/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool'],function(q,l,C,T,H,I){"use strict";var G=C.extend("sap.m.GenericTile",{metadata:{library:"sap.m",properties:{"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:sap.m.FrameType.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:sap.m.LoadState.Loaded},"imageDescription":{type:"string",group:"Misc",defaultValue:null}},aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});G.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._rb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._rb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.37rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.addStyleClass("sapMGenericTileLoading");this._oBusy.setBusyIndicatorDelay(0);};G.prototype.onBeforeRendering=function(){var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()==sap.m.LoadState.Disabled);}this._generateFailedText();};G.prototype.onAfterRendering=function(){this._checkFooter(this.getState());if(this.getState()==sap.m.LoadState.Disabled){this._oBusy.$().bind("tap",q.proxy(this._handleOverlayClick,this));}else{this._oBusy.$().unbind("tap",this._handleOverlayClick);}};G.prototype.exit=function(){this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();};G.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();};G.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE){e.preventDefault();}};G.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};G.prototype._handleOverlayClick=function(e){e.stopPropagation();};G.prototype.ontouchstart=function(e){if(this.getState()!==sap.m.LoadState.Disabled){if(this.getBackgroundImage()){this.addStyleClass("sapMGTBackgroundHvrOutln");}else{this.addStyleClass("sapMGTHvrOutln");}}};G.prototype.ontouchcancel=function(e){if(this.getBackgroundImage()){this.removeStyleClass("sapMGTBackgroundHvrOutln");}else{this.removeStyleClass("sapMGTHvrOutln");}};G.prototype.ontouchend=function(e){if(this.getBackgroundImage()){this.removeStyleClass("sapMGTBackgroundHvrOutln");}else{this.removeStyleClass("sapMGTHvrOutln");}};G.prototype.attachEvent=function(e,d,f,a){C.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")&&this.getState()!=sap.m.LoadState.Disabled){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};G.prototype.detachEvent=function(e,f,a){C.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};G.prototype.getHeader=function(){return this._oTitle.getText();};G.prototype.setHeader=function(t){if(/.*[\u0900-\u097F]+.*/.test(t)){this._oTitle.setMaxLines(1);}else{this._oTitle.setMaxLines(2);}this._oTitle.setText(t);return this;};G.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-icon-image",src:u},sap.m.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};G.prototype.setState=function(s){if(this.getState()!=s){this._checkFooter(s);return this.setProperty("state",s);}else{return this;}};G.prototype.getHeaderAltText=function(){var a="";var i=true;if(this.getHeader()){a+=this.getHeader();i=false;}if(this.getSubheader()){a+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){a+=(i?"":"\n")+this.getImageDescription();}return a;};G.prototype.getBodyAltText=function(){var a="";var b=true;var t=this.getTileContent();var f=this._calculateFrameType(this.getFrameType());var c=0;for(var i=0;i<t.length;i++){if(f>c){if(t[i].getAltText){a+=(b?"":"\n")+t[i].getAltText();b=false;}else if(t[i].getTooltip_AsString()){a+=(b?"":"\n")+t[i].getTooltip_AsString();b=false;}}else{break;}c+=this._calculateFrameType(t[i].getFrameType());}return a;};G.prototype.getAltText=function(){switch(this.getState()){case sap.m.LoadState.Disabled:return"";case sap.m.LoadState.Loading:return this._sLoading;case sap.m.LoadState.Failed:return this._oFailedText.getText();default:return this.getHeaderAltText()+"\n"+this.getBodyAltText();}};G.prototype._checkFooter=function(s){var f=this.$().find(".sapMTileCntFtrTxt");if(s==sap.m.LoadState.Failed&&f.is(":visible")){f.hide();}else if(f.is(":hidden")){f.show();}};G.prototype._calculateFrameType=function(f){if(f==sap.m.FrameType.TwoByOne){return 2;}else{return 1;}};G.prototype._generateFailedText=function(){var c=this.getFailedText();var f=c?c:this._sFailedToLoad;this._oFailedText.setText(f);this._oFailedText.setTooltip(f);};G.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var a="";if(typeof t==="string"||t instanceof String){return t;}a=this.getAltText();return a?a:"";};return G;},true);
