/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Title','./Text','./Button','sap/ui/core/InvisibleText','./Image','./OverflowToolbar','./ToolbarSpacer','sap/ui/core/Icon'],function(q,l,C,L,T,a,B,I,b,O,c,d){'use strict';var N=L.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},description:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance'},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Title',multiple:false,visibility:"hidden"},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"}},events:{close:{}}}});N.prototype.init=function(){this.setType('Active');this._closeButton=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),press:function(){this.close();}.bind(this)});this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();this.setAggregation('_overflowToolbar',new O());};N.prototype.setTitle=function(t){var r=this.setProperty('title',t,true);this._getHeaderTitle().setText(t);return r;};N.prototype.setDescription=function(e){var r=this.setProperty('description',e,true);this._getDescriptionText().setText(e);return r;};N.prototype.setDatetime=function(e){var r=this.setProperty('datetime',e,true);this._getDateTimeText().setText(e);this._updateAriaAdditionalInfo();return r;};N.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation("_headerTitle");if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};N.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};N.prototype.setAuthorName=function(e){var r=this.setProperty('authorName',e,true);this._getAuthorName().setText(e);return r;};N.prototype.setAuthorPicture=function(e,s){var r=this.setProperty('authorPicture',e,s);this._getAuthorImage().setSrc(e);return r;};N.prototype.bindAggregation=function(e,f){if(e=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',f);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,e,f);}};N.prototype.validateAggregation=function(e,o,m){if(e=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,e,o,m);}};N.prototype.setAggregation=function(e,o,s){if(e=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,e,o,s);}};N.prototype.getAggregation=function(e,f){if(e=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(g){return g instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,e,f);}};N.prototype.indexOfAggregation=function(e,o){if(e=='buttons'){this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);return this;}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,e,o);}};N.prototype.insertAggregation=function(e,o,f,s){if(e=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,f,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,f,s);}};N.prototype.addAggregation=function(e,o,s){if(e=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,e,o,s);}};N.prototype.removeAggregation=function(e,o,s){if(e=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,e,o,s);}};N.prototype.removeAllAggregation=function(e,s){if(e=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,e,s);}};N.prototype.destroyAggregation=function(e,s){if(e=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,e,s);}};N.prototype.getBinding=function(e){if(e=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,e);}};N.prototype.getBindingInfo=function(e){if(e=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,e);}};N.prototype.getBindingPath=function(e){if(e=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,e);}};N.prototype.clone=function(){var e=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');e.setAggregation("_overflowToolbar",o.clone(),true);return e;};N.prototype.close=function(){var p=this.getParent();this.fireClose();p&&p instanceof sap.ui.core.Element&&p.focus();this.destroy();};N.prototype.exit=function(){if(this._closeButton){this._closeButton.destroy();this._closeButton=null;}if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle()});this.setAggregation("_headerTitle",t,true);}return t;};N.prototype._getDescriptionText=function(){var e=this.getAggregation('_bodyText');if(!e){e=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription()}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",e,true);}return e;};N.prototype._getDateTimeText=function(){var e=this.getAggregation('_dateTime');if(!e){e=new sap.m.Text({text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',e,true);}return e;};N.prototype._getAuthorName=function(){var e=this.getAggregation('_authorName');if(!e){e=new a({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',e,true);}return e;};N.prototype._getAuthorImage=function(){var e=this.getAggregation('_authorImage');if(!e){var f=this.getAuthorPicture();var g=this.getAuthorName();if(i(f)){e=new d({src:f,alt:g});}else{e=new b({src:f,alt:g});}this.setAggregation('_authorImage',e,true);}return e;};N.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};N.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var e=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var f=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);this._ariaDetailsText.setText(e+' '+f);};function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}return N;},true);
