/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./TimePickerSliderRenderer','sap/ui/core/IconPool'],function(q,C,T,I){"use strict";var a=C.extend("sap.m.TimePickerSlider",{metadata:{library:"sap.m",properties:{selectedValue:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"},_arrowUp:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{expanded:{}}},renderer:T.render});var S=sap.ui.getCore().getConfiguration().getAnimation()?200:0;var M=50;a.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._contentRepeat=null;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._initArrows();};a.prototype.onAfterRendering=function(){if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}this._attachEvents();};a.prototype.onThemeChanged=function(e){this.invalidate();};a.prototype.fireTap=function(e){var s,i,d;if(!this.getIsExpanded()){if(sap.ui.Device.system.desktop){this.focus();}else{this.setIsExpanded(true);}}else{s=e.srcElement||e.originalTarget;if(s.tagName.toLowerCase()==="li"){i=q(s).text();d=F.call(this,i);this._bOneTimeValueSelectionAnimation=true;this.setSelectedValue(d);}else{this._addSelectionStyle();}}};a.prototype.setSelectedValue=function(v){var i=f(this.getItems(),function(E){return E.getKey()===v;}),t=this,d,s,e,g;if(i===-1){return this;}if(this.getDomRef()){s=this._getSliderContainerDomRef();e=this._getItemHeightInPx();g=this._getContentRepeat();if(i*e>=this._selectionOffset){d=this.getItems().length*Math.floor(g/2)+i;}else{d=this.getItems().length*Math.ceil(g/2)+i;}if(this._bOneTimeValueSelectionAnimation){this._animatingSnap=true;s.animate({scrollTop:d*e-this._selectionOffset},S,'linear',function(){s.clearQueue();t._animatingSnap=false;t._bOneTimeValueSelectionAnimation=false;});}else{s.scrollTop(d*e-this._selectionOffset);}this._removeSelectionStyle();this._iSelectedItemIndex=d;this._addSelectionStyle();}return this.setProperty("selectedValue",v,true);};a.prototype.setIsExpanded=function(v,s){this.setProperty("isExpanded",v,true);if(!this.getDomRef()){return this;}var t=this.$();if(v){t.addClass("sapMTPSliderExpanded");if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,function(){this._updateSelectionFrameLayout();if(!s){this.fireExpanded({ctrl:this});}});}else{this._updateSelectionFrameLayout();if(!s){this.fireExpanded({ctrl:this});}}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);this._scrollerSnapped(this._iSelectedIndex);}t.removeClass("sapMTPSliderExpanded");if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}}return this;};a.prototype.onfocusin=function(e){if(sap.ui.Device.system.desktop&&!this.getIsExpanded()){this.setIsExpanded(true);}};a.prototype.onfocusout=function(e){var s=e.relatedTarget?e.relatedTarget.id:null,A=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(s&&A.indexOf(s)!==-1){return;}if(sap.ui.Device.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false);}};a.prototype._onmousewheel=function(e){e.preventDefault();e.stopPropagation();if(!this.getIsExpanded()){return false;}var O=e.originalEvent,d=O.detail?(-O.detail>0):(O.wheelDelta>0),r=d?Math.ceil:Math.floor,w=O.detail?(-O.detail/3):(O.wheelDelta/120),t=this,R;if(!w){return false;}if(!this._aWheelDeltas){this._aWheelDeltas=[];}t._aWheelDeltas.push(w);if(!this._bWheelScrolling){this._bWheelScrolling=true;this._intervalId=setInterval(function(){if(!t._aWheelDeltas.length){clearInterval(t._intervalId);t._bWheelScrolling=false;}else{R=t._aWheelDeltas[0];t._aWheelDeltas=[];R=r(R);if(R){t._offsetSlider(R);}}},150);}return false;};a.prototype.onsappageup=function(e){if(this.getIsExpanded()){var i=this.getItems()[0];this.setSelectedValue(i.getKey());}};a.prototype.onsappagedown=function(e){if(this.getIsExpanded()){var l=this.getItems()[this.getItems().length-1];this.setSelectedValue(l.getKey());}};a.prototype.onsapup=function(e){if(this.getIsExpanded()){this._offsetValue(-1);}};a.prototype.onsapdown=function(e){if(this.getIsExpanded()){this._offsetValue(1);}};a.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMTimePickerSlider");};a.prototype._getContentRepeat=function(){if(!this._contentRepeat){if(this.getIsCyclic()){this._contentRepeat=Math.ceil(M/this.getItems().length);this._contentRepeat=Math.max(this._contentRepeat,3);}else{this._contentRepeat=1;}}return this._contentRepeat;};a.prototype._getItemHeightInPx=function(){return this.$("content").find("li").outerHeight();};a.prototype._updateSelectionFrameLayout=function(){var $,i,t,s;if(this.getDomRef()){$=this.$().find(".sapMTPPickerSelectionFrame");if(sap.ui.Device.system.phone){s=this.$().offset().top;i=(this.$().height()-this._getItemHeightInPx())/2+s;}else{t=this.$().parents(".sapUiSizeCompact").length>0?8:16;i=(this.$().height()-this._getItemHeightInPx())/2+t;}$.css("top",i);if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}}};a.prototype._getSelectionFrameTopOffset=function(){var $=this._getSliderContainerDomRef().find(".sapMTPPickerSelectionFrame"),d=$.offset();return d.top;};a.prototype._animateScroll=function(s){var $=this._getSliderContainerDomRef(),p=$.scrollTop(),d=25,e=$.height(),g=this.$("content").height(),D=200,i=e+D,h=this._getContentRepeat(),j=this.getIsCyclic(),k=0.9,l=0.05,t=this;this._intervalId=setInterval(function(){t._animating=true;p=p-s*d;if(j){p=t._getUpdatedCycleScrollTop(e,g,p,i,h);}else{if(p>t._maxScrollTop){p=t._maxScrollTop;s=0;}if(p<t._minScrollTop){p=t._minScrollTop;s=0;}}$.scrollTop(p);s*=k;if(Math.abs(s)<l){var m=t._getItemHeightInPx();var O=t._selectionOffset?(t._selectionOffset%m):0;var n=Math.round((p+O)/m)*m-O;clearInterval(t._intervalId);t._animating=null;t._iSelectedIndex=Math.round((p+t._selectionOffset)/m);t._animatingSnap=true;$.animate({scrollTop:n},S,'linear',function(){$.clearQueue();t._animatingSnap=false;t._scrollerSnapped(t._iSelectedIndex);});}},d);};a.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._animating=null;}};a.prototype._startDrag=function(p){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[];}this._dragSession.pageY=p;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop();};a.prototype._doDrag=function(p,t){if(this._dragSession){this._dragSession.offsetY=p-this._dragSession.pageY;this._dragSession.positions.push({pageY:p,timeStamp:t});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10);}if(this._bIsDrag){this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY);}}};a.prototype._endDrag=function(p,t){if(this._dragSession){var O,d;for(var i=this._dragSession.positions.length-1;i>=0;i--){O=t-this._dragSession.positions[i].timeStamp;d=p-this._dragSession.positions[i].pageY;if(O>100){break;}}var s=(d/O);if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}this._dragSession=null;this._animateScroll(s);}};a.prototype._afterExpandCollapse=function(){var s=this.getSelectedValue(),d=this._getSelectionFrameTopOffset(),$=this._getSliderContainerDomRef(),e=$.offset(),i,l,L,g;this._selectionOffset=d-e.top;if(!this.getIsCyclic()){l=q("#"+this.getId()+"-content");g=this._getItemHeightInPx();L=this.$().height();if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=d-e.top;this._maxScrollTop=g*(this.getItems().length-1);i=$.height();this._marginBottom=i-this._marginTop-g;if(this._marginBottom<0){this._marginBottom=L-this._marginTop-g;}l.css("margin-top",this._marginTop);l.css("margin-bottom",this._marginBottom);}else{this._marginBottom=L-g;l.css("margin-top",0);l.css("margin-bottom",this._marginBottom);}this._selectionOffset=0;}if(!this.getIsExpanded()){this._selectionOffset=0;}this.setSelectedValue(s);};a.prototype._getUpdatedCycleScrollTop=function(i,d,t,D,e){var g=d-t-i;while(g<D){t=t-d/e;g=d-t-i;}while(t<D){t=t+d/e;}return t;};a.prototype._scrollerSnapped=function(i){var s=i,d=this.getItems().length,n;while(s>=d){s=s-d;}if(!this.getIsCyclic()){s=i;}n=this.getItems()[s].getKey();this.setSelectedValue(n);};a.prototype._updateScroll=function(){var s=this.getSelectedValue();if(s!==this.getItems()[0].getKey()&&this._getSliderContainerDomRef().scrollTop()+(this._selectionOffset?this._selectionOffset:0)===0){this.setSelectedValue(s);}};a.prototype._addSelectionStyle=function(){var $=this.$("content").find("li"),s=$.eq(this._iSelectedItemIndex).text(),A=F.call(this,s);$.eq(this._iSelectedItemIndex).addClass("sapMTimePickerItemSelected").attr("aria-selected","true");document.getElementById(this.getId()+"-valDescription").setAttribute("aria-label",A);};a.prototype._removeSelectionStyle=function(){var $=this.$("content").find("li");$.eq(this._iSelectedItemIndex).removeClass("sapMTimePickerItemSelected").attr("aria-selected","false");};a.prototype._attachEvents=function(){var e=this._getSliderContainerDomRef()[0],d=sap.ui.Device;if(d.support.touch){e.addEventListener("touchstart",q.proxy(o,this),false);e.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);}else{e.addEventListener("mousedown",q.proxy(o,this),false);document.addEventListener("mousemove",q.proxy(b,this),false);document.addEventListener("mouseup",q.proxy(c,this),false);}};a.prototype._detachEvents=function(){var e=this.getDomRef(),d=sap.ui.Device;if(d.support.touch){e.removeEventListener("touchstart",q.proxy(o,this),false);e.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);}else{e.removeEventListener("mousedown",q.proxy(o,this),false);e.removeEventListener("mousemove",q.proxy(b,this),false);document.removeEventListener("mouseup",q.proxy(c,this),false);}};a.prototype._offsetValue=function(i){var s=this._getSliderContainerDomRef(),d=s.scrollTop(),e=this._getItemHeightInPx(),g=d+i*e,h=this.getIsCyclic(),t=this,j=this._iSelectedItemIndex+i;if(!h){if(j<0||j>=this.getItems().length){return;}if(g>this._maxScrollTop){g=this._maxScrollTop;}if(g<this._minScrollTop){g=this._minScrollTop;}}this._animatingSnap=true;s.animate({scrollTop:g},S,'linear',function(){s.clearQueue();t._animatingSnap=false;t._scrollerSnapped(j);});};a.prototype._offsetSlider=function(O){var s=this._getSliderContainerDomRef().scrollTop(),t=this,$=t._getSliderContainerDomRef().height(),d=t.$("content").height(),D=200,i=$+D,e=t._getContentRepeat(),g=t.getIsCyclic(),h=t._getItemHeightInPx();s=s-O*h;if(g){s=t._getUpdatedCycleScrollTop($,d,s,i,e);}else{if(s>t._maxScrollTop){s=t._maxScrollTop;}if(s<t._minScrollTop){s=t._minScrollTop;}}t._getSliderContainerDomRef().scrollTop(s);t._iSelectedIndex=Math.round((s+t._selectionOffset)/h);t._scrollerSnapped(t._iSelectedIndex);};a.prototype._initArrows=function(){var t=this,A,d;A=new sap.m.Button({icon:I.getIconURI("slim-arrow-up"),press:function(e){t._offsetValue(-1);},type:'Transparent'});A.addEventDelegate({onAfterRendering:function(){A.$().attr("tabindex",-1);}});this.setAggregation("_arrowUp",A);d=new sap.m.Button({icon:I.getIconURI("slim-arrow-down"),press:function(e){t._offsetValue(1);},type:'Transparent'});d.addStyleClass("sapMTimePickerItemArrowDown");d.addEventDelegate({onAfterRendering:function(){d.$().attr("tabindex",-1);}});this.setAggregation("_arrowDown",d);};function f(A,p){if(A==null){throw new TypeError('findIndex called with null or undefined array');}if(typeof p!=='function'){throw new TypeError('predicate must be a function');}var l=A.length;var t=arguments[1];var v;for(var i=0;i<l;i++){v=A[i];if(p.call(t,v,i,A)){return i;}}return-1;}var o=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._stopAnimation();this._startDrag(p);e.preventDefault();this._mousedown=true;};var b=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var d=this._dragSession.positions.some(function(g){return Math.abs(g.pageY-p)>5;});if(d){this._bIsDrag=true;}}this._doDrag(p,e.timeStamp);this._mousedown=true;};var c=function(e){var p=e.changedTouches&&e.changedTouches.length?e.changedTouches[0].pageY:e.pageY;if(this._bIsDrag===false){this.fireTap(e);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(p,e.timeStamp);this._mousedown=false;};var F=function(t){var i=this.getItems();var d=f(i,function(e){return e.getText()===t;});return i[d].getKey();};return a;},false);
