/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Object','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager','jquery.sap.act','jquery.sap.dom','jquery.sap.events','jquery.sap.mobile','jquery.sap.properties','jquery.sap.resources','jquery.sap.script'],function(q,D,G,a,E,B,C,c,d,e,g,F,R,h,T,U,M){"use strict";var L={};var _;var k=B.extend("sap.ui.core.Core",{constructor:function(){if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}var t=this,l=q.sap.log,b="sap.ui.core.Core";B.call(this);_=new E();["attachEvent","detachEvent","getEventingParent"].forEach(function(K){k.prototype[K]=_[K].bind(_);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;this.mElements={};this.mObjects={"component":{},"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;l.info("Creating Core",null,b);q.sap.measure.start("coreComplete","Core.js - complete");q.sap.measure.start("coreBoot","Core.js - boot");q.sap.measure.start("coreInit","Core.js - init");this.oConfiguration=new c(this);var f=this.oConfiguration["frameOptionsConfig"]||{};f.mode=this.oConfiguration.getFrameOptions();f.whitelistService=this.oConfiguration.getWhitelistService();this.oFrameOptions=new q.sap.FrameOptions(f);if(this.oConfiguration["bindingSyntax"]==="complex"){sap.ui.base.ManagedObject.bindingParser=sap.ui.base.BindingParser.complexParser;}if(this.oConfiguration["xx-designMode"]==true){sap.ui.base.BindingParser._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=q.inArray("sap.ui.core.library",m);if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&q.inArray("sap.ui.core.plugin.LessSupport",m)==-1){l.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var p=this.oConfiguration.preload;if(window["sap-ui-debug"]){p="";}if(p==="auto"){p=(window["sap-ui-optimized"]&&!this.oConfiguration['xx-loadAllMode'])?"sync":"";}this.oConfiguration.preload=p;l.info("Declared modules: "+m,b);this._setupThemes();this._setupRTL();var $=q("html");this._setupBrowser($);this._setupOS($);this._setupLang($);this._setupAnimation($);this._setupWeinre();sap.ui.getCore=q.sap.getter(this.getInterface());this.oRenderManager=new R();var s=q.sap.syncPoint("UI5 Document Ready",function(O,K){t.handleLoad();});var j=s.startTask("document.ready");var n=s.startTask("preload and boot");q(function(){l.trace("document is ready");s.finishTask(j);});var o=q.sap.syncPoint("UI5 Core Preloads and Bootstrap Script",function(O,K){l.trace("Core loaded: open="+O+", failures="+K);t._boot();s.finishTask(n);q.sap.measure.end("coreBoot");});var u=o.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var v=o.startTask("load version info");var w=function(V){if(V){l.trace("Loaded \"sap-ui-version.json\".");}else{l.error("Could not load \"sap-ui-version.json\".");}o.finishTask(v);};var A=p==="async";var x=sap.ui.getVersionInfo({async:A,failOnError:false});if(x instanceof Promise){x.then(w,function(K){l.error("Unexpected error when loading \"sap-ui-version.json\": "+K);o.finishTask(v);});}else{w(x);}}var y=this.oConfiguration["xx-bootTask"];if(y){var z=o.startTask("custom boot task");y(function(K){o.finishTask(z,typeof K==="undefined"||K===true);});}this._polyfillFlexbox();var H=o.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;o.finishTask(H);};if(p==="sync"||p==="async"){var I=p!=="sync";q.each(m,function(i,K){if(K.match(/\.library$/)){q.sap.preloadModules(K+"-preload",I,o);}});}var J=this.oConfiguration.getAppCacheBuster();if(J&&J.length>0){q.sap.require("sap.ui.core.AppCacheBuster");sap.ui.core.AppCacheBuster.boot(o);}o.finishTask(u);},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId"]}});k.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var S="sap-ui-static";k.prototype._grantFriendAccess=function(){var t=this;g.prototype.register=function(m){t.registerElementClass(m);};e.prototype.register=function(){t.registerElement(this);};e.prototype.deregister=function(){t.deregisterElement(this);};e._updateFocusInfo=function(o){if(t.oFocusHandler){t.oFocusHandler.updateControlFocusInfo(o);}};C.prototype.register=function(){t.registerObject(this);};C.prototype.deregister=function(){var s=this.sId;for(var b in t.mElements){var o=t.mElements[b];if(o._sapui_candidateForDestroy&&o._sOwnerId===s&&!o.getParent()){q.sap.log.debug("destroying dangling template "+o+" when destroying the owner component");o.destroy();}}t.deregisterObject(this);};};k.prototype._setupThemes=function(){var l=q.sap.log,b="sap.ui.core.Core";var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(o){if(o.themeroots){for(var t in o.themeroots){var f=o.themeroots[t];if(typeof f==="string"){this.setThemeRoot(t,f);}else{for(var i in f){if(i.length>0){this.setThemeRoot(t,[i],f[i]);}else{this.setThemeRoot(t,f[i]);}}}}}}this.sTheme=this.oConfiguration.getTheme();q(document.documentElement).addClass("sapUiTheme-"+this.sTheme);l.info("Declared theme "+this.sTheme,null,b);};k.prototype._setupRTL=function(){var l=q.sap.log,b="sap.ui.core.Core";if(this.oConfiguration.getRTL()){q(document.documentElement).attr("dir","rtl");l.info("RTL mode activated",null,b);}};k.prototype._setupBrowser=function($){var l=q.sap.log,f="sap.ui.core.Core";$=$||q("html");var b=D.browser;var i=b.name;if(i===b.BROWSER.CHROME){q.browser.safari=false;q.browser.chrome=true;}else if(i===b.BROWSER.SAFARI){q.browser.safari=true;q.browser.chrome=false;if(b.mobile){i="m"+i;}}if(i){q.browser.fVersion=b.version;q.browser.mobile=b.mobile;i=i+(b.version===-1?"":Math.floor(b.version));$.attr("data-sap-ui-browser",i);l.debug("Browser-Id: "+i,null,f);}};k.prototype._setupOS=function($){$=$||q("html");$.attr("data-sap-ui-os",D.os.name+D.os.versionStr);var o=null;switch(D.os.name){case D.os.OS.IOS:o="sap-ios";break;case D.os.OS.ANDROID:o="sap-android";break;case D.os.OS.BLACKBERRY:o="sap-bb";break;case D.os.OS.WINDOWS_PHONE:o="sap-winphone";break;}if(o){$.addClass(o);}};k.prototype._setupLang=function($){$=$||q("html");var u=function(){var l=this.oConfiguration.getLocale();if(l){$.attr("lang",l.toString());}else{$.removeAttr("lang");}};u.call(this);this.attachLocalizationChanged(u,this);};k.prototype._setupAnimation=function($){$=$||q("html");var A=this.oConfiguration.getAnimation();$.attr("data-sap-ui-animation",A?"on":"off");q.fx.off=!A;};k.prototype._setupWeinre=function(){var l=q.sap.log;if(this.oConfiguration.getWeinreId()){l.info("Starting WEINRE Remote Web Inspector");var w="<script src=\"";w+=this.oConfiguration.getWeinreServer();w+="/target/target-script-min.js#";w+=q.sap.encodeURL(this.oConfiguration.getWeinreId());w+="\"></script>";document.write(w);}};k.prototype._polyfillFlexbox=function(){var u=new q.sap.Version(this.oConfiguration.getCompatibilityVersion("flexBoxPolyfill"));if(u.compareTo("1.16")>=0){q.support.useFlexBoxPolyfill=false;}else if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.support.useFlexBoxPolyfill=true;}else{q.support.useFlexBoxPolyfill=false;}};k.prototype._boot=function(){this.lock();var b=this.oConfiguration['preloadLibCss'];if(b&&b.length>0&&!b.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+b.join(","));}var t=this;q.each(this.oConfiguration.modules,function(i,f){var m=f.match(/^(.*)\.library$/);if(m){t.loadLibrary(m[1]);}else{q.sap.require(f);}});this.unlock();};k.prototype.applyTheme=function(t,s){t=this.oConfiguration._normalizeTheme(t,s);if(s){this.setThemeRoot(t,s);}if(t&&this.sTheme!=t){var b=this.sTheme;this._updateThemeUrls(t);this.sTheme=t;this.oConfiguration._setTheme(t);q(document.documentElement).removeClass("sapUiTheme-"+b).addClass("sapUiTheme-"+t);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false,true);}}};k.prototype._updateThemeUrls=function(t){var b=this,s=this.oConfiguration.getRTL()?"-RTL":"";q("link[id^=sap-ui-theme-]").each(function(){var l=this.id.slice(13),f=this.href.slice(this.href.lastIndexOf("/")+1),i="library",H,p,$=q(this);if((p=l.indexOf("-["))>0){i+=l.slice(p+2,-1);l=l.slice(0,p);}if(f===(i+".css")||f===(i+"-RTL.css")){f=i+s+".css";}if($.attr("data-sap-ui-css-count")){$.remove();}H=b._getThemePath(l,t)+f;if(H!=this.href){this.href=H;$.removeAttr("data-sap-ui-ready");}});};k.prototype._getThemePath=function(l,t){if(this._mThemeRoots){var p=this._mThemeRoots[t+" "+l]||this._mThemeRoots[t];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+t+"/";q.sap.registerModulePath(l+".themes."+t,p);return p;}}return q.sap.getModulePath(l+".themes."+t,"/");};k.prototype.setThemeRoot=function(t,l,s){if(!this._mThemeRoots){this._mThemeRoots={};}if(s===undefined){s=l;l=undefined;}s=s+(s.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var b=l[i];this._mThemeRoots[t+" "+b]=s;}}else{this._mThemeRoots[t]=s;}return this;};k.prototype.init=function(){if(this.bInitialized){return;}var l=q.sap.log,b="sap.ui.core.Core.init()";this.boot();l.info("Initializing",null,b);this.oFocusHandler=new F(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new h(this);this.oThemeCheck=new T(this);l.info("Initialized",null,b);q.sap.measure.end("coreInit");this.bInitialized=true;l.info("Starting Plugins",null,b);this.startPlugins();l.info("Plugins started",null,b);this._createUIAreas();this.oThemeCheck.fireThemeChangedEvent(true);this._executeOnInit();this._setupRootComponent();this._setBodyAccessibilityRole();this._executeInitListeners();this.renderPendingUIUpdates();q.sap.measure.end("coreComplete");};k.prototype._createUIAreas=function(){var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i]);}o.areas=undefined;}};k.prototype._executeOnInit=function(){var o=this.oConfiguration;if(o.onInit){if(typeof o.onInit==="function"){o.onInit();}else{q.sap.globalEval(o.onInit);}o.onInit=undefined;}};k.prototype._setupRootComponent=function(){var l=q.sap.log,b="sap.ui.core.Core.init()",o=this.oConfiguration;var s=o.getRootComponent();if(s){l.info("Loading Root Component: "+s,null,b);var f=sap.ui.component({name:s});this.oRootComponent=f;var i=o["xx-rootComponentNode"];if(i&&f instanceof sap.ui.core.UIComponent){var j=q.sap.domById(i);if(j){l.info("Creating ComponentContainer for Root Component: "+s,null,b);var m=new sap.ui.core.ComponentContainer({component:f,propagateModel:true});m.placeAt(j);}}}else{var A=o.getApplication();if(A){l.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! Please migrate from sap.ui.app.Application to sap.ui.core.Component.");l.info("Loading Application: "+A,null,b);q.sap.require(A);var n=q.sap.getObject(A);var p=new n();}}};k.prototype._setBodyAccessibilityRole=function(){var o=this.oConfiguration;var $=q("body");if(o.getAccessibility()&&o.getAutoAriaBodyRole()&&!$.attr("role")){$.attr("role","application");}};k.prototype._executeInitListeners=function(){var l=q.sap.log,b="sap.ui.core.Core.init()";var j=this.aInitListeners;this.aInitListeners=undefined;if(j&&j.length>0){l.info("Fire Loaded Event",null,b);q.each(j,function(i,f){f();});}};k.prototype.handleLoad=function(){this.bDomReady=true;var w=this.isLocked();if(!w){this.lock();}this.init();if(!w){this.unlock();}};k.prototype.isInitialized=function(){return this.bInitialized;};k.prototype.isThemeApplied=function(){return T.themeLoaded;};k.prototype.attachInitEvent=function(f){if(this.aInitListeners){this.aInitListeners.push(f);}};k.prototype.attachInit=function(f){if(this.aInitListeners){this.aInitListeners.push(f);}else{f();}};k.prototype.lock=function(){this.bLocked=true;};k.prototype.unlock=function(){this.bLocked=false;};k.prototype.isLocked=function(){return this.bLocked;};k.prototype.getConfiguration=function(){return this.oConfiguration;};k.prototype.getRenderManager=function(){return this.createRenderManager();};k.prototype.createRenderManager=function(){var o=new R();o._setFocusHandler(this.oFocusHandler);return o.getInterface();};k.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};k.prototype.loadLibrary=function(l,u){if(!L[l]){var m=l+".library",A;if(u){q.sap.registerModulePath(l,u);}if(this.oConfiguration['xx-loadAllMode']&&!q.sap.isDeclared(m)){A=m+"-all";q.sap.log.debug("load all-in-one file "+A);q.sap.require(A);}else if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){q.sap.preloadModules(m+"-preload",false);}q.sap.require(m);if(!L[l]){q.sap.log.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(true);}}return this.mLibraries[l];};k.prototype.loadLibraries=function(l,o){o=q.extend({async:true},o);var t=this,p=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',A=o.async;function b(s){if(p){q.each(l,function(i,j){q.sap.preloadModules(j+".library-preload",!!s,s);});}}function f(){q.each(l,function(i,s){q.sap.require(s+".library");});if(t.oThemeCheck&&t.isInitialized()){t.oThemeCheck.fireThemeChangedEvent(true);}}if(A&&p){return new Promise(function(i,j){var s=q.sap.syncPoint("Load Libraries",function(O,n){if(!n){f();i();}else{j();}});var m=s.startTask("load libraries");b(s);s.finishTask(m);});}else{b(null);f();}};k.prototype.createComponent=function(v,u,i,s){if(typeof v==="string"){v={name:v,url:u};if(typeof i==="object"){v.settings=i;}else{v.id=i;v.settings=s;}}return sap.ui.component(v);};k.prototype.getRootComponent=function(){return this.oRootComponent;};k.prototype.initLibrary=function(l){var b=typeof l==="string",o=b?{name:l}:l,s=o.name,f=q.sap.log,m="sap.ui.core.Core.initLibrary()";if(b){f.warning("[Deprecated] library "+s+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!s||L[s]){return;}f.debug("Analyzing Library "+s,null,m);L[s]=true;function n(j,I){var K,v;for(K in I){v=I[K];if(v!==undefined){if(q.isArray(j[K])){if(j[K].length===0){j[K]=v;}else{j[K]=q.sap.unique(j[K].concat(v));}}else if(j[K]===undefined){j[K]=v;}else{q.sap.log.warning("library info setting ignored: "+K+"="+v);}}}return j;}q.sap.getObject(s,0);this.mLibraries[s]=o=n(this.mLibraries[s]||{name:s,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},o);function p(){var P=q.sap.properties({url:sap.ui.resource(s,"library.properties")});o.version=P.getProperty(s+"[version]");var v=P.getProperty(s+"[dependencies]");f.debug("Required Libraries: "+v,null,m);o.dependencies=(v&&v.split(/[,;| ]/))||[];var K=P.getKeys(),w=/(.+)\.(type|interface|control|element)$/,x;for(var j=0;j<K.length;j++){var y=P.getProperty(K[j]);if((x=y.match(w))!==null){o[x[2]+"s"].push(K[j]);}}}if(b){p();}for(var i=0;i<o.dependencies.length;i++){var t=o.dependencies[i];f.debug("resolve Dependencies to "+t,null,m);if(!L[t]){f.warning("Dependency from "+s+" to "+t+" has not been resolved by library itself",null,m);this.loadLibrary(t);}}a.registerInterfaceTypes(o.interfaces);for(var i=0;i<o.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(o.types[i])){q.sap.declare(o.types[i]);}}var u=o.controls.concat(o.elements);for(var i=0;i<u.length;i++){sap.ui.lazyRequire(u[i],"new extend getMetadata");}if(!o.noLibraryCSS&&q.inArray(s,this.oConfiguration['preloadLibCss'])<0){var Q=this._getLibraryCssQueryParams(o);this.includeLibraryTheme(s,undefined,Q);}o.sName=o.name;o.aControls=o.controls;if(!q.sap.isDeclared(s+".library")){f.warning("Library Module "+s+".library"+" not loaded automatically",null,m);q.sap.require(s+".library");}this.fireLibraryChanged({name:s,stereotype:"library",operation:"add",metadata:o});};k.prototype.includeLibraryTheme=function(l,v,Q){if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var s=(this.oConfiguration.getRTL()?"-RTL":"");var b,f=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){b="library"+v+s;}else{b=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var i=this._getThemePath(l,this.sTheme)+b+".css"+(Q?Q:"");q.sap.log.info("Including "+i+" -  sap.ui.core.Core.includeLibraryTheme()");q.sap.includeStyleSheet(i,"sap-ui-theme-"+f);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P._addLibraryTheme(f,i);}}};k.prototype._getLibraryCssQueryParams=function(l){var Q;if(this.oConfiguration["versionedLibCss"]&&l){Q="?version="+l.version;if(sap.ui.versioninfo){Q+="&sap-ui-dist-version="+sap.ui.versioninfo.version;}}return Q;};k.prototype.getLoadedLibraries=function(){return q.extend({},this.mLibraries);};k.prototype.getLibraryResourceBundle=function(l,s){l=l||"sap.ui.core";s=s||this.getConfiguration().getLanguage();var K=l+"/"+s;if(!this.mResourceBundles[K]){var u=sap.ui.resource(l,'messagebundle.properties');this.mResourceBundles[K]=q.sap.resources({url:u,locale:s});}return this.mResourceBundles[K];};k.prototype.setRoot=function(o,b){if(b){b.placeAt(o,"only");}};k.prototype.createUIArea=function(o){var t=this;if(!o){throw new Error("oDomRef must not be null");}if(typeof(o)==="string"){var i=o;if(i==S){o=this.getStaticAreaRef();}else{o=q.sap.domById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!o.id||o.id.length==0){o.id=q.sap.uid();}var I=o.id;if(!this.mUIAreas[I]){this.mUIAreas[I]=new U(this,o);q.each(this.oModels,function(n,m){t.mUIAreas[I].oPropagatedProperties.oModels[n]=m;});this.mUIAreas[I].propagateProperties(true);}else{this.mUIAreas[I].setRootNode(o);}return this.mUIAreas[I];};k.prototype.getUIArea=function(o){var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};var r=U._oRenderLog;k.prototype.addInvalidatedUIArea=function(u){if(!this._sRerenderTimer){r.debug("Registering timer for delayed re-rendering");this._sRerenderTimer=q.sap.delayedCall(0,this,"renderPendingUIUpdates");}};k.MAX_RENDERING_ITERATIONS=20;k.prototype.renderPendingUIUpdates=function(){r.debug("Render pending UI updates: start");q.sap.measure.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var u=false,l=k.MAX_RENDERING_ITERATIONS>0,i=0;this._bRendering=true;do{if(l){i++;if(i>k.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+i+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(i>1){r.debug("Render pending UI updates: iteration "+i);}}if(this._sRerenderTimer){q.sap.clearDelayedCall(this._sRerenderTimer);this._sRerenderTimer=undefined;}var m=this.mUIAreas;for(var I in m){u=m[I].rerender()||u;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(u){this.fireUIUpdated();}r.debug("Render pending UI updates: finished");q.sap.measure.end("renderPendingUIUpdates");};k.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};k.prototype.attachUIUpdated=function(f,l){_.attachEvent(k.M_EVENTS.UIUpdated,f,l);};k.prototype.detachUIUpdated=function(f,l){_.detachEvent(k.M_EVENTS.UIUpdated,f,l);};k.prototype.fireUIUpdated=function(p){_.fireEvent(k.M_EVENTS.UIUpdated,p);};k.prototype.attachThemeChanged=function(f,l){_.attachEvent(k.M_EVENTS.ThemeChanged,f,l);};k.prototype.detachThemeChanged=function(f,l){_.detachEvent(k.M_EVENTS.ThemeChanged,f,l);};k.prototype.fireThemeChanged=function(p){q.sap.scrollbarSize(true);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P.reset(true);}var s=k.M_EVENTS.ThemeChanged;var o=q.Event(s);o.theme=p?p.theme:null;q.each(this.mElements,function(i,b){b._handleEvent(o);});q.sap.act.refresh();_.fireEvent(s,p);};k.prototype.attachLocalizationChanged=function(f,l){_.attachEvent(k.M_EVENTS.LocalizationChanged,f,l);};k.prototype.detachLocalizationChanged=function(f,l){_.detachEvent(k.M_EVENTS.LocalizationChanged,f,l);};k.prototype.fireLocalizationChanged=function(m){var s=k.M_EVENTS.LocalizationChanged,b=q.Event(s,{changes:m}),A=sap.ui.base.ManagedObject._handleLocalizationChange,f=[];q.each(m,function(i,v){f.push(i);});q.sap.log.info("localization settings changed: "+f.join(","),null,"sap.ui.core.Core");q.each(this.oModels,function(N,o){if(o&&o._handleLocalizationChange){o._handleLocalizationChange();}});function n(p){q.each(this.mUIAreas,function(){A.call(this,p);});q.each(this.mObjects["component"],function(){A.call(this,p);});q.each(this.mElements,function(){A.call(this,p);});}n.call(this,1);n.call(this,2);if(m.rtl!=undefined){q(document.documentElement).attr("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);q.each(this.mUIAreas,function(){this.invalidate();});q.sap.log.info("RTL mode "+m.rtl?"activated":"deactivated");}q.each(this.mElements,function(i,o){this._handleEvent(b);});_.fireEvent(s,{changes:m});};k.prototype.attachLibraryChanged=function(f,l){_.attachEvent(k.M_EVENTS.LibraryChanged,f,l);};k.prototype.detachLibraryChanged=function(f,l){_.detachEvent(k.M_EVENTS.LibraryChanged,f,l);};k.prototype.fireLibraryChanged=function(p){_.fireEvent(k.M_EVENTS.LibraryChanged,p);};k.prototype.applyChanges=function(){this.renderPendingUIUpdates();};k.prototype.registerElementClass=function(m){var n=m.getName(),l=m.getLibraryName()||"",o=this.mLibraries[l],s=d.prototype.isPrototypeOf(m.getClass().prototype)?'controls':'elements';if(!o){q.sap.getObject(l,0);o=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(q.inArray(n,o[s])<0){o[s].push(n);q.sap.log.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};k.prototype.registerElement=function(o){var b=this.byId(o.getId());if(b&&b!==o){if(b._sapui_candidateForDestroy){q.sap.log.debug("destroying dangling template "+b+" when creating new object with same ID");b.destroy();b=null;}}if(b&&b!==o){if(this.oConfiguration.getNoDuplicateIds()){q.sap.log.error("adding element with duplicate id '"+o.getId()+"'");throw new Error("Error: adding element with duplicate id '"+o.getId()+"'");}else{q.sap.log.warning("adding element with duplicate id '"+o.getId()+"'");}}this.mElements[o.getId()]=o;};k.prototype.deregisterElement=function(o){delete this.mElements[o.getId()];};k.prototype.registerObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype(),b=this.getObject(t,i);if(b&&b!==o){q.sap.log.error("adding object \""+t+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+t+"\" with duplicate id '"+i+"'");}this.mObjects[t][i]=o;};k.prototype.deregisterObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype();delete this.mObjects[t][i];};k.prototype.byId=function(i){return i==null?undefined:this.mElements[i];};k.prototype.getControl=k.prototype.byId;k.prototype.getElementById=k.prototype.byId;k.prototype.getObject=function(t,i){return i==null?undefined:this.mObjects[t]&&this.mObjects[t][i];};k.prototype.getComponent=function(i){return this.getObject("component",i);};k.prototype.getTemplate=function(i){q.sap.require("sap.ui.core.tmpl.Template");return sap.ui.core.tmpl.Template.byId(i);};k.prototype.getStaticAreaRef=function(){var s=q.sap.domById(S);if(!s){if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}var A={id:S};if(q("body").attr("role")!="application"){A.role="application";}var l=this.getConfiguration().getRTL()?"right":"left";s=q("<DIV/>",A).css({"height":"0","width":"0","overflow":"hidden","float":l}).prependTo(document.body)[0];this.createUIArea(s).bInitial=false;}return s;};k.prototype.isStaticAreaRef=function(o){return o&&(o.id===S);};k._I_INTERVAL=200;h.prototype.I_INTERVAL=k._I_INTERVAL;k.prototype.attachIntervalTimer=function(f,l){if(!this.oTimedTrigger){q.sap.require("sap.ui.core.IntervalTrigger");this.oTimedTrigger=new sap.ui.core.IntervalTrigger(k._I_INTERVAL);}this.oTimedTrigger.addListener(f,l);};k.prototype.detachIntervalTimer=function(f,l){if(this.oTimedTrigger){this.oTimedTrigger.removeListener(f,l);}};k.prototype.attachControlEvent=function(f,l){_.attachEvent(k.M_EVENTS.ControlEvent,f,l);};k.prototype.detachControlEvent=function(f,l){_.detachEvent(k.M_EVENTS.ControlEvent,f,l);};k.prototype.fireControlEvent=function(p){_.fireEvent(k.M_EVENTS.ControlEvent,p);};k.prototype._handleControlEvent=function(o,u){var b=q.Event(o.type);q.extend(b,o);b.originalEvent=undefined;this.fireControlEvent({"browserEvent":b,"uiArea":u});};k.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};k.prototype.registerPlugin=function(p){if(!p){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return;}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this);}};k.prototype.unregisterPlugin=function(p){if(!p){return;}var P=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){P=i;break;}}if(P==-1){return;}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this);}this.aPlugins.splice(P,1);};k.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true);}}};k.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this);}}};k.prototype.setModel=function(m,n){if(!m&&this.oModels[n]){delete this.oModels[n];q.each(this.mUIAreas,function(i,u){delete u.oPropagatedProperties.oModels[n];u.propagateProperties(n);});}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;q.each(this.mUIAreas,function(i,u){u.oPropagatedProperties.oModels[n]=m;u.propagateProperties(n);});}return this;};k.prototype.setMessageManager=function(m){this.oMessageManager=m;};k.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new M();}return this.oMessageManager;};k.prototype.byFieldGroupId=function(f){var b=[];for(var n in this.mElements){var o=this.mElements[n];if(o instanceof d&&o.checkFieldGroupIds(f)){b.push(o);}}return b;};k.prototype.getModel=function(n){return this.oModels[n];};k.prototype.hasModel=function(){return!q.isEmptyObject(this.oModels);};k.prototype.getEventBus=function(){if(!this.oEventBus){q.sap.require("sap.ui.core.EventBus");this.oEventBus=new sap.ui.core.EventBus();}return this.oEventBus;};k.prototype.attachValidationError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(k.M_EVENTS.ValidationError,o,f,l);return this;};k.prototype.detachValidationError=function(f,l){_.detachEvent(k.M_EVENTS.ValidationError,f,l);return this;};k.prototype.attachParseError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(k.M_EVENTS.ParseError,o,f,l);return this;};k.prototype.detachParseError=function(f,l){_.detachEvent(k.M_EVENTS.ParseError,f,l);return this;};k.prototype.attachFormatError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(k.M_EVENTS.FormatError,o,f,l);return this;};k.prototype.detachFormatError=function(f,l){_.detachEvent(k.M_EVENTS.FormatError,f,l);return this;};k.prototype.attachValidationSuccess=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(k.M_EVENTS.ValidationSuccess,o,f,l);return this;};k.prototype.detachValidationSuccess=function(f,l){_.detachEvent(k.M_EVENTS.ValidationSuccess,f,l);return this;};k.prototype.fireParseError=function(A){_.fireEvent(k.M_EVENTS.ParseError,A);return this;};k.prototype.fireValidationError=function(A){_.fireEvent(k.M_EVENTS.ValidationError,A);return this;};k.prototype.fireFormatError=function(A){_.fireEvent(k.M_EVENTS.FormatError,A);return this;};k.prototype.fireValidationSuccess=function(A){_.fireEvent(k.M_EVENTS.ValidationSuccess,A);return this;};k.prototype.isMobile=function(){return D.browser.mobile;};k.prototype._getEventProvider=function(){return _;};k.prototype.destroy=function(){this.oFocusHandler.destroy();_.destroy();B.prototype.destroy.call(this);};sap.ui.setRoot=function(o,b){sap.ui.getCore().setRoot(o,b);};return new k().getInterface();});
