/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,J){"use strict";var e=P.extend("sap.m.P13nDimMeasurePanel",{metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1},chartTypeKey:{type:"string",defaultValue:""}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}});e.prototype.init=function(){var t=this;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;this._oTableModel=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],indexOfMarkedTableItem:-1,markedTableItem:null,isMoveDownButtonEnabled:false,isMoveUpButtonEnabled:false,selectedItemsSwitchedOn:false,isSearchFilterActive:false,countOfSelectedItems:0});this._oTableModel.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);this.setType(sap.m.P13nPanelType.dimeasure);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var p=null,$=null,f,h;p=t.getParent();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&t._oToolbar.$().length>0){i=s.$()[0].clientHeight;f=$.children()[0].clientHeight;h=t._oToolbar?t._oToolbar.$()[0].clientHeight:0;a=f-h;if(i!==a){s.setHeight(a+'px');b=true;}}}}return b;};this.addAggregation("content",s);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};e.prototype._moveMarkedTableItem=function(D){var o=this._oTableModel.getData();if(!o.markedTableItem||o.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(o.markedTableItem)<0){return;}var f=function(){switch(D){case"Down":return o.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return o.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[o.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);}};e.prototype._switchSelectedItems=function(){var D=this._oTableModel.getData();D.selectedItemsSwitchedOn=!D.selectedItemsSwitchedOn;this._changeEnableProperty4SelectAll();this._switchVisibilityOfTableItems(D.selectedItemsSwitchedOn);if(D.markedTableItem&&D.markedTableItem.getVisible()===false){this._deactivateSelectedItem();}this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();this._fnHandleResize();};e.prototype._filterItems=function(){var D=this._oTableModel.getData();var s=null,t=null;var L=0,a=0,i=0,j=0;var I=null,o=null;var b,f;var g=null,h=null,r=null;var E=function(k){if(k){return k.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');}};if(D.selectedItemsSwitchedOn){s=this._oTable.getSelectedItems();}else{s=this._oTable.getItems();}if(D.isSearchFilterActive){h=this._oSearchField.getValue();if(h){h=h.replace(/(^\s+)|(\s+$)/g,'');}if(h!==null&&h!==undefined){h=E(h);h=r=new RegExp(h,'igm');}}t=this._oTable.getItems();L=t.length;for(i=0;i<L;i++){I=t[i];b=true;f=false;if(D.isSearchFilterActive){b=false;g=I.getCells()[0].getText();if(g&&r!==null&&g.match(r)!==null){b=true;}if(I.getCells()[1]&&I.getCells()[1].getText){g=I.getCells()[1].getText();if(g&&r!==null&&g.match(r)!==null){b=true;}}if(b!==true&&I.getTooltip_Text){g=(I.getTooltip()instanceof sap.ui.core.TooltipBase?I.getTooltip().getTooltip_Text():I.getTooltip_Text());if(g&&r!==null&&g.match(r)!==null){b=true;}}}a=s.length;for(j=0;j<a;j++){o=s[j];if(o){if(o.getId()==I.getId()){f=true;break;}}}I.setVisible(f&&b);}};e.prototype._changeEnableProperty4SelectAll=function(){var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!this._oTableModel.getData().isSearchFilterActive&&!this._oTableModel.getData().selectedItemsSwitchedOn);}};e.prototype._executeSearch=function(){var D=this._oTableModel.getData();var L=this._oSearchField.getValue().length||0;D.isSearchFilterActive=L>0?true:false;this._changeEnableProperty4SelectAll();this._filterItems();if(D.markedTableItem&&D.markedTableItem.getVisible()===false){this._deactivateSelectedItem();}this._updateControlLogic();this._scrollToSelectedItem(D.markedTableItem);};e.prototype._tableItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));};e.prototype._deactivateSelectedItem=function(){this._switchMarkedTableItemTo(null);};e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};e.prototype.onBeforeRendering=function(){this.getColumnsItems().forEach(function(o){this._applyColumnsItem(o);},this);};e.prototype.onAfterRendering=function(){var t=this,L=0;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(L);L=window.setTimeout(function(){t._fnHandleResize();t._oToolbar._resetAndInvalidateToolbar();},0);}};e.prototype.onBeforeNavigationFrom=function(){var r=true;var s=this._oTable.getSelectedItems();var v=this.getVisibleItemsThreshold();if(s&&v!==-1&&s.length>v){r=false;}return r;};e.prototype.getOkPayload=function(){var D=this._oTableModel.getData();var b=this.getChartTypeKey()!==D.selectedChartTypeKey;if(b){this.setChartTypeKey(D.selectedChartTypeKey);}var a=this._syncModel2ColumnsItems();return{columnsItems:this.getColumnsItems(),chartTypeChanged:b,columnsItemsChanged:a};};e.prototype._syncModel2ColumnsItems=function(){var b=false;var D=this._oTableModel.getData();D.items.forEach(function(m){var o=this._getColumnsItemByColumnKey(m.columnKey);if(o){if(o&&o.getVisible()&&!m.persistentSelected){this.removeAggregation("columnsItems",o,true);m.persistentIndex=-1;m.persistentSelected=undefined;m.role=undefined;b=true;return;}}else{if(m.persistentSelected){o=new sap.m.P13nColumnsItem({columnKey:m.columnKey,visible:m.persistentSelected});this.addAggregation("columnsItems",o,true);b=true;}else{return;}}if(m.persistentIndex>-1&&m.persistentIndex!==o.getIndex()){o.setIndex(m.persistentIndex);b=true;}if(m.role!==undefined&&m.role!==o.getRole()){o.setRole(m.role);b=true;}this._reindexModelItemsByPersistentIndex(this._oTableModel.getData().items);},this);this._oTableModel.refresh();return b;};e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._oToolbar.destroy();this._oToolbar=null;this._oTable.destroy();this._oTable=null;if(this._oTableModel){this._oTableModel.destroy();this._oTableModel=null;}};e.prototype.setChartTypeKey=function(s){this.setProperty("chartTypeKey",s);this._oTableModel.getData().selectedChartTypeKey=s;this._oTableModel.refresh();return this;};e.prototype.addAvailableChartType=function(i){this.addAggregation("availableChartTypes",i);this._oTableModel.getData().availableChartTypes.push({key:i.getKey(),text:i.getText()});this._oTableModel.refresh();return this;};e.prototype.insertAvailableChartType=function(i,I){this.insertAggregation("availableChartTypes",i,I);this._oTableModel.getData().availableChartTypes.splice(I,0,{key:i.getKey(),text:i.getText()});this._oTableModel.refresh();return this;};e.prototype.removeAvailableChartType=function(i){var I=this.indexOfAvailableChartTypes(i);if(I>-1){this._oTableModel.getData().availableChartTypes.splice(I,1);this._oTableModel.refresh();}i=this.removeAggregation("availableChartTypes",i);return i;};e.prototype.removeAllAvailableChartType=function(){var i=this.removeAllAggregation("availableChartTypes");this._oTableModel.getData().availableChartTypes=[];this._oTableModel.refresh();return i;};e.prototype.destroyAvailableChartType=function(){this.destroyAggregation("availableChartTypes");this._oTableModel.getData().availableChartTypes=[];this._oTableModel.refresh();return this;};e.prototype.addItem=function(i){this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();return this;};e.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();return this;};e.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){this._oTableModel.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();}i=this.removeAggregation("items",i);return i;};e.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this._oTableModel.getData().items=[];this._oTableModel.refresh();return i;};e.prototype.destroyItems=function(){this.destroyAggregation("items");this._oTableModel.getData().items=[];this._oTableModel.refresh();return this;};e.prototype.addColumnsItem=function(o){this.addAggregation("columnsItems",o);this._applyColumnsItem(o);return this;};e.prototype.insertColumnsItem=function(o,i){this.insertAggregation("columnsItems",o,i);this._applyColumnsItem(o);return this;};e.prototype.removeColumnsItem=function(o){o=this.removeAggregation("columnsItems",o);var m=this._getModelItemByColumnKey(o.getColumnKey());if(!m){return;}m.persistentIndex=-1;m.persistentSelected=undefined;m.role=undefined;this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();return o;};e.prototype.removeAllColumnsItems=function(){this.getColumnsItems().forEach(function(o){var m=this._getModelItemByColumnKey(o.getColumnKey());if(!m){return;}m.persistentIndex=-1;m.persistentSelected=undefined;m.role=undefined;},this);this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();var a=this.removeAllAggregation("columnsItems");return a;};e.prototype.destroyColumnsItems=function(){this.getColumnsItems().forEach(function(o){var m=this._getModelItemByColumnKey(o.getColumnKey());if(!m){return;}m.persistentIndex=-1;m.persistentSelected=undefined;m.role=undefined;},this);this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();this.destroyAggregation("columnsItems");return this;};e.prototype._includeModelItem=function(i,I){if(I<0){I=this._oTable.getItems().length;}var t=this;var g=function(){if(i.getAggregationRole()==="Dimension"){return[{key:"category",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"series",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_SERIES')}];}if(i.getAggregationRole()==="Measure"){return[{key:"axis1",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS2')}];}return[];};var m={columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),aggregationRole:i.getAggregationRole(),availableRoleTypes:g(),persistentIndex:-1,persistentSelected:undefined,role:undefined,tableIndex:undefined};this._oTableModel.getData().items.splice(I,0,m);this._oTableModel.refresh();};e.prototype._applyColumnsItem=function(o){var m=this._getModelItemByColumnKey(o.getColumnKey());if(!m||m.persistentIndex===o.getIndex()&&m.persistentSelected===o.getVisible()){return;}m.persistentIndex=o.getIndex();m.persistentSelected=o.getVisible();m.role=o.getRole();m.tableIndex=o.getIndex();this._sortModelItemsByPersistentIndex(this._oTableModel.getData().items);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();};e.prototype._onTableItemSelectionChange=function(E){this._reindexModelItemsByPersistentIndex(this._oTableModel.getData().items);this._oTableModel.refresh();};e.prototype._determinePersistentIndex=function(s){var m=q.extend(true,[],this._oTableModel.getData().items);var M=m[this._getModelItemIndexByColumnKey(s)];this._reindexModelItemsByPersistentIndex(m);return M.persistentIndex;};e.prototype._getColumnsItemByColumnKey=function(s){for(var i=0,a=this.getColumnsItems(),b=a.length;i<b;i++){if(a[i].getColumnKey()===s){return a[i];}}return null;};e.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this._oTableModel.getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};e.prototype._getModelItemByColumnKey=function(s){var m=null;this._oTableModel.getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};e.prototype._moveModelItems=function(i,I){var D=this._oTableModel.getData();if(i<0||I<0||i>D.items.length-1||I>D.items.length-1){return false;}var m=D.items.splice(i,1);D.items.splice(I,0,m[0]);this._reindexModelItemsByPersistentIndexAndTableIndex(this._oTableModel.getData().items);this._oTableModel.refresh();return true;};e.prototype._switchVisibilityOfTableItems=function(s){this._oTableModel.getData().items.forEach(function(m){if(!m.persistentSelected){m.visible=!s;}});this._oTableModel.refresh();};e.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};e.prototype._getVisibleModelItems=function(){var v=[];this._oTableModel.getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};e.prototype._getModelItemByTableItem=function(t){var i=this._getVisibleTableItems().indexOf(t);return this._getVisibleModelItems()[i];};e.prototype._reindexModelItemsByPersistentIndexAndTableIndex=function(m){var p=-1;m.forEach(function(M,t){if(M.persistentSelected){p++;M.persistentIndex=p;}M.tableIndex=t;},this);this._oTableModel.getData().countOfSelectedItems=p+1;};e.prototype._reindexModelItemsByPersistentIndex=function(m){var p=-1;m.forEach(function(M){if(M.persistentSelected){p++;M.persistentIndex=p;}},this);this._oTableModel.getData().countOfSelectedItems=p+1;};e.prototype._reindexModelItemsByTableIndex=function(m){m.forEach(function(M,t){M.tableIndex=t;},this);};e.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex<b.persistentIndex){return-1;}else if(a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};e.prototype._switchMarkedTableItemTo=function(t){var D=this._oTableModel.getData();if(D.markedTableItem===t){return;}if(D.markedTableItem){D.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}D.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);D.markedTableItem=t;if(D.markedTableItem){D.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._updateControlLogic();};e.prototype._createTable=function(){var t=this;this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._tableItemPressed,this),selectionChange:q.proxy(this._onTableItemSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{path:'/countOfSelectedItems',formatter:function(i){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,t._oTable.getItems().length]);}}})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(m){if(m.aggregationRole==="Dimension"){return t._oRb.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(m.aggregationRole==="Measure"){return t._oRb.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(i,b){var a=b.getObject();return new sap.ui.core.Item({key:a.key,text:a.text});}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this._oTableModel);};e.prototype._createToolbar=function(){var t=this;var m=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Down");},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});m.setModel(this._oTableModel);var M=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Bottom");},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});M.setModel(this._oTableModel);var o=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Up");},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});o.setModel(this._oTableModel);var a=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Top");},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});a.setModel(this._oTableModel);var s=new sap.m.Button({text:{path:'/selectedItemsSwitchedOn',formatter:function(b){return b?t._oRb.getText('COLUMNSPANEL_SHOW_ALL'):t._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}},press:q.proxy(this._switchSelectedItems,this),layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});s.setModel(this._oTableModel);this._oChartTypeComboBox=new sap.m.ComboBox({selectedKey:{path:'/selectedChartTypeKey'},items:{path:'/availableChartTypes',template:new sap.ui.core.Item({key:"{key}",text:"{text}"})}});this._oChartTypeComboBox.setModel(this._oTableModel);var L=0;this._oSearchField=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(L);if(D){L=window.setTimeout(function(){t._executeSearch();},D);}else{t._executeSearch();}},search:q.proxy(this._executeSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({"minWidth":"12.5rem","maxWidth":"23.077rem","shrinkable":true,"moveToOverflow":false,"stayInOverflow":false})});this._oToolbar=new sap.m.OverflowToolbar({active:true,design:sap.m.ToolbarDesign.Solid,content:[this._oChartTypeComboBox,new sap.m.ToolbarSpacer(),this._oSearchField,s,a,o,m,M]});this.addAggregation("content",this._oToolbar);};e.prototype._updateControlLogic=function(){var D=this._oTableModel.getData();var L=this._getVisibleTableItems().length;D.isMoveUpButtonEnabled=D.indexOfMarkedTableItem>0&&D.isSearchFilterActive===false;D.isMoveDownButtonEnabled=D.indexOfMarkedTableItem<L-1&&D.indexOfMarkedTableItem>-1&&D.isSearchFilterActive===false;this._oTableModel.refresh();};e.prototype._showAll=function(){q.sap.log.info("ModelItems: table persistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var D=this._oTableModel.getData();var t=this._oTable.getItems();var L=Math.max(D.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=D.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.tableIndex+" "+m.persistentSelected+"_"+m.persistentIndex+";    "+o.getId()+" "+o.getCells()[0].getText()+": "+o.getSelected()+" "+o.getCells()[1].getText());}};return e;},true);
