/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";var V=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{}}}});V.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';};V.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;if(this._bAppendedToUIArea){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(this,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}};V.prototype.addCustomTab=function(c){var i=c.getId();if(i==='sort'||i==='filter'||i==='group'){throw'Id "'+i+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',c);return this;};V.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}else{C.prototype.invalidate.apply(this,arguments);}};V.prototype.addStyleClass=function(){var d=this._getDialog();d.addStyleClass.apply(d,arguments);return this;};V.prototype.removeStyleClass=function(){var d=this._getDialog();d.removeStyleClass.apply(d,arguments);return this;};V.prototype.toggleStyleClass=function(){var d=this._getDialog();d.toggleStyleClass.apply(d,arguments);return this;};V.prototype.hasStyleClass=function(){var d=this._getDialog();return d.hasStyleClass.apply(d,arguments);};V.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};V.prototype.setTitle=function(t){this._getTitleLabel().setText(t);this.setProperty("title",t,true);return this;};V.prototype.addAggregation=function(A,o,s){sap.ui.base.ManagedObject.prototype.addAggregation.apply(this,arguments);if(A!=='sortItems'&&A!=='groupItems'&&A!=='filterItems'){return this;}var t=A.replace('Items','');t=t.charAt(0).toUpperCase()+t.slice(1);o.attachEvent('itemPropertyChanged',function(A,e){if(A==='filterItems'&&e.getParameter('changedItem').getMetadata().getName()==='sap.m.ViewSettingsItem'){if(e.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var i=this._filterDetailList.getItems();i.forEach(function(c){if(c.data('item').getId()===e.getParameter('changedItem').getId()){c.setSelected(e.getParameter('propertyValue'));}});}}}else{if(typeof this['_init'+t+'Content']==='function'){this['_init'+t+'Content']();}if(typeof this['_init'+t+'Items']==='function'){this['_init'+t+'Items']();}}}.bind(this,A));o.attachEvent('filterDetailItemsAggregationChange',function(e){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));};V.prototype._setFilterDetailTitle=function(i){this._getDetailTitleLabel().setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText());};V.prototype.updateAggregation=function(A){sap.ui.base.ManagedObject.prototype.updateAggregation.apply(this,arguments);if(A!=='sortItems'&&A!=='groupItems'&&A!=='filterItems'){return this;}var t=A.replace('Items','');t=t.charAt(0).toUpperCase()+t.slice(1);if(typeof this['_init'+t+'Content']==='function'){this['_init'+t+'Content']();}if(typeof this['_init'+t+'Items']==='function'){this['_init'+t+'Items']();}};V.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};V.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};V.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};V.prototype.setSelectedSortItem=function(c){var d=this.getSortItems(),i=0,o=f(c,d,"Could not set selected sort item. Item is not found: '"+c+"'");if(v(o)){for(i=0;i<d.length;i++){if(d[i].getId()!==o.getId()){d[i].setProperty('selected',false,true);}}if(o.getProperty('selected')!==true){o.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,o);}this.setAssociation("selectedSortItem",o,true);}return this;};V.prototype.setSelectedGroupItem=function(c){var d=this.getGroupItems(),i=0,o=f(c,d,"Could not set selected group item. Item is not found: '"+c+"'");if(v(o)){for(i=0;i<d.length;i++){d[i].setProperty('selected',false,true);}o.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,o);}this.setAssociation("selectedGroupItem",o,true);}return this;};V.prototype.setSelectedPresetFilterItem=function(c){var d=this.getPresetFilterItems(),i=0,o=f(c,d,"Could not set selected preset filter item. Item is not found: '"+c+"'");if(v(o)){for(i=0;i<d.length;i++){d[i].setProperty('selected',false,true);}o.setProperty('selected',true,true);this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",o,true);}return this;};V.prototype.open=function(p){if(!this.getParent()&&!this._bAppendedToUIArea){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}if(p&&this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),"to",[this._getPage1().getId(),"show"]);}this._initDialogContent(p);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(sap.ui.Device.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var c=this._getNavContainer().getCurrentPage(),$;if(c){$=c.$("cont").firstFocusableDomRef();if($){if(q($).hasClass('sapMListUl')){var d=q($).find('.sapMLIB');d.length&&d[0].focus();return;}$.focus();}}},this);}this._getDialog().open();return this;};V.prototype.getSelectedFilterItems=function(){var s=[],F=this.getFilterItems(),S,m=true,i=0,j;for(;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getSelected()){s.push(F[i]);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){S=F[i].getItems();m=F[i].getMultiSelect();for(j=0;j<S.length;j++){if(S[j].getSelected()){s.push(S[j]);if(!m){break;}}}}}return s;};V.prototype.getSelectedFilterString=function(){var F="",s,p=this.getSelectedPresetFilterItem(),c=this.getFilterItems(),S,m=true,i=0,j;if(p){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(p).getText());}else{for(;i<c.length;i++){if(c[i]instanceof sap.m.ViewSettingsCustomItem){if(c[i].getSelected()){F+=c[i].getText()+", ";}}else if(c[i]instanceof sap.m.ViewSettingsFilterItem){S=c[i].getItems();m=c[i].getMultiSelect();s="";for(j=0;j<S.length;j++){if(S[j].getSelected()){s+=S[j].getText()+", ";if(!m){break;}}}s=s.substring(0,s.length-2);if(s){s=" ("+s+")";F+=c[i].getText()+s+", ";}}}F=F.substring(0,F.length-2);if(F){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+F);}}return F;};V.prototype.getSelectedFilterKeys=function(){var s={},S=this.getSelectedFilterItems(),i=0;for(;i<S.length;i++){s[S[i].getKey()]=S[i].getSelected();}return s;};V.prototype.setSelectedFilterKeys=function(s){var K="",F=this.getFilterItems(),S={},o,m,i,j,k;if(Object.keys(s).length){this._clearPresetFilter();}for(K in s){o=null;if(s.hasOwnProperty(K)){for(i=0;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getKey()===K){o=F[i];F[i].setProperty('selected',s[K],true);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){S=F[i].getItems();m=F[i].getMultiSelect();for(j=0;j<S.length;j++){if(S[j].getKey()===K){o=S[j];if(!m){for(k=0;k<S.length;k++){S[k].setProperty('selected',false,true);}}break;}}}if(o){break;}}if(o===null){q.sap.log.warning('Cannot set state for key "'+K+'" because there is no filter with these keys');continue;}o.setProperty('selected',s[K],true);}}return this;};V.prototype._getDialog=function(){var t=this;if(this._dialog===undefined){this._dialog=new sap.m.Dialog(this.getId()+"-dialog",{showHeader:false,stretch:sap.ui.Device.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),beginButton:new sap.m.Button({text:this._rb.getText("VIEWSETTINGS_ACCEPT")}).attachPress(this._onConfirm,this),endButton:new sap.m.Button({text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");var d=this._dialog.onsapescape;this._dialog.onsapescape=function(e){if(d){d.call(t._dialog,e);}t._onCancel();};this._dialog.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){t._pressBackButton();}};}return this._dialog;};V.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new sap.m.NavContainer(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};V.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new sap.m.Label(this.getId()+"-title",{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};V.prototype._getResetButton=function(){var t=this;if(this._resetButton===undefined){this._resetButton=new sap.m.Button(this.getId()+"-resetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});}return this._resetButton;};V.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new sap.m.Label(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};V.prototype._getHeader=function(){if(this._header===undefined){this._header=new sap.m.Bar({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};V.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new sap.m.Bar({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};V.prototype._getSegmentedButton=function(){var t=this,c=this.getCustomTabs(),d=c.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new sap.m.SegmentedButton({select:function(e){var s=e.getParameter('id');if(s===t.getId()+"-sortbutton"){t._switchToPage(0);}else if(s===t.getId()+"-groupbutton"){t._switchToPage(1);}else if(s===t.getId()+"-filterbutton"){t._switchToPage(2);}else{for(i=0;i<d;i++){var o=c[i];if(!t._isEmptyTab(o)&&s===o.getTabButton().getId()){t._switchToPage(o.getId());break;}}}q.sap.log.info('press event segmented: '+e.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};V.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new sap.m.Button(this.getId()+"-sortbutton",{visible:false,icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};V.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new sap.m.Button(this.getId()+"-groupbutton",{visible:false,icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};V.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new sap.m.Button(this.getId()+"-filterbutton",{visible:false,icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};V.prototype._getPage1=function(s){if(this._page1===undefined&&!s){this._page1=new sap.m.Page(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};V.prototype._getPage2=function(){var t=this,d,B,D;if(this._page2===undefined){B=new sap.m.Button(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});D=new sap.m.Button(this.getId()+"-detailresetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});d=new sap.m.Bar({contentLeft:[B],contentMiddle:[this._getDetailTitleLabel()],contentRight:[D]}).addStyleClass("sapMVSDBar");this._page2=new sap.m.Page(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:d});this._getNavContainer().addPage(this._page2);}return this._page2;};V.prototype._initFilterDetailItems=function(o){var L;var m=o.getMultiSelect();var s=o.getItems();var t=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new sap.m.List({mode:(m?sap.m.ListMode.MultiSelect:sap.m.ListMode.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(e){var S,E=e.getParameter("listItems"),c,i=0,n;t._clearPresetFilter();if(E.length>1&&m){c=o.getItems();for(;i<c.length;i++){for(var j=0;j<E.length;j++){if(c[i].getKey()===E[j].getCustomData()[0].getValue().getKey()){c[i].setProperty('selected',E[j].getSelected(),true);}}}}else{S=e.getParameter("listItem").data("item");if(!o.getMultiSelect()){c=o.getItems();for(;i<c.length;i++){if(c[i].getId()!==S.getId()){c[i].setProperty('selected',false,true);}}}n=e.getParameter("listItem").getSelected();if(S.getProperty('selected')!==n){S.setProperty('selected',e.getParameter("listItem").getSelected(),true);}}}});for(var i=0;i<s.length;i++){L=new sap.m.StandardListItem({title:s[i].getText(),type:sap.m.ListType.Active,selected:s[i].getSelected()}).data("item",s[i]);this._filterDetailList.addItem(L);}this._getPage2().addContent(this._filterDetailList);};V.prototype._initSortItems=function(){var s,L;this._sortList.removeAllItems();s=this.getSortItems();if(s.length){s.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._sortList.addItem(L);},this);}};V.prototype._initSortContent=function(){var t=this;if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION").concat(":")});this._sortOrderList=new sap.m.List(this.getId()+"-sortorderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){t.setProperty('sortDescending',e.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaSortOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT").concat(":")});this._sortList=new sap.m.List(this.getId()+"-sortlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var s=sap.ui.getCore().byId(t.getSelectedSortItem());var i=e.getParameter("listItem").data("item");if(i){if(s){s.setSelected(!e.getParameter("listItem").getSelected());}i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedSortItem",i,true);},ariaLabelledBy:this._ariaSortListInvisibleText});this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};V.prototype._initGroupItems=function(){var L,h,G=this.getGroupItems();this._groupList.removeAllItems();if(!!G.length){G.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._groupList.addItem(L);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){h=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new sap.m.ViewSettingsItem({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!h,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!h&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}L=new sap.m.StandardListItem({title:this._oGroupingNoneItem.getText(),type:sap.m.ListType.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(L);}};V.prototype._initGroupContent=function(){var t=this;if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION").concat(":")});this._groupOrderList=new sap.m.List(this.getId()+"-grouporderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){t.setProperty('groupDescending',e.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaGroupOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP").concat(":")});this._groupList=new sap.m.List(this.getId()+"-grouplist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var s=sap.ui.getCore().byId(t.getSelectedGroupItem()),i=e.getParameter("listItem").data("item");if(!!i){if(!!s){s.setSelected(!e.getParameter("listItem").getSelected());}i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedGroupItem",i,true);},ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};V.prototype._initFilterItems=function(){var p,F,L,t=this;this._presetFilterList.removeAllItems();p=this.getPresetFilterItems();if(p.length){p.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._presetFilterList.addItem(L);},this);}if(p.length){L=new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(L);}this._filterList.removeAllItems();F=this.getFilterItems();if(F.length){F.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,press:(function(i){return function(e){if(t._navContainer.getCurrentPage().getId()!==t.getId()+'-page2'){t._switchToPage(3,i);t._prevSelectedFilterItem=this;q.sap.delayedCall(0,t._navContainer,"to",[t.getId()+'-page2',"slide"]);}if(sap.ui.Device.system.desktop&&t._filterDetailList&&t._filterDetailList.getItems()[0]){t._getNavContainer().attachEventOnce("afterNavigate",function(){t._filterDetailList.getItems()[0].focus();});}};}(i))}).data("item",i);this._filterList.addItem(L);},this);}};V.prototype._initFilterContent=function(){var t=this;if(this._filterContent){return;}this._vContentPage=-1;this._presetFilterList=new sap.m.List(this.getId()+"-predefinedfilterlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var i=e.getParameter("listItem").data("item");if(i){i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedPresetFilterItem",i,true);t._clearSelectedFilters();}}).addStyleClass("sapMVSDUpperList");this._filterList=new sap.m.List(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};V.prototype._initDialogContent=function(p){var s=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(s){this._initSortContent();this._initSortItems();}if(G){this._initGroupContent();this._initGroupItems();}if(P||F){this._initFilterContent();this._initFilterItems();}this._updateDialogState(p);this._updateListSelections();};V.prototype._updateDialogState=function(p){var s=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length,c=!!this.getCustomTabs().length,S=this._getSegmentedButton(),d=null,i=false,D={"sort":0,"group":1,"filter":2};S.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(s){S.addButton(this._getSortButton());}if(P||F){S.addButton(this._getFilterButton());if(!P){this._presetFilterList.setVisible(false);this._presetFilterList.addStyleClass("sapMVSDUpperList");}if(!F){this._filterList.setVisible(false);this._presetFilterList.removeStyleClass("sapMVSDUpperList");}}if(G){S.addButton(this._getGroupButton());}if(c){this.getCustomTabs().forEach(function(o){if(!this._isEmptyTab(o)){var B=o.getTabButton({'idPrefix':this.getId()+this._sCustomTabsButtonsIdPrefix});S.addButton(B);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(p===undefined&&this._vContentPage!==-1){p=this._vContentPage;switch(p){case 0:p='sort';break;case 1:p='group';break;case 2:p='filter';break;}}if(p===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{p=this._determineValidPageId(p);for(var e in D){if(p===e){i=true;d=this.getId()+'-'+p+'button';p=D[e];break;}}if(!i){d=this.getId()+this._sCustomTabsButtonsIdPrefix+p;}this._getSegmentedButton().setSelectedButton(d);this._switchToPage(p);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};V.prototype._determineValidPageId=function(p){var d='sort',h=false,c=[];c=this._fetchValidPagesIds();if(c.length){d=c[0];}else{q.sap.log.warning('No available pages to load - missing items.');}if(!p){p=d;}else{c.filter(function(s){if(s===p){h=true;return false;}return true;});if(!h){p=d;}}return p;};V.prototype._fetchValidPagesIds=function(){var i,c=this.getCustomTabs(),d=c.length,e=[];var p=['sort','filter','group'];p.forEach(function(P){if(this._isValidPredefinedPageId(P)){e.push(P);}},this);for(i=0;i<d;i++){var o=c[i];if(!this._isEmptyTab(o)){e.push(o.getId());}}return e;};V.prototype._isEmptyTab=function(c){return!(c.getContent().length||this._vContentPage===c.getId()&&this._getPage1().getContent().length);};V.prototype._isValidPredefinedPageId=function(n){if(!n){q.sap.log.warning('Missing mandatory parameter.');return false;}var h=false;switch(n){case'sort':h=!!this.getSortItems().length;break;case'filter':h=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':h=!!this.getGroupItems().length;break;}return h;};sap.m.ViewSettingsDialog.prototype._pressBackButton=function(){var t=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(t._prevSelectedFilterItem){t._prevSelectedFilterItem.focus();}});q.sap.delayedCall(0,this._getNavContainer(),'back');this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};V.prototype.setModel=function(m,n){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return sap.ui.base.ManagedObject.prototype.setModel.call(this,m,n);};V.prototype.removeFilterItem=function(F){var s="";if(this._vContentPage===3&&this._oContentItem){if(typeof(F)==="object"){s=F.getId();}else if(typeof(F)==="string"){s=F;}else if(typeof(F)==="number"){s=this.getFilterItems()[F].getId();}if(this._oContentItem.getId()===s){r.call(this);}}return this.removeAggregation('filterItems',F);};V.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return this.removeAllAggregation('filterItems');};V.prototype._switchToPage=function(w,o){var i=0,t=this._getTitleLabel(),R=this._getResetButton(),h=this._getHeader(),s=this._getSubHeader();if(this._vContentPage===w&&w!==3){if(h.getContentRight().length===0&&s.getContentRight().length===0){this._addResetButtonToPage1();}return false;}if(b.call(this)){a.call(this);}h.removeAllContentRight();s.removeAllContentRight();this._vContentPage=w;this._oContentItem=o;if(w!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(w===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){t.setText(this.getTitle());}else{t.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}switch(w){case 1:R.setVisible(false);if(!this._showSubHeader&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:R.setVisible(!!this.getFilterItems().length);if(!this._showSubHeader&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(o);if(o instanceof sap.m.ViewSettingsCustomItem&&o.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(o.getCustomControl());}else if(o instanceof sap.m.ViewSettingsFilterItem&&o.getItems()){this._initFilterDetailItems(o);}break;case 0:R.setVisible(false);if(!this._getPage1().getSubHeader()&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:R.setVisible(false);this._getPage1().removeAllAggregation("content",true);var T="VIEWSETTINGS_TITLE";var c=this.getCustomTabs();if(c.length<2){T=c[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){t.setText(T);}c.forEach(function(d){if(d.getId()===w){d.getContent().forEach(function(e){this._getPage1().addContent(e);},this);}},this);break;}};V.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};V.prototype._updateListSelection=function(L,o){var c,i=0;if(!L){return false;}c=L.getItems();L.removeSelections();for(;i<c.length;i++){if(c[i].data("item")===o||c[i].data("item")===null){L.setSelectedItem(c[i],(o&&o.getSelected?o.getSelected():true));return true;}}return false;};V.prototype._updateFilterCounters=function(){var L=(this._filterList?this._filterList.getItems():[]),o,s,F=0,i=0,j;for(;i<L.length;i++){o=L[i].data("item");F=0;if(o){if(o instanceof sap.m.ViewSettingsCustomItem){F=o.getFilterCount();}else if(o instanceof sap.m.ViewSettingsFilterItem){F=0;s=o.getItems();for(j=0;j<s.length;j++){if(s[j].getSelected()){F++;}}}}L[i].setCounter(F);}};V.prototype._clearSelectedFilters=function(){var c=this.getFilterItems(),s,i=0,j;for(;i<c.length;i++){if(c[i]instanceof sap.m.ViewSettingsFilterItem){s=c[i].getItems();for(j=0;j<s.length;j++){s[j].setProperty('selected',false,true);}}c[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};V.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};V.prototype._calculateNumberOfPages=function(){var A=0,s=!!this.getSortItems().length,G=!!this.getGroupItems().length,p=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(s){A++;}if(p||F){A++;}if(G){A++;}this.getCustomTabs().forEach(function(c){if(!this._isEmptyTab(c)){A++;}},this);return A;};V.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function r(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function g(c,k){var i,o;for(i=0;i<c.length;i++){if(c[i].getKey()===k){o=c[i];break;}}return o;}function f(i,c,e){var o;if(typeof i==="string"){o=g(c,i);if(!o){q.sap.log.error(e);}}else{o=i;}return o;}function v(i){return i&&i instanceof sap.m.ViewSettingsItem;}V.prototype._onConfirm=function(e){var t=this,d=this._getDialog(),A=function(){var s={sortItem:sap.ui.getCore().byId(t.getSelectedSortItem()),sortDescending:t.getSortDescending(),groupItem:sap.ui.getCore().byId(t.getSelectedGroupItem()),groupDescending:t.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(t.getSelectedPresetFilterItem()),filterItems:t.getSelectedFilterItems(),filterKeys:t.getSelectedFilterKeys(),filterString:t.getSelectedFilterString()};t._dialog.detachAfterClose(A);t.fireConfirm(s);};d.attachAfterClose(A);d.close();};V.prototype._onCancel=function(e){var t=this,d=this._getDialog(),A=function(){t.setSelectedSortItem(t._oPreviousState.sortItem);t.setSortDescending(t._oPreviousState.sortDescending);t.setSelectedGroupItem(t._oPreviousState.groupItem);t.setGroupDescending(t._oPreviousState.groupDescending);t.setSelectedPresetFilterItem(t._oPreviousState.presetFilterItem);t._clearSelectedFilters();t.setSelectedFilterKeys(t._oPreviousState.filterKeys);if(t._navContainer.getCurrentPage()!==t._oPreviousState.navPage){q.sap.delayedCall(0,t._navContainer,"to",[t._oPreviousState.navPage.getId(),"show"]);}t._switchToPage(t._oPreviousState.contentPage,t._oPreviousState.contentItem);t._dialog.detachAfterClose(A);t.fireCancel();};d.attachAfterClose(A);d.close();};V.prototype._onClearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),'to',[this._getPage1().getId()]);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));};V.prototype._addResetButtonToPage1=function(){var h=this._getHeader(),s=this._getSubHeader(),R=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(s);}s.addContentRight(R);}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}h.addContentRight(R);}};V.prototype.removeAggregation=function(A,o,s){a.call(this,A,o);return sap.ui.core.Control.prototype.removeAggregation.call(this,A,o,s);};V.prototype.removeAllAggregation=function(A,s){a.call(this);return sap.ui.core.Control.prototype.removeAllAggregation.call(this,A,s);};V.prototype.destroyAggregation=function(A,s){a.call(this);return sap.ui.core.Control.prototype.destroyAggregation.call(this,A,s);};function a(A,c){if(!this._getPage1(true)){return;}if(A==='customTabs'&&c){if(c.getMetadata().getName()===this.getMetadata().getManagedAggregation(A).type&&this._vContentPage===c.getId()){var p=this._getPage1().getContent();p.forEach(function(o){c.addAggregation('content',o,true);});}}else if(!A&&!c){var p=this._getPage1().getContent();this.getCustomTabs().forEach(function(c){if(this._vContentPage===c.getId()){p.forEach(function(o){c.addAggregation('content',o,true);});}},this);}}function b(){var p=[-1,0,1,2,3];return(this._getPage1().getContent().length&&p.indexOf(this._vContentPage)===-1);}return V;},true);
