/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation'],function(q,l,C,I){"use strict";var T=C.extend("sap.ui.commons.TabStrip",{metadata:{library:"sap.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},selectedIndex:{type:"int",group:"Misc",defaultValue:0},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"tabs",aggregations:{tabs:{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"}},events:{select:{parameters:{index:{type:"int"}}},close:{parameters:{index:{type:"int"}}}}}});T.ANIMATION_DURATION=200;T.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};T.prototype.onAfterRendering=function(){this._initItemNavigation();var t=this.getTabs();for(var i=0;i<t.length;i++){t[i].onAfterRendering();}};T.prototype.createTab=function(t,c){var o=new sap.ui.core.Title({text:t}),a=new sap.ui.commons.Tab();a.setTitle(o);a.addContent(c);this.addTab(a);return a;};T.prototype.selectTabByDomRef=function(d){var i=this.getItemIndex(d);if(i>-1){if((i!=this.getSelectedIndex())&&(this.getTabs()[i].getEnabled())){var o=this.getSelectedIndex();this.setProperty('selectedIndex',i,true);this.rerenderPanel(o,true);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex());}}};T.prototype.onsapspace=function(e){var s=e.target;this.selectTabByDomRef(s);};T.prototype.onsapspacemodifiers=T.prototype.onsapspace;T.prototype.onsapenter=T.prototype.onsapspace;T.prototype.onsapentermodifiers=T.prototype.onsapspace;T.prototype.onsapdelete=function(e){var s=e.target;var i=this.getItemIndex(s);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i});}};T.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild;};T.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};T.prototype.getItemIndex=function(d){var i;if(!d.id||d.id.search("-close")!=-1){var o=q(d).parentByAttribute("id");i=o.id;}else{i=d.id;}for(var a=0,t=this.getTabs();a<t.length;a++){if(i==t[a].getId()){return a;}}return-1;};T.prototype.removeTab=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfTab(e);}var t=this.getTabs()[i];if(t.getVisible()){t.setProperty("visible",false,true);this.hideTab(i);t.setProperty("visible",true,true);}if(this.getSelectedIndex()>i){this.setProperty('selectedIndex',this.getSelectedIndex()-1,true);}return this.removeAggregation("tabs",i,true);};T.prototype.setSelectedIndex=function(s){var o=this.getSelectedIndex();if(s==o){return this;}var t=this.getTabs();var a=t[s];if(!a&&!this.getDomRef()){this.setProperty('selectedIndex',s,false);}else if(a&&a.getEnabled()&&a.getVisible()){this.setProperty('selectedIndex',s,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(o);if(this.oItemNavigation){var v=0;var S=-1;for(var i=0;i<t.length;i++){a=t[i];if(a.getVisible()===false){continue;}if(i==s){S=v;break;}v++;}this.oItemNavigation.setSelectedIndex(S);}}}else{this._warningInvalidSelectedIndex(s,a);}return this;};T.prototype.closeTab=function(i){var t=this.getTabs()[i];if(!t||!t.getClosable()||!t.getVisible()){return;}t.setProperty("visible",false,true);this.hideTab(i);};T.prototype.hideTab=function(a){var t=this.getTabs()[a];if(!this.getDomRef()){return;}var f=this.oItemNavigation.getFocusedIndex();var v=parseInt(t.$().attr("aria-posinset"),10)-1;var F=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty('selectedIndex',-1,true);t.$("panel").remove();}else if(a==this.getSelectedIndex()){var n=a+1;while(n<this.getTabs().length&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n++;}if(n==this.getTabs().length){n=a-1;while(n>=0&&(!this.getTabs()[n].getEnabled()||!this.getTabs()[n].getVisible())){n--;}}this.setProperty('selectedIndex',n,true);this.rerenderPanel(a);}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex());}this.iVisibleTabs--;var v=0;var b=[];var s=-1;var c=false;for(var i=0;i<this.getTabs().length;i++){var t=this.getTabs()[i];if(F==t.getId()){c=true;}if(t.getVisible()===false){continue;}if(i==this.getSelectedIndex()){s=v;}v++;t.$().attr("aria-posinset",v).attr("aria-setsize",this.iVisibleTabs);b.push(t.getDomRef());}if(v<=f){f--;}this.oItemNavigation.setItemDomRefs(b);this.oItemNavigation.setSelectedIndex(s);this.oItemNavigation.setFocusedIndex(f);if(c){this.oItemNavigation.focusItem(f);}};T.prototype.rerenderPanel=function(o,f){var n=this.getSelectedIndex();var O=this.getTabs()[o];var N=this.getTabs()[n].getId();var t=this.getTabs()[n];q.sap.delayedCall(0,this,function(){var $=this.$().find('.sapUiTabPanel');if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(r,t);r.flush($[0]);r.destroy();}$.attr("id",N+"-panel").attr("aria-labelledby",N);O.setProperty("scrollTop",$.scrollTop(),true);O.setProperty("scrollLeft",$.scrollLeft(),true);t.onAfterRendering();if(f){this.fireSelect({index:n});}});this.toggleTabClasses(o,n);};T.prototype.toggleTabClasses=function(o,n){this.getTabs()[o].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false);var b=o-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--;}if(b>=0){this.getTabs()[b].$().removeClass("sapUiTabBeforeSel");}var a=o+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++;}if(a<this.getTabs().length){this.getTabs()[a].$().removeClass("sapUiTabAfterSel");}this.getTabs()[n].$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true);b=n-1;while(b>=0&&!this.getTabs()[b].getVisible()){b--;}if(b>=0){this.getTabs()[b].$().addClass("sapUiTabBeforeSel");}a=n+1;while(a<this.getTabs().length&&!this.getTabs()[a].getVisible()){a++;}if(a<this.getTabs().length){this.getTabs()[a].$().addClass("sapUiTabAfterSel");}};T.prototype._originalInvalidate=T.prototype.invalidate;T.prototype.invalidate=function(){this.invalidated=true;T.prototype._originalInvalidate.apply(this,arguments);};T.prototype._warningInvalidSelectedIndex=function(s,t){var d="";if(!t){d="Tab not exists";}else if(!t.getEnabled()){d="Tab disabled";}else if(!t.getVisible()){d="Tab not visible";}q.sap.log.warning("SelectedIndex "+s+" can not be set",d,"sap.ui.commons.TabStrip");};T.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ESCAPE){this._stopMoving();}};T.prototype.onclick=function(e){var s=e.target;var $=q(s);if(s.className=="sapUiTabClose"){var i=this.getItemIndex($.parentByAttribute("id"));if(i>-1){this.fireClose({index:i});}}};T.prototype.onmousedown=function(e){var L=!e.button;var i=this._isTouchMode(e);if(!i&&!L){return;}var s=e.target;var $=q(s);if(s.className=="sapUiTabClose"){e.preventDefault();e.stopPropagation();e.target=null;return;}this.selectTabByDomRef(s);if(!this.getEnableTabReordering()){return;}var a=$.closest(".sapUiTab, .sapUiTabSel, .sapUiTabDsbl");if(a.length===1){this._onTabMoveStart(a,e,i);}};T.prototype._onTabMoveStart=function($,e,i){this._disableTextSelection();e.preventDefault();$.zIndex(this.$().zIndex()+10);var a=this.getItemIndex(e.target);var t=this.getTabs()[a];var b=this.$().find('.sapUiTabBarCnt').children();var c=q.inArray($[0],b);var w=$.outerWidth();this._dragContext={index:c,tabIndex:a,isTouchMode:i,startX:i?e.originalEvent.targetTouches[0].pageX:e.pageX,tab:t,tabWidth:w,tabCenter:$.position().left+w/2};this._aMovedTabIndexes=[];var d=q(document);if(i){d.bind("touchmove",q.proxy(this._onTabMove,this));d.bind("touchend",q.proxy(this._onTabMoved,this));}else{d.mousemove(q.proxy(this._onTabMove,this));d.mouseup(q.proxy(this._onTabMoved,this));}};T.prototype._onTabMove=function(e){var d=this._dragContext;if(!d){return;}var b=this._isTouchMode(e);if(b){e.preventDefault();}var p=b?e.targetTouches[0].pageX:e.pageX;var D=p-d.startX;d.tab.$().css({left:D});var $,x,o,r,a=this.$().find('.sapUiTabBarCnt').children(),m=this._aMovedTabIndexes,R=sap.ui.getCore().getConfiguration().getRTL();for(var i=0;i<a.length;i++){if(i==d.index){continue;}$=q(a[i]);x=$.position().left;o=parseFloat($.css('left'));if(!isNaN(o)){x-=o;}if(i<d.index!=R){r=x+$.outerWidth()>d.tabCenter+D;this._onAnimateTab($,d.tabWidth,r,m,i);}else{r=x<d.tabCenter+D;this._onAnimateTab($,-d.tabWidth,r,m,i);}}};T.prototype._onAnimateTab=function($,d,r,m,i){var a=q.inArray(i,m);var b=a!=-1;if(r&&!b){$.stop(true,true);$.animate({left:d},T.ANIMATION_DURATION);m.push(i);}else if(!r&&b){$.stop(true,true);$.animate({left:0},T.ANIMATION_DURATION);m.splice(a,1);}};T.prototype._onTabMoved=function(e){var d=this._dragContext;if(!d){return;}this._stopMoving();var m=this._aMovedTabIndexes;if(m.length==0){return;}var $=d.tab.$(),a,b=this.$().find('.sapUiTabBarCnt').children();var n=m[m.length-1],s=n,N=this.getItemIndex(b[n]);this.removeAggregation('tabs',d.tab,true);this.insertAggregation('tabs',d.tab,N,true);if(n>d.index){$.insertAfter(q(b[n]));}else{$.insertBefore(q(b[n]));}b=this.$().find('.sapUiTabBarCnt').children();if(!d.tab.getEnabled()){for(var i=0;i<b.length;i++){a=q(b[i]);if(a.hasClass('sapUiTabSel')){s=i;N=this.getItemIndex(a[0]);break;}}}this.setProperty('selectedIndex',N,true);b.removeClass('sapUiTabAfterSel');b.removeClass('sapUiTabBeforeSel');for(var i=0;i<b.length;i++){a=q(b[i]);a.attr("aria-posinset",i+1);if(i==s-1){a.addClass('sapUiTabBeforeSel');}else if(i==s+1){a.addClass('sapUiTabAfterSel');}}$.focus();this._initItemNavigation();};T.prototype._stopMoving=function(){var d=this._dragContext;if(!d){return;}var $=d.tab.$();$.css('z-index','');var a=this.$().find('.sapUiTabBarCnt').children();a.stop(true,true);a.css('left','');this._dragContext=null;var b=q(document);if(d.isTouchMode){b.unbind("touchmove",this._onTabMove);b.unbind("touchend",this._onTabMoved);}else{b.unbind("mousemove",this._onTabMove);b.unbind("mouseup",this._onTabMoved);}this._enableTextSelection();};T.prototype._isTouchMode=function(e){return!!e.originalEvent["touches"];};T.prototype._initItemNavigation=function(){var f=this.getFocusDomRef(),t=f.lastChild.childNodes,a=[],s=-1;for(var i=0;i<t.length;i++){a.push(t[i]);if(q(t[i]).hasClass("sapUiTabSel")){s=i;}}if(!this.oItemNavigation){this.oItemNavigation=new I();this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(a);this.oItemNavigation.setSelectedIndex(s);};T.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").addClass('sapUiTabStripNoSelection').bind("selectstart",function(E){E.preventDefault();return false;});};T.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").removeClass('sapUiTabStripNoSelection').unbind("selectstart");};T.prototype._getActualSelectedIndex=function(){var s=Math.max(0,this.getSelectedIndex());var t=this.getTabs();var S=t[s];if(S&&S.getVisible()&&S.getEnabled()){return s;}for(var i=0;i<t.length;i++){var o=t[i];if(o.getVisible()&&o.getEnabled()){return i;}}return 0;};return T;},true);
