/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','./View','sap/ui/model/resource/ResourceModel','sap/ui/base/ManagedObject','sap/ui/core/Control','jquery.sap.xml'],function(q,X,l,V,R,M,C){"use strict";var a=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'}}}});sap.ui.xmlview=function(i,v){return sap.ui.view(i,v,sap.ui.core.mvc.ViewType.XML);};a._sType=sap.ui.core.mvc.ViewType.XML;a.asyncSupport=true;a.prototype.initViewSettings=function(s){var t=this;this._oContainingView=s.containingView||this;var p=function(){if(!t.isSubView()){X.parseViewAttributes(t._xContent,t,s);}else{delete s.controller;}if((t._resourceBundleName||t._resourceBundleUrl)&&(!s.models||!s.models[t._resourceBundleAlias])){var m=new R({bundleName:t._resourceBundleName,bundleUrl:t._resourceBundleUrl,bundleLocale:t._resourceBundleLocale});t.setModel(m,t._resourceBundleAlias);}t.oAfterRenderingNotifier=new sap.ui.core.mvc.XMLAfterRenderingNotifier();t.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){t.onAfterRenderingBeforeChildren();}});};if(!s){throw new Error("mSettings must be given");}if(this._oAsyncState){this._oAsyncState.suppressPreserve=true;}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((s.viewName||s.viewContent)&&s.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(s.viewName||s.viewContent)&&!s.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}if(s.viewName){var r=q.sap.getResourceName(s.viewName,".view.xml");if(s.async){return q.sap.loadResource(r,{async:true}).then(function(d){t._xContent=d.documentElement;return t.runPreprocessor("xml",t._xContent);}).then(function(x){t._xContent=x;p();});}else{this._xContent=q.sap.loadResource(r).documentElement;}}else if(s.viewContent){this.mProperties["viewContent"]=s.viewContent;this._xContent=q.sap.parseXML(s.viewContent);if(this._xContent.parseError.errorCode!==0){var P=this._xContent.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}else{this._xContent=this._xContent.documentElement;}}else if(s.xmlNode){this._xContent=s.xmlNode;}if(s.async){return this.runPreprocessor("xml",this._xContent).then(function(x){t._xContent=x;p();});}else{this._xContent=this.runPreprocessor("xml",this._xContent,true);p();}};a.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};a.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){t._aParsedContent=X.parseTemplate(t._xContent,t);if(t._oAsyncState){delete t._oAsyncState.suppressPreserve;}},{settings:this._fnSettingsPreprocessor});};a.prototype.getControllerName=function(){return this._controllerName;};a.prototype.isSubView=function(){return this._oContainingView!=this;};a.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var c=this.getAggregation("content");if(c){for(var i=0;i<c.length;i++){if(c[i].getDomRef()===null){continue;}var $=c[i].$();q.sap.byId(sap.ui.core.RenderPrefixes.Dummy+c[i].getId(),this._$oldContent).replaceWith($);}}q.sap.byId(sap.ui.core.RenderPrefixes.Dummy+this.getId()).replaceWith(this._$oldContent);}this._$oldContent=undefined;};a.prototype._onChildRerenderedEmpty=function(c,e){q(e).replaceWith('<div id="'+sap.ui.core.RenderPrefixes.Dummy+c.getId()+'" class="sapUiHidden"/>');return true;};a.registerPreprocessor=function(t,p,s,o,S){t=t.toUpperCase();if(a.PreprocessorType[t]){sap.ui.core.mvc.View.registerPreprocessor(a.PreprocessorType[t],p,this.getMetadata().getClass()._sType,s,o,S);}else{q.sap.log.error("Preprocessor could not be registered due to unknown sType \""+t+"\"",this.getMetadata().getName());}};a.PreprocessorType={XML:"xml",CONTROLS:"controls"};C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{renderer:function(r,c){r.write("");}});a.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return a;});
