/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{},startDateChange:{}}}});c.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=this._newUniversalDate(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=this._newUniversalDate(new Date(Date.UTC(9999,11,31)));var E=new H(this.getId()+"--Head");E.attachEvent("pressPrevious",this._handlePrevious,this);E.attachEvent("pressNext",this._handleNext,this);E.attachEvent("pressButton1",r,this);E.attachEvent("pressButton2",s,this);this.setAggregation("header",E);var F=this._createMonth(this.getId()+"--Month0");F.attachEvent("focus",v,this);F.attachEvent("select",u,this);F.attachEvent("_renderMonth",t,this);F.attachEvent("_bindMousemove",w,this);F.attachEvent("_unbindMousemove",x,this);F._bNoThemeChange=true;this.addAggregation("month",F);var G=new b(this.getId()+"--MP");G.attachEvent("select",y,this);G._bNoThemeChange=true;this.setAggregation("monthPicker",G);var I=new Y(this.getId()+"--YP");I.attachEvent("select",z,this);this.setAggregation("yearPicker",I);};c.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}};c.prototype._createMonth=function(i){var E=new M(i);return E;};c.prototype.onBeforeRendering=function(){var E=this.getAggregation("month");var F;var G=E[0].getDate();var I=this._getFocusedDate();if(E.length>1&&G){F=this._newUniversalDate(G);}else if(E.length>1){F=B.call(this,this._getFocusedDate());}else{F=I;}for(var i=0;i<E.length;i++){var J=E[i];G=this._newUniversalDate(F);if(i>0){G.setUTCDate(1);G.setUTCMonth(F.getUTCMonth()+i);}if(I.getUTCFullYear()==G.getUTCFullYear()&&I.getUTCMonth()==G.getUTCMonth()){J.setDate(a._createLocalDate(I));}else{J.displayDate(a._createLocalDate(G));}}this._updateHeader(F);};c.prototype.onAfterRendering=function(){j.call(this);};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,A,[this]);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){d.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=this._newUniversalDate(i);};c.prototype.focusDate=function(i){o.call(this,i,false);return this;};c.prototype.displayDate=function(i){o.call(this,i,true);return this;};c.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=a._createUniversalUTCDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=this._newUniversalDate(this._getFocusedDate());}S.setUTCDate(1);return a._createLocalDate(S);};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(E){this.setProperty("months",E,false);E=p.call(this);var F=this.getAggregation("month");var i=0;var G;if(F.length<E){for(i=F.length;i<E;i++){G=this._createMonth(this.getId()+"--Month"+i);G.attachEvent("focus",v,this);G.attachEvent("select",u,this);G.attachEvent("_renderMonth",t,this);G.attachEvent("_bindMousemove",w,this);G.attachEvent("_unbindMousemove",x,this);G._bNoThemeChange=true;this.addAggregation("month",G);}}else if(F.length>E){for(i=F.length;i>E;i--){G=this.removeAggregation("month",i-1);G.destroy();}}if(E>1&&F[0].getDate()){F[0].setProperty("date",null,true);}return this;};c.prototype.setPrimaryCalendarType=function(E){var F=this.getAggregation("month");var R=false;if(F.length>1){R=true;}this.setProperty("primaryCalendarType",E,!R);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:E});if(this._oFocusedDate){this._oFocusedDate=U.getInstance(this._oFocusedDate.getJSDate(),E);}this._oMinDate=U.getInstance(this._oMinDate.getJSDate(),E);this._oMaxDate=U.getInstance(this._oMaxDate.getJSDate(),E);for(var i=0;i<F.length;i++){var G=F[i];G.setPrimaryCalendarType(E);}var I=this.getAggregation("monthPicker");I.setPrimaryCalendarType(E);var J=this.getAggregation("yearPicker");J.setPrimaryCalendarType(E);if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(this.iMode!=1&&I.getDomRef()){I.$().remove();}if(this.iMode!=2&&J.getDomRef()){J.$().remove();}}return this;};c.prototype._newUniversalDate=function(i){var J;if((i instanceof U)){J=new Date(i.getJSDate().getTime());}else{J=new Date(i.getTime());}return U.getInstance(J,this.getPrimaryCalendarType());};c.prototype.setSecondaryCalendarType=function(E){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",E,true);this._oYearFormatSecondary=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:E});var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];G.setSecondaryCalendarType(E);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};c.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var E=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(E);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=p.call(this);if(i>2){return true;}else{return false;}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};c.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(F.getDomRef("B1"));if(!this._bPoupupMode){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==F.getId()+"-B1"){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==F.getId()+"-B1"){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");var K;switch(this._iMode){case 0:K=this._getFocusedDate();for(var i=0;i<G.length;i++){var N=G[i];var O=a._createUniversalUTCDate(N.getDate(),this.getPrimaryCalendarType());if(K.getTime()==O.getTime()){N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}else{q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());break;case 2:J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==F.getId()+"-B2"){q.sap.focus(F.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var F=this.getAggregation("header");var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");q.sap.focus(F.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<F.length;i++){var J=F[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var E=this.getAggregation("monthPicker");e.call(this,true);E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;this._bLongMonth=E._bLongMonth;f.call(this,true);var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];G._bNoThemeChange=false;G.onThemeChanged(arguments);G._bNoThemeChange=true;}var I=this._getFocusedDate();n.call(this,I);j.call(this);};c.prototype._updateHeader=function(i){n.call(this,i);k.call(this,i,true);};c.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var G=this.getAggregation("yearPicker");var I=p.call(this);var J;var N=false;switch(this._iMode){case 0:if(I>1){J=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());J.setUTCDate(1);this._setFocusedDate(J);F=this._getFocusedDate();}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_.call(this,N,true);break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);i.setTextButton2(this._oYearFormat.format(F,true));var S=this._getSecondaryCalendarType();if(S){var K=U.getInstance(new Date(F.getJSDate()),S);K.setUTCMonth(0,1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(K,true));}else{i.setAdditionalTextButton2();}k.call(this,F);break;case 2:G.previousPage();break;}};c.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var G=this.getAggregation("yearPicker");var I=p.call(this);var J;switch(this._iMode){case 0:if(I>1){J=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(J);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+I,1);_.call(this);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);i.setTextButton2(this._oYearFormat.format(F,true));var S=this._getSecondaryCalendarType();if(S){var K=U.getInstance(new Date(F.getJSDate()),S);K.setUTCMonth(0,1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(K,true));}else{i.setAdditionalTextButton2();}k.call(this,F);break;case 2:G.nextPage();break;}};c.prototype._getDisplayedMonths=function(E){var F=[];var G=E.getUTCMonth();var I=p.call(this);if(I>1){for(var i=0;i<I;i++){F.push((G+i)%12);}}else{F.push(G);}return F;};c.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=a._createUniversalUTCDate(i[0].getDate(),P);F.setUTCDate(1);F=U.getInstance(F.getJSDate(),S);var E=F.getUTCMonth();var G=a._createUniversalUTCDate(i[i.length-1].getDate(),P);G.setUTCMonth(G.getUTCMonth()+1,0);G=U.getInstance(G.getJSDate(),S);var I=G.getUTCMonth();return{start:E,end:I};};c.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:f.call(this);break;case 2:h.call(this);break;}};function _(N,I,E){var F=this._getFocusedDate();var G=this.getAggregation("month");var J=false;var K;var O;var P;var i=0;for(i=0;i<G.length;i++){K=G[i];if(K.checkDateFocusable(a._createLocalDate(F))){J=true;}if(J||G.length==1){if(!N){K.setDate(a._createLocalDate(F));}else{K.displayDate(a._createLocalDate(F));}break;}}if(!J){P=this._newUniversalDate(F);if(G.length>1){P=B.call(this,P);for(i=0;i<G.length;i++){K=G[i];O=this._newUniversalDate(P);O.setUTCMonth(P.getUTCMonth()+i);if(!N&&O.getUTCFullYear()==F.getUTCFullYear()&&O.getUTCMonth()==F.getUTCMonth()){K.setDate(a._createLocalDate(F));}else{K.displayDate(a._createLocalDate(O));}}}this._updateHeader(P);if(!E){this.fireStartDateChange();}}}function d(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),i);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N,i);}}function e(N){if(this._iMode==2){h.call(this,true);}var E=this._getFocusedDate();var F=this.getAggregation("monthPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(F.getDomRef()){F.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(F);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(F);}this.$("contentOver").css("display","");if(!N){F.setMonth(E.getUTCMonth());if(this._iMode==0){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;k.call(this,E,false);}function f(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var E=this.getAggregation("monthPicker");E.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(this.getMonths()>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}k.call(this,this._getFocusedDate(),true);}function g(){if(this._iMode==1){f.call(this,true);}var E=this._getFocusedDate();var F=E.getJSDate().getUTCFullYear();var G=this._oMaxDate.getJSDate().getUTCFullYear();var I=this._oMinDate.getJSDate().getUTCFullYear();if(G-I<=20){return;}var J=this.getAggregation("header");if(F>(G-10)){F=G-9;J.setEnabledNext(false);}else{J.setEnabledNext(true);}if(F<(I+9)){F=I+10;J.setEnabledPrevious(false);}else{J.setEnabledPrevious(true);}var K=this.getAggregation("yearPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(K.getDomRef()){K.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(K);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(K);}this.$("contentOver").css("display","");K.setDate(E.getJSDate());var N;if(p.call(this)==1){N=this.getAggregation("month")[0];var O=N.$("days").find(".sapUiCalItem");if(O.length==28){K.$().addClass("sapUiCalYearNoTop");}else{K.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var P=this.getAggregation("month");for(var i=0;i<P.length;i++){N=P[i];q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._iMode=2;}function h(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var E=this.getAggregation("yearPicker");E.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(this.getMonths()>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}}function j(){if(!this._bNamesLengthChecked){e.call(this,true);f.call(this,true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var E=this._getFocusedDate();n.call(this,E);}}else if(this.getMonths()>1){m.call(this,this._getFocusedDate(),true,true);}}function k(i,E){var F=this._oMaxDate.getJSDate().getUTCFullYear();var G=this._oMinDate.getJSDate().getUTCFullYear();var I=this._oMaxDate.getJSDate().getUTCMonth();var J=this._oMinDate.getJSDate().getUTCMonth();var K=this.getAggregation("header");var N=this._newUniversalDate(i);N.setUTCMonth(N.getUTCMonth()+1,0);var O=N.getJSDate().getUTCFullYear();var P=N.getJSDate().getUTCMonth();if(O>F||(O==F&&(!E||P>=I))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){K.setEnabledNext(false);}else{K.setEnabledNext(true);}N.setUTCDate(1);O=N.getJSDate().getUTCFullYear();P=N.getJSDate().getUTCMonth();if(O<G||(O==G&&(!E||P<=J))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){K.setEnabledPrevious(false);}else{K.setEnabledPrevious(true);}}function m(i,O,N){var F;var E=false;var G=false;if(i.getTime()<this._oMinDate.getTime()){F=this._oMinDate;E=true;}else if(i.getTime()>this._oMaxDate.getTime()){F=this._oMaxDate;E=true;}else{F=i;}if(this._focusDateExtend){G=this._focusDateExtend(i,O,N);}var I=F.getTime()<this._getFocusedDate().getTime();this._setFocusedDate(F);if(E||O){_.call(this,false,I,N);}if(G){this.fireStartDateChange();}}function n(i){var E=this.getAggregation("header");var F=this._getLocaleData();var G=[];var I=[];var J=[];var K;var S=false;var T;var P;var N=this.getPrimaryCalendarType();var O=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){G=F.getMonthsStandAlone("wide",N);}else{S=true;G=F.getMonthsStandAlone("abbreviated",N);I=F.getMonthsStandAlone("wide",N);}if(O){J=F.getMonthsStandAlone("abbreviated",O);var Q=this._getDisplayedSecondaryMonths(N,O);if(Q.start==Q.end){T=J[Q.start];}else{P=F.getIntervalPattern();T=P.replace(/\{0\}/,J[Q.start]).replace(/\{1\}/,J[Q.end]);}}E.setAdditionalTextButton1(T);var R=this._getDisplayedMonths(i);if(R.length>1){if(!P){P=F.getIntervalPattern();}T=P.replace(/\{0\}/,G[R[0]]).replace(/\{1\}/,G[R[R.length-1]]);if(S){K=P.replace(/\{0\}/,I[R[0]]).replace(/\{1\}/,I[R[R.length-1]]);}}else{T=G[R[0]];if(S){K=I[R[0]];}}E.setTextButton1(T);if(S){E.setAriaLabelButton1(K);}var V=this._newUniversalDate(i);V.setUTCDate(1);E.setTextButton2(this._oYearFormat.format(V,true));if(O){V=U.getInstance(V.getJSDate(),O);E.setAdditionalTextButton2(this._oYearFormatSecondary.format(V,true));}else{E.setAdditionalTextButton2();}}function o(i,N){if(i&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}i=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());var E=i.getUTCFullYear();if(E<1||E>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this._setFocusedDate(i);if(this.getDomRef()&&this._iMode==0){_.call(this,N,false,true);}}}function p(){if(sap.ui.Device.system.phone){return 1;}else{return this.getMonths();}}function r(E){if(this._iMode!=1){e.call(this);}else{f.call(this);}}function s(E){if(this._iMode!=2){g.call(this);}else{h.call(this);}}function t(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function u(E){if(p.call(this)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._updateSelection();}}}this.fireSelect();}function v(E){var i=a._createUniversalUTCDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_.call(this,false,false,true);}}else{m.call(this,i,O);}}function w(E){if(p.call(this)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._bindMousemove();}}}}function x(E){if(p.call(this)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._unbindMousemove();}}}}function y(E){var F=this._newUniversalDate(this._getFocusedDate());var i=this.getAggregation("monthPicker");var G=i.getMonth();F.setUTCMonth(G);if(G!=F.getUTCMonth()){F.setUTCDate(0);}m.call(this,F,true);f.call(this);}function z(E){var F=this._newUniversalDate(this._getFocusedDate());var i=this.getAggregation("yearPicker");var G=a._createUniversalUTCDate(i.getDate(),this.getPrimaryCalendarType());G.setUTCMonth(F.getUTCMonth(),F.getUTCDate());F=G;m.call(this,F,true);h.call(this);}function A(){this._sInvalidateMonth=undefined;var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];F._bDateRangeChanged=true;F._bInvalidateSync=true;if(E.length>1){F._bNoFocus=true;}F.invalidate();F._bInvalidateSync=undefined;}if(E.length>1){m.call(this,this._getFocusedDate(),true,true);}this._bDateRangeChanged=undefined;}function B(i){var F=this._newUniversalDate(i);F.setUTCDate(1);var E=p.call(this);if(E<=12){var G=i.getUTCMonth();G=G-G%E;if(12%E>0&&G+E>11){G=12-E;}F.setUTCMonth(G);}return F;}return c;},true);
