/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/CustomData","sap/ui/layout/Grid","./ObjectPageSectionBase","./ObjectPageSubSectionLayout","./ObjectPageSubSectionMode","./BlockBase","sap/ui/layout/GridData","sap/m/Button","sap/ui/Device","./library"],function(C,G,O,a,b,B,c,d,D,l){"use strict";var e=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:b.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}}}});e.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;e.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._switchSubSectionMode(this.getMode());};e.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};e.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}));}return this.getAggregation("_grid");};e.prototype.connectToModels=function(){var f=this.getBlocks()||[],m=this.getMoreBlocks()||[],s=this.getMode();f.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(s);}o.connectToModels();}});if(m.length>0&&s===b.Expanded){m.forEach(function(M){if(M instanceof B){if(!M.getMode()){M.setMode(s);}M.connectToModels();}});}};e.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}D.media.detachHandler(this._updateImportance,this,e.MEDIA_RANGE);D.media.detachHandler(this._titleOnLeftSynchronizeLayouts,this,e.MEDIA_RANGE);if(O.prototype.exit){O.prototype.exit.call(this);}};e.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}if(this._getUseTitleOnTheLeft()){D.media.attachHandler(this._titleOnLeftSynchronizeLayouts,this,e.MEDIA_RANGE);}else{D.media.detachHandler(this._titleOnLeftSynchronizeLayouts,this,e.MEDIA_RANGE);}this._$spacer=jQuery.sap.byId(o.getId()+"-spacer");};e.prototype.onBeforeRendering=function(){if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(this._getObjectPageLayout());this.refreshSeeMoreVisibility();};e.prototype._applyLayout=function(L){var v,g=this._getGrid(),s=this.getMode(),f=L.getSubSectionLayout(),o=this._calculateLayoutConfiguration(f,L),h=this.getBlocks(),A=h.concat(this.getMoreBlocks());this._oLayoutConfig=o;this._resetLayoutData(A);if(s===b.Expanded){v=A;}else{v=h;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(i){this._setBlockMode(i,s);g.addContent(i);},this);}catch(E){jQuery.sap.log.error("ObjectPageSubSection :: error while building layout "+f+": "+E);}return this;};e.prototype._calculateLayoutConfiguration=function(L,o){var f={M:2,L:3,XL:4},i=f.L,E=f.XL,t=(L===a.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){i-=1;E-=1;}if(u){i-=1;}f.L=i;f.XL=E;return f;};e.prototype.refreshSeeMoreVisibility=function(){var f=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),g=this.$();if(!f){f=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(g.length){g.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",f);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",f);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",f);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",f);return f;};e.prototype.setMode=function(m){if(this.getMode()!==m){this._switchSubSectionMode(m);if(this._bRenderedFirstTime){this.rerender();}}return this;};e.prototype.onkeydown=function(E){if(E.keyCode===jQuery.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof e){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};e.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};e.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};e.prototype._calcBlockColumnLayout=function(f,o){var g=12,v,M,L,X,h;M={iRemaining:o.M,iColumnConfig:o.M};L={iRemaining:o.L,iColumnConfig:o.L};X={iRemaining:o.XL,iColumnConfig:o.XL};h=[X,L,M];v=f.filter(function(i){return i.getVisible&&i.getVisible();});v.forEach(function(i,I){h.forEach(function(j){j.iCalculatedSize=this._calculateBlockSize(i,j.iRemaining,v,I,j.iColumnConfig);},this);i.setLayoutData(new c({spanS:g,spanM:M.iCalculatedSize*(g/M.iColumnConfig),spanL:L.iCalculatedSize*(g/L.iColumnConfig),spanXL:X.iCalculatedSize*(g/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));h.forEach(function(j){j.iRemaining-=j.iCalculatedSize;if(j.iRemaining<1){j.iRemaining=j.iColumnConfig;}});},this);return v;};e.prototype._calculateBlockSize=function(o,r,v,i,m){var f,F=m,g;if(!this._hasAutoLayout(o)){return Math.min(m,parseInt(o.getColumnLayout(),10));}for(g=1;g<=F;g++){f=this._calcLayout(v[i+g]);if(f<r){r-=f;}else{break;}}return r;};e.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};e.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};e.prototype._onDesktopMediaRange=function(o){var m=o||D.media.getCurrentRange(e.MEDIA_RANGE);return["LargeDesktop","Desktop"].indexOf(m.name)>-1;};e.prototype._titleOnLeftSynchronizeLayouts=function(o){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(o));};e.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}jQuery.each(this._aAggregationProxy,jQuery.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A));},this));this._bRenderedFirstTime=true;};e.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};e.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};e.prototype._setAggregation=function(A,v){this._aAggregationProxy[A]=v;this._notifyObjectPageLayout();this.invalidate();return this._aAggregationProxy[A];};e.prototype.addAggregation=function(A,o){var f;if(this.hasProxy(A)){f=this._getAggregation(A);f.push(o);this._setAggregation(f);if(o instanceof B){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};e.prototype.insertAggregation=function(A,o,i){if(this.hasProxy(A)){jQuery.sap.log.warning("ObjectPageSubSection :: used of insertAggregation for "+A+" is not supported, will use addAggregation instead");return this.addAggregation(A,o);}return O.prototype.insertAggregation.apply(this,arguments);};e.prototype.removeAllAggregation=function(A){var i;if(this.hasProxy(A)){i=this._getAggregation(A);this._setAggregation(A,[]);return i.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};e.prototype.removeAggregation=function(A,o){var r=false,i;if(this.hasProxy(A)){i=this._getAggregation(A);i.forEach(function(f,I){if(f.getId()===o.getId()){i.splice(I,1);this._setAggregation(i);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};e.prototype.indexOfAggregation=function(A,o){var i=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(f,I){if(f.getId()===o.getId()){i=I;return true;}},this);return i;}return O.prototype.indexOfAggregation.apply(this,arguments);};e.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};e.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};e.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new d(this.getId()+"--seeMore",{type:sap.m.ButtonType.Transparent,iconFirst:false}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};e.prototype._seeMoreLessControlPressHandler=function(E){var s=this.getMode(),t,m=this.getMoreBlocks()||[];if(s===b.Expanded){t=b.Collapsed;}else{t=b.Expanded;m.forEach(function(o){if(o instanceof B){o.setMode(s);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};e.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===b.Collapsed){this.setProperty("mode",b.Collapsed,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",b.Expanded,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_LESS"));}};e.prototype._setBlockMode=function(o,m){if(o instanceof B){o.setMode(m);}else{jQuery.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+m+" to "+o.getMetadata().getName());}};e.prototype._setToFocusable=function(f){var F='0',n='-1',t="tabIndex";if(f){this.$().attr(t,F);}else{this.$().attr(t,n);}return this;};e.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o.getSubSectionLayout()===a.TitleOnLeft;};e.prototype._resetLayoutData=function(f){f.forEach(function(o){if(!this._bRenderedFirstTime&&o.getLayoutData()){o.destroyLayoutData();jQuery.sap.log.warning("ObjectPageSubSection :: forbidden use of layoutData for block "+o.getMetadata().getName(),"layout will be set by subSection");}},this);};e.prototype.getVisibleBlocksCount=function(){var v=0;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(m){if(m.getVisible&&!m.getVisible()){return true;}v++;});return v;};return e;});
