/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/ui/core/library'],function(q,M,C,a,l){"use strict";var V=C.extend("sap.ui.core.mvc.View",{metadata:{library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',viewContent:'any',viewData:'any',async:{type:"boolean",defaultValue:false}}}});V._mPreprocessors={};V.prototype._initCompositeSupport=function(s){this.oViewData=s.viewData;this.sViewName=s.viewName;this.mPreprocessors=s.preprocessors||{};var t=this;if(s.async){this._oAsyncState={};this._oAsyncState.promise=new Promise(function(r){t._oAsyncState.resolve=r;});}var b=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(b&&b.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(s){var I=this.getId();if(b&&I){if(t.isPrefixedId(I)){I=I.substring((t.getId()+"--").length);}var m=b.getCustomProperties(t.sViewName,I,t);if(m){s=q.extend(s,m);}}};}var p=function(f){var d=sap.ui.require("sap/ui/core/Component");var o=d&&d.getOwnerComponentFor(t);if(o){return o.runAsOwner(f);}else{return f.call();}};var i=function(){var P=c(t,s);if(P instanceof Promise){return P.then(function(){if(t.onControllerConnected){p(function(){t.onControllerConnected(t.oController);});}});}else{if(t.onControllerConnected){t.onControllerConnected(t.oController);}}};if(this.initViewSettings){if(s.async){this.initViewSettings(s).then(function(){return p(i);}).then(function(){return t.runPreprocessor("controls",t);}).then(function(){p(t.fireAfterInit.bind(t));t._oAsyncState.resolve(t);});}else{this.initViewSettings(s);i();this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};V.prototype.getController=function(){return this.oController;};V.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};V.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};V.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};var c=function(t,s){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var o=s.controller,n=o&&typeof o.getMetadata==="function"&&o.getMetadata().getName();if(!o&&t.getControllerName){var d=t.getControllerName();if(d){var b=sap.ui.require('sap/ui/core/CustomizingConfiguration');var e=b&&b.getControllerReplacement(d,M._sOwnerId);if(e){d=typeof e==="string"?e:e.controllerName;}o=sap.ui.controller(d);n=d;}}if(o){o=a.extendIfRequired(o,n,t._oAsyncState);if(o instanceof Promise){if(!t._oAsyncState){throw new Error("The view "+t.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return o.then(function(o){t.oController=o;o.connectToView(t);});}else{t.oController=o;o.connectToView(t);}}}else{t.oController={};}};V.prototype.getViewData=function(){return this.oViewData;};V.prototype.exit=function(){this.fireBeforeExit();this.oController=null;this._oAsyncState=null;};V.prototype.onAfterRendering=function(){this.fireAfterRendering();};V.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};V.prototype.clone=function(i,L){var s={},k,o;for(k in this.mProperties&&!(this.isBound&&this.isBound(k))){if(this.mProperties.hasOwnProperty(k)){s[k]=this.mProperties[k];}}o=C.prototype.clone.call(this,i,L,{cloneChildren:false,cloneBindings:true});o.applySettings(s);return o;};V.prototype.runPreprocessor=function(t,s,S){var v=this.getMetadata().getClass()._sType,o={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!S},b=V._mPreprocessors[v]?V._mPreprocessors[v][t]:undefined,d=b?b.settings:{},L=this.mPreprocessors[t],p;function r(R){if(R instanceof Promise||S){return R;}else{return Promise.resolve(R);}}if(L&&L.preprocessor){b=L;d=L;}else if(L&&(b&&b.onDemand)){d=q.extend(L,d);}else if(b&&b.onDemand){return r(s);}if(b){if(typeof b.preprocessor==="string"){q.sap.require(b.preprocessor);q.sap.log.debug("Running preprocessor for \""+t+"\" via module string \""+b.preprocessor+"\"",this);p=q.sap.getObject(b.preprocessor).process;}else if(b.preprocessor){q.sap.log.debug("Running preprocessor for \""+t+"\" via given function",this);p=b.preprocessor;}if(p&&(!S||b.syncSupport==S)){return r(p(s,o,d));}}return r(s);};V.registerPreprocessor=function(t,p,v,s,o,S){if(typeof o!=="boolean"){S=o;o=false;}if(p){q.sap.log.debug("Register "+(o?"onDemand-":"")+"preprocessor for \""+t+"\""+(s?" with syncSupport":""),this.getMetadata().getName());if(!V._mPreprocessors[v]){V._mPreprocessors[v]={};}else if(!V._mPreprocessors[v][t]){V._mPreprocessors[v][t]={};}V._mPreprocessors[v][t]={preprocessor:p,onDemand:o,syncSupport:s,settings:S};}else{q.sap.log.error("Registration for \""+t+"\" failed, no preprocessor specified",this.getMetadata().getName());}};sap.ui.view=function(i,v,t){var b=null,o={};if(typeof i==="object"||typeof i==="string"&&v===undefined){v=i;i=undefined;}if(v){if(typeof v==="string"){o.viewName=v;}else{o=v;}}if(i){o.id=i;}if(t){o.type=t;}var d=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(d){var e=d.getViewReplacement(o.viewName,M._sOwnerId);if(e){q.sap.log.info("Customizing: View replacement for view '"+o.viewName+"' found and applied: "+e.viewName+" (type: "+e.type+")");q.extend(o,e);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+o.viewName+"'.");}}if(!o.type){throw new Error("No view type specified.");}else if(o.type===sap.ui.core.mvc.ViewType.JS){b=new sap.ui.core.mvc.JSView(o);}else if(o.type===sap.ui.core.mvc.ViewType.JSON){b=new sap.ui.core.mvc.JSONView(o);}else if(o.type===sap.ui.core.mvc.ViewType.XML){b=new sap.ui.core.mvc.XMLView(o);}else if(o.type===sap.ui.core.mvc.ViewType.HTML){b=new sap.ui.core.mvc.HTMLView(o);}else if(o.type===sap.ui.core.mvc.ViewType.Template){b=new sap.ui.core.mvc.TemplateView(o);}else{throw new Error("Unknown view type "+o.type+" specified.");}return b;};V.prototype.loaded=function(){if(!this._oAsyncState){return Promise.resolve(this);}else{return this._oAsyncState.promise;}};V._resolveEventHandler=function(n,o){var h;if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){switch(n.indexOf('.')){case 0:h=o&&q.sap.getObject(n.slice(1),undefined,o);break;case-1:h=o&&o[n];if(h!=null){break;}default:h=q.sap.getObject(n);}}else{h=function(){};}if(typeof h==="function"){h._sapui_handlerName=n;return[h,o];}};return V;});
