/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Title','./Text','./Button','sap/ui/core/InvisibleText','./Link','sap/ui/core/Icon','./Image','./OverflowToolbar'],function(q,l,C,L,T,a,B,I,b,c,d,O){'use strict';var N=L.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_headerTitle:{type:'sap.m.Title',multiple:false,visibility:'hidden'},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});N.prototype.init=function(){this._closeButton=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),press:function(){this.close();}.bind(this)});this._collapseButton=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_overflowToolbar',new O());};N.prototype.setTitle=function(t){var r=this.setProperty('title',t,true);this._getHeaderTitle().setText(t);return r;};N.prototype.setDatetime=function(f){var r=this.setProperty('datetime',f,true);this._getDateTimeText().setText(f);return r;};N.prototype.setCollapsed=function(f){this._toggleCollapsed();return this.setProperty('collapsed',f,true);};N.prototype.setAuthorName=function(f){var r=this.setProperty('authorName',f,true);this._getAuthorName().setText(f);return r;};N.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=sap.ui.core.Priority.None;if(n){n.forEach(function(f){p=e(p,f.getPriority());});}else{p=this.getProperty('priority');}return p;};N.prototype.getUnread=function(){var n=this.getAggregation('items');if(n){return n.some(function(f){return f.getUnread();});}return this.getProperty('unread');};N.prototype.onBeforeRendering=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var f=r.getText('NOTIFICATION_LIST_GROUP_EXPAND');var g=r.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this._collapseButton.setText(this.getCollapsed()?f:g);};N.prototype.close=function(){var p=this.getParent();this.fireClose();p&&p instanceof sap.ui.core.Element&&p.focus();this.destroy();};N.prototype._getHeaderTitle=function(){var t=this.getAggregation('_headerTitle');if(!t){t=new sap.m.Title({id:this.getId()+'-title',text:this.getTitle()});this.setAggregation('_headerTitle',t);}if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};N.prototype._getDateTimeText=function(){var f=this.getAggregation('_dateTime');if(!f){f=new sap.m.Text({text:this.getDatetime(),textAlign:'End'}).addStyleClass('sapMNLG-Datetime');this.setAggregation('_dateTime',f,true);}return f;};N.prototype._getAuthorName=function(){var f=this.getAggregation('_authorName');if(!f){f=new a({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',f,true);}return f;};N.prototype._getAuthorImage=function(){var f=this.getAggregation('_authorImage');if(!f){var g=this.getAuthorPicture();var h=this.getAuthorName();if(i(g)){f=new c({src:g,alt:h});}else{f=new d({src:g,alt:h});}this.setAggregation('_authorImage',f,true);}return f;};N.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var f=r.getText('NOTIFICATION_LIST_GROUP_EXPAND');var g=r.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this._collapseButton.setText(n?f:g,true);this.$().toggleClass('sapMNLG-Collapsed',n);};N.prototype.bindAggregation=function(f,g){if(f=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',g);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,f,g);}};N.prototype.validateAggregation=function(f,o,m){if(f=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,f,o,m);}};N.prototype.setAggregation=function(f,o,s){if(f=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,f,o,s);}};N.prototype.getAggregation=function(f,g){if(f=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(h){return h instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,f,g);}};N.prototype.indexOfAggregation=function(f,o){if(f=='buttons'){this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);return this;}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,f,o);}};N.prototype.insertAggregation=function(f,o,g,s){if(f=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,g,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,g,s);}};N.prototype.addAggregation=function(f,o,s){if(f=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,f,o,s);}};N.prototype.removeAggregation=function(f,o,s){if(f=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,f,o,s);}};N.prototype.removeAllAggregation=function(f,s){if(f=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,f,s);}};N.prototype.destroyAggregation=function(f,s){if(f=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,f,s);}};N.prototype.getBinding=function(f){if(f=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,f);}};N.prototype.getBindingInfo=function(f){if(f=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,f);}};N.prototype.getBindingPath=function(f){if(f=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,f);}};N.prototype.clone=function(){var f=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');f.setAggregation("_overflowToolbar",o.clone(),true);return f;};function e(f,s){if(f==s){return f;}if((f=='None')){return s;}if((f=='Low')&&(s!='None')){return s;}if((f=='Medium')&&(s!='None'&&s!='Low')){return s;}return f;}function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}return N;},true);
