/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";var b=a.extend("sap.m.P13nFilterPanel",{metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{}}},renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMFilterPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMFilterPanelContent");r.addClass("sapMFilterPanelBG");r.writeClasses();r.write(">");var d=c.getAggregation("content");var L=d.length;for(var i=0;i<L;i++){r.renderControl(d[i]);}r.write("</div>");r.write("</section>");}});b.prototype.setConditions=function(c){var I=[];var e=[];if(c.length){for(var i=0;i<c.length;i++){var o=c[i];if(!o.exclude){I.push(o);}else{e.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(e);if(e.length>0){this._oExcludePanel.setExpanded(true);}};b.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var e=this._oExcludeFilterPanel.getConditions();return i.concat(e);};b.prototype.setContainerQuery=function(c){this.setProperty("containerQuery",c);this._oIncludeFilterPanel.setContainerQuery(c);this._oExcludeFilterPanel.setContainerQuery(c);};b.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);};b.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};b.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};b.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};b.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};b.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};b.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};b.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};b.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};b.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};b.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields);}};b.prototype.getKeyFields=function(){return this._aKeyFields;};b.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();};b.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();};b.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes(),10);var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes(),10);if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};b.prototype.init=function(){this.setType(sap.m.P13nPanelType.filter);sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};if(!this._aIncludeOperations["default"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE]);}if(!this._aIncludeOperations["string"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"string");}if(!this._aIncludeOperations["date"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"date");}if(!this._aIncludeOperations["time"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"time");}if(!this._aIncludeOperations["numeric"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numeric");}if(!this._aIncludeOperations["boolean"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ],"boolean");}this._aExcludeOperations={};if(!this._aExcludeOperations["default"]){this.setExcludeOperations([sap.m.P13nConditionOperation.EQ]);}this._oIncludePanel=new sap.m.Panel({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new sap.m.Panel({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};b.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aIncludeOperations=d(this._aIncludeOperations);this._aExcludeOperations=d(this._aExcludeOperations);this._oRb=d(this._oRb);};b.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i),maxLength:g("maxLength",o,i),type:g("type",o,i),precision:g("precision",o,i),scale:g("scale",o,i),isDefault:g("isDefault",o,i),values:g("values",o,i)});var n=k.length;if(k[n-1].maxLength===1||k[n-1].maxLength==="1"){k[n-1].operations=[sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE];}});this.setKeyFields(k);var c=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(f){var o=f.getBindingContext(m);if(f.getBinding("key")&&o){o.getObject()[f.getBinding("key").getPath()]=f.getKey();}c.push({key:f.getKey(),keyField:g("columnKey",o,f),operation:g("operation",o,f),value1:g("value1",o,f),value2:g("value2",o,f),exclude:g("exclude",o,f)});});this.setConditions(c);}};b.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};b.prototype.removeItem=function(i){a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;};b.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};b.prototype.addFilterItem=function(f){this.addAggregation("filterItems",f);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};b.prototype.insertFilterItem=function(f,i){this.insertAggregation("filterItems",f,i);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};b.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};b.prototype.removeFilterItem=function(f){f=this.removeAggregation("filterItems",f);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};b.prototype.removeAllFilterItems=function(){var f=this.removeAllAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};b.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};b.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var c=e.getParameter("index");var f;var I=-1;var E=e.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(d,i){if((!d.getExclude()&&!E)||(d.getExclude()&&E)){c--;}I=i;return c<0;},this);if(o==="update"){f=t.getFilterItems()[I];if(f){f.setExclude(n.exclude);f.setColumnKey(n.keyField);f.setOperation(n.operation);f.setValue1(n.value1);f.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:f});}if(o==="add"){if(c>=0){I++;}f=new sap.m.P13nFilterItem({key:k,columnKey:n.keyField,exclude:n.exclude,operation:n.operation,value1:n.value1,value2:n.value2});t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:f});t._bIgnoreBindCalls=false;}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t._bIgnoreBindCalls=false;}};};return b;},true);
