/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/IntervalTrigger','./Overlay','./library'],function(q,I,O,l){"use strict";var a=O.extend("sap.ui.ux3.OverlayDialog",{metadata:{library:"sap.ui.ux3",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});a.prototype.init=function(){O.prototype.init.apply(this);this.setProperty("openButtonVisible",false);a.Trigger=new I(300);};a.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}q.sap.focus(f);};a.prototype._setFocusFirst=function(){if(this.getCloseButtonVisible()){q.sap.focus(this.getDomRef("close"));}else{q.sap.focus(this.$("content").firstFocusableDomRef());}};a.prototype.setOpenButtonVisible=function(v){q.sap.log.warning("OverlayDialog does not support an openButton.");return undefined;};a.prototype.setWidth=function(w){if(w=="auto"||w=="inherit"){w="auto";}return this.setProperty("width",w);};a.prototype.setHeight=function(h){if(h=="auto"||h=="inherit"){h="auto";}return this.setProperty("height",h);};a.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);this._cleanup();};a.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);a.Trigger.addListener(this._checkChange,this);};a.prototype._cleanup=function(){a.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null;};a.prototype.exit=function(){this._cleanup();O.prototype.exit.apply(this,arguments);};a.prototype._checkChange=function(){if(!this.getDomRef()){return;}var $=this.$("content"),b=this.$(),A=this.getWidth()==="auto",c=this.getHeight()==="auto";var d=A?b.width()/2:$.width(),e=c?b.height()/2:$.height(),o=b.width(),f=b.height();if(d!=this.contentWidth||e!=this.contentHeight||o!=this.overlayWidth||f!=this.overlayHeight){$.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=A?b.width()/2:$.width();this.contentHeight=c?b.height()/2:$.height();this.overlayWidth=o;this.overlayHeight=f;var g=this.$("close");if(this.contentWidth<this.overlayWidth){$.css("left","50%");$.css("right","auto");$.css("margin-left",(-1)*this.contentWidth/2+"px");$.css("width",c?this.contentWidth:this.getWidth());g.css("right","50%");g.css("margin-right",(-1)*this.contentWidth/2-10+"px");}else{$.css("left","0");$.css("right","10px");$.css("margin-left","0");$.css("width","auto");g.css("right","0");g.css("margin-right","0");}if(this.contentHeight<this.overlayHeight-30){$.css("top","50%");$.css("bottom","auto");$.css("margin-top",(-1)*this.contentHeight/2+"px");$.css("height",c?this.contentHeight:this.getHeight());g.css("top","50%");g.css("margin-top",(-1)*this.contentHeight/2-10+"px");}else{$.css("top","10px");$.css("bottom","30px");$.css("margin-top","0");$.css("height","auto");g.css("top","0");g.css("margin-top","0");}}};return a;},true);
