/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Manifest','./ComponentMetadata','./Core','sap/ui/thirdparty/URI'],function(q,M,a,C,b,U){"use strict";function c(u,o){['sap-client','sap-server'].forEach(function(n){var v=u.get(n);if(v&&!o.hasSearch(n)){o.addSearch(n,v);}});}function d(D,m,s,S){if(s){for(var n in D){if(!m[n]&&s[n]&&s[n].uri){m[n]=S;}}}}var f=M.extend("sap.ui.core.Component",{constructor:function(i,s){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){s=i;i=undefined;}if(s&&typeof s._manifest==="object"){var o=this.getMetadata();this._oManifest=s._manifest;delete s._manifest;var g=function(){};g.prototype=q.sap.newObject(Object.getPrototypeOf(o));this._oMetadataProxy=new g();this._oMetadataProxy._oMetadata=o;for(var m in o){if(!/^(getManifest|getManifestEntry)$/.test(m)&&typeof o[m]==="function"){this._oMetadataProxy[m]=o[m].bind(o);}}this._oMetadataProxy.getManifest=this.getManifest.bind(this);this._oMetadataProxy.getManifestEntry=this.getManifestEntry.bind(this);this._oMetadataProxy.getMetadataVersion=function(){return 2;};this.getMetadata=function(){return this._oMetadataProxy;};}M.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:true},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);f.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};f.prototype.getManifestEntry=function(k){return this._getManifestEntry(k);};f.prototype._getManifestEntry=function(k,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(k,m);}else{var D=this._oManifest.getEntry(k);if(D!==undefined&&!q.isPlainObject(D)){return D;}var p,P;if(m&&(p=this.getMetadata().getParent())instanceof C){P=p.getManifestEntry(k,m);}if(P||D){D=q.extend(true,{},P,D);}return D;}};f.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};f.activateCustomizing=function(s){};f.deactivateCustomizing=function(s){};f.getOwnerIdFor=function(o){var O=(o instanceof M)&&o._sOwnerId;return O||undefined;};f.getOwnerComponentFor=function(o){var O=f.getOwnerIdFor(o);return O&&sap.ui.component(O);};f.prototype.runAsOwner=function(e){var o=M._sOwnerId;try{M._sOwnerId=this.getId();return e.call();}finally{M._sOwnerId=o;}};f.prototype.getInterface=function(){return this;};f.prototype._initCompositeSupport=function(s){if(this._oManifest){var m=this.getManifest();var u=m&&m["sap.ui5"];var e=u&&u["extends"];var E=e&&e["extensions"];if(E){q.sap.require("sap.ui.core.CustomizingConfiguration");var g=sap.ui.require('sap/ui/core/CustomizingConfiguration');g.activateForComponentInstance(this);}}this._mManifestModels={};this.getMetadata().onInitComponent();this.oComponentData=s&&s.componentData;this.getMetadata().init();this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(o){var h=o.originalEvent;this.onWindowError(h.message,h.filename,h.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};f.prototype.destroy=function(){if(typeof this._mManifestModels==='object'){for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}this._mManifestModels=null;}if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}M.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(this._oManifest){var e=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(e){e.deactivateForComponentInstance(this);}}this.getMetadata().onExitComponent();};f.prototype.getComponentData=function(){return this.oComponentData;};f.prototype.getEventBus=function(){if(!this._oEventBus){q.sap.require("sap.ui.core.EventBus");this._oEventBus=new sap.ui.core.EventBus();}return this._oEventBus;};f.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var o=this._getManifestEntry("/sap.app/dataSources",true)||{};var e=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(e,o);};f.prototype._initComponentModels=function(m,D){if(!m){return;}var e={models:m,dataSources:D||{},origin:{dataSources:{},models:{}}};var o=this.getMetadata();while(o&&o instanceof C){var g=o.getManifestEntry("/sap.app/dataSources");d(e.dataSources,e.origin.dataSources,g,o);var h=o.getManifestEntry("/sap.ui5/models");d(e.models,e.origin.models,h,o);o=o.getParent();}var u=q.sap.getUriParameters();for(var s in e.models){var j=e.models[s];var I=false;if(typeof j==='string'){j={dataSource:j};}if(j.dataSource){var k=e.dataSources&&e.dataSources[j.dataSource];if(typeof k==='object'){if(k.type===undefined){k.type='OData';}if(!j.type){switch(k.type){case'OData':j.type='sap.ui.model.odata.v2.ODataModel';break;case'JSON':j.type='sap.ui.model.json.JSONModel';break;case'XML':j.type='sap.ui.model.xml.XMLModel';break;default:}}if(!j.uri){j.uri=k.uri;I=true;}if(k.type==='OData'&&k.settings&&typeof k.settings.maxAge==="number"){j.settings=j.settings||{};j.settings.headers=j.settings.headers||{};j.settings.headers["Cache-Control"]="max-age="+k.settings.maxAge;}if(k.type==='OData'&&k.settings&&k.settings.annotations){var A=k.settings.annotations;for(var i=0;i<A.length;i++){var l=e.dataSources[A[i]];if(!l){q.sap.log.error("Component Manifest: ODataAnnotation \""+A[i]+"\" for dataSource \""+j.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",this);continue;}if(l.type!=='ODataAnnotation'){q.sap.log.error("Component Manifest: dataSource \""+A[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+l.type+"\"","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",this);continue;}if(!l.uri){q.sap.log.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+A[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",this);continue;}var n=e.origin.dataSources[A[i]]||this.getMetadata();var p=n.getManifestObject().resolveUri(new U(l.uri)).toString();j.settings=j.settings||{};j.settings.annotationURI=j.settings.annotationURI||[];j.settings.annotationURI.push(p);}}}else{q.sap.log.error("Component Manifest: dataSource \""+j.dataSource+"\" for model \""+s+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+j.dataSource+"\"]",this);}}if(!j.type){q.sap.log.error("Component Manifest: Missing \"type\" for model \""+s+"\"","[\"sap.ui5\"][\"models\"][\""+s+"\"]",this);continue;}try{q.sap.require(j.type);}catch(E){q.sap.log.error("Component Manifest: Class \""+j.type+"\" for model \""+s+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+s+"\"]",this);continue;}var r=q.sap.getObject(j.type);if(!r){q.sap.log.error("Component Manifest: Class \""+j.type+"\" for model \""+s+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+s+"\"]",this);continue;}if(j.type==='sap.ui.model.odata.ODataModel'&&(!j.settings||j.settings.json===undefined)){j.settings=j.settings||{};j.settings.json=true;}if(j.uri){var t=new U(j.uri);var v=(I?e.origin.dataSources[j.dataSource]:e.origin.models[s])||this.getMetadata();t=v.getManifestObject().resolveUri(t);if(j.dataSource){c(u,t);}j.uri=t.toString();}if(j.uriSettingName===undefined){switch(j.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':j.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':j.uriSettingName='bundleUrl';break;default:}}var w=this.getComponentData();var S=w&&w.startupParameters&&w.startupParameters["sap-system"];if(!S){S=u.get("sap-system");}var x=false;var O;if(S&&q.inArray(j.type,["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"])!=-1){x=true;q.sap.require("sap.ui.model.odata.ODataUtils");O=sap.ui.require("sap/ui/model/odata/ODataUtils");}if(j.uri){if(x){j.preOriginBaseUri=j.uri.split("?")[0];j.uri=O.setOrigin(j.uri,{alias:S});j.postOriginBaseUri=j.uri.split("?")[0];}if(j.uriSettingName!==undefined){j.settings=j.settings||{};if(!j.settings[j.uriSettingName]){j.settings[j.uriSettingName]=j.uri;}}else if(j.settings){j.settings=[j.uri,j.settings];}else{j.settings=[j.uri];}}else{if(x&&j.uriSettingName!==undefined&&j.settings&&j.settings[j.uriSettingName]){j.preOriginBaseUri=j.settings[j.uriSettingName].split("?")[0];j.settings[j.uriSettingName]=O.setOrigin(j.settings[j.uriSettingName],{alias:S});j.postOriginUri=j.settings[j.uriSettingName].split("?")[0];}}if(x&&j.settings&&j.settings.annotationURI){var y=[].concat(j.settings.annotationURI);var z=[];for(var i=0;i<y.length;i++){z.push(y[i].replace(j.preOriginBaseUri,j.postOriginBaseUri.split("?")[0]));}j.settings.annotationURI=z;}if(j.settings&&!q.isArray(j.settings)){j.settings=[j.settings];}var B=[null].concat(j.settings||[]);var F=r.bind.apply(r,B);var G=new F();this._mManifestModels[s]=G;this.setModel(G,s||undefined);}};sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}if(typeof v==='string'){return sap.ui.getCore().getComponent(v);}function e(o){var n=v.name,i=v.id,h=v.componentData,s=n+'.Component',S=v.settings;var I=new o(q.extend({},S,{id:i,componentData:h,_manifest:v._manifest}));q.sap.log.info("Component instance Id = "+I.getId());var H=I.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(I.getMetadata().handleValidation()!==undefined){H=I.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(I,H);}return I;}var g=sap.ui.component.load(v,true);if(v.async){return g.then(e);}else{return e(g);}};sap.ui.component.load=function(o,F){var n=o.name,u=o.url,g=sap.ui.getCore().getConfiguration(),h=/^(sync|async)$/.test(g.getComponentPreload()),m=typeof o.manifestFirst!=="undefined"?o.manifestFirst:g.getManifestFirst(),j;if(o.manifestUrl){j=a.load({manifestUrl:o.manifestUrl,componentName:n,async:o.async});o._manifest=j;}if(j&&!o.async){n=j.getComponentName();}if(!(j&&o.async)){if(!n){throw new Error("The name of the component is undefined.");}if(u){q.sap.registerModulePath(n,u);}}if(m&&!j){j=a.load({manifestUrl:q.sap.getModulePath(n)+"/manifest.json",componentName:n,async:o.async,failOnError:false});o._manifest=j;}function k(){var e=n+'.Component';q.sap.require(e);var i=q.sap.getObject(e);if(!i){var v="The specified component controller '"+e+"' could not be found!";if(F){throw new Error(v);}else{q.sap.log.warning(v);}}return i;}function p(O,i){if(typeof O==='object'){if(O.url){q.sap.registerModulePath(O.name,O.url);}return(O.lazy&&i!==true)?undefined:O.name;}return O;}function l(i,A){var v=i+'.Component',P;if(h&&i!=null&&!q.sap.isDeclared(v,true)){if(A){P=q.sap.getResourceName(v,'-preload.js');return q.sap._loadJSResourceAsync(P,true);}try{P=v+'-preload';q.sap.require(P);}catch(e){q.sap.log.warning("couldn't preload component from "+P+": "+((e&&e.message)||e));}}}function r(e,j,A){var P=[];var i=A?function(B){P.push(B);}:q.noop;j.defineResourceRoots();var L=j.getEntry("/sap.ui5/dependencies/libs");if(L){var v=[];for(var y in L){if(!L[y].lazy){v.push(y);}}if(v.length>0){q.sap.log.info("Component \""+e+"\" is loading libraries: \""+v.join(", ")+"\"");i(sap.ui.getCore().loadLibraries(v,{async:A}));}}var E=j.getEntry("/sap.ui5/extends/component");if(E){i(l(E,A));}var z=j.getEntry("/sap.ui5/dependencies/components");if(z){for(var e in z){if(!z[e].lazy){i(l(e,A));}}}return A?Promise.all(P):undefined;}if(o.async){var s=o.asyncHints||{},t=[],w=function(P){if(P){t.push(P);}},x=function($){return $;};if(s.preloadBundles){q.each(s.preloadBundles,function(i,B){w(q.sap._loadJSResourceAsync(p(B,true),true));});}if(s.libs){w(sap.ui.getCore().loadLibraries(s.libs.map(p).filter(x)));}if(!j){w(l(n,true));}else{w(j.then(function(j){o._manifest=j;return l(j.getComponentName(),true);}));}if(s.components){q.each(s.components,function(i,v){w(l(p(v),true));});}return Promise.all(t).then(function(v){q.sap.log.debug("Component.load: all promises fulfilled, then "+v);if(j){return j.then(function(j){n=j.getComponentName();return r(n,j,true);});}else{return v;}}).then(function(){return s.preloadOnly?true:k();});}if(j){r(n,j);}l(n);return k();};return f;});
