/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,U,c,d,e,f,g,h,k,l,m,o){"use strict";var p=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(s,P){M.apply(this,arguments);var u,i,H,t,w,j,n,r,A,L,D,v,x,y,S,z,E,J,F,G,I,K,N,Q=this;if(typeof(s)==="object"){P=s;s=P.serviceUrl;}if(P){u=P.user;i=P.password;H=P.headers;t=P.tokenHandling;w=P.withCredentials;j=P.maxDataServiceVersion;n=P.useBatch;r=P.refreshAfterChange;A=P.annotationURI;L=P.loadAnnotationsJoined;v=P.defaultBindingMode;D=P.defaultCountMode;x=P.defaultOperationMode;y=P.metadataNamespaces;S=P.serviceUrlParams;z=P.metadataUrlParams;J=P.json;F=P.messageParser;G=P.skipMetadataAnnotationParsing;I=P.defaultUpdateMethod;K=P.disableHeadRequestForToken;N=P.sequentializeRequests;}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.sDefaultBindingMode=v||B.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=I||U.Merge;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=n!==false;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=j;this.bLoadMetadataAsync=true;this.bLoadAnnotationsJoined=L!==false;this.sAnnotationURI=A;this.sDefaultCountMode=D||b.Request;this.sDefaultOperationMode=x||c.Server;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=G;this.bDisableHeadRequestForToken=!!K;this.bSequentializeRequests=!!N;if(F){F.setProcessor(this);}this.oMessageParser=F;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=s;var R=s.split("?");if(R.length>1){this.sServiceUrl=R[0];if(R[1]){this.aUrlParams.push(R[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=i;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);E=a._createUrlParamsArray(z);var T=this._createRequestUrl("/$metadata",undefined,E);this.oServiceData=p.mServiceData[T];if(!this.oServiceData){p.mServiceData[T]={};this.oServiceData=p.mServiceData[T];}if(!this.oServiceData.oMetadata){this.oMetadata=new f(T,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:y,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata;}else{this.oMetadata=this.oServiceData.oMetadata;}this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var V=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(W,X){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(X["metadataString"],W);}.bind(this,!!this.sAnnotationURI));}if(this.sAnnotationURI){this.pAnnotationsLoaded=this.pAnnotationsLoaded.then(V.addUrl.bind(V,this.sAnnotationURI));}}if(S){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(S));}this.onMetadataLoaded=function(W){Q._initializeMetadata();};this.onMetadataFailed=function(W){Q.fireMetadataFailed(W.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});p.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};p.prototype.attachBatchRequestFailed=function(D,F,L){this.attachEvent("batchRequestFailed",D,F,L);return this;};p.prototype.detachBatchRequestFailed=function(F,L){this.detachEvent("batchRequestFailed",F,L);return this;};p.prototype.fireBatchRequestFailed=function(A){this.fireEvent("batchRequestFailed",A);return this;};p.prototype.attachBatchRequestSent=function(D,F,L){this.attachEvent("batchRequestSent",D,F,L);return this;};p.prototype.detachBatchRequestSent=function(F,L){this.detachEvent("batchRequestSent",F,L);return this;};p.prototype.fireBatchRequestSent=function(A){this.fireEvent("batchRequestSent",A);return this;};p.prototype.attachBatchRequestCompleted=function(D,F,L){this.attachEvent("batchRequestCompleted",D,F,L);return this;};p.prototype.detachBatchRequestCompleted=function(F,L){this.detachEvent("batchRequestCompleted",F,L);return this;};p.prototype.fireBatchRequestCompleted=function(A){this.fireEvent("batchRequestCompleted",A);return this;};p.mServiceData={};p.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this;};p.prototype.attachRejectChange=function(D,F,L){this.attachEvent("rejectChange",D,F,L);return this;};p.prototype.detachRejectChange=function(F,L){this.detachEvent("rejectChange",F,L);return this;};p.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(I,j){if(j){t.metadataLoadEvent=q.sap.delayedCall(0,t,i,[t.bLoadMetadataAsync]);}else{if(I){t.initialize();}t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug(t+" - metadataloaded fired");}};if(this.bLoadMetadataAsync&&this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&this.oAnnotations.bInitialized){i(true);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(this.bLoadMetadataAsync,D);}};p.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};p.prototype.fireAnnotationsLoaded=function(A){this.fireEvent("annotationsLoaded",A);return this;};p.prototype.attachAnnotationsLoaded=function(D,F,L){this.attachEvent("annotationsLoaded",D,F,L);return this;};p.prototype.detachAnnotationsLoaded=function(F,L){this.detachEvent("annotationsLoaded",F,L);return this;};p.prototype.fireAnnotationsFailed=function(A){this.fireEvent("annotationsFailed",A);q.sap.log.debug(this+" - annotationsfailed fired");return this;};p.prototype.attachAnnotationsFailed=function(D,F,L){this.attachEvent("annotationsFailed",D,F,L);return this;};p.prototype.detachAnnotationsFailed=function(F,L){this.detachEvent("annotationsFailed",F,L);return this;};p.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};p.prototype.attachMetadataLoaded=function(D,F,L){this.attachEvent("metadataLoaded",D,F,L);return this;};p.prototype.detachMetadataLoaded=function(F,L){this.detachEvent("metadataLoaded",F,L);return this;};p.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};p.prototype.attachMetadataFailed=function(D,F,L){this.attachEvent("metadataFailed",D,F,L);return this;};p.prototype.detachMetadataFailed=function(F,L){this.detachEvent("metadataFailed",F,L);return this;};p.prototype._createEventInfo=function(r,R,n){var E={};E.url=r.requestUri;E.method=r.method;E.async=r.async;E.headers=r.headers;if(n){E.requests=[];for(var i=0;i<n.length;i++){var s={};if(q.isArray(n[i])){var t=n[i];for(var j=0;j<t.length;j++){var r=t[j].request;var I=n[i][j].response;s={};s.url=r.requestUri;s.method=r.method;s.headers=r.headers;if(I){s.response={};if(r._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}else{var r=n[i].request;var I=n[i].response;s.url=r.requestUri;s.method=r.method;s.headers=r.headers;if(I){s.response={};if(r._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}}if(R){E.response={};E.success=true;if(R.message){E.response.message=R.message;E.success=false;}if(R.response){R=R.response;}if(R&&R.statusCode!=undefined){E.response.headers=R.headers;E.response.statusCode=R.statusCode;E.response.statusText=R.statusText;E.response.responseText=R.body!==undefined?R.body:R.responseText;}}E.ID=r.requestID;return E;};p.prototype._createRequestID=function(){var r;r=q.sap.uid();return r;};p.prototype._createRequestUrl=function(P,i,u,j){var n,A=[],s="";n=this._normalizePath(P,i);if(!j){s=this.sServiceUrl+n;}else{s=n.substr(n.indexOf('/')+1);}if(this.aUrlParams){A=A.concat(this.aUrlParams);}if(u){A=A.concat(u);}if(A&&A.length>0){s+="?"+A.join("&");}return s;};p.prototype._importData=function(D,j){var t=this,L,K,r,E;if(D.results){L=[];q.each(D.results,function(i,s){var K=t._importData(s,j);if(K){L.push(K);}});return L;}else{K=this._getKey(D);if(!K){return K;}E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){r=t._importData(P,j);if(q.isArray(r)){E[N]={__list:r};}else{E[N]={__ref:r};}}else if(!P||!P.__deferred){E[N]=P;}});var n={};n[K]=E;this._updateChangedEntities(n);j[K]=true;return K;}};p.prototype._removeReferences=function(D){var t=this,L;if(!D){return D;}if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._removeReferences(j));});return L;}else{q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};p.prototype._restoreReferences=function(D){var t=this,L,r=[];if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._restoreReferences(j));});return L;}else{q.each(D,function(P,i){if(i&&i["__ref"]){var n=t._getObject("/"+i["__ref"]);if(n){delete i["__ref"];D[P]=n;t._restoreReferences(n);}}else if(i&&i["__list"]){q.each(i["__list"],function(j,E){var n=t._getObject("/"+i["__list"][j]);if(n){r.push(n);t._restoreReferences(n);}});delete i["__list"];i.results=r;r=[];}});return D;}};p.prototype.removeData=function(){this.oData={};};p.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,j){j.initialize();});};p.prototype.refresh=function(F,r,G){if(typeof F==="string"){G=F;F=false;r=false;}if(r){this.removeData();}this._refresh(F,G);};p.prototype._refresh=function(F,G,i,E){var j=this.aBindings.slice(0);this.sRefreshGroupId=G;q.each(j,function(I,n){n._refresh(F,i,E);});this.sRefreshGroupId=undefined;};p.prototype.checkUpdate=function(F,A,j,n){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,j);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var r=this.aBindings.slice(0);q.each(r,function(I,t){if(!n||this.isMetaModelPath(t.getPath())){t.checkUpdate(F,j);}}.bind(this));var s=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<s.length;i++){s[i]();}};p.prototype.checkDataState=function(L){var i=this.aBindings.slice(0);q.each(i,function(I,j){if(j.checkDataState){j.checkDataState(L);}});};p.prototype.bindProperty=function(P,i,j){var n=new g(this,P,i,j);return n;};p.prototype.bindList=function(P,i,s,F,j){var n=new e(this,P,i,s,F,j);return n;};p.prototype.bindTree=function(P,i,F,j,s){var n=new h(this,P,i,F,j,s);return n;};p.prototype.createBindingContext=function(P,i,j,n,r){var R=this.resolve(P,i),s,N,G,t=this;if(typeof i=="function"){r=j;n=i;j=undefined;i=undefined;}if(typeof j=="function"){r=n;n=j;j=undefined;}if(!R){if(n){n(null);}return null;}if(r===undefined){r=this._isReloadNeeded(R,j);}if(!r){s=this.resolve(P,i,true);N=this.getContext(s);if(n){n(N);}return N;}if(n){var I=!q.sap.startsWith(P,"/");if(R){var u=[],v=this.createCustomParams(j);if(v){u.push(v);}if(j&&(j.batchGroupId||j.groupId)){G=j.groupId||j.batchGroupId;}var w=function(D){var K=D?t._getKey(D):undefined;if(K&&i&&I){var y=i.getPath();y=y.substr(1);if(t.oData[y]){t.oData[y][P]={__ref:K};}}N=t.getContext('/'+K);n(N);};var x=function(E){if(E.statusCode=='404'&&i&&I){var y=i.getPath();y=y.substr(1);if(t.oData[y]){t.oData[y][P]={__ref:null};}}n(null);};this.read(R,{groupId:G,urlParameters:u,success:w,error:x});}else{n(null);}}};p.prototype._isReloadNeeded=function(P,n){var r=this.oMetadata,D=this.oData,E=this.oMetadata._getEntityTypeByPath(P),s=this.getObject(P),t=[],S=[];function u(i){return i.filter(function(j){return j.indexOf("/")===-1;});}function v(i,j){var N=j+"/";return i.filter(function(x){return x.indexOf(N)===0;}).map(function(x){return x.substr(N.length);});}function w(E,s,S,t){var x,y,N,z,A,F,G,H,I;if(!E){return false;}if(s===null){return false;}if(!s){return true;}x=u(S);if(x.length===0){x=E.property.map(function(J){return J.name;});}for(var i=0;i<x.length;i++){I=x[i];if(!s.hasOwnProperty(I)){return true;}}y=u(t);for(var i=0;i<y.length;i++){var H=y[i];if(!s.hasOwnProperty(H)){return true;}N=s[H];if(!N){continue;}if(N.__deferred){return true;}z=r._getEntityTypeByNavProperty(E,H);F=v(S,H);G=v(t,H);if(N.__ref){A=D[N.__ref];if(w(z,A,F,G)){return true;}}if(N.__list){for(var j=0;j<N.__list.length;j++){A=D[N.__list[j]];if(w(z,A,F,G)){return true;}}}}return false;}if(n){if(n.select){S=n.select.replace(/\s/g,"").split(',');}if(n.expand){t=n.expand.replace(/\s/g,"").split(',');}}return w(E,s,S,t);};p.prototype.createCustomParams=function(P){var i=[],j,s={expand:true,select:true};for(var n in P){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};p.prototype.bindContext=function(P,i,j){var n=new d(this,P,i,j);return n;};p.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};p.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};p.prototype._getKey=function(v){var K,u;if(v instanceof C){K=v.getPath().substr(1);}else if(v&&v.__metadata&&v.__metadata.uri){u=v.__metadata.uri;K=u.substr(u.lastIndexOf("/")+1);}else if(typeof v==='string'){K=v.substr(v.lastIndexOf("/")+1);}return K;};p.prototype.getKey=function(v){return this._getKey(v);};p.prototype.createKey=function(s,K){var E=this.oMetadata._getEntityTypeByPath(s),j=s,t=this,n,P;j+="(";if(E.key.propertyRef.length===1){n=E.key.propertyRef[0].name;P=this.oMetadata._getPropertyMetadata(E,n);j+=a.formatValue(K[n],P.type);}else{q.each(E.key.propertyRef,function(i,r){if(i>0){j+=",";}n=r.name;P=t.oMetadata._getPropertyMetadata(E,n);j+=n;j+="=";j+=a.formatValue(K[n],P.type);});}j+=")";return j;};p.prototype.getProperty=function(P,i,I){var v=this._getObject(P,i);if(!I){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(I===true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};p.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,r,s,R=this.resolve(P,i),S,D,t,u,K,v;if(this.oMetadata&&this.oMetadata.isLoaded()&&R&&R.indexOf('/#')>-1){if(this.isMetaModelPath(R)){S=R.indexOf('/##');v=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);t=R.substr(S+3);u=v.getMetaContext(D);n=v.getProperty(t,u);}else{n=this.oMetadata._getAnnotation(R);}}else{if(!R){return n;}var w=R.split("/"),I=0;K=w[1];w.splice(0,2);r=this.mChangedEntities[K];s=this.oData[K];if(!j){n=!K?this.oData:r||s;}else{n=!K?this.oData:s;}while(n&&w[I]){var H=r&&r.hasOwnProperty(w[I]);r=r&&r[w[I]];s=s&&s[w[I]];n=j||!H?s:r;if(n){if(n.__ref){r=this.mChangedEntities[n.__ref];s=this.oData[n.__ref];n=j?s:r||s;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}if(q.isPlainObject(r)&&this._getKey(r)){n=j?s:q.sap.extend(true,{},s,r);}return n;};p.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};p.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};p.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};p.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(r,i){this.refreshSecurityToken(function(){r(this.oServiceData.securityToken);}.bind(this),function(){i();},true);}.bind(this));}}return this.pSecurityToken;};p.prototype.refreshSecurityToken=function(s,E,A){var t;var i=this;var u=this._createRequestUrl("/");var T={abort:function(){this.request.abort();}};function _(D,R){if(R){t=i._getHeader("x-csrf-token",R.headers);if(t){i.oServiceData.securityToken=t;i.pSecurityToken=Promise.resolve(t);i.oHeaders["x-csrf-token"]=t;}else{i.resetSecurityToken();i.bTokenHandling=false;}}if(s){s(D,R);}}function j(v){i.resetSecurityToken();i.bTokenHandling=false;i._handleError(v);if(E){E(v);}}function n(v){T.request=r("GET",j);}function r(R,E){var v=i._createRequest(u,R,i._getHeaders(),null,null,!!A);v.headers["x-csrf-token"]="Fetch";return i._request(v,_,E,undefined,undefined,i.getServiceMetadata());}if(this.bDisableHeadRequestForToken){T.request=r("GET",j);}else{T.request=r("HEAD",n);}return T;};p.prototype._submitRequest=function(r,s,E){var t=this,H,R,A,j,n;j=new Promise(function(i,z){n=i;});function _(D,i){if(s){s(D,i);}n();}function u(i){if(t.bTokenHandling&&i.response){var T=t._getHeader("x-csrf-token",i.response.headers);if(!r.bTokenReset&&i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();r.bTokenReset=true;w();return;}}if(E){E(i);}n();}function v(r){if(t.bTokenHandling&&r.method!=="GET"){t.pReadyForRequest=t.securityTokenAvailable();}return t.pReadyForRequest;}function w(){v(r).then(function(T){if(t.bTokenHandling){r.headers["x-csrf-token"]=T;}y();},function(){y();});}var x=function(T,r,z){var D,F=r.eventInfo.requests;if(F){q.each(F,function(i,r){if(q.isArray(r)){q.each(r,function(i,r){D=t._createEventInfo(r.request,z);t["fireRequest"+T](D);});}else{D=t._createEventInfo(r.request,z);t["fireRequest"+T](D);}});D=t._createEventInfo(r,z,F);t["fireBatchRequest"+T](D);}else{D=t._createEventInfo(r,z,F);t["fireRequest"+T](D);}};function y(){R=t._request(r,_,u,H,undefined,t.getServiceMetadata());if(r.eventInfo){x("Sent",r,null);delete r.eventInfo;}if(A){R.abort();}}H=t._getODataHandler(r.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){w();});this.pSequentialRequestCompleted=j;}else{w();}return{abort:function(){if(R){R.abort();}A=true;}};};p.prototype._submitSingleRequest=function(r,s,E){var t=this,R,i={},G={},j={};var n=function(D,v){if(D===undefined&&v.statusCode===200){u({message:"Response did not contain a valid OData result",response:v});return;}var S=function(D,v){if(s){s(D,v);}if(r.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,G);if(t._isRefreshNeeded(r,v)){t._refresh(false,undefined,i,j);}}};t._processSuccess(r,v,S,G,i,j);};var u=function(v){if(v.message=="Request aborted"){t._processAborted(r,v,E);}else{t._processError(r,v,E);}};r.eventInfo={};R=this._submitRequest(r,n,u);return R;};p.prototype._submitBatchRequest=function(n,r,s,E){var t=this;var u=function(D,w){if(D===undefined&&w.statusCode===200){v({message:"Response did not contain a valid OData batch result",response:w});return;}var x,y,z,A=D.__batchResponses,F,G={},H={},I={};if(A){var i,j;for(i=0;i<A.length;i++){x=A[i];if(q.isArray(r[i])){if(x.message){for(j=0;j<r[i].length;j++){y=r[i][j];if(y.request._aborted){t._processAborted(y.request,x,y.fnError);}else{t._processError(y.request,x,y.fnError);}y.response=x;}}else{z=x.__changeResponses;for(j=0;j<z.length;j++){var J=z[j];y=r[i][j];if(y.request._aborted){t._processAborted(y.request,J,y.fnError);}else if(J.message){t._processError(y.request,J,y.fnError);}else{t._processSuccess(y.request,J,y.fnSuccess,H,G,I);}y.response=J;}}}else{y=r[i];if(y.request._aborted){t._processAborted(y.request,x,y.fnError);}else if(x.message){t._processError(y.request,x,y.fnError);}else{t._processSuccess(y.request,x,y.fnSuccess,H,G,I);}y.response=x;}}t.checkUpdate(false,false,H);}if(s){s(D);}F=t._createEventInfo(n,w,r);t.fireBatchRequestCompleted(F);};var v=function(j){var w,A=R&&R.bAborted;q.each(r,function(i,x){if(q.isArray(x)){q.each(x,function(i,x){if(A){t._processAborted(x.request,j,x.fnError);}else{t._processError(x.request,j,x.fnError);}});}else{if(A){t._processAborted(x.request,j,x.fnError);}else{t._processError(x.request,j,x.fnError);}}});if(E){E(j);}w=t._createEventInfo(n,j,r);t.fireBatchRequestCompleted(w);if(!A){t.fireBatchRequestFailed(w);}};n.eventInfo={requests:r,batch:true};var R=this._submitRequest(n,u,v);return R;};p.prototype._createBatchRequest=function(i){var u,r,j={},P={};P.__batchRequests=i;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(j,this.mCustomHeaders,this.oHeaders);delete j["Content-Type"];r={headers:j,requestUri:u,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};r.withCredentials=this.bWithCredentials;return r;};p.prototype._pushToRequestQueue=function(r,G,s,R,S,E){var i,j=r[G];if(!j){j={};j.map={};j.requests=[];r[G]=j;}if(R.method!=="GET"||R.key){if(!j.changes){j.changes={};}if(R.key&&j.map&&R.key in j.map){var n=j.map[R.key];n.method=R.method;if(R.method==="PUT"){delete n.headers["x-http-method"];}if(n._aborted){delete n._aborted;var t={abort:function(){n._aborted=true;}};this.mChangeHandles[R.key]=t;}if(R.method!=="GET"){n.data=R.data;n.requestUri=R.requestUri;}else{n.requestUri=R.requestUri;delete n.data;}}else{if(R.method!=="GET"){i=j.changes[s];if(!i){i=[];j.changes[s]=i;}R._changeSetId=s;i.push({request:R,fnSuccess:S,fnError:E,changeSetId:s});}else{j.requests.push({request:R,fnSuccess:S,fnError:E});}if(R.key){j.map[R.key]=R;}}}else{j.requests.push({request:R,fnSuccess:S,fnError:E});}};p.prototype._collectChangedEntities=function(G,j,E){var t=this;if(G.changes){q.each(G.changes,function(s,n){for(var i=0;i<n.length;i++){var r=n[i].request,K=r.requestUri.split('?')[0];if(r.method==="POST"||r.method==="DELETE"){var u=t.oMetadata._getEntityTypeByPath("/"+K);if(u){E[u.entityType]=true;}}else{j[K]=true;}}});}};p.prototype._processRequestQueue=function(r,G,s,E){var t=this,P,R=[];if(this.bUseBatch){if(t.bRefreshAfterChange){q.each(r,function(i,j){if(i===G||!G){var n={},u={};t._collectChangedEntities(j,n,u);t.bIncludeInCurrentBatch=true;t._refresh(false,i,n,u);t.bIncludeInCurrentBatch=false;}});}q.each(r,function(j,n){if(j===G||!G){var u=[],v=[],w,x;if(n.changes){q.each(n.changes,function(A,D){w={__changeRequests:[]};x=[];for(var i=0;i<D.length;i++){P='/'+t.getKey(D[i].request.data);t.increaseLaundering(P,D[i].request.data);if(D[i].request._aborted){t._processAborted(D[i].request,null,D[i].fnError);}else{if(D[i].request.data&&D[i].request.data.__metadata){delete D[i].request.data.__metadata.created;}w.__changeRequests.push(D[i].request);x.push(D[i]);delete t.mChangeHandles[D[i].request.key];}}if(w.__changeRequests&&w.__changeRequests.length>0){u.push(w);v.push(x);}});}if(n.requests){var y=n.requests;for(var i=0;i<y.length;i++){if(y[i].request._aborted){t._processAborted(y[i].request,null,y[i].fnError);}else{u.push(y[i].request);v.push(y[i]);}}}if(u.length>0){var z=t._createBatchRequest(u,true);R.push(t._submitBatchRequest(z,v,s,E));}delete r[j];}});}else{q.each(r,function(j,n){if(j===G||!G){if(n.changes){q.each(n.changes,function(v,w){for(var i=0;i<w.length;i++){P='/'+t.getKey(w[i].request.data);t.increaseLaundering(P,w[i].request.data);if(w[i].request._aborted){t._processAborted(w[i].request,null,w[i].fnError);}else{w[i].request._handle=t._submitSingleRequest(w[i].request,w[i].fnSuccess,w[i].fnError);R.push(w[i].request._handle);}}});}if(n.requests){var u=n.requests;for(var i=0;i<u.length;i++){if(u[i].request._aborted){t._processAborted(u[i].request,null,u[i].fnError);}else{u[i].request._handle=t._submitSingleRequest(u[i].request,u[i].fnSuccess,u[i].fnError);R.push(u[i].request._handle);}}}delete r[j];}});}this.checkDataState(this.mLaunderingState);return R.length==1?R[0]:R;};p.prototype._processRequestQueueAsync=function(r){var t=this;if(!this.pCallAsnyc){this.pCallAsnyc=Promise.resolve();this.pCallAsnyc.then(function(){t._processRequestQueue(r);t.pCallAsnyc=undefined;});}};p.prototype._processSuccess=function(r,R,s,G,i,E){var j=R.data,I,n,u,P,t,v,L={},w={},x=this;n=!(R.statusCode===204||R.statusCode==='204');u=r.requestUri;P=u.replace(this.sServiceUrl,"");if(!q.sap.startsWith(P,'/')){P='/'+P;}P=this._normalizePath(P);this.decreaseLaundering(P,r.data);if(n&&j===undefined&&R){this._parseResponse(R,r);q.sap.log.fatal(this+" - No data was retrieved by service: '"+R.requestUri+"'");x.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(j&&j.results&&!q.isArray(j.results)){j=j.results;}if(j&&(q.isArray(j)||typeof j=='object')){I=q.sap.extend(true,{},j);x._importData(I,L);}if(L&&this.oData[r.key]&&this.oData[r.key].__metadata.created&&this.oData[r.key].__metadata.created.functionImport){var y=[];var z=this.oData[r.key]["$result"];if(z&&z.__list){q.each(L,function(K){y.push(K);});z.__list=y;}else if(z&&z.__ref){q.each(L,function(K){z.__ref=K;});}}if(!n){t=P.split("/");if(t[1]){w[t[1]]=r;var A={};A[t[1]]=r.data;this._updateChangedEntities(A);}if(r.method==="DELETE"&&t[2]!=="$links"){delete x.oData[t[1]];delete x.mContexts["/"+t[1]];delete x.mChangedEntities[t[1]];}}if(n&&r.method==="POST"){v=this.oMetadata._getEntityTypeByPath(P);if(v){E[v.entityType]=true;}if(r.key){var K=this._getKey(j);delete this.mChangedEntities[r.key];delete this.oData[r.key];var D=this.getContext("/"+r.key);D.sPath='/'+K;if(this.oData[K]){delete this.oData[K].__metadata.created;}}}this._parseResponse(R,r,L,w);q.extend(G,L);q.extend(i,w);this._updateETag(r,R);if(s){s(j,R);}var F=this._createEventInfo(r,R);this.fireRequestCompleted(F);return true;};p.prototype._processError=function(r,R,E){var P,i=this._handleError(R,r);P='/'+this.getKey(r.data);this.decreaseLaundering(P,r.data);if(E){E(i);}var j=this._createEventInfo(r,i);this.fireRequestCompleted(j);this.fireRequestFailed(j);};p.prototype._processAborted=function(r,R,E){var P;var i={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};P='/'+this.getKey(r.data);this.decreaseLaundering(P,r.data);if(E){E(i);}if(R){var j=this._createEventInfo(r,i);j.success=false;this.fireRequestCompleted(j);}};p.prototype._processChange=function(K,D,u){var P,E,i,s,j,r,H,t,R,v,w=this;E=this.oMetadata._getEntityTypeByPath(K);if(!u){u="MERGE";}P=q.sap.extend(true,{},this._getObject('/'+K,true),D);if(D.__metadata&&D.__metadata.created){s=D.__metadata.created.method?D.__metadata.created.method:"POST";K=D.__metadata.created.key;i=D.__metadata.created;if(D.__metadata.created.functionImport){i.urlParameters=this._createFunctionImportParameters(D.__metadata.created.key,s,P);P=undefined;}}else if(u==="MERGE"){s="MERGE";v=this.oData[K];}else{s="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&E){var N=this.oMetadata._getNavigationPropertyNames(E);q.each(N,function(I,z){delete P[z];});}if(s==="MERGE"&&E&&v){q.each(P,function(z,A){if(z!=='__metadata'){if(q.sap.equal(v[z],A)&&!w.isLaundering('/'+K+'/'+z)){delete P[z];}}});var x="/"+K,y;q.each(P,function(z,A){if(z!=='__metadata'){y=w.getProperty(x+"/"+z+"/#@sap:unit");if(y){if(P[y]===undefined){P[y]=v[y];}}}});}P=this._removeReferences(P);t=i&&i.urlParameters?a._createUrlParamsArray(i.urlParameters):undefined;H=i&&i.headers?this._getHeaders(i.headers):this._getHeaders();j=i&&i.eTag?i.eTag:this.getETag(P);r=this._createRequestUrl('/'+K,null,t,this.bUseBatch);R=this._createRequest(r,s,H,P,j);if(this.bUseBatch){R.requestUri=R.requestUri.replace(this.sServiceUrl+'/','');}return R;};p.prototype._resolveGroup=function(K){var i,E,P,G,s,D;E=this.oMetadata._getEntityTypeByPath(K);D=this._getObject('/'+K);P=D.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}if(this.mChangeGroups[E.name]){i=this.mChangeGroups[E.name];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}return{groupId:G,changeSetId:s};};p.prototype._updateETag=function(r,R){var u,E,s;u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);s=this._getHeader("etag",R.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s;}};p.prototype._handleError=function(E,r){var P={},t;var s="The following problem occurred: "+E.message;P.message=E.message;if(E.response){this._parseResponse(E.response,r);if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.headers=E.response.headers;P.responseText=E.response.body;}q.sap.log.fatal(s);return P;};p.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};p.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return o.batchHandler;}else if(u.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return o.jsonHandler;}else{return o.atomHandler;}};p.prototype.getETag=function(P,i,E){if(typeof P=="object"){E=P;P="";}return this._getETag(P,i,E);};p.prototype._getETag=function(P,i,D){if(!D||!D.__metadata){D=this._getObject(P,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};p.prototype.forceEntityUpdate=function(K){var D=this.mChangedEntities[K];if(D&&D.__metadata){D.__metadata.etag='*';}else{q.sap.log.error(this+" - Entity with key "+K+" does not exist or has no change");}};p.prototype._createRequest=function(u,s,H,D,E,A){A=A!==false;if(E&&s!=="GET"){H["If-Match"]=E;}if(s!=="DELETE"&&s!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(s==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";s="POST";}var r={headers:H,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(D){r.data=D;}if(this.bWithCredentials){r.withCredentials=this.bWithCredentials;}r.requestID=this._createRequestID();return r;};p.prototype._isRefreshNeeded=function(r,R){var i=false;if(this.bRefreshAfterChange){i=true;}return i;};p.prototype._processRequest=function(P){var r,R,A=false,t=this;this.oMetadata.loaded().then(function(){R=P();t._processRequestQueueAsync(t.mRequests);if(A){r.abort();}});r={abort:function(){A=true;if(R){R._aborted=true;if(R._handle){R._handle.abort();}}}};return r;};p.prototype.update=function(P,D,i){var s,E,r,u,j,n,t,G,v,w,H,x,R,y=this;if(i){G=i.groupId||i.batchGroupId;v=i.changeSetId;j=i.context;s=i.success;E=i.error;n=i.eTag;H=i.headers;w=i.urlParameters;if(i.merge!==undefined){x=i.merge?"MERGE":"PUT";}}t=a._createUrlParamsArray(w);H=this._getHeaders(H);x=x?x:this.sDefaultUpdateMethod;n=n||this._getETag(P,j,D);return this._processRequest(function(){u=y._createRequestUrl(P,j,t,y.bUseBatch);r=y._createRequest(u,x,H,D,n);R=y.mRequests;if(G in y.mDeferredGroups){R=y.mDeferredRequests;}y._pushToRequestQueue(R,G,v,r,s,E);return r;});};p.prototype.create=function(P,D,i){var r,u,E,j,s,n,t,R,H,v,w,G,x,y,z=this;if(i){j=i.context;t=i.urlParameters;s=i.success;n=i.error;G=i.groupId||i.batchGroupId;y=i.changeSetId;w=i.eTag;H=i.headers;}v=a._createUrlParamsArray(t);H=this._getHeaders(H);x="POST";return this._processRequest(function(){u=z._createRequestUrl(P,j,v,z.bUseBatch);r=z._createRequest(u,x,H,D,w);P=z._normalizePath(P,j);E=z.oMetadata._getEntityTypeByPath(P);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true;}R=z.mRequests;if(G in z.mDeferredGroups){R=z.mDeferredRequests;}z._pushToRequestQueue(R,G,y,r,s,n);return r;});};p.prototype.remove=function(P,i){var j,E,s,n,r,u,G,t,v,w,x,H,y,z,R,A=this;if(i){G=i.groupId||i.batchGroupId;t=i.changeSetId;j=i.context;s=i.success;n=i.error;v=i.eTag;H=i.headers;x=i.urlParameters;}y=a._createUrlParamsArray(x);H=this._getHeaders(H);z="DELETE";v=v||this._getETag(P,j);w=function(D,F){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!==-1){E=E.substr(0,E.indexOf('?'));}delete A.oData[E];delete A.mContexts["/"+E];if(s){s(D,F);}};return this._processRequest(function(){u=A._createRequestUrl(P,j,y,A.bUseBatch);r=A._createRequest(u,z,H,undefined,v);R=A.mRequests;if(G in A.mDeferredGroups){R=A.mDeferredRequests;}A._pushToRequestQueue(R,G,t,r,w,n);return r;});};p.prototype.callFunction=function(F,P){var r,u,i,R,j,n,s,E,t="GET",n,I={},G,v,H,w,x=this,K,y,z,A,D,J,L={};if(P){G=P.groupId||P.batchGroupId;v=P.changeSetId;t=P.method?P.method:t;j=P.urlParameters;w=P.eTag;s=P.success;E=P.error;H=P.headers;}if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return;}H=this._getHeaders(H);D=new Promise(function(N,Q){z=N;A=Q;});J=this._processRequest(function(){i=x.oMetadata._getFunctionImportMetadata(F,t);if(!i){A();return;}var N=i.entitySet||i.entitySetPath;if(N){L.$result={__list:[]};if(i.returnType&&i.returnType.indexOf("Collection")==-1){L.$result={__ref:{}};}}if(i.parameter!=null){q.each(i.parameter,function(Q,S){L[S.name]=x._createPropertyValue(S.type);if(j&&j[S.name]!==undefined){L[S.name]=j[S.name];I[S.name]=a.formatValue(j[S.name],S.type);}});q.each(j,function(Q){if(I[Q]===undefined){q.sap.log.warning(x+" - Parameter '"+Q+"' is not defined for function call '"+F+"'!");}});}K=F.substring(1)+"('"+q.sap.uid()+"')";L.__metadata={uri:x.sServiceUrl+'/'+K,created:{key:F.substring(1),success:s,error:E,headers:H,method:t,groupId:G,changeSetId:v,eTag:w,functionImport:true}};x.oData[K]=L;y=x.getContext("/"+K);z(y);n=a._createUrlParamsArray(I);u=x._createRequestUrl(F,null,n,x.bUseBatch);r=x._createRequest(u,t,H,undefined);r.key=K;R=x.mRequests;if(G in x.mDeferredGroups){R=x.mDeferredRequests;}x._pushToRequestQueue(R,G,v,r,s,E);return r;});J.contextCreated=function(){return D;};return J;};p.prototype._createFunctionImportParameters=function(F,s,P){var u=q.extend(true,{},P);delete u.__metadata;delete u["$result"];var i=this.oMetadata._getFunctionImportMetadata(F,s);if(!i){return;}if(i.parameter!=null){q.each(i.parameter,function(I,j){if(u[j.name]){u[j.name]=a.formatValue(u[j.name],j.type);}});}return u;};p.prototype.read=function(P,i){var r,u,j,n,s,E,F,S,t,v,w,N,x,H,y,G,z,R,A=this;if(i){j=i.context;n=i.urlParameters;s=i.success;E=i.error;F=i.filters;S=i.sorters;G=i.groupId||i.batchGroupId;H=i.headers;}if(this.sRefreshGroupId){G=this.sRefreshGroupId;}x=a._createUrlParamsArray(n);H=this._getHeaders(H);y="GET";z=this._getETag(P,j);function D(){v=a.createSortParams(S);if(v){x.push(v);}var T=P;var I=P.indexOf("$count");if(I!==-1){T=P.substring(0,I-1);}N=A._normalizePath(T,j);w=A.oMetadata._getEntityTypeByPath(N);t=a.createFilterParams(F,A.oMetadata,w);if(t){x.push(t);}u=A._createRequestUrl(P,j,x,A.bUseBatch);r=A._createRequest(u,y,H,null,z);R=A.mRequests;if(G in A.mDeferredGroups){R=A.mDeferredRequests;}A._pushToRequestQueue(R,G,null,r,s,E);return r;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){r=D();return{abort:function(){if(r){r._aborted=true;}}};}else{return this._processRequest(D);}};p.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};p.prototype.metadataLoaded=function(){return this.oMetadata.loaded();};p.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};p.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){q.sap.require("sap.ui.model.odata.ODataAnnotations");this.oAnnotations=new O({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync,headers:this.mCustomHeaders});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};p.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};p.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};p.prototype.addAnnotationUrl=function(u){var j=[].concat(u),n=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}n.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(n).then(function(P){return Promise.all(q.map(P,function(i){E=E.concat(i.entitySets);return t.addAnnotationXML(i["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(P){return{annotations:P.annotations,entitySets:E};});};p.prototype.addAnnotationXML=function(x,s){return new Promise(function(r,i){this._getAnnotationParser().setXML(null,x,{success:r,error:i,fireEvents:!s});}.bind(this));};p.prototype.submitChanges=function(P){var r,G,j,s,E,R,v,A=false,n,t,u,w=this;if(P){G=P.groupId||P.batchGroupId;s=P.success;E=P.error;if(P.merge!==undefined){n=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){q.sap.log.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}t=q.sap.extend(true,{},w.mChangedEntities);this.oMetadata.loaded().then(function(){q.each(t,function(K,D){j=w._resolveGroup(K);if(j.groupId===G||!G){r=w._processChange(K,D,n||w.sDefaultUpdateMethod);r.key=K;u=D.__metadata&&D.__metadata.created?D.__metadata.created:{};if(j.groupId in w.mDeferredGroups){w._pushToRequestQueue(w.mDeferredRequests,j.groupId,j.changeSetId,r,u.success,u.error);}}});v=w._processRequestQueue(w.mDeferredRequests,G,s,E);if(A){R.abort();}});R={abort:function(){if(v){if(q.isArray(v)){q.each(v,function(i,R){R.abort();});}else{v.abort();}}else{A=true;}}};return R;};p.prototype._updateChangedEntities=function(i){var t=this,r;function u(j,n){q.each(n,function(K){var A=r+'/'+K;if(q.isPlainObject(n[K])&&q.isPlainObject(j[K])){u(j[K],n[K]);if(q.isEmptyObject(n[K])){delete n[K];}}else if(q.sap.equal(n[K],j[K])&&!t.isLaundering(A)){delete n[K];}});}q.each(i,function(K,D){if(K in t.mChangedEntities){var E=t._getObject('/'+K,null,true);var j=t._getObject('/'+K);q.sap.extend(true,E,D);r='/'+K;u(E,j);if(q.isEmptyObject(j)){delete t.mChangedEntities[K];if(t.mChangeHandles[K]){t.mChangeHandles[K].abort();delete t.mChangeHandles[K];}}else{t.mChangedEntities[K]=j;j.__metadata={};q.extend(j.__metadata,E.__metadata);}}});};p.prototype.resetChanges=function(P){var t=this,j,E={},n,K,r;if(P){q.each(P,function(I,s){t.getEntityByPath(s,null,E);j=E.propertyPath.split("/");K=E.key;n=t.mChangedEntities[K];for(var i=0;i<j.length-1;i++){if(n.hasOwnProperty(j[i])){n=n[j[i]];}else{n=undefined;}}if(n){delete n[j[j.length-1]];}if(t.mChangedEntities[K]){r=t.mChangedEntities[K].__metadata;delete t.mChangedEntities[K].__metadata;if(q.isEmptyObject(t.mChangedEntities[K])||!E.propertyPath){t.metadataLoaded().then(function(){t.mChangeHandles[K].abort();delete t.mChangeHandles[K];});delete t.mChangedEntities[K];}else{t.mChangedEntities[K].__metadata=r;}}else{q.sap.log.warning(t+" - resetChanges: "+s+" is not changed");}});}else{q.each(this.mChangedEntities,function(K,i){t.metadataLoaded().then(function(){t.mChangeHandles[K].abort();delete t.mChangeHandles[K];});delete t.mChangedEntities[K];});}this.checkUpdate();};p.prototype.setProperty=function(P,v,j,A){var n,s,r,R,t,E={},u,w,K,G,x,y,z={},D={},F,H=false,I=this;u=this.resolve(P,j,true);var E=this.getEntityByPath(u,null,D);if(!E){return false;}s=u.substring(u.lastIndexOf("/")+1);K=D.key;t=this._getObject('/'+K);n=this._getObject(P,j,true);if(!this.mChangedEntities[K]){y=E.__metadata;E={};E.__metadata=q.extend({},y);this.mChangedEntities[K]=E;}var J=this.mChangedEntities[K];w=D.propertyPath.split("/");for(var i=0;i<w.length-1;i++){if(!J.hasOwnProperty(w[i])){J[w[i]]={};}J=J[w[i]];}H=t.__metadata.created&&t.__metadata.created.functionImport;if(q.sap.equal(v,n)&&!this.isLaundering('/'+K)&&!H){delete J[s];y=this.mChangedEntities[K].__metadata;delete this.mChangedEntities[K].__metadata;if(q.isEmptyObject(this.mChangedEntities[K])){I.metadataLoaded().then(function(){if(I.mChangeHandles[K]){I.mChangeHandles[K].abort();delete I.mChangeHandles[K];}});delete this.mChangedEntities[K];z[K]=true;this.checkUpdate(false,A,z);return true;}this.mChangedEntities[K].__metadata=y;}else{J[s]=v;}G=this._resolveGroup(K);r=this.mRequests;if(G.groupId in this.mDeferredGroups){r=this.mDeferredRequests;R=this._processChange(K,{__metadata:E.__metadata});}else{R=this._processChange(K,this._getObject('/'+K));}R.key=K;F=J.__metadata&&J.__metadata.created?J.__metadata.created:{};this.metadataLoaded().then(function(){if(!I.mChangeHandles[K]){x={abort:function(){R._aborted=true;}};I.mChangeHandles[K]=x;}I._pushToRequestQueue(r,G.groupId,G.changeSetId,R,F.success,F.error);I._processRequestQueueAsync(I.mRequests);});z[K]=true;this.checkUpdate(false,A,z);return true;};p.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}return false;};p.prototype.setHeaders=function(H){var i={},t=this;this.mCustomHeaders={};if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};p.prototype._getHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});}return q.extend({},this.mCustomHeaders,i,this.oHeaders);};p.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};p.prototype._getHeader=function(H,i){var s;for(s in i){if(s.toLowerCase()===H.toLowerCase()){return i[s];}}return null;};p.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities);};p.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};p.prototype.getPendingChanges=function(){return q.sap.extend(true,{},this.mChangedEntities);};p.prototype.updateBindings=function(F){this.checkUpdate(F);};p.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};p.prototype.setUseBatch=function(u){this.bUseBatch=u;};p.prototype.formatValue=function(v,t){return a.formatValue(v,t);};p.prototype.deleteCreatedEntry=function(i){var t=this;if(i){var P=i.getPath();delete this.mContexts[P];if(q.sap.startsWith(P,"/")){P=P.substr(1);}t.metadataLoaded().then(function(){t.mChangeHandles[P].abort();delete t.mChangeHandles[P];});delete this.mChangedEntities[P];delete this.oData[P];}};p.prototype.createEntry=function(P,j){var s,E,r,u,n,t,K,v,G,w,R,x,H,y,z,A={},D,F="POST",I=this;if(j){z=j.properties;G=j.groupId||j.batchGroupId;w=j.changeSetId;t=j.context;s=j.success;E=j.error;D=j.created;n=j.eTag;H=j.headers;x=j.urlParameters;}G=G?G:this.sDefaultChangeGroup;v=a._createUrlParamsArray(x);H=this._getHeaders(H);function J(){var L;if(!q.sap.startsWith(P,"/")){P="/"+P;}var N=I.oMetadata._getEntityTypeByPath(P);if(!N){return undefined;}if(typeof z==="object"&&!q.isArray(z)){A=z;}else{for(var i=0;i<N.property.length;i++){var Q=N.property[i];var S=q.inArray(Q.name,z)>-1;if(!z||S){A[Q.name]=I._createPropertyValue(Q.type);if(S){z.splice(z.indexOf(Q.name),1);}}}if(z){}}var T=I.oMetadata._getEntitySetByType(N);K=T.name+"('"+q.sap.uid()+"')";A.__metadata={type:""+N.entityType,uri:I.sServiceUrl+'/'+K,created:{key:P.substring(1),success:s,error:E,headers:H,urlParameters:x,groupId:G,changeSetId:w,eTag:n}};I.oData[K]=q.sap.extend(true,{},A);I.mChangedEntities[K]=A;u=I._createRequestUrl(P,t,v,I.bUseBatch);r=I._createRequest(u,F,H,A,n);L=I.getContext("/"+K);r.key=K;y=I.mRequests;if(G in I.mDeferredGroups){y=I.mDeferredRequests;}I.metadataLoaded().then(function(){I._pushToRequestQueue(y,G,w,r,s,E,j);R={abort:function(){r._aborted=true;}};I.mChangeHandles[K]=R;I._processRequestQueueAsync(I.mRequests);});return L;}if(D){this.oMetadata.loaded().then(function(){D(J());});}else if(this.oMetadata.isLoaded()){return J();}else{q.sap.log.error("Tried to use createEntry without created-callback, before metadata is available!");}};p.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T[1];var s=T[0];if(n.toUpperCase()!=='EDM'){var j={};var r=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<r.property.length;i++){var P=r.property[i];j[P.name]=this._createPropertyValue(P.type);}return j;}else{return this._getDefaultPropertyValue(s,n);}};p.prototype._getDefaultPropertyValue=function(t,n){return undefined;};p.prototype._normalizePath=function(P,i){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!q.sap.startsWith(P,"/")){q.sap.log.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i);};p.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r;};p.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};p.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};p.prototype._request=function(r,s,E,H,i,j){var R;if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(n){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(R&&R.bSuppressErrorHandlerCall)){n.apply(this,arguments);}};}R=o.request(r,w(s||o.defaultSuccess),w(E||o.defaultError),H,i,j);if(r.async!==false){this.aPendingRequestHandles.push(R);}return R;};p.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort();}}delete this.aPendingRequestHandles;}if(this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent);}if(this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;}};p.prototype.setDeferredBatchGroups=function(G){this.setDeferredGroups(G);};p.prototype.setDeferredGroups=function(G){var t=this;this.mDeferredGroups={};q.each(G,function(i,s){t.mDeferredGroups[s]=s;});};p.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};p.prototype.getDeferredGroups=function(){var G=[],i=0;q.each(this.mDeferredGroups,function(K,s){G[i]=s;i++;});return G;};p.prototype.setChangeBatchGroups=function(G){q.each(G,function(E,i){i.groupId=i.batchGroupId;});this.setChangeGroups(G);};p.prototype.setChangeGroups=function(G){this.mChangeGroups=G;};p.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};p.prototype.getChangeGroups=function(){return this.mChangeGroups;};p.prototype.setMessageParser=function(P){if(!(P instanceof l)){q.sap.log.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return;}P.setProcessor(this);this.oMessageParser=P;return this;};p.prototype._parseResponse=function(r,R,G,i){try{if(!this.oMessageParser){this.oMessageParser=new m(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}return this.oMessageParser.parse(r,R,G,i);}catch(j){q.sap.log.error("Error parsing OData messages: "+j);}};p.prototype.callAfterUpdate=function(F){this.aCallAfterUpdate.push(F);};p.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new k(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);},function(E){var s=E.message,D;if(!s&&E.xmlDoc&&E.xmlDoc.parseError){s=E.xmlDoc.parseError.reason;D=E.xmlDoc.parseError.srcText;}q.sap.log.error("error in ODataMetaModel.loaded(): "+s,D,"sap.ui.model.odata.v2.ODataModel");});}return this.oMetaModel;};p.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};p.prototype.getEntityByPath=function(P,i,E){var r=M.prototype.resolve.call(this,P,i);if(!r){return null;}var j=r.split("/"),n=null,s=[];while(j.length>0){var t=j.join("/"),u=this._getObject(t);if(q.isPlainObject(u)){var K=this._getKey(u);if(K){n=u;break;}}s.unshift(j.pop());}if(n){E.propertyPath=s.join("/");E.key=K;return n;}return null;};p.prototype.resolve=function(P,i,j){var r=M.prototype.resolve.call(this,P,i);if(j){var E={},n=this.getEntityByPath(P,i,E);if(n){if(E.propertyPath){return"/"+E.key+"/"+E.propertyPath;}else{return"/"+E.key;}}else{return undefined;}}return r;};p.prototype.isLaundering=function(P,i){var r=this.resolve(P,i);return(r in this.mLaunderingState)&&this.mLaunderingState[r]>0;};p.prototype.increaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(q.isPlainObject(j)){this.increaseLaundering(P+"/"+n,j);}else{var t=P+"/"+n;if(!(t in this.mLaunderingState)){this.mLaunderingState[t]=0;}this.mLaunderingState[t]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};p.prototype.decreaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],t=P+"/"+n;if(q.isPlainObject(j)){this.decreaseLaundering(t,j);}else{if(t in this.mLaunderingState){this.mLaunderingState[t]--;if(this.mLaunderingState[t]===0){delete this.mLaunderingState[t];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};return p;});
