/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','../base/Object','../base/ManagedObject','./ElementMetadata','jquery.sap.strings','jquery.sap.trace'],function(q,B,M,E){"use strict";var a=M.extend("sap.ui.core.Element",{metadata:{stereotype:"element","abstract":true,publicMethods:["getId","getMetadata","getTooltip_AsString","getTooltip_Text","getModel","setModel","hasModel","bindElement","unbindElement","getElementBinding","prop","getLayoutData","setLayoutData"],library:"sap.ui.core",aggregations:{tooltip:{name:"tooltip",type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false},customData:{name:"customData",type:"sap.ui.core.CustomData",multiple:true,singularName:"customData"},layoutData:{name:"layoutData",type:"sap.ui.core.LayoutData",multiple:false,singularName:"layoutData"},dependents:{name:"dependents",type:"sap.ui.core.Control",multiple:true}}},constructor:function(i,s){M.apply(this,arguments);},renderer:null},E);a.defineClass=function(c,s,m){return B.defineClass(c,s,m||E);};a.prototype.getInterface=function(){return this;};a.prototype._handleEvent=function(e){var t=this,h="on"+e.type;function b(d){var i,l,D;if(d&&(l=d.length)>0){d=l===1?d:d.slice();for(i=0;i<l;i++){if(e.isImmediateHandlerPropagationStopped()){return;}D=d[i].oDelegate;if(D[h]){D[h].call(d[i].vThis===true?t:d[i].vThis||D,e);}}}}b(this.aBeforeDelegates);if(e.isImmediateHandlerPropagationStopped()){return;}if(this[h]){this[h](e);}b(this.aDelegates);};a.create=function(d,k){if(!d||d instanceof a||typeof d!=="object"||d instanceof String){return d;}function g(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return q.sap.getObject(t);}}var c=g(d.Type)||g(k&&k.type);if(typeof c==="function"){return new c(d);}var m="Don't know how to create an Element from "+d+" ("+(typeof d)+")";q.sap.log.fatal(m);throw new Error(m);};a.prototype.toString=function(){if(this.getMetadata){return"Element "+this.getMetadata().getName()+"#"+this.sId;}else{return"Element {unknown class}#"+this.sId;}};a.prototype.getDomRef=function(s){return q.sap.domById(s?this.getId()+"-"+s:this.getId());};a.prototype.$=function(s){return q(this.getDomRef(s));};a.prototype.isActive=function(){return this.oParent&&this.oParent.isActive();};a.prototype.prop=function(p,v){var P=this.getMetadata().getAllSettings()[p];if(P){if(arguments.length==1){return this[P._sGetter]();}else{this[P._sMutator](v);return this;}}};a.prototype.insertDependent=function(c,i){return this.insertAggregation("dependents",c,i,true);};a.prototype.addDependent=function(c){return this.addAggregation("dependents",c,true);};a.prototype.removeDependent=function(c){return this.removeAggregation("dependents",c,true);};a.prototype.removeAllDependents=function(){return this.removeAllAggregation("dependents",true);};a.prototype.destroyDependents=function(){return this.destroyAggregation("dependents",true);};a.prototype.rerender=function(){if(this.oParent){this.oParent.rerender();}};a.prototype.getUIArea=function(){return this.oParent?this.oParent.getUIArea():null;};a.prototype.destroy=function(s){a._updateFocusInfo(this);M.prototype.destroy.call(this,s);if(s!=="KeepDom"){this.$().remove();}else{q.sap.log.debug("DOM is not removed on destroy of "+this);}};a.prototype.fireEvent=function(e,p,A,b){if(this.hasListeners(e)){q.sap.interaction.notifyStepStart(this);}if(typeof p==='boolean'){b=A;A=p;p=null;}p=p||{};p.id=p.id||this.getId();return M.prototype.fireEvent.call(this,e,p,A,b);};a.prototype.addDelegate=function(d,c,t,C){if(!d){return this;}this.removeDelegate(d);if(typeof c==="object"){C=t;t=c;c=false;}if(typeof t==="boolean"){C=t;t=undefined;}(c?this.aBeforeDelegates:this.aDelegates).push({oDelegate:d,bClone:!!C,vThis:((t===this)?true:t)});return this;};a.prototype.removeDelegate=function(d){var i;for(i=0;i<this.aDelegates.length;i++){if(this.aDelegates[i].oDelegate==d){this.aDelegates.splice(i,1);i--;}}for(i=0;i<this.aBeforeDelegates.length;i++){if(this.aBeforeDelegates[i].oDelegate==d){this.aBeforeDelegates.splice(i,1);i--;}}return this;};a.prototype.addEventDelegate=function(d,t){return this.addDelegate(d,false,t,true);};a.prototype.removeEventDelegate=function(d){return this.removeDelegate(d);};a.prototype.getFocusDomRef=function(){return this.getDomRef()||null;};a.prototype.focus=function(){q.sap.focus(this.getFocusDomRef());};a.prototype.getFocusInfo=function(){return{id:this.getId()};};a.prototype.applyFocusInfo=function(f){this.focus();return this;};a.prototype._refreshTooltipBaseDelegate=function(t){var o=this.getTooltip();if(o instanceof sap.ui.core.TooltipBase){this.removeDelegate(o);}if(t instanceof sap.ui.core.TooltipBase){t._currentControl=this;this.addDelegate(t);}};a.prototype.setTooltip=function(t){this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t);return this;};a.prototype.getTooltip=function(){return this.getAggregation("tooltip");};a.runWithPreprocessors=M.runWithPreprocessors;a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();if(typeof t==="string"||t instanceof String){return t;}return undefined;};a.prototype.getTooltip_Text=function(){var t=this.getTooltip();if(t&&typeof t.getText==="function"){return t.getText();}return t;};(function(){var g=function(e,k){var d=e.getAggregation("customData");if(d){for(var i=0;i<d.length;i++){if(d[i].getKey()==k){return d[i];}}}return null;};var s=function(e,k,v,w){if(v===null){var d=g(e,k);if(!d){return;}var b=e.getAggregation("customData").length;if(b==1){e.destroyAggregation("customData",true);}else{e.removeAggregation("customData",d,true);d.destroy();}}else{var d=g(e,k);if(d){d.setValue(v);d.setWriteToDom(w);}else{var d=new sap.ui.core.CustomData({key:k,value:v,writeToDom:w});e.addAggregation("customData",d,true);}}};a.prototype.data=function(){var b=arguments.length;if(b==0){var d=this.getAggregation("customData"),r={};if(d){for(var i=0;i<d.length;i++){r[d[i].getKey()]=d[i].getValue();}}return r;}else if(b==1){var c=arguments[0];if(c===null){this.destroyAggregation("customData",true);return this;}else if(typeof c=="string"){var e=g(this,c);return e?e.getValue():null;}else if(typeof c=="object"){for(var k in c){s(this,k,c[k]);}return this;}else{throw new Error("When data() is called with one argument, this argument must be a string, an object or null, but is "+(typeof c)+":"+c+" (on UI Element with ID '"+this.getId()+"')");}}else if(b==2){s(this,arguments[0],arguments[1]);return this;}else if(b==3){s(this,arguments[0],arguments[1],arguments[2]);return this;}else{throw new Error("data() may only be called with 0-3 arguments (on UI Element with ID '"+this.getId()+"')");}};})();a.prototype.clone=function(I,l){var c=M.prototype.clone.apply(this,arguments);for(var i=0;i<this.aDelegates.length;i++){if(this.aDelegates[i].bClone){c.aDelegates.push(this.aDelegates[i]);}}for(var i=0;i<this.aBeforeDelegates.length;i++){if(this.aBeforeDelegates[i].bClone){c.aBeforeDelegates.push(this.aBeforeDelegates[i]);}}return c;};a.prototype.findElements=function(r){var c=M.prototype.findAggregatedObjects.call(this,r);return c;};a.prototype.setLayoutData=function(l){this.setAggregation("layoutData",l,true);var L=this.getParent();if(L){var e=q.Event("LayoutDataChange");e.srcControl=this;L._handleEvent(e);}return this;};a.prototype.bindElement=function(p,P){return this.bindObject(p,P);};a.prototype.unbindElement=function(m){return this.unbindObject(m);};a.prototype.getElementBinding=function(m){return this.getObjectBinding(m);};a.prototype._getFieldGroupIds=function(){var f;if(this.getMetadata().hasProperty("fieldGroupIds")){f=this.getFieldGroupIds();}if(!f||f.length==0){var p=this.getParent();if(p&&p._getFieldGroupIds){return p._getFieldGroupIds();}}return f;};return a;});
