// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.table.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenuRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.table.ColumnMenuRenderer
jQuery.sap.declare('sap.ui.table.ColumnMenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/ColumnMenuRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/unified/MenuRenderer'],
	function(jQuery, Renderer, MenuRenderer) {
	"use strict";


	/**
	 * Renderer for the sap.ui.table.ColumnMenuRendere
	 * @namespace
	 */
	var ColumnMenuRenderer = Renderer.extend(MenuRenderer);

	return ColumnMenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/ColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.DataTable
jQuery.sap.declare('sap.ui.table.DataTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/table/DataTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/core/theming/Parameters'],
	function(jQuery, Renderer, Parameters) {
	"use strict";


	/**
	 * DataTableRenderer
	 * @namespace
	 */
	var DataTableRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oTable an object representation of the control that should be rendered
	 */
	DataTableRenderer.render = function(rm, oTable) {
		// create the rows of the table
		// (here we could think about a swith to allow the programmatic usage of the table)
		oTable._createRows();

		// basic table div
		rm.write("<div");
		if (oTable._bAccMode) {
			var aAriaOwnsIds = [];
			if (oTable.getToolbar()) {
				aAriaOwnsIds.push(oTable.getToolbar().getId());
			}
			aAriaOwnsIds.push(oTable.getId() + "-table");
			rm.writeAttribute("aria-owns", aAriaOwnsIds.join(" "));
			rm.writeAttribute("aria-readonly", "true");
			if (oTable.getTitle()) {
				rm.writeAttribute("aria-labelledby", oTable.getTitle().getId());
			}
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-multiselectable", "true");
			}
		}
		rm.writeControlData(oTable);
		rm.addClass("sapUiTable");
		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode());
		if (oTable.getColumnHeaderVisible()) {
			rm.addClass("sapUiTableCHdr"); // show column headers
		}
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.addClass("sapUiTableRSel"); // show row selector
		}

		// This class flags whether the sap.m. library is loaded or not.
		var sSapMTableClass = sap.ui.table.TableHelper.addTableClass();
		if (sSapMTableClass) {
			rm.addClass(sSapMTableClass);
		}

		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode()); // row selection mode
		//rm.addClass("sapUiTableHScr"); // show horizontal scrollbar
		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
			rm.addClass("sapUiTableVScr"); // show vertical scrollbar
		}
		if (oTable.getEditable()) {
			rm.addClass("sapUiTableEdt"); // editable (background color)
		}
		rm.addClass("sapUiTableShNoDa");
		if (oTable.getShowNoData() && oTable._getRowCount() === 0) {
			rm.addClass("sapUiTableEmpty"); // no data!
		}
		if (oTable.getEnableGrouping()) {
			rm.addClass("sapUiTableGrouping");
		}
		rm.writeClasses();
		if (oTable.getWidth()) {
			rm.addStyle("width", oTable.getWidth());
		}
		rm.writeStyles();
		rm.write(">");

		if (oTable.getTitle()) {
			this.renderHeader(rm, oTable, oTable.getTitle());
		}

		if (oTable.getToolbar()) {
			this.renderToolbar(rm, oTable, oTable.getToolbar());
		}

		if (oTable.getExtension() && oTable.getExtension().length > 0) {
			this.renderExtensions(rm, oTable, oTable.getExtension());
		}

		rm.write("<div");
		rm.addClass("sapUiTableCnt");
		rm.writeClasses();
		// Define group for F6 handling
		rm.writeAttribute("data-sap-ui-fastnavgroup", "true");
		if (oTable._bAccMode) {
			rm.writeAttribute("aria-describedby", oTable.getId() + "-ariacount");
		}
		rm.write(">");

		this.renderColHdr(rm, oTable);

		this.renderTable(rm, oTable);

		if (oTable._bAccMode) {
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariadesc");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			if (oTable.getTitle() && oTable.getTitle().getText && oTable.getTitle().getText() != "") {
				rm.writeEscaped(oTable.getTitle().getText());
			} else {
				rm.write(oTable._oResBundle.getText("TBL_TABLE"));
			}

			rm.write("</span>");
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariacount");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write("</span>");
			// aria description for toggling the edit mode
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-toggleedit");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_TOGGLE_EDIT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY"));
			rm.write("</span>");
			// table row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-rownumberofrows");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write("</span>");
		}

		rm.write("</div>");

		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			rm.write("<div");
			rm.addClass("sapUiTablePaginator");
			rm.writeClasses();
			rm.write(">");
			if (!oTable._oPaginator) {
				jQuery.sap.require("sap.ui.commons.Paginator");
				oTable._oPaginator = new sap.ui.commons.Paginator(oTable.getId() + "-paginator");
				oTable._oPaginator.attachPage(jQuery.proxy(oTable.onvscroll, oTable));
			}
			rm.renderControl(oTable._oPaginator);
			rm.write("</div>");
		}

		if (oTable.getFooter()) {
			this.renderFooter(rm, oTable, oTable.getFooter());
		}

		if (oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Interactive) {
			this.renderVariableHeight(rm ,oTable);
		}

		rm.write("</div>");

	};

	// =============================================================================
	// BASIC AREAS OF THE TABLE
	// =============================================================================

	DataTableRenderer.renderHeader = function(rm, oTable, oTitle) {
		rm.write("<div");
		rm.addClass("sapUiTableHdr");
		rm.writeClasses();
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "heading");
		}
		rm.write(">");

		rm.renderControl(oTitle);

		rm.write("</div>");
	};

	DataTableRenderer.renderToolbar = function(rm, oTable, oToolbar) {
		rm.write("<div");
		rm.addClass("sapUiTableTbr");
		if (typeof oToolbar.getStandalone !== "function") {
			// for the mobile toolbar we add another class
			rm.addClass("sapUiTableMTbr");
		}
		rm.writeClasses();
		rm.write(">");

		// toolbar has to be embedded (not standalone)!
		if (typeof oToolbar.getStandalone === "function" && oToolbar.getStandalone()) {
			oToolbar.setStandalone(false);
		}

		// set the default design of the toolbar
		if (sap.m && sap.m.Toolbar && oToolbar instanceof sap.m.Toolbar) {
			oToolbar.setDesign(Parameters.get("sapUiTableToolbarDesign"), true);
		}

		rm.renderControl(oToolbar);

		rm.write("</div>");
	};

	DataTableRenderer.renderExtensions = function(rm, oTable, aExtensions) {
		for (var i = 0, l = aExtensions.length; i < l; i++) {
			this.renderExtension(rm, oTable, aExtensions[i]);
		}
	};

	DataTableRenderer.renderExtension = function(rm, oTable, oExtension) {
		rm.write("<div");
		rm.addClass("sapUiTableExt");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oExtension);

		rm.write("</div>");
	};

	DataTableRenderer.renderTable = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableCCnt");
		rm.writeClasses();
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlBefore");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");

		this.renderRowHdr(rm, oTable);
		this.renderTableCtrl(rm, oTable);
		this.renderVSb(rm, oTable);

		rm.write("</div>");

		this.renderHSb(rm, oTable);

	};

	DataTableRenderer.renderFooter = function(rm, oTable, oFooter) {
		rm.write("<div");
		rm.addClass("sapUiTableFtr");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oFooter);

		rm.write("</div>");
	};

	DataTableRenderer.renderVariableHeight = function(rm, oTable) {
		rm.write('<div id="' + oTable.getId() + '-sb" tabIndex="-1"');
		rm.addClass("sapUiTableSplitterBar");
		rm.addStyle("height", "5px");
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.write("</div>");
	};

	// =============================================================================
	// COLUMN HEADER OF THE TABLE
	// =============================================================================

	DataTableRenderer.renderColHdr = function(rm, oTable) {

		rm.write("<div");
		rm.addClass("sapUiTableColHdrCnt");
		rm.writeClasses();
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", (oTable.getColumnHeaderHeight() * oTable._getHeaderRowCount()) + "px");
		}
		if (oTable._bAccMode &&
			 (oTable.getSelectionMode() === sap.ui.table.SelectionMode.None ||
					 oTable.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
			rm.writeAttribute("role", "row");
		}
		rm.writeStyles();
		rm.write(">");

		this.renderColRowHdr(rm, oTable);

		var aCols = oTable.getColumns();

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableColHdrFixed");
			rm.writeClasses();
			rm.write(">");

			for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

				rm.write("<div");
				rm.addClass("sapUiTableColHdr");
				rm.writeClasses();
				rm.addStyle("min-width", oTable._getColumnsWidth(0, oTable.getFixedColumnCount()) + "px");
				rm.writeStyles();
				rm.write(">");

				var iSpan = 1;
				for (var i = 0, l = oTable.getFixedColumnCount(); i < l; i++) {
					if (aCols[i] && aCols[i].shouldRender()) {
						if (iSpan <= 1) {
							this.renderCol(rm, oTable, aCols[i], i, h);
							var aHeaderSpan = aCols[i].getHeaderSpan();
							if (jQuery.isArray(aHeaderSpan)) {
								iSpan = aCols[i].getHeaderSpan()[h] + 1;
							} else {
								iSpan = aCols[i].getHeaderSpan() + 1;
							}
						} else {
							//Render column header but this is invisible because of the span
							this.renderCol(rm, oTable, aCols[i], i, h, true);
						}
						if (h == 0) {
							this.renderColRsz(rm, oTable, aCols[i], i);
						}
						iSpan--;
					}
				}

				rm.write("<p style=\"clear: both;\"></p>");
				rm.write("</div>");

			}

			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableColHdrScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

			rm.write("<div");
			rm.addClass("sapUiTableColHdr");
			rm.writeClasses();
			rm.addStyle("min-width", oTable._getColumnsWidth(oTable.getFixedColumnCount(), aCols.length) + "px");
			rm.writeStyles();
			rm.write(">");

			var iSpan = 1;
			for (var i = oTable.getFixedColumnCount(), l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					if (iSpan <= 1) {
						this.renderCol(rm, oTable, aCols[i], i, h);
						var aHeaderSpan = aCols[i].getHeaderSpan();
						if (jQuery.isArray(aHeaderSpan)) {
							iSpan = aCols[i].getHeaderSpan()[h] + 1;
						} else {
							iSpan = aCols[i].getHeaderSpan() + 1;
						}
					} else {
						//Render column header but this is invisible because of the span
						this.renderCol(rm, oTable, aCols[i], i, h, true);
					}
					if (h == 0) {
						this.renderColRsz(rm, oTable, aCols[i], i);
					}
					iSpan--;
				}
			}

			rm.write("<p style=\"clear: both;\"></p>");
			rm.write("</div>");

		}

		rm.write("</div>");

		rm.write("</div>");

	};

	/**
	 * This function renders aria attributes if bAccMode is true.
	 * @param {sap.ui.core.RenderManager} rm Instance of the RenderManager
	 * @param {Map} mAriaAttributes Map of aria attributes. The Key of the maps equals the attribute name
	 * @param {Boolean} bAccMode Flag if Acc Mode is turned on
	 */
	DataTableRenderer.renderAriaAttributes = function(rm, mAriaAttributes, bAccMode) {
		if (bAccMode) {
			for (var sKey in mAriaAttributes) {
				var mAriaAttribute = mAriaAttributes[sKey];
				if (mAriaAttribute.escaped) {
					rm.writeAttributeEscaped(sKey, mAriaAttribute.value);
				} else {
					rm.writeAttribute(sKey, mAriaAttribute.value);
				}
			}
		}
	};

	DataTableRenderer.getAriaAttributesForRowHdr = function(oTable) {
		return {
			"aria-label": {value: oTable._oResBundle.getText("TBL_SELECT_ALL_KEY"), escaped: true}
		};
	};

	DataTableRenderer.renderColRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-selall");
		var oSelMode = oTable.getSelectionMode();
		if ((oSelMode == "Multi" || oSelMode == "MultiToggle") && oTable.getEnableSelectAll()) {
			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_SELECT_ALL"));
			//TODO: remove second _getSelectableRowCount Call!
			if (oTable._getSelectableRowCount() == 0 || oTable._getSelectableRowCount() !== oTable.getSelectedIndices().length) {
				rm.addClass("sapUiTableSelAll");
			}
			rm.addClass("sapUiTableSelAllEnabled");
		}
		rm.addClass("sapUiTableColRowHdr");
		rm.writeClasses();

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForRowHdr(oTable);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.write(">");
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.Single) {
			rm.write("<div");
			rm.addClass("sapUiTableColRowHdrIco");
			rm.writeClasses();
			if (oTable.getColumnHeaderHeight() > 0) {
				rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
			}
			rm.write(">");
			rm.write("</div>");
		}
		rm.write("</div>");
	};

	DataTableRenderer.getAriaAttributesForCol = function(oTable, oColumn, iColumnIndex) {
		var mAriaAttributes = {};

		// aria-haspopup should only be added if the column has a column menu
		// the column menu always gets created but might have no items.
		if (oColumn._menuHasItems()) {
			mAriaAttributes["aria-haspopup"] = {value: "true"};
		}

		mAriaAttributes.role = {value: "columnheader"};

		if (iColumnIndex < oTable.getFixedColumnCount()) {
			mAriaAttributes["aria-labelledby"] = {value: oColumn.getId() + " " + oTable.getId() + "-ariafixedcolumn"};
		}

		return mAriaAttributes;
	};

	DataTableRenderer.renderCol = function(rm, oTable, oColumn, iIndex, iHeader, bInvisible) {
		var oLabel;
		if (oColumn.getMultiLabels().length > 0) {
			oLabel = oColumn.getMultiLabels()[iHeader];
		} else if (iHeader == 0) {
			oLabel = oColumn.getLabel();
		}

		rm.write("<div");
		if (iHeader === 0) {
			rm.writeElementData(oColumn);
		} else {
			// TODO: we need a writeElementData with suffix - it is another HTML element
			//       which belongs to the same column but it is not in one structure!
			rm.writeAttribute('id', oColumn.getId() + "_" + iHeader);
		}
		rm.writeAttribute('data-sap-ui-colid', oColumn.getId());
		rm.writeAttribute("data-sap-ui-colindex", iIndex);

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForCol(oTable, oColumn, iIndex);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.addClass("sapUiTableCol");
		if (oTable.getFixedColumnCount() === iIndex + 1) {
			rm.addClass("sapUiTableColLastFixed");
		}

		rm.writeClasses();
		rm.addStyle("width", oColumn.getWidth());
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
		}
		if (bInvisible) {
			rm.addStyle("display", "none");
		}
		rm.writeStyles();
		var sTooltip = oColumn.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write("><div");
		rm.addClass("sapUiTableColCell");
		rm.writeClasses();
		var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
		if (sHAlign) {
			rm.addStyle("text-align", sHAlign);
		}
		rm.writeStyles();
		rm.write(">");

		// TODO: rework column sort / filter status integration
		rm.write("<div id=\"" + oColumn.getId() + "-icons\" class=\"sapUiTableColIcons\"></div>");

		if (oLabel) {
			rm.renderControl(oLabel);
		}

		rm.write("</div></div>");
	};

	DataTableRenderer.renderColRsz = function(rm, oTable, oColumn, iIndex) {
		if (oColumn.getResizable()) {
			rm.write("<div");
			rm.writeAttribute("id", oColumn.getId() + "-rsz");
			rm.writeAttribute("data-sap-ui-colindex", iIndex);
			rm.writeAttribute("tabindex", "-1");
			rm.addClass("sapUiTableColRsz");
			rm.writeClasses();
			rm.addStyle("left", oTable._bRtlMode ? "99000px" : "-99000px");
			rm.writeStyles();
			rm.write("></div>");
		}
	};


	// =============================================================================
	// CONTENT AREA OF THE TABLE
	// =============================================================================

	DataTableRenderer.renderRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableRowHdrScr");
		rm.writeClasses();
		rm.write(">");

		// start with the first current top visible row
		for (var row = 0, count = oTable.getRows().length; row < count; row++) {
			this.renderRowHdrRow(rm, oTable, oTable.getRows()[row], row);
		}

		rm.write("</div>");
	};

	DataTableRenderer.getAriaAttributesForRowHdrRow = function(oTable, oRow) {
		var mAriaAttributes = {
			"aria-labelledby": {value: oTable.getId() + "-rownumberofrows " + oRow.getId() + "-rowselecttext"}
		};

		var sSelctionMode = oTable.getSelectionMode();
		if (sSelctionMode !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["title"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT")};
			mAriaAttributes["aria-selected"] = {value: "false"};
			if (sSelctionMode === sap.ui.table.SelectionMode.Multi) {
				if (oTable.getSelectedIndices().length > 1) {
					mAriaAttributes["aria-label"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY")};
				}
			} else {
				mAriaAttributes["aria-label"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT_KEY")};
			}
		}

		return mAriaAttributes;
	};

	DataTableRenderer.renderRowHdrRow = function(rm, oTable, oRow, iRowIndex) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-rowsel" + iRowIndex);
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		rm.addClass("sapUiTableRowHdr");
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		rm.writeClasses();
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForRowHdrRow(oTable, oRow);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		var aCellIds = [];
		jQuery.each(oRow.getCells(), function(iIndex, oCell) {
			aCellIds.push(oRow.getId() + "-col" + iIndex);
		});

		rm.writeStyles();
		rm.write("></div>");
	};

	DataTableRenderer.renderTableCtrl = function(rm, oTable) {

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableCtrlScrFixed");
			rm.writeClasses();
			rm.write(">");

			this.renderTableControl(rm, oTable, true);

			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariafixedcolumn");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_FIXED_COLUMN"));
			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableCtrlScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlCnt");
		rm.writeClasses();
		rm.write(">");

		this.renderTableControl(rm, oTable, false);

		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlAfter");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");
		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlEmpty");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write(">");
		if (oTable.getNoData() && oTable.getNoData() instanceof sap.ui.core.Control) {
			rm.renderControl(oTable.getNoData());
		} else {
			rm.write("<span");
			rm.addClass("sapUiTableCtrlEmptyMsg");
			rm.writeClasses();
			rm.write(">");
			if (typeof oTable.getNoData() === "string" || oTable.getNoData() instanceof String) {
				rm.writeEscaped(oTable.getNoData());
			} else if (oTable.getNoDataText()) {
				rm.writeEscaped(oTable.getNoDataText());
			} else {
				rm.writeEscaped(oTable._oResBundle.getText("TBL_NO_DATA"));
			}
			rm.write("</span>");
		}
		rm.write("</div>");
	};


	DataTableRenderer.renderTableControl = function(rm, oTable, bFixedTable) {
		var iStartColumn, iEndColumn;
		if (bFixedTable) {
			iStartColumn = 0;
			iEndColumn = oTable.getFixedColumnCount();
		} else {
			iStartColumn = oTable.getFixedColumnCount();
			iEndColumn = oTable.getColumns().length;
		}
		var iFixedRows = oTable.getFixedRowCount();
		var iFixedBottomRows = oTable.getFixedBottomRowCount();
		var aRows = oTable.getRows();

		if (iFixedRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, true, false, 0, iFixedRows);
		}
		this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, false, iFixedRows, aRows.length - iFixedBottomRows);
		if (iFixedBottomRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, true, aRows.length - iFixedBottomRows, aRows.length);
		}
	};

	DataTableRenderer.getAriaAttributesForTableControlCntColTh = function(oColumn, bHasRowSelector) {
		var mAriaAttributes = {
			"role": {value: "columnheader"},
			"scope": {value: "col"}
		};

		if (bHasRowSelector) {
			mAriaAttributes["aria-owns"] = {value: "" + oColumn.getId()};
			mAriaAttributes["aria-labelledby"] = {value: "" + oColumn.getId()};
		}

		return mAriaAttributes;
	};

	DataTableRenderer.renderTableControlCnt = function(rm, oTable, bFixedTable, iStartColumn, iEndColumn, bFixedRow, bFixedBottomRow, iStartRow, iEndRow) {
		rm.write("<table");
		var sId = oTable.getId() + "-table";

		if (bFixedTable) {
			sId += "-fixed";
			rm.addClass("sapUiTableCtrlFixed");
		} else {
			rm.addClass("sapUiTableCtrlScroll");
		}
		if (bFixedRow) {
			sId += "-fixrow";
			rm.addClass("sapUiTableCtrlRowFixed");
		} else if (bFixedBottomRow) {
			sId += "-fixrow-bottom";
			rm.addClass("sapUiTableCtrlRowFixedBottom");
		} else {
			rm.addClass("sapUiTableCtrlRowScroll");
		}
		rm.writeAttribute("id", sId);
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "grid");
		}
		rm.addClass("sapUiTableCtrl");
		rm.writeClasses();
		rm.addStyle("min-width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		//Firefox and chrome and safari need a defined width for the fixed table
		if (bFixedTable && (!!sap.ui.Device.browser.firefox || !!sap.ui.Device.browser.chrome || !!sap.ui.Device.browser.safari)) {
			rm.addStyle("width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		}
		rm.writeStyles();
		rm.write(">");

		rm.write("<thead>");

		rm.write("<tr");
		rm.addClass("sapUiTableCtrlCol");
		if (iStartRow == 0) {
			rm.addClass("sapUiTableCtrlFirstCol");
		}
		rm.writeClasses();
		rm.write(">");

		var aCols = oTable.getColumns();
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.write("<th");
			rm.addStyle("width", "0px");
			rm.writeStyles();
			if (iStartRow == 0) {
				var mAriaAttributes = this.getAriaAttributesForTableControlCntColTh(oColumn);
				this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);
				rm.writeAttribute("id", oTable.getId() + "_colsel");
			}
			rm.write("></th>");
		} else {
			if (aCols.length === 0) {
				// no cols => render th => avoids rendering issue in firefox
				rm.write("<th></th>");
			}
		}

		for (var col = iStartColumn, count = iEndColumn; col < count; col++) {
			var oColumn = aCols[col];
			if (oColumn && oColumn.shouldRender()) {
				rm.write("<th");
				rm.addStyle("width", oColumn.getWidth());
				rm.writeStyles();
				if (iStartRow == 0) {
					var mAriaAttributes = this.getAriaAttributesForTableControlCntColTh(oColumn, true);
					this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);
					rm.writeAttribute("id", oTable.getId() + "_col" + col);
				}
				rm.writeAttribute("data-sap-ui-headcolindex", col);
				rm.write(">");
				if (iStartRow == 0 && oTable._getHeaderRowCount() == 0) {
					if (oColumn.getMultiLabels().length > 0) {
						rm.renderControl(oColumn.getMultiLabels()[0]);
					} else {
						rm.renderControl(oColumn.getLabel());
					}
				}
				rm.write("</th>");
			}
		}

		// dummy column to fill the table width
		if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCols.length > 0) {
			rm.write("<th></th>");
		}

		rm.write("</tr>");
		rm.write("</thead>");

		rm.write("<tbody>");

		var aVisibleColumns = oTable._getVisibleColumns();
		var bHasOnlyFixedColumns = oTable._hasOnlyFixColumnWidths();

		// render the table rows
		var aRows = oTable.getRows();
		// retrieve tooltip and aria texts only once and pass them to the rows _updateSelection function
		var mTooltipTexts = oTable._getAriaTextsForSelectionMode(true);

		// check whether the row can be clicked to change the selection
		var bSelectOnCellsAllowed = oTable._getSelectOnCellsAllowed();
		for (var row = iStartRow, count = iEndRow; row < count; row++) {
			this.renderTableRow(rm, oTable, aRows[row], row, bFixedTable, iStartColumn, iEndColumn, false, aVisibleColumns, bHasOnlyFixedColumns, mTooltipTexts, bSelectOnCellsAllowed);
		}

		rm.write("</tbody>");
		rm.write("</table>");
	};

	DataTableRenderer.getAriaAttributesForRowTr = function(oTable, iRowIndex, aCells) {
		var mAriaAttributes = {};

		mAriaAttributes["role"] = {value: "row"};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}

		return mAriaAttributes;
	};

	DataTableRenderer.getAriaAttributesForRowTd = function(oTable, oRow, iRowIndex, aCells) {
		var mAriaAttributes = {};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			mAriaAttributes["role"] = {value: "rowheader"};
		} else {
			if (aCells.length === 0) {
				mAriaAttributes["role"] = {value: "gridcell"};
			}
		}

		mAriaAttributes["headers"] = {value: oTable.getId() + "_colsel"};
		mAriaAttributes["aria-owns"] = {value: oTable.getId() + "-rowsel" + iRowIndex};
		mAriaAttributes["role"] = {value: "rowheader"};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}

		return mAriaAttributes;
	};

	DataTableRenderer.renderTableRow = function(rm, oTable, oRow, iRowIndex, bFixedTable, iStartColumn, iEndColumn, bFixedRow, aVisibleColumns, bHasOnlyFixedColumns, mTooltipTexts, bSelectOnCellsAllowed) {

		rm.write("<tr");
		rm.addClass("sapUiTableTr");
		if (bFixedTable) {
			rm.writeAttribute("id", oRow.getId() + "-fixed");
		} else {
			rm.writeElementData(oRow);
		}
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		if (iRowIndex % 2 === 0) {
			rm.addClass("sapUiTableRowEven");
		} else {
			rm.addClass("sapUiTableRowOdd");
		}
		rm.writeClasses();
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}
		rm.writeStyles();

		var mAriaAttributes = this.getAriaAttributesForRowTr(oTable);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.write(">");
		var aCells = oRow.getCells();
		// render the row headers
		if ((oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) ||
			aCells.length === 0) {
			rm.write("<td");
			var mAriaAttributes = this.getAriaAttributesForRowTd(oTable, oRow, iRowIndex, aCells);
			this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

			rm.write(">");
			if (oTable._bAccMode) {
				rm.write("<div");
				rm.writeAttribute("id", oRow.getId() + "-rowselecttext");
				rm.addClass("sapUiTableAriaRowSel");
				rm.writeClasses();
				rm.write(">");
				rm.write("</div>");
			}
			rm.write("</td>");
		}

		for (var cell = 0, count = aCells.length; cell < count; cell++) {
			this.renderTableCell(rm, oTable, oRow, aCells[cell], cell, bFixedTable, iStartColumn, iEndColumn, aVisibleColumns);
		}
		if (!bFixedTable && bHasOnlyFixedColumns && aCells.length > 0) {
			rm.write("<td></td>");
		}
		rm.write("</tr>");

		// because property changes of the table lead to re-rendering but the selection state might
		// remain, it's required to update tooltips and aria description according to the selection.
		// delay this call to make sure it happens when the DOM is rendered. Otherwise some elements
		// might not be rendered yet.
		jQuery.sap.delayedCall(0, this, function() {
			oRow._updateSelection(oTable, mTooltipTexts, bSelectOnCellsAllowed);
		});

	};

	DataTableRenderer.getAriaAttributesForCell = function(oTable, bFixedTable, oRow, oColumn, iColIndex, oCell) {
		var mAriaAttributes = {};

		mAriaAttributes["headers"] = {value: oTable.getId() + "_col" + iColIndex};
		mAriaAttributes["role"] = {value: "gridcell"};

		var sRowSelectorId = oTable.getId() + "-rownumberofrows";


		var aMultiLabels = oColumn.getMultiLabels();
		var iMultiLabels = aMultiLabels.length;
		var sLabels = "";

		// get IDs of column labels
		if (oTable.getColumnHeaderVisible()) {
			var sColumnId = oColumn.getId();
			// first column header has no suffix, just the column ID
			sLabels = sColumnId;
			if (iMultiLabels > 1) {
				for (var i = 1; i < iMultiLabels; i++) {
					// for all other column header rows we add the suffix
					sLabels += " " + sColumnId + "_" + i;
				}
			}
		} else {
			// column header is not rendered therfore there is no <div> tag. Link aria description to label
			var oLabel;
			if (iMultiLabels == 0) {
				oLabel = oColumn.getLabel();
				if (oLabel) {
					sLabels = oLabel.getId();
				}
			} else {
				for (var i = 0; i < iMultiLabels; i++) {
					// for all other column header rows we add the suffix
					oLabel = aMultiLabels[i];
					if (oLabel) {
						sLabels += " " + oLabel.getId() + " ";
					}
				}
			}
		}


		var sLabelledBy = sRowSelectorId + " " + oTable.getId() + "-ariadesc " + sLabels;

		sLabelledBy +=  " " + oCell.getId();

		var sDescribedBy = "";
		if (bFixedTable) {
			sLabelledBy += " " + oTable.getId() + "-ariafixedcolumn";
		}

		mAriaAttributes["aria-labelledby"] = {value: sLabelledBy};
		mAriaAttributes["aria-describedby"] = {value: oTable.getId() + "-toggleedit" + sDescribedBy};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}


		return mAriaAttributes;
	};

	DataTableRenderer.renderTableCell = function(rm, oTable, oRow, oCell, iCellIndex, bFixedTable, iStartColumn, iEndColumn, aVisibleColumns) {
		var iColIndex = oCell.data("sap-ui-colindex");
		var oColumn = oTable.getColumns()[iColIndex];
		if (oColumn.shouldRender() && iStartColumn <= iColIndex && iEndColumn > iColIndex) {
			rm.write("<td");
			var sId = oRow.getId() + "-col" + iCellIndex;
			rm.writeAttribute("id", sId);
			rm.writeAttribute("tabindex", "-1");

			var mAriaAttributes = this.getAriaAttributesForCell(oTable, bFixedTable, oRow, oColumn, iColIndex, oCell);
			this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

			var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
			if (sHAlign) {
				rm.addStyle("text-align", sHAlign);
			}
			rm.writeStyles();
			if (aVisibleColumns.length > 0 && aVisibleColumns[0] === oColumn) {
				rm.addClass("sapUiTableTdFirst");
			}
			// grouping support to show/hide values of grouped columns
			if (oColumn.getGrouped()) {
				rm.addClass("sapUiTableTdGroup");
			}
			rm.writeClasses();
			rm.write("><div");
			rm.addClass("sapUiTableCell");

			rm.writeClasses();

			if (oTable.getRowHeight() && oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
				rm.addStyle("max-height", oTable.getRowHeight() + "px");
			}
			rm.writeStyles();

			rm.write(">");
			this.renderTableCellControl(rm, oTable, oCell, iCellIndex);
			rm.write("</div></td>");
		}
	};

	DataTableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
		if (oTable.isTreeBinding("rows") && iCellIndex === 0 && !oTable.getUseGroupMode()) {
			rm.write("<span");
			rm.addClass("sapUiTableTreeIcon");
			rm.addClass("sapUiTableTreeIconLeaf");
			rm.writeClasses();
			rm.writeAttribute("tabindex", -1);
			rm.write(">&nbsp;</span>");
		}
		rm.renderControl(oCell);
	};

	DataTableRenderer.renderVSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableVSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oVSb);
		rm.write("</div>");
	};

	DataTableRenderer.renderHSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableHSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oHSb);
		rm.write("</div>");
	};


	// =============================================================================
	// HELPER FUNCTIONALITY
	// =============================================================================

	/**
	 * Returns the value for the HTML "align" attribute according to the given
	 * horizontal alignment and RTL mode, or NULL if the HTML default is fine.
	 *
	 * @param {sap.ui.core.HorizontalAlign} oHAlign
	 * @param {boolean} bRTL
	 * @type string
	 */
	DataTableRenderer.getHAlign = function(oHAlign, bRTL) {
	  switch (oHAlign) {
		case sap.ui.core.HorizontalAlign.Center:
		  return "center";
		case sap.ui.core.HorizontalAlign.End:
		case sap.ui.core.HorizontalAlign.Right:
		  return bRTL ? "left" : "right";
	  }
	  // case sap.ui.core.HorizontalAlign.Left:
	  // case sap.ui.core.HorizontalAlign.Begin:
	  return bRTL ? "right" : "left";
	};




	return DataTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/DataTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TablePersoController') ) {
/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides TablePersoController
jQuery.sap.declare('sap.ui.table.TablePersoController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TablePersoController",['jquery.sap.global', 'sap/ui/base/ManagedObject'],
	function(jQuery, ManagedObject) {
	"use strict";


	/**
	 * Constructor for a new TablePersoController.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The TablePersoController can be used to connect a table with a persistence service.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.36.5
	 * @since 1.21.1
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.TablePersoController
	 */
	var TablePersoController = ManagedObject.extend("sap.ui.table.TablePersoController", /** @lends sap.ui.table.TablePersoController.prototype */ {

		constructor: function(sId, mSettings) {
			ManagedObject.apply(this, arguments);
		},

		metadata: {
			properties: {

				/**
				 * Auto save state
				 */
				"autoSave": {
					type: "boolean",
					defaultValue: true
				},

				/**
				 * Personalization Service object. Needs to have the following methods:
				 * <ul>
				 * <li>getPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * <li>setPersData(oBundle) : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * <li>delPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * </ul>
				 */
				"persoService": {
					type: "any"
				},

				/**
				 * By defining a custom data key the <code>TablePersoController</code>
				 * will try to get the key for saving the perso data from the custom
				 * data of the Table and Column instead of creating it by concatenating
				 * the ID of the Table and the Column. Basically this will be more stable
				 * than using the auto IDs.
				 */
				"customDataKey": {
					type: "string",
					defaultValue: "persoKey"
				}
			},
			associations: {
				/**
				 * The target table of this controller.
				 */
				"table": {
					type: "sap.ui.table.Table",
					multiple: false
				}
			},
			library: "sap.ui.table"
		}

	});

	/**
	 * @private
	 */
	TablePersoController.prototype.init = function() {

		// Table Personalization schema
		this._schemaProperty = "_persoSchemaVersion";
		this._schemaVersion = "1.0";

		this._oInitialPersoData = null;

		this._aTableEvents = ["columnResize", "columnMove", "columnVisibility", "sort", "filter", "group"];
		this._aColumnProperties = ["visible", "width", "sorted", "sortOrder", "grouped", "summed"];

		this._bSaveFilters = false;
		if (this._bSaveFilters) {
			this._aTableEvents.push("filter");
			this._aColumnProperties.push("filtered");
			this._aColumnProperties.push("filterValue");
		}

	};

	/**
	 * @private
	 */
	TablePersoController.prototype.exit = function() {

		var oTable = this._getTable();

		if (oTable) {
			this._manageTableEventHandlers(oTable, false);
		}

		delete this._schemaProperty;
		delete this._schemaVersion;

		delete this._oInitialPersoData;

		delete this._oDialog;

	};

	TablePersoController.prototype.setPersoService = function(oService) {
		oService = this.validateProperty("persoService", oService);
		if (oService &&
			(!jQuery.isFunction(oService.getPersData) ||
			!jQuery.isFunction(oService.setPersData) ||
			!jQuery.isFunction(oService.delPersData))) {
			throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods " +
					"\"getPersData\", \"setPersData\" and \"delPersData\".");
		}

		var oOldService = this.getPersoService();
		this.setProperty("persoService", oService, true);
		var oNewService = this.getPersoService();

		// refresh data using new service if there was a new service set and a table was set
		if (oNewService && oNewService !== oOldService && this._getTable() && (this.getAutoSave() || !oOldService )) {
			this.refresh();
		}

		return this;
	};

	TablePersoController.prototype.setAutoSave = function(bAutoSave) {
		var oOldValue = this.getAutoSave();
		this.setProperty("autoSave", bAutoSave, true);
		var oNewValue = this.getAutoSave();

		// save data if autoSave is turned from false to true
		if (oNewValue && !oOldValue) {
			this.savePersonalizations();
		}

		return this;
	};

	TablePersoController.prototype.setTable = function(vTable) {
		var oOldTable = this._getTable();
		if (oOldTable) {
			oOldTable._oPersoController = undefined; // remove the relationship to the controller
		}
		this.setAssociation("table", vTable, true);
		var oNewTable = this._getTable();
		if (oNewTable) {
			oNewTable._oPersoController = this; // set the relationship to controller (debugging & performance opts)
		}

		// detach handlers from old table
		if (oOldTable) {
			this._manageTableEventHandlers(oOldTable, false);
		}

		if (oNewTable && oNewTable !== oOldTable) {

			// save initial table configuration (incl. text for perso dialog)
			this._oInitialPersoData = this._getCurrentTablePersoData(true);

			// attach handlers to new table
			this._manageTableEventHandlers(oNewTable, true);

			// only refresh if there is a service set and autoSave is on or no table was set before
			if (this.getPersoService() && (this.getAutoSave() || !oOldTable )) {
				this.refresh();
			}
		} else if (!oNewTable) {
			// remove initial data if table is set to null
			this._oInitialPersoData = null;
		}

		return this;
	};

	TablePersoController.prototype.setCustomDataKey = function(sCustomDataKey) {
		var sOldValue = this.getCustomDataKey();
		this.setProperty("customDataKey", sCustomDataKey, true);
		var sNewValue = this.getCustomDataKey();

		// save data if the autosave is on and the perso key has been changed
		if (sOldValue !== sNewValue && this.getAutoSave()) {
			this.savePersonalizations();
		}

		return this;
	};

	TablePersoController.prototype._manageTableEventHandlers = function(oTable, bAttach) {
		// attach or detach the Table Event Handlers (necessary for autosave)
		for (var i = 0, l = this._aTableEvents.length; i < l; i++) {
			var fn = oTable[(bAttach ? "attachEvent" : "detachEvent")];
			fn.apply(oTable, [this._aTableEvents[i], this._tableEventHandler, this]);
		}
	};

	/**
	 * Refresh the personalizations (reloads data from service).
	 *
	 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the refresh is finished
	 * @public
	 */
	TablePersoController.prototype.refresh = function() {
		var that = this;

		var oService = this.getPersoService();
		if (oService) {
			return oService.getPersData().done(function(oServiceData) {
				var oData = (oServiceData && jQuery.isArray(oServiceData.aColumns))
						? oServiceData
						: that._oInitialPersoData; // use initial column definitions
				that._adjustTable(oData);
			}).fail(function() {
				jQuery.sap.log.error("Problem reading persisted personalization data.");
			});
		} else {
			jQuery.sap.log.error("The Personalization Service is not available!");
			// return a dummy promise and reject it immediately
			var oDeferred = jQuery.Deferred();
			oDeferred.reject();
			return oDeferred.promise();
		}
	};

	/**
	 * Saves the current personalization state.
	 *
	 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the save is finished
	 * @public
	 */
	TablePersoController.prototype.savePersonalizations = function() {
		var oService = this.getPersoService();
		if (oService) {

			var oData = this._getCurrentTablePersoData();
			oData[this._schemaProperty] = this._schemaVersion;

			return oService.setPersData(oData).fail(function() {
				jQuery.sap.log.error("Problem persisting personalization data.");
			});

		} else {
			jQuery.sap.log.error("The Personalization Service is not available!");
			// return a dummy promise and reject it immediately
			var oDeferred = jQuery.Deferred();
			oDeferred.reject();
			return oDeferred.promise();
		}
	};

	TablePersoController.prototype._adjustTable = function(oData) {
		var oTable = this._getTable();
		if (!oTable || !oData || !jQuery.isArray(oData.aColumns)) {
			return;
		}

		// create a persoKey to column map
		var mColumns = {}, aCols = oTable.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			mColumns[this._getColumnPersoKey(aCols[i])] = aCols[i];
		}

		var aColumns = oData.aColumns;

		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumnInfo = aColumns[i]; // P13N info object
			var oColumn = mColumns[oColumnInfo.id];

			// only if the column is available in the table
			// e.g. if the Table has been removed or renamed => ignore!
			if (oColumn) {

				// apply the order
				if (oTable.indexOfColumn(oColumn) !== oColumnInfo.order) {
					oTable.removeColumn(oColumn);
					oTable.insertColumn(oColumn, oColumnInfo.order);
				}

				var oMetadata = oColumn.getMetadata();
				for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
					var sProperty = this._aColumnProperties[j];
					if (oColumnInfo[sProperty] !== undefined) {
						try {
							if (oMetadata.hasProperty(sProperty) && oColumn.getProperty(sProperty) != oColumnInfo[sProperty]) {
								oColumn.setProperty(sProperty, oColumnInfo[sProperty]);
							}
						} catch (ex) {
							jQuery.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \"" + oColumn[sProperty] + "\" for the property + \"" + sProperty + "\".");
						}
					}
				}

			}

		}

		if (typeof oTable._onPersoApplied === "function") {
			oTable._onPersoApplied();
		}

	};

	TablePersoController.prototype._tableEventHandler = function(oEvent) {
		if (this.getAutoSave() && !this._iTriggerSaveTimeout) {
			var that = this;
			this._iTriggerSaveTimeout = setTimeout(function() {
				that.savePersonalizations();
				that._iTriggerSaveTimeout = null;
			}, 0);
		}
	};

	TablePersoController.prototype._getCurrentTablePersoData = function(bForDialog) {
		var oTable = this._getTable(),
			aColumns = oTable.getColumns();

		var oData = {
			aColumns: []
		};

		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumn = aColumns[i];
			var sPersoKey = this._getColumnPersoKey(oColumn);
			var oColumnInfo = {
				id: sPersoKey,
				order: i
			};
			var oMetadata = oColumn.getMetadata();
			for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
				var sProperty = this._aColumnProperties[j];
				if (oMetadata.hasProperty(sProperty)) {
					oColumnInfo[sProperty] = oColumn.getProperty(sProperty);
				}
			}
			if (bForDialog) {
				oColumnInfo.text = oColumn.getLabel() && oColumn.getLabel().getText() || sPersoKey;
			}
			oData.aColumns.push(oColumnInfo);
		}

		return oData;
	};

	TablePersoController.prototype._getTable = function() {
		return sap.ui.getCore().byId(this.getTable());
	};

	TablePersoController.prototype._getColumnPersoKey = function(oColumn) {
		return this._getPersoKey(this._getTable()) + "-" + this._getPersoKey(oColumn);
	};

	TablePersoController.prototype._getPersoKey = function(oControl) {
		var sPersoKey = oControl.data(this.getCustomDataKey());
		if (!sPersoKey) {
			sPersoKey = oControl.getId();
			if (sPersoKey.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix()) === 0) {
				jQuery.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \"" + oControl.getId() + "\")");
			}
		}
		return sPersoKey;
	};

	/**
	 * Opens the personalization dialog for the Table to modify the visibility and
	 * the order of the columns.
	 *
	 * <i>Using this functionality will require to load the sap.m library because the
	 * personalization dialog is only available in this library for now.</i>
	 *
	 * @param {object} mSettings
	 * @public
	 * @experimental since 1.21.2 - API might change / feature requires the sap.m library!
	 */
	TablePersoController.prototype.openDialog = function(mSettings) {

		// include the mobile library to re-use the sap.m.TablePersoDialog
		sap.ui.getCore().loadLibrary("sap.m");
		jQuery.sap.require("sap.m.TablePersoDialog");

		// create and open the dialog
		if (!this._oDialog) {
			var that = this;
			this._oDialog = new sap.m.TablePersoDialog({
				persoService: this.getPersoService(),
				showSelectAll: true,
				showResetAll: true,
				grouping: false,
				contentWidth: mSettings && mSettings.contentWidth,
				contentHeight: mSettings && mSettings.contentHeight || "20rem",
				initialColumnState: this._oInitialPersoData.aColumns,
				columnInfoCallback: function(oTable, mPersoMap, oPersoService) {
					return that._getCurrentTablePersoData(true).aColumns;
				},
				confirm : function() {
					that._adjustTable(this.retrievePersonalizations());
					if (that.getAutoSave()) {
						that.savePersonalizations();
					}
				}
			});
			this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding"); // otherwise height calculation doesn't work properly!
			jQuery.sap.syncStyleClass("sapUiSizeCompact", this._getTable(), this._oDialog._oDialog);
		}

		this._oDialog.open();

	};


	return TablePersoController;

}, /* bExport= */ true);

}; // end of sap/ui/table/TablePersoController.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.Table
jQuery.sap.declare('sap.ui.table.TableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TableRenderer",['jquery.sap.global', 'sap/ui/core/theming/Parameters'],
	function(jQuery, Parameters) {
	"use strict";


	/**
	 * Table renderer.
	 * @namespace
	 */
	var TableRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oTable an object representation of the control that should be rendered
	 */
	TableRenderer.render = function(rm, oTable) {
		// create the rows of the table
		// (here we could think about a swith to allow the programmatic usage of the table)
		oTable._createRows();

		// basic table div
		rm.write("<div");
		if (oTable._bAccMode) {
			var aAriaOwnsIds = [];
			if (oTable.getToolbar()) {
				aAriaOwnsIds.push(oTable.getToolbar().getId());
			}
			aAriaOwnsIds.push(oTable.getId() + "-table");
			rm.writeAttribute("aria-owns", aAriaOwnsIds.join(" "));
			rm.writeAttribute("aria-readonly", "true");
			if (oTable.getTitle()) {
				rm.writeAttribute("aria-labelledby", oTable.getTitle().getId());
			}
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-multiselectable", "true");
			}
		}
		rm.writeControlData(oTable);
		rm.addClass("sapUiTable");
		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode());
		if (oTable.getColumnHeaderVisible()) {
			rm.addClass("sapUiTableCHdr"); // show column headers
		}
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.addClass("sapUiTableRSel"); // show row selector
		}

		// This class flags whether the sap.m. library is loaded or not.
		var sSapMTableClass = sap.ui.table.TableHelper.addTableClass();
		if (sSapMTableClass) {
			rm.addClass(sSapMTableClass);
		}

		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode()); // row selection mode
		//rm.addClass("sapUiTableHScr"); // show horizontal scrollbar
		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
			rm.addClass("sapUiTableVScr"); // show vertical scrollbar
		}
		if (oTable.getEditable()) {
			rm.addClass("sapUiTableEdt"); // editable (background color)
		}
		rm.addClass("sapUiTableShNoDa");
		if (oTable.getShowNoData() && oTable._getRowCount() === 0) {
			rm.addClass("sapUiTableEmpty"); // no data!
		}
		if (oTable.getEnableGrouping()) {
			rm.addClass("sapUiTableGrouping");
		}
		rm.writeClasses();
		if (oTable.getWidth()) {
			rm.addStyle("width", oTable.getWidth());
		}
		rm.writeStyles();
		rm.write(">");

		if (oTable.getTitle()) {
			this.renderHeader(rm, oTable, oTable.getTitle());
		}

		if (oTable.getToolbar()) {
			this.renderToolbar(rm, oTable, oTable.getToolbar());
		}

		if (oTable.getExtension() && oTable.getExtension().length > 0) {
			this.renderExtensions(rm, oTable, oTable.getExtension());
		}

		rm.write("<div");
		rm.addClass("sapUiTableCnt");
		rm.writeClasses();
		// Define group for F6 handling
		rm.writeAttribute("data-sap-ui-fastnavgroup", "true");
		if (oTable._bAccMode) {
			rm.writeAttribute("aria-describedby", oTable.getId() + "-ariacount");
		}
		rm.write(">");

		this.renderColHdr(rm, oTable);

		this.renderTable(rm, oTable);

		if (oTable._bAccMode) {
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariadesc");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			if (oTable.getTitle() && oTable.getTitle().getText && oTable.getTitle().getText() != "") {
				rm.writeEscaped(oTable.getTitle().getText());
			} else {
				rm.write(oTable._oResBundle.getText("TBL_TABLE"));
			}

			rm.write("</span>");
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariacount");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write("</span>");
			// aria description for toggling the edit mode
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-toggleedit");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_TOGGLE_EDIT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY"));
			rm.write("</span>");
			// table row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-rownumberofrows");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write("</span>");
		}

		rm.write("</div>");

		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			rm.write("<div");
			rm.addClass("sapUiTablePaginator");
			rm.writeClasses();
			rm.write(">");
			if (!oTable._oPaginator) {
				jQuery.sap.require("sap.ui.commons.Paginator");
				oTable._oPaginator = new sap.ui.commons.Paginator(oTable.getId() + "-paginator");
				oTable._oPaginator.attachPage(jQuery.proxy(oTable.onvscroll, oTable));
			}
			rm.renderControl(oTable._oPaginator);
			rm.write("</div>");
		}

		if (oTable.getFooter()) {
			this.renderFooter(rm, oTable, oTable.getFooter());
		}

		if (oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Interactive) {
			this.renderVariableHeight(rm ,oTable);
		}

		rm.write("</div>");

	};

	// =============================================================================
	// BASIC AREAS OF THE TABLE
	// =============================================================================

	TableRenderer.renderHeader = function(rm, oTable, oTitle) {
		rm.write("<div");
		rm.addClass("sapUiTableHdr");
		rm.writeClasses();
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "heading");
		}
		rm.write(">");

		rm.renderControl(oTitle);

		rm.write("</div>");
	};

	TableRenderer.renderToolbar = function(rm, oTable, oToolbar) {
		rm.write("<div");
		rm.addClass("sapUiTableTbr");
		if (typeof oToolbar.getStandalone !== "function") {
			// for the mobile toolbar we add another class
			rm.addClass("sapUiTableMTbr");
		}
		rm.writeClasses();
		rm.write(">");

		// toolbar has to be embedded (not standalone)!
		if (typeof oToolbar.getStandalone === "function" && oToolbar.getStandalone()) {
			oToolbar.setStandalone(false);
		}

		// set the default design of the toolbar
		if (sap.m && sap.m.Toolbar && oToolbar instanceof sap.m.Toolbar) {
			oToolbar.setDesign(Parameters.get("sapUiTableToolbarDesign"), true);
		}

		rm.renderControl(oToolbar);

		rm.write("</div>");
	};

	TableRenderer.renderExtensions = function(rm, oTable, aExtensions) {
		for (var i = 0, l = aExtensions.length; i < l; i++) {
			this.renderExtension(rm, oTable, aExtensions[i]);
		}
	};

	TableRenderer.renderExtension = function(rm, oTable, oExtension) {
		rm.write("<div");
		rm.addClass("sapUiTableExt");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oExtension);

		rm.write("</div>");
	};

	TableRenderer.renderTable = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableCCnt");
		rm.writeClasses();
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlBefore");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");

		this.renderRowHdr(rm, oTable);
		this.renderTableCtrl(rm, oTable);
		this.renderVSb(rm, oTable);

		rm.write("</div>");

		this.renderHSb(rm, oTable);

	};

	TableRenderer.renderFooter = function(rm, oTable, oFooter) {
		rm.write("<div");
		rm.addClass("sapUiTableFtr");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oFooter);

		rm.write("</div>");
	};

	TableRenderer.renderVariableHeight = function(rm, oTable) {
		rm.write('<div id="' + oTable.getId() + '-sb" tabIndex="-1"');
		rm.addClass("sapUiTableSplitterBar");
		rm.addStyle("height", "5px");
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.write("</div>");
	};

	// =============================================================================
	// COLUMN HEADER OF THE TABLE
	// =============================================================================

	TableRenderer.renderColHdr = function(rm, oTable) {

		rm.write("<div");
		rm.addClass("sapUiTableColHdrCnt");
		rm.writeClasses();
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", (oTable.getColumnHeaderHeight() * oTable._getHeaderRowCount()) + "px");
		}
		if (oTable._bAccMode &&
			 (oTable.getSelectionMode() === sap.ui.table.SelectionMode.None ||
					 oTable.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
			rm.writeAttribute("role", "row");
		}
		rm.writeStyles();
		rm.write(">");

		this.renderColRowHdr(rm, oTable);

		var aCols = oTable.getColumns();

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableColHdrFixed");
			rm.writeClasses();
			rm.write(">");

			for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

				rm.write("<div");
				rm.addClass("sapUiTableColHdr");
				rm.writeClasses();
				rm.addStyle("min-width", oTable._getColumnsWidth(0, oTable.getFixedColumnCount()) + "px");
				rm.writeStyles();
				rm.write(">");

				var iSpan = 1;
				for (var i = 0, l = oTable.getFixedColumnCount(); i < l; i++) {
					if (aCols[i] && aCols[i].shouldRender()) {
						if (iSpan <= 1) {
							this.renderCol(rm, oTable, aCols[i], i, h);
							var aHeaderSpan = aCols[i].getHeaderSpan();
							if (jQuery.isArray(aHeaderSpan)) {
								iSpan = aCols[i].getHeaderSpan()[h] + 1;
							} else {
								iSpan = parseInt(aCols[i].getHeaderSpan(), 10) + 1;
							}
						} else {
							//Render column header but this is invisible because of the span
							this.renderCol(rm, oTable, aCols[i], i, h, true);
						}
						if (h == 0) {
							this.renderColRsz(rm, oTable, aCols[i], i);
						}
						iSpan--;
					}
				}

				rm.write("<p style=\"clear: both;\"></p>");
				rm.write("</div>");

			}

			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableColHdrScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

			rm.write("<div");
			rm.addClass("sapUiTableColHdr");
			rm.writeClasses();
			rm.addStyle("min-width", oTable._getColumnsWidth(oTable.getFixedColumnCount(), aCols.length) + "px");
			rm.writeStyles();
			rm.write(">");

			var iSpan = 1;
			for (var i = oTable.getFixedColumnCount(), l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					if (iSpan <= 1) {
						this.renderCol(rm, oTable, aCols[i], i, h);
						var aHeaderSpan = aCols[i].getHeaderSpan();
						if (jQuery.isArray(aHeaderSpan)) {
							iSpan = aCols[i].getHeaderSpan()[h] + 1;
						} else {
							iSpan = parseInt(aCols[i].getHeaderSpan(), 10) + 1;
						}
					} else {
						//Render column header but this is invisible because of the span
						this.renderCol(rm, oTable, aCols[i], i, h, true);
					}
					if (h == 0) {
						this.renderColRsz(rm, oTable, aCols[i], i);
					}
					iSpan--;
				}
			}

			rm.write("<p style=\"clear: both;\"></p>");
			rm.write("</div>");

		}

		rm.write("</div>");

		rm.write("</div>");

	};

	/**
	 * This function renders aria attributes if bAccMode is true.
	 * @param {sap.ui.core.RenderManager} rm Instance of the RenderManager
	 * @param {Map} mAriaAttributes Map of aria attributes. The Key of the maps equals the attribute name
	 * @param {Boolean} bAccMode Flag if Acc Mode is turned on
	 */
	TableRenderer.renderAriaAttributes = function(rm, mAriaAttributes, bAccMode) {
		if (bAccMode) {
			for (var sKey in mAriaAttributes) {
				var mAriaAttribute = mAriaAttributes[sKey];
				if (mAriaAttribute.escaped) {
					rm.writeAttributeEscaped(sKey, mAriaAttribute.value);
				} else {
					rm.writeAttribute(sKey, mAriaAttribute.value);
				}
			}
		}
	};

	TableRenderer.getAriaAttributesForRowHdr = function(oTable) {
		return {
			"aria-label": {value: oTable._oResBundle.getText("TBL_SELECT_ALL_KEY"), escaped: true}
		};
	};

	TableRenderer.renderColRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-selall");
		var oSelMode = oTable.getSelectionMode();
		if ((oSelMode == "Multi" || oSelMode == "MultiToggle") && oTable.getEnableSelectAll()) {
			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_SELECT_ALL"));
			//TODO: remove second _getSelectableRowCount Call!
			if (oTable._getSelectableRowCount() == 0 || oTable._getSelectableRowCount() !== oTable.getSelectedIndices().length) {
				rm.addClass("sapUiTableSelAll");
			}
			rm.addClass("sapUiTableSelAllEnabled");
		}
		rm.addClass("sapUiTableColRowHdr");
		rm.writeClasses();

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForRowHdr(oTable);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.write(">");
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.Single) {
			rm.write("<div");
			rm.addClass("sapUiTableColRowHdrIco");
			rm.writeClasses();
			if (oTable.getColumnHeaderHeight() > 0) {
				rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
			}
			rm.write(">");
			rm.write("</div>");
		}
		rm.write("</div>");
	};

	TableRenderer.getAriaAttributesForCol = function(oTable, oColumn, iColumnIndex) {
		var mAriaAttributes = {};

		// aria-haspopup should only be added if the column has a column menu
		// the column menu always gets created but might have no items.
		if (oColumn._menuHasItems()) {
			mAriaAttributes["aria-haspopup"] = {value: "true"};
		}

		mAriaAttributes.role = {value: "columnheader"};

		if (iColumnIndex < oTable.getFixedColumnCount()) {
			mAriaAttributes["aria-labelledby"] = {value: oColumn.getId() + " " + oTable.getId() + "-ariafixedcolumn"};
		}

		return mAriaAttributes;
	};

	TableRenderer.renderCol = function(rm, oTable, oColumn, iIndex, iHeader, bInvisible) {
		var oLabel;
		if (oColumn.getMultiLabels().length > 0) {
			oLabel = oColumn.getMultiLabels()[iHeader];
		} else if (iHeader == 0) {
			oLabel = oColumn.getLabel();
		}

		rm.write("<div");
		if (iHeader === 0) {
			rm.writeElementData(oColumn);
		} else {
			// TODO: we need a writeElementData with suffix - it is another HTML element
			//       which belongs to the same column but it is not in one structure!
			rm.writeAttribute('id', oColumn.getId() + "_" + iHeader);
		}
		rm.writeAttribute('data-sap-ui-colid', oColumn.getId());
		rm.writeAttribute("data-sap-ui-colindex", iIndex);

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForCol(oTable, oColumn, iIndex);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.addClass("sapUiTableCol");
		if (oTable.getFixedColumnCount() === iIndex + 1) {
			rm.addClass("sapUiTableColLastFixed");
		}

		rm.writeClasses();
		rm.addStyle("width", oColumn.getWidth());
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
		}
		if (bInvisible) {
			rm.addStyle("display", "none");
		}
		rm.writeStyles();
		var sTooltip = oColumn.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write("><div");
		rm.addClass("sapUiTableColCell");
		rm.writeClasses();
		var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
		if (sHAlign) {
			rm.addStyle("text-align", sHAlign);
		}
		rm.writeStyles();
		rm.write(">");

		// TODO: rework column sort / filter status integration
		rm.write("<div id=\"" + oColumn.getId() + "-icons\" class=\"sapUiTableColIcons\"></div>");

		if (oLabel) {
			rm.renderControl(oLabel);
		}

		rm.write("</div></div>");
	};

	TableRenderer.renderColRsz = function(rm, oTable, oColumn, iIndex) {
		if (oColumn.getResizable()) {
			rm.write("<div");
			rm.writeAttribute("id", oColumn.getId() + "-rsz");
			rm.writeAttribute("data-sap-ui-colindex", iIndex);
			rm.writeAttribute("tabindex", "-1");
			rm.addClass("sapUiTableColRsz");
			rm.writeClasses();
			rm.addStyle("left", oTable._bRtlMode ? "99000px" : "-99000px");
			rm.writeStyles();
			rm.write("></div>");
		}
	};


	// =============================================================================
	// CONTENT AREA OF THE TABLE
	// =============================================================================

	TableRenderer.renderRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableRowHdrScr");
		rm.writeClasses();
		rm.write(">");

		// start with the first current top visible row
		for (var row = 0, count = oTable.getRows().length; row < count; row++) {
			this.renderRowHdrRow(rm, oTable, oTable.getRows()[row], row);
		}

		rm.write("</div>");
	};

	TableRenderer.getAriaAttributesForRowHdrRow = function(oTable, oRow) {
		var mAriaAttributes = {
			"aria-labelledby": {value: oTable.getId() + "-rownumberofrows " + oRow.getId() + "-rowselecttext"}
		};

		var sSelctionMode = oTable.getSelectionMode();
		if (sSelctionMode !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["title"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT")};
			mAriaAttributes["aria-selected"] = {value: "false"};
			if (sSelctionMode === sap.ui.table.SelectionMode.Multi) {
				if (oTable.getSelectedIndices().length > 1) {
					mAriaAttributes["aria-label"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY")};
				}
			} else {
				mAriaAttributes["aria-label"] = {value: oTable._oResBundle.getText("TBL_ROW_SELECT_KEY")};
			}
		}

		return mAriaAttributes;
	};

	TableRenderer.renderRowHdrRow = function(rm, oTable, oRow, iRowIndex) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-rowsel" + iRowIndex);
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		rm.addClass("sapUiTableRowHdr");
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		rm.writeClasses();
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}

		rm.writeAttribute("tabindex", "-1");

		var mAriaAttributes = this.getAriaAttributesForRowHdrRow(oTable, oRow);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		var aCellIds = [];
		jQuery.each(oRow.getCells(), function(iIndex, oCell) {
			aCellIds.push(oRow.getId() + "-col" + iIndex);
		});

		rm.writeStyles();
		rm.write("></div>");
	};

	TableRenderer.renderTableCtrl = function(rm, oTable) {

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableCtrlScrFixed");
			rm.writeClasses();
			rm.write(">");

			this.renderTableControl(rm, oTable, true);

			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariafixedcolumn");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_FIXED_COLUMN"));
			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableCtrlScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlCnt");
		rm.writeClasses();
		rm.write(">");

		this.renderTableControl(rm, oTable, false);

		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlAfter");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");
		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlEmpty");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write(">");
		if (oTable.getNoData() && oTable.getNoData() instanceof sap.ui.core.Control) {
			rm.renderControl(oTable.getNoData());
		} else {
			rm.write("<span");
			rm.addClass("sapUiTableCtrlEmptyMsg");
			rm.writeClasses();
			rm.write(">");
			if (typeof oTable.getNoData() === "string" || oTable.getNoData() instanceof String) {
				rm.writeEscaped(oTable.getNoData());
			} else if (oTable.getNoDataText()) {
				rm.writeEscaped(oTable.getNoDataText());
			} else {
				rm.writeEscaped(oTable._oResBundle.getText("TBL_NO_DATA"));
			}
			rm.write("</span>");
		}
		rm.write("</div>");
	};


	TableRenderer.renderTableControl = function(rm, oTable, bFixedTable) {
		var iStartColumn, iEndColumn;
		if (bFixedTable) {
			iStartColumn = 0;
			iEndColumn = oTable.getFixedColumnCount();
		} else {
			iStartColumn = oTable.getFixedColumnCount();
			iEndColumn = oTable.getColumns().length;
		}
		var iFixedRows = oTable.getFixedRowCount();
		var iFixedBottomRows = oTable.getFixedBottomRowCount();
		var aRows = oTable.getRows();

		if (iFixedRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, true, false, 0, iFixedRows);
		}
		this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, false, iFixedRows, aRows.length - iFixedBottomRows);
		if (iFixedBottomRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, true, aRows.length - iFixedBottomRows, aRows.length);
		}
	};

	TableRenderer.getAriaAttributesForTableControlCntColTh = function(oColumn, bHasRowSelector) {
		var mAriaAttributes = {
			"role": {value: "columnheader"},
			"scope": {value: "col"}
		};

		if (bHasRowSelector) {
			mAriaAttributes["aria-owns"] = {value: "" + oColumn.getId()};
			mAriaAttributes["aria-labelledby"] = {value: "" + oColumn.getId()};
		}

		return mAriaAttributes;
	};

	TableRenderer.renderTableControlCnt = function(rm, oTable, bFixedTable, iStartColumn, iEndColumn, bFixedRow, bFixedBottomRow, iStartRow, iEndRow) {
		rm.write("<table");
		var sId = oTable.getId() + "-table";

		if (bFixedTable) {
			sId += "-fixed";
			rm.addClass("sapUiTableCtrlFixed");
		} else {
			rm.addClass("sapUiTableCtrlScroll");
		}
		if (bFixedRow) {
			sId += "-fixrow";
			rm.addClass("sapUiTableCtrlRowFixed");
		} else if (bFixedBottomRow) {
			sId += "-fixrow-bottom";
			rm.addClass("sapUiTableCtrlRowFixedBottom");
		} else {
			rm.addClass("sapUiTableCtrlRowScroll");
		}
		rm.writeAttribute("id", sId);
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "grid");
		}
		rm.addClass("sapUiTableCtrl");
		rm.writeClasses();
		rm.addStyle("min-width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		//Firefox and chrome and safari need a defined width for the fixed table
		if (bFixedTable && (!!sap.ui.Device.browser.firefox || !!sap.ui.Device.browser.chrome || !!sap.ui.Device.browser.safari)) {
			rm.addStyle("width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		}
		rm.writeStyles();
		rm.write(">");

		rm.write("<thead>");

		rm.write("<tr");
		rm.addClass("sapUiTableCtrlCol");
		if (iStartRow == 0) {
			rm.addClass("sapUiTableCtrlFirstCol");
		}
		rm.writeClasses();
		rm.write(">");

		var aCols = oTable.getColumns();
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.write("<th");
			rm.addStyle("width", "0px");
			rm.writeStyles();
			if (iStartRow == 0) {
				var mAriaAttributes = this.getAriaAttributesForTableControlCntColTh(oColumn);
				this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);
				rm.writeAttribute("id", oTable.getId() + "_colsel");
			}
			rm.write("></th>");
		} else {
			if (aCols.length === 0) {
				// no cols => render th => avoids rendering issue in firefox
				rm.write("<th></th>");
			}
		}

		for (var col = iStartColumn, count = iEndColumn; col < count; col++) {
			var oColumn = aCols[col];
			if (oColumn && oColumn.shouldRender()) {
				rm.write("<th");
				rm.addStyle("width", oColumn.getWidth());
				rm.writeStyles();
				if (iStartRow == 0) {
					var mAriaAttributes = this.getAriaAttributesForTableControlCntColTh(oColumn, true);
					this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);
					rm.writeAttribute("id", oTable.getId() + "_col" + col);
				}
				rm.writeAttribute("data-sap-ui-headcolindex", col);
				rm.write(">");
				if (iStartRow == 0 && oTable._getHeaderRowCount() == 0) {
					if (oColumn.getMultiLabels().length > 0) {
						rm.renderControl(oColumn.getMultiLabels()[0]);
					} else {
						rm.renderControl(oColumn.getLabel());
					}
				}
				rm.write("</th>");
			}
		}

		// dummy column to fill the table width
		if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCols.length > 0) {
			rm.write("<th></th>");
		}

		rm.write("</tr>");
		rm.write("</thead>");

		rm.write("<tbody>");

		var aVisibleColumns = oTable._getVisibleColumns();
		var bHasOnlyFixedColumns = oTable._hasOnlyFixColumnWidths();

		// render the table rows
		var aRows = oTable.getRows();
		// retrieve tooltip and aria texts only once and pass them to the rows _updateSelection function
		var mTooltipTexts = oTable._getAriaTextsForSelectionMode(true);

		// check whether the row can be clicked to change the selection
		var bSelectOnCellsAllowed = oTable._getSelectOnCellsAllowed();
		for (var row = iStartRow, count = iEndRow; row < count; row++) {
			this.renderTableRow(rm, oTable, aRows[row], row, bFixedTable, iStartColumn, iEndColumn, false, aVisibleColumns, bHasOnlyFixedColumns, mTooltipTexts, bSelectOnCellsAllowed);
		}

		rm.write("</tbody>");
		rm.write("</table>");
	};

	TableRenderer.getAriaAttributesForRowTr = function(oTable, iRowIndex, aCells) {
		var mAriaAttributes = {};

		mAriaAttributes["role"] = {value: "row"};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}

		return mAriaAttributes;
	};

	TableRenderer.getAriaAttributesForRowTd = function(oTable, oRow, iRowIndex, aCells) {
		var mAriaAttributes = {};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			mAriaAttributes["role"] = {value: "rowheader"};
		} else {
			if (aCells.length === 0) {
				mAriaAttributes["role"] = {value: "gridcell"};
			}
		}

		mAriaAttributes["headers"] = {value: oTable.getId() + "_colsel"};
		mAriaAttributes["aria-owns"] = {value: oTable.getId() + "-rowsel" + iRowIndex};
		mAriaAttributes["role"] = {value: "rowheader"};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}

		return mAriaAttributes;
	};

	TableRenderer.renderTableRow = function(rm, oTable, oRow, iRowIndex, bFixedTable, iStartColumn, iEndColumn, bFixedRow, aVisibleColumns, bHasOnlyFixedColumns, mTooltipTexts, bSelectOnCellsAllowed) {

		rm.write("<tr");
		rm.addClass("sapUiTableTr");
		if (bFixedTable) {
			rm.writeAttribute("id", oRow.getId() + "-fixed");
		} else {
			rm.writeElementData(oRow);
		}
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		if (iRowIndex % 2 === 0) {
			rm.addClass("sapUiTableRowEven");
		} else {
			rm.addClass("sapUiTableRowOdd");
		}
		rm.writeClasses();
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}
		rm.writeStyles();

		var mAriaAttributes = this.getAriaAttributesForRowTr(oTable);
		this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

		rm.write(">");
		var aCells = oRow.getCells();
		// render the row headers
		if ((oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
			oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) ||
			aCells.length === 0) {
			rm.write("<td");
			var mAriaAttributes = this.getAriaAttributesForRowTd(oTable, oRow, iRowIndex, aCells);
			this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

			rm.write(">");
			if (oTable._bAccMode) {
				rm.write("<div");
				rm.writeAttribute("id", oRow.getId() + "-rowselecttext");
				rm.addClass("sapUiTableAriaRowSel");
				rm.writeClasses();
				rm.write(">");
				rm.write("</div>");
			}
			rm.write("</td>");
		}

		for (var cell = 0, count = aCells.length; cell < count; cell++) {
			this.renderTableCell(rm, oTable, oRow, aCells[cell], cell, bFixedTable, iStartColumn, iEndColumn, aVisibleColumns);
		}
		if (!bFixedTable && bHasOnlyFixedColumns && aCells.length > 0) {
			rm.write("<td></td>");
		}
		rm.write("</tr>");

		// because property changes of the table lead to re-rendering but the selection state might
		// remain, it's required to update tooltips and aria description according to the selection.
		// delay this call to make sure it happens when the DOM is rendered. Otherwise some elements
		// might not be rendered yet.
		jQuery.sap.delayedCall(0, this, function() {
			oRow._updateSelection(oTable, mTooltipTexts, bSelectOnCellsAllowed);
		});

	};

	TableRenderer.getAriaAttributesForCell = function(oTable, bFixedTable, oRow, oColumn, iColIndex, oCell) {
		var mAriaAttributes = {};

		mAriaAttributes["headers"] = {value: oTable.getId() + "_col" + iColIndex};
		mAriaAttributes["role"] = {value: "gridcell"};

		var sRowSelectorId = oTable.getId() + "-rownumberofrows";


		var aMultiLabels = oColumn.getMultiLabels();
		var iMultiLabels = aMultiLabels.length;
		var sLabels = "";

		// get IDs of column labels
		if (oTable.getColumnHeaderVisible()) {
			var sColumnId = oColumn.getId();
			// first column header has no suffix, just the column ID
			sLabels = sColumnId;
			if (iMultiLabels > 1) {
				for (var i = 1; i < iMultiLabels; i++) {
					// for all other column header rows we add the suffix
					sLabels += " " + sColumnId + "_" + i;
				}
			}
		} else {
			// column header is not rendered therfore there is no <div> tag. Link aria description to label
			var oLabel;
			if (iMultiLabels == 0) {
				oLabel = oColumn.getLabel();
				if (oLabel) {
					sLabels = oLabel.getId();
				}
			} else {
				for (var i = 0; i < iMultiLabels; i++) {
					// for all other column header rows we add the suffix
					oLabel = aMultiLabels[i];
					if (oLabel) {
						sLabels += " " + oLabel.getId() + " ";
					}
				}
			}
		}


		var sLabelledBy = sRowSelectorId + " " + oTable.getId() + "-ariadesc " + sLabels;

		sLabelledBy +=  " " + oCell.getId();

		var sDescribedBy = "";
		if (bFixedTable) {
			sLabelledBy += " " + oTable.getId() + "-ariafixedcolumn";
		}

		mAriaAttributes["aria-labelledby"] = {value: sLabelledBy};
		mAriaAttributes["aria-describedby"] = {value: oTable.getId() + "-toggleedit" + sDescribedBy};

		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
			mAriaAttributes["aria-selected"] = {value: "false"};
		}


		return mAriaAttributes;
	};

	TableRenderer.renderTableCell = function(rm, oTable, oRow, oCell, iCellIndex, bFixedTable, iStartColumn, iEndColumn, aVisibleColumns) {
		var iColIndex = oCell.data("sap-ui-colindex");
		var oColumn = oTable.getColumns()[iColIndex];
		if (oColumn.shouldRender() && iStartColumn <= iColIndex && iEndColumn > iColIndex) {
			rm.write("<td");
			var sId = oRow.getId() + "-col" + iCellIndex;
			rm.writeAttribute("id", sId);
			rm.writeAttribute("tabindex", "-1");

			var mAriaAttributes = this.getAriaAttributesForCell(oTable, bFixedTable, oRow, oColumn, iColIndex, oCell);
			this.renderAriaAttributes(rm, mAriaAttributes, oTable._bAccMode);

			var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
			if (sHAlign) {
				rm.addStyle("text-align", sHAlign);
			}
			rm.writeStyles();
			if (aVisibleColumns.length > 0 && aVisibleColumns[0] === oColumn) {
				rm.addClass("sapUiTableTdFirst");
			}
			// grouping support to show/hide values of grouped columns
			if (oColumn.getGrouped()) {
				rm.addClass("sapUiTableTdGroup");
			}
			rm.writeClasses();
			rm.write("><div");
			rm.addClass("sapUiTableCell");

			rm.writeClasses();

			if (oTable.getRowHeight() && oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
				rm.addStyle("max-height", oTable.getRowHeight() + "px");
			}
			rm.writeStyles();

			rm.write(">");
			this.renderTableCellControl(rm, oTable, oCell, iCellIndex);
			rm.write("</div></td>");
		}
	};

	TableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
		rm.renderControl(oCell);
	};

	TableRenderer.renderVSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableVSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oVSb);
		rm.write("</div>");
	};

	TableRenderer.renderHSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableHSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oHSb);
		rm.write("</div>");
	};


	// =============================================================================
	// HELPER FUNCTIONALITY
	// =============================================================================

	/**
	 * Returns the value for the HTML "align" attribute according to the given
	 * horizontal alignment and RTL mode, or NULL if the HTML default is fine.
	 *
	 * @param {sap.ui.core.HorizontalAlign} oHAlign
	 * @param {boolean} bRTL
	 * @type string
	 */
	TableRenderer.getHAlign = function(oHAlign, bRTL) {
	  switch (oHAlign) {
		case sap.ui.core.HorizontalAlign.Center:
		  return "center";
		case sap.ui.core.HorizontalAlign.End:
		case sap.ui.core.HorizontalAlign.Right:
		  return bRTL ? "left" : "right";
	  }
	  // case sap.ui.core.HorizontalAlign.Left:
	  // case sap.ui.core.HorizontalAlign.Begin:
	  return bRTL ? "right" : "left";
	};


	return TableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeAutoExpandMode') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides enumeration sap.ui.table.TreeAutoExpandMode
jQuery.sap.declare('sap.ui.table.TreeAutoExpandMode'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeAutoExpandMode",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	* @class
	* Different modes for setting the auto expand mode on different tables (Analytical-, TreeTable, ...)
	*
	* @static
	* @public
	* @alias sap.ui.table.TreeAutoExpandMode
	*/
	var TreeAutoExpandMode = {
			/**
			 * Tree nodes will be expanded in sequence, level by level (Single requests are sent)
			 * @public
			 */
			Sequential: "Sequential",

			/**
			 * If supported by a backend provider with analytical capabilities, the requests needed for an automatic node expansion are bundled.
			 * @public
			 */
			Bundled: "Bundled"
	};

	return TreeAutoExpandMode;

}, /* bExport= */ true);
}; // end of sap/ui/table/TreeAutoExpandMode.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.TreeTable
jQuery.sap.declare('sap.ui.table.TreeTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './TableRenderer'],
	function(jQuery, Renderer, TableRenderer) {
	"use strict";


	/**
	 * TreeTable renderer.
	 * @namespace
	 */
	var TreeTableRenderer = Renderer.extend(TableRenderer);


	TreeTableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
		if (oTable.isTreeBinding("rows") && iCellIndex === 0 && !oTable.getUseGroupMode()) {
			rm.write("<span");
			rm.addClass("sapUiTableTreeIcon");
			rm.addClass("sapUiTableTreeIconLeaf");
			rm.writeClasses();
			rm.writeAttribute("tabindex", -1);
			rm.write(">&nbsp;</span>");
		}
		rm.renderControl(oCell);
	};


	return TreeTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/TreeTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.table.
 */
jQuery.sap.declare('sap.ui.table.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.library'); // unlisted dependency retained
sap.ui.define("sap/ui/table/library",['jquery.sap.global',
	'sap/ui/core/library', // library dependency
	'sap/ui/unified/library'], // library dependency
	function(jQuery) {

	"use strict";

	/**
	 * Table-like controls, mainly for desktop scenarios.
	 *
	 * @namespace
	 * @name sap.ui.table
	 * @author SAP SE
	 * @version 1.36.5
	 * @public
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.table",
		version: "1.36.5",
		dependencies : ["sap.ui.core","sap.ui.unified"],
		types: [
			"sap.ui.table.NavigationMode",
			"sap.ui.table.SelectionBehavior",
			"sap.ui.table.SelectionMode",
			"sap.ui.table.SortOrder",
			"sap.ui.table.VisibleRowCountMode"
		],
		interfaces: [],
		controls: [
			"sap.ui.table.AnalyticalColumnMenu",
			"sap.ui.table.AnalyticalTable",
			"sap.ui.table.ColumnMenu",
			"sap.ui.table.DataTable",
			"sap.ui.table.Table",
			"sap.ui.table.TreeTable"
		],
		elements: [
			"sap.ui.table.AnalyticalColumn",
			"sap.ui.table.Column",
			"sap.ui.table.Row"
		]
	});


	/**
	 * Navigation mode of the table
	 *
	 * @version 1.36.5
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.NavigationMode = {

		/**
		 * Uses the scrollbar control.
		 * @public
		 */
		Scrollbar : "Scrollbar",

		/**
		 * Uses the paginator control.
		 * @public
		 */
		Paginator : "Paginator"

	};


	/**
	 * Selection behavior of the table
	 *
	 * @version 1.36.5
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SelectionBehavior = {

		/**
		 * Rows can be selected on the complete row.
		 * @public
		 */
		Row : "Row",

		/**
		 * Rows can only be selected on the row selector.
		 * @public
		 */
		RowSelector : "RowSelector",

		/**
		 * Rows can only be selected on the row (and the selector is hidden).
		 * @public
		 */
		RowOnly : "RowOnly"

	};


	/**
	 * Selection mode of the table
	 *
	 * @version 1.36.5
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SelectionMode = {

		/**
		 * Select multiple rows at a time (toggle behavior).
		 * @public
		 */
		MultiToggle : "MultiToggle",

		/**
		 * Select multiple rows at a time.
		 * @public
		 */
		Multi : "Multi",

		/**
		 * Select one row at a time.
		 * @public
		 */
		Single : "Single",

		/**
		 * No rows can be selected.
		 * @public
		 */
		None : "None"

	};


	/**
	 * Sort order of a column
	 *
	 * @version 1.36.5
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SortOrder = {

		/**
		 * Sort Order: ascending.
		 * @public
		 */
		Ascending : "Ascending",

		/**
		 * Sort Order: descending.
		 * @public
		 */
		Descending : "Descending"

	};


	/**
	 * VisibleRowCountMode of the table
	 *
	 * @version 1.36.5
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.VisibleRowCountMode = {

		/**
		 * The table always has as many rows as defined in the visibleRowCount property.
		 * @public
		 */
		Fixed : "Fixed",

		/**
		 * After rendering the table has as many rows as defined in visibleRowCount property. The user is able to change the visible rows by moving a grip with the mouse. The visibleRowCount property is changed accordingly.
		 * @public
		 */
		Interactive : "Interactive",

		/**
		 * The table automatically fills the height of the surrounding container.
		 * The visibleRowCount property is automatically changed accordingly.
		 * All rows need the same height, otherwise the auto mode doesn't always work as expected.
		 * The height of all siblings within the same layout container of the table will be subtracted from the available height.
		 * For performance reasons, it is recommended to add no siblings in the table's parent container.
		 * @public
		 */
		Auto : "Auto"

	};

	/**
	 * Details about the group event to distinguish between different actions associated with grouping
	 * @enum {string}
	 * @public
	 * @type {{group: string, ungroup: string, ungroupAll: string, moveUp: string, moveDown: string, showGroupedColumn: string, hideGroupedColumn: string}}
	 */
	sap.ui.table.GroupEventType = {
		/**
		 * Group Column
		 * @public
		 */
		group: "group",
		/**
		 * Ungroup Column
		 * @public
		 */
		ungroup: "ungroup",
		/**
		 * Ungroup All Columns
		 * @public
		 */
		ungroupAll: "ungroupAll",
		/**
		 * Change the group order of the columns. Move column one position up in the group sequence
		 * @public
		 */
		moveUp: "moveUp",
		/**
		 * Change the group order of the columns. Move column one position down in the group sequence
		 * @public
		 */
		moveDown: "moveDown",
		/**
		 * Show grouped column also as a column, not just as group header
		 * @public
		 */
		showGroupedColumn: "showGroupedColumn",
		/**
		 * Show grouped column only as group header
		 * @public
		 */
		hideGroupedColumn: "hideGroupedColumn"
	};

	// map the new Column to the old ColumnHeader
	sap.ui.table.ColumnHeader = sap.ui.table.Column;

	// map the SelectionMode All to Multi
	sap.ui.table.SelectionMode.All = sap.ui.table.SelectionMode.Multi;

	//factory for table to create labels an textviews to be overwritten by commons and mobile library
	if (!sap.ui.table.TableHelper) {
		sap.ui.table.TableHelper = {
			createLabel: function(mConfig){ throw new Error("no Label control available!"); }, /* must return a Label control */
			createTextView: function(mConfig){ throw new Error("no TextView control available!"); }, /* must return a textview control */
			createTextField: function(mConfig){ throw new Error("no TextField control available!"); }, /* must return a textfield control */
			createImage: function(mConfig){ throw new Error("no Image control available!"); }, /* must return a textview control */
			bFinal: false /* if true, the helper must not be overwritten by an other library */
		};
	}

	return sap.ui.table;

});

}; // end of sap/ui/table/library.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenuRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumnMenuRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './ColumnMenuRenderer'],
	function(jQuery, Renderer, ColumnMenuRenderer) {
	"use strict";


	/**
	 * AnalyticalTable renderer.
	 * @namespace
	 */
	var AnalyticalColumnMenuRenderer = Renderer.extend(ColumnMenuRenderer);

	return AnalyticalColumnMenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.table.AnalyticalTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './TableRenderer'],
	function(jQuery, Renderer, TableRenderer) {
	"use strict";


	/**
	 * AnalyticalTable renderer.
	 * @namespace
	 */
	var AnalyticalTableRenderer = Renderer.extend(TableRenderer);

	AnalyticalTableRenderer.getAriaAttributesForCell = function(oTable, bFixedTable, oRow, oColumn, iColIndex, oCell) {
		// since the analytical table is a read-only control there is no need for the toggleedit description.
		// invoke the TableRenderer function to retrieve aria attributes for cells and then remove the
		// toggleedit description from aria-describedby
		var mAriaAttributes = TableRenderer.getAriaAttributesForCell.apply(this, arguments);
		if (mAriaAttributes["aria-describedby"]) {
			var aDescribedByParts = mAriaAttributes["aria-describedby"].value.split(" ");
			var iIndex = aDescribedByParts.indexOf(oTable.getId() + "-toggleedit");
			delete mAriaAttributes["aria-describedby"];

			if (iIndex >= 0) {
				aDescribedByParts.splice(iIndex);
			}

			if (aDescribedByParts.length > 0) {
				mAriaAttributes["aria-describedby"].value = aDescribedByParts.join(" ");
			}
		}

		return mAriaAttributes;
	};

	return AnalyticalTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Column') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Column.
jQuery.sap.declare('sap.ui.table.Column'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Type'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.type.String'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Column",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/core/RenderManager', 'sap/ui/model/Filter', 'sap/ui/model/Sorter', 'sap/ui/model/Type', 'sap/ui/model/type/String', './library'],
	function(jQuery, Element, RenderManager, Filter, Sorter, Type, String, library) {
	"use strict";


	/**
	 * Constructor for a new Column.
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 *
	 * @class
	 * The column allows you to define column specific properties that will be applied when rendering the table.
	 * @extends sap.ui.core.Element
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Column
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Column = Element.extend("sap.ui.table.Column", /** @lends sap.ui.table.Column.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Width of the column. Works only with px/em/rem values. Em are handled like rem values.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * If the table is wider than the sum of widths of the visible columns, the columns will be
			 * resized proportionally to their widths that were set originally. If set to false, the column will be displayed in the
			 * original width. If all columns are set to not be flexible, an extra "dummy" column will be
			 * created at the end of the table.
			 */
			flexible : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * If set to true, the column can be resized either using the resize-handle (by mouse) or using
			 * the keyboard (SHIFT + Left/Right Arrow keys)
			 */
			resizable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Horizontal alignment of the column content. Controls with a text align do not inherit
			 * the horizontal alignment. You have to set the text align directly on the template.
			 */
			hAlign : {type : "sap.ui.core.HorizontalAlign", group : "Appearance", defaultValue : sap.ui.core.HorizontalAlign.Begin},

			/**
			 * Indicates if the column is sorted. This property only controls if a sort indicator is displayed in the
			 * column header - it does not trigger the sort function. The column has to be sorted by calling <code>Column.sort()</code>
			 */
			sorted : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * This property indicates the sort direction (Ascending or Descending). The corresponding icon will be
			 * rendered if the property <code>sorted</code> is <code>true</code>
			 * @see sap.ui.table.SortOrder (default value: "Ascending")
			 */
			sortOrder : {type : "sap.ui.table.SortOrder", group : "Appearance", defaultValue : sap.ui.table.SortOrder.Ascending},

			/**
			 * Specifies the binding property on which the column will sort.
			 * Since the column template may have composite bindings, it's not possible to figure out on which binding
			 * property the sort shall be applied. Therefore the binding property for sorting must be specified.
			 * For example, if the first name and last name are displayed in the same column, only one of the two can be defined as
			 * <code>sortProperty</code>.
			 *
			 * A column menu entry for sorting can only be generated if the <code>sortProperty</code> is set.
			 */
			sortProperty : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Indicates if the column is filtered. This property only controls if a filter indicator is displayed in the
			 * column header - it does not trigger the filter function. The column has to be filtered by calling <code>Column.sort()</code>
			 */
			filtered : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Specifies the binding property on which the column shall be filtered.
			 * Since the column template may have composite bindings, it's not possible to figure out on which binding
			 * property the filter shall be applied. Therefore the binding property for filtering must be specified.
			 * For example, if the first name and last name are displayed in the same column, only one of the two can be defined as
			 * <code>filterProperty</code>.
			 *
			 * A column menu entry for filtering can only be generated if the <code>filterProperty</code> is set. The
			 * default menu entry is a text input field.
			 */
			filterProperty : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Specifies the value of the filter as string (will be converted into the proper data type). It is possible
			 * to provide a filterOperator as string, as shown here:
			 * > 50
			 * < 100
			 * >= 150
			 * <= 200
			 * = 250
			 * != 300
			 * *something	ends with
			 * something*	starts with
			 * *something*	contains
			 * some..thing	between
			 * 50..100		between
			 */
			filterValue : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Filter operator to use when filtering this column.
			 * @see sap.ui.model.FilterOperator (default value: "Contains")
			 */
			filterOperator : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * If this property is set, the default filter operator of the column is overridden.
			 * By default <code>Contains</code> is used for string and <code>EQ</code> for other types. A valid <code>sap.ui.model.FilterOperator</code> needs to be passed.
			 */
			defaultFilterOperator : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Type of Filter. This is used to transform the search term to the specified type,
			 * to make sure that the right columns are displayed. This should be the same as defined
			 * in binding for this column. As an alternative you can pass a function which does the conversion.
			 * The function receives the entered filter value as parameter and returns the proper
			 * value for the filter expression. Another option is to pass the class name of the type,
			 * e.g.: <code>sap.ui.model.type.Date</code> or an expression similar to the binding syntax,
			 * e.g.: <code>"\{type: 'sap.ui.model.type.Date', formatOptions: \{UTC: true\}, constraints: {} \}"</code>.
			 * Here the escaping is mandatory to avoid handling by the binding parser.
			 * By default the filter type is <code>sap.ui.model.type.String</code>.
			 * @since 1.9.2
			 */
			filterType : {type : "any", group : "Misc", defaultValue : null},

			/**
			 * Indicates if the column is grouped.
			 */
			grouped : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Invisible controls are not rendered.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * The name of the column which is used in the column visibility menu item as text.
			 * If not set as a fallback the column menu tries to get the text from the nested Label.
			 * @since 1.11.1
			 */
			name : {type : "string", group : "Appearance", defaultValue : null},

			/**
			 * Defines if the filter menu entry is displayed
			 * @since 1.13.0
			 */
			showFilterMenuEntry : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Defines if the sort menu entries are displayed
			 * @since 1.13.0
			 */
			showSortMenuEntry : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * If this property is set, a span is applied for the header. When moving columns, all columns
			 * which are part of the header will be moved. The <code>headerSpan</code> can be either an integer or an array of
			 * integers (if you use the multi header feature of the table). If you only specify an integer, this span is
			 * applied for all header rows, with multiple integers you can specify a separate span for each header row.
			 */
			headerSpan : {type : "any", group : "Behavior", defaultValue : 1},

			/**
			 * Enables auto-resizing of the column on double-clicking the resizer. The width is determined on the widest
			 * currently displayed content. It does not consider rows which are currently not scrolled into view.
			 * Currently only implemented to work with the following controls:
			 * <code>sap.m.Text, sap.m.Label, sap.m.Link, sap.m.Input,
			 * sap.ui.commons.TextView, sap.ui.commons.Label, sap.ui.commons.Link and sap.ui.commons.TextField,
			 * sap.ui.commons.Checkbox, sap.m.Checkbox</code>
			 * @since 1.21.1
			 */
			autoResizable : {type : "boolean", group : "Behavior", defaultValue : false}
		},
		defaultAggregation : "label",
		aggregations : {

			/**
			 * Label of the column which is displayed in the column header. This aggregation is for the standard behavior,
			 * where you only want to display one single row header. If a string is supplied, a default label control will be
			 * created. Which control this is depends on the loaded libraries.
			 */
			label : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

			/**
			 * Labels of the column which are displayed in the column header. Define a control for
			 * each header row in the table. Use this aggregation if you want to use multiple headers per column.
			 * @since 1.13.1
			 */
			multiLabels : {type : "sap.ui.core.Control", multiple : true, singularName : "multiLabel"},

			/**
			 * Template (cell renderer) of this column. A template is decoupled from the column, which means after
			 * changing the templates' properties or aggregations an explicit invalidation of the column or table is
			 * required. The default depends on the loaded libraries.
			 */
			template : {type : "sap.ui.core.Control", multiple : false},

			/**
			 * The menu used by the column. By default the {@see sap.ui.table.ColumnMenu} is used.
			 */
			menu : {type : "sap.ui.unified.Menu", multiple : false}
		},

		events : {
			/**
			 * Fires before the column menu is opened.
			 * @since 1.33.0
			 */
			columnMenuOpen: {
				allowPreventDefault: true,
				parameters: {
					/**
					 * Refence to the selected <code>menu</code> instance to be opened.
					 */
					menu: {type: "sap.ui.unified.Menu"}
				}
			}
		}
	}});


	/** default filter type for the columns */
	Column._DEFAULT_FILTER_TYPE = new String();

	/**
	 * called when the column is initialized
	 */
	Column.prototype.init = function() {

		this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._oSorter = null;

		// Skip proppagation of databinding properties to the template
		this.mSkipPropagation = {template: true};

	};

	/**
	 * called when the column is destroyed
	 */
	Column.prototype.exit = function() {

		// destroy the sort image
		var oSortImage = sap.ui.getCore().byId(this.getId() + "-sortIcon");
		if (oSortImage) {
			oSortImage.destroy();
		}

		// destroy the filter image
		var oFilterImage = sap.ui.getCore().byId(this.getId() + "-filterIcon");
		if (oFilterImage) {
			oFilterImage.destroy();
		}

	};

	/**
	 * called when the column's parent is set
	 */
	Column.prototype.setParent = function(oParent, sAggregationName, bSuppressRerendering) {
		Element.prototype.setParent.apply(this, arguments);
		var oMenu = this.getAggregation("menu");
		if (oMenu && typeof oMenu._updateReferences === "function") {
			//if menu is set update menus internal references
			oMenu._updateReferences(this);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.invalidate = function(oOrigin) {
		// prevent changes in the template (especially the databinding ones)
		//  - what about exchanging the template? => implemented in setTemplate
		//  - what about modifiying properties? => developer must call invalidate!
		// The problem is that we just need to prevent databinding changes. The
		// problem here is that the databinding bindings are created ones the template
		// is created and has its own model. If now changes are done in the model
		// this directly affects the template which invalidates the column invalidating
		// the complete Table.
		/*
		 * PART1: When you create the Tooltip (deferred) then it establishes the
		 * connection to its data (also for the template of the column!) and this
		 * finally invalidates the Table which triggers the re-rendering. One
		 * option is to complete decouple the template from the Table by
		 * supressing the invalidate. But this finally also decouples the Table
		 * from any changes on the template after the template has been applied
		 * to the Column. But when re-rendering it would update the column cells.
		 * To notify the Table on proper changes one has to call the method
		 * invalidate on the Table.
		*/
		/*
		 * PART2: we also suppress the re-rendering in case of the column menu is
		 * rerendered. This is a popup and we use the instance check because of the
		 * menu behind the getMenu function is lazy created when first accessed.
		 */
	  if (oOrigin !== this.getTemplate() && !(oOrigin instanceof sap.ui.table.ColumnMenu)) {
			// changes on the template require to call invalidate on the column or table
	    Element.prototype.invalidate.apply(this, arguments);
	  }
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setLabel = function(vLabel) {
		var oLabel = vLabel;
		if (typeof (vLabel) === "string") {
			oLabel = sap.ui.table.TableHelper.createLabel({text: vLabel});
		}
		this.setAggregation("label", oLabel);
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setTemplate = function(vTemplate) {
		var oTemplate = vTemplate;
		if (typeof (vTemplate) === "string") {
			oTemplate = sap.ui.table.TableHelper.createTextView().bindProperty("text", vTemplate);
		}
		this.setAggregation("template", oTemplate);
		// manually invalidate the Column (because of the invalidate decoupling to
		// prevent invalidations from the databinding part)
		this.invalidate();
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.getMenu = function() {
		var oMenu = this.getAggregation("menu");
		if (!oMenu) {
			oMenu = this._createMenu();
			this.setMenu(oMenu);
		}
		return oMenu;
	};

	/**
	 * This function invalidates the column's menu. All items will be re-created the next time the menu opens. This only
	 * happens for generated menus.
	 * @private
	 */
	Column.prototype.invalidateMenu = function() {
		var oMenu = this.getAggregation("menu");
		if (oMenu && oMenu._invalidate) {
			oMenu._invalidate();
		}
	};

	/**
	 * Checks whether or not the menu has items. This function considers table and column
	 * properties to determine whether the column menu would have items. If there is a menu set,
	 * it will just check whether there are items in the item aggregation.
	 * @return {Boolean} True if the menu has or could have items.
	 * @private
	 */
	Column.prototype._menuHasItems = function() {
		var oMenu = this.getAggregation("menu");
		var oTable = this.getParent();
		var fnMenuHasItems = function() {
			return (
				this.isSortableByMenu() || // Sorter
				this.isFilterableByMenu() || // Filter
				this.isGroupableByMenu() || // Grouping
				(oTable && oTable.getEnableColumnFreeze()) || // Column Freeze
				(oTable && oTable.getShowColumnVisibilityMenu()) // Column Visibility Menu
			);

		}.bind(this);

		return !!((oMenu && oMenu.getItems().length > 0) || fnMenuHasItems());
	};

	/**
	 * This function checks whether a filter column menu item will be created. Although it evaluates some column
	 * properties, it does not check the metadata.
	 *
	 * For Columns the following applies:
	 * - filterProperty must be defined
	 * - showFilterMenuEntry must be true (which is the default)
	 *
	 * @returns {boolean}
	 */
	Column.prototype.isFilterableByMenu = function() {
		return !!(this.getFilterProperty() && this.getShowFilterMenuEntry());
	};

	/**
	 * This function checks whether sort column menu items will be created. Although it evaluates some column
	 * properties, it does not check the metadata.
	 *
	 * For Columns the following applies:
	 * - sortProperty must be defined
	 * - showSortMenuEntry must be true (which is the default)
	 *
	 * @returns {boolean}
	 */
	Column.prototype.isSortableByMenu = function() {
		return !!(this.getSortProperty() && this.getShowSortMenuEntry());
	};

	/**
	 * This function checks whether a grouping column menu item will be created. Although it evaluates some column
	 * properties, it does not check the metadata. Since a property of the table must be checked, this function will
	 * return false when the column is not a child of a table.
	 *
	 * For Columns the following applies:
	 * - sortProperty must be defined
	 * - showFilterMenuEntry must be true (which is the default)
	 *
	 * @returns {boolean}
	 */
	Column.prototype.isGroupableByMenu = function() {
		var oTable = this.getParent();
		return !!(oTable && oTable.getEnableGrouping && oTable.getEnableGrouping() && this.getSortProperty());
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setMenu = function(oMenu) {
		this.setAggregation("menu", oMenu, true);
		return this;
	};

	/*
	 * Factory method. Creates the column menu.
	 *
	 * @return {sap.ui.table.ColumnMenu} The created column menu.
	 */
	Column.prototype._createMenu = function() {
		jQuery.sap.require("sap.ui.table.ColumnMenu");

		if (!this._defaultMenu) {
			this._defaultMenu =  new sap.ui.table.ColumnMenu(this.getId() + "-menu", {ariaLabelledBy: this});
		}

		return this._defaultMenu;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setWidth = function(sWidth) {
		this.setProperty("width", sWidth);
		this.fireEvent('_widthChanged', { newWidth: sWidth });
		return this;
	};

	Column.prototype._setAppDefault = function(sProperty, mValue) {
		if (!this._appDefaults) {
			this._appDefaults = {};
		}

		if (sProperty == "sorted") {
			this._appDefaults.sorted = mValue;
		} else if (sProperty == "sortOrder") {
			this._appDefaults.sortOrder = mValue;
		} else if (sProperty == "filtered") {
			this._appDefaults.filtered = mValue;
		} else if (sProperty == "filterValue") {
			this._appDefaults.filterValue = mValue;
		} else if (sProperty == "filterOperator") {
			this._appDefaults.filterOperator = mValue;
		}
	};

	Column.prototype._restoreAppDefaults = function() {
		if (this._appDefaults) {
			this.setProperty("sorted", this._appDefaults.sorted, true);
			this.setProperty("sortOrder", this._appDefaults.sortOrder, true);
			this.setProperty("filtered", this._appDefaults.filtered, true);
			this.setProperty("filterValue", this._appDefaults.filterValue, true);
			this.setProperty("filterOperator", this._appDefaults.filterOperator, true);
			this._renderSortIcon();
			this._renderFilterIcon();
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setSorted = function(bFlag) {
		this.setProperty("sorted", bFlag, true);
		this._setAppDefault("sorted", bFlag);
		this._renderSortIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setSortOrder = function(tSortOrder) {
		this.setProperty("sortOrder", tSortOrder, true);
		this._setAppDefault("sortOrder", tSortOrder);
		this._renderSortIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFiltered = function(bFlag) {
		this.setProperty("filtered", bFlag, true);
		this._setAppDefault("filtered", bFlag);
		this._renderFilterIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterValue = function(sValue) {
		this.setProperty("filterValue", sValue, true);
		this._setAppDefault("filterValue", sValue);
		var oMenu = this.getMenu();
		if (oMenu && oMenu instanceof sap.ui.table.ColumnMenu) {
			oMenu._setFilterValue(sValue);
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterOperator = function(sValue) {
		this.setProperty("filterOperator", sValue, true);
		this._setAppDefault("filterOperator", sValue);
		return this;
	};


	/**
	 * Function is called when mouse button is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Column.prototype.onmousedown = function(oEvent) {
		var oMenu = this.getAggregation("menu");
		this._bSkipOpen = oMenu && oMenu.bOpen;
	};


	/**
	 * Function is called when mouse leaves the control.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Column.prototype.onmouseout = function(oEvent) {
		if (this._bSkipOpen && jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
			this._bSkipOpen = false;
		}
	};

	/**
	 * Open the column menu
	 * @param [{Object}] oDomRef Optional DOM reference of the element to which the menu should be visually attached. Fallback is the focused DOM reference
	 * @private
	 */
	Column.prototype._openMenu = function(oDomRef, bWithKeyboard) {
		if (this._bSkipOpen){
			this._bSkipOpen = false;
			return;
		}

		var oMenu = this.getMenu();
		var bExecuteDefault = this.fireColumnMenuOpen({
			menu: oMenu
		});

		if (bExecuteDefault) {
			var eDock = sap.ui.core.Popup.Dock;
			var oFocusDomRef = oDomRef;
			if (!oDomRef) {
				oDomRef = this.getDomRef();
				oFocusDomRef = this.getFocusDomRef();
			}
			oMenu.open(!!bWithKeyboard, oFocusDomRef, eDock.BeginTop, eDock.BeginBottom, oDomRef, "none none");
		}
	};


	/**
	 * Toggles the sort order of the column.
	 *
	 * @type sap.ui.table.Column
	 * @public
	 * @deprecated Since version 1.5.1.
	 * Please use the function "sap.ui.Table.prototype.sort".
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Column.prototype.toggleSort = function() {
		// by default we sort ascending / only if already is sorted ascending then we toggle
		this.sort(this.getSorted() && this.getSortOrder() === sap.ui.table.SortOrder.Ascending);
	};


	/**
	 * sorts the current column ascending or descending
	 *
	 * @param {boolean} bDescending
	 *         sort order of the column (if undefined the default will be ascending)
	 * @type sap.ui.table.Column
	 * @public
	 * @deprecated Since version 1.5.1.
	 * Please use the function "sap.ui.Table.prototype.sort".
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Column.prototype.sort = function(bDescending, bAdd) {

		var oTable = this.getParent();
		if (oTable) {
			oTable.pushSortedColumn(this, bAdd);
			// get the sort order type
			var oNewSortOrder = bDescending ? sap.ui.table.SortOrder.Descending : sap.ui.table.SortOrder.Ascending;

			// notify the event listeners
			var bExecuteDefault = oTable.fireSort({
				column: this,
				sortOrder: oNewSortOrder,
				columnAdded: bAdd
			});

			if (bExecuteDefault) {

				// reset the sorting status of all columns
				var aSorters = [];
				var aSortedCols = oTable._aSortedColumns;

				var aCols = oTable.getColumns();

				for (var i = 0, l = aCols.length; i < l; i++) {

					aCols[i].setProperty("sorted", false, true);
					aCols[i].setProperty("sortOrder", sap.ui.table.SortOrder.Ascending, true);
					aCols[i]._renderSortIcon();
					if (jQuery.inArray(aCols[i], aSortedCols) < 0) {
						delete aCols[i]._oSorter;
					}

				}

				for (var i = 0, l = aSortedCols.length; i < l; i++) {
					// set the sort property of the current column
					aSortedCols[i].setProperty("sorted", true, true);
					aSortedCols[i].setProperty("sortOrder", oNewSortOrder, true);
					aSortedCols[i]._renderSortIcon();
					if (this === aSortedCols[i]) {
						this._oSorter = new Sorter(aSortedCols[i].getSortProperty(), aSortedCols[i].getSortOrder() === sap.ui.table.SortOrder.Descending);
					}
					aSorters.push(aSortedCols[i]._oSorter);
				}

				// set the sorted flag and sort the model
				if (oTable.isBound("rows")) {

					// sort the binding
					oTable.getBinding("rows").sort(aSorters);

					if (this._afterSort) {
						this._afterSort();
					}
				}

				// update the sort icon
				this._renderSortIcon();

			}

		}

		return this;

	};

	function getHTML(oImage) {
		var oRenderManager = sap.ui.getCore().createRenderManager(),
			sHTML = oRenderManager.getHTML(oImage);
		oRenderManager.destroy();
		return sHTML;
	}

	Column.prototype._renderSortIcon = function() {

		var oTable = this.getParent();
		if (oTable && oTable.getDomRef()) {
			if (this.getSorted()) {

				// create the image for the sort order visualization
				var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
				var oImage = sap.ui.getCore().byId(this.getId() + "-sortIcon") || sap.ui.table.TableHelper.createImage(this.getId() + "-sortIcon");
				oImage.addStyleClass("sapUiTableColIconsOrder");
				if (this.getSortOrder() === sap.ui.table.SortOrder.Ascending) {
					oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_asc.gif"));
				} else {
					oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_desc.gif"));
				}

				// apply the image and aria property to the column
				var htmlImage = getHTML(oImage);
				this.$().find(".sapUiTableColIconsOrder").remove();
				jQuery(htmlImage).prependTo(this.getDomRef("icons"));
				this.$().attr("aria-sort", this.getSortOrder() === sap.ui.table.SortOrder.Ascending ? "ascending" : "descending");

				this.$().find(".sapUiTableColCell").addClass("sapUiTableColSorted");

			} else {

				// remove the sort indicators
				this.$().find(".sapUiTableColIconsOrder").remove();
				this.$().removeAttr("aria-sort");

				this.$().find(".sapUiTableColCell").removeClass("sapUiTableColSorted");

			}
		}

	};

	Column.prototype._getFilter = function() {

		var oFilter,
		    sPath = this.getFilterProperty(),
		    sValue = this.getFilterValue(),
		    sOperator = this.getFilterOperator(),
		    sParsedValue,
		    sSecondaryParsedValue,
		    oType = this.getFilterType() || Column._DEFAULT_FILTER_TYPE,
		    bIsString = oType instanceof String,
		    aBetween;

		if (sValue) {

			// determine the operator
			if (!sOperator) {

				aBetween = sValue.match(/(.*)\s*\.\.\s*(.*)/);

				// determine the filter operator depending on the
				if (sValue.indexOf("=") == 0) {
					sOperator = sap.ui.model.FilterOperator.EQ;
					sParsedValue = sValue.substr(1);
				} else if (sValue.indexOf("!=") == 0) {
					sOperator = sap.ui.model.FilterOperator.NE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf("<=") == 0) {
					sOperator = sap.ui.model.FilterOperator.LE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf("<") == 0) {
					sOperator = sap.ui.model.FilterOperator.LT;
					sParsedValue = sValue.substr(1);
				} else if (sValue.indexOf(">=") == 0) {
					sOperator = sap.ui.model.FilterOperator.GE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf(">") == 0) {
					sOperator = sap.ui.model.FilterOperator.GT;
					sParsedValue = sValue.substr(1);
				} else if (aBetween) {
					if (aBetween[1] && aBetween[2]) {
						sOperator = sap.ui.model.FilterOperator.BT;
						sParsedValue = aBetween[1];
						sSecondaryParsedValue = aBetween[2];
					} else if (aBetween[1] && !aBetween[2]) {
						sOperator = sap.ui.model.FilterOperator.GE;
						sParsedValue = aBetween[1];
					} else {
						sOperator = sap.ui.model.FilterOperator.LE;
						sParsedValue = aBetween[2];
					}
				} else if (bIsString && sValue.indexOf("*") == 0 && sValue.lastIndexOf("*") == sValue.length - 1) {
					sOperator = sap.ui.model.FilterOperator.Contains;
					sParsedValue = sValue.substr(1, sValue.length - 2);
				} else if (bIsString && sValue.indexOf("*") == 0) {
					sOperator = sap.ui.model.FilterOperator.EndsWith;
					sParsedValue = sValue.substr(1);
				} else if (bIsString && sValue.lastIndexOf("*") == sValue.length - 1) {
					sOperator = sap.ui.model.FilterOperator.StartsWith;
					sParsedValue = sValue.substr(0, sValue.length - 1);
				} else {
					if (this.getDefaultFilterOperator()) {
						sOperator = this.getDefaultFilterOperator();
					} else {
						if (bIsString) {
							// Due to compatibility reason we need to use Contains for Strings instead of EQ as default!!
							sOperator = sap.ui.model.FilterOperator.Contains;
						} else {
							sOperator = sap.ui.model.FilterOperator.EQ;
						}
					}
					sParsedValue = sValue.substr(0);
				}
				if (!sSecondaryParsedValue) {
					oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sParsedValue));
				} else {
					oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sParsedValue), this._parseFilterValue(sSecondaryParsedValue));
				}
			} else {
				oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sValue));
			}

		}

		return oFilter;

	};

	Column.prototype.filter = function(sValue) {

		var oTable = this.getParent();
		if (oTable && oTable.isBound("rows")) {

			// notify the event listeners
			var bExecuteDefault = oTable.fireFilter({
				column: this,
				value: sValue
			});

			if (bExecuteDefault) {

				this.setProperty("filtered", !!sValue, true);
				this.setProperty("filterValue", sValue, true);
				var oMenu = this.getMenu();
				if (oMenu && oMenu instanceof sap.ui.table.ColumnMenu) {
					// update column menu input field
					oMenu._setFilterValue(sValue);
				}

				var aFilters = [];
				var aCols = oTable.getColumns();
				for (var i = 0, l = aCols.length; i < l; i++) {
					var oCol = aCols[i],
						oFilter;

					oMenu = oCol.getMenu();
					try {
						oFilter = oCol._getFilter();
						if (oMenu && oMenu instanceof sap.ui.table.ColumnMenu) {
							oMenu._setFilterState(sap.ui.core.ValueState.None);
						}
					} catch (e) {
						if (oMenu && oMenu instanceof sap.ui.table.ColumnMenu) {
							oMenu._setFilterState(sap.ui.core.ValueState.Error);
						}
						continue;
					}
					if (oFilter) {
						aFilters.push(oFilter);
					}
				}
				oTable.getBinding("rows").filter(aFilters, sap.ui.model.FilterType.Control);

				this._renderFilterIcon();

			}

		}

		return this;

	};

	Column.prototype._parseFilterValue = function(sValue) {
		var oFilterType = this.getFilterType();

		if (oFilterType) {
			if (jQuery.isFunction(oFilterType)) {
				sValue = oFilterType(sValue);
			} else {
				sValue = oFilterType.parseValue(sValue, "string");
			}
		}

		return sValue;
	};

	Column.prototype._renderFilterIcon = function() {
		var oTable = this.getParent();
		if (oTable && oTable.getDomRef()) {
			var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
			var oImage = sap.ui.getCore().byId(this.getId() + "-filterIcon") ||
				sap.ui.table.TableHelper.createImage({
					id: this.getId() + "-filterIcon",
					decorative: false,
					alt: oTable._oResBundle.getText("TBL_FILTER_ICON_TEXT")
				});
			oImage.$().remove();
			oImage.addStyleClass("sapUiTableColIconsFilter");
			if (this.getFiltered()) {
				oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_filter.gif"));
				var htmlImage = getHTML(oImage);
				jQuery(htmlImage).prependTo(this.getDomRef("icons"));
				this.$().find(".sapUiTableColCell").addClass("sapUiTableColFiltered");
			} else {
				this.$().find(".sapUiTableColCell").removeClass("sapUiTableColFiltered");
			}
		}
	};

	Column.prototype._restoreIcons = function() {

		if (this.getSorted()) {
			this._renderSortIcon();
		}

		if (this.getFiltered()) {
			this._renderFilterIcon();
		}

	};

	/**
	 * Returns whether the column should be rendered or not.
	 * @return {boolean} true, if the column should be rendered
	 * @protected
	 */
	Column.prototype.shouldRender = function() {
		return this.getVisible() && !this.getGrouped();
	};

	/*
	 * support the declarative usage of the filter type
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterType = function(vType) {
		var oType = vType;
		if (typeof (vType) === "string") {
			try {
				// similar to BindingParser allow to specify formatOptions and constraints for types
				var mConfig = jQuery.sap.parseJS(vType);
				if (typeof (mConfig.type) === "string") {
					var fnType = jQuery.sap.getObject(mConfig.type);
					oType = fnType && new fnType(mConfig.formatOptions, mConfig.constraints);
				}
			} catch (ex) {
				var fnType = jQuery.sap.getObject(vType);
				oType = fnType && new fnType();
			}
			// check for a valid type
			if (!(oType instanceof Type)) {
				jQuery.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");
				oType = undefined;
			}
		}
		this.setProperty("filterType", oType, true);
		return this;
	};

	/**
	 * Determines the column index based upon the order in its aggregation.
	 * Invisible columns are taken in account of order.
	 * @see JSDoc generated by SAPUI5 control API generator
	 * @return {int} the column index.
	 */
	Column.prototype.getIndex = function() {
		var oTable = this.getParent();
		if (oTable) {
			return oTable.indexOfColumn(this);
		} else {
			return -1;
		}
	};

	return Column;

}, /* bExport= */ true);

}; // end of sap/ui/table/Column.js
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenu') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.ColumnMenu.
jQuery.sap.declare('sap.ui.table.ColumnMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained
sap.ui.define("sap/ui/table/ColumnMenu",['jquery.sap.global', 'sap/ui/core/RenderManager', './library', 'sap/ui/unified/Menu', 'sap/ui/unified/MenuItem'],
	function(jQuery, RenderManager, library, Menu, MenuItem) {
	"use strict";

	/**
	 * Constructor for a new ColumnMenu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The column menu provides all common actions that can be performed on a column.
	 * @extends sap.ui.unified.Menu
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.ColumnMenu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) design time metamodel
	 */
	var ColumnMenu = Menu.extend("sap.ui.table.ColumnMenu", /** @lends sap.ui.table.ColumnMenu.prototype */ { metadata : {

		library : "sap.ui.table"
	}});


	/**
	 * This file defines behavior for the control,
	 */


	/**
	 * Initialization of the ColumnMenu control
	 * @private
	 */
	ColumnMenu.prototype.init = function() {
		if (Menu.prototype.init) {
			Menu.prototype.init.apply(this, arguments);
		}
		this.addStyleClass("sapUiTableColumnMenu");
		this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._bInvalidated = true;
		this._iPopupClosedTimeoutId = null;
		this._oColumn = null;
		this._oTable = null;
		this._attachPopupClosed();
	};


	/**
	 * Termination of the ColumnMenu control
	 * @private
	 */
	ColumnMenu.prototype.exit = function() {
		if (Menu.prototype.exit) {
			Menu.prototype.exit.apply(this, arguments);
		}
		window.clearTimeout(this._iPopupClosedTimeoutId);
		this._detachEvents();
		this._oColumn = this._oTable = null;
	};


	/**
	 * Event handler. Called when the theme is changed.
	 * @private
	 */
	ColumnMenu.prototype.onThemeChanged = function() {
		if (this.getDomRef()) {
			this._invalidate();
		}
	};


	/**
	 * Defines this object's new parent. If no new parent is given, the parent is
	 * just unset and we assume that the old parent has removed this child from its
	 * aggregation. But if a new parent is given, this child is first removed from
	 * its old parent.
	 *
	 * @param {sap.ui.base.ManagedObject} oParent the object that becomes this object's new parent
	 * @see {sap.ui.base.ManagedObject}
	 *
	 * @return {sap.ui.base.ManagedObject}
	 *            Returns <code>this</code> to allow method chaining
	 * @private
	 */
	ColumnMenu.prototype.setParent = function(oParent) {
		this._detachEvents();
		this._invalidate();
		this._updateReferences(oParent);
		this._attachEvents();
		return Menu.prototype.setParent.apply(this, arguments);
	};

	ColumnMenu.prototype._updateReferences = function(oParent) {
		this._oColumn = oParent;
		if (oParent) {
			jQuery.sap.assert(oParent instanceof sap.ui.table.Column, "ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");

			this._oTable = this._oColumn.getParent();
			if (this._oTable) {
				jQuery.sap.assert(this._oTable instanceof sap.ui.table.Table || this._oTable instanceof sap.ui.table.DataTable, "ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");
			}
		}
	};


	/**
	 * Attaches the required event handlers.
	 * @private
	 */
	ColumnMenu.prototype._attachEvents = function() {
		if (this._oTable) {
			this._oTable.attachColumnVisibility(this._invalidate, this);
			this._oTable.attachColumnMove(this._invalidate, this);
		}
	};


	/**
	 * Detaches the required event handlers.
	 * @private
	 */
	ColumnMenu.prototype._detachEvents = function() {
		if (this._oTable) {
			this._oTable.detachColumnVisibility(this._invalidate, this);
			this._oTable.detachColumnMove(this._invalidate, this);
		}
	};

	/**
	 * Invalidates the column menu control items. Forces recreation of the menu items when the menu is opened.
	 * @private
	 */
	ColumnMenu.prototype._invalidate = function() {
		this._bInvalidated = true;
	};


	/**
	 * Special handling for IE < 9 when the popup is closed.
	 * The associated column of the menu is focused when the menu is closed.
	 * @private
	 */
	ColumnMenu.prototype._attachPopupClosed = function() {
		// put the focus back into the column header after the
		// popup is being closed.
		var that = this;

		if (!sap.ui.Device.support.touch) {
			this.getPopup().attachClosed(function() {
				that._iPopupClosedTimeoutId = window.setTimeout(function() {
					if (that._oColumn) {
						if (that._lastFocusedDomRef) {
							that._lastFocusedDomRef.focus();
						} else {
							that._oColumn.focus();
						}
					}
				}, 0);
			});
		}
	};


	/**
	 * Override {@link sap.ui.unified.Menu#open} method.
	 * @see sap.ui.unified.Menu#open
	 * @private
	 */
	ColumnMenu.prototype.open = function() {
		if (this._bInvalidated) {
			this._bInvalidated = false;
			this.destroyItems();
			this._addMenuItems();
		}

		if (this.getItems().length > 0) {
			this._lastFocusedDomRef = arguments[4];
			Menu.prototype.open.apply(this, arguments);
		}
	};


	/**
	 * Adds the menu items to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addMenuItems = function() {
		// when you add or remove menu items here, remember to update the Column.prototype._menuHasItems function
		if (this._oColumn) {
			// items can only be created if the menus parent is a column
			// since column properties must be evaluated in order to create the items.
			this._addSortMenuItem(false);
			this._addSortMenuItem(true);
			this._addFilterMenuItem();
			this._addGroupMenuItem();
			this._addFreezeMenuItem();
			this._addColumnVisibilityMenuItem();
		}
	};

	/**
	 * Adds the sort menu item to the menu.
	 * @param {boolean} bDesc the sort direction. <code>true</code> for descending.
	 * @private
	 */
	ColumnMenu.prototype._addSortMenuItem = function(bDesc) {
		var oColumn = this._oColumn;

		if (oColumn.isSortableByMenu()) {
			var sDir = bDesc ? "desc" : "asc";
			var sIcon = bDesc ? "sort-descending" : "sort-ascending";
			if (oColumn.getSortProperty() && oColumn.getShowSortMenuEntry()) {
				this.addItem(this._createMenuItem(
					sDir,
						"TBL_SORT_" + sDir.toUpperCase(),
					sIcon,
					function (oEvent) {
						oColumn.sort(bDesc, oEvent.getParameter("ctrlKey") === true);
					}
				));
			}
		}
	};


	/**
	 * Adds the filter menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addFilterMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = oColumn.getParent();
		var bEnableCustomFilter = false;

		if (oTable) {
			bEnableCustomFilter = oTable.getEnableCustomFilter();
		}

		if (oColumn.isFilterableByMenu()) {
			if (bEnableCustomFilter) {
				this.addItem(this._createMenuItem(
					"filter",
					"TBL_FILTER_ITEM",
					"filter",
					function() {
						oTable.fireCustomFilter({
							column: oColumn
						});
					}
				));
			} else {
				this.addItem(this._createMenuTextFieldItem(
					"filter",
					"TBL_FILTER",
					"filter",
					oColumn.getFilterValue(),
					function() {
						oColumn.filter(this.getValue());
					}
				));
			}
		}
	};


	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addGroupMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = this._oTable;
		if (oColumn.isGroupableByMenu()) {
			if (oTable && oTable.getEnableGrouping() && oColumn.getSortProperty()) {
				this.addItem(this._createMenuItem(
					"group",
					"TBL_GROUP",
					null,
					jQuery.proxy(function() {
						oTable.setGroupBy(oColumn);
					},this)
				));
			}
		}
	};


	/**
	 * Adds the freeze menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addFreezeMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = this._oTable;
		if (oTable && oTable.getEnableColumnFreeze()) {
			var iColumnIndex = jQuery.inArray(oColumn, oTable.getColumns());
			var bIsFixedColumn = iColumnIndex + 1 == oTable.getFixedColumnCount();
			this.addItem(this._createMenuItem(
				"freeze",
				bIsFixedColumn ? "TBL_UNFREEZE" : "TBL_FREEZE",
				null,
				function() {
					// forward the event
					var bExecuteDefault = oTable.fireColumnFreeze({
						column: oColumn
					});

					// execute the column freezing
					if (bExecuteDefault) {
						if (bIsFixedColumn) {
							oTable.setFixedColumnCount(0);
						} else {
							oTable.setFixedColumnCount(iColumnIndex + 1);
						}
					}
				}
			));
		}
	};


	/**
	 * Adds the column visibility menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addColumnVisibilityMenuItem = function() {
		var oTable = this._oTable;

		if (oTable && oTable.getShowColumnVisibilityMenu()) {
			var oColumnVisibiltyMenuItem = this._createMenuItem("column-visibilty", "TBL_COLUMNS");
			this.addItem(oColumnVisibiltyMenuItem);

			var oColumnVisibiltyMenu = new Menu(oColumnVisibiltyMenuItem.getId() + "-menu");
			oColumnVisibiltyMenu.addStyleClass("sapUiTableColumnVisibilityMenu");
			oColumnVisibiltyMenuItem.setSubmenu(oColumnVisibiltyMenu);

			var aColumns = oTable.getColumns();

			if (oTable.getColumnVisibilityMenuSorter && typeof oTable.getColumnVisibilityMenuSorter === "function") {
				var oSorter = oTable.getColumnVisibilityMenuSorter();
				if (typeof oSorter === "function") {
					aColumns = aColumns.sort(oSorter);
				}
			}

			var oBinding = oTable.getBinding();
			var bAnalyticalBinding = sap.ui.model && sap.ui.model.analytics && oBinding instanceof sap.ui.model.analytics.AnalyticalBinding;

			for (var i = 0, l = aColumns.length; i < l; i++) {
				var oColumn = aColumns[i];
				// skip columns which are set to invisible by analytical metadata
				if (bAnalyticalBinding && oColumn instanceof sap.ui.table.AnalyticalColumn) {

					var oQueryResult = oBinding.getAnalyticalQueryResult();
					var oEntityType = oQueryResult.getEntityType();
					var oMetadata = oBinding.getModel().getProperty("/#" + oEntityType.getTypeDescription().name + "/" + oColumn.getLeadingProperty() + "/sap:visible");

					if (oMetadata && (oMetadata.value === "false" || oMetadata.value === false)) {
						continue;
					}
				}
				var oMenuItem = this._createColumnVisibilityMenuItem(oColumnVisibiltyMenu.getId() + "-item-" + i, oColumn);
				oColumnVisibiltyMenu.addItem(oMenuItem);
			}
		}
	};


	/**
	 * Factory method for the column visibility menu item.
	 * @param {string} sId the id of the menu item.
	 * @param {sap.ui.table.Column} oColumn the associated column to the menu item.
	 * @return {sap.ui.unified.MenuItem} the created menu item.
	 * @private
	 */
	ColumnMenu.prototype._createColumnVisibilityMenuItem = function(sId, oColumn) {
		var sText = oColumn.getName() || (oColumn.getLabel() && oColumn.getLabel().getText ? oColumn.getLabel().getText() : null);
		return new MenuItem(sId, {
			text: sText,
			icon: oColumn.getVisible() ? "sap-icon://accept" : null,
			select: jQuery.proxy(function(oEvent) {
				var oMenuItem = oEvent.getSource();
				var bVisible = !oColumn.getVisible();
				if (bVisible || this._oTable._getVisibleColumnCount() > 1) {
					var oTable = oColumn.getParent();
					var bExecuteDefault = true;
					if (oTable && (oTable instanceof sap.ui.table.Table || oTable instanceof sap.ui.table.DataTable)) {
						bExecuteDefault = oTable.fireColumnVisibility({
							column: oColumn,
							newVisible: bVisible
						});
					}
					if (bExecuteDefault) {
						oColumn.setVisible(bVisible);
					}
					oMenuItem.setIcon(bVisible ? "sap-icon://accept" : null);
				}
			}, this)
		});
	};


	/**
	 * Factory method for a menu item.
	 * @param {string} sId the id of the menu item.
	 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
	 * @param {string} sIcon the icon name
	 * @param {function} fHandler the handler function to call when the item gets selected.
	 * @return {sap.ui.unified.MenuItem} the created menu item.
	 * @private
	 */
	ColumnMenu.prototype._createMenuItem = function(sId, sTextI18nKey, sIcon, fHandler) {
		return new MenuItem(this.getId() + "-" + sId, {
			text: this.oResBundle.getText(sTextI18nKey),
			icon: sIcon ? "sap-icon://" + sIcon : null,
			select: fHandler || function() {}
		});
	};


	/**
	 * Factory method for a menu text field item.
	 * @param {string} sId the id of the menu item.
	 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
	 * @param {string} sIcon the icon name
	 * @param {string} sValue the default value of the text field
	 * @param {function} fHandler the handler function to call when the item gets selected.
	 * @return {sap.ui.unified.MenuTextFieldItem} the created menu text field item.
	 * @private
	 */
	ColumnMenu.prototype._createMenuTextFieldItem = function(sId, sTextI18nKey, sIcon, sValue, fHandler) {
		jQuery.sap.require("sap.ui.unified.MenuTextFieldItem");
		fHandler = fHandler || function() {};
		return new sap.ui.unified.MenuTextFieldItem(this.getId() + "-" + sId, {
			label: this.oResBundle.getText(sTextI18nKey),
			icon: sIcon ? "sap-icon://" + sIcon : null,
			value: sValue,
			select: fHandler || function() {}
		});
	};


	/**
	 * sets a new filter value into the filter field
	 * @param {String} sValue value of the filter input field to be set
	 * @return {sap.ui.table.ColumnMenu} this reference for chaining
	 * @private
	 */
	ColumnMenu.prototype._setFilterValue = function(sValue) {
		var oColumn = this.getParent();
		var oTable = (oColumn ? oColumn.getParent() : undefined);

		var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
		if (oFilterField && (oTable && !oTable.getEnableCustomFilter())) {
			oFilterField.setValue(sValue);
		}
		return this;
	};

	/**
	 * sets a new filter value into the filter field
	 * @param {sap.ui.core.ValueState} sFilterState value state for filter text field item
	 * @return {sap.ui.table.ColumnMenu} this reference for chaining
	 * @private
	 */
	ColumnMenu.prototype._setFilterState = function(sFilterState) {
		var oColumn = this.getParent();
		var oTable = (oColumn ? oColumn.getParent() : undefined);

		var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
		if (oFilterField && (oTable && !oTable.getEnableCustomFilter())) {
			oFilterField.setValueState(sFilterState);
		}
		return this;
	};


	return ColumnMenu;

}, /* bExport= */ true);

}; // end of sap/ui/table/ColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Row') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Row.
jQuery.sap.declare('sap.ui.table.Row'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Row",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";



	/**
	 * Constructor for a new Row.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The row.
	 * @extends sap.ui.core.Element
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Row
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Row = Element.extend("sap.ui.table.Row", /** @lends sap.ui.table.Row.prototype */ { metadata : {

		library : "sap.ui.table",
		defaultAggregation : "cells",
		aggregations : {

			/**
			 * The controls for the cells.
			 */
			cells : {type : "sap.ui.core.Control", multiple : true, singularName : "cell"}
		}
	}});


	/**
	 * Returns the index of the row in the table or -1 if not added to a table. This
	 * function considers the scroll position of the table and also takes fixed rows and
	 * fixed bottom rows into account.
	 *
	 * @return {int} index of the row (considers scroll position and fixed rows)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Row.prototype.getIndex = function() {
		var oTable = this.getParent();
		if (oTable) {
			// get the index of the row in the aggregation
			var iRowIndex = oTable.indexOfRow(this);

			// check for fixed rows. In this case the index of the context is the same like the index of the row in the aggregation
			var iNumberOfFixedRows = oTable.getFixedRowCount();
			if (iNumberOfFixedRows > 0 && iRowIndex < iNumberOfFixedRows) {
				return iRowIndex;
			}

			// check for fixed bottom rows
			var iNumberOfFixedBottomRows = oTable.getFixedBottomRowCount();
			var iVisibleRowCount = oTable.getVisibleRowCount();
			if (iNumberOfFixedBottomRows > 0 && iRowIndex >= iVisibleRowCount - iNumberOfFixedBottomRows) {
				var oBinding = oTable.getBinding("rows");
				if (oBinding && oBinding.getLength() >= iVisibleRowCount) {
					return oBinding.getLength() - (iVisibleRowCount - iRowIndex);
				} else {
					return iRowIndex;
				}
			}

			var iFirstRow = oTable.getFirstVisibleRow();
			return iFirstRow + iRowIndex;
		}
		return -1;
	};

	/**
	 *
	 * @param bJQuery Set to true to get jQuery object instead of DomRef
	 * @returns {object} contains DomRefs or jQuery objects of the row
	 */
	Row.prototype.getDomRefs = function (bJQuery) {
		var oDomRefs = {};
		var fnAccess = jQuery.sap.domById;
		if (bJQuery === true) {
			fnAccess = jQuery.sap.byId;
		}

		var oTable = this.getParent();
		if (oTable) {
			var iRowIndex = oTable.indexOfRow(this);
			// row selector domRef
			oDomRefs.rowSelector = fnAccess(oTable.getId() + "-rowsel" + iRowIndex);
		}

		// row domRef
		oDomRefs.rowScrollPart = fnAccess(this.getId());
		// row domRef (the fixed part)
		oDomRefs.rowFixedPart = fnAccess(this.getId() + "-fixed");
		// row selector domRef
		oDomRefs.rowSelectorText = fnAccess(this.getId() + "-rowselecttext");

		if (bJQuery === true) {
			oDomRefs.row = oDomRefs.rowScrollPart;
			if (oDomRefs.rowSelector && oDomRefs.rowSelector.length > 0) {
				oDomRefs.row = oDomRefs.row.add(oDomRefs.rowSelector);
			} else {
				// since this won't be undefined in jQuery case
				oDomRefs.rowSelector = undefined;
			}

			if (oDomRefs.rowFixedPart.length > 0) {
				oDomRefs.row = oDomRefs.row.add(oDomRefs.rowFixedPart);
			} else {
				// since this won't be undefined in jQuery case
				oDomRefs.rowFixedPart = undefined;
			}
		}

		return oDomRefs;
	};

	/**
	 *
	 * @param {sap.ui.table.Table} oTable Instance of the table
	 * @param {Object} mTooltipTexts texts for aria descriptions and tooltips
	 * @param {Object} mTooltipTexts.mouse texts for tooltips
	 * @param {String} mTooltipTexts.mouse.rowSelect text for row select tooltip (if row is unselected)
	 * @param {String} mTooltipTexts.mouse.rowDeselect text for row de-select tooltip (if row is selected)
	 * @param {Object} mTooltipTexts.keyboard texts for aria descriptions
	 * @param {String} mTooltipTexts.keyboard.rowSelect text for row select aria description (if row is unselected)
	 * @param {String} mTooltipTexts.keyboard.rowDeselect text for row de-select aria description (if row is selected)
	 * @param {Boolean} bSelectOnCellsAllowed set to true when the entire row may be clicked for selecting it
	 * @private
	 */
	Row.prototype._updateSelection = function(oTable, mTooltipTexts, bSelectOnCellsAllowed) {
		var bIsSelected = oTable.isIndexSelected(this.getIndex());
		var $DomRefs = this.getDomRefs(true);

		var sSelectReference = "rowSelect";
		if (bIsSelected) {
			// when the row is selected it must show texts how to deselect
			sSelectReference = "rowDeselect";
		}

		// update tooltips and aria texts
		if ($DomRefs.rowSelector) {
			$DomRefs.rowSelector.attr("title", mTooltipTexts.mouse[sSelectReference]);
			$DomRefs.rowSelector.attr("aria-label", mTooltipTexts.keyboard[sSelectReference]);
		}

		if ($DomRefs.rowSelectorText) {
			$DomRefs.rowSelectorText.text(mTooltipTexts.keyboard[sSelectReference]);
		}

		var $Row = $DomRefs.rowScrollPart;
		if ($DomRefs.rowFixedPart) {
			$Row = $Row.add($DomRefs.rowFixedPart);
		}

		if (bSelectOnCellsAllowed) {
			// the row requires a tooltip for selection if the cell selection is allowed
			$Row.attr("title", mTooltipTexts.mouse[sSelectReference]);
			$Row.attr("aria-label", mTooltipTexts.keyboard[sSelectReference]);
		} else {
			$Row.removeAttr("title");
			$Row.removeAttr("aria-label");
		}

		// update aria-selected state, do at the very end since this forces the screen reader to read the aria texts again
		if ($DomRefs.row) {
			// update visual selection state
			$DomRefs.row.toggleClass("sapUiTableRowSel", bIsSelected);
			$DomRefs.row.children("td").add($DomRefs.row).attr("aria-selected", bIsSelected.toString());
		}
	};

	return Row;

}, /* bExport= */ true);

}; // end of sap/ui/table/Row.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Table') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Table.
jQuery.sap.declare('sap.ui.table.Table'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ScrollBar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.SelectionModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.ChangeReason'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Table",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/IntervalTrigger', 'sap/ui/core/ScrollBar', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/core/theming/Parameters', 'sap/ui/model/SelectionModel', 'sap/ui/model/ChangeReason', './Row', './library', 'sap/ui/core/IconPool', 'jquery.sap.dom'],
	function(jQuery, Control, IntervalTrigger, ScrollBar, ItemNavigation, Parameters, SelectionModel, ChangeReason, Row, library, IconPool) {
	"use strict";



	/**
	 * Constructor for a new Table.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * <p>
	 *     Provides a comprehensive set of features for displaying and dealing with vast amounts of data. The Table control supports
	 *     desktop PCs and tablet devices. On tablets, special consideration should be given to the number of visible columns
	 *     and rows due to the limited performance of some devices.
	 * </p>
	 * <p>
	 *     In order to keep the document DOM as lean as possible, the Table control reuses its DOM elements of the rows.
	 *     When the user scrolls, only the row contexts are changed but the rendered controls remain the same. This allows
	 *     the Table control to handle huge amounts of data. Nevertheless, restrictions apply regarding the number of displayed
	 *     columns. Keep the number as low as possible to improve performance. Due to the nature of tables, the used
	 *     control for column templates also has a big influence on the performance.
	 * </p>
	 * <p>
	 *     The Table control relies completely on data binding, and its supported feature set is tightly coupled to
	 *     the data model and binding being used.
	 * </p>
	 *
	 *
	 * @extends sap.ui.core.Control
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Table
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Table = Control.extend("sap.ui.table.Table", /** @lends sap.ui.table.Table.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Width of the Table.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : 'auto'},

			/**
			 * Height of a row of the Table in pixel.
			 */
			rowHeight : {type : "int", group : "Appearance", defaultValue : null},

			/**
			 * Height of the column header of the Table in pixel.
			 */
			columnHeaderHeight : {type : "int", group : "Appearance", defaultValue : null},

			/**
			 * Flag whether the column header is visible or not.
			 */
			columnHeaderVisible : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Number of visible rows of the table.
			 */
			visibleRowCount : {type : "int", group : "Appearance", defaultValue : 10},

			/**
			 * First visible row.
			 */
			firstVisibleRow : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Selection mode of the Table. This property controls whether single or multiple rows can be selected and
			 * how the selection can be extended. It may also influence the visual appearance.
			 */
			selectionMode : {type : "sap.ui.table.SelectionMode", group : "Behavior", defaultValue : sap.ui.table.SelectionMode.Multi},

			/**
			 * Selection behavior of the Table. This property defines whether the row selector is displayed and whether the row, the row selector or both
			 * can be clicked to select a row.
			 */
			selectionBehavior : {type : "sap.ui.table.SelectionBehavior", group : "Behavior", defaultValue : sap.ui.table.SelectionBehavior.RowSelector},

			/**
			 * Zero-based index of selected item. Index value for no selection is -1.
			 * When multi-selection is enabled and multiple items are selected, the method returns
			 * the lead selected item. Sets the zero-based index of the currently selected item. This method
			 * removes any previous selections. When the given index is invalid, the call is ignored.
			 */
			selectedIndex : {type : "int", group : "Appearance", defaultValue : -1},

			/**
			 * Flag whether the controls of the Table are editable or not (currently this only controls the background color in certain themes!)
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Flag whether to use the scroll mode or paging mode. If the Paginator mode is used it will require the sap.ui.commons library!
			 */
			navigationMode : {type : "sap.ui.table.NavigationMode", group : "Behavior", defaultValue : sap.ui.table.NavigationMode.Scrollbar},

			/**
			 * The <code>threshold</code> defines how many additional (not yet visible records) shall be pre-fetched to enable smooth
			 * scrolling. The threshold is always added to the <code>visibleRowCount</code>. If the <code>visibleRowCount</code> is 10 and the
			 * <code>threshold</code> is 100, there will be 110 records fetched with the initial load.
			 * If the <code>threshold</code> is lower than the <code>visibleRowCount</code>, the <code>visibleRowCount</code> will be used as
			 * the <code>threshold</code>. If the value is 0 then the thresholding is disabled.
			 */
			threshold : {type : "int", group : "Appearance", defaultValue : 100},

			/**
			 * Flag to enable or disable column reordering
			 */
			enableColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Flag to enable or disable column grouping. (experimental!)
			 */
			enableGrouping : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Flag to show or hide the column visibility menu. This menu will get displayed in each
			 * generated column header menu. It allows to show or hide columns
			 */
			showColumnVisibilityMenu : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Flag whether to show the no data overlay or not once the table is empty. If set to false
			 * the table will just show a grid of empty cells
			 */
			showNoData : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * This defines how the table handles the visible rows in the table. The default behavior is,
			 * that a fixed row count is defined. If you change it to auto the visibleRowCount property is
			 * changed by the table automatically. It will then adjust its maximum row count to the space it is
			 * allowed to cover (limited by the surrounding container) and its minimum row count to the value of
			 * the property minAutoRowCount (default value : 5) In manual mode the user can change
			 * the visibleRowCount interactively.
			 * @since 1.9.2
			 * @see sap.ui.table.VisibleRowCountMode
			 */
			visibleRowCountMode : {type : "sap.ui.table.VisibleRowCountMode", group : "Appearance", defaultValue : sap.ui.table.VisibleRowCountMode.Fixed},

			/**
			 * This property is used to set the minimum count of visible rows when the property visibleRowCountMode is set to Auto or Interactive.
			 * For any other visibleRowCountMode, it is ignored.
			 */
			minAutoRowCount : {type : "int", group : "Appearance", defaultValue : 5},

			/**
			 * Number of columns that are fix on the left. When you use a horizontal scroll bar, only
			 * the columns which are not fixed, will scroll. Fixed columns need a defined width for the feature to work.
			 * Please note that the aggregated width of all fixed columns must not exceed the table width since there
			 * will be no scrollbar for fixed columns.
			 */
			fixedColumnCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Number of rows that are fix on the top. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
			 */
			fixedRowCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Number of rows that are fix on the bottom. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
			 * @since 1.18.7
			 */
			fixedBottomRowCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Flag whether to show or hide the column menu item to freeze or unfreeze a column.
			 * @since 1.21.0
			 */
			enableColumnFreeze : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Flag whether to enable or disable the context menu on cells to trigger a filtering with the cell value.
			 * @since 1.21.0
			 */
			enableCellFilter : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Setting this property to true will show an overlay on top of the Table content and users cannot click anymore on the Table content.
			 * @since 1.21.2
			 */
			showOverlay : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Specifies if a select all button should be displayed in the top left corner. This button is only displayed
			 * if the row selector is visible and the selection mode is set to any kind of multi selection.
			 * @since 1.23.0
			 */
			enableSelectAll : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Set this parameter to true to implement your own filter behaviour. Instead of the filter input box a button
			 * will be rendered for which' press event (customFilter) you can register an event handler.
			 * @since 1.23.0
			 */
			enableCustomFilter : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Set this parameter to true to make the table handle the busy indicator by its own.
			 * The table will switch to busy as soon as it scrolls into an unpaged area. This feature can only
			 * be used when the navigation mode is set to scrolling.
			 * @since 1.27.0
			 */
			enableBusyIndicator : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Flag to enable or disable column reordering
			 * @deprecated Since version 1.5.2.
			 * Use the property enableColumnReordering instead.
			 */
			allowColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},

			/**
			 * This text is shown, in case there is no data available to be displayed in the Table and no custom noData control is set.
			 * @since 1.21.0
			 * @deprecated Since version 1.22.1.
			 * The aggregation noData also supports string values now. Use noData instead.
			 */
			noDataText : {type : "string", group : "Appearance", defaultValue : null, deprecated: true}
		},
		defaultAggregation : "columns",
		aggregations : {

			/**
			 * Control or text of title section of the Table (if not set it will be hidden)
			 */
			title : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

			/**
			 * Control or text of footer section of the Table (if not set it will be hidden)
			 */
			footer : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

			/**
			 * Toolbar of the Table (if not set it will be hidden)
			 */
			toolbar : {type : "sap.ui.core.Toolbar", multiple : false},

			/**
			 * Extension section of the Table (if not set it will be hidden)
			 */
			extension : {type : "sap.ui.core.Control", multiple : true, singularName : "extension"},

			/**
			 * Columns of the Table
			 */
			columns : {type : "sap.ui.table.Column", multiple : true, singularName : "column", bindable : "bindable"},

			/**
			 * Rows of the Table
			 */
			rows : {type : "sap.ui.table.Row", multiple : true, singularName : "row", bindable : "bindable"},

			/**
			 * The value for the noData aggregation can be either a string value or a control instance.
			 * The control is shown, in case there is no data for the Table available. In case of a string
			 * value this will simply replace the no data text.
			 */
			noData : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}
		},
		associations : {

			/**
			 * Group By Column (experimental!)
			 */
			groupBy : {type : "sap.ui.table.Column", multiple : false}
		},
		events : {

			/**
			 * fired when the row selection of the table has been changed (the event parameters can be used to determine
			 * selection changes - to find out the selected rows you should better use the table selection API)
			 */
			rowSelectionChange : {
				parameters : {

					/**
					 * row index which has been clicked so that the selection has been changed (either selected or deselected)
					 */
					rowIndex : {type : "int"},

					/**
					 * binding context of the row which has been clicked so that selection has been changed
					 */
					rowContext : {type : "object"},

					/**
					 * array of row indices which selection has been changed (either selected or deselected)
					 */
					rowIndices : {type : "int[]"}
				}
			},

			/**
			 * fired when a column of the table has been selected
			 */
			columnSelect : {allowPreventDefault : true,
				parameters : {

					/**
					 * reference to the selected column
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * fired when a table column is resized.
			 */
			columnResize : {allowPreventDefault : true,
				parameters : {

					/**
					 * resized column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new width of the table column as CSS Size definition.
					 */
					width : {type : "sap.ui.core.CSSSize"}
				}
			},

			/**
			 * fired when a table column is moved.
			 */
			columnMove : {allowPreventDefault : true,
				parameters : {

					/**
					 * moved column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new position of the column.
					 */
					newPos : {type : "int"}
				}
			},

			/**
			 * fired when the table is sorted.
			 */
			sort : {allowPreventDefault : true,
				parameters : {

					/**
					 * sorted column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * Sort Order
					 */
					sortOrder : {type : "sap.ui.table.SortOrder"},

					/**
					 * If column was added to sorter this is true. If new sort is started this is set to false
					 */
					columnAdded : {type : "boolean"}
				}
			},

			/**
			 * fired when the table is filtered.
			 */
			filter : {allowPreventDefault : true,
				parameters : {

					/**
					 * filtered column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * filter value.
					 */
					value : {type : "string"}
				}
			},

			/**
			 * fired when the table is grouped (experimental!).
			 */
			group : {allowPreventDefault : true,
				parameters : {
					/**
					 * grouped column.
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * fired when the visibility of a table column is changed.
			 */
			columnVisibility : {allowPreventDefault : true,
				parameters : {

					/**
					 * affected column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new value of the visible property.
					 */
					visible : {type : "boolean"}
				}
			},

			/**
			 * fired when the user clicks a cell of the table (experimental!).
			 * @since 1.21.0
			 */
			cellClick : {allowPreventDefault : true,
				parameters : {
					/**
					 * The control of the cell.
					 */
					cellControl : {type : "sap.ui.core.Control"},

					/**
					 * DOM reference of the clicked cell. Can be used to position the context menu.
					 */
					cellDomRef : {type : "Object"},

					/**
					 * Row index of the selected cell.
					 */
					rowIndex : {type : "int"},

					/**
					 * Column index of the selected cell. This is the index of visible columns and might differ from
					 * the index maintained in the column aggregation.
					 */
					columnIndex : {type : "int"},

					/**
					 * Column ID of the selected cell.
					 */
					columnId : {type : "string"},

					/**
					 * Row binding context of the selected cell.
					 */
					rowBindingContext : {type : "sap.ui.model.Context"}
				}
			},

			/**
			 * fired when the user clicks a cell of the table.
			 * @since 1.21.0
			 */
			cellContextmenu : {allowPreventDefault : true,
				parameters : {
					/**
					 * The control of the cell.
					 */
					cellControl : {type : "sap.ui.core.Control"},

					/**
					 * DOM reference of the clicked cell. Can be used to position the context menu.
					 */
					cellDomRef : {type : "Object"},

					/**
					 * Row index of the selected cell.
					 */
					rowIndex : {type : "int"},

					/**
					 * Column index of the selected cell. This is the index of visible columns and might differ from
					 * the index maintained in the column aggregation.
					 */
					columnIndex : {type : "int"},

					/**
					 * Column ID of the selected cell.
					 */
					columnId : {type : "string"},

					/**
					 * Row binding context of the selected cell.
					 */
					rowBindingContext : {type : "sap.ui.model.Context"}
				}
			},

			/**
			 * fired when a column of the table should be freezed
			 * @since 1.21.0
			 */
			columnFreeze : {allowPreventDefault : true,
				parameters : {

					/**
					 * reference to the column to freeze
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * This event is triggered when the custom filter item of the column menu is pressed. The column on which the event was triggered is passed as parameter.
			 * @since 1.23.0
			 */
			customFilter : {
				/**
				 * The column instance on which the custom filter button was pressed.
				 */
				column : {type : "sap.ui.table.Column"},

				/**
				 * Filter value.
				 */
				value : {type : "string"}
			}
		}
	}});
































	// =============================================================================
	// BASIC CONTROL API
	// =============================================================================

	Table.ResizeTrigger = new IntervalTrigger(300);

	IconPool.insertFontFaceStyle();

	/**
	 * Initialization of the Table control
	 * @private
	 */
	Table.prototype.init = function() {
		this._iBaseFontSize = parseFloat(jQuery("body").css("font-size")) || 16;
		// create an information object which contains always required infos
		this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._bAccMode = sap.ui.getCore().getConfiguration().getAccessibility();
		this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL();

		// basic selection model (by default the table uses multi selection)
		this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);

		// minimum width of a table column in pixel:
		// should at least be larger than the paddings for cols and cells!
		this._iColMinWidth = 20;
		if ('ontouchstart' in document) {
			this._iColMinWidth = 88;
		}

		this._oCalcColumnWidths = [];

		// columns to cells map
		this._aIdxCols2Cells = [];

		// visible columns
		this._aVisibleColumns = [];

		// we add a delegate to enable to focus the scrollbar when clicking on them
		// to avoid that the table control grabs the focus and scrolls to the focus
		// element (hide the outline)
		var fnFocusIndex = {
			onAfterRendering: function(oEvent) {
				oEvent.srcControl.$("sb").attr("tabindex", "-1").css("outline", "none");
			}
		};

		// vertical scrollbar
		this._oVSb = new ScrollBar(this.getId() + "-vsb", {size: "100%"});

		//
		// Optimization for large tables: scroll event is fired only by mouse up.
		//
		// TODO: decide if to switch this dynamically or via API
		this._oVSb._bLargeDataScrolling = false;

		this._oVSb.attachScroll(this.onvscroll, this);
		this._oVSb.addDelegate(fnFocusIndex);

		// horizontal scrollbar (configure by default for the pixel mode)
		this._oHSb = new ScrollBar(this.getId() + "-hsb", {size: "100%", contentSize: "0px", vertical: false});
		this._oHSb.attachScroll(this.onhscroll, this);
		this._oHSb.addDelegate(fnFocusIndex);

		// action mode flag (for keyboard navigation)
		this._bActionMode = false;

		// column index of the last fixed column (to prevent column reordering!)
		this._iLastFixedColIndex = -1;

		// flag whether the editable property should be inherited or not
		this._bInheritEditableToControls = false;

		// text selection for column headers?
		this._bAllowColumnHeaderTextSelection = false;

		// flag, whether to call _updateTableCell on cell control or not?
		this._bCallUpdateTableCell = false;

		// timer delay in ms
		this._iTimerDelay = 250;

		this._doubleclickDelay = 300;
		this._clicksRegistered = 0;

		// determine whether jQuery version is less than 1.8 (height and width behaves different!!)
		this._bjQueryLess18 = jQuery.sap.Version(jQuery.fn.jquery).compareTo("1.8") < 0;
		this._iDataRequestedCounter = 0;
		this._bDataRequestedListenersAttached = false;

		// F6 Handling is done in TableRenderer to make sure the table content gets the focus. The
		// Toolbar has its own F6 stop.
		// this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};


	/**
	 * Termination of the Table control
	 * @private
	 */
	Table.prototype.exit = function() {
		// destroy the child controls
		this._oVSb.destroy();
		this._oHSb.destroy();
		if (this._oPaginator) {
			this._oPaginator.destroy();
		}
		// destroy helpers
		this._destroyItemNavigation();
		// cleanup
		this._cleanUpTimers();
		this._detachEvents();
	};


	/**
	 * theme changed
	 * @private
	 */
	Table.prototype.onThemeChanged = function() {
		if (this.getDomRef()) {
			this.invalidate();
		}
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	Table.prototype.onBeforeRendering = function() {
		this._cleanUpTimers();
		this._detachEvents();
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	Table.prototype.onAfterRendering = function() {
		this._bOnAfterRendering = true;

		var $this = this.$();

		if ('ontouchstart' in document) {
			$this.addClass("sapUiTableTouch");
		}

		this._renderOverlay();
		this._updateVSb(true);
		this._updateTableContent();
		this._handleResize();

		this._attachEvents();

		// restore the column icons
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].getVisible()) {
				aCols[i]._restoreIcons();
			}
		}

		// enable/disable text selection for column headers
		if (!this._bAllowColumnHeaderTextSelection) {
			this._disableTextSelection($this.find(".sapUiTableColHdrCnt"));
		}

		this._bOnAfterRendering = false;

		this._initItemNavigation();

		if (this._bDetermineVisibleCols === true) {
			this._determineVisibleCols();
			this._bDetermineVisibleCols = false;
		}
	};

	/**
	 * Render overlay div
	 * @private
	 */
	Table.prototype._renderOverlay = function() {
		var $this = this.$(),
		    $overlay = $this.find(".sapUiTableOverlay"),
		    bShowOverlay = this.getShowOverlay();
		if (bShowOverlay && $overlay.length === 0) {
			$overlay = jQuery("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index", "1");
			$this.append($overlay);
		} else if (!bShowOverlay) {
			$overlay.remove();
		}
	};

	Table.prototype.setShowOverlay = function(bShow) {
		this.setProperty("showOverlay", bShow, true);
		this._renderOverlay();
		return this;
	};

	/**
	 * update the table content (scrollbar, no data overlay, selection, row header, ...)
	 * @private
	 */
	Table.prototype._updateTableContent = function() {

		// show or hide the no data container
		this._updateNoData();

		// update the selection visualization
		this._updateSelection();

		// update the rows (TODO: generalize this for 1.6)
		if (this._modifyRow) {
			jQuery.each(this.getRows(), function(iIndex, oRow) {
				this._modifyRow(iIndex + this.getFirstVisibleRow(), oRow.$());
				this._modifyRow(iIndex + this.getFirstVisibleRow(), oRow.$("fixed"));
			}.bind(this));
		}

		var oBinding = this.getBinding("rows");
		var iFixedTopRows = this.getFixedRowCount();
		var iFixedBottomRows = this.getFixedBottomRowCount();
		var iVisibleRowCount = this.getVisibleRowCount();

		jQuery.each(this.getRows(), function(iIndex, oRow) {
			var $rowDomRefs = oRow.getDomRefs(true);

			// update row header tooltip
			if (oRow.getBindingContext() && this._isRowSelectable(oRow.getIndex())) {
				$rowDomRefs.rowSelector.attr("title", this._oResBundle.getText("TBL_ROW_SELECT"));
			} else {
				$rowDomRefs.rowSelector.attr("title", "");
			}

			if (iFixedTopRows > 0) {
				$rowDomRefs.row.toggleClass("sapUiTableFixedTopRow", iIndex < iFixedTopRows);
				$rowDomRefs.row.toggleClass("sapUiTableFixedLastTopRow", iIndex == iFixedTopRows - 1);
			}

			if (iFixedBottomRows > 0) {
				var bIsPreBottomRow = false;
				if (oBinding) {
					if (oBinding.getLength() >= iVisibleRowCount) {
						bIsPreBottomRow = (iIndex == iVisibleRowCount - iFixedBottomRows - 1);
					} else {
						bIsPreBottomRow = (this.getFirstVisibleRow() + iIndex) == (oBinding.getLength() - iFixedBottomRows - 1) && (this.getFirstVisibleRow() + iIndex) < oBinding.getLength();
					}
				}

				$rowDomRefs.row.toggleClass("sapUiTableFixedPreBottomRow", bIsPreBottomRow);
			}
		}.bind(this));

		// update the row header (sync row heights)
		this._updateRowHeader();

		// hook for update table cell after rendering is complete
		if (this._bOnAfterRendering && (this._bCallUpdateTableCell || typeof this._updateTableCell === "function")) {
			var oBindingInfo = this.mBindingInfos["rows"];
			jQuery.each(this.getRows(), function(iIndex, oRow) {
				var iAbsoluteRowIndex = this.getFirstVisibleRow() + iIndex; //get the absolute row index

				jQuery.each(oRow.getCells(), function(iIndex, oCell) {
					if (oCell._updateTableCell) {
						oCell._updateTableCell(oCell /* cell control */,
						                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
						                       oCell.$().closest("td") /* jQuery object for td */,
						                       iAbsoluteRowIndex);
					}
					if (this._updateTableCell) {
						this._updateTableCell(oCell /* cell control */,
						                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
						                       oCell.$().closest("td") /* jQuery object for td */,
						                       iAbsoluteRowIndex);
					}
				});
			}.bind(this));
		}
	};


	// =============================================================================
	// ITEMNAVIGATION
	// =============================================================================


	/**
	 * initialize ItemNavigation. Transfer relevant controls to ItemNavigation.
	 * TabIndexes are set by ItemNavigation
	 * @private
	*/
	Table.prototype._initItemNavigation = function() {

		var $this = this.$();
		var iColumnCount = this._getVisibleColumnCount();
		var iTotalColumnCount = iColumnCount;
		var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;

		// initialization of item navigation for the Column Headers
		if (!this._oColHdrItemNav) {
			this._oColHdrItemNav = new ItemNavigation();
			this._oColHdrItemNav.setCycling(false);
			this.addDelegate(this._oColHdrItemNav);
		}

		// create the list of item dom refs
		var aItemDomRefs = [];
		if (this.getFixedColumnCount() == 0) {
			aItemDomRefs = $this.find(".sapUiTableCtrl td[tabindex]").get();
		} else {
			var $topLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');
			var $topRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');
			var $middleLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');
			var $middleRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');
			var $bottomLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');
			var $bottomRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');
			for (var i = 0; i < this.getVisibleRowCount(); i++) {
				aItemDomRefs = aItemDomRefs.concat($topLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($topRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($middleLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($middleRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($bottomLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($bottomRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
			}
		}

		// to later determine the position of the first TD in the aItemDomRefs we keep the
		// count of TDs => aCount - TDs = first TD (add the row headers to the TD count / except the first one!)
		var iTDCount = aItemDomRefs.length;
		var iInitialIndex = 0;

		// add the row header items (if visible)
		if (bHasRowHeader) {
			var aRowHdrDomRefs = $this.find(".sapUiTableRowHdr").get();
			for (var i = aRowHdrDomRefs.length - 1; i >= 0; i--) {
				aItemDomRefs.splice(i * iColumnCount, 0, aRowHdrDomRefs[i]);
				// we ignore the row headers
				iTDCount++;
			}
			// except the first row header
			iTDCount--;
			// add the row header to the column count
			iTotalColumnCount++;
			iInitialIndex = 1;
		}

		// add the column items
		if (this.getColumnHeaderVisible()) {
			aItemDomRefs = $this.find(".sapUiTableCol").get().concat(aItemDomRefs);
		}

		// add the select all item
		if (bHasRowHeader && this.getColumnHeaderVisible()) {
			var aRowHdr = $this.find(".sapUiTableColRowHdr").get();
			for (var i = this._getHeaderRowCount() - 1; i >= 0; i--) {
				aItemDomRefs.splice(i * iColumnCount, 0, aRowHdr[0]);
			}
		}

		// initialization of item navigation for the Table control
		if (!this._oItemNavigation) {
			this._iLastSelectedDataRow = this._getHeaderRowCount();
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setTableMode(true);
			this._oItemNavigation.attachEvent(ItemNavigation.Events.BeforeFocus, function(oEvent) {
				this.$("ariadesc").text("");
			}, this);
			this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, function(oEvent) {
				var iRow = Math.floor(oEvent.getParameter("index") / this._oItemNavigation.iColumns);
				if (iRow > 0) {
					this._iLastSelectedDataRow = iRow;
				}
			}, this);
			this.addDelegate(this._oItemNavigation);
		}

		// configure the item navigation
		this._oItemNavigation.setColumns(iTotalColumnCount);
		this._oItemNavigation.setRootDomRef($this.find(".sapUiTableCnt").get(0));
		this._oItemNavigation.setItemDomRefs(aItemDomRefs);
		this._oItemNavigation.setFocusedIndex(iInitialIndex);

	};

	/**
	 * destroys ItemNavigation
	 * @private
	*/
	Table.prototype._destroyItemNavigation = function() {

		// destroy of item navigation for the Table control
		if (this._oItemNavigation) {
			this._oItemNavigation.destroy();
			this._oItemNavigation = undefined;
		}

	};


	/*
	 * @see JSDoc generated by SAPUI5 control
	 */
	Table.prototype.getFocusInfo = function() {
		var sId = this.$().find(":focus").attr("id");
		if (sId) {
			return {customId: sId};
		} else {
			return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control
	 */
	Table.prototype.applyFocusInfo = function(mFocusInfo) {
		if (mFocusInfo && mFocusInfo.customId) {
			this.$().find("#" + mFocusInfo.customId).focus();
		} else {
			sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
		return this;
	};


	// =============================================================================
	// PUBLIC TABLE API
	// =============================================================================


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setTitle = function(vTitle) {
		var oTitle = vTitle;
		if (typeof (vTitle) === "string" || vTitle instanceof String) {
			oTitle = sap.ui.table.TableHelper.createTextView({
				text: vTitle,
				width: "100%"
			});
			oTitle.addStyleClass("sapUiTableHdrTitle");
		}
		this.setAggregation("title", oTitle);
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFooter = function(vFooter) {
		var oFooter = vFooter;
		if (typeof (vFooter) === "string" || vFooter instanceof String) {
			oFooter = sap.ui.table.TableHelper.createTextView({
				text: vFooter,
				width: "100%"
			});
		}
		this.setAggregation("footer", oFooter);
		return this;
	};


	/**
	 * Sets the selection mode. The current selection is lost.
	 * @param {string} sSelectionMode the selection mode, see sap.ui.table.SelectionMode
	 * @public
	 * @return a reference on the table for chaining
	 */
	Table.prototype.setSelectionMode = function(sSelectionMode) {
		this.clearSelection();
		if (sSelectionMode === sap.ui.table.SelectionMode.Single) {
			this._oSelection.setSelectionMode(SelectionModel.SINGLE_SELECTION);
		} else {
			this._oSelection.setSelectionMode(SelectionModel.MULTI_SELECTION);
		}
		this.setProperty("selectionMode", sSelectionMode);
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFirstVisibleRow = function(iRowIndex, bOnScroll) {
		// TODO: think about this optimization - for now it doesn't work since
		//       this API is used to update the rows afterwards
		//if (iRowIndex !== this.getFirstVisibleRow()) {
			// update the property

			this.setProperty("firstVisibleRow", iRowIndex, true);
			// update the bindings:
			//  - prevent the rerendering
			//  - use the databinding fwk to update the content of the rows
			if (this.getBinding("rows") && !this._bRefreshing) {
				this.updateRows();
			}

			this._updateAriaRowOfRowsText(true);

		if (bOnScroll && !this._$AriaLiveDomRef && this._bAccMode) {
			if (this._ariaLiveTimer) {
				jQuery.sap.clearDelayedCall(this._ariaLiveTimer);
			}

			var fnSetAriaLive = function() {
				if (this._oItemNavigation) {
					this._$AriaLiveDomRef = jQuery(this._oItemNavigation.getFocusedDomRef()).attr("aria-live", "rude");
					var oTable = this;
					var fnRemoveAriaLive = function () {
						if (oTable._$AriaLiveDomRef) {
							oTable._$AriaLiveDomRef.removeAttr("aria-live");
							delete oTable._$AriaLiveDomRef;
						}
					};
					jQuery.sap.delayedCall(0, this, fnRemoveAriaLive);
					delete this._ariaLiveTimer;
				}
			};

			this._ariaLiveTimer = jQuery.sap.delayedCall(60, this, fnSetAriaLive);
		}

		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.getAllowColumnReordering = function() {
		jQuery.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");
		return Table.prototype.getEnableColumnReordering.apply(this, arguments);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setAllowColumnReordering = function() {
		jQuery.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");
		return Table.prototype.setEnableColumnReordering.apply(this, arguments);
	};


	// enable calling 'bindAggregation("rows")' without a factory
	Table.getMetadata().getAggregation("rows")._doesNotRequireFactory = true;

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.bindRows = function(oBindingInfo, vTemplate, oSorter, aFilters) {
		// ensure old Table API compatibility (sPath, [oSorter], [aFilters])
		if (typeof oBindingInfo === "string" &&
			  (vTemplate instanceof sap.ui.model.Sorter || jQuery.isArray(oSorter) && oSorter[0] instanceof sap.ui.model.Filter) ) {
			aFilters = oSorter;
			oSorter = vTemplate;
			vTemplate = undefined;
		}

		return this.bindAggregation("rows", oBindingInfo, vTemplate, oSorter, aFilters);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
		sap.ui.core.Element.prototype._bindAggregation.apply(this, arguments);
		var oBinding = this.getBinding("rows");
		if (sName === "rows" && oBinding) {
			oBinding.attachChange(this._onBindingChange, this);
		}

		// re-initialize the selection model, might be necessary in case the table gets "rebound"
		this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);

		// currently only required for TreeBindings, will be relevant for ListBindings later
		if (oBinding && this.isTreeBinding("rows") && !oBinding.hasListeners("selectionChanged")) {
			oBinding.attachSelectionChanged(this._onSelectionChanged, this);
		}
		return this;
	};

	/**
	 * Initialises a new selection model for the Table instance.
	 * @param {sap.ui.model.SelectionModel.MULTI_SELECTION|sap.ui.model.SelectionModel.SINGLE_SELECTION} sSelectionMode the selection mode of the selection model
	 * @return {sap.ui.table.Table} the table instance for chaining
	 * @private
	 */
	Table.prototype._initSelectionModel = function (sSelectionMode) {
		// detach old selection model event handler
		if (this._oSelection) {
			this._oSelection.detachSelectionChanged(this._onSelectionChanged, this);
		}
		//new selection model with the currently set selection mode
		this._oSelection = new sap.ui.model.SelectionModel(sSelectionMode);
		this._oSelection.attachSelectionChanged(this._onSelectionChanged, this);

		return this;
	};

	/**
	 * handler for change events of the binding
	 * @param {sap.ui.base.Event} oEvent change event
	 * @private
	 */
	Table.prototype._onBindingChange = function(oEvent) {
		var sReason = typeof (oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
		if (sReason === "sort" || sReason === "filter") {
			this.clearSelection();
			this.setFirstVisibleRow(0);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.unbindAggregation = function(sName, bSuppressReset) {
		var oBinding = this.getBinding("rows");
		if (sName === "rows" && oBinding) {
			oBinding.detachChange(this._onBindingChange);

			this._restoreAppDefaultsColumnHeaderSortFilter();
			// metadata might have changed
			this._invalidateColumnMenus();
			this.updateRows(); // TODO: shouldn't this be more a central feature?!
		}

		//Reset needs to be resetted, else destroyRows is called, which is not allowed to be called
		bSuppressReset = sName === "rows" && this.isBound("rows");
		return sap.ui.core.Element.prototype.unbindAggregation.apply(this, [sName, bSuppressReset]);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setVisibleRowCountMode = function(oVisibleRowCountMode) {
		this.setProperty("visibleRowCountMode", oVisibleRowCountMode);
		this._handleRowCountMode();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setVisibleRowCount = function(iVisibleRowCount) {
		if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
			return this;
		}

		if (iVisibleRowCount <= (this.getFixedRowCount() + this.getFixedBottomRowCount())) {
			jQuery.sap.log.error("Table: " + this.getId() + " visibleRowCount('" + iVisibleRowCount + "') must be bigger than number of fixed rows('" + (this.getFixedRowCount() + this.getFixedBottomRowCount()) + "')");
			return this;
		}

		iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
		if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
			this.setProperty("firstVisibleRow", 0);
		}
		this.setProperty("visibleRowCount", iVisibleRowCount);
		return this;
	};

	/**
	 * Sets a new tooltip for this object. The tooltip can either be a simple string
	 * (which in most cases will be rendered as the <code>title</code> attribute of this
	 * Element) or an instance of {@link sap.ui.core.TooltipBase}.
	 *
	 * If a new tooltip is set, any previously set tooltip is deactivated.
	 *
	 * Please note that tooltips are not rendered for the table. The tooltip property will be set
	 * but it won't effect the DOM.
	 *
	 * @param {string|sap.ui.core.TooltipBase} vTooltip
	 * @returns {sap.ui.table.Table} This-reference for chaining
	 * @public
	 * @override
	 */
	Table.prototype.setTooltip = function(vTooltip) {
		jQuery.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");
		return this.setAggregation("tooltip", vTooltip, true);
	};

	/**
	 * refresh rows
	 * @private
	 */
	Table.prototype.refreshRows = function(vEvent) {
		var sReason = typeof (vEvent) === "object" ? vEvent.getParameter("reason") : vEvent;
		if (sReason == sap.ui.model.ChangeReason.Refresh) {
			this._attachBindingListener();
		}
		this._bBusyIndicatorAllowed = true;
		//needs to be called here to reset the firstVisible row so that the correct data is fetched
		this._bRefreshing = true;
		this._onBindingChange(vEvent);
		this._updateBindingContexts(true);
		this._bRefreshing = false;
	};

	/**
	 * updates the rows - called internally by the updateAggregation function when
	 * anything in the model has been changed.
	 * @private
	 */
	Table.prototype.updateRows = function(sReason) {
		this._setBusy(sReason ? {changeReason: sReason} : false);

		// by default the start index is the first visible row
		var iStartIndex = this.getFirstVisibleRow();

		// calculate the boundaries (at least 0 - max the row count - visible row count)
		iStartIndex = Math.max(iStartIndex, 0);
		if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar && this._getRowCount() > 0) {
			iStartIndex = Math.min(iStartIndex, Math.max(this._getRowCount() - this.getVisibleRowCount(), 0));
		}
		this.setProperty("firstVisibleRow", iStartIndex, true);

		// when not scrolling we update also the scroll position of the scrollbar
		if (this._oVSb.getScrollPosition() !== iStartIndex) {
			this._oVSb.setScrollPosition(iStartIndex);
			this._updateAriaRowOfRowsText(true);
		}

		// update the paginator
		if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			// if iStartIndex is equal or greater than the number of total rows go back to page 1
			var iNewPage = 1;
			if (iStartIndex < this.getBinding("rows").getLength()) {
				iNewPage = Math.ceil((iStartIndex + 1) / this.getVisibleRowCount());
			}
			if (iNewPage !== this._oPaginator.getCurrentPage()) {
				this.setProperty("firstVisibleRow", (iNewPage - 1) * this.getVisibleRowCount(), true);
				this._oPaginator.setCurrentPage(iNewPage);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
			}
		}

		// update the bindings only once the table is rendered
		if (this.getDomRef()) {
			// update the bindings by using a delayed mechanism to avoid to many update
			// requests: by using the mechanism below it will trigger an update each 50ms
			// except if the reason is coming from the binding with reason "change" then
			// we do an immediate update instead of a delayed one
			var iDelay = (sReason == ChangeReason.Change ? 0 : 50);
			this._sBindingTimer = this._sBindingTimer || jQuery.sap.delayedCall(iDelay, this, function() {
				// update only if control not marked as destroyed (could happen because updateRows is called during destroying the table)
				if (!this.bIsDestroyed) {
					this._determineVisibleCols();
					this._updateBindingContexts();
					this._updateVSb(); // this was moved here, before it was done before updatebindingContext
					this._updateTableContent();
					this._sBindingTimer = undefined;
					//Helper event for testing
					this.fireEvent("_rowsUpdated");
				}
			});
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.insertRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.addRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeAllRows = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.destroyRows = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");
	};

	/**
	 * triggers automatic resizing of a column to the widest content.(experimental!)
	 * @experimental Experimental! Presently implemented to only work with pure text-based controls,
	 * the sap.ui.commons.Checkbox and sap.m.Image as well as sap.ui.commons.Image.
	 * It will also work for most simple input fields (TextField, CheckBox, but not ComboBox)
	 *
	 * @param {int} iColId column id
	 * @function
	 * @public
	 */
	Table.prototype.autoResizeColumn = function(iColId) {
		var oCol = this.getColumns()[iColId];
		this._iColumnResizeStart = null;
		var iNewWidth = this._calculateAutomaticColumnWidth(iColId);
		if (iNewWidth == null) {
			return;
		}

		oCol._iNewWidth = iNewWidth;
		this._oCalcColumnWidths[iColId] = oCol._iNewWidth;
		this._onColumnResized(null, iColId);
	};


	// =============================================================================
	// EVENT HANDLING & CLEANUP
	// =============================================================================

	/**
	 * attaches the required native event handlers
	 * @private
	 */
	Table.prototype._attachEvents = function() {

		var $this = this.$();

		// listen to the scroll events of the containers (for keyboard navigation)
		$this.find(".sapUiTableColHdrScr").scroll(jQuery.proxy(this._oncolscroll, this));
		$this.find(".sapUiTableCtrlScr").scroll(jQuery.proxy(this._oncntscroll, this));
		$this.find(".sapUiTableCtrlScrFixed").scroll(jQuery.proxy(this._oncntscroll, this));

		// sync row header > content (hover effect)
		$this.find(".sapUiTableRowHdr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableRowHdr").index(this);
			$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// sync content fixed > row header (hover effect)
		$this.find(".sapUiTableCtrlFixed > tbody > tr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableCtrlFixed > tbody > tr").index(this);
			$this.find(".sapUiTableRowHdr").filter(":eq(" + (iIndex) + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// sync content scroll > row header (hover effect)
		$this.find(".sapUiTableCtrlScroll > tbody > tr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableCtrlScroll > tbody > tr").index(this);
			$this.find(".sapUiTableRowHdr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// listen to the resize handlers
		$this.find(".sapUiTableColRsz").mousedown(jQuery.proxy(this._onColumnResizeStart, this));

		this._enableColumnAutoResizing();
		Table.ResizeTrigger.addListener(this._checkTableSize, this);

		// the vertical scrollbar listens to the mousewheel on the content section
		this._oHSb.bind($this.find(".sapUiTableCtrlScr").get(0));
		this._oVSb.bind($this.find(".sapUiTableCtrlScr").get(0));
		this._oHSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.bind($this.find(".sapUiTableRowHdrScr").get(0));

		jQuery("body").bind('webkitTransitionEnd transitionend',
			jQuery.proxy(function(oEvent) {
				if (jQuery(oEvent.target).has($this).length > 0) {
					this._handleResize();
				}
			}, this));
	};


	/**
	 * detaches the required native event handlers
	 * @private
	 */
	Table.prototype._detachEvents = function() {

		var $this = this.$();

		$this.find(".sapUiTableRowHdrScr").unbind();
		$this.find(".sapUiTableColHdrScr").unbind();

		$this.find(".sapUiTableCtrl > tbody > tr").unbind();
		$this.find(".sapUiTableRowHdr").unbind();

		Table.ResizeTrigger.removeListener(this._checkTableSize, this);

		$this.find(".sapUiTableColRsz").unbind();

		this._oHSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
		this._oVSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
		this._oHSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.unbind($this.find(".sapUiTableRowHdrScr").get(0));

		jQuery("body").unbind('webkitTransitionEnd transitionend');
	};


	/**
	 * cleanup the timers when not required anymore
	 * @private
	 */
	Table.prototype._cleanUpTimers = function() {

		if (this._sBindingTimer) {
			jQuery.sap.clearDelayedCall(this._sBindingTimer);
			this._sBindingTimer = undefined;
		}

		if (this._sScrollBarTimer) {
			jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
			this._sScrollBarTimer = undefined;
		}

		if (this._sDelayedMenuTimer) {
			jQuery.sap.clearDelayedCall(this._sDelayedMenuTimer);
			this._sDelayedMenuTimer = undefined;
		}

		if (this._sDelayedActionTimer) {
			jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
			this._sDelayedActionTimer = undefined;
		}

		if (this._sColHdrPosTimer) {
			jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
			this._sColHdrPosTimer = undefined;
		}

		if (this._visibleRowCountTimer) {
			jQuery.sap.clearDelayedCall(this._visibleRowCountTimer);
			this._visibleRowCountTimer = undefined;
		}

		Table.ResizeTrigger.removeListener(this._checkTableSize, this);
	};


	// =============================================================================
	// PRIVATE TABLE STUFF :)
	// =============================================================================

	/**
	 *
	 * @param oBinding
	 * @returns {*}
	 * @private
	 */
	Table.prototype._getFixedBottomRowContexts = function (oBinding) {
		var iFixedBottomRowCount = this.getFixedBottomRowCount();
		var iVisibleRowCount = this.getVisibleRowCount();
		var aContexts;
		if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
			aContexts = oBinding.getContexts(oBinding.getLength() - iFixedBottomRowCount, iFixedBottomRowCount, 1);
		} else {
			aContexts = [];
		}

		return aContexts;
	};


	/**
	 * creates the rows for the rows aggregation
	 * @private
	 */
	Table.prototype._createRows = function(iStartIndex) {
		var iFirstVisibleRow = this.getFirstVisibleRow();
		var iVisibleRowCount = this.getVisibleRowCount();

		// by default the start index is the first visible row
		iStartIndex = iStartIndex === undefined ? iFirstVisibleRow : iStartIndex;

		// create the new template
		var oTemplate = new Row(this.getId() + "-rows");
		var aCols = this.getColumns();
		var iCellIndex = 0;
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].getVisible()) {
				var oColTemplate = aCols[i].getTemplate();
				if (oColTemplate) {
					var oClone = oColTemplate.clone("col" + i);
					// inherit the editable property if required to the child controls
					if (this._bInheritEditableToControls && !this.getEditable() && oClone.setEditable) {
						oClone.setEditable(false);
					}
					oClone.data("sap-ui-colindex", i);
					oClone.data("sap-ui-colid", aCols[i].getId());
					oTemplate.addCell(oClone);
					this._aIdxCols2Cells[i] = iCellIndex++;
				}
			}
		}

		// initially called without iStartIndex and iLength
		this.destroyAggregation("rows", true);
		var aContexts;
		var oBinding = this.getBinding("rows");
		var oBindingInfo = this.mBindingInfos["rows"];
		if (oBinding && iVisibleRowCount > 0) {
			// if thresholding is 0 then it is disabled and we forward 0 to the binding
			var iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
			var iFixedBottomRowCount = this.getFixedBottomRowCount();
			aContexts = oBinding.getContexts(iStartIndex, iVisibleRowCount - iFixedBottomRowCount, iThreshold);
			this._setBusy({
				requestedLength: iVisibleRowCount - iFixedBottomRowCount,
				receivedLength: aContexts.length,
				contexts: aContexts });

			var aFixedBottomContexts = [];
			aFixedBottomContexts = this._getFixedBottomRowContexts(oBinding);

			aContexts = aContexts.concat(aFixedBottomContexts);

			if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
				this._setBusy({
					requestedLength: iFixedBottomRowCount,
					receivedLength: aFixedBottomContexts.length,
					contexts: aFixedBottomContexts });
			}
		}
		for (var i = 0; i < iVisibleRowCount; i++) {
			var oClone = oTemplate.clone("row" + i); // TODO: Isn't the following required! + "-" + this.getId());
			if (aContexts && aContexts[i]) {
				oClone.setBindingContext(aContexts[i], oBindingInfo.model);
				oClone._bHidden = false;
			} else {
				if (oBindingInfo) {
					oClone.setBindingContext(null, oBindingInfo.model);
				} else {
					oClone.setBindingContext(null);
				}

				oClone._bHidden = true;
			}
			this.addAggregation("rows", oClone, true);
		}

		// destroy the template
		oTemplate.destroy();
	};


	/**
	 * updates the horizontal scrollbar
	 * @private
	 */
	Table.prototype._updateHSb = function() {

		// get the width of the container
		var $this = this.$();

		// apply the new content size
		var iColsWidth = $this.find(".sapUiTableCtrlScroll").width();
		if (!!sap.ui.Device.browser.safari) {
			iColsWidth = Math.max(iColsWidth, this._getColumnsWidth(this.getFixedColumnCount()));
		}

		// add the horizontal scrollbar
		if (iColsWidth > $this.find(".sapUiTableCtrlScr").width()) {
			// show the scrollbar
			if (!$this.hasClass("sapUiTableHScr")) {
				$this.addClass("sapUiTableHScr");

				if (!!sap.ui.Device.browser.safari) {
					var $sapUiTableColHdr = $this.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");
					// min-width on table elements does not work for safari
					if (this._bjQueryLess18) {
						$sapUiTableColHdr.width(iColsWidth);
					} else {
						$sapUiTableColHdr.outerWidth(iColsWidth);
					}
				}
			}

			var iScrollPadding = $this.find(".sapUiTableCtrlFixed").width();

			if ($this.find(".sapUiTableRowHdrScr:visible").length > 0) {
				iScrollPadding += $this.find(".sapUiTableRowHdrScr").width();
			}

			var $sapUiTableHSb = $this.find(".sapUiTableHSb");
			if (this._bRtlMode) {
				$sapUiTableHSb.css('padding-right', iScrollPadding + 'px');
			} else {
				$sapUiTableHSb.css('padding-left', iScrollPadding + 'px');
			}

			// When table has no fixed width, the scrollbar is not allowed to increase the width of the table.
			// We define the max-width of the scrollbar to be limited by its parent width.
			var iMaximumScrollBarWidth = $sapUiTableHSb.parent().width();
			$sapUiTableHSb.css('max-width', iMaximumScrollBarWidth + "px");

			this._oHSb.setContentSize(iColsWidth + "px");

			if (this._oHSb.getDomRef()) {
				this._oHSb.rerender();
			}
		} else {
			// hide the scrollbar
			if ($this.hasClass("sapUiTableHScr")) {
				$this.removeClass("sapUiTableHScr");
				if (!!sap.ui.Device.browser.safari) {
					// min-width on table elements does not work for safari
					$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width", "");
				}
			}
		}

		this._syncHeaderAndContent();

	};


	/**
	 * updates the vertical scrollbar
	 * @private
	 */
	Table.prototype._updateVSb = function(bOnAfterRendering) {
		var $this = this.$();
		var bDoResize = false;
		var bForceUpdateVSb = false;
		var oBinding = this.getBinding("rows");
		if (oBinding) {

			// move the vertical scrollbar to the scrolling table only
			var iFixedRows = this.getFixedRowCount();
			if (iFixedRows > 0) {
				var iOffsetTop = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;
				this.$().find('.sapUiTableVSb').css('top', (iOffsetTop - 1) + 'px');
				bForceUpdateVSb = true;
			}
			var iFixedBottomRows = this.getFixedBottomRowCount();
			if (iFixedBottomRows > 0) {
				var iOffsetHeight = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;
				this.$().find('.sapUiTableVSb').css('height', iOffsetHeight + 'px');
				bForceUpdateVSb = true;
			}

			var iLength = oBinding.getLength();
			var iSteps = Math.max(0, (iLength || 0) - this.getVisibleRowCount());
			// check for paging mode or scrollbar mode
			if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				// update the paginator (set the first visible row property)
				var iNumberOfPages = Math.ceil((iLength || 0) / this.getVisibleRowCount());
				this._oPaginator.setNumberOfPages(iNumberOfPages);
				var iPage = Math.min(iNumberOfPages, Math.ceil((this.getFirstVisibleRow() + 1) / this.getVisibleRowCount()));
				this.setProperty("firstVisibleRow", (Math.max(iPage,1) - 1) * this.getVisibleRowCount(), true);
				this._oPaginator.setCurrentPage(iPage);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
				if ($this.hasClass("sapUiTableVScr")) {
					$this.removeClass("sapUiTableVScr");
				}

				if (this._sScrollBarTimer != undefined) {
					jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
				}
			} else {
				// in case of scrollbar mode show or hide the scrollbar dependening on the
				// calculated steps:
				if (iSteps > 0) {
					if (!$this.hasClass("sapUiTableVScr")) {
						$this.addClass("sapUiTableVScr");
						bDoResize = true;
					}
				} else {
					//scroll to top when the scrollbar vanishes -> the binding length is smaller than the number of visible rows
					if (iLength > 0) {
						// only set the scroll position to 0 if there is some data which can be shown.
						// this allows the application to set a scroll position even though the data was not yet loaded.
						this.setFirstVisibleRow(0);
					}

					if ($this.hasClass("sapUiTableVScr")) {
						$this.removeClass("sapUiTableVScr");
						bDoResize = true;
					}
				}

				// update the scrollbar only if it is required
				if (bOnAfterRendering || bForceUpdateVSb || iSteps !== this._oVSb.getSteps() || this.getFirstVisibleRow() !== this._oVSb.getScrollPosition()) {
					jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
					this._sScrollBarTimer = undefined;
					// TODO: in case of bForceUpdateVSb the scrolling doesn't work anymore
					//       height changes of the scrollbar should not require a re-rendering!
					this._sScrollBarTimer = jQuery.sap.delayedCall(bOnAfterRendering ? 0 : 250, this, function() {
						// When the scrollbar timer is planned iSteps might be 0 because the binding might not have data yet.
						// This can even happen with JSON ListBinding if setProperty is called on a collection
						// Make sure to get the current length from the binding.
						var iSteps = 0;
						if (oBinding) {
							// the binding might have changed by the time the function gets called
							iSteps = Math.max(0, (oBinding.getLength() || 0) - this.getVisibleRowCount());
						}

						if ($this) {
							$this.toggleClass("sapUiTableVScr", iSteps > 0);
						}

						this._oVSb.setSteps(iSteps);
						if (this._oVSb.getDomRef()) {
							this._oVSb.rerender();
						}
						this._oVSb.setScrollPosition(this.getFirstVisibleRow());
						this._sScrollBarTimer = undefined;
					});
				}
			}
		} else {
			// check for paging mode or scrollbar mode
			if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				// update the paginator (set the first visible row property)
				this._oPaginator.setNumberOfPages(0);
				this._oPaginator.setCurrentPage(0);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
			} else {
				if ($this.hasClass("sapUiTableVScr")) {
					$this.removeClass("sapUiTableVScr");
					bDoResize = true;
				}
			}
		}
		if (bDoResize && !this._bOnAfterRendering) {
			this._handleResize();
		}
	};


	/**
	 * updates the binding contexts of the currently visible controls
	 * @private
	 */
	Table.prototype._updateBindingContexts = function(bSuppressUpdate) {

		var aRows = this.getRows(),
			oBinding = this.getBinding("rows"),
			oBindinginfo = this.mBindingInfos["rows"],
			aFixedContexts,
			aContexts,
			aFixedBottomContexts,
			iFixedRows = this.getFixedRowCount(),
			iFixedBottomRows = this.getFixedBottomRowCount(),
			iVisibleRowCount = this.getVisibleRowCount();

		// fetch the contexts from the binding
		if (oBinding) {
			var iThreshold;
			if ((iFixedRows > 0 || iFixedBottomRows > 0) && aRows.length > 0) {
				// thresholding is deactivated when value is 0
				var iTotalFixedRows = iFixedRows + iFixedBottomRows;
				iThreshold = this.getThreshold() ? Math.max((this.getVisibleRowCount() - iTotalFixedRows), this.getThreshold()) : 0;
				var iRequestedLength = Math.max(0, aRows.length - iTotalFixedRows);
				aContexts = oBinding.getContexts(this.getFirstVisibleRow() + iFixedRows, iRequestedLength, iThreshold);
				this._setBusy({
					requestedLength: iRequestedLength,
					receivedLength: aContexts.length,
					contexts: aContexts });
				// static rows: we fetch the contexts without threshold to avoid loading
				// of unnecessary data. Make sure to fetch after the normal rows to avoid
				// outgoing double requests for the contexts.
				if (iFixedRows > 0) {
					aFixedContexts = oBinding.getContexts(0, iFixedRows);
					this._setBusy({
						requestedLength: iFixedRows,
						receivedLength: aFixedContexts.length,
						contexts: aFixedContexts });

					aContexts = aFixedContexts.concat(aContexts);
				}

				var aFixedBottomContexts = this._getFixedBottomRowContexts(oBinding);
				aContexts = aContexts.concat(aFixedBottomContexts);

				if (iFixedBottomRows > 0 && (iVisibleRowCount - iFixedBottomRows) < oBinding.getLength()) {
					this._setBusy({
						requestedLength: iFixedBottomRows,
						receivedLength: aFixedBottomContexts.length,
						contexts: aFixedBottomContexts });
				}
			} else if (aRows.length > 0) {
				// thresholding is deactivated when value is 0
				iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
				aContexts = oBinding.getContexts(this.getFirstVisibleRow(), aRows.length, iThreshold);
				this._setBusy({
					requestedLength: aRows.length,
					receivedLength: aContexts.length,
					contexts: aContexts });
			}
		}

		// update the binding contexts only for the visible columns
		//for (var iIndex = 0, iLength = this.getRows().length; iIndex < iLength; iIndex++) {
		if (!bSuppressUpdate) {
			for (var iIndex = aRows.length - 1; iIndex >= 0; iIndex--) {
				var oContext = aContexts ? aContexts[iIndex] : undefined;
				var oRow = aRows[iIndex];
				if (oRow) {
					//calculate the absolute row index, used by the Tree/AnalyticalTable to find the rendering infos for this row
					var iAbsoluteRowIndex = this.getFirstVisibleRow() + iIndex;
					this._updateRowBindingContext(oRow, oContext, oBindinginfo && oBindinginfo.model, iAbsoluteRowIndex);
				}
			}
		}

	};

	/**
	 * updates the binding context a row
	 * @param {sap.ui.table.Row} row to update
	 * @param {sap.ui.model.Context} binding context of the row
	 * @private
	 */
	Table.prototype._updateRowBindingContext = function(oRow, oContext, sModelName, iAbsoluteRowIndex) {
		var aCells = oRow.getCells();
		var $rowTargets = oRow.getDomRefs(true).row;

		// check for a context object (in case of grouping there could be custom context objects)
		oRow.setBindingContext(oContext, sModelName);
		if (oContext && oContext instanceof sap.ui.model.Context) {
			for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
				var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
				if (aCells[col]) {
					this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
				}
			}
			$rowTargets.removeClass("sapUiTableRowHidden");
			oRow._bHidden = false;
		} else {
			$rowTargets.addClass("sapUiTableRowHidden");
			$rowTargets.removeClass('sapUiTableFixedPreBottomRow sapUiTableFixedTopRow');

			oRow._bHidden = true;
			for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
				var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
				if (aCells[col]) {
					this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
				}
			}
		}
	};

	/**
	 * updates the binding context a cell
	 * @param {sap.ui.core.Control} control of the cell
	 * @param {sap.ui.model.Context} binding context of the cell
	 * @private
	 */
	Table.prototype._updateCellBindingContext = function(oCell, oContext, sModelName, iAbsoluteRowIndex) {
			//oCell.setBindingContext(oContext, sModelName);
			if (this._bCallUpdateTableCell && oCell._updateTableCell) {
				oCell._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
			if (typeof this._updateTableCell === "function") {
				this._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
	};

	/**
	 * check if data is available in the table
	 * @private
	 */
	Table.prototype._hasData = function() {
		var oBinding = this.getBinding("rows");
		if (!oBinding || (oBinding.getLength() || 0) === 0) {
			return false;
		}
		return true;
	};

	/**
	 * show or hide the no data container
	 * @private
	 */
	Table.prototype._updateNoData = function() {
		// no data?
		if (this.getShowNoData()) {
			var oBinding = this.getBinding("rows");
			if (!this._hasData()) {
				if (!this.$().hasClass("sapUiTableEmpty")) {
					this.$().addClass("sapUiTableEmpty");
				}
				// update the ARIA text for the row count
				this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [0]));
			} else {
				if (this.$().hasClass("sapUiTableEmpty")) {
					this.$().removeClass("sapUiTableEmpty");
				}
				// update the ARIA text for the row count
				this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [(oBinding.getLength() || 0)]));
			}
		}
	};


	/**
	 * determines the currently visible columns (used for simply updating only the
	 * controls of the visible columns instead of the complete row!)
	 * @private
	 */
	Table.prototype._determineVisibleCols = function() {

		// determine the visible colums
		var $this = this.$(),
		    that = this;

		if ($this.hasClass("sapUiTableHScr")) {

			var bRtl = this._bRtlMode;

			// calculate the view port
			var iScrollLeft = this._oHSb.getNativeScrollPosition();
			if (bRtl && sap.ui.Device.browser.firefox && iScrollLeft < 0) {
				// Firefox deals with negative scrollPosition in RTL mode
				iScrollLeft = iScrollLeft * -1;
			}
			var iScrollRight = iScrollLeft + this._getScrollWidth();

			// has the view port changed?
			if (this._iOldScrollLeft !== iScrollLeft || this._iOldScrollRight !== iScrollRight || this._bForceVisibleColCalc) {

				// calculate the first and last visible column
				var iLeft = bRtl ? $this.find(".sapUiTableCtrlScroll").width() : 0;

				if ((sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox) && bRtl) {
					// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
					// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
					iLeft = 0;
				}

				this._aVisibleColumns = [];
				for (var i = 0, l = this.getFixedColumnCount(); i < l; i++) {
					this._aVisibleColumns.push(i);
				}
				var $ths = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");
				$ths.each(function(iIndex, oElement) {
					var iWidth = jQuery(oElement).width();
					if (bRtl && sap.ui.Device.browser.chrome) {
						iLeft -= iWidth;
					}
					if (iLeft + iWidth >= iScrollLeft && iLeft <= iScrollRight) {
						that._aVisibleColumns.push(parseInt(jQuery(oElement).data('sap-ui-headcolindex'),10));
					}
					if (!bRtl || (sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox)) {
						iLeft += iWidth;
					}
				});

				// keep the view port information (performance!!)
				this._iOldScrollLeft = iScrollLeft;
				this._iOldScrollRight = iScrollRight;
				this._bForceVisibleColCalc = false;
			}
		} else {
			this._aVisibleColumns = [];
			var aCols = this.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					this._aVisibleColumns.push(i);
				}
			}
		}

	};

	/**
	 * enables automatic resizing on doubleclick on a column if the corresponding column attribute is set
	 * @experimental Experimental, only works with limited control set
	 * @function
	 * @private
	 */
	Table.prototype._enableColumnAutoResizing = function (){
		var that = this;
		jQuery.each(this.getColumns(), function (iIndex, oCol){
			if (!!oCol.getAutoResizable()){
				var $resizer = jQuery.find(".sapUiTableColRsz[data-sap-ui-colindex=" + iIndex + "]");
				if ($resizer){
					that._bindSimulatedDoubleclick($resizer, null /* fnSingleClick*/, that._onAutomaticColumnResize /* fnDoubleClick */);
				}
			}
		});
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeColumn = function (oColumn) {
		var oResult = this.removeAggregation('columns', oColumn);
		this._bDetermineVisibleCols = true;

		if (typeof oColumn === "number" && oColumn > -1) {
			oColumn = this.getColumns()[oColumn];
		}

		var iIndex = jQuery.inArray(oColumn, this._aSortedColumns);
		if (this._iNewColPos === undefined && iIndex >= 0) {
			this._aSortedColumns.splice(iIndex, 1);
		}

		return oResult;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeAllColumns = function() {
		var oResult = this.removeAllAggregation('columns');
		this._aSortedColumns = [];

		return oResult;
	};

	/*
	 * @see JSDoc generated by SAPUI5 contdrol API generator
	 */
	Table.prototype.destroyColumns = function() {
		var oResult = this.destroyAggregation('columns');
		this._aSortedColumns = [];

		return oResult;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.addColumn = function (oColumn) {
		var that = this;
		this.addAggregation('columns', oColumn);
		oColumn.attachEvent('_widthChanged', function(oEvent) {
			that._bForceVisibleColCalc = true;
		});

		this._bDetermineVisibleCols = true;
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.insertColumn = function (oColumn, iIndex) {
		var that = this;
		this.insertAggregation('columns', oColumn, iIndex);
		oColumn.attachEvent('_widthChanged', function() {
			that._bForceVisibleColCalc = true;
		});

		this._bDetermineVisibleCols = true;
		return this;
	};

	/**
	 * returns the count of rows when bound or 0
	 * @private
	 */
	Table.prototype._getRowCount = function() {
		var oBinding = this.getBinding("rows");
		return oBinding ? (oBinding.getLength() || 0) : 0;
	};

	/**
	 * returns the count of rows which can ca selected when bound or 0
	 * @private
	 */
	Table.prototype._getSelectableRowCount = function() {
		return this._getRowCount();
	};


	/**
	 * returns the current top scroll position of the scrollbar (row number)
	 * @private
	 */
	Table.prototype._getScrollTop = function() {
		if (this.$().hasClass("sapUiTableVScr")) {
			return this._oVSb.getScrollPosition() || 0;
		} else {
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				return (((this._oPaginator.getCurrentPage() || 1) - 1) * this.getVisibleRowCount());
			} else {
				return 0;
			}
		}
	};

	/**
	 * returns the width of the table scroll container
	 * @private
	 */
	Table.prototype._getScrollWidth = function() {
		return this.$().find(".sapUiTableCtrlScr").width();
	};

	/**
	 * returns the height of the table scroll container
	 * @private
	 */
	Table.prototype._getScrollHeight = function() {
		return this.$().find(".sapUiTableCtrlScr").height();
	};

	/**
	 * returns the count of visible columns
	 * @private
	 */
	Table.prototype._getVisibleColumns = function() {
		var aColumns = [];
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].shouldRender()) {
				aColumns.push(aCols[i]);
			}
		}
		return aColumns;
	};

	/**
	 * returns the count of visible columns
	 * @private
	 */
	Table.prototype._getVisibleColumnCount = function() {
		return this._getVisibleColumns().length;
	};

	/**
	 * returns the row count of headers
	 * @private
	 */
	Table.prototype._getHeaderRowCount = function() {
		if (!this.getColumnHeaderVisible()) {
			return 0;
		} else if (!this._useMultiHeader()) {
			return 1;
		}
		var iHeaderRows = 0;
		jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
			iHeaderRows = Math.max(iHeaderRows,  oColumn.getMultiLabels().length);
		});
		return iHeaderRows;
	};

	/**
	 * returns if multi header beahviour is used or not
	 * @private
	 */
	Table.prototype._useMultiHeader = function() {
		var useMultiLabels = false;
		jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
			if (oColumn.getMultiLabels().length > 0) {
				useMultiLabels = true;
				return false;
			}
		});
		return useMultiLabels;
	};


	/**
	 * Returns the summed width of all rendered columns
	 * @private
	 * @param {Number} iStartColumn starting column for calculating the width
	 * @param {Number} iEndColumn ending column for calculating the width
	 * @returns {Number} the summed column width
	 */
	Table.prototype._getColumnsWidth = function(iStartColumn, iEndColumn) {
		// first calculate the min width of the table for all columns
		var aCols = this.getColumns();
		var iColsWidth = 0;

		if (iStartColumn !== 0 && !iStartColumn) {
			iStartColumn = 0;
		}
		if (iEndColumn !== 0 && !iEndColumn) {
			iEndColumn = aCols.length;
		}

		for (var i = iStartColumn, l = iEndColumn; i < l; i++) {
			if (aCols[i] && aCols[i].shouldRender()) {
				iColsWidth += this._CSSSizeToPixel(aCols[i].getWidth());
			}
		}

		return iColsWidth;

	};

	/**
	 * Calculates the pixel value from a given CSS size and returns it with or without unit.
	 * @param sCSSSize
	 * @param bReturnWithUnit
	 * @returns {string|number} Converted CSS value in pixel
	 * @private
	 */
	Table.prototype._CSSSizeToPixel = function(sCSSSize, bReturnWithUnit) {
		var sPixelValue = this._iColMinWidth;

		if (sCSSSize) {
			if (jQuery.sap.endsWith(sCSSSize, "px")) {
				sPixelValue = parseInt(sCSSSize, 10);
			} else if (jQuery.sap.endsWith(sCSSSize, "em") || jQuery.sap.endsWith(sCSSSize, "rem")) {
				sPixelValue = Math.ceil(parseFloat(sCSSSize) * this._getBaseFontSize());
			}
		}

		if (bReturnWithUnit) {
			return sPixelValue + "px";
		} else {
			return parseInt(sPixelValue, 10);
		}
	};

	Table.prototype._getBaseFontSize = function() {
		return this._iBaseFontSize;
	};

	/**
	 * calculates the width of the columns by using the browsers calculation
	 * mechanism and setting a fix width to the columns
	 * @private
	 */
	Table.prototype._handleResize = function() {

		// when using the native resize handler then this function could be called
		// before the table has been rendered - therefore we interrupt this method
		if (!this.getDomRef()) {
			return;
		}

		// update the horizontal scrollbar
		this._updateHSb();

		// update the column header (sync column widths)
		this._updateColumnHeader();

		this._updateRowHeader();

		this._handleRowCountMode();
	};

	Table.prototype._checkTableSize = function() {
		if (!this.getDomRef()) {
			return;
		}

		var oParentDomRef = this.getDomRef().parentNode,
			iHeight = oParentDomRef.offsetHeight,
			iWidth = oParentDomRef.offsetWidth;

		if (oParentDomRef != this._lastParent || iHeight != this._lastParentHeight || iWidth != this._lastParentWidth) {
			this._handleResize();
			this._lastParent = oParentDomRef;
			this._lastParentHeight = iHeight;
			this._lastParentWidth = iWidth;

			// update the bindings
			if (this.getBinding("rows")) {
				this.updateRows();
			}
		}
	};

	Table.prototype._handleRowCountMode = function() {
		//if visibleRowCountMode is auto change the visibleRowCount according to the parents container height
		if (this.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
			var $this = this.$();

			var iCanvasHeight = $this.parent().height();
			var iRows = this._calculateRowsToDisplay(iCanvasHeight);

			if (isNaN(iRows)) {
				return;
			}
			// Currently this needs to be executed in a timeout because invalidate is lost wenn method is called during onAfterRendering
			// This can be reverted when keeping the invalidate calls, that occur during onAfterRendering are kept
			var that = this;
			this._visibleRowCountTimer = setTimeout(function() {
				that.setVisibleRowCount(iRows);
			}, 0);
		}
	};

	/**
	 * updates the row headers
	 * @private
	 */
	Table.prototype._updateRowHeader = function() {

		// we skip this expensive height and width calculation when not required!
		if (this.getFixedRowCount() >= 0 || this.getFixedColumnCount() >= 0 || this.getRowHeight() <= 0) {

			var $this = this.$();

			var $fixedRows = $this.find(".sapUiTableCtrlFixed > tbody > tr");
			var $scrollRows = $this.find(".sapUiTableCtrlScroll > tbody > tr");
			var $rowHeaders = $this.find(".sapUiTableRowHdr");

			if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
				$fixedRows.css('height','');
				$scrollRows.css('height','');
			}

			for (var i = 0, l = $scrollRows.length; i < l; i++) {
				var iHeight = Math.max($fixedRows[i] ? ($fixedRows[i].getBoundingClientRect().bottom - $fixedRows[i].getBoundingClientRect().top) : 0, $scrollRows[i] ? ($scrollRows[i].getBoundingClientRect().bottom - $scrollRows[i].getBoundingClientRect().top) : 0);
				if (this._bjQueryLess18) {
					jQuery($rowHeaders[i]).height(iHeight);
					if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
						jQuery($fixedRows[i]).height(iHeight);
						jQuery($scrollRows[i]).height(iHeight);
					}
				} else {
					jQuery($rowHeaders[i]).outerHeight(iHeight);
					if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
						jQuery($fixedRows[i]).outerHeight(iHeight);
						jQuery($scrollRows[i]).outerHeight(iHeight);
					}
				}
			}

		}

	};

	/**
	 * Synchronizes the <th> width of the table, with the rendered header divs.
	 * @private
	 */
	Table.prototype._syncColumnHeaders = function(bUpdateResizeHandlers) {
		var oDomRef = this.getDomRef();
		if (!oDomRef) {
			// _syncColumnHeaders gets called async, there might be no DomRef anymore
			return;
		}
		var $this = this.$();
		var oRectTable = oDomRef.getBoundingClientRect();
		var iTableWidth = oRectTable.right - oRectTable.left;
		var aVisibleColumns = this._getVisibleColumns();
		if (aVisibleColumns.length == 0) {
			return;
		}
		var iInvisibleColWidth = 0;

		var bRtl = this._bRtlMode;
		var iLeftAway = bRtl ? 99000 : -99000;

		// Select only table headers (identified by data-sap-ui-headcolindex attribute). Not the row header.
		var $colHeaderContainer = $this.find(".sapUiTableColHdr");
		var $tableHeaders = $this.find(".sapUiTableCtrlFirstCol > th");

		var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
		if (bHasRowHeader && $tableHeaders.length > 0) {
			var oHiddenElement = $tableHeaders.get(0);
			iInvisibleColWidth = oHiddenElement.getBoundingClientRect().right - oHiddenElement.getBoundingClientRect().left;
			$tableHeaders = $tableHeaders.not(":nth-child(1)");
		}

		// Create map with source table headers and their corresponding resizers.
		var mHeaders = {};

		// Traverse the source table headers, which are needed to determine the column head width
		$tableHeaders.each(function(iIndex, oElement) {
			var iHeadColIndex = oElement.getAttribute("data-sap-ui-headcolindex");
			var oRect = oElement.getBoundingClientRect();

			// set width of target column div
			var iTargetWidth;
			var oVisibleColumn = aVisibleColumns[iIndex];
			if (oVisibleColumn) {
				iTargetWidth = oRect.right - oRect.left;
			}

			//for the first column also calculate the width of the hidden column
			if (iIndex == 0) {
				iTargetWidth += iInvisibleColWidth;
			}

			// apply the width of the column
			var	vHeaderSpan = aVisibleColumns[iIndex] ? aVisibleColumns[iIndex].getHeaderSpan() : 1,
				aHeaderData = [],
				aSpans;

			if (vHeaderSpan) {
				// vHeaderSpan can be an array for multi column header rows purpose.
				if (!jQuery.isArray(vHeaderSpan)) {
					vHeaderSpan = [vHeaderSpan];
				}
				jQuery.each(vHeaderSpan, function(iSpanIndex, iSpan) {
					vHeaderSpan[iSpanIndex] = Math.max(iSpan, 1);
				});

				aSpans = vHeaderSpan;
			} else {
				aSpans = [1];
			}

			for (var i = 0; i < aSpans.length; i++) {
				aHeaderData[i] = {
					width: iTargetWidth,
					span: 1
				};

				for (var j = 1; j < aSpans[i]; j++) {
					var oHeader = $tableHeaders[iIndex + j];
					var oHeaderRect = oHeader.getBoundingClientRect();
					if (oHeader) {
						aHeaderData[i].width += oHeaderRect.right - oHeaderRect.left;
						aHeaderData[i].span = aSpans[i];
					}
				}
			}

			if (oVisibleColumn) {
				var oColRsz = document.getElementById(oVisibleColumn.getId() + "-rsz");
				mHeaders[iHeadColIndex] = {
					domRefColumnTh: oElement,
					domRefColumnDivs: [],
					domRefColumnResizer: oColRsz,
					domRefColumnResizerPosition: undefined,
					rect: oRect,
					aHeaderData: aHeaderData
				};
			}
		});

		// Map target column header divs to corresponding source table header.
		var $cols = $colHeaderContainer.find(".sapUiTableCol");
		$cols.each(function(iIndex, oElement) {
			var iColIndex = parseInt(oElement.getAttribute("data-sap-ui-colindex"),10);
			var mHeader = mHeaders[iColIndex];
			mHeader.domRefColumnDivs.push(oElement);

			var iResizerPositionLeft = 0;

			if (mHeader) {
				if (!bRtl) {
					iResizerPositionLeft = mHeader.rect.right - oRectTable.left;
				} else {
					iResizerPositionLeft = mHeader.rect.left - oRectTable.left;
				}
			}

			if (!iResizerPositionLeft || iResizerPositionLeft <= 0 || iResizerPositionLeft >= iTableWidth) {
				iResizerPositionLeft = iLeftAway;
			}

			mHeader.domRefColumnResizerPosition = iResizerPositionLeft;
		});

		jQuery.each(mHeaders, function(iIndex, mHeader) {
			for (var i = 0; i < mHeader.domRefColumnDivs.length; i++) {
				// apply header widths
				var oHeaderData = mHeader.aHeaderData[0];
				if (mHeader.aHeaderData[i]) {
					oHeaderData = mHeader.aHeaderData[i];
				}
				mHeader.domRefColumnDivs[i].style.width =  oHeaderData.width + "px";
				mHeader.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan", oHeaderData.span);

				// position resizer
				if (mHeader.domRefColumnResizer) {
					mHeader.domRefColumnResizer.style.left = mHeader.domRefColumnResizerPosition + "px";
				}
			}
		});

		// Table Column Height Calculation

		// we change the height of the cols, col header and the row header to auto to
		// find out whether to use the height of a cell or the min height of the col header.
		var iHeaderRowCount = this._getHeaderRowCount();
		var bHasColHdrHeight = this.getColumnHeaderHeight() > 0;
		if (!bHasColHdrHeight && !bUpdateResizeHandlers) {
			var $jqo = $this.find(".sapUiTableColHdrCnt,.sapUiTableColRowHdr");

			// We do this without jQuery for improved performance in IE (3500ms)
			var iColsLength = $cols.length;
			for (var i = 0; i < iColsLength; i++) {
				$cols[i].style.height = 'auto';
			}
			$jqo.height("auto");


			// Total height of the table header
			var iHeight = Math.max($colHeaderContainer.height(), $jqo.height());

			// Height of one row within the header
			// avoid half pixels
			var iRegularHeight = Math.floor(iHeight / iHeaderRowCount);
			if (this._bjQueryLess18) {
				$cols.height(iRegularHeight);
				$jqo.height(iHeight);
			} else {
				$cols.outerHeight(iRegularHeight);
				$jqo.outerHeight(iHeight);
			}
		}
	};

	/**
	 * updates the column headers (width and position of the resize handles)
	 * @private
	 */
	Table.prototype._updateColumnHeader = function(bUpdateResizeHandlers) {
		if (this._sColHdrPosTimer) {
			jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
		}

		// instantly execute the synchronization or delay it
		if (this._bOnAfterRendering) {
			this._syncColumnHeaders.apply(this, arguments);
		} else {
			this._sColHdrPosTimer = jQuery.sap.delayedCall(150, this, this._syncColumnHeaders, arguments);
		}
	};

	/**
	 * disables text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._disableTextSelection = function (oElement) {
		// prevent text selection
		jQuery(oElement || document.body).
			attr("unselectable", "on").
			css({
				"-moz-user-select": "none",
				"-webkit-user-select": "none",
				"user-select": "none"
	        }).
			bind("selectstart", function(oEvent) {
				oEvent.preventDefault();
				return false;
			});
	};

	/**
	 * enables text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._enableTextSelection = function (oElement) {
		jQuery(oElement || document.body).
			attr("unselectable", "off").
			css({
				"-moz-user-select": "",
				"-webkit-user-select": "",
				"user-select": ""
	        }).
			unbind("selectstart");
	};

	/**
	 * clears the text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._clearTextSelection = function () {
		if (window.getSelection) {
		  if (window.getSelection().empty) {  // Chrome
		    window.getSelection().empty();
		  } else if (window.getSelection().removeAllRanges) {  // Firefox
		    window.getSelection().removeAllRanges();
		  }
		} else if (document.selection && document.selection.empty) {  // IE?
			try {
			    document.selection.empty();
			} catch (ex) {
			    // ignore error to as a workaround for bug in IE8
			}
		}
	};

	// =============================================================================
	// CONTROL EVENT HANDLING
	// =============================================================================

	/**
	 * will be called by the vertical scrollbar. updates the visualized data by
	 * applying the first visible (scrollpos) row from the vertical scrollbar
	 * @private
	 */
	Table.prototype.onvscroll = function(oEvent) {
		// do not scroll in action mode!
		this._leaveActionMode();
		// set the first visible row
		this.setFirstVisibleRow(this._getScrollTop(), true);
	};

	/**
	 * sync the column header and content
	 * @private
	 */
	Table.prototype._syncHeaderAndContent = function() {
		if (!this._bSyncScrollLeft) {
			this._bSyncScrollLeft = true;
			// synchronize the scroll areas
			var $this = this.$();
			var iScrollLeft = this._oHSb.getNativeScrollPosition();
			$this.find(".sapUiTableCtrlScr").scrollLeft(iScrollLeft);
			if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
				var oScrollDomRef = $this.find(".sapUiTableColHdrScr").get(0);
				iScrollLeft = oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - this._oHSb.getScrollPosition();
			}
			$this.find(".sapUiTableColHdrScr").scrollLeft(iScrollLeft);
			this._bSyncScrollLeft = false;
		}

	};

	/**
	 * will be called when the horizontal scrollbar is used. since the table does
	 * not render/update the data of all columns (only the visible ones) in case
	 * of scrolling horizontally we need to update the content of the columns which
	 * became visible.
	 * @private
	 */
	Table.prototype.onhscroll = function(oEvent) {

		if (!this._bOnAfterRendering) {

			// sync the column header and the content area
			this._syncHeaderAndContent();

			// update the column headers (resize handles)
			this._updateColumnHeader(true);

			// update the bindings
			if (this.getBinding("rows")) {
				this.updateRows();
			}

		}

	};

	/**
	 * when navigating within the column header we need to synchronize the content
	 * area with the position (scrollLeft) of the column header.
	 * @private
	 */
	Table.prototype._oncolscroll = function(oEvent) {
		if (!this._bSyncScrollLeft) {
			var $cnt = this.$().find(".sapUiTableColHdrScr");
			if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
				var oScrollDomRef = this.$().find(".sapUiTableColHdrScr").get(0);
				this._oHSb.setScrollPosition(oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - $cnt.scrollLeft());
			} else {
				this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
			}
		}
	};

	/**
	 * when navigating within the content area we need to synchronize the column
	 * header with the position (scrollLeft) of the content area.
	 * @private
	 */
	Table.prototype._oncntscroll = function(oEvent) {
		if (!this._bSyncScrollLeft) {
			var $cnt = this.$().find(".sapUiTableCtrlScr");
			this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
		}
	};


	/**
	 * listens to the mousedown events for starting column drag & drop. therefore
	 * we wait 200ms to make sure it is no click on the column to open the menu.
	 * @private
	 */
	Table.prototype.onmousedown = function(oEvent) {
		// only move on left click!
		var bLeftButton = oEvent.button === 0;
		var bIsTouchMode = this._isTouchMode(oEvent);

		if (bLeftButton) {
			var $target = jQuery(oEvent.target);

			var $splitter = this.$("sb");
			if (oEvent.target == $splitter[0]) {

				// Fix for IE text selection while dragging
				jQuery(document.body).bind("selectstart", jQuery.proxy(this._splitterSelectStart, this));

				var offset = $splitter.offset();
				var height = $splitter.height();
				var width = $splitter.width();

				jQuery(document.body).append(
						"<div id=\"" + this.getId() + "-ghost\" class=\"sapUiHSBGhost\" style =\" height:" + height + "px; width:"
						+ width + "px; left:" + offset.left + "px; top:" + offset.top + "px\" ></div>");

				// append overlay over splitter to enable correct functionality of moving the splitter
				$splitter.append(
						"<div id=\"" + this.getId() + "-overlay\" style =\"left: 0px;" +
								" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");

				var $Document = jQuery(document);
				if (bIsTouchMode) {
					$Document.bind("touchend", jQuery.proxy(this._onGhostMouseRelease, this));
					$Document.bind("touchmove", jQuery.proxy(this._onGhostMouseMove, this));
				} else {
					$Document.bind("mouseup", jQuery.proxy(this._onGhostMouseRelease, this));
					$Document.bind("mousemove", jQuery.proxy(this._onGhostMouseMove, this));
				}

				this._disableTextSelection();

				return;
			}

			var $col = $target.closest(".sapUiTableCol");
			if ($col.length === 1) {

				this._bShowMenu = true;
				this._sDelayedMenuTimer = jQuery.sap.delayedCall(200, this, function() {
					this._bShowMenu = false;
				});

				var bIsColumnMenuTarget = this._isTouchMode(oEvent) && ($target.hasClass("sapUiTableColDropDown") || $target.hasClass("sapUiTableColResizer"));
				if (this.getEnableColumnReordering() && !bIsColumnMenuTarget) {
					var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
					if (iIndex > this._iLastFixedColIndex) {
						var oColumn = this.getColumns()[iIndex];

						this._sDelayedActionTimer = jQuery.sap.delayedCall(200, this, function() {
							this._onColumnMoveStart(oColumn, bIsTouchMode);
						});
					}
				}
			}

			// in case of FireFox and CTRL+CLICK it selects the target TD
			//   => prevent the default behavior only in this case (to still allow text selection)
			var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);
			if (!!sap.ui.Device.browser.firefox && bCtrl) {
				oEvent.preventDefault();
			}
		}

	};

	/**
	 * controls the action mode when clicking into the table control
	 * @private
	 */
	Table.prototype.onmouseup = function(oEvent) {
		// clean up the timer
		jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);

		if (oEvent.isMarked()) {
			// the event was already handled by some other handler, do nothing.
			return;
		}

		if (this.$().find(".sapUiTableCtrl td :focus").length > 0) {
			// when clicking into a focusable control we enter the action mode!
			this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));
		} else {
			// when clicking anywhere else in the table we leave the action mode!
			this._leaveActionMode(oEvent);
		}
	};

	/**
	 * handles the selection when clicking on the table
	 * @private
	 */
	Table.prototype.onclick = function(oEvent) {
		// clean up the timer
		jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);

		if (oEvent.isMarked()) {
			// the event was already handled by some other handler, do nothing.
			return;
		}

		// forward the event
		if (!this._findAndfireCellEvent(this.fireCellClick, oEvent)) {
			this._onSelect(oEvent);
		} else {
			oEvent.preventDefault();
		}
	};

	/**
	 * handles the cell contextmenu eventing of the table, open the menus for cell, group header and column header
	 * @private
	 */
	Table.prototype.oncontextmenu = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		var $Header = $Target.closest('.sapUiTableCol');
		if ($Header.length > 0) {
			var oColumn = sap.ui.getCore().byId($Header.attr("data-sap-ui-colid"));
			if (oColumn) {
				oColumn._openMenu($Header[0], false);
			}
			oEvent.preventDefault();
		} else {
			if (this._findAndfireCellEvent(this.fireCellContextmenu, oEvent, this._oncellcontextmenu)) {
				oEvent.preventDefault();
			}
		}
	};

	/**
	 * handles the default cell contextmenu
	 * @private
	 */
	Table.prototype._oncellcontextmenu = function(mParams) {
		if (this.getEnableCellFilter()) {
			// create the contextmenu instance the first time it is needed
			if (!this._oContextMenu) {
				jQuery.sap.require("sap.ui.unified.Menu");
				jQuery.sap.require("sap.ui.unified.MenuItem");

				this._oContextMenu = new sap.ui.unified.Menu(this.getId() + "-contextmenu");
				this.addDependent(this._oContextMenu);
			}

			// does the column support filtering?
			var oColumn = sap.ui.getCore().byId(mParams.columnId);
			var sProperty = oColumn.getFilterProperty();
			// currently only filter is possible by default cell context menu, if filtering is not allowed by
			// menu, don't open the context menu at all.
			if (oColumn && oColumn.isFilterableByMenu() && mParams.rowBindingContext) {
				// destroy all items of the menu and recreate
				this._oContextMenu.destroyItems();
				this._oContextMenu.addItem(new sap.ui.unified.MenuItem({
					text: this._oResBundle.getText("TBL_FILTER"),
					select: [function() {
						var oContext = this.getContextByIndex(mParams.rowIndex);
						var sValue = oContext.getProperty(sProperty);
						if (this.getEnableCustomFilter()) {
							// only fire custom filter event
							this.fireCustomFilter({
								column: oColumn,
								value: sValue
							});
						} else {
							this.filter(oColumn, sValue);
						}

					}, this]
				}));

				// open the popup below the cell
				var eDock = sap.ui.core.Popup.Dock;
				this._oContextMenu.open(false, mParams.cellDomRef, eDock.BeginTop, eDock.BeginBottom, mParams.cellDomRef, "none none");
				return true;
			}
		}
	};

	/**
	 * helper method to bind different functions to a click if both a single and a double click can occur on an element
	 * @experimental Experimental
	 * @function
	 * @private
	 */
	Table.prototype._bindSimulatedDoubleclick = function(element, fnClick, fnDoubleclick){
		var eventBound = "click";
		var that = this;
		if (!!sap.ui.Device.support.touch){
			//event needs to be touchend due to timing issues on the ipad
			eventBound = "touchend";
		}
		jQuery(element).on(eventBound, function(oEvent){
			oEvent.preventDefault();
			oEvent.stopPropagation();
			that._clicksRegistered = that._clicksRegistered + 1;
			if (that._clicksRegistered < 2){
				that._singleClickTimer = jQuery.sap.delayedCall(that._doubleclickDelay, that, function(){
					that._clicksRegistered = 0;
					if (fnClick){
						fnClick.call(that, oEvent);
					}
				}, [oEvent]);
			} else {
				jQuery.sap.clearDelayedCall(that._singleClickTimer);
				that._clicksRegistered = 0;
				fnDoubleclick.call(that, oEvent);
			}
		});
	};

	/**
	 * finds the cell on which the click or contextmenu event is executed and
	 * notifies the listener which control has been clicked or the contextmenu
	 * should be openend.
	 * @param {function} fnFire function to fire the event
	 * @param {DOMEvent} oEvent event object
	 * @return {boolean} cancelled or not
	 * @private
	 */
	Table.prototype._findAndfireCellEvent = function(fnFire, oEvent, fnContextMenu) {
		var $target = jQuery(oEvent.target);
		// find out which cell has been clicked
		var $cell = $target.closest("td[role='gridcell']");
		var sId = $cell.attr("id");
		var aMatches = /.*-row(\d*)-col(\d*)/i.exec(sId);
		var bCancel = false;
		if (aMatches) {
			var iRow = aMatches[1];
			var iCol = aMatches[2];
			var oRow = this.getRows()[iRow];
			var oCell = oRow && oRow.getCells()[iCol];
			var iRealRowIndex = oRow && oRow.getIndex();
			var sColId = oCell.data("sap-ui-colid");

			var oRowBindingContext;
			if (this.getBindingInfo("rows")) {
				oRowBindingContext = oRow.getBindingContext(this.getBindingInfo("rows").model);
			}

			var mParams = {
				rowIndex: iRealRowIndex,
				columnIndex: iCol,
				columnId: sColId,
				cellControl: oCell,
				rowBindingContext: oRowBindingContext,
				cellDomRef: $cell.get(0)
			};
			bCancel = !fnFire.call(this, mParams);
			if (!bCancel && typeof fnContextMenu === "function") {
				mParams.cellDomRef = $cell[0];
				bCancel = fnContextMenu.call(this, mParams);
			}
		}
		return bCancel;
	};

	/**
	 * handles the focus in to reposition the focus or prevent default handling for
	 * column resizing
	 * @private
	 */
	Table.prototype.onfocusin = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var bNoData = this.$().hasClass("sapUiTableEmpty");
		var bControlBefore = $target.hasClass("sapUiTableCtrlBefore");
		this._updateAriaRowOfRowsText();
		// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
		if (!this._bIgnoreFocusIn && (bControlBefore || $target.hasClass("sapUiTableCtrlAfter"))) {
			// set the focus on the last focused dom ref of the item navigation or
			// in case if not set yet (tab previous into item nav) then we set the
			// focus to the root domref
			// reset the aria description of the table that the table is announced the
			// first time the table grabs the focus
			this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));
			// when entering the before or after helper DOM elements we put the
			// focus on the current focus element of the item navigation and we
			// leave the action mode!
			this._leaveActionMode();
			if (jQuery.contains(this.$().find('.sapUiTableColHdrCnt')[0], oEvent.target)) {
				jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
			} else {
				if (bControlBefore) {
					if (bNoData) {
						this._bIgnoreFocusIn = true;
						this.$().find(".sapUiTableCtrlEmpty").focus();
						this._bIgnoreFocusIn = false;
					} else {
						this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns, oEvent);
					}
				} else {
					this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns) + (this._oItemNavigation.iColumns * this._iLastSelectedDataRow), oEvent);
				}
			}

			if (!bNoData) {
				oEvent.preventDefault();
			}
		} else if (jQuery.sap.endsWith(oEvent.target.id, "-rsz")) {
			// prevent that the ItemNavigation grabs the focus!
			// only for the column resizing
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};

	/**
	 * The row index only considers the position of the row in the aggregation. It must be adapted
	 * to consider the firstVisibleRow offset or if a fixed bottom row was pressed
	 * @param {int} iRow row index of the control in the rows aggregation
	 * @returns {int} the adapted (absolute) row index
	 * @private
	 */
	Table.prototype._getAbsoluteRowIndex = function(iRow) {
		var iIndex = 0;
		var iFirstVisibleRow = this.getFirstVisibleRow();
		var iFixedBottomRowCount = this.getFixedBottomRowCount();
		var iVisibleRowCount = this.getVisibleRowCount();
		var iFirstFixedBottomRowIndex = iVisibleRowCount - iFixedBottomRowCount;

		if (iFixedBottomRowCount > 0 && iRow >= iFirstFixedBottomRowIndex) {
			iIndex = this.getBinding().getLength() - iVisibleRowCount + iRow;
		} else {
			iIndex = iFirstVisibleRow + iRow;
		}

		return iIndex;
	};

	// =============================================================================
	// SELECTION HANDLING
	// =============================================================================

		/**
	 * handles the row selection and the column header menu
	 * @private
	 */
	Table.prototype._onSelect = function(oEvent) {

		// trigger column menu
		var $target = jQuery(oEvent.target);

		// determine modifier keys
		var bShift = oEvent.shiftKey;
		var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);

		// column header?
		var $col = $target.closest(".sapUiTableCol");
		if (this._bShowMenu && $col.length === 1) {
			var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
			var oColumn = this.getColumns()[iIndex];

			if ($target.hasClass("sapUiTableColDropDown")) {
				var bExecuteDefault = this.fireColumnSelect({
					column: oColumn
				});

				if (bExecuteDefault) {
					oColumn._openMenu($col[0], oEvent.type == "keyup");
				}
			} else {
				this._onColumnSelect(oColumn, $col[0], this._isTouchMode(oEvent), oEvent.type == "keyup");
			}

			return;
		}

		// row header?
		var $row = $target.closest(".sapUiTableRowHdr");
		if ($row.length === 1) {
			var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
			this._onRowSelect(this._getAbsoluteRowIndex(iIndex), bShift, bCtrl);
			return;
		}

		// table control? (only if the selection behavior is set to row)
		var oClosestTd;
		if (oEvent.target) {
			var $ClosestTd = jQuery(oEvent.target).closest("td");
			if ($ClosestTd.length > 0) {
				oClosestTd = $ClosestTd[0];
			}
		}

		if (oClosestTd && oClosestTd.getAttribute("role") == "gridcell" && (
		    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.Row ||
		    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
			var $row = $target.closest(".sapUiTableCtrl > tbody > tr");
			if ($row.length === 1) {
				var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
				this._onRowSelect(this._getAbsoluteRowIndex(iIndex), bShift, bCtrl);
				return;
			}
		}

		// select all?
		if (jQuery.sap.containsOrEquals(this.getDomRef("selall"), oEvent.target)) {
			this._toggleSelectAll();
			return;
		}

	};


	// =============================================================================
	// ROW EVENT HANDLING
	// =============================================================================

	/**
	 *
	 * @param iRowIndex
	 * @returns {boolean}
	 * @private
	 */
	Table.prototype._isRowSelectable = function(iRowIndex) {
		return true;
	};

	/**
	 * handles the row selection (depending on the mode)
	 * @private
	 */
	Table.prototype._onRowSelect = function(iRowIndex, bShift, bCtrl) {

		// in case of IE and SHIFT we clear the text selection
		if (!!sap.ui.Device.browser.internet_explorer && bShift) {
			this._clearTextSelection();
		}

		// is the table bound?
		var oBinding = this.getBinding("rows");
		if (!oBinding) {
			return;
		}

		//var iRowIndex = Math.min(Math.max(0, iRowIndex), this.getBinding("rows").getLength() - 1);
		if (iRowIndex < 0 || iRowIndex >= (oBinding.getLength() || 0)) {
			return;
		}

		// Make sure that group headers, which represents a tree node in AnalyticalTable, are not selectable.
		if (!this._isRowSelectable(iRowIndex)) {
			return;
		}

		this._iSourceRowIndex = iRowIndex;

		var oSelMode = this.getSelectionMode();
		if (oSelMode !== sap.ui.table.SelectionMode.None) {
			if (oSelMode === sap.ui.table.SelectionMode.Single) {
				if (!this.isIndexSelected(iRowIndex)) {
					this.setSelectedIndex(iRowIndex);
				} else {
					this.clearSelection();
				}
			} else {
				// in case of multi toggle behavior a click on the row selection
				// header adds or removes the selected row and the previous seleciton
				// will not be removed
				if (oSelMode === sap.ui.table.SelectionMode.MultiToggle) {
					bCtrl = true;
				}
				if (bShift) {
					// If no row is selected getSelectedIndex returns -1 - then we simply
					// select the clicked row:
					var iSelectedIndex = this.getSelectedIndex();
					if (iSelectedIndex >= 0) {
						this.addSelectionInterval(iSelectedIndex, iRowIndex);
					} else {
						this.setSelectedIndex(iRowIndex);
					}
				} else {
					if (!this.isIndexSelected(iRowIndex)) {
						if (bCtrl) {
							this.addSelectionInterval(iRowIndex, iRowIndex);
						} else {
							this.setSelectedIndex(iRowIndex);
						}
					} else {
						if (bCtrl) {
							this.removeSelectionInterval(iRowIndex, iRowIndex);
						} else {
							if (this.getSelectedIndices().length === 1) {
								this.clearSelection();
							} else {
								this.setSelectedIndex(iRowIndex);
							}
						}
					}
				}
			}
		}

		this._iSourceRowIndex = undefined;

	};


	// =============================================================================
	// COLUMN EVENT HANDLING
	// =============================================================================

	/**
	 * column select event => opens the column menu
	 * @private
	 */
	Table.prototype._onColumnSelect = function(oColumn, oDomRef, bIsTouchMode, bWithKeyboard) {
		// On tablet open special column header menu
		if (bIsTouchMode) {
			var $ColumnHeader = jQuery(oDomRef);
			var $ColumnCell = $ColumnHeader.find(".sapUiTableColCell");

			if ($ColumnHeader.find(".sapUiTableColCellMenu").length < 1) {
				$ColumnCell.hide();

				var sColumnDropDownButton = "";
				if (oColumn._menuHasItems()) {
					sColumnDropDownButton = "<div class='sapUiTableColDropDown'></div>";
				}

				var sColumnResizerButton = "";
				if (oColumn.getResizable()) {
					sColumnResizerButton = "<div class='sapUiTableColResizer''></div>";
				}

				var $ColumnHeaderMenu = jQuery("<div class='sapUiTableColCellMenu'>" + sColumnDropDownButton + sColumnResizerButton + "</div>");
				$ColumnHeader.append($ColumnHeaderMenu);
				$ColumnHeader.bind("focusout", function() {
					this.cell.show();
					this.menu.remove();
					this.self.unbind("focusout");
				}.bind({
					cell: $ColumnCell,
					menu: $ColumnHeaderMenu,
					self: $ColumnHeader
				}));

				// listen to the resize handlers
				if (oColumn.getResizable()) {
					$ColumnHeader.find(".sapUiTableColResizer").bind("touchstart", jQuery.proxy(this._onColumnResizeStart, this));
				}
			}

			return;
		}

		// forward the event
		var bExecuteDefault = this.fireColumnSelect({
			column: oColumn
		});

		// if the default behavior should be prevented we suppress to open
		// the column menu!
		if (bExecuteDefault) {
			oColumn._openMenu(oDomRef, bWithKeyboard);
		}

	};

	/**
	 * start column moveing
	 * @private
	 */
	Table.prototype._onColumnMoveStart = function(oColumn, bIsTouchMode) {
		this._disableTextSelection();

		var $col = oColumn.$();
		var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);

		if (iColIndex < this.getFixedColumnCount()) {
			return;
		}

		this.$().addClass("sapUiTableDragDrop");
		this._$colGhost = $col.clone().removeAttr("id");

		$col.css({
			"opacity": ".25"
		});

		this._$colGhost.addClass("sapUiTableColGhost").css({
			"left": -10000,
			"top": -10000,
			//Position is set to relative for columns later, if the moving is started a second time the position: relative overwrites
			//the absolut position set by the sapUiTableColGhost class, so we overrite the style attribute for position here to make
			//sure that the position is absolute
			"position": "absolute",
			"z-index": this.$().zIndex() + 10
		});

		// TODO: only for the visible columns!?
		this.$().find(".sapUiTableCol").each(function(iIndex, oElement) {

			var $col = jQuery(this);
			$col.css({position: "relative"});

			$col.data("pos", {
				left: $col.position().left,
				center: $col.position().left + $col.outerWidth() / 2,
				right:  $col.position().left + $col.outerWidth()
			});

		});

		this._$colGhost.appendTo(document.body);

		var $body = jQuery(document.body);
		if (bIsTouchMode) {
			$body.bind("touchmove", jQuery.proxy(this._onColumnMove, this));
			$body.bind("touchend", jQuery.proxy(this._onColumnMoved, this));
		} else {
			$body.mousemove(jQuery.proxy(this._onColumnMove, this));
			$body.mouseup(jQuery.proxy(this._onColumnMoved, this));
		}
	};

	/**
	 * move the column position the ghost
	 * @private
	 */
	Table.prototype._onColumnMove = function(oEvent) {
		var $this = this.$();
		var iLocationX = oEvent.pageX;
		var iLocationY = oEvent.pageY;
		if (oEvent && this._isTouchMode(oEvent)) {
			iLocationX = oEvent.targetTouches[0].pageX;
			iLocationY = oEvent.targetTouches[0].pageY;
			oEvent.stopPropagation();
			oEvent.preventDefault();
		}

		var bRtl = this._bRtlMode;
		var iRelX = iLocationX - $this.offset().left;
		var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
		var $DnDCol = this.getColumns()[iDnDColIndex].$();

		// find out the new col position
		var iOldColPos = this._iNewColPos;
		this._iNewColPos = iDnDColIndex;
		var that = this;
		$this.find(".sapUiTableCol").each(function(iIndex, oCol) {
			var $col = jQuery(oCol);
			var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
			var vHeaderSpans = sap.ui.getCore().byId($col.attr("data-sap-ui-colid")).getHeaderSpan();
			var iSpan;

			if (vHeaderSpans) {
				if (jQuery.isArray(vHeaderSpans)) {
					iSpan = vHeaderSpans[0];
				} else {
					iSpan = vHeaderSpans;
				}
			} else {
				iSpan = 1;
			}

			if ($col.get(0) !== $DnDCol.get(0)) {

				var oPos = $col.data("pos");

				var bBefore = iRelX >= oPos.left && iRelX <= oPos.center;
				var bAfter = iRelX >= oPos.center && iRelX <= oPos.right;

				if (!bRtl) {
					if (bBefore) {
						that._iNewColPos = iColIndex;
					} else if (bAfter) {
						that._iNewColPos = iColIndex + iSpan;
					} else {
						that._iNewColPos = that._iNewColPos;
					}
				} else {
					if (bAfter) {
						that._iNewColPos = iColIndex;
					} else if (bBefore) {
						that._iNewColPos = iColIndex + iSpan;
					} else {
						that._iNewColPos = that._iNewColPos;
					}
				}

				if ((bBefore || bAfter) && iColIndex > iDnDColIndex) {
					that._iNewColPos--;
				}

			}

		});

		// prevent the reordering of the fixed columns
		if (this._iNewColPos <= this._iLastFixedColIndex) {
			this._iNewColPos = iOldColPos;
		}
		if (this._iNewColPos < this.getFixedColumnCount()) {
			this._iNewColPos = iOldColPos;
		}

		// animate the column move
		this._animateColumnMove(iDnDColIndex, iOldColPos, this._iNewColPos);

		// update the ghost position
		this._$colGhost.css({
			"left": iLocationX + 5,
			"top": iLocationY + 5
		});
	};

	/**
	 * animates the column movement
	 */
	Table.prototype._animateColumnMove = function(iColIndex, iOldPos, iNewPos) {

		var bRtl = this._bRtlMode;
		var $DnDCol = this.getColumns()[iColIndex].$();

		// position has been changed => reorder
		if (iOldPos !== iNewPos) {

			for (var i = Math.min(iOldPos, iNewPos), l = Math.max(iOldPos, iNewPos); i <= l; i++) {
				var oCol = this.getColumns()[i];
				if (i !== iColIndex && oCol.getVisible()) {
					oCol.$().stop(true, true).animate({left: "0px"});
				}
			}

			var iOffsetLeft = 0;
			if (iNewPos < iColIndex) {
				for (var i = iNewPos; i < iColIndex; i++) {
					var oCol = this.getColumns()[i];
					if (oCol.getVisible()) {
						var $col = oCol.$();
						iOffsetLeft -= $col.outerWidth();
						$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? -1 : 1) + "px"});
					}
				}
			} else {
				for (var i = iColIndex + 1, l = iNewPos + 1; i < l; i++) {
					var oCol = this.getColumns()[i];
					if (oCol.getVisible()) {
						var $col = oCol.$();
						iOffsetLeft += $col.outerWidth();
						$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? 1 : -1) + "px"});
					}
				}
			}
			$DnDCol.stop(true, true).animate({left: iOffsetLeft * (bRtl ? -1 : 1) + "px"});
		}

	};

	/**
	 * columns is moved => update!
	 * @private
	 */
	Table.prototype._onColumnMoved = function(oEvent) {
		this.$().removeClass("sapUiTableDragDrop");

		var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
		var oDnDCol = this.getColumns()[iDnDColIndex];

		var $Body = jQuery(document.body);
		$Body.unbind("touchmove", this._onColumnMove);
		$Body.unbind("touchend", this._onColumnMoved);
		$Body.unbind("mousemove", this._onColumnMove);
		$Body.unbind("mouseup", this._onColumnMoved);

		this._$colGhost.remove();
		this._$colGhost = undefined;

		this._enableTextSelection();

		// forward the event
		var bExecuteDefault = this.fireColumnMove({
			column: oDnDCol,
			newPos: this._iNewColPos
		});

		var bMoveRight = iDnDColIndex < this._iNewColPos;

		if (bExecuteDefault && this._iNewColPos !== undefined && this._iNewColPos !== iDnDColIndex) {
			this.removeColumn(oDnDCol);
			this.insertColumn(oDnDCol, this._iNewColPos);
			var vHeaderSpan = oDnDCol.getHeaderSpan(),
				iSpan;

			if (vHeaderSpan) {
				if (jQuery.isArray(vHeaderSpan)) {
					iSpan = vHeaderSpan[0];
				} else {
					iSpan = vHeaderSpan;
				}
			} else {
				iSpan = 1;
			}

			if (iSpan > 1) {
				if (!bMoveRight) {
					this._iNewColPos++;
				}
				for (var i = 1; i < iSpan; i++) {
					var oDependentCol = this.getColumns()[bMoveRight ? iDnDColIndex : iDnDColIndex + i];
					this.removeColumn(oDependentCol);
					this.insertColumn(oDependentCol, this._iNewColPos);
					this.fireColumnMove({
						column: oDependentCol,
						newPos: this._iNewColPos
					});
					if (!bMoveRight) {
						this._iNewColPos++;
					}
				}
			}
			this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);
		} else {
			this._animateColumnMove(iDnDColIndex, this._iNewColPos, iDnDColIndex);
			oDnDCol.$().css({
				"backgroundColor": "",
				"backgroundImage": "",
				"opacity": ""
			});
		}

		// Re-apply focus
		setTimeout(function() {
			var iOldFocusedIndex = this._oItemNavigation.getFocusedIndex();
			this._oItemNavigation.focusItem(0, oEvent);
			this._oItemNavigation.focusItem(iOldFocusedIndex, oEvent);
		}.bind(this), 0);

		delete this._iNewColPos;
	};

	/**
	 * starts the automatic column resize after doubleclick
	 * @experimental Experimental, only works with a limited control set
	 * @private
	 */
	Table.prototype._onAutomaticColumnResize = function(oEvent) {
		var iColIndex, oCol, headerSpan, maxHeaderSpan, iColsToResize = 1, bResizeMultiple = false;
		jQuery.sap.log.debug("doubleclick fired");
		this._disableTextSelection();
		this._$colResize = jQuery(oEvent.target);
		this._$colResize.addClass("sapUiTableColRszActive");
		//get the id of the column which needs to be resized. it might be different from the resizers column id if a headerspan is used.
		var iParentColIndex = parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"), 10);
		iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		if (iParentColIndex != iColIndex) {
			bResizeMultiple = true;
		}
		//try to find out if we are only resizing one column or all columns under a header span
		if (bResizeMultiple) {
			oCol = this.getColumns()[iParentColIndex];
			headerSpan = oCol.getHeaderSpan();
			if (headerSpan instanceof Array){
				maxHeaderSpan = Math.max.apply(Math, headerSpan);
			} else if (!!headerSpan) {
				maxHeaderSpan = headerSpan;
			}
			if (iColIndex + headerSpan - 1 != iParentColIndex){
				iColsToResize = maxHeaderSpan;
				iColIndex = iParentColIndex + maxHeaderSpan;
			}
		}
		if (iColsToResize > 1){
		//	for(var i = 0; i < iColsToResize; i--{
			while (iColIndex > iParentColIndex) {
				iColIndex--;
				this.autoResizeColumn(iColIndex);
			}
		} else {
			this.autoResizeColumn(iColIndex);
		}
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * Determines the associated resizer id for a column.
	 * @param {int} the column index of the target column
	 * @param {int} the column span of the target column
	 * @return {String} the associated resizer id
	 */
	Table.prototype._getResizerIdForColumn = function(iColIndex, iColSpan) {
		if (iColSpan > 0) {
			iColSpan--;
		}

		var oColumn = this.getColumns()[this._aIdxCols2Cells[iColIndex + iColSpan]];
		return oColumn.getId() + "-rsz";
	};

	/**
	 * start the column resize
	 * @private
	 */
	Table.prototype._onColumnResizeStart = function(oEvent) {
		if (this._isTouchMode(oEvent)) {
			this._iColumnResizeStart = oEvent.targetTouches[0].pageX;
			this._disableTextSelection();

			var $Column = jQuery(oEvent.target).closest(".sapUiTableCol");
			var iColIndex = parseInt($Column.attr("data-sap-ui-colindex"), 10);
			var iColSpan = $Column.attr("data-sap-ui-colspan");

			var sResizerId = this._getResizerIdForColumn(iColIndex, iColSpan);
			this._$colResize = jQuery.sap.byId(sResizerId);

			jQuery(document.body).bind("touchmove", jQuery.proxy(this._onColumnResize, this));
			jQuery(document.body).bind("touchend", jQuery.proxy(this._onColumnResized, this));

			return;
		}

		// only resize on left click!
		var bLeftButton = oEvent.button === 0;
		if (bLeftButton) {
			this._iColumnResizeStart = oEvent.pageX;

			this._disableTextSelection();
			this._$colResize = jQuery(oEvent.target);

			jQuery(document.body).
				mousemove(jQuery.proxy(this._onColumnResize, this)).
				mouseup(jQuery.proxy(this._onColumnResized, this));
		}
	};

	/**
	 * resize the column
	 * @private
	 */
	Table.prototype._onColumnResize = function(oEvent) {
		var iLocationX;
		if (this._isTouchMode(oEvent)) {
			iLocationX = oEvent.targetTouches[0].pageX;
			oEvent.stopPropagation();
			oEvent.preventDefault();
		} else {
			iLocationX = oEvent.pageX;
		}

		if (this._iColumnResizeStart && iLocationX < this._iColumnResizeStart + 3 && iLocationX > this._iColumnResizeStart - 3) {
			return;
		}

		if (this._isTouchMode(oEvent)) {
			this._$colResize.addClass("sapUiTableColTouchRszActive");
		} else {
			this._$colResize.addClass("sapUiTableColRszActive");
		}

		var $this = this.$();

		var bRtl = this._bRtlMode;
		var iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		var oColumn = this.getColumns()[iColIndex];
		var $col = $this.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='" + iColIndex + "']");

		// get the left position of the column to calculate the new width
		// relative to the parent container (sapUiTableCnt)!
		var iColLeft = $col.position().left;

		var iWidth;
		if (!bRtl) {
			// refine width calculation in case of fixed columns
			if (this.getFixedColumnCount() > 0 && iColIndex >= this.getFixedColumnCount()) {
				var iFixedColumnsWidth = $this.find(".sapUiTableColHdrFixed").width();
				iColLeft = iColLeft + iFixedColumnsWidth;

				// Consider scroll offset of non fixed area.
				iColLeft = iColLeft - $this.find(".sapUiTableCtrlScr").scrollLeft();
			}

			// find the total left offset from the document (required for pageX info)
			var iOffsetLeft = $this.find(".sapUiTableCtrlFirstCol > th:first").offset().left;

			// relative left position within the table scroll container
			var iRelLeft = iLocationX - iOffsetLeft;

			// calculate the new width
			iWidth = iRelLeft - iColLeft;
		} else {
			var $ScrollArea;
			if (this.getFixedColumnCount() > 0 && iColIndex < this.getFixedColumnCount()) {
				$ScrollArea = $this.find('.sapUiTableCtrlScrFixed');
			} else {
				$ScrollArea = $this.find('.sapUiTableCtrlScr');
			}
			var iScrollAreaScrollLeft = $ScrollArea.scrollLeft();

			if (sap.ui.Device.browser.internet_explorer) {
				// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
				// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
				iScrollAreaScrollLeft = $ScrollArea[0].scrollWidth - iScrollAreaScrollLeft - $ScrollArea[0].clientWidth;
			} else if (sap.ui.Device.browser.firefox) {
				// FF has negative reverse scroll position (Chrome = 0, IE = 100, FF = -100)
				iScrollAreaScrollLeft = iScrollAreaScrollLeft + $ScrollArea[0].scrollWidth - $ScrollArea[0].clientWidth;
			}

			//get the difference between where mouse was released and left side of the table
			var iDiff = iColLeft - iScrollAreaScrollLeft - iLocationX + $ScrollArea.offset().left;
			iWidth = $col.outerWidth() + iDiff;
		}

		iWidth = Math.max(iWidth, this._iColMinWidth);

		// calculate and set the position of the resize handle
		var iRszOffsetLeft = $this.find(".sapUiTableCnt").offset().left;

		var iRszLeft = iLocationX - iRszOffsetLeft;
		iRszLeft -= this._$colResize.width() / 2;
		this._$colResize.css("left", iRszLeft);

		// store the width of the column to apply later
		oColumn._iNewWidth = iWidth;
	};

	/**
	 * column is resized => update!
	 * @private
	 */
	Table.prototype._onColumnResized = function(oEvent, iIndex) {
		var iColIndex;
		// ignore when no resize column is set
		if (!this._$colResize && (iIndex === null || iIndex === undefined)) {
			return;
		}
		// get the new width of the column
		if (iIndex === null || iIndex === undefined) {
			iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		} else {
			iColIndex = iIndex;
		}
		var oColumn = this.getColumns()[iColIndex];
		// if the resize has started and we have a new width for the column
		// we apply it to the column object
		var bResized = false;
		if (oColumn._iNewWidth) {
			var sWidth;
			var iAvailableSpace = this.$().find(".sapUiTableCtrl").width();
			if (!this._checkPercentageColumnWidth()) {
				sWidth = oColumn._iNewWidth + "px";
			} else {
				var iColumnWidth = Math.round(100 / iAvailableSpace * oColumn._iNewWidth);
				sWidth = iColumnWidth + "%";
			}

			if (this._updateColumnWidth(oColumn, sWidth, true)) {
				this._resizeDependentColumns(oColumn, sWidth);
			}

			delete oColumn._iNewWidth;

			bResized = true;
		}

		// unbind the event handlers
		var $Body = jQuery(document.body);
		$Body.unbind("touchmove", this._onColumnResize);
		$Body.unbind("touchend", this._onColumnResized);
		$Body.unbind("mousemove", this._onColumnResize);
		$Body.unbind("mouseup", this._onColumnResized);

		// focus the column
		oColumn.focus();

		// hide the text selection
		if (this._$colResize) {
			this._$colResize.removeClass("sapUiTableColTouchRszActive sapUiTableColRszActive");
			this._$colResize = undefined;
		}
		this._enableTextSelection();

		// rerender / ignore if nothing changed!
		if (bResized) {
			this.invalidate();
		}

	};

	/**
	 *
	 * @param oColumn
	 * @param sWidth
	 * @private
	 */
	Table.prototype._resizeDependentColumns = function(oColumn, sWidth) {

		//Adjust columns only if the columns have percentage values
		if (this._checkPercentageColumnWidth()) {
			var aVisibleColumns = this._getVisibleColumns();
			//var oLastVisibleColumn = aVisibleColumns[aVisibleColumns.length - 1]; // NOT USED!
			//var bAllFollowingColumnsFlexible = true; // NOT USED!

			var iColumnIndex;
			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				if (oColumn === oCurrentColumn) {
					iColumnIndex = iIndex;
				//} else if (iColumnIndex !== undefined && !oCurrentColumn.getFlexible()) { // NOT REQUIRED?
					//bAllFollowingColumnsFlexible = false;
				}
			});

			var iOthersWidth = 0;
			var iLastIndex = aVisibleColumns.length - 1;
			var iTotalPercentage;
			if (iColumnIndex === undefined) {
				iTotalPercentage = 0;
			} else {
				iTotalPercentage = parseInt(sWidth,10);
			}
			var iPercentages = 0;
			var aOtherColumns = [];
			var that = this;

			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
				if ((((iColumnIndex === iLastIndex && iIndex < iColumnIndex) || ((iColumnIndex !== iLastIndex) && iIndex > iColumnIndex)) && oCurrentColumn.getFlexible()) || iColumnIndex === undefined) {
					iOthersWidth += oCurrentColumn.$().outerWidth();
					iPercentages += iColumnPercentage;
					aOtherColumns.push(oCurrentColumn);
				} else if (iIndex !== iColumnIndex) {
					iTotalPercentage += iColumnPercentage;
				}
			});

			var iCalcPercentage = iTotalPercentage;
			jQuery.each(aOtherColumns, function(iIndex, oCurrentColumn){
				var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
				var iNewWidth = Math.round((100 - iCalcPercentage) / iPercentages * iColumnPercentage);
				if (iIndex === aOtherColumns.length - 1) {
					iNewWidth = 100 - iTotalPercentage;
				} else {
					iTotalPercentage += iNewWidth;
				}
				that._updateColumnWidth(oCurrentColumn, iNewWidth + "%");
			});
		} else if (!this._hasOnlyFixColumnWidths()) {

			var aVisibleColumns = this._getVisibleColumns(),
				iAvailableSpace = this.$().find(".sapUiTableCtrl").width(),
				iColumnIndex,
				iRightColumns = 0,
				iLeftWidth = 0,
				iRightWidth = 0,
				iNonFixedColumns = 0;

			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				//Check columns if they are fixed = they have a pixel width
				if (!jQuery.sap.endsWith(oCurrentColumn.getWidth(), "px")
					&& !jQuery.sap.endsWith(oCurrentColumn.getWidth(), "em")
					&& !jQuery.sap.endsWith(oCurrentColumn.getWidth(), "rem")) {
					iNonFixedColumns++;
					return false;
				}
				//if iColumnIndex is defined we already found our column and all other columns are right of that one
				if (iColumnIndex != undefined) {
					iRightWidth += this._CSSSizeToPixel(oCurrentColumn.getWidth());
					iRightColumns++;
				} else if (oColumn !== oCurrentColumn) {
					iLeftWidth += this._CSSSizeToPixel(oCurrentColumn.getWidth());
				}
				if (oColumn === oCurrentColumn) {
					iColumnIndex = iIndex;
					//Use new width of column
					iLeftWidth += this._CSSSizeToPixel(sWidth);
				}
			}.bind(this));
			//If there are non fixed columns we don't do this
			if (iNonFixedColumns > 0 || (iLeftWidth + iRightWidth > iAvailableSpace)) {
				return;
			}
			//Available space is all space right of the modified columns
			iAvailableSpace -= iLeftWidth;
			for (var i = iColumnIndex + 1; i < aVisibleColumns.length; i++) {
				//Calculate new column width based on previous percentage width
				var oColumn = aVisibleColumns[i],
					iColWidth = this._CSSSizeToPixel(oColumn.getWidth()),
					iPercent = iColWidth / iRightWidth * 100,
					iNewWidth = iAvailableSpace / 100 * iPercent;
				this._updateColumnWidth(oColumn, Math.round(iNewWidth) + 'px');
			}
		}
	};

	/**
	 *
	 * @param oColumn
	 * @returns {*}
	 * @private
	 */
	Table.prototype._getColumnPercentageWidth = function(oColumn) {
		var sColumnWidth = oColumn.getWidth();
		var iColumnPercentage = parseInt(oColumn.getWidth(),10);
		var iTotalWidth = this.$().find(".sapUiTableCtrl").width();
		if (jQuery.sap.endsWith(sColumnWidth, "px") || jQuery.sap.endsWith(sColumnWidth, "em") || jQuery.sap.endsWith(sColumnWidth, "rem")) {
			iColumnPercentage = Math.round(100 / iTotalWidth * iColumnPercentage);
		} else if (!jQuery.sap.endsWith(sColumnWidth, "%")) {
			iColumnPercentage = Math.round(100 / iTotalWidth * oColumn.$().width());
		}
		return iColumnPercentage;
	};

	/**
	 *
	 * @param oColumn
	 * @param sWidth
	 * @private
	 */
	Table.prototype._updateColumnWidth = function(oColumn, sWidth, bFireEvent) {
		// forward the event
		var bExecuteDefault = true;
		if (bFireEvent) {
			bExecuteDefault = this.fireColumnResize({
				column: oColumn,
				width: sWidth
			});
		}

		// set the width of the column (when not cancelled)
		if (bExecuteDefault) {
			oColumn.setProperty("width", sWidth, true);
			this.$().find('th[aria-owns="' + oColumn.getId() + '"]').css('width', sWidth);
		}

		return bExecuteDefault;
	};

	/**
	 * Check if at least one column has a percentage value
	 * @private
	 */
	Table.prototype._checkPercentageColumnWidth = function() {
		var aColumns = this.getColumns();
		var bHasPercentageColumns = false;
		jQuery.each(aColumns, function(iIndex, oColumn) {
			if (jQuery.sap.endsWith(oColumn.getWidth(), "%")) {
				bHasPercentageColumns = true;
				return false;
			}
		});
		return bHasPercentageColumns;
	};

	/**
	 * Check if table has only non flexible columns with fixed widths and only then
	 * the table adds a dummy column to fill the rest of the width instead of resizing
	 * the columns to fit the complete table width
	 * @private
	 */
	Table.prototype._hasOnlyFixColumnWidths = function() {
		var bOnlyFixColumnWidths = true;
		jQuery.each(this.getColumns(), function(iIndex, oColumn) {
			var sWidth = oColumn.getWidth();
			if (oColumn.getFlexible() || !sWidth || sWidth.substr(-2) !== "px") {
				bOnlyFixColumnWidths = false;
				return false;
			}
		});
		return bOnlyFixColumnWidths;
	};


	// =============================================================================
	// SORTING & FILTERING
	// =============================================================================

	/**
	 * pushes the sorted column to array
	 *
	 * @param {sap.ui.table.Column} oColumn
	 *         column to be sorted
	 * @param {Boolean} bAdd Set to true to add the new sort criterion to the existing sort criteria
	 * @type sap.ui.table.Table
	 * @private
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */

	Table.prototype.pushSortedColumn = function(oColumn, bAdd) {

		if (!bAdd) {
			this._aSortedColumns = [];
		}

		this._aSortedColumns.push(oColumn);

	};

	/**
	 * gets sorted columns
	 *
	 * @return Array of sorted columns
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.getSortedColumns = function() {

		return this._aSortedColumns;

	};

	/**
	 * sorts the given column ascending or descending
	 *
	 * @param {sap.ui.table.Column} oColumn
	 *         column to be sorted
	 * @param {sap.ui.table.SortOrder} oSortOrder
	 *         sort order of the column (if undefined the default will be ascending)
	 * @param {Boolean} bAdd Set to true to add the new sort criterion to the existing sort criteria
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.sort = function(oColumn, oSortOrder, bAdd) {
		if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
			oColumn.sort(oSortOrder === sap.ui.table.SortOrder.Descending, bAdd);
		}
	};


	/**
	 * filter the given column by the given value
	 *
	 * @param {sap.ui.table.Column} oColumn
	 *         column to be filtered
	 * @param {string} sValue
	 *         filter value as string (will be converted)
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.filter = function(oColumn, sValue) {
		if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
			oColumn.filter(sValue);
		}
	};


	// =============================================================================
	// SELECTION HANDLING
	// =============================================================================

	Table.prototype._getSelectOnCellsAllowed = function () {
		var sSelectionBehavior = this.getSelectionBehavior();
		var sSelectionMode = this.getSelectionMode();
		return sSelectionMode !== sap.ui.table.SelectionMode.None && (sSelectionBehavior === sap.ui.table.SelectionBehavior.Row || sSelectionBehavior === sap.ui.table.SelectionBehavior.RowOnly);
	};

	/**
	 * Retrieve Aria descriptions from resource bundle for a certain selection mode
	 * @param {Boolean} [bConsiderSelectionState] set to true if the current selection state of the table shall be considered
	 * @param {String} [sSelectionMode] optional parameter. If no selection mode is set, the current selection mode of the table is used
	 * @returns {{mouse: {rowSelect: string, rowDeselect: string}, keyboard: {rowSelect: string, rowDeselect: string}}}
	 * @private
	 */
	Table.prototype._getAriaTextsForSelectionMode = function (bConsiderSelectionState, sSelectionMode) {
		if (!sSelectionMode) {
			sSelectionMode = this.getSelectionMode();
		}

		var oResBundle = this._oResBundle;
		var mTooltipTexts = {
			mouse: {
				rowSelect: "",
				rowDeselect: ""
			},
			keyboard:{
				rowSelect: "",
				rowDeselect: ""
			}};

		if (sSelectionMode === sap.ui.table.SelectionMode.Single) {
			mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
			mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
			mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
			mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");
		} else if (sSelectionMode === sap.ui.table.SelectionMode.Multi) {
			mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI");
			mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_MULTI");
			mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY");
			mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY");

			if (bConsiderSelectionState === true) {
				if (this.getSelectedIndices().length === 1) {
					// in multi selection case, if there is only one row selected it's not required
					// to press CTRL in order to only deselect this single row hence use the description text
					// of the single de-selection.
					// for selection it's different since the description for SHIFT/CTRL handling is required
					mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
					mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");
				} else if (this.getSelectedIndices().length === 0) {
					// if there are no rows selected in multi selection mode, it's not required to press CTRL or SHIFT
					// in order to enhance the selection.
					mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
					mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
				}
			}

		} else if (sSelectionMode === sap.ui.table.SelectionMode.MultiToggle) {
			mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_TOGGLE");
			// text for de-select is the same like for single selection
			mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
			mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");
			// text for de-select is the same like for single selection
			mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");

			if (bConsiderSelectionState === true && this.getSelectedIndices().length === 0) {
				// if there is no row selected yet, the selection is like in single selection case
				mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
				mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
			}
		}

		return mTooltipTexts;
	};

	/**
	 * updates the visual selection in the HTML markup
	 * @private
	 */
	Table.prototype._updateSelection = function() {
		if (this.getSelectionMode() === sap.ui.table.SelectionMode.None) {
			// there is no selection which needs to be updated. With the switch of the
			// selection mode the selection was cleared (and updated within that step)
			return;
		}

		// retrieve tooltip and aria texts only once and pass them to the rows _updateSelection function
		var mTooltipTexts = this._getAriaTextsForSelectionMode(true);

		// check whether the row can be clicked to change the selection
		var bSelectOnCellsAllowed = this._getSelectOnCellsAllowed();

		// trigger the rows to update their selection
		var aRows = this.getRows();
		for (var i = 0; i < aRows.length; i++) {
			var oRow = aRows[i];
			oRow._updateSelection(this, mTooltipTexts, bSelectOnCellsAllowed);
		}
		// update internal property to reflect the correct index
		this.setProperty("selectedIndex", this.getSelectedIndex(), true);
	};


	/**
	 * notifies the selection listeners about the changed rows
	 * @private
	 */
	Table.prototype._onSelectionChanged = function(oEvent) {
		var aRowIndices = oEvent.getParameter("rowIndices");
		var iRowIndex = this._iSourceRowIndex !== undefined ? this._iSourceRowIndex : this.getSelectedIndex();
		this._updateSelection();
		var oSelMode = this.getSelectionMode();
		if (oSelMode === "Multi" || oSelMode === "MultiToggle") {
			this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");
		}
		this.fireRowSelectionChange({
			rowIndex: iRowIndex,
			rowContext: this.getContextByIndex(iRowIndex),
			rowIndices: aRowIndices
		});
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Returns the context of a row by its index. Please note that for server-based models like OData,
	 * the supplied index might not have been loaded yet. If the context is not available at the client,
	 * the binding will trigger a backend request and request this single context. Although this API
	 * looks synchronous it may not return a context but load it and fire a change event on the binding.
	 *
	 * For server-based models you should consider to only make this API call when the index is within
	 * the currently visible scroll area.
	 *
	 * @param {int} iIndex
	 *         Index of the row to return the context from.
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.getContextByIndex = function(iIndex) {
		// TODO: ODataListBinding needs to make sure to prevent loading multiple times
		// index must not be smaller than 0! otherwise the ODataModel fails
		var oBinding = this.getBinding("rows");
		return iIndex >= 0 && oBinding ? oBinding.getContexts(iIndex, 1)[0] : null;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.getSelectedIndex = function() {
		return this._oSelection.getLeadSelectedIndex();
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setSelectedIndex = function(iIndex) {
		if (iIndex === -1) {
			//If Index eq -1 no item is selected, therefore clear selection is called
			//SelectionModel doesn't know that -1 means no selection
			this.clearSelection();
		} else {
			this._oSelection.setSelectionInterval(iIndex, iIndex);
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Removes complete selection.
	 *
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.clearSelection = function() {
		this._oSelection.clearSelection();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Add all rows to the selection.
	 * Please note that for server based models like OData the indices which are considered to be selected might not
	 * be available at the client yet. Calling getContextByIndex might not return a result but trigger a roundtrip
	 * to request this single entity.
	 *
	 * @return sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.selectAll = function() {
		var oSelMode = this.getSelectionMode();
		if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
			return this;
		}
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			// first give the higher number. The toIndex will be used as leadIndex. It more likely that
			// in oData case the index 0 is already loaded than that the last index is loaded. The leadIndex will
			// be used to determine the leadContext in the selectionChange event. If not yet loaded it would need to
			// be request. To avoid unnecessary roundtrips the lead index is set to 0.
			this._oSelection.setSelectionInterval((oBinding.getLength() || 0) - 1, 0);
			this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
	 *
	 * @return int[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.getSelectedIndices = function() {
		return this._oSelection.getSelectedIndices();
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Adds the given selection interval to the selection. In case of single selection the "indexTo" value will be used for as selected index.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.addSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.addSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/**
	 * Sets the given selection interval as selection. In case of single selection the "indexTo" value will be used for as selected index.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.setSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.setSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/**
	 * Removes the given selection interval from the selection. In case of single selection this call removeSelectedIndex with the "indexTo" value.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.removeSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.removeSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/**
	 * Returns whether the given index is selected.
	 *
	 * @param {int} iIndex
	 *         Index which is checked for selection state.
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.isIndexSelected = function(iIndex) {
		return this._oSelection.isSelectedIndex(iIndex);
	};


	// =============================================================================
	// KEYBOARD HANDLING HELPERS
	// =============================================================================

	/**
	 * scrolls down a single row
	 * @private
	 */
	Table.prototype._scrollNext = function() {
		// we are at the end => scroll one down if possible
		if (this.getFirstVisibleRow() < this._getRowCount() - this.getVisibleRowCount()) {
			this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + 1, this._getRowCount() - this.getVisibleRowCount()));
		}
	};

	/**
	 * scrolls up a single row
	 * @private
	 */
	Table.prototype._scrollPrevious = function() {
		// we are at the beginning => scroll one up if possible
		if (this.getFirstVisibleRow() > 0) {
			this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - 1, 0));
		}
	};

	/**
	 * scrolls down a up page
	 * @private
	 */
	Table.prototype._scrollPageUp = function() {
		this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - this.getVisibleRowCount(), 0));
	};

	/**
	 * scrolls down a complete page
	 * @private
	 */
	Table.prototype._scrollPageDown = function() {
		this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + this.getVisibleRowCount() - this.getFixedBottomRowCount(), this._getRowCount() - this.getVisibleRowCount()));
	};

	/**
	 * checks if the current target domref is in the first row of the table
	 * @private
	 */
	Table.prototype._isTopRow = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
		var iFixedRows = this.getFixedRowCount();
		if (iFixedRows > 0 && iRowIndex >= iFixedRows) {
			return iRowIndex === iFixedRows;
		}
		return iRowIndex === 0;
	};

	/**
	 * checks if the current target domref is in the last row of the table
	 * @private
	 */
	Table.prototype._isBottomRow = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
		var iFixedRows = this.getFixedBottomRowCount();
		if (iFixedRows > 0 && iRowIndex <= this.getVisibleRowCount() - 1 - iFixedRows) {
			return iRowIndex === this.getVisibleRowCount() - 1 - iFixedRows;
		}
		return iRowIndex === this.getVisibleRowCount() - 1;
	};

	/**
	 * enters the action mode. in the action mode the user can navigate through the
	 * interactive controls of the table by using the TAB & SHIFT-TAB. this table is
	 * aligned with the official WAI-ARIA 1.0.
	 * @private
	 */
	Table.prototype._enterActionMode = function($Focusable) {
		// only enter the action mode when not already in action mode and:
		if ($Focusable.length > 0 && !this._bActionMode) {

			//If cell has no tabbable element, we don't do anything
			if ($Focusable.filter(":sapTabbable").length == 0) {
				return;
			}

			// in the action mode we need no item navigation
			this._bActionMode = true;
			this.removeDelegate(this._oItemNavigation);

			// remove the tab index from the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");

			// set the focus to the active control
			$Focusable.filter(":sapTabbable").eq(0).focus();
		}
	};

	/**
	 * leaves the action mode and enters the navigation mode. in the navigation mode
	 * the user can navigate through the cells of the table by using the arrow keys,
	 * page up & down keys, home and end keys. this table is aligned with the
	 * official WAI-ARIA 1.0.
	 * @private
	 */
	Table.prototype._leaveActionMode = function(oEvent) {

	 // TODO: update ItemNavigation position otherwise the position is strange!
	 //        EDIT AN SCROLL!

		if (this._bActionMode) {

			// in the navigation mode we use the item navigation
			this._bActionMode = false;
			this.addDelegate(this._oItemNavigation);

			// reset the tabindex of the focused domref of the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

			// when we have an event which is responsible to leave the action mode
			// we search for the closest
			if (oEvent) {
				if (jQuery(oEvent.target).closest("td[tabindex='-1']").length > 0) {
					// triggered when clicking into a cell, then we focus the cell
					var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("td[tabindex='-1']").get(0));
					this._oItemNavigation.focusItem(iIndex, null);
				} else {
					// somewhere else means whe check if the click happend inside
					// the container, then we focus the last focused element
					// (DON'T KNOW IF THIS IS OK - but we don't know where the focus was!)
					if (jQuery.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0), oEvent.target)) {
						this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
					}
				}
			} else {
				// when no event is given we just focus the last focused index
				this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
			}

		}

	};

	/**
	 * Return the focused row index.
	 * @return {int} the currently focused row index.
	 * @private
	 */
	Table.prototype._getFocusedRowIndex = function() {
		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;
		var iSelectedRow = this.getFirstVisibleRow() + (iFocusedIndex - iSelectedCellInRow) / iColumns;

		if (!this.getColumnHeaderVisible()) {
			iSelectedRow++;
		}
		return iSelectedRow - 1;
	};

	/**
	 * Checks whether the row of the currently focused cell is selected or not.
	 * @return {boolean} true or false
	 * @private
	 */
	Table.prototype._isFocusedRowSelected = function() {
		var iSelectedRow = this._getFocusedRowIndex();
		var bIsFocusedRowSelected = this.isIndexSelected(iSelectedRow);

		var bIsCellRowHeader = (this._oItemNavigation.iFocusedIndex % this._oItemNavigation.iColumns == 0);
		if (bIsCellRowHeader) {
			return bIsFocusedRowSelected;
		} else {
			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
			if (bHasRowHeader) {
				return null;
			} else {
				return bIsFocusedRowSelected;
			}
		}
	};

	// =============================================================================
	// KEYBOARD HANDLING EVENTS
	// =============================================================================

	// FYI: two more relevant things are handled in the onclick and onfocusin event

	/**
	 * handle the row selection via SPACE or ENTER key if key is pressed on a group header, the open state is toggled
	 * @private
	 */
	Table.prototype.onkeyup = function(oEvent) {
		if (!this._bEventSapSelect === true) {
			return;
		}

		this._bEventSapSelect = false;

		// this mimics the sapselect event but on keyup
		if (oEvent.keyCode !== jQuery.sap.KeyCodes.ENTER &&
			oEvent.keyCode !== jQuery.sap.KeyCodes.SPACE &&
			oEvent.keyCode !== jQuery.sap.KeyCodes.F4 ||
			oEvent.srcControl !== this &&
			jQuery.inArray(oEvent.srcControl,this.getRows()) === -1 &&
			jQuery.inArray(oEvent.srcControl,this.getColumns()) === -1) {
			return;
		}
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				if (oBinding.isExpanded(iRowIndex)) {
					oBinding.collapse(iRowIndex);
				} else {
					oBinding.expand(iRowIndex);
				}
			}
			oEvent.preventDefault();
			return;
		}
		this._bShowMenu = true;
		this._onSelect(oEvent);
		this._bShowMenu = false;
		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	Table.prototype.onsapselect = function() {
		this._bEventSapSelect = true;
	};

	/**
	 * @private
	 */
	Table.prototype.onsapselectmodifiers = function() {
		this._bEventSapSelect = true;
	};

	Table.prototype.onsapspace = function(oEvent) {
		var $target = jQuery(oEvent.target);
		if (((this.getSelectionBehavior() == sap.ui.table.SelectionBehavior.Row || this.getSelectionBehavior() == sap.ui.table.SelectionBehavior.RowOnly) && oEvent.srcControl instanceof sap.ui.table.Row) ||
			$target.hasClass("sapUiTableRowHdr") || $target.hasClass("sapUiTableColRowHdr") || $target.hasClass("sapUiTableCol")) {
			oEvent.preventDefault();
		}
	};

	/**
	 * handle the row selection via SPACE or ENTER key
	 * @private
	 */
	Table.prototype.onkeydown = function(oEvent) {
		var $this = this.$();

		if (!this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
			oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
			if ($this.find(".sapUiTableCtrl td:focus").length > 0) {
				this._enterActionMode($this.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else if (this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
			this._leaveActionMode(oEvent);
		} else if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode) {
			//Set tabindex to second table if fixed columns are used
			if (this.getFixedColumnCount() > 0) {
				var $cell = jQuery(oEvent.target);
				if ($cell.is("td[role=gridcell]") == false) {
					$cell = $cell.parents("td[role=gridcell]");
				}
				var $row = $cell.parent("tr[data-sap-ui-rowindex]");
				var $table = $row.closest(".sapUiTableCtrl");
				var iRowIndex = parseInt($row.attr("data-sap-ui-rowindex"),10);
				var $cells = $row.find("td[role=gridcell]");
				var iColIndex = $cells.index($cell);
				var iTableCols = $cells.length;
				if (iColIndex === (iTableCols - 1)) {
					var $otherTable;
					if ($table.hasClass("sapUiTableCtrlFixed")) {
						$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll");
					} else {
						$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlFixed");
						iRowIndex++;
						if (iRowIndex == this.getVisibleRowCount()) {
							iRowIndex = 0;
						}
					}
					var $otherRow = $otherTable.find("tr[data-sap-ui-rowindex='" + iRowIndex + "']");
					var $nextFocus = $otherRow.find("td :sapFocusable[tabindex='0']").first();
					if ($nextFocus.length > 0) {
						$nextFocus.focus();
						oEvent.preventDefault();
					}
				}
			}
		} else if (oEvent.keyCode == jQuery.sap.KeyCodes.A && (oEvent.metaKey || oEvent.ctrlKey)) {
			// CTRL + A handling
			var oIN = this._oItemNavigation;
			var iFocusedIndex = oIN.getFocusedIndex();

			this._toggleSelectAll();

			oIN.focusItem(iFocusedIndex, oEvent);

			oEvent.preventDefault();
			oEvent.stopImmediatePropagation(true);
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.F10 && (oEvent.shiftKey)) {
			// SHIFT + 10 should open the context menu
			this.oncontextmenu(oEvent);
		}
	};

	/**
	 * handle the ESCAPE key to leave the action mode
	 * @private
	 */
	Table.prototype.onsapescape = function(oEvent) {
		this._leaveActionMode(oEvent);
	};

	/**
	 * handle the SHIFT-TAB key
	 * <ul>
	 *   <li>Navigation Mode:
	 *      <ul>
	 *          <li>If focus is on header: jump to the next focusable control before the table</li>
	 *          <li>If focus in on content: jump to header for the current column</li>
	 *      </ul>
	 *   <li>Action Mode: switch back to navigation mode</li>
	 * </ul>
	 * @private
	 */
	Table.prototype.onsaptabprevious = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			this._leaveActionMode();
			oEvent.preventDefault();
		} else {
			var oIN = this._oItemNavigation;
			var bNoData = this.$().hasClass("sapUiTableEmpty");
			var oSapUiTableCCnt = $this.find('.sapUiTableCCnt')[0];
			var bFocusFromTableContent = jQuery.contains(oSapUiTableCCnt, oEvent.target);

			if (bFocusFromTableContent && this.getColumnHeaderVisible()) {
				// Focus comes from table content. Focus the column header which corresponds to the
				// selected column (column index)
				var iColumn = oIN.getFocusedIndex() % oIN.iColumns;
				oIN.focusItem(iColumn, oEvent);
				oEvent.preventDefault();
			} else if (oIN.getFocusedDomRef() === oEvent.target && jQuery.sap.containsOrEquals(oSapUiTableCCnt, oEvent.target) ||
				(!this.getColumnHeaderVisible() && bNoData && bFocusFromTableContent)) {
				// in case of having the focus in the row or column header we do not need to
				// place the focus to the div before the table control because there we do
				// not need to skip the table controls anymore.
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiTableCtrlBefore").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 * handle the TAB key:
	 * <ul>
	 *   <li>Navigation Mode:
	 *      <ul>
	 *          <li>If focus is on header: jump to the first data column of the focused column header</li>
	 *          <li>If focus in on content: jump to the next focusable control after the table</li>
	 *      </ul>
	 *   <li>Action Mode: switch back to navigation mode</li>
	 * </ul>
	 * @private
	 */
	Table.prototype.onsaptabnext = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			this._leaveActionMode();
			oEvent.preventDefault();
		} else {
			var oIN = this._oItemNavigation;
			var bContainsColHdrCnt = jQuery.contains($this.find('.sapUiTableColHdrCnt')[0], oEvent.target);
			var bNoData = this.$().hasClass("sapUiTableEmpty");

			if (bContainsColHdrCnt && !bNoData) {
				oIN.focusItem(oIN.getFocusedIndex() + oIN.iColumns * this._iLastSelectedDataRow, oEvent);
				oEvent.preventDefault();
			} else if (oIN.getFocusedDomRef() === oEvent.target || (bNoData && bContainsColHdrCnt)) {
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiTableCtrlAfter").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 *
	 * @param bForceUpdate
	 * @private
	 */
	Table.prototype._updateAriaRowOfRowsText = function(bForceUpdate) {
		var oAriaElement = document.getElementById(this.getId() + "-rownumberofrows");

		if (!oAriaElement) {
			// table is not in DOM anymore
			return;
		}

		var oIN = this._oItemNavigation;
		if (oIN) {
			var iIndex = oIN.getFocusedIndex();
			var iColumnNumber = iIndex % oIN.iColumns;

			var iFirstVisibleRow = this.getFirstVisibleRow();
			var iTotalRowCount = this._getRowCount();
			var iRowIndex = Math.floor(iIndex / oIN.iColumns) + iFirstVisibleRow + 1 - this._getHeaderRowCount();

			var sRowCountText = this._oResBundle.getText("TBL_ROW_ROWCOUNT", [iRowIndex, iTotalRowCount]);
			if (iRowIndex > 0 && iColumnNumber === 0 || bForceUpdate) {
				oAriaElement.innerText = sRowCountText;
			} else {
				oAriaElement.innerText = " ";
			}
		}
	};


	/**
	 * dynamic scrolling when reaching the bottom row with the ARROW DOWN key
	 * @private
	 */
	Table.prototype.onsapdown = function(oEvent) {
		if (!this._bActionMode && this._isBottomRow(oEvent)) {
			if (this.getFirstVisibleRow() != this._getRowCount() - this.getVisibleRowCount()) {
				oEvent.stopImmediatePropagation(true);
				if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
					this._scrollNext();
				} else {
					this._scrollPageDown();
				}
			}
		}
		oEvent.preventDefault();
	};

	/**
	 * Implements selecting/deselecting rows when pressing SHIFT + DOWN
	 * @private
	 */
	Table.prototype.onsapdownmodifiers = function(oEvent) {
		if (oEvent.shiftKey) {
			var iFocusedRow = this._getFocusedRowIndex();
			var bIsFocusedRowSelected = this._isFocusedRowSelected();
			if (bIsFocusedRowSelected === true) {
				this.addSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
			} else if (bIsFocusedRowSelected === false) {
				this.removeSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
			}

			if (this._isBottomRow(oEvent)) {
				this._scrollNext();
			}
		} else if (oEvent.altKey) {
			// Toggle group header on ALT + DOWN.
			this._toggleGroupHeader(oEvent);
		}
	};

	/**
	 * Implements selecting/deselecting rows when pressing SHIFT + UP
	 *
	 * @private
	 */
	Table.prototype.onsapupmodifiers = function(oEvent) {
		if (oEvent.shiftKey) {
			var iFocusedRow = this._getFocusedRowIndex();
			var bIsFocusedRowSelected = this._isFocusedRowSelected();

			if (bIsFocusedRowSelected === true) {
				this.addSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
			} else if (bIsFocusedRowSelected === false) {
				this.removeSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
			}

			if (this._isTopRow(oEvent)) {
				// Prevent that focus jumps to header in this case.
				if (this.getFirstVisibleRow() != 0) {
					oEvent.stopImmediatePropagation(true);
				}
				this._scrollPrevious();
			}
		} else if (oEvent.altKey) {
			// Toggle group header on ALT + UP.
			this._toggleGroupHeader(oEvent);
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the ARROW UP key
	 *
	 * @private
	 */
	Table.prototype.onsapup = function(oEvent) {
		if (!this._bActionMode && this._isTopRow(oEvent)) {
			if (this.getFirstVisibleRow() != 0) {
				oEvent.stopImmediatePropagation(true);
			}
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
				this._scrollPrevious();
			} else {
				this._scrollPageUp();
			}
		}
		oEvent.preventDefault();
	};

	/**
	 * dynamic scrolling when reaching the bottom row with the PAGE DOWN key
	 * @private
	 */
	Table.prototype.onsappagedown = function(oEvent) {
		if (!this._bActionMode) {
			var $this = this.$();
			var oIN = this._oItemNavigation;

			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
			var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;

			// Check if focus is on header
			// Special Handling is required here:
			// - If not in the last header row, jump to the last header row in the same column
			// - If in the last header row, scroll table to first row and jump to first row, same column
			if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
				// focus is on header
				var iCol = oIN.iFocusedIndex % oIN.iColumns;
				if ((oIN.iFocusedIndex <= (oIN.iColumns * iHeaderRows) && oIN.iFocusedIndex >= (oIN.iColumns * iHeaderRows) - oIN.iColumns) ||
					(iCol === 0 && bRowHeader)) {
					// move focus to first data row, scroll table to top
					this.setFirstVisibleRow(0);
					oIN.focusItem(oIN.iColumns * iHeaderRows + iCol, oEvent);
				} else {
					// set focus to last header row, same column if possible
					oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
				}

				oEvent.stopImmediatePropagation(true);
			} else {
				if (this._isBottomRow(oEvent)) {
					this._scrollPageDown();
				}

				var iFixedBottomRowsOffset = this.getFixedBottomRowCount();
				if (this.getFirstVisibleRow() === this._getRowCount() - this.getVisibleRowCount()) {
					iFixedBottomRowsOffset = 0;
				}

				var iRowCount = (oIN.aItemDomRefs.length / oIN.iColumns) - iFixedBottomRowsOffset;
				var iCol = oIN.iFocusedIndex % oIN.iColumns;
				var iIndex = (iRowCount - 1) * oIN.iColumns + iCol;

				oIN.focusItem(iIndex, oEvent);

				oEvent.stopImmediatePropagation(true);
			}
			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE DOWN key
	 * @private
	 */
	Table.prototype.onsappagedownmodifiers = function(oEvent) {
		if (!this._bActionMode && oEvent.altKey) {
			var oIN = this._oItemNavigation;
			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

			var iCol = oIN.iFocusedIndex % oIN.iColumns;
			var iNewCol;
			if (iCol == 0 && bRowHeader) {
				iNewCol = 1;
			} else {
				var iVisibleColumns = this._aVisibleColumns.length;
				var iMaxIndex = this._getVisibleColumns().length;
				if (!bRowHeader) {
					iMaxIndex--;
				}
				if (iVisibleColumns === 0) {
					iNewCol = iMaxIndex;
				} else {
					iNewCol = Math.min(iMaxIndex, iCol + iVisibleColumns);
				}
			}
			oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
			oEvent.stopImmediatePropagation(true);
			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE UP key
	 * @private
	 */
	Table.prototype.onsappageup = function(oEvent) {
		if (!this._bActionMode) {
			var $this = this.$();
			var oIN = this._oItemNavigation;

			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
			var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;
			var iCol = oIN.iFocusedIndex % oIN.iColumns;

			if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
				// focus is on header
				if (oIN.iFocusedIndex > oIN.iColumns) {
					// focus is not on the first header row, move to first
					oIN.focusItem(iCol, oEvent);
				}
				oEvent.stopImmediatePropagation(true);
			} else {
				// focus is on content area
				if (this.getColumnHeaderVisible() && this.getFirstVisibleRow() == 0 && this._isTopRow(oEvent)) {
					// focus is on first row, move to last header row, same column
					if (bRowHeader && iCol === 0) {
						oIN.focusItem(iCol, oEvent);
					} else {
						oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
					}
					oEvent.stopImmediatePropagation(true);
				} else {
					var iIndex = this.getColumnHeaderVisible() ? oIN.iColumns * iHeaderRows : 0;
					oIN.focusItem(iIndex + iCol, oEvent);
					oEvent.stopImmediatePropagation(true);

					if (this._isTopRow(oEvent)) {
						this._scrollPageUp();
					}
				}
			}

			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE UP key
	 * @private
	 */
	Table.prototype.onsappageupmodifiers = function(oEvent) {
		if (!this._bActionMode && oEvent.altKey) {
			var oIN = this._oItemNavigation;
			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

			var iCol = oIN.iFocusedIndex % oIN.iColumns;
			if (iCol > 0) {
				var iNewCol;
				if (iCol == 1 && bRowHeader) {
					iNewCol = 0;
				} else {
					var iVisibleColumns = this._aVisibleColumns.length;
					if (iVisibleColumns === 0) {
						if (bRowHeader) {
							iNewCol = 1;
						} else {
							iNewCol = 0;
						}
					} else {
						var iMin = 1;
						if (!bRowHeader) {
							iMin = 0;
						}
						iNewCol = Math.max(iMin, iCol - iVisibleColumns);
					}
				}
				oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
			}
			oEvent.stopImmediatePropagation(true);
			oEvent.preventDefault();
		}
	};

	/**
	 * Keyboard Handling regarding HOME key
	 *
	 * @private
	 */
	Table.prototype.onsaphome = function(oEvent) {
		var bIsRowOnly = (this.getSelectionBehavior() == sap.ui.table.SelectionBehavior.RowOnly);

		// If focus is on a group header, do nothing.
		var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
		if (bIsGroupCell) {
			oEvent.stopImmediatePropagation(true);
			return;
		}

		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;

		var offset = 0;
		if (!bIsRowOnly) {
			offset = 1;
		}

		if (iSelectedCellInRow > this.getFixedColumnCount() + offset) {
			// If there is a fixed column, stop right of it.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() + offset, null);
		} else if (!bIsRowOnly) {
			if (iSelectedCellInRow > 1) {
				// if focus is anywhere in the row, move focus to the first column cell.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + 1, null);
			} else if (iSelectedCellInRow == 1) {
				// if focus is on first cell, move focus to row header.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - 1, null);
			} else {
				// If focus is on selection cell, do nothing.
				oEvent.stopImmediatePropagation(true);
			}
		}
	};

	/**
	 * Keyboard Handling regarding END key
	 *
	 * @private
	 */
	Table.prototype.onsapend = function(oEvent) {
		// If focus is on a group header, do nothing.
		var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
		if (bIsGroupCell) {
			oEvent.stopImmediatePropagation(true);
			return;
		}

		// If focus is on a selection cell, move focus to the first cell of the same row.
		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;

		var bIsRowOnly = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
		var offset = 0;
		if (!bIsRowOnly) {
			offset = 1;
		}

		if (iSelectedCellInRow === 0 && bIsRowOnly) {
			// If focus is in row header, select first cell in same row.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex + 1, null);
		} else if (iSelectedCellInRow < this.getFixedColumnCount() - offset) {
			// if their is a fixed column, stop left of it.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() - offset, null);
		}
	};

	/**
	 * dynamic scrolling when using CTRL + HOME key
	 *
	 * @private
	 */
	Table.prototype.onsaphomemodifiers = function(oEvent) {
		if (oEvent.metaKey || oEvent.ctrlKey) {
			var $this = this.$();

			// Is target a table header cell
			var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
			var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

			// If focus is on a group header, do nothing.
			if (bIsTableHeaderCell) {
				oEvent.stopImmediatePropagation(true);
				return;
			}

			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedRowInColumn = Math.ceil(iFocusedIndex / iColumns) - 1;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			if (this.getColumnHeaderVisible()) {
				if (iSelectedRowInColumn == 1) {
					// if focus is in first row, select corresponding header
					oEvent.stopImmediatePropagation(true);
					this._oItemNavigation.focusItem(iSelectedCellInRow, oEvent);
				} else if (iSelectedRowInColumn > 1) {
					oEvent.stopImmediatePropagation(true);

					// if focus is in any row, select first cell row
					this.setFirstVisibleRow(0);

					var iTargetIndex = iSelectedCellInRow + iColumns;
					this._oItemNavigation.focusItem(iTargetIndex, oEvent);
				}
			} else {
				oEvent.stopImmediatePropagation(true);

				// if focus is in any row, select first cell row
				this.setFirstVisibleRow(0);

				var iTargetIndex = iFocusedIndex - iSelectedRowInColumn * iColumns;
				this._oItemNavigation.focusItem(iTargetIndex, oEvent);
			}
		}
	};

	/**
	 * dynamic scrolling when using CTRL + END key
	 *
	 * @private
	 */
	Table.prototype.onsapendmodifiers = function(oEvent) {
		if (oEvent.metaKey || oEvent.ctrlKey) {
			var $this = this.$();

			// Is target a table header cell
			var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
			var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			oEvent.stopImmediatePropagation(true);

			if (bIsTableHeaderCell) {
				// If focus is on a group header, select first cell row after header.
				this._oItemNavigation.focusItem(iFocusedIndex + iColumns, oEvent);
			} else {
				// if focus is on any cell row, select last cell row.
				this.setFirstVisibleRow(this._getRowCount() - this.getVisibleRowCount());
				var iTargetIndex = this._oItemNavigation.aItemDomRefs.length - (iColumns - iSelectedCellInRow);
				this._oItemNavigation.focusItem(iTargetIndex, oEvent);
			}
		}
	};

	/**
	 * Default handler for sapleft event.
	 * @private
	 */
	Table.prototype.onsapleft = function(oEvent) {
		this._collapseGroupHeader(oEvent);
	};

	/**
	 * Default handler for sapright event.
	 * @private
	 */
	Table.prototype.onsapright = function(oEvent) {
		this._expandGroupHeader(oEvent);
	};


	/**
	 * If focus is on group header, open/close the group header, depending on the expand state.
	 * @private
	 */
	Table.prototype._toggleGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding.isExpanded(iRowIndex)) {
				oBinding.collapse(iRowIndex);
			} else {
				oBinding.expand(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * If focus is on group header, close the group header, else do the default behaviour of item navigation
	 * @private
	 */
	Table.prototype._collapseGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding.isExpanded(iRowIndex)) {
				oBinding.collapse(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * If focus is on group header, open the group header, else do the default behaviour of item navigation
	 * @private
	 */
	Table.prototype._expandGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && !oBinding.isExpanded(iRowIndex)) {
				oBinding.expand(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * On shift+left on column header decrease the width of a column
	 * @private
	 */
	Table.prototype.onsapleftmodifiers = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass('sapUiTableCol')) {
			var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10),
				aVisibleColumns = this._getVisibleColumns(),
				oColumn = aVisibleColumns[this._aVisibleColumns.indexOf(iColIndex)];

			 if (oEvent.shiftKey) {
				 var iNewWidth = parseInt(oColumn.getWidth(), 10) - 16;
				oColumn.setWidth((iNewWidth > 20 ? iNewWidth : 20) + "px");
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			} else if (oEvent.ctrlKey || oEvent.metaKey) {
				if (iColIndex - 1 >= 0) {
					// check whether preceding column is part of column span
					var iNewIndex = 0;

					for (var iPointer = this._aVisibleColumns.indexOf(iColIndex) - 1; iPointer >= 0; iPointer--) {
						iNewIndex = this._aVisibleColumns[iPointer];
						if (aVisibleColumns[iPointer].$().css("display") !== "none") {
							break;
						}
					}
					this.removeColumn(oColumn);
					this.insertColumn(oColumn, iNewIndex);

					// also move spanned columns
					var iHeaderSpan = oColumn.getHeaderSpan();
					if (iHeaderSpan > 1) {
						for (var i = 1; i < iHeaderSpan; i++) {
							oColumn = aVisibleColumns[iColIndex + i];
							this.removeColumn(oColumn);
							this.insertColumn(oColumn, iNewIndex + i);
						}
					}
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		}
	};

	/**
	 * On shift+left on column header decrease the width of a column
	 * @private
	 */
	Table.prototype.onsaprightmodifiers = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass('sapUiTableCol')) {
			var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10);
			var aVisibleColumns = this._getVisibleColumns();
			var iPointer = this._aVisibleColumns.indexOf(iColIndex);
			var oColumn = aVisibleColumns[iPointer];
			 if (oEvent.shiftKey) {
				oColumn.setWidth(parseInt(oColumn.getWidth(), 10) + 16 + "px");
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			} else if (oEvent.ctrlKey || oEvent.metaKey) {
				var iHeaderSpan = oColumn.getHeaderSpan();
				if (iPointer < aVisibleColumns.length - iHeaderSpan) {
					// Depending on the header span of the column to be moved, several
					// columns might need to be moved to the right
					var iNextHeaderSpan = aVisibleColumns[iPointer + 1].getHeaderSpan(),
						iNewIndex = this._aVisibleColumns[iPointer + iNextHeaderSpan];
					//iPointer = this._aVisibleColumns[iPointer];
					for (var i = iHeaderSpan - 1; i >= 0; i--) {
						oColumn = aVisibleColumns[iPointer + i];
						this.removeColumn(oColumn);
						this.insertColumn(oColumn, iNewIndex + i);
					}
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		}
	};

	// =============================================================================
	// GROUPING
	// =============================================================================

	/*
	 * overridden to hide the group by column when set
	 */
	Table.prototype.setGroupBy = function(vValue) {

		// determine the group by column
		var oGroupBy = vValue;
		if (typeof oGroupBy === "string") {
			oGroupBy = sap.ui.getCore().byId(oGroupBy);
		}

		// only for columns we do the full handling here - otherwise the method
		// setAssociation will fail below with a specific fwk error message
		var bReset = false;
		if (oGroupBy && oGroupBy instanceof sap.ui.table.Column) {

			// check for column being part of the columns aggregation
			if (jQuery.inArray(oGroupBy, this.getColumns()) === -1) {
				throw new Error("Column has to be part of the columns aggregation!");
			}

			// fire the event (to allow to cancel the event)
			var bExecuteDefault = this.fireGroup({column: oGroupBy, groupedColumns: [oGroupBy.getId()], type: sap.ui.table.GroupEventType.group});

			// first we reset the grouping indicator of the old column (will show the column)
			var oOldGroupBy = sap.ui.getCore().byId(this.getGroupBy());
			if (oOldGroupBy) {
				oOldGroupBy.setGrouped(false);
				bReset = true;
			}

			// then we set the grouping indicator of the new column (will hide the column)
			// ==> only if the default behavior is not prevented
			if (bExecuteDefault && oGroupBy instanceof sap.ui.table.Column) {
				oGroupBy.setGrouped(true);
			}

		}

		// reset the binding when no value is given or the binding needs to be reseted
		// TODO: think about a better handling to recreate the group binding
		if (!oGroupBy || bReset) {
			var oBindingInfo = this.getBindingInfo("rows");
			delete oBindingInfo.binding;
			this._bindAggregation("rows", oBindingInfo);
		}

		// set the new group by column (TODO: undefined doesn't work!)
		return this.setAssociation("groupBy", oGroupBy);
	};

	/*
	 * override the getBinding to inject the grouping information into the JSON model.
	 *
	 * !!EXPERIMENTAL FEATURE!!
	 *
	 * TODO:
	 *   - Grouping is not really possible for models based on OData:
	 *     - it works when loading data from the beginning because in this case the
	 *       model has the relevant information (distinct values) to determine the
	 *       count of rows and add them properly in the scrollbar as well as adding
	 *       the group information to the contexts array which is used by the
	 *       _modifyRow to display the group headers
	 *     - it doesn't work when not knowing how many groups are available before
	 *       and on which position the group header has to be added - e.g. when
	 *       displaying a snapshot in the middle of the model.
	 *   - For OData it might be a server-side feature?
	 */
	Table.prototype.getBinding = function(sName) {

		// default binding is the "rows" binding
		sName = sName || "rows";
		var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);

		// we do all the extended stuff only when grouping is enabled
		if (this.getEnableGrouping()) {

			// require the binding types (think about loading them only if required)
			jQuery.sap.require("sap.ui.model.ClientListBinding");

			// check for grouping being supported or not (only for client ListBindings!!)
			var oGroupBy = sap.ui.getCore().byId(this.getGroupBy());
			var bIsSupported = oGroupBy && oGroupBy.getGrouped() &&
			                   sName === "rows" && oBinding &&
			                   oBinding instanceof sap.ui.model.ClientListBinding;

			// only enhance the binding if it has not been done yet and supported!
			if (bIsSupported && !oBinding._modified) {

				// once the binding is modified we always return the modified binding
				// and don't wanna modifiy the binding once again
				oBinding._modified = true;

				// hook into the row modification and add the grouping specifics
				this._modifyRow = function(iRowIndex, $row) {

					// we add the style override to display the row header
					this.$().find(".sapUiTableRowHdrScr").css("display", "block");

					// modify the rows
					var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
					if (oBinding.isGroupHeader(iRowIndex)) {
						$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
						var sClass = oBinding.isExpanded(iRowIndex) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
						$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + oBinding.getTitle(iRowIndex) + "</div>");
						$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
					} else {
						$row.removeClass("sapUiTableGroupHeader");
						$rowHdr.html("");
						$rowHdr.removeClass("sapUiTableGroupHeader");
					}

				};

				this.onclick = function(oEvent) {
					if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
						var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
						if ($parent.length > 0) {
							var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
							var oBinding = this.getBinding("rows");
							if (oBinding.isExpanded(iRowIndex)) {
								oBinding.collapse(iRowIndex);
								jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
							} else {
								oBinding.expand(iRowIndex);
								jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
							}
						}
					} else {
						if (Table.prototype.onclick) {
							Table.prototype.onclick.apply(this, arguments);
						}
					}
				};

				// we use sorting finally to sort the values and afterwards group them
				var sPropertyName = oGroupBy.getSortProperty();
				oBinding.sort(new sap.ui.model.Sorter(sPropertyName));

				// fetch the contexts from the original binding
				var iLength = oBinding.getLength(),
					aContexts = oBinding.getContexts(0, iLength);

				// add the context information for the group headers which are later on
				// used for displaying the grouping information of each group
				var sKey;
				var iCounter = 0;
				for (var i = iLength - 1; i >= 0; i--) {
					var sNewKey = aContexts[i].getProperty(sPropertyName);
					if (!sKey) {
						sKey = sNewKey;
					}
					if (sKey !== sNewKey) {
						var oGroupContext = aContexts[i + 1].getModel().getContext("/sap.ui.table.GroupInfo" + i);
						oGroupContext.__groupInfo = {
							oContext: aContexts[i + 1],
							name: sKey,
							count: iCounter,
							groupHeader: true,
							expanded: true
						};
						aContexts.splice(i + 1, 0,
							oGroupContext
						);
						sKey = sNewKey;
						iCounter = 0;
					}
					iCounter++;
				}
				var oGroupContext = aContexts[0].getModel().getContext("/sap.ui.table.GroupInfo");
				oGroupContext.__groupInfo =	{
					oContext: aContexts[0],
					name: sKey,
					count: iCounter,
					groupHeader: true,
					expanded: true
				};
				aContexts.splice(0, 0,
					oGroupContext
				);

				// extend the binding and hook into the relevant functions to provide
				// access to the grouping information for the _modifyRow function
				jQuery.extend(oBinding, {
					getLength: function() {
						return aContexts.length;
					},
					getContexts: function(iStartIndex, iLength) {
						return aContexts.slice(iStartIndex, iStartIndex + iLength);
					},
					isGroupHeader: function(iIndex) {
						var oContext = aContexts[iIndex];
						return oContext && oContext.__groupInfo && oContext.__groupInfo.groupHeader;
					},
					getTitle: function(iIndex) {
						var oContext = aContexts[iIndex];
						return oContext && oContext.__groupInfo && oContext.__groupInfo.name + " - " + oContext.__groupInfo.count;
					},
					isExpanded: function(iIndex) {
						var oContext = aContexts[iIndex];
						return this.isGroupHeader(iIndex) && oContext.__groupInfo && oContext.__groupInfo.expanded;
					},
					expand: function(iIndex) {
						if (this.isGroupHeader(iIndex) && !aContexts[iIndex].__groupInfo.expanded) {
							for (var i = 0; i < aContexts[iIndex].__childs.length; i++) {
								aContexts.splice(iIndex + 1 + i, 0, aContexts[iIndex].__childs[i]);
							}
							delete aContexts[iIndex].__childs;
							aContexts[iIndex].__groupInfo.expanded = true;
							this._fireChange();
						}
					},
					collapse: function(iIndex) {
						if (this.isGroupHeader(iIndex) && aContexts[iIndex].__groupInfo.expanded) {
							aContexts[iIndex].__childs = aContexts.splice(iIndex + 1, aContexts[iIndex].__groupInfo.count);
							aContexts[iIndex].__groupInfo.expanded = false;
							this._fireChange();
						}
					}

				});

			}

		}

		return oBinding;

	};

	/**
	 * @private
	 */
	Table.prototype.resetGrouping = function() {

		// reset the group binding only when enhanced
		var oBinding = this.getBinding("rows");
		if (oBinding && oBinding._modified) {

			// we remove the style override to display the row header
			this.$().find(".sapUiTableRowHdrScr").css("display", "");

			// if the grouping is not supported we remove the hacks we did
			// and simply return the binding finally
			this.onclick = Table.prototype.onclick;
			this._modifyRow = undefined;

			// reset the binding
			var oBindingInfo = this.getBindingInfo("rows");
			this.unbindRows();
			this.bindRows(oBindingInfo);

		}

	};

	/**
	 * @private
	 */
	Table.prototype.setEnableGrouping = function(bEnableGrouping) {
		// set the property
		this.setProperty("enableGrouping", bEnableGrouping);
		// reset the grouping
		if (!bEnableGrouping) {
			this.resetGrouping();
		}
		// update the column headers
		this._invalidateColumnMenus();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setEnableCustomFilter = function(bEnableCustomFilter) {
		this.setProperty("enableCustomFilter", bEnableCustomFilter);
		// update the column headers
		this._invalidateColumnMenus();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setEnableColumnFreeze = function(bEnableColumnFreeze) {
		this.setProperty("enableColumnFreeze", bEnableColumnFreeze);
		this._invalidateColumnMenus();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setShowColumnVisibilityMenu = function(bShowColumnVisibilityMenu) {
		this.setProperty("showColumnVisibilityMenu", bShowColumnVisibilityMenu);
		this._invalidateColumnMenus();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFixedColumnCount = function(iFixedColumnCount) {
		var aCols = this._getVisibleColumns();
		var vHeaderSpan = aCols[iFixedColumnCount - 1] && aCols[iFixedColumnCount - 1].getHeaderSpan();
		if (vHeaderSpan) {
			var iHeaderSpan;
			if (jQuery.isArray(vHeaderSpan)) {
				iHeaderSpan = parseInt(vHeaderSpan[0], 10);
			} else {
				iHeaderSpan = parseInt(vHeaderSpan, 10);
			}
			iFixedColumnCount += iHeaderSpan - 1;
		}
		//Set current width as fixed width for cols
		var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
		for (var i = 0; i < iFixedColumnCount; i++) {
			var oColumn = aCols[i];
			if (oColumn) {
				var iColumnIndex = jQuery.inArray(oColumn, this.getColumns());
				if (!oColumn.getWidth()) {
					oColumn.setWidth($ths.filter("[data-sap-ui-headcolindex='" + iColumnIndex + "']").width() + "px");
				}
			}
		}
		this.setProperty("fixedColumnCount", iFixedColumnCount);
		this._invalidateColumnMenus();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFixedRowCount = function(iFixedRowCount) {
		if (!(parseInt(iFixedRowCount, 10) >= 0)) {
			jQuery.sap.log.error("Number of fixed rows must be greater or equal 0");
			return this;
		}

		if ((iFixedRowCount + this.getFixedBottomRowCount()) < this.getVisibleRowCount()) {
			this.setProperty("fixedRowCount", iFixedRowCount);
		} else {
			jQuery.sap.log.error("Table '" + this.getId() + "' fixed rows('" + (iFixedRowCount + this.getFixedBottomRowCount()) + "') must be smaller than numberOfVisibleRows('" + this.getVisibleRowCount() + "')");
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFixedBottomRowCount = function(iFixedRowCount) {
		if (!(parseInt(iFixedRowCount, 10) >= 0)) {
			jQuery.sap.log.error("Number of fixed bottom rows must be greater or equal 0");
			return this;
		}

		if ((iFixedRowCount + this.getFixedRowCount()) < this.getVisibleRowCount()) {
			this.setProperty("fixedBottomRowCount", iFixedRowCount);
		} else {
			jQuery.sap.log.error("Table '" + this.getId() + "' fixed rows('" + (iFixedRowCount + this.getFixedRowCount()) + "') must be smaller than numberOfVisibleRows('" + this.getVisibleRowCount() + "')");
		}
		return this;
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._invalidateColumnMenus = function() {
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			aCols[i].invalidateMenu();
		}
	};

	/**
	 * The selectstart event triggered in IE to select the text.
	 * @private
	 * @param {event} oEvent The splitterselectstart event
	 * @return {boolean} false
	 */
	Table.prototype._splitterSelectStart = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
		return false;
	};

	/**
	 * Checks whether the passed oEvent is a touch event.
	 * @private
	 * @param {event} oEvent The event to check
	 * @return {boolean} false
	 */
	Table.prototype._isTouchMode = function(oEvent) {
		return !!oEvent.originalEvent["touches"];
	};

	/**
	 * drops the splitter bar
	 * @private
	 */
	Table.prototype._onGhostMouseRelease = function(oEvent) {
		var splitterBarGhost = this.getDomRef("ghost");

		var iLocationY = this._isTouchMode(oEvent) ? oEvent.changedTouches[0].pageY : oEvent.pageY;
		var iNewHeight = iLocationY - this.$().offset().top;

	    this.setVisibleRowCount(this._calculateRowsToDisplay(iNewHeight));

		jQuery(splitterBarGhost).remove();
		this.$("overlay").remove();

		jQuery(document.body).unbind("selectstart", this._splitterSelectStart);

		var $Document = jQuery(document);
		$Document.unbind("touchend", this._onGhostMouseRelease);
		$Document.unbind("touchmove", this._onGhostMouseMove);
		$Document.unbind("mouseup", this._onGhostMouseRelease);
		$Document.unbind("mousemove", this._onGhostMouseMove);

		this._enableTextSelection();
	};

	/**
	 *
	 * @param oEvent
	 * @private
	 */
	Table.prototype._onGhostMouseMove = function(oEvent) {
		var splitterBarGhost = this.getDomRef("ghost");

		var iLocationY = this._isTouchMode(oEvent) ? oEvent.targetTouches[0].pageY : oEvent.pageY;
		var min = this.$().offset().top;
		if (iLocationY > min) {
			jQuery(splitterBarGhost).css("top", iLocationY + "px");
		}
	};

	/**
	 * Calculates the maximum rows to display within the table.
	 * @private
	 */
	Table.prototype._calculateRowsToDisplay = function(iHeight) {
		var iMinRowCount = this.getMinAutoRowCount() || 5;

		// If no iHeight is passed, return minimum row count.
		if (!iHeight) {
			return iMinRowCount;
		}

		var $this = this.$();
		if (!$this.get(0)) {
			return iMinRowCount;
		}

		var iUsedHeight = this._calculateUsedHeight($this.find('.sapUiTableCCnt'), $this);

		var aRows = this.getRows();
		if (!aRows.length) {
			return iMinRowCount;
		}

		var oDomRefs = aRows[0].getDomRefs(true);
		var $row = oDomRefs.rowFixedPart || oDomRefs.rowScrollPart;
		var iRowHeight = $row.outerHeight();

		// No rows displayed when visible row count == 0, no row height can be determined, therefore we set standard row height
		if (!iRowHeight) {
			var sRowHeightParamName = "sap.ui.table.Table:sapUiTableRowHeight";
			if ($this.parents().hasClass('sapUiSizeCompact')) {
				sRowHeightParamName = "sap.ui.table.Table:sapUiTableCompactRowHeight";
			}
			iRowHeight = parseInt(Parameters.get(sRowHeightParamName), 10);
		}

		// Maximum height of the table is the height of the window minus two row height, reserved for header and footer.
		var iMaxHeight = window.innerHeight - 2 * iRowHeight;
		var iCalculatedSpace = iHeight - iUsedHeight;

		// Make sure that table does not grow to infinity
		var iAvailableSpace = Math.min(iCalculatedSpace, iMaxHeight);

		// the last content row height is iRowHeight - 1, therefore + 1 in the formula below:
		// to avoid issues with having more fixed rows than visible row count, the number of visible rows must be
		// adjusted.
		return Math.max((this.getFixedRowCount() + this.getFixedBottomRowCount()) + 1, Math.max(iMinRowCount, Math.floor((iAvailableSpace + 1) / iRowHeight)));
	};

	/**
	 * Calculates the already used vertical space of the table which is blocked by other elements than the row content area.
	 * @private
	 * @param $element start element from which traversing begins
	 * @param $targetElement end element where traversing stops
	 * @returns {Number} the used height as a number
	 */
	Table.prototype._calculateUsedHeight = function($element, $targetElement) {
		if (!$element || $element.length == 0 || !$targetElement || $element.is($targetElement)) {
			return 0;
		}

		return Math.max(0, $targetElement.height() - $element.height());
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setShowNoData = function(bShowNoData) {
		this.setProperty('showNoData', bShowNoData, true);
		bShowNoData = this.getProperty('showNoData');
		if (!bShowNoData) {
			this.$().removeClass("sapUiTableEmpty");
		} else {
			this._updateNoData();
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setNoDataText = function(sText) {
		this.setProperty("noDataText", sText, true);
		this.$().find('.sapUiTableCtrlEmptyMsg').text(sText);
	};

	/**
	 * Creates a new {@link sap.ui.core.util.Export} object and fills row/column information from the table if not provided. For the cell content, the column's "sortProperty" will be used (experimental!)
	 *
	 * <p><b>Please note: The return value was changed from jQuery Promises to standard ES6 Promises.
	 * jQuery specific Promise methods ('done', 'fail', 'always', 'pipe' and 'state') are still available but should not be used.
	 * Please use only the standard methods 'then' and 'catch'!</b></p>
	 *
	 * @param {object} [mSettings] settings for the new Export, see {@link sap.ui.core.util.Export} <code>constructor</code>
	 * @return {Promise} Promise object
	 *
	 * @experimental Experimental because the property for the column/cell definitions (sortProperty) could change in future.
	 * @public
	 */
	Table.prototype.exportData = function(mSettings) {
		jQuery.sap.require("sap.ui.core.util.Export");

		mSettings = mSettings || {};

		if (!mSettings.rows) {
			var oBinding = this.getBinding("rows"),
				oBindingInfo = this.getBindingInfo("rows");

			var aFilters = oBinding.aFilters.concat(oBinding.aApplicationFilters);

			mSettings.rows = {
				path: oBindingInfo.path,
				model: oBindingInfo.model,
				sorter: oBinding.aSorters,
				filters: aFilters,
				parameters: oBindingInfo.parameters
			};
		}

		// by default we choose the export type CSV
		if (!mSettings.exportType) {
			jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");
			mSettings.exportType = new sap.ui.core.util.ExportTypeCSV();
		}

		var sModelName = mSettings.rows.model;
		if (!sModelName) {
			// if a model separator is found in the path, extract model name from there
			var sPath = mSettings.rows.path;
			var iSeparatorPos = sPath.indexOf(">");
			if (iSeparatorPos > 0) {
				sModelName = sPath.substr(0, iSeparatorPos);
			}
		}

		if (!mSettings.columns) {
			mSettings.columns = [];

			var aColumns = this.getColumns();
			for (var i = 0, l = aColumns.length; i < l; i++) {
				var oColumn = aColumns[i];
				if (oColumn.getSortProperty()) {
					mSettings.columns.push({
						name: oColumn.getLabel().getText(),
						template: {
							content: {
								path: oColumn.getSortProperty(),
								model: sModelName
							}
						}
					});
				}
			}
		}

		var oExport = new sap.ui.core.util.Export(mSettings);
		this.addDependent(oExport);

		return oExport;
	};

	/**
	 * internal function to calculate the widest content width of the column
	 * also takes the column header and potential icons into account
	 * @param {int} iColIndex index of the column which should be resized
	 * @return {int} minWidth minimum width the column needs to have
	 * @private
	 * @experimental Experimental, only works with a limited control set
	 * @function
	 */

	Table.prototype._calculateAutomaticColumnWidth = function(iColIndex) {

		var aTextBasedControls = [
			"sap.m.Text",
			"sap.m.Label",
			"sap.m.Link",
			"sap.ui.commons.TextView",
			"sap.ui.commons.Label",
			"sap.ui.commons.Link"
		];

		var $this = this.$();
		var iHeaderWidth = 0;

		var $cols = $this.find('td[headers=\"' + this.getId() + '_col' + iColIndex + '\"]').children("div");
		var oColumns = this.getColumns();
		var oCol = oColumns[iColIndex];
		if (!oCol) {
			return null;
		}
		var aHeaderSpan = oCol.getHeaderSpan();
		var oColLabel = oCol.getLabel();
		var that = this;

		var oColTemplate = oCol.getTemplate();
		var bIsTextBased = jQuery.inArray(oColTemplate.getMetadata().getName(), aTextBasedControls) != -1 ||
		                   sap.ui.commons && sap.ui.commons.TextField && oColTemplate instanceof sap.ui.commons.TextField ||
		                   sap.m && sap.m.Input && oColTemplate instanceof sap.m.Input;

		var hiddenSizeDetector = document.createElement("div");
		document.body.appendChild(hiddenSizeDetector);
		jQuery(hiddenSizeDetector).addClass("sapUiTableHiddenSizeDetector");

		var oColLabels = oCol.getMultiLabels();
		if (oColLabels.length == 0 && !!oColLabel){
			oColLabels = [oColLabel];
		}

		if (oColLabels.length > 0) {
			jQuery.each(oColLabels, function(iIdx, oLabel){
				var iHeaderSpan;
				if (!!oLabel.getText()){
					jQuery(hiddenSizeDetector).text(oLabel.getText());
					iHeaderWidth = hiddenSizeDetector.scrollWidth;
				} else {
					iHeaderWidth = oLabel.$().scrollWidth;
				}
				iHeaderWidth = iHeaderWidth + $this.find("#" + oCol.getId() + "-icons").first().width();

				$this.find(".sapUiTableColIcons#" + oCol.getId() + "_" + iIdx + "-icons").first().width();
				if (aHeaderSpan instanceof Array && aHeaderSpan[iIdx] > 1){
					iHeaderSpan = aHeaderSpan[iIdx];
				} else if (aHeaderSpan > 1){
					iHeaderSpan = aHeaderSpan;
				}
				if (!!iHeaderSpan){
					// we have a header span, so we need to distribute the width of this header label over more than one column
					//get the width of the other columns and subtract from the minwidth required from label side
					var i = iHeaderSpan - 1;
					while (i > iColIndex) {
						iHeaderWidth = iHeaderWidth - (that._oCalcColumnWidths[iColIndex + i] || 0);
						i -= 1;
					}
				}
			});
		}

		var minAddWidth = Math.max.apply(null, $cols.map(
			function(){
				var _$this = jQuery(this);
				return parseInt(_$this.css('padding-left'), 10) + parseInt(_$this.css('padding-right'), 10)
						+ parseInt(_$this.css('margin-left'), 10) + parseInt(_$this.css('margin-right'), 10);
			}).get());

		//get the max width of the currently displayed cells in this column
		var minWidth = Math.max.apply(null, $cols.children().map(
			function() {
				var width = 0,
				sWidth = 0;
				var _$this = jQuery(this);
				var sColText = _$this.text() || _$this.val();

				if (bIsTextBased){
					jQuery(hiddenSizeDetector).text(sColText);
					sWidth = hiddenSizeDetector.scrollWidth;
				} else {
					sWidth = this.scrollWidth;
				}
				if (iHeaderWidth > sWidth){
					sWidth = iHeaderWidth;
				}
				width = sWidth + parseInt(_$this.css('margin-left'), 10)
										+ parseInt(_$this.css('margin-right'), 10)
										+ minAddWidth
										+ 1; // ellipsis is still displayed if there is an equality of the div's width and the table column
				return width;
			}).get());

		jQuery(hiddenSizeDetector).remove();
		return Math.max(minWidth, this._iColMinWidth);
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._onPersoApplied = function() {

		// apply the sorter and filter again (right now only the first sorter is applied)
		var aColumns = this.getColumns();
		var aSorters = [];//, aFilters = [];
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumn = aColumns[i];
			if (oColumn.getSorted()) {
				aSorters.push(new sap.ui.model.Sorter(oColumn.getSortProperty(), oColumn.getSortOrder() === sap.ui.table.SortOrder.Descending));
			/*
			} else if (oColumn.getFiltered()) {
				aFilters.push(oColumn._getFilter());
			*/
			}
		}

		if (aSorters.length > 0 && this.getBinding("rows")) {
			this.getBinding("rows").sort(aSorters);
		}
		/*
		if (aFilters.length > 0 && this.getBinding("rows")) {
			this.getBinding("rows").filter(aFilters);
		}
		*/

		this.refreshRows();

	};

	/**
	 * Toggles the selection state of all cells.
	 * @private
	 */
	Table.prototype._toggleSelectAll = function() {

		if (!this.$("selall").hasClass("sapUiTableSelAll")) {
			this.clearSelection();
		} else {
			this.selectAll();
		}
		if (!!sap.ui.Device.browser.internet_explorer) {
			this.$("selall").focus();
		}
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._restoreAppDefaultsColumnHeaderSortFilter = function () {
		var aColumns = this.getColumns();
		jQuery.each(aColumns, function(iIndex, oColumn){
			oColumn._restoreAppDefaults();
		});
	};

	/**
	 *
	 * @param mParameters
	 * @private
	 */
	Table.prototype._setBusy = function (mParameters) {
		var oBinding,
			i,
			bSetBusy;

		if (!this.getEnableBusyIndicator() || !this._bBusyIndicatorAllowed) {
			return;
		}

		oBinding = this.getBinding("rows");
		if (!oBinding) {
			return;
		}

		this.setBusy(false);
		if (mParameters) {
			if (mParameters.contexts && mParameters.contexts.length !== undefined) {
				// TreeBinding and AnalyticalBinding always return a contexts array with the
				// requested length. Both put undefined in it for contexts which need to be loaded
				// Check for undefined in the contexts array.
				bSetBusy = false;
				for (i = 0; i < mParameters.contexts.length; i++) {
					if (mParameters.contexts[i] === undefined) {
						bSetBusy = true;
						break;
					}
				}
			} else if (mParameters.changeReason === ChangeReason.Expand) {
				this.setBusy(true);
			}

			var iLength = oBinding.getLength();
			if (bSetBusy || (oBinding.isInitial()) || (mParameters.receivedLength === 0 && this._iDataRequestedCounter !== 0) ||
				(mParameters.receivedLength < mParameters.requestedLength && mParameters.receivedLength !== iLength &&
				 mParameters.receivedLength !== iLength - this.getFirstVisibleRow())) {
				this.setBusy(true);
			}
		}
	};

	/*
	 * Prevents re-rendering, when enabling/disabling busy indicator.
	 * Avoids the request delays.
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setEnableBusyIndicator = function (bValue) {
		this.setProperty("enableBusyIndicator", bValue, true);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setColumnHeaderVisible = function(bColumnHeaderVisible) {
		this.setProperty("columnHeaderVisible", bColumnHeaderVisible);
		// Adapt the item navigation. Since the HeaderRowCount changed, also the lastSelectedDataRow changes.
		this._iLastSelectedDataRow = this._getHeaderRowCount();

	};

	/**
	 *
	 * @private
	 */
	Table.prototype._attachDataRequestedListeners = function () {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.detachDataRequested(this._onBindingDataRequestedListener, this);
			oBinding.detachDataReceived(this._onBindingDataReceivedListener, this);
			this._iDataRequestedCounter = 0;
			oBinding.attachDataRequested(this._onBindingDataRequestedListener, this);
			oBinding.attachDataReceived(this._onBindingDataReceivedListener, this);
		}
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._onBindingDataRequestedListener = function (oEvent) {
		if (oEvent.getSource() == this.getBinding("rows")) {
			this._iDataRequestedCounter++;
		}
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._onBindingDataReceivedListener = function (oEvent) {
		if (oEvent.getSource() == this.getBinding("rows")) {
			this._iDataRequestedCounter--;
		}
	};

	/**
	 *
	 * @private
	 */
	Table.prototype._attachBindingListener = function() {
		this._attachDataRequestedListeners();
	};

	/**
	 * Lets you control in which situation the <code>ScrollBar</code> fires scroll events.
	 *
	 * @param {boolean} bLargeDataScrolling Set to true to let the <code>ScrollBar</code> only fires scroll events when
	 * the scroll handle is released. No matter what the setting is, the <code>ScrollBar</code> keeps on fireing scroll events
	 * when the user scroll with the mousewheel or using touch
	 * @private
	 */
	Table.prototype._setLargeDataScrolling = function(bLargeDataScrolling) {
		if (this._oVSb) {
			this._oVSb._bLargeDataScrolling = !!bLargeDataScrolling;
		} else {
			jQuery.sap.log.error("Vertical Scrollbar wasn't initialized yet.");
		}
	};

	return Table;

}, /* bExport= */ true);

}; // end of sap/ui/table/Table.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTable') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.TreeTable.
jQuery.sap.declare('sap.ui.table.TreeTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.odata.ODataTreeBindingAdapter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.ClientTreeBindingAdapter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.TreeBindingCompatibilityAdapter'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeTable",['jquery.sap.global', './Table', 'sap/ui/model/odata/ODataTreeBindingAdapter', 'sap/ui/model/ClientTreeBindingAdapter', 'sap/ui/model/TreeBindingCompatibilityAdapter', './library'],
	function(jQuery, Table, ODataTreeBindingAdapter, ClientTreeBindingAdapter, TreeBindingCompatibilityAdapter, library) {
	"use strict";

	/**
	 * Constructor for a new TreeTable.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The TreeTable control provides a comprehensive set of features to display hierarchical data.
	 * @extends sap.ui.table.Table
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.TreeTable
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TreeTable = Table.extend("sap.ui.table.TreeTable", /** @lends sap.ui.table.TreeTable.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Flag to enable or disable expanding of first level.
			 */
			expandFirstLevel : {type : "boolean", defaultValue : false},

			/**
			 * If group mode is enable nodes with subitems are rendered as if they were group headers.
			 * This can be used to do the grouping for an OData service on the backend and visualize this in a table.
			 * This mode only makes sense if the tree has a depth of exacly 1 (group headers and entries)
			 */
			useGroupMode : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * The property name of the rows data which will be displayed as a group header if the group mode is enabled
			 */
			groupHeaderProperty : {type : "string", group : "Data", defaultValue : null},

			/**
			 * Setting collapseRecursive to true means, that when collapsing a node all subsequent child nodes will also be collapsed.
			 * This property is only supported with sap.ui.model.odata.v2.ODataModel
			 */
			collapseRecursive : {type: "boolean", defaultValue: true},

			/**
			 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
			 * This property is only supported when the TreeTable uses an underlying odata services with hierarchy annotations.
			 * This property is only supported with sap.ui.model.odata.v2.ODataModel
			 * The hierarchy annotations may also be provided locally as a parameter for the ODataTreeBinding.
			 */
			rootLevel : {type: "int", group: "Data", defaultValue: 0}
		},
		events : {

			/**
			 * fired when a node has been expanded or collapsed (only available in hierachical mode)
			 */
			toggleOpenState : {
				parameters : {

					/**
					 * index of the expanded/collapsed row
					 */
					rowIndex : {type : "int"},

					/**
					 * binding context of the selected row
					 */
					rowContext : {type : "object"},

					/**
					 * flag whether the node has been expanded or collapsed
					 */
					expanded : {type : "boolean"}
				}
			}
		}
	}});


	/**
	 * Initialization of the TreeTable control
	 * @private
	 */
	TreeTable.prototype.init = function() {
		Table.prototype.init.apply(this, arguments);
		this._iLastFixedColIndex = 0;

		// adopting properties and load icon fonts for bluecrystal
		if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal" ||
			sap.ui.getCore().getConfiguration().getTheme() === "sap_hcb") {

			// add the icon fonts
			jQuery.sap.require("sap.ui.core.IconPool");
			sap.ui.core.IconPool.insertFontFaceStyle();

			// defaulting the rowHeight
			// this.setRowHeight(32); --> is done via CSS

		}
	};

	TreeTable.prototype.bindRows = function(oBindingInfo, vTemplate, aSorters, aFilters) {
		var sPath,
			oTemplate,
			aSorters,
			aFilters;

		// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
		if (typeof oBindingInfo == "string") {
			sPath = arguments[0];
			oTemplate = arguments[1];
			aSorters = arguments[2];
			aFilters = arguments[3];
			oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters, template: oTemplate};
		}

		if (typeof oBindingInfo === "object") {
			oBindingInfo.parameters = oBindingInfo.parameters || {};
			oBindingInfo.parameters.rootLevel = this.getRootLevel();
			oBindingInfo.parameters.collapseRecursive = this.getCollapseRecursive();
			// number of expanded levels is taken from the binding parameters first,
			// if not found, we check if they are set on the table
			oBindingInfo.parameters.numberOfExpandedLevels = oBindingInfo.parameters.numberOfExpandedLevels || (this.getExpandFirstLevel() ? 1 : 0);
			oBindingInfo.parameters.rootNodeID = oBindingInfo.parameters.rootNodeID;
		}

		//return Table.prototype.bindRows.call(this, oBindingInfo, vTemplate, oSorter, aFilters);
		return this.bindAggregation("rows", oBindingInfo);
	};

	/**
	 * Sets the selection mode. The current selection is lost.
	 * @param {string} sSelectionMode the selection mode, see sap.ui.table.SelectionMode
	 * @public
	 * @return a reference on the table for chaining
	 */
	TreeTable.prototype.setSelectionMode = function (sSelectionMode) {
		var oBinding = this.getBinding("rows");
		if (oBinding && oBinding.clearSelection) {
			oBinding.clearSelection();
			this.setProperty("selectionMode", sSelectionMode);
		} else {
			Table.prototype.setSelectionMode.call(this, sSelectionMode);
		}
		return this;
	};

	/**
	 * refresh rows
	 * @private
	 */
	TreeTable.prototype.refreshRows = function(sReason) {
		this._bBusyIndicatorAllowed = true;
		this._attachBindingListener();
		var oBinding = this.getBinding("rows");
		if (oBinding && this.isTreeBinding("rows") && !oBinding.hasListeners("selectionChanged")) {
			oBinding.attachSelectionChanged(this._onSelectionChanged, this);
		}

		//needs to be called here to reset the firstVisible row so that the correct data is fetched
		this._bRefreshing = true;
		this._onBindingChange(sReason);
		this._updateBindingContexts(true);
		//this.getBinding()._init();
		this._bRefreshing = false;
	};

	/**
	 * Setter for property <code>fixedRowCount</code>.
	 *
	 * <b>This property is not supportd for the TreeTable and will be ignored!</b>
	 *
	 * Default value is <code>0</code>
	 *
	 * @param {int} iFixedRowCount  new value for property <code>fixedRowCount</code>
	 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
	 * @public
	 */
	TreeTable.prototype.setFixedRowCount = function(iRowCount) {
		// this property makes no sense for the TreeTable
		jQuery.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");
		return this;
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	TreeTable.prototype.onAfterRendering = function() {
		Table.prototype.onAfterRendering.apply(this, arguments);
		this.$().find("[role=grid]").attr("role", "treegrid");
	};

	TreeTable.prototype.isTreeBinding = function(sName) {
		sName = sName || "rows";
		if (sName === "rows") {
			return true;
		}
		return sap.ui.core.Element.prototype.isTreeBinding.apply(this, arguments);
	};

	TreeTable.prototype.getBinding = function(sName) {
		sName = sName || "rows";
		var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);

		// the check for the tree binding is only relevant becuase of the DataTable migration
		//  --> once the DataTable is deleted after the deprecation period this check can be deleted
		if (oBinding && this.isTreeBinding(sName) && sName === "rows" && !oBinding.getLength) {
			if (sap.ui.model.odata.ODataTreeBinding && oBinding instanceof sap.ui.model.odata.ODataTreeBinding) {
				// use legacy tree binding adapter
				TreeBindingCompatibilityAdapter(oBinding, this);
			} else if (sap.ui.model.odata.v2.ODataTreeBinding && oBinding instanceof sap.ui.model.odata.v2.ODataTreeBinding) {
				ODataTreeBindingAdapter.apply(oBinding);
			} else if (sap.ui.model.ClientTreeBinding && oBinding instanceof sap.ui.model.ClientTreeBinding) {
				ClientTreeBindingAdapter.apply(oBinding);
				//TreeBindingCompatibilityAdapter(oBinding, this);
			} else {
				jQuery.sap.log.error("Binding not supported by sap.ui.table.TreeTable");
			}
		}

		return oBinding;
	};

	TreeTable.prototype._updateTableContent = function() {
		Table.prototype._updateTableContent.apply(this, arguments);

		var oBinding = this.getBinding("rows"),
			iFirstRow = this.getFirstVisibleRow(),
			aRows = this.getRows(),
			iCount = aRows.length,
			iFixedBottomRowCount = this.getFixedBottomRowCount(),
			iFirstFixedBottomRowIndex = iCount - iFixedBottomRowCount;

		var iIndex = iFirstRow;
		if (oBinding) {
			var iBindingLength = oBinding.getLength();
			for (var iRow = 0; iRow < iCount; iRow++) {
				if (iFixedBottomRowCount > 0 && iRow >= iFirstFixedBottomRowIndex) {
					iIndex = iBindingLength - iCount + iRow;
				} else {
					iIndex = iFirstRow + iRow;
				}

				var oContext = this.getContextByIndex(iIndex),
					$DomRefs = aRows[iRow].getDomRefs(true),
					$row = $DomRefs.rowFixedPart || $DomRefs.rowScrollPart;

				this._updateExpandIcon($row, oContext, iIndex);

				if (this.getUseGroupMode()) {
					//If group mode is enabled nodes which have children are visualized as if they were group header
					var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
					if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
						// modify the rows
						$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
						var sClass = oBinding.isExpanded(iFirstRow + iRow) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
						$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + this.getModel().getProperty(this.getGroupHeaderProperty(), oContext) + "</div>");
						$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
					} else {
						$row.removeClass("sapUiTableGroupHeader");
						if (oContext) {
							$row.removeClass("sapUiTableRowHidden");
						}
						$rowHdr.html("");
						$rowHdr.removeClass("sapUiTableGroupHeader");
					}
				}
			}
		}
	};

	TreeTable.prototype._updateTableCell = function () {
		return true;
	};

	TreeTable.prototype._updateExpandIcon = function($row, oContext, iAbsoluteRowIndex) {

		var oBinding = this.getBinding("rows");

		if (oBinding) {
			var iLevel = 0,
				bIsExpanded = false;

			if (oBinding.getLevel) {
				//used by the "mini-adapter" in the TreeTable ClientTreeBindings
				iLevel = oBinding.getLevel(oContext);
				bIsExpanded = oBinding.isExpanded(iAbsoluteRowIndex);
			} else if (oBinding.findNode) { // the ODataTreebinding(Adapter) provides the hasChildren method for Tree
				var oNode = oBinding.findNode(iAbsoluteRowIndex);
				iLevel = oNode ? oNode.level : 0;
				bIsExpanded = oNode && oNode.nodeState ? oNode.nodeState.expanded : false;
			}

			var $TreeIcon = $row.find(".sapUiTableTreeIcon");
			var sTreeIconClass = "sapUiTableTreeIconLeaf";
			var $FirstTd = $row.children("td.sapUiTableTdFirst");
			if (!this.getUseGroupMode()) {
				if (this._bRtlMode === true) {
					$TreeIcon.css("marginRight", iLevel * 17);
				} else {
					$TreeIcon.css("marginLeft", iLevel * 17);
				}
			}
			if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
				sTreeIconClass = bIsExpanded ? "sapUiTableTreeIconNodeOpen" : "sapUiTableTreeIconNodeClosed";
				$FirstTd.attr('aria-expanded', bIsExpanded);
				var sNodeText = bIsExpanded ? this._oResBundle.getText("TBL_COLLAPSE") : this._oResBundle.getText("TBL_EXPAND");
				$TreeIcon.attr('title', sNodeText);
			} else {
				$FirstTd.attr('aria-expanded', false);
				$TreeIcon.attr('aria-label', this._oResBundle.getText("TBL_LEAF"));
			}
			$TreeIcon.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(sTreeIconClass);
			$row.attr("data-sap-ui-level", iLevel);
			$FirstTd.attr('aria-level', iLevel + 1);
		}

	};

	TreeTable.prototype.onclick = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
			this._onGroupSelect(oEvent);
		} else if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
			this._onNodeSelect(oEvent);
		} else {
			if (Table.prototype.onclick) {
				Table.prototype.onclick.apply(this, arguments);
			}
		}
	};

	TreeTable.prototype.onsapselect = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
			this._onNodeSelect(oEvent);
		} else {
			if (Table.prototype.onsapselect) {
				Table.prototype.onsapselect.apply(this, arguments);
			}
		}
	};

	TreeTable.prototype.onkeydown = function(oEvent) {
		Table.prototype.onkeydown.apply(this, arguments);
		var $Target = jQuery(oEvent.target),
			$TargetTD = $Target.closest('td');
		if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode && $TargetTD.find('.sapUiTableTreeIcon').length > 0) {
			//If node icon has focus set tab to control else set tab to node icon
			if ($Target.hasClass('sapUiTableTreeIcon')) {
				if (!$Target.hasClass("sapUiTableTreeIconLeaf")) {
					$TargetTD.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();
				}
			} else {
				$TargetTD.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();
			}
			oEvent.preventDefault();
		}
	};

	TreeTable.prototype._onNodeSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parents("tr");
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oContext = this.getContextByIndex(iRowIndex);
			this.fireToggleOpenState({
				rowIndex: iRowIndex,
				rowContext: oContext,
				expanded: !this.getBinding().isExpanded(iRowIndex)
			});
			//this.getBinding("rows").toggleContext(oContext);
			this.getBinding("rows").toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	TreeTable.prototype._onGroupSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oContext = this.getContextByIndex(iRowIndex);
			if (this.getBinding().isExpanded(iRowIndex)) {
				jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
			} else {
				jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
			}
			this.fireToggleOpenState({
				rowIndex: iRowIndex,
				rowContext: oContext,
				expanded: !this.getBinding().isExpanded(iRowIndex)
			});
			//this.getBinding("rows").toggleContext(iRowIndex);
			this.getBinding("rows").toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	/**
	 * expands the row for the given row index
	 *
	 * @param {int} iRowIndex
	 *         index of the row to expand
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.expand = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.expand(iRowIndex);
		}

		return this;
	};

	/**
	 * collapses the row for the given row index
	 *
	 * @param {int} iRowIndex
	 *         index of the row to collapse
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.collapse = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapse(iRowIndex);
		}

		return this;
	};

	/**
	 * Collapses all nodes (and lower if collapseRecursive is activated)
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.collapseAll = function () {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapseToLevel(0);
			this.setFirstVisibleRow(0);
		}

		return this;
	};

	/**
	 * Expands all nodes starting from the root level to the given level 'iLevel'.
	 *
	 * Only supported with ODataModel v2, when running in OperationMode.Client or OperationMode.Auto.
	 * Fully supported for <code>sap.ui.model.ClientTreeBinding</code>, e.g. if you are using a <code>sap.ui.model.json.JSONModel</code>.
	 *
	 * Please also see <code>sap.ui.model.odata.OperationMode</code>.
	 *
	 * @param {int} iLevel the level to which the trees shall be expanded
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.expandToLevel = function (iLevel) {
		var oBinding = this.getBinding("rows");

		jQuery.sap.assert(oBinding && oBinding.expandToLevel, "TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");

		if (oBinding && oBinding.expandToLevel) {
			oBinding.expandToLevel(iLevel);
		}

		return this;
	};

	/**
	 * Returns whether the row is expanded or collapsed.
	 *
	 * @param {int} iRowIndex index of the row to check
	 * @return {boolean} true if the node at "iRowIndex" is expanded, false otherwise (meaning it is collapsed)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.isExpanded = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.isExpanded(iRowIndex);
		}
		return false;
	};

	/**
	 * Checks if the row at the given index is selected.
	 *
	 * @param {int} iRowIndex The row index for which the selection state should be retrieved
	 * @return {boolean} true if the index is selected, false otherwise
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.isIndexSelected = function (iRowIndex) {
		var oBinding = this.getBinding("rows");
		//when using the treebindingadapter, check if the node is selected
		if (oBinding && oBinding.isIndexSelected) {
			return oBinding.isIndexSelected(iRowIndex);
		} else {
			return Table.prototype.isIndexSelected.call(this, iRowIndex);
		}
	};

	/**
	 * Overriden from Table.js base class.
	 * In a TreeTable you can only select indices, which correspond to the currently visualized tree.
	 * Invisible tree nodes (e.g. collapsed child nodes) can not be selected via Index, because they do not
	 * correspond to a TreeTable row.
	 *
	 * @param {int} iRowIndex The row index which will be selected (if existing)
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.setSelectedIndex = function (iRowIndex) {
		if (iRowIndex === -1) {
			//If Index eq -1 no item is selected, therefore clear selection is called
			//SelectionModel doesn't know that -1 means no selection
			this.clearSelection();
		}

		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");

		if (oBinding && oBinding.findNode && oBinding.setNodeSelection) {
			// set the found node as selected
			oBinding.setSelectedIndex(iRowIndex);
			//this.fireEvent("selectionChanged");
		} else {
			Table.prototype.setSelectedIndex.call(this, iRowIndex);
		}
		return this;
	};

	/**
	 * Returns an array containing the row indices of all selected tree nodes (ordered ascending).
	 *
	 * Please be aware of the following:
	 * Due to performance/network traffic reasons, the getSelectedIndices function returns only all indices
	 * of actually selected rows/tree nodes. Unknown rows/nodes (as in "not yet loaded" to the client), will not be
	 * returned.
	 *
	 * @return {int[]} an array containing all selected indices
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.getSelectedIndices = function () {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");

		if (oBinding && oBinding.findNode && oBinding.getSelectedIndices) {
			/*jQuery.sap.log.warning("When using a TreeTable on a V2 ODataModel, you can also use 'getSelectedContexts' on the underlying TreeBinding," +
					" for an optimised retrieval of the binding contexts of the all selected rows/nodes.");*/
			return oBinding.getSelectedIndices();
		} else {
			return Table.prototype.getSelectedIndices.call(this);
		}
	};

	/**
	 * Sets the selection of the TreeTable to the given range (including boundaries).
	 * Beware: The previous selection will be lost/overriden. If this is not wanted, please use "addSelectionInterval" and
	 * "removeSelectionIntervall".
	 *
	 * @param {int} iFromIndex the start index of the selection range
	 * @param {int} iToIndex the end index of the selection range
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.setSelectionInterval = function (iFromIndex, iToIndex) {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");

		if (oBinding && oBinding.findNode && oBinding.setSelectionInterval) {
			oBinding.setSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.setSelectionInterval.call(this, iFromIndex, iToIndex);
		}

		return this;
	};

	/**
	 * Marks a range of tree nodes as selected, starting with iFromIndex going to iToIndex.
	 * The TreeNodes are referenced via their absolute row index.
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 *
	 * Please also take notice of the fact, that "addSelectionInterval" does not change any other selection.
	 * To override the current selection, please use "setSelctionInterval" or for a single entry use "setSelectedIndex".
	 *
	 * @param {int} iFromIndex The starting index of the range which will be selected.
	 * @param {int} iToIndex The starting index of the range which will be selected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.addSelectionInterval = function (iFromIndex, iToIndex) {
		var oBinding = this.getBinding("rows");
		//TBA check
		if (oBinding && oBinding.findNode && oBinding.addSelectionInterval) {
			oBinding.addSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.addSelectionInterval.call(this, iFromIndex, iToIndex);
		}
		return this;
	};

	/**
	 * All rows/tree nodes inside the range (including boundaries) will be deselected.
	 * Tree nodes are referenced with theit absolute row index inside the tree-
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 *
	 * @param {int} iFromIndex The starting index of the range which will be deselected.
	 * @param {int} iToIndex The starting index of the range which will be deselected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.removeSelectionInterval = function (iFromIndex, iToIndex) {
		var oBinding = this.getBinding("rows");
		//TBA check
		if (oBinding && oBinding.findNode && oBinding.removeSelectionInterval) {
			oBinding.removeSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.removeSelectionInterval.call(this, iFromIndex, iToIndex);
		}
		return this;
	};

	/**
	 * Selects all available nodes/rows.
	 *
	 * Explanation of the SelectAll function and what to expect from its behavior:
	 * All rows/tree nodes locally stored on the client are selected.
	 * In addition all subsequent rows/tree nodes, which will be paged into view are also immediatly selected.
	 * However, due to obvious performance/network traffic reasons, the SelectAll function will NOT retrieve any data from the backend.
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.selectAll = function () {
		//select all is only allowed when SelectionMode is "Multi" or "MultiToggle"
		var oSelMode = this.getSelectionMode();
		if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle") || !this._getSelectableRowCount()) {
			return this;
		}

		//The OData TBA exposes a selectAll function
		var oBinding = this.getBinding("rows");
		if (oBinding.selectAll) {
			oBinding.selectAll();
			this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
		} else {
			//otherwise fallback on the tables own function
			Table.prototype.selectAll.call(this);
		}

		return this;
	};

	/**
	 * Retrieves the lead selection index. The lead selection index is, among other things, used to determine the
	 * start/end of a selection range, when using Shift-Click to select multiple entries at once.
	 *
	 * @return {int[]} an array containing all selected indices (ascending ordered integers)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.getSelectedIndex = function() {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");

		if (oBinding && oBinding.findNode) {
			return oBinding.getSelectedIndex();
		} else {
			return Table.prototype.getSelectedIndex.call(this);
		}
	};

	/**
	 * Clears the complete selection (all tree table rows/nodes will lose their selection)
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.clearSelection = function () {
		var oBinding = this.getBinding("rows");

		if (oBinding && oBinding.clearSelection) {
			oBinding.clearSelection();
		} else {
			Table.prototype.clearSelection.call(this);
		}

		return this;
	};

	TreeTable.prototype._enterActionMode = function($Tabbable) {
		var $domRef = $Tabbable.eq(0);

		Table.prototype._enterActionMode.apply(this, arguments);
		if ($Tabbable.length > 0 && $domRef.hasClass("sapUiTableTreeIcon") && !$domRef.hasClass("sapUiTableTreeIconLeaf")) {
			//Set tabindex to 0 to have make node icon accessible
			$domRef.attr("tabindex", 0).focus();
			//set action mode to true so that _leaveActionMode is called to remove the tabindex again
			this._bActionMode = true;
		}
	};

	TreeTable.prototype._leaveActionMode = function(oEvent) {
		Table.prototype._leaveActionMode.apply(this, arguments);
		this.$().find(".sapUiTableTreeIcon").attr("tabindex", -1);
	};

	TreeTable.prototype.getContextByIndex = function (iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.getContextByIndex(iRowIndex);
		}
	};

	/**
	 * Set the rootLevel for the hierarchy
	 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
	 * This setting has only effect when the binding is already initialized.
	 * @param {int} iRootLevel
	 * @returns {TreeTable}
	 */
	TreeTable.prototype.setRootLevel = function(iRootLevel) {
		this.setFirstVisibleRow(0);

		var oBinding = this.getBinding("rows");
		if (oBinding) {
			jQuery.sap.assert(oBinding.setRootLevel, "rootLevel is not supported by the used binding");
			if (oBinding.setRootLevel) {
				oBinding.setRootLevel(iRootLevel);
			}
		}
		this.setProperty("rootLevel", iRootLevel, true);

		return this;
	};

	/**
	 * Sets the node hierarchy to collapse recursive. When set to true, all child nodes will get collapsed as well.
	 * This setting has only effect when the binding is already initialized.
	 * @param {boolean} bCollapseRecursive
	 */
	TreeTable.prototype.setCollapseRecursive = function(bCollapseRecursive) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			jQuery.sap.assert(oBinding.setCollapseRecursive, "Collapse Recursive is not supported by the used binding");
			if (oBinding.setCollapseRecursive) {
				oBinding.setCollapseRecursive(bCollapseRecursive);
			}
		}
		this.setProperty("collapseRecursive", !!bCollapseRecursive, true);
		return this;
	};

	return TreeTable;

}, /* bExport= */ true);

}; // end of sap/ui/table/TreeTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumn') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalColumn.
jQuery.sap.declare('sap.ui.table.AnalyticalColumn'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumn",['jquery.sap.global', './Column', './library'],
	function(jQuery, Column, library) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalColumn.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This column addes additional properties to the tabl ecolumn which are needed for the analytical binding and table
	 * @extends sap.ui.table.Column
	 *
	 * @author SAP SE
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.21.
	 * The AnalyticalColumn will be productized soon. Some attributes will be added to Column.
	 * @alias sap.ui.table.AnalyticalColumn
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalColumn = Column.extend("sap.ui.table.AnalyticalColumn", /** @lends sap.ui.table.AnalyticalColumn.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Defines the primary model property which is used inside the Column. In case of the analytical extension this means the property which is grouped by for dimensions or the property which is summed for measures.
			 */
			leadingProperty : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * If defined a sum for this column is calculated
			 */
			summed : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Specifies that the dimension referred to by the column shall be included in the granularity of the data result. It allows a finer distinction between a visible/grouped/(included)inResult column.
			 */
			inResult : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Specifies whether the column is displayed within the table even if it is grouped or not. A grouped column has the same value for every rows within the group.
			 */
			showIfGrouped : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * If the column is grouped, this formatter is used to format the value in the group header
			 */
			groupHeaderFormatter : {type : "any", group : "Behavior", defaultValue : null}
		}
	}});

	AnalyticalColumn.prototype.init = function() {
		Column.prototype.init.apply(this, arguments);
		this._bSkipUpdateAI = false;
	};

	/**
	 * map of filtertypes for re-use in getFilterType
	 * @private
	 */
	AnalyticalColumn._DEFAULT_FILTERTYPES = {
		"Time": new sap.ui.model.type.Time({UTC: true}),
		"DateTime": new sap.ui.model.type.DateTime({UTC: true}),
		"Float": new sap.ui.model.type.Float(),
		"Integer": new sap.ui.model.type.Integer(),
		"Boolean": new sap.ui.model.type.Boolean()
	};

	/*
	 * Factory method. Creates the column menu.
	 *
	 * @return {sap.ui.table.AnalyticalColumnMenu} The created column menu.
	 */
	AnalyticalColumn.prototype._createMenu = function() {
		jQuery.sap.require("sap.ui.table.AnalyticalColumnMenu");
		return new sap.ui.table.AnalyticalColumnMenu(this.getId() + "-menu");
	};

	AnalyticalColumn.prototype.setGrouped = function(bGrouped) {
		var oParent = this.getParent();
		var that = this;
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			if (bGrouped) {
				oParent._addGroupedColumn(this.getId());
			} else {
				oParent._aGroupedColumns = jQuery.grep(oParent._aGroupedColumns, function(value) {
					return value != that.getId();
				});
			}
		}

		var bReturn = this.setProperty("grouped", bGrouped);
		this._updateTableColumnDetails();
		this._updateTableAnalyticalInfo(true);
		return bReturn;
	};

	AnalyticalColumn.prototype.setSummed = function(bSummed) {
		var bReturn = this.setProperty("summed", bSummed, true);
		this._updateTableAnalyticalInfo();
		return bReturn;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.setVisible = function(bVisible) {
		Column.prototype.setVisible.apply(this, arguments);
		this._updateTableColumnDetails();
		this._updateTableAnalyticalInfo();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getLabel = function() {
		var oLabel = this.getAggregation("label");
		if (!oLabel) {
			if (!this._oBindingLabel) {
				var oParent = this.getParent();
				if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
					var oBinding = oParent.getBinding("rows");
					if (oBinding) {
						this._oBindingLabel = sap.ui.table.TableHelper.createLabel();
						var oModel = oBinding.getModel();
						// if the metadata of the underlying odatamodel is not yet loaded -> the setting of the text of the label must be delayed
						if (oModel.oMetadata && oModel.oMetadata.isLoaded()) {
							this._oBindingLabel.setText(oBinding.getPropertyLabel(this.getLeadingProperty()));
						} else {
							var that = this;
							oModel.attachMetadataLoaded(function () {
								that._oBindingLabel.setText(oBinding.getPropertyLabel(that.getLeadingProperty()));
							});
						}
					}
				}
			}
			oLabel = this._oBindingLabel;
		}
		return oLabel;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getFilterProperty = function() {
		var sProperty = this.getProperty("filterProperty");
		if (!sProperty) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty();
				if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getFilterablePropertyNames()) > -1) {
					sProperty = sLeadingProperty;
				}
			}
		}
		return sProperty;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getSortProperty = function() {
		var sProperty = this.getProperty("sortProperty");
		if (!sProperty) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty();
				if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getSortablePropertyNames()) > -1) {
					sProperty = sLeadingProperty;
				}
			}
		}
		return sProperty;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getFilterType = function() {
		var vFilterType = this.getProperty("filterType");
		if (!vFilterType) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty(),
				    oProperty = oBinding && oBinding.getProperty(sLeadingProperty);
				if (oProperty) {
					switch (oProperty.type) {
						case "Edm.Time":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Time"];
							break;
						case "Edm.DateTime":
						case "Edm.DateTimeOffset":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["DateTime"];
							break;
						case "Edm.Single":
						case "Edm.Double":
						case "Edm.Decimal":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Float"];
							break;
						case "Edm.SByte":
						case "Edm.Int16":
						case "Edm.Int32":
						case "Edm.Int64":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Integer"];
							break;
						case "Edm.Boolean":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Boolean"];
							break;
					}
				}
			}
		}
		return vFilterType;
	};

	AnalyticalColumn.prototype._afterSort = function() {
		this._updateTableAnalyticalInfo();
	};

	AnalyticalColumn.prototype._updateTableAnalyticalInfo = function(bSupressRefresh) {
		if (this._bSkipUpdateAI) {
			return;
		}

		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			oParent.updateAnalyticalInfo(bSupressRefresh);
		}
	};

	AnalyticalColumn.prototype._updateTableColumnDetails = function() {
		if (this._bSkipUpdateAI) {
			return;
		}

		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			oParent._updateTableColumnDetails();
		}
	};

	AnalyticalColumn.prototype.shouldRender = function() {
		if (!this.getVisible()) {
			return false;
		}
		return (!this.getGrouped() || this._bLastGroupAndGrouped || this.getShowIfGrouped()) && (!this._bDependendGrouped || this._bLastGroupAndGrouped);
	};

	AnalyticalColumn.prototype.getTooltip_AsString = function() {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			if (oBinding && this.getLeadingProperty()) {
				return oBinding.getPropertyQuickInfo(this.getLeadingProperty());
			}
		}
		return sap.ui.core.Element.prototype.getTooltip_AsString.apply(this);
	};

	/**
	 * Checks whether or not the menu has items
	 * @return {Boolean} True if the menu has or could have items.
	 */
	AnalyticalColumn.prototype._menuHasItems = function() {
		var fnMenuHasItems = function() {
			var oTable = this.getParent();
			var oBinding = oTable.getBinding("rows");
			var oResultSet = oBinding && oBinding.getAnalyticalQueryResult();
			return  (oTable && oResultSet && oResultSet.findMeasureByPropertyName(this.getLeadingProperty())); // totals menu entry
		}.bind(this);

		return Column.prototype._menuHasItems.apply(this) || fnMenuHasItems();
	};

	/**
	 * This function checks whether a filter column menu item will be created. This function considers
	 * several column properties and evaluates metadata to determine whether filtering for a column is applicable.
	 * Since for the AnalyticalBinding metadata is very important to determine whether the column can be filtered it
	 * is required to have a binding. If there is no binding, this function will return false.
	 *
	 * For Analytical Columns the following applies:
	 * - filterProperty must be defined or it must be possible to derive it from the leadingProperty + filterable = true in the metadata
	 * - showFilterMenuEntry must be true (which is the default)
	 * - The filter property must be a property of the bound collection however it may differ from the leading property
	 * - With OData v1 and v2 the filter property must not be a measure
	 * - The analytical column must be a child of an AnalyticalTable
	 *
	 * @returns {boolean}
	 */
	AnalyticalColumn.prototype.isFilterableByMenu = function() {
		var sFilterProperty = this.getFilterProperty();
		if (!sFilterProperty || !this.getShowFilterMenuEntry()) {
			// not required to get binding and do addtional checks if there is no filterProperty set or derived
			// or if the filter menu entry shall not be displayed at all
			return false;
		}

		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			// metadata must be evaluated which can only be done when the collection is known and the metadata is loaded
			// this is usually the case when a binding exists.
			if (oBinding) {
				// OData v2 does not allow to proper filter for measures
				if (jQuery.inArray(sFilterProperty, oBinding.getFilterablePropertyNames()) > -1 &&
					!oBinding.isMeasure(sFilterProperty) &&
					oBinding.getProperty(sFilterProperty)) {
					return true;
				}
			}
		}

		return false;
	};

	/**
	 * This function checks whether a grouping column menu item will be created.
	 *
	 * Since a property of the table must be checked, this function will return false when the column is not a child of a table.
	 *
	 * For Columns the following applies:
	 * - table must be bound
	 * - column must be child of an AnalyticalTable
	 * - metadata must be loaded
	 * - leadingProperty must be sortable
	 * - leadingProperty must be filterable
	 *
	 * @returns {boolean}
	 */
	AnalyticalColumn.prototype.isGroupableByMenu = function() {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			if (oBinding) {
				var oResultSet = oBinding.getAnalyticalQueryResult();
				if (oResultSet && oResultSet.findDimensionByPropertyName(this.getLeadingProperty())
					&& jQuery.inArray(this.getLeadingProperty(), oBinding.getSortablePropertyNames()) > -1
					&& jQuery.inArray(this.getLeadingProperty(), oBinding.getFilterablePropertyNames()) > -1) {
					return true;
				}
			}
		}

		return false;
	};

	return AnalyticalColumn;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumn.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenu') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalColumnMenu.
jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumnMenu",['jquery.sap.global', './ColumnMenu', './library'],
	function(jQuery, ColumnMenu, library) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalColumnMenu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A column menu which is used by the analytical column
	 * @extends sap.ui.table.ColumnMenu
	 *
	 * @author SAP SE
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.21.
	 * The AnalyticalColumnMenu will be productized soon.
	 * @alias sap.ui.table.AnalyticalColumnMenu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalColumnMenu = ColumnMenu.extend("sap.ui.table.AnalyticalColumnMenu", /** @lends sap.ui.table.AnalyticalColumnMenu.prototype */ { metadata : {

		library : "sap.ui.table"
	}});

	AnalyticalColumnMenu.prototype.init = function() {
		ColumnMenu.prototype.init.apply(this);
	};

	/**
	 * Adds the menu items to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addMenuItems = function() {
		// when you add or remove menu items here, remember to update the hasItems function
		ColumnMenu.prototype._addMenuItems.apply(this);
		if (this._oColumn) {
			this._addSumMenuItem();
		}
	};

	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addGroupMenuItem = function() {
		var oColumn = this._oColumn,
			oTable = this._oTable;

		if (oColumn.isGroupableByMenu()) {
			this._oGroupIcon = this._createMenuItem(
				"group",
				"TBL_GROUP",
				oColumn.getGrouped() ? "accept" : null,
				jQuery.proxy(function(oEvent) {
					var oMenuItem = oEvent.getSource(),
						bGrouped = oColumn.getGrouped();

					oColumn.setGrouped(!bGrouped);
					oTable.fireGroup({column: oColumn, groupedColumns: oTable._aGroupedColumns, type: sap.ui.table.GroupEventType.group});
					oMenuItem.setIcon(!bGrouped ? "sap-icon://accept" : null);
				}, this)
			);
			this.addItem(this._oGroupIcon);
		}
	};

	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addSumMenuItem = function() {
		var oColumn = this._oColumn,
			oTable = this._oTable,
			oBinding = oTable.getBinding("rows"),
			oResultSet = oBinding && oBinding.getAnalyticalQueryResult();

		if (oTable && oResultSet && oResultSet.findMeasureByPropertyName(oColumn.getLeadingProperty())) {
			this._oSumItem = this._createMenuItem(
				"total",
				"TBL_TOTAL",
				oColumn.getSummed() ? "accept" : null,
				jQuery.proxy(function(oEvent) {
					var oMenuItem = oEvent.getSource(),
						bSummed = oColumn.getSummed();

					oColumn.setSummed(!bSummed);
					oMenuItem.setIcon(!bSummed ? "sap-icon://accept" : null);
				}, this)
			);
			this.addItem(this._oSumItem);
		}
	};


	AnalyticalColumnMenu.prototype.open = function() {
		ColumnMenu.prototype.open.apply(this, arguments);

		var oColumn = this._oColumn;
		this._oSumItem && this._oSumItem.setIcon(oColumn.getSummed() ? "sap-icon://accept" : null);
		this._oGroupIcon && this._oGroupIcon.setIcon(oColumn.getGrouped() ? "sap-icon://accept" : null);
	};

	return AnalyticalColumnMenu;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalTable.
jQuery.sap.declare('sap.ui.table.AnalyticalTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.analytics.ODataModelAdapter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalTable",['jquery.sap.global', './AnalyticalColumn', './Table', './TreeTable', './library', 'sap/ui/model/analytics/ODataModelAdapter', 'sap/ui/core/IconPool'],
	function(jQuery, AnalyticalColumn, Table, TreeTable, library, ODataModelAdapter, IconPool) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalTable.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Table which handles analytical OData backends. The AnalyticalTable only works with an AnalyticalBinding and
	 * correctly annotated OData services. Please check on the SAP Annotations for OData Version 2.0 documentation for further details.
	 * @see http://scn.sap.com/docs/DOC-44986
	 *
	 * @extends sap.ui.table.Table
	 * @version 1.36.5
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.AnalyticalTable
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalTable = Table.extend("sap.ui.table.AnalyticalTable", /** @lends sap.ui.table.AnalyticalTable.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Specifies if the total values should be displayed in the group headers or on bottom of the row. Does not affact the total sum.
			 */
			sumOnTop : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Number of levels, which should be opened initially (on first load of data).
			 */
			numberOfExpandedLevels : {type : "int", group : "Misc", defaultValue : 0},

			/**
			 * The kind of auto expansion algorithm, e.g. optimised filter conditions, per level requests, ...
			 * sap.ui.table.TreeAutoExpandMode
			 */
			autoExpandMode: {type: "string", group: "Misc", defaultValue: "Bundled" },

			/**
			 * Functions which is used to sort the column visibility menu entries e.g.: function(ColumnA, ColumnB) { return 0 = equals, <0 lower, >0 greater }; Other values than functions will be ignored.
			 */
			columnVisibilityMenuSorter : {type : "any", group : "Appearance", defaultValue : null},

			/**
			 * Setting collapseRecursive to true means, that when collapsing a node all subsequent child nodes will also be collapsed.
			 */
			collapseRecursive : {type: "boolean", defaultValue: true},

			/**
			 * If dirty the content of the Table will be overlayed.
			 * @deprecated Since version 1.21.2.
			 * Please use setShowOverlay instead.
			 */
			dirty : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true}
		}
	}});


	// =====================================================================
	// WE START WITH A COPY OF THE TREETABLE AND REFACTOR THE CODING!
	// =====================================================================

	/**
	 * This function retrieves the grand total context, in case of an analytical table
	 * Overidden from Table.js
	 * @overrides
	 */
	AnalyticalTable.prototype._getFixedBottomRowContexts = function (oBinding) {
		return oBinding.getGrandTotalContext();
	};

	/**
	 * Initialization of the AnalyticalTable control
	 * @private
	 */
	AnalyticalTable.prototype.init = function() {
		Table.prototype.init.apply(this, arguments);

		this.addStyleClass("sapUiAnalyticalTable");

		this.attachBrowserEvent("contextmenu", this._onContextMenu);

		// defaulting properties
		this.setSelectionMode(sap.ui.table.SelectionMode.MultiToggle);
		this.setShowColumnVisibilityMenu(true);
		this.setEnableColumnFreeze(true);
		this.setEnableCellFilter(true);
		this._aGroupedColumns = [];

		// adopting properties and load icon fonts for bluecrystal
		if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal") {

			// add the icon fonts
			jQuery.sap.require("sap.ui.core.IconPool");
			sap.ui.core.IconPool.insertFontFaceStyle();

			// defaulting the rowHeight -> is set via CSS
		}
	};

	AnalyticalTable.prototype.setFixedRowCount = function() {
		jQuery.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");
		return this;
	};

	AnalyticalTable.prototype.setFixedBottomRowCount = function() {
		jQuery.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");
		return this;
	};

	/**
	 * Rerendering handling
	 * @private
	 */
	AnalyticalTable.prototype.onAfterRendering = function() {
		Table.prototype.onAfterRendering.apply(this, arguments);
		this.$().find("[role=grid]").attr("role", "treegrid");
	};

	AnalyticalTable.prototype.setDirty = function(bDirty) {
		jQuery.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");
		this.setProperty("dirty", bDirty, true);
		this.setShowOverlay(this.getDirty());
		return this;
	};

	AnalyticalTable.prototype.getModel = function(oModel, sName) {
		var oModel = Table.prototype.getModel.apply(this, arguments);
		if (oModel) {
			sap.ui.model.analytics.ODataModelAdapter.apply(oModel);
		}
		return oModel;
	};

	/**
	 * handler for change events of the binding
	 * @param {sap.ui.base.Event} oEvent change event
	 * @private
	 */
	AnalyticalTable.prototype._onBindingChange = function(oEvent) {
		Table.prototype._onBindingChange.apply(this, arguments);
		// the column menus have to be invalidated when the amount
		// of data changes in the Table; this happens on normal changes
		// of the Table as well as when filtering
		var sReason = typeof (oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
		if (sReason !== "sort") {
			this._invalidateColumnMenus();
		}
	};

	AnalyticalTable.prototype.bindRows = function(oBindingInfo) {
		// Sanitize the arguments for API Compatibility: sName, sPath, oTemplate, oSorter, aFilters
		var oBindingInfoSanitized = this._sanitizeBindingInfo.apply(this, arguments);

		var vReturn = this.bindAggregation("rows", oBindingInfoSanitized);
		this._bSupressRefresh = true;
		this._updateColumns();
		this._bSupressRefresh = false;

		return vReturn;
	};

	/**
	 * _bindAggregation is overwritten, and will be called by either ManagedObject.prototype.bindAggregation
	 * or ManagedObject.prototype.setModel
	 */
	AnalyticalTable.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
		if (sName === "rows") {
			// make sure to reset the first visible row (currently needed for the analytical binding)
			// TODO: think about a boundary check to reset the firstvisiblerow if out of bounds
			this.setProperty("firstVisibleRow", 0, true);

			// The current syntax for _bindAggregation is sPath can be an object wrapping the other parameters
			// in this case we have to sanitize the parameters, so the ODataModelAdapter will instantiate the correct binding.
			this._sanitizeBindingInfo.call(this, sPath, oTemplate, oSorter, aFilters);
		}
		return Table.prototype._bindAggregation.apply(this, arguments);
	};

	/**
	 * Overwritten from Table.js - does nothing since the selection is stored in the
	 */
	AnalyticalTable.prototype._initSelectionModel = function (sSelectionMode) {
		this._oSelection = new sap.ui.model.SelectionModel(sSelectionMode);
		return this;
	};

	/**
	 * Sets the selection mode, the current selection is lost.
	 * Since the AnalyticalTable relies on the RowSelector for rendering the group headers the SelectionMode "None" is
	 * not supported and must not be used.
	 * @param {string} sSelectionMode the selection mode, see sap.ui.table.SelectionMode
	 * @public
	 * @return {sap.ui.table.Table} a reference on the table for chaining
	 */
	AnalyticalTable.prototype.setSelectionMode = function (sSelectionMode) {
		// clear selection if the mode changes
		if (sSelectionMode === sap.ui.table.SelectionMode.None) {
			jQuery.sap.log.fatal("SelectionMode 'None' is not supported by the AnalyticalTable.");
			return this;
		}

		var oBinding = this.getBinding("rows");
		if (oBinding && oBinding.clearSelection) {
			oBinding.clearSelection();
		}

		// set selection mode independent from clearing the selection
		this.setProperty("selectionMode", sSelectionMode);
		return this;
	};

	/**
	 * Sets the selection behavior.
	 * Since the AnalyticalTable relies on the RowSelector for rendering the group headers the SelectionBehavior "RowOnly" is
	 * not supported and must not be used.
	 * @param {string} sBehavior the selection behavior, see sap.ui.table.SelectionBehavior
	 * @public
	 * @returns {sap.ui.table.Table} this for chaining
	 */
	AnalyticalTable.prototype.setSelectionBehavior = function (sBehavior) {
		if (sBehavior === sap.ui.table.SelectionBehavior.RowOnly) {
			jQuery.sap.log.fatal("SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.");
			return this;
		} else {
			return Table.prototype.setSelectionBehavior.apply(this, arguments);
		}
	};

	AnalyticalTable.prototype._sanitizeBindingInfo = function (oBindingInfo) {
		var sPath,
			oTemplate,
			aSorters,
			aFilters;

		// Old API compatibility
		// previously the bind* functions were called in this pattern: sName, sPath, oTemplate, oSorter, aFilters
		if (typeof oBindingInfo == "string") {
			sPath = arguments[0];
			oTemplate = arguments[1];
			aSorters = arguments[2];
			aFilters = arguments[3];
			oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters};
			// allow either to pass the template or the factory function as 3rd parameter
			if (oTemplate instanceof sap.ui.base.ManagedObject) {
				oBindingInfo.template = oTemplate;
			} else if (typeof oTemplate === "function") {
				oBindingInfo.factory = oTemplate;
			}
		}

		// extract the sorters from the columns (TODO: reconsider this!)
		var aColumns = this.getColumns();
		for (var i = 0, l = aColumns.length; i < l; i++) {
			if (aColumns[i].getSorted()) {
				oBindingInfo.sorter = oBindingInfo.sorter || [];
				oBindingInfo.sorter.push(new sap.ui.model.Sorter(aColumns[i].getSortProperty() || aColumns[i].getLeadingProperty(), aColumns[i].getSortOrder() === sap.ui.table.SortOrder.Descending));
			}
		}

		// Make sure all necessary parameters are given.
		// The ODataModelAdapter (via bindList) needs these properties to determine if an AnalyticalBinding should be instantiated.
		// This is the default for the AnalyticalTable.
		oBindingInfo.parameters = oBindingInfo.parameters || {};
		oBindingInfo.parameters.analyticalInfo = this._getColumnInformation();
		oBindingInfo.parameters.sumOnTop = this.getSumOnTop();
		oBindingInfo.parameters.numberOfExpandedLevels = this.getNumberOfExpandedLevels();
		oBindingInfo.parameters.autoExpandMode = this.getAutoExpandMode();

		// This may fail, in case the model is not yet set.
		// If this case happens, the ODataModelAdapter is added by the overriden _bindAggregation, which is called during setModel(...)
		var oModel = this.getModel(oBindingInfo.model);
		if (oModel) {
			ODataModelAdapter.apply(oModel);
		}

		return oBindingInfo;
	};

	/**
	 * @param {Boolean} bSuppressRefresh Suppress Refresh
	 * @returns {sap.ui.table.AnalyticalTable} this
	 * @private
 	 */
	AnalyticalTable.prototype._setSuppressRefresh = function (bSuppressRefresh) {
		this._bSupressRefresh = bSuppressRefresh;
		return this;
	};

	AnalyticalTable.prototype._attachBindingListener = function() {
		var oBinding = this.getBinding("rows");

		// The selectionChanged event is also a special AnalyticalTreeBindingAdapter event.
		// The event interface is the same as in sap.ui.model.SelectionModel, due to compatibility with the sap.ui.table.Table
		if (oBinding && !oBinding.hasListeners("selectionChanged")){
			oBinding.attachSelectionChanged(this._onSelectionChanged, this);
		}

		Table.prototype._attachDataRequestedListeners.apply(this);
	};

	AnalyticalTable.prototype._getColumnInformation = function() {
		var aColumns = [],
			aTableColumns = this.getColumns();

		for (var i = 0; i < this._aGroupedColumns.length; i++) {
			var oColumn = sap.ui.getCore().byId(this._aGroupedColumns[i]);

			if (!oColumn) {
				continue;
			}

			aColumns.push({
				name: oColumn.getLeadingProperty(),
				visible: oColumn.getVisible(),
				grouped: oColumn.getGrouped(),
				total: oColumn.getSummed(),
				sorted: oColumn.getSorted(),
				sortOrder: oColumn.getSortOrder(),
				inResult: oColumn.getInResult(),
				formatter: oColumn.getGroupHeaderFormatter()
			});
		}

		for (var i = 0; i < aTableColumns.length; i++) {
			var oColumn = aTableColumns[i];

			if (jQuery.inArray(oColumn.getId(), this._aGroupedColumns) > -1) {
				continue;
			}
			if (!oColumn instanceof AnalyticalColumn) {
				jQuery.sap.log.error("You have to use AnalyticalColumns for the Analytical table");
			}

			aColumns.push({
				name: oColumn.getLeadingProperty(),
				visible: oColumn.getVisible(),
				grouped: oColumn.getGrouped(),
				total: oColumn.getSummed(),
				sorted: oColumn.getSorted(),
				sortOrder: oColumn.getSortOrder(),
				inResult: oColumn.getInResult(),
				formatter: oColumn.getGroupHeaderFormatter()
			});
		}

		return aColumns;
	};

	AnalyticalTable.prototype._updateTableContent = function() {
		Table.prototype._updateTableContent.apply(this, arguments);

		var oBinding = this.getBinding("rows"),
			iFirstRow = this.getFirstVisibleRow(),
			iFixedBottomRowCount = this.getFixedBottomRowCount(),
			iCount = this.getVisibleRowCount(),
			aCols = this.getColumns();

		var fnRemoveClasses = function (oRow) {
			var $row = oRow.getDomRefs(true);

			$row.row.removeAttr("data-sap-ui-level");
			$row.row.removeData("sap-ui-level");
			$row.row.removeAttr('aria-level');
			$row.row.removeAttr('aria-expanded');
			$row.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");
			$row.rowSelector.html("");
		};

		var aRows = this.getRows();
		//check if the table has rows (data to display)
		if (!oBinding) {
			// restore initial table state, remove group headers and total row formatting
			for (var i = 0; i < aRows.length; i++) {
				fnRemoveClasses(aRows[i]);
			}
			return;
		}

		for (var iRow = 0, l = Math.min(iCount, aRows.length); iRow < l; iRow++) {
			var bIsFixedRow = iRow > (iCount - iFixedBottomRowCount - 1) && oBinding.getLength() > iCount,
				iRowIndex = bIsFixedRow ? (oBinding.getLength() - 1 - (iCount - 1 - iRow)) : iFirstRow + iRow,
				oRow = aRows[iRow],
				$row = oRow.$(),
				$fixedRow = oRow.$("fixed"),
				$rowHdr = this.$().find("div[data-sap-ui-rowindex=" + $row.attr("data-sap-ui-rowindex") + "]");

			var oContextInfo;
			if (bIsFixedRow && oBinding.bProvideGrandTotals) {
				oContextInfo = oBinding.getGrandTotalContextInfo();
			} else {
				oContextInfo = this.getContextInfoByIndex(iRowIndex);
			}

			var iLevel = oContextInfo ? oContextInfo.level : 0;

			if (!oContextInfo || !oContextInfo.context) {
				fnRemoveClasses(oRow);
				if (oContextInfo && !oContextInfo.context) {
					$row.addClass("sapUiAnalyticalTableDummy");
					$rowHdr.addClass("sapUiAnalyticalTableDummy");
					$rowHdr.html('<div class="sapUiAnalyticalTableLoading">' + this._oResBundle.getText("TBL_CELL_LOADING") + '</div>');
				}
				continue;
			}

			var aAriaLabelledByParts = [this.getId() + "-rownumberofrows"];
			var sAriaTextForSum = "";

			if (oBinding.nodeHasChildren && oBinding.nodeHasChildren(oContextInfo)) {
				// modify the rows
				$row.addClass("sapUiTableGroupHeader");
				$fixedRow.addClass("sapUiTableGroupHeader");

				$rowHdr.attr("aria-haspopup", true);

				var sGroupHeaderText = oBinding.getGroupName(oContextInfo.context, oContextInfo.level);

				var sClass = oContextInfo.nodeState.expanded ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";

				if (oContextInfo.nodeState.expanded && !this.getSumOnTop()) {
					$row.addClass("sapUiTableRowHidden");
					$fixedRow.addClass("sapUiTableRowHidden");
					$rowHdr.addClass("sapUiTableRowHidden");
				}

				var sGroupHeaderMenuButton = "";
				if ('ontouchstart' in document) {
					sGroupHeaderMenuButton = "<div class='sapUiTableGroupMenuButton'></div>";
				}
				$rowHdr.html("<div id=\"" + oRow.getId() + "-groupHeader\" class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\" title=\"" + sGroupHeaderText + "\">" + sGroupHeaderText + "</div>" + sGroupHeaderMenuButton);
				aAriaLabelledByParts.push(oRow.getId() + "-groupHeader");

				$row.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");
				$fixedRow.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");
				$rowHdr.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");
				$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title").removeAttr("aria-label");

				$row.attr('aria-expanded', oContextInfo.nodeState.expanded);
				$fixedRow.attr('aria-expanded', oContextInfo.nodeState.expanded);
				$rowHdr.attr('aria-expanded', oContextInfo.nodeState.expanded);

				if (oContextInfo.level > 0) {
					sAriaTextForSum = oBinding.getGroupName(oContextInfo.context, oContextInfo.level);
				} else {
					sAriaTextForSum = this._oResBundle.getText("TBL_GRAND_TOTAL_ROW");
				}
			} else {
				$row.removeAttr('aria-expanded');
				$rowHdr.removeAttr('aria-expanded');
				$fixedRow.removeAttr('aria-expanded');
				$rowHdr.attr("aria-haspopup", false);

				$rowHdr.removeAttr('aria-describedby');

				$row.removeClass("sapUiTableGroupHeader sapUiTableRowHidden sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");

				$fixedRow.removeClass("sapUiTableGroupHeader sapUiTableRowHidden sapUiAnalyticalTableSum");

				$rowHdr.html("");
				$rowHdr.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableDummy sapUiAnalyticalTableSum");

				// update aria description for row selection
				if (!oContextInfo.nodeState.sum) {
					aAriaLabelledByParts.push(this.getId() + "-rows-row" + $rowHdr.attr("data-sap-ui-rowindex") + "-rowselecttext");
				}

				if (oContextInfo.nodeState.sum && oContextInfo.context && oContextInfo.context.getObject()) {
					$row.addClass("sapUiAnalyticalTableSum");
					$fixedRow.addClass("sapUiAnalyticalTableSum");
					$rowHdr.addClass("sapUiAnalyticalTableSum");

					sAriaTextForSum;
					if (oContextInfo.level > 0) {
						sAriaTextForSum = this._oResBundle.getText("TBL_GROUP_TOTAL_ROW") + " " + oBinding.getGroupName(oContextInfo.context, oContextInfo.level);
					} else {
						sAriaTextForSum = this._oResBundle.getText("TBL_GRAND_TOTAL_ROW");
					}
				}
			}

			//set the level of the node on the DOM
			$row.attr("data-sap-ui-level", iLevel);
			$fixedRow.attr("data-sap-ui-level", iLevel);
			$rowHdr.attr("data-sap-ui-level", iLevel);
			$rowHdr.attr('aria-level', iLevel + 1);
			$row.attr('aria-level', iLevel + 1);
			$fixedRow.attr('aria-level', iLevel + 1);

			//set the level of the node as a data-* attribute
			$row.data("sap-ui-level", iLevel);
			$fixedRow.data("sap-ui-level", iLevel);
			$rowHdr.data("sap-ui-level", iLevel);

			if ('ontouchstart' in document) {
				var iScrollBarOffset = 0;
				if (this.$().hasClass("sapUiTableVScr")) {
					iScrollBarOffset += this.$().find('.sapUiTableVSb').width();
				}
				var $GroupHeaderMenuButton = $rowHdr.find(".sapUiTableGroupMenuButton");

				if (this._bRtlMode) {
					$GroupHeaderMenuButton.css("right", (this.$().width() - $GroupHeaderMenuButton.width() + $rowHdr.position().left - iScrollBarOffset) + "px");
				} else {
					$GroupHeaderMenuButton.css("left", (this.$().width() - $GroupHeaderMenuButton.width() - $rowHdr.position().left - iScrollBarOffset) + "px");
				}
			}

			// show or hide the totals if not enabled - needs to be done by Table
			// control since the model could be reused and thus the values cannot
			// be cleared in the model - and the binding has no control over the
			// value mapping - this happens directly via the context!
			var aCells = oRow.getCells();
			var aMeasures = [];
			for (var i = 0, lc = aCells.length; i < lc; i++) {
				var iCol = aCells[i].data("sap-ui-colindex");
				var oCol = aCols[iCol];
				var $td = jQuery(aCells[i].$().closest("td"));
				if (oBinding.isMeasure(oCol.getLeadingProperty())) {
					$td.addClass("sapUiTableMeasureCell");
					if (!oContextInfo.nodeState.sum || oCol.getSummed()) {
						$td.removeClass("sapUiTableCellHidden");
						aMeasures.push(oCol.getId());
						aMeasures.push($td[0].id);
					} else {
						$td.addClass("sapUiTableCellHidden");
					}

					var sAriaTextForSumId = $td[0].id + "-ariaTextForSum";
					var $AriaTextForSum = jQuery.sap.byId(sAriaTextForSumId);
					if ($AriaTextForSum.length === 0) {
						$td.append("<span id=\"" + sAriaTextForSumId + "\" class=\"sapUiHidden\"></span>");
						$AriaTextForSum = jQuery.sap.byId(sAriaTextForSumId);
					}

					if (oContextInfo.nodeState.sum || $row.hasClass("sapUiTableGroupHeader")) {
						$AriaTextForSum.text(sAriaTextForSum);
						$td.attr("aria-labelledby", sAriaTextForSumId + " " + $td.attr("aria-labelledby"));
					} else {
						$AriaTextForSum.text("");
						$td.removeAriaLabelledBy(sAriaTextForSumId);
					}
				} else {
					$td.removeClass("sapUiTableMeasureCell");
				}
			}

			// connect measures with the group header
			for (var k = 0; k < aMeasures.length; k++) {
				aAriaLabelledByParts.push(aMeasures[k]);
			}
			// update aria description for row selection
			$rowHdr.attr("aria-labelledby", aAriaLabelledByParts.join(" "));

			var $targetRow = this.getFixedColumnCount() > 0 ? $fixedRow : $row;
			this._resizeGroupHeader($rowHdr, $targetRow, oContextInfo.nodeState.expanded);
		}
	};

	/*
	 * Calculates how much width is available for the group header title.
	 * Logic tries to grant as much space as possible. Especially to use every gap between each sum/dimension label.
	 * This is important for users for making sure that they can read the group title even when they scrolled horizontally.
	 * @param {jQuery} $rowHdr the current row header wrapped by jQuery.
	 * @param {jQuery} $row jQuery collection of the current processed row.
	 * @param {Boolean} bIsExpanded
	 *         flag whether the current node is expanded or not.
	 */
	AnalyticalTable.prototype._resizeGroupHeader = function($rowHdr, $row, bIsExpanded) {
		// Group Icon Layouting logic
		var $groupIcon = $rowHdr.find(".sapUiTableGroupIcon");
		if ($groupIcon.length === 0 || bIsExpanded) {
			return;
		}

		var $MeasureAndSumLabels =  $row.find(".sapUiTableCell > *");
		var oTableClientRect = this.getDomRef().getBoundingClientRect();
		$groupIcon.width('');
		var iGroupPosition = this._bRtlMode ? $groupIcon[0].getBoundingClientRect().left : $groupIcon[0].getBoundingClientRect().right;
		var iGroupIconWidth = $groupIcon.width();

		var bIsRtlMode = this._bRtlMode;

		$MeasureAndSumLabels.each(function(index) {
			var $this = jQuery(this);
			if ($this.text().length === 0) {
				return true;
			}
			var oClientRect = $this[0].getBoundingClientRect();
			$this.width('auto');
			var iLabelWidth = $this.width();
			$this.width('');

			var iOverlap = 0;
			var bDoResize = false;
			var sTextAlign = $this.css('text-align');
			if (!bIsRtlMode) {
				if (sTextAlign === "left") {
					iOverlap = iGroupPosition - oClientRect.left;
					bDoResize = (iOverlap > 0 && oClientRect.left + iLabelWidth > oTableClientRect.left);
				} else if (sTextAlign === "right") {
					iOverlap = iGroupPosition - oClientRect.right + iLabelWidth;
					bDoResize = (iOverlap > 0 && oClientRect.right > oTableClientRect.left);
				}
			} else {
				if (sTextAlign === "left") {
					iOverlap = oClientRect.left + iLabelWidth - iGroupPosition;
					bDoResize = (iOverlap > 0 && oClientRect.left < oTableClientRect.right);
				} else if (sTextAlign === "right") {
					iOverlap = oClientRect.right - iGroupPosition;
					bDoResize = (iOverlap > 0 && oClientRect.right < oTableClientRect.right);
				}
			}

			if (bDoResize) {
				$groupIcon.width(iGroupIconWidth - iOverlap);
				// break loop
				return false;
			}
		});
	};

	AnalyticalTable.prototype.onclick = function(oEvent) {
		var $EventTarget = jQuery(oEvent.target);
		if ($EventTarget.hasClass("sapUiTableGroupIcon")) {
			this._onNodeSelect(oEvent);
		} else if ($EventTarget.hasClass("sapUiAnalyticalTableSum")) {
			// Sums cannot be selected
			oEvent.preventDefault();
			return;
		} else if ($EventTarget.hasClass("sapUiTableGroupMenuButton")) {
			this._onContextMenu(oEvent);
			oEvent.preventDefault();
			return;
		} else {
			if (Table.prototype.onclick) {
				Table.prototype.onclick.apply(this, arguments);
			}
		}
	};

	AnalyticalTable.prototype.onsapselect = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
			this._onNodeSelect(oEvent);
		} else if (jQuery(oEvent.target).hasClass("sapUiAnalyticalTableSum")) {
			//Summs connot be selected
			oEvent.preventDefault();
			return;
		} else {
			var $Target = jQuery(oEvent.target),
				$TargetDIV = $Target.closest('div.sapUiTableRowHdr');
			if ($TargetDIV.hasClass('sapUiTableGroupHeader') && $TargetDIV.hasClass('sapUiTableRowHdr')) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($TargetDIV.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				oBinding.toggleIndex(iRowIndex);
				return;
			}
			if (Table.prototype.onsapselect) {
				Table.prototype.onsapselect.apply(this, arguments);
			}
		}
	};

	AnalyticalTable.prototype._onNodeSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parent();
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			oBinding.toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	AnalyticalTable.prototype._onContextMenu = function(oEvent) {
		if (jQuery(oEvent.target).closest('tr').hasClass('sapUiTableGroupHeader') ||
				jQuery(oEvent.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length > 0) {
			this._iGroupedLevel = jQuery(oEvent.target).closest('[data-sap-ui-level]').data('sap-ui-level');
			var oMenu = this._getGroupHeaderMenu();
			var eDock = sap.ui.core.Popup.Dock;

			var iLocationX = oEvent.pageX || oEvent.clientX;
			var iLocationY = oEvent.pageY || oEvent.clientY;
			oMenu.open(false, oEvent.target, eDock.LeftTop, eDock.LeftTop, document, (iLocationX - 2) + " " + (iLocationY - 2));

			oEvent.preventDefault();
			oEvent.stopPropagation();
			return;
		}

		return true;
	};

	AnalyticalTable.prototype._getGroupHeaderMenu = function() {

		var that = this;
		function getGroupColumnInfo() {
			var iIndex = that._iGroupedLevel - 1;
			if (that._aGroupedColumns[iIndex]) {
				var oGroupedColumn = that.getColumns().filter(function(oColumn){
					if (that._aGroupedColumns[iIndex] == oColumn.getId()) {
						return true;
					}
				})[0];

				return {
					column: oGroupedColumn,
					index: iIndex
				};
			}else {
				return undefined;
			}
		}

		if (!this._oGroupHeaderMenu) {
			this._oGroupHeaderMenu = new sap.ui.unified.Menu();
			this._oGroupHeaderMenuVisibilityItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SHOW_COLUMN"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column,
							bShowIfGrouped = oColumn.getShowIfGrouped();
						oColumn.setShowIfGrouped(!bShowIfGrouped);

						that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type:( !bShowIfGrouped ? sap.ui.table.GroupEventType.showGroupedColumn : sap.ui.table.GroupEventType.hideGroupedColumn )});
					}
				}
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_UNGROUP"),
				select: function() {
					var aColumns = that.getColumns(),
						iFoundGroups = 0,
						iLastGroupedIndex = -1,
						iUngroudpedIndex = -1,
						oColumn;
					for (var i = 0; i < aColumns.length; i++) {
						oColumn = aColumns[i];
						if (oColumn.getGrouped()) {
							iFoundGroups++;
							if (iFoundGroups == that._iGroupedLevel) {
								oColumn._bSkipUpdateAI = true;

								// relaying the ungrouping to the AnalyticalBinding,
								// the numberOfExpandedLevels must be reset through the AnalyticalTreeBindingAdapter.
								var oBinding = that.getBinding("rows");
								oBinding.setNumberOfExpandedLevels(0);
								// setGrouped(false) leads to an invalidation of the Column -> rerender
								// and this will result in new requests from the AnalyticalBinding,
								//because the initial grouping is lost (can not be restored!)
								oColumn.setGrouped(false);

								oColumn._bSkipUpdateAI = false;
								iUngroudpedIndex = i;
								that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.ungroup});
							} else {
								iLastGroupedIndex = i;
							}
						}
					}
					if (iLastGroupedIndex > -1 && iUngroudpedIndex > -1 && iUngroudpedIndex < iLastGroupedIndex) {
						var oUngroupedColumn = aColumns[iUngroudpedIndex];
						var iHeaderSpan = oUngroupedColumn.getHeaderSpan();
						if (jQuery.isArray(iHeaderSpan)) {
							iHeaderSpan = iHeaderSpan[0];
						}
						var aRemovedColumns = [];
						for (var i = iUngroudpedIndex; i < iUngroudpedIndex + iHeaderSpan; i++) {
							aRemovedColumns.push(aColumns[i]);
						}
						jQuery.each(aRemovedColumns, function(iIndex, oColumn) {
							that.removeColumn(oColumn);
							that.insertColumn(oColumn, iLastGroupedIndex);
						});
					}
					that._updateTableColumnDetails();
					that.updateAnalyticalInfo();
				}
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_UNGROUP_ALL"),
				select: function() {
					var aColumns = that.getColumns();
					for (var i = 0; i < aColumns.length; i++) {
						aColumns[i]._bSkipUpdateAI = true;

						// same as with single "ungrouping" (see above)
						var oBinding = that.getBinding("rows");
						oBinding.setNumberOfExpandedLevels(0);

						aColumns[i].setGrouped(false);
						aColumns[i]._bSkipUpdateAI = false;
					}
					that._bSupressRefresh = true;
					that._updateTableColumnDetails();
					that.updateAnalyticalInfo();
					that._bSupressRefresh = false;
					that.fireGroup({column: undefined, groupedColumns: [], type: sap.ui.table.GroupEventType.ungroupAll});
				}
			}));
			this._oGroupHeaderMoveUpItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_MOVE_UP"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;
						var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
						if (iIndex > 0) {
							that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex - 1, 1, that._aGroupedColumns[iIndex])[0];
							that.updateAnalyticalInfo();
							that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.moveUp});
						}
					}
				},
				icon: "sap-icon://arrow-top"
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);
			this._oGroupHeaderMoveDownItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_MOVE_DOWN"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;
						var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
						if (iIndex < that._aGroupedColumns.length) {
							that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex + 1, 1, that._aGroupedColumns[iIndex])[0];
							that.updateAnalyticalInfo();
							that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.moveDown});
						}
					}
				},
				icon: "sap-icon://arrow-bottom"
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SORT_ASC"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;

						oColumn.sort(false); //update Analytical Info triggered by aftersort in column
					}
				},
				icon: "sap-icon://up"
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SORT_DESC"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;

						oColumn.sort(true); //update Analytical Info triggered by aftersort in column
					}
				},
				icon: "sap-icon://down"
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),
				select: function() {
					// Why -1? Because the "Collapse Level" Menu Entry should collapse TO the given level - 1
					// So collapsing level 1 means actually all nodes up TO level 0 will be collapsed.
					// Potential negative values are handled by the binding.
					that.getBinding("rows").collapseToLevel(that._iGroupedLevel - 1);
					that.setFirstVisibleRow(0); //scroll to top after collapsing (so no rows vanish)
					that.clearSelection();
				}
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_COLLAPSE_ALL"),
				select: function() {
					that.getBinding("rows").collapseToLevel(0);
					that.setFirstVisibleRow(0); //scroll to top after collapsing (so no rows vanish)
					that.clearSelection();
				}
			}));
		}

		var oGroupColumnInfo = getGroupColumnInfo();
		if (oGroupColumnInfo) {
			var oColumn = oGroupColumnInfo.column;
			if (oColumn.getShowIfGrouped()) {
				this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));
			} else {
				this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));
			}
			this._oGroupHeaderMoveUpItem.setEnabled(oGroupColumnInfo.index > 0);
			this._oGroupHeaderMoveDownItem.setEnabled(oGroupColumnInfo.index < this._aGroupedColumns.length - 1);
		} else {
			this._oGroupHeaderMoveUpItem.setEnabled(true);
			this._oGroupHeaderMoveDownItem.setEnabled(true);
		}

		return this._oGroupHeaderMenu;

	};

	AnalyticalTable.prototype.expand = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.expand(iRowIndex);
		}
	};

	AnalyticalTable.prototype.collapse = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapse(iRowIndex);
		}
	};

	/**
	 * Collapses all nodes (and lower if collapseRecursive is activated)
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.collapseAll = function () {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapseToLevel(0);
			this.setFirstVisibleRow(0);
		}

		return this;
	};

	AnalyticalTable.prototype.isExpanded = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.isExpanded(iRowIndex);
		}
		return false;
	};

	/**
	 * Returns the context of a row by its index.
	 *
	 * @param {int} iIndex
	 *         Index of the row to return the context from.
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.getContextByIndex = function(iIndex) {
		var oBinding = this.getBinding("rows");
		return iIndex >= 0 && oBinding ? oBinding.getContextByIndex(iIndex) : null;
	};

	AnalyticalTable.prototype.getContextInfoByIndex = function(iIndex) {
		var oBinding = this.getBinding("rows");
		return iIndex >= 0 && oBinding ? oBinding.getNodeByIndex(iIndex) : null;
	};

	AnalyticalTable.prototype._onColumnMoved = function(oEvent) {
		Table.prototype._onColumnMoved.apply(this, arguments);
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype.addColumn = function(vColumn, bSuppressInvalidate) {
		//@TODO: Implement addColumn(Column[] || oColumn)
		var oColumn = this._getColumn(vColumn);
		if (oColumn.getGrouped()) {
			this._addGroupedColumn(oColumn.getId());
		}
		Table.prototype.addColumn.call(this, oColumn, bSuppressInvalidate);
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo(bSuppressInvalidate);
		return this;
	};

	AnalyticalTable.prototype.insertColumn = function(vColumn, iIndex, bSuppressInvalidate) {
		var oColumn = this._getColumn(vColumn);
		if (oColumn.getGrouped()) {
			this._addGroupedColumn(oColumn.getId());
		}
		Table.prototype.insertColumn.call(this, oColumn, iIndex, bSuppressInvalidate);
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo(bSuppressInvalidate);
		return this;
	};

	AnalyticalTable.prototype.removeColumn = function(vColumn, bSuppressInvalidate) {
		var oResult = Table.prototype.removeColumn.apply(this, arguments);

		// only remove from grouped columns if not caused by column move. If this._iNewColPos
		// is set, the column was moved by user.-
		if (!this._iNewColPos) {
			this._aGroupedColumns = jQuery.grep(this._aGroupedColumns, function(sValue) {
				//check if vColum is an object with getId function
				if (vColumn.getId) {
					return sValue != vColumn.getId();
				} else {
					return sValue == vColumn;
				}
			});
		}

		this.updateAnalyticalInfo(bSuppressInvalidate);

		return oResult;
	};

	AnalyticalTable.prototype.removeAllColumns = function(bSuppressInvalidate) {
		this._aGroupedColumns = [];
		var aResult = Table.prototype.removeAllColumns.apply(this, arguments);

		this._updateTableColumnDetails();
		this.updateAnalyticalInfo(bSuppressInvalidate);

		return aResult;
	};

	AnalyticalTable.prototype._getColumn = function(vColumn) {
		if (typeof vColumn === "string") {
			var oColumn =  new AnalyticalColumn({
				leadingProperty: vColumn,
				template: vColumn,
				managed: true
			});
			return oColumn;
		} else if (vColumn instanceof AnalyticalColumn) {
			return vColumn;
		} else {
			throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");
		}
	};

	AnalyticalTable.prototype._updateColumns = function() {
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype.updateAnalyticalInfo = function(bSupressRefresh) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			var aColumnInfo = this._getColumnInformation();
			oBinding.updateAnalyticalInfo(aColumnInfo);
			this._updateTotalRow(aColumnInfo, bSupressRefresh);
			if (bSupressRefresh || this._bSupressRefresh) {
				return;
			}
			this.refreshRows();
		}
	};

	AnalyticalTable.prototype._updateTotalRow = function(aColumnInfo, bSuppressInvalidate) {
		var oBinding = this.getBinding("rows");

		var iFixedBottomRowCount = this.getFixedBottomRowCount();
		if (oBinding && (oBinding.providesGrandTotal() && oBinding.hasTotaledMeasures())) {
			if (iFixedBottomRowCount !== 1) {
				this.setProperty("fixedBottomRowCount", 1, bSuppressInvalidate);
			}
		} else {
			if (iFixedBottomRowCount !== 0) {
				this.setProperty("fixedBottomRowCount", 0, bSuppressInvalidate);
			}
		}

	};

	AnalyticalTable.prototype._updateTableColumnDetails = function() {
		var oBinding = this.getBinding("rows"),
			oResult = oBinding && oBinding.getAnalyticalQueryResult();

		if (oResult) {
			var aColumns = this.getColumns(),
				aGroupedDimensions = [],
				aUngroupedDimensions = [],
				aDimensions = [],
				oDimensionIndex = {},
				oColumn,
				oDimension;

			// calculate an index of all dimensions and their columns. Grouping is done per dimension.
			for (var i = 0; i < aColumns.length; i++) {
				oColumn = aColumns[i];
				oColumn._isLastGroupableLeft = false;
				oColumn._bLastGroupAndGrouped = false;
				oColumn._bDependendGrouped = false;

				// ignore invisible columns
				if (!oColumn.getVisible()) {
					continue;
				}

				var sLeadingProperty = oColumn.getLeadingProperty();
				oDimension = oResult.findDimensionByPropertyName(sLeadingProperty);

				if (oDimension) {
					var sDimensionName = oDimension.getName();
					if (!oDimensionIndex[sDimensionName]) {
						oDimensionIndex[sDimensionName] = {dimension: oDimension, columns: [oColumn]};
					} else {
						oDimensionIndex[sDimensionName].columns.push(oColumn);
					}

					// if one column of a dimension is grouped, the dimension is considered as grouped.
					// all columns which are not explicitly grouped will be flagged as dependendGrouped in the next step
					if (oColumn.getGrouped() && jQuery.inArray(sDimensionName, aGroupedDimensions) == -1) {
						aGroupedDimensions.push(sDimensionName);
					}

					if (jQuery.inArray(sDimensionName, aDimensions) == -1) {
						aDimensions.push(sDimensionName);
					}
				}
			}

			aUngroupedDimensions = jQuery.grep(aDimensions, function (s) {
				return (jQuery.inArray(s, aGroupedDimensions) == -1);
			});

			// for all grouped dimensions
			if (aGroupedDimensions.length > 0) {
				// calculate and flag the dependendly grouped columns of the dimension
				jQuery.each(aGroupedDimensions, function(i, s) {
					jQuery.each(oDimensionIndex[s].columns, function(j, o) {
						if (!o.getGrouped()) {
							o._bDependendGrouped = true;
						}
					});
				});

				// if there is only one dimension left, their columns must remain visible even though they are grouped.
				// this behavior is controlled by the flag _bLastGroupAndGrouped
				if (aGroupedDimensions.length == aDimensions.length) {
					oDimension = oResult.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length - 1]).getLeadingProperty());
					var aGroupedDimensionColumns = oDimensionIndex[oDimension.getName()].columns;
					jQuery.each(aGroupedDimensionColumns, function(i, o) {
						o._bLastGroupAndGrouped = true;
					});
				}
			}

			if (aUngroupedDimensions.length == 1) {
				jQuery.each(oDimensionIndex[aUngroupedDimensions[0]].columns, function(j, o) {
					o._isLastGroupableLeft = true;
				});
			}
		}
	};

	AnalyticalTable.prototype._getFirstMeasureColumnIndex = function() {
		var oBinding = this.getBinding("rows"),
			oResultSet = oBinding && oBinding.getAnalyticalQueryResult(),
			aColumns = this._getVisibleColumns();

		if (!oResultSet) {
			return -1;
		}

		for (var i = 0; i < aColumns.length; i++) {
			var oColumn = aColumns[i],
				sLeadingProperty = oColumn.getLeadingProperty();

			if (oResultSet.findMeasureByName(sLeadingProperty) || oResultSet.findMeasureByPropertyName(sLeadingProperty)) {
				return i;
			}
		}
	};

	/**
	 * Returns the total size of the data entries.
	 *
	 * @type int
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.getTotalSize = function() {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.getTotalSize();
		}
		return 0;
	};

	AnalyticalTable.prototype._hasData = function() {
		var oBinding = this.getBinding("rows"),
			iLength = oBinding && (oBinding.getLength() || 0),
			bHasTotal = oBinding && oBinding.providesGrandTotal() && oBinding.hasTotaledMeasures();

		if (!oBinding || (bHasTotal && iLength < 2) || (!bHasTotal && iLength === 0)) {
			return false;
		}
		return true;
	};

	AnalyticalTable.prototype._onPersoApplied = function() {
		Table.prototype._onPersoApplied.apply(this, arguments);
		this._aGroupedColumns = [];
		var aColumns = this.getColumns();
		for (var i = 0, l = aColumns.length; i < l; i++) {
			if (aColumns[i].getGrouped()) {
				this._addGroupedColumn(aColumns[i].getId());
			}
		}
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype._addGroupedColumn = function(sColumn) {
		if (jQuery.inArray(sColumn, this._aGroupedColumns) < 0) {
			this._aGroupedColumns.push(sColumn);
		}
	};

	AnalyticalTable.prototype.getGroupedColumns = function () {
		return this._aGroupedColumns;
	};

	/**
	 * Sets the node hierarchy to collapse recursive. When set to true, all child nodes will get collapsed as well.
	 * This setting has only effect when the binding is already initialized.
	 * @param {boolean} bCollapseRecursive
	 */
	AnalyticalTable.prototype.setCollapseRecursive = function(bCollapseRecursive) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			jQuery.sap.assert(oBinding.setCollapseRecursive, "Collapse Recursive is not supported by the used binding");
			if (oBinding.setCollapseRecursive) {
				oBinding.setCollapseRecursive(bCollapseRecursive);
			}
		}
		this.setProperty("collapseRecursive", !!bCollapseRecursive, true);
		return this;
	};

	/***************************************************
	 *              Selection of Table Rows            *
	 ***************************************************/

	/**
	 * returns the count of rows which can ca selected when bound or 0
	 * @private
	 */
	AnalyticalTable.prototype._getSelectableRowCount = function() {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			var oRootNode = oBinding.getGrandTotalContextInfo();
			return oRootNode ? oRootNode.numberOfLeafs : 0;
		}
	};

	/**
	 * Checks if the row at the given index is selected.
	 *
	 * @param {int} iRowIndex The row index for which the selection state should be retrieved
	 * @return {boolean} true if the index is selected, false otherwise
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.isIndexSelected = function (iRowIndex) {
		return TreeTable.prototype.isIndexSelected.call(this, iRowIndex);
	};

	/**
	 * Overriden from Table.js base class.
	 * In a TreeTable you can only select indices, which correspond to the currently visualized tree.
	 * Invisible tree nodes (e.g. collapsed child nodes) can not be selected via Index, because they do not
	 * correspond to a TreeTable row.
	 *
	 * @param {int} iRowIndex The row index which will be selected (if existing)
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.setSelectedIndex = function (iRowIndex) {
		return TreeTable.prototype.setSelectedIndex.call(this, iRowIndex);
	};

	/**
	 * Returns an array containing the row indices of all selected tree nodes (ordered ascending).
	 *
	 * Please be aware of the following:
	 * Due to performance/network traffic reasons, the getSelectedIndices function returns only all indices
	 * of actually selected rows/tree nodes. Unknown rows/nodes (as in "not yet loaded" to the client), will not be
	 * returned.
	 *
	 * @return {int[]} an array containing all selected indices
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.getSelectedIndices = function () {
		return TreeTable.prototype.getSelectedIndices.call(this);
	};

	/**
	 * Sets the selection of the TreeTable to the given range (including boundaries).
	 * Beware: The previous selection will be lost/overriden. If this is not wanted, please use "addSelectionInterval" and
	 * "removeSelectionIntervall".
	 *
	 * @param {int} iFromIndex the start index of the selection range
	 * @param {int} iToIndex the end index of the selection range
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.setSelectionInterval = function (iFromIndex, iToIndex) {
		return TreeTable.prototype.setSelectionInterval.call(this, iFromIndex, iToIndex);
	};

	/**
	 * Marks a range of tree nodes as selected, starting with iFromIndex going to iToIndex.
	 * The TreeNodes are referenced via their absolute row index.
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 *
	 * Please also take notice of the fact, that "addSelectionInterval" does not change any other selection.
	 * To override the current selection, please use "setSelctionInterval" or for a single entry use "setSelectedIndex".
	 *
	 * @param {int} iFromIndex The starting index of the range which will be selected.
	 * @param {int} iToIndex The starting index of the range which will be selected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.addSelectionInterval = function (iFromIndex, iToIndex) {
		return TreeTable.prototype.addSelectionInterval.call(this, iFromIndex, iToIndex);
	};

	/**
	 * All rows/tree nodes inside the range (including boundaries) will be deselected.
	 * Tree nodes are referenced with theit absolute row index inside the tree-
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 *
	 * @param {int} iFromIndex The starting index of the range which will be deselected.
	 * @param {int} iToIndex The starting index of the range which will be deselected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.removeSelectionInterval = function (iFromIndex, iToIndex) {
		return TreeTable.prototype.removeSelectionInterval.call(this, iFromIndex, iToIndex);
	};

	/**
	 * Selects all available nodes/rows.
	 *
	 * Explanation of the SelectAll function and what to expect from its behavior:
	 * All rows/tree nodes locally stored on the client are selected.
	 * In addition all subsequent rows/tree nodes, which will be paged into view are also immediatly selected.
	 * However, due to obvious performance/network traffic reasons, the SelectAll function will NOT retrieve any data from the backend.
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.selectAll = function () {
		return TreeTable.prototype.selectAll.call(this);
	};

	/**
	 * Retrieves the lead selection index. The lead selection index is, among other things, used to determine the
	 * start/end of a selection range, when using Shift-Click to select multiple entries at once.
	 *
	 * @return {int[]} an array containing all selected indices (ascending ordered integers)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.getSelectedIndex = function() {
		return TreeTable.prototype.getSelectedIndex.call(this);
	};

	/**
	 * Clears the complete selection (all tree table rows/nodes will lose their selection)
	 *
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.clearSelection = function () {
		return TreeTable.prototype.clearSelection.call(this);
	};

	AnalyticalTable.prototype._isRowSelectable = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.isIndexSelectable(iRowIndex);
		} else {
			// if there is no binding the selection can't be handled, therefore the row is not selectable
			return false;
		}

	};

	return AnalyticalTable;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTable') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.DataTable.
jQuery.sap.declare('sap.ui.table.DataTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ScrollBar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.SelectionModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.odata.ODataTreeBindingAdapter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/table/DataTable",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/IntervalTrigger', 'sap/ui/core/ScrollBar', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/core/theming/Parameters', 'sap/ui/model/SelectionModel', './Row', 'sap/ui/model/odata/ODataTreeBindingAdapter', './library', 'sap/ui/core/IconPool', 'jquery.sap.dom'],
	function(jQuery, Control, IntervalTrigger, ScrollBar, ItemNavigation, Parameters, SelectionModel, Row, ODataTreeBindingAdapter, library, IconPool) {
		"use strict";



		/**
		 * Constructor for a new DataTable.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * <p>
		 *     Provides a comprehensive set of features for displaying and dealing with vast amounts of data. The Table control supports
		 *     desktop PCs and tablet devices. On tablets, special consideration should be given to the number of visible columns
		 *     and rows due to the limited performance of some devices.
		 * </p>
		 * <p>
		 *     In order to keep the document DOM as lean as possible, the Table control reuses its DOM elements of the rows.
		 *     When the user scrolls, only the row contexts are changed but the rendered controls remain the same. This allows
		 *     the Table control to handle huge amounts of data. Nevertheless, restrictions apply regarding the number of displayed
		 *     columns. Keep the number as low as possible to improve performance. Due to the nature of tables, the used
		 *     control for column templates also has a big influence on the performance.
		 * </p>
		 * <p>
		 *     The Table control relies completely on data binding, and its supported feature set is tightly coupled to
		 *     the data model and binding being used.
		 * </p>
		 *
		 *
		 * @extends sap.ui.core.Control
		 * @version 1.36.5
		 *
		 * @constructor
		 * @public
		 * @alias sap.ui.table.DataTable
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var DataTable = Control.extend("sap.ui.table.DataTable", /** @lends sap.ui.table.DataTable.prototype */{ metadata : {

			library : "sap.ui.table",
			properties : {

				/**
				 * Width of the Table.
				 */
				width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : 'auto'},

				/**
				 * Height of a row of the Table in pixel.
				 */
				rowHeight : {type : "int", group : "Appearance", defaultValue : null},

				/**
				 * Height of the column header of the Table in pixel.
				 */
				columnHeaderHeight : {type : "int", group : "Appearance", defaultValue : null},

				/**
				 * Flag whether the column header is visible or not.
				 */
				columnHeaderVisible : {type : "boolean", group : "Appearance", defaultValue : true},

				/**
				 * Number of visible rows of the table.
				 */
				visibleRowCount : {type : "int", group : "Appearance", defaultValue : 10},

				/**
				 * First visible row.
				 */
				firstVisibleRow : {type : "int", group : "Appearance", defaultValue : 0},

				/**
				 * Selection mode of the Table. This property controls whether single or multiple rows can be selected and
				 * how the selection can be extended. It may also influence the visual appearance.
				 */
				selectionMode : {type : "sap.ui.table.SelectionMode", group : "Behavior", defaultValue : sap.ui.table.SelectionMode.Multi},

				/**
				 * Selection behavior of the Table. This property defines whether the row selector is displayed and whether the row, the row selector or both
				 * can be clicked to select a row.
				 */
				selectionBehavior : {type : "sap.ui.table.SelectionBehavior", group : "Behavior", defaultValue : sap.ui.table.SelectionBehavior.RowSelector},

				/**
				 * Zero-based index of selected item. Index value for no selection is -1.
				 * When multi-selection is enabled and multiple items are selected, the method returns
				 * the lead selected item. Sets the zero-based index of the currently selected item. This method
				 * removes any previous selections. When the given index is invalid, the call is ignored.
				 */
				selectedIndex : {type : "int", group : "Appearance", defaultValue : -1},

				/**
				 * Flag whether the controls of the Table are editable or not (currently this only controls the background color in certain themes!)
				 */
				editable : {type : "boolean", group : "Behavior", defaultValue : true},

				/**
				 * Flag whether to use the scroll mode or paging mode. If the Paginator mode is used it will require the sap.ui.commons library!
				 */
				navigationMode : {type : "sap.ui.table.NavigationMode", group : "Behavior", defaultValue : sap.ui.table.NavigationMode.Scrollbar},

				/**
				 * Threshold to fetch the next chunk of data. The minimal threshold can be the visible row count of the Table. If the value is 0 then the thresholding is disabled.
				 */
				threshold : {type : "int", group : "Appearance", defaultValue : 100},

				/**
				 * Flag to enable or disable column reordering
				 */
				enableColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true},

				/**
				 * Flag to enable or disable column grouping. (experimental!)
				 */
				enableGrouping : {type : "boolean", group : "Behavior", defaultValue : false},

				/**
				 * Flag to show or hide the column visibility menu. This menu will get displayed in each
				 * generated column header menu. It allows to show or hide columns
				 */
				showColumnVisibilityMenu : {type : "boolean", group : "Appearance", defaultValue : false},

				/**
				 * Flag whether to show the no data overlay or not once the table is empty. If set to false
				 * the table will just show a grid of empty cells
				 */
				showNoData : {type : "boolean", group : "Appearance", defaultValue : true},

				/**
				 * This defines how the table handles the visible rows in the table. The default behavior is,
				 * that a fixed row count is defined. If you change it to auto the visibleRowCount property is
				 * changed by the table automatically. It will then adjust its maximum row count to the space it is
				 * allowed to cover (limited by the surrounding container) and its minimum row count to the value of
				 * the property minAutoRowCount (default value : 5) In manual mode the user can change
				 * the visibleRowCount interactively.
				 * @since 1.9.2
				 */
				visibleRowCountMode : {type : "sap.ui.table.VisibleRowCountMode", group : "Appearance", defaultValue : sap.ui.table.VisibleRowCountMode.Fixed},

				/**
				 * This property is used to set the minimum count of visible rows when the property visibleRowCountMode is set to Auto. For any other visibleRowCountMode, it is ignored.
				 */
				minAutoRowCount : {type : "int", group : "Appearance", defaultValue : 5},

				/**
				 * Number of columns that are fix on the left. When you use a horizontal scroll bar, only
				 * the columns which are not fixed, will scroll. Fixed columns need a defined width for the feature to work.
				 * Please note that the aggregated width of all fixed columns must not exceed the table width since there
				 * will be no scrollbar for fixed columns.
				 */
				fixedColumnCount : {type : "int", group : "Appearance", defaultValue : 0},

				/**
				 * Number of rows that are fix on the top. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
				 */
				fixedRowCount : {type : "int", group : "Appearance", defaultValue : 0},

				/**
				 * Number of rows that are fix on the bottom. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
				 * @since 1.18.7
				 */
				fixedBottomRowCount : {type : "int", group : "Appearance", defaultValue : 0},

				/**
				 * Flag whether to show or hide the column menu item to freeze or unfreeze a column.
				 * @since 1.21.0
				 */
				enableColumnFreeze : {type : "boolean", group : "Behavior", defaultValue : false},

				/**
				 * Flag whether to enable or disable the context menu on cells to trigger a filtering with the cell value.
				 * @since 1.21.0
				 */
				enableCellFilter : {type : "boolean", group : "Behavior", defaultValue : false},

				/**
				 * Setting this property to true will show an overlay on top of the Table content and users cannot click anymore on the Table content.
				 * @since 1.21.2
				 */
				showOverlay : {type : "boolean", group : "Appearance", defaultValue : false},

				/**
				 * Specifies if a select all button should be displayed in the top left corner. This button is only displayed
				 * if the row selector is visible and the selection mode is set to any kind of multi selection.
				 * @since 1.23.0
				 */
				enableSelectAll : {type : "boolean", group : "Behavior", defaultValue : true},

				/**
				 * Set this parameter to true to implement your own filter behaviour. Instead of the filter input box a button
				 * will be rendered for which' press event (customFilter) you can register an event handler.
				 * @since 1.23.0
				 */
				enableCustomFilter : {type : "boolean", group : "Behavior", defaultValue : false},

				/**
				 * Set this parameter to true to make the table handle the busy indicator by its own.
				 * The table will switch to busy as soon as it scrolls into an unpaged area. This feature can only
				 * be used when the navigation mode is set to scrolling.
				 * @since 1.27.0
				 */
				enableBusyIndicator : {type : "boolean", group : "Behavior", defaultValue : false},

				/**
				 * Flag to enable or disable column reordering
				 * @deprecated Since version 1.5.2.
				 * Use the property enableColumnReordering instead.
				 */
				allowColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},

				/**
				 * This text is shown, in case there is no data available to be displayed in the Table and no custom noData control is set.
				 * @since 1.21.0
				 * @deprecated Since version 1.22.1.
				 * The aggregation noData also supports string values now. Use noData instead.
				 */
				noDataText : {type : "string", group : "Appearance", defaultValue : null, deprecated: true},

				/**
				 * Flag to enable or disable expanding of first level.
				 */
				expandFirstLevel : {type : "boolean", defaultValue : false},

				/**
				 * If group mode is enable nodes with subitems are rendered as if they were group headers.
				 * This can be used to do the grouping for an OData service on the backend and visualize this in a table.
				 * This mode only makes sense if the tree has a depth of exacly 1 (group headers and entries)
				 */
				useGroupMode : {type : "boolean", group : "Appearance", defaultValue : false},

				/**
				 * The property name of the rows data which will be displayed as a group header if the group mode is enabled
				 */
				groupHeaderProperty : {type : "string", group : "Data", defaultValue : null},

				/**
				 * Setting collapseRecursive to true means, that when collapsing a node all subsequent child nodes will also be collapsed.
				 * This property is only supported with sap.ui.model.odata.v2.ODataModel
				 */
				collapseRecursive : {type: "boolean", defaultValue: true},

				/**
				 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
				 * This property is only supported when the TreeTable uses an underlying odata services with hierarchy annotations.
				 * This property is only supported with sap.ui.model.odata.v2.ODataModel
				 * The hierarchy annotations may also be provided locally as a parameter for the ODataTreeBinding.
				 */
				rootLevel : {type: "int", group: "Data", defaultValue: 0},

				/**
				 * Count of visible rows when expanded
				 */
				expandedVisibleRowCount : {type : "int", defaultValue : null},

				/**
				 * Flag whether the Table is expanded or not
				 */
				expanded : {type : "boolean", defaultValue : false},

				/**
				 * Flag, whether the table displays its content hierarchical or not (**experimental**!!)
				 */
				hierarchical : {type : "boolean", defaultValue : false}
			},
			defaultAggregation : "columns",
			aggregations : {

				/**
				 * Control or text of title section of the Table (if not set it will be hidden)
				 */
				title : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

				/**
				 * Control or text of footer section of the Table (if not set it will be hidden)
				 */
				footer : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

				/**
				 * Toolbar of the Table (if not set it will be hidden)
				 */
				toolbar : {type : "sap.ui.core.Toolbar", multiple : false},

				/**
				 * Extension section of the Table (if not set it will be hidden)
				 */
				extension : {type : "sap.ui.core.Control", multiple : true, singularName : "extension"},

				/**
				 * Columns of the Table
				 */
				columns : {type : "sap.ui.table.Column", multiple : true, singularName : "column", bindable : "bindable"},

				/**
				 * Rows of the Table
				 */
				rows : {type : "sap.ui.table.Row", multiple : true, singularName : "row", bindable : "bindable"},

				/**
				 * The value for the noData aggregation can be either a string value or a control instance.
				 * The control is shown, in case there is no data for the Table available. In case of a string
				 * value this will simply replace the no data text.
				 */
				noData : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}
			},
			associations : {

				/**
				 * Group By Column (experimental!)
				 */
				groupBy : {type : "sap.ui.table.Column", multiple : false}
			},
			events : {

				/**
				 * fired when the row selection of the table has been changed (the event parameters can be used to determine
				 * selection changes - to find out the selected rows you should better use the table selection API)
				 */
				rowSelectionChange : {
					parameters : {

						/**
						 * row index which has been clicked so that the selection has been changed (either selected or deselected)
						 */
						rowIndex : {type : "int"},

						/**
						 * binding context of the row which has been clicked so that selection has been changed
						 */
						rowContext : {type : "object"},

						/**
						 * array of row indices which selection has been changed (either selected or deselected)
						 */
						rowIndices : {type : "int[]"}
					}
				},

				/**
				 * fired when a column of the table has been selected
				 */
				columnSelect : {allowPreventDefault : true,
					parameters : {

						/**
						 * reference to the selected column
						 */
						column : {type : "sap.ui.table.Column"}
					}
				},

				/**
				 * fired when a table column is resized.
				 */
				columnResize : {allowPreventDefault : true,
					parameters : {

						/**
						 * resized column.
						 */
						column : {type : "sap.ui.table.Column"},

						/**
						 * new width of the table in pixel.
						 */
						width : {type : "int"}
					}
				},

				/**
				 * fired when a table column is moved.
				 */
				columnMove : {allowPreventDefault : true,
					parameters : {

						/**
						 * moved column.
						 */
						column : {type : "sap.ui.table.Column"},

						/**
						 * new position of the column.
						 */
						newPos : {type : "int"}
					}
				},

				/**
				 * fired when the table is sorted.
				 */
				sort : {allowPreventDefault : true,
					parameters : {

						/**
						 * sorted column.
						 */
						column : {type : "sap.ui.table.Column"},

						/**
						 * Sort Order
						 */
						sortOrder : {type : "sap.ui.table.SortOrder"},

						/**
						 * If column was added to sorter this is true. If new sort is started this is set to false
						 */
						columnAdded : {type : "boolean"}
					}
				},

				/**
				 * fired when the table is filtered.
				 */
				filter : {allowPreventDefault : true,
					parameters : {

						/**
						 * filtered column.
						 */
						column : {type : "sap.ui.table.Column"},

						/**
						 * filter value.
						 */
						value : {type : "string"}
					}
				},

				/**
				 * fired when the table is grouped (experimental!).
				 */
				group : {allowPreventDefault : true,
					parameters : {

						/**
						 * grouped column.
						 */
						column : {type : "sap.ui.table.Column"}
					}
				},

				/**
				 * fired when the visibility of a table column is changed.
				 */
				columnVisibility : {allowPreventDefault : true,
					parameters : {

						/**
						 * affected column.
						 */
						column : {type : "sap.ui.table.Column"},

						/**
						 * new value of the visible property.
						 */
						visible : {type : "boolean"}
					}
				},

				/**
				 * fired when the user clicks a cell of the table (experimental!).
				 * @since 1.21.0
				 */
				cellClick : {allowPreventDefault : true,
					parameters : {

						/**
						 * The control of the cell.
						 */
						cellControl : {type : "sap.ui.core.Control"},

						/**
						 * Row index of the selected cell.
						 */
						rowIndex : {type : "int"},

						/**
						 * Column index of the selected cell.
						 */
						columnIndex : {type : "int"}
					}
				},

				/**
				 * fired when the user clicks a cell of the table (experimental!).
				 * @since 1.21.0
				 */
				cellContextmenu : {allowPreventDefault : true,
					parameters : {

						/**
						 * The control of the cell.
						 */
						cellControl : {type : "sap.ui.core.Control"},

						/**
						 * Row index of the selected cell.
						 */
						rowIndex : {type : "int"},

						/**
						 * Column index of the selected cell.
						 */
						columnIndex : {type : "int"}
					}
				},

				/**
				 * fired when a column of the table should be freezed
				 * @since 1.21.0
				 */
				columnFreeze : {allowPreventDefault : true,
					parameters : {

						/**
						 * reference to the column to freeze
						 */
						column : {type : "sap.ui.table.Column"}
					}
				},

				/**
				 * This event is triggered when the custom filter item of the column menu is pressed. The column on which the event was triggered is passed as parameter.
				 * @since 1.23.0
				 */
				customFilter : {},
				/**
				 * fired when a node has been expanded or collapsed (only available in hierachical mode)
				 */
				toggleOpenState : {
					parameters : {

						/**
						 * index of the expanded/collapsed row
						 */
						rowIndex : {type : "int"},

						/**
						 * binding context of the selected row
						 */
						rowContext : {type : "object"},

						/**
						 * flag whether the node has been expanded or collapsed
						 */
						expanded : {type : "boolean"}
					}
				},

				/**
				 * fired when the row selection of the table has been changed
				 */
				rowSelect : {
					parameters : {

						/**
						 * row index which row has been selected or deselected
						 */
						rowIndex : {type : "int"},

						/**
						 * binding context of the row index which row has been selected or deselected
						 */
						rowContext : {type : "object"},

						/**
						 * array of row indices which selection has been changed (either selected or deselected)
						 */
						rowIndices : {type : "int[]"}
					}
				}
			}
		}});
































		// =============================================================================
		// BASIC CONTROL API
		// =============================================================================

		DataTable.ResizeTrigger = new IntervalTrigger(300);

		IconPool.insertFontFaceStyle();

		/**
		 * Initialization of the Table control
		 * @private
		 */
		DataTable.prototype.init = function() {

			// create an information object which contains always required infos
			this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
			this._bAccMode = sap.ui.getCore().getConfiguration().getAccessibility();
			this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL();

			// basic selection model (by default the table uses multi selection)
			this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);

			// minimum width of a table column in pixel:
			// should at least be larger than the paddings for cols and cells!
			this._iColMinWidth = 20;
			if ('ontouchstart' in document) {
				this._iColMinWidth = 88;
			}

			this._oCalcColumnWidths = [];

			// columns to cells map
			this._aIdxCols2Cells = [];

			// visible columns
			this._aVisibleColumns = [];

			// we add a delegate to enable to focus the scrollbar when clicking on them
			// to avoid that the table control grabs the focus and scrolls to the focus
			// element (hide the outline)
			var fnFocusIndex = {
				onAfterRendering: function(oEvent) {
					oEvent.srcControl.$("sb").attr("tabindex", "-1").css("outline", "none");
				}
			};

			// vertical scrollbar
			this._oVSb = new ScrollBar(this.getId() + "-vsb", {size: "100%"});
			this._oVSb.attachScroll(this.onvscroll, this);
			this._oVSb.addDelegate(fnFocusIndex);

			// horizontal scrollbar (configure by default for the pixel mode)
			this._oHSb = new ScrollBar(this.getId() + "-hsb", {size: "100%", contentSize: "0px", vertical: false});
			this._oHSb.attachScroll(this.onhscroll, this);
			this._oHSb.addDelegate(fnFocusIndex);

			// action mode flag (for keyboard navigation)
			this._bActionMode = false;

			// column index of the last fixed column (to prevent column reordering!)
			this._iLastFixedColIndex = -1;

			// flag whether the editable property should be inherited or not
			this._bInheritEditableToControls = false;

			// text selection for column headers?
			this._bAllowColumnHeaderTextSelection = false;

			// flag, whether to call _updateTableCell on cell control or not?
			this._bCallUpdateTableCell = false;

			// timer delay in ms
			this._iTimerDelay = 250;

			this._doubleclickDelay = 300;
			this._clicksRegistered = 0;

			// determine whether jQuery version is less than 1.8 (height and width behaves different!!)
			this._bjQueryLess18 = jQuery.sap.Version(jQuery.fn.jquery).compareTo("1.8") < 0;
			this._iDataRequestedCounter = 0;
			this._bDataRequestedListenersAttached = false;

			// F6 Handling is done in TableRenderer to make sure the table content gets the focus. The
			// Toolbar has its own F6 stop.
			// this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling

			this._iLastFixedColIndex = 0;

			// adopting properties and load icon fonts for bluecrystal
			if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal" ||
				sap.ui.getCore().getConfiguration().getTheme() === "sap_hcb") {

				// add the icon fonts
				jQuery.sap.require("sap.ui.core.IconPool");
				sap.ui.core.IconPool.insertFontFaceStyle();

				// defaulting the rowHeight
				// this.setRowHeight(32); --> is done via CSS

			}

			this._bInheritEditableToControls = true;

			// default values for DataTable
			this.setEditable(false);
			this.setSelectionBehavior(sap.ui.table.SelectionBehavior.Row);

			this.attachRowSelectionChange(function(oEvent) {
				this.fireRowSelect(oEvent.mParameters);
			});

			this._iLastFixedColIndex = -1;
		};


		/**
		 * Termination of the Table control
		 * @private
		 */
		DataTable.prototype.exit = function() {
			// destroy the child controls
			this._oVSb.destroy();
			this._oHSb.destroy();
			if (this._oPaginator) {
				this._oPaginator.destroy();
			}
			// destroy helpers
			this._destroyItemNavigation();
			// cleanup
			this._cleanUpTimers();
			this._detachEvents();
		};


		/**
		 * theme changed
		 * @private
		 */
		DataTable.prototype.onThemeChanged = function() {
			if (this.getDomRef()) {
				this.invalidate();
			}
		};


		/**
		 * Rerendering handling
		 * @private
		 */
		DataTable.prototype.onBeforeRendering = function() {
			this._cleanUpTimers();
			this._detachEvents();
		};


		/**
		 * Rerendering handling
		 * @private
		 */
		DataTable.prototype.onAfterRendering = function() {

			this._bOnAfterRendering = true;

			var $this = this.$();

			if ('ontouchstart' in document) {
				$this.addClass("sapUiTableTouch");
			}

			this._renderOverlay();
			this._updateVSb(true);
			this._updateTableContent();
			this._handleResize();

			this._attachEvents();

			// restore the column icons
			var aCols = this.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].getVisible()) {
					aCols[i]._restoreIcons();
				}
			}

			// enable/disable text selection for column headers
			if (!this._bAllowColumnHeaderTextSelection) {
				this._disableTextSelection($this.find(".sapUiTableColHdrCnt"));
			}

			this._bOnAfterRendering = false;

			this._initItemNavigation();

			if (this._bDetermineVisibleCols === true) {
				this._determineVisibleCols();
				this._bDetermineVisibleCols = false;
			}

			this.$().find("[role=grid]").attr("role", "treegrid");
		};

		/**
		 * Render overlay div
		 * @private
		 */
		DataTable.prototype._renderOverlay = function() {
			var $this = this.$(),
				$overlay = $this.find(".sapUiTableOverlay"),
				bShowOverlay = this.getShowOverlay();
			if (bShowOverlay && $overlay.length === 0) {
				$overlay = jQuery("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index", "1");
				$this.append($overlay);
			} else if (!bShowOverlay) {
				$overlay.remove();
			}
		};

		DataTable.prototype.setShowOverlay = function(bShow) {
			this.setProperty("showOverlay", bShow, true);
			this._renderOverlay();
			return this;
		};

		/**
		 * update the table content (scrollbar, no data overlay, selection, row header, ...)
		 * @private
		 */
		DataTable.prototype._updateTableContent = function() {
			// show or hide the no data container
			this._updateNoData();

			// update the selection visualization
			this._updateSelection();

			// update the rows (TODO: generalize this for 1.6)
			if (this._modifyRow) {
				jQuery.each(this.getRows(), function (iIndex, oRow) {
					this._modifyRow(iIndex + this.getFirstVisibleRow(), oRow.$());
					this._modifyRow(iIndex + this.getFirstVisibleRow(), oRow.$("fixed"));
				}.bind(this));
			}

			var oBinding = this.getBinding("rows");
			var iFixedTopRows = this.getFixedRowCount();
			var iFixedBottomRows = this.getFixedBottomRowCount();
			var iVisibleRowCount = this.getVisibleRowCount();

			if (oBinding) {
				jQuery.each(this.getRows(), function (iIndex, oRow) {
					var $rowDomRefs = oRow.getDomRefs(true);

					// update row header tooltip
					if (oRow.getBindingContext()) {
						$rowDomRefs.rowSelector.attr("title", this._oResBundle.getText("TBL_ROW_SELECT"));
					} else {
						$rowDomRefs.rowSelector.attr("title", "");
					}

					if (iFixedTopRows > 0) {
						$rowDomRefs.row.toggleClass("sapUiTableFixedTopRow", iIndex < iFixedTopRows);
						$rowDomRefs.row.toggleClass("sapUiTableFixedLastTopRow", iIndex == iFixedTopRows - 1);
					}

					if (iFixedBottomRows > 0) {
						var bIsPreBottomRow;
						if (oBinding.getLength() >= iVisibleRowCount) {
							bIsPreBottomRow = (iIndex == iVisibleRowCount - iFixedBottomRows - 1);
						} else {
							bIsPreBottomRow = (this.getFirstVisibleRow() + iIndex) == (oBinding.getLength() - iFixedBottomRows - 1) && (this.getFirstVisibleRow() + iIndex) < oBinding.getLength();
						}

						$rowDomRefs.row.toggleClass("sapUiTableFixedPreBottomRow", bIsPreBottomRow);
					}
				}.bind(this));
			}

			// update the row header (sync row heights)
			this._updateRowHeader();

			// hook for update table cell after rendering is complete
			if (this._bOnAfterRendering && (this._bCallUpdateTableCell || typeof this._updateTableCell === "function")) {
				var oBindingInfo = this.mBindingInfos["rows"];
				jQuery.each(this.getRows(), function (iIndex, oRow) {
					var iAbsoluteRowIndex = this.getFirstVisibleRow() + iIndex; //get the absolute row index

					jQuery.each(oRow.getCells(), function (iIndex, oCell) {
						if (oCell._updateTableCell) {
							oCell._updateTableCell(oCell /* cell control */,
								oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
								oCell.$().closest("td") /* jQuery object for td */,
								iAbsoluteRowIndex);
						}
						if (this._updateTableCell) {
							this._updateTableCell(oCell /* cell control */,
								oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
								oCell.$().closest("td") /* jQuery object for td */,
								iAbsoluteRowIndex);
						}
					});
				}.bind(this));
			}

			if (this.getHierarchical()) {
				//If group mode is enabled nodes which have children are visualized as if they were group header
				var oBinding = this.getBinding("rows"),
					iFirstRow = this.getFirstVisibleRow(),
					iCount = this.getVisibleRowCount(),
					iFixedBottomRowCount = this.getFixedBottomRowCount(),
					iFirstFixedBottomRowIndex = iCount - iFixedBottomRowCount;

				var iIndex = iFirstRow;

				for (var iRow = 0; iRow < iCount; iRow++) {
					if (iFixedBottomRowCount > 0 && iRow >= iFirstFixedBottomRowIndex) {
						iIndex = oBinding.getLength() - iCount + iRow;
					} else {
						iIndex = iFirstRow + iRow;
					}

					var oContext = this.getContextByIndex(iIndex),
						$DomRefs = this.getRows()[iRow].getDomRefs(true),
						$row = $DomRefs.rowFixedPart || $DomRefs.rowScrollPart;

					this._updateExpandIcon($row, oContext, iIndex);

					if (this.getUseGroupMode()) {
						var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
						if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
							// modify the rows
							$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
							var sClass = oBinding.isExpanded(iFirstRow + iRow) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
							$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + this.getModel().getProperty(this.getGroupHeaderProperty(), oContext) + "</div>");
							$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
						} else {
							$row.removeClass("sapUiTableGroupHeader");
							if (oContext) {
								$row.removeClass("sapUiTableRowHidden");
							}
							$rowHdr.html("");
							$rowHdr.removeClass("sapUiTableGroupHeader");
						}
					}
				}
			}
		};


		// =============================================================================
		// ITEMNAVIGATION
		// =============================================================================


		/**
		 * initialize ItemNavigation. Transfer relevant controls to ItemNavigation.
		 * TabIndexes are set by ItemNavigation
		 * @private
		 */
		DataTable.prototype._initItemNavigation = function() {

			var $this = this.$();
			var iColumnCount = this._getVisibleColumnCount();
			var iTotalColumnCount = iColumnCount;
			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;

			// initialization of item navigation for the Column Headers
			if (!this._oColHdrItemNav) {
				this._oColHdrItemNav = new ItemNavigation();
				this._oColHdrItemNav.setCycling(false);
				this.addDelegate(this._oColHdrItemNav);
			}

			// create the list of item dom refs
			var aItemDomRefs = [];
			if (this.getFixedColumnCount() == 0) {
				aItemDomRefs = $this.find(".sapUiTableCtrl td[tabindex]").get();
			} else {
				var $topLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');
				var $topRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');
				var $middleLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');
				var $middleRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');
				var $bottomLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');
				var $bottomRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');
				for (var i = 0; i < this.getVisibleRowCount(); i++) {
					aItemDomRefs = aItemDomRefs.concat($topLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
					aItemDomRefs = aItemDomRefs.concat($topRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
					aItemDomRefs = aItemDomRefs.concat($middleLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
					aItemDomRefs = aItemDomRefs.concat($middleRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
					aItemDomRefs = aItemDomRefs.concat($bottomLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
					aItemDomRefs = aItemDomRefs.concat($bottomRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				}
			}

			// to later determine the position of the first TD in the aItemDomRefs we keep the
			// count of TDs => aCount - TDs = first TD (add the row headers to the TD count / except the first one!)
			var iTDCount = aItemDomRefs.length;
			var iInitialIndex = 0;

			// add the row header items (if visible)
			if (bHasRowHeader) {
				var aRowHdrDomRefs = $this.find(".sapUiTableRowHdr").get();
				for (var i = aRowHdrDomRefs.length - 1; i >= 0; i--) {
					aItemDomRefs.splice(i * iColumnCount, 0, aRowHdrDomRefs[i]);
					// we ignore the row headers
					iTDCount++;
				}
				// except the first row header
				iTDCount--;
				// add the row header to the column count
				iTotalColumnCount++;
				iInitialIndex = 1;
			}

			// add the column items
			if (this.getColumnHeaderVisible()) {
				aItemDomRefs = $this.find(".sapUiTableCol").get().concat(aItemDomRefs);
			}

			// add the select all item
			if (bHasRowHeader && this.getColumnHeaderVisible()) {
				var aRowHdr = $this.find(".sapUiTableColRowHdr").get();
				for (var i = this._getHeaderRowCount() - 1; i >= 0; i--) {
					aItemDomRefs.splice(i * iColumnCount, 0, aRowHdr[0]);
				}
			}

			// initialization of item navigation for the Table control
			if (!this._oItemNavigation) {
				this._iLastSelectedDataRow = this._getHeaderRowCount();
				this._oItemNavigation = new ItemNavigation();
				this._oItemNavigation.setTableMode(true);
				this._oItemNavigation.attachEvent(ItemNavigation.Events.BeforeFocus, function(oEvent) {
					this.$("ariadesc").text("");
				}, this);
				this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, function(oEvent) {
					var iRow = Math.floor(oEvent.getParameter("index") / this._oItemNavigation.iColumns);
					if (iRow > 0) {
						this._iLastSelectedDataRow = iRow;
					}
				}, this);
				this.addDelegate(this._oItemNavigation);
			}

			// configure the item navigation
			this._oItemNavigation.setColumns(iTotalColumnCount);
			this._oItemNavigation.setRootDomRef($this.find(".sapUiTableCnt").get(0));
			this._oItemNavigation.setItemDomRefs(aItemDomRefs);
			this._oItemNavigation.setFocusedIndex(iInitialIndex);

		};

		/**
		 * destroys ItemNavigation
		 * @private
		 */
		DataTable.prototype._destroyItemNavigation = function() {

			// destroy of item navigation for the Table control
			if (this._oItemNavigation) {
				this._oItemNavigation.destroy();
				this._oItemNavigation = undefined;
			}

		};


		/*
		 * @see JSDoc generated by SAPUI5 control
		 */
		DataTable.prototype.getFocusInfo = function() {
			var sId = this.$().find(":focus").attr("id");
			if (sId) {
				return {customId: sId};
			} else {
				return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control
		 */
		DataTable.prototype.applyFocusInfo = function(mFocusInfo) {
			if (mFocusInfo && mFocusInfo.customId) {
				this.$().find("#" + mFocusInfo.customId).focus();
			} else {
				sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
			}
			return this;
		};


		// =============================================================================
		// PUBLIC TABLE API
		// =============================================================================


		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setTitle = function(vTitle) {
			var oTitle = vTitle;
			if (typeof (vTitle) === "string" || vTitle instanceof String) {
				oTitle = sap.ui.table.TableHelper.createTextView({
					text: vTitle,
					width: "100%"
				});
				oTitle.addStyleClass("sapUiTableHdrTitle");
			}
			this.setAggregation("title", oTitle);
			return this;
		};


		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setFooter = function(vFooter) {
			var oFooter = vFooter;
			if (typeof (vFooter) === "string" || vFooter instanceof String) {
				oFooter = sap.ui.table.TableHelper.createTextView({
					text: vFooter,
					width: "100%"
				});
			}
			this.setAggregation("footer", oFooter);
			return this;
		};


		/**
		 * Sets the selection mode. The current selection is lost.
		 * @param {string} sSelectionMode the selection mode, see sap.ui.DataTable.SelectionMode
		 * @public
		 * @return a reference on the table for chaining
		 */
		DataTable.prototype.setSelectionMode = function(sSelectionMode) {
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding.clearSelection) {
				oBinding.clearSelection();
				this.setProperty("selectionMode", sSelectionMode);
			} else {
				this.clearSelection();
				if (sSelectionMode === sap.ui.table.SelectionMode.Single) {
					this._oSelection.setSelectionMode(SelectionModel.SINGLE_SELECTION);
				} else {
					this._oSelection.setSelectionMode(SelectionModel.MULTI_SELECTION);
				}
				this.setProperty("selectionMode", sSelectionMode);
			}

			return this;
		};


		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setFirstVisibleRow = function(iRowIndex, bOnScroll) {
			// TODO: think about this optimization - for now it doesn't work since
			//       this API is used to update the rows afterwards
			//if (iRowIndex !== this.getFirstVisibleRow()) {
			// update the property

			this.setProperty("firstVisibleRow", iRowIndex, true);
			// update the bindings:
			//  - prevent the rerendering
			//  - use the databinding fwk to update the content of the rows
			if (this.getBinding("rows") && !this._bRefreshing) {
				this.updateRows();
			}

			this._updateAriaRowOfRowsText(true);

			if (bOnScroll && !this._$AriaLiveDomRef && this._bAccMode) {
				if (this._ariaLiveTimer) {
					jQuery.sap.clearDelayedCall(this._ariaLiveTimer);
				}

				var fnSetAriaLive = function() {
					if (this._oItemNavigation) {
						this._$AriaLiveDomRef = jQuery(this._oItemNavigation.getFocusedDomRef()).attr("aria-live", "rude");
						var oTable = this;
						var fnRemoveAriaLive = function () {
							if (oTable._$AriaLiveDomRef) {
								oTable._$AriaLiveDomRef.removeAttr("aria-live");
								delete oTable._$AriaLiveDomRef;
							}
						};
						jQuery.sap.delayedCall(0, this, fnRemoveAriaLive);
						delete this._ariaLiveTimer;
					}
				};

				this._ariaLiveTimer = jQuery.sap.delayedCall(60, this, fnSetAriaLive);
			}

			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.getAllowColumnReordering = function() {
			jQuery.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");
			return DataTable.prototype.getEnableColumnReordering.apply(this, arguments);
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setAllowColumnReordering = function() {
			jQuery.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");
			return DataTable.prototype.setEnableColumnReordering.apply(this, arguments);
		};

		/**
		 * Setter for property <code>fixedRowCount</code>.
		 *
		 * <b>This property is not supportd for the TreeTable and will be ignored!</b>
		 *
		 * Default value is <code>0</code>
		 *
		 * @param {int} iFixedRowCount  new value for property <code>fixedRowCount</code>
		 * @return {sap.ui.table.DataTable} <code>this</code> to allow method chaining
		 * @public
		 */
		DataTable.prototype.setFixedRowCount = function(iRowCount) {
			// this property makes no sense for the TreeTable
			if (!this.getHierarchical()) {
				this.setProperty("fixedRowCount", iRowCount);
			} else {
				jQuery.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");
			}
			return this;
		};

		// enable calling 'bindAggregation("rows")' without a factory
		DataTable.getMetadata().getAggregation("rows")._doesNotRequireFactory = true;

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.bindRows = function(oBindingInfo, vTemplate, oSorter, aFilters) {
			var sPath,
				oTemplate,
				aSorters,
				aFilters;

			// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
			if (typeof oBindingInfo == "string") {
				sPath = arguments[0];
				oTemplate = arguments[1];
				aSorters = arguments[2];
				aFilters = arguments[3];
				oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters, template: oTemplate};
			}

			if (typeof oBindingInfo === "object") {
				oBindingInfo.parameters = oBindingInfo.parameters || {};
				oBindingInfo.parameters.rootLevel = this.getRootLevel();
				oBindingInfo.parameters.collapseRecursive = this.getCollapseRecursive();
				// number of expanded levels is taken from the binding parameters first,
				// if not found, we check if they are set on the table
				oBindingInfo.parameters.numberOfExpandedLevels = oBindingInfo.parameters.numberOfExpandedLevels || (this.getExpandFirstLevel() ? 1 : 0);
				oBindingInfo.parameters.rootNodeID = oBindingInfo.parameters.rootNodeID;
			}

			//return Table.prototype.bindRows.call(this, oBindingInfo, vTemplate, oSorter, aFilters);
			return this.bindAggregation("rows", oBindingInfo);
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
			sap.ui.core.Element.prototype._bindAggregation.apply(this, arguments);
			var oBinding = this.getBinding("rows");
			if (sName === "rows" && oBinding) {
				oBinding.attachChange(this._onBindingChange, this);
			}

			// re-initialize the selection model, might be necessary in case the table gets "rebound"
			this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);

			return this;
		};

		/**
		 * Initialises a new selection model for the Table instance.
		 * @param {sap.ui.model.SelectionModel.MULTI_SELECTION|sap.ui.model.SelectionModel.SINGLE_SELECTION} sSelectionMode the selection mode of the selection model
		 * @return {sap.ui.table.DataTable} the table instance for chaining
		 * @private
		 */
		DataTable.prototype._initSelectionModel = function (sSelectionMode) {
			// detach old selection model event handler
			if (this._oSelection) {
				this._oSelection.detachSelectionChanged(this._onSelectionChanged, this);
			}
			//new selection model with the currently set selection mode
			this._oSelection = new sap.ui.model.SelectionModel(sSelectionMode);
			this._oSelection.attachSelectionChanged(this._onSelectionChanged, this);

			return this;
		};

		/**
		 * handler for change events of the binding
		 * @param {sap.ui.base.Event} oEvent change event
		 * @private
		 */
		DataTable.prototype._onBindingChange = function(oEvent) {
			var sReason = typeof (oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
			if (sReason === "sort" || sReason === "filter") {
				this.clearSelection();
				this.setFirstVisibleRow(0);
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.unbindAggregation = function(sName, bSuppressReset) {
			var oBinding = this.getBinding("rows");
			if (sName === "rows" && oBinding) {
				oBinding.detachChange(this._onBindingChange);
				//Reset needs to be resetted, else destroyRows is called, which is not allowed to be called
				bSuppressReset = true;
				this._restoreAppDefaultsColumnHeaderSortFilter();
			}
			this.updateRows(); // TODO: shouldn't this be more a central feature?!
			return sap.ui.core.Element.prototype.unbindAggregation.apply(this, [sName, bSuppressReset]);
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setVisibleRowCountMode = function(oVisibleRowCountMode) {
			this.setProperty("visibleRowCountMode", oVisibleRowCountMode);
			this._handleRowCountMode();
			return this;
		};

		DataTable.prototype.setExpanded = function(bExpanded) {
			this.setProperty("expanded", bExpanded, true);
			if (this.getExpandedVisibleRowCount() > 0) {
				var iVisibleRowCount = bExpanded ? this.getExpandedVisibleRowCount() : this._iVisibleRowCount;
				if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
					return this;
				}
				iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
				if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
					this.setProperty("firstVisibleRow", 0);
				}
				this.setProperty("visibleRowCount", iVisibleRowCount);
			}

			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setVisibleRowCount = function(iVisibleRowCount) {
			this._iVisibleRowCount = iVisibleRowCount;
			if (!this.getExpanded()) {
				if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
					return this;
				}
				iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
				if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
					this.setProperty("firstVisibleRow", 0);
				}
				this.setProperty("visibleRowCount", iVisibleRowCount);
			}

			return this;
		};

		DataTable.prototype.setExpandedVisibleRowCount = function(iVisibleRowCount) {
			this.setProperty("expandedVisibleRowCount", iVisibleRowCount, true);
			if (this.getExpanded()) {
				if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
					return this;
				}
				iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
				if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
					this.setProperty("firstVisibleRow", 0);
				}
				this.setProperty("visibleRowCount", iVisibleRowCount);
			}
			return this;
		};

		/**
		 * refresh rows
		 * @private
		 */
		DataTable.prototype.refreshRows = function(sReason) {
			this._bBusyIndicatorAllowed = true;
			this._attachBindingListener();
			var oBinding = this.getBinding("rows");
			if (oBinding && this.isTreeBinding("rows") && !oBinding.hasListeners("selectionChanged")) {
				oBinding.attachSelectionChanged(this._onSelectionChanged, this);
			}

			//needs to be called here to reset the firstVisible row so that the correct data is fetched
			this._bRefreshing = true;
			this._onBindingChange(sReason);
			this._updateBindingContexts(true);
			//this.getBinding()._init();
			this._bRefreshing = false;
		};

		/**
		 * updates the rows - called internally by the updateAggregation function when
		 * anything in the model has been changed.
		 * @private
		 */
		DataTable.prototype.updateRows = function(sReason) {
			this._setBusy(sReason ? {changeReason: sReason} : false);

			// by default the start index is the first visible row
			var iStartIndex = this.getFirstVisibleRow();

			// calculate the boundaries (at least 0 - max the row count - visible row count)
			iStartIndex = Math.max(iStartIndex, 0);
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar && this._getRowCount() > 0) {
				iStartIndex = Math.min(iStartIndex, Math.max(this._getRowCount() - this.getVisibleRowCount(), 0));
			}
			this.setProperty("firstVisibleRow", iStartIndex, true);

			// when not scrolling we update also the scroll position of the scrollbar
			if (this._oVSb.getScrollPosition() !== iStartIndex) {
				this._oVSb.setScrollPosition(iStartIndex);
				this._updateAriaRowOfRowsText(true);
			}

			// update the paginator
			if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				// if iStartIndex is equal or greater than the number of total rows go back to page 1
				var iNewPage = 1;
				if (iStartIndex < this.getBinding("rows").getLength()) {
					iNewPage = Math.ceil((iStartIndex + 1) / this.getVisibleRowCount());
				}
				if (iNewPage !== this._oPaginator.getCurrentPage()) {
					this.setProperty("firstVisibleRow", (iNewPage - 1) * this.getVisibleRowCount(), true);
					this._oPaginator.setCurrentPage(iNewPage);
					if (this._oPaginator.getDomRef()) {
						this._oPaginator.rerender();
					}
				}
			}

			// update the bindings only once the table is rendered
			if (this.getDomRef()) {
				// update the bindings by using a delayed mechanism to avoid to many update
				// requests: by using the mechanism below it will trigger an update each 50ms
				this._sBindingTimer = this._sBindingTimer || jQuery.sap.delayedCall(50, this, function() {
					// update only if control not marked as destroyed (could happen because updateRows is called during destroying the table)
					if (!this.bIsDestroyed) {
						this._determineVisibleCols();
						this._updateBindingContexts();
						this._updateVSb(); // this was moved here, before it was done before updatebindingContext
						this._updateTableContent();
						this._sBindingTimer = undefined;
						//Helper event for testing
						this.fireEvent("_rowsUpdated");
					}
				});
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.insertRow = function() {
			jQuery.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.addRow = function() {
			jQuery.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.removeRow = function() {
			jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.removeAllRows = function() {
			jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.destroyRows = function() {
			jQuery.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");
		};

		/**
		 * triggers automatic resizing of a column to the widest content.(experimental!)
		 * @experimental Experimental! Presently implemented to only work with pure text-based controls,
		 * the sap.ui.commons.Checkbox and sap.m.Image as well as sap.ui.commons.Image.
		 * It will also work for most simple input fields (TextField, CheckBox, but not ComboBox)
		 *
		 * @param {int} iColId column id
		 * @return {sap.ui.table.DataTable} instance of the table for method chaining
		 * @function
		 * @public
		 */
		DataTable.prototype.autoResizeColumn = function(iColId) {
			var oCol = this.getColumns()[iColId];
			this._iColumnResizeStart = null;
			var iNewWidth = this._calculateAutomaticColumnWidth(iColId);
			if (iNewWidth == null) {
				return this;
			}

			oCol._iNewWidth = iNewWidth;
			this._oCalcColumnWidths[iColId] = oCol._iNewWidth;
			this._onColumnResized(null, iColId);

			return this;
		};


		// =============================================================================
		// EVENT HANDLING & CLEANUP
		// =============================================================================

		/**
		 * attaches the required native event handlers
		 * @private
		 */
		DataTable.prototype._attachEvents = function() {

			var $this = this.$();

			// listen to the scroll events of the containers (for keyboard navigation)
			$this.find(".sapUiTableColHdrScr").scroll(jQuery.proxy(this._oncolscroll, this));
			$this.find(".sapUiTableCtrlScr").scroll(jQuery.proxy(this._oncntscroll, this));
			$this.find(".sapUiTableCtrlScrFixed").scroll(jQuery.proxy(this._oncntscroll, this));

			// sync row header > content (hover effect)
			$this.find(".sapUiTableRowHdr").hover(function() {
				jQuery(this).addClass("sapUiTableRowHvr");
				var iIndex = $this.find(".sapUiTableRowHdr").index(this);
				$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			}, function() {
				jQuery(this).removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
			});

			// sync content fixed > row header (hover effect)
			$this.find(".sapUiTableCtrlFixed > tbody > tr").hover(function() {
				jQuery(this).addClass("sapUiTableRowHvr");
				var iIndex = $this.find(".sapUiTableCtrlFixed > tbody > tr").index(this);
				$this.find(".sapUiTableRowHdr").filter(":eq(" + (iIndex) + ")").addClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			}, function() {
				jQuery(this).removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
			});

			// sync content scroll > row header (hover effect)
			$this.find(".sapUiTableCtrlScroll > tbody > tr").hover(function() {
				jQuery(this).addClass("sapUiTableRowHvr");
				var iIndex = $this.find(".sapUiTableCtrlScroll > tbody > tr").index(this);
				$this.find(".sapUiTableRowHdr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			}, function() {
				jQuery(this).removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
				$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
			});

			// listen to the resize handlers
			$this.find(".sapUiTableColRsz").mousedown(jQuery.proxy(this._onColumnResizeStart, this));

			this._enableColumnAutoResizing();
			DataTable.ResizeTrigger.addListener(this._checkTableSize, this);

			// the vertical scrollbar listens to the mousewheel on the content section
			this._oHSb.bind($this.find(".sapUiTableCtrlScr").get(0));
			this._oVSb.bind($this.find(".sapUiTableCtrlScr").get(0));
			this._oHSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
			this._oVSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
			this._oVSb.bind($this.find(".sapUiTableRowHdrScr").get(0));

			jQuery("body").bind('webkitTransitionEnd transitionend',
				jQuery.proxy(function(oEvent) {
					if (jQuery(oEvent.target).has($this).length > 0) {
						this._handleResize();
					}
				}, this));
		};


		/**
		 * detaches the required native event handlers
		 * @private
		 */
		DataTable.prototype._detachEvents = function() {

			var $this = this.$();

			$this.find(".sapUiTableRowHdrScr").unbind();
			$this.find(".sapUiTableColHdrScr").unbind();

			$this.find(".sapUiTableCtrl > tbody > tr").unbind();
			$this.find(".sapUiTableRowHdr").unbind();

			DataTable.ResizeTrigger.removeListener(this._checkTableSize, this);

			$this.find(".sapUiTableColRsz").unbind();

			this._oHSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
			this._oVSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
			this._oHSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
			this._oVSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
			this._oVSb.unbind($this.find(".sapUiTableRowHdrScr").get(0));

			jQuery("body").unbind('webkitTransitionEnd transitionend');
		};


		/**
		 * cleanup the timers when not required anymore
		 * @private
		 */
		DataTable.prototype._cleanUpTimers = function() {

			if (this._sBindingTimer) {
				jQuery.sap.clearDelayedCall(this._sBindingTimer);
				this._sBindingTimer = undefined;
			}

			if (this._sScrollBarTimer) {
				jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
				this._sScrollBarTimer = undefined;
			}

			if (this._sDelayedMenuTimer) {
				jQuery.sap.clearDelayedCall(this._sDelayedMenuTimer);
				this._sDelayedMenuTimer = undefined;
			}

			if (this._sDelayedActionTimer) {
				jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
				this._sDelayedActionTimer = undefined;
			}

			if (this._sColHdrPosTimer) {
				jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
				this._sColHdrPosTimer = undefined;
			}

			if (this._visibleRowCountTimer) {
				jQuery.sap.clearDelayedCall(this._visibleRowCountTimer);
				this._visibleRowCountTimer = undefined;
			}

			DataTable.ResizeTrigger.removeListener(this._checkTableSize, this);
		};


		// =============================================================================
		// PRIVATE TABLE STUFF :)
		// =============================================================================

		/**
		 *
		 * @param oBinding
		 * @returns {*}
		 * @private
		 */
		DataTable.prototype._getFixedBottomRowContexts = function (oBinding) {
			var iFixedBottomRowCount = this.getFixedBottomRowCount();
			var iVisibleRowCount = this.getVisibleRowCount();
			var aContexts;
			if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
				aContexts = oBinding.getContexts(oBinding.getLength() - iFixedBottomRowCount, iFixedBottomRowCount, 1);
			} else {
				aContexts = [];
			}

			return aContexts;
		};


		/**
		 * creates the rows for the rows aggregation
		 * @private
		 */
		DataTable.prototype._createRows = function(iStartIndex) {
			var iFirstVisibleRow = this.getFirstVisibleRow();
			var iVisibleRowCount = this.getVisibleRowCount();

			// by default the start index is the first visible row
			iStartIndex = iStartIndex === undefined ? iFirstVisibleRow : iStartIndex;

			// create the new template
			var oTemplate = new Row(this.getId() + "-rows");
			var aCols = this.getColumns();
			var iCellIndex = 0;
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].getVisible()) {
					var oColTemplate = aCols[i].getTemplate();
					if (oColTemplate) {
						var oClone = oColTemplate.clone("col" + i);
						// inherit the editable property if required to the child controls
						if (this._bInheritEditableToControls && !this.getEditable() && oClone.setEditable) {
							oClone.setEditable(false);
						}
						oClone.data("sap-ui-colindex", i);
						oTemplate.addCell(oClone);
						this._aIdxCols2Cells[i] = iCellIndex++;
					}
				}
			}

			// initially called without iStartIndex and iLength
			this.destroyAggregation("rows", true);
			var aContexts;
			var oBinding = this.getBinding("rows");
			var oBindingInfo = this.mBindingInfos["rows"];
			if (oBinding && iVisibleRowCount > 0) {
				// if thresholding is 0 then it is disabled and we forward 0 to the binding
				var iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
				var iFixedBottomRowCount = this.getFixedBottomRowCount();
				aContexts = oBinding.getContexts(iStartIndex, iVisibleRowCount - iFixedBottomRowCount, iThreshold);
				this._setBusy({
					requestedLength: iVisibleRowCount - iFixedBottomRowCount,
					receivedLength: aContexts.length,
					contexts: aContexts });

				var aFixedBottomContexts = [];
				aFixedBottomContexts = this._getFixedBottomRowContexts(oBinding);

				aContexts = aContexts.concat(aFixedBottomContexts);

				if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
					this._setBusy({
						requestedLength: iFixedBottomRowCount,
						receivedLength: aFixedBottomContexts.length,
						contexts: aFixedBottomContexts });
				}
			}
			for (var i = 0; i < iVisibleRowCount; i++) {
				var oClone = oTemplate.clone("row" + i); // TODO: Isn't the following required! + "-" + this.getId());
				if (aContexts && aContexts[i]) {
					oClone.setBindingContext(aContexts[i], oBindingInfo.model);
					oClone._bHidden = false;
				} else {
					if (oBindingInfo) {
						oClone.setBindingContext(null, oBindingInfo.model);
					} else {
						oClone.setBindingContext(null);
					}

					oClone._bHidden = true;
				}
				this.addAggregation("rows", oClone, true);
			}

			// destroy the template
			oTemplate.destroy();
		};


		/**
		 * updates the horizontal scrollbar
		 * @private
		 */
		DataTable.prototype._updateHSb = function() {

			// get the width of the container
			var $this = this.$();

			// apply the new content size
			var iColsWidth = $this.find(".sapUiTableCtrlScroll").width();
			if (!!sap.ui.Device.browser.safari) {
				iColsWidth = Math.max(iColsWidth, this._getColumnsWidth(this.getFixedColumnCount()));
			}

			// add the horizontal scrollbar
			if (iColsWidth > $this.find(".sapUiTableCtrlScr").width()) {
				// show the scrollbar
				if (!$this.hasClass("sapUiTableHScr")) {
					$this.addClass("sapUiTableHScr");

					if (!!sap.ui.Device.browser.safari) {
						var $sapUiTableColHdr = $this.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");
						// min-width on table elements does not work for safari
						if (this._bjQueryLess18) {
							$sapUiTableColHdr.width(iColsWidth);
						} else {
							$sapUiTableColHdr.outerWidth(iColsWidth);
						}
					}
				}

				var iScrollPadding = $this.find(".sapUiTableCtrlFixed").width();

				if ($this.find(".sapUiTableRowHdrScr:visible").length > 0) {
					iScrollPadding += $this.find(".sapUiTableRowHdrScr").width();
				}

				var $sapUiTableHSb = $this.find(".sapUiTableHSb");
				if (this._bRtlMode) {
					$sapUiTableHSb.css('padding-right', iScrollPadding + 'px');
				} else {
					$sapUiTableHSb.css('padding-left', iScrollPadding + 'px');
				}

				// When table has no fixed width, the scrollbar is not allowed to increase the width of the DataTable.
				// We define the max-width of the scrollbar to be limited by its parent width.
				var iMaximumScrollBarWidth = $sapUiTableHSb.parent().width();
				$sapUiTableHSb.css('max-width', iMaximumScrollBarWidth + "px");

				this._oHSb.setContentSize(iColsWidth + "px");

				if (this._oHSb.getDomRef()) {
					this._oHSb.rerender();
				}
			} else {
				// hide the scrollbar
				if ($this.hasClass("sapUiTableHScr")) {
					$this.removeClass("sapUiTableHScr");
					if (!!sap.ui.Device.browser.safari) {
						// min-width on table elements does not work for safari
						$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width", "");
					}
				}
			}

			this._syncHeaderAndContent();

		};


		/**
		 * updates the vertical scrollbar
		 * @private
		 */
		DataTable.prototype._updateVSb = function(bOnAfterRendering) {
			var $this = this.$();
			var bDoResize = false;
			var bForceUpdateVSb = false;
			var oBinding = this.getBinding("rows");
			if (oBinding) {

				// move the vertical scrollbar to the scrolling table only
				var iFixedRows = this.getFixedRowCount();
				if (iFixedRows > 0) {
					var iOffsetTop = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;
					this.$().find('.sapUiTableVSb').css('top', (iOffsetTop - 1) + 'px');
					bForceUpdateVSb = true;
				}
				var iFixedBottomRows = this.getFixedBottomRowCount();
				if (iFixedBottomRows > 0) {
					var iOffsetHeight = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;
					this.$().find('.sapUiTableVSb').css('height', iOffsetHeight + 'px');
					bForceUpdateVSb = true;
				}

				var iSteps = Math.max(0, (oBinding.getLength() || 0) - this.getVisibleRowCount());
				// check for paging mode or scrollbar mode
				if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
					// update the paginator (set the first visible row property)
					var iNumberOfPages = Math.ceil((oBinding.getLength() || 0) / this.getVisibleRowCount());
					this._oPaginator.setNumberOfPages(iNumberOfPages);
					var iPage = Math.min(iNumberOfPages, Math.ceil((this.getFirstVisibleRow() + 1) / this.getVisibleRowCount()));
					this.setProperty("firstVisibleRow", (Math.max(iPage,1) - 1) * this.getVisibleRowCount(), true);
					this._oPaginator.setCurrentPage(iPage);
					if (this._oPaginator.getDomRef()) {
						this._oPaginator.rerender();
					}
					if ($this.hasClass("sapUiTableVScr")) {
						$this.removeClass("sapUiTableVScr");
					}
				} else {
					// in case of scrollbar mode show or hide the scrollbar dependening on the
					// calculated steps:
					if (iSteps > 0) {
						if (!$this.hasClass("sapUiTableVScr")) {
							$this.addClass("sapUiTableVScr");
							bDoResize = true;
						}
					} else {
						//scroll to top when the scrollbar vanishes -> the binding length is smaller than the number of visible rows
						this.setFirstVisibleRow(0);

						if ($this.hasClass("sapUiTableVScr")) {
							$this.removeClass("sapUiTableVScr");
							bDoResize = true;
						}
					}
				}

				// update the scrollbar only if it is required
				if (bOnAfterRendering || bForceUpdateVSb || iSteps !== this._oVSb.getSteps() || this.getFirstVisibleRow() !== this._oVSb.getScrollPosition()) {
					jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
					// TODO: in case of bForceUpdateVSb the scrolling doesn't work anymore
					//       height changes of the scrollbar should not require a re-rendering!
					this._sScrollBarTimer = jQuery.sap.delayedCall(bOnAfterRendering ? 0 : 250, this, function() {

						this._oVSb.setSteps(iSteps);
						if (this._oVSb.getDomRef()) {
							this._oVSb.rerender();
						}
						this._oVSb.setScrollPosition(this.getFirstVisibleRow());

					});

				}

			} else {
				// check for paging mode or scrollbar mode
				if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
					// update the paginator (set the first visible row property)
					this._oPaginator.setNumberOfPages(0);
					this._oPaginator.setCurrentPage(0);
					if (this._oPaginator.getDomRef()) {
						this._oPaginator.rerender();
					}
				} else {
					if ($this.hasClass("sapUiTableVScr")) {
						$this.removeClass("sapUiTableVScr");
						bDoResize = true;
					}
				}
			}
			if (bDoResize && !this._bOnAfterRendering) {
				this._handleResize();
			}
		};


		/**
		 * updates the binding contexts of the currently visible controls
		 * @private
		 */
		DataTable.prototype._updateBindingContexts = function(bSuppressUpdate) {

			var aRows = this.getRows(),
				oBinding = this.getBinding("rows"),
				oBindinginfo = this.mBindingInfos["rows"],
				aFixedContexts,
				aContexts,
				aFixedBottomContexts,
				iFixedRows = this.getFixedRowCount(),
				iFixedBottomRows = this.getFixedBottomRowCount(),
				iVisibleRowCount = this.getVisibleRowCount();

			// fetch the contexts from the binding
			if (oBinding) {
				var iThreshold;
				if ((iFixedRows > 0 || iFixedBottomRows > 0) && aRows.length > 0) {
					// thresholding is deactivated when value is 0
					var iTotalFixedRows = iFixedRows + iFixedBottomRows;
					iThreshold = this.getThreshold() ? Math.max((this.getVisibleRowCount() - iTotalFixedRows), this.getThreshold()) : 0;
					var iRequestedLength = Math.max(0, aRows.length - iTotalFixedRows);
					aContexts = oBinding.getContexts(this.getFirstVisibleRow() + iFixedRows, iRequestedLength, iThreshold);
					this._setBusy({
						requestedLength: iRequestedLength,
						receivedLength: aContexts.length,
						contexts: aContexts });
					// static rows: we fetch the contexts without threshold to avoid loading
					// of unnecessary data. Make sure to fetch after the normal rows to avoid
					// outgoing double requests for the contexts.
					if (iFixedRows > 0) {
						aFixedContexts = oBinding.getContexts(0, iFixedRows);
						this._setBusy({
							requestedLength: iFixedRows,
							receivedLength: aFixedContexts.length,
							contexts: aFixedContexts });

						aContexts = aFixedContexts.concat(aContexts);
					}

					var aFixedBottomContexts = this._getFixedBottomRowContexts(oBinding);
					aContexts = aContexts.concat(aFixedBottomContexts);

					if (iFixedBottomRows > 0 && (iVisibleRowCount - iFixedBottomRows) < oBinding.getLength()) {
						this._setBusy({
							requestedLength: iFixedBottomRows,
							receivedLength: aFixedBottomContexts.length,
							contexts: aFixedBottomContexts });
					}
				} else if (aRows.length > 0) {
					// thresholding is deactivated when value is 0
					iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
					aContexts = oBinding.getContexts(this.getFirstVisibleRow(), aRows.length, iThreshold);
					this._setBusy({
						requestedLength: aRows.length,
						receivedLength: aContexts.length,
						contexts: aContexts });
				}
			}

			// update the binding contexts only for the visible columns
			//for (var iIndex = 0, iLength = this.getRows().length; iIndex < iLength; iIndex++) {
			if (!bSuppressUpdate) {
				for (var iIndex = aRows.length - 1; iIndex >= 0; iIndex--) {
					var oContext = aContexts ? aContexts[iIndex] : undefined;
					var oRow = aRows[iIndex];
					if (oRow) {
						//calculate the absolute row index, used by the Tree/AnalyticalTable to find the rendering infos for this row
						var iAbsoluteRowIndex = this.getFirstVisibleRow() + iIndex;
						this._updateRowBindingContext(oRow, oContext, oBindinginfo && oBindinginfo.model, iAbsoluteRowIndex);
					}
				}
			}

		};

		/**
		 * updates the binding context a row
		 * @param {sap.ui.table.Row} row to update
		 * @param {sap.ui.model.Context} binding context of the row
		 * @private
		 */
		DataTable.prototype._updateRowBindingContext = function(oRow, oContext, sModelName, iAbsoluteRowIndex) {
			var aCells = oRow.getCells();
			var $rowTargets = oRow.getDomRefs(true).row;

			// check for a context object (in case of grouping there could be custom context objects)
			oRow.setBindingContext(oContext, sModelName);
			if (oContext && oContext instanceof sap.ui.model.Context) {
				for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
					var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
					if (aCells[col]) {
						this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
					}
				}
				$rowTargets.removeClass("sapUiTableRowHidden");
				oRow._bHidden = false;
			} else {
				$rowTargets.addClass("sapUiTableRowHidden");
				$rowTargets.removeClass('sapUiTableFixedPreBottomRow sapUiTableFixedTopRow');

				oRow._bHidden = true;
				for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
					var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
					if (aCells[col]) {
						this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
					}
				}
			}
		};

		/**
		 * updates the binding context a cell
		 * @param {sap.ui.core.Control} control of the cell
		 * @param {sap.ui.model.Context} binding context of the cell
		 * @private
		 */
		DataTable.prototype._updateCellBindingContext = function(oCell, oContext, sModelName, iAbsoluteRowIndex) {
			//oCell.setBindingContext(oContext, sModelName);
			if (this._bCallUpdateTableCell && oCell._updateTableCell) {
				oCell._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
			if (typeof this._updateTableCell === "function") {
				this._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
		};

		/**
		 * check if data is available in the table
		 * @private
		 */
		DataTable.prototype._hasData = function() {
			var oBinding = this.getBinding("rows");
			if (!oBinding || (oBinding.getLength() || 0) === 0) {
				return false;
			}
			return true;
		};

		/**
		 * show or hide the no data container
		 * @private
		 */
		DataTable.prototype._updateNoData = function() {
			// no data?
			if (this.getShowNoData()) {
				var oBinding = this.getBinding("rows");
				if (!this._hasData()) {
					if (!this.$().hasClass("sapUiTableEmpty")) {
						this.$().addClass("sapUiTableEmpty");
					}
					// update the ARIA text for the row count
					this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [0]));
				} else {
					if (this.$().hasClass("sapUiTableEmpty")) {
						this.$().removeClass("sapUiTableEmpty");
					}
					// update the ARIA text for the row count
					this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [(oBinding.getLength() || 0)]));
				}
			}
		};


		/**
		 * determines the currently visible columns (used for simply updating only the
		 * controls of the visible columns instead of the complete row!)
		 * @private
		 */
		DataTable.prototype._determineVisibleCols = function() {

			// determine the visible colums
			var $this = this.$(),
				that = this;

			if ($this.hasClass("sapUiTableHScr")) {

				var bRtl = this._bRtlMode;

				// calculate the view port
				var iScrollLeft = this._oHSb.getNativeScrollPosition();
				if (bRtl && sap.ui.Device.browser.firefox && iScrollLeft < 0) {
					// Firefox deals with negative scrollPosition in RTL mode
					iScrollLeft = iScrollLeft * -1;
				}
				var iScrollRight = iScrollLeft + this._getScrollWidth();

				// has the view port changed?
				if (this._iOldScrollLeft !== iScrollLeft || this._iOldScrollRight !== iScrollRight || this._bForceVisibleColCalc) {

					// calculate the first and last visible column
					var iLeft = bRtl ? $this.find(".sapUiTableCtrlScroll").width() : 0;

					if ((sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox) && bRtl) {
						// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
						// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
						iLeft = 0;
					}

					this._aVisibleColumns = [];
					for (var i = 0, l = this.getFixedColumnCount(); i < l; i++) {
						this._aVisibleColumns.push(i);
					}
					var $ths = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");
					$ths.each(function(iIndex, oElement) {
						var iWidth = jQuery(oElement).width();
						if (bRtl && sap.ui.Device.browser.chrome) {
							iLeft -= iWidth;
						}
						if (iLeft + iWidth >= iScrollLeft && iLeft <= iScrollRight) {
							that._aVisibleColumns.push(parseInt(jQuery(oElement).data('sap-ui-headcolindex'),10));
						}
						if (!bRtl || (sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox)) {
							iLeft += iWidth;
						}
					});

					// keep the view port information (performance!!)
					this._iOldScrollLeft = iScrollLeft;
					this._iOldScrollRight = iScrollRight;
					this._bForceVisibleColCalc = false;
				}
			} else {
				this._aVisibleColumns = [];
				var aCols = this.getColumns();
				for (var i = 0, l = aCols.length; i < l; i++) {
					if (aCols[i].shouldRender()) {
						this._aVisibleColumns.push(i);
					}
				}
			}

		};

		/**
		 * enables automatic resizing on doubleclick on a column if the corresponding column attribute is set
		 * @experimental Experimental, only works with limited control set
		 * @function
		 * @private
		 */
		DataTable.prototype._enableColumnAutoResizing = function (){
			var that = this;
			jQuery.each(this.getColumns(), function (iIndex, oCol){
				if (!!oCol.getAutoResizable()){
					var $resizer = jQuery.find(".sapUiTableColRsz[data-sap-ui-colindex=" + iIndex + "]");
					if ($resizer){
						that._bindSimulatedDoubleclick($resizer, null /* fnSingleClick*/, that._onAutomaticColumnResize /* fnDoubleClick */);
					}
				}
			});
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.removeColumn = function (oColumn) {
			var oResult = this.removeAggregation('columns', oColumn);
			this._bDetermineVisibleCols = true;
			return oResult;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.addColumn = function (oColumn) {
			var that = this;
			this.addAggregation('columns', oColumn);
			oColumn.attachEvent('_widthChanged', function(oEvent) {
				that._bForceVisibleColCalc = true;
			});

			this._bDetermineVisibleCols = true;
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.insertColumn = function (oColumn, iIndex) {
			var that = this;
			this.insertAggregation('columns', oColumn, iIndex);
			oColumn.attachEvent('_widthChanged', function() {
				that._bForceVisibleColCalc = true;
			});

			this._bDetermineVisibleCols = true;
			return this;
		};

		/**
		 * returns the count of rows when bound or 0
		 * @private
		 */
		DataTable.prototype._getRowCount = function() {
			var oBinding = this.getBinding("rows");
			return oBinding ? (oBinding.getLength() || 0) : 0;
		};

		/**
		 * returns the count of rows which can ca selected when bound or 0
		 * @private
		 */
		DataTable.prototype._getSelectableRowCount = function() {
			return this._getRowCount();
		};


		/**
		 * returns the current top scroll position of the scrollbar (row number)
		 * @private
		 */
		DataTable.prototype._getScrollTop = function() {
			if (this.$().hasClass("sapUiTableVScr")) {
				return this._oVSb.getScrollPosition() || 0;
			} else {
				if (this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
					return (((this._oPaginator.getCurrentPage() || 1) - 1) * this.getVisibleRowCount());
				} else {
					return 0;
				}
			}
		};

		/**
		 * returns the width of the table scroll container
		 * @private
		 */
		DataTable.prototype._getScrollWidth = function() {
			return this.$().find(".sapUiTableCtrlScr").width();
		};

		/**
		 * returns the height of the table scroll container
		 * @private
		 */
		DataTable.prototype._getScrollHeight = function() {
			return this.$().find(".sapUiTableCtrlScr").height();
		};

		/**
		 * returns the count of visible columns
		 * @private
		 */
		DataTable.prototype._getVisibleColumns = function() {
			var aColumns = [];
			var aCols = this.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					aColumns.push(aCols[i]);
				}
			}
			return aColumns;
		};

		/**
		 * returns the count of visible columns
		 * @private
		 */
		DataTable.prototype._getVisibleColumnCount = function() {
			return this._getVisibleColumns().length;
		};

		/**
		 * returns the row count of headers
		 * @private
		 */
		DataTable.prototype._getHeaderRowCount = function() {
			if (!this.getColumnHeaderVisible()) {
				return 0;
			} else if (!this._useMultiHeader()) {
				return 1;
			}
			var iHeaderRows = 0;
			jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
				iHeaderRows = Math.max(iHeaderRows,  oColumn.getMultiLabels().length);
			});
			return iHeaderRows;
		};

		/**
		 * returns if multi header beahviour is used or not
		 * @private
		 */
		DataTable.prototype._useMultiHeader = function() {
			var useMultiLabels = false;
			jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
				if (oColumn.getMultiLabels().length > 0) {
					useMultiLabels = true;
					return false;
				}
			});
			return useMultiLabels;
		};


		/**
		 * returns the min width of all columns
		 * @private
		 */
		DataTable.prototype._getColumnsWidth = function(iStartColumn, iEndColumn) {
			// first calculate the min width of the table for all columns
			var aCols = this.getColumns();
			var iColsWidth = 0;

			if (iStartColumn !== 0 && !iStartColumn) {
				iStartColumn = 0;
			}
			if (iEndColumn !== 0 && !iEndColumn) {
				iEndColumn = aCols.length;
			}

			for (var i = iStartColumn, l = iEndColumn; i < l; i++) {
				if (aCols[i] && aCols[i].shouldRender()) {
					var sWidth = aCols[i].getWidth();
					var iWidth = parseInt(sWidth, 10);
					if (jQuery.sap.endsWith(sWidth, "px")) {
						iColsWidth += iWidth;
					} else {
						// for unknown width we use the min width
						iColsWidth += /* aCols[i].getMinWidth() || */ this._iColMinWidth;
					}
				}
			}

			return iColsWidth;

		};

		/**
		 * calculates the width of the columns by using the browsers calculation
		 * mechanism and setting a fix width to the columns
		 * @private
		 */
		DataTable.prototype._handleResize = function() {

			// when using the native resize handler then this function could be called
			// before the table has been rendered - therefore we interrupt this method
			if (!this.getDomRef()) {
				return;
			}

			// update the horizontal scrollbar
			this._updateHSb();

			// update the column header (sync column widths)
			this._updateColumnHeader();

			this._updateRowHeader();

			this._handleRowCountMode();
		};

		DataTable.prototype._checkTableSize = function() {
			if (!this.getDomRef()) {
				return;
			}

			var oParentDomRef = this.getDomRef().parentNode,
				iHeight = oParentDomRef.offsetHeight,
				iWidth = oParentDomRef.offsetWidth;

			if (oParentDomRef != this._lastParent || iHeight != this._lastParentHeight || iWidth != this._lastParentWidth) {
				this._handleResize();
				this._lastParent = oParentDomRef;
				this._lastParentHeight = iHeight;
				this._lastParentWidth = iWidth;

				// update the bindings
				if (this.getBinding("rows")) {
					this.updateRows();
				}
			}
		};

		DataTable.prototype._handleRowCountMode = function() {
			//if visibleRowCountMode is auto change the visibleRowCount according to the parents container height
			if (this.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
				var iCanvasHeight = this.$().parent().height();
				var iRows = this._calculateRowsToDisplay(iCanvasHeight);
				if (isNaN(iRows)) {
					return;
				}
				//Currently this needs to be executed in a timeout because invalidate is lost wenn method is called during onAfterRendering
				//This can be reverted when keeping the invalidate calls, that occur during onAfterRendering are kept
				var that = this;
				this._visibleRowCountTimer = setTimeout(function() {
					that.setVisibleRowCount(iRows);
				}, 0);
			}
		};

		/**
		 * updates the row headers
		 * @private
		 */
		DataTable.prototype._updateRowHeader = function() {

			// we skip this expensive height and width calculation when not required!
			if (this.getFixedRowCount() >= 0 || this.getFixedColumnCount() >= 0 || this.getRowHeight() <= 0) {

				var $this = this.$();

				var $fixedRows = $this.find(".sapUiTableCtrlFixed > tbody > tr");
				var $scrollRows = $this.find(".sapUiTableCtrlScroll > tbody > tr");
				var $rowHeaders = $this.find(".sapUiTableRowHdr");

				if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
					$fixedRows.css('height','');
					$scrollRows.css('height','');
				}

				for (var i = 0, l = $scrollRows.length; i < l; i++) {
					var iHeight = Math.max($fixedRows[i] ? ($fixedRows[i].getBoundingClientRect().bottom - $fixedRows[i].getBoundingClientRect().top) : 0, $scrollRows[i] ? ($scrollRows[i].getBoundingClientRect().bottom - $scrollRows[i].getBoundingClientRect().top) : 0);
					if (this._bjQueryLess18) {
						jQuery($rowHeaders[i]).height(iHeight);
						if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
							jQuery($fixedRows[i]).height(iHeight);
							jQuery($scrollRows[i]).height(iHeight);
						}
					} else {
						jQuery($rowHeaders[i]).outerHeight(iHeight);
						if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
							jQuery($fixedRows[i]).outerHeight(iHeight);
							jQuery($scrollRows[i]).outerHeight(iHeight);
						}
					}
				}

			}

		};

		/**
		 * Synchronizes the <th> width of the table, with the rendered header divs.
		 * @private
		 */
		DataTable.prototype._syncColumnHeaders = function(bUpdateResizeHandlers) {
			var $this = this.$();
			var oRectTable = this.getDomRef().getBoundingClientRect();
			var iTableWidth = oRectTable.right - oRectTable.left;
			var aVisibleColumns = this._getVisibleColumns();
			var iInvisibleColWidth = 0;

			var bRtl = this._bRtlMode;
			var iLeftAway = bRtl ? "99000px" : "-99000px";

			// Select only table headers (identified by data-sap-ui-headcolindex attribute). Not the row header.
			var $colHeaderContainer = $this.find(".sapUiTableColHdr");
			var $tableHeaders = $this.find(".sapUiTableCtrlFirstCol > th");

			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
			if (bHasRowHeader) {
				var oHiddenElement = $tableHeaders.get(0);
				iInvisibleColWidth = oHiddenElement.getBoundingClientRect().right - oHiddenElement.getBoundingClientRect().left;
				$tableHeaders = $tableHeaders.not(":nth-child(1)");
			}

			// Create map with source table headers and their corresponding resizers.
			var mHeaders = {};

			// Traverse the source table headers, which are needed for determine to column head width
			$tableHeaders.each(function(iIndex, oElement) {
				var iHeadColIndex = oElement.getAttribute("data-sap-ui-headcolindex");
				var oRect = oElement.getBoundingClientRect();

				// set width of target column div
				var iTargetWidth;
				var oVisibleColumn = aVisibleColumns[iIndex];
				if (oVisibleColumn) {
					iTargetWidth = oRect.right - oRect.left;
				}

				//for the first column also calculate the width of the hidden column
				if (iIndex == 0) {
					iTargetWidth += iInvisibleColWidth;
				}

				// apply the width of the column
				var	vHeaderSpan = aVisibleColumns[iIndex] ? aVisibleColumns[iIndex].getHeaderSpan() : 1,
					aHeaderData = [],
					aSpans;

				if (vHeaderSpan) {
					// vHeaderSpan can be an array for multi column header rows purpose.
					if (!jQuery.isArray(vHeaderSpan)) {
						vHeaderSpan = [vHeaderSpan];
					}
					jQuery.each(vHeaderSpan, function(iSpanIndex, iSpan) {
						vHeaderSpan[iSpanIndex] = Math.max((iSpan + iIndex > aVisibleColumns.length) ? Math.min(iSpan, aVisibleColumns.length - iIndex) : iSpan, 1);
					});

					aSpans = vHeaderSpan;
				} else {
					aSpans = [1];
				}

				for (var i = 0; i < aSpans.length; i++) {
					aHeaderData[i] = {
						width: iTargetWidth,
						span: 1
					};

					for (var j = 1; j < aSpans[i]; j++) {
						var oHeader = $tableHeaders[iIndex + j];
						var oHeaderRect = oHeader.getBoundingClientRect();
						if (oHeader) {
							aHeaderData[i].width += oHeaderRect.right - oHeaderRect.left;
							aHeaderData[i].span = aSpans[i];
						}
					}
				}

				var oColRsz = document.getElementById(oVisibleColumn.getId() + "-rsz");

				mHeaders[iHeadColIndex] = {
					domRefColumnTh: oElement,
					domRefColumnDivs: [],
					domRefColumnResizer: oColRsz,
					domRefColumnResizerPosition: undefined,
					rect: oRect,
					aHeaderData: aHeaderData
				};
			});

			// Map target column header divs to corresponding source table header.
			var $cols = $colHeaderContainer.find(".sapUiTableCol");
			$cols.each(function(iIndex, oElement) {
				var iColIndex = parseInt(oElement.getAttribute("data-sap-ui-colindex"),10);
				var mHeader = mHeaders[iColIndex];
				mHeader.domRefColumnDivs.push(oElement);

				var iResizerPositionLeft = 0;

				if (mHeader) {
					if (!bRtl) {
						iResizerPositionLeft = mHeader.rect.right - oRectTable.left;
					} else {
						iResizerPositionLeft = mHeader.rect.left - oRectTable.left;
					}
				}

				if (!iResizerPositionLeft || iResizerPositionLeft <= 0 || iResizerPositionLeft >= iTableWidth) {
					iResizerPositionLeft = iLeftAway;
				}
				mHeader.domRefColumnResizerPosition = iResizerPositionLeft;
			});

			jQuery.each(mHeaders, function(iIndex, mHeader) {
				for (var i = 0; i < mHeader.domRefColumnDivs.length; i++) {
					// apply header widths
					var oHeaderData = mHeader.aHeaderData[0];
					if (mHeader.aHeaderData[i]) {
						oHeaderData = mHeader.aHeaderData[i];
					}
					mHeader.domRefColumnDivs[i].style.width =  oHeaderData.width + "px";
					mHeader.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan", oHeaderData.span);

					// position resizer
					if (mHeader.domRefColumnResizer) {
						mHeader.domRefColumnResizer.style.left = mHeader.domRefColumnResizerPosition + "px";
					}
				}
			});

			// Table Column Height Calculation

			// we change the height of the cols, col header and the row header to auto to
			// find out whether to use the height of a cell or the min height of the col header.
			var iHeaderRowCount = this._getHeaderRowCount();
			var bHasColHdrHeight = this.getColumnHeaderHeight() > 0;
			if (!bHasColHdrHeight && !bUpdateResizeHandlers) {
				var $jqo = $this.find(".sapUiTableColHdrCnt,.sapUiTableColRowHdr");

				// We do this without jQuery for improved performance in IE (3500ms)
				var iColsLength = $cols.length;
				for (var i = 0; i < iColsLength; i++) {
					$cols[i].style.height = 'auto';
				}
				$jqo.height("auto");


				// Total height of the table header
				var iHeight = Math.max($colHeaderContainer.height(), $jqo.height());

				// Height of one row within the header
				var iRegularHeight = iHeight / iHeaderRowCount;
				if (this._bjQueryLess18) {
					$cols.height(iRegularHeight);
					$jqo.height(iHeight);
				} else {
					$cols.outerHeight(iRegularHeight);
					$jqo.outerHeight(iHeight);
				}
			}
		};

		/**
		 * updates the column headers (width and position of the resize handles)
		 * @private
		 */
		DataTable.prototype._updateColumnHeader = function(bUpdateResizeHandlers) {
			if (this._sColHdrPosTimer) {
				jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
			}

			// instantly execute the synchronization or delay it
			if (this._bOnAfterRendering) {
				this._syncColumnHeaders.apply(this, arguments);
			} else {
				this._sColHdrPosTimer = jQuery.sap.delayedCall(150, this, this._syncColumnHeaders, arguments);
			}
		};

		/**
		 * disables text selection on the document (disabled fro Dnd)
		 * @private
		 */
		DataTable.prototype._disableTextSelection = function (oElement) {
			// prevent text selection
			jQuery(oElement || document.body).
				attr("unselectable", "on").
				css({
					"-moz-user-select": "none",
					"-webkit-user-select": "none",
					"user-select": "none"
				}).
				bind("selectstart", function(oEvent) {
					oEvent.preventDefault();
					return false;
				});
		};

		/**
		 * enables text selection on the document (disabled fro Dnd)
		 * @private
		 */
		DataTable.prototype._enableTextSelection = function (oElement) {
			jQuery(oElement || document.body).
				attr("unselectable", "off").
				css({
					"-moz-user-select": "",
					"-webkit-user-select": "",
					"user-select": ""
				}).
				unbind("selectstart");
		};

		/**
		 * clears the text selection on the document (disabled fro Dnd)
		 * @private
		 */
		DataTable.prototype._clearTextSelection = function () {
			if (window.getSelection) {
				if (window.getSelection().empty) {  // Chrome
					window.getSelection().empty();
				} else if (window.getSelection().removeAllRanges) {  // Firefox
					window.getSelection().removeAllRanges();
				}
			} else if (document.selection && document.selection.empty) {  // IE?
				try {
					document.selection.empty();
				} catch (ex) {
					// ignore error to as a workaround for bug in IE8
				}
			}
		};

		// =============================================================================
		// CONTROL EVENT HANDLING
		// =============================================================================

		/**
		 * will be called by the vertical scrollbar. updates the visualized data by
		 * applying the first visible (scrollpos) row from the vertical scrollbar
		 * @private
		 */
		DataTable.prototype.onvscroll = function(oEvent) {
			// do not scroll in action mode!
			this._leaveActionMode();
			// set the first visible row
			this.setFirstVisibleRow(this._getScrollTop(), true);
		};

		/**
		 * sync the column header and content
		 * @private
		 */
		DataTable.prototype._syncHeaderAndContent = function() {
			if (!this._bSyncScrollLeft) {
				this._bSyncScrollLeft = true;
				// synchronize the scroll areas
				var $this = this.$();
				var iScrollLeft = this._oHSb.getNativeScrollPosition();
				$this.find(".sapUiTableCtrlScr").scrollLeft(iScrollLeft);
				if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
					var oScrollDomRef = $this.find(".sapUiTableColHdrScr").get(0);
					iScrollLeft = oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - this._oHSb.getScrollPosition();
				}
				$this.find(".sapUiTableColHdrScr").scrollLeft(iScrollLeft);
				this._bSyncScrollLeft = false;
			}

		};

		/**
		 * will be called when the horizontal scrollbar is used. since the table does
		 * not render/update the data of all columns (only the visible ones) in case
		 * of scrolling horizontally we need to update the content of the columns which
		 * became visible.
		 * @private
		 */
		DataTable.prototype.onhscroll = function(oEvent) {

			if (!this._bOnAfterRendering) {

				// sync the column header and the content area
				this._syncHeaderAndContent();

				// update the column headers (resize handles)
				this._updateColumnHeader(true);

				// update the bindings
				if (this.getBinding("rows")) {
					this.updateRows();
				}

			}

		};

		/**
		 * when navigating within the column header we need to synchronize the content
		 * area with the position (scrollLeft) of the column header.
		 * @private
		 */
		DataTable.prototype._oncolscroll = function(oEvent) {
			if (!this._bSyncScrollLeft) {
				var $cnt = this.$().find(".sapUiTableColHdrScr");
				if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
					var oScrollDomRef = this.$().find(".sapUiTableColHdrScr").get(0);
					this._oHSb.setScrollPosition(oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - $cnt.scrollLeft());
				} else {
					this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
				}
			}
		};

		/**
		 * when navigating within the content area we need to synchronize the column
		 * header with the position (scrollLeft) of the content area.
		 * @private
		 */
		DataTable.prototype._oncntscroll = function(oEvent) {
			if (!this._bSyncScrollLeft) {
				var $cnt = this.$().find(".sapUiTableCtrlScr");
				this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
			}
		};


		/**
		 * listens to the mousedown events for starting column drag & drop. therefore
		 * we wait 200ms to make sure it is no click on the column to open the menu.
		 * @private
		 */
		DataTable.prototype.onmousedown = function(oEvent) {
			// only move on left click!
			var bLeftButton = oEvent.button === 0;
			var bIsTouchMode = this._isTouchMode(oEvent);

			if (bLeftButton) {
				var $target = jQuery(oEvent.target);

				var $splitter = this.$("sb");
				if (oEvent.target == $splitter[0]) {

					// Fix for IE text selection while dragging
					jQuery(document.body).bind("selectstart", jQuery.proxy(this._splitterSelectStart, this));

					var offset = $splitter.offset();
					var height = $splitter.height();
					var width = $splitter.width();

					jQuery(document.body).append(
							"<div id=\"" + this.getId() + "-ghost\" class=\"sapUiHSBGhost\" style =\" height:" + height + "px; width:"
							+ width + "px; left:" + offset.left + "px; top:" + offset.top + "px\" ></div>");

					// append overlay over splitter to enable correct functionality of moving the splitter
					$splitter.append(
							"<div id=\"" + this.getId() + "-overlay\" style =\"left: 0px;" +
							" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");

					var $Document = jQuery(document);
					if (bIsTouchMode) {
						$Document.bind("touchend", jQuery.proxy(this._onGhostMouseRelease, this));
						$Document.bind("touchmove", jQuery.proxy(this._onGhostMouseMove, this));
					} else {
						$Document.bind("mouseup", jQuery.proxy(this._onGhostMouseRelease, this));
						$Document.bind("mousemove", jQuery.proxy(this._onGhostMouseMove, this));
					}

					this._disableTextSelection();

					return;
				}

				var $col = $target.closest(".sapUiTableCol");
				if ($col.length === 1) {

					this._bShowMenu = true;
					this._sDelayedMenuTimer = jQuery.sap.delayedCall(200, this, function() {
						this._bShowMenu = false;
					});

					var bIsColumnMenuTarget = this._isTouchMode(oEvent) && ($target.hasClass("sapUiTableColDropDown") || $target.hasClass("sapUiTableColResizer"));
					if (this.getEnableColumnReordering() && !bIsColumnMenuTarget) {
						var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
						if (iIndex > this._iLastFixedColIndex) {
							var oColumn = this.getColumns()[iIndex];

							this._sDelayedActionTimer = jQuery.sap.delayedCall(200, this, function() {
								this._onColumnMoveStart(oColumn, bIsTouchMode);
							});
						}
					}
				}

				// in case of FireFox and CTRL+CLICK it selects the target TD
				//   => prevent the default behavior only in this case (to still allow text selection)
				var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);
				if (!!sap.ui.Device.browser.firefox && bCtrl) {
					oEvent.preventDefault();
				}
			}

		};

		/**
		 * controls the action mode when clicking into the table control
		 * @private
		 */
		DataTable.prototype.onmouseup = function(oEvent) {
			// clean up the timer
			jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);

			if (this.$().find(".sapUiTableCtrl td :focus").length > 0) {
				// when clicking into a focusable control we enter the action mode!
				this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));
			} else {
				// when clicking anywhere else in the table we leave the action mode!
				this._leaveActionMode(oEvent);
			}
		};

		/**
		 * handles the selection when clicking on the table
		 * @private
		 */
		DataTable.prototype.onclick = function(oEvent) {
			if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
				this._onGroupSelect(oEvent);
			} else if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
				this._onNodeSelect(oEvent);
			} else {
				// clean up the timer
				jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
				// forward the event
				if (!this._findAndfireCellEvent(this.fireCellClick, oEvent)) {
					this._onSelect(oEvent);
				} else {
					oEvent.preventDefault();
				}
			}
		};

		/**
		 * handles the cell contextmenu eventing of the table, open the menus for cell, group header and column header
		 * @private
		 */
		DataTable.prototype.oncontextmenu = function(oEvent) {
			var $Target = jQuery(oEvent.target);
			var $Header = $Target.closest('.sapUiTableCol');
			if ($Header.length > 0) {
				var oColumn = sap.ui.getCore().byId($Header.attr("data-sap-ui-colid"));
				if (oColumn) {
					oColumn._openMenu($Header[0]);
				}
				oEvent.preventDefault();
			} else {
				if (this._findAndfireCellEvent(this.fireCellContextmenu, oEvent, this._oncellcontextmenu)) {
					oEvent.preventDefault();
				}
			}
		};

		/**
		 * handles the default cell contextmenu
		 * @private
		 */
		DataTable.prototype._oncellcontextmenu = function(mParams) {
			if (this.getEnableCellFilter()) {

				// create the contextmenu instance the first time it is needed
				if (!this._oContextMenu) {

					jQuery.sap.require("sap.ui.unified.Menu");
					jQuery.sap.require("sap.ui.unified.MenuItem");

					this._oContextMenu = new sap.ui.unified.Menu(this.getId() + "-contextmenu");
					this.addDependent(this._oContextMenu);

				}

				// does the column support filtering?
				var oColumn = this._getVisibleColumns()[mParams.columnIndex];
				var sProperty = oColumn.getFilterProperty();
				if (sProperty && oColumn.getShowFilterMenuEntry()) {

					// destroy all items of the menu and recreate
					this._oContextMenu.destroyItems();
					this._oContextMenu.addItem(new sap.ui.unified.MenuItem({
						text: this._oResBundle.getText("TBL_FILTER"),
						select: [function() {
							var oContext = this.getContextByIndex(mParams.rowIndex);
							var sValue = oContext.getProperty(sProperty);
							this.filter(oColumn, sValue);
						}, this]
					}));

					// open the popup below the cell
					var eDock = sap.ui.core.Popup.Dock;
					this._oContextMenu.open(false, mParams.cellDomRef, eDock.BeginTop, eDock.BeginBottom, mParams.cellDomRef, "none none");
					return true;
				}
			}
		};

		/**
		 * helper method to bind different functions to a click if both a single and a double click can occur on an element
		 * @experimental Experimental
		 * @function
		 * @private
		 */
		DataTable.prototype._bindSimulatedDoubleclick = function(element, fnClick, fnDoubleclick){
			var eventBound = "click";
			var that = this;
			if (!!sap.ui.Device.support.touch){
				//event needs to be touchend due to timing issues on the ipad
				eventBound = "touchend";
			}
			jQuery(element).on(eventBound, function(oEvent){
				oEvent.preventDefault();
				oEvent.stopPropagation();
				that._clicksRegistered = that._clicksRegistered + 1;
				if (that._clicksRegistered < 2){
					that._singleClickTimer = jQuery.sap.delayedCall(that._doubleclickDelay, that, function(){
						that._clicksRegistered = 0;
						if (fnClick){
							fnClick.call(that, oEvent);
						}
					}, [oEvent]);
				} else {
					jQuery.sap.clearDelayedCall(that._singleClickTimer);
					that._clicksRegistered = 0;
					fnDoubleclick.call(that, oEvent);
				}
			});
		};

		/**
		 * finds the cell on which the click or contextmenu event is executed and
		 * notifies the listener which control has been clicked or the contextmenu
		 * should be openend.
		 * @param {function} fnFire function to fire the event
		 * @param {DOMEvent} oEvent event object
		 * @return {boolean} cancelled or not
		 * @private
		 */
		DataTable.prototype._findAndfireCellEvent = function(fnFire, oEvent, fnContextMenu) {
			var $target = jQuery(oEvent.target);
			// find out which cell has been clicked
			var $cell = $target.closest("td[role='gridcell']");
			var sId = $cell.attr("id");
			var aMatches = /.*-row(\d*)-col(\d*)/i.exec(sId);
			var bCancel = false;
			if (aMatches) {
				var iRow = aMatches[1];
				var iCol = aMatches[2];
				var oRow = this.getRows()[iRow];
				var oCell = oRow && oRow.getCells()[iCol];
				var iRealRowIndex = oRow && oRow.getIndex();
				var mParams = {
					rowIndex: iRealRowIndex,
					columnIndex: iCol,
					cellControl: oCell
				};
				bCancel = !fnFire.call(this, mParams);
				if (!bCancel && typeof fnContextMenu === "function") {
					mParams.cellDomRef = $cell[0];
					bCancel = fnContextMenu.call(this, mParams);
				}
			}
			return bCancel;
		};

		/**
		 * handles the focus in to reposition the focus or prevent default handling for
		 * column resizing
		 * @private
		 */
		DataTable.prototype.onfocusin = function(oEvent) {
			var $target = jQuery(oEvent.target);
			var bNoData = this.$().hasClass("sapUiTableEmpty");
			var bControlBefore = $target.hasClass("sapUiTableCtrlBefore");
			this._updateAriaRowOfRowsText();
			// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
			if (!this._bIgnoreFocusIn && (bControlBefore || $target.hasClass("sapUiTableCtrlAfter"))) {
				// set the focus on the last focused dom ref of the item navigation or
				// in case if not set yet (tab previous into item nav) then we set the
				// focus to the root domref
				// reset the aria description of the table that the table is announced the
				// first time the table grabs the focus
				this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));
				// when entering the before or after helper DOM elements we put the
				// focus on the current focus element of the item navigation and we
				// leave the action mode!
				this._leaveActionMode();
				if (jQuery.contains(this.$().find('.sapUiTableColHdrCnt')[0], oEvent.target)) {
					jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
				} else {
					if (bControlBefore) {
						if (bNoData) {
							this._bIgnoreFocusIn = true;
							this.$().find(".sapUiTableCtrlEmpty").focus();
							this._bIgnoreFocusIn = false;
						} else {
							this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns, oEvent);
						}
					} else {
						this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns) + (this._oItemNavigation.iColumns * this._iLastSelectedDataRow), oEvent);
					}
				}

				if (!bNoData) {
					oEvent.preventDefault();
				}
			} else if (jQuery.sap.endsWith(oEvent.target.id, "-rsz")) {
				// prevent that the ItemNavigation grabs the focus!
				// only for the column resizing
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		};

		/**
		 * The row index only considers the position of the row in the aggregation. It must be adapted
		 * to consider the firstVisibleRow offset or if a fixed bottom row was pressed
		 * @param {int} iRow row index of the control in the rows aggregation
		 * @returns {int} the adapted (absolute) row index
		 * @private
		 */
		DataTable.prototype._getAbsoluteRowIndex = function(iRow) {
			var iIndex = 0;
			var iFirstVisibleRow = this.getFirstVisibleRow();
			var iFixedBottomRowCount = this.getFixedBottomRowCount();
			var iVisibleRowCount = this.getVisibleRowCount();
			var iFirstFixedBottomRowIndex = iVisibleRowCount - iFixedBottomRowCount;

			if (iFixedBottomRowCount > 0 && iRow >= iFirstFixedBottomRowIndex) {
				iIndex = this.getBinding().getLength() - iVisibleRowCount + iRow;
			} else {
				iIndex = iFirstVisibleRow + iRow;
			}

			return iIndex;
		};

		// =============================================================================
		// SELECTION HANDLING
		// =============================================================================

		/**
		 * handles the row selection and the column header menu
		 * @private
		 */
		DataTable.prototype._onSelect = function(oEvent) {

			// trigger column menu
			var $target = jQuery(oEvent.target);

			// determine modifier keys
			var bShift = oEvent.shiftKey;
			var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);

			// column header?
			var $col = $target.closest(".sapUiTableCol");
			if (this._bShowMenu && $col.length === 1) {
				var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
				var oColumn = this.getColumns()[iIndex];

				if ($target.hasClass("sapUiTableColDropDown")) {
					var bExecuteDefault = this.fireColumnSelect({
						column: oColumn
					});

					if (bExecuteDefault) {
						oColumn._openMenu($col[0]);
					}
				} else {
					this._onColumnSelect(oColumn, $col[0], this._isTouchMode(oEvent));
				}

				return;
			}

			// row header?
			var $row = $target.closest(".sapUiTableRowHdr");
			if ($row.length === 1) {
				var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
				this._onRowSelect(this._getAbsoluteRowIndex(iIndex), bShift, bCtrl);
				return;
			}

			// table control? (only if the selection behavior is set to row)
			if (/*!this._bActionMode && */ (
				this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.Row ||
				this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
				var $row = $target.closest(".sapUiTableCtrl > tbody > tr");
				if ($row.length === 1) {
					var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
					this._onRowSelect(this._getAbsoluteRowIndex(iIndex), bShift, bCtrl);
					return;
				}
			}

			// select all?
			if (jQuery.sap.containsOrEquals(this.getDomRef("selall"), oEvent.target)) {
				this._toggleSelectAll();
				return;
			}

		};


		// =============================================================================
		// ROW EVENT HANDLING
		// =============================================================================

		/**
		 *
		 * @param iRowIndex
		 * @returns {boolean}
		 * @private
		 */
		DataTable.prototype._isRowSelectable = function(iRowIndex) {
			return true;
		};

		/**
		 * handles the row selection (depending on the mode)
		 * @private
		 */
		DataTable.prototype._onRowSelect = function(iRowIndex, bShift, bCtrl) {

			// in case of IE and SHIFT we clear the text selection
			if (!!sap.ui.Device.browser.internet_explorer && bShift) {
				this._clearTextSelection();
			}

			// is the table bound?
			var oBinding = this.getBinding("rows");
			if (!oBinding) {
				return;
			}

			//var iRowIndex = Math.min(Math.max(0, iRowIndex), this.getBinding("rows").getLength() - 1);
			if (iRowIndex < 0 || iRowIndex >= (oBinding.getLength() || 0)) {
				return;
			}

			// Make sure that group headers, which represents a tree node in AnalyticalTable, are not selectable.
			if (!this._isRowSelectable(iRowIndex)) {
				return;
			}

			this._iSourceRowIndex = iRowIndex;

			var oSelMode = this.getSelectionMode();
			if (oSelMode !== sap.ui.table.SelectionMode.None) {
				if (oSelMode === sap.ui.table.SelectionMode.Single) {
					if (!this.isIndexSelected(iRowIndex)) {
						this.setSelectedIndex(iRowIndex);
					} else {
						this.clearSelection();
					}
				} else {
					// in case of multi toggle behavior a click on the row selection
					// header adds or removes the selected row and the previous seleciton
					// will not be removed
					if (oSelMode === sap.ui.table.SelectionMode.MultiToggle) {
						bCtrl = true;
					}
					if (bShift) {
						// If no row is selected getSelectedIndex returns -1 - then we simply
						// select the clicked row:
						var iSelectedIndex = this.getSelectedIndex();
						if (iSelectedIndex >= 0) {
							this.addSelectionInterval(iSelectedIndex, iRowIndex);
						} else {
							this.setSelectedIndex(iRowIndex);
						}
					} else {
						if (!this.isIndexSelected(iRowIndex)) {
							if (bCtrl) {
								this.addSelectionInterval(iRowIndex, iRowIndex);
							} else {
								this.setSelectedIndex(iRowIndex);
							}
						} else {
							if (bCtrl) {
								this.removeSelectionInterval(iRowIndex, iRowIndex);
							} else {
								if (this.getSelectedIndices().length === 1) {
									this.clearSelection();
								} else {
									this.setSelectedIndex(iRowIndex);
								}
							}
						}
					}
				}
			}

			this._iSourceRowIndex = undefined;

		};


		// =============================================================================
		// COLUMN EVENT HANDLING
		// =============================================================================

		/**
		 * column select event => opens the column menu
		 * @private
		 */
		DataTable.prototype._onColumnSelect = function(oColumn, oDomRef, bIsTouchMode) {
			// On tablet open special column header menu
			if (bIsTouchMode) {
				var $ColumnHeader = jQuery(oDomRef);
				var $ColumnCell = $ColumnHeader.find(".sapUiTableColCell");

				if ($ColumnHeader.find(".sapUiTableColCellMenu").length < 1) {
					$ColumnCell.hide();

					var sColumnDropDownButton = "";
					if (oColumn._menuHasItems()) {
						sColumnDropDownButton = "<div class='sapUiTableColDropDown'></div>";
					}

					var sColumnResizerButton = "";
					if (oColumn.getResizable()) {
						sColumnResizerButton = "<div class='sapUiTableColResizer''></div>";
					}

					var $ColumnHeaderMenu = jQuery("<div class='sapUiTableColCellMenu'>" + sColumnDropDownButton + sColumnResizerButton + "</div>");
					$ColumnHeader.append($ColumnHeaderMenu);
					$ColumnHeader.bind("focusout", function() {
						this.cell.show();
						this.menu.remove();
						this.self.unbind("focusout");
					}.bind({
							cell: $ColumnCell,
							menu: $ColumnHeaderMenu,
							self: $ColumnHeader
						}));

					// listen to the resize handlers
					if (oColumn.getResizable()) {
						$ColumnHeader.find(".sapUiTableColResizer").bind("touchstart", jQuery.proxy(this._onColumnResizeStart, this));
					}
				}

				return;
			}

			// forward the event
			var bExecuteDefault = this.fireColumnSelect({
				column: oColumn
			});

			// if the default behavior should be prevented we suppress to open
			// the column menu!
			if (bExecuteDefault) {
				oColumn._openMenu(oDomRef);
			}

		};

		/**
		 * start column moveing
		 * @private
		 */
		DataTable.prototype._onColumnMoveStart = function(oColumn, bIsTouchMode) {
			this._disableTextSelection();

			var $col = oColumn.$();
			var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);

			if (iColIndex < this.getFixedColumnCount()) {
				return;
			}

			this.$().addClass("sapUiTableDragDrop");
			this._$colGhost = $col.clone().removeAttr("id");

			$col.css({
				"opacity": ".25"
			});

			this._$colGhost.addClass("sapUiTableColGhost").css({
				"left": -10000,
				"top": -10000,
				//Position is set to relative for columns later, if the moving is started a second time the position: relative overwrites
				//the absolut position set by the sapUiTableColGhost class, so we overrite the style attribute for position here to make
				//sure that the position is absolute
				"position": "absolute",
				"z-index": this.$().zIndex() + 10
			});

			// TODO: only for the visible columns!?
			this.$().find(".sapUiTableCol").each(function(iIndex, oElement) {

				var $col = jQuery(this);
				$col.css({position: "relative"});

				$col.data("pos", {
					left: $col.position().left,
					center: $col.position().left + $col.outerWidth() / 2,
					right:  $col.position().left + $col.outerWidth()
				});

			});

			this._$colGhost.appendTo(document.body);

			var $body = jQuery(document.body);
			if (bIsTouchMode) {
				$body.bind("touchmove", jQuery.proxy(this._onColumnMove, this));
				$body.bind("touchend", jQuery.proxy(this._onColumnMoved, this));
			} else {
				$body.mousemove(jQuery.proxy(this._onColumnMove, this));
				$body.mouseup(jQuery.proxy(this._onColumnMoved, this));
			}
		};

		/**
		 * move the column position the ghost
		 * @private
		 */
		DataTable.prototype._onColumnMove = function(oEvent) {
			var $this = this.$();
			var iLocationX = oEvent.pageX;
			var iLocationY = oEvent.pageY;
			if (oEvent && this._isTouchMode(oEvent)) {
				iLocationX = oEvent.targetTouches[0].pageX;
				iLocationY = oEvent.targetTouches[0].pageY;
				oEvent.stopPropagation();
				oEvent.preventDefault();
			}

			var bRtl = this._bRtlMode;
			var iRelX = iLocationX - $this.offset().left;
			var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
			var $DnDCol = this.getColumns()[iDnDColIndex].$();

			// find out the new col position
			var iOldColPos = this._iNewColPos;
			this._iNewColPos = iDnDColIndex;
			var that = this;
			$this.find(".sapUiTableCol").each(function(iIndex, oCol) {
				var $col = jQuery(oCol);
				var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
				var vHeaderSpans = sap.ui.getCore().byId($col.attr("data-sap-ui-colid")).getHeaderSpan();
				var iSpan;

				if (vHeaderSpans) {
					if (jQuery.isArray(vHeaderSpans)) {
						iSpan = vHeaderSpans[0];
					} else {
						iSpan = vHeaderSpans;
					}
				} else {
					iSpan = 1;
				}

				if ($col.get(0) !== $DnDCol.get(0)) {

					var oPos = $col.data("pos");

					var bBefore = iRelX >= oPos.left && iRelX <= oPos.center;
					var bAfter = iRelX >= oPos.center && iRelX <= oPos.right;

					if (!bRtl) {
						if (bBefore) {
							that._iNewColPos = iColIndex;
						} else if (bAfter) {
							that._iNewColPos = iColIndex + iSpan;
						} else {
							that._iNewColPos = that._iNewColPos;
						}
					} else {
						if (bAfter) {
							that._iNewColPos = iColIndex;
						} else if (bBefore) {
							that._iNewColPos = iColIndex + iSpan;
						} else {
							that._iNewColPos = that._iNewColPos;
						}
					}

					if ((bBefore || bAfter) && iColIndex > iDnDColIndex) {
						that._iNewColPos--;
					}

				}

			});

			// prevent the reordering of the fixed columns
			if (this._iNewColPos <= this._iLastFixedColIndex) {
				this._iNewColPos = iOldColPos;
			}
			if (this._iNewColPos < this.getFixedColumnCount()) {
				this._iNewColPos = iOldColPos;
			}

			// animate the column move
			this._animateColumnMove(iDnDColIndex, iOldColPos, this._iNewColPos);

			// update the ghost position
			this._$colGhost.css({
				"left": iLocationX + 5,
				"top": iLocationY + 5
			});
		};

		/**
		 * animates the column movement
		 */
		DataTable.prototype._animateColumnMove = function(iColIndex, iOldPos, iNewPos) {

			var bRtl = this._bRtlMode;
			var $DnDCol = this.getColumns()[iColIndex].$();

			// position has been changed => reorder
			if (iOldPos !== iNewPos) {

				for (var i = Math.min(iOldPos, iNewPos), l = Math.max(iOldPos, iNewPos); i <= l; i++) {
					var oCol = this.getColumns()[i];
					if (i !== iColIndex && oCol.getVisible()) {
						oCol.$().stop(true, true).animate({left: "0px"});
					}
				}

				var iOffsetLeft = 0;
				if (iNewPos < iColIndex) {
					for (var i = iNewPos; i < iColIndex; i++) {
						var oCol = this.getColumns()[i];
						if (oCol.getVisible()) {
							var $col = oCol.$();
							iOffsetLeft -= $col.outerWidth();
							$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? -1 : 1) + "px"});
						}
					}
				} else {
					for (var i = iColIndex + 1, l = iNewPos + 1; i < l; i++) {
						var oCol = this.getColumns()[i];
						if (oCol.getVisible()) {
							var $col = oCol.$();
							iOffsetLeft += $col.outerWidth();
							$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? 1 : -1) + "px"});
						}
					}
				}
				$DnDCol.stop(true, true).animate({left: iOffsetLeft * (bRtl ? -1 : 1) + "px"});
			}

		};

		/**
		 * columns is moved => update!
		 * @private
		 */
		DataTable.prototype._onColumnMoved = function(oEvent) {
			this.$().removeClass("sapUiTableDragDrop");

			var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
			var oDnDCol = this.getColumns()[iDnDColIndex];

			var $Body = jQuery(document.body);
			$Body.unbind("touchmove", this._onColumnMove);
			$Body.unbind("touchend", this._onColumnMoved);
			$Body.unbind("mousemove", this._onColumnMove);
			$Body.unbind("mouseup", this._onColumnMoved);

			this._$colGhost.remove();
			this._$colGhost = undefined;

			this._enableTextSelection();

			// forward the event
			var bExecuteDefault = this.fireColumnMove({
				column: oDnDCol,
				newPos: this._iNewColPos
			});

			var bMoveRight = iDnDColIndex < this._iNewColPos;

			if (bExecuteDefault && this._iNewColPos !== undefined && this._iNewColPos !== iDnDColIndex) {
				this.removeColumn(oDnDCol);
				this.insertColumn(oDnDCol, this._iNewColPos);
				var vHeaderSpan = oDnDCol.getHeaderSpan(),
					iSpan;

				if (vHeaderSpan) {
					if (jQuery.isArray(vHeaderSpan)) {
						iSpan = vHeaderSpan[0];
					} else {
						iSpan = vHeaderSpan;
					}
				} else {
					iSpan = 1;
				}

				if (iSpan > 1) {
					if (!bMoveRight) {
						this._iNewColPos++;
					}
					for (var i = 1; i < iSpan; i++) {
						var oDependentCol = this.getColumns()[bMoveRight ? iDnDColIndex : iDnDColIndex + i];
						this.removeColumn(oDependentCol);
						this.insertColumn(oDependentCol, this._iNewColPos);
						this.fireColumnMove({
							column: oDependentCol,
							newPos: this._iNewColPos
						});
						if (!bMoveRight) {
							this._iNewColPos++;
						}
					}
				}
				this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);
			} else {
				this._animateColumnMove(iDnDColIndex, this._iNewColPos, iDnDColIndex);
				oDnDCol.$().css({
					"backgroundColor": "",
					"backgroundImage": "",
					"opacity": ""
				});
			}

			// Re-apply focus
			setTimeout(function() {
				var iOldFocusedIndex = this._oItemNavigation.getFocusedIndex();
				this._oItemNavigation.focusItem(0, oEvent);
				this._oItemNavigation.focusItem(iOldFocusedIndex, oEvent);
			}.bind(this), 0);

			delete this._iNewColPos;
		};

		/**
		 * starts the automatic column resize after doubleclick
		 * @experimental Experimental, only works with a limited control set
		 * @private
		 */
		DataTable.prototype._onAutomaticColumnResize = function(oEvent) {
			var iColIndex, oCol, headerSpan, maxHeaderSpan, iColsToResize = 1, bResizeMultiple = false;
			jQuery.sap.log.debug("doubleclick fired");
			this._disableTextSelection();
			this._$colResize = jQuery(oEvent.target);
			this._$colResize.addClass("sapUiTableColRszActive");
			//get the id of the column which needs to be resized. it might be different from the resizers column id if a headerspan is used.
			var iParentColIndex = parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"), 10);
			iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
			if (iParentColIndex != iColIndex) {
				bResizeMultiple = true;
			}
			//try to find out if we are only resizing one column or all columns under a header span
			if (bResizeMultiple) {
				oCol = this.getColumns()[iParentColIndex];
				headerSpan = oCol.getHeaderSpan();
				if (headerSpan instanceof Array){
					maxHeaderSpan = Math.max.apply(Math, headerSpan);
				} else if (!!headerSpan) {
					maxHeaderSpan = headerSpan;
				}
				if (iColIndex + headerSpan - 1 != iParentColIndex){
					iColsToResize = maxHeaderSpan;
					iColIndex = iParentColIndex + maxHeaderSpan;
				}
			}
			if (iColsToResize > 1){
				//	for(var i = 0; i < iColsToResize; i--{
				while (iColIndex > iParentColIndex) {
					iColIndex--;
					this.autoResizeColumn(iColIndex);
				}
			} else {
				this.autoResizeColumn(iColIndex);
			}
			oEvent.preventDefault();
			oEvent.stopPropagation();
		};

		/**
		 * Determines the associated resizer id for a column.
		 * @param {int} the column index of the target column
		 * @param {int} the column span of the target column
		 * @return {String} the associated resizer id
		 */
		DataTable.prototype._getResizerIdForColumn = function(iColIndex, iColSpan) {
			if (iColSpan > 0) {
				iColSpan--;
			}

			var oColumn = this.getColumns()[this._aIdxCols2Cells[iColIndex + iColSpan]];
			return oColumn.getId() + "-rsz";
		};

		/**
		 * start the column resize
		 * @private
		 */
		DataTable.prototype._onColumnResizeStart = function(oEvent) {
			if (this._isTouchMode(oEvent)) {
				this._iColumnResizeStart = oEvent.targetTouches[0].pageX;
				this._disableTextSelection();

				var $Column = jQuery(oEvent.target).closest(".sapUiTableCol");
				var iColIndex = parseInt($Column.attr("data-sap-ui-colindex"), 10);
				var iColSpan = $Column.attr("data-sap-ui-colspan");

				var sResizerId = this._getResizerIdForColumn(iColIndex, iColSpan);
				this._$colResize = jQuery.sap.byId(sResizerId);

				jQuery(document.body).bind("touchmove", jQuery.proxy(this._onColumnResize, this));
				jQuery(document.body).bind("touchend", jQuery.proxy(this._onColumnResized, this));

				return;
			}

			// only resize on left click!
			var bLeftButton = oEvent.button === 0;
			if (bLeftButton) {
				this._iColumnResizeStart = oEvent.pageX;

				this._disableTextSelection();
				this._$colResize = jQuery(oEvent.target);

				jQuery(document.body).
					mousemove(jQuery.proxy(this._onColumnResize, this)).
					mouseup(jQuery.proxy(this._onColumnResized, this));
			}
		};

		/**
		 * resize the column
		 * @private
		 */
		DataTable.prototype._onColumnResize = function(oEvent) {
			var iLocationX;
			if (this._isTouchMode(oEvent)) {
				iLocationX = oEvent.targetTouches[0].pageX;
				oEvent.stopPropagation();
				oEvent.preventDefault();
			} else {
				iLocationX = oEvent.pageX;
			}

			if (this._iColumnResizeStart && iLocationX < this._iColumnResizeStart + 3 && iLocationX > this._iColumnResizeStart - 3) {
				return;
			}

			if (this._isTouchMode(oEvent)) {
				this._$colResize.addClass("sapUiTableColTouchRszActive");
			} else {
				this._$colResize.addClass("sapUiTableColRszActive");
			}

			var $this = this.$();

			var bRtl = this._bRtlMode;
			var iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
			var oColumn = this.getColumns()[iColIndex];
			var $col = $this.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='" + iColIndex + "']");

			// get the left position of the column to calculate the new width
			// relative to the parent container (sapUiTableCnt)!
			var iColLeft = $col.position().left;

			var iWidth;
			if (!bRtl) {
				// refine width calculation in case of fixed columns
				if (this.getFixedColumnCount() > 0 && iColIndex >= this.getFixedColumnCount()) {
					var iFixedColumnsWidth = $this.find(".sapUiTableColHdrFixed").width();
					iColLeft = iColLeft + iFixedColumnsWidth;

					// Consider scroll offset of non fixed area.
					iColLeft = iColLeft - $this.find(".sapUiTableCtrlScr").scrollLeft();
				}

				// find the total left offset from the document (required for pageX info)
				var iOffsetLeft = $this.find(".sapUiTableCtrlFirstCol > th:first").offset().left;

				// relative left position within the table scroll container
				var iRelLeft = iLocationX - iOffsetLeft;

				// calculate the new width
				iWidth = iRelLeft - iColLeft;
			} else {
				var $ScrollArea;
				if (this.getFixedColumnCount() > 0 && iColIndex < this.getFixedColumnCount()) {
					$ScrollArea = $this.find('.sapUiTableCtrlScrFixed');
				} else {
					$ScrollArea = $this.find('.sapUiTableCtrlScr');
				}
				var iScrollAreaScrollLeft = $ScrollArea.scrollLeft();

				if (sap.ui.Device.browser.internet_explorer) {
					// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
					// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
					iScrollAreaScrollLeft = $ScrollArea[0].scrollWidth - iScrollAreaScrollLeft - $ScrollArea[0].clientWidth;
				} else if (sap.ui.Device.browser.firefox) {
					// FF has negative reverse scroll position (Chrome = 0, IE = 100, FF = -100)
					iScrollAreaScrollLeft = iScrollAreaScrollLeft + $ScrollArea[0].scrollWidth - $ScrollArea[0].clientWidth;
				}

				//get the difference between where mouse was released and left side of the table
				var iDiff = iColLeft - iScrollAreaScrollLeft - iLocationX + $ScrollArea.offset().left;
				iWidth = $col.outerWidth() + iDiff;
			}

			iWidth = Math.max(iWidth, this._iColMinWidth);

			// calculate and set the position of the resize handle
			var iRszOffsetLeft = $this.find(".sapUiTableCnt").offset().left;

			var iRszLeft = iLocationX - iRszOffsetLeft;
			iRszLeft -= this._$colResize.width() / 2;
			this._$colResize.css("left", iRszLeft);

			// store the width of the column to apply later
			oColumn._iNewWidth = iWidth;
		};

		/**
		 * column is resized => update!
		 * @private
		 */
		DataTable.prototype._onColumnResized = function(oEvent, iIndex) {
			var iColIndex;
			// ignore when no resize column is set
			if (!this._$colResize && (iIndex === null || iIndex === undefined)) {
				return;
			}
			// get the new width of the column
			if (iIndex === null || iIndex === undefined) {
				iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
			} else {
				iColIndex = iIndex;
			}
			var oColumn = this.getColumns()[iColIndex];
			// if the resize has started and we have a new width for the column
			// we apply it to the column object
			var bResized = false;
			if (oColumn._iNewWidth) {
				var sWidth;
				var iAvailableSpace = this.$().find(".sapUiTableCtrl").width();
				if (!this._checkPercentageColumnWidth()) {
					sWidth = oColumn._iNewWidth + "px";
				} else {
					var iColumnWidth = Math.round(100 / iAvailableSpace * oColumn._iNewWidth);
					sWidth = iColumnWidth + "%";
				}

				this._updateColumnWidth(oColumn, sWidth);
				this._resizeDependentColumns(oColumn, sWidth);

				delete oColumn._iNewWidth;

				bResized = true;
			}

			// unbind the event handlers
			var $Body = jQuery(document.body);
			$Body.unbind("touchmove", this._onColumnResize);
			$Body.unbind("touchend", this._onColumnResized);
			$Body.unbind("mousemove", this._onColumnResize);
			$Body.unbind("mouseup", this._onColumnResized);

			// focus the column
			oColumn.focus();

			// hide the text selection
			if (this._$colResize) {
				this._$colResize.removeClass("sapUiTableColTouchRszActive sapUiTableColRszActive");
				this._$colResize = undefined;
			}
			this._enableTextSelection();

			// rerender / ignore if nothing changed!
			if (bResized) {
				this.invalidate();
			}

		};

		/**
		 *
		 * @param oColumn
		 * @param sWidth
		 * @private
		 */
		DataTable.prototype._resizeDependentColumns = function(oColumn, sWidth) {

			//Adjust columns only if the columns have percentage values
			if (this._checkPercentageColumnWidth()) {
				var aVisibleColumns = this._getVisibleColumns();
				//var oLastVisibleColumn = aVisibleColumns[aVisibleColumns.length - 1]; // NOT USED!
				//var bAllFollowingColumnsFlexible = true; // NOT USED!

				var iColumnIndex;
				jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
					if (oColumn === oCurrentColumn) {
						iColumnIndex = iIndex;
						//} else if (iColumnIndex !== undefined && !oCurrentColumn.getFlexible()) { // NOT REQUIRED?
						//bAllFollowingColumnsFlexible = false;
					}
				});

				var iOthersWidth = 0;
				var iLastIndex = aVisibleColumns.length - 1;
				var iTotalPercentage;
				if (iColumnIndex === undefined) {
					iTotalPercentage = 0;
				} else {
					iTotalPercentage = parseInt(sWidth,10);
				}
				var iPercentages = 0;
				var aOtherColumns = [];
				var that = this;

				jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
					var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
					if ((((iColumnIndex === iLastIndex && iIndex < iColumnIndex) || ((iColumnIndex !== iLastIndex) && iIndex > iColumnIndex)) && oCurrentColumn.getFlexible()) || iColumnIndex === undefined) {
						iOthersWidth += oCurrentColumn.$().outerWidth();
						iPercentages += iColumnPercentage;
						aOtherColumns.push(oCurrentColumn);
					} else if (iIndex !== iColumnIndex) {
						iTotalPercentage += iColumnPercentage;
					}
				});

				var iCalcPercentage = iTotalPercentage;
				jQuery.each(aOtherColumns, function(iIndex, oCurrentColumn){
					var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
					var iNewWidth = Math.round((100 - iCalcPercentage) / iPercentages * iColumnPercentage);
					if (iIndex === aOtherColumns.length - 1) {
						iNewWidth = 100 - iTotalPercentage;
					} else {
						iTotalPercentage += iNewWidth;
					}
					that._updateColumnWidth(oCurrentColumn, iNewWidth + "%");
				});
			} else if (!this._hasOnlyFixColumnWidths()) {

				var aVisibleColumns = this._getVisibleColumns(),
					iAvailableSpace = this.$().find(".sapUiTableCtrl").width(),
					iColumnIndex,
					iRightColumns = 0,
					iLeftWidth = 0,
					iRightWidth = 0,
					iNonFixedColumns = 0;

				jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
					//Check columns if they are fixed = they have a pixel width
					if (!jQuery.sap.endsWith(oCurrentColumn.getWidth(), "px")) {
						iNonFixedColumns++;
						return false;
					}
					//if iColumnIndex is defined we already found our column and all other columns are right of that one
					if (iColumnIndex != undefined) {
						iRightWidth += parseInt(oCurrentColumn.getWidth(),10);
						iRightColumns++;
					} else if (oColumn !== oCurrentColumn) {
						iLeftWidth += parseInt(oCurrentColumn.getWidth(),10);
					}
					if (oColumn === oCurrentColumn) {
						iColumnIndex = iIndex;
						//Use new width of column
						iLeftWidth += parseInt(sWidth,10);
					}
				});
				//If there are non fixed columns we don't do this
				if (iNonFixedColumns > 0 || (iLeftWidth + iRightWidth > iAvailableSpace)) {
					return;
				}
				//Available space is all space right of the modified columns
				iAvailableSpace -= iLeftWidth;
				for (var i = iColumnIndex + 1; i < aVisibleColumns.length; i++) {
					//Calculate new column width based on previous percentage width
					var oColumn = aVisibleColumns[i],
						iColWidth = parseInt(oColumn.getWidth(),10),
						iPercent = iColWidth / iRightWidth * 100,
						iNewWidth = iAvailableSpace / 100 * iPercent;
					this._updateColumnWidth(oColumn, Math.round(iNewWidth) + 'px');
				}
			}
		};

		/**
		 *
		 * @param oColumn
		 * @returns {*}
		 * @private
		 */
		DataTable.prototype._getColumnPercentageWidth = function(oColumn) {
			var sColumnWidth = oColumn.getWidth();
			var iColumnPercentage = parseInt(oColumn.getWidth(),10);
			var iTotalWidth = this.$().find(".sapUiTableCtrl").width();
			if (jQuery.sap.endsWith(sColumnWidth, "px")) {
				iColumnPercentage = Math.round(100 / iTotalWidth * iColumnPercentage);
			} else if (!jQuery.sap.endsWith(sColumnWidth, "%")) {
				iColumnPercentage = Math.round(100 / iTotalWidth * oColumn.$().width());
			}
			return iColumnPercentage;
		};

		/**
		 *
		 * @param oColumn
		 * @param sWidth
		 * @private
		 */
		DataTable.prototype._updateColumnWidth = function(oColumn, sWidth) {
			// forward the event
			var bExecuteDefault = this.fireColumnResize({
				column: oColumn,
				width: sWidth
			});

			// set the width of the column (when not cancelled)
			if (bExecuteDefault) {
				oColumn.setProperty("width", sWidth, true);
				this.$().find('th[aria-owns="' + oColumn.getId() + '"]').css('width', sWidth);
			}
		};

		/**
		 * Check if at least one column has a percentage value
		 * @private
		 */
		DataTable.prototype._checkPercentageColumnWidth = function() {
			var aColumns = this.getColumns();
			var bHasPercentageColumns = false;
			jQuery.each(aColumns, function(iIndex, oColumn) {
				if (jQuery.sap.endsWith(oColumn.getWidth(), "%")) {
					bHasPercentageColumns = true;
					return false;
				}
			});
			return bHasPercentageColumns;
		};

		/**
		 * Check if table has only non flexible columns with fixed widths and only then
		 * the table adds a dummy column to fill the rest of the width instead of resizing
		 * the columns to fit the complete table width
		 * @private
		 */
		DataTable.prototype._hasOnlyFixColumnWidths = function() {
			var bOnlyFixColumnWidths = true;
			jQuery.each(this.getColumns(), function(iIndex, oColumn) {
				var sWidth = oColumn.getWidth();
				if (oColumn.getFlexible() || !sWidth || sWidth.substr(-2) !== "px") {
					bOnlyFixColumnWidths = false;
					return false;
				}
			});
			return bOnlyFixColumnWidths;
		};


		// =============================================================================
		// SORTING & FILTERING
		// =============================================================================


		/**
		 * sorts the given column ascending or descending
		 *
		 * @param {sap.ui.table.Column} oColumn
		 *         column to be sorted
		 * @param {sap.ui.table.SortOrder} oSortOrder
		 *         sort order of the column (if undefined the default will be ascending)
		 * @param {Boolean} bAdd Set to true to add the new sort criterion to the existing sort criteria
		 * @return {sap.ui.table.DataTable} instance of the table for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.sort = function(oColumn, oSortOrder, bAdd) {
			if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
				oColumn.sort(oSortOrder === sap.ui.table.SortOrder.Descending, bAdd);
			}
			return this;
		};


		/**
		 * filter the given column by the given value
		 *
		 * @param {sap.ui.table.Column} oColumn
		 *         column to be filtered
		 * @param {string} sValue
		 *         filter value as string (will be converted)
		 * @return {sap.ui.table.DataTable} instance of the table for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.filter = function(oColumn, sValue) {
			if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
				oColumn.filter(sValue);
			}
			return this;
		};


		// =============================================================================
		// SELECTION HANDLING
		// =============================================================================

		DataTable.prototype._getSelectOnCellsAllowed = function () {
			var sSelectionBehavior = this.getSelectionBehavior();
			var sSelectionMode = this.getSelectionMode();
			return sSelectionMode !== sap.ui.table.SelectionMode.None && (sSelectionBehavior === sap.ui.table.SelectionBehavior.Row || sSelectionBehavior === sap.ui.table.SelectionBehavior.RowOnly);
		};

		/**
		 * Retrieve Aria descriptions from resource bundle for a certain selection mode
		 * @param {Boolean} [bConsiderSelectionState] set to true if the current selection state of the table shall be considered
		 * @param {String} [sSelectionMode] optional parameter. If no selection mode is set, the current selection mode of the table is used
		 * @returns {{mouse: {rowSelect: string, rowDeselect: string}, keyboard: {rowSelect: string, rowDeselect: string}}}
		 * @private
		 */
		DataTable.prototype._getAriaTextsForSelectionMode = function (bConsiderSelectionState, sSelectionMode) {
			if (!sSelectionMode) {
				sSelectionMode = this.getSelectionMode();
			}

			var oResBundle = this._oResBundle;
			var mTooltipTexts = {
				mouse: {
					rowSelect: "",
					rowDeselect: ""
				},
				keyboard:{
					rowSelect: "",
					rowDeselect: ""
				}};

			if (sSelectionMode === sap.ui.table.SelectionMode.Single) {
				mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
				mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
				mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
				mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");
			} else if (sSelectionMode === sap.ui.table.SelectionMode.Multi) {
				mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI");
				mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_MULTI");
				mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY");
				mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY");

				if (bConsiderSelectionState === true) {
					if (this.getSelectedIndices().length === 1) {
						// in multi selection case, if there is only one row selected it's not required
						// to press CTRL in order to only deselect this single row hence use the description text
						// of the single de-selection.
						// for selection it's different since the description for SHIFT/CTRL handling is required
						mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
						mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");
					} else if (this.getSelectedIndices().length === 0) {
						// if there are no rows selected in multi selection mode, it's not required to press CTRL or SHIFT
						// in order to enhance the selection.
						mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
						mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
					}
				}

			} else if (sSelectionMode === sap.ui.table.SelectionMode.MultiToggle) {
				mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_TOGGLE");
				// text for de-select is the same like for single selection
				mTooltipTexts.mouse.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT");
				mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");
				// text for de-select is the same like for single selection
				mTooltipTexts.keyboard.rowDeselect = oResBundle.getText("TBL_ROW_DESELECT_KEY");

				if (bConsiderSelectionState === true && this.getSelectedIndices().length === 0) {
					// if there is no row selected yet, the selection is like in single selection case
					mTooltipTexts.mouse.rowSelect = oResBundle.getText("TBL_ROW_SELECT");
					mTooltipTexts.keyboard.rowSelect = oResBundle.getText("TBL_ROW_SELECT_KEY");
				}
			}

			return mTooltipTexts;
		};

		/**
		 * updates the visual selection in the HTML markup
		 * @private
		 */
		DataTable.prototype._updateSelection = function() {
			if (this.getSelectionMode() === sap.ui.table.SelectionMode.None) {
				// there is no selection which needs to be updated. With the switch of the
				// selection mode the selection was cleared (and updated within that step)
				return;
			}

			// retrieve tooltip and aria texts only once and pass them to the rows _updateSelection function
			var mTooltipTexts = this._getAriaTextsForSelectionMode(true);

			// check whether the row can be clicked to change the selection
			var bSelectOnCellsAllowed = this._getSelectOnCellsAllowed();

			// trigger the rows to update their selection
			var aRows = this.getRows();
			for (var i = 0; i < aRows.length; i++) {
				var oRow = aRows[i];
				oRow._updateSelection(this, mTooltipTexts, bSelectOnCellsAllowed);
			}
			// update internal property to reflect the correct index
			this.setProperty("selectedIndex", this.getSelectedIndex(), true);
		};


		/**
		 * notifies the selection listeners about the changed rows
		 * @private
		 */
		DataTable.prototype._onSelectionChanged = function(oEvent) {
			var aRowIndices = oEvent.getParameter("rowIndices");
			var iRowIndex = this._iSourceRowIndex !== undefined ? this._iSourceRowIndex : this.getSelectedIndex();
			this._updateSelection();
			var oSelMode = this.getSelectionMode();
			if (oSelMode === "Multi" || oSelMode === "MultiToggle") {
				this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");
			}
			this.fireRowSelectionChange({
				rowIndex: iRowIndex,
				rowContext: this.getContextByIndex(iRowIndex),
				rowIndices: aRowIndices
			});
		};


		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */

		/**
		 * Returns the context of a row by its index. Please note that for server based models like OData
		 * the supplied index might not have been loaded yet. If the context is not available at the client
		 * the binding will trigger a backend request and request this single context. Although this API
		 * looks synchronous it may not return a context but load it and fire a change event on the binding.
		 *
		 * @param {int} iIndex
		 *         Index of the row to return the context from.
		 * @return {sap.ui.model.Context} context of the index position or null if not found
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.getContextByIndex = function(iIndex) {
			// TODO: ODataListBinding needs to make sure to prevent loading multiple times
			// index must not be smaller than 0! otherwise the ODataModel fails
			var oBinding = this.getBinding("rows");
			return iIndex >= 0 && oBinding ? oBinding.getContexts(iIndex, 1)[0] : null;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.getSelectedIndex = function() {
			//when using the treebindingadapter, check if the node is selected
			var oBinding = this.getBinding("rows");

			if (oBinding && oBinding.findNode) {
				return oBinding.getSelectedIndex();
			} else {
				return this._oSelection.getLeadSelectedIndex();
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setSelectedIndex = function(iIndex) {
			if (iIndex === -1) {
				//If Index eq -1 no item is selected, therefore clear selection is called
				//SelectionModel doesn't know that -1 means no selection
				this.clearSelection();
			}

			//when using the treebindingadapter, check if the node is selected
			var oBinding = this.getBinding("rows");

			if (oBinding && oBinding.findNode && oBinding.setNodeSelection) {
				// set the found node as selected
				oBinding.setSelectedIndex(iIndex);
				//this.fireEvent("selectionChanged");
			} else {
					this._oSelection.setSelectionInterval(iIndex, iIndex);
			}

			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */

		/**
		 * Removes complete selection.
		 *
		 * @return {sap.ui.table.DataTable} table instance for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.clearSelection = function() {
			var oBinding = this.getBinding("rows");

			if (oBinding && oBinding.clearSelection) {
				oBinding.clearSelection();
			} else {
				this._oSelection.clearSelection();
			}
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */

		/**
		 * Add all rows to the selection.
		 * Please note that for server based models like OData the indices which are considered to be selected might not
		 * be available at the client yet. Calling getContextByIndex might not return a result but trigger a roundtrip
		 * to request this single entity.
		 *
		 * @return sap.ui.table.DataTable
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.selectAll = function() {
			//select all is only allowed when SelectionMode is "Multi" or "MultiToggle"
			var oSelMode = this.getSelectionMode();
			if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
				return this;
			}

			var oBinding = this.getBinding("rows");
			if (oBinding) {
				if (oBinding.selectAll) {
					oBinding.selectAll();
					this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
				} else {
					this._oSelection.setSelectionInterval(0, (oBinding.getLength() || 0) - 1);
					this.$("selall").attr('title', this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
				}
			}
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */

		/**
		 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
		 *
		 * @return int[]
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.getSelectedIndices = function() {
			//when using the treebindingadapter, check if the node is selected
			var oBinding = this.getBinding("rows");

			if (oBinding && oBinding.findNode && oBinding.getSelectedIndices) {
				/*jQuery.sap.log.warning("When using a TreeTable on a V2 ODataModel, you can also use 'getSelectedContexts' on the underlying TreeBinding," +
				 " for an optimised retrieval of the binding contexts of the all selected rows/nodes.");*/
				return oBinding.getSelectedIndices();
			} else {
				return this._oSelection.getSelectedIndices();
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */

		/**
		 * Adds the given selection interval to the selection. In case of single selection the "indexTo" value will be used for as selected index.
		 *
		 * @param {int} iIndexFrom
		 *         Index from which .
		 * @param {int} iIndexTo
		 *         Indices of the items that shall additionally be selected.
		 * @return {sap.ui.table.DataTable} table instance for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.addSelectionInterval = function(iIndexFrom, iIndexTo) {
			var oBinding = this.getBinding("rows");
			//TBA check
			if (oBinding && oBinding.findNode && oBinding.addSelectionInterval) {
				oBinding.addSelectionInterval(iIndexFrom, iIndexTo);
			} else {
				this._oSelection.addSelectionInterval(iIndexFrom, iIndexTo);
			}

			return this;
		};

		/**
		 * Sets the given selection interval as selection. In case of single selection the "indexTo" value will be used for as selected index.
		 *
		 * @param {int} iIndexFrom
		 *         Index from which .
		 * @param {int} iIndexTo
		 *         Indices of the items that shall additionally be selected.
		 * @return {sap.ui.table.DataTable} table instance for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.setSelectionInterval = function(iIndexFrom, iIndexTo) {
			//when using the treebindingadapter, check if the node is selected
			var oBinding = this.getBinding("rows");

			if (oBinding && oBinding.findNode && oBinding.setSelectionInterval) {
				oBinding.setSelectionInterval(iIndexFrom, iIndexTo);
			} else {
				this._oSelection.setSelectionInterval(iIndexFrom, iIndexTo);
			}

			return this;
		};

		/**
		 * Removes the given selection interval from the selection. In case of single selection this call removeSelectedIndex with the "indexTo" value.
		 *
		 * @param {int} iIndexFrom
		 *         Index from which .
		 * @param {int} iIndexTo
		 *         Indices of the items that shall additionally be selected.
		 * @return {sap.ui.table.DataTable} table instance for method chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.removeSelectionInterval = function(iIndexFrom, iIndexTo) {
			var oBinding = this.getBinding("rows");
			//TBA check
			if (oBinding && oBinding.findNode && oBinding.removeSelectionInterval) {
				oBinding.removeSelectionInterval(iIndexFrom, iIndexTo);
			} else {
				this._oSelection.removeSelectionInterval(iIndexFrom, iIndexTo);
			}

			return this;
		};

		/**
		 * Returns whether the given index is selected.
		 *
		 * @param {int} iIndex
		 *         Index which is checked for selection state.
		 * @return {boolean} true if selected
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.isIndexSelected = function(iIndex) {
			var oBinding = this.getBinding("rows");
			//when using the treebindingadapter, check if the node is selected
			if (oBinding && oBinding.isIndexSelected) {
				return oBinding.isIndexSelected(iIndex);
			} else {
				return this._oSelection.isSelectedIndex(iIndex);
			}
		};

		/**
		 * Returns whether the row is expanded or collapsed.
		 *
		 * @param {int} iRowIndex index of the row to check
		 * @return {boolean} true if the node at "iRowIndex" is expanded, false otherwise (meaning it is collapsed)
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.isExpanded = function(iRowIndex) {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				return oBinding.isExpanded(iRowIndex);
			}
			return false;
		};

		/**
		 * Collapses all nodes on level 'iLevel' (and lower if collapseRecursive is activated)
		 * If no parameter is given, all nodes will be collapsed to the topmost level.
		 *
		 * Only supported with ODataModel v2.
		 *
		 * @param {int} iLevel the level to which all nodes shall be collapsed
		 * @return {sap.ui.table.DataTable} a reference on the TreeTable control, can be used for chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.expandToLevel = function (iLevel) {
			var oBinding = this.getBinding("rows");

			jQuery.sap.assert(oBinding && oBinding.expandToLevel, "TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");

			if (oBinding && oBinding.expandToLevel) {
				oBinding.expandToLevel(iLevel);
			}

			return this;
		};

		/**
		 * Collapses all nodes (and lower if collapseRecursive is activated)
		 *
		 * @return {sap.ui.table.DataTable} a reference on the TreeTable control, can be used for chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.collapseAll = function () {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				oBinding.collapseToLevel(0);
				this.setFirstVisibleRow(0);
			}

			return this;
		};

		/**
		 * expands the row for the given row index
		 *
		 * @param {int} iRowIndex
		 *         index of the row to expand
		 * @return {sap.ui.table.DataTable} a reference on the TreeTable control, can be used for chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.expand = function(iRowIndex) {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				oBinding.expand(iRowIndex);
			}

			return this;
		};

		/**
		 * collapses the row for the given row index
		 *
		 * @param {int} iRowIndex
		 *         index of the row to collapse
		 * @return {sap.ui.table.DataTable} a reference on the TreeTable control, can be used for chaining
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		DataTable.prototype.collapse = function(iRowIndex) {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				oBinding.collapse(iRowIndex);
			}

			return this;
		};

		DataTable.prototype._onGroupSelect = function(oEvent) {

			var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
			if ($parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
				var oContext = this.getContextByIndex(iRowIndex);
				if (this.getBinding().isExpanded(iRowIndex)) {
					jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
				} else {
					jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
				}
				this.fireToggleOpenState({
					rowIndex: iRowIndex,
					rowContext: oContext,
					expanded: !this.getBinding().isExpanded(iRowIndex)
				});
				//this.getBinding("rows").toggleContext(iRowIndex);
				this.getBinding("rows").toggleIndex(iRowIndex);
			}

			oEvent.preventDefault();
			oEvent.stopPropagation();

		};

		DataTable.prototype._onNodeSelect = function(oEvent) {

			var $parent = jQuery(oEvent.target).parents("tr");
			if ($parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
				var oContext = this.getContextByIndex(iRowIndex);
				this.fireToggleOpenState({
					rowIndex: iRowIndex,
					rowContext: oContext,
					expanded: !this.getBinding().isExpanded(iRowIndex)
				});
				//this.getBinding("rows").toggleContext(oContext);
				this.getBinding("rows").toggleIndex(iRowIndex);
			}

			oEvent.preventDefault();
			oEvent.stopPropagation();

		};

		DataTable.prototype._updateExpandIcon = function($row, oContext, iAbsoluteRowIndex) {

			var oBinding = this.getBinding("rows");

			if (oBinding) {
				var iLevel = 0,
					bIsExpanded = false;

				if (oBinding.getLevel) {
					//used by the "mini-adapter" in the TreeTable ClientTreeBindings
					iLevel = oBinding.getLevel(oContext);
					bIsExpanded = oBinding.isExpanded(iAbsoluteRowIndex);
				} else if (oBinding.findNode) { // the ODataTreebinding(Adapter) provides the hasChildren method for Tree
					var oNode = oBinding.findNode(iAbsoluteRowIndex);
					iLevel = oNode ? oNode.level : 0;
					bIsExpanded = oNode && oNode.nodeState ? oNode.nodeState.expanded : false;
				}

				var $TreeIcon = $row.find(".sapUiTableTreeIcon");
				var sTreeIconClass = "sapUiTableTreeIconLeaf";
				var $FirstTd = $row.children("td.sapUiTableTdFirst");
				if (!this.getUseGroupMode()) {
					$TreeIcon.css("marginLeft", iLevel * 17);
				}
				if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
					sTreeIconClass = bIsExpanded ? "sapUiTableTreeIconNodeOpen" : "sapUiTableTreeIconNodeClosed";
					$FirstTd.attr('aria-expanded', bIsExpanded);
					var sNodeText = bIsExpanded ? this._oResBundle.getText("TBL_COLLAPSE") : this._oResBundle.getText("TBL_EXPAND");
					$TreeIcon.attr('title', sNodeText);
				} else {
					$FirstTd.attr('aria-expanded', false);
					$TreeIcon.attr('aria-label', this._oResBundle.getText("TBL_LEAF"));
				}
				$TreeIcon.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(sTreeIconClass);
				$row.attr("data-sap-ui-level", iLevel);
				$FirstTd.attr('aria-level', iLevel + 1);
			}
		};

		DataTable.prototype._updateTableCell = function () {
			return true;
		};

		DataTable.prototype.isTreeBinding = function(sName) {
			sName = sName || "rows";
			if (sName === "rows") {
				return this.getHierarchical();
			}
			return sap.ui.core.Element.prototype.isTreeBinding.apply(this, arguments);
		};

		DataTable.prototype.setHierarchical = function(bHierarchical) {
			this.setProperty("hierarchical", bHierarchical);
			this._iLastFixedColIndex = bHierarchical ? 0 : -1;
		};

		// =============================================================================
		// KEYBOARD HANDLING HELPERS
		// =============================================================================

		/**
		 * scrolls down a single row
		 * @private
		 */
		DataTable.prototype._scrollNext = function() {
			// we are at the end => scroll one down if possible
			if (this.getFirstVisibleRow() < this._getRowCount() - this.getVisibleRowCount()) {
				this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + 1, this._getRowCount() - this.getVisibleRowCount()));
			}
		};

		/**
		 * scrolls up a single row
		 * @private
		 */
		DataTable.prototype._scrollPrevious = function() {
			// we are at the beginning => scroll one up if possible
			if (this.getFirstVisibleRow() > 0) {
				this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - 1, 0));
			}
		};

		/**
		 * scrolls down a up page
		 * @private
		 */
		DataTable.prototype._scrollPageUp = function() {
			this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - this.getVisibleRowCount(), 0));
		};

		/**
		 * scrolls down a complete page
		 * @private
		 */
		DataTable.prototype._scrollPageDown = function() {
			this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + this.getVisibleRowCount() - this.getFixedBottomRowCount(), this._getRowCount() - this.getVisibleRowCount()));
		};

		/**
		 * checks if the current target domref is in the first row of the table
		 * @private
		 */
		DataTable.prototype._isTopRow = function(oEvent) {
			var $target = jQuery(oEvent.target);
			var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
			var iFixedRows = this.getFixedRowCount();
			if (iFixedRows > 0 && iRowIndex >= iFixedRows) {
				return iRowIndex === iFixedRows;
			}
			return iRowIndex === 0;
		};

		/**
		 * checks if the current target domref is in the last row of the table
		 * @private
		 */
		DataTable.prototype._isBottomRow = function(oEvent) {
			var $target = jQuery(oEvent.target);
			var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
			var iFixedRows = this.getFixedBottomRowCount();
			if (iFixedRows > 0 && iRowIndex <= this.getVisibleRowCount() - 1 - iFixedRows) {
				return iRowIndex === this.getVisibleRowCount() - 1 - iFixedRows;
			}
			return iRowIndex === this.getVisibleRowCount() - 1;
		};

		/**
		 * enters the action mode. in the action mode the user can navigate through the
		 * interactive controls of the table by using the TAB & SHIFT-TAB. this table is
		 * aligned with the official WAI-ARIA 1.0.
		 * @private
		 */
		DataTable.prototype._enterActionMode = function($Focusable) {
			// only enter the action mode when not already in action mode and:
			if ($Focusable.length > 0 && !this._bActionMode) {

				//If cell has no tabbable element, we don't do anything
				if ($Focusable.filter(":sapTabbable").length == 0) {
					return;
				}

				// in the action mode we need no item navigation
				this._bActionMode = true;
				this.removeDelegate(this._oItemNavigation);

				// remove the tab index from the item navigation
				jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");

				// set the focus to the active control
				$Focusable.filter(":sapTabbable").eq(0).focus();
			}

			var $domRef = $Focusable.eq(0);
			if ($Focusable.length > 0 && $domRef.hasClass("sapUiTableTreeIcon") && !$domRef.hasClass("sapUiTableTreeIconLeaf")) {
				//Set tabindex to 0 to have make node icon accessible
				$domRef.attr("tabindex", 0).focus();
				//set action mode to true so that _leaveActionMode is called to remove the tabindex again
				this._bActionMode = true;
			}
		};

		/**
		 * leaves the action mode and enters the navigation mode. in the navigation mode
		 * the user can navigate through the cells of the table by using the arrow keys,
		 * page up & down keys, home and end keys. this table is aligned with the
		 * official WAI-ARIA 1.0.
		 * @private
		 */
		DataTable.prototype._leaveActionMode = function(oEvent) {

			// TODO: update ItemNavigation position otherwise the position is strange!
			//        EDIT AN SCROLL!

			if (this._bActionMode) {

				// in the navigation mode we use the item navigation
				this._bActionMode = false;
				this.addDelegate(this._oItemNavigation);

				// reset the tabindex of the focused domref of the item navigation
				jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

				// when we have an event which is responsible to leave the action mode
				// we search for the closest
				if (oEvent) {
					if (jQuery(oEvent.target).closest("td[tabindex='-1']").length > 0) {
						// triggered when clicking into a cell, then we focus the cell
						var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("td[tabindex='-1']").get(0));
						this._oItemNavigation.focusItem(iIndex, null);
					} else {
						// somewhere else means whe check if the click happend inside
						// the container, then we focus the last focused element
						// (DON'T KNOW IF THIS IS OK - but we don't know where the focus was!)
						if (jQuery.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0), oEvent.target)) {
							this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
						}
					}
				} else {
					// when no event is given we just focus the last focused index
					this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
				}

			}

			this.$().find(".sapUiTableTreeIcon").attr("tabindex", -1);
		};

		/**
		 * Return the focused row index.
		 * @return {int} the currently focused row index.
		 * @private
		 */
		DataTable.prototype._getFocusedRowIndex = function() {
			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedCellInRow = iFocusedIndex % iColumns;
			var iSelectedRow = this.getFirstVisibleRow() + (iFocusedIndex - iSelectedCellInRow) / iColumns;

			if (!this.getColumnHeaderVisible()) {
				iSelectedRow++;
			}
			return iSelectedRow - 1;
		};

		/**
		 * Checks whether the row of the currently focused cell is selected or not.
		 * @return {boolean} true or false
		 * @private
		 */
		DataTable.prototype._isFocusedRowSelected = function() {
			var iSelectedRow = this._getFocusedRowIndex();
			var bIsFocusedRowSelected = this.isIndexSelected(iSelectedRow);

			var bIsCellRowHeader = (this._oItemNavigation.iFocusedIndex % this._oItemNavigation.iColumns == 0);
			if (bIsCellRowHeader) {
				return bIsFocusedRowSelected;
			} else {
				var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
				if (bHasRowHeader) {
					return null;
				} else {
					return bIsFocusedRowSelected;
				}
			}
		};

		// =============================================================================
		// KEYBOARD HANDLING EVENTS
		// =============================================================================

		// FYI: two more relevant things are handled in the onclick and onfocusin event

		/**
		 * handle the row selection via SPACE or ENTER key if key is pressed on a group header, the open state is toggled
		 * @private
		 */
		DataTable.prototype.onkeyup = function(oEvent) {
			if (!this._bEventSapSelect === true) {
				return;
			}

			this._bEventSapSelect = false;

			// this mimics the sapselect event but on keyup
			if (oEvent.keyCode !== jQuery.sap.KeyCodes.ENTER &&
				oEvent.keyCode !== jQuery.sap.KeyCodes.SPACE &&
				oEvent.keyCode !== jQuery.sap.KeyCodes.F4 ||
				oEvent.srcControl !== this &&
				jQuery.inArray(oEvent.srcControl,this.getRows()) === -1 &&
				jQuery.inArray(oEvent.srcControl,this.getColumns()) === -1) {
				return;
			}
			var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
			if ($Parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				if (oBinding) {
					if (oBinding.isExpanded(iRowIndex)) {
						oBinding.collapse(iRowIndex);
					} else {
						oBinding.expand(iRowIndex);
					}
				}
				oEvent.preventDefault();
				return;
			}
			this._bShowMenu = true;
			this._onSelect(oEvent);
			this._bShowMenu = false;
			oEvent.preventDefault();
		};

		/**
		 * @private
		 */
		DataTable.prototype.onsapselect = function(oEvent) {
			if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
				this._onNodeSelect(oEvent);
			} else {
				this._bEventSapSelect = true;
			}
		};

		/**
		 * @private
		 */
		DataTable.prototype.onsapselectmodifiers = function() {
			this._bEventSapSelect = true;
		};

		/**
		 * handle the row selection via SPACE or ENTER key
		 * @private
		 */
		DataTable.prototype.onkeydown = function(oEvent) {
			var $this = this.$();
			if (!this._bActionMode &&
				oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
				oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
				if ($this.find(".sapUiTableCtrl td:focus").length > 0) {
					this._enterActionMode($this.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));
					oEvent.preventDefault();
					oEvent.stopPropagation();
				}
			} else if (this._bActionMode &&
				oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
				this._leaveActionMode(oEvent);
			} else if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode) {
				//Set tabindex to second table if fixed columns are used
				if (this.getFixedColumnCount() > 0) {
					var $cell = jQuery(oEvent.target);
					if ($cell.is("td[role=gridcell]") == false) {
						$cell = $cell.parents("td[role=gridcell]");
					}
					var $row = $cell.parent("tr[data-sap-ui-rowindex]");
					var $table = $row.closest(".sapUiTableCtrl");
					var iRowIndex = parseInt($row.attr("data-sap-ui-rowindex"),10);
					var $cells = $row.find("td[role=gridcell]");
					var iColIndex = $cells.index($cell);
					var iTableCols = $cells.length;
					if (iColIndex === (iTableCols - 1)) {
						var $otherTable;
						if ($table.hasClass("sapUiTableCtrlFixed")) {
							$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll");
						} else {
							$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlFixed");
							iRowIndex++;
							if (iRowIndex == this.getVisibleRowCount()) {
								iRowIndex = 0;
							}
						}
						var $otherRow = $otherTable.find("tr[data-sap-ui-rowindex='" + iRowIndex + "']");
						var $nextFocus = $otherRow.find("td :sapFocusable[tabindex='0']").first();
						if ($nextFocus.length > 0) {
							$nextFocus.focus();
							oEvent.preventDefault();
						}
					}
				}
			} else if (oEvent.keyCode == jQuery.sap.KeyCodes.A && (oEvent.metaKey || oEvent.ctrlKey)) {
				// CTRL + A handling
				var oIN = this._oItemNavigation;
				var iFocusedIndex = oIN.getFocusedIndex();

				this._toggleSelectAll();

				oIN.focusItem(iFocusedIndex, oEvent);

				oEvent.preventDefault();
				oEvent.stopImmediatePropagation(true);
			} else if (oEvent.keyCode === jQuery.sap.KeyCodes.F10 && (oEvent.shiftKey)) {
				// SHIFT + 10 should open the context menu
				this.oncontextmenu(oEvent);
			}

			var $Target = jQuery(oEvent.target),
				$TargetTD = $Target.closest('td');
			if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode && $TargetTD.find('.sapUiTableTreeIcon').length > 0) {
				//If node icon has focus set tab to control else set tab to node icon
				if ($Target.hasClass('sapUiTableTreeIcon')) {
					if (!$Target.hasClass("sapUiTableTreeIconLeaf")) {
						$TargetTD.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();
					}
				} else {
					$TargetTD.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();
				}
				oEvent.preventDefault();
			}
		};

		/**
		 * handle the ESCAPE key to leave the action mode
		 * @private
		 */
		DataTable.prototype.onsapescape = function(oEvent) {
			this._leaveActionMode(oEvent);
		};

		/**
		 * handle the SHIFT-TAB key
		 * <ul>
		 *   <li>Navigation Mode:
		 *      <ul>
		 *          <li>If focus is on header: jump to the next focusable control before the table</li>
		 *          <li>If focus in on content: jump to header for the current column</li>
		 *      </ul>
		 *   <li>Action Mode: switch back to navigation mode</li>
		 * </ul>
		 * @private
		 */
		DataTable.prototype.onsaptabprevious = function(oEvent) {
			var $this = this.$();
			if (this._bActionMode) {
				this._leaveActionMode();
				oEvent.preventDefault();
			} else {
				var oIN = this._oItemNavigation;
				var bNoData = this.$().hasClass("sapUiTableEmpty");
				var oSapUiTableCCnt = $this.find('.sapUiTableCCnt')[0];
				var bFocusFromTableContent = jQuery.contains(oSapUiTableCCnt, oEvent.target);

				if (bFocusFromTableContent && this.getColumnHeaderVisible()) {
					// Focus comes from table content. Focus the column header which corresponds to the
					// selected column (column index)
					var iColumn = oIN.getFocusedIndex() % oIN.iColumns;
					oIN.focusItem(iColumn, oEvent);
					oEvent.preventDefault();
				} else if (oIN.getFocusedDomRef() === oEvent.target && jQuery.sap.containsOrEquals(oSapUiTableCCnt, oEvent.target) ||
					(!this.getColumnHeaderVisible() && bNoData && bFocusFromTableContent)) {
					// in case of having the focus in the row or column header we do not need to
					// place the focus to the div before the table control because there we do
					// not need to skip the table controls anymore.
					this._bIgnoreFocusIn = true;
					$this.find(".sapUiTableCtrlBefore").focus();
					this._bIgnoreFocusIn = false;
				}
			}
		};

		/**
		 * handle the TAB key:
		 * <ul>
		 *   <li>Navigation Mode:
		 *      <ul>
		 *          <li>If focus is on header: jump to the first data column of the focused column header</li>
		 *          <li>If focus in on content: jump to the next focusable control after the table</li>
		 *      </ul>
		 *   <li>Action Mode: switch back to navigation mode</li>
		 * </ul>
		 * @private
		 */
		DataTable.prototype.onsaptabnext = function(oEvent) {
			var $this = this.$();
			if (this._bActionMode) {
				this._leaveActionMode();
				oEvent.preventDefault();
			} else {
				var oIN = this._oItemNavigation;
				var bContainsColHdrCnt = jQuery.contains($this.find('.sapUiTableColHdrCnt')[0], oEvent.target);
				var bNoData = this.$().hasClass("sapUiTableEmpty");

				if (bContainsColHdrCnt && !bNoData) {
					oIN.focusItem(oIN.getFocusedIndex() + oIN.iColumns * this._iLastSelectedDataRow, oEvent);
					oEvent.preventDefault();
				} else if (oIN.getFocusedDomRef() === oEvent.target || (bNoData && bContainsColHdrCnt)) {
					this._bIgnoreFocusIn = true;
					$this.find(".sapUiTableCtrlAfter").focus();
					this._bIgnoreFocusIn = false;
				}
			}
		};

		/**
		 *
		 * @param bForceUpdate
		 * @private
		 */
		DataTable.prototype._updateAriaRowOfRowsText = function(bForceUpdate) {
			var oAriaElement = document.getElementById(this.getId() + "-rownumberofrows");

			if (!oAriaElement) {
				// table is not in DOM anymore
				return;
			}

			var oIN = this._oItemNavigation;
			if (oIN) {
				var iIndex = oIN.getFocusedIndex();
				var iColumnNumber = iIndex % oIN.iColumns;

				var iFirstVisibleRow = this.getFirstVisibleRow();
				var iTotalRowCount = this._getRowCount();
				var iRowIndex = Math.floor(iIndex / oIN.iColumns) + iFirstVisibleRow + 1 - this._getHeaderRowCount();

				var sRowCountText = this._oResBundle.getText("TBL_ROW_ROWCOUNT", [iRowIndex, iTotalRowCount]);
				if (iRowIndex > 0 && iColumnNumber === 0 || bForceUpdate) {
					oAriaElement.innerText = sRowCountText;
				} else {
					oAriaElement.innerText = " ";
				}
			}
		};


		/**
		 * dynamic scrolling when reaching the bottom row with the ARROW DOWN key
		 * @private
		 */
		DataTable.prototype.onsapdown = function(oEvent) {
			if (!this._bActionMode && this._isBottomRow(oEvent)) {
				if (this.getFirstVisibleRow() != this._getRowCount() - this.getVisibleRowCount()) {
					oEvent.stopImmediatePropagation(true);
					if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
						this._scrollNext();
					} else {
						this._scrollPageDown();
					}
				}
			}
			oEvent.preventDefault();
		};

		/**
		 * Implements selecting/deselecting rows when pressing SHIFT + DOWN
		 * @private
		 */
		DataTable.prototype.onsapdownmodifiers = function(oEvent) {
			if (oEvent.shiftKey) {
				var iFocusedRow = this._getFocusedRowIndex();
				var bIsFocusedRowSelected = this._isFocusedRowSelected();
				if (bIsFocusedRowSelected === true) {
					this.addSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
				} else if (bIsFocusedRowSelected === false) {
					this.removeSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
				}

				if (this._isBottomRow(oEvent)) {
					this._scrollNext();
				}
			} else if (oEvent.altKey) {
				// Toggle group header on ALT + DOWN.
				this._toggleGroupHeader(oEvent);
			}
		};

		/**
		 * Implements selecting/deselecting rows when pressing SHIFT + UP
		 *
		 * @private
		 */
		DataTable.prototype.onsapupmodifiers = function(oEvent) {
			if (oEvent.shiftKey) {
				var iFocusedRow = this._getFocusedRowIndex();
				var bIsFocusedRowSelected = this._isFocusedRowSelected();

				if (bIsFocusedRowSelected === true) {
					this.addSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
				} else if (bIsFocusedRowSelected === false) {
					this.removeSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
				}

				if (this._isTopRow(oEvent)) {
					// Prevent that focus jumps to header in this case.
					if (this.getFirstVisibleRow() != 0) {
						oEvent.stopImmediatePropagation(true);
					}
					this._scrollPrevious();
				}
			} else if (oEvent.altKey) {
				// Toggle group header on ALT + UP.
				this._toggleGroupHeader(oEvent);
			}
		};

		/**
		 * dynamic scrolling when reaching the top row with the ARROW UP key
		 *
		 * @private
		 */
		DataTable.prototype.onsapup = function(oEvent) {
			if (!this._bActionMode && this._isTopRow(oEvent)) {
				if (this.getFirstVisibleRow() != 0) {
					oEvent.stopImmediatePropagation(true);
				}
				if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
					this._scrollPrevious();
				} else {
					this._scrollPageUp();
				}
			}
			oEvent.preventDefault();
		};

		/**
		 * dynamic scrolling when reaching the bottom row with the PAGE DOWN key
		 * @private
		 */
		DataTable.prototype.onsappagedown = function(oEvent) {
			if (!this._bActionMode) {
				var $this = this.$();
				var oIN = this._oItemNavigation;

				var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
				var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;

				// Check if focus is on header
				// Special Handling is required here:
				// - If not in the last header row, jump to the last header row in the same column
				// - If in the last header row, scroll table to first row and jump to first row, same column
				if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
					// focus is on header
					var iCol = oIN.iFocusedIndex % oIN.iColumns;
					if ((oIN.iFocusedIndex <= (oIN.iColumns * iHeaderRows) && oIN.iFocusedIndex >= (oIN.iColumns * iHeaderRows) - oIN.iColumns) ||
						(iCol === 0 && bRowHeader)) {
						// move focus to first data row, scroll table to top
						this.setFirstVisibleRow(0);
						oIN.focusItem(oIN.iColumns * iHeaderRows + iCol, oEvent);
					} else {
						// set focus to last header row, same column if possible
						oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
					}

					oEvent.stopImmediatePropagation(true);
				} else {
					if (this._isBottomRow(oEvent)) {
						this._scrollPageDown();
					}

					var iFixedBottomRowsOffset = this.getFixedBottomRowCount();
					if (this.getFirstVisibleRow() === this._getRowCount() - this.getVisibleRowCount()) {
						iFixedBottomRowsOffset = 0;
					}

					var iRowCount = (oIN.aItemDomRefs.length / oIN.iColumns) - iFixedBottomRowsOffset;
					var iCol = oIN.iFocusedIndex % oIN.iColumns;
					var iIndex = (iRowCount - 1) * oIN.iColumns + iCol;

					oIN.focusItem(iIndex, oEvent);

					oEvent.stopImmediatePropagation(true);
				}
				oEvent.preventDefault();
			}
		};

		/**
		 * dynamic scrolling when reaching the top row with the PAGE DOWN key
		 * @private
		 */
		DataTable.prototype.onsappagedownmodifiers = function(oEvent) {
			if (!this._bActionMode && oEvent.altKey) {
				var oIN = this._oItemNavigation;
				var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

				var iCol = oIN.iFocusedIndex % oIN.iColumns;
				var iNewCol;
				if (iCol == 0 && bRowHeader) {
					iNewCol = 1;
				} else {
					var iVisibleColumns = this._aVisibleColumns.length;
					var iMaxIndex = this._getVisibleColumns().length;
					if (!bRowHeader) {
						iMaxIndex--;
					}
					if (iVisibleColumns === 0) {
						iNewCol = iMaxIndex;
					} else {
						iNewCol = Math.min(iMaxIndex, iCol + iVisibleColumns);
					}
				}
				oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
				oEvent.stopImmediatePropagation(true);
				oEvent.preventDefault();
			}
		};

		/**
		 * dynamic scrolling when reaching the top row with the PAGE UP key
		 * @private
		 */
		DataTable.prototype.onsappageup = function(oEvent) {
			if (!this._bActionMode) {
				var $this = this.$();
				var oIN = this._oItemNavigation;

				var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
				var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;
				var iCol = oIN.iFocusedIndex % oIN.iColumns;

				if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
					// focus is on header
					if (oIN.iFocusedIndex > oIN.iColumns) {
						// focus is not on the first header row, move to first
						oIN.focusItem(iCol, oEvent);
					}
					oEvent.stopImmediatePropagation(true);
				} else {
					// focus is on content area
					if (this.getColumnHeaderVisible() && this.getFirstVisibleRow() == 0 && this._isTopRow(oEvent)) {
						// focus is on first row, move to last header row, same column
						if (bRowHeader && iCol === 0) {
							oIN.focusItem(iCol, oEvent);
						} else {
							oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
						}
						oEvent.stopImmediatePropagation(true);
					} else {
						var iIndex = this.getColumnHeaderVisible() ? oIN.iColumns * iHeaderRows : 0;
						oIN.focusItem(iIndex + iCol, oEvent);
						oEvent.stopImmediatePropagation(true);

						if (this._isTopRow(oEvent)) {
							this._scrollPageUp();
						}
					}
				}

				oEvent.preventDefault();
			}
		};

		/**
		 * dynamic scrolling when reaching the top row with the PAGE UP key
		 * @private
		 */
		DataTable.prototype.onsappageupmodifiers = function(oEvent) {
			if (!this._bActionMode && oEvent.altKey) {
				var oIN = this._oItemNavigation;
				var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

				var iCol = oIN.iFocusedIndex % oIN.iColumns;
				if (iCol > 0) {
					var iNewCol;
					if (iCol == 1 && bRowHeader) {
						iNewCol = 0;
					} else {
						var iVisibleColumns = this._aVisibleColumns.length;
						if (iVisibleColumns === 0) {
							if (bRowHeader) {
								iNewCol = 1;
							} else {
								iNewCol = 0;
							}
						} else {
							var iMin = 1;
							if (!bRowHeader) {
								iMin = 0;
							}
							iNewCol = Math.max(iMin, iCol - iVisibleColumns);
						}
					}
					oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
				}
				oEvent.stopImmediatePropagation(true);
				oEvent.preventDefault();
			}
		};

		/**
		 * Keyboard Handling regarding HOME key
		 *
		 * @private
		 */
		DataTable.prototype.onsaphome = function(oEvent) {
			var bIsRowOnly = (this.getSelectionBehavior() == sap.ui.table.SelectionBehavior.RowOnly);

			// If focus is on a group header, do nothing.
			var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
			if (bIsGroupCell) {
				oEvent.stopImmediatePropagation(true);
				return;
			}

			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			var offset = 0;
			if (!bIsRowOnly) {
				offset = 1;
			}

			if (iSelectedCellInRow > this.getFixedColumnCount() + offset) {
				// If there is a fixed column, stop right of it.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() + offset, null);
			} else if (!bIsRowOnly) {
				if (iSelectedCellInRow > 1) {
					// if focus is anywhere in the row, move focus to the first column cell.
					oEvent.stopImmediatePropagation(true);
					this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + 1, null);
				} else if (iSelectedCellInRow == 1) {
					// if focus is on first cell, move focus to row header.
					oEvent.stopImmediatePropagation(true);
					this._oItemNavigation.focusItem(iFocusedIndex - 1, null);
				} else {
					// If focus is on selection cell, do nothing.
					oEvent.stopImmediatePropagation(true);
				}
			}
		};

		/**
		 * Keyboard Handling regarding END key
		 *
		 * @private
		 */
		DataTable.prototype.onsapend = function(oEvent) {
			// If focus is on a group header, do nothing.
			var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
			if (bIsGroupCell) {
				oEvent.stopImmediatePropagation(true);
				return;
			}

			// If focus is on a selection cell, move focus to the first cell of the same row.
			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			var bIsRowOnly = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
			var offset = 0;
			if (!bIsRowOnly) {
				offset = 1;
			}

			if (iSelectedCellInRow === 0 && bIsRowOnly) {
				// If focus is in row header, select first cell in same row.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex + 1, null);
			} else if (iSelectedCellInRow < this.getFixedColumnCount() - offset) {
				// if their is a fixed column, stop left of it.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() - offset, null);
			}
		};

		/**
		 * dynamic scrolling when using CTRL + HOME key
		 *
		 * @private
		 */
		DataTable.prototype.onsaphomemodifiers = function(oEvent) {
			if (oEvent.metaKey || oEvent.ctrlKey) {
				var $this = this.$();

				// Is target a table header cell
				var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
				var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

				// If focus is on a group header, do nothing.
				if (bIsTableHeaderCell) {
					oEvent.stopImmediatePropagation(true);
					return;
				}

				var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
				var iColumns = this._oItemNavigation.iColumns;
				var iSelectedRowInColumn = Math.ceil(iFocusedIndex / iColumns) - 1;
				var iSelectedCellInRow = iFocusedIndex % iColumns;

				if (this.getColumnHeaderVisible()) {
					if (iSelectedRowInColumn == 1) {
						// if focus is in first row, select corresponding header
						oEvent.stopImmediatePropagation(true);
						this._oItemNavigation.focusItem(iSelectedCellInRow, oEvent);
					} else if (iSelectedRowInColumn > 1) {
						oEvent.stopImmediatePropagation(true);

						// if focus is in any row, select first cell row
						this.setFirstVisibleRow(0);

						var iTargetIndex = iSelectedCellInRow + iColumns;
						this._oItemNavigation.focusItem(iTargetIndex, oEvent);
					}
				} else {
					oEvent.stopImmediatePropagation(true);

					// if focus is in any row, select first cell row
					this.setFirstVisibleRow(0);

					var iTargetIndex = iFocusedIndex - iSelectedRowInColumn * iColumns;
					this._oItemNavigation.focusItem(iTargetIndex, oEvent);
				}
			}
		};

		/**
		 * dynamic scrolling when using CTRL + END key
		 *
		 * @private
		 */
		DataTable.prototype.onsapendmodifiers = function(oEvent) {
			if (oEvent.metaKey || oEvent.ctrlKey) {
				var $this = this.$();

				// Is target a table header cell
				var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
				var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

				var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
				var iColumns = this._oItemNavigation.iColumns;
				var iSelectedCellInRow = iFocusedIndex % iColumns;

				oEvent.stopImmediatePropagation(true);

				if (bIsTableHeaderCell) {
					// If focus is on a group header, select first cell row after header.
					this._oItemNavigation.focusItem(iFocusedIndex + iColumns, oEvent);
				} else {
					// if focus is on any cell row, select last cell row.
					this.setFirstVisibleRow(this._getRowCount() - this.getVisibleRowCount());
					var iTargetIndex = this._oItemNavigation.aItemDomRefs.length - (iColumns - iSelectedCellInRow);
					this._oItemNavigation.focusItem(iTargetIndex, oEvent);
				}
			}
		};

		/**
		 * Default handler for sapleft event.
		 * @private
		 */
		DataTable.prototype.onsapleft = function(oEvent) {
			this._collapseGroupHeader(oEvent);
		};

		/**
		 * Default handler for sapright event.
		 * @private
		 */
		DataTable.prototype.onsapright = function(oEvent) {
			this._expandGroupHeader(oEvent);
		};


		/**
		 * If focus is on group header, open/close the group header, depending on the expand state.
		 * @private
		 */
		DataTable.prototype._toggleGroupHeader = function(oEvent) {
			var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
			if ($Parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				if (oBinding && oBinding.isExpanded(iRowIndex)) {
					oBinding.collapse(iRowIndex);
				} else {
					oBinding.expand(iRowIndex);
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		};

		/**
		 * If focus is on group header, close the group header, else do the default behaviour of item navigation
		 * @private
		 */
		DataTable.prototype._collapseGroupHeader = function(oEvent) {
			var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
			if ($Parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				if (oBinding && oBinding.isExpanded(iRowIndex)) {
					oBinding.collapse(iRowIndex);
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		};

		/**
		 * If focus is on group header, open the group header, else do the default behaviour of item navigation
		 * @private
		 */
		DataTable.prototype._expandGroupHeader = function(oEvent) {
			var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
			if ($Parent.length > 0) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				if (oBinding && !oBinding.isExpanded(iRowIndex)) {
					oBinding.expand(iRowIndex);
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		};

		/**
		 * On shift+left on column header decrease the width of a column
		 * @private
		 */
		DataTable.prototype.onsapleftmodifiers = function(oEvent) {
			var $Target = jQuery(oEvent.target);
			if ($Target.hasClass('sapUiTableCol')) {
				var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10),
					aVisibleColumns = this._getVisibleColumns(),
					oColumn = aVisibleColumns[this._aVisibleColumns.indexOf(iColIndex)];

				if (oEvent.shiftKey) {
					var iNewWidth = parseInt(oColumn.getWidth(), 10) - 16;
					oColumn.setWidth((iNewWidth > 20 ? iNewWidth : 20) + "px");
					oEvent.preventDefault();
					oEvent.stopImmediatePropagation();
				} else if (oEvent.ctrlKey || oEvent.metaKey) {
					if (iColIndex - 1 >= 0) {
						// check whether preceding column is part of column span
						var iNewIndex = 0;

						for (var iPointer = this._aVisibleColumns.indexOf(iColIndex) - 1; iPointer >= 0; iPointer--) {
							iNewIndex = this._aVisibleColumns[iPointer];
							if (aVisibleColumns[iPointer].$().css("display") !== "none") {
								break;
							}
						}
						this.removeColumn(oColumn);
						this.insertColumn(oColumn, iNewIndex);

						// also move spanned columns
						var iHeaderSpan = oColumn.getHeaderSpan();
						if (iHeaderSpan > 1) {
							for (var i = 1; i < iHeaderSpan; i++) {
								oColumn = aVisibleColumns[iColIndex + i];
								this.removeColumn(oColumn);
								this.insertColumn(oColumn, iNewIndex + i);
							}
						}
					}
					oEvent.preventDefault();
					oEvent.stopImmediatePropagation();
				}
			}
		};

		/**
		 * On shift+left on column header decrease the width of a column
		 * @private
		 */
		DataTable.prototype.onsaprightmodifiers = function(oEvent) {
			var $Target = jQuery(oEvent.target);
			if ($Target.hasClass('sapUiTableCol')) {
				var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10);
				var aVisibleColumns = this._getVisibleColumns();
				var iPointer = this._aVisibleColumns.indexOf(iColIndex);
				var oColumn = aVisibleColumns[iPointer];
				if (oEvent.shiftKey) {
					oColumn.setWidth(parseInt(oColumn.getWidth(), 10) + 16 + "px");
					oEvent.preventDefault();
					oEvent.stopImmediatePropagation();
				} else if (oEvent.ctrlKey || oEvent.metaKey) {
					var iHeaderSpan = oColumn.getHeaderSpan();
					if (iPointer < aVisibleColumns.length - iHeaderSpan) {
						// Depending on the header span of the column to be moved, several
						// columns might need to be moved to the right
						var iNextHeaderSpan = aVisibleColumns[iPointer + 1].getHeaderSpan(),
							iNewIndex = this._aVisibleColumns[iPointer + iNextHeaderSpan];
						//iPointer = this._aVisibleColumns[iPointer];
						for (var i = iHeaderSpan - 1; i >= 0; i--) {
							oColumn = aVisibleColumns[iPointer + i];
							this.removeColumn(oColumn);
							this.insertColumn(oColumn, iNewIndex + i);
						}
					}
					oEvent.preventDefault();
					oEvent.stopImmediatePropagation();
				}
			}
		};

		// =============================================================================
		// GROUPING
		// =============================================================================

		/*
		 * overridden to hide the group by column when set
		 */
		DataTable.prototype.setGroupBy = function(vValue) {

			// determine the group by column
			var oGroupBy = vValue;
			if (typeof oGroupBy === "string") {
				oGroupBy = sap.ui.getCore().byId(oGroupBy);
			}

			// only for columns we do the full handling here - otherwise the method
			// setAssociation will fail below with a specific fwk error message
			var bReset = false;
			if (oGroupBy && oGroupBy instanceof sap.ui.table.Column) {

				// check for column being part of the columns aggregation
				if (jQuery.inArray(oGroupBy, this.getColumns()) === -1) {
					throw new Error("Column has to be part of the columns aggregation!");
				}

				// fire the event (to allow to cancel the event)
				var bExecuteDefault = this.fireGroup({column: oGroupBy, groupedColumns: [oGroupBy.getId()], type: sap.ui.table.GroupEventType.group});

				// first we reset the grouping indicator of the old column (will show the column)
				var oOldGroupBy = sap.ui.getCore().byId(this.getGroupBy());
				if (oOldGroupBy) {
					oOldGroupBy.setGrouped(false);
					bReset = true;
				}

				// then we set the grouping indicator of the new column (will hide the column)
				// ==> only if the default behavior is not prevented
				if (bExecuteDefault && oGroupBy instanceof sap.ui.table.Column) {
					oGroupBy.setGrouped(true);
				}

			}

			// reset the binding when no value is given or the binding needs to be reseted
			// TODO: think about a better handling to recreate the group binding
			if (!oGroupBy || bReset) {
				var oBindingInfo = this.getBindingInfo("rows");
				delete oBindingInfo.binding;
				this._bindAggregation("rows", oBindingInfo);
			}

			// set the new group by column (TODO: undefined doesn't work!)
			return this.setAssociation("groupBy", oGroupBy);
		};

		DataTable.prototype.getBinding = function(sName) {
			sName = sName || "rows";
			var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);

			// the check for the tree binding is only relevant becuase of the DataTable migration
			//  --> once the DataTable is deleted after the deprecation period this check can be deleted
			if (oBinding && this.isTreeBinding(sName) && sName === "rows" && !oBinding.getLength) {

				if (oBinding instanceof sap.ui.model.ClientTreeBinding || oBinding.getModel() instanceof sap.ui.model.odata.ODataModel) {
					// Code necessary for ClientTreeBinding
					var that = this;
					jQuery.extend(oBinding, {
						_init: function(bExpandFirstLevel) {
							this._bExpandFirstLevel = bExpandFirstLevel;
							// load the root contexts and create the context info map
							this.mContextInfo = {};
							this._initContexts();
							// expand the first level if required
							if (bExpandFirstLevel && !this._bFirstLevelExpanded) {
								this._expandFirstLevel();
							}
						},

						_initContexts: function(bSkipFirstLevelLoad) {
							// load the root contexts and create the context info map entry (if missing)
							this.aContexts = this.getRootContexts();
							for (var i = 0, l = this.aContexts.length; i < l; i++) {
								var oldContextInfo = this._getContextInfo(this.aContexts[i]);
								this._setContextInfo({
									oContext: this.aContexts[i],
									iLevel: 0,
									bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
								});
							}

							if (this._bExpandFirstLevel && !this._bFirstLevelExpanded) {
								this._expandFirstLevel(bSkipFirstLevelLoad);
							}
						},

						_expandFirstLevel: function (bSkipFirstLevelLoad) {
							var that = this;
							if (this.aContexts && this.aContexts.length > 0) {
								jQuery.each(this.aContexts.slice(), function(iIndex, oContext) {
									if (!bSkipFirstLevelLoad) {
										that._loadChildContexts(oContext);
									}
									that._getContextInfo(oContext).bExpanded = true;
								});

								this._bFirstLevelExpanded = true;
							}
						},

						_fnFireFilter: oBinding._fireFilter,
						_fireFilter: function() {
							this._fnFireFilter.apply(this, arguments);
							this._initContexts(true);
							this._restoreContexts(this.aContexts);
						},
						_fnFireChange: oBinding._fireChange,
						_fireChange: function() {
							this._fnFireChange.apply(this, arguments);
							this._initContexts(true);
							this._restoreContexts(this.aContexts);
						},
						_restoreContexts: function(aContexts) {
							var that = this;
							var aNewChildContexts = [];
							jQuery.each(aContexts.slice(), function(iIndex, oContext) {
								var oContextInfo = that._getContextInfo(oContext);
								if (oContextInfo && oContextInfo.bExpanded) {
									aNewChildContexts.push.apply(aNewChildContexts, that._loadChildContexts(oContext));
								}
							});
							if (aNewChildContexts.length > 0) {
								this._restoreContexts(aNewChildContexts);
							}
						},
						_loadChildContexts: function(oContext) {
							var oContextInfo = this._getContextInfo(oContext);
							var iIndex = jQuery.inArray(oContext, this.aContexts);
							var aNodeContexts = this.getNodeContexts(oContext);
							for (var i = 0, l = aNodeContexts.length; i < l; i++) {
								this.aContexts.splice(iIndex + i + 1, 0, aNodeContexts[i]);
								var oldContextInfo = this._getContextInfo(aNodeContexts[i]);
								this._setContextInfo({
									oParentContext: oContext,
									oContext: aNodeContexts[i],
									iLevel: oContextInfo.iLevel + 1,
									bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
								});
							}
							return aNodeContexts;
						},
						_getContextInfo: function(oContext) {
							return oContext ? this.mContextInfo[oContext.getPath()] : undefined;
						},
						_setContextInfo: function(mData) {
							if (mData && mData.oContext) {
								this.mContextInfo[mData.oContext.getPath()] = mData;
							}
						},
						getLength: function() {
							return this.aContexts ? this.aContexts.length : 0;
						},
						getContexts: function(iStartIndex, iLength) {
							return this.aContexts.slice(iStartIndex, iStartIndex + iLength);
						},
						getContextByIndex: function (iRowIndex) {
							return this.aContexts[iRowIndex];
						},
						getLevel: function(oContext) {
							var oContextInfo = this._getContextInfo(oContext);
							return oContextInfo ? oContextInfo.iLevel : -1;
						},
						isExpanded: function(iRowIndex) {
							var oContext = this.getContextByIndex(iRowIndex);
							var oContextInfo = this._getContextInfo(oContext);
							return oContextInfo ? oContextInfo.bExpanded : false;
						},
						expandContext: function(oContext) {
							var oContextInfo = this._getContextInfo(oContext);
							if (oContextInfo && !oContextInfo.bExpanded) {
								this.storeSelection();
								this._loadChildContexts(oContext);
								oContextInfo.bExpanded = true;
								this._fireChange();
								this.restoreSelection();
							}
						},
						expand: function (iRowIndex) {
							this.expandContext(this.getContextByIndex(iRowIndex));
						},
						collapseContext: function(oContext, bSupressChanges) {
							var oContextInfo = this._getContextInfo(oContext);
							if (oContextInfo && oContextInfo.bExpanded) {
								this.storeSelection();
								for (var i = this.aContexts.length - 1; i > 0; i--) {
									if (this._getContextInfo(this.aContexts[i]).oParentContext === oContext) {
										this.aContexts.splice(i, 1);
									}
								}
								oContextInfo.bExpanded = false;
								if (!bSupressChanges) {
									this._fireChange();
								}
								this.restoreSelection();
							}
						},
						collapse: function (iRowIndex) {
							this.collapseContext(this.getContextByIndex(iRowIndex));
						},
						collapseToLevel: function (iLevel) {
							if (!iLevel || iLevel < 0) {
								iLevel = 0;
							}

							var aContextsCopy = this.aContexts.slice();
							for (var i = aContextsCopy.length - 1; i >= 0; i--) {
								var iContextLevel = this.getLevel(aContextsCopy[i]);
								if (iContextLevel != -1 && iContextLevel >= iLevel) {
									this.collapseContext(aContextsCopy[i], true);
								}
							}

							this._fireChange();
						},
						toggleContext: function(oContext) {
							var oContextInfo = this._getContextInfo(oContext);
							if (oContextInfo) {
								if (oContextInfo.bExpanded) {
									this.collapseContext(oContext);
								} else {
									this.expandContext(oContext);
								}
							}
						},
						toggleIndex: function (iRowIndex) {
							this.toggleContext(this.getContextByIndex(iRowIndex));
						},
						storeSelection: function() {
							var aSelectedIndices = that.getSelectedIndices();
							var aSelectedContexts = [];
							jQuery.each(aSelectedIndices, function(iIndex, iValue) {
								aSelectedContexts.push(that.getContextByIndex(iValue));
							});
							this._aSelectedContexts = aSelectedContexts;
						},
						restoreSelection: function() {
							that.clearSelection();
							var _aSelectedContexts = this._aSelectedContexts;
							jQuery.each(this.aContexts, function(iIndex, oContext) {
								if (jQuery.inArray(oContext, _aSelectedContexts) >= 0) {
									that.addSelectionInterval(iIndex, iIndex);
								}
							});
							this._aSelectedContexts = undefined;
						},
						attachSelectionChanged: function() {
							// for compatibility reasons (OData Tree Binding)
							return undefined;
						},
						clearSelection: function () {
							that._oSelection.clearSelection();
						},
						attachSort: function() {},
						detachSort: function() {}
					});
					// initialize the binding
					oBinding._init(this.getExpandFirstLevel());

				} else {
					//Use the ODataTreeBindingAdapter to enhance the TreeBinding with a ListBinding API
					ODataTreeBindingAdapter.apply(oBinding);
				}
			}

			return oBinding;
		};


		/**
		 * @private
		 */
		DataTable.prototype.resetGrouping = function() {

			// reset the group binding only when enhanced
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding._modified) {

				// we remove the style override to display the row header
				this.$().find(".sapUiTableRowHdrScr").css("display", "");

				// if the grouping is not supported we remove the hacks we did
				// and simply return the binding finally
				this.onclick = DataTable.prototype.onclick;
				this._modifyRow = undefined;

				// reset the binding
				var oBindingInfo = this.getBindingInfo("rows");
				this.unbindRows();
				this.bindRows(oBindingInfo);

			}

		};

		/**
		 * @private
		 */
		DataTable.prototype.setEnableGrouping = function(bEnableGrouping) {
			// set the property
			this.setProperty("enableGrouping", bEnableGrouping);
			// reset the grouping
			if (!bEnableGrouping) {
				this.resetGrouping();
			}
			// update the column headers
			this._invalidateColumnMenus();
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setEnableCustomFilter = function(bEnableCustomFilter) {
			this.setProperty("enableCustomFilter", bEnableCustomFilter);
			// update the column headers
			this._invalidateColumnMenus();
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setEnableColumnFreeze = function(bEnableColumnFreeze) {
			this.setProperty("enableColumnFreeze", bEnableColumnFreeze);
			this._invalidateColumnMenus();
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setShowColumnVisibilityMenu = function(bShowColumnVisibilityMenu) {
			this.setProperty("showColumnVisibilityMenu", bShowColumnVisibilityMenu);
			this._invalidateColumnMenus();
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setFixedColumnCount = function(iFixedColumnCount) {
			var aCols = this._getVisibleColumns();
			var vHeaderSpan = aCols[iFixedColumnCount - 1] && aCols[iFixedColumnCount - 1].getHeaderSpan();
			if (vHeaderSpan) {
				var iHeaderSpan;
				if (jQuery.isArray(vHeaderSpan)) {
					iHeaderSpan = parseInt(vHeaderSpan[0], 10);
				} else {
					iHeaderSpan = parseInt(vHeaderSpan, 10);
				}
				iFixedColumnCount += iHeaderSpan - 1;
			}
			//Set current width as fixed width for cols
			var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
			for (var i = 0; i < iFixedColumnCount; i++) {
				var oColumn = aCols[i];
				if (oColumn) {
					var iColumnIndex = jQuery.inArray(oColumn, this.getColumns());
					if (!oColumn.getWidth()) {
						oColumn.setWidth($ths.filter("[data-sap-ui-headcolindex='" + iColumnIndex + "']").width() + "px");
					}
				}
			}
			this.setProperty("fixedColumnCount", iFixedColumnCount);
			this._invalidateColumnMenus();
			return this;
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._invalidateColumnMenus = function() {
			var aCols = this.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].getMenu()) {
					aCols[i].getMenu()._bInvalidated = true;
				}
			}
		};

		/**
		 * The selectstart event triggered in IE to select the text.
		 * @private
		 * @param {event} oEvent The splitterselectstart event
		 * @return {boolean} false
		 */
		DataTable.prototype._splitterSelectStart = function(oEvent){
			oEvent.preventDefault();
			oEvent.stopPropagation();
			return false;
		};

		/**
		 * Checks whether the passed oEvent is a touch event.
		 * @private
		 * @param {event} oEvent The event to check
		 * @return {boolean} false
		 */
		DataTable.prototype._isTouchMode = function(oEvent) {
			return !!oEvent.originalEvent["touches"];
		};

		/**
		 * drops the splitter bar
		 * @private
		 */
		DataTable.prototype._onGhostMouseRelease = function(oEvent) {
			var splitterBarGhost = this.getDomRef("ghost");

			var iLocationY = this._isTouchMode(oEvent) ? oEvent.changedTouches[0].pageY : oEvent.pageY;
			var iNewHeight = iLocationY - this.$().offset().top;

			this.setVisibleRowCount(this._calculateRowsToDisplay(iNewHeight));

			jQuery(splitterBarGhost).remove();
			this.$("overlay").remove();

			jQuery(document.body).unbind("selectstart", this._splitterSelectStart);

			var $Document = jQuery(document);
			$Document.unbind("touchend", this._onGhostMouseRelease);
			$Document.unbind("touchmove", this._onGhostMouseMove);
			$Document.unbind("mouseup", this._onGhostMouseRelease);
			$Document.unbind("mousemove", this._onGhostMouseMove);

			this._enableTextSelection();
		};

		/**
		 *
		 * @param oEvent
		 * @private
		 */
		DataTable.prototype._onGhostMouseMove = function(oEvent) {
			var splitterBarGhost = this.getDomRef("ghost");

			var iLocationY = this._isTouchMode(oEvent) ? oEvent.targetTouches[0].pageY : oEvent.pageY;
			var min = this.$().offset().top;
			if (iLocationY > min) {
				jQuery(splitterBarGhost).css("top", iLocationY + "px");
			}
		};

		/**
		 * Calculates the maximum rows to display within the DataTable.
		 * @private
		 */
		DataTable.prototype._calculateRowsToDisplay = function(iHeight) {
			var iMinRowCount = this.getMinAutoRowCount() || 5;

			// If no iHeight is passed, return minimum row count.
			if (!iHeight) {
				return iMinRowCount;
			}

			var $this = this.$();
			if (!$this.get(0)) {
				return;
			}

			// usage of getBoundingClientRect() for retrieving subpixel correct value of the height. Necessary for zooming/flickering bugs in Chrome
			var iControlHeight = $this.get(0).getBoundingClientRect().height;
			var iContentHeight = $this.find('.sapUiTableCCnt').outerHeight();

			// Determine default row height.
			var iRowHeight = $this.find("tr:not(.sapUiAnalyticalTableSum) > td").outerHeight();

			// No rows displayed when visible row count == 0, no row height can be determined, therefore we set standard row height
			if (!iRowHeight) {
				var sRowHeightParamName = "sap.ui.table.Table:sapUiTableRowHeight";
				if ($this.parents().hasClass('sapUiSizeCompact')) {
					sRowHeightParamName = "sap.ui.table.Table:sapUiTableCompactRowHeight";
				}
				iRowHeight = parseInt(Parameters.get(sRowHeightParamName), 10);
			}

			// Maximum height of the table is the height of the window minus two row height, reserved for header and footer.
			var iMaxHeight = window.innerHeight - 2 * iRowHeight;
			var iCalculatedSpace = iHeight - (iControlHeight - iContentHeight);

			// Make sure that table does not grow to infinity
			var iAvailableSpace = Math.min(iCalculatedSpace, iMaxHeight);

			// the last content row height is iRowHeight - 1, therefore + 1 in the formula below:
			return Math.max(iMinRowCount, Math.floor((iAvailableSpace + 1) / iRowHeight));
		};


		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setShowNoData = function(bShowNoData) {
			this.setProperty('showNoData', bShowNoData, true);
			bShowNoData = this.getProperty('showNoData');
			if (!bShowNoData) {
				this.$().removeClass("sapUiTableEmpty");
			} else {
				this._updateNoData();
			}
			return this;
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setNoDataText = function(sText) {
			this.setProperty("noDataText", sText, true);
			this.$().find('.sapUiTableCtrlEmptyMsg').text(sText);
		};

		/**
		 * Creates a new {@link sap.ui.core.util.Export} object and fills row/column information from the table if not provided. For the cell content, the column's "sortProperty" will be used (experimental!)
		 *
		 * <p><b>Please note: The return value was changed from jQuery Promises to standard ES6 Promises.
		 * jQuery specific Promise methods ('done', 'fail', 'always', 'pipe' and 'state') are still available but should not be used.
		 * Please use only the standard methods 'then' and 'catch'!</b></p>
		 *
		 * @param {object} [mSettings] settings for the new Export, see {@link sap.ui.core.util.Export} <code>constructor</code>
		 * @return {Promise} Promise object
		 *
		 * @experimental Experimental because the property for the column/cell definitions (sortProperty) could change in future.
		 * @public
		 */
		DataTable.prototype.exportData = function(mSettings) {
			jQuery.sap.require("sap.ui.core.util.Export");

			mSettings = mSettings || {};

			if (!mSettings.rows) {
				var oBinding = this.getBinding("rows"),
					oBindingInfo = this.getBindingInfo("rows");

				var aFilters = oBinding.aFilters.concat(oBinding.aApplicationFilters);

				mSettings.rows = {
					path: oBindingInfo.path,
					model: oBindingInfo.model,
					sorter: oBinding.aSorters,
					filters: aFilters,
					parameters: oBindingInfo.parameters
				};
			}

			// by default we choose the export type CSV
			if (!mSettings.exportType) {
				jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");
				mSettings.exportType = new sap.ui.core.util.ExportTypeCSV();
			}

			var sModelName = mSettings.rows.model;
			if (!sModelName) {
				// if a model separator is found in the path, extract model name from there
				var sPath = mSettings.rows.path;
				var iSeparatorPos = sPath.indexOf(">");
				if (iSeparatorPos > 0) {
					sModelName = sPath.substr(0, iSeparatorPos);
				}
			}

			if (!mSettings.columns) {
				mSettings.columns = [];

				var aColumns = this.getColumns();
				for (var i = 0, l = aColumns.length; i < l; i++) {
					var oColumn = aColumns[i];
					if (oColumn.getSortProperty()) {
						mSettings.columns.push({
							name: oColumn.getLabel().getText(),
							template: {
								content: {
									path: oColumn.getSortProperty(),
									model: sModelName
								}
							}
						});
					}
				}
			}

			var oExport = new sap.ui.core.util.Export(mSettings);
			this.addDependent(oExport);

			return oExport;
		};

		/**
		 * internal function to calculate the widest content width of the column
		 * also takes the column header and potential icons into account
		 * @param {int} iColIndex index of the column which should be resized
		 * @return {int} minWidth minimum width the column needs to have
		 * @private
		 * @experimental Experimental, only works with a limited control set
		 * @function
		 */

		DataTable.prototype._calculateAutomaticColumnWidth = function(iColIndex) {

			var aTextBasedControls = [
				"sap.m.Text",
				"sap.m.Label",
				"sap.m.Link",
				"sap.ui.commons.TextView",
				"sap.ui.commons.Label",
				"sap.ui.commons.Link"
			];

			var $this = this.$();
			var iHeaderWidth = 0;

			var $cols = $this.find('td[headers=\"' + this.getId() + '_col' + iColIndex + '\"]').children("div");
			var oColumns = this.getColumns();
			var oCol = oColumns[iColIndex];
			if (!oCol) {
				return null;
			}
			var aHeaderSpan = oCol.getHeaderSpan();
			var oColLabel = oCol.getLabel();
			var that = this;

			var oColTemplate = oCol.getTemplate();
			var bIsTextBased = jQuery.inArray(oColTemplate.getMetadata().getName(), aTextBasedControls) != -1 ||
				sap.ui.commons && sap.ui.commons.TextField && oColTemplate instanceof sap.ui.commons.TextField ||
				sap.m && sap.m.Input && oColTemplate instanceof sap.m.Input;

			var hiddenSizeDetector = document.createElement("div");
			document.body.appendChild(hiddenSizeDetector);
			jQuery(hiddenSizeDetector).addClass("sapUiTableHiddenSizeDetector");

			var oColLabels = oCol.getMultiLabels();
			if (oColLabels.length == 0 && !!oColLabel){
				oColLabels = [oColLabel];
			}

			if (oColLabels.length > 0) {
				jQuery.each(oColLabels, function(iIdx, oLabel){
					var iHeaderSpan;
					if (!!oLabel.getText()){
						jQuery(hiddenSizeDetector).text(oLabel.getText());
						iHeaderWidth = hiddenSizeDetector.scrollWidth;
					} else {
						iHeaderWidth = oLabel.$().scrollWidth;
					}
					iHeaderWidth = iHeaderWidth + $this.find("#" + oCol.getId() + "-icons").first().width();

					$this.find(".sapUiTableColIcons#" + oCol.getId() + "_" + iIdx + "-icons").first().width();
					if (aHeaderSpan instanceof Array && aHeaderSpan[iIdx] > 1){
						iHeaderSpan = aHeaderSpan[iIdx];
					} else if (aHeaderSpan > 1){
						iHeaderSpan = aHeaderSpan;
					}
					if (!!iHeaderSpan){
						// we have a header span, so we need to distribute the width of this header label over more than one column
						//get the width of the other columns and subtract from the minwidth required from label side
						var i = iHeaderSpan - 1;
						while (i > iColIndex) {
							iHeaderWidth = iHeaderWidth - (that._oCalcColumnWidths[iColIndex + i] || 0);
							i -= 1;
						}
					}
				});
			}

			var minAddWidth = Math.max.apply(null, $cols.map(
				function(){
					var _$this = jQuery(this);
					return parseInt(_$this.css('padding-left'), 10) + parseInt(_$this.css('padding-right'), 10)
						+ parseInt(_$this.css('margin-left'), 10) + parseInt(_$this.css('margin-right'), 10);
				}).get());

			//get the max width of the currently displayed cells in this column
			var minWidth = Math.max.apply(null, $cols.children().map(
				function() {
					var width = 0,
						sWidth = 0;
					var _$this = jQuery(this);
					var sColText = _$this.text() || _$this.val();

					if (bIsTextBased){
						jQuery(hiddenSizeDetector).text(sColText);
						sWidth = hiddenSizeDetector.scrollWidth;
					} else {
						sWidth = this.scrollWidth;
					}
					if (iHeaderWidth > sWidth){
						sWidth = iHeaderWidth;
					}
					width = sWidth + parseInt(_$this.css('margin-left'), 10)
						+ parseInt(_$this.css('margin-right'), 10)
						+ minAddWidth
						+ 1; // ellipsis is still displayed if there is an equality of the div's width and the table column
					return width;
				}).get());

			jQuery(hiddenSizeDetector).remove();
			return Math.max(minWidth, this._iColMinWidth);
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._onPersoApplied = function() {

			// apply the sorter and filter again (right now only the first sorter is applied)
			var aColumns = this.getColumns();
			var aSorters = [];//, aFilters = [];
			for (var i = 0, l = aColumns.length; i < l; i++) {
				var oColumn = aColumns[i];
				if (oColumn.getSorted()) {
					aSorters.push(new sap.ui.model.Sorter(oColumn.getSortProperty(), oColumn.getSortOrder() === sap.ui.table.SortOrder.Descending));
					/*
					 } else if (oColumn.getFiltered()) {
					 aFilters.push(oColumn._getFilter());
					 */
				}
			}

			if (aSorters.length > 0 && this.getBinding("rows")) {
				this.getBinding("rows").sort(aSorters);
			}
			/*
			 if (aFilters.length > 0 && this.getBinding("rows")) {
			 this.getBinding("rows").filter(aFilters);
			 }
			 */

			this.refreshRows();

		};

		/**
		 * Toggles the selection state of all cells.
		 * @private
		 */
		DataTable.prototype._toggleSelectAll = function() {

			if (!this.$("selall").hasClass("sapUiTableSelAll")) {
				this.clearSelection();
			} else {
				this.selectAll();
			}
			if (!!sap.ui.Device.browser.internet_explorer) {
				this.$("selall").focus();
			}
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._restoreAppDefaultsColumnHeaderSortFilter = function () {
			var aColumns = this.getColumns();
			jQuery.each(aColumns, function(iIndex, oColumn){
				oColumn._restoreAppDefaults();
			});
		};

		/**
		 *
		 * @param mParameters
		 * @private
		 */
		DataTable.prototype._setBusy = function (mParameters) {
			var oBinding,
				i,
				bSetBusy;

			if (!this.getEnableBusyIndicator() || !this._bBusyIndicatorAllowed) {
				return;
			}

			oBinding = this.getBinding("rows");
			if (!oBinding) {
				return;
			}

			this.setBusy(false);
			if (mParameters) {
				if (mParameters.contexts && mParameters.contexts.length !== undefined) {
					// TreeBinding and AnalyticalBinding always return a contexts array with the
					// requested length. Both put undefined in it for contexts which need to be loaded
					// Check for undefined in the contexts array.
					bSetBusy = false;
					for (i = 0; i < mParameters.contexts.length; i++) {
						if (mParameters.contexts[i] === undefined) {
							bSetBusy = true;
							break;
						}
					}
				} else if (mParameters.changeReason === sap.ui.model.ChangeReason.Expand) {
					this.setBusy(true);
				}

				if (bSetBusy || (oBinding.isInitial() || oBinding._bInitial) || (mParameters.receivedLength === 0 && this._iDataRequestedCounter !== 0) ||
					(mParameters.receivedLength < mParameters.requestedLength && mParameters.receivedLength !== oBinding.getLength())) {
					this.setBusy(true);
				}
			}
		};

		/*
		 * @see JSDoc generated by SAPUI5 control API generator
		 */
		DataTable.prototype.setColumnHeaderVisible = function(bColumnHeaderVisible) {
			this.setProperty("columnHeaderVisible", bColumnHeaderVisible);
			// Adapt the item navigation. Since the HeaderRowCount changed, also the lastSelectedDataRow changes.
			this._iLastSelectedDataRow = this._getHeaderRowCount();

		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._attachDataRequestedListeners = function () {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				this._iDataRequestedCounter = 0;
				oBinding.detachDataRequested(this._onBindingDataRequestedListener, this);
				oBinding.detachDataReceived(this._onBindingDataReceivedListener, this);

				oBinding.attachDataRequested(this._onBindingDataRequestedListener, this);
				oBinding.attachDataReceived(this._onBindingDataReceivedListener, this);
			}
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._onBindingDataRequestedListener = function () {
			this._iDataRequestedCounter++;
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._onBindingDataReceivedListener = function () {
			this._iDataRequestedCounter--;
		};

		/**
		 *
		 * @private
		 */
		DataTable.prototype._attachBindingListener = function() {
			this._attachDataRequestedListeners();
		};

		/**
		 * Sets the node hierarchy to collapse recursive. When set to true, all child nodes will get collapsed as well.
		 * This setting has only effect when the binding is already initialized.
		 * @param {boolean} bCollapseRecursive
		 */
		DataTable.prototype.setCollapseRecursive = function(bCollapseRecursive) {
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				jQuery.sap.assert(oBinding.setCollapseRecursive, "Collapse Recursive is not supported by the used binding");
				if (oBinding.setCollapseRecursive) {
					oBinding.setCollapseRecursive(bCollapseRecursive);
				}
			}
			this.setProperty("collapseRecursive", !!bCollapseRecursive, true);
			return this;
		};

		/**
		 * Set the rootLevel for the hierarchy
		 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
		 * This setting has only effect when the binding is already initialized.
		 * @param {int} iRootLevel
		 * @returns {TreeTable}
		 */
		DataTable.prototype.setRootLevel = function(iRootLevel) {
			this.setFirstVisibleRow(0);

			var oBinding = this.getBinding("rows");
			if (oBinding) {
				jQuery.sap.assert(oBinding.setRootLevel, "rootLevel is not supported by the used binding");
				if (oBinding.setRootLevel) {
					oBinding.setRootLevel(iRootLevel);
				}
			}
			this.setProperty("rootLevel", iRootLevel, true);

			return this;
		};

		return DataTable;

	}, /* bExport= */ true);

}; // end of sap/ui/table/DataTable.js
