/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Text','./Button','sap/ui/core/InvisibleText','./Image','./OverflowToolbar','./ToolbarSpacer','sap/ui/core/Icon'],function(q,l,C,L,T,B,I,a,O,b,c){'use strict';var N=L.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},description:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance'},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false},truncate:{type:'boolean',group:'Appearance',defaultValue:true}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"}},events:{close:{}}}});N.prototype.init=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this.setType('Active');this._closeButton=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),press:function(){this.close();}.bind(this)});this._collapseButton=new sap.m.Button({type:sap.m.ButtonType.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);this._collapseButton.setText(this.getTruncate()?this._expandText:this._collapseText);this.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.toggle('sapMNLI-TextWrapper--is-expanded');this.getDomRef().querySelector('.sapMNLI-Header').classList.toggle('sapMNLI-TitleWrapper--is-expanded');this._registerResize();}.bind(this)});this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();this.setAggregation('_overflowToolbar',new O());};N.prototype.onBeforeRendering=function(){this._deregisterResize();};N.prototype.onAfterRendering=function(){this._showHideTruncateButton();this._registerResize();};N.prototype.setTitle=function(t){var r=this.setProperty('title',t,true);this._getHeaderTitle().setText(t);return r;};N.prototype.setDescription=function(d){var r=this.setProperty('description',d,true);this._getDescriptionText().setText(d);return r;};N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d,true);this._getDateTimeText().setText(d);this._updateAriaAdditionalInfo();return r;};N.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation("_headerTitle");if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};N.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};N.prototype.setAuthorName=function(d){var r=this.setProperty('authorName',d,true);this._getAuthorName().setText(d);return r;};N.prototype.setAuthorPicture=function(d,s){var r=this.setProperty('authorPicture',d,s);this._getAuthorImage().setSrc(d);return r;};N.prototype.bindAggregation=function(d,e){if(d=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',e);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,d,e);}};N.prototype.validateAggregation=function(d,o,m){if(d=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,d,o,m);}};N.prototype.setAggregation=function(d,o,s){if(d=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,d,o,s);}};N.prototype.getAggregation=function(d,e){if(d=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(f){return f instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,d,e);}};N.prototype.indexOfAggregation=function(d,o){if(d=='buttons'){this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);return this;}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,d,o);}};N.prototype.insertAggregation=function(d,o,e,s){if(d=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,e,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,e,s);}};N.prototype.addAggregation=function(d,o,s){if(d=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,d,o,s);}};N.prototype.removeAggregation=function(d,o,s){if(d=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,d,o,s);}};N.prototype.removeAllAggregation=function(d,s){if(d=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,d,s);}};N.prototype.destroyAggregation=function(d,s){if(d=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,d,s);}};N.prototype.getBinding=function(d){if(d=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,d);}};N.prototype.getBindingInfo=function(d){if(d=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,d);}};N.prototype.getBindingPath=function(d){if(d=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,d);}};N.prototype.clone=function(){var d=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');d.setAggregation("_overflowToolbar",o.clone(),true);return d;};N.prototype.close=function(){var p=this.getParent();this.fireClose();p&&p instanceof sap.ui.core.Element&&p.focus();this.destroy();};N.prototype.exit=function(){this._deregisterResize();if(this._closeButton){this._closeButton.destroy();this._closeButton=null;}if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};N.prototype._getDescriptionText=function(){var d=this.getAggregation('_bodyText');if(!d){d=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",d,true);}return d;};N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new sap.m.Text({text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};N.prototype._getAuthorName=function(){var d=this.getAggregation('_authorName');if(!d){d=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',d,true);}return d;};N.prototype._getAuthorImage=function(){var d=this.getAggregation('_authorImage');if(!d){var e=this.getAuthorPicture();var f=this.getAuthorName();if(i(e)){d=new c({src:e,alt:f});}else{d=new a({src:e,alt:f});}this.setAggregation('_authorImage',d,true);}return d;};N.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};N.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var d=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var e=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);this._ariaDetailsText.setText(d+' '+e);};N.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var d=this.getDomRef('title').parentElement.offsetHeight;var e=this.getDomRef("body").offsetHeight;var f=this.getDomRef("body").parentElement.offsetHeight;return e>f||t>d;};N.prototype._showHideTruncateButton=function(){var n=this.getDomRef();if(this._canTruncate()){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this._collapseButton.setText(this._expandText);n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');}else{this._collapseButton.setText(this._collapseText);n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');};N.prototype._deregisterResize=function(){if(this._sPopupResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}};N.prototype._registerResize=function(){var t=this;this._sPopupResizeHandler=sap.ui.core.ResizeHandler.register(this.getDomRef(),function(){t.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');t.getDomRef().querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');t.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');t.getDomRef().querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');t._showHideTruncateButton();});};function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}return N;},true);
