/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,U,l){"use strict";var b=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}}}}});b.prototype.init=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);};b.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};b.prototype.onBeforeRendering=function(){d.call(this);f.call(this);n.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};b.prototype.onAfterRendering=function(){o.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}};b.prototype.setStartDate=function(S){if(!S){S=new Date();}if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var y=S.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("startDate",S);return this;};b.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};b.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};b.prototype.onfocusin=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){t.call(this,E.target.id);}else{var V=this._getVisibleAppointments();var F=false;var A;for(var i=0;i<V.length;i++){A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){F=true;A.focus();break;}}if(!F){A=this.getFocusedAppointment();if(A){A.focus();}}}};b.prototype.applyFocusInfo=function(F){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};b.prototype.onsapleft=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){u.call(this,this._bRTL,1);}E.preventDefault();E.stopPropagation();};b.prototype.onsapright=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){u.call(this,!this._bRTL,1);}E.preventDefault();E.stopPropagation();};b.prototype.onsapup=function(E){this.fireLeaveRow({type:E.type});};b.prototype.onsapdown=function(E){this.fireLeaveRow({type:E.type});};b.prototype.onsaphome=function(E){v.call(this,E);E.preventDefault();E.stopPropagation();};b.prototype.onsapend=function(E){v.call(this,E);E.preventDefault();E.stopPropagation();};b.prototype.onsapselect=function(E){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){p.call(this,A,!E.ctrlKey);break;}}E.stopPropagation();E.preventDefault();};b.prototype.onclick=function(E){this.onsapselect(E);};b.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};b.prototype.handleResize=function(E){if(E&&E.size&&E.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");o.call(this);return this;};b.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var I=this.getIntervals();var j=this.getIntervalType();var S=this._getStartDate();var k=S.getTime();var E=this._oUTCEndDate;var w=E.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=w&&i.getTime()>=k){var B=h.call(this,j,I,S,E,k,i);var T=0;if(this._bRTL){N.css("right",B+"%");}else{N.css("left",B+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(j){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;break;case sap.ui.unified.CalendarIntervalType.Day:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};b.prototype.getFocusedAppointment=function(){var A=r.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==this._sFocusedAppointmentId){j=G[i];break;}}if(!j){for(i=0;i<A.length;i++){if(A[i].getId()==this._sFocusedAppointmentId){j=A[i];break;}}}return j;};b.prototype.focusAppointment=function(A){if(!A||!(A instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var i=A.getId();if(this._sFocusedAppointmentId!=i){t.call(this,i);}else{A.focus();}return this;};b.prototype.focusNearestAppointment=function(j){if(!j||!(j instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var A=r.call(this);var N;var P;var k;for(var i=0;i<A.length;i++){N=A[i];if(N.getStartDate()>j){if(i>0){P=A[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){k=P;}else{k=N;}this.focusAppointment(k);}return this;};b.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};b.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};b.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=c.call(this);var w=j.getWeekendStart();var W=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((w<=W&&i>=w&&i<=W)||(w>W&&(i>=w||i<=W))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function c(){if(!this._oLocaleData){var i=_.call(this);var j=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function d(){var S=this.getStartDate();var E;var i=this.getIntervals();var I=this.getIntervalType();this._oUTCStartDate=e.call(this,S);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:E=new U(this._oUTCStartDate.getTime());E.setUTCHours(E.getUTCHours()+i);this._iMinDelta=this._iHoursMinDelta;break;case sap.ui.unified.CalendarIntervalType.Day:E=new U(this._oUTCStartDate.getTime());E.setUTCDate(E.getUTCDate()+i);this._iMinDelta=this._iDaysMinDelta;break;case sap.ui.unified.CalendarIntervalType.Month:E=new U(this._oUTCStartDate.getTime());E.setUTCMonth(E.getUTCMonth()+i);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}E.setUTCMilliseconds(-1);this._iRowSize=E.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=E;}function e(i){var I=this.getIntervalType();var j=a._createUniversalUTCDate(i,undefined,true);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Day:j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCDate(1);j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}return j;}function f(){var O=this._aVisibleAppointments||[];var A=r.call(this);var w;var G;var x;var I=this.getIntervals();var y=this.getIntervalType();var S=this._getStartDate();var z=S.getTime();var E=this._oUTCEndDate;var B=E.getTime();var V=[];var F=false;var i=0;var j=0;this.destroyAggregation("groupAppointments",true);for(i=0;i<A.length;i++){w=A[i];var H=a._createUniversalUTCDate(w.getStartDate(),undefined,true);H.setUTCSeconds(0);H.setUTCMilliseconds(0);var J=a._createUniversalUTCDate(w.getEndDate(),undefined,true);J.setUTCSeconds(0);J.setUTCMilliseconds(0);var K=false;if(H.getTime()<z&&J.getTime()>=z){H=new U(z);K=true;}if(J.getTime()>B&&H.getTime()<=B){J=new U(B);K=true;}var M=H.getUTCHours()*60+H.getUTCMinutes();H.setUTCMinutes(H.getUTCMinutes()-(M%this._iMinDelta));var N=(J.getTime()-H.getTime())/60000;if(K&&N==0){continue;}var P=0;var Q=0;var R=-1;G=undefined;x=undefined;if(H&&H.getTime()<=B&&J&&J.getTime()>=z){if(y==sap.ui.unified.CalendarIntervalType.Month&&J.getTime()-H.getTime()<604800000){G=g.call(this,H,w,y,I,S,E,z,V);var T=a._createUniversalUTCDate(G.getEndDate(),undefined,true);if(J.getTime()>T.getTime()){x=g.call(this,J,w,y,I,S,E,z,V);}}P=h.call(this,y,I,S,E,z,H);Q=m.call(this,y,I,S,E,z,J);for(j=0;j<O.length;j++){var W=O[j];if(w==W.appointment){R=W.level;}}if(G){G._iBegin=P;G._iEnd=Q;G._iLevel=R;if(x){x._iBegin=P;x._iEnd=Q;x._iLevel=R;}continue;}V.push({appointment:w,begin:P,end:Q,calculatedEnd:Q,level:R});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==w.getId()){F=true;}}}var X=this.getAggregation("groupAppointments",[]);if(X.length>0){for(i=0;i<V.length;i++){w=V[i];if(w.appointment._aAppointments&&w.appointment._aAppointments.length==1){G=w.appointment;var Y=false;for(j=0;j<V.length;j++){if(V[j].appointment==G._aAppointments[0]){Y=true;break;}}if(!Y){for(j=0;j<X.length;j++){x=X[j];if(G!=x){for(var k=0;k<x._aAppointments.length;k++){if(G._aAppointments[0]==x._aAppointments[k]){x._aAppointments.splice(k,1);x.setProperty("title",x._aAppointments.length,true);break;}}}}w.begin=G._iBegin;w.end=G._iEnd;w.calculatedEnd=G._iEnd;w.level=G._iLevel;w.appointment=G._aAppointments[0];}else{V.splice(i,1);i--;}G.destroy();}}}if(!F){if(V.length>0){this._sFocusedAppointmentId=V[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=V;return this._aVisibleAppointments;}function g(i,A,I,k,S,E,w,V){var G=this.getAggregation("groupAppointments",[]);var x;var y=c.call(this);var F=y.getFirstDayOfWeek();var z=i.getDay();var B=new U(i.getTime());B.setUTCHours(0);B.setUTCMinutes(0);B.setUTCSeconds(0);B.setUTCMilliseconds(0);if(F<=z){B.setDate(B.getDate()-(z-F));}else{B.setDate(B.getDate()-(7-z-F));}for(var j=0;j<G.length;j++){x=G[j];var H=a._createUniversalUTCDate(x.getStartDate(),undefined,true);if(H.getTime()==B.getTime()){break;}x=undefined;}if(!x){var J=new U(B.getTime());J.setDate(J.getDate()+7);J.setMilliseconds(-1);x=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+G.length,{type:A.getType(),startDate:a._createLocalDate(new Date(B.getTime()),true),endDate:a._createLocalDate(new Date(J.getTime()),true)});x._aAppointments=[];this.addAggregation("groupAppointments",x,true);var K=h.call(this,I,k,S,E,w,B);var M=m.call(this,I,k,S,E,w,J);V.push({appointment:x,begin:K,end:M,calculatedEnd:M,level:-1});}x._aAppointments.push(A);if(x.getType()!=sap.ui.unified.CalendarDayType.None&&x.getType()!=A.getType()){x.setType(sap.ui.unified.CalendarDayType.None);}x.setProperty("title",x._aAppointments.length,true);return x;}function h(i,I,S,E,j,A){var B=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){B=100*(A.getTime()-j)/this._iRowSize;}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var k=new U(M.getTime());k.setUTCMonth(k.getUTCMonth()+1);k.setMilliseconds(-1);var w=k.getTime()-M.getTime();var x=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();B=(100*x/I)+(100*(A.getTime()-M.getTime())/w)/I;}if(B<0){B=0;}B=Math.round(B*100000)/100000;return B;}function m(i,I,S,E,j,A){var k=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){k=100-(100*(A.getTime()-j)/this._iRowSize);}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var w=new U(M.getTime());w.setUTCMonth(w.getUTCMonth()+1);w.setMilliseconds(-1);var x=w.getTime()-M.getTime();var y=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();k=100-((100*y/I)+(100*(A.getTime()-M.getTime())/x)/I);}if(k<0){k=0;}k=Math.round(k*100000)/100000;return k;}function n(){var V=[];if(this.getShowIntervalHeaders()){var A=this.getIntervalHeaders();var k;var I=this.getIntervals();var w=this.getIntervalType();var S=this._getStartDate();var x=S.getTime();var E=this._oUTCEndDate;var y=E.getTime();var i=0;var j=0;for(i=0;i<A.length;i++){k=A[i];var z=a._createUniversalUTCDate(k.getStartDate(),undefined,true);z.setUTCSeconds(0);z.setUTCMilliseconds(0);var B=a._createUniversalUTCDate(k.getEndDate(),undefined,true);B.setUTCSeconds(0);B.setUTCMilliseconds(0);if(z&&z.getTime()<=y&&B&&B.getTime()>=x){var F=new U(S.getTime());var G=new U(S.getTime());G.setUTCMinutes(G.getUTCMinutes()-1);var H=-1;for(j=0;j<I;j++){switch(w){case sap.ui.unified.CalendarIntervalType.Hour:G.setUTCHours(G.getUTCHours()+1);if(j>0){F.setUTCHours(F.getUTCHours()+1);}break;case sap.ui.unified.CalendarIntervalType.Day:G.setUTCDate(G.getUTCDate()+1);if(j>0){F.setUTCDate(F.getUTCDate()+1);}break;case sap.ui.unified.CalendarIntervalType.Month:G.setUTCDate(1);G.setUTCMonth(G.getUTCMonth()+2);G.setUTCDate(0);if(j>0){F.setUTCMonth(F.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+w+"; "+this);}if(z&&z.getTime()<=F.getTime()&&B&&B.getTime()>=G.getTime()){if(H<0){H=j;}V.push({interval:j,appointment:k,first:H==j});}}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function o(){var A=this.$("Apps");var R=A.innerWidth();if(R<=0){return;}var $=this.$("DummyApp");var H=$.outerHeight(true);var M=$.outerWidth();var k=M/R*100;var w=Math.ceil(1000*k)/1000;var x;var y;var S=0;var z=0;var i=0;if(this.getShowIntervalHeaders()){S=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){x=this._aVisibleAppointments[i];y=x.appointment.$();var P=Math.floor(1000*(100-x.calculatedEnd-x.begin))/1000;var B=false;if(P<w){x.end=100-x.begin-k;if(x.end<0){x.end=0;}x.level=-1;B=true;y.addClass("sapUiCalendarAppSmall");}else if(y.hasClass("sapUiCalendarAppSmall")){x.end=x.calculatedEnd;B=true;y.removeClass("sapUiCalendarAppSmall");}if(B){if(this._bRTL){y.css("left",x.end+"%");}else{y.css("right",x.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){x=this._aVisibleAppointments[i];y=x.appointment.$();var E={};if(x.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var V=this._aVisibleAppointments[j];if(x!=V&&x.begin<100-V.end&&100-x.end>V.begin&&V.level>=0){if(E[V.level]){E[V.level]++;}else{E[V.level]=1;}}}x.level=0;while(E[x.level]){x.level++;}y.attr("data-sap-level",x.level);}y.css("top",(H*x.level+S)+"px");if(z<x.level){z=x.level;}}z++;H=H*z+S;if(!this.getHeight()){A.outerHeight(H);}else{var I=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<I.length;i++){var F=q(I[i]);F.outerHeight(H);}}$.css("display","none");}function p(A,R){var i=0;var O;if(R){var j=this.getAppointments();var G=this.getAggregation("groupAppointments",[]);q.merge(j,G);for(i=0;i<j.length;i++){O=j[i];if(O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");}}}A.setProperty("selected",true,true);A.$().addClass("sapUiCalendarAppSel");if(A._aAppointments){for(i=0;i<A._aAppointments.length;i++){O=A._aAppointments[i];O.setProperty("selected",true,true);}this.fireSelect({appointments:A._aAppointments,multiSelect:!R});}else{this.fireSelect({appointment:A,multiSelect:!R});}}function r(){var A=this.getAppointments();A.sort(function(i,j){return i.getStartDate()-j.getStartDate();});return A;}function s(I){var G=this.getAggregation("groupAppointments",[]);var k;var F=false;for(var i=0;i<G.length;i++){var w=G[i]._aAppointments;for(var j=0;j<w.length;j++){if(w[j].getId()==I){k=G[i];F=true;break;}}if(F){break;}}return k;}function t(I){if(this._sFocusedAppointmentId!=I){var A=r.call(this);var V=this._aVisibleAppointments;var j;var i=0;j=s.call(this,I);if(j){I=j.getId();j=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==I){j=V[i].appointment;break;}}if(j){var O=this.getFocusedAppointment().$();var $=j.$();this._sFocusedAppointmentId=j.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<A.length;i++){if(A[i].getId()==I){j=A[i];break;}}if(j){this._sFocusedAppointmentId=j.getId();var k=e.call(this,j.getStartDate());this.setStartDate(a._createLocalDate(k,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}function u(F,S){var I=this._sFocusedAppointmentId;var A=r.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var k=0;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==I){var w=G[i]._aAppointments;if(F){I=w[w.length-1].getId();}else{I=w[0].getId();}break;}}for(i=0;i<A.length;i++){if(A[i].getId()==I){k=i;break;}}if(F){k=k+S;}else{k=k-S;}if(k<0){k=0;}else if(k>=A.length){k=A.length-1;}j=A[k];t.call(this,j.getId());}function v(E){var A=r.call(this);var j;var S=new U(this._getStartDate());var k=new U(this._oUTCEndDate);var I=this.getIntervalType();var w;var G;S.setUTCHours(0);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:k.setUTCDate(k.getUTCDate()+1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Day:S.setUTCDate(1);k.setUTCMonth(k.getUTCMonth()+1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Month:S.setUTCMonth(0);S.setUTCDate(1);k.setUTCFullYear(k.getUTCFullYear()+1);k.setUTCMonth(1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var x=a._createLocalDate(S,true);var y=a._createLocalDate(k,true);for(var i=0;i<A.length;i++){if(A[i].getStartDate()>=x&&A[i].getStartDate()<=y){j=A[i];w=j.getId();if(E.type=="saphome"){break;}}else if(A[i].getStartDate()>y){break;}}G=s.call(this,w);if(G){j=G;w=j.getId();}if(w&&w!=this._sFocusedAppointmentId){t.call(this,w);}else if(E._bPlanningCalendar&&j){j.focus();}else{this.fireLeaveRow({type:E.type});}}return b;},true);
