/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,T,b,M,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{},startDateChange:{}}}});c.prototype.init=function(){this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59)));var K=new H(this.getId()+"--Head",{visibleButton0:true,visibleButton1:true,visibleButton2:true});K.attachEvent("pressPrevious",this._handlePrevious,this);K.attachEvent("pressNext",this._handleNext,this);K.attachEvent("pressButton0",t,this);K.attachEvent("pressButton1",u,this);K.attachEvent("pressButton2",v,this);this.setAggregation("header",K);var N=new T(this.getId()+"--TimesRow");N.attachEvent("focus",x,this);N.attachEvent("select",w,this);N._bNoThemeChange=true;this.setAggregation("timesRow",N);var O=new M(this.getId()+"--MP",{columns:0,months:6});O.attachEvent("select",A,this);O._bNoThemeChange=true;this.setAggregation("monthPicker",O);var P=new Y(this.getId()+"--YP",{columns:0,years:6});P.attachEvent("select",B,this);this.setAggregation("yearPicker",P);this.setPickerPopup(false);this._iItemsHead=15;};c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};c.prototype.onBeforeRendering=function(){var K=this.getAggregation("timesRow");var N=this._getFocusedDate();n.call(this);K.setDate(a._createLocalDate(N,true));};c.prototype.setStartDate=function(S){if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getStartDate(),S)){return this;}var K=S.getFullYear();if(K<1||K>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("startDate",S,true);var N=this.getAggregation("timesRow");N.setStartDate(S);this._oUTCStartDate=new U(N._getStartDate().getTime());n.call(this);var O=a._createLocalDate(this._getFocusedDate(),true);if(!N.checkDateFocusable(O)){this._setFocusedDate(this._oUTCStartDate);N.displayDate(S);}return this;};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){if(!O||(!(O instanceof sap.ui.unified.calendar.DatesRow||O instanceof sap.ui.unified.calendar.MonthPicker||O instanceof sap.ui.unified.calendar.YearPicker||O instanceof sap.ui.unified.calendar.Header))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,E);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("selectedDates");return K;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var K=this.destroyAggregation("specialDates");return K;};c.prototype.setIntervalMinutes=function(K){if(K>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%K>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",K,false);var N=this.getAggregation("timesRow");var O=a._createLocalDate(this._getFocusedDate(),true);if(!N.checkDateFocusable(O)){var S=d.call(this);this._setFocusedDate(S);N.setDate(a._createLocalDate(S,true));}return this;};c.prototype.setLocale=function(K){if(this._sLocale!=K){this._sLocale=K;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(K){if(!(K instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(K.getTime());};c.prototype.focusDate=function(K){var N=false;var O=this.getAggregation("timesRow");if(!O.checkDateFocusable(K)){var P=a._createUniversalUTCDate(K,undefined,true);F.call(this,P);N=true;}s.call(this,K,false);if(N){this.fireStartDateChange();}return this;};c.prototype.displayDate=function(K){s.call(this,K,true);return this;};c.prototype.setItems=function(K){this.setProperty("items",K,true);K=this._getItems();var N=this.getAggregation("timesRow");N.setItems(K);var O=a._createLocalDate(this._getFocusedDate(),true);if(!N.checkDateFocusable(O)){var S=d.call(this);this._setFocusedDate(S);N.setDate(a._createLocalDate(S,true));}if(!this.getPickerPopup()){var P=this.getAggregation("datesRow");var Q=Math.floor(K*1.5);if(Q>31){Q=31;}P.setDays(Q);var R=this.getAggregation("monthPicker");var V=Math.floor(K/2);if(V>12){V=12;}R.setMonths(V);var W=this.getAggregation("yearPicker");var X=Math.floor(K/2);if(X>20){X=20;}W.setYears(X);}n.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}};c.prototype._getItems=function(){var K=this.getItems();if(sap.ui.Device.system.phone&&K>6){return 6;}else{return K;}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var K=this.getLocale();var N=new sap.ui.core.Locale(K);this._oLocaleData=L.getInstance(N);}return this._oLocaleData;};c.prototype.setPickerPopup=function(P){this.setProperty("pickerPopup",P,true);var K=this.getAggregation("datesRow");var N=this.getAggregation("monthPicker");var O=this.getAggregation("yearPicker");if(K){K.destroy();}if(P){K=new sap.ui.unified.calendar.Month(this.getId()+"--DatesRow",{selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});this.setAggregation("datesRow",K);N.setColumns(3);N.setMonths(12);O.setColumns(4);O.setYears(20);}else{K=new b(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});this.setAggregation("datesRow",K);N.setColumns(0);N.setMonths(6);O.setColumns(0);O.setYears(6);}K.attachEvent("focus",z,this);K.attachEvent("select",y,this);K._bNoThemeChange=true;K.getIntervalSelection=function(){return this.getProperty("intervalSelection");};K.getSingleSelection=function(){return this.getProperty("singleSelection");};K.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};K.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};K.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};};c.prototype.onclick=function(K){if(K.isMarked("delayedMouseEvent")){return;}if(K.target.id==this.getId()+"-cancel"){this.onsapescape(K);}};c.prototype.onmousedown=function(K){K.preventDefault();K.setMark("cancelAutoClose");};c.prototype.onsapescape=function(K){switch(this._iMode){case 0:this.fireCancel();break;case 1:h.call(this);break;case 2:j.call(this);break;case 3:m.call(this);break;}};c.prototype.onsaptabnext=function(K){var N=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),K.target)){q.sap.focus(N.getDomRef("B0"));if(!this._bPoupupMode){var O=this.getAggregation("timesRow");var P=this.getAggregation("monthPicker");var Q=this.getAggregation("yearPicker");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(P.getDomRef()){q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}K.preventDefault();}else if(K.target.id==N.getId()+"-B0"){q.sap.focus(N.getDomRef("B1"));K.preventDefault();}else if(K.target.id==N.getId()+"-B1"){q.sap.focus(N.getDomRef("B2"));K.preventDefault();}};c.prototype.onsaptabprevious=function(K){var N=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),K.target)){if(this._bPoupupMode){q.sap.focus(N.getDomRef("B2"));K.preventDefault();}}else if(K.target.id==N.getId()+"-B0"){var O=this.getAggregation("timesRow");var P=this.getAggregation("monthPicker");var Q=this.getAggregation("yearPicker");switch(this._iMode){case 0:O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());break;case 2:P._oItemNavigation.focusItem(P._oItemNavigation.getFocusedIndex());break;case 3:Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());break;}K.preventDefault();}else if(K.target.id==N.getId()+"-B2"){q.sap.focus(N.getDomRef("B1"));K.preventDefault();}else if(K.target.id==N.getId()+"-B1"){q.sap.focus(N.getDomRef("B0"));K.preventDefault();}};c.prototype.onfocusin=function(K){if(K.target.id==this.getId()+"-end"){var N=this.getAggregation("header");var O=this.getAggregation("timesRow");var P=this.getAggregation("monthPicker");var Q=this.getAggregation("yearPicker");q.sap.focus(N.getDomRef("B2"));if(!this._bPoupupMode){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(P.getDomRef()){q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(K){if(!K.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(K.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var N=this.getAggregation("timesRow");var O=this.getAggregation("monthPicker");var P=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 3:q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype._handlePrevious=function(K){var N=this._getFocusedDate();switch(this._iMode){case 0:var O=this._getItems();var S=new U(d.call(this).getTime());var P=this.getIntervalMinutes();S.setUTCMinutes(S.getUTCMinutes()-O*P);N.setUTCMinutes(N.getUTCMinutes()-O*P);this._setFocusedDate(N);_.call(this,S,true);break;case 1:var Q=this.getAggregation("datesRow");var R=a._createUniversalUTCDate(Q.getDate());var V=Q.getDays();if(R.getUTCDate()<=V){R.setUTCDate(1);}else{R.setUTCDate(R.getUTCDate()-V);}G.call(this,R);break;case 2:var W=this.getAggregation("monthPicker");if(W.getMonths()<12){W.previousPage();}else{N.setUTCFullYear(N.getUTCFullYear()-1);F.call(this,N);this._setFocusedDate(N);n.call(this);this.fireStartDateChange();}break;case 3:var X=this.getAggregation("yearPicker");X.previousPage();break;}};c.prototype._handleNext=function(K){var N=this._getFocusedDate();switch(this._iMode){case 0:var O=this._getItems();var S=new U(d.call(this).getTime());var P=this.getIntervalMinutes();S.setUTCMinutes(S.getUTCMinutes()+O*P);N.setUTCMinutes(N.getUTCMinutes()+O*P);this._setFocusedDate(N);_.call(this,S,true);break;case 1:var Q=this.getAggregation("datesRow");var R=a._createUniversalUTCDate(Q.getDate());var V=new U(R.getTime());V.setUTCDate(1);V.setUTCMonth(V.getUTCMonth()+1);V.setUTCDate(0);var W=Q.getDays();if(R.getUTCDate()+W>V.getUTCDate()){R.setUTCDate(V.getUTCDate());}else{R.setUTCDate(R.getUTCDate()+W);}G.call(this,R);break;case 2:var X=this.getAggregation("monthPicker");if(X.getMonths()<12){X.nextPage();}else{N.setUTCFullYear(N.getUTCFullYear()+1);F.call(this,N);this._setFocusedDate(N);n.call(this);this.fireStartDateChange();}break;case 3:var Z=this.getAggregation("yearPicker");Z.nextPage();break;}};c.prototype._getShowItemHeader=function(){var K=this.getItems();if(K>this._iItemsHead){return true;}else{return false;}};function _(S,K,N){var O=new U(this._oMaxDate.getTime());O.setUTCMinutes(O.getUTCMinutes()-this.getIntervalMinutes()*this._getItems()+1);if(S.getTime()<this._oMinDate.getTime()){S=this._oMinDate;}else if(S.getTime()>O.getTime()){S=O;}var P=this.getAggregation("timesRow");var Q=a._createLocalDate(S,true);P.setStartDate(Q);this._oUTCStartDate=new U(P._getStartDate().getTime());Q=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",Q,true);n.call(this);if(K){var R=a._createLocalDate(this._getFocusedDate(),true);if(!P.checkDateFocusable(R)){this._setFocusedDate(S);P.setDate(Q);}else{P.setDate(R);}}if(!N){this.fireStartDateChange();}}function d(){if(!this._oUTCStartDate){var K=this.getAggregation("timesRow");K.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(K._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function e(N){var K=this._getFocusedDate();var O=this.getAggregation("timesRow");if(!N){O.setDate(a._createLocalDate(K,true));}else{O.displayDate(a._createLocalDate(K,true));}n.call(this);}function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),undefined,true);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N,undefined,true);}}function g(){if(this._iMode==3){m.call(this,true);}else if(this._iMode==2){j.call(this,true);}var K=this._getFocusedDate();var N=this._getItems();var O=this.getAggregation("datesRow");var P=O.getSelectedDates()[0];P.setStartDate(a._createLocalDate(K,true));if(!this.getPickerPopup()){var Q=new U(K.getTime());Q.setUTCDate(1);Q.setUTCMonth(Q.getUTCMonth()+1);Q.setUTCDate(0);var R=Q.getUTCDate();var S=Math.floor(N*1.5);if(S>R){S=R;}O.setDays(S);if(O.getDomRef()){O.$().css("display","");}else{var V=sap.ui.getCore().createRenderManager();var $=this.$("content");V.renderControl(O);V.flush($[0],false,true);V.destroy();}}else{I.call(this,O);}this.$("contentOver").css("display","");G.call(this,K);if(this._iMode==0){var W=this.getAggregation("timesRow");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;o.call(this);}function h(N){this._iMode=0;if(!this.getPickerPopup()){var K=this.getAggregation("datesRow");K.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){e.call(this);var O=this.getAggregation("timesRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function i(){if(this._iMode==1){h.call(this,true);}else if(this._iMode==3){m.call(this,true);}var K=this._getFocusedDate();var N=this.getAggregation("monthPicker");if(!this.getPickerPopup()){if(N.getDomRef()){N.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(N);R.flush($[0],false,true);R.destroy();}}else{I.call(this,N);}this.$("contentOver").css("display","");N.setMonth(K.getUTCMonth());if(this._iMode==0){var O=this.getAggregation("timesRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;o.call(this);}function j(N){this._iMode=0;if(!this.getPickerPopup()){var K=this.getAggregation("monthPicker");K.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){e.call(this);var O=this.getAggregation("timesRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function k(){if(this._iMode==1){h.call(this,true);}else if(this._iMode==2){j.call(this,true);}var K=this._getFocusedDate();var N=K.getJSDate().getUTCFullYear();var O=this._oMaxDate.getJSDate().getUTCFullYear();var P=this._oMinDate.getJSDate().getUTCFullYear();if(O-P<=20){return;}var Q=this.getAggregation("header");if(N>(O-10)){N=O-9;Q.setEnabledNext(false);}else{Q.setEnabledNext(true);}if(N<(P+9)){N=P+10;Q.setEnabledPrevious(false);}else{Q.setEnabledPrevious(true);}var R=this.getAggregation("yearPicker");if(!this.getPickerPopup()){if(R.getDomRef()){R.$().css("display","");}else{var S=sap.ui.getCore().createRenderManager();var $=this.$("content");S.renderControl(R);S.flush($[0],false,true);S.destroy();}}else{I.call(this,R);}this.$("contentOver").css("display","");R.setDate(K.getJSDate());if(this._iMode==0){var V=this.getAggregation("timesRow");q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=3;}function m(N){this._iMode=0;if(!this.getPickerPopup()){var K=this.getAggregation("yearPicker");K.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){e.call(this);var O=this.getAggregation("timesRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function n(){p.call(this);o.call(this,true);}function o(K){var N=new U(d.call(this).getTime());var O=this._getItems();var P=N.getJSDate().getUTCFullYear();var Q=this._oMaxDate.getJSDate().getUTCFullYear();var R=this._oMinDate.getJSDate().getUTCFullYear();var S=N.getJSDate().getUTCMonth();var V=this._oMaxDate.getJSDate().getUTCMonth();var W=this._oMinDate.getJSDate().getUTCMonth();var X=N.getJSDate().getUTCDate();var Z=this._oMaxDate.getJSDate().getUTCDate();var $=this._oMinDate.getJSDate().getUTCDate();var a1=this.getAggregation("header");if((P<R||(P==R&&(!K||(S<W||(S==W&&X<=$)))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){a1.setEnabledPrevious(false);}else{a1.setEnabledPrevious(true);}N.setUTCMinutes(N.getUTCMinutes()+(O)*this.getIntervalMinutes()-1);P=N.getJSDate().getUTCFullYear();S=N.getJSDate().getUTCMonth();X=N.getJSDate().getUTCDate();if((P>Q||(P==Q&&(!K||(S>V||(S==V&&X>=Z)))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){a1.setEnabledNext(false);}else{a1.setEnabledNext(true);}}function p(){var K=this.getAggregation("header");var N;var S=d.call(this);K.setTextButton0((S.getUTCDate()).toString());var O=this._getLocaleData();var P=[];var Q=[];var R;var V=false;if(this._bLongMonth||!this._bNamesLengthChecked){P=O.getMonthsStandAlone("wide");}else{V=true;P=O.getMonthsStandAlone("abbreviated");Q=O.getMonthsStandAlone("wide");}var W=S.getUTCMonth();N=P[W];if(V){R=Q[P[W]];}K.setTextButton1(N);if(V){K.setAriaLabelButton1(R);}K.setTextButton2(this._oYearFormat.format(S,true));}function r(K,N){var O;var P=false;if(K.getTime()<this._oMinDate.getTime()){O=this._oMinDate;P=true;}else if(K.getTime()>this._oMaxDate.getTime()){O=this._oMaxDate;P=true;}else{O=K;}this._setFocusedDate(O);if(P||N){F.call(this,O);e.call(this,false);this.fireStartDateChange();}}function s(K,N){if(K&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=K.getTime())){if(!(K instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}K=a._createUniversalUTCDate(K,undefined,true);var O=K.getUTCFullYear();if(O<1||O>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this._setFocusedDate(K);if(this.getDomRef()&&this._iMode==0){e.call(this,N);}}}function t(K){if(this._iMode!=1){g.call(this);}else{h.call(this);}}function u(K){if(this._iMode!=2){i.call(this);}else{j.call(this);}}function v(K){if(this._iMode!=3){k.call(this);}else{m.call(this);}}function w(K){this.fireSelect();}function x(K){var N=a._createUniversalUTCDate(K.getParameter("date"),undefined,true);var O=K.getParameter("notVisible");r.call(this,N,O);}function y(K){var N=new U(this._getFocusedDate().getTime());var O=K.oSource;var P=O.getSelectedDates()[0];var Q=a._createUniversalUTCDate(P.getStartDate());if(!this.getPickerPopup()||Q.getUTCMonth()==N.getUTCMonth()){N.setUTCDate(Q.getUTCDate());N.setUTCMonth(Q.getUTCMonth());N.setUTCFullYear(Q.getUTCFullYear());r.call(this,N,true);h.call(this);}}function z(K){var N=new U(this._getFocusedDate().getTime());var O=a._createUniversalUTCDate(K.getParameter("date"),undefined,true);var P=K.getParameter("otherMonth");if(P&&O.getUTCMonth()==N.getUTCMonth()&&O.getUTCFullYear()==N.getUTCFullYear()){G.call(this,O);}}function A(K){var N=new U(this._getFocusedDate().getTime());var O=this.getAggregation("monthPicker");var P=O.getMonth();N.setUTCMonth(P);if(P!=N.getUTCMonth()){N.setUTCDate(0);}r.call(this,N,true);j.call(this);}function B(K){var N=new U(this._getFocusedDate().getTime());var O=this.getAggregation("yearPicker");var P=a._createUniversalUTCDate(O.getDate());var Q=N.getUTCMonth();P.setUTCMonth(N.getUTCMonth(),N.getUTCDate());P.setUTCHours(N.getUTCHours());P.setUTCMinutes(N.getUTCMinutes());N=P;if(Q!=N.getUTCMonth()){N.setUTCDate(0);}r.call(this,N,true);m.call(this);}function E(){this._sInvalidateContent=undefined;var K=this.getAggregation("timesRow");K._bDateRangeChanged=true;K._bInvalidateSync=true;K.invalidate();K._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function F(K){var N=this.getAggregation("timesRow");var S=d.call(this);var O=N._oItemNavigation.getFocusedIndex();S=new U(K.getTime());S.setUTCMinutes(S.getUTCMinutes()-O*this.getIntervalMinutes());_.call(this,S,false,true);}function G(K){var N=this.getAggregation("datesRow");if(!this.getPickerPopup()){var O=new U(K.getTime());O.setUTCDate(1);O.setUTCMonth(O.getUTCMonth()+1);O.setUTCDate(0);var P=N.getDays();var S=new U(K.getTime());S.setUTCDate(1+(Math.ceil(K.getUTCDate()/P)-1)*P);if(O.getUTCDate()-S.getUTCDate()<P){S.setUTCDate(O.getUTCDate()-P+1);}N.setStartDate(a._createLocalDate(S,true));}N.setDate(a._createLocalDate(K,true));}function I(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(J,this);this._oPopup.onsapescape=function(O){this._oCalendar.onsapescape(O);};}this._oPopup.setContent(P);var K=this.getAggregation("header");var N=sap.ui.core.Popup.Dock;this._oPopup.open(0,N.CenterTop,N.CenterBottom,K,null,"flipfit",true);}function J(K){switch(this._iMode){case 0:break;case 1:h.call(this);break;case 2:j.call(this);break;case 3:m.call(this);break;}}return c;},true);
