/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Text","sap/m/Button","sap/m/ActionSheet","sap/m/Image","sap/ui/core/Icon","./library"],function(C,I,a,D,B,O,R,T,b,A,c,d,l){"use strict";var e=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:sap.uxap.ObjectPageHeaderPictureShape.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:sap.uxap.ObjectPageHeaderDesign.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}}}});e.prototype._iAvailablePercentageForActions=0.3;e.prototype.init=function(){if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iScrollBarWidth=jQuery.position.scrollbarWidth();this._oOverflowActionSheet=this._getInternalAggregation("_overflowActionSheet");this._oOverflowButton=this._getInternalAggregation("_overflowButton").attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._getInternalAggregation("_expandButton");this._oActionSheetButtonMap={};this._oFlagIcon=this._getInternalAggregation("_flagIcon");this._oFavIcon=this._getInternalAggregation("_favIcon");this._oTitleArrowIcon=this._getInternalAggregation("_titleArrowIcon").attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._getInternalAggregation("_titleArrowIconCont").attachPress(this._handleArrowPress,this);this._oLockIcon=this._getInternalAggregation("_lockIcon").attachPress(this._handleLockPress,this);this._oLockIconCont=this._getInternalAggregation("_lockIconCont").attachPress(this._handleLockPress,this);this._oChangesIcon=this._getInternalAggregation("_changesIcon").attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._getInternalAggregation("_changesIconCont").attachPress(this._handleChangesPress,this);};e.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};e.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};e.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};e.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};e._internalAggregationFactory={"_objectImage":function(P){var f,s=P.getObjectImageURI();if(s.indexOf("sap-icon://")==0){f=new d();}else{f=new c({densityAware:P.getObjectImageDensityAware(),alt:P.getObjectImageAlt(),decorative:false});}f.setSrc(s);f.addStyleClass("sapUxAPObjectPageHeaderObjectImage");if(P.getObjectImageAlt()){f.setTooltip(P.getObjectImageAlt());}return f;},"_overflowActionSheet":function(){return new A({placement:sap.m.PlacementType.Bottom});},"_lockIconCont":function(P){return this._getButton(P,"sap-icon://locked","lock-cont");},"_breadCrumbs":function(P){return new B({links:P.getAggregation("breadCrumbLinks")});},"_lockIcon":function(P){return this._getButton(P,"sap-icon://locked","lock",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow-cont",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(P){return this._getIcon(P,"favorite",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(P){return this._getIcon(P,"flag",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(P){return this._getButton(P,"sap-icon://overflow","overflow");},"_expandButton":function(P){return this._getButton(P,"sap-icon://slim-arrow-down","expand",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(P){return this._getButton(P,"sap-icon://request","changes-cont",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(P){return this._getButton(P,"sap-icon://request","changes",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(P,i,t){return I.createControlByURI({id:this._getParentAugmentedId(P,i),tooltip:t,src:I.getIconURI(i),visible:false});},_getButton:function(P,i,s,t){return new b({id:this._getParentAugmentedId(P,s),tooltip:t,icon:i,type:sap.m.ButtonType.Transparent});},_getParentAugmentedId:function(P,s){return P.getId()+"-"+s;}};e.prototype._getInternalAggregation=function(s){if(!this.getAggregation(s)){this.setAggregation(s,e._internalAggregationFactory[s](this));}return this.getAggregation(s);};e.prototype._applyActionProperty=function(P,f){var n=f[0];if(this.getProperty(P)!==n){f.unshift(P);this.setProperty.apply(this,f);this._notifyParentOfChanges();}return this;};e.prototype._applyObjectImageProperty=function(P,f){var n=f[0];if(this.getProperty(P)!==n){f.unshift(P);this.setProperty.apply(this,f);this._destroyObjectImage();this._notifyParentOfChanges();}return this;};e.prototype._proxyMethodToBreadCrumbControl=function(f,h){var i=this._getInternalAggregation("_breadCrumbs");return i[f].apply(i,h);};e.prototype.setHeaderDesign=function(h){this.setProperty("headerDesign",h);if(this.getParent()){this.getParent().invalidate();}return this;};e.prototype._shiftHeaderTitle=function(){var P=this.getParent(),h=0,s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",$=this.$().find(".sapUxAPObjectPageHeaderIdentifierActions"),H=true,i=this._iOffset;if(typeof P._hasVerticalScrollBar==="function"){H=P._hasVerticalScrollBar();}if(sap.ui.Device.system.desktop){h=this._iScrollBarWidth;if(!H){h=0;i+=this._iScrollBarWidth;}}$.css(s,i+"px");if(typeof P._shiftHeader==="function"){P._shiftHeader(s,h+"px");}};e.prototype.setObjectTitle=function(t){return this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var g=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var f=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,P,f);};};var G=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var f=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,P,f);};};p.forEach(g);o.forEach(G);e.prototype.getBreadCrumbsLinks=function(){return this._getInternalAggregation("_breadCrumbs").getLinks();};e.prototype.addBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("addLink",arguments);};e.prototype.indexOfBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("indexOfLink",arguments);};e.prototype.insertBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("insertLink",arguments);};e.prototype.removeBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("removeLink",arguments);};e.prototype.removeAllBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("removeAllLinks",arguments);};e.prototype.destroyBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("destroyLinks",arguments);};e.prototype._destroyObjectImage=function(){var s="_objectImage",f=this.getAggregation(s);if(f){f.destroy();this.setAggregation(s,null);}};e.prototype.onBeforeRendering=function(){if(this.getShowPlaceholder()){this._oPlaceholder=I.createControlByURI({src:I.getIconURI("picture"),visible:true});}var f=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(f.length>1||this._hasOneButtonShowText(f)){jQuery.each(f,jQuery.proxy(function(i,h){if(h instanceof b&&h.getVisible()){if(h instanceof b&&(h.getType()==="Default"||h.getType()==="Unstyled")){h.setProperty("type",sap.m.ButtonType.Transparent,false);}var j=this._createActionSheetButton(h);this._oActionSheetButtonMap[h.getId()]=j;this._oOverflowActionSheet.addButton(j);}},this));}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);};e.prototype._createActionSheetButton=function(f){var h=new b({press:jQuery.proxy(this._onSeeMoreContentSelect,this),enabled:f.getEnabled(),customData:new a({key:"originalId",value:f.getId()})});var t=f.getBindingInfo("text"),i=f.getBindingInfo("icon"),m;if(t&&t.parts&&t.parts.length>0){m=t.parts[0].model;h.bindProperty("text",{path:t.parts[0].path,model:m,formatter:t.formatter});h.setBindingContext(f.getBindingContext(m),m);h.setModel(f.getModel(m),m);}else{h.setText(f.getText());}if(i&&i.parts&&i.parts.length>0){m=i.parts[0].model;h.bindProperty("icon",{path:i.parts[0].path,model:m,formatter:i.formatter});h.setBindingContext(f.getBindingContext(m),m);h.setModel(f.getModel(m),m);}else{h.setIcon(f.getIcon());}return h;};e.prototype.onAfterRendering=function(){this._adaptLayout();if(this.getShowPlaceholder()){jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function(){jQuery(this).hide();jQuery(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");});}else{jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function(){jQuery(this).addClass("sapMNoImg");});}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._shiftHeaderTitle();this._attachDetachActionButtonsHandler(true);};e.prototype._onHeaderResize=function(){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._adjustHeaderHeights==="function"){this.getParent()._adjustHeaderHeights();}};e.prototype._attachDetachActionButtonsHandler=function(f){var h=this.getActions()||[];if(h.length<1){return;}h.forEach(function(i){if(i instanceof O){if(f){i.attachEvent("_change",this._adaptLayout,this);}else{i.detachEvent("_change",this._adaptLayout,this);}}},this);};e.prototype._onSeeMoreContentSelect=function(E){var P=E.getSource(),f=sap.ui.getCore().byId(P.data("originalId"));if(f.firePress){f.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};e._actionImportanceMap={"Low":3,"Medium":2,"High":1};e._sortActionsByImportance=function(f,h){var i=(f instanceof O)?f.getImportance():sap.uxap.Importance.High,s=(h instanceof O)?h.getImportance():sap.uxap.Importance.High,j=e._actionImportanceMap[i]-e._actionImportanceMap[s];if(j===0){return f.position-h.position;}return j;};e.prototype._hasOneButtonShowText=function(f){var h=false;if(f.length!==1){return h;}if(f[0]instanceof O){h=(!f[0].getHideText()&&f[0].getText()!="");}else if(f[0]instanceof b){h=(f[0].getText()!="");}return h;};e.prototype._adaptLayout=function(){var i=this.$("identifierLine").width(),f=this._getActionsWidth(),h=f/i,j=this._iAvailablePercentageForActions*i,$=this._oOverflowButton.$(),k=this.$("actions").find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(h>this._iAvailablePercentageForActions){this._adaptActions(j);}k.css("visibility","visible");if(k.filter(":visible").length===k.length){$.hide();}this._adaptObjectPageHeaderIndentifierLine();};e.prototype._adaptObjectPageHeaderIndentifierLine=function(){var i=this.$("identifierLine").width(),$=this.$("subtitle"),f=this.$("identifierLineContainer"),s,t,h=this.$("actions").width()+this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer").width(),P=3;if($.length){if($.hasClass("sapOPHSubtitleBlock")){$.removeClass("sapOPHSubtitleBlock");}s=$.outerHeight()+$.position().top;t=this.$("innerTitle").outerHeight()+this.$("innerTitle").position().top;if(Math.abs(s-t)>P){$.addClass("sapOPHSubtitleBlock");}}f.width((0.95-(h/i))*100+"%");};e.prototype._adaptActions=function(f){var m=jQuery("html").hasClass("sapUiMedia-Std-Phone")||D.system.phone,v=this._oOverflowButton.$().show().width(),h=this.getActions(),j=h.length,k;for(var i=0;i<j;i++){h[i].position=i;}h.sort(e._sortActionsByImportance);h.forEach(function(n){k=this._oActionSheetButtonMap[n.getId()];if(k){v+=n.$().width();if(f>v&&!m){k.setVisible(false);}else{this._setActionButtonVisibility(n,false);}}},this);};e.prototype._setActionButtonVisibility=function(f,v){var h=this._oActionSheetButtonMap[f.getId()];if(h){if(v){f.$().show();}else{f.$().hide();}h.setVisible(!v);}};e.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(f){if(f instanceof b){f.$().show();f.$().css("visibility","hidden");w+=f.$().outerWidth(true);}});return w;};e.prototype._notifyParentOfChanges=function(){if(this.getParent()&&typeof this.getParent()._headerTitleChangeHandler==="function"){this.getParent()._headerTitleChangeHandler();}};e.prototype._getActionsPaddingStatus=function(){return this.$("actions").hasClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");};e.prototype._setActionsPaddingStatus=function(s){return this.$("actions").toggleClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding",s);};e.prototype.exit=function(){jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error");if(this._iResizeId){R.deregister(this._iResizeId);}};return e;});
