jQuery.sap.declare('sap.ui.layout.library-all');if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayout')){
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.layout.BlockLayout');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/BlockLayout",['sap/ui/core/Control'],function(C){"use strict";var B=C.extend("sap.ui.layout.BlockLayout",{metadata:{library:"sap.ui.layout",properties:{background:{type:"sap.ui.layout.BlockBackgroundType",group:"Appearance",defaultValue:"Default"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutRow",multiple:true}}}});B.CONSTANTS={breakPointM:600,breakPointL:1024};B.prototype.onBeforeRendering=function(){this._detachResizeHandler();};B.prototype.onAfterRendering=function(){this._parentResizeHandler=sap.ui.core.ResizeHandler.register(this,this._onParentResize.bind(this));this._onParentResize();};B.prototype._onParentResize=function(){var d=this.getDomRef(),w=d.clientWidth;this._removeBreakpointClasses();if(w<=B.CONSTANTS.breakPointM){this.addStyleClass("sapUiBlockLayoutSmall",true);}else if(w>B.CONSTANTS.breakPointM&&w<B.CONSTANTS.breakPointL){this.addStyleClass("sapUiBlockLayoutMedium",true);}else{this.addStyleClass("sapUiBlockLayoutBig",true);}};B.prototype._removeBreakpointClasses=function(){this.removeStyleClass("sapUiBlockLayoutBig",true);this.removeStyleClass("sapUiBlockLayoutMedium",true);this.removeStyleClass("sapUiBlockLayoutSmall",true);};B.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){sap.ui.core.ResizeHandler.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};B.prototype.exit=function(){this._detachResizeHandler();};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayoutCell')){jQuery.sap.declare('sap.ui.layout.BlockLayoutCell');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/BlockLayoutCell",['sap/ui/core/Control'],function(C){"use strict";var B=C.extend("sap.ui.layout.BlockLayoutCell",{metadata:{library:"sap.ui.layout",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleAlignment:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:"Begin"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:"Auto"},width:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});B.prototype.setWidth=function(w){this.setProperty("width",w);if(!this._getParentRowScrollable()){var p=this.getParent();if(p){p._checkGuidelinesAndUpdateCells();}}return this;};B.prototype._clearState=function(){this._parentRowScrollable=false;this._differentSBreakpointSize=false;};B.prototype._setDifferentSBreakpointSize=function(d,r){this._differentSBreakpointSize=d;this._widthToRowWidthRatio=r;};B.prototype._getDifferentSBreakpointSize=function(){return this._differentSBreakpointSize;};B.prototype._getWidthToRowWidthRatio=function(){return this._widthToRowWidthRatio;};B.prototype._setParentRowScrollable=function(s){this._parentRowScrollable=s;};B.prototype._getParentRowScrollable=function(){return this._parentRowScrollable;};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayoutCellRenderer')){jQuery.sap.declare('sap.ui.layout.BlockLayoutCellRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/BlockLayoutCellRenderer",['jquery.sap.global'],function(q){"use strict";var B={};B.render=function(r,b){this.startCell(r,b);this.addContent(r,b);this.endCell(r);};B.startCell=function(r,b){r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutCell");if(b._getDifferentSBreakpointSize()){this.setDifferentSBreakpointSize(r,b._getWidthToRowWidthRatio());}else{this.setWidth(r,b);}r.writeStyles();r.writeClasses();r.write(">");};B.setDifferentSBreakpointSize=function(r,w){switch(w){case 0.25:r.addClass("sapUiBlockSmallCell");break;case 0.5:r.addClass("sapUiBlockMediumCell");break;default:break;}};B.setWidth=function(r,b){if(b._getParentRowScrollable()){var w=b.getWidth();if(w!==0){r.addStyle("width",w+"%");}}else{var f=(b.getWidth()==0)?1:b.getWidth();this.addFlex(r,f);}};B.addFlex=function(r,f){r.addStyle("-webkit-flex",f);r.addStyle("-ms-flex",f);r.addStyle("flex",f);};B.addTitle=function(r,b){if(b.getTitle()){var a="sapUiBlockCell"+b.getTitleAlignment(),t="sapUiBlockCellTitle "+a;var l=b.getTitleLevel(),c=l==sap.ui.core.TitleLevel.Auto,d=c?"h2":l;r.write("<"+d+" id='"+this.getTitleId(b)+"' class='"+t+"'>");r.writeEscaped(b.getTitle());r.write("</"+d+">");}};B.getTitleId=function(b){return b.getId()+"-Title";};B.addContent=function(r,b){var c=b.getContent(),a="sapUiBlockCellContent ";if(b.getTitleAlignment()=="Center"){a+="sapUiBlockCellCenteredContent";}r.write("<div class='"+a+"' aria-labelledby='"+this.getTitleId(b)+"' >");this.addTitle(r,b);c.forEach(r.renderControl);r.write("</div>");};B.endCell=function(r){r.write("</div>");};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.BlockLayoutRenderer');sap.ui.define("sap/ui/layout/BlockLayoutRenderer",[],function(){"use strict";var B={};B.render=function(r,b){this.startLayout(r,b);this.addContent(r,b);this.endLayout(r);};B.startLayout=function(r,b){var a=b.getBackground();r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayout");if(a=="Light"){r.addClass("sapUiBlockLayoutLightBackground");}r.writeStyles();r.writeClasses();r.write(">");};B.addContent=function(r,b){var c=b.getContent();c.forEach(r.renderControl);};B.endLayout=function(r){r.write("</div>");};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayoutRow')){jQuery.sap.declare('sap.ui.layout.BlockLayoutRow');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/BlockLayoutRow",['jquery.sap.global','sap/ui/core/Control'],function(q,C){"use strict";var B=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}}}});B.CONSTANTS={maxScrollableCellsPerRow:10,minScrollableCellsPerRow:3,guidelineRatios:[0.25,0.5,0.75,1.0]};B.prototype.onBeforeRendering=function(){this._checkGuidelinesAndUpdateCells();};B.prototype._checkGuidelinesAndUpdateCells=function(){var t=this,c=this.getContent(),a=this._calcCellRatios(),d=this._checkDifferentSBreakpointCase(),g=this._guidelinesCheck();c.forEach(function(b,i){b._clearState();if(t.getScrollable()){b._setParentRowScrollable(true);}else if(d&&g){b._setDifferentSBreakpointSize(true,a[i]);}});if(!this.getScrollable()&&d&&g){this._rowSCase=true;this.addStyleClass("sapUiBlockRowSCase",true);}else{this._rowSCase=false;this.removeStyleClass("sapUiBlockRowSCase",true);}};B.prototype._guidelinesCheck=function(){if(this.getScrollable()){return this._checkScrollableCellsCount();}else{return this._checkNonScrollableGuidelines();}};B.prototype._calcCellRatios=function(){var c=[],t=0,a=this.getContent();a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth();t+=d;});a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth(),e=d/t;c.push(e);});return c;};B.prototype._checkNonScrollableGuidelines=function(){var t=this,c=this._calcCellRatios(),g=true;c.forEach(function(a){if(!t._isCellRatioIncluded(a)){g=false;}});if(!g){q.sap.log.error("In your BlockLayoutRow "+this.getId()+" you are using cell ratios that are "+"not recommended in the guidelines. Cells can be with width of 25% 50% 75% or 100% according to the guidelines.");}return g;};B.prototype._checkDifferentSBreakpointCase=function(){var c=this._calcCellRatios(),a=this.getContent();if(a.length==4||(a.length==3&&c[1]!=0.5)){return true;}return false;};B.prototype._isCellRatioIncluded=function(r){var g=B.CONSTANTS.guidelineRatios;for(var i=0;i<g.length;i++){if(g[i]===r){return true;}}return false;};B.prototype._checkScrollableCellsCount=function(){if(this.getContent().length>B.CONSTANTS.maxScrollableCellsPerRow){q.sap.log.error("You are using too much cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Max cells allowed: 10.");return false;}if(this.getContent().length<B.CONSTANTS.minScrollableCellsPerRow){q.sap.log.error("You are using not enough cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Min cells allowed: 3.");return false;}return true;};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.BlockLayoutRowRenderer')){jQuery.sap.declare('sap.ui.layout.BlockLayoutRowRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/BlockLayoutRowRenderer",['jquery.sap.global'],function(q){"use strict";var B={};B.render=function(r,b){this.startRow(r,b);this.renderContent(r,b);this.endRow(r,b);};B.startRow=function(r,b){r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutRow");this.addRowRenderingClass(r,b);r.writeStyles();r.writeClasses();r.write(">");};B.addRowRenderingClass=function(r,b){if(b.getScrollable()){r.addClass("sapUiBlockScrollingRow");if(b.getContent().length>=6){r.addClass("sapUiBlockScrollingNarrowCells");}}else{r.addClass("sapUiBlockHorizontalCellsRow");}if(b._rowSCase){r.addClass("sapUiBlockRowSCase");}};B.renderContent=function(r,b){var c,a=b.getContent(),s=b.getScrollable();for(var i=0;i<a.length;i++){c=a[i];if(s){c.addStyleClass("sapUiBlockScrollableCell");}else{c.addStyleClass("sapUiBlockHorizontalCell");}r.renderControl(c);}};B.endRow=function(r){r.write("</div>");};return B;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.DynamicSideContent')){jQuery.sap.declare('sap.ui.layout.DynamicSideContent');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.ResizeHandler');sap.ui.define("sap/ui/layout/DynamicSideContent",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler'],function(q,C,R){"use strict";var D=C.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:sap.ui.layout.SideContentVisibility.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:sap.ui.layout.SideContentFallDown.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:sap.ui.layout.SideContentPosition.End}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}}}});var S="S",M="M",L="L",X="XL",H="sapUiHidden",a="sapUiDSCSpan12",b="sapUiDSCMCFixed",c="sapUiDSCSCFixed",d=3,e=4,f=6,g=8,h=9,i=12,I="Invalid Breakpoint. Expected: S, M, L or XL",j="SCGridCell",k="MCGridCell",l=720,m=1024,n=1440;D.prototype.init=function(){this._bSuppressInitialFireBreakPointChange=true;};D.prototype.setShowSideContent=function(v,s){this.setProperty("showSideContent",v,true);this._SCVisible=v;if(!s&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._MCVisible=true;}this._changeGridState();}return this;};D.prototype.setShowMainContent=function(v,s){this.setProperty("showMainContent",v,true);this._MCVisible=v;if(!s&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._SCVisible=true;}this._changeGridState();}return this;};D.prototype.getShowSideContent=function(){if(this._currentBreakpoint===S){return this._SCVisible&&this.getProperty("showSideContent");}else{return this.getProperty("showSideContent");}};D.prototype.getShowMainContent=function(){if(this._currentBreakpoint===S){return this._MCVisible&&this.getProperty("showMainContent");}else{return this.getProperty("showMainContent");}};D.prototype.setEqualSplit=function(s){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",s,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,s);this._changeGridState();}return this;};D.prototype.addSideContent=function(o){this.addAggregation("sideContent",o,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(j));return this;};D.prototype.addMainContent=function(o){this.addAggregation("mainContent",o,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(k));return this;};D.prototype.toggle=function(){if(this._currentBreakpoint===S){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false;}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false;}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false;}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false;}this._changeGridState();}return this;};D.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint;};D.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this.getProperty("showSideContent");this._MCVisible=this.getProperty("showMainContent");if(!this.getContainerQuery()){this._iWindowWidth=q(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit());}};D.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize();}else{var t=this;q(window).resize(function(){t._adjustToScreenSize();});}this._changeGridState();this._initScrolling();};D.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null;}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null;}};D.prototype._rerenderControl=function(o,$){if(this.getDomRef()){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(r,o);r.flush($[0]);r.destroy();}return this;};D.prototype._initScrolling=function(){var s=this.getId(),o=s+"-"+j,p=s+"-"+k;if(!this._oSCScroller&&!this._oMCScroller){q.sap.require("sap.ui.core.delegate.ScrollEnablement");this._oSCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:o,horizontal:false,vertical:true});this._oMCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:p,horizontal:false,vertical:true});}};D.prototype._attachContainerResizeListener=function(){if(!this._sContainerResizeListener){this._sContainerResizeListener=R.register(this,q.proxy(this._adjustToScreenSize,this));}};D.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}};D.prototype._getBreakPointFromWidth=function(w){if(w<=l&&this._currentBreakpoint!==S){return S;}else if((w>l)&&(w<=m)&&this._currentBreakpoint!==M){return M;}else if((w>m)&&(w<=n)&&this._currentBreakpoint!==L){return L;}else if(w>n&&this._currentBreakpoint!==X){return X;}return this._currentBreakpoint;};D.prototype._setBreakpointFromWidth=function(w){this._currentBreakpoint=this._getBreakPointFromWidth(w);if(this._bSuppressInitialFireBreakPointChange){this._bSuppressInitialFireBreakPointChange=false;}else{this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint});}};D.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width();}else{this._iWindowWidth=q(window).width();}if(this._iWindowWidth!==this._iOldWindowWidth){this._iOldWindowWidth=this._iWindowWidth;this._oldBreakPoint=this._currentBreakpoint;this._setBreakpointFromWidth(this._iWindowWidth);if((this._oldBreakPoint!==this._currentBreakpoint)||(this._currentBreakpoint===M&&this.getSideContentFallDown()===sap.ui.layout.SideContentFallDown.OnMinimumWidth)){this._setResizeData(this._currentBreakpoint,this.getEqualSplit());this._changeGridState();}}};D.prototype._setResizeData=function(s,o){var p=this.getSideContentVisibility(),r=this.getSideContentFallDown();if(!o){switch(s){case S:this._setSpanSize(i,i);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")){this._SCVisible=p===sap.ui.layout.SideContentVisibility.AlwaysShow;}this._bFixedSideContent=false;break;case M:var t=Math.ceil((33.333/100)*this._iWindowWidth);if(r===sap.ui.layout.SideContentFallDown.BelowL||r===sap.ui.layout.SideContentFallDown.BelowXL||(t<=320&&r===sap.ui.layout.SideContentFallDown.OnMinimumWidth)){this._setSpanSize(i,i);this._bFixedSideContent=false;}else{this._setSpanSize(e,g);this._bFixedSideContent=true;}this._SCVisible=p===sap.ui.layout.SideContentVisibility.ShowAboveS||p===sap.ui.layout.SideContentVisibility.AlwaysShow;this._MCVisible=true;break;case L:if(r===sap.ui.layout.SideContentFallDown.BelowXL){this._setSpanSize(i,i);}else{this._setSpanSize(e,g);}this._SCVisible=p===sap.ui.layout.SideContentVisibility.ShowAboveS||p===sap.ui.layout.SideContentVisibility.ShowAboveM||p===sap.ui.layout.SideContentVisibility.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case X:this._setSpanSize(d,h);this._SCVisible=p!==sap.ui.layout.SideContentVisibility.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(I);}}else{switch(s){case S:this._setSpanSize(i,i);this._SCVisible=false;break;default:this._setSpanSize(f,f);this._SCVisible=true;this._MCVisible=true;}this._bFixedSideContent=false;}return this;};D.prototype._shouldSetHeight=function(){var s,B,o,O,p,F,r;s=(this._iScSpan+this._iMcSpan)===i;B=this._MCVisible&&this._SCVisible;o=!this._MCVisible&&this._SCVisible;O=this._MCVisible&&!this._SCVisible;p=o||O;F=this._fixedSideContent;r=this.getSideContentVisibility()===sap.ui.layout.SideContentVisibility.NeverShow;return((s&&B)||p||F||r);};D.prototype._changeGridState=function(){var $=this.$(j),o=this.$(k),p=this.getProperty("showMainContent"),s=this.getProperty("showSideContent");if(this._bFixedSideContent){$.removeClass().addClass(c);o.removeClass().addClass(b);}else{$.removeClass(c);o.removeClass(b);}if(this._SCVisible&&this._MCVisible&&s&&p){if(!this._bFixedSideContent){o.removeClass().addClass("sapUiDSCSpan"+this._iMcSpan);$.removeClass().addClass("sapUiDSCSpan"+this._iScSpan);}if(this._shouldSetHeight()){$.css("height","100%").css("float","left");o.css("height","100%").css("float","left");}else{$.css("height","auto").css("float","none");o.css("height","auto").css("float","none");}}else if(!this._SCVisible&&!this._MCVisible){o.addClass(H);$.addClass(H);}else if(this._MCVisible&&p){o.removeClass().addClass(a);$.addClass(H);}else if(this._SCVisible&&s){$.removeClass().addClass(a);o.addClass(H);}else if(!p&&!s){o.addClass(H);$.addClass(H);}};D.prototype._setSpanSize=function(s,o){this._iScSpan=s;this._iMcSpan=o;};return D;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.DynamicSideContentRenderer')){jQuery.sap.declare('sap.ui.layout.DynamicSideContentRenderer');sap.ui.define("sap/ui/layout/DynamicSideContentRenderer",[],function(){"use strict";var S="SIDE_CONTENT_LABEL";var D={};D.render=function(r,s){r.write("<div");r.writeControlData(s);r.addClass("sapUiDSC");r.writeClasses();r.addStyle("height","100%");r.writeStyles();r.write(">");this.renderSubControls(r,s);r.write("</div>");};D.renderSubControls=function(r,s){var i=s.getId(),b=s._shouldSetHeight(),p=sap.ui.getCore().getConfiguration().getRTL(),a=s.getSideContentPosition();if((a===sap.ui.layout.SideContentPosition.Begin&&!p)||(p&&a===sap.ui.layout.SideContentPosition.End)){this._renderSideContent(r,s,i,b);this._renderMainContent(r,s,i,b);}else{this._renderMainContent(r,s,i,b);this._renderSideContent(r,s,i,b);}};D.renderControls=function(r,c){var l=c.length,i=0;for(;i<l;i++){r.renderControl(c[i]);}};D._renderMainContent=function(r,s,i,b){r.write("<div id='"+i+"-MCGridCell'");if(s._iMcSpan){r.addClass("sapUiDSCSpan"+s._iMcSpan);r.writeClasses();}if(b){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getMainContent());r.write("</div>");};D._renderSideContent=function(r,s,i,b){var a=sap.ui.Device.browser.firefox?"div":"aside";r.write("<"+a+" id='"+i+"-SCGridCell'");var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");r.writeAttribute("aria-label",m.getText(S));r.writeAccessibilityState(s,{role:"complementary"});if(s._iScSpan){r.addClass("sapUiDSCSpan"+s._iScSpan);r.writeClasses();}if(b){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getSideContent());r.write("</"+a+">");};return D;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.FixFlexRenderer')){jQuery.sap.declare('sap.ui.layout.FixFlexRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/FixFlexRenderer",['jquery.sap.global'],function(q){"use strict";var F={};F.render=function(r,c){r.write('<div');r.writeControlData(c);r.addClass('sapUiFixFlex');if(c.getMinFlexSize()!==0){r.addClass('sapUiFixFlexInnerScrolling');}if(!c.getVertical()){r.addClass('sapUiFixFlexRow');}if(!q.support.hasFlexBoxSupport){r.addClass('sapUiFixFlex-Legacy');}r.writeClasses();r.write('>');if(c.getFixFirst()){this.renderFixChild(r,c);this.renderFlexChild(r,c);}else{this.renderFlexChild(r,c);this.renderFixChild(r,c);}r.write('</div>');};F.renderFixChild=function(r,c){var f=c.getFixContent();r.write('<div id="'+c.getId()+'-Fixed" class="sapUiFixFlexFixed"');if(c.getFixContentSize()!=='auto'){if(c.getVertical()){r.addStyle('height',c.getFixContentSize());}else{r.addStyle('width',c.getFixContentSize());}r.writeStyles();}r.write('>');for(var i=0;i<f.length;i++){r.renderControl(f[i]);}r.write('</div>');};F.renderFlexChild=function(r,c){var f=c.getFlexContent();r.write('<div id="'+c.getId()+'-Flexible" class="sapUiFixFlexFlexible">');r.write('<div id="'+c.getId()+'-FlexibleContainer" class="sapUiFixFlexFlexibleContainer"');if(c.getMinFlexSize()!==0){if(c.getVertical()){r.write('style="min-height:'+c.getMinFlexSize()+'px"');}else{r.write('style="min-width:'+c.getMinFlexSize()+'px"');}}r.write('>');r.renderControl(f);r.write('</div>');r.write('</div>');};return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.GridRenderer')){jQuery.sap.declare('sap.ui.layout.GridRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/GridRenderer",['jquery.sap.global'],function(q){"use strict";var G={};G.render=function(r,c){var I=/^([X][L](?:[0-9]|1[0-1]))? ?([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i;var S=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;r.write("<div");r.writeControlData(c);r.addClass("sapUiRespGrid");var M=sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED).name;r.addClass("sapUiRespGridMedia-Std-"+M);var h=c.getHSpacing();if(h==0.5){h="05";}else if((h!==0)&&(h!==1)&&(h!==2)){h=1;}r.addClass("sapUiRespGridHSpace"+h);var v=c.getVSpacing();if(v==0.5){v="05";}else if((v!==0)&&(v!==1)&&(v!==2)){v=1;}r.addClass("sapUiRespGridVSpace"+v);var p=c.getPosition();if(p){p=p.toUpperCase();if(p===sap.ui.layout.GridPosition.Center.toUpperCase()){r.addClass("sapUiRespGridPosCenter");}else if(p===sap.ui.layout.GridPosition.Right.toUpperCase()){r.addClass("sapUiRespGridPosRight");}}r.writeClasses();var w=c.getWidth();if(w!=="100%"&&w!=="auto"&&w!=="inherit"){if(h==0){w="width: "+w;}else{w="width: -webkit-calc("+w+" - "+h+"rem); width: calc("+w+" - "+h+"rem); ";}r.writeAttribute("style",w);}var R=c._getAccessibleRole();var a;if(R){a={role:R};}r.writeAccessibilityState(c,a);r.write(">");var b=c.getContent();var d=c.getDefaultSpan();var e=["","XL3","L3","M6","S12"];var f=["","XL0","L0","M0","S0"];var D=S.exec(d);var g=c._getSpanXLChanged();var k=c._getIndentXLChanged();var n=c.getDefaultIndent();var o=I.exec(n);for(var i=0;i<b.length;i++){r.write("<div");var L=c._getLayoutDataForControl(b[i]);var C=false;if(L){var B=false;if(L.getLinebreak()===true){r.addClass("sapUiRespGridBreak");}else{if(L.getLinebreakXL()===true){B=true;r.addClass("sapUiRespGridBreakXL");}if(L.getLinebreakL()===true){if(!B&&!L._getLinebreakXLChanged()){r.addClass("sapUiRespGridBreakXL");}r.addClass("sapUiRespGridBreakL");}if(L.getLinebreakM()===true){r.addClass("sapUiRespGridBreakM");}if(L.getLinebreakS()===true){r.addClass("sapUiRespGridBreakS");}}var t;var u;var x=L.getSpan();if(!x||!x.lenght==0){t=D;}else{t=S.exec(x);if(/XL/gi.test(x)){C=true;}}if(t){for(var j=1;j<t.length;j++){var y=t[j];if(!y){y=D[j];if(!y){y=e[j];}}if(y.substr(0,1)==="L"){u=y.substr(1,2);}var z=L.getSpanXL();var A=L.getSpanL();var E=L.getSpanM();var F=L.getSpanS();y=y.toUpperCase();if((y.substr(0,2)==="XL")&&(z>0)&&(z<13)){r.addClass("sapUiRespGridSpanXL"+z);C=true;}else if((y.substr(0,1)==="L")&&(A>0)&&(A<13)){r.addClass("sapUiRespGridSpanL"+A);u=A;}else if((y.substr(0,1)==="M")&&(E>0)&&(E<13)){r.addClass("sapUiRespGridSpanM"+E);}else if((y.substr(0,1)==="S")&&(F>0)&&(F<13)){r.addClass("sapUiRespGridSpanS"+F);}else{if((y.substr(0,2)!=="XL")||g||C){r.addClass("sapUiRespGridSpan"+y);}}}if(!g&&!C){r.addClass("sapUiRespGridSpanXL"+u);}}var H;var J;var K=L.getIndent();if(!K||K.length==0){H=o;}else{H=I.exec(K);if(/XL/gi.test(K)){k=true;}}if(!H){H=o;if(!H){H=undefined;}}var N=L.getIndentXL();var O=L.getIndentL();var P=L.getIndentM();var Q=L.getIndentS();if(H){for(var j=1;j<H.length;j++){var T=H[j];if(!T){if(o&&o[j]){T=o[j];}else{T=f[j];}}if(T){T=T.toUpperCase();if(T.substr(0,1)==="L"){J=T.substr(1,2);}if((T.substr(0,2)==="XL")&&(N>0)&&(N<12)){r.addClass("sapUiRespGridIndentXL"+N);k=true;}else if((T.substr(0,1)==="L")&&(O>0)&&(O<12)){r.addClass("sapUiRespGridIndentL"+O);J=O;}else if((T.substr(0,1)==="M")&&(P>0)&&(P<12)){r.addClass("sapUiRespGridIndentM"+P);}else if((T.substr(0,1)==="S")&&(Q>0)&&(Q<12)){r.addClass("sapUiRespGridIndentS"+Q);}else{if(!(/^(XL0)? ?(L0)? ?(M0)? ?(S0)?$/.exec(T))){r.addClass("sapUiRespGridIndent"+T);}}}}if(!k){if(J&&J>0){r.addClass("sapUiRespGridIndentXL"+J);}}}var l=L.getVisibleL(),m=L.getVisibleM(),s=L.getVisibleS();if(!l&&m&&s){r.addClass("sapUiRespGridHiddenL");r.addClass("sapUiRespGridHiddenXL");}else if(!l&&!m&&s){r.addClass("sapUiRespGridVisibleS");}else if(l&&!m&&!s){r.addClass("sapUiRespGridVisibleL");r.addClass("sapUiRespGridVisibleXL");}else if(!l&&m&&!s){r.addClass("sapUiRespGridVisibleM");}else if(l&&!m&&s){r.addClass("sapUiRespGridHiddenM");}else if(l&&m&&!s){r.addClass("sapUiRespGridHiddenS");}var U=L.getMoveBackwards();if(U&&U.length>0){var V=I.exec(U);if(V){for(var j=1;j<V.length;j++){var W=V[j];if(W){r.addClass("sapUiRespGridBwd"+W.toUpperCase());}}}}var X=L.getMoveForward();if(X&&X.length>0){var Y=I.exec(X);if(Y){for(var j=1;j<Y.length;j++){var Z=Y[j];if(Z){r.addClass("sapUiRespGridFwd"+Z.toUpperCase());}}}}if(L._sStylesInternal){r.addClass(L._sStylesInternal);}}if(!L){var y="";if(D){for(var j=1;j<D.length;j++){y=D[j];if(!y){if((j==1)&&(D[j+1])){y="X"+D[j+1];}else{y=e[j];}}r.addClass("sapUiRespGridSpan"+y.toUpperCase());}}else{for(var j=1;j<e.length;j++){y=e[j];r.addClass("sapUiRespGridSpan"+y.toUpperCase());}}var T="";if(o){for(var j=1;j<o.length;j++){T=o[j];if(!T){if((j==1)&&(o[j+1])){T="X"+o[j+1];}else{T=f[j];}}if(((T.substr(0,1)!=="X")&&(T.substr(1,1)!=="0"))||((T.substr(0,1)=="X")&&(T.substr(2,1)!=="0"))){r.addClass("sapUiRespGridIndent"+T.toUpperCase());}}}}r.writeClasses();r.write(">");r.renderControl(b[i]);r.write("</div>");}r.write("</div>");};return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.HorizontalLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.HorizontalLayoutRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/HorizontalLayoutRenderer",['jquery.sap.global'],function(q){"use strict";var H={};H.render=function(r,c){var a=r;var n=!c.getAllowWrapping();a.write("<div");a.writeControlData(c);a.addClass("sapUiHLayout");if(n){a.addClass("sapUiHLayoutNoWrap");}a.writeClasses();a.write(">");var C=c.getContent();for(var i=0;i<C.length;i++){if(n){a.write("<div class='sapUiHLayoutChildWrapper'>");}a.renderControl(C[i]);if(n){a.write("</div>");}}a.write("</div>");};return H;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.ResponsiveFlowLayoutRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/ResponsiveFlowLayoutRenderer",['jquery.sap.global'],function(q){"use strict";var R={};(function(){R.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiRFL");r.writeClasses();var s=c._getAccessibleRole();var a;if(s){a={role:s};}r.writeAccessibilityState(c,a);r.write(">");r.write("</div>");};}());return R;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.SplitterRenderer')){jQuery.sap.declare('sap.ui.layout.SplitterRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/SplitterRenderer",['jquery.sap.global'],function(q){"use strict";var S={};S.render=function(r,c){var h=c.getOrientation()===sap.ui.core.Orientation.Horizontal;var o=h?"sapUiLoSplitterH":"sapUiLoSplitterV";var a=sap.ui.getCore().getConfiguration().getAnimation();r.write("<div");r.writeControlData(c);r.addClass("sapUiLoSplitter");r.addClass(o);if(a&&!c._liveResize){r.addClass("sapUiLoSplitterAnimated");}r.writeClasses();r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");this.renderInitialContent(r,c);r.write("</div>");};S.renderInitialContent=function(r,c){var I=c.getId();var h=c.getOrientation()===sap.ui.core.Orientation.Horizontal;var s=h?"width":"height";var g="sap-icon://"+(h?"horizontal":"vertical")+"-grip";var C=c.getContentAreas();var l=C.length;var a=c.getCalculatedSizes();for(var i=0;i<l;++i){var L=C[i].getLayoutData();var b="0";if(a[i]){b=a[i]+"px";}else if(L){b=L.getSize();}r.write("<section "+"id=\""+I+"-content-"+i+"\" "+"style=\""+s+": "+b+";\" "+"class=\"sapUiLoSplitterContent\">");r.renderControl(C[i]);r.write("</section>");if(i<l-1){r.write("<div id=\""+I+"-splitbar-"+i+"\" "+"role=\"separator\" "+"title=\""+c._getText("SPLITTER_MOVE")+"\" "+"class=\"sapUiLoSplitterBar\" "+"aria-orientation=\""+(h?"vertical":"horizontal")+"\" "+"tabindex=\"0\">");r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-"+i+"-icon","title":null,"aria-label":null});r.write("</div>");}}r.write("<div id=\""+I+"-overlay\" class=\"sapUiLoSplitterOverlay\" style=\"display: none;\">"+"<div id=\""+I+"-overlayBar\" class=\"sapUiLoSplitterOverlayBar\">");r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-Overlay-icon","title":null,"aria-label":null});r.write("</div>"+"</div>");};return S;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.VerticalLayout.designtime')){jQuery.sap.declare('sap.ui.layout.VerticalLayout.designtime');sap.ui.define("sap/ui/layout/VerticalLayout.designtime",[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);};if(!jQuery.sap.isDeclared('sap.ui.layout.VerticalLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.VerticalLayoutRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/VerticalLayoutRenderer",['jquery.sap.global'],function(q){"use strict";var V={};V.render=function(r,v){var a=r;a.write("<DIV");a.writeControlData(v);a.addClass("sapUiVlt");a.addClass("sapuiVlt");if(v.getWidth()&&v.getWidth()!=''){a.addStyle("width",v.getWidth());}a.writeStyles();a.writeClasses();a.write(">");var c=v.getContent();for(var i=0;i<c.length;i++){a.write("<DIV class=\"sapUiVltCell sapuiVltCell\">");a.renderControl(c[i]);a.write("</DIV>");}a.write("</DIV>");};return V;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.Form.designtime')){jQuery.sap.declare('sap.ui.layout.form.Form.designtime');sap.ui.define("sap/ui/layout/form/Form.designtime",[],function(){"use strict";return{aggregations:{formContainers:{getAggregationDomRef:function(a){if(this.getLayout()instanceof sap.ui.layout.form.GridLayout){return":sap-domref tbody";}else{return":sap-domref > div";}}}}};},false);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormContainer.designtime')){jQuery.sap.declare('sap.ui.layout.form.FormContainer.designtime');sap.ui.define("sap/ui/layout/form/FormContainer.designtime",[],function(){"use strict";return{aggregations:{formElements:{domRef:":sap-domref"}}};},false);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.form.FormLayoutRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/FormLayoutRenderer",['jquery.sap.global'],function(q){"use strict";var F={};F.render=function(r,l){var a=r;var f=l.getParent();if(f&&f instanceof sap.ui.layout.form.Form){this.renderForm(a,l,f);}};F.renderForm=function(r,l,f){var t=f.getToolbar();r.write("<div");r.writeControlData(l);r.addClass(this.getMainClass());if(t){r.addClass("sapUiFormToolbar");}this.addBackgroundClass(r,l);r.writeClasses();r.write(">");if(t){r.renderControl(t);}else{var s=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormTitleSize');this.renderTitle(r,f.getTitle(),undefined,false,s,f.getId());}this.renderContainers(r,l,f);r.write("</div>");};F.getMainClass=function(){return"sapUiFormLayout";};F.addBackgroundClass=function(r,l){var b=l.getBackgroundDesign();if(b!=sap.ui.layout.BackgroundDesign.Transparent){r.addClass("sapUiFormBackgr"+b);}};F.renderContainers=function(r,l,f){var c=f.getFormContainers();for(var i=0,a=c.length;i<a;i++){var C=c[i];if(C.getVisible()){this.renderContainer(r,l,C);}}};F.renderContainer=function(r,l,c){var e=c.getExpandable();var t=c.getToolbar();var T=c.getTitle();r.write("<section");r.writeElementData(c);r.addClass("sapUiFormContainer");if(t){r.addClass("sapUiFormContainerToolbar");}else if(T){r.addClass("sapUiFormContainerTitle");}if(c.getTooltip_AsString()){r.writeAttributeEscaped('title',c.getTooltip_AsString());}r.writeClasses();this.writeAccessibilityStateContainer(r,c);r.write(">");if(t){r.renderControl(t);}else{this.renderTitle(r,T,c._oExpandButton,e,sap.ui.core.TitleLevel.H4,c.getId());}if(e){r.write("<div id='"+c.getId()+"-content'");if(!c.getExpanded()){r.addStyle("display","none");r.writeStyles();}r.write(">");}var E=c.getFormElements();for(var j=0,a=E.length;j<a;j++){var o=E[j];if(o.getVisible()){this.renderElement(r,l,o);}}if(e){r.write("</div>");}r.write("</section>");};F.renderElement=function(r,l,e){var L=e.getLabelControl();r.write("<div");r.writeElementData(e);r.addClass("sapUiFormElement");if(L){r.addClass("sapUiFormElementLbl");}r.writeClasses();r.write(">");if(L){r.renderControl(L);}var f=e.getFields();if(f&&f.length>0){for(var k=0,a=f.length;k<a;k++){var o=f[k];r.renderControl(o);}}r.write("</div>");};F.renderTitle=function(r,t,e,E,l,c){if(t){var L=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormSubTitleSize');if(l){L=l;}if(typeof t!=="string"&&t.getLevel()!=sap.ui.core.TitleLevel.Auto){L=t.getLevel();}r.write("<"+L+" ");r.addClass("sapUiFormTitle");r.addClass("sapUiFormTitle"+L);if(typeof t!=="string"){r.writeElementData(t);if(t.getTooltip_AsString()){r.writeAttributeEscaped('title',t.getTooltip_AsString());}if(t.getEmphasized()){r.addClass("sapUiFormTitleEmph");}}else{r.writeAttribute("id",c+"--title");}r.writeClasses();r.write(">");if(E&&e){r.renderControl(e);}if(typeof t==="string"){r.writeEscaped(t,true);}else{var i=t.getIcon();if(i){var C=[];var a={"title":null};a["id"]=t.getId()+"-ico";r.writeIcon(i,C,a);}r.writeEscaped(t.getText(),true);}r.write("</"+L+">");}};F.writeAccessibilityStateContainer=function(r,c){var a={role:"form"};var t=c.getTitle();var T=c.getToolbar();if(T){if(!c.getAriaLabelledBy()||c.getAriaLabelledBy().length==0){a["labelledby"]=T.getId();}}else if(t){var i="";if(typeof t=="string"){i=c.getId()+"--title";}else{i=t.getId();}a["labelledby"]=i;}r.writeAccessibilityState(c,a);};return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormRenderer')){jQuery.sap.declare('sap.ui.layout.form.FormRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/FormRenderer",['jquery.sap.global'],function(q){"use strict";var F={};F.render=function(r,f){var a=r;var l=f.getLayout();a.write("<div");a.writeControlData(f);a.addClass("sapUiForm");a.writeAttribute("data-sap-ui-customfastnavgroup","true");var c=sap.ui.layout.form.FormHelper.addFormClass();if(c){a.addClass(c);}if(f.getEditable()){a.addClass("sapUiFormEdit");a.addClass("sapUiFormEdit-CTX");}if(f.getWidth()){a.addStyle("width",f.getWidth());}if(f.getTooltip_AsString()){a.writeAttributeEscaped('title',f.getTooltip_AsString());}a.writeClasses();a.writeStyles();var A={role:"form"};var t=f.getTitle();var T=f.getToolbar();if(T){if(!f.getAriaLabelledBy()||f.getAriaLabelledBy().length==0){A["labelledby"]=T.getId();}}else if(t){var i="";if(typeof t=="string"){i=f.getId()+"--title";}else{i=t.getId();}A["labelledby"]={value:i,append:true};}a.writeAccessibilityState(f,A);a.write(">");if(l){a.renderControl(l);}else{q.sap.log.warning("Form \""+f.getId()+"\" - Layout missing!","Renderer","Form");}a.write("</div>");};return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.GridLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.form.GridLayoutRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/layout/form/GridLayoutRenderer",['jquery.sap.global','sap/ui/core/Renderer','./FormLayoutRenderer'],function(q,R,F){"use strict";var G=R.extend(F);G.renderForm=function(r,l,f){var s=l.getSingleColumn();var c=16;var S=false;var C=0;var a=f.getFormContainers();var b=a.length;var i=0;var o;var d;var t=f.getToolbar();var T=f.getTitle();if(s){c=c/2;C=c;}else{C=c/2;for(i=0;i<b;i++){d=this.getContainerData(l,a[i]);if(d&&d.getHalfGrid()){S=true;break;}}}r.write("<table role=\"presentation\"");r.writeControlData(l);r.write(" cellpadding=\"0\" cellspacing=\"0\"");r.addStyle("border-collapse","collapse");r.addStyle("table-layout","fixed");r.addStyle("width","100%");r.addClass("sapUiGrid");this.addBackgroundClass(r,l);if(t){r.addClass("sapUiFormToolbar");}r.writeStyles();r.writeClasses();r.write(">");r.write("<colgroup>");r.write("<col span="+C+">");if(S){r.write("<col class = \"sapUiGridSpace\"span=1>");}if(!s){r.write("<col span="+C+">");}r.write("</colgroup><tbody>");if(t||T){var e=c;if(S){e++;}r.write("<tr class=\"sapUiGridTitle\"><th colspan="+e+">");if(t){r.renderControl(t);}else{var g=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:sapUiFormTitleSize');this.renderTitle(r,T,undefined,false,g,f.getId());}r.write("</th></tr>");}i=0;var h;var j;while(i<b){o=a[i];o._checkProperties();if(o.getVisible()){d=this.getContainerData(l,o);if(d&&d.getHalfGrid()&&!s){h=a[i+1];j=undefined;if(h&&h.getVisible()){j=this.getContainerData(l,h);}if(j&&j.getHalfGrid()){h._checkProperties();this.renderContainerHalfSize(r,l,o,h,c);i++;}else{this.renderContainerHalfSize(r,l,o,undefined,c);}}else{this.renderContainerFullSize(r,l,o,c,S);}}i++;}if(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==9){r.write("<tr style=\"visibility:hidden;\">");for(i=0;i<c;i++){r.write("<td style=\"visibility:hidden; padding:0; height: 0;\"></td>");}if(S){r.write("<td style=\"visibility:hidden; padding:0; height: 0;\"></td>");}r.write("</tr>");}r.write("</tbody></table>");};G.renderContainerFullSize=function(r,l,c,C,s){var e=c.getExpandable();var t=c.getTooltip_AsString();var T=c.getToolbar();var o=c.getTitle();if(T||o){var a=C;if(s){a++;}r.write("<tr class=\"sapUiGridConteinerFirstRow\"><td colspan="+a);r.addClass("sapUiGridHeader");if(t){r.writeAttributeEscaped('title',t);}if(T){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(T){r.renderControl(T);}else{this.renderTitle(r,c.getTitle(),c._oExpandButton,e,false,c.getId());}r.write("</td></tr>");}if(!e||c.getExpanded()){var E=c.getFormElements();var b;var d=[];var f;var g=false;for(var j=0,h=E.length;j<h;j++){b=E[j];if(b.getVisible()){f=d[0]&&(d[0][0]==C);r.write("<tr");if(!g){g=true;if(!T&&!o){r.addClass("sapUiGridConteinerFirstRow");}}if(!this.checkFullSizeElement(l,b)&&d[0]!="full"&&!f){r.writeElementData(b);r.addClass("sapUiFormElement");}r.writeClasses();r.write(">");if(!f){d=this.renderElement(r,l,b,false,C,s,d);}else{d.splice(0,1);}r.write("</tr>");if(d[0]=="full"||f){j=j-1;}}}if(d.length>0){for(var i=0;i<d.length;i++){r.write("<tr></tr>");}}}};G.renderContainerHalfSize=function(r,l,c,C,a){var b=a/2;var e=c.getExpandable();var t=c.getTooltip_AsString();var T;var o=c.getTitle();var d;var f=c.getToolbar();var g;var E=[];if(!e||c.getExpanded()){E=c.getFormElements();}var L=E.length;var h=[];var j=0;var k=false;if(C){k=C.getExpandable();T=C.getTooltip_AsString();d=C.getTitle();g=C.getToolbar();if(!k||C.getExpanded()){h=C.getFormElements();}j=h.length;}if(o||d||f||g){r.write("<tr class=\"sapUiGridConteinerFirstRow\"><td colspan="+b);r.addClass("sapUiGridHeader");if(t){r.writeAttributeEscaped('title',t);}if(f){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(f){r.renderControl(f);}else if(o){this.renderTitle(r,o,c._oExpandButton,e,false,c.getId());}r.write("</td><td></td><td colspan="+b);r.addClass("sapUiGridHeader");if(T){r.writeAttributeEscaped('title',T);}if(g){r.addClass("sapUiFormContainerToolbar");}else if(d){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(g){r.renderControl(g);}else if(d){this.renderTitle(r,d,C._oExpandButton,k,false,C.getId());}r.write("</td></tr>");}if((!e||c.getExpanded())||(!k||C.getExpanded())){var m=[],n=[];var p=0,s=0;var u;var v;var w;var x;var y=false;while(p<L||s<j){u=E[p];v=h[s];w=m[0]&&(m[0][0]==b);x=n[0]&&(n[0][0]==b);if((u&&u.getVisible())||(v&&v.getVisible())||w||x){r.write("<tr");if(!y){y=true;if(!f&&!o&&!g&&!d){r.addClass("sapUiGridConteinerFirstRow");}}r.writeClasses();r.write(">");if(!w){if(u&&u.getVisible()&&(!e||c.getExpanded())){m=this.renderElement(r,l,u,true,b,false,m);}else{r.write("<td colspan="+b+"></td>");}if(m[0]!="full"){p++;}}else{if(m[0][2]>0){r.write("<td colspan="+m[0][2]+"></td>");}m.splice(0,1);}r.write("<td></td>");if(!x){if(v&&v.getVisible()&&(!k||C.getExpanded())){n=this.renderElement(r,l,v,true,b,false,n);}else{r.write("<td colspan="+b+"></td>");}if(n[0]!="full"){s++;}}else{if(n[0][2]>0){r.write("<td colspan="+n[0][2]+"></td>");}n.splice(0,1);}r.write("</tr>");}else{p++;s++;}}if(m.length>0||n.length>0){for(var i=0;i<m.length||i<n.length;i++){r.write("<tr></tr>");}}}};G.renderElement=function(r,l,e,h,c,s,a){var L=e.getLabelControl();var b=0;var f=e.getFields();var C=0;var A=0;var m=false;var d=1;var g=1;var x=0;if(this.checkFullSizeElement(l,e)){if(a.length>0&&a[0]!="full"){q.sap.log.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");return a;}if(s){c=c+1;}if(L&&a[0]!="full"){r.write("<td colspan="+c+" class=\"sapUiFormElementLbl sapUiGridLabelFull\">");r.renderControl(L);r.write("</td>");return["full"];}else{a.splice(0,1);g=this.getElementData(l,f[0]).getVCells();r.write("<td colspan="+c);if(g>1&&h){r.write(" rowspan="+g);for(x=0;x<g-1;x++){a.push([c,undefined,false]);}}r.write(" >");r.renderControl(f[0]);r.write("</td>");return a;}}if(a.length>0&&a[0][0]>0){c=c-a[0][0]+a[0][2];m=a[0][1];b=a[0][2];a.splice(0,1);}var j=b;var E;var k="";if(L||b>0){j=3;if(L&&b==0){E=this.getElementData(l,L);if(E){k=E.getHCells();if(k!="auto"&&k!="full"){j=parseInt(k,10);}}}r.write("<td colspan="+j+" class=\"sapUiFormElementLbl\">");if(L){r.renderControl(L);}c=c-j;r.write("</td>");}if(f&&f.length>0){var n=c;var o=f.length;var p;var i=0;var t=0;for(i=0,t=f.length;i<t;i++){p=f[i];E=this.getElementData(l,p);if(E&&E.getHCells()!="auto"){n=n-parseInt(E.getHCells(),10);o=o-1;}}var u=0;for(i=0,u=0,t=f.length;i<t;i++){p=f[i];E=this.getElementData(l,p);k="auto";d=1;g=1;if(E){k=E.getHCells();g=E.getVCells();}if(k=="auto"){if(n>0){d=Math.floor(n/o);if(d<1){d=1;}u++;A=A+d;if((u==o)&&(n>A)){d=d+(n-A);}}else{d=1;}}else{d=parseInt(k,10);}C=C+d;if(C>c){q.sap.log.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");C=C-d;break;}if(g>1){for(x=0;x<g-1;x++){if(L){b=j;}if(a.length>x){a[x][0]=a[x][0]+d;a[x][2]=b;}else{a.push([j+d,undefined,b]);}}}if(s&&C>=Math.floor(c/2)&&!m){d=d+1;m=true;if(g>1){for(x=0;x<g-1;x++){a[x][1]=true;}}}r.write("<td");if(d>1){r.write(" colspan="+d);}if(g>1){r.write(" rowspan="+g);}r.write(" >");r.renderControl(p);r.write("</td>");}}if(C<c){var v=c-C;if(!h&&s&&!m){v++;}r.write("<td colspan="+v+" ></td>");}return a;};G.checkFullSizeElement=function(l,e){var f=e.getFields();if(f.length==1&&this.getElementData(l,f[0])&&this.getElementData(l,f[0]).getHCells()=="full"){return true;}else{return false;}};G.getContainerData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");};G.getElementData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridElementData");};return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveGridLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.form.ResponsiveGridLayoutRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/layout/form/ResponsiveGridLayoutRenderer",['jquery.sap.global','sap/ui/core/Renderer','./FormLayoutRenderer'],function(q,R,F){"use strict";var a=R.extend(F);a.getMainClass=function(){return"sapUiFormResGrid";};a.renderContainers=function(r,l,f){var c=f.getFormContainers();var v=[];var L=0;for(var i=0;i<c.length;i++){var C=c[i];if(C.getVisible()){L++;v.push(C);}}if(L>0){if(L>1||!l.getSingleContainerFullSize()){r.renderControl(l._mainGrid);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};return a;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveLayoutRenderer')){jQuery.sap.declare('sap.ui.layout.form.ResponsiveLayoutRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/layout/form/ResponsiveLayoutRenderer",['jquery.sap.global','sap/ui/core/Renderer','./FormLayoutRenderer'],function(q,R,F){"use strict";var a=R.extend(F);a.getMainClass=function(){return"sapUiFormResLayout";};a.renderContainers=function(r,l,f){var c=f.getFormContainers();var v=[];var L=0;for(var i=0;i<c.length;i++){var C=c[i];if(C.getVisible()){L++;v.push(C);}}if(L>0){if(L>1){r.renderControl(l._mainRFLayout);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};return a;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.SimpleFormRenderer')){jQuery.sap.declare('sap.ui.layout.form.SimpleFormRenderer');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/SimpleFormRenderer",['jquery.sap.global'],function(q){"use strict";var S={};S.render=function(r,c){c._bChangedByMe=true;r.write("<div");r.writeControlData(c);r.addClass("sapUiSimpleForm");if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.writeClasses();r.write(">");var f=c.getAggregation("form");r.renderControl(f);r.write("</div>");c._bChangedByMe=false;};return S;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.library')){jQuery.sap.declare('sap.ui.layout.library');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.DataType');jQuery.sap.require('sap.ui.core.library');sap.ui.define("sap/ui/layout/library",['jquery.sap.global','sap/ui/base/DataType','sap/ui/core/library'],function(q,D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.layout",version:"1.36.9",dependencies:["sap.ui.core"],types:["sap.ui.layout.BackgroundDesign","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.BlockBackgroundType","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout"],interfaces:[],controls:["sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm"],elements:["sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.form.GridElementData"]});sap.ui.layout.BackgroundDesign={Solid:"Solid",Transparent:"Transparent",Translucent:"Translucent"};sap.ui.layout.GridIndent=D.createType('sap.ui.layout.GridIndent',{isValid:function(v){return/^(([Xx][Ll](?:[0-9]|1[0-1]))? ?([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.GridPosition={Left:"Left",Right:"Right",Center:"Center"};sap.ui.layout.GridSpan=D.createType('sap.ui.layout.GridSpan',{isValid:function(v){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.BlockBackgroundType={Default:"Default",Light:"Light"};sap.ui.layout.form=sap.ui.layout.form||{};sap.ui.layout.form.GridElementCells=D.createType('sap.ui.layout.form.GridElementCells',{isValid:function(v){return/^(auto|full|([1-9]|1[0-6]))$/.test(v);}},D.getType('string'));sap.ui.layout.form.SimpleFormLayout={ResponsiveLayout:"ResponsiveLayout",GridLayout:"GridLayout",ResponsiveGridLayout:"ResponsiveGridLayout"};sap.ui.layout.SideContentVisibility={AlwaysShow:"AlwaysShow",ShowAboveL:"ShowAboveL",ShowAboveM:"ShowAboveM",ShowAboveS:"ShowAboveS",NeverShow:"NeverShow"};sap.ui.layout.SideContentFallDown={BelowXL:"BelowXL",BelowL:"BelowL",BelowM:"BelowM",OnMinimumWidth:"OnMinimumWidth"};sap.ui.layout.SideContentPosition={End:"End",Begin:"Begin"};if(!sap.ui.layout.form.FormHelper){sap.ui.layout.form.FormHelper={createLabel:function(t){throw new Error("no Label control available!");},createButton:function(i,p){throw new Error("no Button control available!");},setButtonContent:function(b,t,T,i,I){throw new Error("no Button control available!");},addFormClass:function(){return null;},setToolbar:function(t){return t;},bArrowKeySupport:true,bFinal:false};}return sap.ui.layout;});};if(!jQuery.sap.isDeclared('sap.ui.layout.FixFlex')){jQuery.sap.declare('sap.ui.layout.FixFlex');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.EnabledPropagator');jQuery.sap.require('sap.ui.core.ResizeHandler');sap.ui.define("sap/ui/layout/FixFlex",["jquery.sap.global","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/ResizeHandler","./library"],function(q,C,E,R,l){"use strict";var F=C.extend("sap.ui.layout.FixFlex",{metadata:{library:"sap.ui.layout",properties:{vertical:{type:"boolean",group:"Appearance",defaultValue:true},fixFirst:{type:"boolean",group:"Misc",defaultValue:true},fixContentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minFlexSize:{type:"int",defaultValue:0}},aggregations:{fixContent:{type:"sap.ui.core.Control",multiple:true,singularName:"fixContent"},flexContent:{type:"sap.ui.core.Control",multiple:false}}}});E.call(F.prototype);F.prototype._handlerResizeNoFlexBoxSupport=function(){var c=this.$(),f,$;if(!c.is(":visible")){return;}f=this.$("Fixed");$=this.$("Flexible");f.removeAttr("style");$.removeAttr("style");if(this.getVertical()){$.height(Math.floor(c.height()-f.height()));}else{$.width(Math.floor(c.width()-f.width()));f.width(Math.floor(f.width()));}};F.prototype._deregisterControl=function(){if(this.sResizeListenerNoFlexBoxSupportId){R.deregister(this.sResizeListenerNoFlexBoxSupportId);this.sResizeListenerNoFlexBoxSupportId=null;}if(this.sResizeListenerNoFlexBoxSupportFixedId){R.deregister(this.sResizeListenerNoFlexBoxSupportFixedId);this.sResizeListenerNoFlexBoxSupportFixedId=null;}if(this.sResizeListenerFixFlexScroll){R.deregister(this.sResizeListenerFixFlexScroll);this.sResizeListenerFixFlexScroll=null;}if(this.sResizeListenerFixFlexScrollFlexPart){R.deregister(this.sResizeListenerFixFlexScrollFlexPart);this.sResizeListenerFixFlexScrollFlexPart=null;}};F.prototype._changeScrolling=function(){var n,d,$=this.$(),a=this.getMinFlexSize();if(this.getVertical()===true){n=this.$().height()-this.$("Fixed").height();d="height";}else{n=this.$().width()-this.$("Fixed").width();d="width";}if(n<parseInt(this.getMinFlexSize(),10)){$.addClass("sapUiFixFlexScrolling");$.removeClass("sapUiFixFlexInnerScrolling");if(this.$("FlexibleContainer").children().height()>a){this.$("Flexible").attr("style","min-"+d+":"+a+"px");}else{this.$("Flexible").attr("style",d+":"+a+"px");}}else{$.addClass("sapUiFixFlexInnerScrolling");$.removeClass("sapUiFixFlexScrolling");this.$("Flexible").removeAttr("style");}};F.prototype.exit=function(){this._deregisterControl();};F.prototype.onBeforeRendering=function(){this._deregisterControl();};F.prototype.onAfterRendering=function(){if(!q.support.hasFlexBoxSupport){this.sResizeListenerNoFlexBoxSupportFixedId=R.register(this.getDomRef("Fixed"),q.proxy(this._handlerResizeNoFlexBoxSupport,this));this.sResizeListenerNoFlexBoxSupportId=R.register(this.getDomRef(),q.proxy(this._handlerResizeNoFlexBoxSupport,this));this._handlerResizeNoFlexBoxSupport();}if(this.getMinFlexSize()!==0){this.sResizeListenerFixFlexScroll=R.register(this.getDomRef(),q.proxy(this._changeScrolling,this));this.sResizeListenerFixFlexScrollFlexPart=R.register(this.getDomRef("Fixed"),q.proxy(this._changeScrolling,this));if(sap.ui.Device.browser.edge===true){this._changeScrolling();}}};F.prototype.ontouchmove=function(e){e.setMarked();};return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.Grid')){jQuery.sap.declare('sap.ui.layout.Grid');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/Grid",['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";var G=C.extend("sap.ui.layout.Grid",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},vSpacing:{type:"float",group:"Dimension",defaultValue:1},hSpacing:{type:"float",group:"Dimension",defaultValue:1},position:{type:"sap.ui.layout.GridPosition",group:"Dimension",defaultValue:"Left"},defaultSpan:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:"XL3 L3 M6 S12"},defaultIndent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:"XL0 L0 M0 S0"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});(function(){G.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._indentXLChanged=false;this._spanXLChanged=false;};G.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this,q.proxy(this._onParentResize,this));this._onParentResize();}else{sap.ui.Device.media.attachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);}};G.prototype.onBeforeRendering=function(){this._cleanup();};G.prototype.exit=function(){this._cleanup();};G.prototype._cleanup=function(){if(this._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}sap.ui.Device.media.detachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);};G.prototype._handleMediaChange=function(p){this._toggleClass(p.name);};G.prototype._setBreakPointTablet=function(b){this._iBreakPointTablet=b;};G.prototype._setBreakPointDesktop=function(b){this._iBreakPointDesktop=b;};G.prototype._setBreakPointLargeDesktop=function(b){this._iBreakPointLargeDesktop=b;};G.prototype.setDefaultIndent=function(d){if(/XL/gi.test(d)){this._setIndentXLChanged(true);}this.setProperty("defaultIndent",d);};G.prototype._setIndentXLChanged=function(c){this._indentXLChanged=c;};G.prototype._getIndentXLChanged=function(){return this._indentXLChanged;};G.prototype.setDefaultSpan=function(d){if(/XL/gi.test(d)){this._setSpanXLChanged(true);}this.setProperty("defaultSpan",d);};G.prototype._setSpanXLChanged=function(c){this._spanXLChanged=c;};G.prototype._getSpanXLChanged=function(){return this._spanXLChanged;};G.prototype._onParentResize=function(){var d=this.getDomRef();if(!d){this._cleanup();return;}if(!q(d).is(":visible")){return;}var c=d.clientWidth;if(c<=this._iBreakPointTablet){this._toggleClass("Phone");}else if((c>this._iBreakPointTablet)&&(c<=this._iBreakPointDesktop)){this._toggleClass("Tablet");}else if((c>this._iBreakPointDesktop)&&(c<=this._iBreakPointLargeDesktop)){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}};G.prototype._toggleClass=function(m){var d=this.$();if(!d){return;}if(d.hasClass("sapUiRespGridMedia-Std-"+m)){return;}d.toggleClass("sapUiRespGridMedia-Std-"+m,true);if(m==="Phone"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="Tablet"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="LargeDesktop"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false);}else{d.toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}this.fireEvent("mediaChanged",{media:m});};G.prototype._getLayoutDataForControl=function(c){var L=c.getLayoutData();if(!L){return undefined;}else if(L instanceof sap.ui.layout.GridData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var a=L.getMultipleLayoutData();for(var i=0;i<a.length;i++){var o=a[i];if(o instanceof sap.ui.layout.GridData){return o;}}}};G.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};G.prototype._getAccessibleRole=function(){return null;};}());return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.GridData')){jQuery.sap.declare('sap.ui.layout.GridData');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/ui/layout/GridData",['jquery.sap.global','sap/ui/core/LayoutData','./library'],function(q,L,l){"use strict";var G=L.extend("sap.ui.layout.GridData",{metadata:{library:"sap.ui.layout",properties:{span:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:null},spanXL:{type:"int",group:"Behavior",defaultValue:null},spanL:{type:"int",group:"Behavior",defaultValue:null},spanM:{type:"int",group:"Behavior",defaultValue:null},spanS:{type:"int",group:"Behavior",defaultValue:null},indent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:null},indentXL:{type:"int",group:"Behavior",defaultValue:null},indentL:{type:"int",group:"Behavior",defaultValue:null},indentM:{type:"int",group:"Behavior",defaultValue:null},indentS:{type:"int",group:"Behavior",defaultValue:null},visibleXL:{type:"boolean",group:"Behavior",defaultValue:true},visibleL:{type:"boolean",group:"Behavior",defaultValue:true},visibleM:{type:"boolean",group:"Behavior",defaultValue:true},visibleS:{type:"boolean",group:"Behavior",defaultValue:true},moveBackwards:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},moveForward:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},linebreak:{type:"boolean",group:"Misc",defaultValue:false},linebreakXL:{type:"boolean",group:"Misc",defaultValue:false},linebreakL:{type:"boolean",group:"Misc",defaultValue:false},linebreakM:{type:"boolean",group:"Misc",defaultValue:false},linebreakS:{type:"boolean",group:"Misc",defaultValue:false},spanLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},visibleOnLarge:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnMedium:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnSmall:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true}}}});(function(){G.prototype._setStylesInternal=function(s){if(s&&s.length>0){this._sStylesInternal=s;}else{this._sStylesInternal=undefined;}};G.prototype._getEffectiveSpanXLarge=function(){var s=this.getSpanXL();if(s&&(s>0)&&(s<13)){return s;}var S=/XL([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,2)==="XL"){return parseInt(b.substr(2),10);}}}return undefined;};G.prototype._getEffectiveSpanLarge=function(){var s=this.getSpanL();if(s&&(s>0)&&(s<13)){return s;}var S=/\bL([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="L"){return parseInt(b.substr(1),10);}}}return undefined;};G.prototype._getEffectiveSpanMedium=function(){var s=this.getSpanM();if(s&&(s>0)&&(s<13)){return s;}var S=/M([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="M"){return parseInt(b.substr(1),10);}}}return undefined;};G.prototype._getEffectiveSpanSmall=function(){var s=this.getSpanS();if(s&&(s>0)&&(s<13)){return s;}var S=/S([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="S"){return parseInt(b.substr(1),10);}}}return undefined;};G.prototype.init=function(){this._bLinebreakXLChanged=false;};G.prototype.setLinebreakXL=function(b){this.setProperty("linebreakXL",b);this._bLinebreakXLChanged=true;};G.prototype._getLinebreakXLChanged=function(){return this._bLinebreakXLChanged;};G.prototype.setSpanLarge=function(s){this.setSpanL(s);q.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");};G.prototype.setSpanMedium=function(s){this.setSpanM(s);q.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");};G.prototype.setSpanSmall=function(s){this.setSpanS(s);q.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");};G.prototype.setIndentLarge=function(i){this.setIndentL(i);q.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");};G.prototype.setIndentMedium=function(i){this.setIndentM(i);q.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");};G.prototype.setIndentSmall=function(i){this.setIndentS(i);q.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");};G.prototype.setVisibleOnLarge=function(v){this.setVisibleL(v);q.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");};G.prototype.setVisibleOnMedium=function(v){this.setVisibleM(v);q.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");};G.prototype.setVisibleOnSmall=function(v){this.setVisibleS(v);q.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");};G.prototype.getSpanLarge=function(){q.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");return this.getSpanL();};G.prototype.getSpanMedium=function(){q.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.getSpanM();};G.prototype.getSpanSmall=function(){q.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.getSpanS();};G.prototype.getIndentLarge=function(){q.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.getIndentL();};G.prototype.getIndentMedium=function(){q.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.getIndentM();};G.prototype.getIndentSmall=function(){q.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.getIndentS();};G.prototype.getVisibleOnLarge=function(){q.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.getVisibleL();};G.prototype.getVisibleOnMedium=function(){q.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.getVisibleM();};G.prototype.getVisibleOnSmall=function(){q.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.getVisibleS();};}());return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.HorizontalLayout')){jQuery.sap.declare('sap.ui.layout.HorizontalLayout');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/HorizontalLayout",['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";var H=C.extend("sap.ui.layout.HorizontalLayout",{metadata:{library:"sap.ui.layout",properties:{allowWrapping:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});return H;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayoutData')){jQuery.sap.declare('sap.ui.layout.ResponsiveFlowLayoutData');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/ui/layout/ResponsiveFlowLayoutData",['jquery.sap.global','sap/ui/core/LayoutData','./library'],function(q,L,l){"use strict";var R=L.extend("sap.ui.layout.ResponsiveFlowLayoutData",{metadata:{library:"sap.ui.layout",properties:{minWidth:{type:"int",group:"Misc",defaultValue:100},weight:{type:"int",group:"Misc",defaultValue:1},linebreak:{type:"boolean",group:"Misc",defaultValue:false},margin:{type:"boolean",group:"Misc",defaultValue:true},linebreakable:{type:"boolean",group:"Misc",defaultValue:true}}}});R.MIN_WIDTH=100;R.WEIGHT=1;R.LINEBREAK=false;R.MARGIN=true;R.LINEBREAKABLE=true;R.prototype.setWeight=function(w){if(w>=1){this.setProperty("weight",w);}else{q.sap.log.warning("Values smaller than 1 are invalid. Default value '1' is used instead",this);this.setProperty("weight",R.WEIGHT);}return this;};R.prototype.setLinebreak=function(b){if(this.getLinebreakable()==false&&b){q.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreak",b);}};R.prototype.setLinebreakable=function(b){if(this.getLinebreak()===true&&b===false){q.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreakable",b);}};return R;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.Splitter')){jQuery.sap.declare('sap.ui.layout.Splitter');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/Splitter",['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";var S=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:sap.ui.core.Orientation.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}}}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");S.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc"),decrease:this._onKeyboardResize.bind(this,"dec"),increaseMore:this._onKeyboardResize.bind(this,"incMore"),decreaseMore:this._onKeyboardResize.bind(this,"decMore"),max:this._onKeyboardResize.bind(this,"max"),min:this._onKeyboardResize.bind(this,"min")};this._enableKeyboardListeners();this._isPreserved=false;sap.ui.getCore().getEventBus().subscribe("sap.ui","__preserveContent",this._preserveHandler,this);};S.prototype.exit=function(){sap.ui.getCore().getEventBus().unsubscribe("sap.ui","__preserveContent",this._preserveHandler);this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};S.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};S.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};S.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var c=this;sap.ui.getCore().attachInit(function(){c._resizeHandlerId=sap.ui.core.ResizeHandler.register(c,c._resizeCallback);});this._delayedResize();};S.prototype.disableAutoResize=function(t){sap.ui.core.ResizeHandler.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};S.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};S.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};S.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};S.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};S.prototype.onBeforeRendering=function(){this._switchOrientation();};S.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._isPreserved=false;this._resize();};S.prototype.onLayoutDataChange=function(){this._delayedResize();};S.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};S.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};S.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var $=q(j.target);var c=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this.getContentAreas();var L=e[B].getLayoutData();var o=e[B+1].getLayoutData();if(!L.getResizable()||!o.getResizable()){a(t);return;}var R=0-d;for(var i=0;i<=B;++i){R+=c[i]+d;}this._move={start:p,relStart:R,barNum:B,bar:q(j.target),c1Size:c[B],c1MinSize:L?parseInt(L.getMinSize(),10):0,c2Size:c[B+1],c2MinSize:o?parseInt(o.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};S.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var d=(p-this._move.start);d=this._bRtl?-d:d;var c=this._move.c1Size+d;var f=this._move.c2Size-d;var i=(c>=0&&f>=0&&c>=this._move.c1MinSize&&f>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+d);if(this._liveResize){var m=(this._move["start"]-e[this._moveCord]);this._resizeContents(this._move["barNum"],this._bRtl?m:-m,false);}}};S.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var m=this._move["start"]-p;this._resizeContents(this._move["barNum"],this._bRtl?m:-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");this._$SplitterOverlay.detach();document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);q.sap.focus(this._move.bar);};S.prototype._resizeContents=function(L,p,f){if(isNaN(p)){q.sap.log.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var c=this.getContentAreas();var o=c[L].getLayoutData();var d=c[L+1].getLayoutData();var s=o.getSize();var e=d.getSize();var $=this.$("content-"+L);var g=this.$("content-"+(L+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var m=parseInt(o.getMinSize(),10);var M=parseInt(d.getMinSize(),10);var D;if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&e!=="auto"){d.setSize(N+"px");}else if(s!=="auto"&&e==="auto"){o.setSize(n+"px");}else{o.setSize(n+"px");d.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");g.css(this._sizeType,N+"px");}};S.prototype._preserveHandler=function(c,e,d){var D=this.getDomRef();if(D&&d.domNode.contains(D)){this._isPreserved=true;}};S.prototype._delayedResize=function(d){if(d===undefined){d=0;}if(this.getDomRef()){q.sap.clearDelayedCall(this._resizeTimeout);q.sap.delayedCall(d,this,this._resize,[]);}};S.prototype._resizeBars=function(c){var i,B;var $=this.$();for(i=0;i<c.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<c.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};S.prototype._resize=function(){if(this._isPreserved){return;}var i=0,B;var c=this.getContentAreas();this._resizeBars(c);var o=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var L=true;for(i=0;i<c.length;++i){var $=this.$("content-"+i);var d=c[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var e=d.getLayoutData();var f=e&&e.getResizable();if(i>0){var R=f&&L;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!R);B.attr("tabindex",R&&this._keyboardEnabled?"0":"-1");B.attr("title",R?this._getText("SPLITTER_MOVE"):"");}L=f;}this._resizeBars(c);if(_(o,n)){this.fireResize({oldSizes:o,newSizes:n});}};S.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var c=s[i];if(c.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;f-=A;var d=s.length-1;var e=0;for(i=0;i<d;++i){e+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return f-e;};S.prototype._recalculateSizes=function(){var i,s,L,c,d;var e=[];var f=this.getContentAreas();for(i=0;i<f.length;++i){L=f[i].getLayoutData();s=L?L.getSize():"auto";e.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(e);var g=[];var h=[];var p=[];for(i=0;i<e.length;++i){s=e[i];var j;if(s.indexOf("px")>-1){j=parseInt(s,10);A-=j;this._calculatedSizes[i]=j;}else if(s.indexOf("%")>-1){p.push(i);}else if(e[i]=="auto"){L=f[i].getLayoutData();if(L&&parseInt(L.getMinSize(),10)!=0){h.push(i);}else{g.push(i);}}else{q.sap.log.error("Illegal size value: "+e[i]);}}var w=false;if(A<0){w=true;A=0;}var R=A;var P=p.length;for(i=0;i<P;++i){d=p[i];c=Math.floor(parseFloat(e[d])/100*A,0);A-=c;this._calculatedSizes[d]=c;R-=c;}A=R;if(A<0){w=true;A=0;}c=Math.floor(A/(h.length+g.length),0);var k=h.length;for(i=0;i<k;++i){d=h[i];var m=parseInt(f[d].getLayoutData().getMinSize(),10);if(m>c){this._calculatedSizes[d]=m;A-=m;}else{this._calculatedSizes[d]=c;A-=c;}}if(A<0){w=true;A=0;}R=A;var n=g.length;c=Math.floor(A/n,0);for(i=0;i<n;++i){d=g[i];this._calculatedSizes[d]=c;R-=c;}if(w){q.sap.log.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};S.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===sap.ui.core.Orientation.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};S.prototype._onKeyboardResize=function(t,e){var B=this.getId()+"-splitbar-";if(!e||!e.target||!e.target.id||e.target.id.indexOf(B)!==0){return;}var s=20;var i=999999;var c=parseInt(e.target.id.substr(B.length),10);var m=this.getCalculatedSizes();this._move.c1Size=m[c];this._move.c2Size=m[c+1];var d=0;switch(t){case"inc":d=s;break;case"incMore":d=s*10;break;case"dec":d=0-s;break;case"decMore":d=0-s*10;break;case"max":d=i;break;case"min":d=0-i;break;default:q.sap.log.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(c,d,true);};S.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};S.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};S.prototype._getText=function(k,A){return(r?r.getText(k,A):k);};function _(s,c){if(s===c){return false;}if(!s||!c||s.length===undefined||c.length===undefined){return true;}if(s.length!=c.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==c[i]){return true;}}return false;}function a(t){var p=function(e){e.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}function b(c){var L=c.getLayoutData();if(L&&(!L.getResizable||!L.getSize||!L.getMinSize)){q.sap.log.warning("Content \""+c.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");L=null;}if(!L){c.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}S.prototype.invalidate=function(o){var f=(o&&this.indexOfContentArea(o)!=-1)||(o&&o instanceof sap.ui.core.CustomData&&o.getWriteToDom())||(o===undefined);if(f||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};S.prototype.setOrientation=function(o){var R=this.setProperty("orientation",o,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return R;};S.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};S.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};S.prototype.addContentArea=function(c){this._needsInvalidation=true;b(c);return this.addAggregation("contentAreas",c);};S.prototype.removeContentArea=function(c){this._needsInvalidation=true;return this.removeAggregation("contentAreas",c);};S.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.destroyAllAggregation("contentAreas");};S.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};S.prototype.insertContentArea=function(c,i){this._needsInvalidation=true;b(c);return this.insertAggregation("contentAreas",c,i);};return S;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.SplitterLayoutData')){jQuery.sap.declare('sap.ui.layout.SplitterLayoutData');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/ui/layout/SplitterLayoutData",['jquery.sap.global','sap/ui/core/LayoutData','./library'],function(q,L,l){"use strict";var S=L.extend("sap.ui.layout.SplitterLayoutData",{metadata:{library:"sap.ui.layout",properties:{resizable:{type:"boolean",group:"Behavior",defaultValue:true},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},minSize:{type:"int",group:"Dimension",defaultValue:0}}}});return S;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.VerticalLayout')){jQuery.sap.declare('sap.ui.layout.VerticalLayout');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.EnabledPropagator');sap.ui.define("sap/ui/layout/VerticalLayout",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/EnabledPropagator','./library'],function(q,C,E,l){"use strict";var V=C.extend("sap.ui.layout.VerticalLayout",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designTime:true}});V.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){this.getDomRef().style.width=this.getWidth();}return this;};E.call(V.prototype);return V;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.Form')){jQuery.sap.declare('sap.ui.layout.form.Form');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/form/Form",['jquery.sap.global','sap/ui/core/Control','sap/ui/layout/library'],function(q,C,l){"use strict";var F=C.extend("sap.ui.layout.form.Form",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"formContainers",aggregations:{formContainers:{type:"sap.ui.layout.form.FormContainer",multiple:true,singularName:"formContainer"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},layout:{type:"sap.ui.layout.form.FormLayout",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});F.prototype.toggleContainerExpanded=function(c){var L=this.getLayout();if(L){L.toggleContainerExpanded(c);}};F.prototype.contentOnAfterRendering=function(f,c){var L=this.getLayout();if(L&&L.contentOnAfterRendering){L.contentOnAfterRendering(f,c);}};F.prototype.onLayoutDataChange=function(e){var L=this.getLayout();if(L&&L.onLayoutDataChange){L.onLayoutDataChange(e);}};F.prototype.onBeforeFastNavigationFocus=function(e){var L=this.getLayout();if(L&&L.onBeforeFastNavigationFocus){L.onBeforeFastNavigationFocus(e);}};F.prototype.setEditable=function(e){var o=this.getEditable();this.setProperty("editable",e,true);if(e!=o&&this.getDomRef()){if(e){this.$().addClass("sapUiFormEdit").addClass("sapUiFormEdit-CTX");this.$().removeAttr("aria-readonly");}else{this.$().removeClass("sapUiFormEdit").removeClass("sapUiFormEdit-CTX");this.$().attr("aria-readonly","true");}}return this;};F.prototype.setToolbar=function(t){t=sap.ui.layout.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};F.prototype.invalidate=function(o){if(!this._bNoInvalidate){C.prototype.invalidate.apply(this,arguments);}};F.prototype.getContainerRenderedDomRef=function(c){var L=this.getLayout();if(L&&L.getContainerRenderedDomRef){return L.getContainerRenderedDomRef(c);}else{return null;}};F.prototype.getElementRenderedDomRef=function(e){var L=this.getLayout();if(L&&L.getElementRenderedDomRef){return L.getElementRenderedDomRef(e);}else{return null;}};return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormContainer')){jQuery.sap.declare('sap.ui.layout.form.FormContainer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.core.EnabledPropagator');jQuery.sap.require('sap.ui.core.theming.Parameters');sap.ui.define("sap/ui/layout/form/FormContainer",['jquery.sap.global','sap/ui/core/Element','sap/ui/core/EnabledPropagator','sap/ui/core/theming/Parameters','sap/ui/layout/library'],function(q,E,a,P,l){"use strict";var F=E.extend("sap.ui.layout.form.FormContainer",{metadata:{library:"sap.ui.layout",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},expandable:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"formElements",aggregations:{formElements:{type:"sap.ui.layout.form.FormElement",multiple:true,singularName:"formElement"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});F.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");};F.prototype.exit=function(){if(this._oExpandButton){this._oExpandButton.destroy();delete this._oExpandButton;}this._rb=undefined;};F.prototype.setExpandable=function(e){this.setProperty("expandable",e);if(e){var t=this;if(!this._oExpandButton){this._oExpandButton=sap.ui.layout.form.FormHelper.createButton.call(this,this.getId()+"--Exp",b);this._oExpandButton.setParent(this);}_(t);}return this;};F.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);var t=this;_(t);var f=this.getParent();if(f&&f.toggleContainerExpanded){f.toggleContainerExpanded(t);}return this;};F.prototype.setToolbar=function(t){t=sap.ui.layout.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};F.prototype.contentOnAfterRendering=function(f,c){var p=this.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(f,c);}};F.prototype.onLayoutDataChange=function(e){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(e);}};F.prototype._checkProperties=function(){var r=0;if(this.getExpandable()&&(!this.getTitle()||this.getToolbar())){q.sap.log.warning("Expander only displayed if title is set",this.getId(),"FormContainer");r=1;}return r;};F.prototype.getRenderedDomRef=function(){var t=this;var f=this.getParent();if(f&&f.getContainerRenderedDomRef){return f.getContainerRenderedDomRef(t);}else{return null;}};F.prototype.getElementRenderedDomRef=function(e){var f=this.getParent();if(f&&f.getElementRenderedDomRef){return f.getElementRenderedDomRef(e);}else{return null;}};function _(c){if(!c._oExpandButton){return;}var i,I,t,T;if(c.getExpanded()){i=P.get('sapUiFormContainerColImageURL');I=P.get('sapUiFormContainerColImageDownURL');t="-";T=c._rb.getText("FORM_COLLAPSE");}else{i=P.get('sapUiFormContainerExpImageURL');I=P.get('sapUiFormContainerExpImageDownURL');t="+";T=c._rb.getText("FORM_EXPAND");}var m="sap.ui.layout.themes."+sap.ui.getCore().getConfiguration().getTheme();if(i){if(!sap.ui.core.IconPool.isIconURI(i)){i=q.sap.getModulePath(m,i);}t="";}if(I&&!sap.ui.core.IconPool.isIconURI(I)){I=q.sap.getModulePath(m,I);}sap.ui.layout.form.FormHelper.setButtonContent(c._oExpandButton,t,T,i,I);}function b(e){this.setExpanded(!this.getExpanded());}return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormElement')){jQuery.sap.declare('sap.ui.layout.form.FormElement');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.core.EnabledPropagator');sap.ui.define("sap/ui/layout/form/FormElement",['jquery.sap.global','sap/ui/core/Element','sap/ui/core/EnabledPropagator','sap/ui/layout/library'],function(q,E,a,l){"use strict";var F=E.extend("sap.ui.layout.form.FormElement",{metadata:{library:"sap.ui.layout",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"fields",aggregations:{label:{type:"sap.ui.core.Label",altTypes:["string"],multiple:false},fields:{type:"sap.ui.core.Control",multiple:true,singularName:"field"}}}});F.prototype.init=function(){this._oFieldDelegate={oElement:this,onAfterRendering:c};};F.prototype.exit=function(){if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}this._oFieldDelegate=undefined;};F.prototype.setLabel=function(A){if(!this._oLabel){var o=this.getLabel();if(o&&o.isRequired){o.isRequired=o._sapuiIsRequired;o._sapuiIsRequired=undefined;}}this.setAggregation("label",A);var L=A;if(typeof L==="string"){if(!this._oLabel){this._oLabel=sap.ui.layout.form.FormHelper.createLabel(L);this._oLabel.setParent(this);if(L.isRequired){this._oLabel.isRequired=_;}}else{this._oLabel.setText(L);}}else{if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}if(L&&L.isRequired){L._sapuiIsRequired=L.isRequired;L.isRequired=_;}}b(this);return this;};F.prototype.getLabelControl=function(){if(this._oLabel){return this._oLabel;}else{return this.getLabel();}};F.prototype.addField=function(f){this.addAggregation("fields",f);f.addDelegate(this._oFieldDelegate);b(this);return this;};F.prototype.insertField=function(f,i){this.insertAggregation("fields",f,i);f.addDelegate(this._oFieldDelegate);b(this);return this;};F.prototype.removeField=function(f){var r=this.removeAggregation("fields",f);r.removeDelegate(this._oFieldDelegate);b(this);return r;};F.prototype.removeAllFields=function(){var r=this.removeAllAggregation("fields");for(var i=0;i<r.length;i++){var R=r[i];R.removeDelegate(this._oFieldDelegate);}b(this);return r;};F.prototype.destroyFields=function(){var f=this.getFields();for(var i=0;i<f.length;i++){var o=f[i];o.removeDelegate(this._oFieldDelegate);}this.destroyAggregation("fields");b(this);return this;};F.prototype.updateFields=function(){var f=this.getFields();var o;var i=0;for(i=0;i<f.length;i++){o=f[i];o.removeDelegate(this._oFieldDelegate);}this.updateAggregation("fields");f=this.getFields();for(i=0;i<f.length;i++){o=f[i];o.addDelegate(this._oFieldDelegate);}b(this);return this;};F.prototype.enhanceAccessibilityState=function(e,A){var L=this.getLabelControl();if(L&&L!=e){var s=A["labelledby"];if(!s){s=L.getId();}else{var d=s.split(" ");if(q.inArray(L.getId(),d)<0){d.splice(0,0,L.getId());s=d.join(" ");}}A["labelledby"]=s;}return A;};F.prototype.onLayoutDataChange=function(e){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(e);}};F.prototype.getRenderedDomRef=function(){var t=this;var C=this.getParent();if(C&&C.getElementRenderedDomRef){return C.getElementRenderedDomRef(t);}else{return null;}};function _(){var f=this.getParent();var d=f.getFields();for(var i=0;i<d.length;i++){var o=d[i];if(o.getRequired&&o.getRequired()===true){return true;}}return false;}function b(f){var d=f.getFields();var o=d.length>0?d[0]:null;var L=f._oLabel;if(L){L.setAlternativeLabelFor(o);}L=f.getLabel();if(L instanceof sap.ui.core.Control){L.setAlternativeLabelFor(o);}}function c(e){var p=this.oElement.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(this.oElement,e.srcControl);}}return F;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.FormLayout')){jQuery.sap.declare('sap.ui.layout.form.FormLayout');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/form/FormLayout",['jquery.sap.global','sap/ui/core/Control','./Form','sap/ui/layout/library'],function(q,C,F,l){"use strict";var a=C.extend("sap.ui.layout.form.FormLayout",{metadata:{library:"sap.ui.layout",properties:{backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:sap.ui.layout.BackgroundDesign.Translucent}}}});a.prototype.contentOnAfterRendering=function(f,c){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){q(c.getFocusDomRef()).data("sap.InNavArea",true);}};a.prototype.toggleContainerExpanded=function(c){var e=c.getExpanded();if(this.getDomRef()){if(e){c.$("content").css("display","");}else{c.$("content").css("display","none");}}};a.prototype.getLayoutDataForElement=function(e,t){var L=e.getLayoutData();var c=q.sap.getObject(t);if(!L){return undefined;}else if(L instanceof c){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var b=L.getMultipleLayoutData();for(var i=0;i<b.length;i++){var o=b[i];if(o instanceof c){return o;}}}};a.prototype.onsapright=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();var t=this;if(!r){this.navigateForward(e,t);}else{this.navigateBack(e,t);}}};a.prototype.onsapleft=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();var t=this;if(!r){this.navigateBack(e,t);}else{this.navigateForward(e,t);}}};a.prototype.onsapdown=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){n=this.findFieldBelow(c,E);}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0);}if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsapup=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){n=this.findFieldAbove(c,E);}else if(E&&E instanceof sap.ui.layout.form.FormContainer){var f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsaphome=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i);if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsaptop=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();n=this.findFirstFieldOfForm(f);if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsapend=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i);if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsapbottom=function(e){if(sap.ui.layout.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var b=f.getFormContainers();var L=b.length;n=this.findLastFieldOfLastElementInPrevContainer(f,L-1);if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.onsapexpand=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o=E.getParent();if(o.getExpandable()){o.setExpanded(true);}};a.prototype.onsapcollapse=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o=E.getParent();if(o.getExpandable()){o.setExpanded(false);}};a.prototype.onsapskipforward=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.onsapskipback=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var b=f.getFormContainers();var i=f.indexOfFormContainer(o);while(!n&&i>=0){var p=b[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.onBeforeFastNavigationFocus=function(e){if(q.contains(this.getDomRef(),e.source)){e.srcControl=q(e.source).control(0);if(e.forward){this.onsapskipforward(e);}else{this.onsapskipback(e);}}else{var n=e.forward?this.findFirstFieldOfForm(this.getParent()):this.findFirstFieldOfLastContainerOfForm(this.getParent());if(n){q.sap.focus(n);e.preventDefault();}}};a.prototype.findElement=function(c){var e=c.getParent();var r=c;while(e&&!(e instanceof sap.ui.layout.form.FormElement)&&!(e&&e instanceof sap.ui.layout.form.FormContainer)&&!(e&&e instanceof F)){r=e;e=e.getParent();}return({rootControl:r,element:e});};a.prototype.navigateForward=function(e){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0);}if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.tabForward=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0,true);if(!n){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.findNextFieldOfElement=function(e,s,t){var f=e.getFields();var L=f.length;var n;for(var i=s;i<L;i++){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};a.prototype.findFirstFieldOfNextElement=function(c,s,t){var e=c.getFormElements();var L=e.length;var n;var i=s;while(!n&&i<L){var E=e[i];if(t==true){n=this.findNextFieldOfElement(E,0,true);}else{n=this.findNextFieldOfElement(E,0);}i++;}return n;};a.prototype.findFirstFieldOfForm=function(f){var c=f.getFormContainers();var n;var o=c[0];if(!o.getExpandable()||o.getExpanded()){n=this.findFirstFieldOfNextElement(o,0);}return n;};a.prototype.findFirstFieldOfLastContainerOfForm=function(f){var n;var c=f.getFormContainers();var i=c.length;while(!n&&i>=0){var p=c[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}return n;};a.prototype.findFirstFieldOfFirstElementInNextContainer=function(f,s,t){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L){var o=c[i];if(o.getExpandable()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){if(t==true){n=this.findFirstFieldOfNextElement(o,0,true);}else{n=this.findFirstFieldOfNextElement(o,0);}}i++;}return n;};a.prototype.findFirstFieldOfFirstElementInPrevContainer=function(f,s){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L&&i>=0){var o=c[i];if(!o.getExpandable()||o.getExpanded()){n=this.findFirstFieldOfNextElement(o,0);}i++;}return n;};a.prototype.navigateBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.tabBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);if(o.getExpandable()){n=o._oExpandButton.getFocusDomRef();}if(!n){n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}if(n){q.sap.focus(n);e.preventDefault();}};a.prototype.findPrevFieldOfElement=function(e,s,t){var f=e.getFields();var n;for(var i=s;i>=0;i--){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};a.prototype.findLastFieldOfPrevElement=function(c,s,t){var e=c.getFormElements();var n;var i=s;while(!n&&i>=0){var E=e[i];var L=E.getFields().length;if(t==true){n=this.findPrevFieldOfElement(E,L-1,true);}else{n=this.findPrevFieldOfElement(E,L-1);}i--;}return n;};a.prototype.findLastFieldOfLastElementInPrevContainer=function(f,s,t){var c=f.getFormContainers();var n;var i=s;while(!n&&i>=0){var o=c[i];if(o.getExpandable()&&!o.getExpanded()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){var L=o.getFormElements().length;if(t==true){n=this.findLastFieldOfPrevElement(o,L-1,true);}else{n=this.findLastFieldOfPrevElement(o,L-1,0);}}i--;}return n;};a.prototype.findFieldBelow=function(c,e){var o=e.getParent();var i=o.indexOfFormElement(e);var n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}return n;};a.prototype.findFieldAbove=function(c,e){var o=e.getParent();var b=o.indexOfFormElement(e);var E=o.getFormElements();var n;var i=b-1;while(!n&&i>=0){var m=E[i];n=this.findPrevFieldOfElement(m,0);i--;}if(!n){var f=o.getParent();b=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,b-1);}return n;};a.prototype._getDomRef=function(c){var d=c.getFocusDomRef();if(!q(d).is(":sapFocusable")){d=undefined;}return d;};a.prototype.getContainerRenderedDomRef=function(c){if(this.getDomRef()){return q.sap.domById(c.getId());}else{return null;}};a.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){return q.sap.domById(e.getId());}else{return null;}};return a;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.GridContainerData')){jQuery.sap.declare('sap.ui.layout.form.GridContainerData');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/ui/layout/form/GridContainerData",['jquery.sap.global','sap/ui/core/LayoutData','sap/ui/layout/library'],function(q,L,l){"use strict";var G=L.extend("sap.ui.layout.form.GridContainerData",{metadata:{library:"sap.ui.layout",properties:{halfGrid:{type:"boolean",group:"Misc",defaultValue:false}}}});return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.GridElementData')){jQuery.sap.declare('sap.ui.layout.form.GridElementData');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/ui/layout/form/GridElementData",['jquery.sap.global','sap/ui/core/LayoutData','sap/ui/layout/library'],function(q,L,l){"use strict";var G=L.extend("sap.ui.layout.form.GridElementData",{metadata:{library:"sap.ui.layout",properties:{hCells:{type:"sap.ui.layout.form.GridElementCells",group:"Appearance",defaultValue:'auto'},vCells:{type:"int",group:"Appearance",defaultValue:1}}}});return G;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.GridLayout')){jQuery.sap.declare('sap.ui.layout.form.GridLayout');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/GridLayout",['jquery.sap.global','./FormLayout','./GridContainerData','./GridElementData','sap/ui/layout/library'],function(q,F,G,a,l){"use strict";var b=F.extend("sap.ui.layout.form.GridLayout",{metadata:{library:"sap.ui.layout",properties:{singleColumn:{type:"boolean",group:"Misc",defaultValue:false}}}});b.prototype.toggleContainerExpanded=function(c){this.invalidate();};b.prototype.onAfterRendering=function(){var f=this.getParent();if(f){var c=f.getFormContainers();for(var i=0;i<c.length;i++){var C=c[i];if(C.getExpandable()){C._oExpandButton.$().attr("tabindex","-1");}}}};b.prototype.contentOnAfterRendering=function(f,c){F.prototype.contentOnAfterRendering.apply(this,arguments);if(c.getMetadata().getName()!="sap.ui.commons.Image"){c.$().css("width","100%");}};b.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};b.prototype.onsaptabnext=function(e){this.tabForward(e);};b.prototype.onsaptabprevious=function(e){this.tabBack(e);};b.prototype.findFieldOfElement=function(e,s,L){if(!L){return F.prototype.findPrevFieldOfElement.apply(this,arguments);}if(!e.getVisible()){return null;}var f=e.getFields();var n;var I=f.length;s=I-1;for(var i=s;i>=0;i--){var o=f[i];var c=o.$().offset().left;if(L<c&&i!=0){continue;}var d=this._getDomRef(o);if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}return n;};b.prototype.findFieldBelow=function(c,e){var C=e.getParent();var d=C.indexOfFormElement(e);var n;if(C.getVisible()){var E=C.getFormElements();var m=E.length;var i=d+1;var L=c.$().offset().left;while(!n&&i<m){var N=E[i];n=this.findFieldOfElement(N,0,L);i++;}}if(!n){var f=C.getParent();d=f.indexOfFormContainer(C);n=this.findFirstFieldOfFirstElementInNextContainer(f,d+1);}return n;};b.prototype.findFieldAbove=function(c,e){var C=e.getParent();var d=C.indexOfFormElement(e);var n;if(C.getVisible()){var E=C.getFormElements();var i=d-1;var L=c.$().offset().left;while(!n&&i>=0){var N=E[i];n=this.findFieldOfElement(N,0,L);i--;}}if(!n){var f=C.getParent();d=f.indexOfFormContainer(C);n=this.findLastFieldOfLastElementInPrevContainer(f,d-1);}return n;};b.prototype.getContainerRenderedDomRef=function(c){return null;};b.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){var s=this.getSingleColumn();var c=e.getParent();var C=this.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");var t=this;if((s||!C||!C.getHalfGrid())&&!this.getRenderer().checkFullSizeElement(t,e)){return q.sap.domById(e.getId());}}return null;};return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveGridLayout')){jQuery.sap.declare('sap.ui.layout.form.ResponsiveGridLayout');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/ResponsiveGridLayout",['jquery.sap.global','sap/ui/layout/Grid','sap/ui/layout/GridData','./FormLayout','sap/ui/layout/library'],function(q,G,a,F,l){"use strict";var R=F.extend("sap.ui.layout.form.ResponsiveGridLayout",{metadata:{library:"sap.ui.layout",properties:{labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600}}}});sap.ui.core.Control.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel",{metadata:{aggregations:{"content":{type:"sap.ui.layout.Grid",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},getLayoutData:function(){var C=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var o;if(L&&C){o=L.getLayoutDataForElement(C,"sap.ui.layout.GridData");}if(o){return o;}else{return this.getAggregation("layoutData");}},getCustomData:function(){var C=sap.ui.getCore().byId(this.getContainer());if(C){return C.getCustomData();}},refreshExpanded:function(){var C=sap.ui.getCore().byId(this.getContainer());if(C){if(C.getExpanded()){this.$().removeClass("sapUiRGLContainerColl");}else{this.$().addClass("sapUiRGLContainerColl");}}},renderer:function(r,p){var C=sap.ui.getCore().byId(p.getContainer());var L=sap.ui.getCore().byId(p.getLayout());var o=p.getContent();var E=C.getExpandable();var t=C.getTooltip_AsString();var T=C.getToolbar();var i=C.getTitle();r.write("<div");r.writeControlData(p);r.addClass("sapUiRGLContainer");if(E&&!C.getExpanded()){r.addClass("sapUiRGLContainerColl");}if(T){r.addClass("sapUiFormContainerToolbar");}else if(i){r.addClass("sapUiFormContainerTitle");}if(t){r.writeAttributeEscaped('title',t);}r.writeClasses();L.getRenderer().writeAccessibilityStateContainer(r,C);r.write(">");if(T){r.renderControl(T);}else if(C.getTitle()){L.getRenderer().renderTitle(r,i,C._oExpandButton,E,false,C.getId());}if(o){r.write("<div");r.addClass("sapUiRGLContainerCont");r.writeClasses();r.write(">");r.renderControl(o);r.write("</div>");}r.write("</div>");}});R.prototype.init=function(){this.mContainers={};this.oDummyLayoutData=new a(this.getId()+"--Dummy");};R.prototype.exit=function(){var t=this;for(var C in this.mContainers){h(t,C);}if(this._mainGrid){this._mainGrid.destroy();delete this._mainGrid;}this.oDummyLayoutData.destroy();this.oDummyLayoutData=undefined;};R.prototype.onBeforeRendering=function(E){var o=this.getParent();if(!o||!(o instanceof sap.ui.layout.form.Form)){return;}o._bNoInvalidate=true;var t=this;_(t,o);k(t,o);o._bNoInvalidate=false;};R.prototype.onAfterRendering=function(E){if(this._mainGrid&&this._mainGrid.__bIsUsed){for(var C in this.mContainers){if(this.mContainers[C][1]._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this.mContainers[C][1]._sContainerResizeListener);this.mContainers[C][1]._sContainerResizeListener=null;}}}};R.prototype.contentOnAfterRendering=function(o,C){F.prototype.contentOnAfterRendering.apply(this,arguments);if(C.getWidth&&(!C.getWidth()||C.getWidth()=="auto")&&C.getMetadata().getName()!="sap.ui.commons.Image"){C.$().css("width","100%");}};R.prototype.toggleContainerExpanded=function(C){var s=C.getId();if(this.mContainers[s]&&this.mContainers[s][0]){var p=this.mContainers[s][0];p.refreshExpanded();}};R.prototype.onLayoutDataChange=function(E){var s=E.srcControl;if(s instanceof sap.ui.layout.form.FormContainer){if(this._mainGrid){this._mainGrid.onLayoutDataChange(E);}}else if(!(s instanceof sap.ui.layout.form.FormElement)){var p=s.getParent();if(p instanceof sap.ui.layout.form.FormElement){var C=p.getParent();var i=C.getId();if(this.mContainers[i]&&this.mContainers[i][1]){this.mContainers[i][1].onLayoutDataChange(E);}}}};R.prototype.onsapup=function(E){this.onsapleft(E);};R.prototype.onsapdown=function(E){this.onsapright(E);};R.prototype.getContainerRenderedDomRef=function(C){if(this.getDomRef()){var s=C.getId();if(this.mContainers[s]){if(this.mContainers[s][0]){var p=this.mContainers[s][0];return p.getDomRef();}else if(this.mContainers[s][1]){var o=this.mContainers[s][1];return o.getDomRef();}}}return null;};R.prototype.getElementRenderedDomRef=function(E){return null;};function _(L,o){var C=o.getFormContainers();var j=C.length;var v=0;var V=0;var n=[];var p;var r;var s;var t;var i=0;for(i=0;i<j;i++){s=C[i];s._checkProperties();if(s.getVisible()){v++;n.push(s);}}for(i=0;i<v;i++){s=n[i];if(s.getVisible()){V++;t=s.getId();p=undefined;r=undefined;var u=n[i+1];if(L.mContainers[t]&&L.mContainers[t][1]){r=L.mContainers[t][1];}else{r=d(L,s);}var T=s.getTitle();var w=s.getToolbar();if(w||T||s.getExpandable()){if(L.mContainers[t]&&L.mContainers[t][0]){p=L.mContainers[t][0];}else{p=b(L,s,r);f(r,true);}g(p,s,V,u,v);}else{if(L.mContainers[t]&&L.mContainers[t][0]){c(L.mContainers[t][0]);}f(r,false);g(r,s,V,u,v);}L.mContainers[t]=[p,r];}}var O=m(L.mContainers);if(v<O){for(t in L.mContainers){var x=false;for(i=0;i<j;i++){s=C[i];if(t==s.getId()&&s.getVisible()){x=true;break;}}if(!x){h(L,t);}}}}function b(L,C,o){var s=C.getId();var p=new sap.ui.layout.form.ResponsiveGridLayoutPanel(s+"---Panel",{container:C,layout:L,content:o});return p;}function c(p){p.setContent("");p.setLayout("");p.setContainer("");p.destroy();}function d(L,C){var I=C.getId()+"--Grid";var o=new G(I,{vSpacing:0,hSpacing:0,containerQuery:true});o.__myParentLayout=L;o.__myParentContainerId=C.getId();o.addStyleClass("sapUiFormResGridCont");o.getContent=function(){var C=sap.ui.getCore().byId(this.__myParentContainerId);if(C){var n=[];var E=C.getFormElements();var p;var r;for(var i=0;i<E.length;i++){var s=E[i];if(s.getVisible()){r=s.getLabelControl();if(r){n.push(r);}p=s.getFields();for(var j=0;j<p.length;j++){n.push(p[j]);}}}return n;}else{return false;}};o._getLayoutDataForControl=function(j){var L=this.__myParentLayout;var n=L.getLayoutDataForElement(j,"sap.ui.layout.GridData");var E=j.getParent();var p=E.getLabelControl();if(n){if(p==j){n._setStylesInternal("sapUiFormElementLbl");}return n;}else{var C=sap.ui.getCore().byId(this.__myParentContainerId);var r=L.getLayoutDataForElement(C,"sap.ui.layout.GridData");var s=C.getParent();var t=L.getLabelSpanL();var u=L.getLabelSpanM();var v=L.getLabelSpanS();if(L.getAdjustLabelSpan()){if(s.getFormContainers().length>=1&&L.getColumnsM()>1){u=L.getLabelSpanL();}if(r){if(r._getEffectiveSpanLarge()==12){t=L.getLabelSpanM();u=L.getLabelSpanM();}}if(s.getFormContainers().length==1||L.getColumnsL()==1){t=L.getLabelSpanM();u=L.getLabelSpanM();}}var w=L.getLabelSpanXL();if(w<0){w=t;}if(p==j){L.oDummyLayoutData.setSpan("XL"+w+" L"+t+" M"+u+" S"+v);L.oDummyLayoutData.setLinebreak(true);L.oDummyLayoutData._setStylesInternal("sapUiFormElementLbl");return L.oDummyLayoutData;}else{var x=12-L.getEmptySpanL();var M=12-L.getEmptySpanM();var S=12-L.getEmptySpanS();var X=x;var y=L.getEmptySpanXL();if(y>-1){X=12-y;}var z;if(p){var A=L.getLayoutDataForElement(p,"sap.ui.layout.GridData");if(A){z=A._getEffectiveSpanLarge();if(z){t=z;}z=A._getEffectiveSpanXLarge();if(z){w=z;}if(w<0){w=t;}z=A._getEffectiveSpanMedium();if(z){u=z;}z=A._getEffectiveSpanSmall();if(z){v=z;}}if(w<12){X=X-w;}if(t<12){x=x-t;}if(u<12){M=M-u;}if(v<12){S=S-v;}}var B=E.getFields();var D=B.length;var H=1;var J=false;for(var i=0;i<D;i++){var K=B[i];if(K!=j){var N=L.getLayoutDataForElement(K,"sap.ui.layout.GridData");if(N){z=N._getEffectiveSpanLarge();if(z&&z<x){x=x-z;}var O=N._getEffectiveSpanXLarge();if(O){if(O<X){X=X-O;}}else{if(z&&z<X){X=X-z;}}z=N._getEffectiveSpanMedium();if(z&&z<M){M=M-z;}z=N._getEffectiveSpanSmall();if(z&&z<S){S=S-z;}}else{H++;}}else{if(H==1){J=true;}}}var P,Q,T,U=12;if(J){var V=X-Math.floor(X/H)*H;P=Math.floor(X/H)+V;V=x-Math.floor(x/H)*H;Q=Math.floor(x/H)+V;V=M-Math.floor(M/H)*H;T=Math.floor(M/H)+V;if(v<12){V=S-Math.floor(S/H)*H;U=Math.floor(S/H)+V;}}else{P=Math.floor(X/H);Q=Math.floor(x/H);T=Math.floor(M/H);if(v<12){U=Math.floor(S/H);}}L.oDummyLayoutData.setSpan("XL"+P+" L"+Q+" M"+T+" S"+U);L.oDummyLayoutData.setLinebreak(J&&!p);L.oDummyLayoutData._setStylesInternal(undefined);return L.oDummyLayoutData;}return n;}};o._onParentResizeOrig=o._onParentResize;o._onParentResize=function(){if(!this.getDomRef()){this._cleanup();return;}if(!q(this.getDomRef()).is(":visible")){return;}var L=this.__myParentLayout;if(!L._mainGrid||!L._mainGrid.__bIsUsed){var j=L.getParent().getFormContainers();var n;for(var i=0;i<j.length;i++){if(j[i].getVisible()){n=j[i];break;}}if(!n||!L.mContainers[n.getId()]||n.getId()!=this.__myParentContainerId){return;}if(L.mContainers[this.__myParentContainerId][0]){var D=L.mContainers[this.__myParentContainerId][0].getDomRef();var p=D.clientWidth;if(p<=L.getBreakpointM()){this._toggleClass("Phone");}else if((p>L.getBreakpointM())&&(p<=L.getBreakpointL())){this._toggleClass("Tablet");}else if((p>L.getBreakpointL())&&(p<=L.getBreakpointXL())){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}else{this._setBreakPointTablet(L.getBreakpointM());this._setBreakPointDesktop(L.getBreakpointL());this._setBreakPointLargeDesktop(L.getBreakpointXL());this._onParentResizeOrig();}}else{var $=L._mainGrid.$();if($.hasClass("sapUiRespGridMedia-Std-Phone")){this._toggleClass("Phone");}else if($.hasClass("sapUiRespGridMedia-Std-Tablet")){this._toggleClass("Tablet");}else if($.hasClass("sapUiRespGridMedia-Std-Desktop")){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}};o._getAccessibleRole=function(){var C=sap.ui.getCore().byId(this.__myParentContainerId);var L=this.__myParentLayout;if(L._mainGrid&&L._mainGrid.__bIsUsed&&!C.getToolbar()&&!C.getTitle()&&!C.getExpandable()){return"form";}};return o;}function e(o){if(o.__myParentContainerId){o.__myParentContainerId=undefined;}o.__myParentLayout=undefined;o.destroy();}function f(o,O){if(O){if(o.__originalGetLayoutData){o.getLayoutData=o.__originalGetLayoutData;delete o.__originalGetLayoutData;}}else if(!o.__originalGetLayoutData){o.__originalGetLayoutData=o.getLayoutData;o.getLayoutData=function(){var L=this.__myParentLayout;var C=sap.ui.getCore().byId(this.__myParentContainerId);var i;if(C){i=L.getLayoutDataForElement(C,"sap.ui.layout.GridData");}if(i){return i;}else{return this.getAggregation("layoutData");}};}}function g(C,o,v,i,V){var L;if(C instanceof sap.ui.layout.form.ResponsiveGridLayoutPanel){L=sap.ui.getCore().byId(C.getLayout());}else{L=C.__myParentLayout;}var j=L.getLayoutDataForElement(o,"sap.ui.layout.GridData");if(!j){var n=L.getColumnsM();var p=L.getColumnsL();var r=L.getColumnsXL();var s=(v%p)==1;var t=(v%p)==0;var u=v>(V-p+(V%p));var w=v<=p;var x=(v%n)==1;var y=(v%n)==0;var z=v>(V-n+(V%n));var A=v<=n;var B=false;var D=t;var E=u;var H=w;if(r>0){B=(v%r)==1;D=(v%r)==0;E=v>(V-r+(V%r));H=v<=r;}if(i){var I=L.getLayoutDataForElement(i,"sap.ui.layout.GridData");if(I&&(I.getLinebreak()||I.getLinebreakXL())){D=true;E=false;}if(I&&(I.getLinebreak()||I.getLinebreakL())){t=true;u=false;}if(I&&(I.getLinebreak()||I.getLinebreakM())){y=true;z=false;}}var S="";if(D){S="sapUiFormResGridLastContXL";}if(t){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContL";}if(y){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContM";}if(E){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowXL";}if(u){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowL";}if(z){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowM";}if(H){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowXL";}if(w){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowL";}if(A){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowM";}j=C.getLayoutData();if(!j){j=new a(C.getId()+"--LD",{linebreakL:s,linebreakM:x});C.setLayoutData(j);}else{j.setLinebreakL(s);j.setLinebreakM(x);}if(r>0){j.setLinebreakXL(B);}j._setStylesInternal(S);}}function h(L,C){var i=L.mContainers[C];var o=i[1];if(o){e(o);}var p=i[0];if(p){c(p);}delete L.mContainers[C];}function k(L,o){var C=o.getFormContainers();var v=[];var n;var p=0;var r=0;var i=0;var j=0;for(i=0;i<C.length;i++){n=C[i];if(n.getVisible()){p++;v.push(n);}}if(p>1||!L.getSingleContainerFullSize()){var s=Math.floor(12/L.getColumnsM());var S=Math.floor(12/L.getColumnsL());var t;var D="";var u=L.getColumnsXL();if(u>=0){t=Math.floor(12/u);D=D+"XL"+t+" ";}D=D+"L"+S+" M"+s+" S12";if(!L._mainGrid){L._mainGrid=new G(o.getId()+"--Grid",{defaultSpan:D,hSpacing:0,vSpacing:0,containerQuery:true}).setParent(L);L._mainGrid.addStyleClass("sapUiFormResGridMain");L._mainGrid._onParentResizeOrig=L._mainGrid._onParentResize;L._mainGrid._onParentResize=function(){this._onParentResizeOrig();for(var A in L.mContainers){L.mContainers[A][1]._onParentResize();}};}else{L._mainGrid.setDefaultSpan(D);var w=L._mainGrid.getContent();r=w.length;var E=false;for(i=0;i<r;i++){var x=w[i];n=undefined;if(x.getContainer){n=sap.ui.getCore().byId(x.getContainer());}else{n=sap.ui.getCore().byId(x.__myParentContainerId);}if(n&&n.getVisible()){var V=v[j];if(n!=V){E=true;break;}var y=L.mContainers[n.getId()];if(y[0]&&y[0]!=x){E=true;break;}if(!y[0]&&y[1]&&y[1]!=x){E=true;break;}j++;}else{L._mainGrid.removeContent(x);}}if(E){L._mainGrid.removeAllContent();r=0;}}L._mainGrid._setBreakPointTablet(L.getBreakpointM());L._mainGrid._setBreakPointDesktop(L.getBreakpointL());L._mainGrid._setBreakPointLargeDesktop(L.getBreakpointXL());L._mainGrid.__bIsUsed=true;if(r<p){var z=0;if(r>0){z=r--;}for(i=z;i<C.length;i++){n=C[i];if(n.getVisible()){var A=n.getId();if(L.mContainers[A]){if(L.mContainers[A][0]){L._mainGrid.addContent(L.mContainers[A][0]);}else if(L.mContainers[A][1]){L._mainGrid.addContent(L.mContainers[A][1]);}}}}}}else if(L._mainGrid){L._mainGrid.__bIsUsed=false;}}function m(o){var L=0;if(!Object.keys){q.each(o,function(){L++;});}else{L=Object.keys(o).length;}return L;}return R;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.SimpleForm')){jQuery.sap.declare('sap.ui.layout.form.SimpleForm');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/layout/form/SimpleForm",['jquery.sap.global','sap/ui/core/Control','sap/ui/layout/ResponsiveFlowLayoutData','./Form','./FormContainer','./FormElement','./FormLayout','sap/ui/layout/library'],function(q,C,R,F,a,b,c,l){"use strict";var S=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:sap.ui.layout.BackgroundDesign.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});S.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(O){this._origInvalidate(arguments);if(this._bIsBeingDestroyed){return;}var j=this.getParent();if(j){j._formInvalidated(O);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];};S.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}for(var i=0;i<this._aLayouts.length;i++){var L=sap.ui.getCore().byId(this._aLayouts[i]);if(L&&L.destroy){L.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];};S.prototype.onBeforeRendering=function(){this._bChangedByMe=true;if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}var i=this;var j=this.getAggregation("form");if(!j.getLayout()){_(i);}d(i);this._bChangedByMe=false;};S.prototype.onAfterRendering=function(){if(this.getLayout()==sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};S.prototype.setEditable=function(E){this._bChangedByMe=true;this.setProperty("editable",E,true);var i=this.getAggregation("form");i.setEditable(E);this._bChangedByMe=false;return this;};S.prototype.setToolbar=function(T){this._bChangedByMe=true;var i=this.getAggregation("form");i.setToolbar(T);this._bChangedByMe=false;return this;};S.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};S.prototype.indexOfContent=function(O){var j=this._aElements;if(j){for(var i=0;i<j.length;i++){if(j[i]==O){return i;}}}return-1;};S.prototype.addContent=function(E){this._bChangedByMe=true;E=this.validateAggregation("content",E,true);if(!this._aElements){this._aElements=[];}var L=this._aElements.length;var i;var j=this.getAggregation("form");var k;var A;var P;var B;if(E instanceof sap.ui.core.Title||E.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){k=t(this,E);j.addFormContainer(k);this._changedFormContainers.push(k);}else if(E.getMetadata().isInstanceOf("sap.ui.core.Label")){if(L>0){i=this._aElements[L-1];P=i.getParent();if(P instanceof b){k=P.getParent();}else if(P instanceof a){k=P;}}if(!k){k=t(this);j.addFormContainer(k);this._changedFormContainers.push(k);}A=p(this,k,E);}else{if(L>0){i=this._aElements[L-1];P=i.getParent();if(P instanceof b){k=P.getParent();A=P;B=g(this,E);if(B instanceof R&&!e(this,B)){if(B.getLinebreak()){A=p(this,k);}}}else if(P instanceof a){k=P;A=p(this,k);}}else{k=t(this);j.addFormContainer(k);this._changedFormContainers.push(k);A=p(this,k);}h(this,E,5,false,true);A.addField(E);x(this._changedFormElements,A);}this._aElements.push(E);E.attachEvent("_change",y,this);this.invalidate();this._bChangedByMe=false;return this;};S.prototype.insertContent=function(E,I){E=this.validateAggregation("content",E,true);if(!this._aElements){this._aElements=[];}var L=this._aElements.length;var N;if(I<0){N=0;}else if(I>L){N=L;}else{N=I;}if(N!==I){q.sap.log.warning("SimpleForm.insertContent: index '"+I+"' out of range [0,"+L+"], forced to "+N);}if(N==L){this.addContent(E);return this;}this._bChangedByMe=true;var O=this._aElements[N];var j=this.getAggregation("form");var k;var A;var B;var D;var G;var H=0;var J;var K;var M;var P;var i=0;var Q;if(E instanceof sap.ui.core.Title||E.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){if(I==0&&!(O instanceof sap.ui.core.Title||O.getMetadata().isInstanceOf("sap.ui.core.Toolbar"))){k=O.getParent().getParent();if(E instanceof sap.ui.core.Title){k.setTitle(E);}else{k.setToolbar(E);}}else{k=t(this,E);if(O instanceof sap.ui.core.Title||O.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){B=O.getParent();G=j.indexOfFormContainer(B);}else{D=O.getParent();B=D.getParent();G=j.indexOfFormContainer(B)+1;H=B.indexOfFormElement(D);if(!O.getMetadata().isInstanceOf("sap.ui.core.Label")){J=D.indexOfField(O);if(J>0||D.getLabel()){A=p(this,k);this._changedFormElements.push(A);x(this._changedFormElements,D);K=D.getFields();for(i=J;i<K.length;i++){Q=K[i];A.addField(Q);}H++;}}M=B.getFormElements();for(i=H;i<M.length;i++){k.addFormElement(M[i]);}}j.insertFormContainer(k,G);}this._changedFormContainers.push(k);}else if(E.getMetadata().isInstanceOf("sap.ui.core.Label")){if(O instanceof sap.ui.core.Title||E.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){B=O.getParent();G=j.indexOfFormContainer(B);P=j.getFormContainers();if(G==0){k=t(this);j.insertFormContainer(k,G);this._changedFormContainers.push(k);}else{k=P[G-1];}A=p(this,k,E);}else if(O.getMetadata().isInstanceOf("sap.ui.core.Label")){B=O.getParent().getParent();H=B.indexOfFormElement(O.getParent());A=r(this,B,E,H);}else{D=O.getParent();B=D.getParent();H=B.indexOfFormElement(D)+1;J=D.indexOfField(O);if(J==0&&!D.getLabel()){A=D;A.setLabel(E);h(this,E,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{A=r(this,B,E,H);x(this._changedFormElements,D);K=D.getFields();for(i=J;i<K.length;i++){Q=K[i];A.addField(Q);}}}this._changedFormElements.push(A);}else{if(O instanceof sap.ui.core.Title||E.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){B=O.getParent();G=j.indexOfFormContainer(B);if(G==0){k=t(this);j.insertFormContainer(k,G);this._changedFormContainers.push(k);}else{P=j.getFormContainers();k=P[G-1];}M=k.getFormElements();if(M.length==0){A=p(this,k);}else{A=M[M.length-1];}A.addField(E);}else if(O.getMetadata().isInstanceOf("sap.ui.core.Label")){D=O.getParent();k=D.getParent();H=k.indexOfFormElement(D);if(H==0){A=r(this,k,null,0);}else{M=k.getFormElements();A=M[H-1];}A.addField(E);}else{A=O.getParent();J=A.indexOfField(O);A.insertField(E,J);}x(this._changedFormElements,A);h(this,E,5,false,true);}this._aElements.splice(N,0,E);E.attachEvent("_change",y,this);this.invalidate();this._bChangedByMe=false;return this;};S.prototype.removeContent=function(E){var j=null;var I=-1;var i=0;if(this._aElements){if(typeof(E)=="string"){E=sap.ui.getCore().byId(E);}if(typeof(E)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==E){E=i;break;}}}if(typeof(E)=="number"){if(E<0||E>=this._aElements.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+E);}else{I=E;j=this._aElements[I];}}}if(j){this._bChangedByMe=true;var k=this.getAggregation("form");var A;var B;var D;var G;if(j instanceof sap.ui.core.Title||j.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){A=j.getParent();A.setTitle(null);A.setToolbar(null);if(I>0){D=A.getFormElements();var H=k.indexOfFormContainer(A);var P=k.getFormContainers()[H-1];if(D.length>0&&!D[0].getLabel()){var J=P.getFormElements();var L=J[J.length-1];G=D[0].getFields();for(i=0;i<G.length;i++){L.addField(G[i]);}x(this._changedFormElements,L);A.removeFormElement(D[0]);D[0].destroy();D.splice(0,1);}for(i=0;i<D.length;i++){P.addFormElement(D[i]);}x(this._changedFormContainers,P);k.removeFormContainer(A);A.destroy();}}else if(j.getMetadata().isInstanceOf("sap.ui.core.Label")){B=j.getParent();A=B.getParent();B.setLabel(null);var K=A.indexOfFormElement(B);if(K==0){if(B.getFields().lenght==0){A.removeFormElement(B);B.destroy();if(A.getFormElements().length==0){k.removeFormContainer(A);A.destroy();}}else{x(this._changedFormElements,B);}}else{D=A.getFormElements();var M=D[K-1];G=B.getFields();for(i=0;i<G.length;i++){M.addField(G[i]);}x(this._changedFormElements,M);A.removeFormElement(B);B.destroy();if(A.getFormElements().length==0){k.removeFormContainer(A);A.destroy();}}}else{B=j.getParent();B.removeField(j);if(B.getFields().length==0&&!B.getLabel()){A=B.getParent();A.removeFormElement(B);B.destroy();if(A.getFormElements().length==0){k.removeFormContainer(A);A.destroy();}}else{x(this._changedFormElements,B);}}this._aElements.splice(I,1);j.setParent(null);j.detachEvent("_change",y,this);o(this,j);this.invalidate();this._bChangedByMe=false;return j;}return null;};S.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var A=k.getFormContainers();for(i=0;i<A.length;i++){var B=A[i];B.setTitle(null);B.setToolbar(null);var D=B.getFormElements();for(var j=0;j<D.length;j++){var E=D[j];E.setLabel(null);E.removeAllFields();}B.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var G=this._aElements[i];o(this,G);G.detachEvent("_change",y,this);}var H=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return H;}else{return[];}};S.prototype.destroyContent=function(){var E=this.removeAllContent();if(E){this._bChangedByMe=true;for(var i=0;i<E.length;i++){E[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};S.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements;};S.prototype.setLayout=function(L){this._bChangedByMe=true;var O=this.getLayout();this.setProperty("layout",L);if(L!=O){var A=this;_(A);var B=this.getAggregation("form");var D=B.getFormContainers();var E;var G;var H;for(var i=0;i<D.length;i++){var I=D[i];this._changedFormContainers.push(I);H=I.getLayoutData();if(H){H.destroy();}n(this,I);E=I.getFormElements();for(var j=0;j<E.length;j++){var J=E[j];x(this._changedFormElements,J);H=J.getLayoutData();if(H){H.destroy();}m(this,J);var K=J.getLabel();if(K){o(this,K);h(this,K,this._iLabelWeight,false,true,this.getLabelMinWidth());}G=J.getFields();for(var k=0;k<G.length;k++){var M=G[k];o(this,M);h(this,M,5,false,true);}}}}this._bChangedByMe=false;return this;};S.prototype.clone=function(I){this._bChangedByMe=true;var k=C.prototype.clone.apply(this,arguments);var A=this.getContent();for(var i=0;i<A.length;i++){var E=A[i];var L=E.getLayoutData();var B=E.clone(I);if(L){if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var D=L.getMultipleLayoutData();for(var j=0;j<D.length;j++){if(e(this,D[j])){k._aLayouts.push(B.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(e(this,L)){k._aLayouts.push(B.getLayoutData().getId());}}k.addContent(B);}this._bChangedByMe=false;return k;};function _(T){var i=T.getAggregation("form");var L=i.getLayout();if(L){L.destroy();}switch(T.getLayout()){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:q.sap.require("sap.ui.layout.form.ResponsiveLayout");i.setLayout(new sap.ui.layout.form.ResponsiveLayout(T.getId()+"--Layout"));break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:q.sap.require("sap.ui.layout.form.GridLayout");q.sap.require("sap.ui.layout.form.GridContainerData");q.sap.require("sap.ui.layout.form.GridElementData");i.setLayout(new sap.ui.layout.form.GridLayout(T.getId()+"--Layout"));break;case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:q.sap.require("sap.ui.layout.form.ResponsiveGridLayout");q.sap.require("sap.ui.layout.GridData");i.setLayout(new sap.ui.layout.form.ResponsiveGridLayout(T.getId()+"--Layout"));break;default:break;}}function d(T){T._changedFormContainers=[];var L=T.getLayout();var j=T.getAggregation("form").getLayout();j.setBackgroundDesign(T.getBackgroundDesign());switch(L){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:T._applyLinebreaks();break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:w(T);break;case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:j.setLabelSpanXL(T.getLabelSpanXL());j.setLabelSpanL(T.getLabelSpanL());j.setLabelSpanM(T.getLabelSpanM());j.setLabelSpanS(T.getLabelSpanS());j.setAdjustLabelSpan(T.getAdjustLabelSpan());j.setEmptySpanXL(T.getEmptySpanXL());j.setEmptySpanL(T.getEmptySpanL());j.setEmptySpanM(T.getEmptySpanM());j.setEmptySpanS(T.getEmptySpanS());j.setColumnsXL(T.getColumnsXL());j.setColumnsL(T.getColumnsL());j.setColumnsM(T.getColumnsM());j.setSingleContainerFullSize(T.getSingleContainerFullSize());j.setBreakpointXL(T.getBreakpointXL());j.setBreakpointL(T.getBreakpointL());j.setBreakpointM(T.getBreakpointM());break;default:break;}for(var i=0;i<T._changedFormElements.length;i++){var k=T._changedFormElements[i];switch(L){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:u(T,k);break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:break;default:break;}v(T,k);}T._changedFormElements=[];}function e(T,L){var i=L.getId(),j=" "+T._aLayouts.join(" ")+" ";return j.indexOf(" "+i+" ")>-1;}function f(T,W,L,i,M){var j=new R({weight:W,linebreak:L===true,linebreakable:i===true});if(M){j.setMinWidth(M);}T._aLayouts.push(j.getId());return j;}function g(T,i){var L;switch(T.getLayout()){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:L=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:L=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.GridElementData");break;case sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout:L=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.GridData");break;default:break;}return L;}function h(T,i,W,L,j,M){var k;switch(T.getLayout()){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:k=g(T,i);if(!k||!e(T,k)){k=i.getLayoutData();if(k&&k.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){k.addMultipleLayoutData(f(T,W,L,j,M));}else if(!k){i.setLayoutData(f(T,W,L,j,M));}else{q.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:break;default:break;}}function m(T,E){switch(T.getLayout()){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:E.setLayoutData(new R({linebreak:true,margin:false}));break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:break;default:break;}}function n(T,i){switch(T.getLayout()){case sap.ui.layout.form.SimpleFormLayout.ResponsiveLayout:i.setLayoutData(new R({minWidth:280}));break;case sap.ui.layout.form.SimpleFormLayout.GridLayout:if(T.getMaxContainerCols()>1){i.setLayoutData(new sap.ui.layout.form.GridContainerData({halfGrid:true}));}else{i.setLayoutData(new sap.ui.layout.form.GridContainerData({halfGrid:false}));}break;default:break;}}function o(T,E){var L=g(T,E);if(L){var j=L.getId();for(var i=0;i<T._aLayouts.length;i++){var I=T._aLayouts[i];if(j==I){L.destroy();T._aLayouts.splice(i,1);break;}}}}function p(T,i,L){var E=s(T,L);i.addFormElement(E);return E;}function r(T,i,L,I){var E=s(T,L);i.insertFormElement(E,I);return E;}function s(T,L){var E=new b();m(T,E);if(L){L.addStyleClass("sapUiFormLabel-CTX");E.setLabel(L);if(!g(T,L)){h(T,L,T._iLabelWeight,false,true,T.getLabelMinWidth());}}E.setVisible(false);return E;}function t(T,i){var j=new a();n(T,j);if(i){if(i instanceof sap.ui.core.Title){j.setTitle(i);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}function u(T,E){var M=T._iMaxWeight;var j=E.getFields();var k;var L=j.length;var A=E.getLabel();var B;var i=0;if(A&&g(T,A)){M=M-g(T,A).getWeight();}for(i=0;i<j.length;i++){k=j[i];B=g(T,k);if(B instanceof R&&!e(T,B)){M=M-B.getWeight();L--;}}var W=Math.floor(M/L);var D=M%L;for(i=0;i<j.length;i++){k=j[i];B=g(T,k);var G=W;if(!B){h(T,k,G,false,i==0);}else if(e(T,B)&&B instanceof R){if(D>0){G++;D--;}B.setWeight(G);}}}function v(T,E){var j=E.getFields();var V=false;for(var i=0;i<j.length;i++){var k=j[i];if(!k.getVisible||k.getVisible()){V=true;break;}}if(E.getVisible()!=V){E.setVisible(V);}}S.prototype._applyLinebreaks=function(){var j=this.getAggregation("form"),k=j.getFormContainers();var D=this.getDomRef();var A=this.$();for(var i=1;i<k.length;i++){var B=k[i],L=B.getLayoutData();if(!D||A.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){L.setLinebreak(true);}else{L.setLinebreak(false);}}else{L.setLinebreak(true);}}if(D&&A.css("visibility")=="hidden"){var E=this;setTimeout(function(){if(E.getDomRef()){E.$().css("visibility","");}},10);}};function w(T){var j=T.getAggregation("form");var k=j.getFormContainers();var L=k.length;for(var i=0;i<L;i++){var A=k[i];if((i==L-1)&&(L%2>0)){A.getLayoutData().setHalfGrid(false);}else if(!A.getLayoutData().getHalfGrid()){A.getLayoutData().setHalfGrid(true);}}}S.prototype._resize=function(){this._bChangedByMe=true;if(this._iCurrentWidth==this.$().outerWidth()){return;}this._iCurrentWidth=this.$().outerWidth();this._applyLinebreaks();this._bChangedByMe=false;};function x(j,k){var A=false;for(var i=0;i<j.length;i++){var B=j[i];if(B==k){A=true;break;}}if(!A){j.push(k);}}function y(E){if(E.getParameter("name")=="visible"){var i=E.oSource.getParent();v(this,i);}}function z(A){var E=[];var B=A.getFormContainers();for(var i=0;i<B.length;i++){var D=B[i];var T=D.getTitle();if(T){E.push(T);}var G=D.getFormElements();for(var j=0;j<G.length;j++){var H=G[j];var L=H.getLabel();if(L){E.push(L);}var I=H.getFields();for(var k=0;k<I.length;k++){var J=I[k];E.push(J);}}}return E;}S.prototype._formInvalidated=function(O){if(!this._bChangedByMe){var k=z(this.getAggregation("form"));var i=0;var j=0;var A=false;if(!this._aElements||k.length<this._aElements.length){A=true;}else{for(i=0;i<k.length;i++){var E=k[i];var B=this._aElements[j];if(E===B){j++;}else{var D=k[i+1];if(D===B){this.insertContent(E,i);break;}D=this._aElements[j+1];if(D===E){A=true;break;}break;}}}if(A){this.removeAllContent();for(i=0;i<k.length;i++){var G=k[i];this.addContent(G);}}}};return S;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.ResponsiveFlowLayout')){jQuery.sap.declare('sap.ui.layout.ResponsiveFlowLayout');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.IntervalTrigger');jQuery.sap.require('sap.ui.core.theming.Parameters');sap.ui.define("sap/ui/layout/ResponsiveFlowLayout",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IntervalTrigger','sap/ui/core/theming/Parameters','./ResponsiveFlowLayoutData','./library'],function(q,C,I,P,R,l){"use strict";var a=C.extend("sap.ui.layout.ResponsiveFlowLayout",{metadata:{library:"sap.ui.layout",properties:{responsive:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});(function(){a.prototype.init=function(){this._rows=[];this._bIsRegistered=false;this._proxyComputeWidths=q.proxy(d,this);this.oRm=sap.ui.getCore().createRenderManager();this.oRm.writeStylesAndClasses=function(){this.writeStyles();this.writeClasses();};this.oRm.writeHeader=function(s,S,e){this.write('<div id="'+s+'"');if(S){for(var k in S){if(k==="width"&&S[k]==="100%"){this.addClass("sapUiRFLFullLength");}this.addStyle(k,S[k]);}}for(var i=0;i<e.length;i++){this.addClass(e[i]);}this.writeStylesAndClasses();this.write(">");};this._iRowCounter=0;};a.prototype.exit=function(){delete this._rows;if(this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}if(this._resizeHandlerComputeWidthsID){sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);}delete this._resizeHandlerComputeWidthsID;delete this._proxyComputeWidths;this.oRm.destroy();delete this.oRm;delete this._$DomRef;delete this._oDomRef;delete this._iRowCounter;};var u=function(t){var e=t.getContent();var r=[];var f=-1;var o={},L={};var s="";var h;var m=0,w=0,j=0;var B=false,M=false,k=false;for(var i=0;i<e.length;i++){m=R.MIN_WIDTH;w=R.WEIGHT;B=R.LINEBREAK;M=R.MARGIN;k=R.LINEBREAKABLE;h=_(e[i]);if(h instanceof R){B=h.getLinebreak();m=h.getMinWidth();w=h.getWeight();M=h.getMargin();k=h.getLinebreakable();}if(f<0||B){f++;r.push({height:-1,cont:[]});}j=r[f].cont.length;s=e[i].getId()+"-cont"+f+"_"+j;o={minWidth:m,weight:w,linebreakable:k,padding:M,control:e[i],id:s,breakWith:[]};var p=false;if(!k){for(var n=j;n>0;n--){L=r[f].cont[n-1];if(L.linebreakable){L.breakWith.push(o);p=true;break;}}}if(!p){r[f].cont.push(o);}}t._rows=r;};var g=function(o,$,t){var r=[];var e=10000000;var f=-1;var h=function(j){var k=q.sap.byId(o.cont[j].id);if(k.length>0){var m=k[0].offsetLeft;if(e>=m){r.push({cont:[]});f++;}e=m;r[f].cont.push(o.cont[j]);}};if(sap.ui.getCore().getConfiguration().getRTL()){for(var i=o.cont.length-1;i>=0;i--){h(i);}}else{for(var i=0;i<o.cont.length;i++){h(i);}}return r;};var b=function(o,w){var r=[];var e=-1;var f=0;var t=0;var i=0;var h=0,m=0;var j=0,k=0;for(j=0;j<o.cont.length;j++){f=0;t=0;for(k=i;k<=j;k++){t=t+o.cont[k].weight;}for(k=i;k<=j;k++){h=w/t*o.cont[k].weight;h=Math.floor(h);m=o.cont[k].minWidth;f+=Math.max(h,m);}if(e==-1||f>w){r.push({cont:[]});if(e!==-1){i=j;}e++;}r[e].cont.push(o.cont[j]);}return r;};var c=function(w,e){if(w.length!=e.length){return true;}for(var i=0;i<w.length;i++){if(w[i].cont.length!=e[i].cont.length){return true;}}return false;};a.prototype.renderContent=function(t,w){var r=t;var e=0;var W=[];var i=0,f=0,j=0,h=0;var k=0;var p=0;var o;var m=0,n=0;var B=[];var s=[];var v=this.getId();var H="";for(i=0;i<r.length;i++){p=0;W.length=0;e=100;s.length=0;s.push("sapUiRFLRow");if(r[i].cont.length<=1){s.push("sapUiRFLCompleteRow");}var x=v+"-row"+this._iRowCounter;var S={};this.oRm.writeHeader(x,S,s);k=0;for(f=0;f<r[i].cont.length;f++){k+=r[i].cont[f].weight;}for(j=0;j<r[i].cont.length;j++){o=r[i].cont[j];m=0;n=0;if(o.breakWith.length>0){m=o.weight;n=o.minWidth;for(var y=0;y<o.breakWith.length;y++){m+=o.breakWith[y].weight;n+=o.breakWith[y].minWidth;}}H=r[i].cont[j].id;s.length=0;S={"min-width":o.breakWith.length>0?n:o.minWidth};p=100/k*o.weight;var z=S["min-width"]/w*100;var A=Math.ceil(z);var D=Math.floor(p);if(D!==100&&A>D){p=A;}else{p=D;}p=e<p?e:p;e-=p;W.push(p);if(e>0&&j===(r[i].cont.length-1)){p+=e;}s.push("sapUiRFLContainer");S["width"]=p+"%";S["min-width"]=S["min-width"]+"px";this.oRm.writeHeader(H,S,s);s.length=0;s.push("sapUiRFLContainerContent");if(o.breakWith.length>0){s.push("sapUiRFLMultiContainerContent");}if(o.padding){s.push("sapUiRFLPaddingClass");}var E=this._addContentClass(o.control,j);if(E){s.push(E);}S={};this.oRm.writeHeader("",S,s);if(o.breakWith.length>0){H=r[i].cont[j].id+"-multi0";s.length=0;S={"min-width":n+"px"};var F=100/m*o.weight;F=Math.floor(F);B.push(F);s.push("sapUiRFLMultiContent");S["width"]=F+"%";if(r[i].cont[j].padding){s.push("sapUiRFLPaddingClass");}this.oRm.writeHeader(H,S,s);var G=F;this.oRm.renderControl(o.control);this.oRm.write("</div>");for(h=0;h<o.breakWith.length;h++){H=o.breakWith[h].id+'-multi'+(h+1);s.length=0;S={"min-width":o.breakWith[h].minWidth+"px"};F=100/m*o.breakWith[h].weight;F=Math.floor(F);B.push(F);G+=F;if(G<100&&h===(o.breakWith.length-1)){F+=100-G;}s.push("sapUiRFLMultiContent");S["width"]=F+"%";if(o.breakWith[h].padding){s.push("sapUiRFLPaddingClass");}this.oRm.writeHeader(H,S,s);this.oRm.renderControl(o.breakWith[h].control);this.oRm.write("</div>");}}else{this.oRm.renderControl(o.control);}this.oRm.write("</div>");this.oRm.write("</div>");}this.oRm.write("</div>");this._iRowCounter++;}};var d=function(e){this._iRowCounter=0;this._oDomRef=this.getDomRef();if(this._oDomRef){var s=this.getId();var f=q(this._oDomRef).width();var r=false;if(this._rows){for(var i=0;i<this._rows.length;i++){var $=this._$DomRef.find("#"+s+"-row"+i);var t=b(this._rows[i],f);var o=g(this._rows[i],$,this);r=c(o,t);var h=$.rect();var p=this._rows[i].oRect;if(h&&p){r=r||(h.width!==p.width)&&(h.height!==p.height);}r=r||(typeof(e)==="boolean"&&e);if(this._bLayoutDataChanged||r){if(sap.ui.Device.browser.internet_explorer){q(this._oDomRef).empty();}else{this._oDomRef.innerHTML="";}this._bLayoutDataChanged=false;this.renderContent(t,f);}}if(this._oDomRef.innerHTML===""){this.oRm.flush(this._oDomRef);for(var i=0;i<this._rows.length;i++){var T=q.sap.byId(s+"-row"+i).rect();this._rows[i].oRect=T;}}if(this._rows.length===0){if(this._resizeHandlerComputeWidthsID){sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}}}};a.prototype.onBeforeRendering=function(){u(this);if(this._resizeHandlerFullLengthID){sap.ui.core.ResizeHandler.deregister(this._resizeHandlerFullLengthID);delete this._resizeHandlerFullLengthID;}};a.prototype.onAfterRendering=function(e){this._oDomRef=this.getDomRef();this._$DomRef=q(this._oDomRef);this._proxyComputeWidths(true);if(this.getResponsive()){if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=sap.ui.core.ResizeHandler.register(this,this._proxyComputeWidths);}}else{if(this._resizeHandlerComputeWidthsID){sap.ui.core.ResizeHandler.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}};a.prototype.onThemeChanged=function(e){if(e.type==="LayoutDataChange"){this._bLayoutDataChanged=true;}if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=sap.ui.core.ResizeHandler.register(this,this._proxyComputeWidths);}u(this);this._proxyComputeWidths();};a.prototype.onLayoutDataChange=a.prototype.onThemeChanged;var _=function(o){var L=o.getLayoutData();if(!L){return undefined;}else if(L instanceof R){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var e=L.getMultipleLayoutData();for(var i=0;i<e.length;i++){var f=e[i];if(f instanceof R){return f;}}}};a.prototype.addContent=function(o){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.addAggregation("content",o);};a.prototype.insertContent=function(o,i){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.insertAggregation("content",o,i);};a.prototype.removeContent=function(o){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.removeAggregation("content",o);};a.prototype._getAccessibleRole=function(){return null;};a.prototype._addContentClass=function(o,i){return null;};}());return a;},true);};if(!jQuery.sap.isDeclared('sap.ui.layout.form.ResponsiveLayout')){jQuery.sap.declare('sap.ui.layout.form.ResponsiveLayout');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/layout/form/ResponsiveLayout",['jquery.sap.global','sap/ui/layout/ResponsiveFlowLayout','sap/ui/layout/ResponsiveFlowLayoutData','./FormLayout','sap/ui/layout/library'],function(q,R,a,F,l){"use strict";var b=F.extend("sap.ui.layout.form.ResponsiveLayout",{metadata:{library:"sap.ui.layout"}});sap.ui.core.Control.extend("sap.ui.layout.form.ResponsiveLayoutPanel",{metadata:{aggregations:{"content":{type:"sap.ui.layout.ResponsiveFlowLayout",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},getLayoutData:function(){var C=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var i;if(L&&C){i=L.getLayoutDataForElement(C,"sap.ui.layout.ResponsiveFlowLayoutData");}return i;},getCustomData:function(){var C=sap.ui.getCore().byId(this.getContainer());if(C){return C.getCustomData();}},refreshExpanded:function(){var C=sap.ui.getCore().byId(this.getContainer());if(C){if(C.getExpanded()){this.$().removeClass("sapUiRLContainerColl");}else{this.$().addClass("sapUiRLContainerColl");}}},renderer:function(r,P){var C=sap.ui.getCore().byId(P.getContainer());var L=sap.ui.getCore().byId(P.getLayout());var i=P.getContent();if(!C||!L){return;}var E=C.getExpandable();var t=C.getTooltip_AsString();var T=C.getToolbar();var j=C.getTitle();r.write("<div");r.writeControlData(P);r.addClass("sapUiRLContainer");if(E&&!C.getExpanded()){r.addClass("sapUiRLContainerColl");}if(T){r.addClass("sapUiFormContainerToolbar");}else if(j){r.addClass("sapUiFormContainerTitle");}if(t){r.writeAttributeEscaped('title',t);}r.writeClasses();L.getRenderer().writeAccessibilityStateContainer(r,C);r.write(">");if(T){r.renderControl(T);}else if(C.getTitle()){L.getRenderer().renderTitle(r,j,C._oExpandButton,E,false,C.getId());}if(i){r.write("<div");r.addClass("sapUiRLContainerCont");r.writeClasses();r.write(">");r.renderControl(i);r.write("</div>");}r.write("</div>");}});b.prototype.init=function(){this.mContainers={};this._defaultLayoutData=new a({margin:false});};b.prototype.exit=function(){var t=this;for(var C in this.mContainers){m(t,C);}if(this._mainRFLayout){this._mainRFLayout.destroy();delete this._mainRFLayout;}this._defaultLayoutData.destroy();delete this._defaultLayoutData;};b.prototype.onBeforeRendering=function(E){var i=this.getParent();if(!i||!(i instanceof sap.ui.layout.form.Form)){return;}i._bNoInvalidate=true;var t=this;_(t,i);o(t,i);i._bNoInvalidate=false;};b.prototype.contentOnAfterRendering=function(i,C){F.prototype.contentOnAfterRendering.apply(this,arguments);if(C.getWidth&&(!C.getWidth()||C.getWidth()=="auto")&&C.getMetadata().getName()!="sap.ui.commons.Image"){C.$().css("width","100%");}};b.prototype.toggleContainerExpanded=function(C){var s=C.getId();if(this.mContainers[s]&&this.mContainers[s][0]){var P=this.mContainers[s][0];P.refreshExpanded();}};b.prototype.onLayoutDataChange=function(E){var s=E.srcControl;var C;var i;var j;if(s instanceof sap.ui.layout.form.FormContainer){if(this._mainRFLayout){this._mainRFLayout.onLayoutDataChange(E);}}else if(s instanceof sap.ui.layout.form.FormElement){i=s.getParent().getId();if(this.mContainers[i]&&this.mContainers[i][1]){this.mContainers[i][1].onLayoutDataChange(E);}}else{var P=s.getParent();if(P instanceof sap.ui.layout.form.FormElement){C=P.getParent();i=C.getId();j=P.getId();if(this.mContainers[i]&&this.mContainers[i][2]&&this.mContainers[i][2][j]){this.mContainers[i][2][j][0].onLayoutDataChange(E);}}}};b.prototype.onsapup=function(E){this.onsapleft(E);};b.prototype.onsapdown=function(E){this.onsapright(E);};b.prototype.getContainerRenderedDomRef=function(C){if(this.getDomRef()){var s=C.getId();if(this.mContainers[s]){if(this.mContainers[s][0]){var P=this.mContainers[s][0];return P.getDomRef();}else if(this.mContainers[s][1]){var r=this.mContainers[s][1];return r.getDomRef();}}}return null;};b.prototype.getElementRenderedDomRef=function(E){if(this.getDomRef()){var C=E.getParent();var s=E.getId();var i=C.getId();if(this.mContainers[i]){if(this.mContainers[i][2]){var r=this.mContainers[i][2];if(r[s]){var j=r[s][0];return j.getDomRef();}}}}return null;};function _(L,j){var C=j.getFormContainers();var r;var s;var t=C.length;var v=0;var P;var u;var i=0;for(i=0;i<t;i++){r=C[i];r._checkProperties();if(r.getVisible()){v++;s=r.getId();P=undefined;u=undefined;if(L.mContainers[s]&&L.mContainers[s][1]){u=L.mContainers[s][1];}else{u=f(L,r,undefined);}var T=r.getTitle();var w=r.getToolbar();if(w||T||r.getExpandable()){if(L.mContainers[s]&&L.mContainers[s][0]){P=L.mContainers[s][0];}else{P=c(L,r,u);g(u,true);}u.removeStyleClass("sapUiRLContainer");}else{if(L.mContainers[s]&&L.mContainers[s][0]){d(L.mContainers[s][0]);g(u,false);}u.addStyleClass("sapUiRLContainer");}var x=e(L,r,u);L.mContainers[s]=[P,u,x];}}var O=p(L.mContainers);if(v<O){for(s in L.mContainers){var y=false;for(i=0;i<t;i++){r=C[i];if(s==r.getId()&&r.getVisible()){y=true;break;}}if(!y){m(L,s);}}}}function c(L,C,r){var s=C.getId();var P=new sap.ui.layout.form.ResponsiveLayoutPanel(s+"--Panel",{container:C,layout:L,content:r});return P;}function d(P){P.setContent("");P.setLayout("");P.setContainer("");P.destroy();}function e(L,C,j){var s=C.getId();var E=C.getFormElements();var r=E.length;var v=0;var t={};if(L.mContainers[s]&&L.mContainers[s][2]){t=L.mContainers[s][2];}var u;var w;var x=-1;var y;var z;var i=0;for(i=0;i<r;i++){y=E[i];if(y.getVisible()){z=y.getId();n(L,C,y,t,j,i);if(t[z]){u=t[z][0];x=j.indexOfContent(u);}else{u=f(L,C,y);u.addStyleClass("sapUiRLElement");if(y.getLabel()){u.addStyleClass("sapUiRLElementWithLabel");}t[z]=[u,undefined];x++;j.insertContent(u,x);}var A=y.getFields();if(y.getLabel()&&A.length>1){if(t[z][1]){w=t[z][1];}else{w=f(L,C,y,true);w.addStyleClass("sapUiRLElementFields");t[z][1]=w;}h(L,w,A);}else{if(t[z][1]){w=t[z][1];k(w);t[z][1]=undefined;}}v++;}}var O=p(t);if(v<O){for(z in t){var B=false;for(i=0;i<r;i++){y=E[i];if(z==y.getId()&&y.getVisible()){B=true;break;}}if(!B){if(t[z][1]){w=t[z][1];k(w);}u=t[z][0];j.removeContent(u);k(u);delete t[z];}}}return t;}function f(L,C,E,i){var I;if(E&&!i){I=E.getId()+"--RFLayout";}else if(E&&i){I=E.getId()+"--content--RFLayout";}else if(C){I=C.getId()+"--RFLayout";}else{return false;}var r=new R(I);r.__myParentLayout=L;r.__myParentContainerId=C.getId();if(E){r.__myParentElementId=E.getId();if(!i){r.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var j=[];var s=E.getLabelControl();var t=E.getFields();if(!s||t.length<=1){j=t;if(s){j.unshift(s);}}else{var L=this.__myParentLayout;var u=this.__myParentContainerId;var v=E.getId();if(s){j.push(s);}if(L.mContainers[u]&&L.mContainers[u][2]&&L.mContainers[u][2][v]&&L.mContainers[u][2][v][1]){j.push(L.mContainers[u][2][v][1]);}}return j;}else{return false;}};r._addContentClass=function(j,s){if(s==0){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var t=E.getLabelControl();if(j==t){return"sapUiFormElementLbl";}}}return null;};}else{r.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){return E.getFields();}else{return false;}};}}else if(C){r._getAccessibleRole=function(){var C=sap.ui.getCore().byId(this.__myParentContainerId);var L=this.__myParentLayout;if(L._mainRFLayout&&!C.getToolbar()&&!C.getTitle()&&!C.getExpandable()){return"form";}};}if((E&&!i)||(!E&&!C.getToolbar()&&!C.getTitle()&&!C.getExpandable())){g(r,false);}else{r.setLayoutData(new a({margin:false}));}return r;}function g(r,O){if(O){if(r.__originalGetLayoutData){r.getLayoutData=r.__originalGetLayoutData;delete r.__originalGetLayoutData;}}else if(!r.__originalGetLayoutData){r.__originalGetLayoutData=r.getLayoutData;r.getLayoutData=function(){var L=this.__myParentLayout;var C=sap.ui.getCore().byId(this.__myParentContainerId);var E=sap.ui.getCore().byId(this.__myParentElementId);var i;if(E){i=L.getLayoutDataForElement(E,"sap.ui.layout.ResponsiveFlowLayoutData");}else if(C){i=L.getLayoutDataForElement(C,"sap.ui.layout.ResponsiveFlowLayoutData");}if(i){return i;}else if(E){return L._defaultLayoutData;}};}}function h(L,r,j){var s;var w=0;for(var i=0;i<j.length;i++){var t=j[i];s=L.getLayoutDataForElement(t,"sap.ui.layout.ResponsiveFlowLayoutData");if(s){w=w+s.getWeight();}else{w++;}}s=r.getLayoutData();if(s){s.setWeight(w);}else{r.setLayoutData(new a({weight:w}));}}function k(r){if(r.__myParentContainerId){r.__myParentContainerId=undefined;}if(r.__myParentElementId){r.__myParentElementId=undefined;}r.__myParentLayout=undefined;r.destroy();}function m(L,C){var i=L.mContainers[C];var r;var E=i[2];if(E){for(var s in E){if(E[s][1]){k(E[s][1]);}r=E[s][0];k(r);delete E[s];}}r=i[1];if(r){r.removeAllContent();k(r);}var P=i[0];if(P){d(P);}delete L.mContainers[C];}function n(L,C,E,r,i,I){var s=E.getId();var j=s+"--RFLayout";var t=sap.ui.getCore().byId(j);if(!r[s]&&t){var O=t.__myParentContainerId;r[s]=L.mContainers[O][2][s];i.insertContent(t,I);t.__myParentContainerId=C.getId();if(r[s][1]){r[s][1].__myParentContainerId=C.getId();}delete L.mContainers[O][2][s];}}function o(L,r){var C=r.getFormContainers();var v=[];var s;var t=0;var u=0;var i=0;var j=0;for(i=0;i<C.length;i++){s=C[i];if(s.getVisible()){t++;v.push(s);}}if(t>1){if(!L._mainRFLayout){L._mainRFLayout=new R(r.getId()+"--RFLayout").setParent(L);}else{var w=L._mainRFLayout.getContent();u=w.length;var E=false;for(i=0;i<u;i++){var x=w[i];s=undefined;if(x.getContainer){s=sap.ui.getCore().byId(x.getContainer());}else{s=sap.ui.getCore().byId(x.__myParentContainerId);}if(s&&s.getVisible()){var V=v[j];if(s!=V){E=true;break;}var y=L.mContainers[s.getId()];if(y[0]&&y[0]!=x){E=true;break;}if(!y[0]&&y[1]&&y[1]!=x){E=true;break;}j++;}else{L._mainRFLayout.removeContent(x);}}if(E){L._mainRFLayout.removeAllContent();u=0;}}if(u<t){var S=0;if(u>0){S=u--;}for(i=S;i<t;i++){s=v[i];var z=s.getId();if(L.mContainers[z]){if(L.mContainers[z][0]){L._mainRFLayout.addContent(L.mContainers[z][0]);}else if(L.mContainers[z][1]){L._mainRFLayout.addContent(L.mContainers[z][1]);}}}}}}function p(O){var L=0;if(!Object.keys){q.each(O,function(){L++;});}else{L=Object.keys(O).length;}return L;}return b;},true);};
