/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Slider"],function(S){"use strict";var R=S.extend("sap.m.RangeSlider",{metadata:{library:"sap.m",properties:{range:{type:"any",group:"Data",defaultValue:[]}}}});R.prototype.init=function(){var r;S.prototype.init.call(this,arguments);r=this.getRange();r=Array.isArray(r)&&r.length===2?r:[0,100];this.setRange(r);this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._aInitialFocusRange=Array.prototype.slice.call(this.getRange());this._iLongestRangeTextWidth=0;this._fTooltipHalfWidthPercent=0;};R.prototype.onBeforeRendering=function(){var a=[Math.abs(this.getMin()),Math.abs(this.getMax())],w=8;this._validateProperties();if(a[0]>a[1]){this._iLongestRangeTextWidth=((a[0].toString()).length+1)*w;}else{this._iLongestRangeTextWidth=((a[1].toString()).length+1)*w;}};R.prototype.onAfterRendering=function(){var r=this.getRange(),m=this.getMin(),M=this.getMax(),h=this.getDomRef("handle1"),H=this.getDomRef("handle2"),b=r.reduce(function(a,v){return a||v<m||v>M;});this._recalculateStyles();if(b){jQuery.sap.log.warning("Warning: "+"Property wrong range: ["+r+"] not in the range: ["+m+","+M+"]",this);}this.$("TooltipsContainer").css("min-width",(this._fTooltipHalfWidthPercent*4)+"%");this._updateHandle(h,r[0]);this._updateHandle(H,r[1]);};R.prototype.exit=function(){this._aInitialFocusRange=null;};R.prototype._recalculateStyles=function(){S.prototype._recalculateStyles.call(this,arguments);this._fTooltipHalfWidthPercent=((this._fSliderWidth-(this._fSliderWidth-(this._iLongestRangeTextWidth/2+8)))/this._fSliderWidth)*100;};R.prototype._recalculateRange=function(){var h;if(this._bRTL){h=[parseFloat(this.getDomRef("handle1").style.right),parseFloat(this.getDomRef("handle2").style.right)];}else{h=[parseFloat(this.getDomRef("handle1").style.left),parseFloat(this.getDomRef("handle2").style.left)];}var s=Math.min.apply(Math,h)+"%";var e=(100-Math.max.apply(Math,h))+"%";var p=this.getDomRef("progress");if(this._bRTL){p.style.left=e;p.style.right=s;}else{p.style.left=s;p.style.right=e;}};R.prototype.getClosestHandleDomRef=function(e){var h=this.getDomRef("handle1"),H=this.getDomRef("handle2"),p=Math.abs(e.pageX-h.offsetLeft-this._fSliderPaddingLeft-this._fSliderOffsetLeft),c=Math.abs(e.clientX-H.offsetLeft-this._fSliderPaddingLeft-this._fSliderOffsetLeft);return p>c?H:h;};R.prototype._getIndexOfHandle=function(h){if(h.getAttribute("data-range-val")==="start"){return 0;}else if(h.getAttribute("data-range-val")==="end"){return 1;}else{return-1;}};R.prototype._updateHandle=function(h,v){var m,r=this.getRange(),i=this._getIndexOfHandle(h),p=this._getPercentOfValue(v),c=this.getRenderer().CSS_CLASS,f=this.getDomRef("input");r[i]=v;this.setRange(r);if(!!this.getName()){f.setAttribute(h.getAttribute("data-range-val"),r[i]);f.setAttribute("value",this.getValue());}if(this._bRTL){h.style.right=p+"%";}else{h.style.left=p+"%";}h.setAttribute("aria-valuenow",v);if(this.getShowHandleTooltip()){h.title=v;}m=r[0]===r[1];this.$("handle1").toggleClass(c+"HandleOverlap",m);this.$("handle2").toggleClass(c+"HandleOverlap",m);this._updateTooltips(i,r,p);this._recalculateRange();};R.prototype._updateTooltips=function(i,r,p){var n=parseInt(r[i],10),z=i===0,a=r[0]<r[1],A=r[0]>r[1];if((a&&z)||(A&&!z)){this._updateLeftTooltip(p,n);}else if((a&&!z)||(A&&z)){this._updateRightTooltip(p,n);}else{this._updateLeftTooltip(p,n);this._updateRightTooltip(p,n);}};R.prototype._updateLeftTooltip=function(p,n){var t=this.$("LeftTooltip"),T=this.getDomRef("TooltipsContainer"),a=this._bRTL?"right":"left";t.text(n);if(p<=this._fTooltipHalfWidthPercent){T.style[a]=0+"%";}else if(p>=(100-3*this._fTooltipHalfWidthPercent)){T.style[a]=(100-4*this._fTooltipHalfWidthPercent)+"%";}else{T.style[a]=p-this._fTooltipHalfWidthPercent+"%";}};R.prototype._updateRightTooltip=function(p,n){var t=this.$("RightTooltip"),T=this.getDomRef("TooltipsContainer"),a=this._bRTL?"left":"right";t.text(n);if(p>=(100-this._fTooltipHalfWidthPercent)){T.style[a]=0+"%";}else{T.style[a]=(100-p-this._fTooltipHalfWidthPercent)+"%";}};R.prototype.setRange=function(r){var m=this.getMax(),M=this.getMin();if(!Array.isArray(r)){jQuery.sap.log.error("Error: "+"Cannot set property range: "+r+" not an array in the range: ["+M+","+m+"]",this);return this;}r=r.map(this._adjustRangeValue,this);this.setProperty("range",Array.prototype.slice.call(r),true);return this;};R.prototype.setValue=R.prototype.setRange;R.prototype.getValue=function(){var r=this.getRange();return Math.abs(r[1]-r[0]);};R.prototype._calculateHandlePosition=function(v){var m=this.getMax(),M=this.getMin(),n;n=((v-this._fSliderPaddingLeft-this._fSliderOffsetLeft)/this._fSliderWidth)*(m-M)+M;if(this._bRTL){n=this._convertValueToRtlMode(n);}return this._adjustRangeValue(n);};R.prototype._adjustRangeValue=function(v){var m=this.getMax(),M=this.getMin(),s=this.getStep(),f;f=Math.abs((v-M)%s);if(f!==0){v=f*2>=s?v+s-f:v-f;}if(v<M){v=M;}else if(v>m){v=m;}return v;};R.prototype.ontouchstart=function(e){var t=e.targetTouches[0],n,C=this.getRenderer().CSS_CLASS,E="."+C,v,r;if(!this.getEnabled()){return;}this._recalculateStyles();n=this.getClosestHandleDomRef(t);jQuery.sap.delayedCall(0,n,"focus");e.setMarked();jQuery(document).on("touchend"+E+" touchcancel"+E+" mouseup"+E,this._ontouchend.bind(this,n)).on(e.originalEvent.type==="touchstart"?"touchmove"+E:"touchmove"+E+" mousemove"+E,this._ontouchmove.bind(this,n));if(n.className.indexOf(C+"HandlePressed")===-1){n.className+=" "+C+"HandlePressed";}v=this._calculateHandlePosition(t.pageX);r=this.getRange();if(v<Math.min.apply(Math,r)||v>Math.max.apply(Math,r)){this._updateHandle(n,v);}};R.prototype._ontouchmove=function(h,e){var p=e.targetTouches?e.targetTouches[0].pageX:e.pageX;e.preventDefault();e.setMarked();if(e.isMarked("delayedMouseEvent")||!this.getEnabled()||e.button){return;}this._updateHandle(h,this._calculateHandlePosition(p));this.fireLiveChange({range:this.getRange()});};R.prototype._ontouchend=function(h,e){var n=this.getRange(),c=this.getRenderer().CSS_CLASS;e.setMarked();h.className=h.className.replace(new RegExp(" ?"+c+"HandlePressed","gi"),"");jQuery(document).off("."+c);this._recalculateRange();if(this._aInitialFocusRange[0]!==n[0]||this._aInitialFocusRange[1]!==n[1]){this._aInitialFocusRange=Array.prototype.slice.call(n);this.fireChange({range:n});}this._updateTooltips(0,n,this._getPercentOfValue(n[0]));this._updateTooltips(1,n,this._getPercentOfValue(n[1]));};R.prototype.onfocusin=function(e){var c=this.getRenderer().CSS_CLASS;this.$("LeftTooltip").toggleClass(c+"HandleTooltipShow");this.$("RightTooltip").toggleClass(c+"HandleTooltipShow");if(!this._hasFocus()){this._aInitialFocusRange=Array.prototype.slice.call(this.getRange());}};R.prototype.onfocusout=function(e){var c=this.getRenderer().CSS_CLASS;this.$("LeftTooltip").toggleClass(c+"HandleTooltipShow");this.$("RightTooltip").toggleClass(c+"HandleTooltipShow");};R.prototype._fireChangeAndLiveChange=function(p){this.fireChange(p);this.fireLiveChange(p);};R.prototype._increaseValueBy=function(i,h){var n,m=this.getMax(),r=this.getRange(),I=this._getIndexOfHandle(h);n=r[I]+i;if(n<m){this._updateHandle(h,n);}else{this._updateHandle(h,m);}this._fireChangeAndLiveChange({range:this.getRange()});};R.prototype._decreaseValueBy=function(d,h){var n,m=this.getMin(),r=this.getRange(),i=this._getIndexOfHandle(h);n=r[i]-d;if(n>m){this._updateHandle(h,n);}else{this._updateHandle(h,m);}this._fireChangeAndLiveChange({range:this.getRange()});};R.prototype.onsapincrease=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._increaseValueBy(this.getStep(),e.target);}};R.prototype.onsapincreasemodifiers=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._increaseValueBy(this._getLongStep(),e.target);}};R.prototype.onsapdecrease=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._decreaseValueBy(this.getStep(),e.target);}};R.prototype.onsapdecreasemodifiers=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._decreaseValueBy(this._getLongStep(),e.target);}};R.prototype.onsapplus=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._increaseValueBy(this.getStep(),e.target);}};R.prototype.onsapminus=function(e){e.preventDefault();e.setMarked();if(this.getEnabled()){this._decreaseValueBy(this.getStep(),e.target);}};R.prototype.onsappageup=R.prototype.onsapincreasemodifiers;R.prototype.onsappagedown=R.prototype.onsapdecreasemodifiers;R.prototype.onsaphome=function(e){e.setMarked();e.preventDefault();if(this.getEnabled()){this._updateHandle(e.target,this.getMin());}this._fireChangeAndLiveChange({range:this.getRange()});};R.prototype.onsapend=function(e){e.setMarked();e.preventDefault();if(this.getEnabled()){this._updateHandle(e.target,this.getMax());}this._fireChangeAndLiveChange({range:this.getRange()});};R.prototype.onsapescape=function(){this.setRange(this._aInitialFocusRange);this._fireChangeAndLiveChange({range:this.getRange()});};return R;},true);
