/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/P13nColumnsItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nColumnsPanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Table','./library','sap/ui/core/Control'],function(q,C,P,c,S,T,l,d){"use strict";
var e=P.extend("sap.m.P13nColumnsPanel",{
metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"}}},setData:{}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
e.prototype._ItemMoveToTop=function(){var o=-1,n=-1,i=null,t=null;if(this._oSelectedItem){t=this._oTable.getItems();i=this._oSelectedItem.data('P13nColumnKey');o=this._getArrayIndexByItemKey(i,t);n=o;if(o>0){n=0;}if(n!=-1&&o!=-1&&o!=n){this._handleItemIndexChanged(this._oSelectedItem,n);this._changeColumnsItemsIndexes(o,n);this._afterMoveItem();}}};
e.prototype._ItemMoveUp=function(){var o=-1,n=-1,i=null,t=null;if(this._oSelectedItem){t=this._oTable.getItems();i=this._oSelectedItem.data('P13nColumnKey');o=this._getArrayIndexByItemKey(i,t);n=o;if(o>0){n=this._getPreviousItemIndex(o);}if(n!=-1&&o!=-1&&o!=n){this._handleItemIndexChanged(this._oSelectedItem,n);this._changeColumnsItemsIndexes(o,n);this._afterMoveItem();}}};
e.prototype._ItemMoveDown=function(){var o=-1,n=-1,i=null,t=null;var a=null;if(this._oSelectedItem){t=this._oTable.getItems();a=t.length;i=this._oSelectedItem.data('P13nColumnKey');o=this._getArrayIndexByItemKey(i,t);n=o;if(o<a-1){n=this._getNextItemIndex(o);}if(n!=-1&&o!=-1&&o!=n){this._handleItemIndexChanged(this._oSelectedItem,n);this._changeColumnsItemsIndexes(o,n);this._afterMoveItem();}}};
e.prototype._ItemMoveToBottom=function(){var o=-1,n=-1,i=null,t=null;var a=null;if(this._oSelectedItem){t=this._oTable.getItems();a=t.length;i=this._oSelectedItem.data('P13nColumnKey');o=this._getArrayIndexByItemKey(i,t);n=o;if(o<a-1){n=a-1;}if(n!=-1&&o!=-1&&o!=n){this._handleItemIndexChanged(this._oSelectedItem,n);this._changeColumnsItemsIndexes(o,n);this._afterMoveItem();}}};
e.prototype._changeColumnsItemsIndexes=function(o,n){var m=null,M=null,s=null,i=null;var a=null,b=null,f=null;if(o!==null&&o!==undefined&&o>-1&&n!==null&&n!==undefined&&n>-1&&o!==n){m=Math.min(o,n);M=Math.max(o,n);i=this._oTable.getItems().length-1;a=this.getColumnsItems();s=this._oSelectedItem.data('P13nColumnKey');a.forEach(function(g){f=g.getColumnKey();if(f!==undefined&&f===s){return;}b=g.getIndex();if(b===undefined||b<0||b<m||b>M){return;}if(o>n){if(b<i){b+=1;}}else{if(b>0){b-=1;}}g.setIndex(b);});}};
e.prototype._afterMoveItem=function(){this._scrollToSelectedItem(this._oSelectedItem);this._calculateMoveButtonAppearance();};
e.prototype._swopShowSelectedButton=function(){var n;this._bShowSelected=!this._bShowSelected;if(this._bShowSelected){n=this._oRb.getText('COLUMNSPANEL_SHOW_ALL');}else{n=this._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}this._oShowSelectedButton.setText(n);this._changeEnableProperty4SelectAll();this._filterItems();if(this._oSelectedItem&&this._oSelectedItem.getVisible()!==true){this._deactivateSelectedItem();}this._scrollToSelectedItem(this._oSelectedItem);this._calculateMoveButtonAppearance();this._fnHandleResize();};
e.prototype._escapeRegExp=function(t){if(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');}};
e.prototype._filterItems=function(){var s=null,t=null;var L=0,a=0,i=0,j=0;var I=null,o=null;var b,f;var g=null,h=null,r=null;if(this._bShowSelected){s=this._oTable.getSelectedItems();}else{s=this._oTable.getItems();}if(this._bSearchFilterActive){h=this._oSearchField.getValue();if(h){h=h.replace(/(^\s+)|(\s+$)/g,'');}if(h!==null&&h!==undefined){h=this._escapeRegExp(h);h=r=new RegExp(h,'igm');}}t=this._oTable.getItems();L=t.length;for(i=0;i<L;i++){I=t[i];b=true;f=false;if(this._bSearchFilterActive){b=false;g=I.getCells()[0].getText();if(g&&r!==null&&g.match(r)!==null){b=true;}if(b!==true&&I.getTooltip_Text){g=(I.getTooltip()instanceof sap.ui.core.TooltipBase?I.getTooltip().getTooltip_Text():I.getTooltip_Text());if(g&&r!==null&&g.match(r)!==null){b=true;}}}a=s.length;for(j=0;j<a;j++){o=s[j];if(o){if(o.getId()==I.getId()){f=true;break;}}}I.setVisible(f&&b);}};
e.prototype._changeEnableProperty4SelectAll=function(s){var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!this._bSearchFilterActive&&!this._bShowSelected);}};
e.prototype._executeSearch=function(){var v=this._oSearchField.getValue();var L=v.length||0;if(L>0){this._bSearchFilterActive=true;}else{this._bSearchFilterActive=false;}this._changeEnableProperty4SelectAll();this._filterItems();if(this._oSelectedItem&&this._oSelectedItem.getVisible()!==true){this._deactivateSelectedItem();}this._calculateMoveButtonAppearance();this._scrollToSelectedItem(this._oSelectedItem);};
e.prototype._getPreviousItemIndex=function(s){var r=-1,i=0;var t=null,o=null;if(s!==null&&s!==undefined&&s>0){if(this._bShowSelected===true){t=this._oTable.getItems();if(t&&t.length>0){for(i=s-1;i>=0;i--){o=t[i];if(o&&o.getSelected()===true){r=i;break;}}}}else{r=s-1;}}return r;};
e.prototype._getNextItemIndex=function(s){var r=-1,i=0,L=null;var t=null,o=null;if(s!==null&&s!==undefined&&s>-1){t=this._oTable.getItems();if(t&&t.length>0){L=t.length;}if(s>=0&&s<L-1){if(this._bShowSelected===true){for(i=s+1;i<L;i++){o=t[i];if(o&&o.getSelected()===true){r=i;break;}}}else{r=s+1;}}}return r;};
e.prototype._updateSelectAllDescription=function(E){var t=this._oTable.getItems().length;var s=this._oTable.getSelectedItems().length;var a=null;var o=this._oTable.getColumns()[0];if(o){a=this._oRb.getText('COLUMNSPANEL_SELECT_ALL');if(s!==null&&s!==undefined&&s>=0){a=this._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[s,t]);}o.getHeader().setText(a);}if(this._bShowSelected){this._filterItems();}};
e.prototype._changeSelectedItem=function(i){var n=null;if(this._oSelectedItem!==null&&this._oSelectedItem!==undefined){this._removeHighLightingFromItem(this._oSelectedItem);}n=i;if(n!=this._oSelectedItem){this._oSelectedItem=n;this._setHighLightingToItem(this._oSelectedItem);}else{this._oSelectedItem=null;}this._calculateMoveButtonAppearance();};
e.prototype._itemPressed=function(E){var n=null;n=E.getParameter('listItem');this._changeSelectedItem(n);};
e.prototype._calculateMoveButtonAppearance=function(){var i=null,t=null;var L=-1,I=-1;var m=false,M=false;if(this._bSearchFilterActive===true){m=M=false;}else if(this._oSelectedItem!==null&&this._oSelectedItem!==undefined){i=this._oSelectedItem.data('P13nColumnKey');if(this._bShowSelected===true){t=this._oTable.getSelectedItems();}else{t=this._oTable.getItems();}I=this._getArrayIndexByItemKey(i,t);if(I!==-1){if(t&&t.length){L=t.length;}if(I===0){M=true;}else if(I===L-1){m=true;}else if(I>0&&I<L-1){M=true;m=true;}}}else{m=M=false;}if(this._oMoveToTopButton.getEnabled()!==m){this._oMoveToTopButton.setEnabled(m);}if(this._oMoveUpButton.getEnabled()!==m){this._oMoveUpButton.setEnabled(m);}if(this._oMoveDownButton.getEnabled()!==M){this._oMoveDownButton.setEnabled(M);}if(this._oMoveToBottomButton.getEnabled()!==M){this._oMoveToBottomButton.setEnabled(M);}};
e.prototype._setHighLightingToItem=function(i){if(i!==null&&i!==undefined&&i.addStyleClass){i.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
e.prototype._removeHighLightingFromItem=function(i){if(i!==null&&i!==undefined&&i.removeStyleClass){i.removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
e.prototype._deactivateSelectedItem=function(){if(this._oSelectedItem){this._removeHighLightingFromItem(this._oSelectedItem);this._oSelectedItem=null;this._calculateMoveButtonAppearance();}};
e.prototype._getArrayIndexByItemKey=function(I,a){var r=-1;var L=0,i=0;var o=null,s=null;if(I!==null&&I!==undefined&&I!==""){if(a&&a.length>0){L=a.length;for(i=0;i<L;i++){s=null;o=a[i];if(o){if(o.getColumnKey){s=o.getColumnKey();}else if(o.columnKey){s=o.columnKey;}else{s=o.data('P13nColumnKey');}if(s!==null&&s!==undefined&&s!==""){if(s===I){r=i;break;}}}}}}return r;};
e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};
e.prototype._extractExistingColumnsItems=function(a){var E=null,o=null;if(a&&a.length>0){E=[];a.forEach(function(b){o={columnKey:b.getColumnKey(),index:b.getIndex(),visible:b.getVisible(),width:b.getWidth()};E.push(o);});}return E;};
e.prototype._extractExistingTableItems=function(){var E=null,o=null;var t=this._oTable.getItems();if(t&&t.length>0){E=[];t.forEach(function(a,i){o={columnKey:a.data('P13nColumnKey'),index:i,visible:a.getSelected(),width:a.data('P13nColumnWidth')};E.push(o);});}return E;};
e.prototype._handleItemIndexChanged=function(i,n){var I=null,a=null;var E=[],o=null;var N=[],b=null;var t=this;if(i&&n!==null&&n!==undefined&&n>-1){I=i.data('P13nColumnKey');b=this.getColumnsItems();this._aExistingColumnsItems=this._extractExistingColumnsItems(b);a=this._getArrayIndexByItemKey(I,b);if(a!==null&&a!==undefined&&a!==-1){o=b[a];}if(o===null){o=this._createNewColumnsItem(I);o.setIndex(n);N.push(o);this.fireAddColumnsItem({newItem:o});this._notifyChange();}else{o.setIndex(n);E.push(o);}if(N.length>0||E.length>0){this.aOwnHandledColumnsItems=N;this.fireChangeColumnsItems({newItems:N,existingItems:E});this._notifyChange();}this.fireSetData();if(E&&E.length>0){E.forEach(function(i){t._updateTableItems(i);});this._oTableItemsOrdering.fCheckReOrdering();}}};
e.prototype._handleItemVisibilityChanged=function(i){var t=this;var I=null,a=null;var E=[],o=null;var n=[],b=null;if(i&&i.length>0){b=this.getColumnsItems();this._aExistingColumnsItems=this._extractExistingColumnsItems(b);i.forEach(function(f){o=a=null;I=f.columnKey;a=t._getArrayIndexByItemKey(I,b);if(a!==null&&a!==undefined&&a!==-1){o=b[a];}if(o===null){o=t._createNewColumnsItem(I);o.setVisible(f.visible);n.push(o);t.fireAddColumnsItem({newItem:o});t._notifyChange();}else{o.setVisible(f.visible);if(o.getVisible()===false){o.setIndex(undefined);}E.push(o);}});if(n.length>0||E.length>0){this.aOwnHandledColumnsItems=n;this.fireChangeColumnsItems({newItems:n,existingItems:E});this._notifyChange();}this.fireSetData();if(E&&E.length>0){E.forEach(function(f){t._updateTableItems(f);});this._oTableItemsOrdering.fCheckReOrdering();}}};
e.prototype._createNewColumnsItem=function(i){var n=new sap.m.P13nColumnsItem({"columnKey":i});return n;};
e.prototype._getColumnsItemByKey=function(i){var a=null;var b=-1,o=null;if(i!==null&&i!==undefined&&i!==""){a=this.getColumnsItems();b=this._getArrayIndexByItemKey(i,a);if(b!==null&&b>-1){o=a[b];}}return o;};
e.prototype._updateTableItems=function(o){var t=null,i,a=null;var b=null,s=null;if(o){b=[];b.push(o);}else{b=this.getColumnsItems();}t=this._oTable.getItems();if(t&&t.length>0){b.forEach(function(o){s=o.getColumnKey();i=this._getArrayIndexByItemKey(s,t);if(i!==-1){a=t[i];this._applyColumnsItem2TableItem(o,a);}},this);}};
e.prototype._reOrderExistingTableItems=function(){var E=null,f=null;var i=-1,L=null;var t=this;E=this._oTable.getItems();f=this._oTable.getSelectedItems();if(f&&f.length>0){f.forEach(function(o){i=E.indexOf(o);if(i>-1){E.splice(i,1);}});}if(E&&E.length>0){try{L=sap.ui.getCore().getConfiguration().getLocale().toString();}catch(g){q.sap.log.error("sap.m.P13nColumnsPanel : no available Language/Locale to sort table items");L=null;}if(L){E.sort(function(a,b){var s=a.getCells()[0].getText();var h=b.getCells()[0].getText();return s.localeCompare(h,L,{numeric:true});});}}this._oTable.removeAllItems();f.forEach(function(I){t._oTable.addItem(I);});E.forEach(function(I){t._oTable.addItem(I);});};
e.prototype._addTableItem=function(i){var o=null;var n=null,s=null;if(i){s=i.getColumnKey();o=this._getColumnsItemByKey(s);n=this._createNewTableItemBasedOnP13nItem(i);if(o){if(o.getVisible()!==undefined){n.setSelected(o.getVisible());}if(o.getWidth()!==undefined){n.data('P13nColumnWidth',o.getWidth());}}if(o&&o.getIndex()!==undefined){this._oTable.insertItem(n,o.getIndex());}else{this._oTable.addItem(n);}}};
e.prototype._insertTableItem=function(i,I){var o=null,n=null,s=null;if(I){s=I.getColumnKey();o=this._getColumnsItemByKey(s);n=this._createNewTableItemBasedOnP13nItem(I);if(o){if(o.getVisible()!==undefined){n.setSelected(o.getVisible());}if(o.getWidth()!==undefined){n.data('P13nColumnWidth',o.getWidth());}}if(o&&o.getIndex()!==undefined){this._oTable.insertItem(n,o.getIndex());}else{this._oTable.insertItem(n,i);}}};
e.prototype._createNewTableItemBasedOnP13nItem=function(i){if(!i){return null;}var s=i.getColumnKey();var n=new sap.m.ColumnListItem({cells:[new sap.m.Text({text:i.getText()?i.getText():q.extend(true,{},i.getBindingInfo("text"))})],visible:true,selected:i.getVisible(),tooltip:i.getTooltip(),type:sap.m.ListType.Active});n.data('P13nColumnKey',s);n.data('P13nColumnWidth',i.getWidth());return n;};
e.prototype._applyColumnsItem2TableItem=function(o,t){var a=this._oTable.getItems();var m=0,r=null,i;var s=null,b=null,E=null,I=false;if(o&&t&&a&&a.length>0){s=o.getColumnKey();if(this._aExistingColumnsItems&&this._aExistingColumnsItems.length>0){b=this._getArrayIndexByItemKey(s,this._aExistingColumnsItems);if(b!==-1){E=this._aExistingColumnsItems[b];if(E&&E.index!==undefined&&E.index===o.getIndex()){I=true;}}}if(o.getIndex()!==undefined&&!I){m=a.length;i=a.indexOf(t);if(i!==o.getIndex()&&o.getIndex()<=m){r=this._oTable.removeItem(t);this._oTable.insertItem(r,o.getIndex());}}if(o.getVisible()!==undefined&&t.getSelected()!==o.getVisible()){t.setSelected(o.getVisible());}if(o.getWidth()!==undefined&&t.data('P13nColumnWidth')!==o.getWidth()){t.data('P13nColumnWidth',o.getWidth());}}};
e.prototype._getTableItemsChangeStatus=function(){var t=false,o=null;var a=this._extractExistingTableItems();if(this._aExistingTableItems&&!a){t=true;}else if(a&&!this._aExistingTableItems){t=true;}else if(this._aExistingTableItems&&a){this._aExistingTableItems.forEach(function(E,i){o=null;if(i<a.length){o=a[i];}if(o){if(E.columnKey!==o.columnKey){t=true;}if(E.index!==o.index){t=true;}if(E.visible!==o.visible){t=true;}if(E.width!==o.width){t=true;}}else{t=true;}if(t){return;}});}return t;};
e.prototype.init=function(){var L=0;var t=this;this._bOnBeforeRenderingFirstTimeExecuted=false;this._bOnAfterRenderingFirstTimeExecuted=false;this._aExistingColumnsItems=null;this._aExistingTableItems=null;this.setType(sap.m.P13nPanelType.columns);this._oTableItemsOrdering={"_bShallBeOrdered":true,"_bShallBeOrderedOnlyFirstTime":true,"_bAreOrdered":false,"fIsOrderingToBeDoneOnlyFirstTime":function(){return this._bShallBeOrderedOnlyFirstTime;},"fOrderOnlyFirstTime":function(){this._bShallBeOrdered=true;},"fIsOrderingToBeDone":function(s){if(s!==undefined&&s!==null){this._bShallBeOrdered=s;}return this._bShallBeOrdered;},"fIsOrderingDone":function(a){if(a!==undefined&&a!==null){this._bAreOrdered=a;}return this._bAreOrdered;},"fCheckReOrdering":function(){if(this.fIsOrderingToBeDone()){this._bAreOrdered=false;}}};this.setVerticalScrolling(false);this._fnHandleResize=function(){var b=false,s,i;if(t.getParent){var p=null,$=null,a,h;p=t.getParent();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&t._oToolbar.$().length>0){s=t._oScrollContainer.$()[0].clientHeight;a=$.children()[0].clientHeight;h=t._oToolbar?t._oToolbar.$()[0].clientHeight:0;i=a-h;if(s!==i){t._oScrollContainer.setHeight(i+'px');b=true;}}}}return b;};this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMoveToTopButton=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),press:function(){t._ItemMoveToTop();},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});this._oMoveUpButton=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),press:function(){t._ItemMoveUp();},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});this._oMoveDownButton=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),press:function(){t._ItemMoveDown();},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});this._oMoveToBottomButton=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),press:function(){t._ItemMoveToBottom();},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});this._oShowSelectedButton=new sap.m.Button({text:this._oRb.getText('COLUMNSPANEL_SHOW_SELECTED'),press:function(){t._swopShowSelectedButton();},layoutData:new sap.m.OverflowToolbarLayoutData({"moveToOverflow":true})});this._bShowSelected=false;this._bSearchFilterActive=false;this._oSearchField=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(L);if(D){L=window.setTimeout(function(){t._executeSearch();},D);}else{t._executeSearch();}},search:function(E){t._executeSearch();},layoutData:new sap.m.OverflowToolbarLayoutData({"minWidth":"12.5rem","maxWidth":"23.077rem","shrinkable":true,"moveToOverflow":false,"stayInOverflow":false})});this._oToolbarSpacer=new sap.m.ToolbarSpacer();this._oToolbar=new sap.m.OverflowToolbar({design:sap.m.ToolbarDesign.Solid,content:[this._oToolbarSpacer,this._oSearchField,this._oShowSelectedButton,this._oMoveToTopButton,this._oMoveUpButton,this._oMoveDownButton,this._oMoveToBottomButton]});this.addAggregation("content",this._oToolbar);this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:function(E){t._itemPressed(E);},selectionChange:function(E){t._updateSelectAllDescription(E);var s=E.getParameter('selected');var a=E.getParameter('listItems');var b=[],o=null;a.forEach(function(f){f.setSelected(s);o={"columnKey":f.data('P13nColumnKey'),"visible":f.getSelected()};b.push(o);});t._handleItemVisibilityChanged(b);var v=t.getValidationExecutor();if(v){v();}if(a.length===1&&s===true){if(a[0]!==t._oSelectedItem){t._changeSelectedItem(a[0]);}}},columns:[new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_SELECT_ALL')})})]});this._oScrollContainer=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",this._oScrollContainer);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this._oScrollContainer,this._fnHandleResize);};
e.prototype.reInitialize=function(){this._oTableItemsOrdering.fOrderOnlyFirstTime();this._oTableItemsOrdering.fCheckReOrdering();};
e.prototype.onBeforeRendering=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){this._bOnBeforeRenderingFirstTimeExecuted=true;if(this._oTableItemsOrdering.fIsOrderingToBeDoneOnlyFirstTime()){this._oTableItemsOrdering.fOrderOnlyFirstTime();}}if(!this._oTableItemsOrdering.fIsOrderingDone()&&this._oTableItemsOrdering.fIsOrderingToBeDone()){this._updateTableItems();this._reOrderExistingTableItems();this._oTableItemsOrdering.fIsOrderingDone(true);if(this._oTableItemsOrdering.fIsOrderingToBeDoneOnlyFirstTime()){this._oTableItemsOrdering.fIsOrderingToBeDone(false);}}if(this._aExistingTableItems===null||this._aExistingTableItems===undefined){this._aExistingTableItems=this._extractExistingTableItems();}this._updateSelectAllDescription();this._calculateMoveButtonAppearance();};
e.prototype.onAfterRendering=function(){var t=this,L=0;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(L);L=window.setTimeout(function(){t._oToolbar._resetAndInvalidateToolbar();},0);}};
e.prototype.getOkPayload=function(){var p=null,s=[],o=null;var t=this._extractExistingTableItems();if(t&&t.length>0){p={"tableItems":t,"tableItemsChanged":false,"selectedItems":s};t.forEach(function(a){if(a&&a.visible&&a.visible===true){o={"columnKey":a.columnKey};s.push(o);}});p.tableItemsChanged=this._getTableItemsChangeStatus();}return p;};
e.prototype.getResetPayload=function(){var p=null;p={"oPanel":this};return p;};
e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._oMoveToTopButton.destroy();this._oMoveToTopButton=null;this._oMoveDownButton.destroy();this._oMoveDownButton=null;this._oMoveUpButton.destroy();this._oMoveUpButton=null;this._oMoveToBottomButton.destroy();this._oMoveToBottomButton=null;this._oSearchField.destroy();this._oSearchField=null;this._oToolbar.destroy();this._oToolbar=null;this._oTable.destroy();this._oTable=null;};
e.prototype.addItem=function(i){P.prototype.addItem.apply(this,arguments);this._addTableItem(i);return this;};
e.prototype.insertItem=function(i,I){P.prototype.insertItem.apply(this,arguments);this._insertTableItem(i,I);return this;};
e.prototype.removeItem=function(i){var t=null,I=null,a=null,s=null;i=P.prototype.removeItem.apply(this,arguments);if(i){s=i.getColumnKey();a=this._oTable.getItems();if(a&&a.length>0&&s!==null&&s!==""){I=this._getArrayIndexByItemKey(s,a);if(I!==null&&I!==-1){t=a[I];if(t){this._oTable.removeItem(t);}}}}return i;};
e.prototype.removeAllItems=function(){var i=P.prototype.removeAllItems.apply(this,arguments);if(this._oTable){this._oTable.removeAllItems();}return i;};
e.prototype.destroyItems=function(){P.prototype.destroyItems.apply(this,arguments);if(this._oTable){this._oTable.destroyItems();}return this;};
e.prototype.addColumnsItem=function(o){this.addAggregation("columnsItems",o);this._updateTableItems(o);this._oTableItemsOrdering.fCheckReOrdering();return this;};
e.prototype.insertColumnsItem=function(i,o){this.insertAggregation("columnsItems",o,i);this._updateTableItems(o);this._oTableItemsOrdering.fCheckReOrdering();return this;};
e.prototype.removeColumnsItem=function(o){o=this.removeAggregation("columnsItems",o);this._updateTableItems(o);this._oTableItemsOrdering.fCheckReOrdering();return o;};
e.prototype.removeAllColumnsItems=function(){var a=this.removeAllAggregation("columnsItems");this._oTableItemsOrdering.fCheckReOrdering();return a;};
e.prototype.destroyColumnsItems=function(){this.destroyAggregation("columnsItems");this._oTableItemsOrdering.fCheckReOrdering();return this;};
e.prototype.onBeforeNavigationFrom=function(){var r=true;var s=this._oTable.getSelectedItems();var v=this.getVisibleItemsThreshold();if(s&&v!==-1&&s.length>v){r=false;}return r;};
e.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return e;},true);
sap.ui.predefine('sap/m/P13nConditionPanel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool'],function(q,a,C,D,N,I){"use strict";
var P=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMConditionPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMConditionPanelContent");r.addClass("sapMConditionPanelBG");r.writeClasses();r.write(">");var b=c.getAggregation("content");var l=b.length;for(var i=0;i<l;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
P.prototype.setConditions=function(c){if(!c){q.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<c.length;i++){this._addCondition2Map(c[i]);}this._clearConditions();this._fillConditions();};
P.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
P.prototype.addCondition=function(c){if(this._bIgnoreSetConditions){return;}c.index=this._iConditions;this._addCondition2Map(c);this._addCondition(c);};
P.prototype.insertCondition=function(c,i){if(this._bIgnoreSetConditions){return;}if(i!==undefined){c.index=i;}this._addCondition2Map(c);this._addCondition(c);};
P.prototype.removeCondition=function(c){this._clearConditions();if(typeof(c)=="string"){this._removeConditionFromMap(c);}if(typeof(c)=="object"){this._removeConditionFromMap(c.key);}this._fillConditions();};
P.prototype._addCondition2Map=function(c){if(!c.key){c.key="condition_"+this._iConditions;if(this.getExclude()){c.key="x"+c.key;}}this._iConditions++;this._oConditionsMap[c.key]=c;this._aConditionKeys.push(c.key);};
P.prototype._removeConditionFromMap=function(k){this._iConditions--;delete this._oConditionsMap[k];var i=this._aConditionKeys.indexOf(k);if(i>=0){this._aConditionKeys.splice(i,1);}};
P.prototype.getConditions=function(){var c;var b=[];if(this._oConditionsMap){for(var d in this._oConditionsMap){c=this._oConditionsMap[d];var v=c.value;if(!v){v=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);}if(!c._oGrid||c._oGrid.select.getSelected()){b.push({"key":d,"text":v,"exclude":c.exclude,"operation":c.operation,"keyField":c.keyField,"value1":c.value1,"value2":c.operation===sap.m.P13nConditionOperation.BT?c.value2:null,"showIfGrouped":c.showIfGrouped});}}}return b;};
P.prototype.setOperations=function(o,t){t=t||"default";this._oTypeOperations[t]=o;this._updateAllOperations();};
P.prototype.setValues=function(v,t){t=t||"default";this._oTypeValues[t]=v;};
P.prototype.addOperation=function(o,t){t=t||"default";this._oTypeOperations[t].push(o);this._updateAllOperations();};
P.prototype.removeAllOperations=function(t){t=t||"default";this._oTypeOperations[t]=[];this._updateAllOperations();};
P.prototype.getOperations=function(t){t=t||"default";return this._oTypeOperations[t];};
P.prototype.setKeyFields=function(k){this._aKeyFields=k;this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.addKeyField=function(k){this._aKeyFields.push(k);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
P.prototype.getKeyFields=function(){return this._aKeyFields;};
P.prototype.setAlwaysShowAddIcon=function(e){this.setProperty("alwaysShowAddIcon",e);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
P.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
P.prototype.setContainerQuery=function(e){this._unregisterResizeHandler();this.setProperty("containerQuery",e);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
P.prototype._updateConditionFieldSpans=function(m){if(this._aConditionsFields){var d=m==="Desktop";if(d){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var t=m==="Tablet";if(t){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
P.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":sap.ui.Device.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L1 M2 S2","SpanSort":sap.ui.Device.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
P.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var t=this;this._oPrevButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(e){t._iFirstConditionIndex=Math.max(0,t._iFirstConditionIndex-t._iConditionPageSize);t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oNextButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(e){t._iFirstConditionIndex+=t._iConditionPageSize;t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oRemoveAllButton=new sap.m.Button({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(e){t._aConditionKeys.forEach(function(k,i){if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}},t);this._iFirstConditionIndex=0;t.removeAllConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});var r="CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP";this._oAddButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText(this._oRb.hasText(r)?r:"CONDITIONPANEL_ADD_TOOLTIP"),visible:true,press:function(e){var c=t._createConditionRow(t._oConditionsGrid,undefined,null,0);t._changeField(c);setTimeout(function(){c.keyField.focus();});t._updatePaginatorToolbar();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});this._oHeaderText=new sap.m.Text({wrapping:false,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oPageText=new sap.m.Text({wrapping:false,textAlign:sap.ui.core.TextAlign.Center,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oFilterField=new sap.m.SearchField({width:"12rem",layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.High})});this._oPaginatorToolbar=new sap.m.OverflowToolbar({height:"3rem",design:sap.m.ToolbarDesign.Transparent,content:[this._oHeaderText,new sap.m.ToolbarSpacer(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
P.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var b=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}o.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(e){this._setToolbarElementVisibility(e.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}var h=this._sOrgHeaderText+(i>0?" ("+i+")":"");o.setHeaderText(h);this._oHeaderText.setText(h);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(b+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(b>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var n=0;this._oConditionsGrid.getContent().forEach(function(g){if(g.select.getSelected()){n++;}},this);if(p==b&&(i-this._iFirstConditionIndex)>n){this._clearConditions();this._fillConditions();}};
P.prototype._setToolbarElementVisibility=function(v){this._oPrevButton.setVisible(v);this._oNextButton.setVisible(v);this._oPageText.setVisible(v);this._oFilterField.setVisible(false);this._oAddButton.setVisible(v);this._oRemoveAllButton.setVisible(v);};
P.prototype.exit=function(){this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
P.prototype._clearConditions=function(){this._oConditionsGrid.removeAllContent();};
P.prototype._fillConditions=function(){var c,s;var i=0,m=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var p=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(m,this._iFirstConditionIndex+p));for(i=this._iFirstConditionIndex;i<n;i++){s=this._aConditionKeys[i];c=this._oConditionsMap[s];this._createConditionRow(this._oConditionsGrid,c,s);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<m){this._createConditionRow(this._oConditionsGrid);}};
P.prototype._addCondition=function(c){var i=0;var m=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var b in this._oConditionsMap){if(i<m&&c===this._oConditionsMap[b]){this._createConditionRow(this._oConditionsGrid,c,b,i);}i++;}}this._updatePaginatorToolbar();};
P.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};
P.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
P.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
P.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}sap.ui.Device.media.detachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);};
P.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this._oConditionsGrid,q.proxy(this._onGridResize,this));this._onGridResize();}else{sap.ui.Device.media.attachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}};
P.prototype._getKeyFromConditionGrid=function(c){var k=c.data("_key");if(!k){k=this._createConditionKey();}return k;};
P.prototype._createConditionKey=function(){var i=0;var k;do{k="condition_"+i;if(this.getExclude()){k="x"+k;}i++;}while(this._oConditionsMap[k]);return k;};
P.prototype._createConditionRow=function(t,c,k,p){var b=null;var g;var d=this;if(p===undefined){p=t.getContent().length;}var o=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",k);for(var f in this._aConditionsFields){var e;var h=this._aConditionsFields[f];switch(h["Control"]){case"CheckBox":e=new sap.m.CheckBox({enabled:false,visible:false,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});if(h["ID"]==="showIfGrouped"){e.setEnabled(true);e.setText(h["Label"]);e.attachSelect(function(){d._changeField(o);});e.setSelected(c?c.showIfGrouped:true);}else{if(c){e.setSelected(true);e.setEnabled(true);}}break;case"ComboBox":if(h["ID"]==="keyField"){e=new sap.m.ComboBox({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var O=q.proxy(e.setSelectedKey,e);e.setSelectedKey=function(k){O(k);var m=d.getValidationExecutor();if(m){m();}};var i=q.proxy(e.setSelectedItem,e);e.setSelectedItem=function(m){i(m);var n=d.getValidationExecutor();if(n){n();}};e.setLayoutData(new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]}));this._fillKeyFieldListItems(e,this._aKeyFields);if(e.attachSelectionChange){e.attachSelectionChange(function(E){var m=d.getValidationExecutor();if(m){m();}d._handleSelectionChangeOnKeyField(t,o);});}if(e.attachChange){e.attachChange(function(E){o.keyField.close();d._handleChangeOnKeyField(t,o);});}if(e.setSelectedItem){if(c){e.setSelectedKey(c.keyField);this._aKeyFields.forEach(function(K,m){var n=K.key;if(n===undefined){n=K;}if(c.keyField===n){e.setSelectedItem(e.getItems()[m]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!k){g=t.getContent()[p-1];e.setSelectedKey(g.keyField.getSelectedKey());}else{this._aKeyFields.some(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);return true;}if(!e.getSelectedItem()&&K.type!=="boolean"){e.setSelectedItem(e.getItems()[m]);}},this);}}else{this._aKeyFields.forEach(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);}},this);}}}}if(h["ID"]==="operation"){e=new sap.m.Select({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});e.attachChange(function(){d._handleChangeOnOperationField(t,o);});o[h["ID"]]=e;this._updateOperationItems(t,o);if(c){var K=this._getCurrentKeyFieldItem(o.keyField);var j=this._oTypeOperations["default"];if(K){if(K.type&&this._oTypeOperations[K.type]){j=this._oTypeOperations[K.type];}if(K.operations){j=K.operations;}}j.some(function(m,n){if(c.operation===m){e.setSelectedKey(m);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&k===null){var g=t.getContent()[p-1];e.setSelectedKey(g.operation.getSelectedKey());}}}}if(e.getSelectedItem&&e.getSelectedItem()){e.setTooltip(e.getSelectedItem().getTooltip()||e.getSelectedItem().getText());}break;case"TextField":var l=this._getCurrentKeyFieldItem(o.keyField);e=this._createValueField(l,h,o);e.oTargetGrid=t;if(c&&c[h["ID"]]!==undefined){var v=c[h["ID"]];var V;if(e instanceof sap.m.Select){if(typeof v==="string"&&l.type==="boolean"){v=v==="true";}if(typeof v==="boolean"){e.setSelectedIndex(v?2:1);}else{e.setSelectedItem(e.getItemByKey(v.toString()));}}else{if(typeof v==="string"&&o.oFormatter instanceof sap.ui.core.format.NumberFormat){V=parseFloat(v);v=o.oFormatter.format(V);}if(typeof v==="string"&&o.oFormatter){V=o.oFormatter.parse(v);}else{V=v;}if(!isNaN(V)&&V!==null&&o.oFormatter){v=o.oFormatter.format(V);e.setValue(v);}else{if(!V&&v&&o.oFormatter instanceof sap.ui.core.format.DateFormat){V=new Date(v);v=o.oFormatter.format(V);e.setValue(v);}else{e.setValue(V);}}}}break;case"Label":e=new sap.m.Label({text:h["Text"]+":",visible:this.getShowLabel(),layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");e.oTargetGrid=t;break;}o[h["ID"]]=e;o.addContent(e);}b=new sap.ui.layout.HorizontalLayout({layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");o.addContent(b);o["ButtonContainer"]=b;var r="CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP";var R=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("sys-cancel"),tooltip:this._oRb.getText(this._oRb.hasText(r)?r:"CONDITIONPANEL_REMOVE_TOOLTIP"),press:function(){d._handleRemoveCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});R.oTargetGrid=t;b.addContent(R);o["remove"]=R;r="CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP";var A=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText(this._oRb.hasText(r)?r:"CONDITIONPANEL_ADD_TOOLTIP"),press:function(){d._handleAddCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});A.oTargetGrid=t;A.addStyleClass("conditionAddBtnFloatRight");b.addContent(A);o["add"]=A;t.insertContent(o,p);this._updateOperationItems(t,o);this._changeOperationValueFields(t,o);this._updateAllConditionsEnableStates();this._updateConditionButtons(t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(c){var s=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);c._oGrid=o;c.value=s;this._oConditionsMap[k]=c;}return o;};
P.prototype._handleRemoveCondition=function(t,c){var i=t.getContent().indexOf(c);this._removeCondition(t,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(i>=0){i=Math.min(i,t.getContent().length-1);var c=t.getContent()[i];setTimeout(function(){c.remove.focus();});}this._updatePaginatorToolbar();};
P.prototype._handleAddCondition=function(t,s){var p=t.getContent().indexOf(s);var c=this._createConditionRow(t,undefined,null,p+1);this._changeField(c);setTimeout(function(){c.keyField.focus();});this._updatePaginatorToolbar();};
P.prototype._getCurrentKeyFieldItem=function(k){if(k.getSelectedKey&&k.getSelectedKey()){var K=k.getSelectedKey();var i=this._aKeyFields;for(var b in i){var o=i[b];if(o.key===K){return o;}}}return null;};
P.prototype._createValueField=function(c,f,o){var b;var s=c?c.type:"";var t=this;var p={value:f["Value"],width:"100%",placeholder:f["Label"],change:function(e){t._validateFormatFieldValue(e);t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};switch(s){case"boolean":case"enum":var d=[];var v=c.values||this._oTypeValues[s]||["",false,true];v.forEach(function(V,i){d.push(new sap.ui.core.Item({key:s==="boolean"?(i===v.length-1).toString():V.toString(),text:V.toString()}));});p={width:"100%",items:d,change:function(){t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};o.oFormatter=null;b=new sap.m.Select(p);break;case"numeric":var F;if(c.precision||c.scale){F={};if(c.precision){F["maxIntegerDigits"]=parseInt(c.precision,10);}if(c.scale){F["maxFractionDigits"]=parseInt(c.scale,10);}}o.oFormatter=N.getFloatInstance(F);b=new sap.m.Input(p);break;case"date":o.oFormatter=D.getDateInstance();b=new sap.m.DatePicker(p);break;case"time":o.oFormatter=D.getTimeInstance();b=new sap.m.TimePicker(p);break;default:o.oFormatter=null;b=new sap.m.Input(p);if(this._fSuggestCallback){var c=this._getCurrentKeyFieldItem(o.keyField);if(c&&c.key){var S=this._fSuggestCallback(b,c.key);if(S){b._oSuggestProvider=S;}}}}if(s!=="boolean"&&s!=="enum"){b.onpaste=function(e){var O;if(window.clipboardData){O=window.clipboardData.getData("Text");}else{O=e.originalEvent.clipboardData.getData('text/plain');}var o=e.srcControl.getParent();var g=O.split(/\r\n|\r|\n/g);if(g){setTimeout(function(){var L=g?g.length:0;if(L>1){var k=t._getCurrentKeyFieldItem(o.keyField);var h=o.operation;for(var i=0;i<L;i++){if(t._aConditionKeys.length>=t._getMaxConditionsAsNumber()){break;}if(g[i]){var j={"key":t._createConditionKey(),"exclude":t.getExclude(),"operation":h.getSelectedKey(),"keyField":k.key,"value1":g[i],"value2":null};t._addCondition2Map(j);t.fireDataChange({key:j.key,index:j.index,operation:"add",newData:j});}}t._clearConditions();t._fillConditions();}},0);}};}if(c&&c.maxLength&&b.setMaxLength){var l=-1;if(typeof c.maxLength==="string"){l=parseInt(c.maxLength,10);}if(typeof c.maxLength==="number"){l=c.maxLength;}if(l>0&&(!b.getShowSuggestion||!b.getShowSuggestion())){b.setMaxLength(l);}}return b;};
P.prototype._fillOperationListItems=function(c,o,t){if(t==="_STRING_"){t="";}if(t==="_TIME_"){t="_DATE_";}if(t==="_BOOLEAN_"){t="";}c.destroyItems();for(var O in o){var T=this._oRb.getText("CONDITIONPANEL_OPTION"+t+o[O]);if(q.sap.startsWith(T,"CONDITIONPANEL_OPTION")){T=this._oRb.getText("CONDITIONPANEL_OPTION"+o[O]);}c.addItem(new sap.ui.core.ListItem({key:o[O],text:T,tooltip:T}));}};
P.prototype._fillKeyFieldListItems=function(c,i){c.destroyItems();for(var b in i){var o=i[b];c.addItem(new sap.ui.core.ListItem({key:o.key,text:o.text,tooltip:o.tooltip?o.tooltip:o.text}));}};
P.prototype._handleChangeOnOperationField=function(t,c){this._changeOperationValueFields(t,c);this._changeField(c);};
P.prototype._handleSelectionChangeOnKeyField=function(t,c){if(this._sConditionType==="Filter"){this._updateOperationItems(t,c);this._createAndUpdateValueFields(t,c);this._changeOperationValueFields(t,c);}this._changeField(c);};
P.prototype._handleChangeOnKeyField=function(t,c){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false,false,c.keyField);}};
P.prototype._createAndUpdateAllKeyFields=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._createAndUpdateValueFields(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._createAndUpdateValueFields=function(t,c){var o=this._getCurrentKeyFieldItem(c.keyField);var f=function(c,b,i){var O=b.getValue?b.getValue():"";var d=c.indexOfContent(b);c.removeContent(b);if(b._oSuggestProvider){b._oSuggestProvider.destroy();b._oSuggestProvider=null;}b.destroy();var e=this._aConditionsFields[i];b=this._createValueField(o,e,c);c[e["ID"]]=b;c.insertContent(b,d);var v,V;if(c.oFormatter&&O){v=c.oFormatter.parse(O);if(!isNaN(v)&&v!==null){V=c.oFormatter.format(v);b.setValue(V);}}if(!V){b.setValue(O);}};q.proxy(f,this)(c,c.value1,5);q.proxy(f,this)(c,c.value2,6);};
P.prototype._updateAllOperations=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._updateOperationItems(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._updateOperationItems=function(t,c){var T="";var k=this._getCurrentKeyFieldItem(c.keyField);var o=c.operation;var O=this._oTypeOperations["default"];var b=o.getSelectedItem();if(k&&!this.getExclude()){if(k.type&&k.type!==""&&this._oTypeOperations[k.type]){T=k.type;O=this._oTypeOperations[T];}if(k.operations){O=k.operations;}}this._fillOperationListItems(o,O,T?"_"+T.toUpperCase()+"_":"");if(b&&o.getItemByKey(b.getKey())){o.setSelectedKey(b.getKey());}else{o.setSelectedItem(o.getItems()[0]);}this._sConditionType="Filter";if(O[0]===sap.m.P13nConditionOperation.Ascending||O[0]===sap.m.P13nConditionOperation.Descending){this._sConditionType="Sort";}if(O[0]===sap.m.P13nConditionOperation.GroupAscending||O[0]===sap.m.P13nConditionOperation.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(c);};
P.prototype._updateKeyFieldItems=function(t,f,A,o){var n=t.getContent().length;var i;var u={};if(!f){for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var K=k.getSelectedKey();if(K!=null&&K!==""){u[K]=true;}}}for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var s=t.getContent()[i].select;var O=k.getSelectedKey();var j=0;var b=this._aKeyFields;if(k!==o){if(A){j=b.length-1;}else{k.destroyItems();}for(j;j<b.length;j++){var c=b[j];if(c.key==null||c.key===""||!u[c.key]||c.key===O){k.addItem(new sap.ui.core.ListItem({key:c.key,text:c.text,tooltip:c.tooltip?c.tooltip:c.text}));}}}if(O){k.setSelectedKey(O);}else if(k.getItems().length>0){k.setSelectedItem(k.getItems()[0]);}if(!s.getSelected()){this._aKeyFields.some(function(d,e){if(d.isDefault){k.setSelectedItem(k.getItems()[e]);return true;}if(!k.getSelectedItem()){if(d.type!=="boolean"){k.setSelectedItem(k.getItems()[e]);}}},this);}if(k.getSelectedItem()){k.setTooltip(k.getSelectedItem().getTooltip()||k.getSelectedItem().getText());}}};
P.prototype._changeOperationValueFields=function(t,c){var o=c.operation;var O=o.getSelectedKey();var v=c.value1;var V=c.value2;var s=c.showIfGrouped;if(!O){return;}if(O===sap.m.P13nConditionOperation.BT){if(v.setPlaceholder){v.setPlaceholder(this._sFromLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.setPlaceholder){V.setPlaceholder(this._sToLabelText);}if(!V.getVisible()){V.setVisible(true);c.insertContent(V,c.getContent().length-1);}}else{if(O===sap.m.P13nConditionOperation.GroupAscending||O===sap.m.P13nConditionOperation.GroupDescending){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}if(o.getVisible()){o.setVisible(false);c.removeContent(o);}s.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(O===sap.m.P13nConditionOperation.NotEmpty||O===sap.m.P13nConditionOperation.Empty||O===sap.m.P13nConditionOperation.Initial||O===sap.m.P13nConditionOperation.Ascending||O===sap.m.P13nConditionOperation.Descending||O===sap.m.P13nConditionOperation.Total||O===sap.m.P13nConditionOperation.Average||O===sap.m.P13nConditionOperation.Minimum||O===sap.m.P13nConditionOperation.Maximum){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}c.removeContent(s);}else{if(v.setPlaceholder){v.setPlaceholder(this._sValueLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}}}}this._adjustValue1Span(c);};
P.prototype._adjustValue1Span=function(c){if(this._sConditionType==="Filter"&&c.value1&&c.operation){var o=c.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(o.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=c.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
P.prototype._getIndexOfCondition=function(c){var i=-1;c.getParent().getContent().some(function(g){if(g.select.getSelected()){i++;}return(g===c);},this);return i+this._iFirstConditionIndex;};
P.prototype._makeFieldValid=function(c,v){if(v){c.setValueState(sap.ui.core.ValueState.None);c.setValueStateText("");}else{c.setValueState(sap.ui.core.ValueState.Warning);c.setValueStateText(this._sValidationDialogFieldMessage);}};
P.prototype._validateFormatFieldValue=function(e){var c=e.oSource;var o=c.getParent();var v;if(c.getDateValue&&e){v=e.getParameter("value");var V=e.getParameter("valid");this._makeFieldValid(c,V);return;}else{v=c.getValue&&c.getValue();}if(!o){return;}if(this.getDisplayFormat()==="UpperCase"&&v){v=v.toUpperCase();c.setValue(v);}if(o.oFormatter&&v){var b=o.oFormatter.parse(v);var V=!isNaN(b)&&b!==null;this._makeFieldValid(c,V);if(V){v=o.oFormatter.format(b);c.setValue(v);}}};
P.prototype._changeField=function(c,e){var k=c.keyField.getSelectedKey();if(c.keyField.getSelectedItem()){c.keyField.setTooltip(c.keyField.getSelectedItem().getTooltip()||c.keyField.getSelectedItem().getText());}else{c.keyField.setTooltip(null);}var o=c.operation.getSelectedKey();if(c.operation.getSelectedItem()){c.operation.setTooltip(c.operation.getSelectedItem().getTooltip()||c.operation.getSelectedItem().getText());}else{c.operation.setTooltip(null);}var v=this._getValueTextFromField(c.value1,c.oFormatter);var V=v;if(c.oFormatter&&v){V=c.oFormatter.parse(v);if(isNaN(V)||V===null){v="";}}var s=this._getValueTextFromField(c.value2,c.oFormatter);var b=s;if(c.oFormatter&&s){b=c.oFormatter.parse(s);if(isNaN(b)||b===null){s="";}}var d=this._getCurrentKeyFieldItem(c.keyField);var f=d?d.type:"";if(f==="boolean"){var g=d.values||this._oTypeValues[f]||["",false,true];var t=g[g.length-1].toString();V=v===t;b=null;}var S=c.showIfGrouped.getSelected();var E=this.getExclude();var h=c.select;var i="";var K;if(k===""||k==null){k=null;K=this._getKeyFromConditionGrid(c);this._removeConditionFromMap(K);this._enableCondition(c,false);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(c,true);i=this._getFormatedConditionText(o,v,s,E,k,S);var l={"value":i,"exclude":E,"operation":o,"keyField":k,"value1":V,"value2":o===sap.m.P13nConditionOperation.BT?b:null,"showIfGrouped":S};K=this._getKeyFromConditionGrid(c);if(i!==""){h.setSelected(true);h.setEnabled(true);var o="update";if(!this._oConditionsMap[K]){o="add";}this._oConditionsMap[K]=l;if(o==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(c),0,K);}c.data("_key",K);this.fireDataChange({key:K,index:this._getIndexOfCondition(c),operation:o,newData:l});}else if(this._oConditionsMap[K]!==undefined){this._removeConditionFromMap(K);c.data("_key",null);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
P.prototype._getValueTextFromField=function(c,f){if(c.getDateValue&&c.getDateValue()){return f.format(c.getDateValue());}if(c instanceof sap.m.Select){return c.getSelectedItem()?c.getSelectedItem().getText():"";}return c.getValue();};
P.prototype._updateAllConditionsEnableStates=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){var k=this._getCurrentKeyFieldItem(o.keyField);var K=k&&k.key!==undefined?k.key:k;var e=K!==""&&K!==null;this._enableCondition(o,e);},this);};
P.prototype._enableCondition=function(c,e){c.operation.setEnabled(e);c.value1.setEnabled(e);c.value2.setEnabled(e);c.showIfGrouped.setEnabled(e);};
P.prototype._removeCondition=function(t,c){var k=this._getKeyFromConditionGrid(c);var i=-1;if(c.select.getSelected()){i=this._getIndexOfCondition(c);}this._removeConditionFromMap(k);c.destroy();if(t.getContent().length<1){this._createConditionRow(t);}else{this._updateConditionButtons(t);}if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}};
P.prototype._updateConditionButtons=function(t){var m=this._getMaxConditionsAsNumber();var n=t.getContent().length;for(var i=0;i<n;i++){var A=t.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<m))||(i===n-1&&i<m-1)){A.removeStyleClass("displayNone");}else{A.addStyleClass("displayNone");}var r=t.getContent()[i].remove;if(m===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){r.addStyleClass("displayNone");}else{r.removeStyleClass("displayNone");}}};
P.prototype.validateConditions=function(){var t=this;var c=function(g){var v=true;for(var i=0;i<g.length;i++){var G=g[i];var b=t._checkCondition(G,i===g.length-1);v=v&&b;}return v;};return c(this._oConditionsGrid.getContent());};
P.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(c){var v=c.value1;var V=c.value2;v.setValueState(sap.ui.core.ValueState.None);v.setValueStateText("");V.setValueState(sap.ui.core.ValueState.None);V.setValueStateText("");},this);};
P.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(c){if(c.value1.getValueState()!==sap.ui.core.ValueState.None||c.value2.getValueState()!==sap.ui.core.ValueState.None){i.push(c);}},this);i.forEach(function(c){this._removeCondition(this._oConditionsGrid,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
P.prototype._checkCondition=function(c,i){var v=true;var b=c.value1;var d=c.value2;var V=b&&(b.getVisible()&&!this._getValueTextFromField(b,c.oFormatter));var e=d&&(d.getVisible()&&!this._getValueTextFromField(d,c.oFormatter));var o=c.operation.getSelectedKey();if(o===sap.m.P13nConditionOperation.BT){if(!V?e:!e){if(V){b.setValueState(sap.ui.core.ValueState.Warning);b.setValueStateText(this._sValidationDialogFieldMessage);}if(e){d.setValueState(sap.ui.core.ValueState.Warning);d.setValueStateText(this._sValidationDialogFieldMessage);}v=false;}else{b.setValueState(sap.ui.core.ValueState.None);b.setValueStateText("");d.setValueState(sap.ui.core.ValueState.None);d.setValueStateText("");}}if((b.getVisible()&&b.getValueState&&b.getValueState()!==sap.ui.core.ValueState.None)||(d.getVisible()&&d.getValueState&&d.getValueState()!==sap.ui.core.ValueState.None)){v=false;}return v;};
P.prototype._getFormatedConditionText=function(o,v,V,e,k,s){var c="";var K=null;if(this._aKeyFields&&this._aKeyFields.length>1){for(var i=0;i<this._aKeyFields.length;i++){var b=this._aKeyFields[i];if(typeof b!=="string"){if(b.key===k&&b.text){K=b.text;}}}}switch(o){case sap.m.P13nConditionOperation.EQ:if(v!==""&&v!==undefined){c="="+v;}break;case sap.m.P13nConditionOperation.GT:if(v!==""&&v!==undefined){c=">"+v;}break;case sap.m.P13nConditionOperation.GE:if(v!==""&&v!==undefined){c=">="+v;}break;case sap.m.P13nConditionOperation.LT:if(v!==""&&v!==undefined){c="<"+v;}break;case sap.m.P13nConditionOperation.LE:if(v!==""&&v!==undefined){c="<="+v;}break;case sap.m.P13nConditionOperation.Contains:if(v!==""&&v!==undefined){c="*"+v+"*";}break;case sap.m.P13nConditionOperation.StartsWith:if(v!==""&&v!==undefined){c=v+"*";}break;case sap.m.P13nConditionOperation.EndsWith:if(v!==""&&v!==undefined){c="*"+v;}break;case sap.m.P13nConditionOperation.BT:if(v!==""&&v!==undefined){if(V!==""){c=v+"..."+V;}}break;case sap.m.P13nConditionOperation.Initial:c="=''";break;case sap.m.P13nConditionOperation.Empty:c="''";break;case sap.m.P13nConditionOperation.NotEmpty:c="!''";break;case sap.m.P13nConditionOperation.Ascending:c="ascending";break;case sap.m.P13nConditionOperation.GroupAscending:c="ascending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Descending:c="descending";break;case sap.m.P13nConditionOperation.GroupDescending:c="descending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Total:c="total";break;case sap.m.P13nConditionOperation.Average:c="average";break;case sap.m.P13nConditionOperation.Minimum:c="minimum";break;case sap.m.P13nConditionOperation.Maximum:c="maximum";break;}if(e&&c!==""){c="!("+c+")";}if(K&&c!==""){c=K+": "+c;}return c;};
P.prototype._updateLayout=function(r){if(!this._oConditionsGrid){return;}var g=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var b=n;if(r.name==="Tablet"){b=5;}if(r.name==="Phone"){b=3;}if(this._sConditionType==="Filter"){for(var i=0;i<g.length;i++){var c=g[i];c.ButtonContainer.removeStyleClass("floatRight");c.removeContent(c.ButtonContainer);c.insertContent(c.ButtonContainer,b);if(!this.getAlwaysShowAddIcon()){if(b!==n){c.ButtonContainer.removeContent(c.add);c.addContent(c.add);}else{c.removeContent(c.add);c.ButtonContainer.addContent(c.add);}}}}};
P.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var g=this._oConditionsGrid.getContent()[0];if(g.remove&&g.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var t=g.remove.$().position().left-w+g.remove.$().width();this._oPaginatorToolbar.setWidth(t+"px");}}var d=this._oConditionsGrid.getDomRef();if(!d){return;}if(!q(d).is(":visible")){return;}var w=d.clientWidth;var r={};if(w<=this._iBreakPointTablet){r.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){r.name="Tablet";}else{r.name="Desktop";}if(r.name==="Phone"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Tablet"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Desktop"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}};
sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};return P;},true);
sap.ui.predefine('sap/m/P13nDialog',['jquery.sap.global','./Dialog','./IconTabBar','./IconTabFilter','./library','sap/ui/core/EnabledPropagator','sap/m/ButtonType','sap/m/DialogRenderer'],function(q,D,I,a,l,E,B,b){"use strict";
var P=D.extend("sap.m.P13nDialog",{
metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:function(r,c){b.render.apply(this,arguments);var i=c._getVisiblePanelID();var p=c.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}
});
E.apply(P.prototype,[true]);
P.prototype.init=function(e){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oResetButton=null;this._mValidationListener={};this._createDialog();};
P.prototype.setShowReset=function(s){this.setProperty("showReset",s);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setVisible(s);}};
P.prototype.setShowResetEnabled=function(e){this.setProperty("showResetEnabled",e);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setEnabled(e);}};
P.prototype.addPanel=function(p){this.addAggregation("panels",p);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){sap.ui.Device.system.phone?N.addItem(n):N.addButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};
P.prototype.insertPanel=function(p,i){this.insertAggregation("panels",p,i);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){sap.ui.Device.system.phone?N.insertItem(n):N.insertButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};
P.prototype.removePanel=function(p){p=this.removeAggregation("panels",p);var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.removeItem(p&&this._getNavigationItemByPanel(p)):n.removeButton(p&&this._getNavigationItemByPanel(p));}return p;};
P.prototype.removeAllPanels=function(){var p=this.removeAllAggregation("panels");var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.removeAllItems():n.removeAllButtons();}return p;};
P.prototype.destroyPanels=function(){this.destroyAggregation("panels");var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.destroyItems():n.destroyButtons();}return this;};
P.prototype._createDialog=function(){if(sap.ui.Device.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new sap.m.Bar({contentLeft:new sap.m.Button({visible:false,type:B.Back,press:function(e){t._backToList();}}),contentMiddle:new sap.m.Title({text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H1"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
P.prototype._getNavigationControl=function(){if(this.getPanels().length<2){return null;}var t=this;if(sap.ui.Device.system.phone){if(!this.getContent().length){this.addContent(new sap.m.List({mode:sap.m.ListMode.None,itemPress:function(e){if(e){t._switchPanel(e.getParameter("listItem"));}}}));this.getContent()[0].addItem(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getContent()[0];}else{if(!this.getSubHeader()||!this.getSubHeader().getContentLeft().length){this.setSubHeader(new sap.m.Bar({contentLeft:[new sap.m.SegmentedButton({select:function(e){t._switchPanel(e.getParameter("button"));},width:'100%'})]}));this.getSubHeader().getContentLeft()[0].addButton(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getSubHeader().getContentLeft()[0];}};
P.prototype.showValidationDialog=function(c,f,v){if(!f.length&&!v.length){return;}var m=[];v.forEach(function(r){if(r.messageText&&m.indexOf(r.messageText)<0){m.push(r.messageText);}});var w=(f.length+m.length)>1;var M="";f.forEach(function(p){switch(p){case sap.m.P13nPanelType.filter:M=(w?"• ":"")+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")+"\n"+M;break;case sap.m.P13nPanelType.columns:M=(w?"• ":"")+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")+"\n"+M;break;}});for(var t in m){M=(w?"• ":"")+m[t]+"\n"+M;}q.sap.require("sap.m.MessageBox");sap.m.MessageBox.show(M,{icon:sap.m.MessageBox.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),sap.m.MessageBox.Action.IGNORE],onClose:function(A){if(A===sap.m.MessageBox.Action.IGNORE){c();}},styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});};
P.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}var n=null;if(sap.ui.Device.system.phone){n=new sap.m.StandardListItem({type:sap.m.ListType.Navigation,title:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}else{n=new sap.m.Button({type:B.Default,text:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}p.setValidationExecutor(q.proxy(this._callValidationExecutor,this));p.setValidationListener(q.proxy(this._registerValidationListener,this));p.setChangeNotifier(q.proxy(this._callChangeNotifier,this));return n;};
P.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(sap.ui.Device.system.phone){var N=this._getNavigationControl();if(N){N.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(o){if(o===p){o.beforeNavigationTo();o.setVisible(true);}else{o.setVisible(false);}},this);}this.invalidate();this.rerender();};
P.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._setDialogTitleFor(p);this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
P.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};
P.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),c=p.length;i<c;i++){if(p[i].data("sapMP13nDialogNavigationItem")===n){return p[i];}}return null;};
P.prototype._getNavigationItemByPanel=function(p){if(!p){return null;}return p.data("sapMP13nDialogNavigationItem");};
P.prototype._setVisibilityOfOtherPanels=function(p,v){for(var i=0,c=this.getPanels(),d=c.length;i<d;i++){if(c[i]===p){continue;}c[i].setVisible(v);}};
P.prototype._setVisibilityOfPanel=function(p){var v;if(sap.ui.Device.system.phone){v=this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);this._setVisibilityOfOtherPanels(p,false);}else{v=this.getInitialVisiblePanelType()===p.getType()||this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);if(v){this._setVisibilityOfOtherPanels(p,false);this.setVerticalScrolling(p.getVerticalScrolling());var o=this._getNavigationItemByPanel(p);var n=this._getNavigationControl();if(n){n.setSelectedButton(o);}}}};
P.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var c=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&c){var p=q.find("#"+i);q(p).appendTo(q(c));}};
P.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};
P.prototype._setDialogTitleFor=function(p){var t;if(this.getPanels().length>1){t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}else{switch(p.getType()){case sap.m.P13nPanelType.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case sap.m.P13nPanelType.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case sap.m.P13nPanelType.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case sap.m.P13nPanelType.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case sap.m.P13nPanelType.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(sap.ui.Device.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
P.prototype._registerValidationListener=function(p,c){if(this.getPanels().indexOf(p)&&c&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=c;}};
P.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var r=v(this._getPayloadOfPanels());var R=this._distributeValidationResult(r);for(var t in this._mValidationListener){var c=this._mValidationListener[t];c(R[t]||[]);}}};
P.prototype._callChangeNotifier=function(p){if(this.getShowReset()){this.setShowResetEnabled(true);}};
P.prototype._distributeValidationResult=function(r){var d={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(d[t]===undefined){d[t]=[];}d[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return d;};
P.prototype._createOKButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),press:function(){var p=t._getPayloadOfPanels();var f=function(){t.fireOk({payload:p});};var c=function(){t.getPanels().forEach(function(o){if(F.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});f();};var F=[];var v=[];var V=t.getValidationExecutor();if(V){v=V(p);}t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){F.push(o.getType());}});if(F.length||v.length){t.showValidationDialog(c,F,v);}else{f();}}});};
P.prototype._createCancelButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),press:function(){t.fireCancel();}});};
P.prototype._createResetButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};
P.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};
P.prototype.exit=function(){D.prototype.exit.apply(this,arguments);};
return P;},true);
sap.ui.predefine('sap/m/P13nDimMeasureItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,J){"use strict";
var e=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
e.prototype.init=function(){var t=this;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;this._bOnBeforeRenderingFirstTimeExecuted=false;var m=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],indexOfMarkedTableItem:-1,markedTableItem:null,isMoveDownButtonEnabled:false,isMoveUpButtonEnabled:false,showOnlySelectedItems:false,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nDimMeasurePanel");this.setType(sap.m.P13nPanelType.dimeasure);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,f,h;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;f=$.children()[0].clientHeight;h=o?o.$()[0].clientHeight:0;a=f-h;if(i!==a){s.setHeight(a+'px');b=true;}}}}return b;};this.addAggregation("content",s);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};
e.prototype._moveMarkedTableItem=function(D){var o=this.getModel("$sapmP13nDimMeasurePanel").getData();if(!o.markedTableItem||o.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(o.markedTableItem)<0){return;}var f=function(){switch(D){case"Down":return o.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return o.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[o.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);}};
e.prototype._filterModelItemsBySearchText=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.aggregationRole&&M.aggregationRole.match(r)){M.visible=true;}if(M.role&&M.role.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};
e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};
e.prototype.onBeforeRendering=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){this._bOnBeforeRenderingFirstTimeExecuted=true;this._syncPanel2Model();}var D=this.getModel("$sapmP13nDimMeasurePanel").getData();if(!D.markedTableItem){var v=this._getVisibleTableItems();this._switchMarkedTableItemTo(v[0]);}};
e.prototype.onAfterRendering=function(){var t=this,L=0;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(L);L=window.setTimeout(function(){t._fnHandleResize();t._getToolbar()._resetAndInvalidateToolbar();},0);}};
e.prototype.getOkPayload=function(){this._syncModel2Panel();return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
e.prototype._syncModel2Panel=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){return;}var D=this.getModel("$sapmP13nDimMeasurePanel").getData();this.setChartTypeKey(D.selectedChartTypeKey);D.items.forEach(function(m){var o=this._getDimMeasureItemByColumnKey(m.columnKey);if(o){if(!this._isDimMeasureItemEqualToModelItem(o,m)){o.setVisible(m.persistentSelected);o.setIndex(m.persistentIndex);o.setRole(m.role);}return;}if(!m.persistentSelected){return;}o=new sap.m.P13nDimMeasureItem({columnKey:m.columnKey,visible:m.persistentSelected,index:m.persistentIndex,role:m.role});this.addAggregation("dimMeasureItems",o,true);},this);};
e.prototype._syncPanel2Model=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M||this._isDimMeasureItemEqualToModelItem(o,M)){return;}M.persistentIndex=o.getIndex();M.persistentSelected=o.getVisible();M.role=o.getRole();this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);},this);m.refresh();};
e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this.getModel("$sapmP13nDimMeasurePanel")){this.getModel("$sapmP13nDimMeasurePanel").destroy();}};
e.prototype.setChartTypeKey=function(s){var m=this.getModel("$sapmP13nDimMeasurePanel");this.setProperty("chartTypeKey",s);m.getData().selectedChartTypeKey=s;return this;};
e.prototype.addAvailableChartType=function(i){var m=this.getModel("$sapmP13nDimMeasurePanel");this.addAggregation("availableChartTypes",i);m.getData().availableChartTypes.push({key:i.getKey(),text:i.getText()});return this;};
e.prototype.insertAvailableChartType=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");this.insertAggregation("availableChartTypes",i,I);m.getData().availableChartTypes.splice(I,0,{key:i.getKey(),text:i.getText()});return this;};
e.prototype.removeAvailableChartType=function(i){var I=this.indexOfAvailableChartTypes(i);if(I>-1){var m=this.getModel("$sapmP13nDimMeasurePanel");m.getData().availableChartTypes.splice(I,1);}i=this.removeAggregation("availableChartTypes",i);return i;};
e.prototype.removeAllAvailableChartType=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var i=this.removeAllAggregation("availableChartTypes");m.getData().availableChartTypes=[];return i;};
e.prototype.destroyAvailableChartType=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this.destroyAggregation("availableChartTypes");m.getData().availableChartTypes=[];return this;};
e.prototype.addItem=function(i){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);return this;};
e.prototype.insertItem=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);return this;};
e.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;m.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);}i=this.removeAggregation("items",i);return i;};
e.prototype.removeAllItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this._bOnBeforeRenderingFirstTimeExecuted=false;var i=this.removeAllAggregation("items");m.getData().items=[];return i;};
e.prototype.destroyItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this._bOnBeforeRenderingFirstTimeExecuted=false;this.destroyAggregation("items");m.getData().items=[];return this;};
e.prototype.addDimMeasureItem=function(D){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();this.addAggregation("dimMeasureItems",D);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=D.getIndex();M.persistentSelected=D.getVisible();M.role=D.getRole();this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return this;};
e.prototype.insertDimMeasureItem=function(D,i){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();this.insertAggregation("dimMeasureItems",D,i);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=D.getIndex();M.persistentSelected=D.getVisible();M.role=D.getRole();this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return this;};
e.prototype.removeDimMeasureItem=function(D){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();D=this.removeAggregation("dimMeasureItems",D);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return D;};
e.prototype.removeAllDimMeasureItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);var a=this.removeAllAggregation("dimMeasureItems");return a;};
e.prototype.destroyDimMeasureItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);this.destroyAggregation("dimMeasureItems");return this;};
e.prototype._includeModelItem=function(i,I){if(I<0){I=this._oTable.getItems().length;}var t=this;var g=function(){if(i.getAggregationRole()==="Dimension"){return[{key:"category",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"series",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_SERIES')}];}if(i.getAggregationRole()==="Measure"){return[{key:"axis1",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS2')}];}return[];};var m={columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),aggregationRole:i.getAggregationRole(),availableRoleTypes:g(),persistentIndex:-1,persistentSelected:undefined,role:undefined,tableIndex:undefined};var M=this.getModel("$sapmP13nDimMeasurePanel");M.getData().items.splice(I,0,m);};
e.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));};
e.prototype._onSelectionChange=function(E){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();var t=E.getParameter("listItem");this._switchMarkedTableItemTo(t);this._reindexModelItemsByPersistentIndex(D);m.refresh();this._notifyChange();};
e.prototype._onSwitchButtonShowSelected=function(){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();D.showOnlySelectedItems=!D.showOnlySelectedItems;this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();this._fnHandleResize();};
e.prototype._onExecuteSearch=function(){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};
e.prototype._getDimMeasureItemByColumnKey=function(s){for(var i=0,D=this.getDimMeasureItems(),a=D.length;i<a;i++){if(D[i].getColumnKey()===s){return D[i];}}return null;};
e.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this.getModel("$sapmP13nDimMeasurePanel").getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};
e.prototype._getModelItemByColumnKey=function(s){var m=null;this.getModel("$sapmP13nDimMeasurePanel").getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};
e.prototype._moveModelItems=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();if(i<0||I<0||i>D.items.length-1||I>D.items.length-1){return false;}var M=D.items.splice(i,1);D.items.splice(I,0,M[0]);this._reindexModelItemsByPersistentIndexAndTableIndex(D);m.refresh();return true;};
e.prototype._switchVisibilityOfUnselectedModelItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var s=this._isFilteredByShowSelected();m.getData().items.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});m.refresh();};
e.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};
e.prototype._getVisibleModelItems=function(){var v=[];this.getModel("$sapmP13nDimMeasurePanel").getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};
e.prototype._getSelectedModelItems=function(){var s=[];this.getModel("$sapmP13nDimMeasurePanel").getData().items.forEach(function(m){if(m.persistentSelected){s.push(m);}});return s;};
e.prototype._getModelItemByTableItem=function(t){var i=this._getVisibleTableItems().indexOf(t);return this._getVisibleModelItems()[i];};
e.prototype._reindexModelItemsByPersistentIndexAndTableIndex=function(D){var p=-1;D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m,t){m.persistentIndex=-1;if(m.persistentSelected){p++;D.countOfSelectedItems++;m.persistentIndex=p;}m.tableIndex=t;D.countOfItems++;});};
e.prototype._reindexModelItemsByPersistentIndex=function(D){var p=-1;D.countOfSelectedItems=0;D.items.forEach(function(m){m.persistentIndex=-1;if(m.persistentSelected){p++;D.countOfSelectedItems++;m.persistentIndex=p;}});};
e.prototype._reindexModelItemsByTableIndex=function(D){D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m,t){m.tableIndex=t;D.countOfItems++;if(m.persistentSelected){D.countOfSelectedItems++;}});};
e.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex<b.persistentIndex){return-1;}else if(a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
e.prototype._switchMarkedTableItemTo=function(t){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();if(D.markedTableItem===t){return;}if(D.markedTableItem){D.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}D.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);D.markedTableItem=t;if(D.markedTableItem){D.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._updateControlLogic();};
e.prototype._createTable=function(){var t=this;this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(m){if(m.aggregationRole==="Dimension"){return t._oRb.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(m.aggregationRole==="Measure"){return t._oRb.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(i,b){var a=b.getObject();return new sap.ui.core.Item({key:a.key,text:a.text});}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this.getModel("$sapmP13nDimMeasurePanel"));};
e.prototype._createToolbar=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var t=this;var M=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Down");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})});M.setModel(m);var o=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Up");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})});o.setModel(m);var a=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Bottom");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})});a.setModel(m);var b=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Top");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})});b.setModel(m);var s=new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(i){return i?t._oRb.getText('COLUMNSPANEL_SHOW_ALL'):t._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}},press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});s.setModel(m);var L=0;var f=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(L);if(D){L=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});var g=new sap.m.ComboBox({selectedKey:{path:'/selectedChartTypeKey'},items:{path:'/availableChartTypes',template:new sap.ui.core.Item({key:"{key}",text:"{text}"})},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:false,stayInOverflow:false})});g.setModel(m);var h=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:sap.m.ToolbarDesign.Solid,content:[g,new sap.m.ToolbarSpacer(),f,s,b,o,M,a]});this.addAggregation("content",h);};
e.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
e.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
e.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
e.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
e.prototype._isFilteredByShowSelected=function(){return this.getModel("$sapmP13nDimMeasurePanel").getData().showOnlySelectedItems;};
e.prototype._isDimMeasureItemEqualToModelItem=function(D,m){return m.persistentIndex===D.getIndex()&&m.persistentSelected===D.getVisible()&&m.role===D.getRole();};
e.prototype._updateControlLogic=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();D.isMoveUpButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem>0;D.isMoveDownButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem<v.length-1&&D.indexOfMarkedTableItem>-1;var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}m.refresh();};
e.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
e.prototype._showAll=function(){q.sap.log.info("ModelItems: visible tableIndex isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var D=this.getModel("$sapmP13nDimMeasurePanel").getData();var t=this._oTable.getItems();var L=Math.max(D.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=D.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.visible+" "+m.tableIndex+" "+m.persistentSelected+"_"+m.persistentIndex+";    "+o.getId()+" "+o.getCells()[0].getText()+": "+o.getSelected()+" "+o.getCells()[1].getText());}};
return e;},true);
sap.ui.predefine('sap/m/P13nFilterItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nFilterPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var b=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{}}},
renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMFilterPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMFilterPanelContent");r.addClass("sapMFilterPanelBG");r.writeClasses();r.write(">");var d=c.getAggregation("content");var L=d.length;for(var i=0;i<L;i++){r.renderControl(d[i]);}r.write("</div>");r.write("</section>");}
});
b.prototype.setConditions=function(c){var I=[];var e=[];if(c.length){for(var i=0;i<c.length;i++){var o=c[i];if(!o.exclude){I.push(o);}else{e.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(e);if(e.length>0){this._oExcludePanel.setExpanded(true);}};
b.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var e=this._oExcludeFilterPanel.getConditions();return i.concat(e);};
b.prototype.setContainerQuery=function(c){this.setProperty("containerQuery",c);this._oIncludeFilterPanel.setContainerQuery(c);this._oExcludeFilterPanel.setContainerQuery(c);};
b.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);};
b.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
b.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
b.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
b.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
b.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
b.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
b.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
b.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
b.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
b.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields);}};
b.prototype.getKeyFields=function(){return this._aKeyFields;};
b.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();};
b.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();};
b.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes(),10);var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes(),10);if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
b.prototype.init=function(){this.setType(sap.m.P13nPanelType.filter);sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};if(!this._aIncludeOperations["default"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE]);}if(!this._aIncludeOperations["string"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"string");}if(!this._aIncludeOperations["date"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"date");}if(!this._aIncludeOperations["time"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"time");}if(!this._aIncludeOperations["numeric"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numeric");}if(!this._aIncludeOperations["boolean"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ],"boolean");}this._aExcludeOperations={};if(!this._aExcludeOperations["default"]){this.setExcludeOperations([sap.m.P13nConditionOperation.EQ]);}this._oIncludePanel=new sap.m.Panel({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new sap.m.Panel({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
b.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aIncludeOperations=d(this._aIncludeOperations);this._aExcludeOperations=d(this._aExcludeOperations);this._oRb=d(this._oRb);};
b.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i),maxLength:g("maxLength",o,i),type:g("type",o,i),precision:g("precision",o,i),scale:g("scale",o,i),isDefault:g("isDefault",o,i),values:g("values",o,i)});var n=k.length;if(k[n-1].maxLength===1||k[n-1].maxLength==="1"){k[n-1].operations=[sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE];}});this.setKeyFields(k);var c=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(f){var o=f.getBindingContext(m);if(f.getBinding("key")&&o){o.getObject()[f.getBinding("key").getPath()]=f.getKey();}c.push({key:f.getKey(),keyField:g("columnKey",o,f),operation:g("operation",o,f),value1:g("value1",o,f),value2:g("value2",o,f),exclude:g("exclude",o,f)});});this.setConditions(c);}};
b.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
b.prototype.removeItem=function(i){a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;};
b.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.addFilterItem=function(f){this.addAggregation("filterItems",f);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
b.prototype.insertFilterItem=function(f,i){this.insertAggregation("filterItems",f,i);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
b.prototype.removeFilterItem=function(f){f=this.removeAggregation("filterItems",f);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
b.prototype.removeAllFilterItems=function(){var f=this.removeAllAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
b.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var c=e.getParameter("index");var f;var I=-1;var E=e.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(d,i){if((!d.getExclude()&&!E)||(d.getExclude()&&E)){c--;}I=i;return c<0;},this);if(o==="update"){f=t.getFilterItems()[I];if(f){f.setExclude(n.exclude);f.setColumnKey(n.keyField);f.setOperation(n.operation);f.setValue1(n.value1);f.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:f});t._notifyChange();}if(o==="add"){if(c>=0){I++;}f=new sap.m.P13nFilterItem({key:k,columnKey:n.keyField,exclude:n.exclude,operation:n.operation,value1:n.value1,value2:n.value2});t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:f});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t._bIgnoreBindCalls=false;t._notifyChange();}};};
b.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return b;},true);
sap.ui.predefine('sap/m/P13nGroupItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nGroupPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var c=a.extend("sap.m.P13nGroupPanel",{
metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:function(r,o){r.write("<section");r.writeControlData(o);r.addClass("sapMGroupPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMGroupPanelContent");r.addClass("sapMGroupPanelBG");r.writeClasses();r.write(">");var b=o.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
c.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}};
c.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
c.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);};
c.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);};
c.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
c.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
c.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
c.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
c.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
c.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
c.prototype.init=function(){this.setType(sap.m.P13nPanelType.group);sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMGroupPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.GroupAscending,sap.m.P13nConditionOperation.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
c.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aOperations=d(this._aOperations);};
c.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});this._oGroupPanel.setKeyFields(k);var b=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(G){var o=G.getBindingContext(m);if(G.getBinding("key")){o.getObject()[G.getBinding("key").getPath()]=G.getKey();}b.push({key:G.getKey(),keyField:g("columnKey",o,G),operation:g("operation",o,G),showIfGrouped:g("showIfGrouped",o,G)});});this._oGroupPanel.setConditions(b);}};
c.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeItem=function(i){a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
c.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
c.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new sap.m.P13nGroupItem({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
c.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(o){var b=o.keyField;s.push(b.getSelectedKey());});return{selectedColumnKeys:s};};
c.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
c.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(o){var b=o.keyField;b.setValueStateText("");b.setValueState("None");var s=b.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){b.setValueStateText(r.messageText);b.setValueState(r.messageType);}});});};
c.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}};
c.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return c;},true);
sap.ui.predefine('sap/m/P13nItem',['jquery.sap.global','./library','sap/ui/core/Element'],function(q,l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},precision:{type:"string",group:"Misc",defaultValue:null},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nPanel',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapMP13nPanel");r.writeClasses();r.write(">");r.write("</span>");}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){return;};
return P;},true);
sap.ui.predefine('sap/m/P13nSortItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nSortPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var c=a.extend("sap.m.P13nSortPanel",{
metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:function(r,o){if(!o.getVisible()){return;}r.write("<section");r.writeControlData(o);r.addClass("sapMSortPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMSortPanelContent");r.addClass("sapMSortPanelBG");r.writeClasses();r.write(">");var b=o.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
c.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
c.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);};
c.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);};
c.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
c.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
c.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
c.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
c.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
c.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}};
c.prototype.init=function(){this.setType(sap.m.P13nPanelType.sort);sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMSortPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.Ascending,sap.m.P13nConditionOperation.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
c.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aOperations=d(this._aOperations);};
c.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});this._oSortPanel.setKeyFields(k);var b=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}b.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(b);}};
c.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeItem=function(i){a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.addSortItem=function(s){this.addAggregation("sortItems",s);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
c.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
c.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new sap.m.P13nSortItem({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
c.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return c;},true);
sap.ui.predefine('sap/m/QuickView',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','./QuickViewBase','./ResponsivePopover','./NavContainer','./PlacementType','./Page','./Bar','./Button'],function(q,l,C,I,Q,R,N,P,a,B,b){"use strict";
var c=Q.extend("sap.m.QuickView",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:P.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}}});
c.prototype.init=function(){var n={pages:[new a()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});}});this._oPopover.addStyleClass('sapMQuickView');var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;this._oPopover.addStyleClass("sapMQuickView");};
c.prototype.onBeforeRenderingPopover=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this.getAggregation("pages");if(!p&&sap.ui.Device.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
c.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype._createPage=function(o){return o._createPage();};
c.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
c.prototype._afterOpen=function(e){if(sap.ui.Device.system.phone){this._restoreFocus();}};
c.prototype._addEmptyPage=function(){var p=new a({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var o=p.getCustomHeader();o.addContentRight(new b({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
c.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
c.prototype._adjustContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
c.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
c.prototype.getCloseButton=function(){if(!sap.ui.Device.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
c.prototype.openBy=function(o){this._bItemsChanged=true;this._oPopover.openBy(o);return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){c.prototype["_"+f+"Old"]=c.prototype[f];c.prototype[f]=function(){var r=c.prototype["_"+f+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._oPopover.invalidate();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return c;},true);
sap.ui.predefine('sap/m/QuickViewBase',['jquery.sap.global','./library','sap/ui/core/Control','jquery.sap.dom'],function(q,l,C){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"}}}}}});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===q.sap.KeyCodes.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);this.fireNavigate(e.getParameters());};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();this.fireAfterNavigate(p);q.sap.delayedCall(0,this,this._restoreFocus);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){q.sap.focus(f);}};
return Q;},true);
sap.ui.predefine('sap/m/QuickViewCard',['jquery.sap.global','./library','sap/ui/core/Control','./QuickViewBase','./NavContainer','./Page','./ScrollContainer'],function(q,l,C,Q,N,P,S){"use strict";
var a=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}}}});
a.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
a.prototype.onBeforeRendering=function(){this._initPages();};
a.prototype.onAfterRendering=function(){this.$().find(".sapMLnk").css("width","auto");};
a.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
a.prototype.onkeydown=function(e){this._processKeyboard(e);};
a.prototype._createPage=function(o){var c=o._createPageContent();var b=new S(this.getId()+'-'+o.getPageId(),{horizontal:false,vertical:false});if(c.header){b.addContent(c.header);}b.addContent(c.form);b.addStyleClass('sapMQuickViewPage');return b;};
return a;},true);
sap.ui.predefine('sap/m/QuickViewGroupElement',['jquery.sap.global','./library','sap/ui/core/Element','./QuickViewGroupElementType','./Link','./Text','sap/ui/core/CustomData'],function(q,l,E,G,L,T,C){"use strict";
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(Q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue()});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(Q){b=Q+'-'+b;}return new L({href:"#",text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(){E.prototype.setProperty.apply(this,arguments);var g=this.getParent();if(!g){return;}var p=g.getParent();if(p){p._updatePage();}};
return a;},true);
sap.ui.predefine('sap/m/QuickViewPage',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/layout/form/SimpleForm','sap/ui/layout/VerticalLayout','sap/ui/layout/HorizontalLayout','./Page','./Button','./ButtonType','./Bar','./Title','./Image','./Link','./Text','./QuickViewGroupElementType','./Label','./HBox','sap/ui/core/Icon','sap/ui/core/Title','sap/ui/core/TitleLevel','sap/ui/core/CustomData','sap/ui/layout/form/SimpleFormLayout'],function(q,l,C,I,S,V,H,P,B,a,b,T,c,L,d,Q,f,g,h,i,m,n,o){"use strict";
var p=C.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"}}}});
p.prototype.init=function(){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
p.prototype.setNavContext=function(e){this._mNavContext=e;};
p.prototype.getNavContext=function(){return this._mNavContext;};
p.prototype.setPageTitleControl=function(t){this._oPageTitle=t;};
p.prototype.getPageTitleControl=function(){return this._oPageTitle;};
p.prototype._createPage=function(){var e=this._createPageContent();var N=this.getNavContext();var j;if(this._oPage){j=this._oPage;j.destroyContent();j.setCustomHeader(new b());}else{j=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new b()});j.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(e.header){j.addContent(e.header);}j.addContent(e.form);var k=j.getCustomHeader();k.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){k.addContentLeft(new B({type:a.Back,tooltip:this._oResourceBundle.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.navContainer.back();}}}));}if(N.popover&&sap.ui.Device.system.phone){k.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}j.addStyleClass('sapMQuickViewPage');return j;};
p.prototype.onAfterRenderingPage=function(){if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
p.prototype._createPageContent=function(){var F=this._createForm();var e=this._getPageHeaderContent();var j=this.getPageTitleControl();if(e&&j){F.addAriaLabelledBy(j);}return{form:F,header:e};};
p.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:o.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
p.prototype._getPageHeaderContent=function(){var e,v=new V(),j=new H();var s=this.getIcon();var t=this.getTitle();var D=this.getDescription();if(!s&&!t&&!D){return null;}if(s){if(this.getIcon().indexOf("sap-icon")==0){e=new h({src:s,useIconTooltip:false,tooltip:t});}else{e=new c({src:s,decorative:false,tooltip:t}).addStyleClass("sapUiIcon");}e.addStyleClass("sapMQuickViewThumbnail");if(this.getTitleUrl()){e.attachPress(this._crossApplicationNavigation(this));}j.addContent(e);}var k;if(this.getTitleUrl()){k=new L({text:t,href:this.getTitleUrl(),target:"_blank"});}else if(this.getCrossAppNavCallback()){k=new L({text:t});k.attachPress(this._crossApplicationNavigation(this));}else{k=new T({text:t,level:m.H1});}this.setPageTitleControl(k);var r=new d({text:D});v.addContent(k);v.addContent(r);j.addContent(v);return j;};
p.prototype._renderGroup=function(G,F){var e=G.getAggregation("elements");var j,r,s;if(G.getHeading()){F.addContent(new i({text:G.getHeading(),level:m.H2}));}if(!e){return;}var N=this.getNavContext();for(var k=0;k<e.length;k++){j=e[k];if(!j.getVisible()){continue;}s=new f({text:j.getLabel()});var t;if(N){t=N.quickViewId;}r=j._getGroupElementValue(t);F.addContent(s);if(!r){F.addContent(new sap.m.Text({text:""}));continue;}if(r instanceof L){r.addAriaLabelledBy(r);}s.setLabelFor(r.getId());if(j.getType()==Q.pageLink){r.attachPress(this._attachPressLink(this));}if(j.getType()==Q.mobile&&!sap.ui.Device.system.desktop){var u=new h({src:I.getIconURI("post"),tooltip:this._oResourceBundle.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new n({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var v=new g({items:[r,u]});F.addContent(v);}else{F.addContent(r);}}};
p.prototype._crossApplicationNavigation=function(t){return function(){if(t.getCrossAppNavCallback()&&t.oCrossAppNavigator){var e=t.getCrossAppNavCallback();if(typeof e=="function"){var j=e();var k=t.oCrossAppNavigator.hrefForExternal({target:{semanticObject:j.target.semanticObject,action:j.target.action},params:j.params});sap.m.URLHelper.redirect(k);}}else if(t.getTitleUrl()){window.open(t.getTitleUrl(),"_blank");}};};
p.prototype.exit=function(){this._oResourceBundle=null;this._oPage=null;this._mNavContext=null;};
p.prototype._attachPressLink=function(t){var N=t.getNavContext();return function(e){e.preventDefault();var s=this.getCustomData()[0].getValue();if(N.navContainer&&s){N.navContainer.to(s);}};};
p.prototype._mobilePress=function(){var s="sms://"+q.sap.encodeURL(this.getCustomData()[0].getValue());window.location.replace(s);};
p.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();N.quickView._clearContainerHeight();this._createPage();N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){p.prototype["_"+F+"Old"]=p.prototype[F];p.prototype[F]=function(){var r=p.prototype["_"+F+"Old"].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});
p.prototype.setProperty=function(){C.prototype.setProperty.apply(this,arguments);this._updatePage();};
return p;},true);
/*!
 * @copyright@
 */
sap.ui.predefine('sap/m/NumericContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var v=c.getValue();var i=c.getIndicator();var s=c.getScale();var S=c.getState();var I=sap.m.DeviationIndicator.None!==i&&v!=="";var w=c.getWithMargin();var W;if(w){W="";}else{W="WithoutMargin";}if(c.getFormatterValue()){var f=c._parseFormattedValue(v);s=f.scale;v=f.value;}var b=s&&v;r.write("<div");r.writeControlData(c);var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.writeAttributeEscaped("title",t);r.writeAttribute("role","presentation");if(sap.ui.Device.browser.firefox){r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+""+t);}else{r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+" "+t);}if(S==sap.m.LoadState.Failed||S==sap.m.LoadState.Loading){r.writeAttribute("aria-disabled","true");}if(c.getAnimateTextChange()){r.addStyle("opacity","0.25");}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.addClass("sapMNC");r.addClass(W);if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNCInner");r.addClass(W);r.writeClasses();r.write(">");if(w){this._renderScaleAndIndicator(r,c,I,b,W,i,s);this._renderValue(r,c,W,v);}else{this._renderValue(r,c,W,v);this._renderScaleAndIndicator(r,c,I,b,W,i,s);}r.write("</div>");r.write("</div>");};
N._prepareAndRenderIcon=function(r,c,i){if(i){var s,l=sap.m.LoadState,C=c.getState();for(s in l){if(l.hasOwnProperty(s)&&s!==C){i.removeStyleClass(s);}else if(l.hasOwnProperty(s)&&s===C){i.addStyleClass(s);}}i.addStyleClass("sapMNCIconImage");r.renderControl(i);}};
N._renderScaleAndIndicator=function(r,c,i,a,w,t,b){if(i||a){var s=c.getState();var C=c.getValueColor();r.write("<div");r.addClass("sapMNCIndScale");r.addClass(w);r.addClass(s);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-indicator");r.addClass("sapMNCIndicator");r.addClass(t);r.addClass(s);r.addClass(C);r.writeClasses();r.write("></div>");if(a){r.write("<div");r.writeAttribute("id",c.getId()+"-scale");r.addClass("sapMNCScale");r.addClass(s);r.addClass(C);r.writeClasses();r.write(">");r.writeEscaped(b.substring(0,3));r.write("</div>");}r.write("</div>");}};
N._renderValue=function(r,c,w,v){var e;if(c.getNullifyValue()){e="0";}else{e="";}r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMNCValue");r.addClass(w);r.addClass(c.getValueColor());r.addClass(c.getState());r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-value-scr");r.addClass("sapMNCValueScr");r.addClass(w);r.writeClasses();r.write(">");this._prepareAndRenderIcon(r,c,c._oIcon);var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else{if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped(e);}}r.write("</div>");r.write("</div>");};
return N;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['jquery.sap.global','./Button'],function(q,B){"use strict";
var A=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return A;},false);
sap.ui.predefine('sap/m/AccButtonRenderer',['jquery.sap.global','./ButtonRenderer','sap/ui/core/Renderer'],function(q,B,R){"use strict";var A=R.extend(B);
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.writeAttribute("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.writeAttribute("aria-hidden",c.getAriaHidden());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/EnabledPropagator'],function(q,L,l,E){"use strict";
var A=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
A.prototype.init=function(){this.setType(sap.m.ListType.Active);L.prototype.init.apply(this,arguments);};
A.prototype.getMode=function(){return sap.m.ListMode.None;};
A.prototype.onsapspace=A.prototype.onsapenter;return A;},true);
sap.ui.predefine('sap/m/ActionListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var A=R.extend(L);
A.renderLIAttributes=function(r,l){r.addClass("sapMALI");};
A.renderLIContent=function(r,l){var i=l.getText();if(i){r.write("<div class='sapMALIText'>");r.writeEscaped(i);r.write("</div>");}};
A.getAriaDescribedBy=function(l){var d=this.getAriaAnnouncement("active"),b=L.getAriaDescribedBy.call(this,l)||"";return d+" "+b;};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['jquery.sap.global','./Select','./library'],function(q,S,l){"use strict";
var A=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
A.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
A.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
A.prototype.addContent=function(){var c=sap.ui.getCore(),p=this.getPicker();this.getButtons().forEach(function(b){p.addContent(c.byId(b));});};
A.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
A.prototype.removeButton=function(b){var p=this.getPicker();if(p){if(typeof b==="number"){b=this.getButtons()[b];}p.removeContent(b);}return this.removeAssociation("buttons",b);};
A.prototype.removeAllButtons=function(){var p=this.getPicker();if(p){this.getButtons().forEach(function(b){p.removeContent(b);});}return this.removeAllAssociation("buttons");};
A.prototype.onsaptabprevious=function(e){if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();var b=this.getButtons();var p=this.getPicker();if(p&&p.isOpen()&&b.length>0){sap.ui.getCore().byId(b[b.length-1]).focus();e.preventDefault();}};
A.prototype.onsaptabnext=function(e){if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();var b=this.getButtons();var p=this.getPicker();if(p&&p.isOpen()&&b.length>0){sap.ui.getCore().byId(b[0]).focus();e.preventDefault();}};
A.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)==-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}};
A.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()){this.focus();}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelectRenderer',['jquery.sap.global','sap/ui/core/Renderer','./SelectRenderer'],function(q,R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";
A.addClass=function(r,a){r.addClass(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['jquery.sap.global','./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText'],function(q,D,P,l,C,I,a){"use strict";
var A=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{origin:{type:"sap.m.Button"}},afterClose:{origin:{type:"sap.m.Button"}},cancelButtonPress:{}}}});
A.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);};
A.prototype.exit=function(){sap.ui.Device.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
A.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
A.prototype._setItemNavigation=function(){var b=this._getAllButtons(),d=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<b.length;i++){if(b[i].getEnabled()&&b[i].getVisible()){d.push(b[i].getFocusDomRef());}}if(this._oCancelButton){d.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);}};
A.prototype.onBeforeRendering=function(){this._clearItemNavigation();};
A.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
A.prototype.sapfocusleave=function(){this.close();};
A.prototype.openBy=function(c){var t=this;if(!this._parent){var o=this.getParent();if(o){this.setParent(null);}if(!sap.ui.Device.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t.fireAfterClose();}}).addStyleClass("sapMActionSheetPopover");if(sap.ui.Device.browser.internet_explorer){this._parent._fnAdjustPositionAndArrow=q.proxy(function(){P.prototype._adjustPositionAndArrow.apply(this);var $=this.$(),f=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;q.each($.find(".sapMActionSheet > .sapMBtn"),function(i,b){var d=q(b),B;d.css("width","");B=b.getBoundingClientRect().width;if(B<=f){d.css("width","100%");}});},this._parent);}}else{this._parent=new D({title:this.getTitle(),type:sap.m.DialogType.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(e){t.fireBeforeClose({origin:e.getParameter("origin")});},afterClose:function(e){t.fireAfterClose({origin:e.getParameter("origin")});sap.ui.Device.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}if(!sap.ui.Device.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(sap.ui.Device.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){sap.m.Dialog.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(o){o.addDependent(this._parent);}}if(!sap.ui.Device.system.phone){this._parent.openBy(c);}else{this._parent.open();sap.ui.Device.resize.attachHandler(this._fnOrientationChange);}};
A.prototype.close=function(c){if(this._parent){this._parent.close();}};
A.prototype.isOpen=function(c){return!!this._parent&&this._parent.isOpen();};
A.prototype._createCancelButton=function(){if(!this._oCancelButton){var c=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new sap.m.Button(this.getId()+'-cancelBtn',{text:c,type:sap.m.ButtonType.Reject,press:function(){if(sap.ui.Device.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(sap.ui.Device.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
A.prototype._getCancelButton=function(){if(sap.ui.Device.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
A.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
A.prototype._preProcessActionButton=function(b){var t=b.getType();if(t!==sap.m.ButtonType.Accept&&t!==sap.m.ButtonType.Reject){b.setType(sap.m.ButtonType.Transparent);}b.addStyleClass("sapMBtnInverted");this._parent&&this._parent.invalidate();return this;};
A.prototype.setShowCancelButton=function(v){if(this._parent){if(sap.ui.Device.system.phone){this.setProperty("showCancelButton",v,false);}}else{this.setProperty("showCancelButton",v,true);}return this;};
A.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._parent&&sap.ui.Device.system.phone){this._parent.setTitle(t);this._parent.toggleStyleClass("sapMDialog-NoHeader",!t);}if(this._parent){if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}return this;};
A.prototype.setPlacement=function(p){this.setProperty("placement",p,true);if(!sap.ui.Device.system.phone){if(this._parent){this._parent.setPlacement(p);}}return this;};
A.prototype._buttonSelected=function(){if(sap.ui.Device.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
A.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
A.prototype._addAriaHiddenTexts=function(b){if(sap.ui.getCore().getConfiguration().getAccessibility()){var i=new a();this.addAggregation("_invisibleAriaTexts",i,false);b.addAriaLabelledBy(b.getId());b.addAriaLabelledBy(i.getId());}};
A.prototype.addButton=function(b){this.addAggregation("buttons",b,false);this._addAriaHiddenTexts(b);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this;};
A.prototype.insertButton=function(b,i){this.insertAggregation("buttons",b,i,false);this._addAriaHiddenTexts(b);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this;};
A.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b,false);if(r){r.detachPress(this._buttonSelected,this);}return r;};
A.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,b){b.detachPress(t._buttonSelected,t);});return r;};
A.prototype.clone=function(){var b=this.getButtons();for(var i=0;i<b.length;i++){b[i].detachPress(this._buttonSelected,this);}var c=C.prototype.clone.apply(this,arguments);for(var j=0;j<b.length;j++){b[i].attachPress(this._buttonSelected,this);}return c;};
A.prototype._getAllButtons=function(){return this.getButtons();};
return A;},true);
sap.ui.predefine('sap/m/ActionSheetRenderer',['jquery.sap.global'],function(q){"use strict";var A={};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,v=a.filter(function(B){return B.getVisible();}).length,i,m,B,V=1;for(i=0;i<b;i++){B=a[i];B.removeStyleClass("sapMActionSheetButtonNoIcon");if(B.getIcon()&&B.getVisible()){m=true;}else{B.addStyleClass("sapMActionSheetButtonNoIcon");}}r.write("<div");r.writeControlData(c);r.addClass("sapMActionSheet");if(m){r.addClass("sapMActionSheetMixedButtons");}r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");for(i=0;i<b;i++){B=a[i];r.renderControl(a[i].addStyleClass("sapMActionSheetButton"));if(B.getVisible()&&sap.ui.getCore().getConfiguration().getAccessibility()){I[i].setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));V++;r.renderControl(I[i]);}}if(sap.ui.Device.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.write("</div>");};
return A;},true);
sap.ui.predefine('sap/m/App',['jquery.sap.global','./NavContainer','./library'],function(q,N,l){"use strict";
var A=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
A.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");q.sap.initMobile({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).bind("resize",q.proxy(this._handleOrientationChange,this));};
A.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}q.sap.initMobile({homeIcon:this.getHomeIcon()});};
A.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
A.prototype.exit=function(){q(window).unbind("resize",this._handleOrientationChange);if(this._sInitTimer){q.sap.clearDelayedCall(this._sInitTimer);}};
A.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
A.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){q.sap.log.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
return A;},true);
sap.ui.predefine('sap/m/AppRenderer',['jquery.sap.global','./NavContainerRenderer','sap/ui/core/Renderer'],function(q,N,R){"use strict";var A={};var A=R.extend(N);
A.renderAttributes=function(r,c){sap.m.BackgroundHelper.addBackgroundColorStyles(r,c.getBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){sap.m.BackgroundHelper.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['./OverflowToolbar','./OverflowToolbarRenderer','./Toolbar'],function(O,a,T){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];return b.map(function(c){return sap.ui.getCore().byId(c);});};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.addAssociation("content",b[0],b[3]);case'removeContent':return this.removeAssociation("content",b[0],b[1],b[2]).map(function(d){return sap.ui.getCore().byId(d);});case'destroyContent':var c=this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});c.forEach(function(d){d.destroy();});return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});default:return T.prototype[f].apply(this,b);}};
return A;},false);
sap.ui.predefine('sap/m/Bar.designtime',[],function(){"use strict";return{aggregations:{contentLeft:{domRef:":sap-domref > .sapMBarLeft"},contentMiddle:{domRef:":sap-domref > .sapMBarMiddle > .sapMBarPH"},contentRight:{domRef:":sap-domref > .sapMBarRight"}}};},false);
sap.ui.predefine('sap/m/Bar',['jquery.sap.global','./BarInPageEnabler','./library','sap/ui/core/Control'],function(q,B,l,C){"use strict";
var a=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:sap.m.BarDesign.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},designtime:true}});
a.prototype.onBeforeRendering=function(){this._removeAllListeners();};
a.prototype.onAfterRendering=function(){this._handleResize();};
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
a.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
a._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
a.prototype._removeAllListeners=function(){var t=this;a._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
a.prototype._removeListenerFailsave=function(L){if(this[L]){sap.ui.core.ResizeHandler.deregister(this[L]);this[L]=null;}};
a.prototype._handleResize=function(){this._removeAllListeners();var c=!!this.getContentLeft().length,b=!!this.getContentMiddle().length,d=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!c&&!b&&!d){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(c,b,d);this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(c){this._sResizeListenerIdLeft=sap.ui.core.ResizeHandler.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(b){this._sResizeListenerIdMid=sap.ui.core.ResizeHandler.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(d){this._sResizeListenerIdRight=sap.ui.core.ResizeHandler.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
a.prototype._updatePosition=function(c,b,d){if(!c&&!d&&b){return;}if(c&&!b&&!d){return;}if(!c&&!b&&d){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:'hidden'});var r=this._$RightBar.outerWidth(true);if(r>i){if(c){this._$LeftBar.css({width:"0px"});}if(b){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.width(L);this._$MidBarPlaceHolder.width(0);return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
a.prototype._getMidBarCss=function(r,b,L){var m=this._$MidBarPlaceHolder.outerWidth(true),R=sap.ui.getCore().getConfiguration().getRTL(),s=R?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=b-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'),10)-parseInt(this._$MidBarPlaceHolder.css('margin-right'),10);M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=b-L-r,i=(b/2)-(m/2),c=L>i,d=(b/2)+(m/2),e=(b-r)<d;if(S>0&&(c||e)){M.position="absolute";M.width=S+"px";M.left=R?r:L;}return M;};
a.prototype._getBarContainerWidth=function(c){var i,b=0,d=c.children(),e=0;if(sap.ui.Device.browser.webkit||sap.ui.Device.browser.firefox||sap.ui.Device.browser.edge){for(i=0;i<d.length;i++){e+=q(d[i]).outerWidth(true);}b=c.outerWidth(true);}else{var o;for(i=0;i<d.length;i++){o=window.getComputedStyle(d[i]);if(o.width=="auto"){e+=q(d[i]).width()+1;}else{e+=parseFloat(o.width);}e+=parseFloat(o.marginLeft);e+=parseFloat(o.marginRight);e+=parseFloat(o.paddingLeft);e+=parseFloat(o.paddingRight);}var f=window.getComputedStyle(c[0]);b+=parseFloat(f.width);b+=parseFloat(f.marginLeft);b+=parseFloat(f.marginRight);b+=parseFloat(f.paddingLeft);b+=parseFloat(f.paddingRight);}if(b<e){b=e;}return b;};
a.prototype.isContextSensitive=B.prototype.isContextSensitive;a.prototype.setHTMLTag=B.prototype.setHTMLTag;a.prototype.getHTMLTag=B.prototype.getHTMLTag;a.prototype.applyTagAndContextClassFor=B.prototype.applyTagAndContextClassFor;a.prototype._setLandmarkInfo=B.prototype._setLandmarkInfo;a.prototype._writeLandmarkInfo=B.prototype._writeLandmarkInfo;return a;},true);
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','./PageAccessibleLandmarkInfo','sap/ui/core/InvisibleText'],function(O,P,I){"use strict";var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";var _={},b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var d=function(t,T){if(typeof _[t]==="undefined"){_[t]=new I({text:T}).toStatic().getId();}return _[t];};
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=sap.m.IBarHTMLTag.Div;}return this.sTag;},
applyTagAndContextClassFor:function(C){var o=c[C];if(!o){jQuery.sap.log.error("The context "+C+" is not known",this);return this;}if(!this.isContextSensitive||!this.setHTMLTag){jQuery.sap.log.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}this.setHTMLTag(o.tag);if(o.internalAriaLabel){this._sInternalAriaLabelId=d(o.tag,b.getText(o.internalAriaLabel));}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_setLandmarkInfo:function(h,C){this._bHasLandmarkInfo=h;if(h){this._sLandmarkContext=C;}else{this._sLandmarkContext=null;}},
_writeLandmarkInfo:function(r,C){var e;if(C._bHasLandmarkInfo){P._writeLandmarkInfo(r,C.getParent(),C._sLandmarkContext);}else{e=sap.m.Dialog&&C.getParent()instanceof sap.m.Dialog?"heading":"toolbar";r.writeAccessibilityState(C,{role:e});}},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.write("<"+t);r.addClass(a);if(C._sInternalAriaLabelId){r.writeAccessibilityState(C,{"labelledby":{value:C._sInternalAriaLabelId,append:true}});}if(this.shouldAddIBarContext(C)){r.addClass(a+"-CTX");}r.writeControlData(C);B.renderTooltip(r,C);this.decorateRootElement(r,C);r.writeClasses();r.writeStyles();r.write(">");this.renderBarContent(r,C);r.write("</"+t+">");}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
return B;},true);
sap.ui.predefine('sap/m/BarRenderer',['jquery.sap.global','./BarInPageEnabler'],function(q,B){"use strict";var a={};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.addClass("sapMBar");r.addClass(this.getContext(c));c._writeLandmarkInfo(r,c);if(c.getTranslucent()&&(sap.ui.Device.support.touch||q.sap.simulateMobileOnDesktop)){r.addClass("sapMBarTranslucent");}r.addClass("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){var C="</div>";r.write("<div id='"+c.getId()+"-BarLeft' ");r.addClass('sapMBarLeft');r.addClass('sapMBarContainer');r.writeClasses();w("left",r,c);r.write(">");this.renderAllControls(c.getContentLeft(),r,c);r.write(C);r.write("<div id='"+c.getId()+"-BarMiddle' ");r.addClass('sapMBarMiddle');r.writeClasses();r.write(">");if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new sap.m.HBox(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var b=!!c.getContentLeft().length,d=!!c.getContentMiddle().length,e=!!c.getContentRight().length;if(d&&!b&&!e){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.write("<div id='"+c.getId()+"-BarPH' ");r.addClass('sapMBarPH');r.addClass('sapMBarContainer');w("middle",r,c);r.writeClasses();r.write(">");this.renderAllControls(c.getContentMiddle(),r,c);r.write(C);}r.write(C);r.write("<div id='"+c.getId()+"-BarRight'");r.addClass('sapMBarRight');r.addClass('sapMBarContainer');if(sap.ui.getCore().getConfiguration().getRTL()){r.addClass("sapMRTL");}r.writeClasses();w("right",r,c);r.write(">");this.renderAllControls(c.getContentRight(),r,c);r.write(C);};
a.renderAllControls=function(c,r,b){c.forEach(function(C){sap.m.BarInPageEnabler.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;function e(){r.addStyle("width","100%");r.writeStyles();}switch(A.toLowerCase()){case"left":if(C&&!b&&!d){e();}break;case"middle":if(b&&!C&&!d){e();}break;case"right":if(d&&!C&&!b){e();}break;default:q.sap.log.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device"],function(C,T,L,S,I,a,R,b,D){"use strict";
var B=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});
B.prototype.onBeforeRendering=function(){if(this._bControlsInfoCached){this._updateSelect(true);}};
B.prototype.onAfterRendering=function(){if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();};
B.prototype.onThemeChanged=function(){this._resetControl();};
B.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};
B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
B._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};
B.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
B.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:sap.m.SelectType.IconOnly})));}return this.getAggregation("_select");};
B.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};
function c(A,d){var e=Array.prototype.slice.apply(d);e.unshift(A);return e;}
B.prototype.insertLink=function(l,i){var r=this.insertAggregation.apply(this,c("links",arguments));this._registerControlListener(l);this._resetControl();return r;};
B.prototype.addLink=function(l){var r=this.addAggregation.apply(this,c("links",arguments));this._registerControlListener(l);this._resetControl();return r;};
B.prototype.removeLink=function(o){var r=this.removeAggregation.apply(this,c("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
B.prototype.removeAllLinks=function(){var l=this.getAggregation("links");var r=this.removeAllAggregation.apply(this,c("links",arguments));l.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
B.prototype.destroyLinks=function(){var l=this.getAggregation("links");var r=this.destroyAggregation.apply(this,c("links",arguments));l.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
B.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
B.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
B.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);s.getPicker().getCustomHeader().getContentLeft()[0].setValue(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
B.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
B.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
B.prototype._onSelectEscPress=function(){this._getSelect().close();};
B.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};
B.prototype._selectChangeHandler=function(e){var l,s,d,o=e.getParameter("selectedItem");if(!o){return;}if(!this._getSelect().isOpen()){return;}l=sap.ui.getCore().byId(o.getKey());if(!(l instanceof L)){return;}s=l.getHref();d=l.getTarget();l.firePress();if(s){if(d){window.open(s,d);}else{window.location.href=s;}}};
B.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
B.prototype._updateSelect=function(i){var s=this._getSelect(),d,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.removeAllItems();d=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;d.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
B.prototype._getControlsForBreadcrumbTrail=function(){if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}if(this.getCurrentLocationText()){return this.getLinks().concat([this._getCurrentLocation()]);}return this.getLinks();};
B.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:o.$().parent().outerWidth(true),bCanOverflow:o instanceof L};};
B.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
B.prototype._determineControlDistribution=function(m){var i,o,d=this._getControlsInfo().aControlInfo,s=this._iSelectWidth,e=[],f=[],u=s;for(i=d.length-1;i>=0;i--){o=d[i];u+=o.width;if(d.length-1===i){f.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){e.unshift(o.control);}else{f.unshift(o.control);}}return{aControlsForBreadcrumbTrail:f,aControlsForSelect:e};};
B.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
B.prototype._handleScreenResize=function(e){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(e.size.width),d=o.aControlsForBreadcrumbTrail.length;if(i!==d){this._updateSelect(true);}return this;};
B.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
B.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
B.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
B.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,d=this._getItemsToNavigate(),n=[];d.forEach(function(o,e){if(e===0){o.$().attr("tabIndex","0");}o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setPageSize(B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
B.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};
B.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};
B.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};
B.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
return B;},true);
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Breadcrumbs","sap/m/Text"],function(C,T){"use strict";var B={};
B.render=function(r,c){var a=c._getControlsForBreadcrumbTrail(),s=c._getSelect();r.write("<ul");r.writeControlData(c);r.addClass("sapMBreadcrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-label",C._getResourceBundle().getText("BREADCRUMB_LABEL"));r.write(">");if(s.getVisible()){this._renderControlInListItem(r,s,false,"sapMBreadcrumbsSelectItem");}a.forEach(function(o){this._renderControlInListItem(r,o,o instanceof T);},this);r.write("</ul>");};
B._renderControlInListItem=function(r,c,s,a){r.write("<li");r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.addClass("sapMBreadcrumbsItem");r.addClass(a);r.writeClasses();r.write(">");r.renderControl(c);if(!s){r.write("<span");r.addClass("sapMBreadcrumbsSeparator");r.writeClasses();r.write(">/</span>");}r.write("</li>");};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button'],function(q,l,C,D,B,L,a,P,b){"use strict";
var c=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}}},
renderer:function(r,o){}
});
c.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});function o(){if(sap.ui.getCore().getConfiguration().getAccessibility()){this._$content.attr('role','application');}}this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,showHeader:false,afterOpen:o,initialFocus:this._busyIndicator}).addStyleClass('sapMBusyDialog');this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText();var d=this.getTitle();var s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!d&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
c.prototype.exit=function(){this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}this._oDialog.destroy();this._oDialog=null;};
c.prototype.open=function(){q.sap.log.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(this.getAriaLabelledBy()&&!this._oDialog._$dialog){var t=this;this.getAriaLabelledBy().forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}if(!document.body||!sap.ui.getCore().isInitialized()){setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
c.prototype.close=function(i){this.fireClose({cancelPressed:i||false});this._oDialog.close();};
c.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
c.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
c.prototype.getTooltip=function(){this._oDialog.getTooltip();return this;};
c.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
c.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
c.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
c.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
c.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
c.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
c.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
c.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
c.prototype._getCancelButton=function(){var d=this.getCancelButtonText();d=d?d:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:d,press:function(){this.close(true);}.bind(this)});};
return c;},true);
sap.ui.predefine('sap/m/BusyIndicator',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters'],function(q,l,C,P){"use strict";
var B=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
B.prototype.init=function(){this.setBusyIndicatorDelay(0);};
B.prototype.setText=function(t){this.setProperty("text",t,true);this._createLabel("setText",t);return this;};
B.prototype.setTextDirection=function(d){this.setProperty("textDirection",d,true);this._createLabel("setTextDirection",d);return this;};
B.prototype.setCustomIcon=function(s){this.setProperty("customIcon",s,false);this._createCustomIcon("setSrc",s);return this;};
B.prototype.setCustomIconRotationSpeed=function(s){if(isNaN(s)||s<0){s=0;}if(s!==this.getCustomIconRotationSpeed()){this.setProperty("customIconRotationSpeed",s,true);this._setRotationSpeed();}return this;};
B.prototype.setCustomIconDensityAware=function(a){this.setProperty("customIconDensityAware",a,true);this._createCustomIcon("setDensityAware",a);return this;};
B.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._createCustomIcon("setWidth",w);return this;};
B.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._createCustomIcon("setHeight",h);return this;};
B.prototype.setSize=function(s){this.setProperty("size",s,true);var d=this.getDomRef();if(d){d.style.fontSize=s;}return this;};
B.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}};
B.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
B.prototype._createCustomIcon=function(n,v){if(!this._iconImage){this._iconImage=new sap.m.Image(this.getId()+"-icon",{width:"44px",height:"44px"}).addStyleClass("sapMBsyIndIcon");this._iconImage.addEventDelegate({onAfterRendering:function(){this._setRotationSpeed();}},this);}this._iconImage[n](v);this._setRotationSpeed();};
B.prototype._createLabel=function(n,v){if(!this._busyLabel){this._busyLabel=new sap.m.Label(this.getId()+"-label",{labelFor:this.getId(),textAlign:"Center"});}this._busyLabel[n](v);};
B.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}if(q.support.cssAnimations){var $=this._iconImage.$();var r=this.getCustomIconRotationSpeed()+"ms";$.css("-webkit-animation-duration",r).css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);}else{this._rotateCustomIcon();}};
B.prototype._rotateCustomIcon=function(){if(!this._iconImage){return;}var $=this._iconImage.$();if(!$[0]||!$[0].offsetWidth){return;}var r=this.getCustomIconRotationSpeed();if(!r){return;}if(!this._fnRotateCustomIcon){this._fnRotateCustomIcon=q.proxy(this._rotateCustomIcon,this);}var R=this._fnRotateCustomIcon;if(!this._$CustomRotator){this._$CustomRotator=q({deg:0});}var a=this._$CustomRotator;if(a.running){return;}a[0].deg=0;a.animate({deg:360},{duration:r,easing:"linear",step:function(n){a.running=true;$.css("-ms-transform",'rotate('+n+'deg)');},complete:function(){a.running=false;window.setTimeout(R,10);}});};
return B;},true);
sap.ui.predefine('sap/m/BusyIndicatorRenderer',['jquery.sap.global'],function(q){"use strict";var B={};
B.render=function(r,b){this.startBusyIndicator(r,b);this.renderBusyIndication(r,b);this.renderLabel(r,b);this.endBusyIndicator(r);};
B.startBusyIndicator=function(r,b){var a={role:"progressbar",valuemin:"0",valuemax:"100"};r.write("<div tabindex='0' ");r.writeControlData(b);r.addClass("sapMBusyIndicator");r.writeClasses();r.addStyle("font-size",b.getSize());r.writeStyles();r.writeAccessibilityState(b,a);this.renderTooltip(r,b.getTooltip_AsString());r.write(">");};
B.renderTooltip=function(r,t){if(t){r.writeAttributeEscaped("title",t);}};
B.renderBusyIndication=function(r,b){if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.write("<div class='sapMBusyIndicatorBusyArea'");r.writeAttribute("id",b.getId()+"-busy-area");r.write("></div>");}};
B.renderLabel=function(r,b){if(b.getText()){r.renderControl(b._busyLabel);}};
B.endBusyIndicator=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/m/Button',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/theming/Parameters'],function(q,l,C,E,I,P){"use strict";
var B=C.extend("sap.m.Button",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}}}});
E.call(B.prototype);
B.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}};
B.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;};
B.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}};
B.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(e.targetTouches.length===1){this._activeButton();}};
B.prototype.ontouchend=function(e){this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;if(e.originalEvent&&e.originalEvent.type in{mouseup:1,touchend:1}){this.ontap(e);}}};
B.prototype.ontouchcancel=function(){this._inactiveButton();};
B.prototype.ontap=function(e){e.setMarked();if(this.getEnabled()){if(e.originalEvent&&e.originalEvent.type==="touchend"){this.focus();}this.fireTap({});this.firePress({});}};
B.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._activeButton();}};
B.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._inactiveButton();this.firePress({});}};
B.prototype.onfocusout=function(){this._inactiveButton();};
B.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
B.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getIcon());}}};
B.prototype._isHoverable=function(){return this.getEnabled()&&sap.ui.Device.system.desktop;};
B.prototype._getImage=function(i,s,a,b){if(this._image&&(this._image.getSrc()!==s)){this._image.destroy();this._image=undefined;}var o=this._image;var c=this.getIconFirst();if(!!o){o.setSrc(s);if(o instanceof sap.m.Image){o.setActiveSrc(a);o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:s,activeSrc:a,densityAware:b,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.toggleStyleClass("sapMBtnIconLeft",c);o.toggleStyleClass("sapMBtnIconRight",!c);this._image=o;return this._image;};
B.prototype._getInternalIconBtn=function(i,s){var o=this._iconBtn;if(o){o.setSrc(s);}else{o=I.createControlByURI({id:i,src:s,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
B.prototype._isUnstyled=function(){var u=false;if(this.getType()===sap.m.ButtonType.Unstyled){u=true;}return u;};
B.prototype.setText=function(t){var v=this.getText();if(t===null||t===undefined){t="";}if(v!==t){var d=this.getDomRef("content");var s=!!d;this.setProperty("text",t,s);if(s){t=this.getText();d.innerHTML=q.sap.encodeHTML(t);this.$("inner").toggleClass("sapMBtnText",!!t);}}return this;};
B.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._image){this._image.setSrc(i);}}return this;};
B.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
B.prototype._getText=function(){return this.getText();};
B.prototype.setType=function(t){this.setProperty("type",t);var T="";var r;switch(t){case sap.m.ButtonType.Accept:if(!sap.m.Button._oStaticAcceptText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_ACCEPT");sap.m.Button._oStaticAcceptText=new sap.ui.core.InvisibleText({text:T});sap.m.Button._oStaticAcceptText.toStatic();}break;case sap.m.ButtonType.Reject:if(!sap.m.Button._oStaticRejectText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_REJECT");sap.m.Button._oStaticRejectText=new sap.ui.core.InvisibleText({text:T});sap.m.Button._oStaticRejectText.toStatic();}break;case sap.m.ButtonType.Emphasized:if(!sap.m.Button._oStaticEmphasizedText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_EMPHASIZED");sap.m.Button._oStaticEmphasizedText=new sap.ui.core.InvisibleText({text:T});sap.m.Button._oStaticEmphasizedText.toStatic();}break;default:break;}return this;};
B.prototype.getAccessibilityInfo=function(){var d=this.getText()||this.getTooltip_AsString();if(!d&&this.getIcon()){var i=sap.ui.core.IconPool.getIconInfo(this.getIcon());if(i){d=i.text||i.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:d,focusable:this.getEnabled(),enabled:this.getEnabled()};};
return B;},true);
sap.ui.predefine('sap/m/ButtonRenderer',['jquery.sap.global'],function(q){"use strict";var B={};
B.render=function(r,b){var t=b.getType();var e=b.getEnabled();var w=b.getWidth();var T=b.getTooltip_AsString();var s=b._getText();var a=b.getTextDirection();var i=sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge;var c=sap.ui.core.IconPool.getIconURI("nav-back");r.write("<button");r.writeControlData(b);r.addClass("sapMBtnBase");if(!b._isUnstyled()){r.addClass("sapMBtn");if((t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up)&&b.getIcon()&&!s){r.addClass("sapMBtnBack");}}var A={};var d="";switch(t){case sap.m.ButtonType.Accept:d=sap.m.Button._oStaticAcceptText.getId();break;case sap.m.ButtonType.Reject:d=sap.m.Button._oStaticRejectText.getId();break;case sap.m.ButtonType.Emphasized:d=sap.m.Button._oStaticEmphasizedText.getId();break;default:break;}if(d){A["describedby"]={value:d,append:true};}if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(r,b,A);}r.writeAccessibilityState(b,A);if(!e){r.writeAttribute("disabled","disabled");if(!b._isUnstyled()){r.addClass("sapMBtnDisabled");}}else{switch(t){case sap.m.ButtonType.Accept:case sap.m.ButtonType.Reject:case sap.m.ButtonType.Emphasized:r.addClass("sapMBtnInverted");break;default:break;}}var I=sap.ui.core.IconPool.getIconInfo(b.getIcon());if(T||(I&&I.text&&!b.getText())){r.writeAttributeEscaped("title",T||I.text);}r.writeClasses();if(w!=""||w.toLowerCase()==="auto"){r.addStyle("width",w);r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",b.getId()+"-inner");if(!b._isUnstyled()){r.addClass("sapMBtnInner");}if(b._isHoverable()){r.addClass("sapMBtnHoverable");}if(e){r.addClass("sapMFocusable");if(i){r.addClass("sapMIE");}}if(!b._isUnstyled()){if(s){r.addClass("sapMBtnText");}if(t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up){r.addClass("sapMBtnBack");}if(b.getIcon()){if(b.getIconFirst()){r.addClass("sapMBtnIconFirst");}else{r.addClass("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(r,b);}if(!b._isUnstyled()&&t!==""){r.addClass("sapMBtn"+q.sap.encodeHTML(t));}r.writeClasses();r.write(">");if(t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up){this.writeInternalIconPoolHtml(r,b,c);}if(b.getIcon()){this.writeImgHtml(r,b);}if(s){r.write("<span");r.addClass("sapMBtnContent");if(a!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",a.toLowerCase());}r.writeClasses();r.writeAttribute("id",b.getId()+"-content");r.write(">");r.writeEscaped(s);r.write("</span>");}if(i&&e){r.write('<div class="sapMBtnFocusDiv"></div>');}r.write("</div>");r.write("</button>");};
B.writeImgHtml=function(r,b){r.renderControl(b._getImage((b.getId()+"-img"),b.getIcon(),b.getActiveIcon(),b.getIconDensityAware()));};
B.writeInternalIconPoolHtml=function(r,b,u){r.renderControl(b._getInternalIconBtn((b.getId()+"-iconBtn"),u));};
return B;},true);
sap.ui.predefine('sap/m/Carousel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/thirdparty/mobify-carousel'],function(q,l,C,m){"use strict";
var a=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},busyIndicatorSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'6em',deprecated:true}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"}}}}}});
a._INNER_SELECTOR=".sapMCrslInner";a._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";a._HUD_SELECTOR=".sapMCrslHud";a._ITEM_SELECTOR=".sapMCrslItem";a._LEFTMOST_CLASS="sapMCrslLeftmost";a._RIGHTMOST_CLASS="sapMCrslRightmost";a._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";a._bIE9=(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10);a._MODIFIERNUMBERFORKEYBOARDHANDLING=10;
a.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(a._INNER_SELECTOR);this._oMobifyCarousel.resize($);},this);this.data("sap-ui-fastnavgroup","true",true);};
a.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;if(!a._bIE9&&this._$InnerDiv){q(window).off("resize",this._fnAdjustAfterResize);}this._$InnerDiv=null;};
a.prototype._cleanUpScrollContainer=function(){var s;while(this.length>0){s=this._aScrollContainers.pop();s.removeAllContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};
a.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};
a.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};
a.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};
a.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(!a._bIE9&&this._$InnerDiv){q(window).off("resize",this._fnAdjustAfterResize);}return this;};
a.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel();this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i+1);this._changePage(i+1);if(sap.zen&&sap.zen.commons&&this.getParent()instanceof sap.zen.commons.layout.PositionContainer){if(this._isCarouselUsedWithCommonsLayout===undefined){q.sap.delayedCall(0,this,"invalidate");this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('afterSlide',q.proxy(function(e,P,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}},this));this._$InnerDiv=this.$().find(a._INNER_SELECTOR)[0];if(a._bIE9){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this._$InnerDiv,this._fnAdjustAfterResize);}else{q(window).on("resize",this._fnAdjustAfterResize);}this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var c='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==c){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._oMobifyCarousel.move(i+1);t._changePage(i+1);}});break;}p=p.getParent();}};
a.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);q.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);this.firePageChanged({oldActivePageId:o,newActivePageId:N});};
a.prototype._adjustHUDVisibility=function(n){if(sap.ui.Device.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$().find(a._HUD_SELECTOR);h.removeClass(a._LATERAL_CLASSES);if(n===1){h.addClass(a._LEFTMOST_CLASS);}else if(n===this.getPages().length){h.addClass(a._RIGHTMOST_CLASS);}}};
a.prototype.setActivePage=function(p){var P=null;if(typeof(p)=='string'){P=p;}else if(p instanceof C){P=p.getId();}if(P){if(P===this.getActivePage()){return this;}var i=this._getPageNumber(P);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",P,true);return this;};
a.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",h);return this;};
a.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
a.prototype.setPageIndicatorPlacement=function(p){if(sap.m.PlacementType.Top!=p&&sap.m.PlacementType.Bottom!=p){p=sap.m.PlacementType.Bottom;}this.setProperty("pageIndicatorPlacement",p,true);var P=this.$().find(a._PAGE_INDICATOR_SELECTOR);if(sap.m.PlacementType.Top===p){this.$().prepend(P);P.removeClass('sapMCrslBottomOffset').addClass('sapMCrslTopOffset');this.$().find(a._ITEM_SELECTOR).removeClass('sapMCrslBottomOffset').addClass('sapMCrslTopOffset');}else{this.$().append(P);P.addClass('sapMCrslBottomOffset').removeClass('sapMCrslTopOffset');this.$().find(a._ITEM_SELECTOR).addClass('sapMCrslBottomOffset').removeClass('sapMCrslTopOffset');}return this;};
a.prototype.setShowPageIndicator=function(s){var p=this.$().find(a._PAGE_INDICATOR_SELECTOR);s?p.show():p.hide();this.setProperty("showPageIndicator",s,true);return this;};
a.prototype.setLoop=function(L){this.setProperty("loop",L,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(L);}return this;};
a.prototype._getNavigationArrow=function(n){q.sap.require("sap.ui.core.IconPool");var p={src:"sap-icon://navigation-"+n+"-arrow",useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};
a.prototype._createScrollContainer=function(p){var c=p instanceof sap.m.Image?"sapMCrslItemTableCell sapMCrslImg":"sapMCrslItemTableCell",o=new sap.ui.core.HTML({content:"<div class='sapMCrslItemTable'>"+"<div class='"+c+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();r.render(p,this.getDomRef().firstChild);r.destroy();}});var s=new sap.m.ScrollContainer({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});s.setParent(this,null,true);this._aScrollContainers.push(s);return s;};
a.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
a.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
a.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
a.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};
a.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};
a.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};
a.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};
a.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};
a.prototype.onkeydown=function(e){if(e.keyCode==q.sap.KeyCodes.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case q.sap.KeyCodes.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case q.sap.KeyCodes.PLUS:case q.sap.KeyCodes.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};
a.prototype.onsapescape=function(e){var b;if(e.target===this.$()[0]&&this._lastActivePageNumber){b=this._lastActivePageNumber+1;this._oMobifyCarousel.move(b);this._changePage(b);}};
a.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};
a.prototype.onsapup=function(e){this._fnSkipToIndex(e,1);};
a.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};
a.prototype.onsapdown=function(e){this._fnSkipToIndex(e,-1);};
a.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};
a.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};
a.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsappageup=function(e){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);};
a.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);};
a.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
a.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E);};
a.prototype.saveLastFocusReference=function(e){if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}this._lastFocusablePageElement[this.getActivePage()]=e.target;};
a.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()];}};
a.prototype._fnSkipToIndex=function(e,n){var b=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){b=this._getPageNumber(this.getActivePage())+1+n;}b=Math.max(b,1);b=Math.min(b,this.getPages().length);this._oMobifyCarousel.move(b);};
a.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};
a.prototype.setShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
a.prototype.getShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
a.prototype.setBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setBusyIndicatorSize' called. Does nothing.");return this;};
a.prototype.getBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getBusyIndicatorSize' called. Does nothing.");return"";};
return a;},true);
sap.ui.predefine('sap/m/CarouselRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeAttribute("data-sap-ui-customfastnavgroup","true");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.addClass("sapMCrsl");r.addClass("sapMCrslFluid");r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.writeAttributeEscaped("tabindex","0");r.writeAccessibilityState(c,{role:"list"});r.write(">");var p=c.getPages();var P=p.length;var s=c.getPageIndicatorPlacement();if(s===sap.m.PlacementType.Top){this._renderPageIndicator({rm:r,iPageCount:P,bBottom:false,bShowPageIndicator:c.getShowPageIndicator()});}r.write("<div class='sapMCrslInner'>");c._cleanUpScrollContainer();var R=function(o,i,a){r.write("<div class='sapMCrslItem");if(a.length>1&&c.getShowPageIndicator()){if(s===sap.m.PlacementType.Bottom){r.write(" sapMCrslBottomOffset");}else{r.write(" sapMCrslTopOffset");}}r.write("' id='"+c.sId+"-"+o.sId+"-slide'");r.writeAccessibilityState(o,{role:"listitem",posinset:i+1,setsize:a.length});r.write(">");r.renderControl(c._createScrollContainer(o,i));r.write("</div>");};p.forEach(R);r.write("</div>");if(sap.ui.Device.system.desktop&&P>1){r.write("<div class='sapMCrslControls sapMCrslHud'>");r.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabindex='-1'><div class='sapMCrslHudInner'>");r.renderControl(c._getNavigationArrow('left'));r.write("</div></a>");r.write("<a class='sapMCrslNext' href='#' data-slide='next' tabindex='-1'><div class='sapMCrslHudInner'>");r.renderControl(c._getNavigationArrow('right'));r.write("</div></a>");r.write("</div>");}if(s===sap.m.PlacementType.Bottom){this._renderPageIndicator({rm:r,iPageCount:P,bBottom:true,bShowPageIndicator:c.getShowPageIndicator()});}r.write("</div>");};
C._renderPageIndicator=function(s){var r=s.rm,p=s.iPageCount,b=s.bBottom,S=s.bShowPageIndicator,R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o="",d=S?"":"display: none";if(p>1&&S){if(b){o=" sapMCrslBottomOffset";}else{o=" sapMCrslTopOffset";}}if(p<=1){return;}r.write('<div class="sapMCrslControls sapMCrslBulleted'+o+'" style="'+d+'">');for(var i=1;i<=p;i++){r.write("<span role='img' data-slide="+i+" aria-label='"+R.getText('CAROUSEL_POSITION',[i,p])+"'>"+i+"</span>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/m/CheckBox',['jquery.sap.global','./Label','./library','sap/ui/Device','sap/ui/core/Control',"sap/ui/core/IconPool",'sap/ui/core/EnabledPropagator'],function(q,L,l,D,C,I,E){"use strict";
var a=C.extend("sap.m.CheckBox",{metadata:{library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}}}});
E.call(a.prototype);
a.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();};
a.prototype.onAfterRendering=function(){if(!this.getText()&&!this.$().attr("aria-labelledby")){this.$().attr("aria-label"," ");}};
a.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
a.prototype.setSelected=function(s){s=!!s;if(s==this.getSelected()){return this;}this.$("CbBg").toggleClass("sapMCbMarkChecked",s);this.$().attr("aria-checked",s);var c=this.getDomRef("CB");if(c){s?c.setAttribute('checked','checked'):c.removeAttribute('checked');}this.setProperty("selected",s,true);return this;};
a.prototype.setText=function(t){var o=this._getLabel(),h=!!t;this.setProperty("text",t,true);o.setText(t);this.$().toggleClass("sapMCbHasLabel",h);return this;};
a.prototype.setWidth=function(w){var o=this._getLabel();this.setProperty("width",w,true);o.setWidth(w);return this;};
a.prototype.setTextDirection=function(d){var o=this._getLabel();this.setProperty("textDirection",d,true);o.setTextDirection(d);return this;};
a.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A,true);o.setTextAlign(A);return this;};
a.prototype.addActiveState=function(c){if(D.os.blackberry){c.addDelegate({ontouchstart:function(e){q(c.getDomRef()).addClass("sapMActive");},ontouchend:function(e){q(c.getDomRef()).removeClass("sapMActive");}});}};
a.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;};
a.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()){this.$().focus();var s=!this.getSelected();this.setSelected(s);this.fireSelect({selected:s});e&&e.setMarked();}};
a.prototype.onsapspace=function(e){this.ontap(e);if(e){e.preventDefault();e.stopPropagation();}};
a.prototype.onsapenter=function(e){this.ontap(e);};
a.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
a.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return this.getEnabled()?0:-1;};
a.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
a.prototype.getAccessibilityInfo=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:b.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+b.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEditable()};};
return a;},true);
sap.ui.predefine('sap/m/CheckBoxRenderer',['jquery.sap.global','sap/ui/core/ValueState','sap/ui/core/ValueStateSupport'],function(q,V,a){"use strict";var C={};
C.render=function(r,c){var i=c.getId(),e=c.getEnabled(),E=c.getEditable(),o=c.getAggregation("_label"),I=V.Error===c.getValueState(),b=V.Warning===c.getValueState();r.write("<div");r.addClass("sapMCb");if(!E){r.addClass("sapMCbRo");}if(!e){r.addClass("sapMCbBgDis");}if(I){r.addClass("sapMCbErr");}else if(b){r.addClass("sapMCbWarn");}if(c.getText()){r.addClass("sapMCbHasLabel");}r.writeControlData(c);r.writeClasses();var t=a.enrichTooltip(c,c.getTooltip_AsString());if(t){r.writeAttributeEscaped("title",t);}if(e){r.writeAttribute("tabindex",c.getTabIndex());}r.writeAccessibilityState(c,{role:"checkbox",selected:null,checked:c.getSelected(),describedby:t?i+"-Descr":undefined});r.write(">");r.write("<div id='");r.write(c.getId()+"-CbBg'");r.addClass("sapMCbBg");if(e&&E&&sap.ui.Device.system.desktop){r.addClass("sapMCbHoverable");}if(!c.getActiveHandling()){r.addClass("sapMCbActiveStateOff");}r.addClass("sapMCbMark");if(c.getSelected()){r.addClass("sapMCbMarkChecked");}r.writeClasses();r.write(">");r.write("<input type='CheckBox' id='");r.write(c.getId()+"-CB'");if(c.getSelected()){r.writeAttribute("checked","checked");}if(c.getName()){r.writeAttributeEscaped('name',c.getName());}if(!e){r.write(" disabled=\"disabled\"");}if(!E){r.write(" readonly=\"readonly\"");}r.write(" /></div>");r.renderControl(o);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span id=\""+i+"-Descr\" class=\"sapUiHidden\">");r.writeEscaped(t);r.write("</span>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/m/Column',['jquery.sap.global','./library','sap/ui/core/Element','sap/ui/core/Renderer'],function(q,l,E,R){"use strict";
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:sap.ui.core.VerticalAlign.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:sap.m.PopinDisplay.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}}}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;
C.prototype.exit=function(){this._clearMedia();};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){sap.ui.Device.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){if(this._minWidth){sap.ui.Device.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);sap.ui.Device.media.attachHandler(this._notifyResize,this,this.getId());this._media=sap.ui.Device.media.getCurrentRange(this.getId());if(this._media){this._media.triggered=false;this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(!this._media.triggered){this._media.triggered=true;return;}this._media=m;this._media.triggered=true;this._media.matches=!!m.from;q.sap.delayedCall(0,this,function(){var p=this.getParent();this.fireEvent("media",this);if(p&&p.onColumnResize){p.onColumnResize(this);}});};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(sap.m.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(sap.m.BaseFontSize)||16;q.each(sap.m.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.applyAlignTo=function(c,a){a=a||this.getHAlign();if(a===sap.ui.core.TextAlign.Initial||!c.getMetadata().getProperties().textAlign||c.getTextAlign()===a){return c;}c.setProperty("textAlign",a,true);var d=c.getDomRef();a=this.getCssAlign(a);if(d&&a){d.style.textAlign=a;}return c;};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();var t=sap.ui.core.TextAlign;if(a===t.Begin||a===t.End||a===t.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var c=this.getProperty("styleClass");if(!r){return c;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){c+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){c+=" sapMListTblNone";}return c.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var p=this.getParent();if(p&&p.indexOfColumn){return p.indexOfColumn(this);}return-1;};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),c=t.querySelectorAll("tr > td:nth-child("+i+")"),b=c.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<b;i++){c[i].style.display=a;c[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setDisplayViaMedia=function(t){var p=this.getParent(),d=this._media&&this._media.matches;if(!this.getDemandPopin()&&this._screen&&p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}else{this.setDisplay(t,d);}};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0;this.setProperty("visible",v,s);if(s){this.setDisplay(t,v);}return this;};
C.prototype.setMinScreenWidth=function(w){if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=sap.m.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}this._addMedia();}return this.setProperty("minScreenWidth",w);};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
return C;},true);
sap.ui.predefine('sap/m/ColumnListItem',['jquery.sap.global','sap/ui/core/Element','./ListItemBase','./library'],function(q,E,L,l){"use strict";
var C=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:sap.ui.core.VerticalAlign.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{onfocusin:function(e){if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}}});
C.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
C.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();};
C.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
C.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
C.prototype.getTable=function(){var p=this.getParent();if(p instanceof sap.m.Table){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
C.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addEventDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown},this).setParent(this,null,true);}return this._oPopin;};
C.prototype.$Popin=function(){return this.$("sub");};
C.prototype.hasPopin=function(){return!!(this._oPopin&&this.getTable().hasPopin());};
C.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
C.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
C.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);t.children().attr("aria-selected",s);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);this.$("subcell").attr("aria-selected",s);}};
C.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
C.prototype._needsTypeColumn=function(){var t=this.getType(),m=sap.m.ListType;return this.getVisible()&&(t==m.Detail||t==m.Navigation||t==m.DetailAndActive);};
sap.m.ColumnListItem.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
sap.m.ColumnListItem.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(c){c.destroy("KeepDom");});this._aClonedHeaders=[];}};
C.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
C.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
C.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return C;},true);
sap.ui.predefine('sap/m/ColumnListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','./ListRenderer','sap/ui/core/Renderer'],function(q,L,a,R){"use strict";var C=R.extend(L);
C.isTextualControl=function(c){var m=[sap.m.Text,sap.m.Label,sap.m.Link,sap.m.Title];return m.some(function(f){return f&&c instanceof f;});};
C.render=function(r,l){var t=l.getTable();if(!t){return;}L.render.apply(this,arguments);if(l.getVisible()&&t.hasPopin()){this.renderPopin(r,l,t);}};
C.openItemTag=function(r,l){r.write("<tr");};
C.closeItemTag=function(r,l){r.write("</tr>");};
C.handleNoFlex=function(r,l){};
C.renderType=function(r,l){r.write('<td role="gridcell" class="sapMListTblNavCol"');this.writeAriaSelected(r,l);if(!l._needsTypeColumn()){r.writeAttribute("aria-hidden","true");}r.write('>');L.renderType.apply(this,arguments);r.write('</td>');};
C.renderModeContent=function(r,l){r.write('<td role="gridcell" class="sapMListTblSelCol"');this.writeAriaSelected(r,l);r.write('>');L.renderModeContent.apply(this,arguments);r.write('</td>');};
C.renderCounter=function(r,l){};
C.getAriaRole=function(l){return"row";};
C.getAriaLabelledBy=function(l){var t=l.getTable(),A=L.getAriaLabelledBy.call(this,l)||"";if(!t||!t.hasPopin()){return A;}var i=l.getId();if(!A){A=i;}else if(A.indexOf(i)==-1){A=i+" "+A;}return A+" "+i+"-sub";};
C.writeAriaSelected=function(r,l){if(l.isSelectable()){r.writeAttribute("aria-selected",l.getProperty("selected"));}};
C.renderLIAttributes=function(r,l){r.addClass("sapMListTblRow");var A=l.getVAlign();if(A!=sap.ui.core.VerticalAlign.Inherit){r.addClass("sapMListTblRow"+A);}};
C.renderLIContentWrapper=function(r,l){var t=l.getTable();if(!t){return;}var c=t.getColumns(true),b=l.getCells(),s=l.isSelectable(),S=l.getProperty("selected");l._destroyClonedHeaders();c.forEach(function(o,i){var d,h,e=true,f=b[o.getInitialOrder()];if(!f||!o.getVisible()||o.isPopin()){o.setIndex(-1);return;}r.write("<td");r.addClass("sapMListTblCell");r.writeAttribute("id",l.getId()+"_cell"+i);r.writeAttribute("role","gridcell");if(s){r.writeAttribute("aria-selected",S);}if(o){d=o.getStyleClass(true);d&&r.addClass(q.sap.encodeHTML(d));h=o.getHeader();if(h){r.writeAttribute("aria-describedby",h.getId());}if(!t.hasPopin()&&o.getMergeDuplicates()){var F=o.getMergeFunctionName(),g=F.split("#"),j=g[1],k=g[0];if(typeof f[k]!="function"){q.sap.log.warning("mergeFunctionName property is defined on "+o+" but this is not function of "+f);}else{var m=o.getLastValue(),n=f[k](j);if(m===n){e=sap.ui.getCore().getConfiguration().getAccessibility();f.addStyleClass("sapMListTblCellDupCnt");r.addClass("sapMListTblCellDup");}else{o.setLastValue(n);}}}o.getVAlign()!="Inherit"&&r.addStyle("vertical-align",o.getVAlign().toLowerCase());var A=o.getCssAlign();if(A){r.addStyle("text-align",A);}r.writeStyles();}r.writeClasses();r.write(">");if(e){if(h&&f.getAriaLabelledBy&&this.isTextualControl(h)&&f.getAriaLabelledBy().indexOf(h.getId())==-1){f.addAssociation("ariaLabelledBy",h,true);}r.renderControl(o.applyAlignTo(f));}r.write("</td>");},this);};
C.renderPopin=function(r,l,t){var s=l.getProperty("selected"),S=l.isSelectable();l.removePopin();r.write("<tr");r.addClass("sapMListTblSubRow");r.writeElementData(l.getPopin());r.writeAttribute("role","row");r.writeAttribute("tabindex","-1");if(S){r.writeAttribute("aria-selected",s);}r.writeAttribute("aria-owns",l.getId());r.writeClasses();r.write(">");r.write("<td");r.writeAttribute("id",l.getId()+"-subcell");r.writeAttribute("role","gridcell");r.writeAttribute("colspan",t.getColCount());if(S){r.writeAttribute("aria-selected",S);}r.write("><div class='sapMListTblSubCnt'>");var c=l.getCells(),b=t.getColumns(true);b.forEach(function(o){if(!o.getVisible()||!o.isPopin()){return;}var d=c[o.getInitialOrder()],h=o.getHeader();if(!h&&!d){return;}var e=o.getStyleClass(),p=o.getPopinDisplay();r.write("<div");r.addClass("sapMListTblSubCntRow");e&&r.addClass(q.sap.encodeHTML(e));r.writeClasses();r.write(">");if(h&&p!=sap.m.PopinDisplay.WithoutHeader){r.write("<div");r.addClass("sapMListTblSubCntHdr");r.writeClasses();r.write(">");h=h.clone();o.addDependent(h);l._addClonedHeader(h);o.applyAlignTo(h,"Begin");r.renderControl(h);r.write("</div>");r.write("<div class='sapMListTblSubCntSpr'>:</div>");}if(d){r.write("<div");r.addClass("sapMListTblSubCntVal");r.addClass("sapMListTblSubCntVal"+p);r.writeClasses();r.write(">");o.applyAlignTo(d,"Begin");r.renderControl(d);r.write("</div>");}r.write("</div>");});r.write("</div></td></tr>");};
C.addLegacyOutlineClass=function(r,l){};
return C;},true);
sap.ui.predefine('sap/m/ComboBox',['jquery.sap.global','./ComboBoxTextField','./ComboBoxBase','./ComboBoxRenderer','./Popover','./SelectList','./Dialog','./Toolbar','./Button','./library'],function(q,C,a,b,P,S,D,T,B,l){"use strict";
var c=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
function h(o,i){if(!i){return;}var d=o.getFocusDomRef(),e=d.selectionStart,f=d.selectionEnd,I=e!==f,t=d.value.substring(0,d.selectionStart),g=this.getSelectedItem();if(i!==g){o.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!I){e=0;}o.selectText(e,d.value.length);}this.scrollToItem(i);}
function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}
c.prototype._handleAriaActiveDescendant=function(i){var d=this.getFocusDomRef(),A="aria-activedescendant";if(d){if(i&&i.getDomRef()&&this.isOpen()){d.setAttribute(A,i.getId());}else{d.removeAttribute(A);}}};
c.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
c.prototype._callMethodInControl=function(f,A){var L=this.getList();if(A[0]==="items"){if(L){return S.prototype[f].apply(L,A);}}else{return a.prototype[f].apply(this,A);}};
c.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),d="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(d);}else{i.bVisible=false;o.length&&o.addClass(d);}};
c.prototype.setSelectedIndex=function(i,_){var I;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);I=_[i];if(I){this.setSelection(I);}};
c.prototype.createDropdown=function(){var t=this;var p=new P({showHeader:false,placement:sap.m.PlacementType.VerticalPreferredBottom,offsetX:0,offsetY:0,initialFocus:this,bounce:false,showArrow:false});p.open=function(){return this.openBy(t);};return p;};
c.prototype.createDialog=function(){var t=this;var o=this.createPickerTextField();var d=o._handleEvent;o._handleEvent=function(e){d.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(e.type)){t._handleEvent(e);}};return new D({stretch:true,showHeader:false,subHeader:new T({content:o}),buttons:[this.createPickerCloseButton()],beforeOpen:function(){t.updatePickerHeaderTitle();},beforeClose:function(){t.updateDomValue(o.getValue());t.onChange();},afterClose:function(){t.focus();}});};
c.prototype.createPickerCloseButton=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){t.close();}});};
c.prototype.createPickerTextField=function(){var t=new C({width:"100%",showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};
c.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker();if(!p){return;}var L=this.getLabels();if(L.length){var o=L[0];if(o&&(typeof o.getText==="function")){p.setShowHeader(true);p.setTitle(o.getText());}}else{p.setShowHeader(false);}};
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;};
c.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};
c.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};
c.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(sap.m.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};
c.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),f=this.getFocusDomRef();if(L){L.setBusy(true);}if(f){f.setAttribute("aria-busy","true");}}};
c.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);};
c.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),f=this.getFocusDomRef();if(L){L.setBusy(false);}if(f){f.removeAttribute("aria-busy");}};
c.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();if(p){p.setValue(this.getValue());}};
c.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);if(e.isMarked("invalid")){return;}var t=(this.getPickerType()==="Dropdown");this.loadItems(function(){var o=this.getSelectedItem(),v=e.target.value,E=v==="",d=e.srcControl;var V=this.filterItems({property:"text",value:v},this.getItems());var i=!!V.length;var f=V[0];if(!E&&f&&f.getEnabled()){if(d._bDoTypeAhead){d.updateDomValue(f.getText());}this.setSelection(f);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(d._bDoTypeAhead){setTimeout(s.bind(d,v.length,d.getValue().length),0);}}if(E||!i){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}if(i||(i&&E)){if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t){this.close();}}else{this.clearFilter();}},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&t){this.open();}};
c.prototype.filterItems=function(o,I){var p=o.property,v=o.value,e=v==="",m=false,M="get"+p.charAt(0).toUpperCase()+p.slice(1),f=[],d=null;I=I||this.getItems();for(var i=0;i<I.length;i++){d=I[i];m=q.sap.startsWithIgnoreCase(d[M](),v)||e;if(m){f.push(d);}this._setItemVisibility(d,m);}return f;};
c.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem");this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});};
c.prototype.onItemPress=function(o){var i=o.getParameter("item");this.close();this.updateDomValue(i.getText());setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);if(this.getPickerType()==="Dialog"){this.onChange();}};
c.prototype.onkeydown=function(e){var o=e.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var k=q.sap.KeyCodes;o._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};
c.prototype.oncut=function(e){var o=e.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};
c.prototype.onsapenter=function(e){var o=e.srcControl;a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()){o.close();}};
c.prototype.onsapdown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var d=this.getSelectableItems();var n=d[d.indexOf(this.getSelectedItem())+1];h.call(this,o,n);});};
c.prototype.onsapup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var d=this.getSelectableItems();var p=d[d.indexOf(this.getSelectedItem())-1];h.call(this,o,p);});};
c.prototype.onsaphome=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var f=this.getSelectableItems()[0];h.call(this,o,f);});};
c.prototype.onsapend=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,o,L);});};
c.prototype.onsappagedown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())+10,I;i=(i>d.length-1)?d.length-1:Math.max(0,i);I=d[i];h.call(this,o,I);});};
c.prototype.onsappageup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())-10,I;i=(i>d.length-1)?d.length-1:Math.max(0,i);I=d[i];h.call(this,o,I);});};
c.prototype.onfocusin=function(e){var d=this.getPickerType()==="Dropdown";if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(d){this.focus();}}else{if(d){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}this.$().addClass("sapMFocus");};
c.prototype.onsapfocusleave=function(e){a.prototype.onsapfocusleave.apply(this,arguments);if(this.getPickerType()==="Dialog"){return;}var p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}var r=sap.ui.getCore().byId(e.relatedControlId),f=r&&r.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),f)){this.focus();}};
c.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof sap.ui.core.Item)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);};
c.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
c.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());}}};
c.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};
c.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};
c.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var d=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(d+"Picker").addStyleClass(d+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};
c.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(e){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};
c.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],d=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");if(d){d.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};
c.prototype.onBeforeOpenDropdown=function(){};
c.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),i=this.getSelectedItem();if(d){d.setAttribute("aria-expanded","true");i&&d.setAttribute("aria-activedescendant",i.getId());}};
c.prototype.onBeforeClose=function(){var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");};
c.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");}if(document.activeElement===d){this.openValueStateMessage();}this.clearFilter();};
c.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
c.prototype.getDefaultSelectedItem=function(){return null;};
c.prototype.clearSelection=function(){this.setSelection(null);};
c.prototype.onPropertyChange=function(o,d){var n=o.getParameter("newValue"),p=o.getParameter("name"),m="set"+p.charAt(0).toUpperCase()+p.slice(1),e=(d&&d.srcControl)||this.getPickerTextField();if(/value|enabled|name|placeholder|editable|textAlign|textDirection/.test(p)&&e&&(typeof e[m]==="function")){e[m](n);}};
c.prototype.onItemChange=function(o){var d=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(d===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};
c.prototype.selectText=function(i,d){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=d;return this;};
c.prototype.addAggregation=function(A,o,d){this._callMethodInControl("addAggregation",arguments);if(A==="items"&&!d&&!this.isInvalidateSuppressed()){this.invalidate(o);}return this;};
c.prototype.getAggregation=function(){return this._callMethodInControl("getAggregation",arguments);};
c.prototype.setAssociation=function(A,i,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};
c.prototype.indexOfAggregation=function(){return this._callMethodInControl("indexOfAggregation",arguments);};
c.prototype.insertAggregation=function(){this._callMethodInControl("insertAggregation",arguments);return this;};
c.prototype.removeAggregation=function(){return this._callMethodInControl("removeAggregation",arguments);};
c.prototype.removeAllAggregation=function(){return this._callMethodInControl("removeAllAggregation",arguments);};
c.prototype.destroyAggregation=function(A,d){this._callMethodInControl("destroyAggregation",arguments);return this;};
c.prototype.setProperty=function(p,v,d){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};
c.prototype.removeAllAssociation=function(A,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
c.prototype.getPickerTextField=function(){var p=this.getPicker(),o=p.getSubHeader();return o&&o.getContent()[0]||null;};
c.prototype.clone=function(I){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,d=L.getItems();i<d.length;i++){o.addItem(d[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};
c.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};
c.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};
c.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};
c.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof sap.ui.core.Item)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var d=(k==="");if(d){this.setSelection(null);this.setValue("");return this;}var i=this.getItemByKey(k);if(i){this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};
c.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};
c.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var I;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){I=this.getDefaultSelectedItem();this.setSelection(I);this.setValue(v);}return i;};
return c;},true);
sap.ui.predefine('sap/m/ComboBoxBase',['jquery.sap.global','./Dialog','./ComboBoxTextField','./SelectList','./Popover','./library'],function(q,D,C,S,P,l){"use strict";
var a=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});
a.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
a.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
a.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};
a.prototype.loadItems=function(c,o){var b=typeof c==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(b){o=q.extend({action:c,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(b){c.call(this);}};
a.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,c,n,I;i<this.aMessageQueue.length;i++){c=this.aMessageQueue.shift();i--;I=(i+1)===this.aMessageQueue.length;n=I?null:this.aMessageQueue[i+1];if(typeof c.action==="function"){if((c.name==="input")&&!I&&(n.name==="input")){continue;}c.action.call(this);}}};
a.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
a.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Dropdown");if(sap.ui.Device.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};
a.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};
a.prototype.ontouchstart=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(this.isOpenArea(e.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
a.prototype.ontouchend=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(!this.isOpen()&&this.isOpenArea(e.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
a.prototype.ontap=function(e){C.prototype.ontap.apply(this,arguments);var b=this.getRenderer().CSS_CLASS_COMBOBOXBASE,c=e.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(c.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(b+"Pressed");return;}this.loadItems();this.open();}if(this.isOpen()){this.addStyleClass(b+"Pressed");}};
a.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(e.keyCode===q.sap.KeyCodes.F4){e.preventDefault();}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.open();};
a.prototype.onsapescape=function(e){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){e.setMarked();e.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
a.prototype.onsaphide=a.prototype.onsapshow;
a.prototype.onsapfocusleave=function(e){if(!e.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(e.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),f=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),f)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
a.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
a.prototype.addContent=function(p){};
a.prototype.setPickerType=function(p){this._sPickerType=p;};
a.prototype.getPickerType=function(){return this._sPickerType;};
a.prototype.createPicker=function(p){};
a.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};
a.prototype.hasContent=function(){return this.getItems().length>0;};
a.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};
a.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};
a.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
a.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};
a.prototype.isItemSelected=function(){};
a.prototype.getKeys=function(I){I=I||this.getItems();for(var i=0,k=[];i<I.length;i++){k[i]=I[i].getKey();}return k;};
a.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};
a.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};
a.prototype.getItemByText=function(t){return this.findItem("text",t);};
a.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),I=i&&i.getDomRef();if(!p||!o||!I){return;}var b=o.scrollTop,c=I.offsetTop,d=o.clientHeight,e=I.offsetHeight;if(b>c){o.scrollTop=c;}else if((c+e)>(b+d)){o.scrollTop=Math.ceil(c+e-d);}};
a.prototype.clearFilter=function(){for(var i=0,I=this.getItems();i<I.length;i++){I[i].bVisible=true;}};
a.prototype.onItemChange=function(c){};
a.prototype.clearSelection=function(){};
a.prototype.setInternalBusyIndicator=function(b){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
a.prototype.setInternalBusyIndicatorDelay=function(d){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
a.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
a.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
a.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
a.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
a.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
a.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};
a.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};
a.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};
a.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};
a.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
a.prototype.removeAllItems=function(){var L=this.getList(),I=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<I.length;i++){I[i].detachEvent("_change",this.onItemChange,this);}return I;};
a.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['jquery.sap.global','./ComboBoxTextFieldRenderer','sap/ui/core/Renderer'],function(q,C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
a.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c);A.expanded=c.isOpen();return A;};
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var b=a.CSS_CLASS_COMBOBOXBASE;r.addClass(b);if(!c.getEnabled()){r.addClass(b+"Disabled");}if(!c.getEditable()){r.addClass(b+"Readonly");}};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['jquery.sap.global','./ComboBoxBaseRenderer','sap/ui/core/Renderer'],function(q,C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Placeholder");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['jquery.sap.global','./InputBase','./library'],function(q,I,l){"use strict";
var C=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}}}});
C.prototype.updateValueStateClasses=function(v,o){I.prototype.updateValueStateClasses.apply(this,arguments);var V=sap.ui.core.ValueState,a=this.getRenderer().CSS_CLASS_COMBOBOXTEXTFIELD,d=this.$();if(o!==V.None){d.removeClass(a+"State "+a+o);}if(v!==V.None){d.addClass(a+"State "+a+v);}};
C.prototype.getOpenArea=function(){return this.getDomRef("arrow");};
C.prototype.isOpenArea=function(d){var o=this.getOpenArea();return o&&o.contains(d);};
C.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
C.prototype.bShowLabelAsPlaceholder=sap.ui.Device.browser.msie;
C.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
C.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
C.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
C.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");return i;};
return C;},true);
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['jquery.sap.global','./InputBaseRenderer','sap/ui/core/Renderer'],function(q,I,R){"use strict";var C=R.extend(I);C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.writeAttribute("autocomplete","off");r.writeAttribute("autocorrect","off");r.writeAttribute("autocapitalize","off");};
C.getAriaRole=function(){return"combobox";};
C.getAccessibilityState=function(c){var a=I.getAccessibilityState.call(this,c);a.autocomplete="both";return a;};
C.addOuterStyles=function(r,c){r.addStyle("max-width",c.getMaxWidth());};
C.addOuterClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a);if(!c.getEnabled()){r.addClass(a+"Disabled");}if(!c.getEditable()){r.addClass(a+"Readonly");}};
C.addPaddingClass=q.noop;
C.addInnerClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"Inner");if(!c.getEditable()){r.addClass(a+"InnerReadonly");}if(c.getShowButton()){r.addClass(a+"InnerWidthExtraPadding");}};
C.addValueStateClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"State");r.addClass(a+c.getValueState());};
C.writeInnerContent=function(r,c){if(c.getShowButton()){this.renderButton(r,c);}};
C.renderButton=function(r,c){var i=c.getId(),b=i+"-arrow",B=i+"-buttonlabel",o=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write('<button tabindex="-1"');r.writeAttribute("id",b);r.writeAttribute("aria-labelledby",B);this.addButtonClasses(r,c);r.writeClasses();r.write(">");r.write("<label");r.writeAttribute("id",B);r.addClass("sapUiInvisibleText");r.addClass(C.CSS_CLASS_COMBOBOXTEXTFIELD+"ButtonLabel");r.writeClasses();r.write(">");r.write(o.getText("COMBOBOX_BUTTON"));r.write("</label>");r.write("</button>");};
C.addButtonClasses=function(r,c){r.addClass(C.CSS_CLASS_COMBOBOXTEXTFIELD+"Arrow");};
return C;},true);
sap.ui.predefine('sap/m/CustomListItem.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);
sap.ui.predefine('sap/m/CustomListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var C=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:true}});
return C;},true);
sap.ui.predefine('sap/m/CustomListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var C=R.extend(L);
C.renderLIAttributes=function(r,l){r.addClass("sapMCLI");};
C.renderLIContent=function(r,l){var c=l.getContent();var a=c.length;for(var i=0;i<a;i++){r.renderControl(c[i]);}};
return C;},true);
sap.ui.predefine('sap/m/CustomTile.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);
sap.ui.predefine('sap/m/CustomTile',['jquery.sap.global','./Tile','./library'],function(q,T,l){"use strict";
var C=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},designtime:true}});
return C;},true);
sap.ui.predefine('sap/m/CustomTileRenderer',['jquery.sap.global','./TileRenderer'],function(q,T){"use strict";var C=sap.ui.core.Renderer.extend(T);
C.render=function(r,c){r.write("<div tabindex=\"0\"");r.writeControlData(c);r.addClass("sapMCustomTile");r.writeClasses();if(c._invisible){r.addStyle("visibility","hidden");r.writeStyles();}if(c.getParent()instanceof sap.m.TileContainer){r.writeAccessibilityState({role:"option",posinset:c._getTileIndex(),setsize:c._getTilesCount()});}r.write(">");r.write("<div id=\""+c.getId()+"-remove\" class=\"sapMTCRemove\"></div>");r.write("<div class=\"sapMCustomTileContent\">");this._renderContent(r,c);r.write("</div></div>");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePicker',['jquery.sap.global','./InputBase','sap/ui/model/type/Date','sap/ui/core/date/UniversalDate','./library'],function(q,I,D,U,l){"use strict";
var a=I.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}}}});
a.prototype.init=function(){I.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99);};
a.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};
a.prototype.invalidate=function(o){if(!o||o!=this._oCalendar){sap.ui.core.Control.prototype.invalidate.apply(this,arguments);}};
a.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();};
a.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
a.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};
a.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};
a.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
a.prototype.onsapshow=function(E){b.call(this);E.preventDefault();};
a.prototype.onsaphide=a.prototype.onsapshow;
a.prototype.onsappageup=function(E){d.call(this,1,"day");E.preventDefault();};
a.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){d.call(this,1,"month");}else{d.call(this,1,"year");}E.preventDefault();};
a.prototype.onsappagedown=function(E){d.call(this,-1,"day");E.preventDefault();};
a.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){d.call(this,-1,"month");}else{d.call(this,-1,"year");}E.preventDefault();};
a.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=g.call(this,true);var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(C)<0){E.preventDefault();}};
a.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiIcon")){b.call(this);}};
a.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v==o){return this;}else{this._lastValue=v;}this.setProperty("value",v,true);this._bValid=true;var h;if(v){h=this._parseValue(v);if(!h||h.getTime()<this._oMinDate.getTime()||h.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);this._oWantedDate=h;}}if(this._bValid){this.setProperty("dateValue",h,true);this._oWantedDate=undefined;}if(this.getDomRef()){var O;if(h){O=this._formatValue(h);}else{O=v;}if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
a.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}var v=this._formatValue(o,true);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
a.prototype.setMinDate=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMinDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(o.getTime());var h=this.getDateValue();if(h&&h.getTime()<o.getTime()){q.sap.log.warning("DateValue not in valid date -> changed to minDate",this);this.setDateValue(new Date(o.getTime()));}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",o,false);if(this._oCalendar){this._oCalendar.setMinDate(o);}return this;};
a.prototype.setMaxDate=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMaxDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(o.getTime());var h=this.getDateValue();if(h&&h.getTime()>o.getTime()){q.sap.log.warning("DateValue not in valid date -> changed to maxDate",this);this.setDateValue(new Date(o.getTime()));}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,99);}this.setProperty("maxDate",o,false);if(this._oCalendar){this._oCalendar.setMaxDate(o);}return this;};
a.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("minDate > MaxDate -> dates switched",this);var m=new Date(this._oMinDate.getTime());var M=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(M.getTime());this._oMaxDate=new Date(m.getTime());this.setProperty("minDate",M,true);this.setProperty("maxDate",m,true);if(this._oCalendar){this._oCalendar.setMinDate(M);this._oCalendar.setMaxDate(m);}}if(this._oWantedDate&&this._oWantedDate.getTime()>=this._oMinDate.getTime()&&this._oWantedDate.getTime()<=this._oMaxDate.getTime()){this.setDateValue(this._oWantedDate);}};
a.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){var o=this._parseValue(V);if(!o||o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",o,true);}}return this;};
a.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue());if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};
a.prototype.setDisplayFormatType=function(s){if(s){var F=false;for(var t in sap.ui.core.CalendarType){if(t==s){F=true;break;}}if(!F){throw new Error(s+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",s,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
a.prototype.setSecondaryCalendarType=function(C){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",C,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(C);}return this;};
a.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var o=this._formatValue(this.getDateValue());if(v==o&&this._bValid){return;}var h;this._oWantedDate=undefined;this._bValid=true;if(v!=""){h=this._parseValue(v,true);if(!h||h.getTime()<this._oMinDate.getTime()||h.getTime()>this._oMaxDate.getTime()){this._bValid=false;h=undefined;}else{v=this._formatValue(h);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();if(this.bShowLabelAsPlaceholder){this.$("placeholder").css("display",v?"none":"inline");}}if(h){v=this._formatValue(h,true);}if(v!==this._lastValue){this._lastValue=v;this.setProperty("value",v,true);var n=this.getValue();if(this._bValid&&v==n){this.setProperty("dateValue",h,true);}v=n;if(this._oPopup&&this._oPopup.isOpen()){if(this._bValid){h=this.getDateValue();}this._oCalendar.focusDate(h);var s=this._oDateRange.getStartDate();if((!s&&h)||(s&&h&&s.getTime()!=h.getTime())){this._oDateRange.setStartDate(new Date(h.getTime()));}else if(s&&!h){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};
a.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var o=this._parseValue(v,true);v=this._formatValue(o,true);return v;};
a.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var o=this._parseValue(v,true);v=this._formatValue(o);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};
a.prototype._parseValue=function(v,h){var F=g.call(this,h);var o=F.parse(v);return o;};
a.prototype._formatValue=function(o,v){var V="";if(o){var F=g.call(this,!v);V=F.format(o);}return V;};
a.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof D)){p=B.oType.getOutputPattern();}else{p=this.getDisplayFormat();}if(!p){p="medium";}if(this._checkStyle(p)){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=this._getPlaceholderPattern(o,p);}}return p;};
a.prototype._getPlaceholderPattern=function(L,p){return L.getDatePattern(p);};
function _(){this._createPopup();this._createPopupContent();var C;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof D)){C=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!C){C=this.getDisplayFormatType();}if(C){this._oCalendar.setPrimaryCalendarType(C);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();}
a.prototype._createPopup=function(){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(e,this);}};
a.prototype._openPopup=function(){if(!this._oPopup){return;}this._oPopup.setAutoCloseAreas([this.getDomRef()]);var h=sap.ui.core.Popup.Dock;var A;if(this.getTextAlign()==sap.ui.core.TextAlign.End){A=h.EndBottom+"-4";this._oPopup.open(0,h.EndTop,A,this,null,"fit",true);}else{A=h.BeginBottom+"-4";this._oPopup.open(0,h.BeginTop,A,this,null,"fit",true);}};
a.prototype._createPopupContent=function(){if(!this._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");q.sap.require("sap.ui.unified.library");this._oCalendar=new sap.ui.unified.Calendar(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate()});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(c,this);this._oCalendar.attachEvent("_renderMonth",f,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};
a.prototype._fillDateRange=function(){var o=this.getDateValue();if(o){this._oCalendar.focusDate(new Date(o.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(new Date(o.getTime()));}}else{this._oCalendar.focusDate(new Date());if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
a.prototype._getFormatInstance=function(A,h){return sap.ui.core.format.DateFormat.getInstance(A);};
a.prototype._checkStyle=function(p){if(p=="short"||p=="medium"||p=="long"||p=="full"){return true;}else{return false;}};
a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o);}}i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
function b(){if(this.getEditable()&&this.getEnabled()){if(!this._oPopup||!this._oPopup.isOpen()){_.call(this);}else{c.call(this);}}}
a.prototype._selectDate=function(E){var o=this.getDateValue();var h=this._getSelectedDate();var v="";if(!q.sap.equal(h,o)){this.setDateValue(new Date(h.getTime()));v=this.getValue();this.fireChangeEvent(v,{valid:true});if(this.getDomRef()){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(h);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}this.setProperty("value",v,true);this.fireChangeEvent(v,{valid:true});}}this._oPopup.close();this._bFocusNoPopup=true;this.focus();};
a.prototype._getSelectedDate=function(){var s=this._oCalendar.getSelectedDates();var o;if(s.length>0){o=s[0].getStartDate();}return o;};
function c(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this._bFocusNoPopup=true;this.focus();}}
function d(n,u){var o=this.getDateValue();var C=this._$input.cursorPos();if(o&&this.getEditable()&&this.getEnabled()){var h=new U(o.getTime());o=new U(o.getTime());switch(u){case"day":h.setDate(h.getDate()+n);break;case"month":h.setMonth(h.getMonth()+n);var m=(o.getMonth()+n)%12;if(m<0){m=12+m;}while(h.getMonth()!=m){h.setDate(h.getDate()-1);}break;case"year":h.setFullYear(h.getFullYear()+n);while(h.getMonth()!=o.getMonth()){h.setDate(h.getDate()-1);}break;default:break;}if(h.getTime()<this._oMinDate.getTime()){h=new U(this._oMinDate.getTime());}else if(h.getTime()>this._oMaxDate.getTime()){h=new U(this._oMaxDate.getTime());}if(!q.sap.equal(this.getDateValue(),h.getJSDate())){this.setDateValue(new Date(h.getTime()));this._curpos=C;this._$input.cursorPos(this._curpos);var v=this.getValue();this.fireChangeEvent(v,{valid:true});}}}
function e(E){this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;}
function f(E){var i=E.getParameter("days");if(i>this._renderedDays){this._renderedDays=i;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}
function g(h){var p="";var r=false;var F;var B=this.getBinding("value");var C;if(B&&B.oType&&(B.oType instanceof D)){p=B.oType.getOutputPattern();r=!!B.oType.oOutputFormat.oFormatOptions.relative;C=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(h){p=(this.getDisplayFormat()||"medium");C=this.getDisplayFormatType();}else{p=(this.getValueFormat()||"short");C=sap.ui.core.CalendarType.Gregorian;}}if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}if(h){if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}}else{if(p==this._sUsedValuePattern&&C==this._sUsedValueCalendarType){F=this._oValueFormat;}}if(!F){if(this._checkStyle(p)){F=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:C},h);}else{F=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:C},h);}if(h){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=C;this._oValueFormat=F;}}return F;}
return a;},true);
sap.ui.predefine('sap/m/DatePickerRenderer',['jquery.sap.global','sap/ui/core/Renderer','./InputBaseRenderer'],function(q,R,I){"use strict";var D=R.extend(I);
D.addOuterClasses=function(r,d){r.addClass("sapMDP");if(d.getEnabled()&&d.getEditable()){r.addClass("sapMInputVH");}};
D.writeInnerContent=function(r,d){if(d.getEnabled()&&d.getEditable()){var c=["sapMInputValHelpInner"];var a={};a["id"]=d.getId()+"-icon";a["tabindex"]="-1";a["title"]=null;r.write('<div class="sapMInputValHelp">');r.writeIcon(this._getIcon(),c,a);r.write("</div>");}};
D._getIcon=function(){return"sap-icon://appointment-2";};
D.writeInnerValue=function(r,d){if(d._bValid){r.writeAttributeEscaped("value",d._formatValue(d.getDateValue()));}else{r.writeAttributeEscaped("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){if(d._bMobile){r.writeAttribute("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATEPICKER_DATE_TYPE")+" "+b;};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["multiline"]=false;a["autocomplete"]="none";a["haspopup"]=true;a["owns"]=d.getId()+"-cal";if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelection',['jquery.sap.global','./DatePicker','./library'],function(q,D,l){"use strict";
var a=D.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}}}});
a.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};
a.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}var f=d.call(this);var s=c.call(this);var A=f.sAllowedCharacters+s+" ";var C=String.fromCharCode(e.charCode);if(C&&f.sAllowedCharacters&&A.indexOf(C)<0){e.preventDefault();}};
a.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern(p);}var s=c.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};
a.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v,true);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);this._oWantedDate=e[0];this._oWantedSecondDate=e[1];e=b.call(this,e[0],e[1]);if(!e[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);this._oWantedDate=undefined;this._oWantedSecondDate=undefined;}if(this.getDomRef()){var o=this._formatValue(e[0],e[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
a.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};
a.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};
a.prototype.setFrom=function(f){this.setDateValue(f);};
a.prototype.getFrom=function(){return this.getDateValue();};
a.prototype.setTo=function(t){this.setSecondDateValue(t);};
a.prototype.getTo=function(){return this.getSecondDateValue();};
a.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}var s=this.getSecondDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
a.prototype.setSecondDateValue=function(s){if(s&&!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedSecondDate=s;s=undefined;}else{this._bValid=true;this.setProperty("secondDateValue",s,true);this._oWantedSecondDate=undefined;}var o=this.getDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
a.prototype.setMinDate=function(o){D.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to minDate",this);this.setSecondDateValue(new Date(this._oMinDate.getTime()));}}return this;};
a.prototype.setMaxDate=function(o){D.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to maxDate",this);this.setSecondDateValue(new Date(this._oMaxDate.getTime()));}}return this;};
a.prototype._checkMinMaxDate=function(){D.prototype._checkMinMaxDate.apply(this,arguments);if(this._oWantedSecondDate&&this._oWantedSecondDate.getTime()>=this._oMinDate.getTime()&&this._oWantedSecondDate.getTime()<=this._oMaxDate.getTime()){this.setSecondDateValue(this._oWantedSecondDate);}};
a.prototype._parseValue=function(v){var f;var e=[];var o,g;var s=c.call(this);if((s&&s!=="")&&v){e=v.split(s);if(e.length===2){if(e[0].slice(e[0].length-1,e[0].length)==" "){e[0]=e[0].slice(0,e[0].length-1);}if(e[1].slice(0,1)==" "){e[1]=e[1].slice(1);}}else{e=v.split(" "+s+" ");}if(e.length<2){var h=v.split(" ");if(h.length===2){e=h;}}}if(v&&e.length<=2){f=d.call(this);if((!s||s==="")||e.length===1){o=f.parse(v);}else if(e.length===2){o=f.parse(e[0]);g=f.parse(e[1]);if(!o||!g){o=undefined;g=undefined;}}}return[o,g];};
a.prototype._formatValue=function(o,s){var v="";var e=c.call(this);if(o){var f;f=d.call(this);if(e&&e!==""&&s){v=f.format(o)+" "+e+" "+f.format(s);}else{v=f.format(o);}}return v;};
a.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];this._oWantedDate=undefined;this._oWantedSecondDate=undefined;this._bValid=true;if(v!=""){e=this._parseValue(v);e=b.call(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}_.call(this,this._bValid);}};
a.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};
a.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};
a.prototype.onsappageup=function(){};
a.prototype.onsappageupmodifiers=function(){};
a.prototype.onsappagedown=function(){};
a.prototype.onsappagedownmodifiers=function(){};
a.prototype._fillDateRange=function(){D.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};
a.prototype._selectDate=function(e){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var f=s[0].getEndDate();if(o&&f){var g=this.getDateValue();var h=this.getSecondDateValue();this._oPopup.close();this._bFocusNoPopup=true;this.focus();var v;if(!q.sap.equal(o,g)||!q.sap.equal(f,h)){if(q.sap.equal(f,h)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(f);}v=this.getValue();_.call(this,true);this._curpos=v.length;this._$input.cursorPos(this._curpos);}else if(!this._bValid){v=this._formatValue(o,f);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}_.call(this,true);}}if(sap.ui.Device.browser.mobile){window.document.activeElement.blur();}}}};
a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=D.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
function _(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}
function b(o,s){if(o&&s&&o.getTime()>s.getTime()){var t=o;o=s;s=t;}if((o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()))||(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}
function c(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);var p=o.getIntervalPattern();var i=p.indexOf("{0}")+3;var I=p.indexOf("{1}");s=p.slice(i,I);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}
function d(){var p=(this.getDisplayFormat()||"medium");var f;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}else{if(this._checkStyle(p)){f=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true,calendarType:C});}else{f=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=f;}return f;}
return a;},true);
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['jquery.sap.global','sap/ui/core/Renderer','./DatePickerRenderer'],function(q,R,D){"use strict";var a=R.extend(D);
a.writeInnerValue=function(r,c){if(c._bValid){r.writeAttributeEscaped("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.writeAttributeEscaped("value",c.getValue());}};
return a;},true);
sap.ui.predefine('sap/m/DateTimeInput',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/model/type/Date'],function(q,C,l,D){"use strict";
var a=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:sap.m.DateTimeInputType.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(p,$,d){var o=sap.m.getLocaleData();$.extend(p,{_types:{Date:{valueFormat:o.getDatePattern("short"),displayFormat:o.getDatePattern("medium")},Time:{valueFormat:o.getTimePattern("short"),displayFormat:o.getTimePattern("short")},DateTime:{valueFormat:o.getDateTimePattern("short"),displayFormat:o.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(f){var T=p._types;T.DateTime[f]=T.DateTime[f].replace("{"+n+"}",T[t][f]);});});}(a.prototype,q,sap.ui.Device));
a.prototype.init=function(){this.setType(sap.m.DateTimeInputType.Date);};
a.prototype.onBeforeRendering=function(){b.call(this);};
a.prototype.getFocusDomRef=function(){var p=_.call(this);return p.getFocusDomRef();};
a.prototype.getIdForLabel=function(){var p=_.call(this);return p.getIdForLabel();};
a.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var p;switch(t){case sap.m.DateTimeInputType.DateTime:q.sap.require("sap.m.DateTimePicker");p=new sap.m.DateTimePicker(this.getId()+"-Picker");break;case sap.m.DateTimeInputType.Time:q.sap.require("sap.m.TimePicker");p=new sap.m.TimePicker(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:q.sap.require("sap.m.DatePicker");p=new sap.m.DatePicker(this.getId()+"-Picker");break;}p.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);p.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){p.setDateValue(this.getDateValue());}p.setEnabled(this.getEnabled());p.setEditable(this.getEditable());p.setValueState(this.getValueState());p.setValueStateText(this.getValueStateText());p.setShowValueStateMessage(this.getShowValueStateMessage());p.setName(this.getName());p.setPlaceholder(this.getPlaceholder());p.setTextAlign(this.getTextAlign());p.setTextDirection(this.getTextDirection());p.setWidth("100%");p.attachChange(c,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){p.addAriaLabelledBy(A[i]);}this.setAggregation("_picker",p);this.setProperty("type",t);return this;};
a.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
a.prototype.setValue=function(v){b.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var p=_.call(this);p.setValue(v);var d=p.getDateValue();this.setProperty("dateValue",d,true);return this;};
a.prototype.setDateValue=function(d){if(d&&!(d instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}b.call(this);this.setProperty("dateValue",d,true);var p=_.call(this);p.setDateValue(d);var v=p.getValue();this.setProperty("value",v,true);return this;};
a.prototype.setDisplayFormat=function(d){this.setProperty("displayFormat",d,true);var p=_.call(this);p.setDisplayFormat(d||this._types[this.getType()].displayFormat);return this;};
a.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var p=_.call(this);p.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
a.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);var p=_.call(this);p.setEnabled(e);return this;};
a.prototype.setEditable=function(e){this.setProperty("editable",e,true);var p=_.call(this);p.setEditable(e);return this;};
a.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var p=_.call(this);p.setValueState(v);return this;};
a.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var p=_.call(this);p.setValueStateText(v);return this;};
a.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var p=_.call(this);p.setShowValueStateMessage(s);return this;};
a.prototype.setName=function(n){this.setProperty("name",n,true);var p=_.call(this);p.setName(n);return this;};
a.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);var P=_.call(this);P.setPlaceholder(p);return this;};
a.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var p=_.call(this);p.setTextAlign(t);return this;};
a.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var p=_.call(this);p.setTextDirection(t);return this;};
a.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.addAriaLabelledBy(i);return this;};
a.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.removeAriaLabelledBy(i);return this;};
a.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var p=_.call(this);p.removeAllAriaLabelledBy();return this;};
a.prototype.getAccessibilityInfo=function(){var p=_.call(this);return p&&p.getAccessibilityInfo?p.getAccessibilityInfo():null;};
function _(){return this.getAggregation("_picker");}
function b(){var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof D)){var p=B.oType.getOutputPattern();var P=_.call(this);if(P.getValueFormat()!=p){P.setValueFormat(p);}if(P.getDisplayFormat()!=p){P.setDisplayFormat(p);}}}
function c(e){var v=e.getParameter("value");var d;var V=e.getParameter("valid");this.setProperty("value",v,true);if(V){d=e.oSource.getDateValue();this.setProperty("dateValue",d,true);}this.fireChange({value:v,newValue:v,valid:V,dateValue:d,newDateValue:d});}
return a;},true);
sap.ui.predefine('sap/m/DateTimeInputRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDTI");var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePicker',['jquery.sap.global','./DatePicker','sap/ui/model/type/Date','./library'],function(q,D,a,l){"use strict";
var b=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});
var P=sap.ui.core.Control.extend("DateTimePickerPopup",{
metadata:{aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,p){r.write("<div");r.writeControlData(p);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=p.getAggregation("_switcher");if(s&&s.getVisible()){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var C=p.getCalendar();if(C){r.renderControl(C);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var S=p.getTimeSliders();if(S){r.renderControl(S);}r.write("</div>");},
init:function(){},
onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}else{s.setVisible(true);s.setSelectedKey("Cal");}}else if(s){s.setVisible(false);}},
onAfterRendering:function(){if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var k=s.getSelectedKey();this._switchVisibility(k);}},
_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},
_switchVisibility:function(k){var C=this.getCalendar();var s=this.getTimeSliders();if(!C||!s){return;}if(k=="Cal"){C.$().css("display","");s.$().css("display","none");C.focus();}else{C.$().css("display","none");s.$().css("display","");s.updateSlidersValues();s._onOrientationChanged();s._initFocus();}},
switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}}
});
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
b.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}};
b.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setFormat(g.call(this));}return this;};
b.prototype._getFormatInstance=function(A,i){var m=q.extend({},A);var s=-1;if(m.style){s=m.style.indexOf("/");}if(i){var o=q.extend({},m);if(s>0){o.style=o.style.substr(0,s);}this._oDisplayFormatDate=sap.ui.core.format.DateFormat.getInstance(o);}return sap.ui.core.format.DateFormat.getDateTimeInstance(m);};
b.prototype._checkStyle=function(p){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(p.indexOf("/")>0){var s=["short","medium","long","full"];var S=false;for(var i=0;i<s.length;i++){var k=s[i];for(var j=0;j<s.length;j++){var m=s[j];if(p==k+"/"+m){S=true;break;}}if(S){break;}}return S;}return false;};
b.prototype._parseValue=function(v,i){var o=D.prototype._parseValue.apply(this,arguments);if(i&&!o){o=this._oDisplayFormatDate.parse(v);if(o){var O=this.getDateValue();if(!O){O=new Date();}o.setHours(O.getHours());o.setMinutes(O.getMinutes());o.setSeconds(O.getSeconds());o.setMilliseconds(O.getMilliseconds());}}return o;};
b.prototype._getPlaceholderPattern=function(L,p){var s=p.indexOf("/");if(s>0){return L.getCombinedDateTimePattern(p.substr(0,s),p.substr(s+1));}else{return L.getCombinedDateTimePattern(p,p);}};
b.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=r.getText("TIMEPICKER_SET");var C=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new P(this.getId()+"-PC");this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:sap.m.PlacementType.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:o,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:C,press:q.proxy(c,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var p=this._oPopup.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}this._oPopup.attachBeforeOpen(d,this);this._oPopup.attachAfterOpen(e,this);this._oPopup.attachAfterClose(f,this);if(sap.ui.Device.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var k=q.sap.KeyCodes,K=E.which||E.keyCode,A=E.altKey;if((A&&(K===k.ARROW_UP||K===k.ARROW_DOWN))||K===k.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};
b.prototype._openPopup=function(){if(!this._oPopup){return;}var p=this._oPopup.getAggregation("_popup");p.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);};
b.prototype._createPopupContent=function(){var n=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(n){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(h,this);}if(!this._oSliders){q.sap.require("sap.m.TimePickerSliders");this._oSliders=new sap.m.TimePickerSliders(this.getId()+"-Sliders",{format:g.call(this),invokedBy:this.getId()});this._oPopupContent.setTimeSliders(this._oSliders);}};
b.prototype._fillDateRange=function(){var o=this.getDateValue();if(o){o=new Date(o.getTime());}else{o=new Date();}this._oCalendar.focusDate(o);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(o);}this._oSliders.setTimeValues(o);};
b.prototype._getSelectedDate=function(){var o=D.prototype._getSelectedDate.apply(this,arguments);if(o){var i=this._oSliders.getTimeValues();var p=this._oSliders.getFormat();if(p.search("h")>=0||p.search("H")>=0){o.setHours(i.getHours());}if(p.search("m")>=0){o.setMinutes(i.getMinutes());}if(p.search("s")>=0){o.setSeconds(i.getSeconds());}if(o.getTime()<this._oMinDate.getTime()){o=new Date(this._oMinDate.getTime());}else if(o.getTime()>this._oMaxDate.getTime()){o=new Date(this._oMaxDate.getTime());}}return o;};
b.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
b.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._selectDate();}
function c(E){this.onsaphide(E);}
function d(E){}
function e(E){this._oCalendar.focus();this._oSliders._onOrientationChanged();}
function f(E){}
function g(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else{s=this.getDisplayFormat();}if(!s){s="medium";}var S=s.indexOf("/");if(S>0&&this._checkStyle(s)){s=s.substr(S+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);t=o.getTimePattern(s);}else{t=s;}return t;}
function h(E){this._oPopupContent.switchToTime();}
return b;},true);
sap.ui.predefine('sap/m/DateTimePickerRenderer',['jquery.sap.global','sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer'],function(q,R,D,I){"use strict";var a=R.extend(D);
a._getIcon=function(){return"sap-icon://date-time";};
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
return a;},true);
sap.ui.predefine('sap/m/Dialog',['jquery.sap.global','./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager'],function(q,B,I,A,T,l,C,a,P,S,b,R){"use strict";var V=sap.ui.core.ValueState;var c=sap.ui.Device.browser.internet_explorer&&(sap.ui.Device.browser.version<10);
var D=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:sap.m.DialogType.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}}}});
D._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);D._mStateClasses={};D._mStateClasses[V.None]="";D._mStateClasses[V.Success]="sapMDialogSuccess";D._mStateClasses[V.Warning]="sapMDialogWarning";D._mStateClasses[V.Error]="sapMDialogError";D._mIcons={};D._mIcons[V.Success]=a.getIconURI("message-success");D._mIcons[V.Warning]=a.getIconURI("message-warning");D._mIcons[V.Error]=a.getIconURI("message-error");
D.prototype.init=function(){var t=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["NavContainer","Page","ScrollContainer"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(q.device.is.iphone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup.onsapescape=q.proxy(function(e){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this.close();e.stopPropagation();},this);this.oPopup._applyPosition=function(p,f){t._setDimensions();t._adjustScrollingPane();p.at={left:t._oManuallySetPosition?t._oManuallySetPosition.x:'50%',top:t._oManuallySetPosition?t._oManuallySetPosition.y:'50%'};t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._registerContentResizeHandler();};if(D._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}};
D.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this._forceDisableScrolling=true;q.sap.log.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else{this._forceDisableScrolling=false;}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling(),zynga:false,preventDefault:false,nonTouchScrolling:"scrollbar",iscroll:sap.ui.Device.browser.name==="an"?"force":undefined});}}this._createToolbarButtons();};
D.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};
D.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}};
D.prototype.open=function(){var p=this.oPopup;p.setInitialFocusId(this.getId());if(p.isOpen()){return this;}this._oCloseTrigger=null;this.fireBeforeOpen();p.attachOpened(this._handleOpened,this);p.setContent(this);p.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
D.prototype.close=function(){this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var p=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===sap.ui.core.OpenState.CLOSED||e===sap.ui.core.OpenState.CLOSING)){sap.m.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});p.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;p.close();this._deregisterContentResizeHandler();}return this;};
D.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};
D.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
D.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});};
D.prototype.onfocusin=function(e){var s=e.target;if(s.id===this.getId()+"-firstfe"){var L=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(L){q.sap.focus(L);}}else if(s.id===this.getId()+"-lastfe"){var f=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(f){q.sap.focus(f);}}};
D.prototype._openAnimation=function(r,i,o){r.addClass("sapMDialogOpen");if(c){r.fadeIn(200,o);}else{r.css("display","block");setTimeout(o,210);}};
D.prototype._closeAnimation=function(r,i,f){r.removeClass("sapMDialogOpen");if(c){r.fadeOut(200,f);}else{setTimeout(f,210);}};
D.prototype._setDimensions=function(){var $=this.$(),s=this.getStretch(),e=this.getStretchOnPhone()&&sap.ui.Device.system.phone,m=this._bMessageType,o={};if(!s){if(!this._oManuallySetSize){o.width=this.getContentWidth()||undefined;o.height=this.getContentHeight()||undefined;}else{o.width=this._oManuallySetSize.width;o.height=this._oManuallySetSize.height;}}if((s&&!m)||(e)){this.$().addClass('sapMDialogStretched');}$.css(o);if(!s&&!this._oManuallySetSize){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
D.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
D.prototype._reposition=function(){};
D.prototype._repositionAfterOpen=function(){};
D.prototype._reapplyPosition=function(){this._adjustScrollingPane();};
D.prototype._onResize=function(){var $=this.$(),e=this.$('cont');if(this._oManuallySetSize){return;}if(!this.getContentHeight()){e.css({height:'auto'});e.height(parseInt($.height(),10));}if(this.getStretch()||this._bDisableRepositioning){return;}this._applyCustomTranslate();};
D.prototype._applyCustomTranslate=function(){var $=this.$(),t,s,i=$.innerWidth(),e=$.innerHeight();if(sap.ui.Device.system.desktop&&(i%2!==0||e%2!==0)){if(!this._bRTL){t='-'+Math.floor(i/2)+"px";}else{t=Math.floor(i/2)+"px";}s='-'+Math.floor(e/2)+"px";$.css('transform','translate('+t+','+s+') scale(1)');}else{$.css('transform','');}};
D.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header").addStyleClass("sapMDialogTitle");this.setAggregation("_header",this._header,false);}};
D.prototype._hasSingleScrollableContent=function(){var e=this.getContent(),i;while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1){for(i=0;i<this._scrollContentList.length;i++){if(e[0]instanceof sap.m[this._scrollContentList[i]]){return true;}}}return false;};
D.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};
D.prototype._clearBlockLayerAnimation=function(){if(q.device.is.iphone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};
D.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};
D.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),f=this.getButtons(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}else if(f&&f.length>0){for(var i=0;i<f.length;i++){if(f[i].getVisible()){s=f[i].getId();break;}}}return s;};
D.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var r;var f=$.firstFocusableDomRef();if(f){r=f.id;}return r;};
D.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var f=$.firstFocusableDomRef();if(f){r=f.id;}return r;};
D.prototype._setInitialFocus=function(){var f=this._getFocusId();var o=sap.ui.getCore().byId(f);var F;if(o){if(!o.getVisible()){this.focus();return;}F=o.getFocusDomRef();}F=F||q.sap.domById(f);if(!F){this.setInitialFocus("");F=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',F?F.id:this.getId(),true);}if(sap.ui.Device.system.desktop||(F&&!/input|textarea|select/i.test(F.tagName))){q.sap.focus(F);}else{this.focus();}};
D.prototype.getScrollDelegate=function(){return this._oScroller;};
D.prototype._composeAggreNameInHeader=function(p){var h;if(p==="Begin"){h="contentLeft";}else if(p==="End"){h="contentRight";}else{h="content"+p;}return h;};
D.prototype._isToolbarEmpty=function(){var f=this._oToolbar.getContent().filter(function(e){return e.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return f.length===0;};
D.prototype._setButton=function(o,p,s){return this;};
D.prototype._getButton=function(p){var s=p.toLowerCase()+"Button",e="_o"+this._firstLetterUpperCase(p)+"Button";if(sap.ui.Device.system.phone){return this.getAggregation(s,null,true);}else{return this[e];}};
D.prototype._getButtonFromHeader=function(p){if(this._header){var h=this._composeAggreNameInHeader(this._firstLetterUpperCase(p)),e=this._header.getAggregation(h);return e&&e[0];}else{return null;}};
D.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};
D.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o;}else{var s=this.getShowHeader();if(!s){return null;}this._createHeader();return this._header;}};
D.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){sap.ui.core.ResizeHandler.deregister(this._resizeListenerId);this._resizeListenerId=null;}sap.ui.Device.resize.detachHandler(this._onResize);};
D.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=sap.ui.core.ResizeHandler.register(_.get(0),q.proxy(this._onResize,this));sap.ui.Device.resize.attachHandler(this._onResize.bind(this));this._onResize();};
D.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
D.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
D.prototype._attachHandler=function(o){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this;}};}if(o){o.addDelegate(this._oButtonDelegate,true,o);}};
D.prototype._createToolbarButtons=function(){var t=this._getToolbar();var e=this.getButtons();var f=this.getBeginButton();var g=this.getEndButton(),h=this,i=[f,g];i.forEach(function(o){if(o&&h._oButtonDelegate){o.removeDelegate(h._oButtonDelegate);}});t.removeAllContent();t.addContent(new T());i.forEach(function(o){h._attachHandler(o);});if(e&&e.length){e.forEach(function(j){t.addContent(j);});}else{if(f){t.addContent(f);}if(g){t.addContent(g);}}};
D.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders").applyTagAndContextClassFor("footer");this._oToolbar._isControlsInfoCached=function(){return false;};this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
D.prototype.setSubHeader=function(o){this.setAggregation("subHeader",o);if(o){o.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);o.setProperty("visible",i);}.bind(this);}return o;};
D.prototype.setLeftButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};
D.prototype.setRightButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};
D.prototype.getLeftButton=function(){var o=this.getBeginButton();return o?o.getId():null;};
D.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
D.prototype.getAggregation=function(s,o,p){var e=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(s==='buttons'&&e.length===0){this.getBeginButton()&&e.push(this.getBeginButton());this.getEndButton()&&e.push(this.getEndButton());}return e;};
D.prototype.getAriaLabelledBy=function(){var h=this._getAnyHeader(),e=this.getAssociation("ariaLabelledBy",[]).slice();var s=this.getSubHeader();if(s){e.unshift(s.getId());}if(h){e.unshift(h.getId());}return e;};
D.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:t,level:"H1"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};
D.prototype.setCustomHeader=function(o){if(o){o.addStyleClass("sapMDialogTitle");}this.setAggregation("customHeader",o);};
D.prototype.setState=function(s){var f={},$=this.$(),n;f[s]=true;this.setProperty("state",s,true);for(n in D._mStateClasses){$.toggleClass(D._mStateClasses[n],!!f[n]);}this.setIcon(D._mIcons[s],true);};
D.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=a.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var s=this.getState();if(!e&&s!==V.None){if(this._iconImage){this._iconImage.setSrc(D._mIcons[s]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};
D.prototype.setType=function(t){var o=this.getType();if(o===t){return this;}this._bMessageType=(t===sap.m.DialogType.Message);return this.setProperty("type",t,false);};
D.prototype.setStretch=function(s){this._bStretchSet=true;return this.setProperty("stretch",s);};
D.prototype.setStretchOnPhone=function(s){if(this._bStretchSet){q.sap.log.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",s);return this.setProperty("stretch",s&&sap.ui.Device.system.phone);};
D.prototype.setVerticalScrolling=function(v){var o=this.getVerticalScrolling();if(o===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};
D.prototype.setHorizontalScrolling=function(v){var o=this.getHorizontalScrolling();if(o===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};
D.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
D.prototype.forceInvalidate=C.prototype.invalidate;
D.prototype.invalidate=function(o){if(this.isOpen()){this.forceInvalidate(o);}};
function d(e){var $=q(e);var o=$.control(0);if(!o||o.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(sap.ui.Device.system.desktop){D.prototype.ondblclick=function(e){if(d(e.target)){this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');}};D.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var t;var f=this;var $=q(document);var g=q(e.target);var r=g.hasClass('sapMDialogResizeHandler')&&this.getResizable();var m=function(o){t=t?clearTimeout(t):setTimeout(function(){o();},0);};var h=30;var w=window.innerWidth;var i=window.innerHeight;var j={x:e.pageX,y:e.pageY,width:f._$dialog.width(),height:f._$dialog.height(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:f._$dialog.offset().left,y:f._$dialog.offset().top}};if((d(e.target)&&this.getDraggable())||r){f._bDisableRepositioning=true;f._$dialog.addClass('sapDialogDisableTransition');f._$dialog.addClass('sapMDialogTouched');f._oManuallySetPosition={x:j.position.x,y:j.position.y};f._$dialog.css({left:Math.min(Math.max(0,f._oManuallySetPosition.x),w-h),top:Math.min(Math.max(0,f._oManuallySetPosition.y),i-h),transform:"initial"});}if(d(e.target)&&this.getDraggable()){$.on("mousemove.sapMDialog",function(e){m(function(){f._bDisableRepositioning=true;f._oManuallySetPosition={x:e.pageX-j.offset.x,y:e.pageY-j.offset.y};f._$dialog.css({left:Math.min(Math.max(0,f._oManuallySetPosition.x),w-h),top:Math.min(Math.max(0,f._oManuallySetPosition.y),i-h),transform:"initial"});});});}else if(r){f._$dialog.addClass('sapMDialogResizing');var s={};var k=parseInt(f._$dialog.css('min-width'),10);var n=j.x+j.width-k;$.on("mousemove.sapMDialog",function(e){m(function(){f._bDisableRepositioning=true;f._oManuallySetSize={width:j.width+e.pageX-j.x,height:j.height+e.pageY-j.y};if(f._bRTL){s.left=Math.min(Math.max(e.pageX,0),n);s.transform="initial";f._oManuallySetSize.width=j.width+j.x-Math.max(e.pageX,0);}s.width=f._oManuallySetSize.width;s.height=f._oManuallySetSize.height;f._$dialog.css(s);});});}else{return;}$.on("mouseup.sapMDialog",function(){var o=f.$(),p=f.$('cont');$.off("mouseup.sapMDialog, mousemove.sapMDialog");if(r){f._$dialog.removeClass('sapMDialogResizing');p.height(parseInt(o.height(),10)+parseInt(o.css("border-top-width"),10)+parseInt(o.css("border-bottom-width"),10));}});e.preventDefault();e.stopPropagation();};}return D;},true);
sap.ui.predefine('sap/m/DialogRenderer',['jquery.sap.global','./BarRenderer'],function(q,B){"use strict";var D={};
D.render=function(r,c){var a=c.getId(),t=c.getType(),h=c._getAnyHeader(),s=c.getSubHeader(),m=(t===sap.m.DialogType.Message),l=c.getBeginButton(),R=c.getEndButton(),H=c.getHorizontalScrolling(),v=c.getVerticalScrolling(),S=c.getState(),b=c.getStretch(),d=c.getStretchOnPhone()&&sap.ui.Device.system.phone,e=c.getResizable(),f=c.getDraggable();if(h){h.applyTagAndContextClassFor("header");}if(s){s.applyTagAndContextClassFor("subheader");}var g=c.getContentWidth()?' width: '+c.getContentWidth()+';':'';var j=c.getContentHeight()?' height: '+c.getContentHeight()+';':'';var k="style='"+g+j+"'";r.write('<div '+k);r.writeControlData(c);r.addClass("sapMDialog");r.addClass("sapMDialog-CTX");r.addClass("sapMPopup-CTX");if(c.isOpen()){r.addClass("sapMDialogOpen");}if(window.devicePixelRatio>1){r.addClass("sapMDialogHighPixelDensity");}if(c._bDisableRepositioning){r.addClass("sapMDialogTouched");}if(b||(d)){r.addClass("sapMDialogStretched");}r.addClass(sap.m.Dialog._mStateClasses[S]);var n=!c._oToolbar&&!l&&!R;var o=c._oToolbar&&c._isToolbarEmpty()&&!l&&!R;if(n||o){r.addClass("sapMDialog-NoFooter");}if(!h){r.addClass("sapMDialog-NoHeader");}if(S==="Error"||S==="Warning"){r.writeAccessibilityState(c,{role:"alertdialog"});}else{r.writeAccessibilityState(c,{role:"dialog"});}if(c._forceDisableScrolling){r.addClass("sapMDialogWithScrollCont");}if(s&&s.getVisible()){r.addClass("sapMDialogWithSubHeader");}if(m){r.addClass("sapMMessageDialog");}if(!v){r.addClass("sapMDialogVerScrollDisabled");}if(!H){r.addClass("sapMDialogHorScrollDisabled");}if(sap.ui.Device.system.phone){r.addClass("sapMDialogPhone");}if(f&&!b){r.addClass("sapMDialogDraggable");}if(sap.m._bSizeCompact){r.addClass("sapUiSizeCompact");}r.writeClasses();var T=c.getTooltip_AsString();if(T){r.writeAttributeEscaped("title",T);}r.writeAttribute("tabindex","-1");r.write(">");if(sap.ui.Device.system.desktop){if(e&&!b){r.write('<div class="sapMDialogResizeHandler"></div>');}r.write('<span id="'+c.getId()+'-firstfe" tabindex="0"/>');}if(h){r.renderControl(h);}if(s){r.renderControl(s.addStyleClass("sapMDialogSubHeader"));}r.write('<section id="'+a+'-cont" class="sapMDialogSection">');r.write('<div id="'+a+'-scroll" class="sapMDialogScroll">');r.write('<div id="'+a+'-scrollCont" class="sapMDialogScrollCont');if(c.getStretch()||j){r.write(' sapMDialogStretchContent');}r.write('">');var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");r.write("</div>");r.write("</section>");if(!(n||o)){r.renderControl(c._oToolbar);}if(sap.ui.Device.system.desktop){r.write('<span id="'+c.getId()+'-lastfe" tabindex="0"/>');}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DisplayListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var D=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});
return D;},true);
sap.ui.predefine('sap/m/DisplayListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var D=R.extend(L);
D.renderLIAttributes=function(r,l){r.addClass("sapMDLI");};
D.renderLIContent=function(r,l){var i=l.getLabel();if(i){r.write("<label for='"+l.getId()+"-value' class='sapMDLILabel'>");r.writeEscaped(l.getLabel());r.write("</label>");}var a=l.getValue();var v=l.getValueTextDirection();if(a){r.write("<div id='"+l.getId()+"-value' class='sapMDLIValue'");if(v!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",v.toLowerCase());}r.write(">");r.writeEscaped(l.getValue());r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label"],function(C,L){"use strict";
var D=C.extend("sap.m.DraftIndicator",{metadata:{properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:sap.m.DraftIndicatorState.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");D._oTEXTS={};D._oTEXTS[sap.m.DraftIndicatorState.Saving]=b.getText("DRAFT_INDICATOR_SAVING_DRAFT");D._oTEXTS[sap.m.DraftIndicatorState.Saved]=b.getText("DRAFT_INDICATOR_DRAFT_SAVED");D._oTEXTS[sap.m.DraftIndicatorState.Clear]="";
D.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
D.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===sap.m.DraftIndicatorState.Saving){this._addToQueue(sap.m.DraftIndicatorState.Clear);}return this;};
D.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new sap.m.Label({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
D.prototype.showDraftSaving=function(){this._addToQueue(sap.m.DraftIndicatorState.Saving);this._addToQueue(sap.m.DraftIndicatorState.Clear);};
D.prototype.showDraftSaved=function(){this._addToQueue(sap.m.DraftIndicatorState.Saved);};
D.prototype.clearDraftState=function(){this._addToQueue(sap.m.DraftIndicatorState.Clear);};
D.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
D.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===sap.m.DraftIndicatorState.Clear){this._proceed();return;}this.iDelayedCallId=jQuery.sap.delayedCall(t,this,this._proceed);};
D.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
D.prototype._applyState=function(s){this._getLabel().setText(D._oTEXTS[s]);};
D.prototype._resetDraftTimer=function(){jQuery.sap.clearDelayedCall(this.iDelayedCallId);this.iDelayedCallId=null;};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicatorRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDraftIndicator");r.writeClasses();r.write(">");var l=c._getLabel();r.renderControl(l);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DynamicPage',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/Device"],function(q,l,C,S,R,D){"use strict";
var a=C.extend("sap.m.DynamicPage",{metadata:{library:"sap.m",properties:{headerScrollable:{type:"boolean",group:"Behaviour",defaultValue:true},headerExpanded:{type:"boolean",group:"Behaviour",defaultValue:true},showFooter:{type:"boolean",group:"Behaviour",defaultValue:false}},aggregations:{title:{type:"sap.m.DynamicPageTitle",multiple:false},header:{type:"sap.m.ISnappable",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}}}});
function e(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}
var u=sap.ui.getCore().getConfiguration().getAnimation();a.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;a.FOOTER_ANIMATION_DURATION=350;a.BREAK_POINTS={TABLET:1024,PHONE:600};a.EVENTS={TITLE_PRESS:"_titlePress",PIN_UNPIN_PRESS:"_pinUnpinPress"};a.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapMDynamicPage-Std-Phone",TABLET:"sapMDynamicPage-Std-Tablet",DESKTOP:"sapMDynamicPage-Std-Desktop"};
a.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;};
a.prototype.onBeforeRendering=function(){if(this.getHeaderScrollable()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._detachScrollHandler();};
a.prototype.onAfterRendering=function(){var h=this.getHeaderScrollable();if(!h&&e(this.getHeader())){this.getHeader()._setShowPinBtn(false);}this._cacheDomElements();this._attachResizeHandlers();this._updateMedia(this._getHeight(this));if(h){this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();}};
a.prototype.exit=function(){this._detachResizeHandlers();};
a.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
a.prototype.setHeaderExpanded=function(h){if(this.getHeaderExpanded()===h){return this;}this._titleExpandCollapseWhenAllowed();return this;};
a.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(f)){return;}f.toggleStyleClass("sapMDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapMDynamicPageActualFooterControlHide",!s);this.toggleStyleClass("sapMDynamicPageFooterSpacer",s);if(u&&!s){q.sap.delayedCall(a.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}};
a.prototype._toggleHeader=function(){if(this._shouldSnap()){this._snapHeader(true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader();this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){this._moveHeaderToContentArea();}};
a.prototype._snapHeader=function(A){var d=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(false);}if(e(d.getSnappedContent())){d._setShowSnapContent(true);}if(A){this._moveHeaderToContentArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);this.$titleArea.addClass("sapMDynamicPageTitleSnapped");};
a.prototype._expandHeader=function(A){var d=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(true);}if(e(d.getSnappedContent())){d._setShowSnapContent(false);}if(A){this._moveHeaderToTitleArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);this.$titleArea.removeClass("sapMDynamicPageTitleSnapped");};
a.prototype._toggleHeaderVisibility=function(s){var d=this.getHeader();if(e(d)){d.$().toggleClass("sapMDynamicPageHeaderHidden",!s);}};
a.prototype._moveHeaderToContentArea=function(){var d=this.getHeader();if(e(d)){d.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;}};
a.prototype._moveHeaderToTitleArea=function(){var d=this.getHeader();if(e(d)){d.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;}};
a.prototype._scrollToSnapHeader=function(){var n=this._getSnappingHeight()+1;this.$wrapper&&this.$wrapper.scrollTop(n);D.system.desktop&&this._getScrollBar().setScrollPosition(n);};
a.prototype._pin=function(){if(!this._bPinned){this._bPinned=true;this.getHeader().$().appendTo(this.$titleArea);this.getHeader()._updateARIAPinButtonState(this._bPinned);}};
a.prototype._unPin=function(){if(this._bPinned){this._bPinned=false;this.getHeader().$().prependTo(this.$wrapper);this.getHeader()._updateARIAPinButtonState(this._bPinned);}};
a.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
a.prototype._getScrollPosition=function(){if(D.system.desktop){return this._getScrollBar().getScrollPosition();}else{return this.$wrapper.scrollTop();}};
a.prototype._shouldSnap=function(){return this._allowScroll()&&this._getScrollPosition()>this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
a.prototype._shouldExpand=function(){return this._allowScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};
a.prototype._headerScrolledOut=function(){return this._getScrollPosition()>this._getSnappingHeight();};
a.prototype._headerSnapAllowed=function(){return this._allowScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
a.prototype._canSnap=function(){return this._getSnappingHeight()?this.$wrapper[0].scrollHeight>this._getSnappingHeight()&&this._allowScroll():false;};
a.prototype._getSnappingHeight=function(){return this._getHeaderHeight()||this._getTitleHeight();};
a.prototype._needsVerticalScrollBar=function(){if(e(this.$wrapper)&&this._allowScroll()){return this.$wrapper[0].scrollHeight>this.$wrapper.innerHeight();}else{return false;}};
a.prototype._getOwnHeight=function(){return this._getHeight(this);};
a.prototype._getEntireHeaderHeight=function(){var t=0,h=0,d=this.getTitle(),o=this.getHeader();if(e(d)){t=d.$().outerHeight();}if(e(o)){h=o.$().outerHeight();}return t+h;};
a.prototype._headerBiggerThanAllowedToExpandWithACommand=function(){return this._getEntireHeaderHeight()>this._getOwnHeight();};
a.prototype._headerBiggerThanAllowedToPin=function(c){if(!(typeof c==="number"&&!isNaN(parseInt(c,10)))){c=this._getOwnHeight();}return this._getEntireHeaderHeight()>a.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*c;};
a.prototype._measureOffsetHeight=function(){var h=0,s=!this.getHeaderExpanded();if(!this.getHeaderScrollable()||this._bPinned){h=this._getTitleHeight()+this._getHeaderHeight();q.sap.log.debug("DynamicPage :: always show header :: title height + header height"+h,this);return h;}if(s||!e(this.getTitle())||!this._canSnap()){h=this._getTitleHeight();q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;}this._snapHeader(true);h=this._getTitleHeight();if(this._shouldExpand()&&!s){this._expandHeader();}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;};
a.prototype._updateScrollBar=function(){var s;if(D.system.desktop&&this._allowScroll()){s=this._getScrollBar();s.setContentSize(this._measureOffsetHeight()+this.$wrapper[0].scrollHeight+"px");s.toggleStyleClass("sapUiHidden",!this._needsVerticalScrollBar());this.toggleStyleClass("sapMDynamicPageWithScroll",this._needsVerticalScrollBar());}q.sap.delayedCall(0,this,this._updateScrollBarOffset);};
a.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.position.scrollbarWidth()+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};
a.prototype._updateHeaderARIAState=function(E){var d=this.getHeader();if(e(d)){d._updateARIAState(E);}};
a.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(a.MEDIA.INVISIBLE);}else if(w<=a.BREAK_POINTS.PHONE){this._updateMediaStyle(a.MEDIA.PHONE);}else if(w<=a.BREAK_POINTS.TABLET){this._updateMediaStyle(a.MEDIA.TABLET);}else{this._updateMediaStyle(a.MEDIA.DESKTOP);}};
a.prototype._updateMediaStyle=function(c){Object.keys(a.MEDIA).forEach(function(m){var E=c===a.MEDIA[m];this.toggleStyleClass(a.MEDIA[m],E);},this);};
a.prototype._updateSnappedExpandedContent=function(){var d=this.getTitle();if(e(d)){d._setShowSnapContent(d._getShowSnapContent());d._setShowExpandContent(d._getShowExpandContent());}};
a.prototype._getHeight=function(c){return!(c instanceof C)?0:c.$().outerHeight()||0;};
a.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
a.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
a.prototype._allowScroll=function(){return this.getHeaderScrollable();};
a.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
a.prototype._cacheDomElements=function(){var t=this.getTitle(),f=this.getFooter();if(e(t)){this.$title=t.$();}if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$titleArea=this.$("header");this.$wrapper=this.$("contentWrapper");this.$content=this.$("content");};
a.prototype.ontouchmove=function(E){E.setMarked();};
a.prototype._onChildControlsAfterRendering=function(){this._updateSnappedExpandedContent();q.sap.delayedCall(0,this,this._updateScrollBar);};
a.prototype._onChildControlsHeightChange=function(E){if(E.size.height!==E.oldSize.height&&!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};
a.prototype._onResize=function(E){var d=this.getHeader();if(this.getHeaderScrollable()&&d){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();d._setShowPinBtn(false);d._togglePinButton(false);}else{d._setShowPinBtn(true);}}this._updateScrollBar();this._updateMedia(E.size.width);};
a.prototype._onWrapperScroll=function(E){if(D.system.phone||!this._bExpandingWithAClick){this._toggleHeader();}if(D.system.desktop&&this._allowScroll()){if(this.allowCustomScroll===true&&E.target.scrollTop>0){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(E.target.scrollTop);this.toggleStyleClass("sapMDynamicPageWithScroll",this._needsVerticalScrollBar());}};
a.prototype._onScrollBarScroll=function(){this._toggleHeader();if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this.$wrapper.scrollTop(this._getScrollBar().getScrollPosition());};
a.prototype._titleExpandCollapseWhenAllowed=function(){if(this._headerBiggerThanAllowedToExpandWithACommand()){q.sap.log.warning("DynamicPage :: couldn't expand header. There isn't enough space for it to fit on the screen",this);return;}if(!this._allowScroll()||!this._needsVerticalScrollBar()){if(!this.getHeaderExpanded()){this._toggleHeaderVisibility(true);this._expandHeader(false);}else{this._toggleHeaderVisibility(false);this._snapHeader(false);}}else if(!this.getHeaderExpanded()){this._bExpandingWithAClick=true;this._expandHeader(true);}else if(this._headerSnapAllowed()){if(this._headerScrolledOut()){this._snapHeader(true);}else{this._scrollToSnapHeader();}}};
a.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}this._updateScrollBar();};
a.prototype._attachResizeHandlers=function(){var c=this._onChildControlsHeightChange.bind(this);if(!this._sResizeHandlerId){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));}if(!this._sTitleResizeHandlerId&&e(this.$title)){this._sTitleResizeHandlerId=R.register(this.$title[0],c);}if(!this._sContentResizeHandlerId&&e(this.$content)){this._sContentResizeHandlerId=R.register(this.$content[0],c);}};
a.prototype._detachResizeHandlers=function(){if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);}if(this._sTitleResizeHandlerId){R.deregister(this._sTitleResizeHandlerId);}if(this._sContentResizeHandlerId){R.deregister(this._sContentResizeHandlerId);}};
a.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),c=this.getContent(),o={onAfterRendering:this._onChildControlsAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(o);}if(e(c)){c.addEventDelegate(o);}};
a.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(a.EVENTS.TITLE_PRESS,this._titleExpandCollapseWhenAllowed,this);this._bAlreadyAttachedTitlePressHandler=true;}};
a.prototype._attachPinPressHandler=function(){var h=this.getHeader();if(e(h)&&!this._bAlreadyAttachedPinPressHandler){h.attachEvent(a.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
a.prototype._attachScrollHandler=function(){this.$wrapper.on("scroll",this._onWrapperScroll.bind(this));};
a.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.unbind("scroll");}};
return a;},false);
sap.ui.predefine('sap/m/DynamicPageHeader',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/InvisibleText","./ButtonType","./ToggleButton"],function(q,l,C,I,B,T){"use strict";
var D=C.extend("sap.m.DynamicPageHeader",{metadata:{interfaces:["sap.m.ISnappable"],library:"sap.m",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});
D._LIBRARY="sap.m";
D._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle(D._LIBRARY);};
D.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:D._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_SNAPPED:D._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:D._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:D._getResourceBundle().getText("UNPIN_HEADER"),STATE_TRUE:"true",STATE_FALSE:"false"};
D.prototype.onBeforeRendering=function(){if(this.getPinnable()){this._getPinButton().addAriaLabelledBy(this._getARIAInvisibleText());}};
D.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};
D.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
D.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
D.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
D.prototype._initARIAState=function(){var $=this.$();$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);};
D.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(D.ARIA.ARIA_CONTROLS,this.getId());}};
D.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);}else{$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_FALSE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_SNAPPED);}};
D.prototype._updateARIAPinButtonState=function(p){var i=this._getARIAInvisibleText();if(p){i.setText(D.ARIA.LABEL_UNPINNED);}else{i.setText(D.ARIA.LABEL_PINNED);}};
D.prototype._getARIAInvisibleText=function(){if(!this._oInvisibleText){this._oInvisibleText=new I({text:D.ARIA.LABEL_PINNED}).toStatic();}return this._oInvisibleText;};
D.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",type:B.Transparent,press:this._pinUnpinFireEvent.bind(this)});this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
D.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};
D.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
return D;},false);
sap.ui.predefine('sap/m/DynamicPageHeaderRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var c=d.getContent();r.write("<header");r.writeControlData(d);r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"region"});r.addClass("sapContrastPlus");r.addClass("sapMDynamicPageHeader");r.writeClasses();r.write(">");if(c.length>0){r.write("<div");r.addClass("sapMDynamicPageHeaderContent");r.writeClasses();r.write(">");c.forEach(r.renderControl);r.write("</div>");if(d.getPinnable()&&!sap.ui.Device.system.phone){D._renderPinUnpinArea(d,r);}}r.write("</header>");};
D._renderPinUnpinArea=function(d,r){r.write("<div");r.addClass("sapMDynamicPageHeaderPinButtonArea");r.writeClasses();r.write(">");r.renderControl(d._getPinButton());r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),E=d._allowScroll();r.write("<article");r.writeControlData(d);r.addClass("sapMDynamicPage");if(!E){r.addClass("sapMDynamicPageFixedContent");}r.writeClasses();r.write(">");if(D.system.desktop&&E){r.renderControl(d._getScrollBar().addStyleClass("sapMDynamicPageScrollBar"));}r.write("<header");r.writeAttributeEscaped("id",d.getId()+'-header');r.addClass("sapMDynamicPageTitleWrapper");r.writeClasses();r.write(">");r.renderControl(o);if(!E){r.renderControl(b);}r.write("</header>");r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-contentWrapper');r.addClass("sapMDynamicPageContentWrapper");r.writeClasses();r.write(">");if(E){r.renderControl(b);}r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-content');r.addClass("sapMDynamicPageContent");r.writeClasses();r.write(">");r.renderControl(e);r.write("</div>");r.write("</div>");a.renderPageToolbar(r,c,d);r.write("</article>");};
a.renderPageToolbar=function(r,d,o){if(d){r.write("<footer");r.writeAttributeEscaped("id",o.getId()+'-footerWrapper');r.addClass("sapContrast");r.addClass("sapContrastPlus");r.addClass("sapMDynamicPageFooter");if(!o.getShowFooter()){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");d.addStyleClass("sapMDynamicPageActualFooterControl");r.renderControl(d);r.write("</footer>");}};
return a;},true);
sap.ui.predefine('sap/m/DynamicPageTitle',["jquery.sap.global","./library","sap/ui/core/Control","./OverflowToolbar"],function(q,l,C,O){"use strict";
var D=C.extend("sap.m.DynamicPageTitle",{metadata:{library:"sap.m",aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.m.Button",multiple:true,singularName:"action"},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},_overflowToolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
function i(o){return typeof o==="function";}
D.prototype.init=function(){this._bShowAdditionalContent=false;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
D.prototype.onBeforeRendering=function(){this._getOverflowToolbar();};
D.prototype.onAfterRendering=function(){this._cacheDomElements();};
D.prototype.ontap=function(e){if(e.srcControl===this||this.getAggregation("_overflowToolbar")===e.srcControl){this.fireEvent("_titlePress");}};
D.prototype._cacheDomElements=function(){this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};
D.prototype._getOverflowToolbar=function(){if(!this.getAggregation("_overflowToolbar")){this.setAggregation("_overflowToolbar",new O({id:this.getId()+"-overflowToolbar"}).addStyleClass("sapMDynamicPageTitleOverflowToolbar"));}return this.getAggregation("_overflowToolbar");};
D.prototype._preProcessAction=function(a){if(i(a._fnOriginalGetParent)){return;}a._fnOriginalGetParent=a.getParent;a.getParent=this._fnActionSubstituteParentFunction;};
D.prototype._postProcessAction=function(a){if(!i(a._fnOriginalGetParent)){return;}a.getParent=a._fnOriginalGetParent;};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(m){D.prototype[m]=function(c){var t=this._getOverflowToolbar(),T=m.replace(/Actions?/,"Content"),r;if(m==="addAction"||m==="insertAction"){r=t[T].apply(t,arguments);this._preProcessAction(c);return r;}else if(m==="removeAction"){this._postProcessAction(c);}else if(m==="removeAllActions"||m==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);}return t[T].apply(t,arguments);};});
D.prototype._setShowSnapContent=function(v){this._bShowAdditionalContent=v;this.$snappedWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapMDynamicPageSnapContentVisible",v);};
D.prototype._getShowSnapContent=function(){return this._bShowAdditionalContent;};
D.prototype._setShowExpandContent=function(v){this._bShowExpandContent=v;this.$expandWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapMDynamicPageExpandContentVisible",v);};
D.prototype._getShowExpandContent=function(){return this._bShowExpandContent||false;};
return D;},false);
sap.ui.predefine('sap/m/DynamicPageTitleRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var a=d._getOverflowToolbar(),l=d.getHeading(),s=d.getSnappedContent(),e=d.getExpandedContent();r.write("<div");r.writeControlData(d);r.writeAccessibilityState({role:"heading",level:2});r.addClass("sapContrastPlus");r.addClass("sapMDynamicPageTitle");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMDynamicPageTitleLeft");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMDynamicPageTitleLeftInner");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMDynamicPageTitleLeftHeading");r.writeClasses();r.write(">");r.renderControl(l);r.write("</div>");if(s.length>0||e.length>0){r.write("<div");r.addClass("sapMDynamicPageTitleLeftSnappedExpandContent");r.writeClasses();r.write(">");D._renderSnappedContent(r,d,s);D._renderExpandContent(r,d,e);r.write("</div>");}r.write("</div>");r.write("</div>");r.write("<div");r.addClass("sapMDynamicPageTitleRight");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMDynamicPageTitleRightActions");r.writeClasses();r.write(">");if(a.getContent().length>0){r.renderControl(a);}r.write("</div>");r.write("</div>");r.write("</div>");};
D._renderExpandContent=function(r,d,e){if(e.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-expand-wrapper');r.writeClasses();r.write(">");e.forEach(r.renderControl);r.write("</div>");}};
D._renderSnappedContent=function(r,d,s){if(s.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-snapped-wrapper');if(!d._getShowSnapContent()){r.addClass("sapUiHidden");}r.addClass("sapMDynamicPageTitleSnapped");r.writeClasses();r.write(">");s.forEach(r.renderControl);r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/m/FacetFilter',['jquery.sap.global','./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation'],function(q,N,l,C,I,a){"use strict";
var F=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:sap.m.FacetFilterType.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{}}}});
F.SCROLL_STEP=264;
F.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(sap.ui.Device.system.phone){this.setProperty("type",sap.m.FacetFilterType.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===sap.m.FacetFilterType.Light);}if(t===sap.m.FacetFilterType.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};
F.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){this._removeResetFromSummary(s);}}return this;};
F.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===sap.m.FacetFilterType.Light);}return this;};
F.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var L=this._displayedList;var s=sap.ui.getCore().byId(L.getAssociation("search"));s.detachLiveChange(L._handleSearchEvent,L);if(v){s.attachLiveChange(L._handleSearchEvent,L);}}return this;};
F.prototype.getLists=function(){var L=this.getAggregation("lists");if(!L){L=[];}if(this._displayedList){L.splice(this._listAggrIndex,0,this._displayedList);}return L;};
F.prototype.removeList=function(o){var L=sap.ui.base.ManagedObject.prototype.removeAggregation.call(this,"lists",o);this._removeList(L);return L;};
F.prototype.removeAggregation=function(){var L=sap.ui.base.ManagedObject.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(L);}return L;};
F.prototype.openFilterDialog=function(){var d=this._getFacetDialog();var n=this._getFacetDialogNavContainer();d.addContent(n);d.setInitialFocus(n.getPages()[0].getContent()[0].getItems()[0]);d.open();return this;};
F.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._closePopoverFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._originalaDomRefs=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(q.sap.touchEventMode==="ON"&&!sap.ui.Device.system.phone){this._enableTouchSupport();}if(sap.ui.Device.system.phone){this.setType(sap.m.FacetFilterType.Light);}};
F.prototype.exit=function(){sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}};
F.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());t.setTooltip(this._getSummaryText());}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};
F.prototype.onAfterRendering=function(){if(this.getType()!==sap.m.FacetFilterType.Light&&!sap.ui.Device.system.phone){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);}this._startItemNavigation();};
sap.m.FacetFilter.prototype._startItemNavigation=function(){var f=this.getDomRef(),r=f.getElementsByClassName("sapMFFHead"),d=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){d.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){d.push(r[0].childNodes[i]);}}}if(d!=""){this._aDomRefs=d;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new sap.ui.core.delegate.ItemNavigation();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
sap.m.FacetFilter.prototype.onsapdelete=function(e){if(this._originalaDomRefs==null){this._originalaDomRefs=this._aDomRefs;}if(e.target.id.indexOf("add")>=0){return;}if(!this.getShowPersonalization()){return;}var j=-1;for(var i=0;i<this._originalaDomRefs.length;i++){if(e.target.id==this._originalaDomRefs[i].id){j=i;break;}}if(j<0){return;}var L=this.getLists()[j];if(!L.getShowRemoveFacetIcon()){return;}L.removeSelections(true);L.setSelectedKeys();L.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var n=this.oItemNavigation.getFocusedIndex();q(e.target).blur();this.oItemNavigation.setFocusedIndex(n+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};
sap.m.FacetFilter.prototype.onsaptabnext=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();e.preventDefault();e.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}if(this._closePopoverFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._closePopoverFlag=false;}};
sap.m.FacetFilter.prototype.onsaptabprevious=function(e){if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();e.preventDefault();e.setMarked();return;}if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=e.target.id){q(this._previousTarget).focus();e.preventDefault();e.setMarked();return;}if(e.target.id.indexOf("add")>=0||e.target.parentNode.className=="sapMFFHead"){this._previousTarget=e.target;q(this.$().find(":sapTabbable")[0]).focus();}};
sap.m.FacetFilter.prototype.onsapend=function(e){if(this._addTarget!=null){q(this._addTarget).focus();e.preventDefault();e.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();e.preventDefault();e.setMarked();}this._previousTarget=e.target;};
sap.m.FacetFilter.prototype.onsaphome=function(e){q(this._aRows[0]).focus();e.preventDefault();e.setMarked();this._previousTarget=e.target;};
sap.m.FacetFilter.prototype.onsappageup=function(e){this._previousTarget=e.target;};
sap.m.FacetFilter.prototype.onsappagedown=function(e){this._previousTarget=e.target;};
sap.m.FacetFilter.prototype.onsapincreasemodifiers=function(e){if(e.which==q.sap.KeyCodes.ARROW_RIGHT){this._previousTarget=e.target;var c=this.oItemNavigation.getFocusedIndex()-1;var n=c+this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
sap.m.FacetFilter.prototype.onsapdecreasemodifiers=function(e){var c=0;if(e.which==q.sap.KeyCodes.ARROW_LEFT){this._previousTarget=e.target;c=this.oItemNavigation.getFocusedIndex()+1;var n=c-this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
sap.m.FacetFilter.prototype.onsapdownmodifiers=function(e){this._previousTarget=e.target;var c=0;c=this.oItemNavigation.getFocusedIndex()-1;var n=c+this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
sap.m.FacetFilter.prototype.onsapupmodifiers=function(e){this._previousTarget=e.target;var c=0;c=this.oItemNavigation.getFocusedIndex();if(c!=0){c=c+1;}var n=c-this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
sap.m.FacetFilter.prototype.onsapexpand=function(e){this._previousTarget=e.target;var n=this.oItemNavigation.getFocusedIndex()+1;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
sap.m.FacetFilter.prototype.onsapcollapse=function(e){this._previousTarget=e.target;var n=this.oItemNavigation.getFocusedIndex()-1;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
sap.m.FacetFilter.prototype.onsapdown=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();return;}};
sap.m.FacetFilter.prototype.onsapup=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
sap.m.FacetFilter.prototype.onsapleft=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
sap.m.FacetFilter.prototype.onsapright=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
sap.m.FacetFilter.prototype.onsapescape=function(e){if(e.target.parentNode.className=="sapMFFResetDiv"){return;}var n=this._lastCategoryFocusIndex;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:sap.m.PlacementType.Bottom,beforeOpen:function(e){this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}c(t._displayedList);},afterClose:function(e){t._addDelegateFlag=true;t._closePopoverFlag=true;if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){q.sap.delayedCall(100,t,t._handlePopoverAfterClose);}else{t._handlePopoverAfterClose();}},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){p.setContentWidth("30%");}p.addStyleClass("sapMFFPop");var c=function(L){if(!L){return;}var i=t._getFacetRemoveIcon(L);if(i){i._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};
F.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),L=this._displayedList;if(!p){return;}var i=this._getFacetRemoveIcon(L);if(i&&i._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,L);L._fireListCloseEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){q.sap.delayedCall(0,this,function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;});}};
F.prototype._openPopover=function(p,c){if(!p.isOpen()){var L=sap.ui.getCore().byId(c.getAssociation("list"));this._moveListToDisplayContainer(L,p);L.fireListOpen({});p.openBy(c);if(L.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,L);}if(L.getWordWrap()){p.setContentWidth("30%");}L._applySearch();}return this;};
F.prototype._getAddFacetButton=function(){var b=this.getAggregation("addFacetButton");if(!b){var t=this;var b=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:sap.m.ButtonType.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(e){t.openFilterDialog();}});this.setAggregation("addFacetButton",b,true);}return b;};
F.prototype._getButtonForList=function(L){if(this._buttons[L.getId()]){this._setButtonText(L);return this._buttons[L.getId()];}var t=this;var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(e){var T=this;var o=function(){var p=t._getPopover();t._openPopover(p,T);};if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){q.sap.delayedCall(100,this,o);}else{var p=t._getPopover();if(p.isOpen()){q.sap.delayedCall(100,this,function(){if(p.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(o);});}else{q.sap.delayedCall(100,this,o);}}}});this._buttons[L.getId()]=b;this.addAggregation("buttons",b);b.setAssociation("list",L.getId(),true);this._setButtonText(L);return b;};
F.prototype._setButtonText=function(L){var b=this._buttons[L.getId()];if(b){var t="";var s=Object.getOwnPropertyNames(L._oSelectedKeys);var S=s.length,i;i=L.getItems().filter(function(o){return o.getVisible();}).length;switch(S){case 0:t=L.getTitle();break;case 1:var c=L._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[L.getTitle(),c]);break;case i:t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[L.getTitle()]);break;default:t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[L.getTitle(),S]);break;}b.setText(t);b.setTooltip(t);}};
F.prototype._getFacetRemoveIcon=function(L){var t=this,i=this._removeFacetIcons[L.getId()];if(!i){i=new sap.ui.core.Icon({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true;}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,L);i._bTouchStarted=false;q.sap.delayedCall(100,this,p);}},true);var p=function(){if(i._bPressed){L.removeSelections(true);L.setSelectedKeys();L.setProperty("active",false,true);}t._handlePopoverAfterClose();};i.setAssociation("list",L.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[L.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,L);}return i;};
F.prototype._displayRemoveIcon=function(d,L){if(this.getShowPersonalization()){var i=this._removeFacetIcons[L.getId()];if(d){i.removeStyleClass("sapMFFLHiddenRemoveIcon");i.addStyleClass("sapMFFLVisibleRemoveIcon");}else{i.removeStyleClass("sapMFFLVisibleRemoveIcon");i.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
F.prototype._getFacetDialogNavContainer=function(){var n=new N();var f=this._createFacetPage();n.addPage(f);n.setInitialPage(f);var t=this;n.attachAfterNavigate(function(e){var T=e.getParameters()["to"];var o=e.getParameters()['from'];if(o===f){var b=T.getContent(0)[1].getItems()[0];if(b){b.focus();}}if(T===f){o.destroySubHeader();o.destroyContent();t._selectedFacetItem.invalidate();T.invalidate();q.sap.focus(t._selectedFacetItem);t._selectedFacetItem=null;}});return n;};
F.prototype._createFacetPage=function(){var f=this._createFacetList();var o=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(e){var b=f.getBinding("items");if(b){var c=new sap.ui.model.Filter("text",sap.ui.model.FilterOperator.Contains,e.getParameters()["newValue"]);b.filter([c]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:o}),content:[f]});return p;};
F.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(e){var n=e.getSource().getParent();t._navFromFilterItemsPage(n);}});return p;};
F.prototype._getFilterItemsPage=function(n){var o=n.getPages()[1];if(o){n.removePage(o);o.destroy();}var p=this._createFilterItemsPage();n.addPage(p);return p;};
F.prototype._createFilterItemsSearchFieldBar=function(L){var t=this;var s=true;if(L.getDataType()!=sap.m.FacetFilterListDataType.String){s=false;}var S=new sap.m.SearchField({value:L._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(e){t._displayedList._handleSearchEvent(e);}});if(this.getLiveSearch()){S.attachLiveChange(L._handleSearchEvent,L);}var b=new sap.m.Bar({contentMiddle:S});L.setAssociation("search",S);return b;};
F.prototype._getFacetDialog=function(){var d=this.getAggregation("dialog");if(!d){var t=this;d=new sap.m.Dialog({showHeader:false,stretch:sap.ui.Device.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var n=this.getContent()[0];var f=n.getPages()[1];if(n.getCurrentPage()===f){var L=t._restoreListFromDisplayContainer(f);L._updateActiveState();L._fireListCloseEvent();}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px"});d.addStyleClass("sapMFFDialog");d.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){var n=this.getContent()[0];t._navFromFilterItemsPage(n);}};this.setAggregation("dialog",d,true);}return d;};
F.prototype._closeDialog=function(){var d=this.getAggregation("dialog");if(d&&d.isOpen()){d.close();}};
F.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};
F.prototype._createFacetList=function(){var f=new sap.m.List({mode:sap.m.ListMode.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",tooltip:"{text}",counter:"{count}",type:sap.m.ListType.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var b=[];for(var i=0;i<this.getLists().length;i++){var L=this.getLists()[i];b.push({text:L.getTitle(),tooltip:L.getTitle(),count:L.getAllCount(),index:i});}var m=new sap.ui.model.json.JSONModel({items:b});var t=this;f.attachUpdateFinished(function(){for(var i=0;i<f.getItems().length;i++){var o=this.getItems()[i];o.detachPress(t._handleFacetListItemPress,t);o.attachPress(t._handleFacetListItemPress,t);}});f.setModel(m);return f;};
F.prototype._createSelectAllCheckboxBar=function(L){if(!L.getMultiSelect()){return null;}var s=L.getActive()&&L.getItems().length>0&&Object.getOwnPropertyNames(L._oSelectedKeys).length===L.getItems().length;var c=new sap.m.CheckBox(L.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(e){c.setSelected(e.getParameter("selected"));h(e.getParameter("selected"));}});L.setAssociation("allcheckbox",c);var b=new sap.m.Bar();b.addEventDelegate({ontap:function(e){if(e.srcControl===this){h(c.getSelected());}}},b);b.addContentLeft(c);var h=function(s){L.getItems().forEach(function(i){i.setSelected(s);},this);};b.addStyleClass("sapMFFCheckbar");return b;};
F.prototype._handleFacetListItemPress=function(e){this._navToFilterItemsPage(e.getSource());};
F.prototype._navToFilterItemsPage=function(f){this._selectedFacetItem=f;var n=this.getAggregation("dialog").getContent()[0];var c=f.getCustomData();var i=c[0].getValue();var o=this.getLists()[i];this._listIndexAgg=this.indexOfAggregation("lists",o);if(this._listIndexAgg==i){var b=this._getFilterItemsPage(n);this._moveListToDisplayContainer(o,b);b.setSubHeader(this._createFilterItemsSearchFieldBar(o));var d=this._createSelectAllCheckboxBar(o);if(d){b.insertContent(d,0);}b.setTitle(o.getTitle());o.fireListOpen({});n.to(b);}};
F.prototype._navFromFilterItemsPage=function(n){var f=n.getPages()[1];var L=this._restoreListFromDisplayContainer(f);L._updateActiveState();L._fireListCloseEvent();this._selectedFacetItem.setCounter(L.getAllCount());n.backToTop();};
F.prototype._moveListToDisplayContainer=function(L,c){this._listAggrIndex=this.indexOfAggregation("lists",L);sap.ui.base.ManagedObject.prototype.removeAggregation.call(this,"lists",L,true);c.addAggregation("content",L,false);L.setAssociation("facetFilter",this,true);this._displayedList=L;};
F.prototype._restoreListFromDisplayContainer=function(c){var L=c.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",L,this._listAggrIndex,L.getActive());this._listAggrIndex=-1;this._displayedList=null;return L;};
F.prototype._getSequencedLists=function(){var m=-1;var s=[];var L=this.getLists();if(L.length>0){for(var i=0;i<L.length;i++){if(L[i].getActive()){if(L[i].getSequence()<-1){L[i].setSequence(-1);}else if(L[i].getSequence()>m){m=L[i].getSequence();}s.push(L[i]);}else if(!L[i].getRetainListSequence()){L[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){m+=1;s[j].setSequence(m);}}if(s.length>1){s.sort(function(b,c){return b.getSequence()-c.getSequence();});}}return s;};
F.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var b=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===sap.m.FacetFilterType.Light?true:false,design:sap.m.ToolbarDesign.Info,height:"auto",press:function(e){b.openFilterDialog();}});this.setAggregation("summaryBar",s);}return s;};
F.prototype._createResetButton=function(){var t=this;var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(e){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var L=t.getLists();for(var i=0;i<L.length;i++){L[i]._searchValue="";L[i]._applySearch();q.sap.focus(L[i].getItems()[0]);}t.invalidate();}});return b;};
F.prototype._addOKButtonToPopover=function(p){var b=p.getFooter();if(!b){var t=this;var b=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(b);}return b;};
F.prototype._getSummaryText=function(){var b=", ";var S=" ";var f="";var c=true;var L=this.getLists();if(L.length>0){for(var i=0;i<L.length;i++){var o=L[i];if(o.getActive()){var d=this._getSelectedItemsText(o);var t="";for(var j=0;j<d.length;j++){t=t+d[j]+b;}if(t){t=t.substring(0,t.lastIndexOf(b)).trim();if(c){f=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[o.getTitle(),t]);c=false;}else{f=f+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[o.getTitle(),t]);}}}}}if(!f){f=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return f;};
F.prototype._getSelectedItemsText=function(L){var t=L.getSelectedItems().map(function(v){return v.getText();});L._oSelectedKeys&&Object.getOwnPropertyNames(L._oSelectedKeys).forEach(function(v){t.indexOf(L._oSelectedKeys[v])===-1&&t.push(L._oSelectedKeys[v]);});return t;};
F.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var b=this._createResetButton();s.addContent(b);b.addStyleClass("sapMFFRefresh");b.addStyleClass("sapMFFBtnHoverable");}};
F.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var b=s.removeAggregation("content",1);b.destroy();}};
F.prototype._removeList=function(L){if(L){var b=this._buttons[L.getId()];if(b){this.removeAggregation("buttons",b);b.destroy();}var r=this._removeFacetIcons[L.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[L.getId()];delete this._removeFacetIcons[L.getId()];}};
F.prototype._getScrollingArrow=function(n){var A=null;var p={src:"sap-icon://navigation-"+n+"-arrow"};if(n==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var c=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<c.length;i++){A.addStyleClass(c[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(n==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var b=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<b.length;i++){A.addStyleClass(b[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{q.sap.log.error("Scrolling arrow name "+n+" is not valid");}return A;};
F.prototype._checkOverflow=function(){var b=this.getDomRef("head"),L=q(b),B=this.$(),s=false,S=false,c=false,i=null,d=null,e=null;if(b){i=b.scrollLeft;d=b.scrollWidth;e=b.clientWidth;if(d>e){if(d-e==1){d=e;}else{c=true;}}B.toggleClass("sapMFFScrolling",c);B.toggleClass("sapMFFNoScrolling",!c);this._lastScrolling=c;if(!this._bRtl){s=i>0;S=(d>e)&&(d>i+e);}else{S=L.scrollLeftRTL()>0;s=L.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){B.toggleClass("sapMFFNoScrollBack",!s);B.toggleClass("sapMFFNoScrollForward",!S);}}};
F.prototype.onclick=function(e){var t=e.target.id;if(t){var i=this.getId();e.preventDefault();if(t==i+"-arrowScrollLeft"){this._scroll(-F.SCROLL_STEP,500);}else if(t==i+"-arrowScrollRight"){this._scroll(F.SCROLL_STEP,500);}}};
F.prototype._scroll=function(d,D){var o=this.getDomRef("head");var s=o.scrollLeft;if(!sap.ui.Device.browser.internet_explorer&&this._bRtl){d=-d;}var S=s+d;q(o).stop(true,true).animate({scrollLeft:S},D);};
F.prototype._enableTouchSupport=function(){var t=this;var T=function(e){e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var f=function(e){var d=e.touches[0].pageX-t.startTouchX;var L=t.getDomRef("head");var o=L.scrollLeft;var n=t.startScrollX-d;L.scrollLeft=n;t._bTouchNotMoved=false;var c=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(c>0){t._velocity=(n-o)/c;}e.preventDefault();};var b=function(e){if(t._bTouchNotMoved===false){e.preventDefault();var L=t.getDomRef("head");var d=50;var c=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var g=t._velocity*d;L.scrollLeft=L.scrollLeft+g;if(Math.abs(t._velocity)<c){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},d);}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:T},this);this.addEventDelegate({ontouchend:b},this);this.addEventDelegate({ontouchmove:f},this);};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var F=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
F.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);};
F.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);};
F.prototype.init=function(){L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);
F.renderLIContent=function(r,c){r.write("<div");if(c.getParent()&&c.getParent().getWordWrap()){r.addClass("sapMFFLITitleWrap");}else{r.addClass("sapMFFLITitle");}r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['jquery.sap.global','./List','./library'],function(q,L,l){"use strict";
var F=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:sap.m.FacetFilterListDataType.String}},events:{listOpen:{},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}}}}});
F.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}return this;};
F.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?sap.m.ListMode.MultiSelect:sap.m.ListMode.SingleSelectMaster;this.setMode(m);return this;};
F.prototype.setMode=function(m){if(m===sap.m.ListMode.MultiSelect||m===sap.m.ListMode.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===sap.m.ListMode.MultiSelect?true:false,true);}return this;};
F.prototype._applySearch=function(){var s=this._getSearchValue();if(s!=null){this._search(s,true);}};
F.prototype.getSelectedItems=function(){var s=[];var c={};var C=sap.m.ListBase.prototype.getSelectedItems.apply(this,arguments);C.forEach(function(i){s.push(new sap.m.FacetFilterItem({text:i.getText(),key:i.getKey(),selected:true}));c[i.getKey()]=true;});var S=this.getSelectedKeys();var a=Object.getOwnPropertyNames(S);if(C.length<a.length){a.forEach(function(k){if(!c[k]){s.push(new sap.m.FacetFilterItem({text:S[k],key:k,selected:true}));}});}return s;};
F.prototype.getSelectedItem=function(){var i=sap.m.ListBase.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new sap.m.FacetFilterItem({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
F.prototype.removeSelections=function(a){if(this._allowRemoveSelections){a?this.setSelectedKeys():sap.m.ListBase.prototype.removeSelections.call(this,a);}return this;};
F.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(a){r[a]=k[a];});return r;};
F.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(a){this._addSelectedKey(a,k[a]);K=true;},this);if(K){this.setActive(true);this._selectItemsByKeys();}else{sap.m.ListBase.prototype.removeSelections.call(this);}};
F.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this.getItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
F.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};sap.m.ListBase.prototype.removeSelections.call(this,true);};
F.prototype.removeItem=function(i){var I=sap.m.ListBase.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
F.prototype.init=function(){this._firstTime=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(sap.m.ListMode.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue=null;this.attachUpdateFinished(function(e){var u=e.getParameter("reason");if(u){u=u.toLowerCase();if(u!==sap.ui.model.ChangeReason.Filter.toLowerCase()){this._selectItemsByKeys();}}else{this._selectItemsByKeys();}});this._allowRemoveSelections=true;};
F.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._searchValue=null;this._allowRemoveSelections=false;sap.m.ListBase.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
F.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var a=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:a});};
F.prototype._updateActiveState=function(){var c=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(c&&c.getSelected())){this.setActive(true);}};
F.prototype._handleSearchEvent=function(e){var s=e.getParameters()["query"];if(s===undefined){s=e.getParameters()["newValue"];}this._search(s);this._updateSelectAllCheckBox();};
F.prototype._search=function(s,f){var b;var n=0;function i(m){return m instanceof sap.ui.model.odata.ODataModel||m instanceof sap.ui.model.odata.v2.ODataModel;}if(f||(s!==this._searchValue)){this._searchValue=s;var B=this.getBinding("items");var o=this.getBindingInfo("items");if(o&&o.binding){b=o.binding.aFilters;if(b.length>0){n=b[0].aFilters.length;if(this._firstTime){this._saveBindInfo=b[0].aFilters[0];this._firstTime=false;}}}if(B){if(s||n>0){var p=this.getBindingInfo("items").template.getBindingInfo("text").parts[0].path;if(p){var u=new sap.ui.model.Filter(p,sap.ui.model.FilterOperator.Contains,s);if(this.getEnableCaseInsensitiveSearch()&&i(B.getModel())){var e="'"+String(s).replace(/'/g,"''")+"'";e=e.toLowerCase();u=new sap.ui.model.Filter("tolower("+p+")",sap.ui.model.FilterOperator.Contains,e);}if(n>1){var a=new sap.ui.model.Filter([u,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&u.sPath!=this._saveBindInfo.sPath){var a=new sap.ui.model.Filter([u,this._saveBindInfo],true);}else{if(s==""){var a=[];}else{var a=new sap.ui.model.Filter([u],true);}}}B.filter(a,sap.ui.model.FilterType.Control);}}else{B.filter([],sap.ui.model.FilterType.Control);}}else{q.sap.log.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
F.prototype._getSearchValue=function(){return this._searchValue;};
F.prototype._updateSelectAllCheckBox=function(){var i=this.getItems().length,c,a,s;function b(I){return I.getSelected();}if(this.getMultiSelect()){c=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));a=i>0&&i===this.getItems().filter(b).length;s=this.getActive()&&a;c&&c.setSelected(s);}};
F.prototype._addSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===sap.m.ListMode.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
F.prototype._removeSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
F.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
F.prototype._selectItemsByKeys=function(){this.getItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);};
F.prototype.onItemSelectedChange=function(i,s){if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}sap.m.ListBase.prototype.onItemSelectedChange.apply(this,arguments);this.setActive(this.getActive()||s);!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};
F.prototype.updateItems=function(r){this._filtering=r===sap.ui.model.ChangeReason.Filter;sap.m.ListBase.prototype.updateItems.apply(this,arguments);this._filtering=false;if(!this.getGrowing()||r===sap.ui.model.ChangeReason.Filter){this._selectItemsByKeys();}};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterListRenderer',['jquery.sap.global','./ListRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',['jquery.sap.global'],function(q){"use strict";var F={};var a={};
F.render=function(r,c){switch(c.getType()){case sap.m.FacetFilterType.Simple:F.renderSimpleFlow(r,c);break;case sap.m.FacetFilterType.Light:F.renderSummaryBar(r,c);break;}};
F.renderSimpleFlow=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");if(c.getShowSummaryBar()){r.write(">");F.renderSummaryBar(r,c);}else{if(c._lastScrolling){r.addClass("sapMFFScrolling");}else{r.addClass("sapMFFNoScrolling");}if(c.getShowReset()){r.addClass("sapMFFResetSpacer");}r.writeClasses();r.write(">");if(sap.ui.Device.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.write("<div");r.writeAttribute("id",c.getId()+"-head");r.addClass("sapMFFHead");r.writeClasses();r.write(">");F.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){r.renderControl(c.getAggregation("addFacetButton"));}r.write("</div>");if(sap.ui.Device.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.write("<div");r.addClass("sapMFFResetDiv");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("resetButton"));r.write("</div>");}}r.write("</div>");};
F.renderSummaryBar=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");r.writeClasses();r.write(">");var s=c.getAggregation("summaryBar");r.renderControl(s);r.write("</div>");};
F.getAriaAnnouncement=function(k,b){if(a[k]){return a[k];}b=b||"FACETFILTER_"+k.toUpperCase();a[k]=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(b)}).toStatic().getId();return a[k];};
F.getAriaDescribedBy=function(c){var d=[];if(c.getShowPersonalization()){d.push(this.getAriaAnnouncement("ARIA_REMOVE"));}d=d.concat(c._aAriaPositionTextIds);return d.join(" ");};
F.getAccessibilityState=function(c){return{describedby:{value:this.getAriaDescribedBy(c),append:true}};};
F.renderFacetFilterListButtons=function(c,r){var l=c._getSequencedLists(),L=l.length,b,i,p,A,o=[],n=[],f=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTER_ARIA_FACET_FILTER"),R=this.getAriaAnnouncement("ARIA_REMOVE");for(i=0;i<L;i++){b=c._getButtonForList(l[i]);o=b.removeAllAriaDescribedBy();o.forEach(d);p=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTERLIST_ARIA_POSITION",[(i+1),L]);A=new sap.ui.core.InvisibleText({text:f+" "+p}).toStatic();b.addAriaDescribedBy(A);n.push(A.getId());if(c.getShowPersonalization()){b.addAriaDescribedBy(F.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(b);if(c.getShowPersonalization()){r.renderControl(c._getFacetRemoveIcon(l[i]));}}c._aAriaPositionTextIds=n;function d(I){if(R!==I){var e=sap.ui.getCore().byId(I);if(e){e.destroy();}}}};
return F;},true);
sap.ui.predefine('sap/m/FeedContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text'],function(q,l,C,T){"use strict";
var F=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},aggregations:{"contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
F.prototype.init=function(){this._oContentText=new sap.m.Text(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("contentTextAgr",this._oContentText);this.setTooltip("{AltText}");};
F.prototype.getAltText=function(){var a="";var i=true;if(this.getAggregation("contentTextAgr").getText()){a+=this.getAggregation("contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){a+=""+this.getSubheader();}else{a+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){a+=""+this.getValue();}else{a+="\n"+this.getValue();}}return a;};
F.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
F.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
F.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();};
F.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
F.prototype.attachEvent=function(e,d,f,a){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
F.prototype.detachEvent=function(e,f,a){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return F;},true);
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttributeEscaped("title",t);r.writeAttribute("id",c.getId()+"-feed-content");r.writeAttribute("role","presentation");if(sap.ui.Device.browser.firefox){r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+""+t);}else{r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+" "+t);}r.addClass("sapMFC");if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");if(v){r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMFCValue");r.addClass(c.getValueColor());r.writeClasses();r.write(">");var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped("");}r.write("</div>");}r.write("<div");r.addClass("sapMFCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMFCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/HTML','sap/ui/core/IconPool'],function(q,l,C,H,I){"use strict";
var F=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},maxLength:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});
F.prototype.init=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",b.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",b.getText("FEEDINPUT_SUBMIT"),true);};
F.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};
F.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);if(this._getImageControl()instanceof sap.m.Image){this._getImageControl().setDensityAware(i);}return this;};
F.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
F.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
F.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
F.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this._getTextArea().setEnabled(e);this._enablePostButton();return this;};
F.prototype.setButtonTooltip=function(b){this.setProperty("buttonTooltip",b,true);this._getPostButton().setTooltip(b);return this;};
F.prototype._getTextArea=function(){if(!this._oTextArea){this._oTextArea=new sap.m.TextArea(this.getId()+"-textArea",{rows:1,value:null,maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);}return this._oTextArea;};
F.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new sap.m.Button(this.getId()+"-button",{enabled:false,type:sap.m.ButtonType.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(e){this._oTextArea.focus();this.firePost({value:this.getValue()});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
F.prototype._enablePostButton=function(){var v=this.getProperty("value");var i=this.getProperty("enabled");var p=(i&&!!v&&v.trim().length>0);var b=this._getPostButton();b.setEnabled(p);};
F.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),s=this.getId()+'-icon',p={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},c=['sapMFeedInImage'];this._oImageControl=sap.m.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);return this._oImageControl;};
return F;},true);
sap.ui.predefine('sap/m/FeedInputRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var m=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapMFeedIn");if(!c.getShowIcon()){r.addClass("sapMFeedInNoIcon");}r.writeClasses();r.write(">");if(!!c.getShowIcon()){this._addImage(r,c,m);}r.write('<div id="'+m+'-container"');r.addClass("sapMFeedInContainer");r.writeClasses();r.write(">");var t=c._getTextArea();r.renderControl(t);r.renderControl(c._getPostButton());r.write("</div>");r.write("</div>");};
F._addImage=function(r,c,m){r.write('<figure id="'+m+'-figure" class ="sapMFeedInFigure');if(!!c.getIcon()){r.write('">');}else{r.write(' sapMFeedListItemIsDefaultIcon">');}r.renderControl(c._getImageControl());r.write('</figure>');};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var F=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
F._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");F._nMaxCharactersMobile=300;F._nMaxCharactersDesktop=500;F._sTextShowMore=F._oRb.getText("TEXT_SHOW_MORE");F._sTextShowLess=F._oRb.getText("TEXT_SHOW_LESS");
F.prototype.exit=function(){if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
F.prototype.ontap=function(e){if(e.srcControl){if((!this.getIconActive()&&this._oImageControl&&e.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&e.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(e.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(e.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(e.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[e]);}}};
F.prototype._getImageControl=function(){var i=this.getIcon();var I=i?i:sap.ui.core.IconPool.getIconURI("person-placeholder");var s=this.getId()+'-icon';var p={src:I,alt:this.getSender(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var c;if(this.getIconActive()){c=['sapMFeedListItemImage'];}else{c=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=sap.m.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);if(this.getIconActive()){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}return this._oImageControl;};
F.prototype._getLinkSender=function(w){if(!this._oLinkControl){q.sap.require("sap.m.Link");var t=this;this._oLinkControl=new sap.m.Link({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+F._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
F.prototype._activeHandlingInheritor=function(){var a=this.getActiveIcon();if(this._oImageControl&&a){this._oImageControl.setSrc(a);}};
F.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():sap.ui.core.IconPool.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};
F.prototype._getCollapsedText=function(){var s=this._sFullText.substring(0,this._nMaxCollapsedLength);var n=s.lastIndexOf(" ");if(n>0){this._sShortText=s.substr(0,n);}else{this._sShortText=s;}return this._sShortText;};
F.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var a=this.$("threeDots");if(this._bTextExpanded){this._getCollapsedText();$.html(q.sap.encodeHTML(this._sShortText).replace(/&#xa;/g,"<br>"));a.text(" ... ");this._oLinkExpandCollapse.setText(F._sTextShowMore);this._bTextExpanded=false;}else{$.html(q.sap.encodeHTML(this._sFullText).replace(/&#xa;/g,"<br>"));a.text("  ");this._oLinkExpandCollapse.setText(F._sTextShowLess);this._bTextExpanded=true;}};
F.prototype._getLinkExpandCollapse=function(){if(!this._oLinkExpandCollapse){q.sap.require("sap.m.Link");this._oLinkExpandCollapse=new sap.m.Link({text:F._sTextShowMore,press:q.proxy(function(){this._toggleTextExpanded();},this)});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
F.prototype._checkTextIsExpandable=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(sap.ui.Device.system.phone){this._nMaxCollapsedLength=F._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=F._nMaxCharactersDesktop;}}this._sFullText=this.getText();var t=false;if(this._sFullText.length>this._nMaxCollapsedLength){t=true;}return t;};
sap.m.FeedListItem.prototype.setType=function(t){if(t==sap.m.ListType.Navigation){this.setProperty("type",sap.m.ListType.Active);}else{this.setProperty("type",t);}return this;};
F.prototype.setUnread=function(v){this.setProperty("unread",false);return this;};
return F;},true);
sap.ui.predefine('sap/m/FeedListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);
F.renderLIAttributes=function(r,f){r.addClass("sapMFeedListItemTitleDiv");r.addClass("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,f){var m=f.getId(),i=sap.ui.Device.system.phone;r.write('<div');r.addClass('sapMFeedListItem');r.writeClasses();r.write('>');if(!!f.getShowIcon()){this._writeImageControl(r,f,m);}if(i){r.write('<div class= "sapMFeedListItemHeader ');if(!!f.getShowIcon()){r.write('sapMFeedListItemHasFigure ');}if(!!f.getSender()&&!!f.getTimestamp()){r.write('sapMFeedListItemFullHeight');}r.write('" >');if(!!f.getSender()){r.write('<p id="'+m+'-name" class="sapMFeedListItemTextName">');r.renderControl(f._getLinkSender(false));r.write('</p>');}if(!!f.getTimestamp()){r.write('<p class="sapMFeedListItemTimestamp">');r.writeEscaped(f.getTimestamp());r.write('</p>');}r.write('</div>');r.write('<p class="sapMFeedListItemText">');r.write('<span id="'+m+'-realtext" class="sapMFeedListItemText">');if(!!f._checkTextIsExpandable()){this._writeCollapsedText(r,f,m);}else{r.writeEscaped(f.getText(),true);r.write('</span>');}r.write('</p>');if(!!f.getInfo()){r.write('<p class="sapMFeedListItemFooter">');if(!!f.getInfo()){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfo">');r.writeEscaped(f.getInfo());r.write('</span>');}r.write('</p>');}}else{r.write('<div class= "sapMFeedListItemText ');if(!!f.getShowIcon()){r.write('sapMFeedListItemHasFigure');}r.write('" >');r.write('<p id="'+m+'-text" class="sapMFeedListItemTextText"');r.writeAttribute("aria-hidden",true);r.write('>');if(!!f.getSender()){r.write('<span id="'+m+'-name" class="sapMFeedListItemTextName">');r.renderControl(f._getLinkSender(true));r.write(' ');r.write('</span>');}r.write('<span id="'+m+'-realtext" class="sapMFeedListItemTextString">');if(!!f._checkTextIsExpandable()){this._writeCollapsedText(r,f,m);}else{r.writeEscaped(f.getText(),true);r.write('</span>');}r.write('</p>');if(!!f.getInfo()||!!f.getTimestamp()){r.write('<p class="sapMFeedListItemFooter">');if(!sap.ui.getCore().getConfiguration().getRTL()){if(!!f.getInfo()){this._writeInfo(r,f,m);if(!!f.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}}if(!!f.getTimestamp()){this._writeTimestamp(r,f,m);}}else{if(!!f.getTimestamp()){this._writeTimestamp(r,f,m);}if(!!f.getInfo()){if(!!f.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}this._writeInfo(r,f,m);}}r.write('</p>');}r.write('</div>');}r.write('</div>');};
F._writeImageControl=function(r,f,m){r.write('<figure id="'+m+'-figure"');r.writeAttribute("aria-hidden",true);r.addClass('sapMFeedListItemFigure');if(!f.getIcon()){r.addClass('sapMFeedListItemIsDefaultIcon');}r.writeClasses();r.write('>');r.renderControl(f._getImageControl());r.write('</figure>');};
F._writeCollapsedText=function(r,f,m){if(f._bTextExpanded){r.writeEscaped(f._sFullText,true);r.write('</span>');r.write('<span id="'+m+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32");r.write('</span>');}else{r.writeEscaped(f._getCollapsedText(),true);r.write('</span>');r.write('<span id="'+m+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32&#46&#46&#46&#32");r.write('</span>');}var l=f._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,f,m){r.write('<span id="'+m+'-timestamp">');r.writeEscaped(f.getTimestamp());r.write('</span>');};
F._writeInfo=function(r,f,m){r.write('<span id="'+m+'-info">');r.writeEscaped(f.getInfo());r.write('</span>');};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/EventProvider'],function(q,O,E){"use strict";var e=new E(),a,c;
var H=O.extend("HeaderAdapter",{constructor:function(h,A){if(!h||!A){q.sap.log.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=h;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButton=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,C=this._oAdaptOptions.bCollapseHeader;if(s){this._adaptStyle("sapF2Adapted");}var t=this._adaptTitle(this._oAdaptOptions),B=this._adaptBackButton(this._oAdaptOptions);if(C){this._collapseHeader(t,B);}return{bTitleHidden:t,bBackButtonHidden:B};};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,bBackButton:this._oBackButton};};
H.prototype._adaptTitle=function(){if(!this._isStandardHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=this._oTitleInfo||this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.addStyleClass("sapF2AdaptedTitle");}return s;};
H.prototype._adaptBackButton=function(){if(!this._isStandardHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var B=false;this.oBackButton=this._detectBackButton();if(this.oBackButton){this.oBackButton.addStyleClass("sapF2AdaptedNavigation");B=true;}return B;};
H.prototype._adaptStyle=function(C){var p=this._oHeader.getParent();if(p){p.addStyleClass(C,true);}};
H.prototype._isStandardHeader=function(h){return h&&b(h,"sap/m/Bar");};
H.prototype._detectTitle=function(){var t;if(this._isStandardHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&i(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change"};}}return t;};
H.prototype._detectSubTitle=function(p){if(b(p,"sap/uxap/ObjectPageHeader")){var h=p.getHeaderTitle();if(h){return{id:h.getId(),text:h.getObjectTitle(),oControl:h,sChangeEventId:"_titleChange"};}}};
H.prototype._detectBackButton=function(){if(this._isStandardHeader(this._oHeader)){var B=this._oHeader.getContentLeft();if(B.length>0&&b(B[0],"sap/m/Button")&&(B[0].getType()==="Back"||B[0].getType()==="Up"||B[0].getIcon()==="sap-icon://nav-back")){return B[0];}}};
H.prototype._collapseHeader=function(t,B){if(this._isStandardHeader(this._oHeader)){var d=this._oHeader.getContentLeft();var m=this._oHeader.getContentMiddle();var f=this._oHeader.getContentRight();if((d.length===0||(d.length===1&&B))&&(m.length===0||(m.length===1&&t))&&(f.length===0)){this._adaptStyle("sapF2CollapsedHeader");}}};
var F=O.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l){e.attachEvent("viewChange",l);};
F.detachViewChange=function(l){e.detachEvent("viewChange",l);};
F.traverse=function(C,A){a={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{},aAdaptedViews:{},aChangeListeners:{}};c=null;this._doBFS([{oNode:C,oAdaptOptions:A}]);};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!N||!this._isAdaptationRequired(A)||(s<=0)){return;}var o=this._processNode(N,A);var C=this._getNodeChildren(N),d=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){d=q.extend(d,{bMoveTitle:A.bMoveTitle&&!o.bTitleHidden,bHideBackButton:A.bHideBackButton&&!o.bBackButtonHidden});}C.forEach(function(f){if(f){Q.push({oNode:f,oAdaptOptions:d});}});this._doBFS(Q);};
F._processNode=function(C,A){if(C._getAdaptableContent&&q.isFunction(C._getAdaptableContent)){C.attachEvent("_adaptableContentChange",function(f){var g=f.getParameter("adaptableContent");this._adaptContent(g,C,A);}.bind(this));if(b(C,"sap/m/Page")){C._attachModifyAggregation("content",A,function(f){var T=f.getParameter("type"),g=f.getParameter("object");if((T==="add")||(T==="insert")){this._doBFS([{oNode:g,oAdaptOptions:A}]);}},this);}if(b(C,"sap/m/NavContainer")){C.attachNavigate(function(f){this._adaptNavigableView(f.getParameter("to"),A);}.bind(this));}return this._adaptContent(C._getAdaptableContent(),C,A);}if(b(C,"sap/ui/core/ComponentContainer")){var o=C.getComponentInstance();if(!o&&C.getName()&&!C.getDomRef()){var t=this;var d={onBeforeRendering:function(){C.removeEventDelegate(d);t._doBFS([{oNode:C.getComponentInstance(),oAdaptOptions:A}]);}};C.addEventDelegate(d,this);}}};
F._getNodeChildren=function(C){if(b(C,"sap/m/NavContainer")){return[C.getCurrentPage()];}if(b(C,"sap/m/SplitContainer")){return[].concat(C.getAggregation("_navMaster"),C.getAggregation("_navDetail"));}if(b(C,"sap/m/Page")){return C.getContent();}if(b(C,"sap/uxap/ObjectPageLayout")){return[C.getHeaderTitle()];}if(b(C,"sap/ui/core/ComponentContainer")){return[C.getComponentInstance()];}if(b(C,"sap/ui/core/Component")){return[C.getAggregation("rootControl")];}return C.findAggregatedObjects(false);};
F._updateSearchDepth=function(s,C){if(b(C,"sap/ui/core/mvc/View")||b(C,"sap/ui/core/Component")||b(C,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._skipDoneAdaptations=function(A){A=q.extend({},A);if(a.aAdaptedViews[c]){A.bStylePage=false;}if(a.aViewTitles[c]){A.bMoveTitle=false;}if(a.aViewBackButtons[c]){A.bHideBackButton=false;}return A;};
F._applyRules=function(A,C){var p=C.getParent();if(b(p,"sap/m/SplitContainer")){var I=sap.ui.Device.system.phone,m=A.bMoveTitle,d;if(m){m=I;}var d=A.bHideBackButton;if(d&&!sap.ui.Device.system.phone){d='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:d});}if(b(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var f=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===C.getId());return q.extend({},A,{bHideBackButton:f});}}return A;};
F._adaptContent=function(C,p,A){if(b(p,"sap/m/Page")||b(p,"sap/uxap/ObjectPageHeader")){return this._adaptHeader(C,A);}if(b(p,"sap/m/NavContainer")){return this._adaptNavigableView(C,A);}};
F._adaptHeader=function(h,A){if(!h||!A){return;}var o=new H(h,A),r=o.adapt(),d=o.getAdaptedContent();if(d.oTitleInfo){a.aViewTitles[c]=d.oTitleInfo;this._registerChangeListener(a.aViewTitles,c);}if(d.oSubTitleInfo){a.aViewSubTitles[c]=d.oSubTitleInfo;this._registerChangeListener(a.aViewSubTitles,c);}if(d.oBackButton){a.aViewBackButtons[c]=d.oBackButton;}return r;};
F._registerChangeListener=function(t,v){var T=t[v];if(T&&T.oControl&&T.sChangeEventId&&!a.aChangeListeners[T.id]){var C=function(o){var T=t[v];T.text=o.getParameter("newValue");this._fireViewChange(v);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,C);a.aChangeListeners[T.id]=C;}};
F._fireViewChange=function(v){e.fireEvent("viewChange",{sViewId:v,oTitleInfo:a.aViewTitles[v],oSubTitleInfo:a.aViewSubTitles[v],oBackButton:a.aViewBackButtons[v]});};
F._adaptNavigableView=function(v,A){if(!v||!A){return;}c=v.getId();if(a.aAdaptedViews[c]){A=this._skipDoneAdaptations(A);}A=q.extend({},A,{iSearchDepth:A.iSearchDepth-1});this._doBFS([{oNode:v,oAdaptOptions:A}]);a.aAdaptedViews[c]=v;this._fireViewChange(c);};
F._isAdaptationRequired=function(A){for(var o in A){if(A.hasOwnProperty(o)&&(A[o]===true)){return true;}}return false;};
function i(C){if(!C){return false;}return b(C,"sap/m/Label")||b(C,"sap/m/Text")||b(C,"sap/m/Title");}
function b(C,t){var T=sap.ui.require(t);return T&&(C instanceof T);}
return F;},false);
sap.ui.predefine('sap/m/FlexBox',['jquery.sap.global','./FlexBoxStylingHelper','./library','sap/ui/core/Control'],function(q,F,l,C){"use strict";
var a=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:sap.m.FlexDirection.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:sap.m.FlexRendertype.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:sap.m.FlexJustifyContent.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:sap.m.FlexAlignItems.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:sap.m.FlexWrap.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:sap.m.FlexAlignContent.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}}}});
a.prototype.init=function(){if(this instanceof sap.m.HBox&&(this.getDirection()!==sap.m.FlexDirection.Row||this.getDirection()!==sap.m.FlexDirection.RowReverse)){this.setDirection('Row');}if(this instanceof sap.m.VBox&&(this.getDirection()!==sap.m.FlexDirection.Column||this.getDirection()!==sap.m.FlexDirection.ColumnReverse)){this.setDirection('Column');}};
a.prototype.addItem=function(i){this.addAggregation("items",i);if(i&&!(i instanceof sap.m.FlexBox)){i.attachEvent("_change",this.onItemChange,this);}return this;};
a.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);if(i&&!(i instanceof sap.m.FlexBox)){i.attachEvent("_change",this.onItemChange,this);}return this;};
a.prototype.removeItem=function(i){var I=this.removeAggregation("items",i,true);if(I&&!(I instanceof sap.m.FlexBox)){I.detachEvent("_change",this.onItemChange,this);if(I instanceof sap.m.FlexBox){I.$().remove();}else{I.$().parent().remove();}}return I;};
a.prototype.removeAllItems=function(){var I=this.getItems();for(var i=0;i<I.length;i++){I[i].detachEvent("_change",this.onItemChange,this);}return this.removeAllAggregation("items");};
a.prototype.onItemChange=function(c){if(c.getParameter("name")!=="visible"||(this.getRenderType()!==sap.m.FlexRendertype.List&&this.getRenderType()!==sap.m.FlexRendertype.Div)){return;}var i=sap.ui.getCore().byId(c.getParameter("id")),w=null;if(i.getLayoutData()){w=q.sap.byId(i.getLayoutData().getId());}else{w=q.sap.byId(sap.ui.core.RenderPrefixes.Invisible+i.getId()).parent();}if(c.getParameter("newValue")){w.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{w.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
a.prototype.setDisplayInline=function(i){this.setProperty("displayInline",i,true);this.$().toggleClass("sapMFlexBoxInline",this.getDisplayInline());return this;};
a.prototype.setDirection=function(v){this.setProperty("direction",v,true);if(this.getDirection()===sap.m.FlexDirection.Column||this.getDirection()===sap.m.FlexDirection.ColumnReverse){this.$().removeClass("sapMHBox").addClass("sapMVBox");}else{this.$().removeClass("sapMVBox").addClass("sapMHBox");}if(this.getDirection()===sap.m.FlexDirection.RowReverse||this.getDirection()===sap.m.FlexDirection.ColumnReverse){this.$().addClass("sapMFlexBoxReverse");}else{this.$().removeClass("sapMFlexBoxReverse");}return this;};
a.prototype.setFitContainer=function(v){this.setProperty("fitContainer",v,true);this.$().toggleClass("sapMFlexBoxFit",this.getFitContainer());return this;};
a.prototype.setWrap=function(v){var o=this.getWrap();this.setProperty("wrap",v,true);this.$().removeClass("sapMFlexBoxWrap"+o).addClass("sapMFlexBoxWrap"+this.getWrap());return this;};
a.prototype.setJustifyContent=function(v){var o=this.getJustifyContent();this.setProperty("justifyContent",v,true);this.$().removeClass("sapMFlexBoxJustify"+o).addClass("sapMFlexBoxJustify"+this.getJustifyContent());return this;};
a.prototype.setAlignItems=function(v){var o=this.getAlignItems();this.setProperty("alignItems",v,true);this.$().removeClass("sapMFlexBoxAlignItems"+o).addClass("sapMFlexBoxAlignItems"+this.getAlignItems());return this;};
a.prototype.setAlignContent=function(v){var o=this.getAlignContent();this.setProperty("alignContent",v,true);this.$().removeClass("sapMFlexBoxAlignContent"+o).addClass("sapMFlexBoxAlignContent"+this.getAlignContent());return this;};
a.prototype.setHeight=function(v){this.setProperty("height",v,true);this.$().css("height",this.getHeight());return this;};
a.prototype.setWidth=function(v){this.setProperty("width",v,true);this.$().css("width",this.getWidth());return this;};
a.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
a.prototype.getAccessibilityInfo=function(){var c=this.getItems();var b=[];for(var i=0;i<c.length;i++){if(c[i].getAccessibilityInfo){var I=c[i].getAccessibilityInfo();if(I){b.push(I);}}}return{children:b};};
return a;},true);
sap.ui.predefine('sap/m/FlexBoxCssPropertyMap',['jquery.sap.global'],function(q){"use strict";var F={'spec0907':{'order':{'<number>':{'box-ordinal-group':'<integer>'}},'flex-grow':{'<number>':{'box-flex':'<number>'}},'flex-shrink':null,'flex-basis':null},'specie10':{'order':{'<number>':{'flex-order':'<number>'}},'flex-grow':{'<number>':{'flex-positive':'<number>','flex-preferred-size':'auto'}},'flex-shrink':{'<number>':{'flex-negative':'<number>'}},'flex-basis':{'<number>':{'flex-preferred-size':'<number>'}}}};return F;},true);
sap.ui.predefine('sap/m/FlexBoxRenderer',['jquery.sap.global','./FlexBoxStylingHelper'],function(q,F){"use strict";if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.sap.log.warning("This browser does not support flexible box layouts natively.");}var a={};
a.render=function(r,c){if(c.getRenderType()===sap.m.FlexRendertype.List){r.write('<ul');}else{r.write('<div');}r.writeControlData(c);var p=c.getParent();if(c.getParent()instanceof sap.m.FlexBox){r.addClass("sapMFlexItem");var l=c.getLayoutData();if(l instanceof sap.m.FlexItemData){F.setFlexItemStyles(r,l);}if(p.getRenderType()===sap.m.FlexRendertype.List){r.write('<li');}}else if(c.getFitContainer()){r.addClass("sapMFlexBoxFit");}r.addClass("sapMFlexBox");if(c.getDisplayInline()){r.addClass("sapMFlexBoxInline");}if(c.getDirection()===sap.m.FlexDirection.Column||c.getDirection()===sap.m.FlexDirection.ColumnReverse){r.addClass("sapMVBox");}else{r.addClass("sapMHBox");}if(c.getDirection()===sap.m.FlexDirection.RowReverse||c.getDirection()===sap.m.FlexDirection.ColumnReverse){r.addClass("sapMFlexBoxReverse");}r.addClass("sapMFlexBoxJustify"+c.getJustifyContent());r.addClass("sapMFlexBoxAlignItems"+c.getAlignItems());r.addClass("sapMFlexBoxWrap"+c.getWrap());r.addClass("sapMFlexBoxAlignContent"+c.getAlignContent());r.addClass("sapMFlexBoxBG"+c.getBackgroundDesign());r.writeClasses();if(c.getHeight()){r.addStyle("height",c.getHeight());}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");a.renderItems(c,r);if(c.getRenderType()===sap.m.FlexRendertype.List){r.write("</ul>");}else{r.write("</div>");}};
a.renderItems=function(c,r){var C=c.getItems(),w='';for(var i=0;i<C.length;i++){if(C[i]instanceof sap.m.FlexBox){w="";}else if(c.getRenderType()===sap.m.FlexRendertype.List){w="li";}else{w="div";}a.renderItem(C[i],w,r);}};
a.renderItem=function(i,w,r){if(w){r.write('<'+w);var l=i.getLayoutData();if(l instanceof sap.m.FlexItemData){if(l.getId()){r.writeAttributeEscaped("id",l.getId());}if(l.getStyleClass()){r.addClass(q.sap.encodeHTML(l.getStyleClass()));}r.addClass("sapMFlexItemAlign"+l.getAlignSelf());r.addClass("sapMFlexBoxBG"+l.getBackgroundDesign());F.setFlexItemStyles(r,l);r.writeStyles();if(i instanceof sap.m.ScrollContainer){r.addClass("sapMFlexBoxFit");}if(!i.getVisible()){r.addClass("sapUiHiddenPlaceholder");}}r.addClass("sapMFlexItem");r.writeClasses();r.write(">");}r.renderControl(i);if(w){r.write('</'+w+'>');}};
return a;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',['jquery.sap.global','./FlexBoxCssPropertyMap'],function(q,F){"use strict";var a={};
a.setFlexItemStyles=function(r,l){r=r||null;var o=l.getOrder(),g=l.getGrowFactor(),s=l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),c=l.getMinWidth(),d=l.getMaxWidth();if(o){a.setStyle(r,l,"order",o);}if(g!=undefined){a.setStyle(r,l,"flex-grow",g);}if(q.support.newFlexBoxLayout||q.support.ie10FlexBoxLayout){if(s!==1){a.setStyle(r,l,"flex-shrink",s);}if(b!=undefined){a.setStyle(r,l,"flex-basis",b);}}if(m!=undefined){a.setStyle(r,l,"min-height",m);}if(M!=undefined){a.setStyle(r,l,"max-height",M);}if(c!=undefined){a.setStyle(r,l,"min-width",c);}if(d!=undefined){a.setStyle(r,l,"max-width",d);}};
a.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=v.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();}if(q.support.flexBoxPrefixed){if(sap.ui.Device.browser.webkit){this.sVendorPrefix="-webkit-";}else if(sap.ui.Device.browser.mozilla){this.sVendorPrefix="-moz-";}else if(sap.ui.Device.browser.internet_explorer){this.sVendorPrefix="-ms-";}}else{this.sVendorPrefix="";}if(q.support.newFlexBoxLayout||["min-height","max-height","min-width","max-width"].indexOf(p)!==-1){a.writeStyle(r,l,p,v);}else if(q.support.flexBoxLayout||q.support.ie10FlexBoxLayout){a.setOldSpecStyle(r,l,p,v);}};
a.setOldSpecStyle=function(r,l,p,v){var s="";if(this.sVendorPrefix=="-ms-"){s="specie10";}else{s="spec0907";}if(F[s][p]!==null&&F[s][p]!=="<idem>"){var L=null;if(typeof(F[s][p])==="object"){if(F[s][p]["<number>"]){L={};for(var k in F[s][p]["<number>"]){if(F[s][p]["<number>"][k]==="<number>"){L[k]=v;}else{L[k]=F[s][p]["<number>"][k];}}}else{L=F[s][p][v];}}else{L=F[s][p][v];}if(L!==null&&L!=="<idem>"){if(typeof(L)==="object"){for(var b in L){a.writeStyle(r,l,b,L[b]);}}}}};
a.writeStyle=function(r,l,p,v){var P="";var V="";if(p!=="display"){P=this.sVendorPrefix;}else{V=this.sVendorPrefix;}if(sap.ui.Device.browser.internet_explorer&&(p==="flex-basis"||p==="flex-preferred-size")){P="";if(l.getParent()){if(l.getParent().getParent().getDirection().indexOf("Row")>-1){p="width";}else{p="height";}}}if(r){r.addStyle(P+p,V+v);}else{l.$().css(P+p,V+v);}};
return a;},true);
sap.ui.predefine('sap/m/FlexItemData',['jquery.sap.global','./FlexBoxStylingHelper','./library','sap/ui/core/LayoutData'],function(q,F,l,L){"use strict";
var a=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:sap.m.FlexAlignSelf.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},styleClass:{type:"string",group:"Misc",defaultValue:''},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent}}}});
a.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
a.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
a.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
a.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
a.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
a.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
a.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
a.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
a.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
a.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
return a;},true);
sap.ui.predefine('sap/m/FlexibleColumnLayout',["jquery.sap.global","./library","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/Button"],function(q,l,R,C,B){"use strict";
var F=C.extend("sap.m.FlexibleColumnLayout",{metadata:{properties:{twoColumnLayoutOnDesktop:{type:"boolean",group:"Behavior",defaultValue:false},threeColumnLayoutType:{type:"sap.m.ThreeColumnLayoutType",group:"Behavior",defaultValue:sap.m.ThreeColumnLayoutType.MidColumnEmphasized},threeColumnLayoutTypeFixed:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{beginColumn:{type:"sap.ui.core.Control",multiple:false},midColumn:{type:"sap.ui.core.Control",multiple:false},endColumn:{type:"sap.ui.core.Control",multiple:false},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{fullScreenColumn:{type:"sap.ui.core.Control",multiple:false}},events:{layoutChange:{parameters:{beginColumnWidth:{type:"int"},midColumnWidth:{type:"int"},endColumnWidth:{type:"int"}}}}}});
F.prototype.init=function(){this._initButtons();this._oRm=sap.ui.getCore().createRenderManager();this._iControlWidth=null;this._sLayout=null;};
F.prototype.onAfterRendering=function(){this._deregisterResizeHandler();this._registerResizeHandler();this._cacheDOMElements();this._iControlWidth=this.$().width();this._adjustLayout(null,true);};
F.prototype.exit=function(){this._deregisterResizeHandler();this._oRm.destroy();};
F.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
F.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);}};
F.prototype._initButtons=function(){var b=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapMFCLNavigationButton").addStyleClass("sapMFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",b,true);var m=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapMFCLNavigationButton").addStyleClass("sapMFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",m,true);var M=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapMFCLNavigationButton").addStyleClass("sapMFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",M,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapMFCLNavigationButton").addStyleClass("sapMFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};
F.prototype._cacheDOMElements=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};this._$columnContainers={begin:this.$("beginColumn-container"),mid:this.$("midColumn-container"),end:this.$("endColumn-container")};this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
F.prototype._flushColumnContent=function(c,o){if(this.getDomRef()){this._oRm.renderControl(o);this._oRm.flush(this._$columnContainers[c][0]);}};
F.prototype.setBeginColumn=function(c){if(this.getBeginColumn()===c){return this;}var r=this.setAggregation("beginColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("begin",c);this._adjustLayout(null,false);return r;};
F.prototype.setMidColumn=function(c){if(this.getMidColumn()===c){return this;}var r=this.setAggregation("midColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("mid",c);this._adjustLayout(null,false);return r;};
F.prototype.setEndColumn=function(c){if(this.getEndColumn()===c){return this;}var r=this.setAggregation("endColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("end",c);this._adjustLayout(null,false);return r;};
F.prototype.setFullScreenColumn=function(i){if(this.getFullScreenColumn()===i){return this;}var r=this.setAssociation("fullScreenColumn",i,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};
F.prototype.setTwoColumnLayoutOnDesktop=function(v){var r=this.setProperty("twoColumnLayoutOnDesktop",v,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};
F.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(c){return this._getColumnSize(c)>0;},this).length;};
F.prototype._resizeColumns=function(){var p,n,t,a,N=false,c=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),A;if(typeof this._$columns==="undefined"){return;}t=(this._getVisibleColumnsCount()-1)*F.COLUMN_MARGIN;a=this._iControlWidth-t;c.forEach(function(s){p=this._getColumnSize(s);this._$columns[s].toggleClass("sapMFCLColumnMargin",N&&p>0);this._$columns[s].toggleClass("sapMFCLColumnActive",p>0);this._$columns[s].removeClass("sapMFCLColumnOnlyActive");this._$columns[s].removeClass("sapMFCLColumnLastActive");this._$columns[s].removeClass("sapMFCLColumnFirstActive");if([100,0].indexOf(p)!==-1){n=p+"%";}else{n=Math.round(a*(p/100))+"px";}this._$columns[s].width(n);if(p>0){N=true;}},this);A=c.filter(function(s){return this._getColumnSize(s)>0;},this);if(r){c.reverse();}if(A.length===1){this._$columns[A[0]].addClass("sapMFCLColumnOnlyActive");}if(A.length>1){this._$columns[A[0]].addClass("sapMFCLColumnFirstActive");this._$columns[A[A.length-1]].addClass("sapMFCLColumnLastActive");}};
F.prototype._getColumnSize=function(c){var s=this._sLayout.split("/"),m={begin:0,mid:1,end:2},S=s[m[c]];return S;};
F.prototype._onResize=function(e){var n=e.size.width;if(n===0||n===this._iControlWidth){return;}this._iControlWidth=e.size.width;if(!this.getFullScreenColumn()){this._adjustLayout(null,true);}};
F.prototype._adjustLayout=function(s,r){var n=this._sLayout,b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,f=this.getFullScreenColumn(),M=this._getMaxColumns(),t=this.getThreeColumnLayoutType()===l.ThreeColumnLayoutType.EndColumnEmphasized?"25/25/50":"25/50/25",p,d,c;if(f){if(this.getBeginColumn()&&this.getBeginColumn().getId()===f){n="100/0/0";}else if(this.getMidColumn()&&this.getMidColumn().getId()===f){n="0/100/0";}else if(this.getEndColumn()&&this.getEndColumn().getId()===f){n="0/0/100";}else{}}else{if(M===3){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{if(this.getThreeColumnLayoutTypeFixed()){p=[t,"33/67/0","67/33/0"];}else{p=["25/25/50","25/50/25","33/67/0","67/33/0"];}d=t;}}else if(M===2){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{p=["0/67/33","33/67/0","67/33/0"];d="0/67/33";}}else{if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["0/100/0","100/0/0"];d="0/100/0";}else{p=["0/0/100","0/100/0","100/0/0"];d="0/0/100";}}if(s){c=p.indexOf(n);if(s==="left"&&c>0){n=p[c-1];}else if(s==="right"&&c<p.length-1){n=p[c+1];}}else{if(!r||p.indexOf(n)===-1){n=d;}}}if(this._sLayout===n){this._resizeColumns();this._hideShowArrows();return;}this._sLayout=n;this._resizeColumns();this._hideShowArrows();if(!f){this.fireLayoutChange({beginColumnWidth:this._getColumnSize("begin"),midColumnWidth:this._getColumnSize("mid"),endColumnWidth:this._getColumnSize("end")});}};
F.prototype._hideShowArrows=function(){var b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,M=this._getMaxColumns(),n=[];if(typeof this._$columns==="undefined"){return;}if(M===3){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["beginBack"];}}else{if(this._sLayout==="25/50/25"){if(this.getThreeColumnLayoutTypeFixed()){n=["midForward"];}else{n=["midForward","midBack"];}}else if(this._sLayout==="25/25/50"){n=["endForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}else if(M===2){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["midBack"];}}else{if(this._sLayout==="0/67/33"){n=["midForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};
F.prototype._toggleButton=function(b,s){this._$columnButtons[b].toggle(s);};
F.prototype._getMaxColumns=function(){if(this._iControlWidth>=F.DESKTOP_BREAKPOINT){if(this.getTwoColumnLayoutOnDesktop()){return 2;}return 3;}if(this._iControlWidth>=F.TABLET_BREAKPOINT&&this._iControlWidth<F.DESKTOP_BREAKPOINT){return 2;}return 1;};
F.COLUMN_MARGIN=8;F.DESKTOP_BREAKPOINT=1280;F.TABLET_BREAKPOINT=960;return F;},false);
sap.ui.predefine('sap/m/FlexibleColumnLayoutRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFCL");r.writeClasses();r.write(">");this.renderBeginColumn(r,c);this.renderMidColumn(r,c);this.renderEndColumn(r,c);r.write("</div>");};
F.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn");r.addClass("sapMFCLColumn").addClass("sapMFCLColumnBegin").addClass("sapMFCLColumnActive");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn-container");r.addClass("sapMFCLContainer");r.writeClasses();r.write(">");if(c.getBeginColumn()){r.renderControl(c.getBeginColumn());}r.write("</div>");r.renderControl(b);r.write("</div>");};
F.renderMidColumn=function(r,c){var m=c.getAggregation("_midColumnForwardArrow"),M=c.getAggregation("_midColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn");r.addClass("sapMFCLColumn").addClass("sapMFCLColumnMid");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn-container");r.addClass("sapMFCLContainer");r.writeClasses();r.write(">");if(c.getMidColumn()){r.renderControl(c.getMidColumn());}r.write("</div>");r.renderControl(m);r.renderControl(M);r.write("</div>");};
F.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn");r.addClass("sapMFCLColumn").addClass("sapMFCLColumnEnd");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn-container");r.addClass("sapMFCLContainer");r.writeClasses();r.write(">");if(c.getEndColumn()){r.renderControl(c.getEndColumn());}r.write("</div>");r.renderControl(e);r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FormattedText',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var F=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}}});
var _={};_.ATTRIBS={'style':1,'class':1,'a::href':1,'a::target':1};_.ELEMENTS={'a':{cssClass:'sapMLink'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1};
F.prototype.init=function(){};
function s(t,a){var w;var b,v,c=t==="a";var d=_.ELEMENTS[t].cssClass||"";for(var i=0;i<a.length;i+=2){b=a[i];v=a[i+1];if(!_.ATTRIBS[b]&&!_.ATTRIBS[t+"::"+b]){w='FormattedText: <'+t+'> with attribute ['+b+'="'+v+'"] is not allowed';q.sap.log.warning(w,this);a[i+1]=null;continue;}if(b=="href"){if(!q.sap.validateUrl(v)){q.sap.log.warning("FormattedText: incorrect href attribute:"+v,this);a[i+1]="#";c=false;}}if(b=="target"){c=false;}if(d&&b.toLowerCase()=="class"){a[i+1]=d+" "+v;d="";}}if(c){a.push("target");a.push("_blank");}if(d){a.push("class");a.push(d);}return a;}
function p(t,a){if(_.ELEMENTS[t]){return s(t,a);}else{var w='<'+t+'> is not allowed';q.sap.log.warning(w,this);}}
function o(e){var n=window.open();n.opener=null;n.location=e.currentTarget.href;e.preventDefault();}
F.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
F.prototype.setHtmlText=function(t){var S="";function u(U){if(q.sap.validateUrl(U)){return U;}}S=q.sap._sanitizeHTML(t,{tagPolicy:p,uriRewriter:u});this.setProperty("htmlText",S);};
return F;},true);
sap.ui.predefine('sap/m/FormattedTextRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var h=c.getHtmlText();r.write("<div");r.writeControlData(c);r.addClass("sapMFT");r.writeClasses();if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.addStyle("width",c.getWidth()||null);r.addStyle("height",c.getHeight()||null);r.writeStyles();r.write(">");r.write(h);r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/GenericTile',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool'],function(q,l,C,T,H,I){"use strict";
var G=C.extend("sap.m.GenericTile",{metadata:{library:"sap.m",properties:{"mode":{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:l.GenericTileMode.ContentMode},"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:l.FrameType.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:sap.m.LoadState.Loaded},"imageDescription":{type:"string",group:"Misc",defaultValue:null}},aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
G.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._rb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._rb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.37rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.addStyleClass("sapMGenericTileLoading");this._oBusy.setBusyIndicatorDelay(0);};
G.prototype.onBeforeRendering=function(){var s=this.getSubheader()?true:false;if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()==sap.m.LoadState.Disabled);}this._generateFailedText();this.$().unbind("mouseenter",this._updateAriaAndTitle);};
G.prototype.onAfterRendering=function(){this._checkFooter(this.getState());if(this.getState()===sap.m.LoadState.Disabled){this._oBusy.$().bind("tap",q.proxy(this._handleOverlayClick,this));}else{this._oBusy.$().unbind("tap",this._handleOverlayClick);}this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));};
G.prototype.exit=function(){this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();};
G.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(sap.ui.Device.browser.internet_explorer&&this.getState()!==sap.m.LoadState.Disabled){this.$().focus();}};
G.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
G.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(sap.ui.Device.browser.internet_explorer&&this.getState()!==sap.m.LoadState.Disabled){this.$().focus();}};
G.prototype.ontap=function(e){if(this.getState()!==sap.m.LoadState.Disabled){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();e.preventDefault();}};
G.prototype.onkeydown=function(e){if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==sap.m.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}e.preventDefault();}};
G.prototype.onkeyup=function(e){if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==sap.m.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}this.firePress();e.preventDefault();}};
G.prototype.getHeader=function(){return this._oTitle.getText();};
G.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};
G.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-icon-image",src:u},sap.m.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
G.prototype.setState=function(s){if(this.getState()!=s){this._checkFooter(s);return this.setProperty("state",s);}else{return this;}};
G.prototype._applyHeaderMode=function(s){if(/.*[\u0900-\u097F]+.*/.test(this._oTitle.getText())){this._oTitle.setMaxLines(2);return;}if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}};
G.prototype._applyContentMode=function(s){if(/.*[\u0900-\u097F]+.*/.test(this._oTitle.getText())){this._oTitle.setMaxLines(1);return;}if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}};
G.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
G.prototype._getContentAriaAndTooltipText=function(){var t="";var b=true;var a=this.getTileContent();for(var i=0;i<a.length;i++){if(q.isFunction(a[i]._getAriaAndTooltipText)){t+=(b?"":"\n")+a[i]._getAriaAndTooltipText();}else if(a[i].getTooltip_AsString()){t+=(b?"":"\n")+a[i].getTooltip_AsString();}b=false;}return t;};
G.prototype._getAriaAndTooltipText=function(){var t;switch(this.getState()){case sap.m.LoadState.Disabled:return"";case sap.m.LoadState.Loading:return this._sLoading;case sap.m.LoadState.Failed:return this._oFailedText.getText();default:t=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());if(q.trim(t).length===0){return"";}else{return t;}}};
G.prototype._getAriaText=function(){var a=this.getTooltip_Text();if(!a||this._isTooltipSuppressed()){a=this._getAriaAndTooltipText();}return a;};
G.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(!t){t=this._getAriaText();}else if(this._isTooltipSuppressed()===true){t=null;}return t;};
G.prototype._checkFooter=function(s){var f=this.$().find(".sapMTileCntFtrTxt");if(s==sap.m.LoadState.Failed&&f.is(":visible")){f.hide();}else if(f.is(":hidden")){f.show();}};
G.prototype._generateFailedText=function(){var c=this.getFailedText();var f=c?c:this._sFailedToLoad;this._oFailedText.setText(f);this._oFailedText.setTooltip(f);};
G.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};
G.prototype._updateAriaAndTitle=function(){var a=this._getAriaAndTooltipText();var t=this._getTooltipText();var A=this._getAriaText();var $=this.$();if($.attr("title")!==a){$.attr("aria-label",A).attr("title",t);}$.find('*').removeAttr("aria-label").removeAttr("title");};
return G;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',[],function(){"use strict";var G={};
G.render=function(r,c){var t=c._getTooltipText();var a=c._getAriaText();var h=c.getHeaderImage();var H=c.hasListeners("press");r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapMGT");r.addClass(c.getFrameType());if(H){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.writeAttributeEscaped("aria-label",a);if(c.getState()!=sap.m.LoadState.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}if(c.getBackgroundImage()){r.write(" style='background-image:url(");r.writeEscaped(c.getBackgroundImage());r.write(");'");r.addClass("sapMGTBackgroundImage");}if(c.getMode()===sap.m.GenericTileMode.HeaderMode){r.addClass("sapMGTHeaderMode");}r.writeClasses();r.write(">");if(c.getState()!==sap.m.LoadState.Loaded){this._renderStateOverlay(r,c,t);}else{this._renderHoverOverlay(r,c);}this._renderFocusDiv(r,c);r.write("<div");r.addClass("sapMGTHdrContent");r.addClass(c.getFrameType());if(t){r.writeAttributeEscaped("title",t);}r.writeClasses();r.write(">");if(h){r.renderControl(c._oImage);}this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</div>");r.write("<div");r.addClass("sapMGTContent");r.writeClasses();r.writeAttribute("id",c.getId()+"-content");r.write(">");var T=c.getTileContent();var l=T.length;for(var i=0;i<l;i++){if(c.getMode()===sap.m.GenericTileMode.HeaderMode){T[i].removeAllAggregation("content",true);}r.renderControl(T[i]);}r.write("</div>");r.write("</div>");};
G._renderFocusDiv=function(r,c){r.write("<div");r.addClass("sapMGTFocusDiv");r.writeClasses();r.writeAttribute("id",c.getId()+"-focus");r.write(">");r.write("</div>");};
G._renderStateOverlay=function(r,c,t){var s=c.getState();r.write("<div");r.addClass("sapMGTOverlay");r.writeClasses();r.writeAttribute("id",c.getId()+"-overlay");if(t){r.writeAttributeEscaped("title",t);}r.write(">");switch(s){case sap.m.LoadState.Loading:c._oBusy.setBusy(s==sap.m.LoadState.Loading);r.renderControl(c._oBusy);break;case sap.m.LoadState.Failed:r.write("<div");r.writeAttribute("id",c.getId()+"-failed-ftr");r.addClass("sapMGenericTileFtrFld");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-failed-icon");r.addClass("sapMGenericTileFtrFldIcn");r.writeClasses();r.write(">");r.renderControl(c._oWarningIcon);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-failed-text");r.addClass("sapMGenericTileFtrFldTxt");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_failedMessageText"));r.write("</div>");r.write("</div>");break;default:}r.write("</div>");};
G._renderHoverOverlay=function(r,c){r.write("<div");if(c.getBackgroundImage()){r.addClass("sapMGTWithImageHoverOverlay");}else{r.addClass("sapMGTWithoutImageHoverOverlay");}r.writeClasses();r.writeAttribute("id",c.getId()+"-hover-overlay");r.write(">");r.write("</div>");};
G._renderHeader=function(r,c){r.write("<div");r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.renderControl(c._oTitle);r.write("</div>");};
G._renderSubheader=function(r,c){r.write("<div");r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c.getSubheader());r.write("</div>");};
return G;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var G=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});
G.prototype.getMode=function(){return sap.m.ListMode.None;};
G.prototype.shouldClearLastValue=function(){return true;};
G.prototype.getTable=function(){var p=this.getParent();if(p instanceof sap.m.Table){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
G.prototype.onBeforeRendering=function(){var p=this.getParent();if(p&&sap.m.Table&&p instanceof sap.m.Table){p.getColumns().forEach(function(c){c.clearLastValue();});}};
return G;},true);
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var G=R.extend(L);
G.openItemTag=function(r,l){r.write(l.getTable()?"<tr":"<li");};
G.closeItemTag=function(r,l){r.write(l.getTable()?"</tr>":"</li>");};
G.renderType=function(r,l){var t=l.getTable();t&&r.write('<td role="gridcell" class="sapMListTblNavCol">');L.renderType.apply(this,arguments);t&&r.write('</td>');};
G.handleNoFlex=function(r,l){};
G.renderCounter=function(r,l){};
G.getAriaRole=function(l){return l.getTable()?"row":"option";};
G.getAriaDescribedBy=function(l){var d=this.getAriaAnnouncement("group_header"),b=L.getAriaDescribedBy.call(this,l)||"";return d+" "+b;};
G.renderLIAttributes=function(r,l){r.addClass("sapMGHLI");if(l.getUpperCase()){r.addClass("sapMGHLIUpperCase");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.write('<td class="sapMGHLICell" role="gridcell"');r.writeAttribute("colspan",t.getColSpan());r.write(">");}L.renderLIContentWrapper.apply(this,arguments);if(t){r.write("</td>");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.write("<label class='sapMGHLITitle'");if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());var c=l.getCount();if(c){r.writeEscaped(" ("+c+")");}r.write("</label>");};
G.addLegacyOutlineClass=function(r,l){if(!l.getTable()){L.addLegacyOutlineClass.apply(this,arguments);}};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/format/NumberFormat'],function(q,B,N){"use strict";
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.write("<ul");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("role","presentation");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</ul>");},
onAfterRendering:function(){if(this._oControl.getGrowingScrollToLoad()){var s=sap.m.getScrollDelegate(this._oControl);if(s){this._oScrollDelegate=s;s.setGrowingList(this._oControl,this.requestNewPage.bind(this));}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}this._updateTriggerDelayed(false);},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;},
shouldReset:function(c){var C=sap.ui.model.ChangeReason;return c==C.Sort||c==C.Filter||c==C.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
requestNewPage:function(e){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:sap.m.ListType.Active,content:new sap.ui.core.HTML({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<h1 class="sapMSLITitle" id="'+t+'Text">'+q.sap.encodeHTML(T)+'</h1>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(e){this.requestNewPage();e.preventDefault();},onsapspace:function(e){this.requestNewPage(e);e.preventDefault();},onAfterRendering:function(e){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-live":"polite"});}},this);this._oTrigger.getList=function(){};return this._oTrigger;},
_getListItemInfo:function(){return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath:"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.$("triggerList").outerHeight();},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,b,s){var o=b.binding;var i=this.createListItem(c,b);if(o.isGrouped()){var I=this._oControl.getItems(true),l=I[I.length-1],m=b.model,g=o.getGroup(i.getBindingContext(m));if(!l||g.key!==o.getGroup(l.getBindingContext(m)).key){var a=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;a=this._oControl.addItemGroup(g,a,s);if(s){this._aChunk.push(a);}}}this._oControl.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory("",c);return i.setBindingContext(c,b.model);},
updateItemsBindingContext:function(C,m){if(!C.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(C[c++],m);}}},
applyChunk:function(I,d){var l=this._aChunk.length;if(!l){return;}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<l;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},
rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){this.applyChunk(false);}},
insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var C=this._oControl,b=C.getBinding("items"),o=C.getBindingInfo("items"),I=C.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=C.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var a=b.getContexts(0,this._iLimit)||[];if(a.dataRequested){this._bDataRequested=true;if(a.diff&&!a.diff.length){return;}}this._oContainerDomRef=C.getItemsContainerDomRef();var d=a.diff,f=false,v;if(!a.length){I.length&&this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(a,o);}else if(!d||!I.length&&d.length){this.rebuildListItems(a,o,true);}else if(b.isGrouped()||C.checkGrowingFromScratch()){if(this._sGroupingPath&&this._sGroupingPath!=this._getGroupingPath(b)){f=true;}else{for(var i=0;i<d.length;i++){var D=d[i],e=a[D.index];if(D.type=="delete"){f=true;break;}else if(D.index!=this._iRenderedDataItems){f=true;break;}else{this.addListItem(e,o,true);v=true;}}}}else{if(this._sGroupingPath){C.removeGroupHeaders(true);}v=-1;var l=-1;for(var i=0;i<d.length;i++){var D=d[i],g=D.index,e=a[g];if(D.type=="delete"){if(v!=-1){this.applyChunk(v);l=-1;v=-1;}this.deleteListItem(g);}else{if(v==-1){v=g;}else if(l>-1&&g!=l+1){this.applyChunk(v);v=g;}this.insertListItem(e,o,g);l=g;}}}if(f){this.rebuildListItems(a,o,true);}else if(this._oContainerDomRef&&d&&d.length){this.updateItemsBindingContext(a,o.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(l){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&q.sap.clearDelayedCall(this._iTriggerTimer);this._iTriggerTimer=q.sap.delayedCall(0,this,"_updateTrigger",[l]);}else{this._updateTrigger(l);}},
_updateTrigger:function(l){var t=this._oTrigger,c=this._oControl;if(!t||!c){return;}var b=c.getBinding("items");if(!b){return;}t.setBusy(l);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",l);if(l){t.setActive(false);c.$("triggerList").css("display","");}else{var i=b.getLength()||0,I=c.getItems(true).length,L=b.isLengthFinal(),h=c.getGrowingScrollToLoad();if(!I||!this._iLimit||(L&&this._iLimit>=i)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");if(document.activeElement===t.getDomRef()){c.$().focus();}}else{if(L){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}}}
});
return G;},true);
sap.ui.predefine('sap/m/GrowingList',['jquery.sap.global','./List','./library'],function(q,L,l){"use strict";
var G=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
G.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
G.prototype.init=function(){sap.m.ListBase.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
G.prototype.setGrowing=function(){return sap.m.ListBase.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(G.prototype,sap.m.ListBase.prototype));return G;},true);
sap.ui.predefine('sap/m/GrowingListRenderer',['jquery.sap.global','./ListRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var G=R.extend(L);
G.render=function(r,c){if(c._isIncompatible()){q.sap.log.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['jquery.sap.global','./FlexBox','./library'],function(q,F,l){"use strict";
var H=F.extend("sap.m.HBox",{metadata:{library:"sap.m"}});
return H;},true);
sap.ui.predefine('sap/m/HBoxRenderer',['jquery.sap.global','./FlexBoxRenderer'],function(q,F){"use strict";var H={};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/IconTabBar',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var I=C.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}}}});
I.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var i=this._getIconTabHeader();c.setAggregation("_header",i.clone(),true);return c;};
I.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.$().length){this._toggleExpandCollapse(e);}return this;};
I.prototype.setExpandable=function(e){this.setProperty("expandable",e,true);return this;};
I.prototype._rerenderContent=function(c){var $=this.$("content");if(c&&($.length>0)){var r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0]);r.destroy();}};
I.prototype._toggleExpandCollapse=function(e){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(e===undefined){e=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",e);s.$().attr({'aria-expanded':e});if(e){s.$().attr({'aria-selected':e});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(e){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,e));this.$("containerContent").toggleClass("sapMITBContentClosed",!e);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,e));}if(!e||s){this.setProperty("expanded",e,true);}this.fireExpand({expand:e,collapse:!e});return this;};
I.prototype.onTransitionEnded=function(e){var $=this.$("content"),a=this.$("containerContent"),b=this.$("contentArrow");if(this._iAnimationCounter===1){a.toggleClass("sapMITBContentClosed",!e);if(e){b.show();$.css("display","block");}else{b.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
I.prototype._getIconTabHeader=function(){var c=this.getAggregation("_header");if(!c){c=new sap.m.IconTabHeader(this.getId()+"--header",{});this.setAggregation("_header",c,true);}return c;};
I.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
I.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
I.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
I.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
I.prototype.setSelectedItem=function(i,a){return this._getIconTabHeader().setSelectedItem(i,a);};
I.prototype._callMethodInManagedObject=function(f,a){var A=Array.prototype.slice.call(arguments),h;if(a==="items"){h=this._getIconTabHeader();return h[f].apply(h,A.slice(1));}else{return sap.ui.base.ManagedObject.prototype[f].apply(this,A.slice(1));}};
I.prototype.bindAggregation=function(){var a=Array.prototype.slice.call(arguments);this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(a));return this;};
I.prototype.validateAggregation=function(a,o,m){return this._callMethodInManagedObject("validateAggregation",a,o,m);};
I.prototype.setAggregation=function(a,o,s){this._callMethodInManagedObject("setAggregation",a,o,s);return this;};
I.prototype.getAggregation=function(a,d){return this._callMethodInManagedObject("getAggregation",a,d);};
I.prototype.indexOfAggregation=function(a,o){return this._callMethodInManagedObject("indexOfAggregation",a,o);};
I.prototype.insertAggregation=function(a,o,i,s){this._callMethodInManagedObject("insertAggregation",a,o,i,s);return this;};
I.prototype.addAggregation=function(a,o,s){this._callMethodInManagedObject("addAggregation",a,o,s);return this;};
I.prototype.removeAggregation=function(a,o,s){return this._callMethodInManagedObject("removeAggregation",a,o,s);};
I.prototype.removeAllAggregation=function(a,s){return this._callMethodInManagedObject("removeAllAggregation",a,s);};
I.prototype.destroyAggregation=function(a,s){this._callMethodInManagedObject("destroyAggregation",a,s);return this;};
I.prototype.getBinding=function(a){return this._callMethodInManagedObject("getBinding",a);};
I.prototype.getBindingInfo=function(a){return this._callMethodInManagedObject("getBindingInfo",a);};
I.prototype.getBindingPath=function(a){return this._callMethodInManagedObject("getBindingPath",a);};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var a={};a._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
a.render=function(r,c){var C=c.getContent(),h=c._getIconTabHeader();r.write("<div ");r.writeControlData(c);r.addClass("sapMITB");if(c.getStretchContentHeight()){r.addClass("sapMITBStretch");}if(!c.getApplyContentPadding()){r.addClass("sapMITBNoContentPadding");}r.addClass("sapMITBBackgroundDesign"+c.getBackgroundDesign());r.writeClasses();r.write(">");if(!c._bHideHeader){r.renderControl(h);}r.write("<div id='"+c.getId()+"-containerContent' ");r.addClass("sapMITBContainerContent");if(!c.getExpanded()){r.addClass("sapMITBContentClosed");}r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-content' class='sapMITBContent' role='tabpanel' ");if(!c.getExpanded()){r.write("style='display: none'");}r.write(">");if(c.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var o=h.oSelectedItem.getContent();if(o.length>0){C=o;}}if(C.length>0){for(var i=0;i<C.length;i++){r.renderControl(C[i]);}}}r.write("</div>");r.write("</div>");r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabFilter',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var a=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:sap.ui.core.IconColor.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:sap.m.IconTabFilterDesign.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
a.prototype._getImageControl=function(c,p,C){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,c,C);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
a.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};
a.prototype.invalidate=function(){var i=this.getParent(),o;if(i instanceof sap.m.IconTabHeader&&i.getParent()instanceof sap.m.IconTabBar){o=i.getParent();if(o.getParent()instanceof sap.m.ObjectHeader){var O=o.getParent();O.invalidate();}else{o.invalidate();}}};
a.prototype.setProperty=function(p,v,s){switch(p){case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}sap.ui.core.Control.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:sap.ui.core.Control.prototype.setProperty.apply(this,arguments);break;}return this;};
a.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};
return a;},true);
sap.ui.predefine('sap/m/IconTabHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement'],function(q,l,C,E,I,a,S){"use strict";
var b=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});
E.apply(b.prototype,[true]);b.SCROLL_STEP=264;
b.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};
b.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var c=this.getItems();var d=-1;var o;for(var i=0;i<c.length;i++){o=c[i];if(o instanceof sap.m.IconTabFilter==false){continue;}d++;if(this.oSelectedItem==o){break;}}this._oItemNavigation.setFocusedIndex(d);};
b.prototype._onItemNavigationAfterFocus=function(e){var h=this.getDomRef("head"),i=e.getParameter("index"),$=e.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=h.scrollLeft;this._checkOverflow();if(i!==null&&i!==undefined){this._scrollIntoView(this.getTabFilters()[i],0);}};
b.prototype.getTabFilters=function(){var i=this.getItems();var t=[];i.forEach(function(o){if(o instanceof sap.m.IconTabFilter){t.push(o);}});return t;};
b.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}};
b.prototype.onBeforeRendering=function(){var c=this.getItems(),s=this.getSelectedKey(),i=0;if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}var p=this.getParent();var d=p instanceof sap.m.IconTabBar;if(c.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<c.length;i++){if(!(c[i]instanceof sap.m.IconTabSeparator)&&c[i]._getNonEmptyKey()===s){this.oSelectedItem=c[i];break;}}}if(!this.oSelectedItem&&(!d||d&&p.getExpanded())){for(i=0;i<c.length;i++){if(!(c[i]instanceof sap.m.IconTabSeparator)&&c[i].getVisible()){this.oSelectedItem=c[i];break;}}}}if(this.oSelectedItem&&!this.oSelectedItem.getVisible()&&(!d||d&&p.getExpanded())){for(i=0;i<c.length;i++){if(!(c[i]instanceof sap.m.IconTabSeparator)&&c[i].getVisible()){this.oSelectedItem=c[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
b.prototype.setSelectedKey=function(k){var c=this.getTabFilters(),i=0;if(c.length>0){k=k||c[0]._getNonEmptyKey();}if(this.$().length){for(;i<c.length;i++){if(c[i]._getNonEmptyKey()===k){this.setSelectedItem(c[i],true);break;}}}this.setProperty("selectedKey",k,true);return this;};
b.prototype.setSelectedItem=function(i,A){if(!i||!i.getEnabled()){return this;}var p=this.getParent();var c=p instanceof sap.m.IconTabBar;var d=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){d=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(c&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").removeAttr('aria-selected').removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&c&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(c){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!c){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(c&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var s=this.oSelectedItem.getContent();if(s.length>0){p._rerenderContent(s);}else{if(!d){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}var e=this.oSelectedItem._getNonEmptyKey();this.oSelectedItem=i;this.setProperty("selectedKey",e,true);if(c){p.setProperty("selectedKey",e,true);}if(!A){if(c){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:e,item:this.oSelectedItem,key:e});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:e,item:this.oSelectedItem,key:e});}}return this;};
b.prototype._getFirstVisibleItem=function(c){for(var i=0;i<c.length;i++){if(c[i].getVisible()){return c[i];}}return null;};
b.prototype.onAfterRendering=function(){var h=this.getDomRef("head");if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){if(!this._bDoThisOnlyOnce){q.sap.delayedCall(1000,this,"_scrollIntoView",[this.oSelectedItem,0]);this._bDoThisOnlyOnce=true;}else if(this._scrollAfterRendering){this._scrollIntoView(this.oSelectedItem,500);this._scrollAfterRendering=false;}}var c=this.getItems();var t=[];var s=-1;var d=this;c.forEach(function(o){if(o instanceof sap.m.IconTabFilter){var e=d.getFocusDomRef(o);q(e).attr("tabindex","-1");t.push(e);if(o===d.oSelectedItem){s=t.indexOf(o);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(h);this._oItemNavigation.setItemDomRefs(t);this._oItemNavigation.setSelectedIndex(s);this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&i&&p.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=sap.ui.core.ResizeHandler.register(p.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}};
b.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};
b.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.addAggregation("items",i);};
b.prototype.insertItem=function(i,c){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.insertAggregation("items",i,c);};
b.prototype.removeAllItems=function(){this._aTabKeys=[];this.removeAllAggregation("items");};
b.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(k),1);}return i;};
b.prototype.removeAggregation=function(A,o,s){var i=this.getTabFilters();var c=C.prototype.removeAggregation.apply(this,arguments);if(c&&c==this.oSelectedItem&&A=='items'){var d=q.inArray(c,i);i=this.getTabFilters();d=Math.max(0,Math.min(d,i.length-1));var e=i[d];if(e){this.setSelectedItem(e);}else{var f=this.getParent();if(f instanceof sap.m.IconTabBar&&f.getExpanded()){f.$("content").children().remove();}}}return c;};
b.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};
b.prototype._checkTextOnly=function(c){if(c.length>0){for(var i=0;i<c.length;i++){if(!(c[i]instanceof sap.m.IconTabSeparator)){if(c[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};
b.prototype._checkNoText=function(c){if(c.length>0){for(var i=0;i<c.length;i++){if(!(c[i]instanceof sap.m.IconTabSeparator)){if(c[i].getText().length>0){return false;}}}}return true;};
b.prototype._checkInLine=function(c){var o;if(c.length>0){for(var i=0;i<c.length;i++){o=c[i];if(!(o instanceof sap.m.IconTabSeparator)){if(o.getIcon()||o.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
b.prototype._checkScrolling=function(h){var $=this.$();var s=false;var d=this.getDomRef("scrollContainer");var c=this.getDomRef("head");if(c&&d){if(c.offsetWidth>d.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}return s;};
b.prototype._getScrollingArrow=function(n){var s=a.getIconURI("slim-arrow-"+n);var p={src:s,useIconTooltip:false};var c=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+c;var r="sapMITBArrowScrollRight"+c;var d=["sapMITBArrowScroll",L];var e=["sapMITBArrowScroll",r];if(this._bInLine){d.push('sapMITBArrowScrollLeftInLine');e.push('sapMITBArrowScrollRightInLine');}if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,d);}return this._oArrowLeft;}if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,e);}return this._oArrowRight;}};
b.prototype._checkOverflow=function(){var B=this.getDomRef("head");var $=this.$();if(this._checkScrolling(B)&&B){var s=false;var c=false;var d=this.getDomRef("scrollContainer");var e=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+d.offsetWidth)<e.offsetWidth){c=true;}if((c!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=c;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",c);$.toggleClass("sapMITBNoScrollForward",!c);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};
b.prototype._handleActivation=function(e){var t=e.target.id,c=e.srcControl,s;var $=q.sap.byId(t);if(q.inArray(this.$("content")[0],$.parents())>-1){}else{if(t){var i=this.getId();e.preventDefault();if(t==i+"-arrowScrollLeft"&&sap.ui.Device.system.desktop){var d=this._oScroller.getScrollLeft()-b.SCROLL_STEP;if(d<0){d=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[d,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(t==i+"-arrowScrollRight"&&sap.ui.Device.system.desktop){var d=this._oScroller.getScrollLeft()+b.SCROLL_STEP;var f=this.$("scrollContainer").width();var h=this.$("head").width();if(d>(h-f)){d=h-f;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[d,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if(c instanceof sap.ui.core.Icon||c instanceof sap.m.Image){s=e.srcControl.getId().replace(/-icon$/,"");c=sap.ui.getCore().byId(s);if(c.getMetadata().isInstanceOf("sap.m.IconTab")&&!(c instanceof sap.m.IconTabSeparator)){this.setSelectedItem(c);}}else if(c.getMetadata().isInstanceOf("sap.m.IconTab")&&!(c instanceof sap.m.IconTabSeparator)){this.setSelectedItem(c);}}}else{if(c.getMetadata().isInstanceOf("sap.m.IconTab")&&!(c instanceof sap.m.IconTabSeparator)){this.setSelectedItem(c);}}}};
b.prototype._scrollIntoView=function(i,d){var $=i.$(),s,n,c;if($.length>0){var e=this.$('head');var h=e.innerWidth()-e.width();var f=$.outerWidth(true);var g=$.position().left-h/2;s=this._oScroller.getScrollLeft();c=this.$("scrollContainer").width();n=0;if(g-s<0||g-s>c-f){if(g-s<0){n+=g;}else{n+=g+f-c;}this._scrollPreparation();this._iCurrentScrollLeft=n;q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,d]);q.sap.delayedCall(d,this,"_afterIscroll");}}return this;};
b.prototype._scroll=function(d,D){this._scrollPreparation();var o=this.getDomRef("head");var s=o.scrollLeft;var i=sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge;if(!i&&this._bRtl){d=-d;}var c=s+d;q(o).stop(true,true).animate({scrollLeft:c},D,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=c;};
b.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(sap.ui.Device.system.desktop){this._checkOverflow();}};
b.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};
b.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();};
b.prototype._fnResize=function(){this._checkOverflow();};
sap.m.IconTabHeader.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),d=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-d);};
sap.m.IconTabHeader.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
b.prototype.getFocusDomRef=function(f){var t=f||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};
b.prototype.applyFocusInfo=function(f){if(f.focusDomRef){q(f.focusDomRef).focus();}};
b.prototype.ontouchstart=function(e){var t=e.targetTouches[0];this._iActiveTouch=t.identifier;this._iTouchStartPageX=t.pageX;this._iTouchDragX=0;var $=q(e.target);if($.hasClass('sapMITBArrowScroll')){e.preventDefault();}if(sap.ui.Device.browser.internet_explorer){if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){e.preventDefault();}}};
b.prototype.ontouchmove=function(e){if(this._iActiveTouch===undefined){return;}var t=sap.m.touch.find(e.changedTouches,this._iActiveTouch);if(!t||t.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-t.pageX);this._iTouchStartPageX=t.pageX;};
b.prototype.ontouchend=function(e){if(this._iActiveTouch===undefined){return;}if(this._scrollable&&this._iTouchDragX>(sap.ui.Device.system.desktop?5:15)){return;}var M=0;var L=1;var c;if(e.which===c||e.which===M||e.which===L){this._handleActivation(e);}this._iActiveTouch=undefined;};
b.prototype.ontouchcancel=b.prototype.ontouchend;
b.prototype.onsapselect=function(e){this._handleActivation(e);};
return b;},true);
sap.ui.predefine('sap/m/IconTabHeaderRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var a={};a._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
a.render=function(r,c){if(!c.getVisible()){return;}var i=c.getItems(),t=c._checkTextOnly(i),n=c._checkNoText(i),b=c._checkInLine(i),R=sap.ui.getCore().getLibraryResourceBundle('sap.m');var o=c.getParent();var u=o&&o instanceof sap.m.IconTabBar&&o.getUpperCase();r.write("<div role='tablist' ");r.addClass("sapMITH");if(c._scrollable){r.addClass("sapMITBScrollable");if(c._bPreviousScrollForward){r.addClass("sapMITBScrollForward");}else{r.addClass("sapMITBNoScrollForward");}if(c._bPreviousScrollBack){r.addClass("sapMITBScrollBack");}else{r.addClass("sapMITBNoScrollBack");}}else{r.addClass("sapMITBNotScrollable");}if(u){r.addClass("sapMITBTextUpperCase");}r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c._getScrollingArrow("left"));r.write("<div id='"+c.getId()+"-scrollContainer' class='sapMITBScrollContainer'>");r.write("<div id='"+c.getId()+"-head'");r.addClass("sapMITBHead");if(t){r.addClass("sapMITBTextOnly");}if(n){r.addClass("sapMITBNoText");}if(b){r.addClass("sapMITBInLine");}r.writeClasses();r.write(">");q.each(i,function(d,e){if(!(e instanceof sap.m.IconTabSeparator)&&!e.getVisible()){return;}var T='';if(e instanceof sap.m.IconTabSeparator){if(e.getIcon()){T+='role="img" aria-label="'+R.getText("ICONTABBAR_NEXTSTEP")+'"';}else{T+='role="separator"';}}else{T+='role="tab" aria-controls="'+c.getParent().sId+'-content" ';if(e){var s=e.getIconColor();var f=s==='Positive'||s==='Critical'||s==='Negative';if(e.getText().length||e.getCount()!==""||e.getIcon()){T+='aria-labelledby="';var g=[];if(e.getText().length){g.push(e.getId()+'-text');}if(e.getCount()!==""){g.push(e.getId()+'-count');}if(e.getIcon()){g.push(e.getId()+'-icon');}if(f){g.push(e.getId()+'-iconColor');}T+=g.join(' ');T+='"';}}}r.write('<div '+T+' ');r.writeElementData(e);r.addClass("sapMITBItem");if(!(e instanceof sap.m.IconTabSeparator)&&!this.getCount()){r.addClass("sapMITBItemNoCount");}if(e instanceof sap.m.IconTabFilter){if(e.getDesign()===sap.m.IconTabFilterDesign.Vertical){r.addClass("sapMITBVertical");}else if(e.getDesign()===sap.m.IconTabFilterDesign.Horizontal){r.addClass("sapMITBHorizontal");}if(e.getShowAll()){r.addClass("sapMITBAll");}else{r.addClass("sapMITBFilter");r.addClass("sapMITBFilter"+e.getIconColor());}if(!e.getEnabled()){r.addClass("sapMITBDisabled");}var h=e.getTooltip_AsString();if(h){r.writeAttributeEscaped("title",h);}r.writeClasses();r.write(">");if(!b){r.write("<div id='"+e.getId()+"-tab' class='sapMITBTab'>");if(!e.getShowAll()||!e.getIcon()){if(f){r.write('<div id="'+e.getId()+'-iconColor" style="display: none;">'+R.getText('ICONTABBAR_ICONCOLOR_'+s.toUpperCase())+'</div>');}r.renderControl(e._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+e.getIconColor()],c,a._aAllIconColors));}if(!e.getShowAll()&&!e.getIcon()&&!t){r.write("<span class='sapMITBFilterNoIcon'> </span>");}if(e.getDesign()===sap.m.IconTabFilterDesign.Horizontal&&!e.getShowAll()){r.write("</div>");r.write("<div class='sapMITBHorizontalWrapper'>");}r.write("<span id='"+e.getId()+"-count' ");r.addClass("sapMITBCount");r.writeClasses();r.write(">");if((e.getCount()==="")&&(e.getDesign()===sap.m.IconTabFilterDesign.Horizontal)){r.write("&nbsp;");}else{r.writeEscaped(e.getCount());}r.write("</span>");if(e.getDesign()===sap.m.IconTabFilterDesign.Vertical){r.write("</div>");}}if(e.getText().length){r.write("<div id='"+e.getId()+"-text' ");r.addClass("sapMITBText");if(u){r.addClass("sapMITBTextUpperCase");}r.writeClasses();r.write(">");r.writeEscaped(e.getText());r.write("</div>");}if(!b){if(e.getDesign()===sap.m.IconTabFilterDesign.Horizontal){r.write("</div>");}}r.write("<div class='sapMITBContentArrow'></div>");}else{r.addClass("sapMITBSep");if(!e.getIcon()){r.addClass("sapMITBSepLine");}r.writeClasses();r.write(">");if(e.getIcon()){r.renderControl(e._getImageControl(['sapMITBSepIcon'],c));}}r.write("</div>");});r.write("</div>");r.write("</div>");r.renderControl(c._getScrollingArrow("right"));r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabSeparator',['jquery.sap.global','./library','sap/ui/core/Element'],function(q,l,E){"use strict";
var I=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
I.prototype._getImageControl=function(c,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,c);return this._oImageControl;};
I.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(sap.ui.core.Item.prototype.exit){sap.ui.core.Item.prototype.exit.call(this,e);}};
return I;},true);
sap.ui.predefine('sap/m/Image',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var I=C.extend("sap.m.Image",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:true},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"}},events:{tap:{},press:{},load:{},error:{}}}});
I._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
I.prototype.onload=function(e){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),D=d[0];if(this.getMode()===sap.m.ImageMode.Background){d.css("background-image","url("+this._oImage.src+")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){if((d.width()===D.naturalWidth)&&(d.height()===D.naturalHeight)){d.width(d.width()/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
I.prototype.onerror=function(e){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var D=this.$(),m=this.getMode(),s=(m===sap.m.ImageMode.Image)?D.attr("src"):this._oImage.src,d=I._currentDevicePixelRatio,c=this._isActiveState?this.getActiveSrc():this.getSrc();D.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){D.removeClass("sapMNoImg");this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(c,2));this._bVersion2Tried=true;},this),0);}}};
I.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;};
I.prototype.onAfterRendering=function(){var d=this.$(),D=d[0],m=this.getMode();if(m===sap.m.ImageMode.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));if(D&&D.complete&&!this._defaultEventTriggered){if(D.naturalWidth>0){this.onload({});}else{this.onerror({});}}}};
I.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}};
I.prototype.ontouchstart=function(e){if(e.srcControl.mEventRegistry["press"]||e.srcControl.mEventRegistry["tap"]){e.setMarked();}if(e.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
I.prototype.ontouchend=function(e){if(e.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
I.prototype.setSrc=function(s){if(s===this.getSrc()){return this;}this.setProperty("src",s,true);var d=this.getDomRef();if(d){this._updateDomSrc(this._getDensityAwareSrc());}return this;};
I.prototype.setActiveSrc=function(a){if(!a){a="";}this.setProperty("activeSrc",a,true);};
I.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);sap.ui.core.Control.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
I.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);sap.ui.core.Control.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
I.prototype.ontap=function(e){this.fireTap({});this.firePress({});};
I.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.firePress({});e.stopPropagation();}};
I.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===sap.m.ImageMode.Image){d.attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
I.prototype._preLoadImage=function(s){if(this.getMode()!==sap.m.ImageMode.Background){return;}var i=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();i=q(this._oImage);i.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;if(this._oImage.complete){i.trigger(this._oImage.naturalWidth>0?"load":"error");}};
I.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
I.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),D=this.getDensityAware(),d=D?I._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return s;}return this._generateSrcByDensity(s,d);};
I.prototype._getDensityAwareActiveSrc=function(){var a=this.getActiveSrc(),D=this.getDensityAware(),d=D?I._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return a;}return this._generateSrcByDensity(a,d);};
I.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),i=s.lastIndexOf("/"),n=s.substring(0,L),e=s.substring(L);if(L===-1||(i>L)){return s+"@"+d;}n=n+"@"+d;return n+e;};
I.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
I.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
return I;},true);
sap.ui.predefine('sap/m/ImageContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool'],function(q,l,C,I,a){"use strict";
var b=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{"src":{type:"sap.ui.core.URI",group:"Misc"},"description":{type:"String",group:"Misc"}},aggregations:{"_content":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
b.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:false},I);this.setAggregation("_content",i,true);}if(d){this.setTooltip(d.trim());}};
b.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();};
b.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
b.prototype.attachEvent=function(e,d,f,c){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,c);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
b.prototype.detachEvent=function(e,f,c){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,c);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return b;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={};
I.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['jquery.sap.global'],function(q){"use strict";var I={};
I.render=function(r,i){var m=i.getMode(),a=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press");r.write(m===sap.m.ImageMode.Image?"<img":"<span");r.writeControlData(i);if(m===sap.m.ImageMode.Image){r.writeAttributeEscaped("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());r.addStyle("background-size",q.sap.encodeHTML(i.getBackgroundSize()));r.addStyle("background-position",q.sap.encodeHTML(i.getBackgroundPosition()));r.addStyle("background-repeat",q.sap.encodeHTML(i.getBackgroundRepeat()));}r.addClass("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.addClass("sapMPointer");}if(i.getUseMap()||!i.getDecorative()){r.addClass("sapMImgFocusable");}r.writeClasses();var u=i.getUseMap();if(u){if(!(q.sap.startsWith(u,"#"))){u="#"+u;}r.writeAttributeEscaped("useMap",u);}if(i.getDecorative()&&!u&&!h){r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.write(" alt=''");}else{if(a||t){r.writeAttributeEscaped("alt",a||t);}}if(a||t){r.writeAttributeEscaped("aria-label",a||t);}if(t){r.writeAttributeEscaped("title",t);}if(h){r.writeAttribute("role","button");r.writeAttribute("tabIndex",0);}if(i.getWidth()&&i.getWidth()!=''){r.addStyle("width",i.getWidth());}if(i.getHeight()&&i.getHeight()!=''){r.addStyle("height",i.getHeight());}r.writeStyles();r.write(" />");};
return I;},true);
sap.ui.predefine('sap/m/Input',['jquery.sap.global','./Bar','./Dialog','./InputBase','./List','./Popover','./StandardListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','jquery.sap.strings'],function(q,B,D,I,L,P,S,T,a,b,l,c){"use strict";
var d=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:sap.m.InputType.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable"},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable"}},events:{liveChange:{parameters:{value:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}}}});
c.insertFontFaceStyle();
d._DEFAULTFILTER=function(v,i){return q.sap.startsWithIgnoreCase(i.getText(),v);};
d._DEFAULTFILTER_TABULAR=function(v,C){var e=C.getCells(),i=0;for(;i<e.length;i++){if(e[i].getText){return q.sap.startsWithIgnoreCase(e[i].getText(),v);}}return false;};
d._DEFAULTRESULT_TABULAR=function(C){var e=C.getCells(),i=0;for(;i<e.length;i++){if(e[i].getText){return e[i].getText();}}return"";};
d.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=d._DEFAULTFILTER;this._bUseDialog=sap.ui.Device.system.phone;this._bFullScreen=sap.ui.Device.system.phone;this._iSetCount=0;};
d.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oValueHelpIcon){this._oValueHelpIcon.destroy();this._oValueHelpIcon=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};
d.prototype._resizePopup=function(){var t=this;if(this._oList&&this._oSuggestionPopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(t._oSuggestionPopup&&t._oSuggestionPopup.isOpen()&&t._oSuggestionPopup.$().outerWidth()<t.$().outerWidth()){t._oSuggestionPopup.setContentWidth((t.$().outerWidth())+"px");}},0);}};
d.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.call(this);this._deregisterEvents();};
d.prototype.onAfterRendering=function(){var t=this;I.prototype.onAfterRendering.call(this);if(!this._bFullScreen){this._resizePopup();this._sPopupResizeHandler=sap.ui.core.ResizeHandler.register(this.getDomRef(),function(){t._resizePopup();});}if(this._bUseDialog){this.$().on("click",q.proxy(function(e){if(this.getShowSuggestion()&&this._oSuggestionPopup&&e.target.id!=this.getId()+"__vhi"){this._oSuggestionPopup.open();}},this));}};
d.prototype._getValueHelpIcon=function(){var t=this;if(!this._oValueHelpIcon){var u=c.getIconURI("value-help");this._oValueHelpIcon=c.createControlByURI({id:this.getId()+"__vhi",src:u,useIconTooltip:false,noTabStop:true});this._oValueHelpIcon.addStyleClass("sapMInputValHelpInner");this._oValueHelpIcon.attachPress(function(e){if(!t.getValueHelpOnly()){t.fireValueHelpRequest({fromSuggestions:false});}});}return this._oValueHelpIcon;};
d.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){this.fireValueHelpRequest({fromSuggestions:false});}};
d.prototype.ontap=function(e){I.prototype.ontap.call(this,e);this._fireValueHelpRequestForValueHelpOnly();};
d.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
d.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
d.prototype.setFilterFunction=function(f){if(f===null||f===undefined){this._fnFilter=d._DEFAULTFILTER;return this;}this._fnFilter=f;return this;};
d.prototype.setRowResultFunction=function(f){if(f===null||f===undefined){this._fnRowResultFilter=d._DEFAULTRESULT_TABULAR;return this;}this._fnRowResultFilter=f;return this;};
d.prototype.setShowValueHelp=function(s){this.setProperty("showValueHelp",s);if(s&&!d.prototype._sAriaValueHelpLabelId){d.prototype._sAriaValueHelpLabelId=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_VALUEHELP")}).toStatic().getId();}return this;};
d.prototype.setValueHelpOnly=function(v){this.setProperty("valueHelpOnly",v);if(v&&!d.prototype._sAriaInputDisabledLabelId){d.prototype._sAriaInputDisabledLabelId=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_DISABLED")}).toStatic().getId();}return this;};
d.prototype._doSelect=function(s,e){if(sap.ui.Device.support.touch){return;}var o=this._$input[0];if(o){var r=this._$input;o.focus();r.selectText(s?s:0,e?e:r.val().length);}return this;};
d.prototype._scrollToItem=function(i){var p=this._oSuggestionPopup,o=this._oList,s,e,f,t,g;if(!(p instanceof P)||!o){return;}s=p.getScrollDelegate();if(!s){return;}var h=o.getItems()[i],j=h&&h.getDomRef();if(!j){return;}e=p.getDomRef("cont").getBoundingClientRect();f=j.getBoundingClientRect();t=e.top-f.top;g=f.bottom-e.bottom;if(t>0){s.scrollTo(s._scrollX,Math.max(s._scrollY-t,0));}else if(g>0){s.scrollTo(s._scrollX,s._scrollY+g);}};
d.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==sap.m.ListType.Inactive);};
d.prototype._onsaparrowkey=function(e,s,i){if(!this.getEnabled()||!this.getEditable()){return;}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}if(s!=="up"&&s!=="down"){return;}e.preventDefault();e.stopPropagation();var f=false,o=this._oList,g=this.getSuggestionItems(),h=o.getItems(),j=this._iPopupListSelectedIndex,n,O=j;if(s==="up"&&j===0){return;}if(s=="down"&&j===h.length-1){return;}var k;if(i>1){if(s=="down"&&j+i>=h.length){s="up";i=1;h[j].setSelected(false);k=j;j=h.length-1;f=true;}else if(s=="up"&&j-i<0){s="down";i=1;h[j].setSelected(false);k=j;j=0;f=true;}}if(j===-1){j=0;if(this._isSuggestionItemSelectable(h[j])){O=j;f=true;}else{s="down";}}if(s==="down"){while(j<h.length-1&&(!f||!this._isSuggestionItemSelectable(h[j]))){h[j].setSelected(false);j=j+i;f=true;i=1;if(k===j){break;}}}else{while(j>0&&(!f||!h[j].getVisible()||!this._isSuggestionItemSelectable(h[j]))){h[j].setSelected(false);j=j-i;f=true;i=1;if(k===j){break;}}}if(!this._isSuggestionItemSelectable(h[j])){if(O>=0){h[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",h[O].getId());}return;}else{h[j].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",h[j].getId());}if(sap.ui.Device.system.desktop){this._scrollToItem(j);}if(sap.m.ColumnListItem&&h[j]instanceof sap.m.ColumnListItem){n=this._getInputValue(this._fnRowResultFilter(h[j]));}else{var m=(g[0]instanceof sap.ui.core.ListItem?true:false);if(m){n=this._getInputValue(h[j].getLabel());}else{n=this._getInputValue(h[j].getTitle());}}this._$input.val(n);this._sSelectedSuggViaKeyboard=n;this._doSelect();this._iPopupListSelectedIndex=j;};
d.prototype.onsapup=function(e){this._onsaparrowkey(e,"up",1);};
d.prototype.onsapdown=function(e){this._onsaparrowkey(e,"down",1);};
d.prototype.onsappageup=function(e){this._onsaparrowkey(e,"up",5);};
d.prototype.onsappagedown=function(e){this._onsaparrowkey(e,"down",5);};
d.prototype.onsaphome=function(e){if(this._oList){this._onsaparrowkey(e,"up",this._oList.getItems().length);}};
d.prototype.onsapend=function(e){if(this._oList){this._onsaparrowkey(e,"down",this._oList.getItems().length);}};
d.prototype.onsapescape=function(e){var f;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){e.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){f=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=f;}this._sBeforeSuggest=undefined;}return;}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
d.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(this._iPopupListSelectedIndex>=0){this._fireSuggestionItemSelectedEvent();this._doSelect();this._iPopupListSelectedIndex=-1;}this._closeSuggestionPopup();}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
d.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup;if(p instanceof P){if(e.relatedControlId&&q.sap.containsOrEquals(p.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this._$input.val()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var f=sap.ui.getCore().byId(e.relatedControlId);if(!(p&&f&&q.sap.containsOrEquals(p.getDomRef(),f.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}};
d.prototype.onmousedown=function(e){var p=this._oSuggestionPopup;if((p instanceof P)&&p.isOpen()){e.stopPropagation();}};
d.prototype._deregisterEvents=function(){if(this._sPopupResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};
d.prototype.updateSuggestionItems=function(){this.updateAggregation("suggestionItems");this._refreshItemsDelayed();return this;};
d.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){q.sap.clearDelayedCall(this._iSuggestDelay);this._iSuggestDelay=null;}};
d.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=q.sap.delayedCall(300,this,function(){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}});}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}};
(function(){
d.prototype.setShowSuggestion=function(v){this.setProperty("showSuggestion",v,true);this._iPopupListSelectedIndex=-1;if(v){this._lazyInitializeSuggestionPopup(this);}else{g(this);}return this;};
d.prototype.setShowTableSuggestionValueHelp=function(v){this.setProperty("showTableSuggestionValueHelp",v,true);if(!this._oSuggestionPopup){return this;}if(v){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
d.prototype._getShowMoreButton=function(){var t=this,m=sap.ui.getCore().getLibraryResourceBundle("sap.m");return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:m.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(t.getShowTableSuggestionValueHelp()){t.fireValueHelpRequest({fromSuggestions:true});t._iPopupListSelectedIndex=-1;t._closeSuggestionPopup();}}}));};
d.prototype._getButtonToolbar=function(){var s=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new a({content:[new b(),s]}));};
d.prototype._addShowMoreButton=function(t){if(!this._oSuggestionPopup||!t&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var s=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(s);}else{var h=this._getButtonToolbar();this._oSuggestionPopup.setFooter(h);}};
d.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};
d.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var v=this._$input.val();if(this.getMaxLength()>0&&this.getType()!==sap.m.InputType.Number&&v.length>this.getMaxLength()){v=v.substring(0,this.getMaxLength());this._$input.val(v);}if(this.getValueLiveUpdate()){this.setProperty("value",v,true);}this.fireLiveChange({value:v,newValue:v});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(v);}};
d.prototype.getValue=function(){return this.getDomRef("inner")?this._$input.val():this.getProperty("value");};
d.prototype._refreshItemsDelayed=function(){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=q.sap.delayedCall(0,this,r,[this]);};
d.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._refreshItemsDelayed();f(this);return this;};
d.prototype.insertSuggestionItem=function(i,h){this.insertAggregation("suggestionItems",h,i,true);this._refreshItemsDelayed();f(this);return this;};
d.prototype.removeSuggestionItem=function(i){var h=this.removeAggregation("suggestionItems",i,true);this._refreshItemsDelayed();return h;};
d.prototype.removeAllSuggestionItems=function(){var h=this.removeAllAggregation("suggestionItems",true);this._refreshItemsDelayed();return h;};
d.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._refreshItemsDelayed();return this;};
d.prototype.addSuggestionRow=function(i){i.setType(sap.m.ListType.Active);this.addAggregation("suggestionRows",i);this._refreshItemsDelayed();f(this);return this;};
d.prototype.insertSuggestionRow=function(i,h){i.setType(sap.m.ListType.Active);this.insertAggregation("suggestionRows",h,i);this._refreshItemsDelayed();f(this);return this;};
d.prototype.removeSuggestionRow=function(i){var h=this.removeAggregation("suggestionRows",i);this._refreshItemsDelayed();return h;};
d.prototype.removeAllSuggestionRows=function(){var h=this.removeAllAggregation("suggestionRows");this._refreshItemsDelayed();return h;};
d.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._refreshItemsDelayed();return this;};
d.prototype.bindAggregation=function(){var h=Array.prototype.slice.call(arguments);if(h[0]==="suggestionRows"||h[0]==="suggestionColumns"||h[0]==="suggestionItems"){f(this,h[0]==="suggestionRows"||h[0]==="suggestionColumns");this._bBindingUpdated=true;}this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(h));return this;};
d.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){e(this);}};
d.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this.cancelPendingSuggest();this._oSuggestionPopup.close();this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");}};
function e(i){var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(i._bUseDialog){i._oPopupInput=new d(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var v=E.getParameter("newValue");i._$input.val(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(v);i.fireLiveChange({value:v,newValue:v});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,initialFocus:i}).attachAfterClose(function(){if(i._iPopupListSelectedIndex>=0){i._fireSuggestionItemSelectedEvent();}if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:m.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i._$input.val(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput){i._validateCurrentText();}}).attachAfterClose(function(){if(i instanceof sap.m.MultiInput&&i._isMultiLineMode){i._updateTokenizerInMultiInput();i._tokenizerInPopup.destroy();i._showIndicator();setTimeout(function(){i._setContainerSizes();},0);}if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var v=i.getValue();i._oPopupInput.setValue(v);i._triggerSuggest(v);r(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){o(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}
function f(i,t){if(i._oList){return;}if(!i._hasTabularSuggestions()&&!t){i._oList=new L(i.getId()+"-popup-list",{width:"100%",showNoData:false,mode:sap.m.ListMode.SingleSelectMaster,rememberSelections:false,itemPress:function(E){var j=E.getParameter("listItem"),C=i._iSetCount,n;i.fireSuggestionItemSelected({selectedItem:j._oItem});if(C!==i._iSetCount){n=i.getValue();}else if(j instanceof sap.m.DisplayListItem){n=j.getLabel();}else{n=j.getTitle();}if(i._bUseDialog){i._oPopupInput.setValue(n);i._oPopupInput._doSelect();}else{i._$input.val(i._getInputValue(n));i.onChange();}i._iPopupListSelectedIndex=-1;if(!(i._bUseDialog&&i instanceof sap.m.MultiInput&&i._isMultiLineMode)){i._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){i._doSelect();}}});}else{if(i._fnFilter===d._DEFAULTFILTER){i._fnFilter=d._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=d._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(t);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var R=i._oSuggestionPopup.$("scrollCont")[0];if(R){var h=sap.ui.getCore().createRenderManager();h.renderControl(i._oList);h.flush(R);h.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}
function g(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}
function o(p,i){p.open=function(){this.openBy(i,false,true);};p.oPopup.setAnimations(function(R,h,O){O();},function(R,h,C){C();});}
function r(h){var s=h.getShowSuggestion();h._iPopupListSelectedIndex=-1;if(!(s&&h.getDomRef()&&(h._bUseDialog||h.$().hasClass("sapMInputFocused")))){return false;}var j,k=h.getSuggestionItems(),t=h.getSuggestionRows(),m=h._$input.val()||"",n=h._oList,F=h.getFilterSuggests(),H=[],p=0,u=h._oSuggestionPopup,v={ontouchstart:function(E){(E.originalEvent||E)._sapui_cancelAutoClose=true;}},w,i;if(h._oList){if(h._oList instanceof T){n.removeSelections(true);}else{n.destroyItems();}}if(m.length<h.getStartSuggestion()){if(!h._bUseDialog){h._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();u.close();}else{if(h._hasTabularSuggestions()&&h._oList){h._oList.addStyleClass("sapMInputSuggestionTableHidden");}}h.$("SuggDescr").text("");h.$("inner").removeAttr("aria-haspopup");h.$("inner").removeAttr("aria-activedescendant");return false;}if(h._hasTabularSuggestions()){if(h._bUseDialog&&h._oList){h._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<t.length;i++){if(!F||h._fnFilter(m,t[i])){t[i].setVisible(true);H.push(t[i]);}else{t[i].setVisible(false);}}}else{var x=(k[0]instanceof sap.ui.core.ListItem?true:false);for(i=0;i<k.length;i++){j=k[i];if(!F||h._fnFilter(m,j)){if(x){w=new sap.m.DisplayListItem(j.getId()+"-dli");w.setLabel(j.getText());w.setValue(j.getAdditionalText());}else{w=new S(j.getId()+"-sli");w.setTitle(j.getText());}w.setType(j.getEnabled()?sap.m.ListType.Active:sap.m.ListType.Inactive);w._oItem=j;w.addEventDelegate(v);H.push(w);}}}p=H.length;var A="";if(p>0){if(p==1){A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_ONE_HIT");}else{A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_MORE_HITS",p);}h.$("inner").attr("aria-haspopup","true");if(!h._hasTabularSuggestions()){for(i=0;i<p;i++){n.addItem(H[i]);}}if(!h._bUseDialog){if(h._sCloseTimer){clearTimeout(h._sCloseTimer);h._sCloseTimer=null;}if(!u.isOpen()&&!h._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){h._sOpenTimer=setTimeout(function(){h._resizePopup();h._sOpenTimer=null;u.open();},0);}}}else{A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_NO_HIT");h.$("inner").removeAttr("aria-haspopup");h.$("inner").removeAttr("aria-activedescendant");if(!h._bUseDialog){if(u.isOpen()){h._sCloseTimer=setTimeout(function(){h._iPopupListSelectedIndex=-1;h.cancelPendingSuggest();u.close();},0);}}else{if(h._hasTabularSuggestions()&&h._oList){h._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}h.$("SuggDescr").text(A);}
})();
d.prototype.onfocusin=function(e){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;};
d.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.fireValueHelpRequest({fromSuggestions:false});e.preventDefault();e.stopPropagation();};
d.prototype.onsaphide=d.prototype.onsapshow;
d.prototype.onsapselect=function(e){this._fireValueHelpRequestForValueHelpOnly();};
d.prototype.onfocusout=function(e){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};
d.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
d.prototype._getSuggestionsTable=function(){var t=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:sap.m.ListMode.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(e){var i=t,C=i._iSetCount,s=e.getParameter("listItem"),n;t.fireSuggestionItemSelected({selectedRow:s});if(C!==i._iSetCount){n=i.getValue();}else{n=t._fnRowResultFilter(s);}if(t._bUseDialog){t._oPopupInput.setValue(n);t._oPopupInput._doSelect();}else{t._$input.val(t._getInputValue(n));t.onChange();}t._iPopupListSelectedIndex=-1;if(!(i._bUseDialog&&i instanceof sap.m.MultiInput&&i._isMultiLineMode)){i._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){t._doSelect();}}});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);t._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};
d.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var s=this._oList.getItems()[this._iPopupListSelectedIndex];if(s){if(sap.m.ColumnListItem&&s instanceof sap.m.ColumnListItem){this.fireSuggestionItemSelected({selectedRow:s});}else{this.fireSuggestionItemSelected({selectedItem:s._oItem});}}this._iPopupListSelectedIndex=-1;}};
d.prototype._callMethodInManagedObject=function(f,A){var e=Array.prototype.slice.call(arguments),s;if(A==="suggestionColumns"){s=this._getSuggestionsTable();return s[f].apply(s,["columns"].concat(e.slice(2)));}else if(A==="suggestionRows"){s=this._getSuggestionsTable();return s[f].apply(s,["items"].concat(e.slice(2)));}else{return sap.ui.core.Control.prototype[f].apply(this,e.slice(1));}};
d.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
d.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};
d.prototype.getAggregation=function(A,o){return this._callMethodInManagedObject("getAggregation",A,o);};
d.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
d.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};
d.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};
d.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
d.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
d.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};
d.prototype.getBinding=function(A){return this._callMethodInManagedObject("getBinding",A);};
d.prototype.getBindingInfo=function(A){return this._callMethodInManagedObject("getBindingInfo",A);};
d.prototype.getBindingPath=function(A){return this._callMethodInManagedObject("getBindingPath",A);};
d.prototype.clone=function(){var i=sap.ui.core.Control.prototype.clone.apply(this,arguments),e;e=this.getBindingInfo("suggestionColumns");if(e){i.bindAggregation("suggestionColumns",e);}else{this.getSuggestionColumns().forEach(function(C){i.addSuggestionColumn(C.clone(),true);});}e=this.getBindingInfo("suggestionRows");if(e){i.bindAggregation("suggestionRows",e);}else{this.getSuggestionRows().forEach(function(r){i.addSuggestionRow(r.clone(),true);});}return i;};
d.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);return this;};
d.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
return d;},true);
sap.ui.predefine('sap/m/InputBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/Popup'],function(q,l,C,E,I,P){"use strict";
var a=C.extend("sap.m.InputBase",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}}}});
E.call(a.prototype);I.insertFontFaceStyle();a.prototype.bShowLabelAsPlaceholder=!sap.ui.Device.support.input.placeholder;
a.prototype._getPlaceholder=function(){return this.getPlaceholder();};
a.prototype._setLabelVisibility=function(){if(!this.bShowLabelAsPlaceholder){return;}var v=this.$("inner").val();this.$("placeholder").css("display",v?"none":"inline");};
a.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
a.prototype._triggerInputEvent=function(p){p=p||{};var e=new q.Event("input",p);e.originalEvent=p;e.setMark("synthetic",true);q.sap.delayedCall(0,this,function(){this.$("inner").trigger(e);});};
a.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;};
a.prototype.onBeforeRendering=function(){if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};
a.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this._setLabelVisibility();this.bRenderingPhase=false;};
a.prototype.exit=function(){if(this._popup){this._popup.destroy();this._popup=null;}};
a.prototype.ontouchstart=function(e){e.setMarked();};
a.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&sap.ui.Device.browser.msie&&sap.ui.Device.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue();this.$().toggleClass("sapMFocus",true);this.openValueStateMessage();};
a.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};
a.prototype.onsapfocusleave=function(e){if(this.bFocusoutDueRendering){return;}this.onChange(e);};
a.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&this.bShowLabelAsPlaceholder&&e.target.id===this.getId()+"-placeholder"){this.focus();}};
a.prototype.onChange=function(e){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue();if(v!==this._lastValue){this.setValue(v);v=this.getValue();this._lastValue=v;this.fireChangeEvent(v);return true;}};
a.prototype.fireChangeEvent=function(v,p){var c=q.extend({value:v,newValue:v},p);this.fireChange(c);};
a.prototype.onValueRevertedByEscape=function(v){this.fireEvent("liveChange",{value:v,newValue:v});};
a.prototype.onsapenter=function(e){this.onChange(e);};
a.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue);}};
a.prototype.oninput=function(e){if(this._bIgnoreNextInput){this._bIgnoreNextInput=false;e.setMarked("invalid");return;}if(!this.getEditable()){e.setMarked("invalid");return;}if(document.activeElement!==e.target){e.setMarked("invalid");return;}this._bCheckDomValue=true;this._setLabelVisibility();};
a.prototype.onkeydown=function(e){var k=q.sap.KeyCodes;var b=sap.ui.Device.browser;if((b.msie&&b.version<10)&&(e.which===k.DELETE||e.which===k.BACKSPACE)){this._triggerInputEvent();}};
a.prototype.oncut=function(e){var b=sap.ui.Device.browser;if(b.msie&&b.version<10){this._triggerInputEvent();}};
a.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
a.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
a.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
a.prototype.getFocusInfo=function(){var f=C.prototype.getFocusInfo.call(this),F=this.getFocusDomRef();q.extend(f,{cursorPos:0,selectionStart:0,selectionEnd:0});if(F){f.cursorPos=q(F).cursorPos();try{f.selectionStart=F.selectionStart;f.selectionEnd=F.selectionEnd;}catch(e){}}return f;};
a.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.call(this,f);this.$("inner").cursorPos(f.cursorPos);this.selectText(f.selectionStart,f.selectionEnd);return this;};
a.prototype.bindToInputEvent=function(c){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:c};return this.addEventDelegate(this._oInputEventDelegate);};
a.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}this._setLabelVisibility();return this;};
a.prototype.closeValueStateMessage=function(){if(this._popup){this._popup.close(0);}this.$("inner").removeAriaDescribedBy(this.getId()+"-message");};
a.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};
a.prototype.iOpenMessagePopupDuration=0;
a.prototype.openValueStateMessage=function(){var s=this.getValueState();if(s==sap.ui.core.ValueState.None||!this.getShowValueStateMessage()||!this.getEditable()||!this.getEnabled()){return;}var t=this.getValueStateText()||sap.ui.core.ValueStateSupport.getAdditionalText(this);var m=this.getId()+"-message";if(!this._popup){this._popup=new P(q("<span></span>")[0],false,false,false);this._popup.attachClosed(function(){q.sap.byId(m).remove();});}var d=P.Dock;var i=this.$("inner");var c="sapMInputBaseMessage sapMInputBaseMessage"+s;var T="sapMInputBaseMessageText";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(s===sap.ui.core.ValueState.Success){c="sapUiInvisibleText";t="";}var $=q("<div>",{"id":m,"class":c,"role":"tooltip","aria-live":"assertive"}).append(q("<span>",{"aria-hidden":true,"class":"sapUiHidden","text":r.getText("INPUTBASE_VALUE_STATE_"+s.toUpperCase())})).append(q("<span>",{"id":m+"-text","class":T,"text":t}));this._popup.setContent($[0]);this._popup.close(0);this._popup.open(this.iOpenMessagePopupDuration,d.BeginTop,d.BeginBottom,this.getDomRefForValueStateMessage(),null,null,sap.ui.Device.system.phone?true:P.CLOSE_ON_SCROLL);if(i.offset().top<$.offset().top){$.addClass("sapMInputBaseMessageBottom");}else{$.addClass("sapMInputBaseMessageTop");}i.addAriaDescribedBy(m);};
a.prototype.updateValueStateClasses=function(v,o){var t=this.$(),i=this.$("inner"),V=sap.ui.core.ValueState;if(o!==V.None){t.removeClass("sapMInputBaseState sapMInputBase"+o);i.removeClass("sapMInputBaseStateInner sapMInputBase"+o+"Inner");}if(v!==V.None){t.addClass("sapMInputBaseState sapMInputBase"+v);i.addClass("sapMInputBaseStateInner sapMInputBase"+v+"Inner");}};
a.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var d=this.getDomRef();if(!d){return this;}var i=this.$("inner"),V=sap.ui.core.ValueState;if(v===V.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){(v==V.None)?this.closeValueStateMessage():this.openValueStateMessage();}return this;};
a.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message-text").text(this.getValueStateText());return this;};
a.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};
a.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
a.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
a.prototype.propagateMessages=function(n,m){if(m&&m.length>0){this.setValueState(m[0].type);this.setValueStateText(m[0].message);}else{this.setValueState(sap.ui.core.ValueState.None);this.setValueStateText('');}};
a.prototype.setTooltip=function(t){var d=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!d){return this;}var T=this.getTooltip_AsString();if(T){d.setAttribute("title",T);}else{d.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var D=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),s=this.getId()+"-describedby",b="aria-describedby",f=this.getFocusDomRef(),c=f.getAttribute(b);if(!D&&A){D=document.createElement("span");D.id=s;D.setAttribute("aria-hidden","true");D.className="sapUiInvisibleText";if(this.getAriaDescribedBy){f.setAttribute(b,(this.getAriaDescribedBy().join(" ")+" "+s).trim());}else{f.setAttribute(b,s);}d.appendChild(D);}else if(D&&!A){d.removeChild(D);var e=D.id;if(c&&e){f.setAttribute(b,c.replace(e,"").trim());}}if(D){D.textContent=A;}}return this;};
a.prototype.refreshDataState=function(n,d){if(d.getChanges().messages){this.propagateMessages(n,d.getMessages());}};
a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();return{role:r.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
Object.defineProperty(a.prototype,"_$input",{get:function(){return this.$("inner");}});return a;},true);
sap.ui.predefine('sap/m/InputBaseRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/core/ValueStateSupport'],function(q,R,V){"use strict";var I={};
I.render=function(r,c){var v=c.getValueState(),t=c.getTextDirection(),T=R.getTextAlign(c.getTextAlign(),t),a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<div");r.writeControlData(c);this.addOuterStyles(r,c);if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.addClass("sapMInputBase");this.addPaddingClass(r,c);this.addCursorClass(r,c);this.addOuterClasses(r,c);if(!c.getEnabled()){r.addClass("sapMInputBaseDisabled");}if(!c.getEditable()){r.addClass("sapMInputBaseReadonly");}if(v!==sap.ui.core.ValueState.None){this.addValueStateClasses(r,c);}r.writeClasses();this.writeOuterAttributes(r,c);var s=c.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write(">");this.prependInnerContent(r,c);if(c.bShowLabelAsPlaceholder){r.write("<label");r.writeAttribute("id",c.getId()+"-placeholder");if(T){r.addStyle("text-align",T);}this.addPlaceholderClasses(r,c);this.addPlaceholderStyles(r,c);r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(c._getPlaceholder());r.write("</label>");}this.openInputTag(r,c);r.writeAttribute("id",c.getId()+"-inner");if(c.getName()){r.writeAttributeEscaped("name",c.getName());}if(!c.bShowLabelAsPlaceholder&&c._getPlaceholder()){r.writeAttributeEscaped("placeholder",c._getPlaceholder());}if(c.getMaxLength&&c.getMaxLength()>0){r.writeAttribute("maxlength",c.getMaxLength());}if(!c.getEnabled()){r.writeAttribute("disabled","disabled");r.addClass("sapMInputBaseDisabledInner");}else if(!c.getEditable()){r.writeAttribute("readonly","readonly");r.addClass("sapMInputBaseReadonlyInner");}if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}this.writeInnerValue(r,c);if(a){this.writeAccessibilityState(r,c);}if(sap.ui.Device.browser.mozilla){if(s){r.writeAttributeEscaped("x-moz-errormessage",s);}else{r.writeAttribute("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,c);r.addClass("sapMInputBaseInner");if(v!==sap.ui.core.ValueState.None){this.addValueStateInnerClasses(r,c);}this.addInnerClasses(r,c);r.writeClasses();if(T){r.addStyle("text-align",T);}this.addInnerStyles(r,c);r.writeStyles();r.write(">");this.writeInnerContent(r,c);this.closeInputTag(r,c);if(a){this.renderAriaLabelledBy(r,c);this.renderAriaDescribedBy(r,c);}r.write("</div>");};
I.getAriaRole=function(c){return"textbox";};
I.getAriaLabelledBy=function(c){if(this.getLabelledByAnnouncement(c)){return c.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(c){return c._getPlaceholder()||"";};
I.renderAriaLabelledBy=function(r,c){var a=this.getLabelledByAnnouncement(c);if(a){r.write("<label");r.writeAttribute("id",c.getId()+"-labelledby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</label>");}};
I.getAriaDescribedBy=function(c){if(this.getDescribedByAnnouncement(c)){return c.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(c){return c.getTooltip_AsString()||"";};
I.renderAriaDescribedBy=function(r,c){var a=this.getDescribedByAnnouncement(c);if(a){r.write("<span");r.writeAttribute("id",c.getId()+"-describedby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAccessibilityState=function(c){var a=this.getAriaLabelledBy(c),A=this.getAriaDescribedBy(c),m={role:this.getAriaRole(c)};if(c.getValueState()===sap.ui.core.ValueState.Error){m.invalid=true;}if(a){m.labelledby={value:a.trim(),append:true};}if(A){m.describedby={value:A.trim(),append:true};}return m;};
I.writeAccessibilityState=function(r,c){r.writeAccessibilityState(c,this.getAccessibilityState(c));};
I.openInputTag=function(r,c){r.write("<input");};
I.writeInnerValue=function(r,c){r.writeAttributeEscaped("value",c.getValue());};
I.addCursorClass=function(r,c){};
I.addPaddingClass=function(r,c){r.addClass("sapMInputBaseWidthPadding");};
I.addOuterStyles=function(r,c){};
I.addOuterClasses=function(r,c){};
I.writeOuterAttributes=function(r,c){};
I.addInnerStyles=function(r,c){};
I.addInnerClasses=function(r,c){};
I.writeInnerAttributes=function(r,c){};
I.prependInnerContent=function(r,c){};
I.writeInnerContent=function(r,c){};
I.closeInputTag=function(r,c){};
I.addPlaceholderStyles=function(r,c){};
I.addPlaceholderClasses=function(r,c){r.addClass("sapMInputBasePlaceholder");};
I.addValueStateInnerClasses=function(r,c){r.addClass("sapMInputBaseStateInner");r.addClass("sapMInputBase"+c.getValueState()+"Inner");};
I.addValueStateClasses=function(r,c){r.addClass("sapMInputBaseState");r.addClass("sapMInputBase"+c.getValueState());};
return I;},true);
sap.ui.predefine('sap/m/InputListItem.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);
sap.ui.predefine('sap/m/InputListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var I=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:true}});
return I;},true);
sap.ui.predefine('sap/m/InputListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var I=R.extend(L);
I.renderLIAttributes=function(r,l){r.addClass("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();if(s){var a=l.getId()+"-label",b=l.getLabelTextDirection();r.write('<label id="'+a+'" class="sapMILILabel"');if(b!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",b.toLowerCase());}r.write('>');r.writeEscaped(s);r.write('</label>');}r.write('<div class="sapMILIDiv sapMILI-CTX">');l.getContent().forEach(function(c){if(a&&c.addAriaLabelledBy&&c.getAriaLabelledBy().indexOf(a)==-1){c.addAriaLabelledBy(a);}r.renderControl(c);});r.write('</div>');};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['jquery.sap.global','sap/ui/core/Renderer','./InputBaseRenderer'],function(q,R,I){"use strict";var a=R.extend(I);
a.addOuterClasses=function(r,c){r.addClass("sapMInput");if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){r.addClass("sapMInputVH");if(c.getValueHelpOnly()){r.addClass("sapMInputVHO");}}if(c.getDescription()){r.addClass("sapMInputDescription");}};
a.addOuterStyles=function(r,c){};
a.writeInnerAttributes=function(r,c){r.writeAttribute("type",c.getType().toLowerCase());if((!c.getEnabled()&&c.getType()=="Password")||(c.getShowSuggestion()&&c._bUseDialog)||(c.getValueHelpOnly()&&c.getEnabled()&&c.getEditable()&&c.getShowValueHelp())){r.writeAttribute("readonly","readonly");}};
a.addInnerClasses=function(r,c){};
a.addInnerStyles=function(r,c){if(c.getDescription()){r.addStyle("width",c.getFieldWidth()||"50%");}};
a.writeInnerContent=function(r,c){var i=c.getId(),d=c.getDescription();if(!d){this.writeValueHelpIcon(r,c);}else{r.write("<span id=\""+c.getId()+"-Descr\">");this.writeValueHelpIcon(r,c);r.writeEscaped(d);r.write("</span>");}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){r.write("<span id=\""+i+"-SuggDescr\" class=\"sapUiInvisibleText\" role=\"status\" aria-live=\"polite\"></span>");}}};
a.writeValueHelpIcon=function(r,c){if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){r.write('<div class="sapMInputValHelp" tabindex="-1">');r.renderControl(c._getValueHelpIcon());r.write("</div>");}};
a.addPlaceholderStyles=function(r,c){if(c.getDescription()){r.addStyle("width",c.getFieldWidth()||"50%");}};
a.getAriaLabelledBy=function(c){var b=I.getAriaLabelledBy.call(this,c)||"";if(c.getDescription()){b=b+" "+c.getId()+"-Descr";}return b;};
a.getAriaDescribedBy=function(c){var A=I.getAriaDescribedBy.apply(this,arguments);if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){if(A){A=A+" "+c._sAriaValueHelpLabelId;}else{A=c._sAriaValueHelpLabelId;}if(c.getValueHelpOnly()){A=A+" "+c._sAriaInputDisabledLabelId;}}if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){if(A){A=A+" "+c.getId()+"-SuggDescr";}else{A=c.getId()+"-SuggDescr";}}return A;};
a.getAccessibilityState=function(c){var A=I.getAccessibilityState.apply(this,arguments);if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){A.autocomplete="list";}return A;};
return a;},true);
sap.ui.predefine('sap/m/InstanceManager',['jquery.sap.global'],function(q){"use strict";var I={};(function(){var r={},e=[];var p="_POPOVER_",d="_DIALOG_";
I.addInstance=function(c,i){if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;if(!C){q.sap.log.warning("Can't remove control from a non-managed category id: "+c);return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){return r[c]||e;};
I.isInstanceManaged=function(c,i){var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{q.sap.log.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{q.sap.log.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.closeAllPopovers=function(){var a=I.getOpenPopovers(),i;for(i=0;i<a.length;i++){a[i].close();}return this;};
I.closeAllDialogs=function(c){var D,a=[],b=I.getOpenDialogs(),f,i;for(i=0;i<b.length;i++){f=b[i];if(c){D=new q.Deferred().done();a.push(D);f.attachEvent("afterClose",(function(g){return function(){g.resolve();};}(D)));}f.close();}if(c){q.when.apply(this,a).then(c);}return this;};
}());return I;},true);
sap.ui.predefine('sap/m/Label',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/LabelEnablement'],function(q,l,C,L){"use strict";
var a=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:sap.m.LabelDesign.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}}}});
a.prototype.setText=function(t){var v=this.getText();if(v!==t){this.setProperty("text",t,true);this.$().html(q.sap.encodeHTML(this.getProperty("text")));if(t){this.$().removeClass("sapMLabelNoText");}else{this.$().addClass("sapMLabelNoText");}}return this;};
a.prototype.setTooltip=function(t){var v=this.getTooltip();if(v!==t){this.setAggregation("tooltip",t,true);this.$().attr("title",this.getTooltip());}return this;};
a.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
L.enrich(a.prototype);return a;},true);
sap.ui.predefine('sap/m/LabelRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var L={};
L.render=function(a,l){var r=L;a.write("<label");a.writeControlData(l);a.addClass("sapMLabel");a.addClass("sapUiSelectable");if(l.getDesign()==sap.m.LabelDesign.Bold){a.addStyle("font-weight","bold");}if(l.getRequired()){a.addClass("sapMLabelRequired");}if(l.getLabelForRendering()){sap.ui.core.LabelEnablement.writeLabelForAttribute(a,l);}else if(l.getParent()instanceof sap.m.Toolbar){a.addClass("sapMLabelTBHeader");}var t=l.getTextDirection();if(t!==sap.ui.core.TextDirection.Inherit){a.writeAttribute("dir",t.toLowerCase());}var w=l.getWidth();if(w){a.addStyle("width",w);}else{a.addClass("sapMLabelMaxWidth");}var T=l.getTextAlign();if(T){var T=r.getTextAlign(T,t);if(T){a.addStyle("text-align",T);}}var s=l.getText();if(s==""){a.addClass("sapMLabelNoText");}a.writeStyles();a.writeClasses();var b=l.getTooltip_AsString();if(b){a.writeAttributeEscaped("title",b);}a.write(">");if(s){a.writeEscaped(s);}a.write("</label>");};
L.getTextAlign=R.getTextAlign;return L;},true);
sap.ui.predefine('sap/m/Link',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement'],function(q,l,C,I,E,L){"use strict";
var a=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}}}});
E.call(a.prototype);
a.prototype.onBeforeRendering=function(){this.removeAssociation("ariaLabelledBy",this.getId(),true);if(this.getAriaLabelledBy().length>0||L.getReferencingLabels(this).length>0){this.addAssociation("ariaLabelledBy",this.getId(),true);}};
a.prototype.onsapspace=function(e){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var c=document.createEvent('MouseEvents');c.initEvent('click',false,true);this.getDomRef().dispatchEvent(c);}};
a.prototype._handlePress=function(e){if(this.getEnabled()){e.setMarked();if(!this.firePress()||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};
if(sap.ui.Device.support.touch){a.prototype.ontap=a.prototype._handlePress;}else{a.prototype.onclick=a.prototype._handlePress;}
a.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();}};
a.prototype.setText=function(t){this.setProperty("text",t,true);t=this.getProperty("text");this.$().text(t);return this;};
a.prototype.setHref=function(u){this.setProperty("href",u,true);if(this.getEnabled()){u=this.getProperty("href");this.$().attr("href",u);}return this;};
a.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){a._addToDescribedBy($,this._sAriaLinkSubtleId);}else{a._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!a.prototype._sAriaLinkSubtleId){a.prototype._sAriaLinkSubtleId=a._getARIAInvisibleTextId("LINK_SUBTLE");}return this;};
a.prototype.setEmphasized=function(e){this.setProperty("emphasized",e,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",e);if(e){a._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{a._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(e&&!a.prototype._sAriaLinkEmphasizedId){a.prototype._sAriaLinkEmphasizedId=a._getARIAInvisibleTextId("LINK_EMPHASIZED");}return this;};
a.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};
a.prototype.setEnabled=function(e){if(e!==this.getProperty("enabled")){this.setProperty("enabled",e,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!e);if(e){$.attr("disabled",false);$.attr("tabindex","0");$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("tabindex","-1");$.attr("aria-disabled",true);$.attr("href","javascript:void(0);");}}return this;};
a.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};
a.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};
a._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};
a._getARIAInvisibleTextId=function(r){var R=a._getResourceBundle();return new I({text:R.getText(r)}).toStatic().getId();};
a._addToDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A){$.attr("aria-describedby",A+" "+i);}else{$.attr("aria-describedby",i);}};
a._removeFromDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A&&A.indexOf(i)!==-1){A=A.replace(i,'');if(A.length>1){$.attr("aria-describedby",A);}else{$.removeAttr("aria-describedby");}}};
a.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
return a;},true);
sap.ui.predefine('sap/m/LinkRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var L={};
L.render=function(r,c){var t=c.getTextDirection(),T=R.getTextAlign(c.getTextAlign(),t),a={role:'link',haspopup:!c.getHref()};r.write("<a");r.writeControlData(c);r.addClass("sapMLnk");if(c.getSubtle()){r.addClass("sapMLnkSubtle");if(a.describedby){a.describedby+=" "+c._sAriaLinkSubtleId;}else{a.describedby=c._sAriaLinkSubtleId;}}if(c.getEmphasized()){r.addClass("sapMLnkEmphasized");if(a.describedby){a.describedby+=" "+c._sAriaLinkEmphasizedId;}else{a.describedby=c._sAriaLinkEmphasizedId;}}if(!c.getEnabled()){r.addClass("sapMLnkDsbl");r.writeAttribute("disabled","true");r.writeAttribute("tabIndex","-1");}else{r.writeAttribute("tabIndex","0");}if(c.getWrapping()){r.addClass("sapMLnkWrapping");}if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}if(c.getHref()&&c.getEnabled()){r.writeAttributeEscaped("href",c.getHref());}else{r.writeAttribute("href","javascript:void(0);");}if(c.getTarget()){r.writeAttributeEscaped("target",c.getTarget());}if(c.getWidth()){r.addStyle("width",c.getWidth());}else{r.addClass("sapMLnkMaxWidth");}if(T){r.addStyle("text-align",T);}if(t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeAccessibilityState(c,a);r.writeClasses();r.writeStyles();r.write(">");this.renderText(r,c);r.write("</a>");};
L.renderText=function(r,c){r.writeEscaped(c.getText());};
return L;},true);
sap.ui.predefine('sap/m/List',['jquery.sap.global','./ListBase','./library'],function(q,L,l){"use strict";
var a=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",deprecated:true}}}});
a.prototype.onBeforeRendering=function(){if(L.prototype.onBeforeRendering){L.prototype.onBeforeRendering.call(this);}if(!this.getColumns().length||this._isColumnsIncompatible()){return;}q.sap.require("sap.m.Table");var p=sap.m.Table.prototype;Object.keys(p).forEach(function(k){this[k]=p[k];},this);if(!this.mProperties.hasOwnProperty("backgroundDesign")){this.setBackgroundDesign("Translucent");}};
a.prototype._isColumnsIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMListAsTable").compareTo("1.16")>=0;};
return a;},true);
sap.ui.predefine('sap/m/ListBase',['jquery.sap.global','./GroupHeaderListItem','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters'],function(q,G,l,C,I,P){"use strict";
var L=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:sap.m.ListHeaderDesign.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:sap.m.ListMode.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:sap.m.ListSeparators.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:sap.m.SwipeDirection.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:sap.m.ListKeyboardMode.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable"},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}}}}});
L.prototype.sNavItemClass="sapMLIB";
L.prototype.init=function(){this._oGrowingDelegate=null;this._bSelectionMode=false;this._bReceivingData=false;this._oSelectedItem=null;this._aSelectedPaths=[];this._aNavSections=[];this._bUpdating=false;this._bRendering=false;this._bActiveItem=false;this.data("sap-ui-fastnavgroup","true",true);};
L.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
L.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(sap.ui.Device.system.desktop){this._bItemNavigationInvalidated=true;}};
L.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
L.prototype.refreshItems=function(r){this._showBusyIndicator();if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};
L.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};
L.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};
L.prototype._bindAggregation=function(n){n=="items"&&this._resetItemsBinding();return C.prototype._bindAggregation.apply(this,arguments);};
L.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};
L.prototype.removeAllItems=function(a){this._oSelectedItem=null;return this.removeAllAggregation("items");};
L.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);if(o&&o===this._oSelectedItem){this._oSelectedItem=null;}return o;};
L.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
L.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};
L.prototype.setGrowing=function(g){g=!!g;if(this.getGrowing()!=g){this.setProperty("growing",g,!g);if(g){q.sap.require("sap.m.GrowingEnablement");this._oGrowingDelegate=new sap.m.GrowingEnablement(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
L.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};
L.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
L.prototype.setNoDataText=function(n){this.setProperty("noDataText",n,true);this.$("nodata-text").text(this.getNoDataText());return this;};
L.prototype.getNoDataText=function(c){if(c&&this._bBusy){return"";}var n=this.getProperty("noDataText");n=n||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return n;};
L.prototype.getSelectedItem=function(){var a=this.getItems(true);for(var i=0;i<a.length;i++){if(a[i].getSelected()){return a[i];}}return null;};
L.prototype.setSelectedItem=function(o,s,f){if(this.indexOfItem(o)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){o.setSelected((s===undefined)?true:!!s);f&&this._fireSelectionChangeEvent([o]);}};
L.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
L.prototype.setSelectedItemById=function(i,s){var o=sap.ui.getCore().byId(i);return this.setSelectedItem(o,s);};
L.prototype.getSelectedContexts=function(a){var b=this.getBindingInfo("items"),m=(b||{}).model,M=this.getModel(m);if(!b||!M){return[];}if(a&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return M.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(m);});};
L.prototype.removeSelections=function(a,f,d){var c=[];this._oSelectedItem=null;a&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(i){if(!i.getSelected()){return;}if(d&&i.isSelectedBoundTwoWay()){return;}i.setSelected(false,true);c.push(i);!a&&this._updateSelectedPaths(i);},this);if(f&&c.length){this._fireSelectionChangeEvent(c);}return this;};
L.prototype.selectAll=function(f){if(this.getMode()!="MultiSelect"){return this;}var c=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);c.push(i);this._updateSelectedPaths(i);}},this);if(f&&c.length){this._fireSelectionChangeEvent(c);}return this;};
sap.m.ListBase.prototype.getLastMode=function(m){return this._sLastMode;};
L.prototype.setMode=function(m){m=this.validateProperty("mode",m);var o=this.getMode();if(o==m){return this;}this.setProperty("mode",m);this._bSelectionMode=m.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);return this;}var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(o===sap.m.ListMode.MultiSelect){this._oSelectedItem=s[0];}return this;};
L.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
L.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
sap.m.ListBase.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};
sap.m.ListBase.prototype.getSelectedContextPaths=function(){return this._aSelectedPaths.slice(0);};
L.prototype.isAllSelectableSelected=function(){var i=this.getItems(true),s=this.getSelectedItems().length,S=i.filter(function(o){return o.isSelectable();}).length;return i.length>0&&s==S;};
L.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
L.prototype.getActiveItem=function(){return this._bActiveItem;};
L.prototype.onItemDOMUpdate=function(o){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};
L.prototype.onItemActiveChange=function(o,a){this._bActiveItem=a;};
L.prototype.onItemSelectedChange=function(o,s){if(this.getMode()==sap.m.ListMode.MultiSelect){this._updateSelectedPaths(o,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=o;}else if(this._oSelectedItem===o){this._oSelectedItem=null;}this._updateSelectedPaths(o,s);};
L.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
L.prototype.checkGrowingFromScratch=function(){};
L.prototype.onBeforePageLoaded=function(g,c){this._fireUpdateStarted(c,g);this.fireGrowingStarted(g);};
L.prototype.onAfterPageLoaded=function(g,c){this._fireUpdateFinished(g);this.fireGrowingFinished(g);};
L.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
L.prototype.getMaxItemsCount=function(){var b=this.getBinding("items");if(b){return b.getLength()||0;}return this.getItems(true).length;};
L.prototype.shouldRenderItems=function(){return true;};
L.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
L.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};
L.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
L.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
L.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};
L.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};
L.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
L.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};
L.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};
L.prototype.onItemSelect=function(o,s){if(this.getMode()==sap.m.ListMode.MultiSelect){this._fireSelectionChangeEvent([o]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([o]);}};
L.prototype._fireSelectionChangeEvent=function(a){var o=a&&a[0];if(!o){return;}this.fireSelectionChange({listItem:o,listItems:a,selected:o.getSelected()});this.fireSelect({listItem:o});};
L.prototype.onItemDelete=function(o){this.fireDelete({listItem:o});};
L.prototype.onItemPress=function(o,s){if(o.getType()==sap.m.ListType.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:o,srcControl:s});});};
L.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var a=this._aSelectedPaths.indexOf(p);if(s){a<0&&this._aSelectedPaths.push(p);}else{a>-1&&this._aSelectedPaths.splice(a,1);}};
L.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
L.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
L.prototype._getTouchBlocker=function(){return this.$().children();};
L.prototype._getSwipeContainer=function(){return this._$swipeContainer||(q.sap.require("sap.m.InstanceManager"),this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};
L.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
L.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),a=this._getSwipeContainer();this.$().prepend(a.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),a.empty()[0]);r.destroy();}return this;};
L.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),a=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();sap.m.InstanceManager.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!a[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});a.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");a.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!a[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
L.prototype._onSwipeOut=function(c){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof c=="function"){c.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;sap.m.InstanceManager.removeDialogInstance(this);};
L.prototype.swipeOut=function(c){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(c);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
L.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
L.prototype.close=L.prototype._removeSwipeContent;
L.prototype._onSwipe=function(e){var c=this.getSwipeContent(),s=e.srcControl;if(c&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&(sap.ui.Device.support.touch||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))){for(var a=s;a&&!(a instanceof sap.m.ListItemBase);a=a.oParent);if(a instanceof sap.m.ListItemBase){this._swipedItem=a;this.fireSwipe({listItem:this._swipedItem,swipeContent:c,srcControl:s},true)&&this._swipeIn();}}};
L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
L.prototype.onswipeleft=function(e){var a=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=a){this._onSwipe(e);}};
L.prototype.onswiperight=function(e){var a=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=a){this._onSwipe(e);}};
L.prototype.setSwipeDirection=function(d){return this.setProperty("swipeDirection",d,true);};
L.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
L.prototype.setSwipeContent=function(c){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!c);return this.setAggregation("swipeContent",c,!this._isSwipeActive);};
L.prototype.invalidate=function(o){if(o&&o===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}C.prototype.invalidate.apply(this,arguments);return this;};
L.prototype.addItemGroup=function(g,h,s){h=h||new G({title:g.text||g.key});h._bGroupHeader=true;this.addAggregation("items",h,s);return h;};
L.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};
L.prototype.getRole=function(){var m=this.getMode(),M=sap.m.ListMode;return(m==M.None||m==M.Delete)?"list":"listbox";};
L.prototype.onNavigationItemFocus=function(e){var i=e.getParameter("index"),a=this._oItemNavigation.getItemDomRefs(),o=a[i],s=a.length,b=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&b&&b.isLengthFinal()){s=b.getLength();if(b.isGrouped()){s+=this.getItems(true).filter(function(c){return c.isGroupHeader()&&c.getVisible();}).length;}}this.getNavigationRoot().setAttribute("aria-activedescendant",o.id);o.setAttribute("aria-posinset",i+1);o.setAttribute("aria-setsize",s);};
L.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
L.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
L.prototype._startItemNavigation=function(i){if(!sap.ui.Device.system.desktop){return;}var k=this.getKeyboardMode(),K=sap.m.ListKeyboardMode;if(k==K.Edit&&!this.getItems(true).length){return;}if(i&&!this.getNavigationRoot().contains(document.activeElement)){this._bItemNavigationInvalidated=true;return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);var t=(k==K.Edit)?-1:0;this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this.onNavigationItemFocus,this);}this._oItemNavigation.setPageSize(this.getGrowingThreshold());var n=this.getNavigationRoot();this._oItemNavigation.setRootDomRef(n);this.setNavigationItems(this._oItemNavigation,n);this._bItemNavigationInvalidated=false;};
L.prototype.setNavigationItems=function(i,n){var N=q(n).children(".sapMLIB").get();i.setItemDomRefs(N);if(i.getFocusedIndex()==-1){i.setFocusedIndex(0);}};
L.prototype.getItemNavigation=function(){return this._oItemNavigation;};
L.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};
L.prototype.setKeyboardMode=function(k){this.setProperty("keyboardMode",k,true);if(this.isActive()){var t=(k==sap.m.ListKeyboardMode.Edit)?-1:0;this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};
L.prototype.setItemFocusable=function(o){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var a=i.indexOf(o.getDomRef());if(a>=0){this._oItemNavigation.setFocusedIndex(a);}};
L.prototype.forwardTab=function(f){this._bIgnoreFocusIn=true;this.$(f?"after":"before").focus();};
L.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
L.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
L.prototype._navToSection=function(f){var t;var i=0;var s=f?1:-1;var a=this._aNavSections.length;this._aNavSections.some(function(S,b){var d=q.sap.domById(S);if(d&&d.contains(document.activeElement)){i=b;return true;}});var o=this.getItemsContainerDomRef();var c=q.sap.byId(this._aNavSections[i]);if(c[0]===o&&this._oItemNavigation){c.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+a)%a;t=q.sap.byId(this._aNavSections[i]);if(t[0]===o&&this._oItemNavigation){var r=t.data("redirect");var b=this._oItemNavigation.getItemDomRefs();var T=b[r]||o.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};
L.prototype.onsapshow=function(e){if(e.isMarked()||e.which==q.sap.KeyCodes.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
L.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
L.prototype.onkeydown=function(e){var c=(e.which==q.sap.KeyCodes.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!c||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==sap.m.ListMode.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
L.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};
L.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var f=t.eq(-1).add($).eq(-1);f.focus();};
L.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit||e.target.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
L.prototype.onItemArrowUpDown=function(o,e){var i=this.getItems(true),a=i.indexOf(o)+(e.type=="sapup"?-1:1),b=i[a];if(b.isGroupHeader()){b=i[a+(e.type=="sapup"?-1:1)];}if(!b){return;}var t=b.getTabbables(),f=o.getTabbables().index(e.target),E=t.eq(t[f]?f:-1);E[0]?E.focus():b.focus();e.preventDefault();e.setMarked();};
return L;},true);
sap.ui.predefine('sap/m/ListBaseRenderer',['jquery.sap.global','sap/ui/core/theming/Parameters','./ListItemBaseRenderer'],function(q,P,L){"use strict";var a={};a.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
a.render=function(r,c){r.write("<div");r.addClass("sapMList");r.writeControlData(c);r.writeAttribute("tabindex","-1");r.writeAttribute("role","presentation");if(c.getInset()){r.addClass("sapMListInsetBG");}if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getBackgroundDesign){r.addClass("sapMListBG"+c.getBackgroundDesign());}var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}this.renderContainerAttributes(r,c);r.writeStyles();r.writeClasses();r.write(">");var h=c.getHeaderText();var H=c.getHeaderToolbar();if(H){H.setDesign(sap.m.ToolbarDesign.Transparent,true);H.addStyleClass("sapMListHdrTBar");r.renderControl(H);}else if(h){r.write("<header class='sapMListHdr'");r.writeAttribute("id",c.getId("header"));r.write(">");r.writeEscaped(h);r.write("</header>");}var I=c.getInfoToolbar();if(I){I.setDesign(sap.m.ToolbarDesign.Info,true);I.addStyleClass("sapMListInfoTBar");r.renderControl(I);}var b=c.getItems(true),s=c.getShowNoData(),R=c.shouldRenderItems()&&b.length,T=c.getKeyboardMode()==sap.m.ListKeyboardMode.Edit?-1:0;if(R||s){this.renderDummyArea(r,c,"before",-1);}this.renderListStartAttributes(r,c);r.writeAccessibilityState(c,this.getAccessibilityState(c));r.addClass("sapMListUl");r.writeAttribute("id",c.getId("listUl"));if(R||s){r.writeAttribute("tabindex",T);}r.addClass("sapMListShowSeparators"+c.getShowSeparators());r.addClass("sapMListMode"+c.getMode());c.getInset()&&r.addClass("sapMListInset");r.writeClasses();r.writeStyles();r.write(">");this.renderListHeadAttributes(r,c);if(R){for(var i=0;i<b.length;i++){r.renderControl(b[i]);}}if(!R&&s){this.renderNoData(r,c);}this.renderListEndAttributes(r,c);if(R||s){this.renderDummyArea(r,c,"after",T);}this.renderGrowing(r,c);if(c.getFooterText()){r.write("<footer class='sapMListFtr'");r.writeAttribute("id",c.getId("footer"));r.write(">");r.writeEscaped(c.getFooterText());r.write("</footer>");}r.write("</div>");};
a.renderContainerAttributes=function(r,c){};
a.renderListHeadAttributes=function(r,c){};
a.renderListStartAttributes=function(r,c){r.write("<ul");c.addNavSection(c.getId("listUl"));};
a.getAriaRole=function(c){return"listbox";};
a.getAriaLabelledBy=function(c){var h=c.getHeaderToolbar();if(h){return h.getTitleId();}if(c.getHeaderText()){return c.getId("header");}};
a.getAriaDescribedBy=function(c){if(c.getFooterText()){return c.getId("footer");}};
a.getAccessibilityState=function(c){var m=sap.m.ListMode,M=c.getMode(),b;if(M==m.MultiSelect){b=true;}else if(M!=m.None&&M!=m.Delete){b=false;}return{role:this.getAriaRole(c),multiselectable:b,labelledby:{value:this.getAriaLabelledBy(c),append:true},describedby:{value:this.getAriaDescribedBy(c),append:true}};};
a.renderListEndAttributes=function(r,c){r.write("</ul>");};
a.renderNoData=function(r,c){r.write("<li");r.writeAttribute("tabindex",c.getKeyboardMode()==sap.m.ListKeyboardMode.Navigation?-1:0);r.writeAttribute("id",c.getId("nodata"));r.addClass("sapMLIB sapMListNoData sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMListNoDataText");r.writeAttribute("id",c.getId("nodata-text"));r.writeClasses();r.write(">");r.writeEscaped(c.getNoDataText(true));r.write("</div>");r.write("</li>");};
a.renderDummyArea=function(r,c,A,t){r.write("<div");r.writeAttribute("id",c.getId(A));r.writeAttribute("tabindex",t);if(sap.ui.Device.browser.msie){r.addClass("sapMListDummyArea").writeClasses();}r.write("></div>");};
a.renderGrowing=function(r,c){var g=c._oGrowingDelegate;if(!g){return;}g.render(r);};
return a;},true);
sap.ui.predefine('sap/m/ListItemBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Icon'],function(q,l,C,I,a){"use strict";
var L=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:sap.m.ListType.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}}}});
L.prototype.DetailIconURI=I.getIconURI("edit");L.prototype.DeleteIconURI=I.getIconURI("sys-cancel");L.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");
L.prototype.init=function(){this._active=false;this._bGroupHeader=false;};
L.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);};
L.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var c=this.getBindingContext(m);if(c){return c.getPath();}};
L.prototype.isSelectedBoundTwoWay=function(){var b=this.getBinding("selected");if(b&&b.getBindingMode()==sap.ui.model.BindingMode.TwoWay){return true;}};
L.prototype.getList=function(){var p=this.getParent();if(p instanceof sap.m.ListBase){return p;}};
L.prototype.getListProperty=function(p,f){var o=this.getList();if(o){p=q.sap.charToUpperCase(p);return o["get"+p]();}return f;};
L.prototype.informList=function(e,p,P){var o=this.getList();if(o){var m="onItem"+e;if(o[m]){o[m](this,p,P);}}};
L.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
L.prototype.getMode=function(){return this.getListProperty("mode","");};
L.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var i=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":i.length,"aria-posinset":i.index(t)+1},A));};
L.prototype.getDeleteControl=function(){if(this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new a({id:this.getId()+"-imgDel",src:this.DeleteIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBIconDel").attachPress(function(e){this.informList("Delete");},this);return this._oDeleteControl;};
L.prototype.getDetailControl=function(){if(this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new a({id:this.getId()+"-imgDet",src:this.DetailIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this).addStyleClass("sapMLIBType sapMLIBIconDet");return this._oDetailControl;};
L.prototype.getNavigationControl=function(){if(this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
L.prototype.getSingleSelectControl=function(){if(this._oSingleSelectControl){return this._oSingleSelectControl;}this._oSingleSelectControl=new sap.m.RadioButton({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};
L.prototype.getMultiSelectControl=function(){if(this._oMultiSelectControl){return this._oMultiSelectControl;}this._oMultiSelectControl=new sap.m.CheckBox({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};
L.prototype.getModeControl=function(u){var m=this.getMode(),b=sap.m.ListMode;if(!m||m==b.None){return;}if(m==b.Delete){return this.getDeleteControl();}var s=null;if(m==b.MultiSelect){s=this.getMultiSelectControl();}else{s=this.getSingleSelectControl();}if(s&&u){s.setSelected(this.getSelected());}return s;};
L.prototype.getTypeControl=function(){var t=this.getType(),T=sap.m.ListType;if(t==T.Detail||t==T.DetailAndActive){return this.getDetailControl();}if(t==T.Navigation){return this.getNavigationControl();}};
L.prototype.destroyControls=function(c){c.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
L.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==sap.m.ListMode.SingleSelectMaster||(this.getType()!=sap.m.ListType.Inactive&&this.getType()!=sap.m.ListType.Detail);};
L.prototype.exit=function(){this._oLastFocused=null;this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
L.prototype.isSelectable=function(){var m=this.getMode();return!(m==sap.m.ListMode.None||m==sap.m.ListMode.Delete);};
L.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
L.prototype.isSelected=L.prototype.getSelected;
L.prototype.setSelected=function(s,d){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!d){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
L.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
L.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
L.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
L.prototype.isGroupHeader=function(){return this._bGroupHeader;};
L.prototype.isIncludedIntoSelection=function(){var m=this.getMode(),M=sap.m.ListMode;return(m==M.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==M.SingleSelectLeft||m==M.SingleSelect||m==M.MultiSelect)));};
L.prototype.hasActiveType=function(){var t=sap.m.ListType,T=this.getType();return(T==t.Active||T==t.Navigation||T==t.DetailAndActive);};
L.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==sap.m.ListType.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
L.prototype.ontap=function(e){if(this._eventHandledByControl){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}this.informList("Press",e.srcControl);};
L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();var t=e.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||e.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=q.sap.delayedCall(100,this,function(){this.setActive(true);e.setMarked();});};
L.prototype.ontouchmove=function(e){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-e.targetTouches[0].clientY)>10||Math.abs(this._touchedX-e.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
L.prototype.ontouchend=function(e){if(e.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this.setActive(false);});}};
L.prototype.ontouchcancel=L.prototype.ontouchend;
L.prototype._activeHandlingNav=function(){};
L.prototype._activeHandlingInheritor=function(){};
L.prototype._inactiveHandlingInheritor=function(){};
L.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
L.prototype.onsapspace=function(e){if(e.srcControl!==this){return;}e.preventDefault();if(e.isMarked()||!this.isSelectable()){return;}if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}e.setMarked();};
L.prototype.onsapenter=function(e){var o=this.getList();if(e.isMarked()||!o){return;}var k=sap.m.ListKeyboardMode;if(e.srcControl!==this&&o.getKeyboardMode()==k.Edit){o.setKeyboardMode(k.Navigation);this._switchFocus(e);return;}if(e.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(e);}else if(this.hasActiveType()){e.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}o.onItemPress(this,e.srcControl);};
L.prototype.onsapdelete=function(e){if(e.isMarked()||e.srcControl!==this||this.getMode()!=sap.m.ListMode.Delete){return;}this.informList("Delete");e.preventDefault();e.setMarked();};
L.prototype._switchFocus=function(e){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(e.srcControl!==this){o._iLastFocusPosOfItem=t.index(e.target);this.focus();}else if(t.length){var f=o._iLastFocusPosOfItem||0;f=t[f]?f:-1;t.eq(f).focus();}e.preventDefault();e.setMarked();};
L.prototype.onkeydown=function(e){if(e.isMarked()){return;}var k=q.sap.KeyCodes;if(e.which==k.F7){this._switchFocus(e);return;}if(e.which==k.F2){if(e.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();e.preventDefault();e.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);var K=sap.m.ListKeyboardMode;o.setKeyboardMode(o.getKeyboardMode()==K.Edit?K.Navigation:K.Edit);this._switchFocus(e);}}}};
L.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
L.prototype.onsaptabnext=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}var b=this.getTabbables().get(-1)||this.getDomRef();if(e.target===b){o.forwardTab(true);e.setMarked();}};
L.prototype.onsaptabprevious=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}if(e.target===this.getDomRef()){o.forwardTab(false);e.setMarked();}};
L.prototype.onfocusin=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit||e.srcControl===this||!q(e.target).is(":sapFocusable")){return;}q.sap.delayedCall(0,o,"setItemFocusable",[this]);e.setMarked();};
L.prototype.onsapup=function(e){if(e.isMarked()||e.srcControl===this||this.getListProperty("keyboardMode")===sap.m.ListKeyboardMode.Navigation){return;}this.informList("ArrowUpDown",e);};
L.prototype.onsapdown=L.prototype.onsapup;return L;},true);
sap.ui.predefine('sap/m/ListItemBaseRenderer',['jquery.sap.global','sap/ui/core/IconPool','sap/ui/core/theming/Parameters'],function(q,I,P){"use strict";var L={};var a={};
L.renderInvisible=function(r,l){this.openItemTag(r,l);r.writeInvisiblePlaceholderData(l);r.write(">");this.closeItemTag(r,l);};
L.isModeMatched=function(m,o){var O=(sap.m.ListBaseRenderer||{}).ModeOrder||{};return(O[m]==o);};
L.renderMode=function(r,l,o){var m=l.getMode();if(!this.isModeMatched(m,o)){return;}var M=l.getModeControl(true);if(M){this.renderModeContent(r,l,M);}};
L.renderModeContent=function(r,l,m){var M=l.getMode(),b={Delete:"D",MultiSelect:"M",SingleSelect:"S",SingleSelectLeft:"SL"};r.write("<div");r.writeAttribute("id",l.getId()+"-mode");r.addClass("sapMLIBSelect"+b[M]);this.decorateMode(r,l);r.writeClasses();r.writeStyles();r.write(">");r.renderControl(m);r.write("</div>");};
L.decorateMode=function(r,l){if(!sap.ui.getCore().getConfiguration().getAnimation()||!l.getListProperty("modeAnimationOn")){return;}var m=l.getMode(),s=l.getListProperty("lastMode");if(!s||s==m){return;}if(m==sap.m.ListMode.None){r.addClass("sapMLIBUnselectAnimation");}else{r.addClass("sapMLIBSelectAnimation");}};
L.renderCounter=function(r,l){var c=l.getCounter();if(c){this.renderCounterContent(r,l,c);}};
L.renderCounterContent=function(r,l,c){r.write("<div");r.writeAttribute("id",l.getId()+"-counter");var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",c);r.writeAttribute("aria-label",A);r.addClass("sapMLIBCounter");r.writeClasses();r.write(">");r.write(c);r.write("</div>");};
L.renderType=function(r,l){var t=l.getTypeControl();if(t){r.renderControl(t);}};
L.openItemTag=function(r,l){r.write("<li");};
L.closeItemTag=function(r,l){r.write("</li>");};
L.handleNoFlex=function(r,l){return!q.support.hasFlexBoxSupport;};
L.renderTabIndex=function(r,l){r.writeAttribute("tabindex","-1");};
L.renderTooltip=function(r,l){var t=l.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
L.addFocusableClasses=function(r,l){if(sap.ui.Device.system.desktop){r.addClass("sapMLIBFocusable");this.addLegacyOutlineClass(r,l);}};
L.addLegacyOutlineClass=function(r,l){if(sap.ui.Device.browser.msie){r.addClass("sapMLIBLegacyOutline");}};
L.getAriaAnnouncement=function(k,b){if(a[k]){return a[k];}b=b||"LIST_ITEM_"+k.toUpperCase();a[k]=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(b)}).toStatic().getId();return a[k];};
L.getAriaRole=function(l){return"option";};
L.getAriaLabelledBy=function(l){if(l.getAriaLabelledBy().length){return l.getId();}};
L.getAriaDescribedBy=function(l){var d=[],t=l.getType(),T=sap.m.ListType;if(l.getListProperty("showUnread")&&l.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(l.getMode()==sap.m.ListMode.Delete){d.push(this.getAriaAnnouncement("deletable"));}if(t==T.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==T.Detail||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==T.Active||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
L.getAccessibilityState=function(l){var A=this.getAriaLabelledBy(l),s=this.getAriaDescribedBy(l),m={role:this.getAriaRole(l)};if(l.isSelectable()){m.selected=l.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}return m;};
L.renderLIContent=function(r,l){};
L.renderLIAttributes=function(r,l){};
L.renderLIContentWrapper=function(r,l){r.write('<div class="sapMLIBContent"');r.writeAttribute("id",l.getId()+"-content");r.write(">");if(this.handleNoFlex()){r.write('<div class="sapMLIBContentNF">');}this.renderLIContent(r,l);if(this.handleNoFlex()){r.write('</div>');}r.write('</div>');};
L.render=function(r,l){if(!l.getVisible()){this.renderInvisible(r,l);return false;}this.openItemTag(r,l);r.writeControlData(l);r.addClass("sapMLIB");r.addClass("sapMLIB-CTX");r.addClass("sapMLIBShowSeparator");r.addClass("sapMLIBType"+l.getType());if(sap.ui.Device.system.desktop&&l.isActionable()){r.addClass("sapMLIBActionable");r.addClass("sapMLIBHoverable");}if(l.getSelected()){r.addClass("sapMLIBSelected");}if(this.handleNoFlex()){r.addClass("sapMLIBNoFlex");}if(l.getListProperty("showUnread")&&l.getUnread()){r.addClass("sapMLIBUnread");}this.addFocusableClasses(r,l);this.renderTooltip(r,l);this.renderTabIndex(r,l);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(l,this.getAccessibilityState(l));}this.renderLIAttributes(r,l);r.writeClasses();r.writeStyles();r.write(">");this.renderMode(r,l,-1);this.renderLIContentWrapper(r,l);this.renderCounter(r,l);this.renderType(r,l);this.renderMode(r,l,1);this.closeItemTag(r,l);};
return L;},true);
sap.ui.predefine('sap/m/ListRenderer',['jquery.sap.global','sap/ui/core/Renderer','./ListBaseRenderer'],function(q,R,L){"use strict";var a=R.extend(L);
a.render=function(r,c){if(!c.getColumns().length){L.render.call(this,r,c);return;}if(c._isColumnsIncompatible()){q.sap.log.warning("Does not render sap.m.List#"+c.getId()+" with columns aggregation when compatibility version is 1.16 or higher. Instead use sap.m.Table control!");return;}q.sap.require("sap.m.TableRenderer");var o=q.extend({},this,sap.m.TableRenderer);L.render.call(o,r,c);};
return a;},true);
sap.ui.predefine('sap/m/MaskInput',['jquery.sap.global','./InputBase','./MaskInputRule','sap/ui/core/Control'],function(q,I,M,C){"use strict";
var a=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}}}});
var E='^';
a.prototype.init=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._setDefaultRules();};
a.prototype.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};
a.prototype.onBeforeRendering=function(){var v=this._validateDependencies();if(v){q.sap.log.warning("Invalid mask input: "+v);}I.prototype.onBeforeRendering.apply(this,arguments);};
a.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onfocusin=function(e){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);};
a.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();};
a.prototype.oninput=function(e){I.prototype.oninput.apply(this,arguments);this._applyMask();this._positionCaret(false);};
a.prototype.onkeypress=function(e){this._keyPressHandler(e);};
a.prototype.onkeydown=function(e){var k=this._parseKeyBoardEvent(e),B=sap.ui.Device.browser,i;i=(k.bBackspace||k.bDelete)&&B.msie&&B.version<10;if(!i){I.prototype.onkeydown.apply(this,arguments);}this._keyDownHandler(e,k);};
a.prototype.onsapenter=function(e){};
a.prototype.onsapfocusleave=function(e){};
a.prototype.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v&&v.length){this._applyRules(v);}return this;};
a.prototype.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};
a.prototype.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};
a.prototype._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){q.sap.log.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};
a.prototype.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){q.sap.log.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){q.sap.log.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};
a.prototype.setMask=function(m){if(!m){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";q.sap.log.warning(e);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};
a.prototype._isCharAllowed=function(c,i){return this._oRules.applyCharAt(c,i);};
a.prototype._feedReplaceChar=function(c,p,s){return c;};
var b=function(c){this._aInitial=c.slice(0);this._aContent=c;};
b.prototype.setCharAt=function(c,p){this._aContent[p]=c;};
b.prototype.charAt=function(p){return this._aContent[p];};
b.prototype.toString=function(){return this._aContent.join('');};
b.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};
b.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};
b.prototype.getSize=function(){return this._aContent.length;};
var T=function(r){this._aRules=r;};
T.prototype.nextTo=function(c){if(typeof c==="undefined"){c=-1;}do{c++;}while(c<this._aRules.length&&!this._aRules[c]);return c;};
T.prototype.previousTo=function(c){do{c--;}while(!this._aRules[c]&&c>0);return c;};
T.prototype.hasRuleAt=function(i){return!!this._aRules[i];};
T.prototype.applyCharAt=function(c,i){return this._aRules[i].test(c);};
a.prototype._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};
a.prototype._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],e=[];if(!this.getMask()){e.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),c=s!==p,d;d=!m.some(function(S){return s===S;});m.push(s);if(!c){e.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!d){e.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return c&&d;});}return e.length?e.join(". "):null;};
a.prototype._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);}};
a.prototype._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){q.sap.log.error(m+" is not a valid mask rule symbol");return null;}q.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};
a.prototype._getTextSelection=function(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return;}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};
a.prototype._setCursorPosition=function(p){return q(this.getFocusDomRef()).cursorPos(p);};
a.prototype._getCursorPosition=function(){return q(this.getFocusDomRef()).cursorPos();};
a.prototype._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),c=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(c,p,r,s),t=this._buildRules(c,r,s);this._oTempValue=new b(i);this._iMaskLength=t.length;this._oRules=new T(t);this._iUserInputStartPosition=this._oRules.nextTo();};
a.prototype._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,c=(m)?m.split(""):[],i;for(i=0;i<l;i++){c.splice(s[i],1);}return c;};
a.prototype._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,L=false;for(i=0;i<l;i++){if(m[i]===E&&!L){s.push(i-p);L=true;p++;}else{L=false;}}return s;};
a.prototype._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};
a.prototype._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};
a.prototype._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};
a.prototype._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};
a.prototype._applyRules=function(i){var c,d=0,m,p=this.getPlaceholderSymbol(),e;for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);e=false;if(i.length){do{c=i.charAt(d);d++;if(this._oRules.applyCharAt(c,m)){this._oTempValue.setCharAt(c,m);e=true;}}while(!e&&(d<i.length));}if(!e){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(d)){d++;}}}};
a.prototype._keyPressHandler=function(e){if(!this.getEditable()){return;}var s=this._getTextSelection(),p,c,k=this._parseKeyBoardEvent(e);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){c=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(c,p);}e.preventDefault();}};
a.prototype.oncut=function(e){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),B=s.iFrom,i=s.iTo;I.prototype.oncut(e);if(!s.bHasSelection){return;}i=i-1;this._resetTempValue(B,i);q.sap.delayedCall(m,this,function updateDomAndCursor(v,p,o){this._oTempValue._aContent=o;this.updateDomValue(v);q.sap.delayedCall(m,this,this._setCursorPosition,[p]);},[this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,B),this._oTempValue._aContent.slice(0)]);};
a.prototype._keyDownHandler=function(e,k){var d,s,B,i,c,n,k=k||this._parseKeyBoardEvent(e);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){c=this._getCursorPosition();s=this._getTextSelection();d=this._determineArrowKeyDirection(k,s);if(this._isRtlMode()&&s.bHasSelection){n=this._determineRtlCaretPositionFromSelection(d);}else{n=this._oRules[d](c);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,d);}this._setCursorPosition(n);e.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);e.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(e);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){s=this._getTextSelection();B=s.iFrom;i=s.iTo;if(!s.bHasSelection){if(k.bBackspace){B=this._oRules.previousTo(B);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){i=i-1;}this._resetTempValue(B,i);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,B));e.preventDefault();}};
a.prototype._feedNextString=function(n,p){var N,A=false,c=n.split(""),s;while(c.length){s=c.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};
a.prototype._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,e,c;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";e=!this._sOldInputValue;c=!n;if(e&&(c||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};
a.prototype._buildMaskValueArray=function(m,p,r,s){return m.map(function(c,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(c,r);return(n&&R)?p:c;},this);};
a.prototype._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};
a.prototype._parseKeyBoardEvent=function(e){var p=e.which||e.keyCode,k=q.sap.KeyCodes,A=p===k.ARROW_RIGHT,c=p===k.ARROW_LEFT,s=e.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:e.ctrlKey,bAltKey:e.altKey,bMetaKey:e.metaKey,bShift:s,bInsert:p===q.sap.KeyCodes.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(sap.ui.Device.system.phone&&sap.ui.Device.os.ios&&p===127),bArrowRight:A,bArrowLeft:c,bHome:p===q.sap.KeyCodes.HOME,bEnd:p===q.sap.KeyCodes.END,bShiftLeftOrRightArrow:s&&(c||A),bBeforeSpace:p<k.SPACE};};
a.prototype._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),e;clearTimeout(this._iCaretTimeoutId);e=this._findFirstPlaceholderPosition();if(e<0){e=m.length;}this._iCaretTimeoutId=q.sap.delayedCall(i,this,function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(e===(m.length))){this.selectText(0,e);}else{this._setCursorPosition(e);}});};
a.prototype._getMinBrowserDelay=function(){return!sap.ui.Device.browser.msie?4:50;};
a.prototype._isValidInput=function(s){var l=s.length,i=0,c;for(;i<l;i++){c=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(c,i)&&c!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&c!==this._oTempValue.charAt(i)){return false;}}return true;};
a.prototype._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',c=new RegExp('^[^'+l+']*['+r+']');return c.test(s);};
a.prototype._fixWebkitBorderPositions=function(c,d){var t=this._oTempValue.toString().length;if(d==='nextTo'){if(c===0||c===t||c===1){c=0;}else if(c===t+1){c=1;}}else{if(c===0||c===t-1){c=t;}else if(c===-1||c===t){c=t-1;}}return c;};
a.prototype._containsRtlChars=function(){var t=this._oTempValue.toString(),c=false;for(var i=0;i<t.length;i++){c=this._isRtlChar(t[i]);}return c;};
a.prototype._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===sap.ui.core.TextDirection.RTL);};
a.prototype._isWebkitProblematicCase=function(){return(sap.ui.Device.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars());};
a.prototype._determineArrowKeyDirection=function(k,s){var d;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){d='nextTo';}else{d='previousTo';}}else{if(k.bArrowRight){d='previousTo';}else{d='nextTo';}}return d;};
a.prototype._determineRtlCaretPositionFromSelection=function(d,w){var n,s=this._getTextSelection();if(w){if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}else{if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}}else{if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}else{if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}}return n;};
return a;},true);
sap.ui.predefine('sap/m/MaskInputRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var M=R.extend(I);
M.getLabelledByAnnouncement=function(c){var m=c.getMask(),p=c.getPlaceholder()||"",t=c.getTooltip_AsString()||"",r,s,a="";if(m&&m.length){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");s=r.getText("MASKINPUT_SCREENREADER_TAG");if(t){t=" "+t+" ";}if(p){p=" "+p+" ";}a=s+p+t;return a;}return I.getLabelledByAnnouncement.apply(this,arguments);};
M.getDescribedByAnnouncement=function(c){var m=c.getMask(),s=c.getPlaceholderSymbol(),r,a="";if(m.length&&s){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a=r.getText("MASKINPUT_SCREENREADER_DESCRIPTION",[s,m]);return jQuery.trim(a);}return I.getDescribedByAnnouncement.apply(this,arguments);};
return M;},true);
sap.ui.predefine('sap/m/MaskInputRule',['jquery.sap.global','sap/ui/core/Element'],function(q,E){"use strict";
var M=E.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});
M.prototype.setMaskFormatSymbol=function(n){var i=v.call(this,n);if(i){this.setProperty("maskFormatSymbol",n);}return this;};
M.prototype.setRegex=function(n){var i=a.call(this,n);if(i){this.setProperty("regex",n);}return this;};
M.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex();};
function v(n){if(/^.$/i.test(n)){return true;}q.sap.log.error("The mask format symbol '"+n+"' is not valid");return false;}
function a(r){if(/.+/i.test(r)){return true;}q.sap.log.error("The regex value '"+r+"' is not valid");return false;}
return M;},true);
sap.ui.predefine('sap/m/Menu',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,D,N,L,P,M,U,a,E){"use strict";
var b=C.extend("sap.m.Menu",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});
E.call(b.prototype);b.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';b.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';
b.prototype.init=function(){if(a.system.phone){this._initDialog();}this._bIsInitialized=false;};
b.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};
b.prototype.invalidate=function(){};
b.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};
b.prototype.openBy=function(o,w){if(a.system.phone){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var e=sap.ui.core.Popup.Dock;this._getMenu().open(w,o,e.BeginTop,e.BeginBottom,o,"0 -2");}};
b.prototype.close=function(){if(sap.ui.Device.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};
b.prototype._initDialog=function(){var d=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});d.addStyleClass("sapMRespMenuDialog");this.setAggregation("_dialog",d,true);};
b.prototype._getDialog=function(){return this.getAggregation("_dialog");};
b.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};
b.prototype._initMenuForItems=function(i,p){var m=new U();m.isCozy=this._isMenuCozy.bind(this,m);m.addStyleClass('sapMMenu');i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};
b.prototype._menuClosed=function(){this.fireClosed();};
b.prototype._getMenu=function(){return this.getAggregation("_menu");};
b.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:f.bind(this)});};
function f(){this._getDialog().close();}
b.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};
b.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};
b.prototype._initAllPages=function(){this._initPageForParent(this);};
b.prototype._initPageForParent=function(p){var i=p.getItems(),d=p instanceof sap.m.Menu,s=d?p.getTitle():p.getText(),o=new L({mode:sap.m.ListMode.None}),e=new P({title:s,showNavButton:!d,content:o});if(!d){this._setBackButtonTooltipForPageWithParent(p,e);}e.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(e);i.forEach(function(I){this._addListItemFromItem(I,e);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return e;};
b.prototype._handleListItemPress=function(e){var o=e.getParameter("listItem"),m=sap.ui.getCore().byId(o.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}};
b.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var d=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=d instanceof sap.m.Menu?d.getTitle():d.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};
b.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:sap.m.ListType.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i});};
b.prototype._createVisualMenuItemFromItem=function(i){return new sap.ui.unified.MenuItem({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection()});};
b.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var e=['aggregationChanged','propertyChanged'];e.forEach(function(s){var d='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[d],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};
b.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var e=['aggregationChanged','propertyChanged'];e.forEach(function(s){var d='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[d],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};
b.prototype._addVisualItemFromItem=function(i,o,I){if(!o){return;}if(a.system.phone){this._addListItemFromItem(i,o,I);var d=o.getContent()[0];this._updateListInset(d);}else{this._addVisualMenuItemFromItem(i,o,I);}};
b.prototype._updateListInset=function(o){var h=false,I="sapMListIcons",d=o.getItems();for(var i=0;i<d.length;i++){if(d[i].getIcon()){h=true;break;}}if(h){o.addStyleClass(I);}else{o.removeStyleClass(I);}};
b.prototype._handleMenuItemSelect=function(e){var u=e.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}};
b.prototype._generateListItemId=function(m){return m+b.LIST_ITEMS_ID_SUFFIX;};
b.prototype._generateUnifiedMenuItemId=function(m){return m+b.UNIFIED_MENU_ITEMS_ID_SUFFIX;};
b.prototype._findMenuItemByUnfdMenuItem=function(u){var d=[],o=u,I,e,i;do{d.push(o.getId());o=o.getParent().getParent();}while(o instanceof sap.ui.unified.MenuItem);I=this.getItems();do{e=d.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===e){if(d.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(d.length);return null;};
b.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(c(m.oOpenerRef)){return true;}return false;};
function c(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}
b.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent());}return this;};
b.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent(),i);}return this;};
b.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};
b.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};
b.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m,o;if(v){m=v.getParent();m.removeItem(v);if(a.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){o=sap.ui.getCore().byId(i._getVisualParent());this._getNavContainer().removePage(o);o.destroy();if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};
b.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};
b.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};
b.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};
b.prototype._onPropertyChanged=function(e){var p=e.getParameter("propertyKey"),o=e.getParameter("propertyValue");if(a.system.phone){if(p==='text'){p='title';}var s=this._generateListItemId(e.getSource().getId());!!s&&sap.ui.getCore().byId(s).setProperty(p,o);if(this._getDialog().isOpen()){this._getDialog().close();}}else{var u=this._generateUnifiedMenuItemId(e.getSource().getId());!!u&&sap.ui.getCore().byId(u).setProperty(p,o);}};
b.prototype._onAggregationChanged=function(e){var A=e.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(e);break;}};
b.prototype._onItemsAggregationChanged=function(e){var I=e.getSource(),m=e.getParameter("methodName"),d=e.getParameter("methodParams"),g;if(m==="add"||m==="insert"){if(m==="insert"){g=d.index;}this._addOrInsertItem(I,d.item,g);}if(m==="remove"){this._removeVisualItem(d.item,I);}if(m==="removeall"){for(var i=0;i<d.items.length;i++){this._removeVisualItem(d.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};
b.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._addVisualItemFromItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(a.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};
b.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};
b.prototype.getDomRefId=function(){if(a.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};
return b;},true);
sap.ui.predefine('sap/m/MenuButton',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./SplitButton','./Dialog','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,S,D,a,E){"use strict";
var M=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:sap.m.MenuButtonMode.Regular},useDefaultActionOnly:{type:"Boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu",bindable:"bindable"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{defaultAction:{}}}});
E.call(M.prototype);
M.prototype.init=function(){this._initButtonControl();};
M.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialWidth){this._iInitialWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};
M.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};
M.prototype.onAfterRendering=function(){if(this._isSplitButton()&&!this._iInitialWidth){this._iInitialWidth=this.$().outerWidth()+1;}this._setAriaHasPopup();};
M.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};
M.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&k!=="buttonMode"&&k!=="useDefaultActionOnly"&&k!=="width"){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};
M.prototype._initButton=function(){var b=new B({width:"100%"});b.attachPress(this._handleButtonPress,this);return b;};
M.prototype._initSplitButton=function(){var b=new S({width:"100%"});b.attachPress(this._handleActionPress,this);b.attachArrowPress(this._handleButtonPress,this);return b;};
M.prototype._initButtonControl=function(){var b;if(this._isSplitButton()){b=this._initSplitButton();}else{b=this._initButton();}this.setAggregation("_button",b,true);};
M.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};
M.prototype._getButtonControl=function(){return this.getAggregation("_button");};
M.prototype._handleButtonPress=function(w){var m=this.getMenu();if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}m.openBy(this,w);this._writeAriaAttributes();if(this._isSplitButton()&&!a.system.phone){this._getButtonControl().setArrowState(true);}};
M.prototype._handleActionPress=function(){var L=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&L){o=sap.ui.getCore().byId(L);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};
M.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}};
M.prototype._menuItemSelected=function(e){var m=e.getParameter("item");if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};
M.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};
M.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};
M.prototype._isSplitButton=function(){return this.getButtonMode()===sap.m.MenuButtonMode.Split;};
M.prototype.setProperty=function(p,v,s){function i(t){var T=[sap.m.ButtonType.Up,sap.m.ButtonType.Back,sap.m.ButtonType.Unstyled];return T.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};
M.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};
M.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};
M.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);};
M.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);};
M.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};
M.prototype.onsapup=function(e){this.openMenuByKeyboard();};
M.prototype.onsapdown=function(e){this.openMenuByKeyboard();};
M.prototype.onsapupmodifiers=function(e){this.openMenuByKeyboard();};
M.prototype.onsapdownmodifiers=function(e){this.openMenuByKeyboard();};
M.prototype.onsapshow=function(e){this.openMenuByKeyboard();!!e&&e.preventDefault();};
M.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};
M.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};
return M;},true);
sap.ui.predefine('sap/m/MenuButtonRenderer',['jquery.sap.global'],function(q){"use strict";var M={};M.CSS_CLASS="sapMMenuBtn";
M.render=function(r,m){var w=m.getWidth();r.write("<div");r.writeControlData(m);this.writeAriaAttributes(r,m);r.addClass(M.CSS_CLASS);r.addClass(M.CSS_CLASS+m.getButtonMode());r.writeClasses();if(w!=""||w.toLowerCase()==="auto"){r.addStyle("width",w);}else if(m._isSplitButton()&&m._iInitialWidth){r.addStyle("width",m._iInitialWidth+"px");}r.writeStyles();r.write(">");r.renderControl(m._getButtonControl());r.write("</div>");};
M.writeAriaAttributes=function(r,m){r.writeAttribute("aria-haspopup","true");};
return M;},true);
sap.ui.predefine('sap/m/MenuItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var M=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"mixed"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
M.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
M.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
M.prototype.addAggregation=function(a,o,s){I.prototype.addAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"add",methodParams:{item:o}});return this;};
M.prototype.insertAggregation=function(a,o,i,s){I.prototype.insertAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"insert",methodParams:{item:o,index:i}});return this;};
M.prototype.removeAggregation=function(a,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"remove",methodParams:{item:O}});return O;};
M.prototype.removeAllAggregation=function(a,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"removeall",methodParams:{items:o}});return o;};
M.prototype.destroyAggregation=function(a,s){this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
M.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
M.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
M.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
M.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
M.prototype._getVisualChild=function(){return this._sVisualChild;};
M.prototype._getVisualParent=function(){return this._sVisualParent;};
M.prototype._getVisualControl=function(){return this._sVisualControl;};
return M;},true);
sap.ui.predefine('sap/m/MenuListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool'],function(q,L,l,E,I){"use strict";
var M=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
M.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
M.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
M.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
M.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return M;},false);
sap.ui.predefine('sap/m/MenuListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var M=R.extend(L);
M.openItemTag=function(r,l){if(l.getStartsSection()){r.write("<li ");r.write("role=\"separator\" ");r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}L.openItemTag(r,l);};
M.renderLIAttributes=function(r,l){r.addClass("sapMSLI");if(l.getIcon()){r.addClass("sapMSLIIcon");}if(l.getType()==sap.m.ListType.Detail||l.getType()==sap.m.ListType.DetailAndActive){r.addClass("sapMSLIDetail");}if(l._hasSubItems()){r.addClass("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,l){var t=l.getTitleTextDirection();if(l.getIcon()){r.renderControl(l._getImage((l.getId()+"-img"),"sapMMenuLIImgThumb",l.getIcon(),l.getIconDensityAware()));}r.write("<div");r.addClass("sapMSLIDiv");r.addClass("sapMSLITitleDiv");r.writeClasses();r.write(">");if(l._bNoFlex){r.write('<div class="sapMLIBNoFlex">');}r.write("<div");r.addClass("sapMSLITitleOnly");r.writeClasses();if(t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());r.write("</div>");if(l._bNoFlex){r.write('</div>');}r.write("</div>");if(l._hasSubItems()){r.renderControl(l._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MessageBox',['jquery.sap.global','./Button','./Dialog','./Text','./TextArea','./Link','./VBox','sap/ui/core/IconPool'],function(q,B,D,T,a,L,V,I){"use strict";var M={};M.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};M.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};(function(){var A=M.Action,b=M.Icon,c={"INFORMATION":"sapMMessageBoxInfo","WARNING":"sapMMessageBoxWarning","ERROR":"sapMMessageBoxError","SUCCESS":"sapMMessageBoxSuccess","QUESTION":"sapMMessageBoxQuestion"},m={"INFORMATION":I.getIconURI("message-information"),"WARNING":I.getIconURI("message-warning"),"ERROR":I.getIconURI("message-error"),"SUCCESS":I.getIconURI("message-success"),"QUESTION":I.getIconURI("question-mark")};var _=function(){if(sap.m.MessageBox._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){sap.m.MessageBox._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}};
M.show=function(v,o){var d,e,f,r=null,t=this,g=[],i,s,h,j,C,k,l,n={id:sap.ui.core.ElementMetadata.uid("mbox"),initialFocus:null,textDirection:sap.ui.core.TextDirection.Inherit,verticalScrolling:true,horizontalScrolling:true,details:""};_();if(typeof o==="string"||arguments.length>2){s=arguments[1];h=arguments[2];j=arguments[3];C=arguments[4];k=arguments[5];l=arguments[6];o={icon:s,title:h,actions:j,onClose:C,id:k,styleClass:l};}if(o&&o.hasOwnProperty("details")){n.icon=sap.m.MessageBox.Icon.INFORMATION;n.actions=[A.OK,A.CANCEL];o=q.extend({},n,o);if(typeof o.details=='object'){o.details=JSON.stringify(o.details,null,'\t');}}o=q.extend({},n,o);if(typeof o.actions!=="undefined"&&!q.isArray(o.actions)){o.actions=[o.actions];}if(!o.actions||o.actions.length===0){o.actions=[A.OK];}function p(z){var E;if(M.Action.hasOwnProperty(z)){E=t._rb.getText("MSGBOX_"+z);}var F=new B({id:sap.ui.core.ElementMetadata.uid("mbox-btn-"),text:E||z,press:function(){r=z;d.close();}});return F;}for(i=0;i<o.actions.length;i++){g.push(p(o.actions[i]));}function u(o,e){var z=new a({editable:false,visible:false,rows:3}).setValue(o.details);var E=new L({text:t._rb.getText("MSGBOX_LINK_TITLE"),press:function(){z.setVisible(true);this.setVisible(false);d._setInitialFocus();}});E.addStyleClass("sapMMessageBoxLinkText");z.addStyleClass("sapMMessageBoxDetails");return new V({items:[e,E,z]});}function w(){if(typeof o.onClose==="function"){o.onClose(r);}d.detachAfterClose(w);d.destroy();}function x(){var i=0;var z=null;if(o.initialFocus){if(o.initialFocus instanceof sap.ui.core.Control){z=o.initialFocus;}if(typeof o.initialFocus==="string"){for(i=0;i<g.length;i++){if(M.Action.hasOwnProperty(o.initialFocus)){if(t._rb.getText("MSGBOX_"+o.initialFocus).toLowerCase()===g[i].getText().toLowerCase()){z=g[i];break;}}else{if(o.initialFocus.toLowerCase()===g[i].getText().toLowerCase()){z=g[i];break;}}}}}return z;}if(typeof(v)==="string"){f=new T({textDirection:o.textDirection}).setText(v).addStyleClass("sapMMsgBoxText");e=f;}else if(v instanceof sap.ui.core.Control){f=v.addStyleClass("sapMMsgBoxText");}if(o&&o.hasOwnProperty("details")&&o.details!==""){f=u(o,f);}function y(){if(sap.ui.getCore().getConfiguration().getAccessibility()){d.$().attr("role","alertdialog");}}d=new D({id:o.id,type:sap.m.DialogType.Message,title:o.title,content:f,icon:m[o.icon],initialFocus:x(),verticalScrolling:o.verticalScrolling,horizontalScrolling:o.horizontalScrolling,afterOpen:y,afterClose:w,buttons:g,ariaLabelledBy:e?e.getId():undefined});if(c[o.icon]){d.addStyleClass(c[o.icon]);}if(o.styleClass){d.addStyleClass(o.styleClass);}d.open();};
M.alert=function(v,o){_();var d={icon:b.NONE,title:this._rb.getText("MSGBOX_TITLE_ALERT"),actions:A.OK,id:sap.ui.core.ElementMetadata.uid("alert"),initialFocus:null},C,t,s,S;if(typeof o==="function"||arguments.length>2){C=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:C,title:t,id:s,styleClass:S};}o=q.extend({},d,o);return M.show(v,o);};
M.confirm=function(v,o){_();var d={icon:b.QUESTION,title:this._rb.getText("MSGBOX_TITLE_CONFIRM"),actions:[A.OK,A.CANCEL],id:sap.ui.core.ElementMetadata.uid("confirm"),initialFocus:null},C,t,s,S;if(typeof o==="function"||arguments.length>2){C=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:C,title:t,id:s,styleClass:S};}o=q.extend({},d,o);return M.show(v,o);};
M.error=function(v,o){_();var d={icon:b.ERROR,title:this._rb.getText("MSGBOX_TITLE_ERROR"),actions:[A.CLOSE],id:sap.ui.core.ElementMetadata.uid("error"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.information=function(v,o){_();var d={icon:b.INFORMATION,title:this._rb.getText("MSGBOX_TITLE_INFO"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("info"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.warning=function(v,o){_();var d={icon:b.WARNING,title:this._rb.getText("MSGBOX_TITLE_WARNING"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("warning"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.success=function(v,o){_();var d={icon:b.SUCCESS,title:this._rb.getText("MSGBOX_TITLE_SUCCESS"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("success"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
}());return M;},true);
sap.ui.predefine('sap/m/MessagePage',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var M=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}}}});
M.prototype.init=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setAggregation("_page",new sap.m.Page({showHeader:this.getShowHeader(),navButtonPress:q.proxy(function(){this.fireNavButtonPress();},this)}));this.setProperty("text",b.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",b.getText("MESSAGE_PAGE_DESCRIPTION"),true);};
M.prototype.onBeforeRendering=function(){if(!(this._oText&&this._oDescription)){this._addPageContent();}};
M.prototype.exit=function(){var p=this.getAggregation("_page");if(p){p.destroy();p=null;}if(this._oText){this._oText=null;}if(this._oDescription){this._oDescription=null;}if(this._oIconControl){this._oIconControl=null;}};
M.prototype.setTitle=function(t){this.setProperty("title",t,true);this.getAggregation("_page").setTitle(t);};
M.prototype.setText=function(t){this.setProperty("text",t,true);this._oText&&this._oText.setText(t);};
M.prototype.setDescription=function(d){this.setProperty("description",d,true);this._oDescription&&this._oDescription.setText(d);};
M.prototype.setShowHeader=function(s){this.setProperty("showHeader",s,true);this.getAggregation("_page").setShowHeader(s);};
M.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);this.getAggregation("_page").setShowNavButton(s);};
M.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);this._oText&&this._oText.setTextDirection(t);this._oDescription&&this._oDescription.setTextDirection(t);};
M.prototype.setIcon=function(i){var o=this.getIcon();this.setProperty("icon",i,true);if(this._oIconControl){if(o!==i&&I.isIconURI(o)!=I.isIconURI(i)){var p=this.getAggregation("_page");p.removeContent(this._oIconControl);this._oIconControl.destroy();p.insertContent(this._getIconControl(),0);}else{this._oIconControl.setSrc(i);}}};
M.prototype._addPageContent=function(){var p=this.getAggregation("_page");if(this.getAggregation("customText")){this._oText=this.getAggregation("customText");}else{this._oText=new sap.m.Text({text:this.getText(),textAlign:sap.ui.core.TextAlign.Center,textDirection:this.getTextDirection()});}if(this.getAggregation("customDescription")){this._oDescription=this.getAggregation("customDescription");}else{this._oDescription=new sap.m.Text({text:this.getDescription(),textAlign:sap.ui.core.TextAlign.Center,textDirection:this.getTextDirection()});}p.addContent(this._getIconControl());p.addContent(this._oText.addStyleClass("sapMMessagePageMainText"));p.addContent(this._oDescription.addStyleClass("sapMMessagePageDescription"));};
M.prototype._getIconControl=function(){this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",useIconTooltip:true,decorative:false},sap.m.Image).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};
M.prototype._getAnyHeader=function(){return this._getInternalHeader();};
M.prototype._getInternalHeader=function(){return this.getAggregation("_page").getAggregation("_internalHeader");};
return M;},true);
sap.ui.predefine('sap/m/MessagePageRenderer',['jquery.sap.global'],function(q){"use strict";var M={};
M.render=function(r,m){r.write("<div");r.writeControlData(m);r.addClass("sapMMessagePage");r.writeClasses();r.write(">");r.renderControl(m.getAggregation("_page"));r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MessagePopover',["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","sap/ui/core/Control","./PlacementType","sap/ui/core/IconPool","sap/ui/core/HTML","./Text","sap/ui/core/Icon","./SegmentedButton","./Page","./NavContainer","./semantic/SemanticPage","./Popover","./MessagePopoverItem","jquery.sap.dom"],function(q,R,B,T,a,b,L,S,l,C,P,I,H,c,d,e,f,N,g,h,M){"use strict";
var j=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessagePopoverItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});
var k="sapMMsgPopover",m={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},n=["all","error","warning","success","information"],A=["asyncDescriptionHandler","asyncURLHandler"],D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(o){i.item.setDescription(o);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};
j.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};
j.prototype.init=function(){var t=this;var p;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:"440px",placement:this.getPlacement(),showCloseButton:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(k);this._createNavigationPages();this._createLists();p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onkeypress:this._onkeypress},this);if(sap.ui.Device.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};
j.prototype.exit=function(){this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;if(this._oLists){this._destroyLists();}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
j.prototype.onBeforeRenderingPopover=function(){var i=this.getHeaderButton();if(i){this._oListHeader.insertContent(i,2);}if(!this.getItems().length){this._makeAutomaticBinding();}if(this._bItemsChanged){this._clearLists();this._fillLists(this.getItems());this._clearSegmentedButton();this._fillSegmentedButton();this._bItemsChanged=false;}this._setInitialFocus();};
j.prototype._makeAutomaticBinding=function(){this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this.bindAggregation("items",{path:"message>/",template:new M({type:"{message>type}",title:"{message>title}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"})});};
j.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this._fnHandleBackPress();}};
j.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};
j.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};
j.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var r=this.getId()+"-HeadingDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\" role=\"heading\">"+p+"</span>"});this._oPopover.addAssociation("ariaDescribedBy",r,true);var u=new B({icon:m["close"],visible:!sap.ui.Device.system.phone,ariaLabelledBy:o,tooltip:s,press:this.close.bind(this)}).addStyleClass(k+"CloseBtn");this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new a(),u,o,t]});return this._oListHeader;};
j.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var r=this.getId()+"-BackBtnDetDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\">"+p+"</span>"});var u=new B({icon:m["close"],visible:!sap.ui.Device.system.phone,ariaLabelledBy:o,tooltip:s,press:this.close.bind(this)}).addStyleClass(k+"CloseBtn");this._oBackButton=new B({icon:m["back"],press:this._fnHandleBackPress.bind(this),ariaLabelledBy:t,tooltip:p});this._oDetailsHeader=new T({content:[this._oBackButton,new a(),u,o,t]});return this._oDetailsHeader;};
j.prototype._createNavigationPages=function(){this._listPage=new f(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new f(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==='A'&&(t.className.indexOf('sapMMsgPopoverItemDisabledLink')!==-1||t.className.indexOf('sapMMsgPopoverItemPendingLink')!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)});this._oPopover.addContent(this._navContainer);return this;};
j.prototype._createLists=function(){this._oLists={};n.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};
j.prototype._clearLists=function(){n.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};
j.prototype._destroyLists=function(){n.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};
j.prototype._fillLists=function(i){i.forEach(function(o){var p=this._mapItemToListItem(o),r=this._mapItemToListItem(o);this._oLists["all"].addAggregation("items",p,true);this._oLists[o.getType().toLowerCase()].addAggregation("items",r,true);},this);};
j.prototype._mapItemToListItem=function(o){if(!o){return null;}var t=o.getType(),i=new S({title:o.getTitle(),icon:this._mapIcon(t),type:sap.m.ListType.Navigation}).addStyleClass(k+"Item").addStyleClass(k+"Item"+t);i._oMessagePopoverItem=o;return i;};
j.prototype._mapIcon=function(i){if(!i){return null;}return m[i.toLowerCase()];};
j.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};
j.prototype._fillSegmentedButton=function(){var t=this;var p=function(s){return function(){t._fnFilterList(s);};};n.forEach(function(s){var o=this._oLists[s],i=o.getItems().length,r;if(i>0){r=new B(this.getId()+"-"+s,{text:s=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):i,icon:m[s],press:p(s)}).addStyleClass(k+"Btn"+s.charAt(0).toUpperCase()+s.slice(1));this._oSegmentedButton.addButton(r,true);}},this);return this;};
j.prototype._setIcon=function(o,i){this._previousIconTypeClass=k+"DescIcon"+o.getType();this._oMessageIcon=new d({src:i.getIcon()}).addStyleClass(k+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};
j.prototype._setTitle=function(o){this._oMessageTitleText=new c(this.getId()+'MessageTitleText',{text:o.getTitle()}).addStyleClass('sapMMsgPopoverTitleText');this._detailsPage.addAggregation("content",this._oMessageTitleText);};
j.prototype._setDescription=function(o){if(o.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+'MarkupDescription',{content:"<div class='markupDescription'>"+o.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new c(this.getId()+'MessageDescriptionText',{text:o.getDescription()}).addStyleClass('sapMMsgPopoverDescriptionText');}this._detailsPage.addContent(this._oMessageDescriptionText);};
j.prototype._iNextValidationTaskId=0;
j.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return'';};
j.prototype._queueValidation=function(i){var o=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var p={};var r=new window.Promise(function(s,t){p.resolve=s;p.reject=t;var u={url:i,id:v,promise:p};o(u);});r.id=v;return r;};
j.prototype._getTagPolicy=function(){var t=this,i;var o=html.makeTagPolicy(this._validateURL());return function customTagPolicy(p,r){var s,v=false;if(p.toUpperCase()==="A"){for(i=0;i<r.length;){if(r[i]==="href"){v=true;s=r[i+1];r.splice(0,2);continue;}i+=2;}}r=o(p,r);if(v&&typeof t.getAsyncURLHandler()==="function"){r=r||[];var u=false;for(i=0;i<r.length;i+=2){if(r[i]==="class"){r[i+1]+="sapMMsgPopoverItemDisabledLink sapMMsgPopoverItemPendingLink";u=true;break;}}var w=r.indexOf("id");if(w>-1){r.splice(w+1,1);r.splice(w,1);}if(!u){r.unshift("sapMMsgPopoverItemDisabledLink sapMMsgPopoverItemPendingLink");r.unshift("class");}var V=t._queueValidation(s);r.push("href");r.push(s);r.push("target");r.push("_blank");r.push("id");r.push("sap-ui-"+t.getId()+"-link-under-validation-"+V.id);V.then(function(x){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+x.id);if(x.allowed){q.sap.log.info("Allow link "+s);}else{q.sap.log.info("Disallow link "+s);}$.removeClass('sapMMsgPopoverItemPendingLink');$.toggleClass('sapMMsgPopoverItemDisabledLink',!x.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return r;};};
j.prototype._sanitizeDescription=function(o){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var t=this._getTagPolicy();var s=html.sanitizeWithPolicy(o.getDescription(),t);o.setDescription(s);this._setDescription(o);};
j.prototype._fnHandleItemPress=function(E){var o=E.getParameter("listItem"),i=o._oMessagePopoverItem;var p=this.getAsyncDescriptionHandler();var r=function(v){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,o);this.fireLongtextLoaded();if(!v){this._navContainer.to(this._detailsPage);}}.bind(this);this._previousIconTypeClass=this._previousIconTypeClass||'';this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._detailsPage.destroyContent();if(typeof p==="function"&&!!i.getLongtextUrl()){i.setMarkupDescription(true);var s={};var t=new window.Promise(function(v,w){s.resolve=v;s.reject=w;});var u=function(){this._detailsPage.setBusy(false);r(true);}.bind(this);t.then(function(){u();}).catch(function(){q.sap.log.warning("Async description loading could not be performed.");u();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);p({promise:s,item:i});}else{r();}this._listPage.$().attr("aria-hidden","true");};
j.prototype._fnHandleBackPress=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};
j.prototype._fnFilterList=function(s){n.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._expandMsgPopover();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};
j.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};
j.prototype._navigate=function(){if(this._isListPage()){this._oRestoreFocus=q(document.activeElement);}};
j.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,this._restoreFocus);};
j.prototype._isListPage=function(){return(this._navContainer.getCurrentPage()==this._listPage);};
j.prototype._setInitialFocus=function(){if(this._isListPage()){this._oPopover.setInitialFocus(this._oLists[this._sCurrentList]);}};
j.prototype._restoreFocus=function(){if(this._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);if(r){r.focus();}}else{this._oBackButton.focus();}};
j.prototype._restoreExpansionDefaults=function(){if(this.getInitiallyExpanded()){this._fnFilterList("all");this._oSegmentedButton.setSelectedButton(null);}else{this._collapseMsgPopover();}};
j.prototype._expandMsgPopover=function(){var s=this._oPopover.$("cont").css("height")||this._oPopover.getContentWidth();this._oPopover.setContentHeight(s).removeStyleClass(k+"-init");};
j.prototype._collapseMsgPopover=function(){n.forEach(function(s){this._oLists[s].setVisible(false);},this);this._oPopover.addStyleClass(k+"-init").setContentHeight("auto");this._oSegmentedButton.setSelectedButton("none");};
j.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();if(r instanceof h){if((p instanceof T||p instanceof b||p instanceof g)){r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};
j.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};
j.prototype.isOpen=function(){return this._oPopover.isOpen();};
j.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};
j.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
j.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(s){j.prototype[s]=function(){if(this._oPopover&&this._oPopover[s]){var p=this._oPopover;var r=p[s].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){j.prototype["_"+F+"Old"]=j.prototype[F];j.prototype[F]=function(){var r=j.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return j;},true);
sap.ui.predefine('sap/m/MessagePopoverItem',["jquery.sap.global","./library","sap/ui/core/Item"],function(q,l,I){"use strict";
var M=I.extend("sap.m.MessagePopoverItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:sap.ui.core.MessageType.Error},title:{type:"string",group:"Appearance",defaultValue:""},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null}}}});
M.prototype.setProperty=function(p,v,s){var P=this.getParent(),t=this.getType().toLowerCase(),a=["description"],u=function(n,i){if(i._oMessagePopoverItem.getId()===this.getId()&&i.getMetadata().getProperty(n)){i.setProperty(n,v);}};if(a.indexOf(p)===-1&&P&&("_bItemsChanged"in P)&&!P._bItemsChanged){P._oLists&&P._oLists.all&&P._oLists.all.getItems&&P._oLists.all.getItems().forEach(u.bind(this,p));P._oLists&&P._oLists[t]&&P._oLists[t].getItems&&P._oLists[t].getItems().forEach(u.bind(this,p));}return I.prototype.setProperty.apply(this,arguments);};
M.prototype.setDescription=function(d){if(typeof d==='undefined'){d='';}if(this.getMarkupDescription()){d=q.sap._sanitizeHTML(d);}this.setProperty("description",d,true);return this;};
return M;},true);
sap.ui.predefine('sap/m/MessagePopoverRenderer',["jquery.sap.global"],function(q){"use strict";var M={};
M.render=function(r,c){};
return M;},true);
sap.ui.predefine('sap/m/MessageStrip',["jquery.sap.global","./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link"],function(q,l,C,M,T,L){"use strict";
var a=C.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:sap.ui.core.MessageType.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{close:{}}}});
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new T());};
a.prototype.setText=function(t){this.getAggregation("_text").setText(t);return this.setProperty("text",t,true);};
a.prototype.setType=function(t){if(t===sap.ui.core.MessageType.None){q.sap.log.warning(M.MESSAGES.TYPE_NOT_SUPPORTED);t=sap.ui.core.MessageType.Information;}return this.setProperty("type",t);};
a.prototype.setAggregation=function(n,c,s){if(n==="link"&&c instanceof L){c.addAriaLabelledBy(this.getId());}C.prototype.setAggregation.call(this,n,c,s);return this;};
a.prototype.ontap=M.handleMSCloseButtonInteraction;a.prototype.onsapenter=M.handleMSCloseButtonInteraction;a.prototype.onsapspace=M.handleMSCloseButtonInteraction;
a.prototype.ontouchmove=function(e){e.setMarked();};
a.prototype.close=function(){var c=function(){this.fireClose();this.setVisible(false);}.bind(this);if(!sap.ui.getCore().getConfiguration().getAnimation()){c();return;}if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){M.closeTransitionWithJavascript.call(this,c);}else{M.closeTransitionWithCSS.call(this,c);}};
return a;},true);
sap.ui.predefine('sap/m/MessageStripRenderer',["./MessageStripUtilities"],function(M){"use strict";var a={};
a.render=function(r,c){this.startMessageStrip(r,c);this.renderAriaTypeText(r,c);if(c.getShowIcon()){this.renderIcon(r,c);}this.renderTextAndLink(r,c);if(c.getShowCloseButton()){this.renderCloseButton(r);}this.endMessageStrip(r);};
a.startMessageStrip=function(r,c){r.write("<div");r.addClass(M.CLASSES.ROOT);r.addClass(M.CLASSES.ROOT+c.getType());r.writeControlData(c);r.writeClasses();r.writeAttribute(M.ATTRIBUTES.CLOSABLE,c.getShowCloseButton());r.writeAccessibilityState(c,M.getAccessibilityState.call(c));r.write(">");};
a.renderAriaTypeText=function(r,c){r.write("<span class='sapUiPseudoInvisibleText'>");r.write(M.getAriaTypeText.call(c));r.write("</span>");};
a.renderIcon=function(r,c){r.write("<div class='"+M.CLASSES.ICON+"'>");r.writeIcon(M.getIconURI.call(c),null,{"title":null});r.write("</div>");};
a.renderTextAndLink=function(r,c){r.write("<div class='"+M.CLASSES.MESSAGE+"'>");r.renderControl(c.getAggregation("_text"));r.renderControl(c.getLink());r.write("</div>");};
a.renderCloseButton=function(r){r.write("<button");r.writeAttribute("class",M.CLASSES.CLOSE_BUTTON);r.writeAttribute("aria-label",M.RESOURCE_BUNDLE.getText("CLOSE"));r.write("></button>");};
a.endMessageStrip=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/MessageStripUtilities',function(){"use strict";var M={};M.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported."+"Defaulting to 'sap.ui.core.MessageType.Information'"};M.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};M.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};M.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");
M.getIconURI=function(){var t=this.getType(),c=this.getCustomIcon(),i="sap-icon://message-"+t.toLowerCase();return c||i;};
M.getAriaTypeText=function(){var b="MESSAGE_STRIP_"+this.getType().toUpperCase(),a=M.RESOURCE_BUNDLE.getText(b);if(this.getShowCloseButton()){a+=" "+M.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE");}return a;};
M.handleMSCloseButtonInteraction=function(e){if(M.isMSCloseButtonPressed(e.target)){this.close();}};
M.isMSCloseButtonPressed=function(t){return t.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1||t.parentNode.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1;};
M.closeTransitionWithJavascript=function(c){this.$().animate({opacity:0},{duration:200,complete:c});};
M.closeTransitionWithCSS=function(c){this.$().addClass(M.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",c);};
M.getAccessibilityState=function(){return{role:"note",live:"assertive",labelledby:this.getId()};};
return M;});
sap.ui.predefine('sap/m/MessageToast',['jquery.sap.global','./InstanceManager','sap/ui/core/Popup'],function(q,I,P){"use strict";var M={};var O="0 -64",C="sapMMessageToast",E="sapUiSelectable";M._mSettings={duration:3000,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1000,autoClose:true,closeOnBrowserNavigation:true};M._aPopups=[];M._iOpenedPopups=0;M._bBoundedEvents=false;
M._validateSettings=function(s){this._isFiniteInteger(s.duration);this._validateWidth(s.width);this._validateDockPosition(s.my);this._validateDockPosition(s.at);this._validateOf(s.of);this._validateOffset(s.offset);this._validateCollision(s.collision);this._validateOnClose(s.onClose);this._validateAutoClose(s.autoClose);this._validateAnimationTimingFunction(s.animationTimingFunction);this._isFiniteInteger(s.animationDuration);};
M._isFiniteInteger=function(N){if(typeof N!=="number"||!isFinite(N)||!(Math.floor(N)===N)||N<=0){q.sap.log.error('"iNumber" needs to be a finite positive nonzero integer on '+this+"._isFiniteInteger");}};
M._validateWidth=function(w){if(!sap.ui.core.CSSSize.isValid(w)){q.sap.log.error(w+' is not of type '+'"sap.ui.core.CSSSize" for property "width" on '+this+"._validateWidth");}};
M._validateDockPosition=function(d){if(!sap.ui.core.Dock.isValid(d)){q.sap.log.error('"'+d+'"'+' is not of type '+'"sap.ui.core.Popup.Dock" on '+this+"._validateDockPosition");}};
M._validateOf=function(e){if(!(e instanceof q)&&!(e&&e.nodeType===1)&&!(e instanceof sap.ui.core.Control)&&e!==window){q.sap.log.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+this+"._validateOf");}};
M._validateOffset=function(o){if(typeof o!=="string"){q.sap.log.error(o+' is of type '+typeof o+', expected "string" for property "offset" on '+this+"._validateOffset");}};
M._validateCollision=function(s){var r=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!r.test(s)){q.sap.log.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+this+"._validateOffset");}};
M._validateOnClose=function(f){if(typeof f!=="function"&&f!==null){q.sap.log.error('"onClose" should be a function or null on '+this+"._validateOnClose");}};
M._validateAutoClose=function(b){if(typeof b!=="boolean"){q.sap.log.error('"autoClose" should be a boolean on '+this+"._validateAutoClose");}};
M._validateAnimationTimingFunction=function(t){var r=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!r.test(t)){q.sap.log.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+this+"._validateAnimationTimingFunction");}};
function h(o){for(var p=["my","at","of","offset"],i=0;i<p.length;i++){if(o[p[i]]!==undefined){return false;}}return true;}
function c(s){var m=document.createElement("div");m.style.width=s.width;m.className=C+" "+E;m.setAttribute("role","alert");m.appendChild(document.createTextNode(s.message));return m;}
function n(o){if(o){if(h(o)){o.offset=O;}if(o.of&&o.of.nodeType===9){o.of=document.defaultView;}}else{o={offset:O};}return o;}
M._handleResizeEvent=function(){if(sap.ui.Device.system.phone||sap.ui.Device.system.tablet){this._resetPosition(this._aPopups);}q.sap.delayedCall(0,this,"_applyPositions",[this._aPopups]);};
M._handleMouseDownEvent=function(e){var i=e.target.hasAttribute("class")&&e.target.getAttribute("class").indexOf(C)!==-1;if(i||e.isMarked("delayedMouseEvent")){return;}this._aPopups.forEach(function(p){p&&p.__bAutoClose&&p.close();});};
M._resetPosition=function(p){for(var i=0,m;i<p.length;i++){m=p[i]&&p[i].getContent();if(m){m.style.visibility="hidden";m.style.left=0;}}};
M._applyPositions=function(p){for(var i=0,o,m;i<p.length;i++){o=p[i];if(o){m=o._oPosition;if(sap.ui.Device.system.phone||sap.ui.Device.system.tablet){q.sap.delayedCall(0,this,"_applyPosition",[o,m]);}else{o.setPosition(m.my,m.at,m.of,m.offset);}}}};
M._applyPosition=function(p,m){var m=m||p._oPosition,o=p.getContent();p.setPosition(m.my,m.at,m.of,m.offset);o.style.visibility="visible";};
M._setCloseAnimation=function(m,d,f,s){var a="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",t="webkitTransitionEnd."+C+" transitionend."+C;if(sap.ui.getCore().getConfiguration().getAnimation()&&s.animationDuration>0){m[0].style.webkitTransition=a;m[0].style.transition=a;m[0].style.opacity=0;m.on(t,function handleMTTransitionEnd(){m.off(t);f();});}else{f();}};
M.show=function(m,o){var t=this,s=q.extend({},this._mSettings,{message:m}),p=new P(),i,a,b="mousedown."+C+" touchstart."+C,d,e;o=n(o);q.extend(s,o);this._validateSettings(s);a=c(s);i=this._aPopups.push(p)-1;p.setContent(a);p.setPosition(s.my,s.at,s.of,s.offset,s.collision);if(q.support.cssTransitions){p.setAnimations(function fnMessageToastOpen($,D,j){j();},function fnMessageToastClose($,D,j){t._setCloseAnimation($,D,j,s);});}p.setShadow(false);p.__bAutoClose=s.autoClose;if(s.closeOnBrowserNavigation){I.addPopoverInstance(p);}if(!this._bBoundedEvents){q(window).on("resize."+C,this._handleResizeEvent.bind(this));q(document).on(b,this._handleMouseDownEvent.bind(this));this._bBoundedEvents=true;}p.open();this._iOpenedPopups++;function f(){I.removePopoverInstance(t._aPopups[i]);q(t._aPopups[i].getContent()).remove();t._aPopups[i].detachClosed(f);t._aPopups[i].destroy();t._aPopups[i]=null;t._iOpenedPopups--;if(t._iOpenedPopups===0){t._aPopups=[];q(window).off("resize."+C);q(document).off(b);t._bBoundedEvents=false;}if(typeof s.onClose==="function"){s.onClose.call(t);}}p.attachClosed(f);d=q.sap.delayedCall(s.duration,p,"close");function g(){q.sap.clearDelayedCall(d);d=null;function j(){e=q.sap.delayedCall(s.duration,p,"close");p.getContent().removeEventListener("mouseleave",j);}p.getContent().addEventListener("mouseleave",j);q.sap.clearDelayedCall(e);e=null;}p.getContent().addEventListener("touchstart",g);p.getContent().addEventListener("mouseover",g);if(sap.ui.Device.system.desktop){p.getContent().addEventListener("mouseleave",function(){d=q.sap.delayedCall(s.duration,p,"close");});}};
M.toString=function(){return"sap.m.MessageToast";};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['jquery.sap.global','./Bar','./InputBase','./ComboBoxBase','./Dialog','./List','./MultiComboBoxRenderer','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','jquery.sap.xml'],function(q,B,I,C,D,L,M,P,l,E,a){"use strict";
var b=C.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});
a.insertFontFaceStyle();E.apply(b.prototype,[true]);
b.prototype.onsapend=function(e){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};
b.prototype.onsaphome=function(e){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};
b.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems();var o=i[0];if(o&&this.isOpen()){this.getListItem(o).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}this._setContainerSizes();};
b.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}this._setContainerSizes();};
b.prototype._selectItemByKey=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(e){e.setMarked();}var v;if(this.isOpen()){v=this._getUnselectedItems();}else{v=this._getItemsStartingText(this.getValue());}if(v.length>1){this._showWrongValueVisualEffect();}if(v.length===1){var i=v[0];var p={item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};if(this.getValue()===""||q.sap.startsWithIgnoreCase(i.getText(),this.getValue())){if(this.getListItem(i).isSelected()){this.setValue('');}else{this.setSelection(p);}}}if(e){this.close();}};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);this._selectItemByKey(e);};
b.prototype.onsaptabnext=function(e){var i=this.getValue();if(i){var s=this._getUnselectedItemsStartingText(i);if(s.length===1){this._selectItemByKey(e);}else{this._showWrongValueVisualEffect();this.setValue(null);}}};
b.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");var c=sap.ui.getCore().byId(e.relatedControlId);var f=c&&c.getFocusDomRef();if(!p||!p.getFocusDomRef()||!f||!q.contains(p.getFocusDomRef(),f)){this.setValue(null);}if(p&&f){if(q.sap.equal(p.getFocusDomRef(),f)){this.focus();}}this._setContainerSizes();};
b.prototype.onfocusin=function(e){this.addStyleClass("sapMFocus");if(e.target===this.getOpenArea()){this.focus();}if(!this.isOpen()){this.openValueStateMessage();}};
b.prototype.onsapescape=function(e){C.prototype.onsapescape.apply(this,arguments);this._setContainerSizes();};
b.prototype._handleItemTap=function(e){if(e.target.childElementCount===0||e.target.childElementCount===2){if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};
b.prototype._handleItemPress=function(e){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}}};
b.prototype._handleSelectionLiveChange=function(e){var o=e.getParameter("listItem");var i=e.getParameter("selected");var n=this._getItemByListItem(o);if(o.getType()==="Inactive"){return;}if(!n){return;}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(i){this.fireChangeEvent(n.getText());this.setSelection(p);}else{this.fireChangeEvent(n.getText());this.removeSelection(p);this.setValue('');}if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){o.focus();}};
b.prototype.onkeydown=function(e){C.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.V);if(this.getValue().length===0&&(e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);e.preventDefault();}};
b.prototype.oninput=function(e){C.prototype.oninput.apply(this,arguments);var v=e.target.value;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){this.updateDomValue(this._sOldValue||"");return;}var i=this._getItemsStartingText(v);var V=!!i.length;if(!V&&v!==""){this.updateDomValue(this._sOldValue||"");if(this._iOldCursorPos){q(this.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();return;}var c=this.getSelectableItems();if(this._sOldInput&&this._sOldInput.length>v.length){c=this.getItems();}c.forEach(function(o){var m=q.sap.startsWithIgnoreCase(o.getText(),v);if(v===""){m=true;}var d=this.getListItem(o);if(d){d.setVisible(m);}},this);this._setContainerSizes();if(!this.getValue()||!V){this.close();}else{this.open();}this._sOldInput=v;};
b.prototype.onkeyup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
b.prototype._showWrongValueVisualEffect=function(){var o=this.getValueState();if(o===sap.ui.core.ValueState.Error){return;}this.setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this,"setValueState",[o]);};
b.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["_create"+p]();this.setAggregation("picker",o,true);var r=this.getRenderer(),c=r.CSS_CLASS_MULTICOMBOBOX;o.setHorizontalScrolling(false).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(c+"Picker").addStyleClass(c+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return o;};
b.prototype.onBeforeRendering=function(){C.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var o=this.getList();if(o){this._synchronizeSelectedItemAndKey(i);o.destroyItems();this._clearTokenizer();this._fillList(i);if(o.getItemNavigation()){this._iFocusedIndex=o.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}};
b.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this);}};
b.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this);}};
b.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this._resetCurrentItem();this.addContent();if(p){p.call(this);}};
b.prototype.onAfterOpen=function(){this.closeValueStateMessage();};
b.prototype.onBeforeClose=function(){};
b.prototype.onAfterClose=function(){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this.clearFilter();this.fireSelectionFinish({selectedItems:this.getSelectedItems()});};
b.prototype._onBeforeOpenDialog=function(){};
b.prototype._onBeforeOpenPopover=function(){var p=this.getPicker(),d=this.getDomRef(),w;if(d&&p){w=(d.offsetWidth/parseFloat(sap.m.BaseFontSize))+"rem";p.setContentMinWidth(w);}};
b.prototype._createDialog=function(){var c=this.getRenderer().CSS_CLASS_COMBOBOXBASE;var d=new D({stretch:true,customHeader:new B({contentLeft:new sap.m.InputBase({width:"100%",editable:false}).addStyleClass(c+"Input")}).addStyleClass(c+"Bar")});d.getAggregation("customHeader").attachBrowserEvent("tap",function(){d.close();},this);return d;};
b.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};
b.prototype._createPopover=function(){var p=new P({showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});this._decoratePopover(p);return p;};
b.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:sap.m.ListMode.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList},this);};
b.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return;}if(!o.item){return;}this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true);}var t=new sap.m.Token({key:o.key,text:o.item.getText(),tooltip:o.item.getText()});o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
b.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return;}if(!o.item){return;}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false);}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
b.prototype._synchronizeSelectedItemAndKey=function(c){if(!c.length){q.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var s=this.getSelectedKeys()||this._aCustomerKeys;var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,d=null,e=s.length;i<e;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(d=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(d,1);}continue;}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(d=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(d,1);}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};
b.prototype._setContainerSizes=function(){var m=this.$();if(!m.length){return;}var c=this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX;var i=m.find(c+"InputContainer");var s=m.children(c+"ShadowDiv");s.text(this.getValue());var d=q(this.getOpenArea()).outerWidth(true);var t=(this._oTokenizer.getScrollWidth()/parseFloat(sap.m.BaseFontSize))+"rem";var e=((s.outerWidth()+d)/parseFloat(sap.m.BaseFontSize))+"rem";this._oTokenizer.$().css("width","calc(100% - "+e+")");i.css("width","calc(100% - "+t+")");i.css("min-width",e);};
b.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
b.prototype._getSelectedItemsOf=function(c){for(var i=0,d=c.length,s=[];i<d;i++){if(this.getListItem(c[i]).isSelected()){s.push(c[i]);}}return s;};
b.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var T=t.length?t[t.length-1]:null;if(!T){return null;}return this._getItemByToken(T);};
b.prototype._getOrderedSelectedItems=function(){var c=[];for(var i=0,t=this._oTokenizer.getTokens(),d=t.length;i<d;i++){c[i]=this._getItemByToken(t[i]);}return c;};
b.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var f=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&q.sap.containsOrEquals(this.getList().getFocusDomRef(),f.getFocusDomRef())){return f;}return null;};
b.prototype._getFocusedItem=function(){var o=this._getFocusedListItem();return this._getItemByListItem(o);};
b.prototype._isRangeSelectionSet=function(o){var $=o.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};
b.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};
b.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
b.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
b.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
b.prototype._decorateListItem=function(o){o.addDelegate({onkeyup:function(e){var i=null;if(e.which==q.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.clearFilter();this.open();i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}return;}},onkeydown:function(e){var i=null,c=null;if(e.shiftKey&&e.which==q.sap.KeyCodes.ARROW_DOWN){c=this._getCurrentItem();i=this._getNextVisibleItemOf(c);}if(e.shiftKey&&e.which==q.sap.KeyCodes.ARROW_UP){c=this._getCurrentItem();i=this._getPreviousVisibleItemOf(c);}if(e.shiftKey&&e.which===q.sap.KeyCodes.SPACE){c=this._getCurrentItem();this._selectPreviousItemsOf(c);}if(i&&i!==c){if(this.getListItem(c).isSelected()){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}else{this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}return;}this._resetCurrentItem();if((e.ctrlKey||e.metaKey)&&e.which==q.sap.KeyCodes.A){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(i){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(i){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);o.addEventDelegate({onsapbackspace:function(e){e.preventDefault();},onsapshow:function(e){e.setMarked();if(e.keyCode===q.sap.KeyCodes.F4){e.preventDefault();}if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(e){this.onsapshow(e);},onsapenter:function(e){e.setMarked();this.close();},onsaphome:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];this.getListItem(i).focus();},onsapend:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[v.length-1];this.getListItem(i).focus();},onsapup:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];var c=q(document.activeElement).control()[0];if(c===this.getListItem(i)){this.focus();e.stopPropagation(true);}},onfocusin:function(e){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(e){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(e){var p=this.getAggregation("picker");var c=sap.ui.getCore().byId(e.relatedControlId);if(p&&c&&q.sap.equal(p.getFocusDomRef(),c.getFocusDomRef())){if(e.srcControl){e.srcControl.focus();}}}},this);if(sap.ui.Device.support.touch){o.addEventDelegate({ontouchstart:function(e){e.setMark("cancelAutoClose");}});}};
b.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);this.getRenderer().placeholderToBeShown=function(r,c){return(!c._oTokenizer.getTokens().length)&&(c.getPlaceholder()?true:false);};return t;};
b.prototype._handleTokenChange=function(e){var t=e.getParameter("type");var T=e.getParameter("token");var i=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){i=(T&&this._getItemByToken(T));if(i&&this.isItemSelected(i)){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});this.focus();this.fireChangeEvent("");}}};
b.prototype._onAfterRenderingTokenizer=function(){this._setContainerSizes();};
b.prototype.onAfterRenderingList=function(){var o=this.getList();if(this._iFocusedIndex!=null&&o.getItems().length>this._iFocusedIndex){o.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}else{var f=this.getFocusDomRef();if(f){f.focus();}}};
b.prototype.onAfterRendering=function(){C.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var d=q(this.getDomRef());var o=d.find(this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX+"Border");p._oOpenBy=o[0];};
b.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");C.prototype.onfocusout.apply(this,arguments);};
b.prototype.onpaste=function(e){var o;if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._oTokenizer._parseString(o);if(s&&s.length>0){this.getSelectableItems().forEach(function(i){if(q.inArray(i.getText(),s)>-1){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
b.prototype.onsapbackspace=function(e){if(!this.getEnabled()||!this.getEditable()){e.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);e.preventDefault();};
b.prototype.onsapdelete=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};
b.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(f===this._oTokenizer||this._oTokenizer.$().find(f.$()).length>0&&this.getEditable()){this.focus();}};
b.prototype.onsapprevious=function(e){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(e.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};
b.prototype._getItemsStartingText=function(t){var i=[];this.getSelectableItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};
b.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};
b.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
b.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};
b.prototype._selectPreviousItemsOf=function(i){var c;do{c=true;var p=this._getPreviousVisibleItemOf(i);if(p){var o=this.getListItem(p);if(o){c=this.getListItem(p).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=p;}while(!c);};
b.prototype._getNextVisibleItemOf=function(i){var c=this.getSelectableItems();var d=c.indexOf(i)+1;if(d<=0||d>c.length-1){return null;}return c[d];};
b.prototype._getPreviousVisibleItemOf=function(i){var c=this.getSelectableItems();var d=c.indexOf(i)-1;if(d<0){return null;}return c[d];};
b.prototype._getNextUnselectedItemOf=function(i){var c=this._getUnselectedItems();var d=c.indexOf(i)+1;if(d<=0||d>c.length-1){return null;}return c[d];};
b.prototype._getPreviousUnselectedItemOf=function(i){var c=this._getUnselectedItems();var d=c.indexOf(i)-1;if(d<0){return null;}return c[d];};
b.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};
b.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};
b.prototype.findFirstEnabledItem=function(c){c=c||this.getItems();for(var i=0;i<c.length;i++){if(c[i].getEnabled()){return c[i];}}return null;};
b.prototype.getVisibleItems=function(){for(var i=0,o,c=this.getItems(),v=[];i<c.length;i++){o=this.getListItem(c[i]);if(o&&o.getVisible()){v.push(c[i]);}}return v;};
b.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
b.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!q.isArray(i)){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(o){if(!(o instanceof sap.ui.core.Item)&&(typeof o!=="string")){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof o==="string"){o=sap.ui.getCore().byId(o);}this.setSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",suppressInvalidate:true});},this);return this;};
b.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
b.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
b.prototype.removeAllSelectedItems=function(){var i=[];var c=this.getAssociation("selectedItems",[]);c.forEach(function(o){var d=this.removeSelectedItem(o);if(d){i.push(d.getId());}},this);return i;};
b.prototype.removeSelectedKeys=function(k){var i=[],c;if(!k||!k.length||!q.isArray(k)){return i;}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o);}if(this._aCustomerKeys.length&&(c=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(c,1);}},this);return i;};
b.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this;};
b.prototype.addSelectedKeys=function(k){k=this.validateProperty("selectedKeys",k);k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i);}else if(K!=null){this._aCustomerKeys.push(K);}},this);return this;};
b.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(o){k.push(o.getKey());},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys);}return k;};
b.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};
b.prototype.getSelectedItems=function(){var i=[],c=this.getAssociation("selectedItems")||[];c.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o);}},this);return i;};
b.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
b.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
b.prototype.setEditable=function(e){C.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(e);return this;};
b.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};
b.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
b.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var c=(this.isItemSelected(i))?s+"Selected":"";var o=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,visible:i.getEnabled()}).addStyleClass(s+" "+c);o.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",o);if(c){var t=new sap.m.Token({key:i.getKey(),text:i.getText(),tooltip:i.getText()});i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o;};
b.prototype._findMappedItem=function(o,c){for(var i=0,c=c||this.getItems(),d=c.length;i<d;i++){if(this.getListItem(c[i])===o){return c[i];}}return null;};
b.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}var t=this._getTokenByItem(i);if(t){t.setVisible(s);}};
b.prototype.getSelectable=function(i){return i._bSelectable;};
b.prototype._fillList=function(c){if(!c){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(e){if(e.srcControl.isSelected()){e.setMarked();}}};}for(var i=0,o,d=c.length;i<d;i++){o=this._mapItemToListItem(c[i]);o.removeEventDelegate(this._oListItemEnterEventDelegate);o.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",o,true);if(this.isItemSelected(c[i])){this.getList().setSelectedItem(o,true);}}};
b.prototype.init=function(){I.prototype.init.apply(this,arguments);this.createList();this.bItemsUpdated=false;this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Popover");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];};
b.prototype.clearSelection=function(){this.removeAllSelectedItems();};
b.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};
b.prototype.insertItem=function(i,c){this.insertAggregation("items",i,c,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),c);}return this;};
b.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
b.prototype.getItemByKey=function(k){return this.findItem("key",k);};
b.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
b.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
b.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,c=this.getItems();i<c.length;i++){if(c[i][m]()===v){return c[i];}}return null;};
b.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};
b.prototype.getList=function(){return this._oList;};
b.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};
b.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};
b.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};
b.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
b.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};
b.prototype._getItemBy=function(d,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,c=this.getItems(),e=c.length;i<e;i++){if(c[i].data(s)===d){return c[i];}}return null;};
b.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
b.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(o){return o.getText();}).join(" ");var i=C.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};
return b;},true);
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['jquery.sap.global','./ComboBoxBaseRenderer','sap/ui/core/Renderer','sap/ui/core/ValueStateSupport'],function(q,C,R,V){"use strict";var M=R.extend(sap.m.ComboBoxBaseRenderer);M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";M.DOT_CSS_CLASS_MULTICOMBOBOX=".sapMMultiComboBox";
M.addOuterClasses=function(r,c){sap.m.ComboBoxBaseRenderer.addOuterClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX);if(c._hasTokens()){r.addClass("sapMMultiComboBoxHasToken");}};
M.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"InputInner");};
M.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"Arrow");};
M.openInputTag=function(r,c){r.write('<div class="sapMMultiComboBoxBorder"');r.writeAttribute("id",c.getId()+"-border");r.write(">");r.renderControl(c._oTokenizer);r.write("<div class=\"sapMMultiComboBoxInputContainer\">");C.openInputTag.call(this,r,c);};
M.closeInputTag=function(r,c){C.closeInputTag.call(this,r,c);r.write("</div>");r.write("</div>");r.write("<div class=\"sapMMultiComboBoxShadowDiv\"/>");};
return M;},true);
sap.ui.predefine('sap/m/MultiInput',['jquery.sap.global','./Input','./Token','./library','sap/ui/core/Item'],function(q,I,T,l,a){"use strict";
var M=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");M.prototype._sAriaMultiInputContainTokenId=new sap.ui.core.InvisibleText({text:r.getText("MULTIINPUT_ARIA_CONTAIN_TOKEN")}).toStatic().getId();
M.prototype.init=function(){var t=this;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");I.prototype.init.call(this);this._bIsValidating=false;this._tokenizer=new sap.m.Tokenizer();this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.attachTokenChange(function(b){t.fireTokenChange(b.getParameters());t.invalidate();if(t._bUseDialog&&t._tokenizerInPopup&&t._tokenizer.getParent()instanceof sap.m.Dialog){t._showAllTokens(t._tokenizerInPopup);return;}else{t._setContainerSizes();var f=q.sap.containsOrEquals(t.getDomRef(),document.activeElement);if(b.getParameter("type")==="tokensChanged"&&b.getParameter("removedTokens").length>0&&f){t.focus();}if(b.getParameter("type")==="removed"&&t._isMultiLineMode){var L=t.getTokens().length;if(L>1){t.getTokens()[L-1].setVisible(true);}else{t._showAllTokens(t._tokenizer);}}}});this.setShowValueHelp(true);this.setShowSuggestion(true);this.addStyleClass("sapMMultiInput");this.attachSuggestionItemSelected(function(e){var i=null;var b=null;if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){b=new T({text:i.getText(),key:i.getKey()});}}var o=t._tokenizer.getTokens().length;if(i){var c=this.getValue();t._tokenizer.addValidateToken({text:c,token:b,suggestionObject:i,validationCallback:function(v){if(v){t.setValue("");}}});}if(t._bUseDialog&&t._tokenizerInPopup&&t._tokenizerInPopup.getParent()instanceof sap.m.Dialog){var n=t._tokenizer.getTokens().length;if(o<n){var N=t._tokenizer.getTokens()[n-1];t._updateTokenizerInPopup(N);t.setValue("");}if(t._tokenizerInPopup.getVisible()===false){t._tokenizerInPopup.setVisible(true);}t._setAllTokenVisible(t._tokenizerInPopup);if(t._oList instanceof sap.m.Table){t._oList.addStyleClass("sapMInputSuggestionTableHidden");}else{t._oList.destroyItems();}var s=t._oSuggestionPopup.getScrollDelegate();if(s){s.scrollTo(0,0,0);}t._oPopupInput.focus();}});this.attachLiveChange(function(e){t._tokenizer.removeSelectedTokens();if(t._bUseDialog&&t._isMultiLineMode){var v=e.getParameter("newValue");if(t._oSuggestionPopup&&t._oSuggestionPopup.getContent().length>1&&v.length>0){t._tokenizerInPopup.setVisible(false);}else{t._tokenizerInPopup.setVisible(true);t._setAllTokenVisible(t._tokenizerInPopup);}}else{t._setContainerSizes();t._tokenizer.scrollToStart();}});sap.ui.Device.orientation.attachHandler(this._onOrientationChange,this);this._sResizeHandlerId=sap.ui.core.ResizeHandler.register(this,function(){t._setContainerSizes();});if(!(this._bUseDialog&&this._oSuggestionPopup)){this.attachSuggestionItemSelected(function(){setTimeout(function(){t._tokenizer.scrollToEnd();},0);});}};
M.prototype._updateTokenizerInPopup=function(t){var n=t.clone();n.attachDelete(this._tokenizerInPopup._onDeleteToken,this._tokenizerInPopup);n.attachPress(this._tokenizerInPopup._onTokenPress,this._tokenizerInPopup);this._tokenizerInPopup.insertToken(n,0);};
M.prototype._updateTokenizerInMultiInput=function(){var t=this._tokenizer.getTokens().length;var b=this._tokenizerInPopup.getTokens().length;var i=0,R=[];for(i=0;i<t;i++){var o=this._tokenizer.getTokens()[i];var j=0;while(j<b&&this._tokenizerInPopup.getTokens()[j].getId().indexOf(o.getId())<0){j++;}if(j===b){R.push(o);}}if(R.length>0){for(i=0;i<R.length;i++){this._tokenizer.removeToken(R[i]);}this.fireTokenChange({addedTokens:[],removedTokens:[R],type:sap.m.Tokenizer.TokenChangeType.TokensChanged});}};
M.prototype._setAllTokenVisible=function(t){if(t.getVisible()===false){t.setVisible(true);}var b=t.getTokens();if(b.length>0){var i=0;for(i=0;i<b.length;i++){b[i].setVisible(true);}}};
M.prototype._setAllTokenInvisible=function(){var t=this.getTokens();if(t.length>0){var i=0;for(i=0;i<t.length;i++){t[i].setVisible(false);}}};
M.prototype._showIndicator=function(){var t=this.getTokens(),b=t.length;this._tokenizer.setVisible(true);if(b>1){var i=0;for(i=0;i<b-1;i++){t[i].setVisible(false);}if(this.$().find(".sapMMultiInputIndicator").length!==0){this._removeIndicator();}var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");var s="<span class=\"sapMMultiInputIndicator\">"+m.getText("MULTIINPUT_SHOW_MORE_TOKENS",b-1)+"</span>";this.$().find(".sapMTokenizer").after(s);this._setValueInvisible();}this._bShowIndicator=true;};
M.prototype._setValueInvisible=function(){this.$("inner").css("opacity","0");};
M.prototype._setValueVisible=function(){this.$("inner").css("opacity","1");};
M.prototype._showAllTokens=function(t){this._setAllTokenVisible(t);this._removeIndicator();};
M.prototype._removeIndicator=function(){this.$().find(".sapMMultiInputIndicator").remove();this._bShowIndicator=false;};
M.prototype.setEnableMultiLineMode=function(m){this.setProperty("enableMultiLineMode",m,true);this.closeMultiLine();var t=this;if(this._bUseDialog){m=true;}if(m){this._showIndicator();this._isMultiLineMode=true;if(this.getDomRef()){setTimeout(function(){t._setContainerSizes();},0);}}else{this._isMultiLineMode=false;this._showAllTokens(this._tokenizer);this.setValue("");if(this.getDomRef()){setTimeout(function(){t._setContainerSizes();t._scrollAndFocus();},0);}}return this;};
M.prototype.openMultiLine=function(){this._setValueVisible();this.$("border").addClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parent().addClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").attr("tabindex","-1");var p=this.getParent();this._originalOverflow=null;if(p&&p.$&&p.$().css("overflow")==="hidden"){this._originalOverflow=p.$().css("overflow");p.$().css("overflow","visible");}var P;if(this.$().closest('.sapUiVlt').length!==0){P=this.$().closest('.sapUiVlt');}else if(this.$().parent('[class*="sapUiRespGridSpan"]').length!==0){P=this.$().parent('[class*="sapUiRespGridSpan"]');}else if(this.$().parents(".sapUiRFLContainer").length!==0){P=this.$().parents(".sapUiRFLContainer");}if(P&&P.length>0&&P.css("overflow")==="hidden"){P.css("overflow","visible");}};
M.prototype.closeMultiLine=function(){this.$("border").removeClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parent().removeClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").removeAttr("tabindex");if(this._originalOverflow){var p=this.getParent();p.$().css("overflow",this._originalOverflow);}};
M.prototype._onOrientationChange=function(){this._setContainerSizes();};
M.prototype.getScrollDelegate=function(){return this._tokenizer._oScroller;};
M.prototype.exit=function(){if(this._sResizeHandlerId){sap.ui.core.ResizeHandler.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}I.prototype.exit.apply(this,arguments);};
M.prototype._setContainerSizes=function(){var t=this.getDomRef();if(!t){return;}var $=this.$();if(this.getTokens().length>0){$.find(".sapMMultiInputBorder").addClass("sapMMultiInputNarrowBorder");}else{$.find(".sapMMultiInputBorder").removeClass("sapMMultiInputNarrowBorder");}this.$("inner").css("width","");var b=$.find(".sapMMultiInputBorder").width();var s=$.children(".sapMMultiInputShadowDiv")[0];var c=$.find(".sapMMultiInputBorder").find(".sapMMultiInputIndicator");q(s).text(this.getValue());var i=q(s).width();var d=q(c).width();var e=this._tokenizer.getScrollWidth();var f=$.find(".sapMInputValHelp").outerWidth(true);if(d!==null&&this._isMultiLineMode&&this._bShowIndicator){i=d;}var g=e+i+f;var h;var j=1;if(!this._bUseDialog&&this._isMultiLineMode&&!this._bShowIndicator&&this.$().find(".sapMMultiInputBorder").length>0){var k=this.$().find(".sapMMultiInputBorder"),m=parseInt((k.css("max-height")||0),10),S=k[0].scrollHeight,n=b-f;if(m<S){n=n-17;}this._tokenizer.setPixelWidth(n);this.$("inner").css("width",n+"px");}else{if(g<b){h=i+b-g;}else{if(e===0&&i>b){h=b;}else{h=i+j;e=b-h-f;}}q($.find(".sapMInputBaseInner")[0]).css("width",h+"px");this._tokenizer.setPixelWidth(e);}if(this.getPlaceholder()){this._sPlaceholder=this.getPlaceholder();}if(this.getTokens().length>0){this.setPlaceholder("");}else{this.setPlaceholder(this._sPlaceholder);}if(this._bUseDialog&&this._isMultiLineMode&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()&&this._tokenizerInPopup&&this._tokenizerInPopup.getTokens().length>0){var p=this._tokenizerInPopup.getTokens().length,L=this._tokenizerInPopup.getTokens()[p-1],o=L.$(),u=L.$().outerWidth(),P=this._oSuggestionPopup.$().find(".sapMDialogScrollCont").width(),B=parseFloat(sap.m.BaseFontSize)||16,n=P-2*B;if(n<u){o.outerWidth(n,true);o.css("overflow","hidden");o.css("text-overflow","ellipsis");o.css("white-space","nowrap");}}};
M.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);this._setContainerSizes();};
M.prototype.addValidator=function(v){this._tokenizer.addValidator(v);};
M.prototype.removeValidator=function(v){this._tokenizer.removeValidator(v);};
M.prototype.removeAllValidators=function(){this._tokenizer.removeAllValidators();};
M.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(this._tokenizer===f||this._tokenizer.$().find(f.$()).length>0){this._scrollAndFocus();}};
M.prototype.onsapbackspace=function(e){if(this.getCursorPosition()>0||!this.getEditable()||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._tokenizer,arguments);e.preventDefault();e.stopPropagation();};
M.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._tokenizer,arguments);};
M.prototype.onkeydown=function(e){if(e.ctrlKey||e.metaKey){if(e.which===q.sap.KeyCodes.A){var v=this.getValue();if(document.activeElement===this._$input[0]){if(this._$input.getSelectedText()!==v){this.selectText(0,v.length);}else if(this._tokenizer){if(!v&&this._tokenizer.getTokens().length){this._tokenizer.focus();}this._tokenizer.selectAllTokens(true);}}else if(document.activeElement===this._tokenizer.$()[0]){if(this._tokenizer._iSelectedToken===this._tokenizer.getTokens().length){this.selectText(0,v.length);}}e.preventDefault();}}};
M.prototype.onpaste=function(e){var o;if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._tokenizer._parseString(o);setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var i=0;for(i=0;i<s.length;i++){this.updateDomValue(s[i]);this._validateCurrentText();}}this.cancelPendingSuggest();}}.bind(this),0);};
M.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this.getCursorPosition()===0){if(e.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._tokenizer,arguments);e.preventDefault();}}};
M.prototype._scrollAndFocus=function(){this._tokenizer.scrollToEnd();this.$().find("input").focus();};
M.prototype.onsaphome=function(e){sap.m.Tokenizer.prototype.onsaphome.apply(this._tokenizer,arguments);};
M.prototype.onsapend=function(e){sap.m.Tokenizer.prototype.onsapend.apply(this._tokenizer,arguments);e.preventDefault();};
M.prototype.onsapenter=function(e){this._validateCurrentText();if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.focus();};
M.prototype._checkFocus=function(){return this.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement);};
M.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup;var n=false;var N=false;var b=this._checkFocus();if(p instanceof sap.m.Popover){if(e.relatedControlId){n=q.sap.containsOrEquals(p.getFocusDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef());N=q.sap.containsOrEquals(this._tokenizer.getFocusDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef());}}if(!N&&!n&&!this._isMultiLineMode){this._setContainerSizes();this._tokenizer.scrollToEnd();}if(this._bIsValidating){if(I.prototype.onsapfocusleave){I.prototype.onsapfocusleave.apply(this,arguments);}return;}if(I.prototype.onsapfocusleave){I.prototype.onsapfocusleave.apply(this,arguments);}if(!this._bUseDialog&&!n&&e.relatedControlId!==this.getId()&&e.relatedControlId!==this._tokenizer.getId()&&!N&&!(this._isMultiLineMode&&this._bShowIndicator)){this._validateCurrentText(true);}if(!this._bUseDialog&&this._isMultiLineMode&&!this._bShowIndicator){if(b||n){return;}this.closeMultiLine();this._showIndicator();var t=this;setTimeout(function(){t._setContainerSizes();},0);}sap.m.Tokenizer.prototype.onsapfocusleave.apply(this._tokenizer,arguments);if(!this._bUseDialog&&this._isMultiLineMode&&this._bShowIndicator){var $=this.$().find(".sapMMultiInputBorder");$.scrollTop(0);}};
M.prototype.cloneTokenizer=function(t){var c=new sap.m.Tokenizer();var b=t.getTokens();if(b.length>0){for(var i=b.length-1;i>=0;i--){var n=b[i].clone();c.addToken(n);}}return c;};
M.prototype._processMultiLine=function(e){if(this._bUseDialog){if(e.target===this._$input[0]||e.target.className.indexOf("sapMToken")>-1&&e.target.className.indexOf("sapMTokenIcon")<0||e.target.className.indexOf("sapMTokenText")>-1){this._removeIndicator();this._oSuggestionPopup.open();this._tokenizerInPopup=this.cloneTokenizer(this._tokenizer);var v=this._oPopupInput.getValue();if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>0&&v.length>0){this._tokenizerInPopup.setVisible(false);}else{this._tokenizerInPopup.setVisible(true);this._setAllTokenVisible(this._tokenizerInPopup);}this._tokenizerInPopup._oScroller.setHorizontal(false);this._tokenizerInPopup.addStyleClass("sapMTokenizerMultiLine");if(this._oSuggestionTable.getItems().length===0){var t=this;this._oPopupInput.onsapenter=function(e){t._validateCurrentText();t._setValueInvisible();};}this._oSuggestionPopup.insertContent(this._tokenizerInPopup,0);}}else{if(e.target===this._$input[0]||e.target.className.indexOf("sapMToken")>-1&&e.target.className.indexOf("sapMTokenIcon")<0||e.target.className.indexOf("sapMTokenText")>-1){this.openMultiLine();this._showAllTokens(this._tokenizer);var t=this;setTimeout(function(){t._setContainerSizes();t._tokenizer.scrollToStart();},0);}}};
M.prototype.ontap=function(e){if(document.activeElement===this._$input[0]){this._tokenizer.selectAllTokens(false);}I.prototype.ontap.apply(this,arguments);};
M.prototype.onfocusin=function(e){if(this._isMultiLineMode){this._processMultiLine(e);}if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);}};
M.prototype.onsapescape=function(e){this._tokenizer.selectAllTokens(false);this.selectText(0,0);I.prototype.onsapescape.apply(this,arguments);};
M.prototype._validateCurrentText=function(e){var o=this._tokenizer.getTokens().length;var t=this.getValue();if(!t||!this.getEditable()){return;}t=t.trim();if(!t){return;}var i=null;if(e||this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t,e);}}var b=null;if(i&&i.getText&&i.getKey){b=new T({text:i.getText(),key:i.getKey()});}var c=this;this._bIsValidating=true;this._tokenizer.addValidateToken({text:t,token:b,suggestionObject:i,validationCallback:function(v){c._bIsValidating=false;if(v){c.setValue("");if(c._bUseDialog&&c._isMultiLineMode&&c._oSuggestionTable.getItems().length===0){var n=c._tokenizer.getTokens().length;if(o<n){var N=c._tokenizer.getTokens()[n-1];c._updateTokenizerInPopup(N);c._oPopupInput.setValue("");}if(c._tokenizerInPopup.getVisible()===false){c._tokenizerInPopup.setVisible(true);}c._setAllTokenVisible(c._tokenizerInPopup);}}}});};
M.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
M.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};
M.prototype._selectAllInputText=function(){var i=this._$input[0];i.selectionStart=0;i.selectionEnd=this.getValue().length;return this;};
M.prototype._getIsSuggestionPopupOpen=function(){return this._oSuggestionPopup&&this._oSuggestionPopup.isOpen();};
M.prototype.setEditable=function(e){if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}this._tokenizer.setEditable(e);if(e){this.removeStyleClass("sapMMultiInputNotEditable");}else{this.addStyleClass("sapMMultiInputNotEditable");}return this;};
M.prototype._findItem=function(t,b,e,g){if(!t){return;}if(!(b&&b.length)){return;}t=t.toLowerCase();var c=b.length;for(var i=0;i<c;i++){var d=b[i];var f=g(d);if(!f){continue;}f=f.toLowerCase();if(f===t){return d;}if(!e&&f.indexOf(t)===0){return d;}}};
M.prototype._getSuggestionItem=function(t,e){var b=null;var c=null;if(this._hasTabularSuggestions()){b=this.getSuggestionRows();c=this._findItem(t,b,e,function(R){var d=R.getCells();var f=null;if(d){var i;for(i=0;i<d.length;i++){if(d[i].getText){f=d[i].getText();break;}}}return f;});}else{b=this.getSuggestionItems();c=this._findItem(t,b,e,function(c){return c.getText();});}return c;};
M.prototype.addToken=function(t){return this._tokenizer.addToken(t);};
M.prototype.removeToken=function(t){return this._tokenizer.removeToken(t);};
M.prototype.removeAllTokens=function(){return this._tokenizer.removeAllTokens();};
M.prototype.getTokens=function(){return this._tokenizer.getTokens();};
M.prototype.insertToken=function(t,i){return this._tokenizer.insertToken(t,i);};
M.prototype.indexOfToken=function(t){return this._tokenizer.indexOfToken(t);};
M.prototype.destroyTokens=function(){return this._tokenizer.destroyTokens();};
M.prototype.updateTokens=function(){this.destroyTokens();return this.updateAggregation("tokens");};
M.prototype.clone=function(){var c=I.prototype.clone.apply(this,arguments);var t=this.getTokens();var i;for(i=0;i<t.length;i++){var n=t[i].clone();c.addToken(n);}return c;};
M.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("border");};
M.prototype.setTokens=function(t){this._tokenizer.setTokens(t);};
M.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};M.WaitForAsyncValidation="sap.m.Tokenizer.WaitForAsyncValidation";M.prototype.getDomRefForValueStateMessage=M.prototype.getPopupAnchorDomRef;
M.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
return M;},true);
sap.ui.predefine('sap/m/MultiInputRenderer',['jquery.sap.global','./InputRenderer','sap/ui/core/Renderer'],function(q,I,R){"use strict";var M=R.extend(I);
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments);if(c.getTokens().length>0){if(a){a=a+" "+c._sAriaMultiInputContainTokenId;}else{a=c._sAriaMultiInputContainTokenId;}}return a;};
M.openInputTag=function(r,c){if(c.getEnableMultiLineMode()||c._bUseDialog){c._isMultiLineMode=true;if(!c._bUseDialog&&c._bShowIndicator===false){r.write("<div id=\""+c.getId()+"-border\" class=\"sapMMultiInputBorder sapMMultiInputMultiModeBorder\">");}else{c._showIndicator();r.write("<div id=\""+c.getId()+"-border\" class=\"sapMMultiInputBorder\">");}}else{r.write("<div id=\""+c.getId()+"-border\" class=\"sapMMultiInputBorder\">");}M._renderTokens(r,c);M._renderInput(r,c);};
M._renderTokens=function(r,c){r.renderControl(c._tokenizer);};
M._renderInput=function(r,c){if(c._isMultiLineMode&&c._bShowIndicator===false){r.write("<div class=\"sapMMultiInputInputContainer sapMMultiInputMultiModeInputContainer\">");}else{if(c._isMultiLineMode&&c._bShowIndicator===true){var t=c.getTokens().length;r.write("<span class=\"sapMMultiInputIndicator\">");if(t>1){var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write(m.getText("MULTIINPUT_SHOW_MORE_TOKENS",t-1));}r.write("</span>");}r.write("<div class=\"sapMMultiInputInputContainer\">");}I.openInputTag.call(this,r,c);};
M.closeInputTag=function(r,c){I.closeInputTag.call(this,r,c);r.write("</div>");r.write("</div>");r.write("<div class=\"sapMMultiInputShadowDiv\"/>");};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/PopupSupport'],function(q,a,C,P){"use strict";
var N=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;};
N.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;};
N.prototype.exit=function(){this._mFocusObject=null;};
N.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var b=p.getId();if(!this._mVisitedPages[b]){this._mVisitedPages[b]=true;var n={from:null,fromId:null,to:p,toId:b,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
N.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,b,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;b=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=N._applyAutoFocusTo(b);if(f){this._mFocusObject[b]=f;}}n={from:null,fromId:null,to:p,toId:b,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
N.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var b=sap.ui.getCore().byId(p);if(b){return b;}else{q.sap.log.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var c=this.getPages();return(c.length>0?c[0]:null);};
N.prototype.getPage=function(p){var b=this.getPages();for(var i=0;i<b.length;i++){if(b[i]&&(b[i].getId()==p)){return b[i];}}return null;};
N.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),mode:"initial",data:d||{}});}}return this._pageStack;};
N.prototype.getCurrentPage=function(){var s=this._ensurePageStackInitialized();if(s.length>=1){return this.getPage(s[s.length-1].id);}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
N.prototype.getPreviousPage=function(){var s=this._ensurePageStackInitialized();if(s.length>1){return this.getPage(s[s.length-2].id);}else if(s.length==1){return undefined;}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
N.prototype.currentPageIsTopPage=function(){var s=this._ensurePageStackInitialized();return(s.length===1);};
N.prototype.insertPreviousPage=function(p,t,d){var s=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=s.length-1;var b={id:p,mode:t,data:d};if(i===0){b.mode="initial";delete s[s.length-1].mode;}s.splice(i,0,b);}else{q.sap.log.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
N._applyAutoFocusTo=function(i){var f=q.sap.byId(i).firstFocusableDomRef();if(f){q.sap.focus(f);}return f;};
N.prototype._applyAutoFocus=function(n){var p=n.toId,d,A=this.getAutoFocus(),b=n.isBack||n.isBackToPage||n.isBackToTop;if(b){d=this._mFocusObject[p];if(d){q.sap.focus(d);}else if(A){N._applyAutoFocusTo(p);}}else if(n.isTo&&A){N._applyAutoFocusTo(p);}};
N.prototype._afterTransitionCallback=function(n,d,b){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=b||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;this._applyAutoFocus(n);this.fireAfterNavigate(n);q.sap.log.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){q.sap.log.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}if(this._aQueue.length>0){var f=this._aQueue.shift();f();}};
N.prototype.to=function(p,t,d,T){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};this._ensurePageStackInitialized(d);if(this._bNavigating){q.sap.log.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var f=this.getCurrentPage();if(f&&(f.getId()===p)){q.sap.log.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");return this;}var o=this.getPage(p);if(o){if(!f){q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}this._mFocusObject[f.getId()]=document.activeElement;var n={from:f,fromId:f.getId(),to:o,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to"};var c=this.fireNavigate(n);if(c){sap.m.closeKeyboard();var e=q.Event("BeforeHide",n);e.srcControl=this;f._handleEvent(e);if(!this._mVisitedPages[p]){e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=d||{};e.backData={};o._handleEvent(e);}e=q.Event("BeforeShow",n);e.srcControl=this;e.data=d||{};e.backData={};o._handleEvent(e);this._pageStack.push({id:p,mode:t,data:d});q.sap.log.info(this.toString()+": navigating to page '"+p+"': "+o.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){q.sap.log.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());return this;}var b;if(!(b=o.getDomRef())||b.parentNode!=this.getDomRef()||sap.ui.core.RenderManager.isPreservedContent(b)){o.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+o.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(o,this.getDomRef());r.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var h=N.transitions[t]||N.transitions["slide"];var i=this._iTransitionsCompleted;var j=this;window.setTimeout(function(){if(j&&(j._iTransitionsCompleted<i+1)){q.sap.log.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;h.to.call(this,f,o,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{q.sap.log.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
N.prototype.back=function(b,t){this._backTo("back",b,t);return this;};
N.prototype.backToPage=function(p,b,t){this._backTo("backToPage",b,t,p);return this;};
N.prototype.backToTop=function(b,t){this._backTo("backToTop",b,t);return this;};
N.prototype._backTo=function(t,b,T,r){if(this._bNavigating){q.sap.log.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,b,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&this._pageStack[0].mode!="initial"){throw new Error("Initial page not found on the stack. How did this happen?");}return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var m=f.mode;var F=this.getPage(f.id);var o;var c;if(t==="backToTop"){o=this._getActualInitialPage();c=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}c=i.data;}else{o=this.getPreviousPage();c=this._pageStack[this._pageStack.length-2].data;}if(!o){q.sap.log.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var d=o.getId();b=b||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:d,firstTime:!this._mVisitedPages[d],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t};var e=this.fireNavigate(n);if(e){sap.m.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[d]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=b||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=b||{};E.data=c||{};o._handleEvent(E);this._pageStack.pop();q.sap.log.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[d]=true;if(t==="backToTop"){this._pageStack=[];q.sap.log.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],h;while(this._pageStack[this._pageStack.length-1].id!==r){h=this._pageStack.pop();p.push(h.id);}q.sap.log.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){q.sap.log.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var j=N.transitions[m]||N.transitions["slide"];var k=this._iTransitionsCompleted;var l=this;window.setTimeout(function(){if(l&&(l._iTransitionsCompleted<k+1)){q.sap.log.warning("Transition '"+m+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var s;if(!(s=o.getDomRef())||s.parentNode!=this.getDomRef()||sap.ui.core.RenderManager.isPreservedContent(s)){o.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var v=sap.ui.getCore().createRenderManager();var w=this.$().children().index(F.getDomRef());v.renderControl(o);v.flush(this.getDomRef(),false,w);v.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){q.sap.log.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,c,b);return this;}j.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,c,b);},this),T);}}return this;};
N.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var b=this._pageStack[i];if(b.id===r){return b;}}return null;};
N.transitions=N.transitions||{};N.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};if(q.support.cssTransitions){N.transitions["slide"]={to:function(f,t,c){f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){t.addStyleClass("sapMNavItemRight");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(60));},0);},back:function(f,t,c){t.addStyleClass("sapMNavItemLeft");t.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);if(sap.ui.Device.browser.webkit){window.setTimeout(function(){t.$().css("box-shadow","0em 1px 0em rgba(128, 128, 1280, 0.1)");window.setTimeout(function(){t.$().css("box-shadow","");},g(50));},0);}t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(100));}};}else{N.transitions["slide"]={to:function(f,t,c){var T=t.$();T.css("left","100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"-100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});},back:function(f,t,c){var T=t.$();T.css("left","-100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});}};}if(q.support.cssTransitions){N.transitions["fade"]={to:function(f,t,c){t.addStyleClass("sapMNavItemTransparent");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;f.addStyleClass("sapMNavItemHidden");t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");c();};t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));},back:function(f,t,c){f.addStyleClass("sapMNavItemOpaque");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;f.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemTransparent");c();};f.$().bind("webkitTransitionEnd transitionend",A);f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");f.addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));}};}else{N.transitions["fade"]={to:function(f,t,c){var T=t.$();T.css("opacity","0");t.removeStyleClass("sapMNavItemHidden");T.animate({opacity:"1"},g(500),function(){f.addStyleClass("sapMNavItemHidden");c();});},back:function(f,t,c){var F=f.$();t.removeStyleClass("sapMNavItemHidden");F.animate({opacity:"0"},g(500),function(){f.addStyleClass("sapMNavItemHidden");F.css("opacity","1");c();});}};}if(q.support.cssTransitions){N.transitions["flip"]={to:function(f,t,c){var b=this;window.setTimeout(function(){b.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemFlipping");f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");b.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var b=this;b.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemFlipping");f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");b.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};}else{N.transitions["flip"]=N.transitions["slide"];}if(q.support.cssTransitions){N.transitions["door"]={to:function(f,t,c){var b=this;window.setTimeout(function(){b.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");b.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var b=this;b.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");b.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};}else{N.transitions["door"]=N.transitions["slide"];}
N.prototype.addCustomTransition=function(n,t,b){if(N.transitions[n]){q.sap.log.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}N.transitions[n]={to:t,back:b};return this;};
N.addCustomTransition=N.prototype.addCustomTransition;N.prototype.forceInvalidation=N.prototype.invalidate;
N.prototype.invalidate=function(s){if(s==this){}else if(!s){this.forceInvalidation();}else if(s instanceof C){var I=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===s){I=true;break;}}if((!I||s===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
N.prototype._isInsideAPopup=function(){return this.getParent()instanceof sap.m.Popover;};
N.prototype.removePage=function(p){p=this.removeAggregation("pages",p,p!==this.getCurrentPage());this._onPageRemoved(p);return p;};
N.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var s=this._ensurePageStackInitialized();this._pageStack=s.filter(function(o){return p.getId()!==o.id;});};
N.prototype.removeAllPages=function(){var p=this.getPages();if(!p){return[];}for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return this.removeAllAggregation("pages");};
N.prototype.addPage=function(p){var b=this.getPages();if(q.inArray(p,b)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=b.length;if(i===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
N.prototype.insertPage=function(p,i){this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");var b=this.getPages().length;if(b===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
N.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
N.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return N;},true);
sap.ui.predefine('sap/m/NavContainerRenderer',['jquery.sap.global'],function(q){"use strict";var N={};
N.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMNav");if(c.getWidth()){r.addStyle("width",c.getWidth());}var h=c.getHeight();if(h&&h!="100%"){r.addStyle("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}r.writeClasses();r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(this.renderBeforeContent){this.renderBeforeContent(r,c);}var C=c.getCurrentPage();if(C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NewsContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text'],function(q,l,C,T){"use strict";
var N=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},aggregations:{"contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
N.prototype.init=function(){this._oContentText=new sap.m.Text(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
N.prototype.getAltText=function(){var a="";var i=true;if(this.getAggregation("contentTextAgr").getText()){a+=this.getAggregation("contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){a+=""+this.getSubheader();}else{a+="\n"+this.getSubheader();}}return a;};
N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
N.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
N.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();};
N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
N.prototype.attachEvent=function(e,d,f,a){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
N.prototype.detachEvent=function(e,f,a){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return N;},true);
sap.ui.predefine('sap/m/NewsContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var s=c.getSubheader();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttributeEscaped("title",t);r.writeAttribute("id",c.getId()+"-news-content");r.writeAttribute("role","presentation");if(sap.ui.Device.browser.firefox){r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+""+t);}else{r.writeAttributeEscaped("aria-label",c.getAltText().replace(/\s/g," ")+" "+t);}r.addClass("sapMNwC");if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNwCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMNwCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NotificationListBase',['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Text','./Image','./OverflowToolbar','sap/ui/core/Icon'],function(q,l,C,L,T,I,O,a){'use strict';
var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});
N.prototype.init=function(){this.setAggregation('_overflowToolbar',new O());};
N.prototype.setTitle=function(t){var r=this.setProperty('title',t,true);this._getHeaderTitle().setText(t);return r;};
N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d,true);this._getDateTimeText().setText(d);return r;};
N.prototype.setAuthorName=function(b){var r=this.setProperty('authorName',b,true);this._getAuthorName().setText(b);return r;};
N.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');c.setAggregation("_overflowToolbar",o.clone(),true);return c;};
N.prototype.close=function(){var p=this.getParent();this.fireClose();if(p&&p instanceof sap.ui.core.Element){p.focus();}};
N.prototype.bindAggregation=function(b,c){if(b=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',c);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,b,c);}};
N.prototype.validateAggregation=function(b,o,m){if(b=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,b,o,m);}};
N.prototype.setAggregation=function(b,o,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,b,o,s);}};
N.prototype.getAggregation=function(b,d){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(c){return c instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,b,d);}};
N.prototype.indexOfAggregation=function(b,o){if(b=='buttons'){this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);return this;}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,b,o);}};
N.prototype.insertAggregation=function(b,o,c,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,c,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,c,s);}};
N.prototype.addAggregation=function(b,o,s){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,b,o,s);}};
N.prototype.removeAggregation=function(b,o,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,b,o,s);}};
N.prototype.removeAllAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,b,s);}};
N.prototype.destroyAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,b,s);}};
N.prototype.getBinding=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,b);}};
N.prototype.getBindingInfo=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,b);}};
N.prototype.getBindingPath=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,b);}};
N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};
N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new sap.m.Text({id:this.getId()+'-datetime',text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};
N.prototype._getAuthorName=function(){var b=this.getAggregation('_authorName');if(!b){b=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',b,true);}return b;};
N.prototype._getAuthorImage=function(){var b=this.getAggregation('_authorImage');if(!b){var c=this.getAuthorPicture();var d=this.getAuthorName();if(i(c)){b=new a({src:c,alt:d});}else{b=new I({src:c,alt:d});}this.setAggregation('_authorImage',b,true);}return b;};
N.prototype._getToolbar=function(){var t=this.getAggregation("_overflowToolbar");if(!t){t=new O();this.setAggregation("_overflowToolbar",t,true);}return t;};
function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}
return N;},true);
sap.ui.predefine('sap/m/NotificationListGroup',['jquery.sap.global','./library','sap/ui/core/Control','./NotificationListBase'],function(q,l,C,N){'use strict';
var a=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true}},aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'}}}});
a.prototype.init=function(){sap.m.NotificationListBase.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation("_collapseButton",b,true);};
a.prototype.setCollapsed=function(b){this._toggleCollapsed();return this.setProperty('collapsed',b,true);};
a.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=sap.ui.core.Priority.None;if(n){n.forEach(function(i){p=c(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};
a.prototype.getUnread=function(){var n=this.getAggregation('items');if(n){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};
a.prototype.onBeforeRendering=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var e=r.getText('NOTIFICATION_LIST_GROUP_EXPAND');var b=r.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(this.getCollapsed()?e:b);};
a.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
a.prototype._getHeaderTitle=function(){var t=sap.m.NotificationListBase.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};
a.prototype._getDateTimeText=function(){var d=sap.m.NotificationListBase.prototype._getDateTimeText.call(this);d.setTextAlign('End');return d;};
a.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var e=r.getText('NOTIFICATION_LIST_GROUP_EXPAND');var b=r.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(n?e:b,true);this.$().toggleClass('sapMNLG-Collapsed',n);};
function c(f,s){if(f==s){return f;}if((f=='None')){return s;}if((f=='Low')&&(s!='None')){return s;}if((f=='Medium')&&(s!='None'&&s!='Low')){return s;}return f;}
return a;},true);
sap.ui.predefine('sap/m/NotificationListGroupRenderer',[],function(){'use strict';var N={};var c='sapMNLG';var a='sapMNLB';var b='sapMLIB';var d='sapMNLB-AuthorPicture';var e='sapMNLB-Header';var f='sapMNLG-Header';var g='sapMNLG-Body';var h='sapMNLB-Footer';var i='sapMNLG-Footer';var j='sapMNLB-CloseButton';var k='sapMNLB-Priority';var l='sapMNLG-Details';var m='sapMNLB-Bullet';var n='sapMNLG-Description';var o='sapMNLG-Collapsed';
N.render=function(r,C){r.write('<li');r.addClass(c);r.addClass(a);r.addClass(b);if(C.getCollapsed()){r.addClass(o);}r.writeClasses();r.writeControlData(C);r.writeAttribute('tabindex','0');r.writeAccessibilityState(C,{labelledby:C._getHeaderTitle().getId()});r.write('>');this.renderHeader(r,C);this.renderBody(r,C);this.renderFooter(r,C);r.write('</li>');};
N.renderHeader=function(r,C){r.write('<div');r.addClass(e);r.addClass(f);r.writeClasses();r.write('>');this.renderPriorityArea(r,C);this.renderCloseButton(r,C);this.renderTitle(r,C);this.renderDetails(r,C);r.write('</div>');};
N.renderTitle=function(r,C){r.renderControl(C._getHeaderTitle());};
N.renderCloseButton=function(r,C){if(C.getShowCloseButton()){r.renderControl(C.getAggregation('_closeButton').addStyleClass(j));}};
N.renderAuthorPicture=function(r,C){if(!C.getAuthorPicture()){return;}r.write('<div');r.addClass(d);r.writeClasses();r.write('>');r.renderControl(C._getAuthorImage());r.write('</div>');};
N.renderDetails=function(r,C){r.write('<div class="'+l+'">');this.renderAuthorPicture(r,C);r.write('<div class="'+n+'">');this.renderAuthorName(r,C);if(C.getAuthorName()!=""&&C.getDatetime()!=""){r.write('<span class="'+m+'">&#x00B7</span>');}this.renderDatetime(r,C);r.write('</div></div>');};
N.renderAuthorName=function(r,C){r.renderControl(C._getAuthorName());};
N.renderBody=function(r,C){r.write('<ul class='+g+'>');this.renderNotifications(r,C);r.write('</ul>');};
N.renderDatetime=function(r,C){r.renderControl(C._getDateTimeText());};
N.renderNotifications=function(r,C){var p=C.getAggregation('items');if(p){p.forEach(function(q){r.renderControl(q);});}};
N.renderFooter=function(r,C){var p=C.getButtons();r.write('<div');r.addClass(i);r.addClass(h);r.writeClasses();r.write('>');this.renderPriorityArea(r,C);this.renderCollapseGroupButton(r,C);if(p&&p.length&&C.getShowButtons()){r.renderControl(C.getAggregation('_overflowToolbar'));}r.write('</div>');};
N.renderPriorityArea=function(r,C){r.write('<div');var p='';var q=C.getPriority();switch(q){case(sap.ui.core.Priority.Low):p='sapMNLB-Low';break;case(sap.ui.core.Priority.Medium):p='sapMNLB-Medium';break;case(sap.ui.core.Priority.High):p='sapMNLB-High';break;default:p='sapMNLB-None';break;}r.addClass(k);r.addClass(p);r.writeClasses();r.write('>');r.write('</div>');};
N.renderCollapseGroupButton=function(r,C){r.renderControl(C.getAggregation('_collapseButton'));};
return N;},true);
sap.ui.predefine('sap/m/NotificationListItem',['jquery.sap.global','./library','sap/ui/core/Control','./NotificationListBase','sap/ui/core/InvisibleText'],function(q,l,C,N,I){'use strict';
var a=N.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{description:{type:'string',group:'Appearance',defaultValue:''},truncate:{type:'boolean',group:'Appearance',defaultValue:true},hideShowMoreButton:{type:'boolean',group:'Appearance',defaultValue:false}},aggregations:{_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"}}}});
a.prototype.init=function(){sap.m.NotificationListBase.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');this.setType('Active');var _=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);b.setText(this.getTruncate()?this._expandText:this._collapseText);this.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.toggle('sapMNLI-TextWrapper--is-expanded');this.getDomRef().querySelector('.sapMNLI-Header').classList.toggle('sapMNLI-TitleWrapper--is-expanded');this._registerResize();}.bind(this)});this.setAggregation("_collapseButton",b,true);this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();};
a.prototype.setDescription=function(d){var r=this.setProperty('description',d,true);this._getDescriptionText().setText(d);return r;};
a.prototype.setDatetime=function(d){var r=sap.m.NotificationListBase.prototype.setDatetime.call(this,d);this._updateAriaAdditionalInfo();return r;};
a.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation("_headerTitle");if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};
a.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};
a.prototype.setAuthorPicture=function(b,s){var r=this.setProperty('authorPicture',b,s);this._getAuthorImage().setSrc(b);return r;};
a.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
a.prototype.onBeforeRendering=function(){this._deregisterResize();};
a.prototype.onAfterRendering=function(){this._registerResize();};
a.prototype.exit=function(){this._deregisterResize();if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};
a.prototype._getDescriptionText=function(){var b=this.getAggregation('_bodyText');if(!b){b=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",b,true);}return b;};
a.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};
a.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var b=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var d=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);this._ariaDetailsText.setText(b+' '+d);};
a.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var b=this.getDomRef('title').parentElement.offsetHeight;var c=this.getDomRef("body").offsetHeight;var d=this.getDomRef("body").parentElement.offsetHeight;return c>d||t>b;};
a.prototype._showHideTruncateButton=function(){var n=this.getDomRef();if(this._canTruncate()&&(!this.getHideShowMoreButton())){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this.getAggregation('_collapseButton').setText(this._expandText);n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');}else{this.getAggregation('_collapseButton').setText(this._collapseText);n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');};
a.prototype._deregisterResize=function(){if(this._sNotificationResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sNotificationResizeHandler);this._sNotificationResizeHandler=null;}};
a.prototype._registerResize=function(){var t=this;t._resizeNotification();this._sNotificationResizeHandler=sap.ui.core.ResizeHandler.register(this.getDomRef(),function(){t._resizeNotification();});};
a.prototype._resizeNotification=function(){var n=this.getDomRef();if(n.offsetWidth>=640){n.classList.add('sapMNLI-LSize');}else{n.classList.remove('sapMNLI-LSize');}this.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');this.getDomRef().querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');this.getDomRef().querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');this.getDomRef().querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');this._showHideTruncateButton();};
return a;},true);
sap.ui.predefine('sap/m/NotificationListItemRenderer',[],function(){'use strict';var N={};var c='sapMNLI';var a='sapMNLB';var b='sapMNLI-TextWrapper';var d='sapMLIB';var e='sapMNLB-AuthorPicture';var f='sapMNLB-Priority';var g='sapMNLB-Header';var h='sapMNLI-Header';var i='sapMNLI-Body';var j='sapMNLI-Description';var k='sapMNLI-Details';var l='sapMNLB-Bullet';var m='sapMNLB-Footer';var n='sapMNLI-Footer';var o='sapMNLI-No-Footer';var p='sapMNLB-CloseButton';var q='sapMNLI-CollapseButton';var r='sapMNLI-TitleWrapper--initial-overwrite';var s='sapMNLI-TextWrapper--initial-overwrite';
N.render=function(R,C){var u=C.getId();R.write('<li');R.addClass(c);R.addClass(a);R.addClass(d);R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{role:"listitem",labelledby:u+'-title',describedby:(u+'-body')+' '+(u+'-info')});R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderHeader(R,C);this.renderBody(R,C);this.renderFooter(R,C);R.write('</li>');};
N.renderPriorityArea=function(R,C){R.write('<div');var u='';switch(C.getPriority()){case(sap.ui.core.Priority.Low):u='sapMNLB-Low';break;case(sap.ui.core.Priority.Medium):u='sapMNLB-Medium';break;case(sap.ui.core.Priority.High):u='sapMNLB-High';break;default:u='sapMNLB-None';break;}R.addClass(f);R.addClass(u);R.writeClasses();R.write('>');R.write('</div>');};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(e);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(p));}};
N.renderCollapseButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton').addStyleClass(q));};
N.renderHeader=function(R,C){R.write('<div');R.addClass(g);R.addClass(h);R.addClass(r);if(t(C)){R.addClass(o);}R.writeClasses();R.write('>');this.renderCloseButton(R,C);this.renderTitle(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderBody=function(R,C){R.write('<div');R.addClass(i);if(t(C)){R.addClass(o);}R.writeClasses();R.write('>');this.renderAuthorPicture(R,C);R.write('<div class='+j+'>');this.renderDescription(R,C);this.renderDetails(R,C);R.write('</div>');this.renderAriaText(R,C);R.write('</div>');};
N.renderDescription=function(R,C){R.write('<div');R.addClass(b);R.addClass(s);R.writeClasses();R.write('>');R.renderControl(C._getDescriptionText());R.write('</div>');};
N.renderDetails=function(R,C){R.write('<div class="'+k+'">');this.renderAuthorName(R,C);if(C.getAuthorName()){R.write('<span class="'+l+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderAriaText=function(R,C){R.renderControl(C._ariaDetailsText);};
N.renderFooter=function(R,C){var B=C.getButtons();R.write('<div');R.addClass(n);R.addClass(m);R.writeClasses();R.write('>');this.renderCollapseButton(R,C);if(B&&B.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
function t(C){return C.getHideShowMoreButton()&&(!C.getShowButtons()||!C.getButtons());}
return N;},true);
sap.ui.predefine('sap/m/NumericContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool'],function(q,l,C,T,H,I){"use strict";
var N=C.extend("sap.m.NumericContent",{metadata:{library:"sap.m",properties:{"animateTextChange":{type:"boolean",group:"Misc",defaultValue:true},"formatterValue":{type:"boolean",group:"Misc",defaultValue:false},"icon":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"iconDescription":{type:"string",group:"Misc",defaultValue:null},"indicator":{type:"sap.m.DeviationIndicator",group:"Misc",defaultValue:sap.m.DeviationIndicator.None},"nullifyValue":{type:"boolean",group:"Misc",defaultValue:true},"scale":{type:"string",group:"Misc",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:sap.m.ValueColor.Neutral},"width":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},"withMargin":{type:"boolean",group:"Appearance",defaultValue:true},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:sap.m.LoadState.Loaded}},events:{"press":{}}}});
N.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setTooltip("{AltText}");};
N.prototype.onAfterRendering=function(){if(sap.m.LoadState.Loaded==this.getState()||this.getAnimateTextChange()){q.sap.byId(this.getId()).animate({opacity:"1"},1000);}};
N.prototype.exit=function(){if(this._oIcon){this._oIcon.destroy();}};
N.prototype.getAltText=function(){var v=this.getValue();var s=this.getScale();var e;var m=this._rb.getText(("SEMANTIC_COLOR_"+this.getValueColor()).toUpperCase());var a="";if(this.getNullifyValue()){e="0";}else{e="";}if(this.getIconDescription()){a=a.concat(this.getIconDescription());a=a.concat("\n");}if(v){a=a.concat(v+s);}else{a=a.concat(e);}a=a.concat("\n");if(this.getIndicator()&&this.getIndicator()!=sap.m.DeviationIndicator.None){a=a.concat(this._rb.getText(("NUMERICCONTENT_DEVIATION_"+this.getIndicator()).toUpperCase()));a=a.concat("\n");}a=a.concat(m);return a;};
N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
N.prototype.setIcon=function(u){var v=!q.sap.equal(this.getIcon(),u);if(v){if(this._oIcon){this._oIcon.destroy();this._oIcon=undefined;}if(u){this._oIcon=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-icon-image",src:u},sap.m.Image);}}return this.setProperty("icon",u);};
N.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}this.firePress();};
N.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE){e.preventDefault();}};
N.prototype.attachEvent=function(e,d,f,a){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
N.prototype.detachEvent=function(e,f,a){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
N.prototype._parseFormattedValue=function(v){var t=v.replace(String.fromCharCode(8206),"").replace(String.fromCharCode(8207),"");return{scale:t.replace(/[+-., \d]*(.*)$/g,"$1").trim().replace(/\.$/,""),value:t.replace(/([+-., \d]*).*$/g,"$1").trim()};};
return N;},true);
sap.ui.predefine('sap/m/ObjectAttribute',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var O=C.extend("sap.m.ObjectAttribute",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:false},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{parameters:{domRef:{type:"string"}}}}}});
O.MAX_LINES={SINGLE_LINE:1,MULTI_LINE:2};
O.prototype.init=function(){this.setAggregation('_textControl',new sap.m.Text());};
O.prototype._getUpdatedTextControl=function(){var a=this.getAggregation('customContent')||this.getAggregation('_textControl'),t=this.getTitle(),T=this.getAggregation('customContent')?this.getAggregation('customContent').getText():this.getText(),s=this.getTextDirection(),p=this.getParent(),P=sap.ui.getCore().getConfiguration().getRTL(),m=O.MAX_LINES.MULTI_LINE,w=true,o='';if(s===sap.ui.core.TextDirection.LTR&&P){o='\u200e';}if(s===sap.ui.core.TextDirection.RTL&&!P){o='\u200f';}T=o+T+o;if(t){T=t+": "+T;}a.setProperty('text',T,true);if(p instanceof sap.m.ObjectListItem){w=false;m=O.MAX_LINES.SINGLE_LINE;}this._setControlWrapping(a,w,m);return a;};
O.prototype._setControlWrapping=function(a,w,m){if(a instanceof sap.m.Link){a.setProperty('wrapping',w,true);}if(a instanceof sap.m.Text){a.setProperty('maxLines',m,true);}};
O.prototype.ontap=function(e){if(this._isSimulatedLink()&&(e.target.id!=this.getId())){this.firePress({domRef:this.getDomRef()});}};
sap.m.ObjectAttribute.prototype.onsapenter=function(e){if(this._isSimulatedLink()){this.firePress({domRef:this.getDomRef()});e.setMarked();}};
sap.m.ObjectAttribute.prototype.onsapspace=function(e){this.onsapenter(e);};
O.prototype._isEmpty=function(){if(this.getAggregation('customContent')&&!(this.getAggregation('customContent')instanceof sap.m.Link||this.getAggregation('customContent')instanceof sap.m.Text)){q.sap.log.warning("Only sap.m.Link or sap.m.Text are allowed in \"sap.m.ObjectAttribute.customContent\" aggregation");return true;}return!(this.getText().trim()||this.getTitle().trim());};
O.prototype.ontouchstart=function(e){if(this._isSimulatedLink()){e.originalEvent._sapui_handledByControl=true;}};
O.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("text");};
O.prototype._isSimulatedLink=function(){return this.getActive()&&!this.getAggregation('customContent');};
return O;},true);
sap.ui.predefine('sap/m/ObjectAttributeRenderer',['jquery.sap.global'],function(q){"use strict";var O={};
O.render=function(r,o){var p=o.getParent(),t=o.getTooltip_AsString();if(o._isEmpty()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMObjectAttributeDiv");if(o._isSimulatedLink()){r.addClass("sapMObjectAttributeActive");r.writeAttribute("tabindex","0");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(o.getActive()&&!o.getAggregation("customContent")){r.writeAccessibilityState(o,{role:"link"});}r.write(">");if(p&&(p instanceof sap.m.ObjectHeader)){this.renderTitleInObjectHeader(r,o);this.renderTextInObjectHeader(r,o);}else{r.renderControl(o._getUpdatedTextControl());}r.write("</div>");};
O.renderTitleInObjectHeader=function(r,o){if(!o.getProperty("title")){return;}r.write("<span id=\""+o.getId()+"-title\"");r.addClass("sapMObjectAttributeTitle");r.writeClasses();r.write(">");r.writeEscaped(o.getProperty("title"));r.write("</span>");r.write("<span id=\""+o.getId()+"-colon\"");r.addClass("sapMObjectAttributeColon");r.writeClasses();r.write(">");r.write(":&nbsp;");r.write("</span>");};
O.renderTextInObjectHeader=function(r,o){var t=o.getTextDirection(),a=o.getAggregation("customContent");r.write("<span id=\""+o.getId()+"-text\"");r.addClass("sapMObjectAttributeText");if(t&&t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeClasses();r.write(">");if(a){if(!o.getParent().getResponsive()){o._setControlWrapping(a,true,sap.m.ObjectAttribute.MAX_LINES.MULTI_LINE);}else{o._setControlWrapping(a,false,sap.m.ObjectAttribute.MAX_LINES.SINGLE_LINE);}r.renderControl(a);}else{r.writeEscaped(o.getProperty("text"));}r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var O=C.extend("sap.m.ObjectHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},introActive:{type:"boolean",group:"Misc",defaultValue:null},titleActive:{type:"boolean",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconActive:{type:"boolean",group:"Misc",defaultValue:null},iconAlt:{type:"string",group:"Accessibility",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},condensed:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"},responsive:{type:"boolean",group:"Behavior",defaultValue:false},fullScreenOptimized:{type:"boolean",group:"Appearance",defaultValue:false},titleHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},titleTarget:{type:"string",group:"Behavior",defaultValue:null},introHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},introTarget:{type:"string",group:"Behavior",defaultValue:null},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},titleSelectorTooltip:{type:"string",group:"Misc",defaultValue:"Options"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.H1}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},secondStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},statuses:{type:"sap.ui.core.Control",multiple:true,singularName:"status"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"},additionalNumbers:{type:"sap.m.ObjectNumber",multiple:true,singularName:"additionalNumber"},headerContainer:{type:"sap.m.ObjectHeaderContainer",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{titlePress:{parameters:{domRef:{type:"object"}}},introPress:{parameters:{domRef:{type:"object"}}},iconPress:{parameters:{domRef:{type:"object"}}},titleSelectorPress:{parameters:{domRef:{type:"object"}}}}}});
O.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oPlaceholderIcon=I.createControlByURI({id:this.getId()+"-placeholder",useIconTooltip:false,src:I.getIconURI("fridge")});this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");this._oFlagIcon=I.createControlByURI({id:this.getId()+"-flag",tooltip:L.getText("TOOLTIP_OH_FLAG_MARK_VALUE"),src:I.getIconURI("flag"),visible:false});this._oFavIcon=I.createControlByURI({id:this.getId()+"-favorite",tooltip:L.getText("TOOLTIP_OH_FAVORITE_MARK_VALUE"),src:I.getIconURI("favorite"),visible:false});this._oTitleArrowIcon=I.createControlByURI({id:this.getId()+"-titleArrow",src:I.getIconURI("arrow-down"),decorative:false,visible:false,tooltip:L.getText("OH_SELECT_ARROW_TOOLTIP"),size:"1.375rem",press:function(e){}});this._fNumberWidth=undefined;this._titleText=new sap.m.Text(this.getId()+"-titleText");this._titleText.setMaxLines(3);};
O.prototype.insertAttribute=function(a,i){var r=this.insertAggregation("attributes",a,i);this._registerControlListener(a);return r;};
O.prototype.addAttribute=function(a){var r=this.addAggregation("attributes",a);this._registerControlListener(a);return r;};
O.prototype.removeAttribute=function(a){var r=this.removeAggregation("attributes",a);this._deregisterControlListener(r);return r;};
O.prototype.removeAllAttributes=function(){var a=this.removeAllAggregation("attributes");a.forEach(this._deregisterControlListener,this);return a;};
O.prototype.destroyAttributes=function(){var a=this.getAggregation("attributes");if(a!==null){a.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("attributes");};
O.prototype.insertStatus=function(s,i){var r=this.insertAggregation("statuses",s,i);this._registerControlListener(s);return r;};
O.prototype.addStatus=function(s){var r=this.addAggregation("statuses",s);this._registerControlListener(s);return r;};
O.prototype.removeStatus=function(s){var r=this.removeAggregation("statuses",s);this._deregisterControlListener(r);return r;};
O.prototype.removeAllStatuses=function(){var s=this.removeAllAggregation("statuses");s.forEach(this._deregisterControlListener,this);return s;};
O.prototype.destroyStatuses=function(){var s=this.getAggregation("statuses");if(s!==null){s.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("statuses");};
O.prototype._registerControlListener=function(c){if(c){c.attachEvent("_change",this.invalidate,this);}};
O.prototype._deregisterControlListener=function(c){if(c){c.detachEvent("_change",this.invalidate,this);}};
O.prototype.setCondensed=function(c){this.setProperty("condensed",c);if(this.getCondensed()){this._oTitleArrowIcon.setSize("1rem");}else{this._oTitleArrowIcon.setSize("1.375rem");}return this;};
O.prototype.setNumber=function(n){this.setProperty("number",n);this._getObjectNumber().setNumber(n);return this;};
O.prototype.setNumberUnit=function(u){this.setProperty("numberUnit",u);this._getObjectNumber().setUnit(u);return this;};
O.prototype.setNumberState=function(s){this.setProperty("numberState",s,true);this._getObjectNumber().setState(s);return this;};
O.prototype.setTitleSelectorTooltip=function(t){this.setProperty("titleSelectorTooltip",t,false);this._oTitleArrowIcon.setTooltip(t);return this;};
O.prototype._getObjectNumber=function(){var c=this.getAggregation("_objectNumber");if(!c){c=new sap.m.ObjectNumber(this.getId()+"-number",{emphasized:false});this.setAggregation("_objectNumber",c,true);}return c;};
O.prototype.getFocusDomRef=function(){if(this.getResponsive()){return this.$("txt");}else{return this.$("title");}};
O.prototype.ontap=function(e){var s=e.target.id;if(this.getIntroActive()&&s===this.getId()+"-intro"){if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(e.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(!this.getTitleHref()){e.preventDefault();s=this.getId()+"-title";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(e.target).parent().attr('id')===this.getId()+"-txt")){if(!this.getTitleHref()){e.preventDefault();s=this.getId()+"-txt";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&(s===this.getId()+"-img"||s===this.getId()+"-icon")){this.fireIconPress({domRef:q.sap.domById(s)});}else if(s===this.getId()+"-titleArrow"){this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
O.prototype._handleSpaceOrEnter=function(e){var s=e.target.id;e.setMarked();if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(e.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(e.type==="sapspace"){e.preventDefault();}s=this.getId()+"-title";if(!this.getTitleHref()){e.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(e.type==="sapspace"){this._linkClick(e,s);}}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(e.target).parent().attr('id')===this.getId()+"-txt")){if(e.type==="sapspace"){e.preventDefault();}s=this.getId()+"-txt";if(!this.getTitleHref()){e.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(e.type==="sapspace"){this._linkClick(e,s);}}}else if(this.getIntroActive()&&s===this.getId()+"-intro"){if(e.type==="sapspace"){e.preventDefault();}if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&q(e.target).hasClass('sapMOHIcon')){if(e.type==="sapspace"){e.preventDefault();}var i=q.sap.domById(this.getId()+"-icon");if(!i){i=q.sap.domById(this.getId()+"-img");}this.fireIconPress({domRef:i});}else if(s===this.getId()+"-titleArrow"){if(e.type==="sapspace"){e.preventDefault();}this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
O.prototype.onsapspace=O.prototype._handleSpaceOrEnter;O.prototype.onsapenter=O.prototype._handleSpaceOrEnter;
O.prototype._linkClick=function(e,s){e.setMarked();var c=document.createEvent('MouseEvents');c.initEvent('click',false,true);q.sap.domById(s).dispatchEvent(c);};
O.prototype._onOrientationChange=function(){var i=this.getId();if(sap.ui.Device.system.tablet&&this.getFullScreenOptimized()&&(this._hasAttributes()||this._hasStatus())){this._rerenderStates();}if(sap.ui.Device.system.phone){if(sap.ui.Device.orientation.portrait){if(this.getTitle().length>50){this._rerenderTitle(50);}if(this.getIcon()){q.sap.byId(i+"-titlediv").removeClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").addClass("sapMOHRHideIcon");}}else{if(sap.ui.Device.orientation.landscape){if(this.getTitle().length>80){this._rerenderTitle(80);}if(this.getIcon()){q.sap.byId(i+"-titlediv").addClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").removeClass("sapMOHRHideIcon");}}}this._adjustNumberDiv();}this._adjustIntroDiv();};
O.prototype._rerenderTitle=function(n){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderTitle(r,this,n);r.destroy();};
O.prototype._rerenderStates=function(){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderResponsiveStates(r,this);r.destroy();};
O.prototype.exit=function(){if(sap.ui.Device.system.desktop){sap.ui.Device.media.detachHandler(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.detachHandler(this._onOrientationChange,this);}if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=undefined;}if(this._oPlaceholderIcon){this._oPlaceholderIcon.destroy();this._oPlaceholderIcon=undefined;}if(this._oFavIcon){this._oFavIcon.destroy();this._oFavIcon=undefined;}if(this._oFlagIcon){this._oFlagIcon.destroy();this._oFlagIcon=undefined;}if(this._oTitleArrowIcon){this._oTitleArrowIcon.destroy();this._oTitleArrowIcon=undefined;}if(this._titleText){this._titleText.destroy();this._titleText=undefined;}if(this._introText){this._introText.destroy();this._introText=undefined;}};
O.prototype._getImageControl=function(){var i=this.getId()+"-img";var s="2.5rem";var p=q.extend({src:this.getIcon(),alt:this.getIconAlt(),useIconTooltip:false,densityAware:this.getIconDensityAware()},I.isIconURI(this.getIcon())?{size:s}:{});this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};
O.prototype.onBeforeRendering=function(){if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.detachHandler(this._onOrientationChange,this);}if(sap.ui.Device.system.desktop){sap.ui.Device.media.detachHandler(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}if(this._introText){this._introText.destroy();this._introText=undefined;}};
O.prototype.onAfterRendering=function(){var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();var $=this.$("titleArrow");$.attr("role","button");if(this.getResponsive()){this._adjustIntroDiv();if(o&&o.getNumber()){if(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Desktop")&&this.getFullScreenOptimized()&&this._iCountVisAttrStat>=1&&this._iCountVisAttrStat<=3){o.setTextAlign(p?sap.ui.core.TextAlign.Right:sap.ui.core.TextAlign.Left);}else{o.setTextAlign(p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right);}}this._adjustNumberDiv();if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.attachHandler(this._onOrientationChange,this);}if(sap.ui.Device.system.desktop){sap.ui.Device.media.attachHandler(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}}else{var t=p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right;if(o&&o.getNumber()){o.setTextAlign(t);}if(this.getAdditionalNumbers()){this._setTextAlignANum(t);}}};
O.prototype._rerenderOHR=function(){this.invalidate();};
O.prototype._adjustNumberDiv=function(){var i=this.getId();var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();if(o&&o.getNumber()){var $=q.sap.byId(i+"-number");var a=q.sap.byId(i+"-titlediv");if(sap.ui.Device.system.phone||(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Phone"))){if($.hasClass("sapMObjectNumberBelowTitle")){o.setTextAlign(p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right);$.removeClass("sapMObjectNumberBelowTitle");a.removeClass("sapMOHRTitleDivFull");}var n=$.parent().width()*0.4;if($.outerWidth()>n){o.setTextAlign(p?sap.ui.core.TextAlign.Right:sap.ui.core.TextAlign.Left);$.addClass("sapMObjectNumberBelowTitle");a.addClass("sapMOHRTitleDivFull");}}}};
O.prototype._adjustIntroDiv=function(){var i=this.getId();var $=q.sap.byId(i+"-txt");var a=q.sap.byId(i+"-titleArrow");var b=q.sap.byId(i+"-intro");if(b.parent().hasClass("sapMOHRIntroMargin")){b.parent().removeClass("sapMOHRIntroMargin");}if(a.height()!==null&&($.height()<a.height())){b.parent().addClass("sapMOHRIntroMargin");}};
O._escapeId=function(i){return i?"#"+i.replace(/(:|\.)/g,'\\$1'):"";};
O.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this.getShowMarkers());};
O.prototype._hasIcon=function(){return!!this.getIcon().trim();};
O.prototype._hasAttributes=function(){var a=this.getAttributes();if(a&&a.length>0){for(var i=0;i<a.length;i++){if(!a[i]._isEmpty()){return true;}}}return false;};
O.prototype._hasStatus=function(){var h=((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));if(!h&&this.getStatuses()&&this.getStatuses().length>0){var s=this.getStatuses();for(var i=0;i<s.length;i++){if(s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty()){h=true;break;}else if(s[i]instanceof sap.m.ProgressIndicator){h=true;break;}}}return h;};
O.prototype._getDefaultBackgroundDesign=function(){if(this.getCondensed()){return sap.m.BackgroundDesign.Solid;}else{if(this.getResponsive()){return sap.m.BackgroundDesign.Translucent;}else{return sap.m.BackgroundDesign.Transparent;}}};
O.prototype._getBackground=function(){if(this.getBackgroundDesign()===undefined){return this._getDefaultBackgroundDesign();}else{return this.getBackgroundDesign();}};
O.prototype._setTextAlignANum=function(t){var n=this.getAdditionalNumbers();for(var i=0;i<n.length;i++){n[i].setTextAlign(t);}};
return O;},true);
sap.ui.predefine('sap/m/ObjectHeaderRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var O={};
O._isEmptyObject=function(o){if(!o){return true;}if((!o._isEmpty||!o._isEmpty())&&(!o.getVisible||o.getVisible())){return false;}return true;};
O._isEmptyArray=function(a){if(a){for(var i=0;i<a.length;i++){if(!O._isEmptyObject(a[i])){return false;}}}return true;};
O._isEmptyRow=function(l,r){return O._isEmptyObject(l)&&O._isEmptyArray(r);};
O._renderObjects=function(r,o,a){for(var i=0;i<o.length;i++){if(o[i]instanceof sap.ui.core.Control){this._renderChildControl(r,a,o[i]);}}};
O._computeChildControlsToBeRendered=function(o){o.__controlsToBeRendered={};var c=o.getAttributes();for(var i=0;i<c.length;i++){o.__controlsToBeRendered[c[i].getId()]=c[i];}c=o.getStatuses();for(var i=0;i<c.length;i++){o.__controlsToBeRendered[c[i].getId()]=c[i];}var C=o.getFirstStatus();if(C){o.__controlsToBeRendered[C.getId()]=C;}C=o.getSecondStatus();if(C){o.__controlsToBeRendered[C.getId()]=C;}C=o.getAggregation("_objectNumber");if(C){o.__controlsToBeRendered[C.getId()]=C;}};
O._cleanupNotRenderedChildControls=function(r,o){for(var i in o.__controlsToBeRendered){r.cleanupControlWithoutRendering(o.__controlsToBeRendered[i]);}delete o.__controlsToBeRendered;};
O._renderMarkersAria=function(r,c){var a="",l=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(c.getMarkFlagged()){a+=(l.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){a+=(l.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(a!==""){r.write("<div");r.writeAttribute("id",c.getId()+"-markers-aria");r.writeAttribute("aria-hidden","false");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(a);r.write("</div>");}};
O._getIcons=function(o){var i=[];if(o.getShowMarkers()){o._oFavIcon.setVisible(o.getMarkFavorite());o._oFlagIcon.setVisible(o.getMarkFlagged());i.push(o._oPlaceholderIcon);i.push(o._oFavIcon);i.push(o._oFlagIcon);}return i;};
O._renderIntro=function(r,o,i,s){if(o.getIntroActive()){o._introText=new sap.m.Link(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setHref(o.getIntroHref());o._introText.setTarget(o.getIntroTarget());o._introText.press=o.introPress;}else{o._introText=new sap.m.Text(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setMaxLines(3);}o._introText.setTextDirection(o.getIntroTextDirection());r.write("<div");r.addClass(i);if(o.getIntroActive()){r.addClass(s);}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._introText);r.write("</div>");};
O._renderAttribute=function(r,o,a,f){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();if(f){r.addStyle("width","100%");r.writeStyles();}r.write(">");this._renderChildControl(r,o,a);r.write("</div>");};
O._getVisibleStatuses=function(o){var v=[];if(o.getFirstStatus()&&o.getFirstStatus().getVisible()){v.push([o.getFirstStatus()]);}if(o.getSecondStatus()&&o.getSecondStatus().getVisible()){v.push([o.getSecondStatus()]);}if(o.getStatuses()){var s=o.getStatuses();for(var i=0;i<s.length;i++){if(!s[i].getVisible||s[i].getVisible()){if(s[i]instanceof sap.m.ObjectStatus||s[i]instanceof sap.m.ProgressIndicator){v.push([s[i]]);}else{q.sap.log.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation."+" Current object is "+s[i].constructor.getMetadata().getName()+" with id \""+s[i].getId()+"\"");}}}}return v;};
O._getVisibleAttribsAndStatuses=function(o){var r=[],a=o.getAttributes(),v=[];for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var V=this._getVisibleStatuses(o);r[0]=v;r[1]=V;return r;};
O._renderRow=function(r,o,l,R){if(O._isEmptyRow(l,R)){return;}r.write("<div");r.addClass("sapMOHAttrRow");r.writeClasses();r.write(">");if(!O._isEmptyObject(l)){this._renderAttribute(r,o,l,O._isEmptyArray(R));}else if(O._isEmptyObject(l)&&!O._isEmptyArray(R)){if(R[0]instanceof sap.m.ProgressIndicator){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();r.write(">");r.write("</div>");}}if(!O._isEmptyArray(R)){r.write("<div");if(R[0]instanceof sap.m.ProgressIndicator){r.addClass("sapMOHStatusFixedWidth");}else if(R[0]instanceof sap.ui.core.Icon){r.addClass("sapMOHStatusFixedWidth");r.addClass("sapMObjStatusMarker");r.writeAttribute("aria-describedby",o.getId()+"-markers-aria");}else{r.addClass("sapMOHStatus");}r.writeClasses();r.write(">");O._renderObjects(r,R,o);r.write("</div>");}r.write("</div>");};
O._renderAttributesAndStatuses=function(r,o){var a=o.getAttributes();var v=[];for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var A=v.length;var i=[];var b=O._getIcons(o);if(!o.getResponsive()&&!O._isEmptyArray(b)){i.push(b);}var V=this._getVisibleStatuses(o);i=i.concat(V);var c=i.length;var n=A>c?A:c;if(!o.getResponsive()){if(o.getShowMarkers()){this._renderMarkersAria(r,o);}for(var C=0;C<n;C++){this._renderRow(r,o,v[C],i[C]);}}};
O._renderNumber=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){return;}r.write("<div");r.writeAttribute("id",o.getId()+"-numberdiv");r.addClass("sapMOHNumberDiv");r.writeClasses();r.write(">");var a=o.getAggregation("_objectNumber");if(a&&a.getNumber()){a.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,a);}r.write("</div>");if(!o.getCondensed()){this._renderAdditionalNumbers(r,o);}};
O._renderAdditionalNumbers=function(r,o){var n=o.getAdditionalNumbers();if(n&&!n.length){return;}if(n.length===1){r.write("<div");r.addClass("additionalOHNumberSeparatorDiv");r.writeClasses();r.write("></div>");}for(var i=0;i<n.length;i++){r.write("<div");r.writeAttribute("id",o.getId()+"-additionalNumber"+i);r.addClass("sapMOHNumberDiv additionalOHNumberDiv");if(n.length===1){r.addClass("sapMOHOnlyANumber");}r.writeClasses();r.write(">");n[i].setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,n[i]);r.write("</div>");}};
O._renderTitle=function(r,o){o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("<div");r.addClass("sapMOHTitleAndArrow");r.writeClasses();r.write(">");}if(o.getTitle()){var t=(o.getTitleLevel()===sap.ui.core.TitleLevel.Auto)?sap.ui.core.TitleLevel.H1:o.getTitleLevel();o._titleText.setText(o.getTitle());o._titleText.setTextDirection(o.getTitleTextDirection());if(o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}else{r.writeAttribute("href","javascript:void(0);");}r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<span");}r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHTitle");if(o.getTitleActive()){r.writeAttribute("tabindex","0");r.addClass("sapMOHTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHTitleFollowArrow");}r.writeClasses();r.write(">");r.write("<"+t+">");this._renderChildControl(r,o,o._titleText);r.write("</"+t+">");if(o.getTitleActive()){r.write("</a>");}else{r.write("</span>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("</div>");}};
O._renderFullTitle=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){r.addClass("sapMOHTitleDivFull");}};
O._renderFullOH=function(r,o){var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(o.getIntro()){this._renderIntro(r,o,"sapMOHIntro","sapMOHIntroActive");}r.write("<div");r.addClass("sapMOHTopRow");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");if(o._hasIcon()){r.addClass("sapMOHTitleIcon");}this._renderFullTitle(r,o);r.writeClasses();r.write(">");if(o._hasIcon()){r.write("<div");r.addClass("sapMOHIcon");if(o.getIconActive()){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");r.writeAccessibilityState({role:"link",haspopup:true,label:l.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._getImageControl());r.write("</div>");}this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);r.write("<div class=\"sapMOHDivider\"/>");r.write("</div>");if(o._hasBottomContent()){r.write("<div");r.addClass("sapMOHBottomRow");r.writeClasses();r.write(">");this._renderAttributesAndStatuses(r,o);r.write("<div class=\"sapMOHDivider\"/>");r.write("</div>");}};
O._renderCondensedOH=function(r,o){r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");this._renderFullTitle(r,o);r.writeClasses();r.write(">");this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);var f=o.getAttributes()[0];if(f&&!f._isEmpty()){this._renderAttribute(r,o,f);}};
O.render=function(r,o){if(o.getResponsive()){this._renderResponsive(r,o);return;}this._computeChildControlsToBeRendered(o);var c=o.getCondensed();r.write("<div");r.writeControlData(o);r.addClass("sapMOH");if(c){r.addClass("sapMOHC");}r.addClass("sapMOHBg"+o._getBackground());r.writeClasses();var t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-titleText-inner",append:true}});r.write(">");if(c){this._renderCondensedOH(r,o);}else{this._renderFullOH(r,o);}r.write("<div class=\"sapMOHLastDivider\"/>");r.write("</div>");this._cleanupNotRenderedChildControls(r,o);};
O._renderChildControl=function(r,o,c){r.renderControl(c);if(!o.getResponsive()&&o.__controlsToBeRendered){o.__controlsToBeRendered[c.getId()]=undefined;}};
O._renderResponsive=function(r,o){var s=this._hasResponsiveStates(o),t=this._hasResponsiveTabs(o),h=o.getHeaderContainer();r.write("<div");r.addClass("sapMOHROuter");r.writeClasses();r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-txt",append:true}});r.writeControlData(o);r.write(">");r.write("<div");r.addClass("sapMOHR");if(t){r.addClass("sapMOHRNoBorder");}r.addClass("sapMOHRBg"+o._getBackground());r.writeClasses();r.write(">");r.write("<div");if(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Desktop")&&o.getFullScreenOptimized()&&o._iCountVisAttrStat>=1&&o._iCountVisAttrStat<=3){r.addClass("sapMOHRStatesOneOrThree");}r.writeClasses();r.write(">");this._renderResponsiveTitleBlock(r,o);if(s){this._renderResponsiveStates(r,o);}r.write("</div>");if(t){this._renderResponsiveTabs(r,o);}r.write("</div>");if(h&&h instanceof sap.m.IconTabBar){this._renderChildControl(r,o,h);}r.write("</div>");if(!o.getTitle()){if(!o.getBinding("title")){q.sap.log.warning("The title shouldn't be empty!");}}};
O._renderResponsiveTitleBlock=function(r,c){var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write("<div");r.writeAttribute("id",c.getId()+"-titlenumdiv");r.addClass("sapMOHRTitleNumberDiv");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-titlediv");r.addClass("sapMOHRTitleDiv");if(c._hasIcon()){if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){if(sap.ui.Device.orientation.landscape||(q('html').hasClass("sapUiMedia-Std-Phone")&&!sap.ui.Device.system.phone)){r.addClass("sapMOHRTitleIcon");}}else{r.addClass("sapMOHRTitleIcon");}}if(!c.getNumber()){r.addClass("sapMOHRTitleDivFull");}r.writeClasses();r.write(">");this._renderResponsiveTitle(r,c);if(c._hasIcon()){r.write("<div");r.writeAttribute("id",c.getId()+"-titleIcon");r.addClass("sapMOHRIcon");if((sap.ui.Device.system.phone&&sap.ui.Device.orientation.portrait)){r.addClass("sapMOHRHideIcon");}if(c.getIconActive()){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:true,label:l.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,c,c._getImageControl());r.write("</div>");}r.write("</div>");this._renderResponsiveNumber(r,c);r.write("</div>");};
O._renderResponsiveStates=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-states");r.addClass("sapMOHRStates");r.writeClasses();r.write(">");this._renderResponsiveRow(r,c);r.write("</div>");};
O._renderResponsiveRow=function(r,o){var v=[];v=this._getVisibleAttribsAndStatuses(o);var V=v[0].concat(v[1]),c=v[0].length,C=V.length,R=1,s='';if(C===0){return;}if(sap.ui.Device.system.desktop){if(!o.getFullScreenOptimized()){if(C>=1&&C<=4){R=2;s='sapMOHRTwoCols';}if(C>=5){R=3;s='sapMOHRThreeCols';}}else{if(C>=1&&C<=3){R=1;s='sapMOHROneCols';}if(C>=4){R=4;s='sapMOHRFourCols';}}}if(sap.ui.Device.system.tablet||(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Tablet"))){if(!o.getFullScreenOptimized()||(sap.ui.Device.orientation.portrait&&o.getFullScreenOptimized())){R=2;s='sapMOHRTwoCols';}else{if(o.getFullScreenOptimized()&&(sap.ui.Device.orientation.landscape||(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Tablet")))){if(C>=1&&C<=2){R=2;s='sapMOHRTwoCols';}if(C>=3){R=3;s='sapMOHRThreeCols';}}}}if(sap.ui.Device.system.phone||(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Phone"))){R=1;s='sapMOHROneCols';}this._renderResponsiveStatesColumn(r,o,R,V,c,s);};
O._renderResponsiveStatesColumn=function(r,o,R,v,c,C){var a=Math.floor(v.length/R);var b=v.length%R;var d=0;var e=1;for(var i=0;i<v.length;i++){if(d==0){r.write("<div");r.addClass("sapMOHRStatesCont"+e);r.addClass(C);r.writeClasses();r.write(">");}if(i<c){this._renderResponsiveAttribute(r,o,v[i]);}else{this._renderResponsiveStatus(r,o,v[i]);}d++;if((d==a&&e>b)||(d==(a+1)&&e<=b)||i==v.length-1){r.write("</div>");d=0;e++;}}};
O._renderResponsiveAttribute=function(r,o,a){r.write("<div");r.addClass("sapMOHRAttr");r.writeClasses();r.write(">");this._renderChildControl(r,o,a);r.write("</div>");};
O._renderResponsiveStatus=function(r,o,s){r.write("<div");r.addClass("sapMOHRStatus");r.writeClasses();r.write(">");this._renderChildControl(r,o,s[0]);r.write("</div>");};
O._renderResponsiveMarkers=function(r,c){var a=[],t=c.getTitleTextDirection(),p=sap.ui.getCore().getConfiguration().getRTL();if(c.getShowMarkers()){c._oFavIcon.setVisible(c.getMarkFavorite());c._oFlagIcon.setVisible(c.getMarkFlagged());a.push(c._oFavIcon);a.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.write("<span");r.addClass("sapMObjStatusMarker");if((t===sap.ui.core.TextDirection.LTR&&p)||(t===sap.ui.core.TextDirection.RTL&&!p)){r.addClass("sapMObjStatusMarkerOpposite");}r.writeClasses();r.writeAttribute("id",c.getId()+"-markers");r.writeAttribute("aria-describedby",c.getId()+"-markers-aria");r.write(">");for(var i=0;i<a.length;i++){this._renderChildControl(r,c,a[i]);}r.write("</span>");}};
O._renderResponsiveNumber=function(r,c){var o=c.getAggregation("_objectNumber");if(o&&o.getNumber()){o.setTextDirection(c.getNumberTextDirection());this._renderChildControl(r,c,o);}};
O._hasResponsiveStates=function(c){var a=c.getAttributes(),v=[];if(!(c._hasAttributes()||c._hasStatus())){c._iCountVisAttrStat=0;return false;}for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var V=this._getVisibleStatuses(c);c._iCountVisAttrStat=v.length+V.length;return!!(v.length+V.length);};
O._hasResponsiveTabs=function(c){var h=c.getHeaderContainer(),i;if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();if(i.getVisible()){c._iCountVisTabs=i.getItems().length;return!!i.getItems().length;}}else if(sap.suite&&sap.suite.ui&&sap.suite.ui.commons&&h instanceof sap.suite.ui.commons.HeaderContainer){return!!h.getItems().length;}}return false;};
O._renderResponsiveTabs=function(r,c){var h=c.getHeaderContainer(),i;r.write("<div class=\"sapMOHRTabs"+(h instanceof sap.m.IconTabBar?" sapMOHRTabsITB":"")+"\">");if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();this._renderChildControl(r,c,i);h._bHideHeader=true;}else if(sap.suite&&sap.suite.ui&&sap.suite.ui.commons&&h instanceof sap.suite.ui.commons.HeaderContainer){this._renderChildControl(r,c,h);}else{q.sap.log.warning("The control "+h+" is not supported for aggregation \"headerContainer\"");}}r.write("</div>");};
O._renderResponsiveTitle=function(r,o){var n;o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());r.write("<div");r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHRTitle");if(o.getTitle().length&&o.getTitleActive()){r.addClass("sapMOHRTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHRTitleFollowArrow");}r.writeClasses();r.write(">");if((sap.ui.Device.system.phone&&sap.ui.Device.orientation.portrait)){n=50;}else{n=80;}r.write("<span");r.writeAttribute("id",o.getId()+"-title-arrow");r.write(">");this._renderResponsiveTitleAndArrow(r,o,n);r.write("</span>");if(o.getIntro()){this._renderIntro(r,o,"sapMOHRIntro","sapMOHRIntroActive");}r.write("</div>");};
O._rerenderTitle=function(r,o,n){var i=o.getId();this._renderResponsiveTitleAndArrow(r,o,n);r.flush(q.sap.byId(i+"-title-arrow"));};
O._renderResponsiveTitleAndArrow=function(r,o,n){var s,e='',t=o.getTitleTextDirection();var m=(o.getShowMarkers()&&(o.getMarkFavorite()||o.getMarkFlagged()));var T=(o.getTitleLevel()===sap.ui.core.TitleLevel.Auto)?sap.ui.core.TitleLevel.H1:o.getTitleLevel();r.write("<"+T+">");r.write("<span");r.addClass("sapMOHRTitleTextContainer");r.writeClasses();if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");if(o.getTitle().length&&o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}else{r.writeAttribute("href","javascript:void(0);");}r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<span");}r.writeAttribute("id",o.getId()+"-txt");r.addClass("sapMOHRTitleText");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapMOHRTitleTextWrappable");r.writeClasses();r.write(">");if(o.getTitle().length>n){s=o.getTitle().substr(0,n).trim();e='...';}else{s=o.getTitle();}if(m){var a=s.substr(s.lastIndexOf(" ")+1);var b=s.substr(0,s.lastIndexOf(" ")+1);if(a.length===1){a=s;b='';}r.writeEscaped(b);r.write("</span>");r.writeEscaped(a);r.write(e);if(o.getTitleActive()){r.write("</a>");}else{r.write("</span>");}this._renderResponsiveMarkers(r,o);r.write("</span>");}else{if(!e){r.writeEscaped(s);}else{r.writeEscaped(s+e);}if(o.getTitleActive()){r.write("</span></a></span>");}else{r.write("</span></span></span>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHRTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}r.write("</"+T+">");};
O._rerenderResponsiveStates=function(r,o){var i=o.getId(),v=this._getVisibleAttribsAndStatuses(o),V=v[0].concat(v[1]),c=v[0].length,C=V.length,R=1,s='';if(C===0){return;}if(sap.ui.Device.orientation.portrait){R=2;s='sapMOHRTwoCols';}else{if(C>=1&&C<=2){R=2;s='sapMOHRTwoCols';}if(C>=3){R=3;s='sapMOHRThreeCols';}}this._renderResponsiveStatesColumn(r,o,R,V,c,s);r.flush(q.sap.byId(i+"-states")[0]);};
return O;},true);
sap.ui.predefine('sap/m/ObjectIdentifier',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var O=C.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
O.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null;}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null;}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null;}if(this._oAriaInfoTextControl){this._oAriaInfoTextControl.destroy();this._oAriaInfoTextControl=null;}};
O.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(I.getIconURI("attachment"),this.getId()+"-attachments");}return this._attachmentsIcon;};
O.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(I.getIconURI("group"),this.getId()+"-people");}return this._peopleIcon;};
O.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(I.getIconURI("notes"),this.getId()+"-notes");}return this._notesIcon;};
O.prototype._getIcon=function(u,i){var s=sap.ui.Device.system.phone?"1em":"1em";var o;o=this._icon||I.createControlByURI({src:u,id:i+"-icon",size:s,useIconTooltip:false},sap.m.Image);o.setSrc(u);return o;};
O.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl"),i;if(!t){this._createAriaInfoTextControl();if(this.getProperty("titleActive")){t=new sap.m.Link({text:this.getProperty("title"),ariaLabelledBy:this._oAriaInfoTextControl});}else{t=new sap.m.Text({text:this.getProperty("title")});}this.setAggregation("_titleControl",t);}else{i=this.getProperty("titleActive");if(i&&t instanceof sap.m.Text){this.destroyAggregation("_titleControl",true);t=new sap.m.Link({text:this.getProperty("title"),ariaLabelledBy:this._oAriaInfoTextControl});this.setAggregation("_titleControl",t);}else if(!i&&t instanceof sap.m.Link){this.destroyAggregation("_titleControl",true);t=new sap.m.Text({text:this.getProperty("title")});this.setAggregation("_titleControl",t);}}t.setVisible(!!this.getTitle());return t;};
O.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new sap.m.Text({text:this.getProperty("text")});this.setAggregation("_textControl",t,true);}t.setTextDirection(this.getTextDirection());t.setVisible(!!this.getText());return t;};
O.prototype._rerenderTitle=function(){var t=this._getTitleControl();t.setProperty("text",this.getProperty("title"),true);var r=sap.ui.getCore().createRenderManager();r.renderControl(t);r.flush(this.$("title")[0]);r.destroy();};
O.prototype.setTitle=function(t){var T=this._getTitleControl();T.setProperty("text",t,false);T.setVisible(!!t);this.setProperty("title",t,true);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
O.prototype.setText=function(t){this.setProperty("text",t,true);var T=this._getTextControl();T.setProperty("text",t,false);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
O.prototype.setTitleActive=function(v){var p=this.getProperty("titleActive");if(p!=v){this.setProperty("titleActive",v,true);if(this.$("title").children().length>0){this._rerenderTitle();}}return this;};
O.prototype._handlePress=function(e){var c=e.target;if(this.getTitleActive()&&this.$("title")[0].firstChild==c){this.fireTitlePress({domRef:c});e.setMarked();}};
O.prototype.onsapenter=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype.onsapspace=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype.ontap=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype._createAriaInfoTextControl=function(){var a;var A=this.getAssociation("ariaLabelledBy");if(A&&A instanceof Array&&A.length>0){var r=[];var R=[];A.forEach(function(i){var c=sap.ui.getCore().byId(i);if(c){r.push(i);var s=c.getText();if(s){R.push(s);}}});a=new sap.m.Text(this.getId()+"-sapSRH",{text:"Object Identifier "+R.join(" ")}).addStyleClass("sapUiInvisibleText");}else{a=new sap.m.Text(this.getId()+"-sapSRH",{text:"Object Identifier"}).addStyleClass("sapUiInvisibleText");}this._oAriaInfoTextControl=a;return a;};
return O;},true);
sap.ui.predefine('sap/m/ObjectIdentifierRenderer',['jquery.sap.global'],function(q){"use strict";var O={};
O.render=function(r,o){var t;if(!o.getVisible()){return;}r.write("<div");r.writeControlData(o);r.writeAccessibilityState(o);r.addClass("sapMObjectIdentifier");r.writeClasses();t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierTopRow");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierIcons");r.writeClasses();r.write(">");if(o.getBadgeAttachments()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getAttachmentsIcon());r.write("</span>");}if(o.getBadgeNotes()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getNotesIcon());r.write("</span>");}if(o.getBadgePeople()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getPeopleIcon());r.write("</span>");}r.write("</div>");r.write("<div id='"+o.getId()+"-title'");r.addClass("sapMObjectIdentifierTitle");r.writeClasses();r.write(">");r.renderControl(o._getTitleControl());if(o.getProperty("titleActive")){r.renderControl(o._oAriaInfoTextControl);}r.write("</div>");r.write("</div>");r.write("<div id='"+o.getId()+"-text'");r.addClass("sapMObjectIdentifierText");if(!!o.getProperty("text")&&!!o.getProperty("title")){r.addClass("sapMObjectIdentifierTextBellow");}r.writeClasses();r.write(">");r.renderControl(o._getTextControl());r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectListItem.designtime',[],function(){"use strict";return{aggregations:{firstStatus:{domRef:":sap-domref .sapMObjLStatus1DivEmpty"},secondStatus:{domRef:":sap-domref .sapMObjLStatus2DivEmpty"},attributes:{domRef:":sap-domref .sapMObjLAttrDivEmpty"}}};},false);
sap.ui.predefine('sap/m/ObjectListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/IconPool'],function(q,L,l,I){"use strict";
var O=L.extend("sap.m.ObjectListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:null},markFlagged:{type:"boolean",group:"Misc",defaultValue:null},showMarkers:{type:"boolean",group:"Misc",defaultValue:null},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},markLocked:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false},secondStatus:{type:"sap.m.ObjectStatus",multiple:false}},designtime:true}});
var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");
O.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(this._oPlaceholderIcon){this._oPlaceholderIcon.destroy();this._oPlaceholderIcon=undefined;}if(this._oFavIcon){this._oFavIcon.destroy();this._oFavIcon=undefined;}if(this._oFlagIcon){this._oFlagIcon.destroy();this._oFlagIcon=undefined;}if(this._oLockIcon){this._oLockIcon.destroy();this._oLockIcon=undefined;}if(this._oTitleText){this._oTitleText.destroy();this._oTitleText=undefined;}L.prototype.exit.apply(this);};
O.prototype._hasAttributes=function(){var a=this.getAttributes();if(a.length>0){for(var i=0;i<a.length;i++){if(!a[i]._isEmpty()){return true;}}}return false;};
O.prototype._hasStatus=function(){return((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));};
O.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this.getShowMarkers()||this.getMarkLocked());};
O.prototype._getVisibleAttributes=function(){var a=this.getAttributes();var v=[];for(var i=0;i<a.length;i++){if(a[i].getVisible()){v.push(a[i]);}}return v;};
O.prototype._getImageControl=function(){var i=this.getId()+'-img';var s="2.5rem";var p;if(I.isIconURI(this.getIcon())){p={src:this.getIcon(),height:s,width:s,size:s,useIconTooltip:false,densityAware:this.getIconDensityAware()};}else{p={src:this.getIcon(),useIconTooltip:false,densityAware:this.getIconDensityAware()};}var c=['sapMObjLIcon'];this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p,c);return this._oImageControl;};
O.prototype._activeHandlingInheritor=function(){var a=this.getActiveIcon();if(!!this._oImageControl&&!!a){this._oImageControl.setSrc(a);}};
O.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon();if(!!this._oImageControl){this._oImageControl.setSrc(s);}};
O.prototype._getPlaceholderIcon=function(){if(!this._oPlaceholderIcon){var p=I.getIconURI("fridge");this._oPlaceholderIcon=I.createControlByURI({id:this.getId()+"-placeholder",useIconTooltip:false,src:p});this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");}return this._oPlaceholderIcon;};
O.prototype._getFlagIcon=function(){if(!this._oFlagIcon){var f=I.getIconURI("flag");this._oFlagIcon=I.createControlByURI({id:this.getId()+"-flag",tooltip:o.getText("TOOLTIP_OLI_FLAG_MARK_VALUE"),src:f});}return this._oFlagIcon;};
O.prototype._getLockIcon=function(){if(!this._oLockIcon){var a=I.getIconURI("locked");this._oLockIcon=I.createControlByURI({id:this.getId()+"-lock",tooltip:o.getText("TOOLTIP_OLI_LOCK_MARK_VALUE"),src:a}).addStyleClass("sapMObjStatusMarkerLocked");}return this._oLockIcon;};
O.prototype._getFavoriteIcon=function(){if(!this._oFavIcon){var f=I.getIconURI("favorite");this._oFavIcon=I.createControlByURI({id:this.getId()+"-favorite",tooltip:o.getText("TOOLTIP_OLI_FAVORITE_MARK_VALUE"),src:f});}return this._oFavIcon;};
O.prototype._getTitleText=function(){if(!this._oTitleText){this._oTitleText=new sap.m.Text(this.getId()+"-titleText",{maxLines:2});this._oTitleText.setParent(this,null,true);}return this._oTitleText;};
return O;},true);
sap.ui.predefine('sap/m/ObjectListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var O=R.extend(L);
O.renderAttributeStatus=function(r,l,a,s){if(!a&&!s||(a&&a._isEmpty()&&s&&s._isEmpty())){return;}r.write("<div");r.addClass("sapMObjLAttrRow");r.writeClasses();r.write(">");if(a&&!a._isEmpty()){r.write("<div");r.addClass("sapMObjLAttrDiv");if(s&&(!s._isEmpty())){if(s instanceof Array){r.addClass("sapMObjAttrWithMarker");}}r.writeClasses();if(!s||s._isEmpty()){r.addStyle("width","100%");r.writeStyles();}r.write(">");r.renderControl(a);r.write("</div>");}if(s&&(!s._isEmpty())){r.write("<div");r.addClass("sapMObjLStatusDiv");if(s instanceof Array){r.addClass("sapMObjStatusMarker");}r.writeClasses();if(!a||a._isEmpty()){r.addStyle("width","100%");r.writeStyles();}r.write(">");if(s instanceof Array){while(s.length>0){r.renderControl(s.shift());}}else{r.renderControl(s);}r.write("</div>");}r.write("</div>");};
O.renderLIAttributes=function(r,l){r.addClass("sapMObjLItem");r.addClass("sapMObjLListModeDiv");};
O.renderLIContent=function(r,l){var t=l.getTitleTextDirection(),i=l.getIntroTextDirection(),n=l.getNumberTextDirection();if(l.getIntro()){r.write("<div");r.addClass("sapMObjLIntro");r.writeClasses();r.writeAttribute("id",l.getId()+"-intro");r.write(">");r.write("<span");if(i!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",i.toLowerCase());}r.write(">");r.writeEscaped(l.getIntro());r.write("</span>");r.write("</div>");}r.write("<div");r.addClass("sapMObjLTopRow");r.writeClasses();r.write(">");if(!!l.getIcon()){r.write("<div");r.addClass("sapMObjLIconDiv");r.writeClasses();r.write(">");r.renderControl(l._getImageControl());r.write("</div>");}r.write("<div");r.addClass("sapMObjLNumberDiv");r.writeClasses();r.write(">");if(l.getNumber()){r.write("<div");r.writeAttribute("id",l.getId()+"-number");r.addClass("sapMObjLNumber");r.addClass("sapMObjLNumberState"+l.getNumberState());r.writeClasses();if(n!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",n.toLowerCase());}r.write(">");r.writeEscaped(l.getNumber());r.write("</div>");if(l.getNumberUnit()){r.write("<div");r.writeAttribute("id",l.getId()+"-numberUnit");r.addClass("sapMObjLNumberUnit");r.addClass("sapMObjLNumberState"+l.getNumberState());r.writeClasses();r.write(">");r.writeEscaped(l.getNumberUnit());r.write("</div>");}}r.write("</div>");r.write("<div");r.addStyle("display","-webkit-box");r.addStyle("overflow","hidden");r.writeStyles();r.write(">");var T=l._getTitleText();if(T){T.setTextDirection(t);T.setText(l.getTitle());T.addStyleClass("sapMObjLTitle");r.renderControl(T);}r.write("</div>");r.write("</div>");if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10)){r.write("<div style=\"clear: both;\"></div>");}if(l._hasBottomContent()){r.write("<div");r.addClass("sapMObjLBottomRow");r.writeClasses();r.write(">");var a=l._getVisibleAttributes();var s=[];var m=null;if(l.getShowMarkers()||l.getMarkLocked()){var p=l._getPlaceholderIcon();m=[p];m._isEmpty=function(){return false;};if(l.getMarkLocked()){var b=l._getLockIcon();b.setVisible(l.getMarkLocked());m.push(b);}if(l.getShowMarkers()){var f=l._getFavoriteIcon();var c=l._getFlagIcon();f.setVisible(l.getMarkFavorite());c.setVisible(l.getMarkFlagged());m.push(f);m.push(c);}s.push(m);}s.push(l.getFirstStatus());s.push(l.getSecondStatus());while(a.length>0){this.renderAttributeStatus(r,l,a.shift(),s.shift());}while(s.length>0){this.renderAttributeStatus(r,l,null,s.shift());}r.write("</div>");}this.renderAriaNode(r,l,this.getAriaNodeText(l));};
O.renderAriaNode=function(r,l,a){if(a){r.write("<div");r.writeAttribute("id",l.getId()+"-aria");r.writeAttribute("aria-hidden","true");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(a);r.write("</div>");}};
O.getAriaNodeText=function(l){var a=[];var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(l.getMarkFlagged()){a.push(o.getText("ARIA_FLAG_MARK_VALUE"));}if(l.getMarkFavorite()){a.push(o.getText("ARIA_FAVORITE_MARK_VALUE"));}if(l.getMarkLocked()){a.push(o.getText("OBJECTLISTITEM_ARIA_LOCKED_MARK_VALUE"));}return a.join(" ");};
O.getAriaLabelledBy=function(l){var a=[];if(l.getIntro()){a.push(l.getId()+"-intro");}if(l.getTitle()){a.push(l.getId()+"-titleText");}if(l.getNumber()){a.push(l.getId()+"-number");}if(l.getNumberUnit()){a.push(l.getId()+"-numberUnit");}if(l.getAttributes()){l.getAttributes().forEach(function(b){a.push(b.getId());});}if(l.getFirstStatus()){a.push(l.getFirstStatus().getId());}if(l.getSecondStatus()){a.push(l.getSecondStatus().getId());}if(this.getAriaNodeText(l)){a.push(l.getId()+"-aria");}return a.join(" ");};
return O;},true);
sap.ui.predefine('sap/m/ObjectMarker',['jquery.sap.global',"sap/ui/core/Control",'sap/ui/core/Renderer'],function(q,C,R){"use strict";
var O=C.extend("sap.m.ObjectMarker",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ObjectMarkerType",group:"Misc"},visibility:{type:"sap.m.ObjectMarkerVisibility",group:"Misc"}},aggregations:{_innerControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{type:{type:"sap.m.ObjectMarkerType"}}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");O.M_PREDEFINED_TYPES={Flagged:{icon:{src:"sap-icon://flag",visibility:{small:true,large:true}},text:{value:r.getText("OM_FLAG"),visibility:{small:false,large:false}}},Favorite:{icon:{src:"sap-icon://favorite",visibility:{small:true,large:true}},text:{value:r.getText("OM_FAVORITE"),visibility:{small:false,large:false}}},Draft:{icon:{src:"sap-icon://request",visibility:{small:true,large:true}},text:{value:r.getText("OM_DRAFT"),visibility:{small:false,large:true}}},Locked:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:r.getText("OM_LOCKED"),visibility:{small:false,large:true}}},Unsaved:{icon:{src:"sap-icon://user-edit",visibility:{small:false,large:true}},text:{value:r.getText("OM_UNSAVED"),visibility:{small:true,large:true}}}};
O.prototype.init=function(){sap.ui.Device.media.initRangeSet("DeviceSet",[600],"px",["small","large"]);};
O.prototype.onAfterRendering=function(){sap.ui.Device.media.attachHandler(this._handleMediaChange,this,"DeviceSet");};
O.prototype.onBeforeRendering=function(){this._cleanup();};
O.prototype.exit=function(){this._cleanup();};
O.prototype.attachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")&&i&&i instanceof b){i.destroy();this.setAggregation("_innerControl",this._createCustomLink(),true);this._adjustControl();}return this;};
O.prototype.detachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")&&i&&i instanceof d){i.destroy();this.setAggregation("_innerControl",this._createCustomText(),true);this._adjustControl();}return this;};
O.prototype.setVisibility=function(v){this.setProperty("visibility",v);this._adjustControl();return this;};
O.prototype.setType=function(t){this.setProperty("type",t);this._adjustControl();return this;};
O.prototype._cleanup=function(){sap.ui.Device.media.detachHandler(this._handleMediaChange,this,"DeviceSet");};
O.prototype._handleMediaChange=function(){this._adjustControl();};
O.prototype._adjustControl=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],i=this._getInnerControl();if(this._isIconVisible()){i.setIcon(t.icon.src);this.addStyleClass("sapMObjectMarkerIcon");}else{i.setIcon(null);this.removeStyleClass("sapMObjectMarkerIcon");}if(this._isTextVisible()){i.setTooltip(null);i.setText(t.text.value);this.addStyleClass("sapMObjectMarkerText");}else{if(i.getIcon()){i.setTooltip(t.text.value);}i.setText(null);this.removeStyleClass("sapMObjectMarkerText");}};
O.prototype._isIconVisible=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),D=this._getDeviceType(),T=t&&t.icon.visibility[D]||false;return v===sap.m.ObjectMarkerVisibility.IconOnly||v===sap.m.ObjectMarkerVisibility.IconAndText||(v!==sap.m.ObjectMarkerVisibility.TextOnly&&T);};
O.prototype._isTextVisible=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),D=this._getDeviceType(),T=t&&t.text.visibility[D]||false;return v===sap.m.ObjectMarkerVisibility.TextOnly||v===sap.m.ObjectMarkerVisibility.IconAndText||(v!==sap.m.ObjectMarkerVisibility.IconOnly&&T);};
O.prototype._getDeviceType=function(){return sap.ui.Device.media.getCurrentRange("DeviceSet").name.toLowerCase();};
O.prototype._getInnerControl=function(){var i=this.getAggregation("_innerControl");if(!i&&this.getType()){i=this._createInnerControl();this.setAggregation("_innerControl",i,true);this._adjustControl();}return i;};
O.prototype._createInnerControl=function(){if(this.hasListeners("press")){return this._createCustomLink();}else{return this._createCustomText();}};
O.prototype._createCustomLink=function(){var o=new d(this.getId()+"-link",{wrapping:true});o.attachPress(function(e){this.firePress({type:this.getType()});},this);return o;};
O.prototype._createCustomText=function(){return new b(this.getId()+"-text");};
var a=R.extend(sap.m.TextRenderer);
a.renderText=function(o,e){o.renderControl(e._getIconAggregation());sap.m.TextRenderer.renderText(o,e);};
var b=sap.m.Text.extend("CustomText",{
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},
renderer:a
});
b.prototype.setIcon=function(i){var I=this._getIconAggregation();this.setProperty("icon",i,false);I.setSrc(i);};
b.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new sap.ui.core.Icon();this.setAggregation("_iconControl",i);}return i;};
b.prototype.setText=function(t){this.setProperty("text",t,true);};
var c=R.extend(sap.m.LinkRenderer);
c.renderText=function(o,e){o.renderControl(e._getIconAggregation());sap.m.LinkRenderer.renderText(o,e);};
var d=sap.m.Link.extend("CustomLink",{
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},
renderer:c
});
d.prototype.setIcon=function(i){var I=this._getIconAggregation();this.setProperty("icon",i,false);I.setSrc(i);};
d.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new sap.ui.core.Icon();this.setAggregation("_iconControl",i);}return i;};
d.prototype.setText=function(t){this.setProperty("text",t,true);};
return O;},true);
sap.ui.predefine('sap/m/ObjectMarkerRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var O={};
O.render=function(r,c){r.write("<span ");r.writeControlData(c);r.addClass("sapMObjectMarker");if(c._isIconVisible()){r.addClass("sapMObjectMarkerIcon");}if(c._isTextVisible()){r.addClass("sapMObjectMarkerText");}r.writeClasses();r.write(">");r.renderControl(c._getInnerControl());r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectNumber',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Renderer'],function(q,l,C,R){"use strict";
var O=C.extend("sap.m.ObjectNumber",{metadata:{library:"sap.m",properties:{number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null,deprecated:true},emphasized:{type:"boolean",group:"Appearance",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},unit:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin}}}});
O.prototype._sCSSPrefixObjNumberStatus='sapMObjectNumberStatus';
O.prototype.setState=function(s){this.$().removeClass(this._sCSSPrefixObjNumberStatus+this.getState());this.setProperty("state",s,true);this.$().addClass(this._sCSSPrefixObjNumberStatus+this.getState());return this;};
O.prototype.setTextAlign=function(a){var A=R.getTextAlign(a,this.getTextDirection());this.setProperty("textAlign",a,true);A=A||a;this.$().css("text-align",a);};
return O;},true);
sap.ui.predefine('sap/m/ObjectNumberRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var O={};
O.render=function(r,o){var t=o.getTooltip_AsString(),T=o.getTextDirection(),s=o.getTextAlign();r.write("<div");r.writeControlData(o);r.addClass("sapMObjectNumber");r.addClass(o._sCSSPrefixObjNumberStatus+o.getState());if(o.getEmphasized()){r.addClass("sapMObjectNumberEmph");}if(t){r.writeAttributeEscaped("title",t);}if(T!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",T.toLowerCase());}s=R.getTextAlign(s,T);if(s){r.addStyle("text-align",s);}r.writeClasses();r.writeStyles();if(o.getState()!==sap.ui.core.ValueState.None){r.writeAccessibilityState({labelledby:o.getId()+"-state"});}r.write(">");this.renderText(r,o);r.write("  ");this.renderUnit(r,o);this.renderHiddenARIAElement(r,o);r.write("</div>");};
O.renderText=function(r,o){r.write("<span");r.addClass("sapMObjectNumberText");r.writeClasses();r.write(">");r.writeEscaped(o.getNumber());r.write("</span>");};
O.renderUnit=function(r,o){var u=o.getUnit()||o.getNumberUnit();r.write("<span");r.addClass("sapMObjectNumberUnit");r.writeClasses();r.write(">");r.writeEscaped(u);r.write("</span>");};
O.renderHiddenARIAElement=function(r,o){var a="",b=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(o.getState()==sap.ui.core.ValueState.None){return;}r.write("<span id='"+o.getId()+"-state' class='sapUiInvisibleText' aria-hidden='true'>");switch(o.getState()){case sap.ui.core.ValueState.Error:a=b.getText("OBJECTNUMBER_ARIA_VALUE_STATE_ERROR");break;case sap.ui.core.ValueState.Warning:a=b.getText("OBJECTNUMBER_ARIA_VALUE_STATE_WARNING");break;case sap.ui.core.ValueState.Success:a=b.getText("OBJECTNUMBER_ARIA_VALUE_STATE_SUCCESS");break;}r.write(a);r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectStatus',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport'],function(q,l,C,I,V){"use strict";
var O=C.extend("sap.m.ObjectStatus",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}}}});
O.prototype.exit=function(){if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}};
O.prototype._getImageControl=function(){var i=this.getId()+'-icon';var p={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};
O.prototype.setTitle=function(t){var T=this.$().children(".sapMObjStatusTitle"),s=!!T.length&&!!this.validateProperty("title",t).trim();this.setProperty("title",t,s);if(s){T.text(this.getTitle()+":");}return this;};
O.prototype.setText=function(t){var T=this.$().children(".sapMObjStatusText"),s=!!T.length&&!!this.validateProperty("text",t).trim();this.setProperty("text",t,s);if(s){T.text(this.getText());}return this;};
O.prototype._isEmpty=function(){return!(this.getText().trim()||this.getIcon().trim()||this.getTitle().trim());};
O.prototype.getAccessibilityInfo=function(){var s=this.getState()!=sap.ui.core.ValueState.None?V.getAdditionalText(this.getState()):"";return{description:((this.getTitle()||"")+" "+(this.getText()||"")+" "+s).trim()};};
return O;},true);
sap.ui.predefine('sap/m/ObjectStatusRenderer',['jquery.sap.global','sap/ui/core/ValueStateSupport'],function(q,V){"use strict";var O={};
O.render=function(r,o){if(!o._isEmpty()){var s=o.getState();var t=o.getTextDirection();var T=t;r.write("<div");r.writeControlData(o);var a=o.getTooltip_AsString();if(a){r.writeAttributeEscaped("title",a);}r.addClass("sapMObjStatus");r.addClass("sapMObjStatus"+s);r.writeClasses();if(s!=sap.ui.core.ValueState.None){r.writeAccessibilityState(o,{describedby:{value:o.getId()+"sapSRH",append:true}});}r.write(">");if(o.getTitle()){var p=sap.ui.getCore().getConfiguration().getRTL();if(T===sap.ui.core.TextDirection.Inherit){T=p?sap.ui.core.TextDirection.RTL:sap.ui.core.TextDirection.LTR;}r.write("<span");r.writeAttributeEscaped("id",o.getId()+"-title");r.addClass("sapMObjStatusTitle");if(T){r.writeAttribute("dir",T.toLowerCase());}r.writeClasses();r.write(">");r.writeEscaped(o.getTitle()+":");r.write("</span>");}if(o.getIcon()){r.write("<span");r.writeAttributeEscaped("id",o.getId()+"-icon");r.addClass("sapMObjStatusIcon");r.writeClasses();r.write(">");r.renderControl(o._getImageControl());r.write("</span>");}if(o.getText()){r.write("<span");r.writeAttributeEscaped("id",o.getId()+"-text");r.addClass("sapMObjStatusText");if(t&&t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeClasses();r.write(">");r.writeEscaped(o.getText());r.write("</span>");}if(s!=sap.ui.core.ValueState.None){r.write("<span");r.writeAttributeEscaped("id",o.getId()+"sapSRH");r.addClass("sapUiInvisibleText");r.writeClasses();r.writeAccessibilityState({hidden:false});r.write(">");r.writeEscaped(V.getAdditionalText(s));r.write("</span>");}r.write("</div>");}};
return O;},true);
sap.ui.predefine('sap/m/OverflowToolbar',["jquery.sap.global","./library","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls","sap/m/OverflowToolbarPriority","sap/ui/core/IconPool","sap/m/SearchField"],function(q,l,T,I,a,b,O,c,d,e,f,S){"use strict";
var g=a.extend("sap.m.OverflowToolbar",{metadata:{aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}}}});
g.prototype._callToolbarMethod=function(F,A){return a.prototype[F].apply(this,A);};
g.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bListenForControlPropertyChanges=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;if(!g._sAriaOverflowButtonLabelId){var C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");g._sAriaOverflowButtonLabelId=new I({text:C.getText("Icon.overflow")}).toStatic().getId();}this._aControlSizes={};};
g.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}};
g.prototype.onAfterRendering=function(){if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;}if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){this.$().lastFocusableDomRef().focus();this._bOverflowButtonWasFocused=false;}this._getOverflowButton().$().attr("aria-haspopup","true");this._doLayout();};
g.prototype._doLayout=function(){var w=this.$().width();this._bListenForControlPropertyChanges=false;this._deregisterToolbarResize();this._polyfillFlexboxSupport();if(w>0){if(!this._isControlsInfoCached()){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;};
g.prototype._polyfillFlexboxSupport=function(){if(a.hasNewFlexBoxSupport){return;}if(a.hasFlexBoxSupport){var t=this.$();var D=t[0]||{};t.removeClass("sapMTBOverflow");var o=D.scrollWidth>D.clientWidth;o&&t.addClass("sapMTBOverflow");}else{a.flexie(this.$());}};
g.prototype._cacheControlsInfo=function(){var p,C,A;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aActionSheetOnlyControls=[];this._iContentSize=0;this.getContent().forEach(function(o){p=g._getControlPriority(o);C=p!==e.NeverOverflow;A=p===e.AlwaysOverflow;var i=g._getOptimalControlWidth(o,this._aControlSizes[o.getId()]);this._aControlSizes[o.getId()]=i;if(d.supportsControl(o)&&A){this._aActionSheetOnlyControls.push(o);}else{this._iContentSize+=i;if(d.supportsControl(o)&&C){this._aMovableControls.push(o);}else{this._aToolbarOnlyControls.push(o);}}},this);if(sap.ui.Device.system.phone){this._iContentSize-=1;}this._bControlsInfoCached=true;};
g.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};
g.prototype._setControlsOverflowAndShrinking=function(t){var C=this._iContentSize,B=[],s,i,A,F=function(o){o.forEach(function(p){this._moveButtonToActionSheet(p);},this);},h=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this.invalidate();if(this._getControlsIds().indexOf(sap.ui.getCore().getCurrentFocusedControlId())!==-1){this._bControlWasFocused=true;}if(sap.ui.getCore().getCurrentFocusedControlId()===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;}}},j=function(C){if(!this._getOverflowButtonNeeded()){C+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}return C;},k=function(M){var G={},o=[];M.forEach(function(p){var r=g._getControlGroup(p),P=g._oPriorityOrder,u,v,w;if(r){u=g._getControlPriority(p);v=this._getControlIndex(p);G[r]=G[r]||[];w=G[r];w.push(p);if(!w._priority||P[w._priority]<P[u]){w._priority=u;}if(!w._index||w._index<v){w._index=v;}}else{o.push(p);}},this);Object.keys(G).forEach(function(p){o.push(G[p]);});return o;},E=function(M){if(M.length){M.forEach(n,this);}else{n.call(this,M);}if(C<=t){return true;}},m=function(v,o){var p=g._oPriorityOrder,r=g._getControlPriority(v),u=g._getControlPriority(o),P=p[r]-p[u];if(P!==0){return P;}else{return this._getControlIndex(o)-this._getControlIndex(v);}},n=function(o){B.unshift(o);C-=this._aControlSizes[o.getId()];};if(this._bSkipOptimization){this._bSkipOptimization=false;}else{s=this._getPopover()._getContentIdsHash();}this._resetToolbar();if(this._aActionSheetOnlyControls.length){for(i=this._aActionSheetOnlyControls.length-1;i>=0;i--){if(this._aActionSheetOnlyControls[i].getVisible()){B.unshift(this._aActionSheetOnlyControls[i]);}}if(B.length>0){C=j.call(this,C);}}if(C<=t){F.call(this,B);h.call(this,s);return;}if(this._aMovableControls.length){C=j.call(this,C);A=k.call(this,this._aMovableControls);A.sort(m.bind(this));A.some(E,this);}F.call(this,B);if(C>t){this._checkContents();}h.call(this,s);};
g.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(function(B){this._restoreButtonInToolbar(B);},this);this._setOverflowButtonNeeded(false);this.getContent().forEach(function(C){C.removeStyleClass(a.shrinkClass);});};
g.prototype._moveButtonToActionSheet=function(B){this._getPopover().addAssociatedContent(B);};
g.prototype._restoreButtonInToolbar=function(B){if(typeof B==="object"){B=B.getId();}this._getPopover().removeAssociatedContent(B);};
g.prototype._resetAndInvalidateToolbar=function(h){this._resetToolbar();this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;if(h){this._bSkipOptimization=true;}this.invalidate();};
g.prototype._getVisibleContent=function(){var t=this.getContent(),A=this._getPopover()._getAllContent();return t.filter(function(C){return A.indexOf(C)===-1;});};
g.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new T({id:this.getId()+"-overflowButton",icon:f.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:this._sAriaOverflowButtonLabelId,type:sap.m.ButtonType.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};
g.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),B=this._getBestActionSheetPlacement();if(p.getPlacement()!==B){p.setPlacement(B);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};
g.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:sap.ui.Device.system.phone?false:true,contentWidth:sap.ui.Device.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset()});p._adaptPositionParams=function(){c.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(sap.ui.Device.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};
g.prototype._shiftPopupShadow=function(){var p=this._getPopover(),P=p.getCurrentPosition();if(P===sap.m.PlacementType.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(P===sap.m.PlacementType.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};
g.prototype._popOverClosedHandler=function(){this._getOverflowButton().setPressed(false);this._getOverflowButton().$().focus();this._getOverflowButton().setEnabled(false);q.sap.delayedCall(0,this,function(){this._getOverflowButton().setEnabled(true);q.sap.delayedCall(0,this,function(){this._getOverflowButton().$().focus();});});};
g.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};
g.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};
g.prototype.onLayoutDataChange=function(){this._resetAndInvalidateToolbar(true);};
g.prototype.addContent=function(C){this._registerControlListener(C);this._preProcessControl(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("addContent",arguments);};
g.prototype.insertContent=function(C,i){this._registerControlListener(C);this._preProcessControl(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("insertContent",arguments);};
g.prototype.removeContent=function(C){var v=this._callToolbarMethod("removeContent",arguments);this._resetAndInvalidateToolbar(false);this._postProcessControl(v);this._deregisterControlListener(v);return v;};
g.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(function(o){this._deregisterControlListener(o);this._postProcessControl(o);},this);this._resetAndInvalidateToolbar(false);return C;};
g.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);q.sap.delayedCall(0,this,function(){this._resetAndInvalidateToolbar(false);});return this._callToolbarMethod("destroyContent",arguments);};
g.prototype._registerControlListener=function(C){if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};
g.prototype._deregisterControlListener=function(C){if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};
g.prototype._onContentPropertyChangedOverflowToolbar=function(E){if(!this._bListenForControlPropertyChanges){return;}var s=E.getSource();var C=d.getControlConfig(s);var p=E.getParameter("name");if(typeof C!=="undefined"&&C.noInvalidationProps.indexOf(p)!==-1){return;}this._resetAndInvalidateToolbar(true);};
g.prototype._getOverflowButtonSize=function(){var B=parseInt(sap.m.BaseFontSize,10),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3;return parseInt(B*C,10);};
g.prototype._getBestActionSheetPlacement=function(){var h=this.getHTMLTag();if(h==="Footer"){return sap.m.PlacementType.Top;}else if(h==="Header"){return sap.m.PlacementType.Bottom;}return sap.m.PlacementType.Vertical;};
g.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};
g.prototype._preProcessControl=function(C){if(!(C instanceof S)){return;}if(C.getSelectOnFocus()){C.setProperty("selectOnFocus",false,true);C._origSelectOnFocus=true;}};
g.prototype._postProcessControl=function(C){if(!(C instanceof S)){return;}if(typeof C._origSelectOnFocus!=="undefined"){C.setProperty("selectOnFocus",C._origSelectOnFocus,true);delete C._origSelectOnFocus;}};
g.prototype._getControlIndex=function(C){return C.length?C._index:this.indexOfContent(C);};
g._getOptimalControlWidth=function(C,o){var i;if(C instanceof b){i=parseInt(C.$().css('min-width'),10)||0+C.$().outerWidth(true)-C.$().outerWidth();}else{i=C.getVisible()?C.$().outerWidth(true):0;}if(i===null){i=typeof o!=="undefined"?o:0;}return i;};
g._getControlPriority=function(C){if(C.length){return C._priority;}var L=C.getLayoutData&&C.getLayoutData();if(L&&L instanceof O){if(L.getMoveToOverflow()===false){return e.NeverOverflow;}if(L.getStayInOverflow()===true){return e.AlwaysOverflow;}return L.getPriority();}return e.High;};
g._getControlGroup=function(C){var L=C.getLayoutData();if(L instanceof O){return L.getGroup();}};
g._oPriorityOrder=(function(){var p={};p[e.Disappear]=1;p[e.Low]=2;p[e.High]=3;return p;})();
g.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};
g.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();};
return g;},true);
sap.ui.predefine('sap/m/OverflowToolbarAssociativePopover',['./Popover','./PopoverRenderer','./OverflowToolbarAssociativePopoverControls','./OverflowToolbarLayoutData'],function(P,a,O,b){"use strict";
var c=P.extend("sap.m._overflowToolbarHelpers.OverflowToolbarAssociativePopover",{
metadata:{associations:{associatedContent:{type:"sap.ui.core.Control",multiple:true}}},
renderer:a.render
});
c.prototype.init=function(){P.prototype.init.apply(this,arguments);this.oControlsManager=new O();};
c.prototype.onBeforeRendering=function(){P.prototype.onBeforeRendering.apply(this,arguments);this.addStyleClass("sapMOTAPopover");var h=this._getAllContent().some(function(o){return o.hasStyleClass("sapMOTAPButtonWithIcon");});if(h){this.addStyleClass("sapMOTAPButtonsWithIcons");}else{this.removeStyleClass("sapMOTAPButtonsWithIcons");}};
c.prototype.addAssociatedContent=function(o){this.addAssociation("associatedContent",o,true);this._preProcessControl(o);return this;};
c.prototype.removeAssociatedContent=function(o){var r=this.removeAssociation("associatedContent",o,true),d;if(r){d=sap.ui.getCore().byId(r);this._postProcessControl(d);}return r;};
c.prototype._preProcessControl=function(o){var s=O.getControlClass(o),d=O.getControlConfig(o),A,p;d.listenForEvents.forEach(function(e){A="attach"+C(e);o[A](this._closeOnInteraction,this);},this);p="_preProcess"+s.split(".").map(C).join("");if(typeof this.oControlsManager[p]==="function"){this.oControlsManager[p](o);}var l=o.getLayoutData();if(l instanceof b&&l.getPriority()===sap.m.OverflowToolbarPriority.Disappear){o.addStyleClass("sapMOTAPHidden");}return this;};
c.prototype._postProcessControl=function(o){var s=O.getControlClass(o),d=O.getControlConfig(o),D,p;d.listenForEvents.forEach(function(e){D="detach"+C(e);o[D](this._closeOnInteraction,this);},this);p="_postProcess"+s.split(".").map(C).join("");if(typeof this.oControlsManager[p]==="function"){this.oControlsManager[p](o);}o.removeStyleClass("sapMOTAPHidden");o.$().remove();return this;};
c.prototype._closeOnInteraction=function(){this.close();};
c.prototype._getContentIdsHash=function(){return this._getAllContent().join(".");};
c.prototype._getAllContent=function(){var A=this.getAssociatedContent().map(function(i){return sap.ui.getCore().byId(i);});if(this.getPlacement()===sap.m.PlacementType.Top){A.reverse();}return this.getContent().concat(A);};
c.prototype.getCurrentPosition=function(){if(!this._oCalcedPos){this._calcPlacement();}return this._oCalcedPos;};
function C(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return c;},false);
sap.ui.predefine('sap/m/OverflowToolbarAssociativePopoverControls',['jquery.sap.global','sap/ui/base/Metadata','./OverflowToolbarButton','./ToggleButton','./Button'],function(q,M,O,T,B){"use strict";var a=M.createClass("sap.m._overflowToolbarHelpers.OverflowToolbarAssociativePopoverControls",{constructor:function(){this._mControlsCache={};}});
a.prototype._preProcessSapMButton=function(c){var b=c.getType();this._mControlsCache[c.getId()]={buttonType:b};if(b===sap.m.ButtonType.Default){c.setProperty("type",sap.m.ButtonType.Transparent,true);}if(c.getIcon()){c.addStyleClass("sapMOTAPButtonWithIcon");}else{c.addStyleClass("sapMOTAPButtonNoIcon");}c.attachEvent("_change",this._onSapMButtonUpdated,this);};
a.prototype._postProcessSapMButton=function(c){var p=this._mControlsCache[c.getId()];if(c.getType()!==p.buttonType){c.setProperty("type",p.buttonType,true);}c.removeStyleClass("sapMOTAPButtonNoIcon");c.removeStyleClass("sapMOTAPButtonWithIcon");c.detachEvent("_change",this._onSapMButtonUpdated,this);};
a.prototype._onSapMButtonUpdated=function(e){var p=e.getParameter("name"),b=e.getSource(),s=b.getId();if(typeof this._mControlsCache[s]==="undefined"){return;}if(p==="type"){this._mControlsCache[s]["buttonType"]=b.getType();}};
a.prototype._preProcessSapMOverflowToolbarButton=function(c){this._preProcessSapMButton(c);c._bInOverflow=true;};
a.prototype._postProcessSapMOverflowToolbarButton=function(c){delete c._bInOverflow;this._postProcessSapMButton(c);};
a.prototype._preProcessSapMToggleButton=function(c){this._preProcessSapMButton(c);};
a.prototype._postProcessSapMToggleButton=function(c){this._postProcessSapMButton(c);};
a.prototype._preProcessSapMSegmentedButton=function(c){c._toSelectMode();};
a.prototype._postProcessSapMSegmentedButton=function(c){c._toNormalMode();};
a.prototype._preProcessSapMSelect=function(c){this._mControlsCache[c.getId()]={selectType:c.getType()};if(c.getType()!==sap.m.SelectType.Default){c.setProperty("type",sap.m.SelectType.Default,true);}};
a.prototype._postProcessSapMSelect=function(c){var p=this._mControlsCache[c.getId()];if(c.getType()!==p.selectType){c.setProperty("type",p.selectType,true);}};
a._mSupportedControls={"sap.m.Button":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","type"]},"sap.m.OverflowToolbarButton":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","type"]},"sap.m.CheckBox":{canOverflow:true,listenForEvents:["select"],noInvalidationProps:["enabled","selected"]},"sap.m.ToggleButton":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","pressed"]},"sap.m.Select":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","selectedItemId","selectedKey"]},"sap.m.ComboBox":{canOverflow:true,listenForEvents:[],noInvalidationProps:["enabled","value","selectedItemId","selectedKey"]},"sap.m.SearchField":{canOverflow:true,listenForEvents:["search"],noInvalidationProps:["enabled","value","selectOnFocus"]},"sap.m.SegmentedButton":{canOverflow:true,listenForEvents:["select"],noInvalidationProps:["enabled","selectedKey"]},"sap.m.Input":{canOverflow:true,listenForEvents:[],noInvalidationProps:["enabled","value"]},"sap.m.DateTimeInput":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue"]},"sap.m.DatePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat","displayFormatType","secondaryCalendarType","minDate","maxDate"]},"sap.m.DateTimePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat","displayFormatType","secondaryCalendarType","minDate","maxDate"]},"sap.m.TimePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat"]},"sap.m.RadioButton":{canOverflow:false,listenForEvents:[],noInvalidationProps:["enabled","selected"]},"sap.m.Slider":{canOverflow:false,listenForEvents:[],noInvalidationProps:["enabled","value"]}};
a.getControlConfig=function(c){var C=a.getControlClass(c);return a._mSupportedControls[C];};
a.supportsControl=function(c){var C=a.getControlClass(c);var o=a._mSupportedControls[C];return typeof o!=="undefined"&&o.canOverflow;};
a.getControlClass=function(c){if(c instanceof O){return"sap.m.OverflowToolbarButton";}else if(c instanceof T){return"sap.m.ToggleButton";}else if(c instanceof B){return"sap.m.Button";}return c.getMetadata().getName();};
return a;},false);
sap.ui.predefine('sap/m/OverflowToolbarButton',['sap/m/Button','sap/m/ButtonRenderer'],function(B,a){"use strict";
var O=B.extend("sap.m.OverflowToolbarButton",{renderer:a.render});
O.prototype._getText=function(){if(this._bInOverflow){return B.prototype._getText.call(this);}return"";};
return O;},true);
sap.ui.predefine('sap/m/OverflowToolbarLayoutData',['sap/m/ToolbarLayoutData','sap/m/OverflowToolbarPriority'],function(T,O){"use strict";
var a=T.extend("sap.m.OverflowToolbarLayoutData",{metadata:{properties:{moveToOverflow:{type:"boolean",defaultValue:true,deprecated:true},stayInOverflow:{type:"boolean",defaultValue:false,deprecated:true},priority:{type:"sap.m.OverflowToolbarPriority",group:"Behavior",defaultValue:sap.m.OverflowToolbarPriority.High},group:{type:"int",group:"Behavior",defaultValue:0}}}});
a.prototype.invalidate=function(){var c=this.getPriority(),i=c===O.AlwaysOverflow||c===O.NeverOverflow;if(this.getGroup()&&i){jQuery.sap.log.error("It is not allowed to set AlwaysOverflow or NeverOverflow to a group items.");}return T.prototype.invalidate.call(this);};
return a;},true);
sap.ui.predefine('sap/m/OverflowToolbarRenderer',['sap/ui/core/Renderer','./ToolbarRenderer'],function(R,T){"use strict";var O=R.extend(T);
O.renderBarContent=function(r,t){t._getVisibleContent().forEach(function(c){sap.m.BarInPageEnabler.addChildClassTo(c,t);r.renderControl(c);});if(t._getOverflowButtonNeeded()){O.renderOverflowButton(r,t);}};
O.renderOverflowButton=function(r,t){var o=t._getOverflowButton();sap.m.BarInPageEnabler.addChildClassTo(o,t);r.renderControl(o);};
return O;},true);
sap.ui.predefine('sap/m/Page.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref > section"}}};},false);
sap.ui.predefine('sap/m/Page',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar"],function(q,l,C,S,T,B,a){"use strict";
var P=C.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:sap.m.PageBackgroundDesign.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},designTime:true}});
P.prototype._hasScrolling=function(){return this.getEnableScrolling();};
P.prototype.onBeforeRendering=function(){if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null;}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new S(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true});}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel());}};
P.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._navBtn){this._navBtn.destroy();this._navBtn=null;}if(this._appIcon){this._appIcon.destroy();this._appIcon=null;}};
P.prototype.setBackgroundDesign=function(b){var s=this.getBackgroundDesign();this.setProperty("backgroundDesign",b,true);this.$().removeClass("sapMPageBg"+s).addClass("sapMPageBg"+this.getBackgroundDesign());return this;};
P.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new T(this.getId()+"-title",{text:t,level:this.getTitleLevel()});this._headerTitle.setText(t);if(w){this._updateHeaderContent(this._headerTitle,"middle",0);}this.setProperty("title",t,true);return this;};
P.prototype._ensureNavButton=function(){var b=this.getNavButtonTooltip()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){var n=this.getNavButtonType();this._navBtn=new B(this.getId()+"-navButton",{press:q.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap();},this)});if(sap.ui.Device.os.android&&n==sap.m.ButtonType.Back){this._navBtn.setType(sap.m.ButtonType.Up);}else{this._navBtn.setType(n);}}this._navBtn.setTooltip(b);};
P.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this;}this.setProperty("showNavButton",s,true);if(s){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1);}this._updateHeaderContent(this._navBtn,"left",0);}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1);}return this;};
P.prototype.setNavButtonType=function(n){this._ensureNavButton();if(!sap.ui.Device.os.ios&&n==sap.m.ButtonType.Back){this._navBtn.setType(sap.m.ButtonType.Up);}else{this._navBtn.setType(n);}this.setProperty("navButtonType",n,true);return this;};
P.prototype.setNavButtonText=function(t){this._ensureNavButton();this.setProperty("navButtonText",t,true);return this;};
P.prototype.setNavButtonTooltip=function(t){this.setProperty("navButtonTooltip",t,true);this._ensureNavButton();return this;};
P.prototype.setIcon=function(i){var o=this.getIcon();if(o===i){return this;}this.setProperty("icon",i,true);return this;};
P.prototype._updateHeaderContent=function(c,s,i){var I=this._getInternalHeader();if(I){switch(s){case"left":if(i==-1){if(I.getContentLeft()){I.removeContentLeft(c);}}else{if(I.indexOfContentLeft(c)!=i){I.insertContentLeft(c,i);I.invalidate();}}break;case"middle":if(i==-1){if(I.getContentMiddle()){I.removeContentMiddle(c);}}else{if(I.indexOfContentMiddle(c)!=i){I.insertContentMiddle(c,i);I.invalidate();}}break;case"right":if(i==-1){if(I.getContentRight()){I.removeContentRight(c);}}else{if(I.indexOfContentRight(c)!=i){I.insertContentRight(c,i);I.invalidate();}}break;default:break;}}};
P.prototype._getInternalHeader=function(){var i=this.getAggregation("_internalHeader");if(!i){this.setAggregation("_internalHeader",new a(this.getId()+"-intHeader"),true);i=this.getAggregation("_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0);}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0);}}return i;};
P.prototype._getAnyHeader=function(){var c=this.getCustomHeader();if(c){return c.addStyleClass("sapMPageHeader");}return this._getInternalHeader().addStyleClass("sapMPageHeader");};
P.prototype.getScrollDelegate=function(){return this._oScroller;};
P.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t);}return this;};
P.prototype.scrollToElement=function(e,t){if(e instanceof sap.ui.core.Element){e=e.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(e,t);}return this;};
P.prototype.setContentOnlyBusy=function(c){this.setProperty("contentOnlyBusy",c,true);this.$().toggleClass("sapMPageBusyCoversAll",!c);return this;};
P.prototype.getHeaderContent=function(){return this._getInternalHeader().getContentRight();};
P.prototype.indexOfHeaderContent=function(c){return this._getInternalHeader().indexOfContentRight(c);};
P.prototype.insertHeaderContent=function(c,i){return this._getInternalHeader().insertContentRight(c,i);};
P.prototype.addHeaderContent=function(c){return this._getInternalHeader().addContentRight(c);};
P.prototype.removeHeaderContent=function(c){return this._getInternalHeader().removeContentRight(c);};
P.prototype.removeAllHeaderContent=function(){return this._getInternalHeader().removeAllContentRight();};
P.prototype.destroyHeaderContent=function(){return this._getInternalHeader().destroyContentRight();};
P.prototype.setCustomHeader=function(h){this.setAggregation("customHeader",h);if(h&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":h});}return this;};
P.prototype._getAdaptableContent=function(){return this._getAnyHeader();};
return P;},true);
sap.ui.predefine('sap/m/PageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var P=E.extend("sap.m.PageAccessibleLandmarkInfo",{metadata:{library:"sap.m",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},contentLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},headerLabel:{type:"string",defaultValue:null},subHeaderRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:null},subHeaderLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null}}}});
P._getLandmarkInfo=function(i,a){if(!i){return null;}var r=null;var t=null;var p=i.getMetadata().getProperty(a+"Role");if(p){r=i[p._sGetter]();}if(!r){return null;}p=i.getMetadata().getProperty(a+"Label");if(p){t=i[p._sGetter]();}return[r.toLowerCase(),t];};
P._writeLandmarkInfo=function(r,p,a){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var i=P._getLandmarkInfo(p.getLandmarkInfo(),a);if(!i){return;}var L={role:i[0]};if(i[1]){L["label"]=i[1];}r.writeAccessibilityState(p,L);};
return P;});
sap.ui.predefine('sap/m/PageRenderer',['sap/m/PageAccessibleLandmarkInfo'],function(P){"use strict";var a={};
a.render=function(r,p){var h=null,f=null,s=null,e=p.getEnableScrolling()?" sapMPageScrollEnabled":"";if(p.getShowHeader()){h=p._getAnyHeader();}if(p.getShowSubHeader()){s=p.getSubHeader();}if(p.getShowFooter()){f=p.getFooter();}r.write("<div");r.writeControlData(p);r.addClass("sapMPage");r.addClass("sapMPageBg"+p.getBackgroundDesign());if(h){r.addClass("sapMPageWithHeader");}if(s){r.addClass("sapMPageWithSubHeader");}if(f){r.addClass("sapMPageWithFooter");}if(!p.getContentOnlyBusy()){r.addClass("sapMPageBusyCoversAll");}r.writeClasses();var t=p.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}P._writeLandmarkInfo(r,p,"root");r.write(">");this.renderBarControl(r,p,h,{context:"header",styleClass:"sapMPageHeader"});this.renderBarControl(r,p,s,{context:"subHeader",styleClass:"sapMPageSubHeader"});r.write('<section id="'+p.getId()+'-cont"');P._writeLandmarkInfo(r,p,"content");r.write('>');if(p._bUseScrollDiv){r.write('<div id="'+p.getId()+'-scroll" class="sapMPageScroll'+e+'">');}var c=p.getContent();var l=c.length;for(var i=0;i<l;i++){r.renderControl(c[i]);}if(p._bUseScrollDiv){r.write("</div>");}r.write("</section>");this.renderBarControl(r,p,f,{context:"footer",styleClass:"sapMPageFooter"});r.write("</div>");};
a.renderBarControl=function(r,p,b,o){if(!b){return;}b.applyTagAndContextClassFor(o.context.toLowerCase());b._setLandmarkInfo(p.getLandmarkInfo(),o.context);b.addStyleClass(o.styleClass);r.renderControl(b);};
return a;},true);
sap.ui.predefine('sap/m/PagingButton',['jquery.sap.global','./Button','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,B,C,I){"use strict";
var P=C.extend("sap.m.PagingButton",{metadata:{library:"sap.m",properties:{count:{type:"int",group:"Data",defaultValue:1},position:{type:"int",group:"Data",defaultValue:1},nextButtonTooltip:{type:"string",group:"Appearance",defaultValue:""},previousButtonTooltip:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{previousButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{positionChange:{parameters:{newPosition:{type:"int"},oldPosition:{type:"int"}}}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
P.prototype.init=function(){this._attachPressEvents();};
P.prototype.onBeforeRendering=function(){this._enforceValidPosition(this.getPosition());this._updateButtonState();};
P.prototype._getNextButton=function(){if(!this.getAggregation("nextButton")){this.setAggregation("nextButton",new sap.m.Button({tooltip:this.getNextButtonTooltip()||r.getText("PAGINGBUTTON_NEXT"),icon:I.getIconURI("slim-arrow-down"),enabled:false,id:this.getId()+"-nextButton"}));}return this.getAggregation("nextButton");};
P.prototype._getPreviousButton=function(){if(!this.getAggregation("previousButton")){this.setAggregation("previousButton",new sap.m.Button({tooltip:this.getPreviousButtonTooltip()||r.getText("PAGINGBUTTON_PREVIOUS"),icon:I.getIconURI("slim-arrow-up"),enabled:false,id:this.getId()+"-previousButton"}));}return this.getAggregation("previousButton");};
P.prototype._attachPressEvents=function(){this._getPreviousButton().attachPress(this._handlePositionChange.bind(this,false));this._getNextButton().attachPress(this._handlePositionChange.bind(this,true));};
P.prototype._handlePositionChange=function(i){var o=this.getPosition(),n=i?o+1:o-1;this.setPosition(n);this.firePositionChange({newPosition:n,oldPosition:o});this._updateButtonState();return this;};
P.prototype._updateButtonState=function(){var t=this.getCount(),c=this.getPosition();this._getPreviousButton().setEnabled(c>1);this._getNextButton().setEnabled(c<t);return this;};
P.prototype.setPosition=function(p){return this._validateProperty("position",p);};
P.prototype.setCount=function(c){return this._validateProperty("count",c);};
P.prototype.setPreviousButtonTooltip=function(t){this._getPreviousButton().setTooltip(t);return this.setProperty("previousButtonTooltip",t,true);};
P.prototype.setNextButtonTooltip=function(t){this._getNextButton().setTooltip(t);return this.setProperty("nextButtonTooltip",t,true);};
P.prototype._validateProperty=function(p,v){if(v<1){q.sap.log.warning("Property '"+p+"' must be greater or equal to 1",this);return this;}return this.setProperty(p,v);};
P.prototype._enforceValidPosition=function(p){var c=this.getCount();if(p>c){q.sap.log.warning("Property position must be less or equal to the total count");this.setPosition(c);}return this;};
return P;},true);
sap.ui.predefine('sap/m/PagingButtonRenderer',['jquery.sap.global'],function(q){"use strict";var P={};
P.render=function(r,c){var n=c._getNextButton(),p=c._getPreviousButton();r.write("<div");r.writeControlData(c);r.addClass("sapMPagingButton");r.writeClasses();r.write(">");r.renderControl(p);r.renderControl(n);r.write("</div>");};
return P;},true);
sap.ui.predefine('sap/m/Panel.designtime',[],function(){"use strict";return{aggregations:{headerToolbar:{domRef:":sap-domref > .sapMPanelHdr, :sap-domref > .sapUiDtEmptyHeader"},infoToolbar:{domRef:":sap-domref > .sapUiDtEmptyInfoToolbar"},content:{domRef:".sapMPanelContent",show:function(){this.setExpanded(true);}}}};},false);
sap.ui.predefine('sap/m/Panel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var P=C.extend("sap.m.Panel",{metadata:{library:"sap.m",properties:{headerText:{type:"string",group:"Data",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},expandable:{type:"boolean",group:"Appearance",defaultValue:false},expanded:{type:"boolean",group:"Appearance",defaultValue:false},expandAnimation:{type:"boolean",group:"Behavior",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false}},events:{expand:{parameters:{expand:{type:"boolean"}}}},designtime:true}});
P.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
P.prototype.setWidth=function(w){this.setProperty("width",w,true);var d=this.getDomRef();if(d){d.style.width=w;}return this;};
P.prototype.setHeight=function(h){this.setProperty("height",h,true);var d=this.getDomRef();if(d){d.style.height=h;d.querySelector(".sapMPanelContent").style.height=h;this._setContentHeight();}return this;};
P.prototype.setExpandable=function(e){this.setProperty("expandable",e,false);if(e&&!this.oIconCollapsed){this.oIconCollapsed=this._createIcon();}return this;};
P.prototype.setExpanded=function(e){if(e===this.getExpanded()){return this;}this.setProperty("expanded",e,true);if(!this.getExpandable()){return this;}this._getIcon().$().attr("aria-expanded",this.getExpanded());this._toggleExpandCollapse();this._toggleCssClasses();this.fireExpand({expand:e});return this;};
P.prototype.onBeforeRendering=function(){this._updateIconAriaLabelledBy();};
P.prototype.onAfterRendering=function(){var $=this.$(),a;this._setContentHeight();if(this.getExpandable()){a=this.oIconCollapsed.$();if(this.getExpanded()){a.attr("aria-expanded","true");}else{$.children(".sapMPanelExpandablePart").hide();a.attr("aria-expanded","false");}}};
P.prototype.exit=function(){if(this.oIconCollapsed){this.oIconCollapsed.destroy();this.oIconCollapsed=null;}};
P.prototype._createIcon=function(){var t=this,c=I.getIconURI("navigation-right-arrow");return I.createControlByURI({id:t.getId()+"-CollapsedImg",src:c,decorative:false,useIconTooltip:false,press:function(){t.setExpanded(!t.getExpanded());}}).addStyleClass("sapMPanelExpandableIcon");};
P.prototype._getIcon=function(){return this.oIconCollapsed;};
P.prototype._setContentHeight=function(){if(this.getHeight()==="auto"){return;}var t=this.getDomRef();var o=t.querySelector(".sapMPanelContent").offsetTop;var a=t.clientHeight-o;t.querySelector(".sapMPanelContent").style.height=a+'px';};
P.prototype._toggleExpandCollapse=function(){var o={};if(!this.getExpandAnimation()){o.duration=0;}this.$().children(".sapMPanelExpandablePart").slideToggle(o);};
P.prototype._toggleCssClasses=function(){var $=this.$();$.children(".sapMPanelWrappingDiv").toggleClass("sapMPanelWrappingDivExpanded");$.children(".sapMPanelWrappingDivTb").toggleClass("sapMPanelWrappingDivTbExpanded");$.find(".sapMPanelExpandableIcon").first().toggleClass("sapMPanelExpandableIconExpanded");};
P.prototype._updateIconAriaLabelledBy=function(){var L,a;if(!this.oIconCollapsed){return;}L=this._getLabellingElementId();a=this.oIconCollapsed.getAriaLabelledBy();if(a.indexOf(L)===-1){this.oIconCollapsed.removeAllAssociation("ariaLabelledBy");this.oIconCollapsed.addAriaLabelledBy(L);}};
P.prototype._getLabellingElementId=function(){var h=this.getHeaderToolbar(),i;if(h){i=h.getTitleId();}else{i=this.getId()+"-header";}return i;};
return P;},true);
sap.ui.predefine('sap/m/PanelRenderer',['jquery.sap.global'],function(q){"use strict";var P={};
P.render=function(r,c){this.startPanel(r,c);this.renderHeader(r,c);this.renderContent(r,c);this.endPanel(r);};
P.startPanel=function(r,c){r.write("<section");r.addClass("sapMPanel");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeAccessibilityState(c,{role:"form",labelledby:c._getLabellingElementId()});r.writeControlData(c);r.writeClasses();r.writeStyles();r.write(">");};
P.renderHeader=function(r,c){var i=c.getExpandable(),I=c.getExpanded(),h=c.getHeaderToolbar(),H;if(i){r.write("<header");if(h){H="sapMPanelWrappingDivTb";}else{H="sapMPanelWrappingDiv";}r.addClass(H);if(I){r.addClass(H+"Expanded");}r.writeClasses();r.write(">");var o=c._getIcon();if(I){o.addStyleClass("sapMPanelExpandableIconExpanded");}else{o.removeStyleClass("sapMPanelExpandableIconExpanded");}r.renderControl(o);}var s=c.getHeaderText();if(h){h.setDesign(sap.m.ToolbarDesign.Transparent,true);r.renderControl(h);}else if(s||i){r.write("<h1");r.addClass("sapMPanelHdr");r.writeClasses();r.writeAttribute("id",c.getId()+"-header");r.write(">");r.writeEscaped(s);r.write("</h1>");}if(i){r.write("</header>");}var a=c.getInfoToolbar();if(a){if(i){a.addStyleClass("sapMPanelExpandablePart");}a.setDesign(sap.m.ToolbarDesign.Info,true);r.renderControl(a);}};
P.renderContent=function(r,c){this.startContent(r,c);this.renderChildren(r,c.getContent());this.endContent(r);};
P.startContent=function(r,c){r.write("<div");r.addClass("sapMPanelContent");r.addClass("sapMPanelBG"+c.getBackgroundDesign());if(c.getExpandable()){r.addClass("sapMPanelExpandablePart");}r.writeClasses();r.write(">");};
P.renderChildren=function(r,c){c.forEach(r.renderControl);};
P.endContent=function(r){r.write("</div>");};
P.endPanel=function(r){r.write("</section>");};
return P;},true);
sap.ui.predefine('sap/m/PlanningCalendar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','./PlanningCalendarRow','./library','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils'],function(q,C,L,P,l,u,a){"use strict";
var b=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{}}}});
var c=sap.ui.core.Control.extend("CalendarHeader",{
metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},
renderer:function(R,H){R.write("<div");R.writeControlData(H);R.addClass("sapMPlanCalHead");R.writeClasses();R.write(">");var T=H.getToolbar();if(T){R.renderControl(T);}var i=H.getAllCheckBox();if(i){R.renderControl(i);}R.write("</div>");}
});
b.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(sap.ui.Device.system.tablet||q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oIntervalTypeSelect=new sap.m.Select(this.getId()+"-IntType",{maxWidth:"15rem"});this._oIntervalTypeSelect.attachEvent("change",_,this);this._oTodayButton=new sap.m.Button(this.getId()+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:sap.m.ButtonType.Transparent});this._oTodayButton.attachEvent("press",d,this);this._oHeaderToolbar=new sap.m.Toolbar(this.getId()+"-HeaderToolbar",{design:sap.m.ToolbarDesign.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new c(this.getId()+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new sap.m.Toolbar(this.getId()+"-InfoToolbar",{height:"auto",design:sap.m.ToolbarDesign.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var T=new sap.m.Table(this.getId()+"-Table",{infoToolbar:this._oInfoToolbar,mode:sap.m.ListMode.SingleSelectMaster,columns:[new sap.m.Column({styleClass:"sapMPlanCalRowHead"}),new sap.m.Column({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:sap.m.ScreenSize.Desktop,demandPopin:true})]});T.attachEvent("selectionChange",n,this);this.setAggregation("table",T,true);this.setStartDate(new Date());this._resizeProxy=q.proxy(h,this);};
b.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var T=this.getAggregation("table");T.removeAllItems();if(this._oTimeInterval){this._oTimeInterval._oPlanningCalendar=undefined;this._oTimeInterval.destroy();this._oTimeInterval=undefined;}if(this._oDateInterval){this._oDateInterval._oPlanningCalendar=undefined;this._oDateInterval.destroy();this._oDateInterval=undefined;}if(this._oMonthInterval){this._oMonthInterval._oPlanningCalendar=undefined;this._oMonthInterval.destroy();this._oMonthInterval=undefined;}if(this._aViews){for(var i=0;i<this._aViews.length;i++){this._aViews[i].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}};
b.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}t.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._bBeforeRendering=undefined;};
b.prototype.onAfterRendering=function(E){E.size={width:this.getDomRef().offsetWidth};h.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}k.call(this,false);};
b.prototype.setStartDate=function(S){if(!S){S=new Date();}if(q.sap.equal(S,this.getStartDate())){return this;}if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=S.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var M=this.getMinDate();if(M&&M.getTime()>S.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(M.getTime());}else{var j=this.getMaxDate();if(j&&j.getTime()<S.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}}}this.setProperty("startDate",S,true);if(this._oTimeInterval){this._oTimeInterval.setStartDate(new Date(S.getTime()));}if(this._oDateInterval){this._oDateInterval.setStartDate(new Date(S.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setStartDate(new Date(S.getTime()));}var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];D.getCalendarRow().setStartDate(new Date(S.getTime()));}if(this.getDomRef()){k.call(this,false);}return this;};
b.prototype.setMinDate=function(D){if(q.sap.equal(D,this.getMinDate())){return this;}var M=this.getMaxDate();if(D){if(!(D instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=D.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("minDate",D,true);this._bNoStartDateChange=true;if(this._oTimeInterval){this._oTimeInterval.setMinDate(new Date(D.getTime()));}if(this._oDateInterval){this._oDateInterval.setMinDate(new Date(D.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setMinDate(new Date(D.getTime()));}if(M&&M.getTime()<D.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);M=new Date(D.getTime());M.setMonth(M.getMonth()+1,0);M.setHours(23);M.setMinutes(59);M.setSeconds(59);M.setMilliseconds(0);this.setMaxDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()<D.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(D.getTime());this.setStartDate(S);}}else{this.setProperty("minDate",undefined,true);if(this._oTimeInterval){this._oTimeInterval.setMinDate();}if(this._oDateInterval){this._oDateInterval.setMinDate();}if(this._oMonthInterval){this._oMonthInterval.setMinDate();}}var T=new Date();if(D&&T.getTime()<D.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()<M.getTime()){this._oTodayButton.setVisible(true);}return this;};
b.prototype.setMaxDate=function(D){if(q.sap.equal(D,this.getMaxDate())){return this;}var M=this.getMinDate();if(D){if(!(D instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=D.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("maxDate",D,true);this._bNoStartDateChange=true;if(this._oTimeInterval){this._oTimeInterval.setMaxDate(new Date(D.getTime()));}if(this._oDateInterval){this._oDateInterval.setMaxDate(new Date(D.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setMaxDate(new Date(D.getTime()));}if(M&&M.getTime()>D.getTime()){q.sap.log.warning("maxDate < minDate -> maxDate set to begin of the month",this);M=new Date(D.getTime());M.setUTCDate(1);M.setHours(0);M.setMinutes(0);M.setSeconds(0);M.setMilliseconds(0);this.setMinDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()>D.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}this.setStartDate(S);}}else{this.setProperty("maxDate",undefined,true);if(this._oTimeInterval){this._oTimeInterval.setMaxDate();}if(this._oDateInterval){this._oDateInterval.setMaxDate();}if(this._oMonthInterval){this._oMonthInterval.setMaxDate();}}var T=new Date();if(D&&T.getTime()>D.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()>M.getTime()){this._oTodayButton.setVisible(true);}return this;};
b.prototype.setViewKey=function(K){this.setProperty("viewKey",K,true);this._oIntervalTypeSelect.setSelectedKey(K);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}var S=this.getStartDate();var M=this.getMinDate();var j=this.getMaxDate();var V=s.call(this,K,!this._bBeforeRendering);if(!V){this._bCheckView=true;this.invalidate();}else{var I=V.getIntervalType();var D=v.call(this,V);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(S.getTime()),items:D,pickerPopup:true});this._oTimeInterval.attachEvent("startDateChange",e,this);this._oTimeInterval.attachEvent("select",f,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oTimeInterval.setMinDate(new Date(M.getTime()));}if(j){this._oTimeInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oTimeInterval.getItems()!=D){this._oTimeInterval.setItems(D);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case sap.ui.unified.CalendarIntervalType.Day:if(!this._oDateInterval){this._oDateInterval=new sap.ui.unified.CalendarDateInterval(this.getId()+"-DateInt",{startDate:new Date(S.getTime()),days:D,showDayNamesLine:false,pickerPopup:true});this._oDateInterval.attachEvent("startDateChange",e,this);this._oDateInterval.attachEvent("select",f,this);this._oDateInterval._oPlanningCalendar=this;this._oDateInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oDateInterval.setMinDate(new Date(M.getTime()));}if(j){this._oDateInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oDateInterval.getDays()!=D){this._oDateInterval.setDays(D);}this._oInfoToolbar.addContent(this._oDateInterval);break;case sap.ui.unified.CalendarIntervalType.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(S.getTime()),months:D,pickerPopup:true});this._oMonthInterval.attachEvent("startDateChange",e,this);this._oMonthInterval.attachEvent("select",f,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oMonthInterval.setMinDate(new Date(M.getTime()));}if(j){this._oMonthInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oMonthInterval.setMonths()!=D){this._oMonthInterval.setMonths(D);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var R=this.getRows();for(var i=0;i<R.length;i++){var E=R[i];var F=E.getCalendarRow();F.setIntervalType(I);F.setIntervals(D);F.setShowSubIntervals(V.getShowSubIntervals());}if(this.getDomRef()){k.call(this,false);}}return this;};
b.prototype.setShowIntervalHeaders=function(S){this.setProperty("showIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowIntervalHeaders(S);}return this;};
b.prototype.setShowEmptyIntervalHeaders=function(S){this.setProperty("showEmptyIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowEmptyIntervalHeaders(S);}return this;};
b.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];D.getCalendarRow().setAppointmentsReducedHeight(j);}return this;};
b.prototype.setShowRowHeaders=function(S){this.setProperty("showRowHeaders",S,true);var T=this.getAggregation("table");T.getColumns()[0].setVisible(S);this.$().toggleClass("sapMPlanCalNoHead",!S);z.call(this);B.call(this);return this;};
b.prototype.addRow=function(R){this.addAggregation("rows",R,true);R.attachEvent("_change",A,this);var T=this.getAggregation("table");T.addItem(R.getColumnListItem());var i=R.getCalendarRow();i.setStartDate(this.getStartDate());i.setShowIntervalHeaders(this.getShowIntervalHeaders());i.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());i.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());i.attachEvent("select",m,this);i.attachEvent("startDateChange",e,this);i.attachEvent("leaveRow",x,this);i.attachEvent("intervalSelect",g,this);y.call(this);if(this._oTimeInterval||this._oDateInterval||this._oMonthInterval){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var j=v.call(this,V);i.setIntervalType(I);i.setIntervals(j);i.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};
b.prototype.insertRow=function(R,i){this.insertAggregation("rows",R,i);R.attachEvent("_change",A,this);var T=this.getAggregation("table");T.insertItem(R.getColumnListItem(),i,true);var j=R.getCalendarRow();j.setStartDate(this.getStartDate());j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.attachEvent("select",m,this);j.attachEvent("startDateChange",e,this);j.attachEvent("leaveRow",x,this);j.attachEvent("intervalSelect",g,this);y.call(this);if(this._oTimeInterval||this._oDateInterval||this._oMonthInterval){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);j.setIntervalType(I);j.setIntervals(D);j.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};
b.prototype.removeRow=function(O){var R=this.removeAggregation("rows",O,true);R.detachEvent("_change",A,this);var T=this.getAggregation("table");T.removeItem(R.getColumnListItem(),true);var i=R.getCalendarRow();i.detachEvent("select",m,this);i.detachEvent("startDateChange",e,this);i.detachEvent("leaveRow",x,this);i.detachEvent("intervalSelect",g,this);y.call(this);B.call(this);return R;};
b.prototype.removeAllRows=function(){var R=this.removeAllAggregation("rows",true);var T=this.getAggregation("table");T.removeAllItems(true);for(var i=0;i<R.length;i++){var j=R[i];j.detachEvent("_change",A,this);var D=j.getCalendarRow();D.detachEvent("select",m,this);D.detachEvent("startDateChange",e,this);D.detachEvent("leaveRow",x,this);D.detachEvent("intervalSelect",g,this);}y.call(this);B.call(this);return R;};
b.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var T=this.getAggregation("table");T.destroyItems(true);y.call(this);B.call(this);return i;};
b.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);o.call(this);return this;};
b.prototype.insertToolbarContent=function(i,I){this.insertAggregation("toolbarContent",i,I);o.call(this);return this;};
b.prototype.removeToolbarContent=function(O){var R=this.removeAggregation("toolbarContent",O,true);o.call(this);return R;};
b.prototype.removeAllToolbarContent=function(){var R=this.removeAllAggregation("toolbarContent",true);o.call(this);return R;};
b.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);o.call(this);return i;};
b.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};
b.prototype.setSingleSelection=function(S){this.setProperty("singleSelection",S,true);z.call(this);B.call(this);if(S){this.selectAllRows(false);}else{y.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!S);return this;};
b.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);var T=this.getAggregation("table");T.setNoDataText(N);return this;};
b.prototype.invalidate=function(O){if(this._bDateRangeChanged||(O&&O instanceof sap.ui.unified.DateRange)){if(this.getDomRef()){var K=this.getViewKey();var V=s.call(this,K);var i=V.getIntervalType();switch(i){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this);}}this._bDateRangeChanged=undefined;}else{C.prototype.invalidate.apply(this,arguments);}};
b.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
b.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var D=this.destroyAggregation("specialDates");return D;};
b.prototype.getSelectedRows=function(){return this.getRows().filter(function(R){return R.getSelected();});};
b.prototype.selectAllRows=function(S){var R=this.getRows();if(!(S&&this.getSingleSelection())){for(var i=0;i<R.length;i++){var j=R[i];j.setSelected(S);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(S);}}return this;};
b.prototype.onsaphomemodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[0];var N=new q.Event("saphome");N._bPlanningCalendar=true;i.getCalendarRow().onsaphome(N);E.preventDefault();E.stopPropagation();}};
b.prototype.onsapendmodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[R.length-1];var N=new q.Event("sapend");N._bPlanningCalendar=true;i.getCalendarRow().onsapend(N);E.preventDefault();E.stopPropagation();}};
function _(E){this.setViewKey(E.getParameter("selectedItem").getKey());this.fireViewChange();}
function d(E){this.setStartDate(new Date());this.fireStartDateChange();}
function e(E){if(this._bNoStartDateChange){return;}var S=E.oSource.getStartDate();this.setStartDate(new Date(S.getTime()));this.fireStartDateChange();}
function f(E){var S=E.oSource.getSelectedDates();var i=new Date(S[0].getStartDate());S[0].setStartDate();var j=a._createUniversalUTCDate(i,undefined,true);var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();switch(I){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCHours(j.getUTCHours()+1);break;case sap.ui.unified.CalendarIntervalType.Day:j.setUTCDate(j.getUTCDate()+1);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCMonth(j.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}j.setUTCMilliseconds(j.getUTCMilliseconds()-1);j=a._createLocalDate(j,true);this.fireIntervalSelect({startDate:i,endDate:j,subInterval:false,row:undefined});}
function g(E){var S=E.getParameter("startDate");var i=E.getParameter("endDate");var j=E.getParameter("subInterval");var R=E.oSource._oPlanningCalendarRow;this.fireIntervalSelect({startDate:S,endDate:i,subInterval:j,row:R});}
function h(E,N){if(E.size.width<=0){return;}var R=this.getRows();var j;var i=0;var O=this._iSize;p.call(this,E.size.width);if(O!=this._iSize){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);for(i=0;i<R.length;i++){j=R[i];var F=j.getCalendarRow();if(D!=F.getIntervals()){F.setIntervals(D);}else{F.handleResize();}}switch(I){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=D){this._oTimeInterval.setItems(D);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=D){this._oDateInterval.setDays(D);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=D){this._oMonthInterval.setMonths(D);}break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}z.call(this);}else if(!N){for(i=0;i<R.length;i++){j=R[i];j.getCalendarRow().handleResize();}}}
function k(U){if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(U){var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().updateCurrentTimeVisualization();}}var N=new Date();var S=this.getStartDate();var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);var T=0;var E=0;var F=0;switch(I){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;E=S.getTime()-3600000;F=S.getTime()+D*3600000;break;case sap.ui.unified.CalendarIntervalType.Day:T=1800000;E=S.getTime()-3600000;F=S.getTime()+D*86400000;break;default:T=-1;break;}if(N.getTime()<=F&&N.getTime()>=E&&T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,k,[true]);}}
function m(E){var D=E.getParameter("appointment");var M=E.getParameter("multiSelect");var F=E.getParameter("appointments");if(!M){var R=this.getRows();for(var i=0;i<R.length;i++){var G=R[i];var H=G.getCalendarRow();if(E.oSource!=H){var I=G.getAppointments();for(var j=0;j<I.length;j++){var J=I[j];J.setSelected(false);}}}}this.fireAppointmentSelect({appointment:D,appointments:F,multiSelect:M});}
function n(E){var j=[];var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];var F=D.getColumnListItem();var S=F.getSelected();if(D.getSelected()!=S){D.setProperty("selected",S,true);j.push(D);}}if(!this.getSingleSelection()){y.call(this);}if(j.length>0){this.fireRowSelectionChange({rows:j});}}
function o(){var T=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:sap.m.ToolbarDesign.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!T.getHeaderToolbar()){T.setHeaderToolbar(this._oToolbar);}}else if(T.getHeaderToolbar()){T.setHeaderToolbar();}this._oToolbar.invalidate();}
function p(W){if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}
function r(){var V=this.getViews();if(V.length==0){if(!this._aViews){this._aViews=[];var i=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:sap.ui.unified.CalendarIntervalType.Hour,intervalType:sap.ui.unified.CalendarIntervalType.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12});this._aViews.push(i);var j=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:sap.ui.unified.CalendarIntervalType.Day,intervalType:sap.ui.unified.CalendarIntervalType.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14});this._aViews.push(j);var D=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:sap.ui.unified.CalendarIntervalType.Month,intervalType:sap.ui.unified.CalendarIntervalType.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12});this._aViews.push(D);}V=this._aViews;}return V;}
function s(K,N){var V=r.call(this);var j;for(var i=0;i<V.length;i++){j=V[i];if(j.getKey()!=K){j=undefined;}else{break;}}if(!j&&!N){throw new Error("PlanningCalendarView with key "+K+"not assigned "+this);}return j;}
function t(){var V=r.call(this);var I=this._oIntervalTypeSelect.getItems();var i=0;var j;if(V.length<I.length){for(i=V.length;i<I.length;i++){j=I[i];this._oIntervalTypeSelect.removeItem(j);j.destroy();}}for(i=0;i<V.length;i++){var D=V[i];j=I[i];if(j){if(j.getKey()!=D.getKey()||j.getText()!=D.getDescription()){j.setKey(D.getKey());j.setText(D.getDescription());j.setTooltip(D.getTooltip());}}else{j=new sap.ui.core.Item(this.getId()+"-"+i,{key:D.getKey(),text:D.getDescription(),tooltip:D.getTooltip()});this._oIntervalTypeSelect.addItem(j);}}}
function v(V){var i=0;switch(this._iSize){case 0:i=V.getIntervalsS();break;case 1:i=V.getIntervalsM();break;default:i=V.getIntervalsL();break;}return i;}
function w(E){var i=E.getParameter("selected");var R=this.getRows();if(i){R=this.getRows().filter(function(j){return!j.getSelected();});}this.selectAllRows(i);this.fireRowSelectionChange({rows:R});}
function x(E){var j=E.oSource;var T=E.getParameter("type");var R=this.getRows();var D;var N;var F;var G;var i=0;var I=0;var H;for(i=0;i<R.length;i++){D=R[i];if(D.getCalendarRow()==j){I=i;break;}}switch(T){case"sapup":F=j.getFocusedAppointment();G=F.getStartDate();if(I>0){I--;}N=R[I];N.getCalendarRow().focusNearestAppointment(G);break;case"sapdown":F=j.getFocusedAppointment();G=F.getStartDate();if(I<R.length-1){I++;}N=R[I];N.getCalendarRow().focusNearestAppointment(G);break;case"saphome":if(I>0){N=R[0];H=new q.Event(T);H._bPlanningCalendar=true;N.getCalendarRow().onsaphome(H);}break;case"sapend":if(I<R.length-1){N=R[R.length-1];H=new q.Event(T);H._bPlanningCalendar=true;N.getCalendarRow().onsapend(H);}break;default:break;}}
function y(){if(this._oSelectAllCheckBox){var R=this.getRows();var S=this.getSelectedRows();if(R.length==S.length&&S.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}
function z(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",w,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}
function A(E){if(E.getParameter("name")=="selected"){y.call(this);}}
function B(){var T=this.getAggregation("table");var M=T.getMode();var i;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){i=sap.m.ListMode.None;}else{i=sap.m.ListMode.SingleSelectMaster;}}else{i=sap.m.ListMode.MultiSelect;}if(M!=i){T.setMode(i);}}
return b;},true);
sap.ui.predefine('sap/m/PlanningCalendarRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var P={};
P.render=function(r,t){var T=t.getTooltip_AsString();r.write("<div");r.writeControlData(t);r.addClass("sapMPlanCal");if(!t.getSingleSelection()){r.addClass("sapMPlanCalMultiSel");}if(!t.getShowRowHeaders()){r.addClass("sapMPlanCalNoHead");}if(T){r.writeAttributeEscaped('title',T);}var w=t.getWidth();if(w){r.addStyle("width",w);}var h=t.getHeight();if(h){r.addStyle("height",h);}r.writeAccessibilityState(t);r.writeClasses();r.writeStyles();r.write(">");var o=t.getAggregation("table");r.renderControl(o);r.write("</div>");};
return P;},true);
sap.ui.predefine('sap/m/PlanningCalendarRow',['jquery.sap.global','sap/ui/core/Element','./StandardListItem','./StandardListItemRenderer','sap/ui/core/Renderer','./library','sap/ui/unified/library'],function(q,E,S,a,R,l,u){"use strict";
var P=E.extend("sap.m.PlanningCalendarRow",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"}}}});
var C=S.extend("CalenderRowHeader",{
metadata:{associations:{parentRow:{type:"sap.m.PlanningCalendarRow",multiple:false}}},
setParentRow:function(i){this.setAssociation("parentRow",i,true);if(!i){this._oRow=undefined;}else if(typeof i=="string"){this._oRow=sap.ui.getCore().byId(i);}else{this._oRow=i;}return this;},
renderer:R.extend(a)
});
CalenderRowHeaderRenderer.openItemTag=function(r,L){r.write("<div");};
CalenderRowHeaderRenderer.closeItemTag=function(r,L){r.write("</div>");};
CalenderRowHeaderRenderer.renderTabIndex=function(r,L){};
P.prototype.init=function(){var c=new C(this.getId()+"-Head",{parentRow:this});var o=new sap.ui.unified.CalendarRow(this.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false});o._oPlanningCalendarRow=this;o.getAppointments=function(){if(this._oPlanningCalendarRow){return this._oPlanningCalendarRow.getAppointments();}else{return[];}};o.getIntervalHeaders=function(){if(this._oPlanningCalendarRow){return this._oPlanningCalendarRow.getIntervalHeaders();}else{return[];}};this._oColumnListItem=new sap.m.ColumnListItem(this.getId()+"-CLI",{cells:[c,o]});};
P.prototype.exit=function(){this._oColumnListItem.destroy();this._oColumnListItem=undefined;};
P.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);this._oColumnListItem.getCells()[0].setTooltip(t);return this;};
P.prototype.setTitle=function(t){this.setProperty("title",t,true);this._oColumnListItem.getCells()[0].setTitle(t);return this;};
P.prototype.setText=function(t){this.setProperty("text",t,true);this._oColumnListItem.getCells()[0].setDescription(t);if(t){this._oColumnListItem.getCells()[1].addStyleClass("sapMPlanCalRowLarge");}else{this._oColumnListItem.getCells()[1].removeStyleClass("sapMPlanCalRowLarge");}return this;};
P.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._oColumnListItem.getCells()[0].setIcon(i);return this;};
P.prototype.setNonWorkingDays=function(n){this.setProperty("nonWorkingDays",n,true);this.getCalendarRow().setNonWorkingDays(n);return this;};
P.prototype.setNonWorkingHours=function(n){this.setProperty("nonWorkingHours",n,true);this.getCalendarRow().setNonWorkingHours(n);return this;};
P.prototype.invalidate=function(o){if(!o||!(o instanceof sap.ui.unified.CalendarAppointment)){E.prototype.invalidate.apply(this,arguments);}else if(this._oColumnListItem){this.getCalendarRow().invalidate(o);}};
P.prototype.removeAppointment=function(o){var r=this.removeAggregation("appointments",o,true);this.getCalendarRow().invalidate();return r;};
P.prototype.removeAllAppointments=function(){var r=this.removeAllAggregation("appointments",true);this.getCalendarRow().invalidate();return r;};
P.prototype.destroyAppointments=function(){var d=this.destroyAggregation("appointments",true);this.getCalendarRow().invalidate();return d;};
P.prototype.removeIntervalHeader=function(o){var r=this.removeAggregation("intervalHeaders",o,true);this.getCalendarRow().invalidate();return r;};
P.prototype.removeAllIntervalHeaders=function(){var r=this.removeAllAggregation("intervalHeaders",true);this.getCalendarRow().invalidate();return r;};
P.prototype.destroyIntervalHeaders=function(){var d=this.destroyAggregation("intervalHeaders",true);this.getCalendarRow().invalidate();return d;};
P.prototype.setSelected=function(s){this.setProperty("selected",s,true);this._oColumnListItem.setSelected(s);return this;};
P.prototype.getColumnListItem=function(){return this._oColumnListItem;};
P.prototype.getCalendarRow=function(){return this._oColumnListItem.getCells()[1];};
P.prototype.applyFocusInfo=function(f){this.getCalendarRow().applyFocusInfo(f);return this;};
return P;},true);
sap.ui.predefine('sap/m/PlanningCalendarView',['jquery.sap.global','sap/ui/core/Element','./StandardListItem','./StandardListItemRenderer','sap/ui/core/Renderer','./library','sap/ui/unified/library'],function(q,E,S,a,R,l,u){"use strict";
var P=E.extend("sap.m.PlanningCalendarView",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},description:{type:"string",group:"Data"},intervalsS:{type:"int",group:"Appearance",defaultValue:6},intervalsM:{type:"int",group:"Appearance",defaultValue:8},intervalsL:{type:"int",group:"Appearance",defaultValue:12},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false}}}});
return P;},true);
sap.ui.predefine('sap/m/Popover',['jquery.sap.global','./Bar','./Button','./InstanceManager','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/theming/Parameters'],function(q,B,a,I,l,C,P,S,b){"use strict";
var c=C.extend("sap.m.Popover",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Behavior",defaultValue:sap.m.PlacementType.Right},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},title:{type:"string",group:"Appearance",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},offsetX:{type:"int",group:"Appearance",defaultValue:0},offsetY:{type:"int",group:"Appearance",defaultValue:0},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentMinWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enableScrolling:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},bounce:{type:"boolean",group:"Behavior",defaultValue:null},resizable:{type:"boolean",group:"Dimension",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},beginButton:{type:"sap.ui.core.Control",multiple:false},endButton:{type:"sap.ui.core.Control",multiple:false}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}}}}});
c._bIE9=(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10);c._bIOS7=sap.ui.Device.os.ios&&sap.ui.Device.os.version>=7&&sap.ui.Device.os.version<8&&sap.ui.Device.browser.name==="sf";
c.prototype.init=function(){this._arrowOffsetThreshold=4;this._marginTopInit=false;this._marginTop=48;this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._$window=q(window);this._initialWindowDimensions={width:this._$window.width(),height:this._$window.height()};this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setAutoClose(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this._placements=[sap.m.PlacementType.Top,sap.m.PlacementType.Right,sap.m.PlacementType.Bottom,sap.m.PlacementType.Left,sap.m.PlacementType.Vertical,sap.m.PlacementType.Horizontal,sap.m.PlacementType.Auto,sap.m.PlacementType.VerticalPreferedTop,sap.m.PlacementType.VerticalPreferedBottom,sap.m.PlacementType.HorizontalPreferedLeft,sap.m.PlacementType.HorizontalPreferedRight,sap.m.PlacementType.VerticalPreferredTop,sap.m.PlacementType.VerticalPreferredBottom,sap.m.PlacementType.HorizontalPreferredLeft,sap.m.PlacementType.HorizontalPreferredRight,sap.m.PlacementType.PreferredRightOrFlip,sap.m.PlacementType.PreferredLeftOrFlip,sap.m.PlacementType.PreferredTopOrFlip,sap.m.PlacementType.PreferredBottomOrFlip];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];this._offsets=["0 -18","18 0","0 18","-18 0"];this._arrowOffset=18;this._followOfTolerance=32;this._scrollContentList=[sap.m.NavContainer,sap.m.Page,sap.m.ScrollContainer];this._fnAdjustPositionAndArrow=q.proxy(this._adjustPositionAndArrow,this);this._fnOrientationChange=q.proxy(this._onOrientationChange,this);this._fnFollowOf=q.proxy(function(i){var L=i.lastOfRect,r=i.currentOfRect;if(!sap.ui.Device.system.desktop||(Math.abs(L.top-r.top)<=this._followOfTolerance&&Math.abs(L.left-r.left)<=this._followOfTolerance)||(Math.abs(L.top+L.height-r.top-r.height)<=this._followOfTolerance&&Math.abs(L.left+L.width-r.left-r.width)<=this._followOfTolerance)){this.oPopup._applyPosition(this.oPopup._oLastPosition,true);}else{this.close();}},this);this.setFollowOf(true);this._oRestoreFocusDelegate={onBeforeRendering:function(){var A=q(document.activeElement),o=A.control(0);this._sFocusControlId=o&&o.getId();},onAfterRendering:function(){if(this._sFocusControlId&&!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){sap.ui.getCore().byId(this._sFocusControlId).focus();}}};var t=this;this.oPopup._applyPosition=function(p,f){var e=this.getOpenState(),o;if(e===sap.ui.core.OpenState.CLOSING||e===sap.ui.core.OpenState.CLOSED){return;}if(f){t._storeScrollPosition();}t._clearCSSStyles();var i=q.inArray(t.getPlacement(),t._placements);if(i>3&&!t._bPosCalced){t._calcPlacement();return;}t._bPosCalced=false;if(t._oOpenBy instanceof sap.ui.core.Element){p.of=t._getOpenByDomRef();}if(!p.of){q.sap.log.warning("sap.m.Popover: in function applyPosition, the openBy element doesn't have any DOM output. "+t);return;}if(!q.sap.containsOrEquals(document.documentElement,p.of)&&p.of.id){o=q.sap.byId(p.of.id);if(o){p.of=o;}else{q.sap.log.warning("sap.m.Popover: in function applyPosition, the openBy element's DOM is already detached from DOM tree and can't be found again by the same id. "+t);return;}}var r=q(p.of).rect();if(f&&t._$window.height()==t._initialWindowDimensions.height&&(r.top+r.height<=0||r.top>=t._$window.height()||r.left+r.width<=0||r.left>=t._$window.width())){t.close();return;}var s=t.getDomRef("scroll");if(!sap.ui.Device.system.desktop){q(window).scrollLeft(0);}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._fnAdjustPositionAndArrow();t._restoreScrollPosition();t._registerContentResizeHandler(s);};this.oPopup.close=function(d){var e=typeof d==="boolean";if(d!==true&&(this.touchEnabled||!this._isFocusInsidePopup())){t.fireBeforeClose({openBy:t._oOpenBy});}t._deregisterContentResizeHandler();P.prototype.close.apply(this,e?[]:arguments);t.removeDelegate(t._oRestoreFocusDelegate);if(document.activeElement&&!this.restoreFocus&&!this._bModal){document.activeElement.blur();}};};
c.prototype.onBeforeRendering=function(){var n,p;if(!this._bVScrollingEnabled&&!this._bHScrollingEnabled&&this._hasSingleScrollableContent()){this._forceDisableScrolling=true;q.sap.log.info("VerticalScrolling and horizontalScrolling in sap.m.Popover with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else{this._forceDisableScrolling=false;}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling(),zynga:false,preventDefault:false,nonTouchScrolling:"scrollbar",bounce:this.getBounce()===""?undefined:this.getBounce(),iscroll:sap.ui.Device.browser.name==="an"?"force":undefined});}}if(this._bContentChanged){this._bContentChanged=false;n=this._getSingleNavContent();p=this._getSinglePageContent();if(n&&!this.getModal()&&!sap.ui.Device.support.touch&&!q.sap.simulateMobileOnDesktop){n.attachEvent("afterNavigate",function(e){q.sap.focus(this.getDomRef());},this);}if(n||p){p=p||n.getCurrentPage();if(p&&p._getAnyHeader){this.addStyleClass("sapMPopoverWithHeaderCont");}if(n){n.attachEvent("navigate",function(e){var o=e.getParameter("to");if(o instanceof sap.m.Page){this.$().toggleClass("sapMPopoverWithHeaderCont",!!o._getAnyHeader());}},this);}}}};
c.prototype.onAfterRendering=function(){var $,d,e;if(!this._marginTopInit&&this.getShowArrow()){this._marginTop=2;if(this._oOpenBy){$=q(this._getOpenByDomRef());if(!($.closest("header.sapMIBar").length>0)){d=$.closest(".sapMPage");if(d.length>0){e=d.children("header.sapMIBar");if(e.length>0){this._marginTop+=e.outerHeight();}}}this._marginTopInit=true;}}};
c.prototype.exit=function(){this._deregisterContentResizeHandler();sap.ui.Device.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);this.removeDelegate(this._oRestoreFocusDelegate);this._oRestoreFocusDelegate=null;if(this.oPopup){this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._internalHeader){this._internalHeader.destroy();this._internalHeader=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}};
c.prototype.openBy=function(o,s){var p=this.oPopup,e=this.oPopup.getOpenState(),f=this._getInitialFocusId(),d,i;this._bSizeCompact=sap.m._bSizeCompact||!!document.querySelector('body.sapUiSizeCompact')||this.hasStyleClass("sapUiSizeCompact");this._adaptPositionParams();if(e===sap.ui.core.OpenState.OPEN||e===sap.ui.core.OpenState.OPENING){if(this._oOpenBy===o){return this;}else{var g=function(){p.detachClosed(g,this);this.openBy(o);};p.attachClosed(g,this);this.close();return this;}}if(!o){return this;}if(sap.ui.Device.support.touch){sap.ui.Device.resize.attachHandler(this._fnOrientationChange);}if(!this._oOpenBy||o!==this._oOpenBy){this._oOpenBy=o;}this.fireBeforeOpen({openBy:this._oOpenBy});p.attachOpened(this._handleOpened,this);p.attachClosed(this._handleClosed,this);p.setInitialFocusId(f);i=q.inArray(this.getPlacement(),this._placements);if(i>-1){d=this._getOpenByDomRef();if(!d){q.sap.log.error("sap.m.Popover id = "+this.getId()+": is opened by a control which isn't rendered yet.");return this;}p.setAutoCloseAreas([d]);p.setContent(this);if(i<=3){p.setPosition(this._myPositions[i],this._atPositions[i],d,this._calcOffset(this._offsets[i]),"fit");}else{p._oPosition.of=d;}var t=this;var h=function(){if(p.getOpenState()===sap.ui.core.OpenState.CLOSING){if(t._sOpenTimeout){clearTimeout(t._sOpenTimeout);t._sOpenTimeout=null;}t._sOpenTimeout=setTimeout(h,150);}else{t._oPreviousFocus=P.getCurrentFocusInfo();p.open();t.addDelegate(t._oRestoreFocusDelegate,t);if(!s){I.addPopoverInstance(t);}}};h();}else{q.sap.log.error(this.getPlacement()+"is not a valid value! It can only be top, right, bottom or left");}return this;};
c.prototype.close=function(){var e=this.oPopup.getOpenState(),s;if(e===sap.ui.core.OpenState.CLOSED||e===sap.ui.core.OpenState.CLOSING){return this;}this.fireBeforeClose({openBy:this._oOpenBy});this.oPopup.close(true);if(this._oPreviousFocus){s=(this._oPreviousFocus.sFocusId===sap.ui.getCore().getCurrentFocusedControlId())||(this._oPreviousFocus.sFocusId===document.activeElement.id);if(!s&&this.oPopup.restoreFocus){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;}}return this;};
c.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};
c.prototype.setFollowOf=function(v){if(v){this.oPopup.setFollowOf(this._fnFollowOf);}else{this.oPopup.setFollowOf(false);}return this;};
c.prototype._clearCSSStyles=function(){var s=this.getDomRef().style,$=this.$("cont"),d=$.children(".sapMPopoverScroll"),o=$[0].style,e=d[0].style,f=this.getContentWidth(),g=this.getContentHeight(),h=this.$("arrow"),w,W;if(f.indexOf("%")>0){w=this._$window.width();f=sap.m.PopupHelper.calcPercentageSize(f,w);}if(g.indexOf("%")>0){W=this._$window.height();g=sap.m.PopupHelper.calcPercentageSize(g,W);}o.width=f||"";o.height=g||"";o.maxWidth="";o.maxHeight="";s.left="";s.right="";s.top="";s.bottom="";s.width="";s.height="";e.width="";e.display="";h.removeClass("sapMPopoverArrRight sapMPopoverArrLeft sapMPopoverArrDown sapMPopoverArrUp sapMPopoverCrossArr sapMPopoverFooterAlignArr sapMPopoverHeaderAlignArr");h.css({left:"",top:""});};
c.prototype._onOrientationChange=function(){var e=this.oPopup.getOpenState();if(!(e===sap.ui.core.OpenState.OPEN||e===sap.ui.core.OpenState.OPENING)){return;}this.oPopup._applyPosition(this.oPopup._oLastPosition,true);};
c.prototype._handleOpened=function(){var t=this;this.oPopup.detachOpened(this._handleOpened,this);if(!sap.ui.Device.support.touch){setTimeout(function(){sap.ui.Device.resize.attachHandler(t._fnOrientationChange);},0);}var f=this._getInitialFocusId(),o=sap.ui.getCore().byId(f);q.sap.focus(o?o.getFocusDomRef():q.sap.domById(f));this.fireAfterOpen({openBy:this._oOpenBy});};
c.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);sap.ui.Device.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);this.fireAfterClose({openBy:this._oOpenBy});};
c.prototype.onfocusin=function(e){var s=e.target,$=this.$();if(s.id===this.getId()+"-firstfe"){var L=$.lastFocusableDomRef();q.sap.focus(L);}else if(s.id===this.getId()+"-lastfe"){var f=$.firstFocusableDomRef();q.sap.focus(f);}};
c.prototype.onkeydown=function(e){var k=q.sap.KeyCodes,K=e.which||e.keyCode,A=e.altKey;if(K===k.ESCAPE||(A&&K===k.F4)){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this.close();e.stopPropagation();e.preventDefault();}};
c.prototype.onmousedown=function(E){var m={width:400,height:128};var r=sap.ui.getCore().getConfiguration().getRTL();if(E.target.className!=="sapMPopoverResizeHandle"){return;}var $=q(document);var d=this.$();var t=this;d.addClass('sapMPopoverResizing');E.preventDefault();E.stopPropagation();var i={x:E.pageX,y:E.pageY,width:d.width(),height:d.height()};$.on("mousemove.sapMPopover",function(e){var w,h;if(r){w=i.width+i.x-e.pageX;h=i.height+(i.y-e.pageY);}else{w=i.width+e.pageX-i.x;h=i.height+(i.y-e.pageY);}t.setContentWidth(Math.max(w,m.width)+'px');t.setContentHeight(Math.max(h,m.height)+'px');});$.on("mouseup.sapMPopover",function(){d.removeClass("sapMPopoverResizing");$.off("mouseup.sapMPopover, mousemove.sapMPopover");});};
c.prototype._hasSingleNavContent=function(){return!!this._getSingleNavContent();};
c.prototype._getSingleNavContent=function(){var d=this._getAllContent();while(d.length===1&&d[0]instanceof sap.ui.core.mvc.View){d=d[0].getContent();}if(d.length===1&&d[0]instanceof sap.m.NavContainer){return d[0];}else{return null;}};
c.prototype._getSinglePageContent=function(){var d=this._getAllContent();while(d.length===1&&d[0]instanceof sap.ui.core.mvc.View){d=d[0].getContent();}if(d.length===1&&d[0]instanceof sap.m.Page){return d[0];}else{return null;}};
c.prototype._hasSinglePageContent=function(){var d=this._getAllContent();while(d.length===1&&d[0]instanceof sap.ui.core.mvc.View){d=d[0].getContent();}if(d.length===1&&d[0]instanceof sap.m.Page){return true;}else{return false;}};
c.prototype._hasSingleScrollableContent=function(){var d=this._getAllContent(),i;while(d.length===1&&d[0]instanceof sap.ui.core.mvc.View){d=d[0].getContent();}if(d.length===1){for(i=0;i<this._scrollContentList.length;i++){if(d[0]instanceof this._scrollContentList[i]){return true;}}return false;}else{return false;}};
c.prototype._getOffsetX=function(){var f=this.getPlacement(),F=0;if(this._bHorizontalFlip){var p=this._getOpenByDomRef();var h=p!==undefined;var i=h?p.getBoundingClientRect().width:0;F=f==="PreferredRightOrFlip"?Math.abs(i):-Math.abs(i);}var r=sap.ui.getCore().getConfiguration().getRTL();return F*(r?-1:1)+this.getOffsetX()*(r?-1:1);};
c.prototype._getOffsetY=function(){var f=this.getPlacement(),F=0;if(this._bVerticalFlip){var p=this._getOpenByDomRef();var h=p!==undefined;var i=h?p.getBoundingClientRect().height:0;F=f==="PreferredTopOrFlip"?-Math.abs(i):Math.abs(i);}return F+this.getOffsetY();};
c.prototype._calcOffset=function(o){var O=this._getOffsetX(),i=this._getOffsetY();var p=o.split(" ");return(parseInt(p[0],10)+O)+" "+(parseInt(p[1],10)+i);};
c.prototype._calcPlacement=function(){var p=this.getPlacement();var o=this._getOpenByDomRef();switch(p){case sap.m.PlacementType.Auto:this._calcAuto();break;case sap.m.PlacementType.Vertical:case sap.m.PlacementType.VerticalPreferedTop:case sap.m.PlacementType.VerticalPreferredTop:case sap.m.PlacementType.VerticalPreferedBottom:case sap.m.PlacementType.VerticalPreferredBottom:case sap.m.PlacementType.PreferredTopOrFlip:case sap.m.PlacementType.PreferredBottomOrFlip:this._calcVertical();break;case sap.m.PlacementType.Horizontal:case sap.m.PlacementType.HorizontalPreferedLeft:case sap.m.PlacementType.HorizontalPreferredLeft:case sap.m.PlacementType.HorizontalPreferedRight:case sap.m.PlacementType.HorizontalPreferredRight:case sap.m.PlacementType.PreferredRightOrFlip:case sap.m.PlacementType.PreferredLeftOrFlip:this._calcHorizontal();break;}this._bPosCalced=true;var i=q.inArray(this._oCalcedPos,this._placements);this.oPopup.setPosition(this._myPositions[i],this._atPositions[i],o,this._calcOffset(this._offsets[i]),"fit");};
c.prototype._calcVertical=function(){var $=q(this._getOpenByDomRef());var h=$[0]!==undefined;var p=this.getPlacement()===sap.m.PlacementType.VerticalPreferedTop||this.getPlacement()===sap.m.PlacementType.VerticalPreferredTop;var d=this.getPlacement()===sap.m.PlacementType.VerticalPreferedBottom||this.getPlacement()===sap.m.PlacementType.VerticalPreferredBottom;var e=this.getPlacement()===sap.m.PlacementType.PreferredTopOrFlip;var f=this.getPlacement()===sap.m.PlacementType.PreferredBottomOrFlip;var i=h?$[0].getBoundingClientRect().top:0;var g=h?$[0].getBoundingClientRect().height:0;var o=this._getOffsetY();var t=i-this._marginTop+o;var j=i+g;var k=this._$window.height()-j-this._marginBottom-o;var m=this.$().outerHeight();if(p&&t>m+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=sap.m.PlacementType.Top;}else if(e){if(t>m+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=sap.m.PlacementType.Top;}else{this._bVerticalFlip=true;this._oCalcedPos=sap.m.PlacementType.Bottom;}}else if(d&&k>m+this._arrowOffset){this._oCalcedPos=sap.m.PlacementType.Bottom;this._bVerticalFlip=false;}else if(f){if(k>m+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=sap.m.PlacementType.Bottom;}else{this._bVerticalFlip=true;this._oCalcedPos=sap.m.PlacementType.Top;}}else if(t>k){this._oCalcedPos=sap.m.PlacementType.Top;}else{this._oCalcedPos=sap.m.PlacementType.Bottom;}};
c.prototype._calcHorizontal=function(){var $=q(this._getOpenByDomRef());var h=$[0]!==undefined;var p=this.getPlacement()===sap.m.PlacementType.HorizontalPreferedLeft||this.getPlacement()===sap.m.PlacementType.HorizontalPreferredLeft;var d=this.getPlacement()===sap.m.PlacementType.HorizontalPreferedRight||this.getPlacement()===sap.m.PlacementType.HorizontalPreferredRight;var i=h?$[0].getBoundingClientRect().left:0;var e=h?$[0].getBoundingClientRect().width:0;var o=this._getOffsetX();var L=i-this._marginLeft+o;var f=i+e;var r=this._$window.width()-f-this._marginRight-o;var g=this.$().outerWidth();var j=this.getPlacement()===sap.m.PlacementType.PreferredLeftOrFlip;var k=this.getPlacement()===sap.m.PlacementType.PreferredRightOrFlip;var R=sap.ui.getCore().getConfiguration().getRTL();if(p&&L>g+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=R?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}else if(j){if(L>g+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=R?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}else{this._bHorizontalFlip=true;this._oCalcedPos=R?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}}else if(d&&r>g+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=R?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}else if(k){if(r>g+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=R?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}else{this._bHorizontalFlip=true;this._oCalcedPos=R?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}}else if(L>r){this._oCalcedPos=R?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}else{this._oCalcedPos=R?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}};
c.prototype._calcAuto=function(){if(this._$window.width()>this._$window.height()){if(this._checkHorizontal()){this._calcHorizontal();}else if(this._checkVertical()){this._calcVertical();}else{this._calcBestPos();}}else{if(this._checkVertical()){this._calcVertical();}else if(this._checkHorizontal()){this._calcHorizontal();}else{this._calcBestPos();}}};
c.prototype._checkHorizontal=function(){var $=q(this._getOpenByDomRef());var h=$[0]!==undefined;var p=h?$[0].getBoundingClientRect().left:0;var i=h?$[0].getBoundingClientRect().width:0;var o=this._getOffsetX();var L=p-this._marginLeft+o;var d=p+i;var r=this._$window.width()-d-this._marginRight-o;var e=this.$();var w=e.outerWidth()+this._arrowOffset;if((w<=L)||(w<=r)){return true;}};
c.prototype._checkVertical=function(){var $=q(this._getOpenByDomRef());var h=$[0]!==undefined;var p=h?$[0].getBoundingClientRect().top:0;var i=h?$[0].getBoundingClientRect().height:0;var o=this._getOffsetY();var t=p-this._marginTop+o;var d=p+i;var e=this._$window.height()-d-this._marginBottom-o;var f=this.$();var H=f.outerHeight()+this._arrowOffset;if((H<=t)||(H<=e)){return true;}};
c.prototype._calcBestPos=function(){var $=this.$();var h=$.outerHeight();var w=$.outerWidth();var r=sap.ui.getCore().getConfiguration().getRTL();var d=q(this._getOpenByDomRef());var H=d[0]!==undefined;var p=H?d[0].getBoundingClientRect().left:0;var i=H?d[0].getBoundingClientRect().top:0;var e=H?d[0].getBoundingClientRect().width:0;var f=H?d[0].getBoundingClientRect().height:0;var o=this._getOffsetX();var O=this._getOffsetY();var t=i-this._marginTop+O;var g=i+f;var j=this._$window.height()-g-this._marginBottom-O;var L=p-this._marginLeft+o;var k=p+e;var R=this._$window.width()-k-this._marginRight-o;var m=h*w;var A;var n;if((this._$window.height()-this._marginTop-this._marginBottom)>=h){A=h;}else{A=this._$window.height()-this._marginTop-this._marginBottom;}if((this._$window.width()-this._marginLeft-this._marginRight)>=w){n=w;}else{n=this._$window.width()-this._marginLeft-this._marginRight;}var s=(A*(L))/m;var u=(A*(R))/m;var T=(n*(t))/m;var v=(n*(j))/m;var M=Math.max(s,u);var x=Math.max(T,v);if(M>x){if(M===s){this._oCalcedPos=r?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}else if(M===u){this._oCalcedPos=r?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}}else if(x>M){if(x===T){this._oCalcedPos=sap.m.PlacementType.Top;}else if(x===v){this._oCalcedPos=sap.m.PlacementType.Bottom;}}else if(x===M){if(this._$window.height()>this._$window.width()){if(x===T){this._oCalcedPos=sap.m.PlacementType.Top;}else if(x===v){this._oCalcedPos=sap.m.PlacementType.Bottom;}}else{if(M===s){this._oCalcedPos=r?sap.m.PlacementType.Right:sap.m.PlacementType.Left;}else if(M===u){this._oCalcedPos=r?sap.m.PlacementType.Left:sap.m.PlacementType.Right;}}}};
c.outerWidth=function(e,i){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().width;}return q(e).outerWidth(i);};
c.outerHeight=function(e,i){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().height;}return q(e).outerHeight(i);};
c.prototype._getPositionParams=function($,d,e,f){var o=window.getComputedStyle($[0]),g=window.getComputedStyle(e[0]),p={};p._$popover=$;p._$parent=q(this._getOpenByDomRef());p._$arrow=d;p._$content=e;p._$scrollArea=f;p._$header=$.children(".sapMPopoverHeader");p._$subHeader=$.children(".sapMPopoverSubHeader");p._$footer=$.children(".sapMPopoverFooter");p._fWindowTop=this._$window.scrollTop();p._fWindowRight=this._$window.width();p._fWindowBottom=(c._bIOS7&&sap.ui.Device.orientation.landscape&&window.innerHeight)?window.innerHeight:this._$window.height();p._fWindowLeft=this._$window.scrollLeft();p._fDocumentWidth=p._fWindowLeft+p._fWindowRight;p._fDocumentHeight=p._fWindowTop+p._fWindowBottom;p._fArrowHeight=d.outerHeight(true);p._fWidth=c.outerWidth($[0]);p._fHeight=$.outerHeight();p._fHeaderHeight=p._$header.length>0?p._$header.outerHeight(true):0;p._fSubHeaderHeight=p._$subHeader.length>0?p._$subHeader.outerHeight(true):0;p._fFooterHeight=p._$footer.length>0?p._$footer.outerHeight(true):0;p._fOffset=$.offset();p._fOffsetX=this._getOffsetX();p._fOffsetY=this._getOffsetY();p._fMarginTop=p._fWindowTop+this._marginTop;p._fMarginRight=this._marginRight;p._fMarginBottom=this._marginBottom;p._fMarginLeft=p._fWindowLeft+this._marginLeft;p._fPopoverBorderTop=parseFloat(o.borderTopWidth);p._fPopoverBorderRight=parseFloat(o.borderRightWidth);p._fPopoverBorderBottom=parseFloat(o.borderBottomWidth);p._fPopoverBorderLeft=parseFloat(o.borderLeftWidth);p._fContentMarginTop=parseFloat(g.marginTop);p._fContentMarginBottom=parseFloat(g.marginBottom);return p;};
c.prototype._recalculateMargins=function(s,p){var r=sap.ui.getCore().getConfiguration().getRTL();switch(s){case sap.m.PlacementType.Left:if(r){p._fMarginLeft=p._$parent.offset().left+c.outerWidth(p._$parent[0],false)+this._arrowOffset-p._fOffsetX;}else{p._fMarginRight=p._fDocumentWidth-p._$parent.offset().left+this._arrowOffset-p._fOffsetX;}break;case sap.m.PlacementType.Right:if(r){p._fMarginRight=p._fDocumentWidth-p._$parent.offset().left+this._arrowOffset-p._fOffsetX;}else{p._fMarginLeft=p._$parent.offset().left+c.outerWidth(p._$parent[0],false)+this._arrowOffset+p._fOffsetX;}break;case sap.m.PlacementType.Top:p._fMarginBottom=p._fDocumentHeight-p._$parent.offset().top+this._arrowOffset-p._fOffsetY;break;case sap.m.PlacementType.Bottom:p._fMarginTop=p._$parent.offset().top+p._$parent.outerHeight()+this._arrowOffset+p._fOffsetY;break;}};
c.prototype._getPopoverPositionCss=function(p){var L,r,t,i,d=p._fDocumentWidth-p._fOffset.left-p._fWidth,e=p._fDocumentHeight-p._fOffset.top-p._fHeight,E=(p._fDocumentWidth-p._fMarginRight-p._fMarginLeft)<p._fWidth,f=(p._fDocumentHeight-p._fMarginTop-p._fMarginBottom)<p._fHeight,o=p._fOffset.left<p._fMarginLeft,O=d<p._fMarginRight,g=p._fOffset.top<p._fMarginTop,h=e<p._fMarginBottom,R=sap.ui.getCore().getConfiguration().getRTL();if(E){L=p._fMarginLeft;r=p._fMarginRight;}else{if(o){L=p._fMarginLeft;if(R){r="";}}else if(O){r=p._fMarginRight;L="";}}if(f){t=p._fMarginTop;i=p._fMarginBottom;}else{if(g){t=p._fMarginTop;}else if(h){i=p._fMarginBottom;t="";}}return{top:t,bottom:Math.max(i-p._fWindowTop,i),left:L,right:typeof r==="number"?r-p._fWindowLeft:r};};
c.prototype._getContentDimensionsCss=function(p){var o={},A=p._$content.height(),m=this._getMaxContentWidth(p),M=this._getMaxContentHeight(p);M=Math.max(M,0);o["max-width"]=m+"px";if(this.getContentHeight()||(A>M)){o["height"]=Math.min(M,A)+"px";}else{o["height"]="";o["max-height"]=M+"px";}return o;};
c.prototype._getMaxContentWidth=function(p){return p._fDocumentWidth-p._fMarginLeft-p._fMarginRight-p._fPopoverBorderLeft-p._fPopoverBorderRight;};
c.prototype._getMaxContentHeight=function(p){return p._fDocumentHeight-p._fMarginTop-p._fMarginBottom-p._fHeaderHeight-p._fSubHeaderHeight-p._fFooterHeight-p._fContentMarginTop-p._fContentMarginBottom-p._fPopoverBorderTop-p._fPopoverBorderBottom;};
c.prototype._isHorizontalScrollbarNeeded=function(p){return this.getHorizontalScrolling()&&(p._$scrollArea.outerWidth(true)<=p._$content.width());};
c.prototype._getArrowOffsetCss=function(s,p){var i,r=sap.ui.getCore().getConfiguration().getRTL();p._fWidth=p._$popover.outerWidth();p._fHeight=p._$popover.outerHeight();if(s===sap.m.PlacementType.Left||s===sap.m.PlacementType.Right){i=p._$parent.offset().top-p._$popover.offset().top-p._fPopoverBorderTop+p._fOffsetY+0.5*(c.outerHeight(p._$parent[0],false)-p._$arrow.outerHeight(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fHeight-this._arrowOffsetThreshold-p._$arrow.outerHeight());return{"top":i};}else if(s===sap.m.PlacementType.Top||s===sap.m.PlacementType.Bottom){if(r){i=p._$popover.offset().left+c.outerWidth(p._$popover[0],false)-(p._$parent.offset().left+c.outerWidth(p._$parent[0],false))+p._fPopoverBorderRight+p._fOffsetX+0.5*(c.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"right":i};}else{i=p._$parent.offset().left-p._$popover.offset().left-p._fPopoverBorderLeft+p._fOffsetX+0.5*(c.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"left":i};}}};
c.prototype._getArrowPositionCssClass=function(s){switch(s){case sap.m.PlacementType.Left:return"sapMPopoverArrRight";case sap.m.PlacementType.Right:return"sapMPopoverArrLeft";case sap.m.PlacementType.Top:return"sapMPopoverArrDown";case sap.m.PlacementType.Bottom:return"sapMPopoverArrUp";}};
c.prototype._getArrowStyleCssClass=function(p){var A=p._$arrow.position(),f=p._$footer.position(),n=this._getSingleNavContent(),o=this._getSinglePageContent(),i=0;if(n||o){o=o||n.getCurrentPage();if(o){i=o._getAnyHeader().$().outerHeight();}}if((A.top+p._fArrowHeight)<(p._fHeaderHeight+p._fSubHeaderHeight)||((A.top+p._fArrowHeight)<i)){return"sapMPopoverHeaderAlignArr";}else if((A.top<(p._fHeaderHeight+p._fSubHeaderHeight))||(A.top<i)||(p._$footer.length&&((A.top+p._fArrowHeight)>f.top)&&(A.top<f.top))){return"sapMPopoverCrossArr";}else if(p._$footer.length&&(A.top>f.top)){return"sapMPopoverFooterAlignArr";}};
c.prototype._getCalculatedPlacement=function(){return this._oCalcedPos||this.getPlacement();};
c.prototype._adjustPositionAndArrow=function(){var e=this.oPopup.getOpenState();if(!(e===sap.ui.core.OpenState.OPEN||e===sap.ui.core.OpenState.OPENING)){return;}var $=this.$(),d=this.$("arrow"),f=this.$("cont"),g=this.$("scroll"),s=this._getCalculatedPlacement(),p=this._getPositionParams($,d,f,g);this._recalculateMargins(s,p);var o=this._getPopoverPositionCss(p),h=this._getContentDimensionsCss(p),H=this._isHorizontalScrollbarNeeded(p);$.css(o);f.css(h);if(H){g.css("display","block");}if(this.getShowArrow()){var A=this._getArrowOffsetCss(s,p),i=this._getArrowPositionCssClass(s);d.removeAttr("style");d.css(A);d.addClass(i);if(s===sap.m.PlacementType.Left||s===sap.m.PlacementType.Right){var j=this._getArrowStyleCssClass(p);if(j){d.addClass(j);}}$.css("overflow","visible");}this._afterAdjustPositionAndArrowHook();};
c.prototype._adaptPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=18;this._offsets=["0 -18","18 0","0 18","-18 0"];if(this._bSizeCompact){this._arrowOffset=9;this._offsets=["0 -9","9 0","0 9","-9 0"];}this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"];}};
c.prototype._afterAdjustPositionAndArrowHook=function(){};
c.prototype._isPopupElement=function(d){var p=this._getOpenByDomRef();return!!(q(d).closest(sap.ui.getCore().getStaticAreaRef()).length)||!!(q(d).closest(p).length);};
c.prototype._getAnyHeader=function(){if(this.getCustomHeader()){return this.getCustomHeader();}else{if(this.getShowHeader()){this._createInternalHeader();return this._internalHeader;}}};
c.prototype._createInternalHeader=function(){if(!this._internalHeader){var t=this;this._internalHeader=new B(this.getId()+"-intHeader");this.setAggregation("_internalHeader",this._internalHeader);this._internalHeader.addEventDelegate({onAfterRendering:function(){t._restoreFocus();}});return true;}else{return false;}};
c.prototype._openAnimation=function(r,R,o){var t=this;if(c._bIE9){o();}else{var O=false,T=function(){if(O||!t.oPopup||t.oPopup.getOpenState()!==sap.ui.core.OpenState.OPENING){return;}r.unbind("webkitTransitionEnd transitionend");o();O=true;};setTimeout(function(){r.addClass("sapMPopoverTransparent");r.css("display","block");setTimeout(function(){r.bind("webkitTransitionEnd transitionend",T);r.removeClass("sapMPopoverTransparent");setTimeout(function(){T();},300);},sap.ui.Device.browser.firefox?50:0);},0);}};
c.prototype._closeAnimation=function(r,R,f){if(c._bIE9){f();}else{var d=false,t=function(){if(d){return;}r.unbind("webkitTransitionEnd transitionend");setTimeout(function(){f();d=true;r.removeClass("sapMPopoverTransparent");},0);};r.bind("webkitTransitionEnd transitionend",t).addClass("sapMPopoverTransparent");setTimeout(function(){t();},300);}};
c.prototype._getInitialFocusId=function(){return this.getInitialFocus()||this._getFirstVisibleButtonId()||this._getFirstFocusableContentElementId()||this.getId();};
c.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}return s;};
c.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var f=$.firstFocusableDomRef();if(f){r=f.id;}return r;};
c.prototype._restoreFocus=function(){if(this.isOpen()){var f=this._getInitialFocusId(),o=sap.ui.getCore().byId(f);q.sap.focus(o?o.getFocusDomRef():q.sap.domById(f));}};
c.prototype._registerContentResizeHandler=function(s){if(!this._sResizeListenerId){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(s||this.getDomRef("scroll"),this._fnOrientationChange);}};
c.prototype._deregisterContentResizeHandler=function(){if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}};
c.prototype._storeScrollPosition=function(){var $=this.$("cont");if($.length>0){this._oScrollPosDesktop={x:$.scrollLeft(),y:$.scrollTop()};}};
c.prototype._restoreScrollPosition=function(){if(!this._oScrollPosDesktop){return;}var $=this.$("cont");if($.length>0){$.scrollLeft(this._oScrollPosDesktop.x).scrollTop(this._oScrollPosDesktop.y);this._oScrollPosDesktop=null;}};
c.prototype._repositionOffset=function(){var e=this.oPopup.getOpenState(),L,p;if(!(e===sap.ui.core.OpenState.OPEN)){return this;}L=this.oPopup._oLastPosition;p=q.inArray(this.getPlacement(),this._placements);if(p===-1){return this;}if(p<4){L.offset=this._calcOffset(this._offsets[p]);this.oPopup._applyPosition(L);}else{this._calcPlacement();}return this;};
c.prototype._getOpenByDomRef=function(){if(!this._oOpenBy){return null;}if(this._oOpenBy instanceof sap.ui.core.Element){return(this._oOpenBy.getPopupAnchorDomRef&&this._oOpenBy.getPopupAnchorDomRef())||this._oOpenBy.getFocusDomRef();}else{return this._oOpenBy;}};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._bVerticalFlip=false;this._bHorizontalFlip=false;var i=q.inArray(p,this._placements);if(i<=3){this._oCalcedPos=p;}return this;};
c.prototype.setTitle=function(t){if(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:this.getTitle(),level:"H1"});this._createInternalHeader();this._internalHeader.addContentMiddle(this._headerTitle);}}return this;};
c.prototype.setBeginButton=function(o){var O=this.getBeginButton();if(O===o){return this;}this._createInternalHeader();this._beginButton=o;if(o){if(O){this._internalHeader.removeAggregation("contentLeft",O,true);}this._internalHeader.addAggregation("contentLeft",o);}else{this._internalHeader.removeContentLeft(O);}return this;};
c.prototype.setEndButton=function(o){var O=this.getEndButton();if(O===o){return this;}this._createInternalHeader();this._endButton=o;if(o){if(O){this._internalHeader.removeAggregation("contentRight",O,true);}this._internalHeader.insertAggregation("contentRight",o,1,true);this._internalHeader.invalidate();}else{this._internalHeader.removeContentRight(O);}return this;};
c.prototype.setLeftButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};
c.prototype.setRightButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};
c.prototype.setShowHeader=function(v){if(v===this.getShowHeader()||this.getCustomHeader()){return this;}if(v){if(this._internalHeader){this._internalHeader.$().show();}}else{if(this._internalHeader){this._internalHeader.$().hide();}}this.setProperty("showHeader",v,true);return this;};
c.prototype.setModal=function(m,M){if(m===this.getModal()){return this;}this.oPopup.setModal(m,q.trim("sapMPopoverBLayer "+M||""));this.setProperty("modal",m,true);return this;};
c.prototype.setOffsetX=function(v){this.setProperty("offsetX",v,true);return this._repositionOffset();};
c.prototype.setOffsetY=function(v){this.setProperty("offsetY",v,true);return this._repositionOffset();};
c.prototype.setEnableScrolling=function(v){this.setHorizontalScrolling(v);this.setVerticalScrolling(v);var o=this.getEnableScrolling();if(o===v){return this;}this.setProperty("enableScrolling",v,true);return this;};
c.prototype.setVerticalScrolling=function(v){this._bVScrollingEnabled=v;var o=this.getVerticalScrolling();if(o===v){return this;}this.$().toggleClass("sapMPopoverVerScrollDisabled",!v);this.setProperty("verticalScrolling",v,true);if(this._oScroller){this._oScroller.setVertical(v);}return this;};
c.prototype.setHorizontalScrolling=function(v){this._bHScrollingEnabled=v;var o=this.getHorizontalScrolling();if(o===v){return this;}this.$().toggleClass("sapMPopoverHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v,true);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};
c.prototype.setResizable=function(v){if(!sap.ui.Device.system.desktop){v=false;}this.setProperty("resizable",v,true);};
c.prototype.getScrollDelegate=function(){return this._oScroller;};
c.prototype.setAggregation=function(A,o,s){if(A==="beginButton"||A==="endButton"){var f="set"+A.charAt(0).toUpperCase()+A.slice(1);return this[f](o);}else{return C.prototype.setAggregation.apply(this,arguments);}};
c.prototype.getAggregation=function(A,d){if(A==="beginButton"||A==="endButton"){var s=this["_"+A];return s||d||null;}else{return C.prototype.getAggregation.apply(this,arguments);}};
c.prototype.destroyAggregation=function(A,s){var o=q(document.activeElement).control(0);if(A==="beginButton"||A==="endButton"){var d=this["_"+A];if(d){d.destroy();this["_"+A]=null;}}else{C.prototype.destroyAggregation.apply(this,arguments);}o&&o.getDomRef()?o.focus():this.focus();return this;};
c.prototype.invalidate=function(o){if(this.isOpen()){C.prototype.invalidate.apply(this,arguments);}return this;};
c.prototype.addAggregation=function(A,o,s){if(A==="content"){this._bContentChanged=true;}C.prototype.addAggregation.apply(this,arguments);};
c.prototype._getAllContent=function(){return this.getContent();};
return c;},true);
sap.ui.predefine('sap/m/PopoverRenderer',['jquery.sap.global'],function(q){"use strict";var P={};
P.render=function(r,c){var C;r.write("<div");r.writeControlData(c);C=this.generateRootClasses(c);C.forEach(function(s,i){r.addClass(s);});r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.writeAttribute("tabindex","-1");r.writeAccessibilityState(c,{role:"dialog"});if(c.getShowHeader()&&c._getAnyHeader()){r.writeAccessibilityState(c,{labelledby:c._getAnyHeader().getId()});}r.write(">");if(c.getResizable()){r.write('<div class="sapMPopoverResizeHandle"></div>');}this.renderContent(r,c);r.write("</div>");};
P.isButtonFooter=function(f){if(f instanceof sap.m.Bar){var c=f.getContentLeft(),C=f.getContentRight(),a=f.getContentMiddle(),l=(!c||c.length===0),r=(!C||C.length===0),m=false;if(a&&a.length===2){if((a[0]instanceof sap.m.Button)&&(a[1]instanceof sap.m.Button)){m=true;}}return l&&r&&m;}else{return false;}};
P.renderContent=function(r,c){var h,I=c.getId(),i=0,a=c._getAllContent(),f=c.getFooter(),s=c.getSubHeader(),C=c.getContentWidth(),b=c.getContentMinWidth(),d=c.getContentHeight(),F="sapMPopoverFooter ";if(c.getShowHeader()){h=c._getAnyHeader();}if(sap.ui.Device.system.desktop){r.write("<span class='sapMPopoverHiddenFocusable' id='"+c.getId()+"-firstfe' tabindex='0'></span>");}if(h){if(h.applyTagAndContextClassFor){h.applyTagAndContextClassFor("header");}h.addStyleClass("sapMPopoverHeader");r.renderControl(h);}if(s){if(s.applyTagAndContextClassFor){s.applyTagAndContextClassFor("subheader");}s.addStyleClass("sapMPopoverSubHeader");r.renderControl(s);}r.write("<div");r.writeAttribute("id",I+"-cont");if(C){r.addStyle("width",C);}if(b){r.addStyle("min-width",b);}if(d){r.addStyle("height",d);}r.writeStyles();r.addClass("sapMPopoverCont");r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","application");}r.write(">");r.write('<div class="sapMPopoverScroll"');r.writeAttribute("id",c.getId()+"-scroll");if(!c.getHorizontalScrolling()){r.addStyle(sap.ui.getCore().getConfiguration().getRTL()?"margin-left":"margin-right",q.sap.scrollbarSize().width+"px");}r.writeStyles();r.write(">");for(i=0;i<a.length;i++){r.renderControl(a[i]);}r.write("</div>");r.write("</div>");if(f){if(f.applyTagAndContextClassFor){f.applyTagAndContextClassFor("footer");f.addStyleClass("sapMTBNoBorders");}if(this.isButtonFooter(f)){F+="sapMPopoverSpecialFooter";}r.renderControl(f.addStyleClass(F));}if(c.getShowArrow()){r.write("<span");r.writeAttribute("id",I+"-arrow");r.addClass("sapMPopoverArr");r.writeClasses();r.write("></span>");}if(sap.ui.Device.system.desktop){r.write("<span class='sapMPopoverHiddenFocusable' id='"+c.getId()+"-lastfe' tabindex='0'></span>");}};
P.generateRootClasses=function(c){var C=["sapMPopover"],s=c.getSubHeader(),f=c.getFooter(),v=c.getVerticalScrolling()&&!c._forceDisableScrolling,h=c.getHorizontalScrolling()&&!c._forceDisableScrolling,H;if(c.getShowHeader()){H=c._getAnyHeader();}if(H){C.push("sapMPopoverWithBar");}else{C.push("sapMPopoverWithoutBar");}if(s){C.push("sapMPopoverWithSubHeader");}else{C.push("sapMPopoverWithoutSubHeader");}if(c._hasSingleNavContent()){C.push("sapMPopoverNav");}if(c._hasSinglePageContent()){C.push("sapMPopoverPage");}if(f){C.push("sapMPopoverWithFooter");}else{C.push("sapMPopoverWithoutFooter");}if(c.getPlacement()===sap.m.PlacementType.Top){C.push("sapMPopoverPlacedTop");}if(!v){C.push("sapMPopoverVerScrollDisabled");}if(!h){C.push("sapMPopoverHorScrollDisabled");}C.push("sapMPopup-CTX");if(c._bSizeCompact){C.push("sapUiSizeCompact");}return C.concat(c.aCustomStyleClasses);};
P.rerenderContentOnly=function(c){var p=c.$(),o=c.getDomRef(),C,r;if(!o){return;}p.removeClass();C=this.generateRootClasses(c);p.addClass(C.join(" "));r=sap.ui.getCore().createRenderManager();this.renderContent(r,c);r.flush(o,true);r.destroy();c._onOrientationChange();};
return P;},true);
sap.ui.predefine('sap/m/ProgressIndicator',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport'],function(q,l,C,V){"use strict";
var P=C.extend("sap.m.ProgressIndicator",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},displayValue:{type:"string",group:"Appearance",defaultValue:null},percentValue:{type:"float",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});
P.prototype.onAfterRendering=function(){if(!!this.getHeight()){var a=this.$().height();this.$("textRight").css("line-height",a+"px");this.$("textLeft").css("line-height",a+"px");}};
P.prototype.setPercentValue=function(p){var t=this;if(typeof(p)!=="number"||p<0||p>100){p=0;q.sap.log.warning(this+": percentValue ("+p+") is not correct! Setting the default percentValue:0.");}if(this.getPercentValue()!==p){this.setProperty("percentValue",p,true);this.$().addClass("sapMPIAnimate").attr("aria-valuenow",p).attr("aria-valuetext",this._getAriaValueText({fPercent:p}));var a=Math.abs(t.getPercentValue()-p)*20;var b=this.$("bar");b.animate({width:p+"%"},a,"linear",function(){t._setText.apply(t);t.$().removeClass("sapMPIAnimate");});}return this;};
P.prototype._setText=function(){this.$().toggleClass("sapMPIValueGreaterHalf",this.getPercentValue()>50);return this;};
P.prototype.setDisplayValue=function(d){this.setProperty("displayValue",d,true);var $=this.$("textLeft");var a=this.$("textRight");$.text(d);a.text(d);this.$().attr("aria-valuetext",this._getAriaValueText({sText:d}));return this;};
P.prototype._getAriaValueText=function(p){p.sText=p.sText||this.getDisplayValue();p.fPercent=p.fPercent||this.getPercentValue();p.sStateText=p.sStateText||this._getStateText();var a=p.sText||p.fPercent+"%";if(p.sStateText){a+=" "+p.sStateText;}return a;};
P.prototype._getStateText=function(){return V.getAdditionalText(this.getState());};
P.prototype.getAccessibilityInfo=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"progressbar",type:b.getText("ACC_CTR_TYPE_PROGRESS"),description:b.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]),focusable:this.getEnabled(),enabled:this.getEnabled()};};
return P;},true);
sap.ui.predefine('sap/m/ProgressIndicatorRenderer',['jquery.sap.global'],function(q){"use strict";var P={};
P.render=function(r,c){var w=c.getPercentValue(),W=c.getWidth(),h=c.getHeight(),t=c.getDisplayValue(),s=c.getShowValue(),S=c.getState(),T=c.getTextDirection().toLowerCase(),C=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapMPI");r.addStyle("width",W);if(w>50){r.addClass("sapMPIValueGreaterHalf");}if(h){r.addStyle("height",h);}if(c.getEnabled()){r.writeAttribute('tabIndex','-1');}else{r.addClass("sapMPIBarDisabled");}r.writeClasses();r.writeStyles();r.writeAccessibilityState(c,{role:"progressbar",valuemin:0,valuenow:w,valuemax:100,valuetext:c._getAriaValueText({sText:t,fPercent:w})});if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.write(">");r.write("<div");r.addClass("sapMPIBar");switch(S){case sap.ui.core.ValueState.Warning:r.addClass("sapMPIBarCritical");break;case sap.ui.core.ValueState.Error:r.addClass("sapMPIBarNegative");break;case sap.ui.core.ValueState.Success:r.addClass("sapMPIBarPositive");break;default:r.addClass("sapMPIBarNeutral");break;}r.writeClasses();r.writeAttribute("id",C+"-bar");r.writeAttribute("style","width:"+w+"%");r.write(">");P._renderDisplayText(r,T,"Left",C);if(s){r.writeEscaped(t);}r.write("</span>");r.write("</div>");P._renderDisplayText(r,T,"Right",C);if(s){r.writeEscaped(t);}r.write("</span>");r.write("</div>");};
P._renderDisplayText=function(r,t,T,c){r.write("<span class='sapMPIText sapMPIText"+T+"' id='"+c+"-text"+T+"'");if(t!=="inherit"){r.writeAttribute("dir",t);}r.write('>');};
return P;},true);
sap.ui.predefine('sap/m/PullToRefresh',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters'],function(q,l,C,P){"use strict";
var a=C.extend("sap.m.PullToRefresh",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:null},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}},events:{refresh:{}}}});
a.prototype.init=function(){this._bTouchMode=sap.ui.Device.support.touch&&!sap.ui.Device.system.combi||q.sap.simulateMobileOnDesktop;this._iState=0;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
a.prototype._loadBI=function(){if(this.getVisible()&&!this._oBusyIndicator){q.sap.require("sap.m.BusyIndicator");this._oBusyIndicator=new sap.m.BusyIndicator({size:"1.7rem",design:"auto"});this._oBusyIndicator.setParent(this);}};
a.prototype.onBeforeRendering=function(){this._loadBI();if(this._bTouchMode){q(window).off("resize.sapMP2R",this.calculateTopTrigger);var p=this.getParent();this._oScroller=p&&p.getScrollDelegate?p.getScrollDelegate():null;if(this._oScroller){this._oScroller.setBounce(true);this._oScroller.setPullDown(this.getVisible()?this:null);}}};
a.prototype.calculateTopTrigger=function(){this._iTopTrigger=1;if(this._oDomRef&&this._oDomRef.parentNode&&this._oDomRef.parentNode.parentNode&&this._oDomRef.parentNode.parentNode.offsetHeight<this._oDomRef.offsetHeight*1.5){this._iTopTrigger=this.getDomRef("T").offsetTop;}};
a.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();if(this._bTouchMode){if(this._oScroller){this._oScroller.refresh();}if(this.getVisible()&&this._oScroller&&this._oScroller._bIScroll){q(window).on("resize.sapMP2R",q.proxy(this.calculateTopTrigger,this));this.calculateTopTrigger();}}};
a.prototype.exit=function(){if(this._bTouchMode&&this._oScroller&&this._oScroller._bIScroll){q(window).off("resize.sapMP2R",this.calculateTopTrigger);}if(this._oScroller){this._oScroller.setPullDown(null);this._oScroller=null;}if(this._oCustomImage){this._oCustomImage.destroy();this._oCustomImage=null;}if(this._oBusyIndicator){this._oBusyIndicator.destroy();this._oBusyIndicator=null;}};
a.prototype.doScrollMove=function(){if(!this._oScroller){return;}var d=this._oDomRef;var _=this._oScroller._scroller;if(_.y>-this._iTopTrigger&&this._iState<1){this.setState(1);_.minScrollY=0;}else if(_.y<-this._iTopTrigger&&this._iState==1){this.setState(0);_.minScrollY=-d.offsetHeight;}};
a.prototype.doPull=function(p){if(this._bTouchMode&&this._iState<2){this.setState(p>=-1?1:0);}};
a.prototype.doRefresh=function(){this.setState(0);};
a.prototype.doScrollEnd=function(){if(this._iState==1){this.setState(2);this.fireRefresh();}};
a.prototype.setState=function(s){if(this._iSt