/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','jquery.sap.act','jquery.sap.script'],function(q,B){"use strict";var l=q.sap.log.getLogger("sap.ui.core.ResizeHandler",q.sap.log.Level.ERROR);function a(o,m){var F=sap.ui.require(m);return typeof F==='function'&&(o instanceof F);}var c=null;var R=B.extend("sap.ui.core.ResizeHandler",{constructor:function(C){B.apply(this);c=C;this.aResizeListeners=[];this.bRegistered=false;this.iIdCounter=0;this.fDestroyHandler=q.proxy(this.destroy,this);q(window).bind("unload",this.fDestroyHandler);q.sap.act.attachActivate(i,this);}});function b(){if(this.bRegistered){this.bRegistered=false;sap.ui.getCore().detachIntervalTimer(this.checkSizes,this);}}function i(){if(!this.bRegistered&&this.aResizeListeners.length>0){this.bRegistered=true;sap.ui.getCore().attachIntervalTimer(this.checkSizes,this);}}R.prototype.destroy=function(e){q.sap.act.detachActivate(i,this);q(window).unbind("unload",this.fDestroyHandler);c=null;this.aResizeListeners=[];b.apply(this);};R.prototype.attachListener=function(r,h){var I=a(r,'sap/ui/core/Control'),d=I?r.getDomRef():r,w=d?d.offsetWidth:0,H=d?d.offsetHeight:0,s="rs-"+new Date().valueOf()+"-"+this.iIdCounter++,e;if(I){e=("Control "+r.getId());}else if(r.id){e=r.id;}else{e=String(r);}this.aResizeListeners.push({sId:s,oDomRef:I?null:r,oControl:I?r:null,fHandler:h,iWidth:w,iHeight:H,dbg:e});l.debug("registered "+e);i.apply(this);return s;};R.prototype.detachListener=function(I){var t=this;q.each(this.aResizeListeners,function(d,r){if(r.sId==I){t.aResizeListeners.splice(d,1);l.debug("deregistered "+I);return false;}});if(this.aResizeListeners.length==0){b.apply(this);}};R.prototype.checkSizes=function(){var d=l.isLoggable();if(d){l.debug("checkSizes:");}q.each(this.aResizeListeners,function(e,r){if(r){var C=!!r.oControl,D=C?r.oControl.getDomRef():r.oDomRef;if(D&&q.contains(document.documentElement,D)){var o=r.iWidth,O=r.iHeight,n=D.offsetWidth,N=D.offsetHeight;if(o!=n||O!=N){r.iWidth=n;r.iHeight=N;var E=q.Event("resize");E.target=D;E.currentTarget=D;E.size={width:n,height:N};E.oldSize={width:o,height:O};E.control=C?r.oControl:null;if(d){l.debug("resize detected for '"+r.dbg+"': "+E.oldSize.width+"x"+E.oldSize.height+" -> "+E.size.width+"x"+E.size.height);}r.fHandler(E);}}}});if(R._keepActive!=true&&R._keepActive!=false){R._keepActive=false;}if(!q.sap.act.isActive()&&!R._keepActive){b.apply(this);}};R.register=function(r,h){if(!c||!c.oResizeHandler){return null;}return c.oResizeHandler.attachListener(r,h);};R.deregister=function(I){if(!c||!c.oResizeHandler){return;}c.oResizeHandler.detachListener(I);};R.deregisterAllForControl=function(C){if(!c||!c.oResizeHandler){return;}var I=[];q.each(c.oResizeHandler.aResizeListeners,function(d,r){if(r&&r.oControl&&r.oControl.getId()===C){I.push(r.sId);}});q.each(I,function(d,s){R.deregister(s);});};return R;});
