/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./Control','./library','jquery.sap.script','jquery.sap.trace'],function(q,D,C,l){"use strict";var S=l.ScrollBarAction;var a=C.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}}});a.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(q.sap.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};a.prototype.onBeforeRendering=function(){this.$("sb").unbind("scroll",this.onscroll);};a.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var c=this.getContentSize();this._bStepMode=!c;var s=this.getSize();if(q.sap.endsWith(s,"px")){s=s.substr(0,s.length-2);}else{s=this.getVertical()?this.$().height():this.$().width();}var b=null;var $=this.$("ffsize");if(!!D.browser.firefox){b=$.outerHeight();if(b===0){b=window.getComputedStyle(q("body").get(0))["font-size"];if(q.sap.endsWith(b,"px")){b=b.substr(0,b.length-2);}b=parseInt(b,10);}}$.remove();if(!!D.browser.webkit){if(!document.width){b=Math.round(40/(window.outerWidth/q(document).width()));}else{b=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(!!D.browser.firefox){this._iFactor=b;}else if(!!D.browser.webkit){this._iFactor=b;}else{this._iFactor=Math.floor(s*0.125);}this._iFactorPage=!!D.browser.firefox?s-b:Math.floor(s*0.875);}else{if(!!D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(s*0.8);}else if(!!D.browser.webkit){this._iFactor=b;this._iFactorPage=Math.floor(s*0.875);}else{this._iFactor=7;this._iFactorPage=s-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var i=this._iSteps*this._iFactor;if(i>this._iMaxContentDivSize){this._iFactor=this._iFactor/(i/this._iMaxContentDivSize);}var d=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(d);}else{var d=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(d);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.bind("scroll",q.proxy(this.onscroll,this));if(q.sap.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize(),10);this._oTouchScroller.setDimensions(0,0,o.width,o.height);var e=this._$ScrollDomRef.get(0);if(e){var r=e.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+e.clientLeft,r.top+e.clientTop);this._bSkipTouchHandling=false;}}};a.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(q.sap.containsOrEquals(this._$ScrollDomRef[0],e.target)){this._doScroll(S.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};a.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};a.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};a.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};a.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};a.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(!!D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(!!D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var b=S.Drag;if(d==this._iFactor){b=S.Step;}else if(d==this._iFactorPage){b=S.Page;}else if(this._bMouseWheel){b=S.MouseWheel;}if(this._bLargeDataScrolling&&b===S.Drag){this._eAction=b;this._bForward=f;if(D.browser.msie){if(this._scrollTimeout){window.clearTimeout(this._scrollTimeout);}this._scrollTimeout=window.setTimeout(this._onScrollTimeout.bind(this),300);}}else{this._doScroll(b,f);}e.preventDefault();e.stopPropagation();return false;};a.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};a.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)&&!D.browser.msie){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};a.prototype.ontouchend=a.prototype.onmouseup;a.prototype._handleTouchScroll=function(L,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:L;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};a.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.unbind(!!D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.unbind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchcancle"),q.proxy(this.ontouchcancle,this));}}};a.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.bind(!!D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.bind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchcancle"),q.proxy(this.ontouchcancle,this));}}};a.prototype._getTouchEventType=function(t){return q.sap.touchEventMode==="SIM"?("sap"+t):t;};a.prototype.pageUp=function(){this._doScroll(S.Page,false);};a.prototype.pageDown=function(){this._doScroll(S.Page,true);};a.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};a.prototype.setCheckedScrollPosition=function(s,c){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var b=i;if(this._bStepMode){i=Math.min(i,this.getSteps());b=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!c;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(b);}else{if(!!D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-b);}else if(!!D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-b);}else{this._$ScrollDomRef.scrollLeft(b);}}if(q.sap.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};a.prototype.setContentSize=function(c){this.setProperty("contentSize",c);this._bStepMode=false;var s=this.$("sbcnt");if(s){if(this.getVertical()){s.height(c);}else{s.width(c);}}return this;};a.prototype._doScroll=function(e,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(!!D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(!!D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);q.sap.log.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+e+" --- Direction is forward: "+f);this.fireScroll({action:e,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);q.sap.log.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+e+" --- Direction is forward: "+f);this.fireScroll({action:e,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}if(Math.round(this._iFactor)==this._iFactor||!D.browser.msie){this._bSuppressScroll=false;}this._iOldScrollPos=s;this._bMouseWheel=false;q.sap.interaction.notifyScrollEvent({type:e});};a.prototype.onThemeChanged=function(){this.rerender();};a.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};a.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};return a;});
