/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Splitter','./SplitterRenderer'],function(S,a){"use strict";var A=S.extend("sap.ui.layout.AssociativeSplitter",{metadata:{associations:{associatedContentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"associatedContentArea"}}},renderer:a});A.prototype.init=function(){S.prototype.init.call(this);this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",1),decrease:this._onKeyboardResize.bind(this,"dec",1),increaseMore:this._onKeyboardResize.bind(this,"incMore",2),decreaseMore:this._onKeyboardResize.bind(this,"decMore",2),max:this._onKeyboardResize.bind(this,"max",1),min:this._onKeyboardResize.bind(this,"min",1)};this._enableKeyboardListeners();};A.prototype._enableKeyboardListeners=function(){S.prototype._enableKeyboardListeners.call(this);this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapupmodifiers=this._keyListeners.decrease;this.onsapdownmodifiers=this._keyListeners.increase;this.onsapright=this._keyListeners.increaseMore;this.onsapdown=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapup=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};A.prototype.addAssociatedContentArea=function(c){this._needsInvalidation=true;_(c);return this.addAssociation("associatedContentAreas",c);};A.prototype.indexOfAssociatedContentArea=function(c){var d=this._getContentAreas();for(var i=0;i<d.length;i++){if(c==d[i]){return i;}}return-1;};A.prototype.insertAssociatedContentArea=function(c,I){var d=c.getId();this._needsInvalidation=true;_(c);var e=this.getAssociatedContentAreas();for(var i=0;i<e.length;i++){if(e[i]==d){e.splice(i,1);}}e.splice(I,0,d);this.setAssociation("associatedContentAreas",null);var t=this;e.forEach(function(d){t.addAssociation("associatedContentAreas",d);});};A.prototype.removeAssociatedContentArea=function(c){this.removeAssociation("associatedContentAreas",c);};A.prototype._getContentAreas=function(){var c=this.getAssociatedContentAreas()||[];var C=this.getContentAreas();var v=c.map(function(i){return sap.ui.getCore().byId(i);}).filter(function(o){return o;});return C.concat(v);};A.prototype.ondblclick=function(e){var i=this.getId();if(!this._oLastDOMclicked||this._oLastDOMclicked.id.indexOf(i+"-splitbar")!=0){return;}var B=parseInt(this._oLastDOMclicked.id.substr((i+"-splitbar-").length),10);var c=this._getContentAreas()[B];if(c._sOldLayoutData&&c._sOldLayoutData!=="0px"){c.setLayoutData(new sap.ui.layout.SplitterLayoutData({size:c._sOldLayoutData}));c._sOldLayoutData=undefined;}else{c._sOldLayoutData=c.getLayoutData().getSize();c.setLayoutData(new sap.ui.layout.SplitterLayoutData({size:"0px"}));}this._ensureAllSplittersCollapsed(B);};A.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}if(jQuery(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);this._oLastDOMclicked=j.target;};A.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}if(jQuery(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};A.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var s=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var c=parseInt(j.target.parentElement.id.substr((I+"-splitbar-").length),10);var B=(s+1)?s:c;var $=jQuery(j.target);var C=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this._getContentAreas();var l=e[B].getLayoutData();var L=e[B+1].getLayoutData();if(!l.getResizable()||!L.getResizable()){b(t);return;}var r=0-d;for(var i=0;i<=B;++i){r+=C[i]+d;}this._move={start:p,relStart:r,barNum:B,bar:jQuery(j.target),c1Size:C[B],c1MinSize:l?parseInt(l.getMinSize(),10):0,c2Size:C[B+1],c2MinSize:L?parseInt(L.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};A.prototype._ensureAllSplittersCollapsed=function(B){var c=this._getContentAreas();var d=false;for(var i=0;i<c.length;i++){var s=c[i].getLayoutData().getSize().slice(0,-2);if(s=="0"||s=="au"){d=true;continue;}else if(i===(c.length-1)&&d){this._getContentAreas()[B+1].setLayoutData(new sap.ui.layout.SplitterLayoutData({size:"100%"}));}}};function _(c){var l=c.getLayoutData();if(l&&(!l.getResizable||!l.getSize||!l.getMinSize)){jQuery.sap.log.warning("Content \""+c.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");l=null;}if(!l){c.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}function b(t){var p=function(e){e.preventDefault();};var f=null;f=function(){document.removeEventListener("touchend",f);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",f);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",f);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",f);document.addEventListener("mousemove",p);}}return A;},false);
