/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","./ResponsiveSplitterUtilities","./ResponsiveSplitterPage","./PaneContainer","./SplitPane","sap/ui/core/delegate/ItemNavigation"],function(q,l,C,R,c,P,S,I){"use strict";var d=C.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}}});var e={MAX_VISIBLE_BUTTONS:7};d.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");this.addEventDelegate({onAfterRendering:function(){this._initItemNavigation();}},this);};d.prototype.onBeforeRendering=function(){var r=this.getRootPaneContainer();if(r){r._oSplitter.addEventDelegate({onAfterRendering:function(){this._setSplitterBarsTooltips(r._oSplitter);this._updatePaginatorButtonsTooltips();}},this);this._createWidthIntervals();this._createPages();this._detachResizeHandler();}};d.prototype.onAfterRendering=function(){this._parentResizeHandler=sap.ui.core.ResizeHandler.register(this,this._onParentResize.bind(this));var r=this.getRootPaneContainer();if(r){this._onParentResize();}};d.prototype.exit=function(){this._detachResizeHandler();};d.prototype._setSplitterBarsTooltips=function(o,p){var s=o.$().find(" > .sapUiLoSplitterBar"),a=o.$().find(" > .sapUiLoSplitterContent"),b=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE")+" ",t=b,f,n,A,g;for(var i=0;i<a.length;i++){g=a[i].childNodes[0].id;A=sap.ui.getCore().byId(g);f=i+1;n=i+2;if(p){t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_PANES",[p+"."+f,p+"."+n]);}else{t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_PANES",[f,n]);}if(s[i]){s[i].setAttribute("title",t);t=b;}if(A instanceof sap.ui.layout.Splitter){this._setSplitterBarsTooltips(A,f);}}};d.prototype._updatePaginatorButtonsTooltips=function(){var v=Array.prototype.slice.call(this._getVisibleButtons()),h=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,H=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",a=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),t="",b=this,o;if(v.length>0){o=v.shift();for(var i=1;i<=h;i++){H+=i;if(i<(h-1)){H+=", ";}else if(i===h-1){H+=" "+a+" ";}}o.setAttribute("title",H);[].forEach.call(v,function(B){t=b._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(h+1);h+=1;B.setAttribute("title",t);});}};d.prototype._handlePaginatorButtonTap=function(E){var o=this._oItemNavigation.getFocusedIndex();if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButton")){q(E.target).attr("tabindex",0);var p=parseInt(q(E.target).attr("page-index"),10);this.getAggregation("_pages").forEach(function(a){a.setVisible(false);});if(p!==0){var D=this._currentInterval.aPages.filter(function(a){return a.demandPane;});p=this._currentInterval.aPages.indexOf(D[p-1]);}this._activatePage(p,parseInt(q(E.target).attr("page-index"),10));}if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorNavButton")){if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}this._setItemNavigation();this._oItemNavigation.focusItem(o);}this._setItemNavigation();};d.prototype.ontap=d.prototype._handlePaginatorButtonTap;d.prototype.onsapenter=d.prototype._handlePaginatorButtonTap;d.prototype.onsapspace=d.prototype._handlePaginatorButtonTap;d.prototype.onsapright=function(E){this._handleArrowNavigation(6,"Forward",E);};d.prototype.onsapleft=function(E){this._handleArrowNavigation(0,"Back",E);};d.prototype._initItemNavigation=function(){if(this._oItemNavigation){this._bPrevItemNavigation=true;this._clearItemNavigation();}this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();if(this._bPrevItemNavigation){this._oItemNavigation.focusItem(0);}};d.prototype._setItemNavigation=function(){var b=this._getVisibleButtons(),D=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<b.length;i++){if(b[i]){D.push(b[i]);}}this._oItemNavigation.setItemDomRefs(D);};d.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;};d.prototype._handleArrowNavigation=function(b,D,E){if(E.target===this._getVisibleButtons()[b]){this["_handlePaginator"+D](E);this._setItemNavigation();}else{return;}};d.prototype._onParentResize=function(){var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}};d.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){sap.ui.core.ResizeHandler.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};d.prototype._createWidthIntervals=function(){var B=[];this._aIntervals=[];R.visitPanes(this.getRootPaneContainer(),function(p){var r=p.getRequiredParentWidth();if(q.inArray(r,B)==-1){B.push(r);}});B.push(Number.NEGATIVE_INFINITY);B.push(Number.POSITIVE_INFINITY);B.sort(function(a,b){return a-b;});for(var i=0;i<B.length-1;i++){var o=new R.splitterInterval(B[i],B[i+1],this.getRootPaneContainer());this._aIntervals.push(o);}};d.prototype._createPages=function(){var m=this._getMaxPageCount();this.destroyAggregation("_pages",true);for(var i=0;i<m;i++){var p=new c();this.addAggregation("_pages",p,true);}};d.prototype._intervalHasChanged=function(){var w=this.getDomRef().clientWidth,o=null,a=this._aIntervals;for(var i=0;i<a.length;i++){if(a[i].iFrom<w&&w<=a[i].iTo){o=a[i];break;}}if(this._currentInterval!==o){this._currentInterval=o;return true;}return false;};d.prototype._setPaginatorVisibility=function(){var b=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),n=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),p=this.$().find(".sapUiResponsiveSplitterPaginator"),i=(this._getHiddenPanes().length+1),s=i<e.MAX_VISIBLE_BUTTONS;b.addClass("sapUiResponsiveSplitterHiddenElement");if(i>1){this.getDomRef().classList.add("sapUiRSVisiblePaginator");b=b.slice(0,s?i:e.MAX_VISIBLE_BUTTONS);b.removeClass("sapUiResponsiveSplitterHiddenElement");b.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");n.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);p.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s);}else{this.getDomRef().classList.remove("sapUiRSVisiblePaginator");}};d.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(i){if(i.iPagesCount>t){t=i.iPagesCount;}});return t;};d.prototype._arrangeContent=function(){var p=this.getAggregation("_pages")||[];this._clearContent();p.forEach(function(o){o.setVisible(false);});this._fillPageContent(this.getRootPaneContainer());this._activatePage(0);};d.prototype._activatePage=function(p){var $=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),o=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),O=$.index(o),a=this.getAggregation("_pages")||[];a[O]&&a[O].setVisible(false);a[p]&&a[p].setVisible(true);o.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");$.eq(p).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");};d.prototype._fillPageContent=function(s){var b=s instanceof P,a=s instanceof S,o=s.getParent(),f=o instanceof P,p=this.getAggregation("_pages"),h,H,g,D,j,m;if(b&&p){this._aPaneContainers.push(s);H=this._getAllPanesInInterval(s,this._currentInterval.iFrom).length>0;g=s._oSplitter;if(f&&H){o._oSplitter.addAssociatedContentArea(g);}else if(!f){p[0].setContent(g);}s.getPanes().forEach(function(k){this._fillPageContent(k);},this);}else if(a&&p){this._assignDefault(s);this._aPanes.push(s);D=s.getDemandPane();h=this._getHiddenPanes();j=h.length;m=this._getMaxPageCount();if(s._isInInterval(this._currentInterval.iFrom)){o._oSplitter.addAssociatedContentArea(s.getContent());}else if(D&&(j<m)){for(var i=0;i<j;i++){p[i+1].setContent(h[i].getContent());}}else if(D&&j===m){for(var i=0;i<j;i++){p[i].setContent(h[i].getContent());}}else if(this._isDefault(s)){p[0].setContent(s.getContent());}}};d.prototype._isDefault=function(p){return this.getDefaultPane()===p.getId();};d.prototype._assignDefault=function(p){var D=this.getDefaultPane();this.setDefaultPane(D||p);};d.prototype._getAllPanesInInterval=function(p,f){var a=[];function v(p){p.getPanes().forEach(function(o){if(o instanceof P){v(o);}else if(o._isInInterval(f)){a.push(o);}});return a;}return v(p,f);};d.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(p){return p.getDemandPane()&&!p._isInInterval(this._currentInterval.iFrom);},this);};d.prototype._clearContent=function(){this._aPaneContainers.forEach(function(p){p._oSplitter.removeAllAssociatedContentArea();});this._aPaneContainers=[];this._aPanes=[];};d.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)");};d.prototype._handlePaginatorButtonTap=function(E){var t=E.target,T=E.target.classList,p;if(T.contains("sapUiResponsiveSplitterPaginatorButton")){p=t.getAttribute("page-index");this._activatePage(p);}else if(T.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(T.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}}};d.prototype._handlePaginatorForward=function(E){var v=this._getVisibleButtons(),h=this._getHiddenPanes().length,H=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),$=H.filter(function(){return this.getAttribute("page-index")>=e.MAX_VISIBLE_BUTTONS&&this.getAttribute("page-index")<=h;});if($.length>0){v.first().addClass("sapUiResponsiveSplitterHiddenElement");$.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};d.prototype._handlePaginatorBack=function(E){var v=this._getVisibleButtons(),m=this._getMaxPageCount()-e.MAX_VISIBLE_BUTTONS,h=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),H=h.filter(function(){return this.getAttribute("page-index")<m;});if(H.length>0){v.last().addClass("sapUiResponsiveSplitterHiddenElement");H.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};d.prototype.ontap=d.prototype._handlePaginatorButtonTap;d.prototype.onsapenter=d.prototype._handlePaginatorButtonTap;d.prototype.onsapspace=d.prototype._handlePaginatorButtonTap;return d;},true);
