/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Model","sap/ui/thirdparty/URI","./_ODataHelper","./lib/_MetadataRequestor","./lib/_Requestor","./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding"],function(q,M,B,a,U,_,b,c,O,d,e,f){"use strict";var C="sap.ui.model.odata.v4.ODataModel",s={messageChange:true},S={groupId:true,serviceUrl:true,synchronizationMode:true,updateGroupId:true};var g=a.extend(C,{constructor:function(p){var h={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},P,i,u;a.apply(this);if(!p||p.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}for(P in p){if(!(P in S)){throw new Error("Unsupported parameter: "+P);}}i=p.serviceUrl;if(!i){throw new Error("Missing service root URL");}u=new U(i);if(u.path()[u.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}this._sQuery=u.search();this.mUriParameters=_.buildQueryOptions(null,u.query(true),null,true);this.sServiceUrl=u.query("").toString();this.sGroupId=p.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}_.checkGroupId(p.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=p.updateGroupId||this.getGroupId();this.oMetaModel=new e(b.create(h,this.mUriParameters),this.sServiceUrl+"$metadata");this.oRequestor=c.create(this.sServiceUrl,h,this.mUriParameters);this.mCallbacksByGroupId={};this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});g.prototype._submitBatch=function(G){var h=this.mCallbacksByGroupId[G],p;p=this.oRequestor.submitBatch(G)["catch"](function(E){q.sap.log.error("$batch failed",E.message,C);throw E;});if(h){delete this.mCallbacksByGroupId[G];h.forEach(function(i){i();});}return p;};g.prototype.addedRequestToGroup=function(G,h){var i=this.mCallbacksByGroupId[G];if(G==="$direct"){if(h){h();}return;}if(!i){i=this.mCallbacksByGroupId[G]=[];if(G==="$auto"){sap.ui.getCore().addPrerenderingTask(this._submitBatch.bind(this,G));}}if(h){i.push(h);}};g.prototype.attachEvent=function(E){if(!(E in s)){throw new Error("Unsupported event '"+E+"': v4.ODataModel#attachEvent");}return a.prototype.attachEvent.apply(this,arguments);};g.prototype.bindContext=function(p,o,P){return new O(this,p,o,P);};g.prototype.bindList=function(p,o,h,F,P){if(F){throw new Error("Unsupported operation: v4.ODataModel#bindList, "+"aFilters parameter must not be set");}if(h){throw new Error("Unsupported operation: v4.ODataModel#bindList, "+"aSorters parameter must not be set");}return new d(this,p,o,P);};g.prototype.bindProperty=function(p,o,P){return new f(this,p,o,P);};g.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};g.prototype.createBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#createBindingContext");};g.prototype.destroy=function(){this.oMetaModel.destroy();return a.prototype.destroy.apply(this,arguments);};g.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};g.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};g.prototype.getGroupId=function(){return this.sGroupId;};g.prototype.getMetaModel=function(){return this.oMetaModel;};g.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};g.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};g.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};g.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};g.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};g.prototype.refresh=function(G){_.checkGroupId(G);this.aBindings.slice().forEach(function(o){if(o.oCache){o.refresh(G);}});};g.prototype.reportError=function(l,r,E){var D=E.stack||E.message;if(D.indexOf(E.message)<0){D=E.message+"\n"+E.stack;}q.sap.log.error(l,D,r);if(E.$reported){return;}E.$reported=true;sap.ui.getCore().getMessageManager().addMessages(new M({message:E.message,processor:this,technical:true,type:"Error"}));};g.prototype.requestCanonicalPath=function(E){return this.oMetaModel.requestCanonicalUrl("/",E.getPath(),E);};g.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};g.prototype.submitBatch=function(G){_.checkGroupId(G,true);return this._submitBatch(G);};g.prototype.toString=function(){return C+": "+this.sServiceUrl;};return g;},true);
