/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time'],function(q,C,l,E,B,D,F,I,T){"use strict";var A;var a=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});a.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bSkipUpdateAI=false;};a._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new Boolean()};function i(c){if(!A){A=sap.ui.require("sap/ui/table/AnalyticalTable");}return A&&(c instanceof A);}a.prototype._createMenu=function(){var b=sap.ui.requireSync("sap/ui/table/AnalyticalColumnMenu");return new b(this.getId()+"-menu");};a.prototype.setGrouped=function(g,s){var p=this.getParent();var t=this;if(p&&i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._aGroupedColumns=q.grep(p._aGroupedColumns,function(v){return v!=t.getId();});}}var r=this.setProperty("grouped",g,s);this._updateColumns(true);return r;};a.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};a.prototype.setVisible=function(v,s){this.setProperty("visible",v,s);this._updateColumns();return this;};a.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(p&&i(p)){var b=p.getBinding("rows");if(b){this._oBindingLabel=l.TableHelper.createLabel();var m=b.getModel();if(m.oMetadata&&m.oMetadata.isLoaded()){this._oBindingLabel.setText(b.getPropertyLabel(this.getLeadingProperty()));}else{var t=this;m.attachMetadataLoaded(function(){t._oBindingLabel.setText(b.getPropertyLabel(t.getLeadingProperty()));});}}}}L=this._oBindingLabel;}return L;};a.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(P&&i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getFilterablePropertyNames())>-1){p=L;}}}return p;};a.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(P&&i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getSortablePropertyNames())>-1){p=L;}}}return p;};a.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(p&&i(p)){var b=p.getBinding("rows");var L=this.getLeadingProperty(),P=b&&b.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=a._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=a._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=a._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=a._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=a._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};a.prototype._afterSort=function(){this._updateTableAnalyticalInfo();};a.prototype._updateColumns=function(s,f){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(!A){A=sap.ui.require("sap/ui/table/AnalyticalTable");}if(p&&A&&p instanceof A){p._updateColumns(s,f);}};a.prototype._updateTableAnalyticalInfo=function(s){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};a.prototype._updateTableColumnDetails=function(){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};a.prototype.shouldRender=function(){if(!this.getVisible()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};a.prototype.getTooltip_AsString=function(){var p=this.getParent();if(p&&i(p)){var b=p.getBinding("rows");if(b&&this.getLeadingProperty()){return b.getPropertyQuickInfo(this.getLeadingProperty());}}return E.prototype.getTooltip_AsString.apply(this);};a.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var b=t.getBinding("rows");var r=b&&b.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};a.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(p&&i(p)){var b=p.getBinding("rows");if(b){if(q.inArray(f,b.getFilterablePropertyNames())>-1&&!b.isMeasure(f)&&b.getProperty(f)){return true;}}}return false;};a.prototype.isGroupableByMenu=function(){var p=this.getParent();if(p&&i(p)){var b=p.getBinding("rows");if(b){var r=b.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&q.inArray(this.getLeadingProperty(),b.getSortablePropertyNames())>-1&&q.inArray(this.getLeadingProperty(),b.getFilterablePropertyNames())>-1){return true;}}}return false;};return a;});
