/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','./TableExtension','./TableAccRenderExtension','./TableUtils'],function(q,C,l,T,a,b){"use strict";var S=l.SelectionBehavior,c=l.SelectionMode;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));for(var i=0;i<s.children.length;i++){if(s.children[i]){A._flatten(s.children[i],t,B,L+1);}}if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var D=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){D=D+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){D=D+" "+B.getText("TBL_CTRL_STATE_READONLY");}return D.trim();}};var E={getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return b.getCellInfo(f);},isHiddenCell:function($){return $.parent().hasClass("sapUiTableRowHidden")||$.hasClass("sapUiTableCellHidden")||(b.isInGroupingRow($)&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell"));},isTreeColumnCell:function(e,$){return e._hasTreeColumn&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false;if(i){var h=b.getColumnIndexOfFocusedCell(t)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var j=b.getVisibleColumnCount(t);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==h);f=e._iLastColumnNumber!=h;g=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(f?t._oResBundle.getText("TBL_COL_COLCOUNT",[h,j]):" ");t.$("ariacount").text(g?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,j]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=h;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,D,f){e._cleanupInfo={cell:$,attr:{"aria-labelledby":D&&D.length?D.join(" "):null,"aria-describedby":f&&f.length?f.join(" "):null}};},performCellModifications:function(e,$,D,f,L,g,t,h){E.storeDefaultsBeforeCellModifications(e,$,D,f);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(h){h(L,g,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var i=e.getTable();s=i.getAriaLabelledBy().join(" ")+" "+i.getId()+"-ariadesc "+i.getId()+"-ariacount";}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":g&&g.length?g.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),e=b.getColumnIndexOfFocusedCell(t),f=b.getRowColCell(t,r,e),I=null,h=E.isHiddenCell($),g=E.isTreeColumnCell(this,$),D=E.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:f.column,fixed:b.isFixedColumn(t,e)})["aria-labelledby"]||[],j=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(b.isInGroupingRow($)){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(b.isInSumRow($)){var k=$.parent().data("sap-ui-level");if(k==0){L.push(s+"-ariagrandtotallabel");}else if(k>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}L=L.concat(D);if(!h){I=A.getAccInfoOfControl(f.cell,t._oResBundle);L.push(I?(s+"-cellacc"):f.cell.getId());if(((!I||I.focusable)&&!this._readonly)||g){j.push(s+"-toggleedit");}}var m=I?I.description:" ";if(g&&!h){var n=E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:f.row});if(n&&n["aria-label"]){m=n["aria-label"]+" "+m;}}E.performCellModifications(this,$,D,null,L,j,m,function(L,j,R,p,u){if(!h&&t._getSelectOnCellsAllowed()&&R){j.push(f.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),g=b.isInGroupingRow($),e=b.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],D=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=D.concat([s+"-rownumberofrows"]);if(!e&&!g){if($.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");}}if(g){L.push(s+"-ariarowgrouplabel");}if(e){var i=$.data("sap-ui-level");if(i==0){L.push(s+"-ariagrandtotallabel");}else if(i>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,D,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),e=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:e,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(e),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);if(s){L.push(t.getId()+"-cellacc");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:$.hasClass("sapUiTableSelAllEnabled")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,u,O,v){var w="";if(O&&v){w="overlay,nodata";}else if(O&&!v){w="overlay";}else if(!O&&v){w="nodata";}var x=false;if(O&&o.getShowOverlay()||v&&b.isNoDataVisible(o)){x=true;}if(x){m["aria-hidden"]="true";}if(w){m["data-sap-ui-table-acc-covered"]=w;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];m["role"]=["columnheader"];if(p&&p.enabled){m["aria-labelledby"].push(s+"-ariaselectall");}break;case d.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!e._treeMode){m["role"]=["rowheader"];}if(o.getSelectionMode()!==c.None){var g=p&&p.rowSelected;m["aria-selected"]=""+g;var h=e.getAriaTextsForSelectionMode(true);m["title"]=h.mouse[g?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.COLUMNHEADER:var j=p&&p.column;var I=j&&j.getId()===p.headerId;m["role"]="columnheader";m["aria-labelledby"]=p&&p.headerId?[p.headerId]:[];if(j&&j._menuHasItems()){m["aria-haspopup"]="true";m["aria-describedby"]=[s+"-ariacolmenu"];}if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(I&&j.getSorted()){m["aria-sort"]=j.getSortOrder()==="Ascending"?"ascending":"descending";m["aria-labelledby"].push(s+(j.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(I&&j.getFiltered()){m["aria-labelledby"].push(s+"-ariacolfiltered");}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";if(p&&typeof p.index==="number"){m["headers"]=s+"_col"+p.index;}var L=[],j=p&&p.column?p.column:null;if(j){var M=j.getMultiLabels();var k=M.length;if(o.getColumnHeaderVisible()){var n=j.getId();L.push(n);if(k>1){for(var i=1;i<k;i++){L.push(n+"_"+i);}}}else{var r;if(k==0){r=j.getLabel();if(r){L.push(r.getId());}}else{for(var i=0;i<k;i++){r=M[i];if(r){L.push(r.getId());}}}}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(e._hasTreeColumn&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTENT:m["role"]=e._treeMode?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===c.Multi||o.getSelectionMode()===c.MultiToggle){m["aria-multiselectable"]="true";}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:if(o.getSelectionMode()===c.None||o.getSelectionBehavior()===S.RowOnly){m["role"]="row";}f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:var H=o.getFixedColumnCount()>0;m["role"]=H?"columnheader":"presentation";m["scope"]="col";if(H){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case d.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==c.None){var g=p&&p.rowSelected;m["aria-selected"]=""+g;}break;case d.ELEMENTTYPES.TR:m["role"]="row";var g=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==c.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";g=true;}if(o._getSelectOnCellsAllowed()){var h=e.getAriaTextsForSelectionMode(true);m["title"]=h.mouse[g?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.TREEICON:if(e._hasTreeColumn){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){m["title"]=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;}return m;}};var d=T.extend("sap.ui.table.TableAccExtension",{_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=false;this._treeMode=false;this._hasTreeColumn=false;switch(s){case T.TABLETYPES.ANALYTICAL:this._readonly=true;this._treeMode=true;break;case T.TABLETYPES.TREE:this._treeMode=true;this._hasTreeColumn=true;break;}t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;this._treeMode=false;this._hasTreeColumn=false;T.prototype.destroy.apply(this,arguments);},_getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},onfocusin:function(e){var t=this.getTable();if(!t||!b.getCellInfo(e.target)){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}});d.ELEMENTTYPES={DATACELL:b.CELLTYPES.DATACELL,COLUMNHEADER:b.CELLTYPES.COLUMNHEADER,ROWHEADER:b.CELLTYPES.ROWHEADER,COLUMNROWHEADER:b.CELLTYPES.COLUMNROWHEADER,ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",NODATA:"NODATA",OVERLAY:"OVERLAY"};d.prototype.getAccMode=function(){return this._accMode;};d.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(t._mTimeouts._cleanupACCFocusRefresh){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCFocusRefresh);t._mTimeouts._cleanupACCFocusRefresh=null;}if(o){E.cleanupCellModifications(this);}var i=E.getInfoOfFocusedCell(this);if(!i||!i.cell||!i.type||!E["modifyAccOf"+i.type]){return;}if(!o){if(i.type===b.CELLTYPES.DATACELL||b.CELLTYPES.ROWHEADER){t._mTimeouts._cleanupACCFocusRefresh=q.sap.delayedCall(100,this,function($){var t=this.getTable();if(!t){return;}var i=E.getInfoOfFocusedCell(this);if(i&&i.cell&&i.type&&i.cell.get(0)&&$.get(0)===i.cell.get(0)){i.cell.blur().focus();}t._mTimeouts._cleanupACCFocusRefresh=null;},[i.cell]);}return;}E["modifyAccOf"+i.type].apply(this,[i.cell,o]);};d.prototype.updateAriaStateOfColumn=function(o,r){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});r=r?r:o.$();r.attr({"aria-sort":m["aria-sort"]||null,"aria-labelledby":m["aria-labelledby"]?m["aria-labelledby"].join(" "):null});};d.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);}};d.prototype.updateAriaForAnalyticalRow=function(r,R,$,f,g,e,L){if(!this._accMode){return;}var t=null,o=this.getTable(),h=[R,R.children(),$,f];if(!g&&$){var I=$.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});t=m["title"]||null;}if($){$.attr({"aria-haspopup":g?"true":null,"title":t});}for(var i=0;i<h.length;i++){if(h[i]){h[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}};d.prototype.updateAriaExpandState=function(r,R,i){if(!this._hasTreeColumn||!this._accMode){return;}var f=R.children("td.sapUiTableTdFirst");var o={"aria-level":null,"aria-expanded":null};var B=this.getTable().mBindingInfos["rows"];if(r.getBindingContext(B&&B.model)){o["aria-level"]=r._iLevel+1;if(!i.hasClass("sapUiTableTreeIconLeaf")){o["aria-expanded"]=""+r._bIsExpanded;}}f.attr(o);i.attr(E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));};d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===c.Single){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===c.Multi){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI_KEY");if(e===true){if(i===1){m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}}else if(s===c.MultiToggle){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};return d;});
