/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./Shell','./library','jquery.sap.script'],function(q,D,C,P,S,l){"use strict";var a=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});a.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){q.sap.delayedCall(50,this,function(){q.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp",false);});}q.sap.delayedCall(this._getAnimDuration(true),this,function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);});};a.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();q.sap.delayedCall(Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0),this,function(){var b=q.sap.byId("sap-ui-blocklayer-popup");if(P.blStack.length==1&&this._getAnimActive()&&b.hasClass("sapUiUfdShellOvrlyBly")){b.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}});q.sap.delayedCall(this._getAnimDuration(false),this,function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();});};a.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};a.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(!!this.getDomRef()){this._headRenderer.render();}return this;};a.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};a.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};a.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};a.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};a.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};a.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-hdr-center",function(r){sap.ui.unified.ShellOverlayRenderer.renderSearch(r,t);});this._contentRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-cntnt",function(r){sap.ui.unified.ShellOverlayRenderer.renderContent(r,t);});};a.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};a.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}q.sap.delayedCall(10,this,function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");});};a.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};a.prototype.onsapspace=a.prototype.onclick;a.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};a.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){q.sap.focus(d);}};a.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(sap.ui.core.theming.Parameters.get(p),10);if(!this._getAnimActive()&&c){v=0;}return v;};a.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("sapUiUfdShellOvrly"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};a.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("sapUiUfdShellOvrlyBlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};a.prototype._getAnimActive=function(){if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){return false;}return true;};a.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){sap.ui.unified._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){sap.ui.unified._iNumberOfOpenedShellOverlays--;});}return this._popup;};a.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};a.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};a.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};a.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};return a;},true);
