/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','./v2/ODataTreeBinding','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils'],function(q,T,O,C,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.mParameters=this.mParameters||{};this._iPageSize=0;this._aNodes=this._aNodes||[];this._aNodeCache=[];this._aCollapsed=this._aCollapsed||[];this._aExpanded=this._aExpanded||[];this._aExpandedAfterSelectAll=this._aExpandedAfterSelectAll||[];this._mSelected=this._mSelected||{};this._bSelectAll=false;this._iCollapsedDelta=0;this._iExpandedDelta=0;this._iLengthDelta=0;this._aRowIndexMap=[];if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._bIsAdapted=true;};d.prototype.setNumberOfExpandedLevels=function(l){this.resetData();O.prototype.setNumberOfExpandedLevels.apply(this,arguments);};d.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}s=s||0;l=l||this.oModel.sizeLimit;t=t||0;this._iPageSize=l;this._iThreshold=t;if(this._aNodes.length==0&&!this.isLengthFinal()){this._loadData(s,l+t);}var R=[];var n=this._retrieveNodeSection(s,l);this._aNodeCache=[];var S;var a=0;var L=0;var g={};for(var i=0;i<n.length;i++){var N=n[i];this._aNodeCache[s+i]=N&&N.context?N:undefined;R.push(N.context);if(!N.context){if(N.serverIndex){if(S==undefined){S=N.serverIndex;}L=N.serverIndex;}else if(N.positionInParent!=undefined){var p=N.parent;g[p.key]=g[p.key]||[];g[p.key].push(N);}}}a=1+Math.max(L-S,0);if(S!=undefined&&a){this._loadData(S,a+t);}for(var m in g){var o=this._calculateRequestParameters(g[m]);this._loadChildren(g[m][0].parent,o.skip,o.top);}if(r){return n;}else{return R;}};d.prototype._calculateRequestParameters=function(m){var p=m[0].parent;var M=m[0].positionInParent;var a=Math.min(M+Math.max(this._iThreshold,m.length),p.children.length);for(var i=M;i<a;i++){var o=p.children[i];if(o){break;}}return{skip:M,top:i-M};};d.prototype._retrieveNodeSection=function(s,l){var n=-1;var N=[];this._map(function(o,r,i,I,p){n++;if(n>=s){if(!o){if(i=="serverIndex"){o={serverIndex:I};}else if(i=="positionInParent"){o={positionInParent:I,parent:p};}}N.push(o);}if(N.length>=l){r.broken=true;}});return N;};d.prototype.getNodes=function(s,l,t){var n=this.getContexts(s,l,t,true);return n;};d.prototype._map=function(m){var r={broken:false};var D=function(N,I,p,P){if(!I){m(N,r,"positionInParent",P,p);}if(r.broken){return;}if(N&&N.children&&N.nodeState.expanded){for(var i=0;i<N.children.length;i++){D(N.children[i],false,N,i);if(r.broken){return;}}}};var n=-1;for(var i=0;i<this._aNodes.length;i++){n++;var N=this._aNodes[i];m(N,r,"serverIndex",i);if(r.broken){return;}if(N&&N.nodeState){if(!N.initiallyCollapsed&&N.nodeState.collapsed){i+=N.magnitude;}else{if(N.initiallyCollapsed&&N.nodeState.expanded){D(N,true);if(r.broken){return;}}}}}};d.prototype._loadData=function(s,t){var r="level <= "+this.getNumberOfExpandedLevels()+"-"+s+"-"+t;if(this.mRequestHandles[r]){return;}function _(D){var e,k,I,i,b=function(n,h){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex<I&&n.serverIndex+n.magnitude>=I){return true;}};delete this.mRequestHandles[r];if(!this._bLengthFinal){var g=D.__count?parseInt(D.__count,10):0;this._aNodes[g-1]=undefined;this._bLengthFinal=true;}if(D.results&&D.results.length>0){for(i=0;i<D.results.length;i++){e=D.results[i];k=this.oModel.getKey(e);I=s+i;var m=e[this.oTreeProperties["hierarchy-node-descendant-count-for"]];if(m<0){m=0;q.sap.log.error("The entry data with key '"+k+"' under binding path '"+this.getPath()+"' has a negative 'hierarchy-node-descendant-count-for' which isn't allowed.");}var n=this._aNodes[I]=this._aNodes[I]||{key:k,context:this.oModel.getContext("/"+k),magnitude:m,level:e[this.oTreeProperties["hierarchy-level-for"]],initiallyCollapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},children:[],serverIndex:I,parent:null};if(this._bSelectAll){if(!this._aExpandedAfterSelectAll.some(b)){this.setNodeSelection(n,true);}}}}this.oModel.callAfterUpdate(function(){this.fireDataReceived({data:D});}.bind(this));this._fireChange({reason:C.Change});}function a(e){delete this.mRequestHandles[r];var A=e.statusCode==0;if(!A){this._aNodes=[];this._bLengthFinal=true;this._fireChange({reason:C.Change});}this.fireDataReceived();}var u=["$skip="+s,"$top="+t];if(!this._bLengthFinal){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}this.fireDataRequested();var l=new sap.ui.model.Filter(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels());var f=[l];if(this.aApplicationFilters){f=f.concat(this.aApplicationFilters);}this.mRequestHandles[r]=this.oModel.read(this.getPath(),{urlParameters:u,filters:[new sap.ui.model.Filter({filters:f,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:a.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});};d.prototype._loadChildren=function(p,s,t){var r=""+p.key+"-"+s+"-"+t;if(this.mRequestHandles[r]){return;}function _(D){delete this.mRequestHandles[r];if(p.childCount==undefined&&D&&D.__count){var b=D.__count?parseInt(D.__count,10):0;p.childCount=b;p.children[b-1]=undefined;var P=p;while(P!=null){P.magnitude+=b;P=P.parent;}this.cleanTreeStateMaps();}if(D.results&&D.results.length>0){for(var i=0;i<D.results.length;i++){var e=D.results[i];var k=this.oModel.getKey(e);var n=p.children[s+i]=p.children[s+i]||{key:k,context:this.oModel.getContext("/"+k),magnitude:0,level:e[this.oTreeProperties["hierarchy-level-for"]]||p.level+1,initiallyCollapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},positionInParent:s+i,children:[],parent:p,isDeepOne:true,containingServerIndex:p.containingServerIndex||p.serverIndex};if(this._bSelectAll&&this._aExpandedAfterSelectAll.indexOf(p)===-1){this.setNodeSelection(n,true);}}}this.oModel.callAfterUpdate(function(){this.fireDataReceived({data:D});}.bind(this));this._fireChange({reason:C.Change});}function a(e){delete this.mRequestHandles[r];var A=e.statusCode==0;if(!A){if(p.childCount==undefined){p.children=[];p.childCount=0;this._fireChange({reason:C.Change});}}this.fireDataReceived();}var u=["$skip="+s,"$top="+t];if(p.childCount==undefined){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}this.fireDataRequested();var l=new sap.ui.model.Filter(this.oTreeProperties["hierarchy-parent-node-for"],"EQ",p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var f=[l];if(this.aApplicationFilters){f=f.concat(this.aApplicationFilters);}this.mRequestHandles[r]=this.oModel.read(this.getPath(),{urlParameters:u,filters:[new sap.ui.model.Filter({filters:f,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:a.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});};d.prototype.findNode=function(r,m){if(this.isInitial()){return;}var n=this._aNodeCache[r];if(n){return n;}var N=-1;for(var i=0;i<this._aNodes.length;i++){N++;n=this._aNodes[i];if(N==r||(m&&m(n))){this._aNodeCache[r]=n;return n;}if(n){if(!n.initiallyCollapsed&&n.nodeState.collapsed){i+=n.magnitude;}else{if(n.initiallyCollapsed&&n.nodeState.expanded){var R={rowIndex:r,nodeIndex:N,match:m};var f=this.findDeepNode(n,R);if(!f){N=R.nodeIndex;}else{this._aNodeCache[r]=f;return f;}}}}}};d.prototype.findDeepNode=function(n,r){if(r.rowIndex==r.nodeIndex){return n;}if(n&&n.children&&n.nodeState.expanded){for(var i=0;i<n.children.length;i++){r.nodeIndex++;var o=n.children[i];if(r.rowIndex==r.nodeIndex||(r.match&&r.match(n))){return o;}var f;if(o&&o.children.length>0){f=this.findDeepNode(o,r);}if(f){return f;}}}};d.prototype.toggleIndex=function(r){var t=this.findNode(r);if(t){if(t.nodeState.expanded){this.collapse(t);}else{this.expand(t);}}};d.prototype.expand=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}t.nodeState.expanded=true;t.nodeState.collapsed=false;var i=this._aCollapsed.indexOf(t);if(i!=-1){this._aCollapsed.splice(i,1);}this._aExpanded.push(t);if(this._bSelectAll){this._aExpandedAfterSelectAll.push(t);}if(t.initiallyCollapsed&&t.childCount==undefined){this._loadChildren(t,0,this._iPageSize);}this.cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Expand});}};d.prototype.expandToLevel=function(l){if(l>this.getNumberOfExpandedLevels()){this.setNumberOfExpandedLevels(l);}};d.prototype.collapse=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}t.nodeState.expanded=false;t.nodeState.collapsed=true;var i=this._aExpanded.indexOf(t);if(i!=-1){this._aExpanded.splice(i,1);}if(this._bSelectAll){i=this._aExpandedAfterSelectAll.indexOf(t);if(i!==-1){this._aExpandedAfterSelectAll.splice(i,1);}}this._aCollapsed.push(t);if(this.bCollapseRecursive){for(var k in this._mSelected){var S=this._mSelected[k];if(this._isInSubtree(t,S)){this.setNodeSelection(S,false);}}}this.cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Collapse});}};d.prototype.collapseToLevel=function(l){if(l<this.getNumberOfExpandedLevels()){if(this.bCollapseRecursive){for(var k in this._mSelected){var s=this._mSelected[k];if(s.level>l){this.setNodeSelection(s,false);}}}this.setNumberOfExpandedLevels(l);}};d.prototype._isInSubtree=function(s,n){if(s.isDeepOne&&!n.isDeepOne){return false;}var p=n;if(n.isDeepOne){do{p=p.parent;if(p===s){return true;}}while(p.parent);}if(!s.isDeepOne&&!s.initiallyCollapsed){return(s.serverIndex<p.serverIndex&&s.serverIndex+s.magnitude>=p.serverIndex);}return false;};d.prototype.cleanTreeStateMaps=function(){var s=function(a,b){var A=a.serverIndex;A=A==undefined?a.containingServerIndex:A;var B=b.serverIndex;B=B==undefined?b.containingServerIndex:B;return A-B;};this._aCollapsed.sort(s);this._aExpanded.sort(s);var m={};this._aCollapsed.forEach(function(n){if(n.serverIndex>=0&&!n.isDeepOne&&!n.initiallyCollapsed){m[n.serverIndex]=n.magnitude;}});var l=0;this._iCollapsedDelta=0;for(var i=0;i<this._aCollapsed.length;i++){var o=this._aCollapsed[i];if(!o.isDeepOne){if(o.serverIndex>=l&&!o.initiallyCollapsed){this._iCollapsedDelta-=o.magnitude;l=o.serverIndex+o.magnitude;}else{}}else{}}this._iExpandedDelta=0;var I=function(n){var f=false;var a=n.serverIndex||n.containingServerIndex;for(var j in m){j=parseInt(j,10);if(a>j&&a<j+m[j]){f=true;break;}}return f;};for(i=0;i<this._aExpanded.length;i++){var e=this._aExpanded[i];if(e.isDeepOne){var p=e.parent;var y=false;while(p){if(p.nodeState.collapsed){y=true;break;}p=p.parent;}var f=I(e);if(!y&&!f){this._iExpandedDelta+=e.children.length;}}else if(e.initiallyCollapsed){var f=I(e);if(!f){this._iExpandedDelta+=e.children.length;}}}this._iLengthDelta=this._iCollapsedDelta+this._iExpandedDelta;};d.prototype.isLengthFinal=function(){return this._bLengthFinal;};d.prototype.getLength=function(){return this._aNodes.length+this._iLengthDelta;};d.prototype.getContextByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n&&n.context;};d.prototype.isExpanded=function(r){var n=this.findNode(r);return n&&n.nodeState.expanded;};d.prototype.hasChildren=function(o){if(!o){return false;}var D=o.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);return D!=="leaf";};d.prototype.nodeHasChildren=function(n){if(n===undefined){return false;}else if(n===null){return true;}else{return this.hasChildren(n.context);}};d.prototype.setNodeSelection=function(n,i){n.nodeState.selected=i;if(i){this._mSelected[n.key]=n;}else{delete this._mSelected[n.key];if(n.key===this._sLeadSelectionKey){this._sLeadSelectionKey=null;}}};d.prototype.isIndexSelected=function(r){var n=this.findNode(r);return n&&n.nodeState?n.nodeState.selected:false;};d.prototype.isIndexSelectable=function(r){var n=this.findNode(r);return!!n;};d.prototype._clearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(var k in this._mSelected){if(k){m++;}}this._map(function(N,r,i,I,p){n++;if(N&&N.nodeState.selected){this.setNodeSelection(N,false);a.push(n);if(this._sLeadSelectionKey==N.key){o=n;}if(a.length==m){r.broken=true;}}}.bind(this));return{rowIndices:a,oldIndex:o,leadIndex:-1};};d.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadKey=n.key;o.leadIndex=r;this.setNodeSelection(n,true);this._publishSelectionChanges(o);}else{q.sap.log.warning("ODataTreeBindingAutoExpand: The selection of index '"+r+"' was ignored. Please make sure to only select rows, for which data has been fetched to the client.");}};d.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionKey||q.isEmptyObject(this._mSelected)){return-1;}var n=-1;this._map(function(N,r){n++;if(N){if(N.key===this._sLeadSelectionKey){r.broken=true;}}}.bind(this));return n;};d.prototype.getSelectedIndices=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var n=-1;this._map(function(N){n++;if(N){if(N.nodeState&&N.nodeState.selected){r.push(n);}}});return r;};d.prototype.getSelectedNodesCount=function(){return Object.keys(this._mSelected).length;};d.prototype.getSelectedContexts=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var m=function(n){if(n){if(n.nodeState.selected&&!n.isArtificial){r.push(n.context);}}};this._map(this._oRootNode,m);return r;};d.prototype.setSelectionInterval=function(f,t){var m=this._clearSelection();var s=this._setSelectionInterval(f,t,true);var I={};var r=[];for(var i=0;i<m.rowIndices.length;i++){var a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadKey:s.leadKey});};d.prototype._setSelectionInterval=function(f,t,s){var n=Math.min(f,t);var N=Math.max(f,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var e=-1;var m=function(g,r,I,h,P){if(!g||!g.isArtificial){e++;}if(g){if(e>=n&&e<=N){if(g){if(g.nodeState.selected!==!!s){b.push(e);}if(g.key===this._sLeadSelectionKey){o=e;}this.setNodeSelection(g,!!s);a.push(g);if(a.length===i){r.broken=true;}}}}}.bind(this);this._map(m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadKey=l.key;p.leadIndex=N;}return p;};d.prototype.addSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,true);this._publishSelectionChanges(p);};d.prototype.removeSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,false);this._publishSelectionChanges(p);};d.prototype.selectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.key===this._sLeadSelectionKey){p.oldIndex=n;}if(N){if(!N.isArtificial&&!N.nodeState.selected){p.rowIndices.push(n);}this.setNodeSelection(N,true);p.leadKey=N.key;p.leadIndex=n;}}}.bind(this));this._publishSelectionChanges(p);};d.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};d.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadKey){this._sLeadSelectionKey=p.leadKey;}else if(p.leadIndex===-1){this._sLeadSelectionKey=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};d.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};d.prototype.resetData=function(){O.prototype.resetData.apply(this,arguments);this._aNodes=[];this._aCollapsed=[];this._aExpanded=[];this._aExpandedAfterSelectAll=[];this._aRowIndexMap=[];this._bLengthFinal=false;this._bSelectAll=false;this._iCollapsedDelta=0;this._iExpandedDelta=0;this._iLengthDelta=0;};d.prototype.attachSelectionChanged=function(D,f,l){this.attachEvent("selectionChanged",D,f,l);return this;};d.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};d.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};d.prototype.getRootContexts=function(){};d.prototype.getNodeContexts=function(){};return d;},true);
