/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,a,c,P,R,S,b,d,e,f,F,g,h,k,m,n,T,o,p,r){"use strict";var G=n.GroupEventType,N=n.NavigationMode,s=n.SelectionBehavior,t=n.SelectionMode,u=n.SharedDomRef,v=n.SortOrder,V=n.VisibleRowCountMode;var w,M,x,y;var z=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:t.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:s.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();z.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this.setNoDataText=function(j){if(!(this.getNoData()instanceof C)){this.setNoData(j);}q.sap.log.error("Function setNoDataText of control sap.ui.table.Table must not be used!");return this;};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;var i=this;this._performUpdateRows=function(j){if(!i.bIsDestroyed){i._lastCalledUpdateRows=Date.now();i._updateBindingContexts(undefined,undefined,j);if(!i._bInvalid){if(i._updateTableContent){i._updateTableContent();}i._getAccExtension().updateAccForCurrentCell(false);i._updateSelection();i._updateGroupHeader();var l=i._collectTableSizes();i._updateRowHeader(l.tableRowHeights);i._syncColumnHeaders(l);if(T.isVariableRowHeightEnabled(i)){i._adjustTablePosition();}if(i._bBindingLengthChanged||T.isVariableRowHeightEnabled(i)){i._updateVSb(l);}}i._mTimeouts.bindingTimer=undefined;i.fireEvent("_rowsUpdated");}i._bBindingLengthChanged=false;};this._initSelectionModel(g.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._oCalcColumnWidths=[];this._aTableHeaders=[];this._iLastHoveredColumnIndex=0;this._aIdxCols2Cells=[];this._aVisibleColumns=[];this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._doubleclickDelay=300;this._clicksRegistered=0;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};z.prototype._attachExtensions=function(){o.enrich(this,r);o.enrich(this,p);};z.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();};z.prototype._detachExtensions=function(){this._getKeyboardExtension().destroy();this._getAccExtension().destroy();};z.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};z.prototype._collectRowHeights=function(){var j=this.getDomRef();if(!j){return[];}var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var A=j.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var B=[];for(var i=0;i<A.length;i++){var H=0;if(l[i]){var J=l[i].getBoundingClientRect();H=J.bottom-J.top;}var K=A[i].getBoundingClientRect();var L=K.bottom-K.top;B.push(Math.max(H,L));}return B;};z.prototype._resetRowHeights=function(){var j=this.getRowHeight();var l="";if(j){l=j+"px";}var A=this.getDomRef();if(A){var B=A.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<B.length;i++){B[i].style.height=l;}}};z.prototype._determineAvailableSpace=function(){var i=this.getDomRef();if(i&&i.parentNode){var j=i.querySelector(".sapUiTableCCnt");if(j){var U=i.scrollHeight-j.clientHeight;return q(i.parentNode).height()-U;}}return 0;};z.prototype._collectTableSizes=function(j){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlRowScrollTop:0,tableCtrlRowScrollHeight:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,columnRowHeight:0,columnRowOuterHeight:0,invisibleColWidth:0};var A=this.getDomRef();if(!A){return l;}var B=A.querySelector(".sapUiTableCnt");if(B){l.tableCntHeight=B.clientHeight;l.tableCntWidth=B.clientWidth;}var H=A.querySelector(".sapUiTableCtrlScroll");if(H){l.tableCtrlScrollWidth=H.clientWidth;}var J=A.querySelector(".sapUiTableRowHdrScr");if(J){l.tableRowHdrScrWidth=J.clientWidth;}var K=A.querySelector(".sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll");if(K){l.tableCtrlRowScrollTop=K.offsetTop;l.tableCtrlRowScrollHeight=K.offsetHeight;}var L=A.querySelector(".sapUiTableCtrlScr");if(L){l.tableCtrlScrWidth=L.clientWidth;}var O=this.getDomRef(u.HorizontalScrollBar);if(O){l.tableHSbScrollLeft=O.scrollLeft;}var Q=A.querySelector(".sapUiTableCtrlFixed");if(Q){l.tableCtrlFixedWidth=Q.clientWidth;}var U=this.getProperty("fixedColumnCount");var W=[];var X=0;var Y=A.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(Y){for(var i=0;i<Y.length;i++){var Z=Y[i].getBoundingClientRect();var $=Z.right-Z.left;W.push($);if(i<U){X+=$;}}}if(U>0){var _=0;var a1=this.getDomRef("sapUiTableRowHdrScr");if(a1){_+=a1.clientWidth;}var b1=this.getDomRef("vsb");if(b1){_+=b1.offsetWidth;}var c1=(A.clientWidth-_<X);if(this._bIgnoreFixedColumnCount!=c1){this._bIgnoreFixedColumnCount=c1;this.invalidate();}}l.headerWidths=W;if(this.getSelectionMode()!==t.None&&this.getSelectionBehavior()!==s.RowOnly){var d1=A.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(d1){l.invisibleColWidth=d1.clientWidth;}}var e1=A.querySelector(".sapUiTableCol");if(e1){l.columnRowHeight=e1.clientHeight;l.columnRowOuterHeight=e1.offsetHeight;}if(!j){l.tableRowHeights=this._collectRowHeights();}else{l.tableRowHeights=j;}return l;};z.prototype._updateRowHeader=function(j){var l=this.getDomRef();if(!l){return;}var A=l.querySelectorAll(".sapUiTableRowHdr");var B=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var H=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(A.length,H.length,0);for(var i=0;i<L;i++){var J=j[i];if(J){if(A[i]){A[i].style.height=J+"px";}if(B[i]){B[i].style.height=J+"px";}if(H[i]){H[i].style.height=J+"px";}}}};z.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var j=this.getVisibleRowCountMode();if(T.isVariableRowHeightEnabled(this)){var l=this.getDomRef(u.VerticalScrollBar);if(l){this._iOldScrollTop=l.scrollTop;}}var A=this.getRows();if(j==V.Interactive||j==V.Fixed||(j==V.Auto&&this._iTableRowContentHeight&&A.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var B=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){B._adjustRows(B._calculateRowsToDisplay());B._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&A.length>0){this._adjustRows(A.length);}};z.prototype.onAfterRendering=function(j){if(j&&j.isMarked("insertTableRows")){return;}this._iDefaultRowHeight=undefined;this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var A=this.getColumns();for(var i=0,l=A.length;i<l;i++){if(A[i].getVisible()){A[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}if(T.isVariableRowHeightEnabled(this)){var B=this.getDomRef(u.VerticalScrollBar);if(B){B.scrollTop=Math.max(B.scrollTop,this._iOldScrollTop);}}this._updateGroupHeader();if(this._updateTableContent){this._updateTableContent();}if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};z.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var i=C.prototype.invalidate.call(this);}return i;};z.prototype._initRowDomRefs=function(){var j=this.getRows();for(var i=0;i<j.length;i++){j[i].initDomRefs();}};z.prototype._updateTableSizes=function(i,j){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var l=this.getDomRef();if(this._bInvalid||!l){return;}this._resetRowHeights();var A=this._collectRowHeights();this._getDefaultRowHeight(A);var B=0;if(!j&&this.getVisibleRowCountMode()==V.Auto){B=this._determineAvailableSpace();if(this._handleRowCountModeAuto(B)&&!i){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var H=this._collectTableSizes(A);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(H.tableCntHeight==0&&H.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(H.tableRowHeights);this._syncColumnHeaders(H);this._determineVisibleCols(H);if(!j){this._setRowContentHeight(B);}this._updateHSb(H);this._updateVSb(H);this.$().find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}var J=this;this._mTimeouts.afterUpdateTableSizes=window.setTimeout(function(){T.registerResizeHandler(J,"",J._onTableResize.bind(J),true);},0);};z.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var j=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(j);}return this;};z.prototype._updateGroupHeader=function(){var i=this;if(this._modifyRow){q.each(this.getRows(),function(j,l){i._modifyRow(j+i.getFirstVisibleRow(),l.$());i._modifyRow(j+i.getFirstVisibleRow(),l.$("fixed"));});}};z.prototype._updateFixedBottomRows=function(){var j=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&j>0){var $=q(l).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var B=this.getBinding("rows");if(B){var A=this.getVisibleRowCount();var H=false;var J=this.getRows();var K=this._getSanitizedFirstVisibleRow();for(var i=0;i<J.length;i++){var L=J[i].getDomRefs(true);if(this._iBindingLength>=A){H=(i==A-j-1);}else{H=(K+i)==(this._iBindingLength-j-1)&&(K+i)<this._iBindingLength;}L.row.toggleClass("sapUiTableFixedPreBottomRow",H);}}}};z.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};z.prototype.applyFocusInfo=function(i){if(i&&i.customId){this.$().find("#"+i.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};z.prototype.setTitle=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});j.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",j);return this;};z.prototype.setFooter=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});}this.setAggregation("footer",j);return this;};z.prototype.setSelectionMode=function(i){this.clearSelection();if(i===t.Single){this._oSelection.setSelectionMode(g.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(g.MULTI_SELECTION);}if(i===t.Multi){i=t.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}this.setProperty("selectionMode",i);return this;};z.prototype._adjustTablePosition=function(){var i=this.getDomRef(u.VerticalScrollBar).scrollTop;var j=this._getDefaultRowHeight();var l=i%j;var A=this.$().find(".sapUiTableCtrlRowScroll, .sapUiTableRowHdrScr");if(this._iBindingLength<=this.getVisibleRowCount()){A.css({"transform":"translate3d(0px, "+(-i)+"px, 0px)"});}else{var B=this._calculateRowCorrection(j,l,i);A.css({"transform":"translate3d(0px, "+(-B)+"px, 0px)"});}};z.prototype._calculateRowCorrection=function(i,j,l){var A=this.getFirstVisibleRow();var B=this._iBindingLength-this.getVisibleRowCount();if(A<B){var H=T.getRowHeightByIndex(this,0)-i;return Math.floor(j*(H/i))+j;}else if(A==B){return l-(this._iBindingLength*i)+this.getDomRef("tableCCnt").clientHeight;}};z.prototype.setFirstVisibleRow=function(i,O,j){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var l=this.getVisibleRowCount();var A=this._paginatorCalculateTargetPage(i,l);var B=(A-1)*l;if(i!=B){i=B;A=this._paginatorCalculateTargetPage(i,l);}this._paginatorUpdate(A);}var H=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(T.isVariableRowHeightEnabled(this)&&this.getBinding("rows")&&!this._bRefreshing&&!H){this._adjustTablePosition();}if(H&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(this.getNavigationMode()==N.Scrollbar){if(!O){var J=this.getDomRef(u.VerticalScrollBar);if(J){J.scrollTop=i*(this._getDefaultRowHeight()||28);}}}}if(H&&!j){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};z.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;z.prototype.bindRows=function(B,i,j,l){if(typeof B==="string"&&(i instanceof h||q.isArray(j)&&j[0]instanceof F)){l=j;j=i;i=undefined;}return this.bindAggregation("rows",B,i,j,l);};z.prototype._bindAggregation=function(i,j,l,A,B){E.prototype._bindAggregation.apply(this,arguments);var H=this.getBinding("rows");if(i==="rows"&&H){H.attachChange(this._onBindingChange,this);}this._initSelectionModel(g.MULTI_SELECTION);if(H&&this.isTreeBinding("rows")&&!H.hasListeners("selectionChanged")){H.attachSelectionChanged(this._onSelectionChanged,this);}return this;};z.prototype._initSelectionModel=function(i){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new g(i);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};z.prototype._onBindingChange=function(i){var j=typeof(i)==="object"?i.getParameter("reason"):i;if(j==="sort"||j==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};z.prototype.unbindAggregation=function(i,j){var B=this.getBinding("rows");if(i==="rows"&&this.isBound("rows")){j=true;}var l=E.prototype.unbindAggregation.apply(this,[i,j]);if(i==="rows"&&B){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return l;};z.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var j=this.getVisibleRowCountMode();if(j==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var l=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=l&&l>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};z.prototype.setTooltip=function(i){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",i,true);};z.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};z.prototype._getFixedBottomRowContexts=function(i,B){var j=this.getBinding("rows");var l=[];if(!j){return l;}i=i||this.getFixedBottomRowCount();B=B||j.getLength();var A=this.getVisibleRowCount();if(i>0&&(A-i)<B){l=this._getContexts(B-i,i,1);}return l;};z.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};z.prototype._getContexts=function(i,l,j){var B=this.getBinding("rows");if(B){return B.getContexts(i,l,j);}else{return[];}};z.prototype._getRowContexts=function(j,l,A){var B=false;var H=[];var J=this.getBinding("rows");var K=j||this.getRows().length;if(!J||K<=0){return[];}var L=this.getFirstVisibleRow();var O=this.getFixedRowCount();var Q=this.getFixedBottomRowCount();var U=0;var W;var X=K-Q;var Y=0;var Z=X;var $=this.getThreshold();$=$?Math.max(K,$):0;var _=L;var a1=function(f1,g1,_){for(var i=0;i<g1.length;i++){f1[_+i]=g1[i];}};if(O>0&&L>0){_=L+O;X-=O;Y=O;W=this._getFixedRowContexts(O);U+=W.length;H=H.concat(W);}W=this._getContexts(_,X,$);var b1=this._updateBindingLength(A);B=W.length<Math.min(X,b1-Q);if(this.getNavigationMode===N.Paginator){var c1=Math.min(X,(Math.max(b1-L-Q,0)));if(c1<X){X=c1;W=W.slice(0,X);}}U+=W.length;a1(H,W,Y);Z=Math.min(Z,Math.max(b1-Q,0));if(Q>0){W=this._getFixedBottomRowContexts(Q,b1);U+=W.length;a1(H,W,Z);}if(B&&!l){var d1=this._getSanitizedFirstVisibleRow(true);if(L!=d1){H=this._getRowContexts(K,true);U=H.length;}}if(!l){var e1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){e1._setBusy({requestedLength:O+X+Q,receivedLength:U,contexts:H,reason:A});},0);}return H;};z.prototype._getSanitizedFirstVisibleRow=function(U){var i=this.getNavigationMode();var j=this.getVisibleRowCount();var l=this.getFirstVisibleRow();l=Math.max(l,0);if(i===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){l=Math.min(l,Math.max(this._iBindingLength-j,0));}else if(i===N.Paginator&&this._oPaginator){var A=this._paginatorCalculateTargetPage(l,j);l=(A-1)*j;if(U){this._paginatorUpdate(A);}}if(U){this.setProperty("firstVisibleRow",l,true);}return l;};z.prototype._paginatorCalculateTargetPage=function(i,j){if(this._oPaginator){var l=1;if(i<this._iBindingLength){l=Math.ceil((i+1)/j);}return l;}};z.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};z.prototype._updateBindingLength=function(i){var B=this.getBinding("rows");var j=0;if(B){j=B.getLength();}if(j!=this._iBindingLength){this._iBindingLength=j;this._onBindingLengthChange(i);}return j;};z.prototype._onBindingLengthChange=function(i){this._updateFixedBottomRows();this._toggleVSb();this._bBindingLengthChanged=true;if(i!="skipNoDataUpdate"){this._updateNoData();}};z.prototype.refreshRows=function(i){var B=this.getBinding("rows");if(!B){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var j=this;var l=typeof(i)==="object"?i.getParameter("reason"):i;if(l==e.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var A=this.getVisibleRowCountMode();if((this.bOutput&&A===V.Auto)||A!==V.Auto){var H=this._calculateRowsToDisplay();if(this.bOutput){this.getBinding("rows").attachEventOnce("dataRequested",function(){if(j._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(j._mTimeouts.refreshRowsAdjustRows);}j._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){j._adjustRows(H,true);},0);});}var U;if(l==e.Filter||l==e.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,H,U);}};z.prototype.updateRows=function(i){if(this._bExitCalled){return;}this._setBusy(i?{changeReason:i}:false);if(this._bBindingLengthChanged){this._updateNoData();}var j=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((j==V.Auto&&this.bOutput)||j!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var B=(i==e.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||i=="unbindAggregation"?0:this._iBindingTimerDelay);var l=this;if(B==0&&i){Promise.resolve().then(function(){l._performUpdateRows(i);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(i);},B);}}};z.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};z.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};z.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};z.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};z.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};z.prototype.autoResizeColumn=function(i){var j=this.getColumns()[i];this._iColumnResizeStart=null;var l=this._calculateAutomaticColumnWidth(i);if(l==null){return;}j._iNewWidth=l;this._oCalcColumnWidths[i]=j._iNewWidth;this._onColumnResized(null,i);};z.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(l){l.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").on("scroll.sapUiTablePreventCCntScroll",function(l){l.target.scrollTop=0;});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(l)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableColRsz").mousedown(q.proxy(this._onColumnResizeStart,this));$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").mousemove(q.proxy(this._onScrPointerMove,this));this._enableColumnAutoResizing();var i=q(this.getDomRef(u.VerticalScrollBar));var j=q(this.getDomRef(u.HorizontalScrollBar));i.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));j.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));j.bind("mousedown.sapUiTableHScroll",function(l){l.preventDefault();});i.bind("mousedown.sapUiTableVScroll",function(l){l.preventDefault();});if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(l){if(q(l.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}};z.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").unbind();$.find(".sapUiTableColRsz").unbind();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").unbind("scroll.sapUiTablePreventCCntScroll");}var i=q(this.getDomRef(u.VerticalScrollBar));i.unbind("scroll.sapUiTableVScroll");i.unbind("mousedown.sapUiTableVScroll");var j=q(this.getDomRef(u.HorizontalScrollBar));j.unbind("scroll.sapUiTableHScroll");j.unbind("mousedown.sapUiTableHScroll");var l=this._getScrollTargets();l.unbind("MozMousePixelScroll.sapUiTableMouseWheel");l.unbind("wheel.sapUiTableMouseWheel");var A=q(document.body);A.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);};z.prototype._onScrPointerMove=function(j){var l=this.getDomRef();if(this._bIsColumnResizerMoving||!l){return;}var A=j.clientX;var B=l.getBoundingClientRect();var L=0;var H;if(this._bRtlMode){H=10000;}else{H=-10000;}for(var i=0;i<this._aTableHeaders.length;i++){var J=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if(A<J.right-5){L=i;H=J.left-B.left;}}else{if(A>J.left+5){L=i;H=J.right-B.left;}}}var K=this._getVisibleColumns()[L];if(K&&K.getResizable()){this.$().find(".sapUiTableColRsz").css("left",H+"px");this._iLastHoveredColumnIndex=L;}};z.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var i=q(this.getDomRef("rsz"));var j=q(this.getDomRef("sapUiTableCtrlScrFixed"));var l=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(j).add(l).add(i);};z.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};z.prototype._updateHSb=function(i){var $=this.$();var j=i.tableCtrlScrollWidth;if(!!D.browser.safari){j=Math.max(j,this._getColumnsWidth(this.getFixedColumnCount()));}if(j>i.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var l=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){l.width(j);}else{l.outerWidth(j);}}}var A=i.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){A+=i.tableRowHdrScrWidth;}if(this.getRows().length>0){var B=$.find(".sapUiTableHSb");if(this._bRtlMode){B.css('margin-right',A+'px');}else{B.css('margin-left',A+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=j+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};z.prototype._updateVSb=function(i){var j=this.getDomRef(u.VerticalScrollBar);if(!j){return;}var l=this.getFixedRowCount();var A=this.getFixedBottomRowCount();if(l>0||A>0){var $=q(j);if(l>0){$.css('top',(i.tableCtrlRowScrollTop-1)+'px');}if(A>0){$.css('height',i.tableCtrlRowScrollHeight+'px');}}var B=this._getDefaultRowHeight();var H=(this._iBindingLength-l-A)*B;if(T.isVariableRowHeightEnabled(this)){var J=0;var K=this.getDomRef("tableCCnt");if(K){J=K.clientHeight;}var L=0;var O=this.getDomRef("table");if(O){L=O.clientHeight;}this._iRowHeightsDelta=L-J-T.getRowHeightByIndex(this,this.getRows().length-1);if(this._iBindingLength<=this.getVisibleRowCount()){H=this._iRowHeightsDelta+(this.getVisibleRowCount()*B);}else{H=this._iRowHeightsDelta+H;}this._toggleVSb();}this.getDomRef("vsb-content").style.height=H+"px";if(!T.isVariableRowHeightEnabled(this)){j.scrollTop=this._getSanitizedFirstVisibleRow()*B;}};z.prototype._toggleVSb=function(){var $=this.$();var B=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var j=0;if(B){var l=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/l);var A=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/l));this.setProperty("firstVisibleRow",(Math.max(A,1)-1)*l,true);j=A;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(j);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){$.toggleClass("sapUiTableVScr",this._isVSbRequired());}};z.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(T.isVariableRowHeightEnabled(this)&&this._iRowHeightsDelta>0){return true;}if(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount()){return true;}}return false;};z.prototype._updateBindingContexts=function(i,j,l){var A=this.getRows(),B=this.getBinding("rows"),H=this.mBindingInfos["rows"],J;if(B){J=this._getRowContexts(j,false,l);}if(!i){var K=this.getFirstVisibleRow();var L=typeof this._updateTableCell==="function";this._resetRowHeights();for(var O=A.length-1;O>=0;O--){var Q=J?J[O]:undefined;var U=A[O];if(U){var W=K+O;this._updateRowBindingContext(U,Q,H&&H.model,W,L,B);}}}};z.prototype._updateRowBindingContext=function(j,A,B,H,J,K){j.setRowBindingContext(A,B,K);if(J){var L=j.getCells();for(var i=0,l=L.length;i<l;i++){if(L[i]){this._updateTableCell(L[i],A,L[i].$().closest("td"),H);}}}};z.prototype._hasData=function(){var B=this.getBinding("rows");if(!B||(B.getLength()||0)===0){return false;}return true;};z.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};z.prototype._determineVisibleCols=function(j){var $=this.$();if($.hasClass("sapUiTableHScr")){var A=this._bRtlMode;var B=j.tableHSbScrollLeft;var H=j.tableCtrlScrollWidth;var J=j.tableCtrlScrWidth;if(A&&D.browser.firefox&&B<0){B=B*-1;}var K=B+J;if(this._iOldScrollLeft!==B||this._iOldScrollRight!==K||this._bForceVisibleColCalc){var L=A?H:0;if((D.browser.internet_explorer||D.browser.firefox)&&A){L=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var O=j.headerWidths;for(var i=0;i<O.length;i++){var Q=O[i];if(A&&D.browser.chrome){L-=Q;}if(L+Q>=B&&L<=K){this._aVisibleColumns.push(i);}if(!A||(D.browser.internet_explorer||D.browser.firefox)){L+=Q;}}this._iOldScrollLeft=B;this._iOldScrollRight=K;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){if(U[i].shouldRender()){this._aVisibleColumns.push(i);}}}};z.prototype._enableColumnAutoResizing=function(){var $=q(this.getDomRef("rsz"));if($.length>0){this._bindSimulatedDoubleclick($,null,this._onAutomaticColumnResize);}};z.prototype.removeColumn=function(i,j){var l=this.removeAggregation('columns',i,j);this._bDetermineVisibleCols=true;if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var A=q.inArray(i,this._aSortedColumns);if(this._iNewColPos===undefined&&A>=0){this._aSortedColumns.splice(A,1);}this._resetRowTemplate();return l;};z.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};z.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};z.prototype.addColumn=function(i,j){var l=this;this.addAggregation('columns',i,j);i.attachEvent('_widthChanged',function(A){l._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};z.prototype.insertColumn=function(i,j,l){var A=this;this.insertAggregation('columns',i,j,l);i.attachEvent('_widthChanged',function(){A._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};z.prototype._getRowCount=function(){return this._iBindingLength;};z.prototype._getSelectableRowCount=function(){return this._iBindingLength;};z.prototype._getFirstVisibleRowByScrollTop=function(i){var j=this.getDomRef(u.VerticalScrollBar);if(j){i=(typeof i==="undefined")?j.scrollTop:i;if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>=this._iBindingLength){return 0;}else{return Math.min(this._iBindingLength-this.getVisibleRowCount(),Math.floor(i/this._getDefaultRowHeight()));}}else{return Math.ceil(i/this._getDefaultRowHeight());}}else{if(this.getNavigationMode()===N.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};z.prototype._getVisibleColumns=function(){var j=[];var A=this.getColumns();for(var i=0,l=A.length;i<l;i++){if(A[i].shouldRender()){j.push(A[i]);}}return j;};z.prototype._getVisibleColumnCount=function(){return this._getVisibleColumns().length;};z.prototype._getHeaderRowCount=function(){if(!this.getColumnHeaderVisible()){return 0;}else if(!this._useMultiHeader()){return 1;}var H=0;q.each(this._getVisibleColumns(),function(i,j){H=Math.max(H,j.getMultiLabels().length);});return H;};z.prototype._useMultiHeader=function(){var i=false;q.each(this._getVisibleColumns(),function(j,l){if(l.getMultiLabels().length>0){i=true;return false;}});return i;};z.prototype._getColumnsWidth=function(j,A){var B=this.getColumns();var H=0;if(j!==0&&!j){j=0;}if(A!==0&&!A){A=B.length;}for(var i=j,l=A;i<l;i++){if(B[i]&&B[i].shouldRender()){H+=this._CSSSizeToPixel(B[i].getWidth());}}return H;};z.prototype._CSSSizeToPixel=function(i,j){var l=this._iColMinWidth;if(i){if(q.sap.endsWith(i,"px")){l=parseInt(i,10);}else if(q.sap.endsWith(i,"em")||q.sap.endsWith(i,"rem")){l=Math.ceil(parseFloat(i)*this._getBaseFontSize());}}if(j){return l+"px";}else{return parseInt(l,10);}};z.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};z.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};z.prototype._handleRowCountModeAuto=function(i){var B=this.getBinding("rows");if(B&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var j=this;var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var A=j.getBusyIndicatorDelay();var H=this.getEnableBusyIndicator();if(B&&H){j.setBusyIndicatorDelay(0);j.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!j._executeAdjustRows()){j._updateTableSizes(false,true);}j._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(H){j.setBusy(false);j.setBusyIndicatorDelay(A);}},0);return l;}};z.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var j=this._calculateRowsToDisplay(i);if(j==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(j);};z.prototype._syncColumnHeaders=function(l){var A=this.getDomRef();if(!A){return;}var $=this.$();var H=l.headerWidths;var B=this.getFixedColumnCount();var J=this._getVisibleColumns();if(J.length==0){return;}var K=$.find(".sapUiTableColHdr");var L=$.find(".sapUiTableColHdrScr");var O=K.find(".sapUiTableCol");var Q=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=Q;var U={};Q.each(function(Z,_){var a1=_.getAttribute("data-sap-ui-headcolindex");var b1=H[Z];var c1;var d1=J[Z];if(d1){c1=b1;}if(Z==0||Z==B){c1+=Math.max(0,l.invisibleColWidth);}var e1=J[Z]?J[Z].getHeaderSpan():1,f1=[],g1;if(e1){if(!q.isArray(e1)){e1=[e1];}q.each(e1,function(i1,j1){e1[i1]=Math.max(j1,1);});g1=e1;}else{g1=[1];}for(var i=0;i<g1.length;i++){f1[i]={width:c1,span:1};for(var j=1;j<g1[i];j++){var h1=Q[Z+j];if(h1){f1[i].width+=H[Z+j];f1[i].span=g1[i];}}}if(d1){U[a1]={domRefColumnTh:_,domRefColumnDivs:[],aHeaderData:f1};}});var W=this;O.each(function(i,j){var Z=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var _=U[Z];if(_){_.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",W);}});q.each(U,function(j,Z){for(var i=0;i<Z.domRefColumnDivs.length;i++){var _=Z.aHeaderData[0];if(Z.aHeaderData[i]){_=Z.aHeaderData[i];}if(Z.domRefColumnDivs[i]){Z.domRefColumnDivs[i].style.width=_.width+"px";Z.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",_.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",W);}}});var X=this.getColumnHeaderHeight()>0;if(!X){O.each(function(i,j){j.style.height=l.columnRowOuterHeight+"px";});var Y=A.querySelector(".sapUiTableColHdrCnt");if(Y){Y.style.height=Math.floor(l.columnRowHeight*this._getHeaderRowCount())+"px";}}L.each(function(i,j){j.style.width=l.tableCtrlScrWidth+"px";});};z.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(j){j.preventDefault();return false;});};z.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};z.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};z.prototype.onvscroll=function(i){var j=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(),true);j._mTimeouts._sScrollUpdateTimerId=null;},300);}else{this.setFirstVisibleRow(this._getFirstVisibleRowByScrollTop(),true);}this._bIsScrolledByWheel=false;};z.prototype.onpscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);var j=0;if(this.getNavigationMode()===N.Paginator){j=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(j,true);};z.prototype._onMouseWheel=function(i){var O=i.originalEvent;var j=O.shiftKey;var l=0;if(D.browser.firefox){l=O.detail;}else{if(j){l=O.deltaX;}else{l=O.deltaY;}}if(j){var H=this.getDomRef(u.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+l;}}else{var A=this.getDomRef(u.VerticalScrollBar);if(A){this._bIsScrolledByWheel=true;A.scrollTop=A.scrollTop+l;}}i.preventDefault();i.stopPropagation();};z.prototype._syncHeaderAndContent=function(i){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=i.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};z.prototype.onhscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);if(!this._bOnAfterRendering){var j=this._collectTableSizes();this._syncHeaderAndContent(j);this._determineVisibleCols(j);}};z.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(u.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableColHdrScr");var j=0;if(i){j=i.scrollLeft;}H.scrollLeft=j;}}};z.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(u.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=i.scrollLeft;}}};z.prototype.onmousedown=function(i){this._getKeyboardExtension().initItemNavigation();var l=i.button===0;var j=this._isTouchMode(i);if(l){var $=q(i.target);var A=this.$("sb");if(i.target==A[0]){q(document.body).bind("selectstart",q.proxy(this._splitterSelectStart,this));var B=A.offset();var H=A.height();var J=A.width();q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+H+"px; width:"+J+"px; left:"+B.left+"px; top:"+B.top+"px\" ></div>");A.append("<div id=\""+this.getId()+"-overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");var K=q(document);if(j){K.bind("touchend.sapUiTableInteractiveResize",q.proxy(this._onGhostMouseRelease,this));K.bind("touchmove.sapUiTableInteractiveResize",q.proxy(this._onGhostMouseMove,this));}else{K.bind("mouseup.sapUiTableInteractiveResize",q.proxy(this._onGhostMouseRelease,this));K.bind("mousemove.sapUiTableInteractiveResize",q.proxy(this._onGhostMouseMove,this));}this._disableTextSelection();return;}var L=$.closest(".sapUiTableCol");if(L.length===1){this._bShowMenu=true;this._mTimeouts.delayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});var O=this._isTouchMode(i)&&($.hasClass("sapUiTableColDropDown")||$.hasClass("sapUiTableColResizer"));if(this.getEnableColumnReordering()&&!O){var Q=parseInt(L.attr("data-sap-ui-colindex"),10);if(Q>this._iLastFixedColIndex){var U=this.getColumns()[Q];this._mTimeouts.delayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(U,j);});}}}var W=!!(i.metaKey||i.ctrlKey);if(!!D.browser.firefox&&W){i.preventDefault();}}};z.prototype.onmouseup=function(i){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);};z.prototype.onclick=function(i){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);if(i.isMarked()){return;}if(!this._findAndfireCellEvent(this.fireCellClick,i)){this._onSelect(i);}else{i.preventDefault();}};z.prototype.oncontextmenu=function(i){var $=q(i.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var j=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(j){j._openMenu(H[0],false);}i.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,i,this._oncellcontextmenu)){i.preventDefault();}}};z.prototype._oncellcontextmenu=function(i){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");x=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var j=sap.ui.getCore().byId(i.columnId);var l=j.getFilterProperty();if(j&&j.isFilterableByMenu()&&i.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new x({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var B=this.getContextByIndex(i.rowIndex);var H=B.getProperty(l);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:j,value:H});}else{this.filter(j,H);}},this]}));var A=P.Dock;this._oContextMenu.open(false,i.cellDomRef,A.BeginTop,A.BeginBottom,i.cellDomRef,"none none");return true;}}};z.prototype._bindSimulatedDoubleclick=function(i,j,l){var A="click";var B=this;if(!!D.support.touch){A="touchend";}q(i).on(A,function(H){H.preventDefault();H.stopPropagation();B._clicksRegistered=B._clicksRegistered+1;if(B._clicksRegistered<2){B._mTimeouts.singleClickTimer=q.sap.delayedCall(B._doubleclickDelay,B,function(){B._clicksRegistered=0;if(j){j.call(B,H);}},[H]);}else{q.sap.clearDelayedCall(B._mTimeouts.singleClickTimer);B._clicksRegistered=0;l.call(B,H);}});};z.prototype._findAndfireCellEvent=function(i,j,l){var $=q(j.target);var A=$.closest("td[role='gridcell']");var B=A.attr("id");var H=/.*-row(\d*)-col(\d*)/i.exec(B);var J=false;if(H){var K=H[1];var L=H[2];var O=this.getRows()[K];var Q=O&&O.getCells()[L];var U=O&&O.getIndex();var W=Q.data("sap-ui-colid");var X;if(this.getBindingInfo("rows")){X=O.getBindingContext(this.getBindingInfo("rows").model);}var Y={rowIndex:U,columnIndex:L,columnId:W,cellControl:Q,rowBindingContext:X,cellDomRef:A.get(0)};J=!i.call(this,Y);if(!J&&typeof l==="function"){Y.cellDomRef=A[0];J=l.call(this,Y);}}return J;};z.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};z.prototype.onfocusin=function(i){var $;var j=q(i.target);if(j.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(j.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var l=$.scrollLeft();var A=$.width();var B=j.position().left;var H=B+j.width();var O=B-l;var J=H-A-l;var K=this.getDomRef(u.HorizontalScrollBar);if(J>0){K.scrollLeft=K.scrollLeft+J+2;}else if(O<0){K.scrollLeft=K.scrollLeft+O-1;}}};z.prototype._getAbsoluteRowIndex=function(i){var j=0;var l=this.getFirstVisibleRow();var A=this.getFixedBottomRowCount();var B=this.getVisibleRowCount();var H=B-A;if(A>0&&i>=H){j=this.getBinding().getLength()-B+i;}else{j=l+i;}return j;};z.prototype._onSelect=function(i){var $=q(i.target);var j=i.shiftKey;var l=!!(i.metaKey||i.ctrlKey);var A=$.closest(".sapUiTableCol");if(this._bShowMenu&&A.length===1){var B=parseInt(A.attr("data-sap-ui-colindex"),10);var H=this.getColumns()[B];if($.hasClass("sapUiTableColDropDown")){var J=this.fireColumnSelect({column:H});if(J){H._openMenu(A[0],i.type=="keyup");}}else{this._onColumnSelect(H,A[0],this._isTouchMode(i),i.type=="keyup");}return;}var K=$.closest(".sapUiTableRowHdr");if(K.length===1){var B=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(B),j,l);return;}var L;if(i.target){var O=q(i.target).closest("td");if(O.length>0){L=O[0];}}if(L&&(L.getAttribute("role")=="gridcell"||q(L).hasClass("sapUiTableTDDummy"))&&(this.getSelectionBehavior()===s.Row||this.getSelectionBehavior()===s.RowOnly)){var K=$.closest(".sapUiTableCtrl > tbody > tr");if(K.length===1){var B=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(B),j,l);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),i.target)){this._toggleSelectAll();return;}};z.prototype._isRowSelectable=function(i){return true;};z.prototype._onRowSelect=function(i,j,l){if(!!D.browser.internet_explorer&&j){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(i<0||i>=(B.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var A=this.getSelectionMode();if(A!==t.None){if(A===t.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(A===t.MultiToggle){l=true;}if(j){var H=this.getSelectedIndex();if(H>=0){this.addSelectionInterval(H,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(l){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(l){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};z.prototype._onColumnSelect=function(i,j,l,W){if(l&&(i.getResizable()||i._menuHasItems())){var $=q(j);var A=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){A.hide();var B="";if(i._menuHasItems()){B="<div class='sapUiTableColDropDown'></div>";}var H="";if(i.getResizable()){H="<div class='sapUiTableColResizer''></div>";}var J=q("<div class='sapUiTableColCellMenu'>"+B+H+"</div>");$.append(J);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:A,menu:J,self:$}));if(i.getResizable()){$.find(".sapUiTableColResizer").bind("touchstart",q.proxy(this._onColumnResizeStart,this));}}return;}var K=this.fireColumnSelect({column:i});if(K){i._openMenu(j,W);}};z.prototype.ontouchstart=function(i){if('ontouchstart'in document){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var j=q(i.target).closest($).length>0;if(j){var l=i.targetTouches[0];this._aTouchStartPosition=[l.pageX,l.pageY];var A=this.getDomRef(u.VerticalScrollBar);if(A){this._iTouchScrollTop=A.scrollTop;}var H=this.getDomRef(u.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};z.prototype.ontouchmove=function(i){if('ontouchstart'in document&&this._aTouchStartPosition){var j=i.targetTouches[0];var l=(j.pageX-this._aTouchStartPosition[0]);var A=(j.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(A)>Math.abs(l);}if(this._bIsScrollVertical){var B=this.getDomRef(u.VerticalScrollBar);if(B){var H=this._iTouchScrollTop-A;if(H>0&&H<(this.getDomRef("vsb-content").clientHeight-B.clientHeight)-1){i.preventDefault();i.stopPropagation();}B.scrollTop=H;}}else{var J=this.getDomRef(u.HorizontalScrollBar);if(J){var K=this._iTouchScrollLeft-l;if(K>0&&K<(this.getDomRef("hsb-content").clientWidth-J.clientWidth)-1){i.preventDefault();i.stopPropagation();}J.scrollLeft=K;}}}};z.prototype._onColumnMoveStart=function(i,j){this._disableTextSelection();var $=i.$();var l=parseInt($.attr("data-sap-ui-colindex"),10);if(l<this.getFixedColumnCount()){return;}this.$().addClass("sapUiTableDragDrop");this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(B,H){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);var A=q(document.body);if(j){A.bind("touchmove.sapUiColumnMove",q.proxy(this._onColumnMove,this));A.bind("touchend.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}else{A.bind("mousemove.sapUiColumnMove",q.proxy(this._onColumnMove,this));A.bind("mouseup.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}};z.prototype._onColumnMove=function(i){var $=this.$();var l=i.pageX;var L=i.pageY;if(i&&this._isTouchMode(i)){l=i.targetTouches[0].pageX;L=i.targetTouches[0].pageY;i.stopPropagation();i.preventDefault();}var j=this._bRtlMode;var A=l-$.offset().left;var B=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var H=this.getColumns()[B].$();var O=this._iNewColPos;this._iNewColPos=B;var J=this;$.find(".sapUiTableCol").each(function(K,Q){var U=q(Q);var W=parseInt(U.attr("data-sap-ui-colindex"),10);var X=sap.ui.getCore().byId(U.attr("data-sap-ui-colid")).getHeaderSpan();var Y;if(X){if(q.isArray(X)){Y=X[0];}else{Y=X;}}else{Y=1;}if(U.get(0)!==H.get(0)){var Z=U.data("pos");var _=A>=Z.left&&A<=Z.center;var a1=A>=Z.center&&A<=Z.right;if(!j){if(_){J._iNewColPos=W;}else if(a1){J._iNewColPos=W+Y;}else{J._iNewColPos=J._iNewColPos;}}else{if(a1){J._iNewColPos=W;}else if(_){J._iNewColPos=W+Y;}else{J._iNewColPos=J._iNewColPos;}}if((_||a1)&&W>B){J._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=O;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=O;}this._animateColumnMove(B,O,this._iNewColPos);this._$colGhost.css({"left":l+5,"top":L+5});};z.prototype._animateColumnMove=function(j,O,A){var B=this._bRtlMode;var $=this.getColumns()[j].$();if(O!==A){for(var i=Math.min(O,A),l=Math.max(O,A);i<=l;i++){var H=this.getColumns()[i];if(i!==j&&H.getVisible()){H.$().stop(true,true).animate({left:"0px"});}}var J=0;if(A<j){for(var i=A;i<j;i++){var H=this.getColumns()[i];if(H.getVisible()){var K=H.$();J-=K.outerWidth();K.stop(true,true).animate({left:$.outerWidth()*(B?-1:1)+"px"});}}}else{for(var i=j+1,l=A+1;i<l;i++){var H=this.getColumns()[i];if(H.getVisible()){var K=H.$();J+=K.outerWidth();K.stop(true,true).animate({left:$.outerWidth()*(B?1:-1)+"px"});}}}$.stop(true,true).animate({left:J*(B?-1:1)+"px"});}};z.prototype._onColumnMoved=function(j){var l=this;this.$().removeClass("sapUiTableDragDrop");var A=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var B=this.getColumns()[A];var $=q(document.body);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var H=this.fireColumnMove({column:B,newPos:this._iNewColPos});var J=A<this._iNewColPos;if(H&&this._iNewColPos!==undefined&&this._iNewColPos!==A){this.removeColumn(B);this.insertColumn(B,this._iNewColPos);var K=B.getHeaderSpan(),L;if(K){if(q.isArray(K)){L=K[0];}else{L=K;}}else{L=1;}if(L>1){if(!J){this._iNewColPos++;}for(var i=1;i<L;i++){var O=this.getColumns()[J?A:A+i];this.removeColumn(O);this.insertColumn(O,this._iNewColPos);this.fireColumnMove({column:O,newPos:this._iNewColPos});if(!J){this._iNewColPos++;}}}}else{this._animateColumnMove(A,this._iNewColPos,A);B.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}if(this._mTimeouts.reApplyFocusTimer){window.clearTimeout(this._mTimeouts.reApplyFocusTimer);}this._mTimeouts.reApplyFocusTimer=window.setTimeout(function(){var Q=T.getFocusedItemInfo(l).cell;T.focusItem(l,0,j);T.focusItem(l,Q,j);},0);delete this._iNewColPos;};z.prototype._onAutomaticColumnResize=function(i){var j=this.getColumns()[this._iLastHoveredColumnIndex];if(!j.getAutoResizable()){return;}q.sap.log.debug("doubleclick fired");this._disableTextSelection();this.autoResizeColumn(this._iLastHoveredColumnIndex);i.preventDefault();i.stopPropagation();};z.prototype._onColumnResizeStart=function(i){this._bIsColumnResizerMoving=true;var $=q(document.body);this.$().addClass("sapUiTableResizing");if(this._isTouchMode(i)){this._iColumnResizeStart=i.targetTouches[0].pageX;this._disableTextSelection();this._$colResize=q("#"+this.getId()+"-rsz");$.bind("touchmove.sapUiTableColumnResize",this._onColumnResize.bind(this));$.bind("touchend.sapUiTableColumnResize",this._onColumnResized.bind(this));}else{if(i.button===0){this._iColumnResizeStart=i.pageX;this._disableTextSelection();this._$colResize=q(i.target);$.bind("mousemove.sapUiTableColumnResize",this._onColumnResize.bind(this));$.bind("mouseup.sapUiTableColumnResize",this._onColumnResized.bind(this));}}};z.prototype._onColumnResize=function(i){var l;if(this._isTouchMode(i)){l=i.targetTouches[0].pageX;i.stopPropagation();i.preventDefault();}else{l=i.pageX;}if(this._iColumnResizeStart&&l<this._iColumnResizeStart+3&&l>this._iColumnResizeStart-3){return;}if(this._isTouchMode(i)){this._$colResize.addClass("sapUiTableColTouchRszActive");}else{this._$colResize.addClass("sapUiTableColRszActive");}var j=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var A=l-this._iColumnResizeStart;var B=j.$().width();var W;if(this._bRtlMode){W=B-A;}else{W=B+A;}W=Math.max(W,this._iColMinWidth);var H=this.$().find(".sapUiTableCnt").offset().left;var J=Math.floor((l-H)-(this._$colResize.width()/2));this._$colResize.css("left",J+"px");j._iNewWidth=W;};z.prototype._onColumnResized=function(i,j){var l;this._bIsColumnResizerMoving=false;this.$().removeClass("sapUiTableResizing");if(!this._$colResize&&(j===null||j===undefined)){return;}if(j===null||j===undefined){l=this._iLastHoveredColumnIndex;}else{l=j;}var A=this._getVisibleColumns()[l];var B=false;if(A._iNewWidth){var W;var H=this.$().find(".sapUiTableCtrl").width();if(!this._checkPercentageColumnWidth()){W=A._iNewWidth+"px";}else{var J=Math.round(100/H*A._iNewWidth);W=J+"%";}if(this._updateColumnWidth(A,W,true)){this._resizeDependentColumns(A,W);}delete A._iNewWidth;B=true;}var $=q(document.body);$.unbind("touchmove.sapUiTableColumnResize");$.unbind("touchend.sapUiTableColumnResize");$.unbind("mousemove.sapUiTableColumnResize");$.unbind("mouseup.sapUiTableColumnResize");A.focus();if(this._$colResize){this._$colResize.removeClass("sapUiTableColTouchRszActive sapUiTableColRszActive");this._$colResize=undefined;}this._enableTextSelection();if(B){this.invalidate();}};z.prototype._resizeDependentColumns=function(j,W){var l=this;if(this._checkPercentageColumnWidth()){var A=this._getVisibleColumns();var B;q.each(A,function(c1,d1){if(j===d1){B=c1;}});var O=0;var L=A.length-1;var H;if(B===undefined){H=0;}else{H=parseInt(W,10);}var J=0;var K=[];q.each(A,function(c1,d1){var e1=l._getColumnPercentageWidth(d1);if((((B===L&&c1<B)||((B!==L)&&c1>B))&&d1.getFlexible())||B===undefined){O+=d1.$().outerWidth();J+=e1;K.push(d1);}else if(c1!==B){H+=e1;}});var Q=H;q.each(K,function(c1,d1){var e1=l._getColumnPercentageWidth(d1);var b1=Math.round((100-Q)/J*e1);if(c1===K.length-1){b1=100-H;}else{H+=b1;}l._updateColumnWidth(d1,b1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var A=this._getVisibleColumns(),U=this.$().find(".sapUiTableCtrl").width(),B,X=0,Y=0,Z=0,$=0;q.each(A,function(c1,d1){if(!q.sap.endsWith(d1.getWidth(),"px")&&!q.sap.endsWith(d1.getWidth(),"em")&&!q.sap.endsWith(d1.getWidth(),"rem")){$++;return false;}if(B!=undefined){Z+=l._CSSSizeToPixel(d1.getWidth());X++;}else if(j!==d1){Y+=l._CSSSizeToPixel(d1.getWidth());}if(j===d1){B=c1;Y+=l._CSSSizeToPixel(W);}});if($>0||(Y+Z>U)){return;}U-=Y;for(var i=B+1;i<A.length;i++){var j=A[i],_=this._CSSSizeToPixel(j.getWidth()),a1=_/Z*100,b1=U/100*a1;this._updateColumnWidth(j,Math.round(b1)+'px');}}};z.prototype._getColumnPercentageWidth=function(i){var j=i.getWidth();var l=parseInt(i.getWidth(),10);var A=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(j,"px")||q.sap.endsWith(j,"em")||q.sap.endsWith(j,"rem")){l=Math.round(100/A*l);}else if(!q.sap.endsWith(j,"%")){l=Math.round(100/A*i.$().width());}return l;};z.prototype._updateColumnWidth=function(i,W,j){var l=true;if(j){l=this.fireColumnResize({column:i,width:W});}if(l){i.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]').css('width',W);}return l;};z.prototype._checkPercentageColumnWidth=function(){var i=this.getColumns();var H=false;q.each(i,function(j,l){if(q.sap.endsWith(l.getWidth(),"%")){H=true;return false;}});return H;};z.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,j){var W=j.getWidth();if(j.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};z.prototype.pushSortedColumn=function(i,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(i);};z.prototype.getSortedColumns=function(){return this._aSortedColumns;};z.prototype.sort=function(i,j,A){if(q.inArray(i,this.getColumns())>=0){i.sort(j===v.Descending,A);}};z.prototype.filter=function(i,j){if(q.inArray(i,this.getColumns())>=0){i.filter(j);}};z.prototype._getSelectOnCellsAllowed=function(){var i=this.getSelectionBehavior();var j=this.getSelectionMode();return j!==t.None&&(i===s.Row||i===s.RowOnly);};z.prototype._updateSelection=function(){if(this.getSelectionMode()===t.None){return;}var j=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=this._getSelectOnCellsAllowed();var A=this.getRows();for(var i=0;i<A.length;i++){var B=A[i];B._updateSelection(this,j,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);};z.prototype._onSelectionChanged=function(i){var j=i.getParameter("rowIndices");var l=i.getParameter("selectAll");var A=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var B=this.getSelectionMode();if(B==="Multi"||B==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:A,rowContext:this.getContextByIndex(A),rowIndices:j,selectAll:l,userInteraction:this._iSourceRowIndex!==undefined});};z.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};z.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};z.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};z.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};z.prototype.selectAll=function(){var i=this.getSelectionMode();if(!this.getEnableSelectAll()||(i!="Multi"&&i!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.selectAll((B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};z.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};z.prototype.addSelectionInterval=function(i,j){this._oSelection.addSelectionInterval(i,j);return this;};z.prototype.setSelectionInterval=function(i,j){this._oSelection.setSelectionInterval(i,j);return this;};z.prototype.removeSelectionInterval=function(i,j){this._oSelection.removeSelectionInterval(i,j);return this;};z.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};z.prototype._toggleGroupHeader=function(i){var $=q(i.target).closest('.sapUiTableGroupHeader');if($.length>0){var j=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(j)){B.collapse(j);}else{B.expand(j);}i.preventDefault();i.stopImmediatePropagation();}};z.prototype._collapseGroupHeader=function(i){var $=q(i.target).closest('.sapUiTableGroupHeader');if($.length>0){var j=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(j)){B.collapse(j);}i.preventDefault();i.stopImmediatePropagation();}};z.prototype._expandGroupHeader=function(i){var $=q(i.target).closest('.sapUiTableGroupHeader');if($.length>0){var j=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&!B.isExpanded(j)){B.expand(j);}i.preventDefault();i.stopImmediatePropagation();}};z.prototype.setGroupBy=function(i){var j=i;if(typeof j==="string"){j=sap.ui.getCore().byId(j);}var l=false;if(j&&j instanceof k){if(q.inArray(j,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var A=this.fireGroup({column:j,groupedColumns:[j.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);l=true;}if(A&&j instanceof k){j.setGrouped(true);}}if(!j||l){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",j);};z.prototype.getBinding=function(j){j=j||"rows";var B=E.prototype.getBinding.call(this,j);if(this.getEnableGrouping()){var l=sap.ui.requireSync("sap/ui/model/ClientListBinding");var A=sap.ui.getCore().byId(this.getGroupBy());var H=A&&A.getGrouped()&&j==="rows"&&B&&B instanceof l;if(H&&!B._modified){B._modified=true;this._modifyRow=function(X,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var Y=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(X)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var Z=B.isExpanded(X)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";Y.html("<div class=\"sapUiTableGroupIcon "+Z+"\" tabindex=\"-1\">"+B.getTitle(X)+"</div>");Y.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");Y.html("");Y.removeClass("sapUiTableGroupHeader");}};this.onclick=function(X){if(q(X.target).hasClass("sapUiTableGroupIcon")){var $=q(X.target).parents("[data-sap-ui-rowindex]");if($.length>0){var Y=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B.isExpanded(Y)){B.collapse(Y);q(X.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{B.expand(Y);q(X.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}}}else{if(z.prototype.onclick){z.prototype.onclick.apply(this,arguments);}}};var J=A.getSortProperty();B.sort(new h(J));var L=B.getLength(),K=B.getContexts(0,L);var O;var Q=0;for(var i=L-1;i>=0;i--){var U=K[i].getProperty(J);if(!O){O=U;}if(O!==U){var W=K[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);W.__groupInfo={oContext:K[i+1],name:O,count:Q,groupHeader:true,expanded:true};K.splice(i+1,0,W);O=U;Q=0;}Q++;}var W=K[0].getModel().getContext("/sap.ui.table.GroupInfo");W.__groupInfo={oContext:K[0],name:O,count:Q,groupHeader:true,expanded:true};K.splice(0,0,W);q.extend(B,{getLength:function(){return K.length;},getContexts:function(X,L){return K.slice(X,X+L);},isGroupHeader:function(X){var Y=K[X];return Y&&Y.__groupInfo&&Y.__groupInfo.groupHeader;},getTitle:function(X){var Y=K[X];return Y&&Y.__groupInfo&&Y.__groupInfo.name+" - "+Y.__groupInfo.count;},isExpanded:function(X){var Y=K[X];return this.isGroupHeader(X)&&Y.__groupInfo&&Y.__groupInfo.expanded;},expand:function(X){if(this.isGroupHeader(X)&&!K[X].__groupInfo.expanded){for(var i=0;i<K[X].__childs.length;i++){K.splice(X+1+i,0,K[X].__childs[i]);}delete K[X].__childs;K[X].__groupInfo.expanded=true;this._fireChange();}},collapse:function(X){if(this.isGroupHeader(X)&&K[X].__groupInfo.expanded){K[X].__childs=K.splice(X+1,K[X].__groupInfo.count);K[X].__groupInfo.expanded=false;this._fireChange();}}});this._mTimeouts.groupingFireBindingChange=this._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){B._fireChange();},0);}}return B;};z.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this.onclick=z.prototype.onclick;this._modifyRow=undefined;var i=this.getBindingInfo("rows");this.unbindRows();this.bindRows(i);}};z.prototype.setEnableGrouping=function(i){this.setProperty("enableGrouping",i);if(!i){this.resetGrouping();}this._invalidateColumnMenus();return this;};z.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};z.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};z.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};z.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};z.prototype.setFixedColumnCount=function(j,l){var A=this._getVisibleColumns();var H=A[j-1]&&A[j-1].getHeaderSpan();if(H){var B;if(q.isArray(H)){B=parseInt(H[0],10);}else{B=parseInt(H,10);}j+=B-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<j;i++){var J=A[i];if(J){var K=q.inArray(J,this.getColumns());if(!J.getWidth()){J.setWidth($.filter("[data-sap-ui-headcolindex='"+K+"']").width()+"px");}}}this.setProperty("fixedColumnCount",j,l);this._collectTableSizes();this._invalidateColumnMenus();return this;};z.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};z.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};z.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};z.prototype._invalidateColumnMenus=function(){var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){j[i].invalidateMenu();}};z.prototype._isTouchMode=function(i){return!!i.originalEvent["touches"];};z.prototype._splitterSelectStart=function(i){i.preventDefault();i.stopPropagation();return false;};z.prototype._onGhostMouseRelease=function(i){var $=this.$();var j=q(this.getDomRef("ghost"));var l=this._isTouchMode(i)?i.changedTouches[0].pageY:i.pageY;var A=l-$.find(".sapUiTableCCnt").offset().top-j.height()-$.find(".sapUiTableFtr").height();this._setRowContentHeight(A);this._adjustRows(this._calculateRowsToDisplay(A));j.remove();this.$("overlay").remove();q(document.body).unbind("selectstart",this._splitterSelectStart);var B=q(document);B.unbind("touchend.sapUiTableInteractiveResize");B.unbind("touchmove.sapUiTableInteractiveResize");B.unbind("mouseup.sapUiTableInteractiveResize");B.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();};z.prototype._onGhostMouseMove=function(i){var j=this.getDomRef("ghost");var l=this._isTouchMode(i)?i.targetTouches[0].pageY:i.pageY;var A=this.$().offset().top;if(l>A){q(j).css("top",l+"px");}};z.prototype._determineParent=function(){var i=this.getParent();if(i){var j;if(i.getDomRef){j=i.getDomRef();}else if(i.getRootNode){j=i.getRootNode();}if(j){return q(j);}}return q();};z.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new m(this.getId()+"-rows");var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getVisible()){var A=j[i].getTemplate();if(A){var B=A.clone("col"+i);B.data("sap-ui-colindex",i);B.data("sap-ui-colid",j[i].getId());this._oRowTemplate.addCell(B);}}}}return this._oRowTemplate;};z.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};z.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};z.prototype._adjustRows=function(j,l){if(isNaN(j)){return false;}if(T.isVariableRowHeightEnabled(this)){j=j+1;}var i;var A=this.getRows();if(!this._oRowTemplate&&A.length>0){this.destroyAggregation("rows",true);A=[];}if(j==A.length){return false;}for(i=A.length-1;i>=j;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",j-1,true);}else{this.setProperty("visibleRowCount",j,true);}this._ignoreInvalidateOfChildControls=true;var B;var H=this.getFirstVisibleRow();var J=0;var K=false;var L;var O=this.getBinding("rows");if(!l){L=this.getBindingInfo("rows");K=typeof this._updateTableCell==="function";B=this._getRowContexts(j);for(i=0;i<A.length;i++){J=H+i;this._updateRowBindingContext(A[i],B[i],L&&L.model,J,K,O);}}if(A.length<j){var Q=this._getRowTemplate();for(i=A.length;i<j;i++){var U=Q.clone("row"+i);if(!l){J=H+i;this._updateRowBindingContext(U,B[i],L&&L.model,J,K,O);}this.addAggregation("rows",U,true);}}this._ignoreInvalidateOfChildControls=false;A=this.getRows();l=l||B.length==0;return this._insertTableRows(A,l);};z.prototype._insertTableRows=function(j,A){var B=false;if(!this._bInvalid){this._detachEvents();var H=this.getDomRef("tableCCnt");j=j||this.getRows();if(!j.length||!H){return;}if(this.getVisibleRowCountMode()==V.Auto){var J=this.getDomRef();if(J){J.style.height="0px";}}var K=q.Event("BeforeRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);var L=new sap.ui.getCore().createRenderManager(),O=this.getRenderer();this._iDefaultRowHeight=undefined;O.renderTableCCnt(L,this);L.flush(H,false,false);L.destroy();K=q.Event("AfterRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){if(Q[i].getVisible()){Q[i]._restoreIcons();}}this._updateTableSizes();this._updateGroupHeader();B=true;if(this._updateTableContent){this._updateTableContent();}this._attachEvents();}if(!A&&!this._bInvalid&&this.getBinding("rows")){var U=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){U.fireEvent("_rowsUpdated");},0);}return B;};z.prototype._getDefaultRowHeight=function(i){if(T.isVariableRowHeightEnabled(this)){this._iDefaultRowHeight=this.getRowHeight()||28;}else{if(!this._iDefaultRowHeight&&this.getDomRef()){i=i||this._collectRowHeights();if(i&&i.length>0){this._iDefaultRowHeight=i[0];}}if(!this._iDefaultRowHeight){this._iDefaultRowHeight=28;}}return this._iDefaultRowHeight;};z.prototype._setRowContentHeight=function(H){H=H||0;var i=this.getVisibleRowCountMode();var j=this.getVisibleRowCount();var l=this.getMinAutoRowCount();var A;var B=this._getDefaultRowHeight();if(i==V.Interactive||i==V.Fixed){if(this._iTableRowContentHeight&&i==V.Interactive){A=l*B;if(!H){H=this._iTableRowContentHeight;}}else{A=j*B;H=A;}}else if(i==V.Auto){A=l*B;}var J=Math.max(H,A);if((i==V.Fixed&&this.getRows().length==0)||i!=V.Fixed){this._iTableRowContentHeight=Math.floor(J/B)*B;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){var $=q(this.getDomRef("tableCCnt"));if(i==V.Fixed||i==V.Interactive){$.css("height",this._getDefaultRowHeight()*this.getVisibleRowCount()+"px");}else if(i==V.Auto){$.css("height",this._iTableRowContentHeight+"px");}}else{if((i==V.Fixed||i==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};z.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var j=this.getMinAutoRowCount();var l=j||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){l=i||j||5;}return l;};z.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var j=this.getVisibleRowCountMode();var l=0;if(j==V.Fixed){l=this.getVisibleRowCount()||0;}else if(j==V.Interactive||j==V.Auto){var A=this._determineMinAutoRowCount();var B=this._getDefaultRowHeight();if(!B||!i){l=A;}else{var H=Math.min(i,50000);var J=Math.floor(H/B);l=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(A,J));}}return Math.max(l,0);};z.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};z.prototype.exportData=function(j){var A=sap.ui.requireSync("sap/ui/core/util/Export");j=j||{};if(!j.rows){var B=this.getBinding("rows"),H=this.getBindingInfo("rows");var J=B.aFilters.concat(B.aApplicationFilters);j.rows={path:H.path,model:H.model,sorter:B.aSorters,filters:J,parameters:H.parameters};}if(!j.exportType){var K=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");j.exportType=new K();}var L=j.rows.model;if(!L){var O=j.rows.path;var Q=O.indexOf(">");if(Q>0){L=O.substr(0,Q);}}if(!j.columns){j.columns=[];var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){var W=U[i];if(W.getSortProperty()){j.columns.push({name:W.getLabel().getText(),template:{content:{path:W.getSortProperty(),model:L}}});}}}var X=new A(j);this.addDependent(X);return X;};z.prototype._calculateAutomaticColumnWidth=function(j){var l=["sap.m.Text","sap.m.Label","sap.m.Link","sap.ui.commons.TextView","sap.ui.commons.Label","sap.ui.commons.Link"];var $=this.$();var H=0;var A=$.find('td[headers=\"'+this.getId()+'_col'+j+'\"]').children("div");var B=this.getColumns();var J=B[j];if(!J){return null;}var K=J.getHeaderSpan();var L=J.getLabel();var O=this;w=w||sap.ui.require("sap/m/Input");y=y||sap.ui.require("sap/ui/commons/TextField");var Q=J.getTemplate();var U=q.inArray(Q.getMetadata().getName(),l)!=-1||y&&Q instanceof y||w&&Q instanceof w;var W=document.createElement("div");document.body.appendChild(W);q(W).addClass("sapUiTableHiddenSizeDetector");var X=J.getMultiLabels();if(X.length==0&&!!L){X=[L];}if(X.length>0){q.each(X,function(_,a1){var b1;if(!!a1.getText()){q(W).text(a1.getText());H=W.scrollWidth;}else{H=a1.$().scrollWidth;}H=H+$.find("#"+J.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+J.getId()+"_"+_+"-icons").first().width();if(K instanceof Array&&K[_]>1){b1=K[_];}else if(K>1){b1=K;}if(!!b1){var i=b1-1;while(i>j){H=H-(O._oCalcColumnWidths[j+i]||0);i-=1;}}});}var Y=Math.max.apply(null,A.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var Z=Math.max.apply(null,A.children().map(function(){var i=0,_=0;var a1=q(this);var b1=a1.text()||a1.val();if(U){q(W).text(b1);_=W.scrollWidth;}else{_=this.scrollWidth;}if(H>_){_=H;}i=_+parseInt(a1.css('margin-left'),10)+parseInt(a1.css('margin-right'),10)+Y+1;return i;}).get());q(W).remove();return Math.max(Z,this._iColMinWidth);};z.prototype._onPersoApplied=function(){var j=this.getColumns();var A=[];for(var i=0,l=j.length;i<l;i++){var B=j[i];if(B.getSorted()){A.push(new h(B.getSortProperty(),B.getSortOrder()===v.Descending));}}var H=this.getBinding("rows");if(H){if(A.length>0){H.sort(A);}this.refreshRows();}};z.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};z.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var i=this.getColumns();q.each(i,function(j,l){l._restoreAppDefaults();});};z.prototype._setBusy=function(j){var B,i,l;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}this.setBusy(false);if(j&&this._iDataRequestedCounter>0){var A=j.reason;if(j.contexts&&j.contexts.length!==undefined){l=false;for(i=0;i<j.contexts.length;i++){if(j.contexts[i]===undefined){l=true;break;}}}else if(j.changeReason===e.Expand){this.setBusy(true);}var L=B.getLength();if((A==e.Expand&&this._iDataRequestedCounter!==0)||l||(B.isInitial())||(j.receivedLength===0&&this._iDataRequestedCounter!==0)||(j.receivedLength<j.requestedLength&&j.receivedLength!==L&&j.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};z.prototype.setBusy=function(B,i){var j=this.getBusy()!=B;i="sapUiTableCnt";var l=C.prototype.setBusy.call(this,B,i);if(j){this.fireBusyStateChanged({busy:B});}return l;};z.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);};z.prototype._attachDataRequestedListeners=function(){var B=this.getBinding("rows");if(B){B.detachDataRequested(this._onBindingDataRequestedListener,this);B.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;B.attachDataRequested(this._onBindingDataRequestedListener,this);B.attachDataReceived(this._onBindingDataReceivedListener,this);}};z.prototype._onBindingDataRequestedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};z.prototype._onBindingDataReceivedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};z.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};z.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};z.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};return z;});
