/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils','sap/ui/core/Renderer'],function(q,C,c,P,D,a,T,R){"use strict";var N=a.NavigationMode,S=a.SelectionBehavior,b=a.SelectionMode,V=a.VisibleRowCountMode;var d={};d.render=function(r,t){r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(t.getSelectionMode()!==b.None&&t.getSelectionBehavior()!==S.RowOnly){r.addClass("sapUiTableRSel");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t._isVSbRequired()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.isNoDataVisible(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}if(t.getEnableGrouping()){r.addClass("sapUiTableGrouping");}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getNavigationMode()===N.Paginator){r.write("<div");r.addClass("sapUiTablePaginator");r.writeClasses();r.write(">");if(!t._oPaginator){var e=sap.ui.requireSync("sap/ui/commons/Paginator");t._oPaginator=new e(t.getId()+"-paginator");t._oPaginator.attachPage(q.proxy(t.onpscroll,t));}r.renderControl(t._oPaginator);r.write("</div>");}if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};d.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};d.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}var e=sap.ui.require("sap/m/Toolbar");if(e&&o instanceof e){o.setDesign(P.get("sapUiTableToolbarDesign"),true);}r.renderControl(o);r.write("</div>");};d.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};d.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};d.renderTable=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderHSb(r,t);};d.renderTableCCnt=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderVSb(r,t);this.renderTabElement(r,"sapUiTableCtrlAfter");r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};d.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};d.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};d.renderColHdr=function(r,t){r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*t._getHeaderRowCount())+"px");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.writeStyles();r.write(">");this.renderColRowHdr(r,t);var e=t.getColumns();var f=t.getFixedColumnCount();var F=t._getColumnsWidth(0,f);if(f>0){r.write("<div");r.addClass("sapUiTableColHdrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var h=0;h<t._getHeaderRowCount();h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.addStyle("min-width",F+"px");r.writeStyles();r.write(">");var s=1;for(var i=0,l=t.getFixedColumnCount();i<l;i++){if(e[i]&&e[i].shouldRender()){if(s<=1){this.renderCol(r,t,e[i],i,h);var H=e[i].getHeaderSpan();if(q.isArray(H)){s=e[i].getHeaderSpan()[h]+1;}else{s=parseInt(e[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,e[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableColHdrScr");if(e.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");for(var h=0;h<t._getHeaderRowCount();h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");var s=1;for(var i=f,l=e.length;i<l;i++){if(e[i].shouldRender()){if(s<=1){this.renderCol(r,t,e[i],i,h);var H=e[i].getHeaderSpan();if(q.isArray(H)){s=e[i].getHeaderSpan()[h]+1;}else{s=parseInt(e[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,e[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");r.write("</div>");};d.renderColRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-selall");var s=t.getSelectionMode();var e=false;if((s=="Multi"||s=="MultiToggle")&&t.getEnableSelectAll()){r.writeAttributeEscaped("title",t._oResBundle.getText("TBL_SELECT_ALL"));if(t._getSelectableRowCount()==0||t._getSelectableRowCount()!==t.getSelectedIndices().length){r.addClass("sapUiTableSelAll");}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e});r.write(">");if(t.getSelectionMode()!==b.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};d.renderCol=function(r,t,o,i,h,I){var l;if(o.getMultiLabels().length>0){l=o.getMultiLabels()[h];}else if(h==0){l=o.getLabel();}r.write("<div");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",i);r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",{column:o,headerId:H,index:i});r.addClass("sapUiTableCol");if(t.getFixedColumnCount()===i+1){r.addClass("sapUiTableColLastFixed");}r.writeClasses();r.addStyle("width",o.getWidth());if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(I){r.addStyle("display","none");}r.writeStyles();var s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeClasses();var e=R.getTextAlign(o.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());if(e){r.addStyle("text-align",e);}r.writeStyles();r.write(">");if(l){r.renderControl(l);}r.write("</div></div>");};d.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.writeAttribute("tabindex","-1");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};d.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var e=0,f=t.getRows().length;e<f;e++){this.renderRowHdrRow(r,t,t.getRows()[e],e);}r.write("</div>");};d._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();var e=t.getFirstVisibleRow();if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>0){var I=false;var B=t.getBinding("rows");if(B){if(t._iBindingLength>=v){I=(i==v-F-1);}else{I=(e+i)==(t._iBindingLength-F-1)&&(t.getFirstVisibleRow()+i)<t._iBindingLength;}}if(I){r.addClass("sapUiTableFixedPreBottomRow");}}};d.renderRowHdrRow=function(r,t,o,i){r.write("<div");r.writeAttribute("id",t.getId()+"-rowsel"+i);r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableRowHdr");this._addFixedRowCSSClasses(r,t,i);var e=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");e=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER",{rowSelected:e});var f=[];q.each(o.getCells(),function(I,g){f.push(o.getId()+"-col"+I);});r.writeStyles();r.write(">");this.writeRowSelectorContent(r,t,o,i);r.write("</div>");};d.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};d.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var g=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,g.length-i);if(i>0&&g.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,g.length-i,g.length);}};d.renderTableControlCnt=function(r,t,f,s,e,F,g,i,E){r.write("<table");var I=t.getId()+"-table";if(f){I+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){I+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(g){I+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",I);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLE");r.addClass("sapUiTableCtrl");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(s,e)+"px");if(f&&(!!D.browser.firefox||!!D.browser.chrome||!!D.browser.safari)){r.addStyle("width",t._getColumnsWidth(s,e)+"px");}r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}r.writeClasses();r.write(">");var h=t.getColumns();if(t.getSelectionMode()!==b.None&&t.getSelectionBehavior()!==S.RowOnly){r.write("<th");r.addStyle("width","0px");r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");r.writeAttribute("id",t.getId()+"-colsel");r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(h.length===0){r.write("<th></th>");}}for(var j=s,k=e;j<k;j++){var o=h[j];if(o&&o.shouldRender()){r.write("<th");r.addStyle("width",o.getWidth());r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+"_col"+j);}r.writeAttribute("data-sap-ui-headcolindex",j);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&t._getHeaderRowCount()==0){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(!f&&t._hasOnlyFixColumnWidths()&&h.length>0){r.write("<th></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var H=t._hasOnlyFixColumnWidths();var l=t.getRows();if(l.length==0){l=[t._getDummyRow()];E=1;}var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var n=t._getSelectOnCellsAllowed();for(var p=i,k=E;p<k;p++){this.renderTableRow(r,t,l[p],p,f,s,e,false,v,H,m,n);}r.write("</tbody>");r.write("</table>");};d.addTrClasses=function(r,t,o,i){return;};d.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);};d.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,g){r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2===0){r.addClass("sapUiTableRowEven");}else{r.addClass("sapUiTableRowOdd");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);var j=t.getRowHeight();if(j>0){r.addStyle("height",j+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var k=o.getCells();if((t.getSelectionMode()!==b.None&&t.getSelectionBehavior()!==S.RowOnly)||k.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(t._getAbsoluteRowIndex(i)),index:i});r.write("></td>");}for(var l=0,n=k.length;l<n;l++){this.renderTableCell(r,t,o,k[l],l,f,s,e,v);}if(!f&&h&&k.length>0){r.write("<td");r.addClass("sapUiTableTDDummy");r.writeClasses();r.write(">");r.write("</td>");}r.write("</tr>");};d.renderTableCell=function(r,t,o,e,i,f,s,E,v){var g=e.data("sap-ui-colindex");var h=t.getColumns()[g];if(h.shouldRender()&&s<=g&&E>g){r.write("<td");var I=o.getId()+"-col"+i;r.writeAttribute("id",I);r.writeAttribute("tabindex","-1");var j=v.length>0&&v[0]===h;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:g,column:h,row:o,fixed:f,firstCol:j});var H=R.getTextAlign(h.getHAlign(),e&&e.getTextDirection&&e.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(j){r.addClass("sapUiTableTdFirst");}if(h.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&h.getLeadingProperty&&B.isMeasure(h.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,e,i);r.write("</div></td>");}};d.renderTableCellControl=function(r,t,o,i){r.renderControl(o);};d.renderVSb=function(r,t){r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-vsb");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-vsb-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};d.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-hsb");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-hsb-content");r.addClass("sapUiTableHSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};d.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};return d;},true);
