/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(q,D,a){"use strict";if(!q){throw new Error("SAPUI5 requires jQuery as a prerequisite (>= version 1.10)");}if(q.sap){return;}if(D.browser.edge){a.Promise=undefined;}if(!a.Promise){ES6Promise.polyfill();}var _=[];function b(l,m){_.push({level:l,message:m});}var c;var f=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function V(M,i,d,s){if(M instanceof V){return M;}if(!(this instanceof V)){return new V(M,i,d,s);}var m;if(typeof M==="string"){m=f.exec(M);}else if(Array.isArray(M)){m=M;}else{m=arguments;}m=m||[];function n(v){v=parseInt(v,10);return isNaN(v)?0:v;}M=n(m[0]);i=n(m[1]);d=n(m[2]);s=String(m[3]||"");this.toString=function(){return M+"."+i+"."+d+s;};this.getMajor=function(){return M;};this.getMinor=function(){return i;};this.getPatch=function(){return d;};this.getSuffix=function(){return s;};this.compareTo=function(){var o=V.apply(a,arguments);return M-o.getMajor()||i-o.getMinor()||d-o.getPatch()||((s<o.getSuffix())?-1:(s===o.getSuffix())?0:1);};}V.prototype.inRange=function(m,M){return this.compareTo(m)>=0&&this.compareTo(M)<0;};var J=V(q.fn.jquery);if(!J.inRange("1.10.1","2.2.4")){b("error","SAPUI5 requires a jQuery version of 1.10 or higher, but lower than 2.2.4; current version is "+q.fn.jquery);}if(!q.browser){q.browser=(function(d){var r=/(webkit)[ \/]([\w.]+)/,i=/(opera)(?:.*version)?[ \/]([\w.]+)/,j=/(msie) ([\w.]+)/,l=/(mozilla)(?:.*? rv:([\w.]+))?/,d=d.toLowerCase(),m=r.exec(d)||i.exec(d)||j.exec(d)||d.indexOf("compatible")<0&&l.exec(d)||[],n={};if(m[1]){n[m[1]]=true;n.version=m[2]||"0";if(n.webkit){n.safari=true;}}return n;}(a.navigator.userAgent));}if(D.browser.msie){q.support=q.support||{};q.support.cors=true;if(a.ActiveXObject!==undefined&&J.inRange("1.11","2")){var C=function(){try{return new XMLHttpRequest();}catch(e){}};var g=function(){try{return new ActiveXObject("Microsoft.XMLHTTP");}catch(e){}};q.ajaxSettings=q.ajaxSettings||{};q.ajaxSettings.xhr=function(){return!this.isLocal?C():g();};}}var h=(function(){var T,U,r,d=/^(.*\/)?download\/configurator[\/\?]/,i=/^(.*\/)?(sap-ui-(core|custom|boot|merged)(-.*)?)\.js([?#]|$)/,j=/^(.*\/)?resources\//;q("script[src]").each(function(){var s=this.getAttribute("src"),m;if((m=s.match(d))!==null){T=this;U=s;r=(m[1]||"")+"resources/";return false;}else if((m=s.match(i))!==null){T=this;U=s;r=m[1]||"";return false;}else if(this.id=='sap-ui-bootstrap'&&(m=s.match(j))){T=this;U=s;r=m[0];return false;}});return{tag:T,url:U,resourceRoot:r};})();(function(){if(/sap-bootstrap-debug=(true|x|X)/.test(location.search)){debugger;}var r;try{r=a.localStorage.getItem("sap-ui-reboot-URL");a.localStorage.removeItem("sap-ui-reboot-URL");}catch(e){}if(r&&r!=="undefined"){var U=confirm("WARNING!\n\nUI5 will be booted from the URL below.\nPress 'Cancel' unless you have configured this.\n\n"+r);if(U){var s=h.tag,d="<script src=\""+r+"\"";q.each(s.attributes,function(i,o){if(o.nodeName.indexOf("data-sap-ui-")==0){d+=" "+o.nodeName+"=\""+o.nodeValue.replace(/"/g,"&quot;")+"\"";}});d+="></script>";s.parentNode.removeChild(s);q("#sap-ui-bootstrap-cachebusted").remove();a["sap-ui-config"]&&a["sap-ui-config"].resourceRoots&&(a["sap-ui-config"].resourceRoots[""]=undefined);document.write(d);var R=new Error("This is not a real error. Aborting UI5 bootstrap and rebooting from: "+r);R.name="Restart";throw R;}}})();(function(){var U=/(?:^|\?|&)sap-ui-debug=([^&]*)(?:&|$)/.exec(location.search),d=(U&&U[1])||'';try{d=d||a.localStorage.getItem("sap-ui-debug");}catch(e){}if(/^(?:false|true|x|X)$/.test(d)){d=d!=='false';}a["sap-ui-debug"]=d;if(/-dbg\.js([?#]|$)/.test(h.url)){a["sap-ui-loaddbg"]=true;a["sap-ui-debug"]=d=d||true;}if(a["sap-ui-optimized"]&&d){a["sap-ui-loaddbg"]=true;if(d===true){var s=h.url.replace(/\/(?:sap-ui-cachebuster\/)?([^\/]+)\.js/,"/$1-dbg.js");a["sap-ui-optimized"]=false;document.write("<script type=\"text/javascript\" src=\""+s+"\"></script>");var r=new Error("Aborting UI5 bootstrap and restarting from: "+s);r.name="Restart";throw r;}}})();var k=a["sap-ui-config"]=(function(){function n(o){q.each(o,function(i,v){var m=i.toLowerCase();if(!o.hasOwnProperty(m)){o[m]=v;delete o[i];}});return o;}var s=h.tag,d=a["sap-ui-config"],j="sap-ui-config.json";if(typeof d==="string"){b("warning","Loading external bootstrap configuration from \""+d+"\". This is a design time feature and not for productive usage!");if(d!==j){b("warning","The external bootstrap configuration file should be named \""+j+"\"!");}q.ajax({url:d,dataType:'json',async:false,success:function(o,T,i){d=o;},error:function(i,T,o){b("error","Loading externalized bootstrap configuration from \""+d+"\" failed! Reason: "+o+"!");d=undefined;}});d=d||{};d.__loaded=true;}d=n(d||{});d.resourceroots=d.resourceroots||{};d.themeroots=d.themeroots||{};d.resourceroots['']=d.resourceroots['']||h.resourceRoot;d['xx-loadallmode']=/(^|\/)(sap-?ui5|[^\/]+-all).js([?#]|$)/.test(h.url);if(s){var l=s.getAttribute("data-sap-ui-config");if(l){try{q.extend(d,n((new Function("return {"+l+"};"))()));}catch(e){b("error","failed to parse data-sap-ui-config attribute: "+(e.message||e));}}q.each(s.attributes,function(i,o){var m=o.name.match(/^data-sap-ui-(.*)$/);if(m){m=m[1].toLowerCase();if(m==='resourceroots'){q.extend(d[m],q.parseJSON(o.value));}else if(m==='theme-roots'){q.extend(d.themeroots,q.parseJSON(o.value));}else if(m!=='config'){d[m]=o.value;}}});}return d;}());var p=0;if(k['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(a.location.search)){p=1;}if(k['xx-nosync']===true||k['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(a.location.search)){p=2;}if(p&&k.__loaded){b(p===1?"warning":"error","[nosync]: configuration loaded via sync XHR");}if(k.noconflict===true||k.noconflict==="true"||k.noconflict==="x"){q.noConflict();}q.sap={};q.sap.Version=V;q.sap.now=!(a.performance&&performance.now&&performance.timing)?Date.now:(function(){var n=performance.timing.navigationStart;return function perfnow(){return n+performance.now();};}());function t(d,i,j){return a.localStorage?function(v){try{if(v!=null||i==='string'){if(v){localStorage.setItem(d,i==='boolean'?'X':v);}else{localStorage.removeItem(d);}j(v);}v=localStorage.getItem(d);return i==='boolean'?v==='X':v;}catch(e){q.sap.log.warning("Could not access localStorage while setting '"+d+"' to '"+v+"' (are cookies disabled?): "+e.message);}}:q.noop;}q.sap.debug=t('sap-ui-debug','',function reloadHint(d){alert("Usage of debug sources is "+(d?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.");});q.sap.setReboot=t('sap-ui-reboot-URL','string',function rebootUrlHint(r){if(r){alert("Next time this app is launched (only once), it will load UI5 from:\n"+r+".\nPlease reload the application page now.");}});q.sap.statistics=t('sap-ui-statistics','boolean',function gatewayStatsHint(U){alert("Usage of Gateway statistics "+(U?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.");});(function(){var d=0,j=1,W=2,l=3,n=4,T=5,s=(a.top==a)?"":"["+a.location.pathname.split('/').slice(-1)[0]+"] ",L=[],M={'':j},o=null;function r(i,w){return("000"+String(i)).slice(-w);}function K(i){return(!i||isNaN(M[i]))?M['']:M[i];}function N(){if(!o){o={listeners:[],onLogEntry:function(m){for(var i=0;i<o.listeners.length;i++){if(o.listeners[i].onLogEntry){o.listeners[i].onLogEntry(m);}}},attach:function(i,m){if(m){o.listeners.push(m);if(m.onAttachToLog){m.onAttachToLog(i);}}},detach:function(m,v){for(var i=0;i<o.listeners.length;i++){if(o.listeners[i]===v){if(v.onDetachFromLog){v.onDetachFromLog(m);}o.listeners.splice(i,1);return;}}}};}return o;}function O(i,m,v,w){if(i<=K(w)){var R=q.sap.now(),U=new Date(R),X=Math.floor((R-Math.floor(R))*1000),Y={time:r(U.getHours(),2)+":"+r(U.getMinutes(),2)+":"+r(U.getSeconds(),2)+"."+r(U.getMilliseconds(),3)+r(X,3),date:r(U.getFullYear(),4)+"-"+r(U.getMonth()+1,2)+"-"+r(U.getDate(),2),timestamp:R,level:i,message:String(m||""),details:String(v||""),component:String(w||"")};L.push(Y);if(o){o.onLogEntry(Y);}if(a.console){var Z=Y.date+" "+Y.time+" "+s+Y.message+" - "+Y.details+" "+Y.component;switch(i){case d:case j:console.error(Z);break;case W:console.warn(Z);break;case l:console.info?console.info(Z):console.log(Z);break;case n:console.debug?console.debug(Z):console.log(Z);break;case T:console.trace?console.trace(Z):console.log(Z);break;}}return Y;}}function Q(i){this.fatal=function(m,v,w){O(d,m,v,w||i);return this;};this.error=function error(m,v,w){O(j,m,v,w||i);return this;};this.warning=function warning(m,v,w){O(W,m,v,w||i);return this;};this.info=function info(m,v,w){O(l,m,v,w||i);return this;};this.debug=function debug(m,v,w){O(n,m,v,w||i);return this;};this.trace=function trace(m,v,w){O(T,m,v,w||i);return this;};this.setLevel=function setLevel(m,w){w=w||i||'';M[w]=m;var R=[];q.each(q.sap.log.LogLevel,function(U,v){R[v]=U;});O(l,"Changing log level "+(w?"for '"+w+"' ":"")+"to "+R[m],"","jQuery.sap.log");return this;};this.getLevel=function getLevel(m){return K(m||i);};this.isLoggable=function(m,v){return(m==null?n:m)<=K(v||i);};}q.sap.log=q.extend(new Q(),{Level:{NONE:d-1,FATAL:d,ERROR:j,WARNING:W,INFO:l,DEBUG:n,TRACE:T,ALL:(T+1)},getLogger:function(i,m){if(!isNaN(m)&&M[i]==null){M[i]=m;}return new Q(i);},getLogEntries:function(){return L.slice();},addLogListener:function(o){N().attach(this,o);return this;},removeLogListener:function(o){N().detach(this,o);return this;}});q.sap.log.LogLevel=q.sap.log.Level;q.sap.log.getLog=q.sap.log.getLogEntries;q.sap.assert=function(R,m){if(!R){var i=typeof m==="function"?m():m;if(a.console&&console.assert){console.assert(R,s+i);}else{q.sap.log.debug("[Assertions] "+i);}}};k.loglevel=(function(){var m=/(?:\?|&)sap-ui-log(?:L|-l)evel=([^&]*)/.exec(a.location.search);return m&&m[1];}())||k.loglevel;if(k.loglevel){q.sap.log.setLevel(q.sap.log.Level[k.loglevel.toUpperCase()]||parseInt(k.loglevel,10));}q.sap.log.info("SAP Logger started.");q.each(_,function(i,e){q.sap.log[e.level](e.message);});_=null;}());q.sap.factory=function factory(o){function d(){}d.prototype=o;return d;};q.sap.newObject=function newObject(o){return new(q.sap.factory(o))();};q.sap.getter=function getter(v){return function(){return v;};};q.sap.getObject=function getObject(n,N,o){var O=o||a,d=(n||"").split("."),l=d.length,j=isNaN(N)?0:l-N,i;if(p&&o===a){q.sap.log.error("[nosync] getObject called to retrieve global name '"+n+"'");}for(i=0;O&&i<l;i++){if(!O[d[i]]&&i<j){O[d[i]]={};}O=O[d[i]];}return O;};q.sap.setObject=function(n,v,o){var O=o||a,N=(n||"").split("."),l=N.length,i;if(l>0){for(i=0;O&&i<l-1;i++){if(!O[N[i]]){O[N[i]]={};}O=O[N[i]];}O[N[l-1]]=v;}};function P(){function M(i,l,U,W,X){this.id=i;this.info=l;this.start=U;this.end=W;this.pause=0;this.resume=0;this.duration=0;this.time=0;this.categories=X;this.average=false;this.count=0;this.completeDuration=0;}function m(l){if(!r){return true;}if(!l){return r===null;}for(var i=0;i<r.length;i++){if(l.indexOf(r[i])>-1){return true;}}return false;}function d(i){if(!i){i=["javascript"];}i=typeof i==="string"?i.split(","):i;if(!m(i)){return null;}return i;}function j(l,U){for(var i=0;i<U.length;i++){if(l.categories.indexOf(U[i])>-1){return true;}}return U.length===0;}var n=false,o=q.ajax,r=null,s=[],O=[],v={},w={};this.getActive=function(){return n;};this.setActive=function(i,l){if(!l){l=null;}else if(typeof l==="string"){l=l.split(",");}r=l;if(n===i){return;}n=i;if(n){for(var T in v){this[T]=v[T];}v={};q.ajax=function(U,W){if(typeof U==='object'){W=U;U=undefined;}W=W||{};var X=new URI(U||W.url).absoluteTo(document.location.origin+document.location.pathname).href();q.sap.measure.start(X,"Request for "+X,"xmlhttprequest");var Y=W.complete;W.complete=function(){q.sap.measure.end(X);if(Y){Y.apply(this,arguments);}};return o.call(this,U,W);};}else if(o){q.ajax=o;}return n;};v["start"]=function(i,l,U){if(!n){return;}U=d(U);if(!U){return;}var W=q.sap.now(),X=new M(i,l,W,0,U);if(q.sap.log.getLevel("sap.ui.Performance")>=4&&a.console&&console.time){console.time(l+" - "+i);}if(X){w[i]=X;return this.getMeasurement(X.id);}else{return false;}};v["pause"]=function(i){if(!n){return;}var l=q.sap.now();var U=w[i];if(U&&U.end>0){return false;}if(U&&U.pause==0){U.pause=l;if(U.pause>=U.resume&&U.resume>0){U.duration=U.duration+U.pause-U.resume;U.resume=0;}else if(U.pause>=U.start){U.duration=U.pause-U.start;}}if(U){return this.getMeasurement(U.id);}else{return false;}};v["resume"]=function(i){if(!n){return;}var l=q.sap.now();var U=w[i];if(U&&U.pause>0){U.pause=0;U.resume=l;}if(U){return this.getMeasurement(U.id);}else{return false;}};v["end"]=function(i){if(!n){return;}var l=q.sap.now();var U=w[i];if(U&&!U.end){U.end=l;if(U.end>=U.resume&&U.resume>0){U.duration=U.duration+U.end-U.resume;U.resume=0;}else if(U.pause>0){U.pause=0;}else if(U.end>=U.start){if(U.average){U.completeDuration+=(U.end-U.start);U.count++;U.duration=U.completeDuration/U.count;U.start=l;}else{U.duration=U.end-U.start;}}if(U.end>=U.start){U.time=U.end-U.start;}}if(U){if(q.sap.log.getLevel("sap.ui.Performance")>=4&&a.console&&console.timeEnd){console.timeEnd(U.info+" - "+i);}return this.getMeasurement(i);}else{return false;}};v["clear"]=function(){w={};};v["remove"]=function(i){delete w[i];};v["add"]=function(i,l,U,W,X,Y,Z){if(!n){return;}Z=d(Z);if(!Z){return false;}var $=new M(i,l,U,W,Z);$.time=X;$.duration=Y;if($){w[i]=$;return this.getMeasurement($.id);}else{return false;}};v["average"]=function(i,l,U){if(!n){return;}U=d(U);if(!U){return;}var W=w[i],X=q.sap.now();if(!W||!W.average){this.start(i,l,U);W=w[i];W.average=true;}else{if(!W.end){W.completeDuration+=(X-W.start);W.count++;}W.start=X;W.end=0;}return this.getMeasurement(W.id);};this.getMeasurement=function(i){var l=w[i];if(l){var U={};for(var W in l){U[W]=l[W];}return U;}else{return false;}};this.getAllMeasurements=function(i){return this.filterMeasurements(function(l){return l;},i);};this.filterMeasurements=function(){var l,U,i=0,W=[],X=typeof arguments[i]==="function"?arguments[i++]:undefined,Y=typeof arguments[i]==="boolean"?arguments[i++]:undefined,Z=Array.isArray(arguments[i])?arguments[i]:[];for(var $ in w){l=this.getMeasurement($);U=(Y===false&&l.end===0)||(Y!==false&&(!Y||l.end));if(U&&j(l,Z)&&(!X||X(l))){W.push(l);}}return W;};this.registerMethod=function(i,l,U,W){var X=l[U];if(X&&typeof X==="function"){var Y=s.indexOf(X)>-1;if(!Y){O.push({func:X,obj:l,method:U,id:i});l[U]=function(){q.sap.measure.average(i,i+" method average",W);var Z=X.apply(this,arguments);q.sap.measure.end(i);return Z;};s.push(l[U]);return true;}}else{q.sap.log.debug(U+" in not a function. jQuery.sap.measure.register failed");}return false;};this.unregisterMethod=function(i,l,U){var W=l[U],X=s.indexOf(W);if(W&&X>-1){l[U]=O[X].func;s.splice(X,1);O.splice(X,1);return true;}return false;};this.unregisterAllMethods=function(){while(O.length>0){var i=O[0];this.unregisterMethod(i.id,i.obj,i.method);}};var K=[];var L;this.getAllInteractionMeasurements=function(i){if(i){q.sap.measure.endInteraction(true);}return K;};this.filterInteractionMeasurements=function(U){var W=[];if(U){for(var i=0,l=K.length;i<l;i++){if(U(K[i])){W.push(K[i]);}}}return W;};this.getPendingInteractionMeasurement=function(){return L;};this.clearInteractionMeasurements=function(){K=[];};function N(i){if(L){L.end=i;L.duration=L.processing;L.requests=q.sap.measure.getRequestTimings();L.measurements=q.sap.measure.filterMeasurements(function($){return($.start>L.start&&$.end<L.end)?$:null;},true);if(L.requests.length>0){var l=L.requests[0].startTime,U=L.requests[0].startTime,W=L.requests[0].requestStart,X=L.requests[0].requestStart,Y=L.requests[0].responseEnd;L.requests.forEach(function($){l=$.responseEnd>l?$.responseEnd:l;L.requestTime+=($.responseEnd-$.startTime);if(Y<$.startTime){L.navigation+=(W-U);L.roundtrip+=(Y-X);U=$.startTime;X=$.requestStart;}if($.responseEnd>Y){W=$.requestStart;Y=$.responseEnd;}});L.navigation+=W-U;L.roundtrip+=Y-X;L.networkTime=L.networkTime?((L.requestTime-L.networkTime)/L.requests.length):0;if(L.duration===0){L.duration=L.navigation+L.roundtrip;}}if(L.processing!==0){var Z=L.processing-L.navigation-L.roundtrip;L.processing=Z>0?Z:0;}K.push(L);q.sap.log.info("Interaction step finished: trigger: "+L.trigger+"; duration: "+L.duration+"; requests: "+L.requests.length,"jQuery.sap.measure");L=null;}}this.startInteraction=function(i,l){function U(l){var Y,Z;if(l){var $,a1;$=sap.ui.require("sap/ui/core/Component");while($&&l&&l.getParent){a1=$.getOwnerComponentFor(l);if(a1||l instanceof $){a1=a1||l;var b1=a1.getManifestEntry("sap.app");Y=b1&&b1.id||a1.getMetadata().getName();Z=b1&&b1.applicationVersion&&b1.applicationVersion.version;}l=l.getParent();}}return{id:Y?Y:"undetermined",version:Z?Z:""};}var W=q.sap.now();if(L){N(W);}this.clearRequestTimings();var X=U(l);L={event:i,trigger:l&&l.getId?l.getId():"undetermined",component:X.id,appVersion:X.version,start:W,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:undefined,busyDuration:0};q.sap.log.info("Interaction step started: trigger: "+L.trigger+"; type: "+L.event,"jQuery.sap.measure");};this.endInteraction=function(i){if(L){if(!i){L.processing=q.sap.now()-L.start;}else{N(q.sap.now());}}};this.setRequestBufferSize=function(i){if(!a.performance){return;}if(a.performance.setResourceTimingBufferSize){a.performance.setResourceTimingBufferSize(i);}else if(a.performance.webkitSetResourceTimingBufferSize){a.performance.webkitSetResourceTimingBufferSize(i);}};this.getRequestTimings=function(){if(a.performance&&a.performance.getEntriesByType){return a.performance.getEntriesByType("resource");}return[];};this.clearRequestTimings=function(){if(!a.performance){return;}if(a.performance.clearResourceTimings){a.performance.clearResourceTimings();}else if(a.performance.webkitClearResourceTimings){a.performance.webkitClearResourceTimings();}};this.setRequestBufferSize(1000);var Q=location.search.match(/sap-ui-measure=([^\&]*)/);if(Q&&Q[1]){if(Q[1]==="true"||Q[1]==="x"||Q[1]==="X"){this.setActive(true);}else{this.setActive(true,Q[1]);}}else{var R=function(){return null;};for(var T in v){this[T]=R;}}}q.sap.measure=new P();function S(n,d,T){var i=[],o=0,j=0,s;this.startTask=function(m){var r=i.length;i[r]={name:m,finished:false};o++;return r;};this.finishTask=function(m,r){if(!i[m]||i[m].finished){throw new Error("trying to finish non existing or already finished task");}i[m].finished=true;o--;if(r===false){j++;}if(o===0){q.sap.log.info("Sync point '"+n+"' finished (tasks:"+i.length+", open:"+o+", failures:"+j+")");if(s){clearTimeout(s);s=null;}l();}};function l(){d&&d(o,j);d=null;}if(!isNaN(T)){s=setTimeout(function(){q.sap.log.info("Sync point '"+n+"' timed out (tasks:"+i.length+", open:"+o+", failures:"+j+")");l();},T);}q.sap.log.info("Sync point '"+n+"' created"+(T?"(timeout after "+T+" ms)":""));}q.sap.syncPoint=function(n,d,T){return new S(n,d,T);};var u=(function(){var o=q.sap.log.getLogger("sap.ui.ModuleSystem",(/sap-ui-xx-debug(M|-m)odule(L|-l)oading=(true|x|X)/.test(location.search)||k["xx-debugModuleLoading"])?q.sap.log.Level.DEBUG:q.sap.log.Level.INFO),U={'':{'url':'resources/'}},r=0,v=-1,L=1,w=2,K=3,R=4,M=5,N={},O={},Q={},T={'sap/ui/thirdparty/blanket.js':{amd:true,exports:'blanket'},'sap/ui/thirdparty/caja-html-sanitizer.js':{amd:false,exports:'html'},'sap/ui/thirdparty/crossroads.js':{amd:true,exports:'crossroads',deps:['sap/ui/thirdparty/signals']},'sap/ui/thirdparty/d3.js':{amd:true,exports:'d3'},'sap/ui/thirdparty/datajs.js':{amd:true,exports:'OData'},'sap/ui/thirdparty/es6-promise.js':{amd:true,exports:'ES6Promise'},'sap/ui/thirdparty/flexie.js':{exports:'Flexie'},'sap/ui/thirdparty/handlebars.js':{amd:true,exports:'Handlebars'},'sap/ui/thirdparty/hasher.js':{amd:true,exports:'hasher',deps:['sap/ui/thirdparty/signals']},'sap/ui/thirdparty/IPv6.js':{amd:true,exports:'IPv6'},'sap/ui/thirdparty/iscroll-lite.js':{exports:'iScroll'},'sap/ui/thirdparty/iscroll.js':{exports:'iScroll'},'sap/ui/thirdparty/jquery.js':{amd:true},'sap/ui/thirdparty/jquery/jquery-1.10.1.js':{amd:true},'sap/ui/thirdparty/jquery/jquery-1.10.2.js':{amd:true},'sap/ui/thirdparty/jquery/jquery-1.11.1.js':{amd:true},'sap/ui/thirdparty/jquery/jquery-2.1.4.js':{amd:true},'sap/ui/thirdparty/jquery/jquery-2.2.1.js':{amd:true},'sap/ui/thirdparty/jquery-mobile-custom.js':{amd:true,exports:'jQuery.mobile'},'sap/ui/thirdparty/jszip.js':{amd:true,exports:'JSZip'},'sap/ui/thirdparty/less.js':{amd:true,exports:'less'},'sap/ui/thirdparty/mobify-carousel.js':{exports:'Mobify'},'sap/ui/thirdparty/punycode.js':{amd:true,exports:'punycode'},'sap/ui/thirdparty/require.js':{exports:'define'},'sap/ui/thirdparty/SecondLevelDomains.js':{amd:true,exports:'SecondLevelDomains'},'sap/ui/thirdparty/signals.js':{amd:true,exports:'signals'},'sap/ui/thirdparty/sinon.js':{amd:true,exports:'sinon'},'sap/ui/thirdparty/sinon-server.js':{amd:true,exports:'sinon'},'sap/ui/thirdparty/unorm.js':{exports:'UNorm'},'sap/ui/thirdparty/unormdata.js':{exports:'UNorm',deps:['sap/ui/thirdparty/unorm']},'sap/ui/thirdparty/URI.js':{amd:true,exports:'URI'},'sap/ui/thirdparty/URITemplate.js':{amd:true,exports:'URITemplate',deps:['sap/ui/thirdparty/URI']},'sap/ui/thirdparty/vkbeautify.js':{exports:'vkbeautify'},'sap/ui/thirdparty/zyngascroll.js':{exports:'Scroller'},'sap/ui/demokit/js/esprima.js':{amd:true,exports:'esprima'}},W=[],X="",Y=512*1024,Z=document.location.href.replace(/\?.*|#.*/g,""),$="fragment",a1="view",b1={js:[a1,$,"controller","designtime"],xml:[a1,$],json:[a1,$],html:[a1,$]},c1=new RegExp("(\\.(?:"+b1.js.join("|")+"))?\\.js$"),d1,e1;(function(){var s="",d="";q.each(b1,function(i,j){s=(s?s+"|":"")+i;d=(d?d+"|":"")+"(?:(?:"+j.join("\\.|")+"\\.)?"+i+")";});s="\\.("+s+")$";d="\\.(?:"+d+"|[^./]+)$";o.debug("constructed regexp for file types :"+s);o.debug("constructed regexp for file sub-types :"+d);d1=new RegExp(s);e1=new RegExp(d);}());var f1;(function(){var d=a["sap-ui-debug"];function m(j){if(!/\/\*\*\/$/.test(j)){j=j.replace(/\/$/,'/**/');}return j.replace(/\*\*\/|\*|[[\]{}()+?.\\^$|]/g,function(l){switch(l){case'**/':return'(?:[^/]+/)*';case'*':return'[^/]*';default:return'\\'+l;}});}if(typeof d==='string'){var s="^(?:"+d.split(/,/).map(m).join("|")+")",i=new RegExp(s);f1=function(j){return i.test(j);};o.debug("Modules that should be excluded from preload: '"+s+"'");}})();function g1(d){this.name=d;this.state=r;this.url=this.data=this.group=null;this.content=N;}g1.prototype.ready=function(d,i){if(this.state===r){this.state=R;this.url=d;this.content=i;}return this;};g1.prototype.preload=function(d,i,j){if(this.state===r&&!(f1&&f1(this.name))){this.state=v;this.url=d;this.data=i;this.group=j;}return this;};g1.get=function(m){return O[m]||(O[m]=new g1(m));};g1.prototype.value=function(){if(this.state===R){if(this.content===N){var s=T[this.name],d=s&&(Array.isArray(s.exports)?s.exports[0]:s.exports);this.content=q.sap.getObject(d||i1(this.name));}return this.content;}return;};g1.get("sap/ui/thirdparty/URI.js").ready(c,URI);g1.get("sap/ui/Device.js").ready(c,D);g1.get("jquery.sap.global.js").ready(c,q);function h1(s){if(/^sap\.ui\.thirdparty\.jquery\.jquery-/.test(s)){return"sap/ui/thirdparty/jquery/jquery-"+s.slice("sap.ui.thirdparty.jquery.jquery-".length);}else if(/^jquery\.sap\./.test(s)){return s;}return s.replace(/\./g,"/");}function i1(s){if(!/\.js$/.test(s)){return;}s=s.slice(0,-3);if(/^sap\/ui\/thirdparty\/jquery\/jquery-/.test(s)){return"sap.ui.thirdparty.jquery.jquery-"+s.slice("sap/ui/thirdparty/jquery/jquery-".length);}else if(/^jquery\.sap\./.test(s)){return s;}return s.replace(/\//g,".");}function j1(s,d){var i=s.split(/\//),l,j,u1,m;if(arguments.length===1&&i.length>0){m=e1.exec(i[i.length-1]);if(m){d=m[0];i[i.length-1]=i[i.length-1].slice(0,m.index);}else{d="";}}for(l=i.length;l>=0;l--){j=i.slice(0,l).join('/');if(U[j]){u1=U[j].url;if(l<i.length){u1+=i.slice(l).join('/');}if(u1.slice(-1)==='/'){u1=u1.slice(0,-1);}return u1+(d||'');}}}function k1(s){var d,i,j;for(d in U){if(U.hasOwnProperty(d)){i=U[d].url.slice(0,-1);if(s.indexOf(i)===0){j=d+s.slice(i.length);if(j.charAt(0)==='/'){j=j.slice(1);}if(O[j]&&O[j].data){return j;}}}}}function l1(d){if(!d.stack){try{throw d;}catch(i){return i.stack;}}return d.stack;}function m1(d,i){if(!D.browser.phantomJS){var j=l1(d);if(j&&i){d.stack=j+"\nCaused by: "+i;}}if(a.console&&!D.browser.chrome){console.error(d.message+"\nCaused by: "+i);}}var n1=/(?:^|\/)\.+/;var o1=/^\.*$/;function p1(s,d){var m=n1.exec(d),u1,v1,i,j,l;if(!m){return d;}if(m.index===0&&s==null){throw new Error("relative name not supported ('"+d+"'");}u1=(m.index===0?s+d:d).split('/');for(i=0,j=0,l=u1.length;i<l;i++){var v1=u1[i];if(o1.test(v1)){if(v1==='.'||v1===''){continue;}else if(v1==='..'){if(j===0){throw new Error("Can't navigate to parent of root (base='"+s+"', name='"+d+"'");}j--;}else{throw new Error("illegal path segment '"+v1+"'");}}else{u1[j++]=v1;}}u1.length=j;return u1.join('/');}function q1(m){var d;d=g1.get(m);if(d.state>r){return d;}if(o.isLoggable()){o.debug(X+"declare module '"+m+"'");}d.state=R;if(W.length===0){W.push(m);d.url=d.url||c;}return d;}function r1(s,d){var l=o.isLoggable(),m=c1.exec(s),j=T[s],u1,v1,w1,x1,i,y1;if(!m){o.error("can only require Javascript module, not "+s);return;}if(j&&j.deps){if(l){o.debug("require dependencies of raw module "+s);}for(i=0;i<j.deps.length;i++){if(l){o.debug("  require "+j.deps[i]);}r1(j.deps[i]+'.js',d);}}u1=s.slice(0,m.index);v1=m[0];w1=g1.get(s);if(l){o.debug(X+"require '"+s+"' of type '"+v1+"'");}if(w1.state!==r){if(w1.state===v){w1.state=w;q.sap.measure.start(s,"Require module "+s+" (preloaded)",["require"]);s1(s);q.sap.measure.end(s);}if(w1.state===R){if(l){o.debug(X+"module '"+s+"' has already been loaded (skipped).");}return w1.value();}else if(w1.state===M){var z1=new Error("found in negative cache: '"+s+"' from "+w1.url+": "+w1.errorMessage);m1(z1,w1.errorStack);throw z1;}else{return;}}q.sap.measure.start(s,"Require module "+s,["require"]);w1.state=L;x1=a["sap-ui-loaddbg"]?["-dbg",""]:[""];for(i=0;i<x1.length&&w1.state!==w;i++){w1.url=j1(u1,x1[i]+v1);if(l){o.debug(X+"loading "+(x1[i]?x1[i]+" version of ":"")+"'"+s+"' from '"+w1.url+"'");}if(d&&p&&s!=='sap/ui/core/Core.js'){y1="[nosync] loading module '"+w1.url+"'";if(p===1){o.error(y1);}else{throw new Error(y1);}}q.ajax({url:w1.url,dataType:'text',async:false,success:function(A1,B1,C1){w1.state=w;w1.data=A1;},error:function(A1,B1,C1){w1.state=M;w1.errorMessage=A1?A1.status+" - "+A1.statusText:B1;w1.errorStack=C1&&C1.stack;}});}if(w1.state===w){s1(s);}q.sap.measure.end(s);if(w1.state!==R){var z1=new Error("failed to load '"+s+"' from "+w1.url+": "+w1.errorMessage);m1(z1,w1.errorStack);throw z1;}return w1.value();}function callPreloadWrapperFn(fn){callPreloadWrapperFn.count++;return fn.call(a);}callPreloadWrapperFn.count=0;function applyAMDFactoryFn(fn,dep){applyAMDFactoryFn.count++;return fn.apply(a,dep);}applyAMDFactoryFn.count=0;function s1(m){var d=O[m],s=T[m],l=o.isLoggable(),i,j,u1;if(d&&d.state===w&&typeof d.data!=="undefined"){u1=(s===true||(s&&s.amd))&&typeof a.define==="function"&&a.define.amd;try{if(u1){delete a.define.amd;}if(l){o.debug(X+"executing '"+m+"'");i=X;X=X+": ";}d.state=K;W.push(m);if(typeof d.data==="function"){callPreloadWrapperFn(d.data);}else if(Array.isArray(d.data)){sap.ui.define.apply(sap.ui,d.data);}else{j=d.data;if(j&&!j.match(/\/\/[#@] source(Mapping)?URL=.*$/)){j+="\n//# sourceURL="+URI(d.url).absoluteTo(Z);if(D.browser.safari){j+="?";}}if(typeof q.sap.require._hook==="function"){j=q.sap.require._hook(j,m);}if(a.execScript&&(!d.data||d.data.length<Y)){try{d.data&&a.execScript(j);}catch(e){W.pop();q.sap.globalEval(d.data);throw e;}}else{a.eval(j);}}W.pop();d.state=R;d.data=undefined;d.value();if(l){X=i;o.debug(X+"finished executing '"+m+"'");}}catch(v1){d.state=M;d.errorStack=v1&&v1.stack;d.errorMessage=((v1.toString&&v1.toString())||v1.message)+(v1.line?"(line "+v1.line+")":"");d.data=undefined;if(a["sap-ui-debug"]&&(/sap-ui-xx-show(L|-l)oad(E|-e)rrors=(true|x|X)/.test(location.search)||k["xx-showloaderrors"])){o.error("error while evaluating "+m+", embedding again via script tag to enforce a stack trace (see below)");q.sap.includeScript(d.url);return;}}finally{if(u1){a.define.amd=u1;}}}}function t1(s,d,j){var m=[],l=o.isLoggable(),i,u1;for(i=0;i<d.length;i++){u1=p1(s,d[i]);if(l){o.debug(X+"require '"+u1+"'");}m[i]=r1(u1+".js");if(l){o.debug(X+"require '"+u1+"': done.");}}j(m);}q.sap.getModulePath=function(m,s){return j1(h1(m),s);};q.sap.getResourcePath=j1;q.sap.registerModulePath=function registerModulePath(m,d){m=m.replace(/\./g,"/");d=d||'.';q.sap.registerResourcePath(m,d);};q.sap.registerResourcePath=function registerResourcePath(s,d){s=String(s||"");if(U[s]&&U[s]["final"]==true){o.warning("registerResourcePath with prefix "+s+" already set as final to '"+U[s].url+"'. This call is ignored.");return;}if(typeof d==='string'||d instanceof String){d={'url':d};}if(!d||d.url==null){delete U[s];o.info("registerResourcePath ('"+s+"') (registration removed)");}else{d.url=String(d.url);var i=d.url.search(/[?#]/);if(i!==-1){d.url=d.url.slice(0,i);}if(d.url.slice(-1)!='/'){d.url+='/';}U[s]=d;o.info("registerResourcePath ('"+s+"', '"+d.url+"')"+((d['final'])?" (final)":""));}};q.sap.registerModuleShims=function(s){for(var d in s){var i=s[d];if(Array.isArray(i)){i={deps:i};}T[d+".js"]=i;}};q.sap.isDeclared=function isDeclared(m,i){m=h1(m)+".js";return O[m]&&(i||O[m].state!==v);};q.sap.getAllDeclaredModules=function(){var m=[];q.each(O,function(s,d){if(d&&d.state!==v){var i=i1(s);if(i){m.push(i);}}});return m;};if(k.resourceroots){q.each(k.resourceroots,q.sap.registerModulePath);}o.info("URL prefixes set to:");for(var n in U){o.info("  "+(n?"'"+n+"'":"(default)")+" : "+U[n].url+((U[n]['final'])?" (final)":""));}q.sap.declare=function(m,d){var s=m;if(typeof(m)==="object"){s=m.modName;m=h1(m.modName)+(m.type?"."+m.type:"")+".js";}else{m=h1(m)+".js";}q1(m);if(d!==false){q.sap.getObject(s,1);}};q.sap.require=function(m){if(arguments.length>1){for(var i=0;i<arguments.length;i++){q.sap.require(arguments[i]);}return this;}if(typeof(m)==="object"){m=h1(m.modName)+(m.type?"."+m.type:"")+".js";}else{m=h1(m)+".js";}r1(m,true);};a.sap=a.sap||{};sap.ui=sap.ui||{};sap.ui.define=function(m,d,i,j){var l=o.isLoggable(),s,u1;if(typeof m==='string'){s=m+'.js';}else{j=i;i=d;d=m;s=W[W.length-1];}m=i1(s);u1=s.slice(0,s.lastIndexOf('/')+1);if(!Array.isArray(d)){j=i;i=d;d=[];}if(l){o.debug("define("+s+", "+"['"+d.join("','")+"']"+")");}var v1=q1(s);v1.content=undefined;t1(u1,d,function(w1){if(l){o.debug("define("+s+"): calling factory "+typeof i);}if(j&&p!==2){var x1=s.split('/').slice(0,-1).join('.');if(x1){q.sap.getObject(x1,0);}}if(typeof i==='function'){v1.content=applyAMDFactoryFn(i,w1);}else{v1.content=i;}if(j&&p!==2){if(v1.content==null){o.error("module '"+s+"' returned no content, but should be exported");}else{if(l){o.debug("exporting content of '"+s+"': as global object");}q.sap.setObject(m,v1.content);}}});};sap.ui.predefine=function(m,d,i,j){if(typeof m!=='string'){throw new Error("sap.ui.predefine requires a module name");}var s=m+'.js';g1.get(s).preload("<unknown>/"+m,[m,d,i,j],null);if(s.match(/\/library\.js$/)){Q[i1(s)+"-preload"]=true;}};sap.ui.require=function(d,i){if(typeof d==='string'){return g1.get(d+'.js').value();}t1(null,d,function(m){if(typeof i==='function'){setTimeout(function(){i.apply(a,m);},0);}});};sap.ui.requireSync=function(m){return r1(m+".js",true);};q.sap.preloadModules=function(s,d,i){var j,l,m;if(!d&&p){m="[nosync] synchronous preload of '"+s+"'";if(p===1){o.warning(m);}else{throw new Error(m);}}if(Q[s]){return;}Q[s]=true;j=q.sap.getModulePath(s,".json");o.debug("preload file "+s);l=i&&i.startTask("load "+s);q.ajax({dataType:"json",async:d,url:j,success:function(u1){if(u1){u1.url=j;}q.sap.registerPreloadedModules(u1,d,i);i&&i.finishTask(l);},error:function(u1,v1,w1){o.error("failed to preload '"+s+"': "+(w1||v1));i&&i.finishTask(l,false);}});};q.sap.registerPreloadedModules=function(d,i,s){var j=V(d.version||"1.0").compareTo("2.0")<0;if(o.isLoggable()){o.debug(X+"adding preloaded modules from '"+d.url+"'");}if(d.name){Q[d.name]=true;}q.each(d.modules,function(l,m){l=j?h1(l)+".js":l;g1.get(l).preload(d.url+"/"+l,m,d.name);if(l.match(/\/library\.js$/)){Q[i1(l)+"-preload"]=true;}});if(d.dependencies){q.each(d.dependencies,function(l,m){q.sap.preloadModules(m,i,s);});}};q.sap.unloadResources=function(s,d,j,l){var m=[];if(d==null){d=true;}if(d){q.each(O,function(i,u1){if(u1&&u1.group===s){m.push(i);}});delete Q[s];}else{if(O[s]){m.push(s);}}q.each(m,function(i,u1){var v1=O[u1];if(v1&&l&&u1.match(/\.js$/)){q.sap.setObject(i1(u1),undefined);}if(v1&&(j||v1.state===v)){delete O[u1];}});};q.sap.getResourceName=function(m,s){return h1(m)+(s||".js");};q.sap.loadResource=function(s,m){var i,j,l,u1,v1;if(typeof s==="string"){m=m||{};}else{m=s||{};s=m.name;if(!s&&m.url){s=k1(m.url);}}m=q.extend({failOnError:true,async:false},m);i=m.dataType;if(i==null&&s){i=(i=d1.exec(s))&&i[1];}v1=m.async?new q.Deferred():null;function w1(d,e){if(d==null&&m.failOnError){u1=e||new Error("no data returned for "+s);if(m.async){v1.reject(u1);q.sap.log.error(u1);}return null;}if(m.async){v1.resolve(d);}return d;}function x1(d){var y1=q.ajaxSettings.converters["text "+i];if(typeof y1==="function"){d=y1(d);}return w1(d);}if(s&&O[s]){j=O[s].data;O[s].state=w;}if(j!=null){if(m.async){setTimeout(function(){x1(j);},0);}else{j=x1(j);}}else{if(!m.async&&p){if(p>=1){o.error("[nosync] loading resource '"+(s||m.url)+"' with sync XHR");}else{throw new Error("[nosync] loading resource '"+(s||m.url)+"' with sync XHR");}}q.ajax({url:l=m.url||j1(s),async:m.async,dataType:i,headers:m.headers,success:function(d,y1,z1){j=w1(d);},error:function(d,y1,z1){u1=new Error("resource "+s+" could not be loaded from "+l+". Check for 'file not found' or parse errors. Reason: "+z1);u1.status=y1;u1.error=z1;u1.statusCode=d.status;j=w1(null,u1);}});}if(m.async){return Promise.resolve(v1);}if(u1!=null&&m.failOnError){throw u1;}return j;};q.sap._loadJSResourceAsync=function(s,i){return new Promise(function(d,j){var m=g1.get(s);var l=m.url=j1(s);m.state=L;var u1=a.document.createElement('SCRIPT');u1.src=l;u1.setAttribute("data-sap-ui-module",s);u1.addEventListener('load',function(e){q.sap.log.info("Javascript resource loaded: "+s);m.state=R;d();});u1.addEventListener('error',function(e){q.sap.log.error("failed to load Javascript resource: "+s);m.state=M;if(i){d();}else{j();}});x(u1);});};return function(){var m={};q.each(U,function(s,d){m[s]=d.url;});return{modules:O,prefixes:m};};}());function x(o){var d=a.document.getElementsByTagName("head")[0];if(d){d.appendChild(o);}}function y(U,i,l,d){var s=a.document.createElement("script");s.src=U;s.type="text/javascript";if(i){s.id=i;}if(l){q(s).load(function(){l();q(s).off("load");});}if(d){q(s).error(function(){d();q(s).off("error");});}var o;if((i&&(o=q.sap.domById(i))&&o.tagName==="SCRIPT")){q(o).remove();}x(s);}q.sap.includeScript=function includeScript(U,i,l,d){var o=typeof U==="string"?{url:U,id:i}:U;if(typeof U==="string"){y(o.url,o.id,l,d);}else{return new Promise(function(r,R){y(o.url,o.id,r,R);});}};var I;var z=q.sap._mIEStyleSheets={};function A(U,s,l,d){var j=function(U,s,l,d){var L=document.createElement("link");L.type="text/css";L.rel="stylesheet";L.href=U;if(s){L.id=s;}var i=function(){q(L).attr("data-sap-ui-ready","false").off("error");if(d){d();}};var n=function(){q(L).attr("data-sap-ui-ready","true").off("load");if(l){l();}};if(D.browser.msie){var r=n;n=function(v){var R;try{R=v.target&&v.target.sheet&&v.target.sheet.rules;}catch(w){}if(R&&R.length>0){r();}else{i();}};}q(L).load(n);q(L).error(i);return L;};var m=function(U,s,l,d){if(D.browser.msie&&D.browser.version<=9&&document.styleSheets.length>=28){var r=URI.parse(document.URL).path;var n=new URI(U).absoluteTo(r).toString();if(s){var v=z[s];if(v&&v.href===n){return;}}q.sap.log.warning("Stylesheet "+(s?s+" ":"")+"not added as LINK because of IE limits",U,"jQuery.sap.includeStyleSheet");if(!I){I=document.createStyleSheet();}var w=false;for(var i=0;i<I.imports.length;i++){var K=I.imports[i];if(K.imports.length<30){K.addImport(n);w=true;break;}}if(!w){I.addImport(n);}if(s){z[s]={href:n};}var L=document.getElementById('sap-ui-core-customcss');if(!q.isEmptyObject(L)){x(L);}}else{var M=j(U,s,l,d);if(q('#sap-ui-core-customcss').length>0){q('#sap-ui-core-customcss').first().before(q(M));}else{x(M);}}};var o=q.sap.domById(s);if(o&&o.tagName==="LINK"&&o.rel==="stylesheet"){if(l||d||o.href!==URI(String(U),URI().search("")).toString()){q(o).replaceWith(j(U,s,l,d));}}else{m(U,s,l,d);}}q.sap.includeStyleSheet=function includeStyleSheet(U,i,l,d){var o=typeof U==="string"?{url:U,id:i}:U;if(typeof U==="string"){A(o.url,o.id,l,d);}else{return new Promise(function(r,R){A(o.url,o.id,r,R);});}};if(!(k.productive===true||k.productive==="true"||k.productive==="x")){document.addEventListener('keydown',function(e){try{if(e.shiftKey&&e.altKey&&e.ctrlKey){if(e.keyCode===80){sap.ui.require(['sap/ui/debug/TechnicalInfo'],function(T){T.open(function(){var i=u();return{modules:i.modules,prefixes:i.prefixes,config:k};});});}else if(e.keyCode===83){sap.ui.require(['sap/ui/core/support/Support'],function(i){var s=i.getStub();if(s.getType()!=i.StubType.APPLICATION){return;}s.openSupportTool();});}}}catch(d){}});}if(!q.support){q.support={};}q.extend(q.support,{touch:D.support.touch});var B=["Webkit","ms","Moz"];var E=document.documentElement.style;var F=function(d,j){if(q.support[d]===undefined){if(E[j]!==undefined){q.support[d]=true;if(j==="boxFlex"||j==="flexOrder"||j==="flexGrow"){if(!D.browser.chrome||D.browser.version>28){q.support.flexBoxPrefixed=false;}}return;}else{j=j.charAt(0).toUpperCase()+j.slice(1);for(var i in B){if(E[B[i]+j]!==undefined){q.support[d]=true;return;}}}q.support[d]=false;}};F("cssTransforms","transform");F("cssTransforms3d","perspective");F("cssTransitions","transition");F("cssAnimations","animationName");if(q.support.cssGradients===undefined){var G=document.createElement('div'),E=G.style;try{E.backgroundImage="linear-gradient(left top, red, white)";E.backgroundImage="-moz-linear-gradient(left top, red, white)";E.backgroundImage="-webkit-linear-gradient(left top, red, white)";E.backgroundImage="-ms-linear-gradient(left top, red, white)";E.backgroundImage="-webkit-gradient(linear, left top, right bottom, from(red), to(white))";}catch(e){}q.support.cssGradients=(E.backgroundImage&&E.backgroundImage.indexOf("gradient")>-1);G=null;}q.support.flexBoxPrefixed=true;F("flexBoxLayout","boxFlex");F("newFlexBoxLayout","flexGrow");if(!q.support.newFlexBoxLayout&&E.msFlexOrder!==undefined){q.support.ie10FlexBoxLayout=true;}else{q.support.ie10FlexBoxLayout=false;}if(q.support.flexBoxLayout||q.support.newFlexBoxLayout||q.support.ie10FlexBoxLayout){q.support.hasFlexBoxSupport=true;}else{q.support.hasFlexBoxSupport=false;}var H=function(s){this.mSettings=s||{};this.sMode=this.mSettings.mode||H.Mode.ALLOW;this.fnCallback=this.mSettings.callback;this.iTimeout=this.mSettings.timeout||10000;this.bBlockEvents=this.mSettings.blockEvents!==false;this.bShowBlockLayer=this.mSettings.showBlockLayer!==false;this.bAllowSameOrigin=this.mSettings.allowSameOrigin!==false;this.sParentOrigin='';this.bUnlocked=false;this.bRunnable=false;this.bParentUnlocked=false;this.bParentResponded=false;this.sStatus="pending";this.aFPChilds=[];var d=this;this.iTimer=setTimeout(function(){d._callback(false);},this.iTimeout);var i=function(){d._handlePostMessage.apply(d,arguments);};H.__window.addEventListener('message',i);if(H.__parent===H.__self||H.__parent==null||this.sMode===H.Mode.ALLOW){this._applyState(true,true);}else{this._lock();if(this.sMode===H.Mode.DENY){this._callback(false);return;}if(this.bAllowSameOrigin){try{var o=H.__parent;var O=false;var T=true;do{var j=o.document.domain;if(o==H.__top){if(j!=undefined){O=true;}break;}o=o.parent;}while(T);if(O){this._applyState(true,true);}}catch(e){this._sendRequireMessage();}}else{this._sendRequireMessage();}}};H.Mode={TRUSTED:'trusted',ALLOW:'allow',DENY:'deny'};H.__window=a;H.__parent=parent;H.__self=self;H.__top=top;H._events=["mousedown","mouseup","click","dblclick","mouseover","mouseout","touchstart","touchend","touchmove","touchcancel","keydown","keypress","keyup"];H.prototype.match=function(s,d){if(!(/\*/i.test(d))){return s==d;}else{d=d.replace(/\//gi,"\\/");d=d.replace(/\./gi,"\\.");d=d.replace(/\*/gi,".*");d=d.replace(/:\.\*$/gi,":\\d*");if(d.substr(d.length-1,1)!=='$'){d=d+'$';}if(d.substr(0,1)!=='^'){d='^'+d;}var r=new RegExp(d,'i');return r.test(s);}};H._lockHandler=function(o){o.stopPropagation();o.preventDefault();};H.prototype._createBlockLayer=function(){if(document.readyState=="complete"){var l=document.createElement("div");l.style.position="absolute";l.style.top="0px";l.style.bottom="0px";l.style.left="0px";l.style.right="0px";l.style.opacity="0";l.style.backgroundColor="white";l.style.zIndex=2147483647;document.body.appendChild(l);this._lockDiv=l;}};H.prototype._setCursor=function(){if(this._lockDiv){this._lockDiv.style.cursor=this.sStatus=="denied"?"not-allowed":"wait";}};H.prototype._lock=function(){var d=this;if(this.bBlockEvents){for(var i=0;i<H._events.length;i++){document.addEventListener(H._events[i],H._lockHandler,true);}}if(this.bShowBlockLayer){this._blockLayer=function(){d._createBlockLayer();d._setCursor();};if(document.readyState=="complete"){this._blockLayer();}else{document.addEventListener("readystatechange",this._blockLayer);}}};H.prototype._unlock=function(){if(this.bBlockEvents){for(var i=0;i<H._events.length;i++){document.removeEventListener(H._events[i],H._lockHandler,true);}}if(this.bShowBlockLayer){document.removeEventListener("readystatechange",this._blockLayer);if(this._lockDiv){document.body.removeChild(this._lockDiv);delete this._lockDiv;}}};H.prototype._callback=function(s){this.sStatus=s?"allowed":"denied";this._setCursor();clearTimeout(this.iTimer);if(typeof this.fnCallback==='function'){this.fnCallback.call(null,s);}};H.prototype._applyState=function(i,d){if(this.bUnlocked){return;}if(i){this.bRunnable=true;}if(d){this.bParentUnlocked=true;}if(!this.bRunnable||!this.bParentUnlocked){return;}this._unlock();this._callback(true);this._notifyChildFrames();this.bUnlocked=true;};H.prototype._applyTrusted=function(T){if(T){this._applyState(true,false);}else{this._callback(false);}};H.prototype._check=function(d){if(this.bRunnable){return;}var T=false;if(this.bAllowSameOrigin&&this.sParentOrigin&&H.__window.document.URL.indexOf(this.sParentOrigin)==0){T=true;}else if(this.mSettings.whitelist&&this.mSettings.whitelist.length!=0){var s=this.sParentOrigin.split('//')[1];s=s.split(':')[0];for(var i=0;i<this.mSettings.whitelist.length;i++){var m=s.indexOf(this.mSettings.whitelist[i]);if(m!=-1&&s.substring(m)==this.mSettings.whitelist[i]){T=true;break;}}}if(T){this._applyTrusted(T);}else if(this.mSettings.whitelistService){var j=this;var l=new XMLHttpRequest();var n=this.mSettings.whitelistService+'?parentOrigin='+encodeURIComponent(this.sParentOrigin);l.onreadystatechange=function(){if(l.readyState==4){j._handleXmlHttpResponse(l,d);}};l.open('GET',n,true);l.setRequestHeader('Accept','application/json');l.send();}else{this._callback(false);}};H.prototype._handleXmlHttpResponse=function(d,i){if(d.status===200){var T=false;var r=d.responseText;var R=JSON.parse(r);if(R.active==false){this._applyState(true,true);}else if(i){return;}else{if(this.match(this.sParentOrigin,R.origin)){T=R.framing;}this._applyTrusted(T);}}else{q.sap.log.warning("The configured whitelist service is not available: "+d.status);this._callback(false);}};H.prototype._notifyChildFrames=function(){for(var i=0;i<this.aFPChilds.length;i++){this.aFPChilds[i].postMessage('SAPFrameProtection*parent-unlocked','*');}};H.prototype._sendRequireMessage=function(){H.__parent.postMessage('SAPFrameProtection*require-origin','*');if(this.mSettings.whitelistService){setTimeout(function(){if(!this.bParentResponded){this._check(true);}}.bind(this),10);}};H.prototype._handlePostMessage=function(o){var s=o.source,d=o.data;if(s===H.__self||s==null||typeof d!=="string"||d.indexOf("SAPFrameProtection*")===-1){return;}if(s===H.__parent){this.bParentResponded=true;if(!this.sParentOrigin){this.sParentOrigin=o.origin;this._check();}if(d=="SAPFrameProtection*parent-unlocked"){this._applyState(false,true);}}else if(s.parent===H.__self&&d=="SAPFrameProtection*require-origin"&&this.bUnlocked){s.postMessage("SAPFrameProtection*parent-unlocked","*");}else{s.postMessage("SAPFrameProtection*parent-origin","*");this.aFPChilds.push(s);}};q.sap.FrameOptions=H;}(jQuery,sap.ui.Device,window));
jQuery.sap.globalEval=function(){"use strict";eval(arguments[0]);};
