/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./ComboBoxTextField','./SelectList','./Popover','./library'],function(q,D,C,S,P,l){"use strict";var a=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});a.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};a.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};a.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};a.prototype.loadItems=function(c,o){var b=typeof c==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(b){o=q.extend({action:c,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(b){c.call(this);}};a.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,c,n,I;i<this.aMessageQueue.length;i++){c=this.aMessageQueue.shift();i--;I=(i+1)===this.aMessageQueue.length;n=I?null:this.aMessageQueue[i+1];if(typeof c.action==="function"){if((c.name==="input")&&!I&&(n.name==="input")){continue;}c.action.call(this);}}};a.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};a.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Dropdown");if(sap.ui.Device.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};a.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};a.prototype.ontouchstart=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(this.isOpenArea(e.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};a.prototype.ontouchend=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(!this.isOpen()&&this.isOpenArea(e.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};a.prototype.ontap=function(e){C.prototype.ontap.apply(this,arguments);var b=this.getRenderer().CSS_CLASS_COMBOBOXBASE,c=e.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(c.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(b+"Pressed");return;}this.bOpenedByKeyboardOrButton=true;this.loadItems();this.open();}if(this.isOpen()){this.addStyleClass(b+"Pressed");}};a.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(e.keyCode===q.sap.KeyCodes.F4){e.preventDefault();}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};a.prototype.onsapescape=function(e){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){e.setMarked();e.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};a.prototype.onsaphide=a.prototype.onsapshow;a.prototype.onsapfocusleave=function(e){if(!e.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(e.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),f=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),f)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};a.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};a.prototype.addContent=function(p){};a.prototype.setPickerType=function(p){this._sPickerType=p;};a.prototype.getPickerType=function(){return this._sPickerType;};a.prototype.createPicker=function(p){};a.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};a.prototype.hasContent=function(){return this.getItems().length>0;};a.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};a.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};a.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};a.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};a.prototype.isItemSelected=function(){};a.prototype.getKeys=function(I){I=I||this.getItems();for(var i=0,k=[];i<I.length;i++){k[i]=I[i].getKey();}return k;};a.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};a.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};a.prototype.getItemByText=function(t){return this.findItem("text",t);};a.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),I=i&&i.getDomRef();if(!p||!o||!I){return;}var b=o.scrollTop,c=I.offsetTop,d=o.clientHeight,e=I.offsetHeight;if(b>c){o.scrollTop=c;}else if((c+e)>(b+d)){o.scrollTop=Math.ceil(c+e-d);}};a.prototype.clearFilter=function(){for(var i=0,I=this.getItems();i<I.length;i++){I[i].bVisible=true;}};a.prototype.onItemChange=function(c){};a.prototype.clearSelection=function(){};a.prototype.setInternalBusyIndicator=function(b){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};a.prototype.setInternalBusyIndicatorDelay=function(d){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};a.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};a.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};a.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};a.prototype.getFirstItem=function(){return this.getItems()[0]||null;};a.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};a.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};a.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};a.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};a.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};a.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};a.prototype.removeAllItems=function(){var L=this.getList(),I=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<I.length;i++){I[i].detachEvent("_change",this.onItemChange,this);}return I;};a.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};return a;},true);
