/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,a){"use strict";var b=a.extend("sap.ui.commons.ColorPicker",{metadata:{library:"sap.ui.commons",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.commons.ColorPickerMode",group:"Appearance",defaultValue:sap.ui.commons.ColorPickerMode.HSV}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});var B="";var s=sap.ui.resource('sap.ui.commons','img/ColorPicker/Alphaslider_BG.png');b.prototype.init=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(sap.ui.Device.browser.firefox){B="-moz-linear-gradient";}else if(sap.ui.Device.browser.msie){B="-ms-linear-gradient";}else if(sap.ui.Device.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,a_old:1,hex:"#ffffff",old:"#ffffff"};this.HexString="ffffff";this.rgbString="";this.$cpBox=null;this.$cpCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.oMatrix=new sap.ui.commons.layout.MatrixLayout({layoutFixed:true,columns:3,width:"270px",widths:["117px","84px","69px"]});this.oMatrix.setParent(this);this.oMatrix.addStyleClass("sapUiColorPicker-ColorPickerMatrix");var c=this.getId()+'-cpBox';var d=this.getId()+'-cpCur';this.oHtmlBox=new sap.ui.core.HTML({content:"<div id="+c+" class='sapUiColorPicker-ColorPickerBox' style='width: 105px; height: 105px;'><div id="+d+" class='sapUiColorPicker-ColorPickerCircle' style='width: 5px; height: 5px;'></div></div>"});var o=this.getId()+'-ocBox';this.oHtmlOldCol=new sap.ui.core.HTML({content:"<div id="+o+" class=sapUiColorPicker-ColorPickerOldColor></div>"});var n=this.getId()+'-ncBox';this.oHtmlNewCol=new sap.ui.core.HTML({content:"<div id="+n+" class=sapUiColorPicker-ColorPickerNewColor></div>"});this.oArrow=new sap.ui.core.Icon({color:"#333",backgroundColor:"transparent",src:"sap-icon://arrow-right",tooltip:r.getText("COLORPICKER_NEW_OLD_COLOR")}).addStyleClass("sapUiColorPicker-Arrow");var i=this.getId()+'-hxF';var h=this.Color.hex.substr(1);this.oHexField=new sap.ui.commons.TextField({id:i,value:h});this.oHexLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oHexField,this.oHexLabel,"COLORPICKER_HEX","#:","sapUiColorPicker-ColorPickerHexField");i=this.getId()+'-rF';this.oRedField=new sap.ui.commons.TextField({id:i,value:this.Color.r,width:"3em"});this.oRedLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oRedField,this.oRedLabel,"COLORPICKER_RED","R:","sapUiColorPicker-ColorPickerInputFieldsLeft");i=this.getId()+'-gF';this.oGreenField=new sap.ui.commons.TextField({id:i,value:this.Color.g,width:"3em"});this.oGreenLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oGreenField,this.oGreenLabel,"COLORPICKER_GREEN","G:","sapUiColorPicker-ColorPickerInputFieldsLeft");i=this.getId()+'-bF';this.oBlueField=new sap.ui.commons.TextField({id:i,value:this.Color.b,width:"3em"});this.oBlueLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oBlueField,this.oBlueLabel,"COLORPICKER_BLUE","B:","sapUiColorPicker-ColorPickerInputFieldsLeft");i=this.getId()+'-hF';this.oHueField=new sap.ui.commons.TextField({id:i,value:this.Color.h,width:"3em"});this.oHueLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oHueField,this.oHueLabel,"COLORPICKER_HUE","H:","sapUiColorPicker-ColorPickerInputFieldsRight");i=this.getId()+'-sF';this.oSatField=new sap.ui.commons.TextField({id:i,value:this.Color.s,width:"3em"});this.oSatLabel=new sap.ui.commons.Label();this.oSatUnits=new sap.ui.commons.Label({text:"%"});this._createValueLabelBox(this.oSatField,this.oSatLabel,"COLORPICKER_SAT","S:","sapUiColorPicker-ColorPickerInputFieldsRight",this.oSatUnits);i=this.getId()+'-lF';this.oLitField=new sap.ui.commons.TextField({id:i,value:this.Color.l,width:"3em"});this.oLitLabel=new sap.ui.commons.Label();this.oLitUnits=new sap.ui.commons.Label({text:"%"});this._createValueLabelBox(this.oLitField,this.oLitLabel,"COLORPICKER_LIGHTNESS","L:","sapUiColorPicker-ColorPickerInputFieldsRight",this.oLitUnits);i=this.getId()+'-aF';this.oAlphaField=new sap.ui.commons.TextField({id:i,value:this.Color.a,width:"3em"});this.oAlphaLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oAlphaField,this.oAlphaLabel,"COLORPICKER_ALPHA","A:","sapUiColorPicker-ColorPickerInputFieldsRight");i=this.getId()+'-vF';this.oValField=new sap.ui.commons.TextField({id:i,value:this.Color.v,width:"3em"});this.oValLabel=new sap.ui.commons.Label();this._createValueLabelBox(this.oValField,this.oValLabel,"COLORPICKER_VALUE","V:","sapUiColorPicker-ColorPickerInputFieldsRight");i=this.getId()+'-hSLD';this.oSlider=new sap.ui.commons.Slider({id:i,max:360,smallStepWidth:1,tooltip:r.getText("COLORPICKER_HUE")});this.oSlider.setValue(parseInt(this.oHueField.getValue(),10),10);this.oSlider.addStyleClass("sapUiColorPicker-ColorPickerSlider");i=this.getId()+'-aSLD';this.oAlphaSlider=new sap.ui.commons.Slider({id:i,max:1,value:1,smallStepWidth:0.01,tooltip:r.getText("COLORPICKER_ALPHA")});this.oAlphaSlider.addStyleClass("sapUiColorPicker-ColorPickerAlphaSlider");this.oRGBorHSLRBGroup=new sap.ui.commons.RadioButtonGroup({columns:2,items:[new sap.ui.core.Item({text:"RGB"}),new sap.ui.core.Item({text:"HSL"})],selectedIndex:(this.Color.formatHSL?1:0)});this.oRGBorHSLRBGroup.addStyleClass("sapUiColorPickerHSL-RB");this.oRGBorHSLLabel=new sap.ui.commons.Label({text:"Output:",labelFor:this.oRGBorHSLRBGroup});this.oHLayout1=new sap.ui.layout.HorizontalLayout({content:[this.oRedLabel,this.oRedField]});this.oHLayout2=new sap.ui.layout.HorizontalLayout({content:[this.oGreenLabel,this.oGreenField]});this.oHLayout3=new sap.ui.layout.HorizontalLayout({content:[this.oBlueLabel,this.oBlueField]});this.oHLayout4=new sap.ui.layout.HorizontalLayout({content:[this.oHexLabel,this.oHexField]});this.oHLayout5=new sap.ui.layout.HorizontalLayout({content:[this.oHueLabel,this.oHueField]});this.oHLayout6=new sap.ui.layout.HorizontalLayout({content:[this.oSatLabel,this.oSatField]});this.oHLayout7a=new sap.ui.layout.HorizontalLayout({content:[this.oLitLabel,this.oLitField,this.oLitUnits]});this.oHLayout7b=new sap.ui.layout.HorizontalLayout({content:[this.oAlphaLabel,this.oAlphaField]});this.oHLayout7=new sap.ui.layout.HorizontalLayout({content:[this.oValLabel,this.oValField]});this.oHLayout8=new sap.ui.layout.HorizontalLayout();this.oVLayout1=new sap.ui.layout.VerticalLayout({content:[this.oHLayout1,this.oHLayout2,this.oHLayout3,this.oHLayout4]});this.oVLayout2=new sap.ui.layout.VerticalLayout();this.oVLayout2.addStyleClass("sapUiColorPicker-ColorPickerLastColumn");this.oMatrix.createRow(this.oHtmlBox,this.oVLayout1,this.oVLayout2);this.oHLayout9=new sap.ui.layout.HorizontalLayout();this.oRow2=new sap.ui.commons.layout.MatrixLayoutRow();this.oCell2=new sap.ui.commons.layout.MatrixLayoutCell({colSpan:3});this.oMatrix.addRow(this.oRow2);this.oRow3=new sap.ui.commons.layout.MatrixLayoutRow();this.oCell3=new sap.ui.commons.layout.MatrixLayoutCell({colSpan:3});this.oMatrix.addRow(this.oRow3);this.oHexField.attachChange(q.proxy(this._handleHexValueChange,this));this.oRedField.attachChange(q.proxy(this._handleRedValueChange,this));this.oGreenField.attachChange(q.proxy(this._handleGreenValueChange,this));this.oBlueField.attachChange(q.proxy(this._handleBlueValueChange,this));this.oHueField.attachChange(q.proxy(this._handleHueValueChange,this));this.oSatField.attachChange(q.proxy(this._handleSatValueChange,this));this.oValField.attachChange(q.proxy(this._handleValValueChange,this));this.oSlider.attachLiveChange(q.proxy(this._handleSliderLiveChange,this));this.oSlider.attachChange(q.proxy(this._handleSliderChange,this));this.oAlphaSlider.attachLiveChange(q.proxy(this._handleAlphaSliderLiveChange,this));this.oAlphaSlider.attachChange(q.proxy(this._handleAlphaSliderChange,this));this.oLitField.attachChange(q.proxy(this._handleLitValueChange,this));this.oAlphaField.attachChange(q.proxy(this._handleAlphaValueChange,this));this.oRGBorHSLRBGroup.attachSelect(q.proxy(this._handleRGBorHSLValueChange,this));this.data("sap-ui-fastnavgroup","true",true);};b.prototype.exit=function(){if(this.$cpBox){this.$cpBox.unbind("mousedown",this.handleMouseDown);}q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);this.oMatrix.destroy();};b.prototype.onBeforeRendering=function(){if(this.getMode()==="HSL"){this.oHLayout8.addContent(this.oHtmlOldCol);this.oHLayout8.addContent(this.oArrow);this.oHLayout8.addContent(this.oHtmlNewCol);this.oHLayout8.addStyleClass("sapUiColorPicker-swatches");this.oHLayout6.addContent(this.oSatUnits);this.oVLayout2.addContent(this.oHLayout5);this.oVLayout2.addContent(this.oHLayout6);this.oVLayout2.addContent(this.oHLayout7a);this.oVLayout2.addContent(this.oHLayout7b);this.oHLayout9.addContent(this.oHLayout8);this.oHLayout9.addContent(this.oRGBorHSLLabel);this.oHLayout9.addContent(this.oRGBorHSLRBGroup);this.oCell2.addContent(this.oHLayout9);this.oCell2.addStyleClass("sapUiColorPicker-RBRow");this.oRow2.addCell(this.oCell2);this.oCell3.addContent(this.oSlider);this.oRow3.addCell(this.oCell3);this.oRow4=new sap.ui.commons.layout.MatrixLayoutRow();this.oCell4=new sap.ui.commons.layout.MatrixLayoutCell({colSpan:3});this.oCell4.addContent(this.oAlphaSlider);this.oRow4.addCell(this.oCell4);this.oMatrix.addRow(this.oRow4);this.addStyleClass("sapUiColorPickerHSL");}else{this.oHLayout8.addContent(this.oHtmlOldCol);this.oHLayout8.addContent(this.oHtmlNewCol);this.oVLayout2.addContent(this.oHLayout5);this.oVLayout2.addContent(this.oHLayout6);this.oVLayout2.addContent(this.oHLayout7);this.oVLayout2.addContent(this.oHLayout8);this.oCell2.addContent(this.oSlider);this.oRow2.addCell(this.oCell2);this.oCell3.addContent(this.oAlphaSlider);this.oRow3.addCell(this.oCell3);}this.$("cpBox").unbind("mousedown",this.handleMouseDown);};b.prototype._createValueLabelBox=function(f,L,t,c,S,u){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");f.addStyleClass(S);f.setTooltip(r.getText(t));L.addStyleClass("sapUiColorPicker-ColorPickerLabels");L.setText(c);L.setTooltip(r.getText(t));L.setLabelFor(f);if(u){u.setLabelFor(f);u.addStyleClass("sapUiColorPicker-ColorPickerLabels");}};b.prototype.setColorString=function(c){var _;this._parseColorString(c);_=this._getRGBString();this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this.getMode()==="HSL"){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype.isColor=function(c){return this._parseColorString(c,true);};b.prototype.handleMouseDown=function(e){if(this.oHexField.getValueState()===sap.ui.core.ValueState.Error){return;}this.handleMousePos(e);q(document).bind("mousemove",q.proxy(this.handleMousePos,this)).bind("mouseup",q.proxy(this.handleMouseUp,this));};b.prototype.handleMouseUp=function(e){if(this.oHexField.getValueState()===sap.ui.core.ValueState.Error){return;}var _=this._getRGBString();this.handleMousePos(e);q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);if(this.getMode()==="HSL"){this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype.handleMousePos=function(e){var _;var c=this.$cpBox.offset();var d=this.$cpBox.width();var f=this.$cpBox.height();var x=e.pageX-c.left;var y=e.pageY-c.top;x=Math.min(Math.max(x,0),d);if(this.bRtl){var r=d-x;x=r;}y=Math.min(Math.max(y,0),f);var v=parseInt(x/d*100,10);var g=parseInt((1-y/f)*100,10);this.oSatField.setValue(g);if(this.getMode()==="HSL"){this.oLitField.setValue(v);this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.oValField.setValue(v);this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleSliderLiveChange=function(){var _;var c=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(c);if(this.getMode()==="HSL"){this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleSliderChange=function(){var _;var c=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(c);if(this.getMode()==="HSL"){this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleAlphaSliderLiveChange=function(){var _;this.Color.a=this.oAlphaSlider.getValue();if(this.getMode()==="HSL"){this.oAlphaField.setValue(this.Color.a);this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleAlphaSliderChange=function(){var _;this.Color.a=this.oAlphaSlider.getValue();if(this.getMode()==="HSL"){this.oAlphaField.setValue(this.Color.a);this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleAlphaValueChange=function(){var _;var c=parseFloat(this.oAlphaField.getValue(),10);if(c<0||isNaN(c)){c=0;}if(c>1.0){c=1;}this.Color.a=c;this.oAlphaField.setValue(c);this.oAlphaSlider.setValue(c);this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});};b.prototype._handleRGBorHSLValueChange=function(){var _=this._getRGBString();this.Color.formatHSL=(this.oRGBorHSLRBGroup.getSelectedIndex()===1);this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});};b.prototype._handleHueValueChange=function(){var _;var h=parseInt(this.oHueField.getValue(),10);if(h<0||isNaN(h)){h=0;}if(h>360){h=359.9;}this.oHueField.setValue(h);this.oSlider.setValue(h);if(this.getMode()==="HSL"){this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleSatValueChange=function(){var _;var c=parseInt(this.oSatField.getValue(),10);if(c<0||isNaN(c)){c=0;}if(c>100){c=100;}this.oSatField.setValue(c);if(this.getMode()==="HSL"){this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleValValueChange=function(){var _;var v=parseInt(this.oValField.getValue(),10);if(v<0||isNaN(v)){v=0;}if(v>100){v=100;}this.oValField.setValue(v);this._processHSVchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});};b.prototype._handleLitValueChange=function(){var _;var c=parseInt(this.oLitField.getValue(),10);if(c<0||isNaN(c)){c=0;}if(c>100){c=100;}this.oLitField.setValue(c);this._processHSLchanges();_=this._getRGBString();this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});};b.prototype._handleRedValueChange=function(){var _;var r=parseInt(this.oRedField.getValue(),10);if(r<0||isNaN(r)){r=0;}if(r>255){r=255;}this.oRedField.setValue(r);this._processRGBchanges();_=this._getRGBString();if(this.getMode()==="HSL"){this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleGreenValueChange=function(){var _;var g=parseInt(this.oGreenField.getValue(),10);if(g<0||isNaN(g)){g=0;}if(g>255){g=255;}this.oGreenField.setValue(g);this._processRGBchanges();_=this._getRGBString();if(this.getMode()==="HSL"){this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._handleBlueValueChange=function(){var _;var c=parseInt(this.oBlueField.getValue(),10);if(c<0||isNaN(c)){c=0;}if(c>255){c=255;}this.oBlueField.setValue(c);this._processRGBchanges();_=this._getRGBString();if(this.getMode()==="HSL"){this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._processHSVchanges=function(){var h=parseInt(this.oHueField.getValue(),10);var c=parseInt(this.oSatField.getValue(),10);var v=parseInt(this.oValField.getValue(),10);this._calculateRGB(h,c,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.HexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=h;this.Color.s=c;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};b.prototype._processHSLchanges=function(){var h=parseInt(this.oHueField.getValue(),10)%360;var c=parseInt(this.oSatField.getValue(),10);var d=parseInt(this.oLitField.getValue(),10);this._calculateRGB(h,c,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.HexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=h;this.Color.s=c;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};b.prototype._processRGBchanges=function(){var r=Math.round(parseInt(this.oRedField.getValue(),10));var g=Math.round(parseInt(this.oGreenField.getValue(),10));var c=Math.round(parseInt(this.oBlueField.getValue(),10));this._calculateHEX(r,g,c);this.oHexField.setValue(this.HexString);this._calculateHSV(r,g,c);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this.getMode()==="HSL"){this.oLitField.setValue(this.Color.l);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.Color.r=r;this.Color.g=g;this.Color.b=c;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};b.prototype._handleHexValueChange=function(){var _;var h=this.oHexField.getValue().toLowerCase();if(h.substr(0,1)==='#'){h=h.substr(1);}var r=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(r.test(h)===false){this.oHexField.setValueState(sap.ui.core.ValueState.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);if(this.getMode()==="HSL"){this.oLitField.setEnabled(false);this.oAlphaField.setEnabled(false);}else{this.oValField.setEnabled(false);}return false;}else if(this.oHexField.getValueState()===sap.ui.core.ValueState.Error){this.oHexField.setValueState(sap.ui.core.ValueState.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);if(this.getMode()==="HSL"){this.oLitField.setEnabled(true);this.oAlphaField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(h.length===3){var t=h.charAt(0)+h.charAt(0)+h.charAt(1)+h.charAt(1)+h.charAt(2)+h.charAt(2);h=t;}this._processHexChanges(h);this.oHexField.setValue(h);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this.getMode()==="HSL"){this.oLitField.setValue(this.Color.l);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.oAlphaSlider.setValue(1);if(this.getMode()==="HSL"){this.oAlphaField.setValue(1);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();_=this._getRGBString();if(this.getMode()==="HSL"){this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:_});}else{this.setProperty('colorString',_,true);this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,alpha:this.Color.a,hex:this.Color.hex,colorString:_});}};b.prototype._processHexChanges=function(i){this._convertRGB(i);if(this.getMode()==="HSL"){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+i.toLowerCase();};b.prototype._updateAlphaBackground=function(e){var n=B+"(left,rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+",0),rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+",1)),url("+s+")";if(this.lastAlphaSliderGradient!=n){q(this.oAlphaSlider.getDomRef()).find(".sapUiSliBar").css("background-image",n);}this.lastOpacitySliderGradient=n;};b.prototype._updateCursorPosition=function(){var x;var c=this.$cpCur.outerWidth();var d=this.$cpCur.outerHeight();var e=this.$cpBox.width();var f=this.$cpBox.height();var g=this.oSatField.getValue();if(this.getMode()==="HSL"){var h=this.oLitField.getValue();x=Math.round(h*e/100.0);}else{var v=this.oValField.getValue();x=Math.round(v*e/100.0);}if(this.bRtl){var r=e-x;x=r;}var y=Math.round((1-g/100.0)*f);x=Math.round(Math.max(x,0)-c/2.0-1.0);y=Math.round(Math.max(y,0)-d/2.0-1.0);this.$cpCur.css("left",x).css("top",y);};b.prototype._calculateRGB=function(h,d,v){if(this.getMode()==="HSL"){this._calculateRGB_Advanced(h,d,v);return;}if(h===360){h=0;}h/=60;d/=100;v/=100;var c=v*d;var x=c*(1-Math.abs(h%2-1));var m=v-c;var r=0,g=0,e=0;var i=Math.floor(h);switch(i){case 0:r=c;g=x;break;case 1:r=x;g=c;break;case 2:g=c;e=x;break;case 3:g=x;e=c;break;case 4:r=x;e=c;break;case 5:r=c;e=x;break;}this.RGB.r=Math.floor((r+m)*255);this.RGB.g=Math.floor((g+m)*255);this.RGB.b=Math.floor((e+m)*255);};b.prototype._calculateRGB_Advanced=function(h,c,e){var r,g,f;if(h<0){h=0;}else if(h>360){h=360;}if(c>100){c=1;}else if(c<0){c=0;}else{c=c/100;}if(e>100){e=1;}else if(e<0){e=0;}else{e=e/100;}var d=c*(1-Math.abs(2*e-1));var m=255*(e-0.5*d);var x=d*(1-Math.abs((h/60)%2-1));var i=Math.floor(h/60);var j=m+255*x;var k=m+255*d;switch(i){case 0:r=k;g=j;f=m;break;case 1:r=j;g=k;f=m;break;case 2:r=m;g=k;f=j;break;case 3:r=m;g=j;f=k;break;case 4:r=j;g=m;f=k;break;case 5:r=k;g=m;f=j;break;default:r=0;g=0;f=0;break;}this.RGB.r=Math.round(r);this.RGB.g=Math.round(g);this.RGB.b=Math.round(f);};b.prototype._getRGBString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};b.prototype._calculateHEX=function(r,g,c){var d=r.toString(16);var e=g.toString(16);var f=c.toString(16);if(d.length===1){d='0'+d;}if(e.length===1){e='0'+e;}if(f.length===1){f='0'+f;}this.HexString=(d+e+f).toLowerCase();};b.prototype._calculateHSV=function(r,g,c){var m=Math.max(Math.max(r,g),c);var d=Math.min(Math.min(r,g),c);var e=(m-d);var v=Math.round(m*100/255);var f=(m===0.0)?0:(100*e/m);var h=0;if(f===0){h=0;}else if(r===m){h=60.0*(g-c)/e;}else if(g===m){h=120.0+60.0*(c-r)/e;}else if(c===m){h=240.0+60.0*(r-g)/e;}if(h<0.0){h+=359.9;}h=Math.round(h);f=Math.round(f);this.Color.h=h;this.Color.s=f;this.Color.v=v;};b.prototype._calculateHSL=function(r,g,c){var m=Math.max(r,g,c);var e=Math.min(r,g,c);var d=(m-e)/255;var f=(m+e)/510;var h=1-Math.abs(2*f-1);var i=(f===0.0)?0:d/h;var j=(h!=0)?i:0;var k=0;f=Math.round(f*100);j=Math.round(j*100);if(f===0||j===0||(r+g+c===765)){k=0;}else{var C=m-e;if(m===r){k=((g-c)/C)%6;}if(m===g){k=(c-r)/C+2;}if(m===c){k=(r-g)/C+4;}if(C===0){k=0;}k*=60;if(k<0){k+=360;}}this.Color.h=Math.round(k);this.Color.s=j;this.Color.l=f;};b.prototype._convertRGB=function(h){var r=parseInt(h.substr(0,2),16);var g=parseInt(h.substr(2,2),16);var c=parseInt(h.substr(4,2),16);this.Color.r=r;this.Color.g=g;this.Color.b=c;};b.prototype._updateGradientBoxBackground=function(h){if(this.getMode()==="HSL"){this._calculateRGB_Advanced(h,100,50);}else{this._calculateRGB(h,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$cpBox.css('background-color','rgb('+this.RGB.r+', '+this.RGB.g+', '+this.RGB.b+')');};b.prototype._updateSelColorBackground=function(){this.$("ncBox").css('background-color',this._getRGBString());};b.prototype._parseColorString=function(c,C){var h="";if(c.substr(0,1)==='#'){c=c.substr(1);}c=c.replace(/ /g,'');c=c.toLowerCase();h=this._parseColorName(c);if(h!=""){if(C){return true;}this._processHexChanges(h);this.Color.old=this.Color.hex;if(this.getMode()==="HSL"){this.Color.formatHSL=false;}return true;}var r=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(r.test(c)===true){if(C){return true;}if(c.length==3){h=c.charAt(0)+c.charAt(0)+c.charAt(1)+c.charAt(1)+c.charAt(2)+c.charAt(2);}else{h=c;}this._processHexChanges(h);this.Color.old=this.Color.hex;if(this.getMode()==="HSL"){this.Color.formatHSL=false;}return true;}if(c.substr(0,4)==='rgba'){return this._parseRGBA(c,C);}if(c.substr(0,3)==='rgb'){return this._parseRGB(c,C);}if(this.getMode()=="HSL"){if(c.substr(0,4)==='hsla'){return this._parseHSLA(c,C);}if(c.substr(0,3)==='hsl'){return this._parseHSL(c,C);}}else{if(c.substr(0,3)==='hsv'){return this._parseHSV(c,C);}else{return false;}}return false;};b.prototype._parseHSV=function(c){c=c.substr(3);c=c.replace("(",'');c=c.replace(")",'');c=c.split(' ').join('');var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100)),){1}((\d{1,2})|(100)){1}$/;if(r.test(c)===true){var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseInt(H[1],10),parseInt(H[2],10));this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseInt(H[1],10);this.Color.v=parseInt(H[2],10);this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;}};b.prototype._parseHSL=function(c,C){c=c.substr(3);c=c.replace("(",'');c=c.replace(")",'');c=c.split(' ').join('');var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100))%,){1}(((\d{1,2})|(100))%){1}$/;if(r.test(c)===true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseInt(H[1],10),parseInt(H[2],10));this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseInt(H[1],10);this.Color.l=parseInt(H[2],10);this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=1;this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100))%,){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseInt(H[1],10),parseFloat(H[2])*100);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseInt(H[1],10);this.Color.l=parseFloat(H[2])*100;this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=1;this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]),){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseFloat(H[1])*100,parseFloat(H[2])*100);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseFloat(H[1])*100;this.Color.l=parseFloat(H[2])*100;this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=1;this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]),){1}(((\d{1,2})|(100))%){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseFloat(H[1])*100,parseInt(H[2],10));this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseFloat(H[1])*100;this.Color.l=parseInt(H[2],10);this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=1;this.Color.formatHSL=true;return true;}else{return false;}}}}};b.prototype._parseHSLA=function(c,C){c=c.substr(4);c=c.replace("(",'');c=c.replace(")",'');c=c.split(' ').join('');var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100))%,){1}(((\d{1,2})|(100))%){1},([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseInt(H[1],10),parseInt(H[2],10));this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseInt(H[1],10);this.Color.l=parseInt(H[2],10);this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=parseFloat(H[3]);this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}(((\d{1,2})|(100))%,){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1},([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseInt(H[1],10),parseFloat(H[2])*100);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseInt(H[1],10);this.Color.l=parseFloat(H[2])*100;this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=parseFloat(H[3]);this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}([0]|(([0]\.[0-9]+)|(\.[0-9]+)|[1]),){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1},([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseFloat(H[1])*100,parseFloat(H[2])*100);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseFloat(H[1])*100;this.Color.l=parseFloat(H[2])*100;this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=parseFloat(H[3]);this.Color.formatHSL=true;return true;}else{var r=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}(((\d{1,2})|(100))%){1},([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(C){return true;}var H=c.split(",");this._calculateRGB(parseInt(H[0],10),parseFloat(H[1])*100,parseInt(H[2],10));this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=parseInt(H[0],10);this.Color.s=parseFloat(H[1])*100;this.Color.l=parseInt(H[2],10);this.Color.hex="#"+this.HexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=parseFloat(H[3]);this.Color.formatHSL=true;return true;}else{return false;}}}}};b.prototype._parseRGB=function(c,C){c=c.substr(3);c=c.replace("(",'');c=c.replace(")",'');c=c.split(' ').join('');var r=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5]))){1}$/;if(r.test(c)==true){if(this.getMode()=="HSL"&&C){return true;}var R=c.split(",");this._calculateHEX(parseInt(R[0],10),parseInt(R[1],10),parseInt(R[2],10));this._processHexChanges(this.HexString);this.Color.old=this.Color.hex;}if(this.getMode()=="HSL"){this.Color.formatHSL=false;return true;}};b.prototype._parseRGBA=function(c,C){c=c.substr(4);c=c.replace("(",'');c=c.replace(")",'');c=c.split(' ').join('');var r=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){1}([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1]){1}$/;if(r.test(c)==true){if(this.getMode()=="HSL"&&C){return true;}var R=c.split(",");var A=c.substr(c.lastIndexOf(",")+1,(c.length-c.lastIndexOf(",")));this._calculateHEX(parseInt(R[0],10),parseInt(R[1],10),parseInt(R[2],10));this._processHexChanges(this.HexString);this.Color.old=this.Color.hex;this.Color.a=this.Color.a_old=parseFloat(A);}if(this.getMode()=="HSL"){this.Color.formatHSL=false;return true;}};b.prototype._parseColorName=function(c){var d="";var h="";var e={aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dodgerblue:'1e90ff',feldspar:'d19275',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslateblue:'8470ff',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',violetred:'d02090',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32'};for(d in e){if(c==d){h=e[d].toLowerCase();return h;}}return h;};b.prototype.onAfterRendering=function(){var _=this._getRGBString();this.$cpBox=this.$("cpBox");this.$cpCur=this.$("cpCur");this.$cpBox.bind("mousedown",q.proxy(this.handleMouseDown,this));this.$("ncBox").css('background-color',_);this.$("ocBox").css('background-color',_);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();if(this.getMode()=="HSL"){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);};b.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};return b;},true);
