/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObjectMetadata','sap/ui/core/Manifest','sap/ui/thirdparty/URI','jquery.sap.resources'],function(q,M,b,U){"use strict";var C=function(c,o){M.apply(this,arguments);};C.prototype=q.sap.newObject(M.prototype);C.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};C.prototype.applySettings=function(c){var s=c.metadata;var n=this.getName(),p=n.replace(/\.\w+?$/,"");if(s._src){if(s._src=="component.json"){q.sap.log.warning("Usage of declaration \"metadata: 'component.json'\" is deprecated (component "+n+"). Use \"metadata: 'json'\" instead.");}else if(s._src!="json"){throw new Error("Invalid metadata declaration for component "+n+": \""+s._src+"\"! Use \"metadata: 'json'\" to load metadata from component.json.");}var r=p.replace(/\./g,"/")+"/component.json";q.sap.log.info("The metadata of the component "+n+" is loaded from file "+r+".");try{var R=q.sap.loadResource(r,{dataType:"json"});q.extend(s,R);}catch(e){q.sap.log.error("Failed to load component metadata from \""+r+"\" (component "+n+")! Reason: "+e);}}M.prototype.applySettings.call(this,c);this._sComponentName=p;this._bInitialized=false;this._iInstanceCount=0;var m=s["manifest"];if(m){s.__metadataVersion=2;if(typeof m==="string"&&m==="json"){var r=p.replace(/\./g,"/")+"/manifest.json";q.sap.log.info("The manifest of the component "+n+" is loaded from file "+r+".");try{var R=q.sap.loadResource(r,{dataType:"json"});m=R;}catch(e){q.sap.log.error("Failed to load component manifest from \""+r+"\" (component "+n+")! Reason: "+e);m={};}}}else{s.__metadataVersion=1;m={};}m["name"]=m["name"]||n;m["sap.app"]=m["sap.app"]||{"id":p};m["sap.ui5"]=m["sap.ui5"]||{};if(!this.isBaseClass()){m["sap.ui5"]["extends"]=m["sap.ui5"]["extends"]||{};}this._convertLegacyMetadata(s,m);this._oStaticInfo=s;this._oManifest=new b(m,{componentName:this._sComponentName,baseUrl:q.sap.getModulePath(this._sComponentName)+"/",process:s.__metadataVersion===2});};C.prototype.init=function(){if(!this._bInitialized){var p=this.getParent();if(p instanceof C){p.init();}this._oManifest.init();this._bInitialized=true;}};C.prototype.exit=function(){if(this._bInitialized){var p=this.getParent();if(p instanceof C){p.exit();}this._oManifest.exit();this._bInitialized=false;}};C.prototype.onInitComponent=function(){var u=this.getManifestEntry("sap.ui5",true),e=u&&u["extends"]&&u["extends"].extensions;if(this._iInstanceCount===0&&!q.isEmptyObject(e)){var a=sap.ui.requireSync('sap/ui/core/CustomizingConfiguration');a.activateForComponent(this._sComponentName);}this._iInstanceCount++;};C.prototype.onExitComponent=function(){this._iInstanceCount=Math.max(this._iInstanceCount-1,0);var a=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(this._iInstanceCount===0&&a){a.deactivateForComponent(this._sComponentName);}};C.prototype.isBaseClass=function(){return/^sap\.ui\.core\.(UI)?Component$/.test(this.getName());};C.prototype.getMetadataVersion=function(){return this._oStaticInfo.__metadataVersion;};C.prototype.getManifestObject=function(){return this._oManifest;};C.prototype.getManifest=function(){if(this.getMetadataVersion()===1){return this._oManifest.getRawJson();}return this._oManifest.getJson();};C.prototype._getManifest=function(){q.sap.log.warning("ComponentMetadata#_getManifest: do not use deprecated functions anymore!");return this._oManifest.getJson();};C.prototype.getRawManifest=function(){return this._oManifest.getRawJson();};C.prototype._getRawManifest=function(){q.sap.log.warning("ComponentMetadata#_getRawManifest: do not use deprecated functions anymore!");return this._oManifest.getRawJson();};C.prototype.getManifestEntry=function(k,m){var d=this._oManifest.getEntry(k);if(d!==undefined&&!q.isPlainObject(d)){return d;}var p,P;if(m&&(p=this.getParent())instanceof C){P=p.getManifestEntry(k,m);}if(P||d){d=q.extend(true,{},P,d);}return d;};C.prototype.getCustomEntry=function(k,m){if(!k||k.indexOf(".")<=0){q.sap.log.warning("Component Metadata entries with keys without namespace prefix can not be read via getCustomEntry. Key: "+k+", Component: "+this.getName());return null;}var p,d=this._oStaticInfo[k]||{};if(!q.isPlainObject(d)){q.sap.log.warning("Custom Component Metadata entry with key '"+k+"' must be an object. Component: "+this.getName());return null;}if(m&&(p=this.getParent())instanceof C){return q.extend(true,{},p.getCustomEntry(k,m),d);}return q.extend(true,{},d);};C.prototype.getComponentName=function(){return this._sComponentName;};C.prototype.getDependencies=function(){if(!this._oLegacyDependencies){var d=this.getManifestEntry("/sap.ui5/dependencies"),u=d&&d.minUI5Version||null,l=d&&d.libs||{},c=d&&d.components||{};var L={ui5version:u,libs:[],components:[]};for(var s in l){L.libs.push(s);}for(var a in c){L.components.push(a);}this._oLegacyDependencies=L;}return this._oLegacyDependencies;};C.prototype.getIncludes=function(){if(!this._aLegacyIncludes){var I=[],r=this.getManifestEntry("/sap.ui5/resources")||{},c=r&&r.css||[],j=r&&r.js||[];for(var i=0,l=c.length;i<l;i++){if(c[i]&&c[i].uri){I.push(c[i].uri);}}for(var i=0,l=j.length;i<l;i++){if(j[i]&&j[i].uri){I.push(j[i].uri);}}this._aLegacyIncludes=(I.length>0)?I:null;}return this._aLegacyIncludes;};C.prototype.getUI5Version=function(){return this.getManifestEntry("/sap.ui5/dependencies/minUI5Version");};C.prototype.getComponents=function(){return this.getDependencies().components;};C.prototype.getLibs=function(){return this.getDependencies().libs;};C.prototype.getVersion=function(){return this.getManifestEntry("/sap.app/applicationVersion/version");};C.prototype.getConfig=function(k,d){var c=this.getManifestEntry("/sap.ui5/config",!d);if(!c){return{};}if(!k){return c;}return c.hasOwnProperty(k)?c[k]:{};};C.prototype.getCustomizing=function(d){return this.getManifestEntry("/sap.ui5/extends/extensions",!d);};C.prototype.getModels=function(d){if(!this._oLegacyModels){this._oLegacyModels={};var D=this.getManifestEntry("/sap.ui5/models")||{};for(var s in D){var o=D[s];this._oLegacyModels[s]=o.settings||{};this._oLegacyModels[s].type=o.type;this._oLegacyModels[s].uri=o.uri;}}var p,m=q.extend(true,{},this._oLegacyModels);if(!d&&(p=this.getParent())instanceof C){m=q.extend(true,{},p.getModels(),m);}return m;};C.prototype.handleValidation=function(){return this.getManifestEntry("/sap.ui5/handleValidation");};C.prototype.getServices=function(){q.sap.log.warning("Usage of sap.ui.core.ComponentMetadata.protoype.getServices is deprecated!");return this._oStaticInfo.services||{};};C.prototype._convertLegacyMetadata=function(s,c){var f=function(a,t){var o={};if(a){for(var i=0,l=a.length;i<l;i++){var v=a[i];if(typeof v==="string"){o[v]=typeof t==="function"&&t(v)||{};}}}return o;};var A=c["sap.app"];var u=c["sap.ui5"];for(var n in s){var v=s[n];if(v!==undefined){switch(n){case"name":c[n]=c[n]||v;A["id"]=A["id"]||v;break;case"description":case"keywords":A[n]=A[n]||v;break;case"version":var d=A.applicationVersion=A.applicationVersion||{};d.version=d.version||v;break;case"config":u[n]=u[n]||v;break;case"customizing":var e=u["extends"]=u["extends"]||{};e.extensions=e.extensions||v;break;case"dependencies":if(!u[n]){u[n]={};u[n].minUI5Version=v.ui5version;u[n].libs=f(v.libs);u[n].components=f(v.components);}break;case"includes":if(!u["resources"]){u["resources"]={};if(v&&v.length>0){for(var i=0,l=v.length;i<l;i++){var r=v[i];var m=r.match(/\.(css|js)$/i);if(m){u["resources"][m[1]]=u["resources"][m[1]]||[];u["resources"][m[1]].push({"uri":r});}}}}break;case"handleValidation":if(u[n]===undefined){u[n]=v;}break;case"models":if(!u["models"]){var g={};for(var h in v){var D=v[h];var j={};for(var k in D){var p=D[k];switch(k){case"type":case"uri":j[k]=p;break;default:j.settings=j.settings||{};j.settings[k]=p;}}g[h]=j;}u["models"]=g;}break;}}}};return C;},true);
