/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/BindingParser','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Interface','sap/ui/base/Object','sap/ui/base/ManagedObject','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager','jquery.sap.act','jquery.sap.dom','jquery.sap.events','jquery.sap.mobile','jquery.sap.properties','jquery.sap.resources','jquery.sap.script'],function(q,D,G,B,a,E,I,c,M,C,d,e,g,h,F,R,k,T,U,p){"use strict";function r(o,m){var b=sap.ui.require(m);return typeof b==='function'&&(o instanceof b);}var L={};var _;var s=c.extend("sap.ui.core.Core",{constructor:function(){if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}var b=this,l=q.sap.log,f="sap.ui.core.Core";c.call(this);_=new E();["attachEvent","detachEvent","getEventingParent"].forEach(function(Q){s.prototype[Q]=_[Q].bind(_);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;this.mElements={};this.mObjects={"component":{},"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;this.aPrerenderingTasks=[];l.info("Creating Core",null,f);q.sap.measure.start("coreComplete","Core.js - complete");q.sap.measure.start("coreBoot","Core.js - boot");q.sap.measure.start("coreInit","Core.js - init");this.oConfiguration=new d(this);var o=this.oConfiguration["frameOptionsConfig"]||{};o.mode=this.oConfiguration.getFrameOptions();o.whitelistService=this.oConfiguration.getWhitelistService();this.oFrameOptions=new q.sap.FrameOptions(o);if(this.oConfiguration["bindingSyntax"]==="complex"){M.bindingParser=B.complexParser;}if(this.oConfiguration["xx-designMode"]==true){B._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=m.indexOf("sap.ui.core.library");if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&m.indexOf("sap.ui.core.plugin.LessSupport")==-1){l.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var P=this.oConfiguration.preload;if(window["sap-ui-debug"]===true){P="";}if(P==="auto"){P=(window["sap-ui-optimized"]&&!this.oConfiguration['xx-loadAllMode'])?"sync":"";}this.oConfiguration.preload=P;l.info("Declared modules: "+m,f);this._setupThemes();this._setupRTL();var $=q("html");this._setupBrowser($);this._setupOS($);this._setupLang($);this._setupAnimation($);this._setupWeinre();sap.ui.getCore=q.sap.getter(this.getInterface());this.oRenderManager=new R();var j=q.sap.syncPoint("UI5 Document Ready",function(Q,W){b.handleLoad();});var n=j.startTask("document.ready");var u=j.startTask("preload and boot");q(function(){l.trace("document is ready");j.finishTask(n);});var v=q.sap.syncPoint("UI5 Core Preloads and Bootstrap Script",function(Q,W){l.trace("Core loaded: open="+Q+", failures="+W);b._boot();j.finishTask(u);q.sap.measure.end("coreBoot");});var w=v.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var V=v.startTask("load version info");var x=function(Q){if(Q){l.trace("Loaded \"sap-ui-version.json\".");}else{l.error("Could not load \"sap-ui-version.json\".");}v.finishTask(V);};var A=P==="async";var y=sap.ui.getVersionInfo({async:A,failOnError:false});if(y instanceof Promise){y.then(x,function(Q){l.error("Unexpected error when loading \"sap-ui-version.json\": "+Q);v.finishTask(V);});}else{x(y);}}var z=this.oConfiguration["xx-bootTask"];if(z){var H=v.startTask("custom boot task");z(function(Q){v.finishTask(H,typeof Q==="undefined"||Q===true);});}this._polyfillFlexbox();var J=v.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;v.finishTask(J);};if(P==="sync"||P==="async"){var K=P!=="sync";q.each(m,function(i,Q){if(Q.match(/\.library$/)){q.sap.preloadModules(Q+"-preload",K,v);}});}var N=this.oConfiguration.getAppCacheBuster();if(N&&N.length>0){var O=sap.ui.requireSync('sap/ui/core/AppCacheBuster');O.boot(v);}v.finishTask(w);},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId","addPrerenderingTask"]}});s.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var S="sap-ui-static";s.prototype._grantFriendAccess=function(){var b=this;h.prototype.register=function(m){b.registerElementClass(m);};g.prototype.register=function(){b.registerElement(this);};g.prototype.deregister=function(){b.deregisterElement(this);};g._updateFocusInfo=function(o){if(b.oFocusHandler){b.oFocusHandler.updateControlFocusInfo(o);}};C.prototype.register=function(){b.registerObject(this);};C.prototype.deregister=function(){var f=this.sId;for(var i in b.mElements){var o=b.mElements[i];if(o._sapui_candidateForDestroy&&o._sOwnerId===f&&!o.getParent()){q.sap.log.debug("destroying dangling template "+o+" when destroying the owner component");o.destroy();}}b.deregisterObject(this);};};s.prototype._setupThemes=function(){var l=q.sap.log,b="sap.ui.core.Core";var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(o){if(o.themeroots){for(var f in o.themeroots){var i=o.themeroots[f];if(typeof i==="string"){this.setThemeRoot(f,i);}else{for(var j in i){if(j.length>0){this.setThemeRoot(f,[j],i[j]);}else{this.setThemeRoot(f,i[j]);}}}}}}this.sTheme=this.oConfiguration.getTheme();q(document.documentElement).addClass("sapUiTheme-"+this.sTheme);l.info("Declared theme "+this.sTheme,null,b);};s.prototype._setupRTL=function(){var l=q.sap.log,b="sap.ui.core.Core";if(this.oConfiguration.getRTL()){q(document.documentElement).attr("dir","rtl");l.info("RTL mode activated",null,b);}};s.prototype._setupBrowser=function($){var l=q.sap.log,f="sap.ui.core.Core";$=$||q("html");var b=D.browser;var i=b.name;if(i===b.BROWSER.CHROME){q.browser.safari=false;q.browser.chrome=true;}else if(i===b.BROWSER.SAFARI){q.browser.safari=true;q.browser.chrome=false;if(b.mobile){i="m"+i;}}if(i){q.browser.fVersion=b.version;q.browser.mobile=b.mobile;i=i+(b.version===-1?"":Math.floor(b.version));$.attr("data-sap-ui-browser",i);l.debug("Browser-Id: "+i,null,f);}};s.prototype._setupOS=function($){$=$||q("html");$.attr("data-sap-ui-os",D.os.name+D.os.versionStr);var o=null;switch(D.os.name){case D.os.OS.IOS:o="sap-ios";break;case D.os.OS.ANDROID:o="sap-android";break;case D.os.OS.BLACKBERRY:o="sap-bb";break;case D.os.OS.WINDOWS_PHONE:o="sap-winphone";break;}if(o){$.addClass(o);}};s.prototype._setupLang=function($){$=$||q("html");var u=function(){var l=this.oConfiguration.getLocale();if(l){$.attr("lang",l.toString());}else{$.removeAttr("lang");}};u.call(this);this.attachLocalizationChanged(u,this);};s.prototype._setupAnimation=function($){$=$||q("html");var A=this.oConfiguration.getAnimation();$.attr("data-sap-ui-animation",A?"on":"off");q.fx.off=!A;};s.prototype._setupWeinre=function(){var l=q.sap.log;if(this.oConfiguration.getWeinreId()){l.info("Starting WEINRE Remote Web Inspector");var w="<script src=\"";w+=this.oConfiguration.getWeinreServer();w+="/target/target-script-min.js#";w+=q.sap.encodeURL(this.oConfiguration.getWeinreId());w+="\"></script>";document.write(w);}};s.prototype._polyfillFlexbox=function(){var u=new q.sap.Version(this.oConfiguration.getCompatibilityVersion("flexBoxPolyfill"));if(u.compareTo("1.16")>=0){q.support.useFlexBoxPolyfill=false;}else if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.support.useFlexBoxPolyfill=true;}else{q.support.useFlexBoxPolyfill=false;}};s.prototype._boot=function(){this.lock();var b=this.oConfiguration['preloadLibCss'];if(b&&b.length>0&&!b.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+b.join(","));}var f=this;q.each(this.oConfiguration.modules,function(i,j){var m=j.match(/^(.*)\.library$/);if(m){f.loadLibrary(m[1]);}else{q.sap.require(j);}});this.unlock();};s.prototype.applyTheme=function(b,f){b=this.oConfiguration._normalizeTheme(b,f);if(f){this.setThemeRoot(b,f);}if(b&&this.sTheme!=b){var i=this.sTheme;this._updateThemeUrls(b);this.sTheme=b;this.oConfiguration._setTheme(b);q(document.documentElement).removeClass("sapUiTheme-"+i).addClass("sapUiTheme-"+b);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false);}}};s.prototype._updateThemeUrls=function(b){var f=this,i=this.oConfiguration.getRTL()?"-RTL":"";q("link[id^=sap-ui-theme-]").each(function(){var l=this.id.slice(13),j=this.href.slice(this.href.lastIndexOf("/")+1),m="library",H,n,$=q(this);if((n=l.indexOf("-["))>0){m+=l.slice(n+2,-1);l=l.slice(0,n);}if(j===(m+".css")||j===(m+"-RTL.css")){j=m+i+".css";}if($.attr("data-sap-ui-css-count")){$.remove();}H=f._getThemePath(l,b)+j;if(H!=this.href){this.href=H;$.removeAttr("data-sap-ui-ready");}});};s.prototype._ensureThemeRoot=function(l,b){if(this._mThemeRoots){var f=this._mThemeRoots[b+" "+l]||this._mThemeRoots[b];if(f){f=f+l.replace(/\./g,"/")+"/themes/"+b+"/";q.sap.registerModulePath(l+".themes."+b,f);}}};s.prototype._getThemePath=function(l,b){this._ensureThemeRoot(l,b);return q.sap.getModulePath(l+".themes."+b,"/");};s.prototype.setThemeRoot=function(b,l,f){if(!this._mThemeRoots){this._mThemeRoots={};}if(f===undefined){f=l;l=undefined;}f=f+(f.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var j=l[i];this._mThemeRoots[b+" "+j]=f;}}else{this._mThemeRoots[b]=f;}return this;};s.prototype.init=function(){if(this.bInitialized){return;}var l=q.sap.log,b="sap.ui.core.Core.init()";this.boot();l.info("Initializing",null,b);this.oFocusHandler=new F(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new k(this);this.oThemeCheck=new T(this);l.info("Initialized",null,b);q.sap.measure.end("coreInit");this.bInitialized=true;l.info("Starting Plugins",null,b);this.startPlugins();l.info("Plugins started",null,b);this._createUIAreas();this.oThemeCheck.fireThemeChangedEvent(true);this._executeOnInit();this._setupRootComponent();this._setBodyAccessibilityRole();this._executeInitListeners();this.renderPendingUIUpdates();q.sap.measure.end("coreComplete");};s.prototype._createUIAreas=function(){var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i]);}o.areas=undefined;}};s.prototype._executeOnInit=function(){var o=this.oConfiguration;if(o.onInit){if(typeof o.onInit==="function"){o.onInit();}else{q.sap.globalEval(o.onInit);}o.onInit=undefined;}};s.prototype._setupRootComponent=function(){var l=q.sap.log,b="sap.ui.core.Core.init()",o=this.oConfiguration;var f=o.getRootComponent();if(f){l.info("Loading Root Component: "+f,null,b);var i=sap.ui.component({name:f});this.oRootComponent=i;var j=o["xx-rootComponentNode"];if(j&&r(i,'sap/ui/core/UIComponent')){var m=q.sap.domById(j);if(m){l.info("Creating ComponentContainer for Root Component: "+f,null,b);var n=sap.ui.requireSync('sap/ui/core/ComponentContainer'),u=new n({component:i,propagateModel:true});u.placeAt(m);}}}else{var A=o.getApplication();if(A){l.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! Please migrate from sap.ui.app.Application to sap.ui.core.Component.");l.info("Loading Application: "+A,null,b);q.sap.require(A);var v=q.sap.getObject(A);var w=new v();}}};s.prototype._setBodyAccessibilityRole=function(){var o=this.oConfiguration;var $=q("body");if(o.getAccessibility()&&o.getAutoAriaBodyRole()&&!$.attr("role")){$.attr("role","application");}};s.prototype._executeInitListeners=function(){var l=q.sap.log,b="sap.ui.core.Core.init()";var j=this.aInitListeners;this.aInitListeners=undefined;if(j&&j.length>0){l.info("Fire Loaded Event",null,b);q.each(j,function(i,f){f();});}};s.prototype.handleLoad=function(){this.bDomReady=true;var w=this.isLocked();if(!w){this.lock();}this.init();if(!w){this.unlock();}};s.prototype.isInitialized=function(){return this.bInitialized;};s.prototype.isThemeApplied=function(){return T.themeLoaded;};s.prototype.attachInitEvent=function(f){if(this.aInitListeners){this.aInitListeners.push(f);}};s.prototype.attachInit=function(f){if(this.aInitListeners){this.aInitListeners.push(f);}else{f();}};s.prototype.lock=function(){this.bLocked=true;};s.prototype.unlock=function(){this.bLocked=false;};s.prototype.isLocked=function(){return this.bLocked;};s.prototype.getConfiguration=function(){return this.oConfiguration;};s.prototype.getRenderManager=function(){return this.createRenderManager();};s.prototype.createRenderManager=function(){var o=new R();o._setFocusHandler(this.oFocusHandler);return o.getInterface();};s.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};s.prototype.loadLibrary=function(l,u){if(!L[l]){var m=l+".library",A;if(u){q.sap.registerModulePath(l,u);}if(this.oConfiguration['xx-loadAllMode']&&!q.sap.isDeclared(m)){A=m+"-all";q.sap.log.debug("load all-in-one file "+A);q.sap.require(A);}else if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){q.sap.preloadModules(m+"-preload",false);}q.sap.require(m);if(!L[l]){q.sap.log.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(true);}}return this.mLibraries[l];};s.prototype.loadLibraries=function(l,o){o=q.extend({async:true,preloadOnly:false},o);var b=this,P=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',A=o.async,f=!o.preloadOnly;function i(m){if(P){l.forEach(function(n){q.sap.preloadModules(n+".library-preload",!!m,m);});}}function j(){if(f){l.forEach(function(m){q.sap.require(m+".library");});if(b.oThemeCheck&&b.isInitialized()){b.oThemeCheck.fireThemeChangedEvent(true);}}}if(A){return new Promise(function(m,n){var u=q.sap.syncPoint("Load Libraries",function(O,w){if(!w){j();m();}else{n(new Error("failed to preload libraries"));}});var v=u.startTask("load libraries");i(u);u.finishTask(v);});}else{i(null);j();}};s.prototype.createComponent=function(v,u,i,m){if(typeof v==="string"){v={name:v,url:u};if(typeof i==="object"){v.settings=i;}else{v.id=i;v.settings=m;}}return sap.ui.component(v);};s.prototype.getRootComponent=function(){return this.oRootComponent;};s.prototype.initLibrary=function(l){var b=typeof l==="string",o=b?{name:l}:l,f=o.name,m=q.sap.log,n="sap.ui.core.Core.initLibrary()";if(b){m.warning("[Deprecated] library "+f+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!f||L[f]){return;}m.debug("Analyzing Library "+f,null,n);L[f]=true;function u(j,y){var K,V;for(K in y){V=y[K];if(V!==undefined){if(q.isArray(j[K])){if(j[K].length===0){j[K]=V;}else{j[K]=q.sap.unique(j[K].concat(V));}}else if(j[K]===undefined){j[K]=V;}else{q.sap.log.warning("library info setting ignored: "+K+"="+V);}}}return j;}q.sap.getObject(f,0);this.mLibraries[f]=o=u(this.mLibraries[f]||{name:f,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},o);function v(){var P=q.sap.properties({url:sap.ui.resource(f,"library.properties")});o.version=P.getProperty(f+"[version]");var y=P.getProperty(f+"[dependencies]");m.debug("Required Libraries: "+y,null,n);o.dependencies=(y&&y.split(/[,;| ]/))||[];var K=P.getKeys(),z=/(.+)\.(type|interface|control|element)$/,A;for(var j=0;j<K.length;j++){var H=P.getProperty(K[j]);if((A=H.match(z))!==null){o[A[2]+"s"].push(K[j]);}}}if(b){v();}for(var i=0;i<o.dependencies.length;i++){var w=o.dependencies[i];m.debug("resolve Dependencies to "+w,null,n);if(!L[w]){m.warning("Dependency from "+f+" to "+w+" has not been resolved by library itself",null,n);this.loadLibrary(w);}}a.registerInterfaceTypes(o.interfaces);for(var i=0;i<o.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(o.types[i])){q.sap.declare(o.types[i]);}}var x=o.controls.concat(o.elements);for(var i=0;i<x.length;i++){sap.ui.lazyRequire(x[i],"new extend getMetadata");}if(!o.noLibraryCSS){this._ensureThemeRoot(f,this.sTheme);if(this.oConfiguration['preloadLibCss'].indexOf(f)<0){var Q=this._getLibraryCssQueryParams(o);this.includeLibraryTheme(f,undefined,Q);}}o.sName=o.name;o.aControls=o.controls;if(!q.sap.isDeclared(f+".library")){m.warning("Library Module "+f+".library"+" not loaded automatically",null,n);q.sap.require(f+".library");}this.fireLibraryChanged({name:f,stereotype:"library",operation:"add",metadata:o});};s.prototype.includeLibraryTheme=function(l,v,Q){if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var b=(this.oConfiguration.getRTL()?"-RTL":"");var f,i=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){f="library"+v+b;}else{f=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var j=this._getThemePath(l,this.sTheme)+f+".css"+(Q?Q:"");q.sap.log.info("Including "+j+" -  sap.ui.core.Core.includeLibraryTheme()");q.sap.includeStyleSheet(j,"sap-ui-theme-"+i);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P._addLibraryTheme(i,j);}}};s.prototype._getLibraryCssQueryParams=function(l){var Q;if(this.oConfiguration["versionedLibCss"]&&l){Q="?version="+l.version;if(sap.ui.versioninfo){Q+="&sap-ui-dist-version="+sap.ui.versioninfo.version;}}return Q;};s.prototype.getLoadedLibraries=function(){return q.extend({},this.mLibraries);};s.prototype.getLibraryResourceBundle=function(l,b){l=l||"sap.ui.core";b=b||this.getConfiguration().getLanguage();var K=l+"/"+b;if(!this.mResourceBundles[K]){var u=sap.ui.resource(l,'messagebundle.properties');this.mResourceBundles[K]=q.sap.resources({url:u,locale:b});}return this.mResourceBundles[K];};s.prototype.setRoot=function(o,b){if(b){b.placeAt(o,"only");}};s.prototype.createUIArea=function(o){var b=this;if(!o){throw new Error("oDomRef must not be null");}if(typeof(o)==="string"){var i=o;if(i==S){o=this.getStaticAreaRef();}else{o=q.sap.domById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!o.id||o.id.length==0){o.id=q.sap.uid();}var f=o.id;if(!this.mUIAreas[f]){this.mUIAreas[f]=new U(this,o);if(!q.isEmptyObject(this.oModels)){var P={oModels:q.extend({},this.oModels),oBindingContexts:{}};b.mUIAreas[f]._propagateProperties(true,b.mUIAreas[f],P,true);}}else{this.mUIAreas[f].setRootNode(o);}return this.mUIAreas[f];};s.prototype.getUIArea=function(o){var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};var t=U._oRenderLog;s.prototype.addInvalidatedUIArea=function(u){if(!this._sRerenderTimer){t.debug("Registering timer for delayed re-rendering");this._sRerenderTimer=q.sap.delayedCall(0,this,"renderPendingUIUpdates");}};s.MAX_RENDERING_ITERATIONS=20;s.prototype.renderPendingUIUpdates=function(){t.debug("Render pending UI updates: start");q.sap.measure.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var u=false,l=s.MAX_RENDERING_ITERATIONS>0,i=0;this._bRendering=true;do{if(l){i++;if(i>s.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+i+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(i>1){t.debug("Render pending UI updates: iteration "+i);}}if(this._sRerenderTimer){q.sap.clearDelayedCall(this._sRerenderTimer);this._sRerenderTimer=undefined;}this.runPrerenderingTasks();var m=this.mUIAreas;for(var b in m){u=m[b].rerender()||u;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(u){this.fireUIUpdated();}t.debug("Render pending UI updates: finished");q.sap.measure.end("renderPendingUIUpdates");};s.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};s.prototype.attachUIUpdated=function(f,l){_.attachEvent(s.M_EVENTS.UIUpdated,f,l);};s.prototype.detachUIUpdated=function(f,l){_.detachEvent(s.M_EVENTS.UIUpdated,f,l);};s.prototype.fireUIUpdated=function(P){_.fireEvent(s.M_EVENTS.UIUpdated,P);};s.prototype.attachThemeChanged=function(f,l){_.attachEvent(s.M_EVENTS.ThemeChanged,f,l);};s.prototype.detachThemeChanged=function(f,l){_.detachEvent(s.M_EVENTS.ThemeChanged,f,l);};s.prototype.fireThemeChanged=function(P){q.sap.scrollbarSize(true);var b=sap.ui.require("sap/ui/core/theming/Parameters");if(b){b.reset(true);}var f=s.M_EVENTS.ThemeChanged;var o=q.Event(f);o.theme=P?P.theme:null;q.each(this.mElements,function(i,j){j._handleEvent(o);});q.sap.act.refresh();_.fireEvent(f,P);};s.prototype.attachLocalizationChanged=function(f,l){_.attachEvent(s.M_EVENTS.LocalizationChanged,f,l);};s.prototype.detachLocalizationChanged=function(f,l){_.detachEvent(s.M_EVENTS.LocalizationChanged,f,l);};s.prototype.fireLocalizationChanged=function(m){var b=s.M_EVENTS.LocalizationChanged,o=q.Event(b,{changes:m}),A=M._handleLocalizationChange;q.sap.log.info("localization settings changed: "+Object.keys(m).join(","),null,"sap.ui.core.Core");q.each(this.oModels,function(N,f){if(f&&f._handleLocalizationChange){f._handleLocalizationChange();}});function n(P){q.each(this.mUIAreas,function(){A.call(this,P);});q.each(this.mObjects["component"],function(){A.call(this,P);});q.each(this.mElements,function(){A.call(this,P);});}n.call(this,1);n.call(this,2);if(m.rtl!=undefined){q(document.documentElement).attr("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);q.each(this.mUIAreas,function(){this.invalidate();});q.sap.log.info("RTL mode "+m.rtl?"activated":"deactivated");}q.each(this.mElements,function(i,f){this._handleEvent(o);});_.fireEvent(b,{changes:m});};s.prototype.attachLibraryChanged=function(f,l){_.attachEvent(s.M_EVENTS.LibraryChanged,f,l);};s.prototype.detachLibraryChanged=function(f,l){_.detachEvent(s.M_EVENTS.LibraryChanged,f,l);};s.prototype.fireLibraryChanged=function(P){_.fireEvent(s.M_EVENTS.LibraryChanged,P);};s.prototype.applyChanges=function(){this.renderPendingUIUpdates();};s.prototype.registerElementClass=function(m){var n=m.getName(),l=m.getLibraryName()||"",o=this.mLibraries[l],b=e.prototype.isPrototypeOf(m.getClass().prototype)?'controls':'elements';if(!o){q.sap.getObject(l,0);o=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(o[b].indexOf(n)<0){o[b].push(n);q.sap.log.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};s.prototype.registerElement=function(o){var i=o.getId(),b=this.mElements[i];if(b&&b!==o){if(b._sapui_candidateForDestroy){q.sap.log.debug("destroying dangling template "+b+" when creating new object with same ID");b.destroy();}else{if(this.oConfiguration.getNoDuplicateIds()){q.sap.log.error("adding element with duplicate id '"+i+"'");throw new Error("Error: adding element with duplicate id '"+i+"'");}else{q.sap.log.warning("adding element with duplicate id '"+i+"'");}}}this.mElements[i]=o;};s.prototype.deregisterElement=function(o){delete this.mElements[o.getId()];};s.prototype.registerObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype(),f=this.getObject(b,i);if(f&&f!==o){q.sap.log.error("adding object \""+b+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+b+"\" with duplicate id '"+i+"'");}this.mObjects[b][i]=o;};s.prototype.deregisterObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype();delete this.mObjects[b][i];};s.prototype.byId=function(i){return i==null?undefined:this.mElements[i];};s.prototype.getControl=s.prototype.byId;s.prototype.getElementById=s.prototype.byId;s.prototype.getObject=function(b,i){return i==null?undefined:this.mObjects[b]&&this.mObjects[b][i];};s.prototype.getComponent=function(i){return this.getObject("component",i);};s.prototype.getTemplate=function(i){var b=sap.ui.requireSync('sap/ui/core/tmpl/Template');return b.byId(i);};s.prototype.getStaticAreaRef=function(){var o=q.sap.domById(S);if(!o){if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}var A={id:S};if(q("body").attr("role")!="application"){A.role="application";}var l=this.getConfiguration().getRTL()?"right":"left";o=q("<DIV/>",A).css({"height":"0","width":"0","overflow":"hidden","float":l}).prependTo(document.body)[0];this.createUIArea(o).bInitial=false;}return o;};s.prototype.isStaticAreaRef=function(o){return o&&(o.id===S);};s._I_INTERVAL=200;k.prototype.I_INTERVAL=s._I_INTERVAL;s.prototype.attachIntervalTimer=function(f,l){if(!this.oTimedTrigger){var b=sap.ui.requireSync("sap/ui/core/IntervalTrigger");this.oTimedTrigger=new b(s._I_INTERVAL);}this.oTimedTrigger.addListener(f,l);};s.prototype.detachIntervalTimer=function(f,l){if(this.oTimedTrigger){this.oTimedTrigger.removeListener(f,l);}};s.prototype.attachControlEvent=function(f,l){_.attachEvent(s.M_EVENTS.ControlEvent,f,l);};s.prototype.detachControlEvent=function(f,l){_.detachEvent(s.M_EVENTS.ControlEvent,f,l);};s.prototype.fireControlEvent=function(P){_.fireEvent(s.M_EVENTS.ControlEvent,P);};s.prototype._handleControlEvent=function(o,u){var b=q.Event(o.type);q.extend(b,o);b.originalEvent=undefined;this.fireControlEvent({"browserEvent":b,"uiArea":u});};s.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};s.prototype.registerPlugin=function(P){if(!P){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===P){return;}}this.aPlugins.push(P);if(this.bInitialized&&P&&P.startPlugin){P.startPlugin(this);}};s.prototype.unregisterPlugin=function(P){if(!P){return;}var b=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===P){b=i;break;}}if(b==-1){return;}if(this.bInitialized&&P&&P.stopPlugin){P.stopPlugin(this);}this.aPlugins.splice(b,1);};s.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var P=this.aPlugins[i];if(P&&P.startPlugin){P.startPlugin(this,true);}}};s.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var P=this.aPlugins[i];if(P&&P.stopPlugin){P.stopPlugin(this);}}};s.prototype.setModel=function(m,n){var b=this,P;if(!m&&this.oModels[n]){delete this.oModels[n];if(q.isEmptyObject(b.oModels)&&q.isEmptyObject(b.oBindingContexts)){P=M._oEmptyPropagatedProperties;}else{P={oModels:q.extend({},b.oModels),oBindingContexts:{}};}q.each(this.mUIAreas,function(i,u){if(m!=u.getModel(n)){u._propagateProperties(n,u,P,false,n);}});}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;q.each(this.mUIAreas,function(i,u){if(m!=u.getModel(n)){var P={oModels:q.extend({},b.oModels),oBindingContexts:{}};u._propagateProperties(n,u,P,false,n);}});}return this;};s.prototype.setMessageManager=function(m){this.oMessageManager=m;};s.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new p();}return this.oMessageManager;};s.prototype.byFieldGroupId=function(f){var b=[];for(var n in this.mElements){var o=this.mElements[n];if(o instanceof e&&o.checkFieldGroupIds(f)){b.push(o);}}return b;};s.prototype.getModel=function(n){return this.oModels[n];};s.prototype.hasModel=function(){return!q.isEmptyObject(this.oModels);};s.prototype.getEventBus=function(){if(!this.oEventBus){var b=sap.ui.requireSync('sap/ui/core/EventBus');this.oEventBus=new b();}return this.oEventBus;};s.prototype.attachValidationError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(s.M_EVENTS.ValidationError,o,f,l);return this;};s.prototype.detachValidationError=function(f,l){_.detachEvent(s.M_EVENTS.ValidationError,f,l);return this;};s.prototype.attachParseError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(s.M_EVENTS.ParseError,o,f,l);return this;};s.prototype.detachParseError=function(f,l){_.detachEvent(s.M_EVENTS.ParseError,f,l);return this;};s.prototype.attachFormatError=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(s.M_EVENTS.FormatError,o,f,l);return this;};s.prototype.detachFormatError=function(f,l){_.detachEvent(s.M_EVENTS.FormatError,f,l);return this;};s.prototype.attachValidationSuccess=function(o,f,l){if(typeof(o)==="function"){l=f;f=o;o=undefined;}_.attachEvent(s.M_EVENTS.ValidationSuccess,o,f,l);return this;};s.prototype.detachValidationSuccess=function(f,l){_.detachEvent(s.M_EVENTS.ValidationSuccess,f,l);return this;};s.prototype.fireParseError=function(A){_.fireEvent(s.M_EVENTS.ParseError,A);return this;};s.prototype.fireValidationError=function(A){_.fireEvent(s.M_EVENTS.ValidationError,A);return this;};s.prototype.fireFormatError=function(A){_.fireEvent(s.M_EVENTS.FormatError,A);return this;};s.prototype.fireValidationSuccess=function(A){_.fireEvent(s.M_EVENTS.ValidationSuccess,A);return this;};s.prototype.isMobile=function(){return D.browser.mobile;};s.prototype._getEventProvider=function(){return _;};s.prototype.addPrerenderingTask=function(P){this.aPrerenderingTasks.push(P);this.addInvalidatedUIArea();};s.prototype.runPrerenderingTasks=function(){var b=this.aPrerenderingTasks.slice();this.aPrerenderingTasks=[];b.forEach(function(P){P();});};s.prototype.destroy=function(){this.oFocusHandler.destroy();_.destroy();c.prototype.destroy.call(this);};sap.ui.setRoot=function(o,b){sap.ui.getCore().setRoot(o,b);};return new s().getInterface();});
