/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/core/UIArea','./DOMElement','./Template'],function(q,C,D,l,U,a,T){"use strict";var b=C.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}}});b.prototype.init=function(){this._aBindingInfos=[];};b.prototype.isInline=function(){var i=false,p=this.getParent();if(p instanceof U&&q(p.getRootNode()).attr("id")===this.getId()){i=true;}return i;};b.prototype.placeAt=function(r,p){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};b.prototype.getTemplateRenderer=function(){return this.fnRenderer;};b.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};b.prototype._cleanup=function(){this.destroyAggregation("controls");if(this._aBindingInfos){var t=this;q.each(this._aBindingInfos,function(i,B){t.getModel(B.model).removeBinding(B.binding);});this._aBindingInfos=[];}};b.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),d=t&&t.getDeclarativeSupport();if(d){var c=this;setTimeout(function(){D.compile(c.getDomRef());});}};b.prototype.exit=function(){this._cleanup();};b.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};b.prototype.onAfterRendering=function(){this.fireAfterRendering();};b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);c.fnRenderer=this.fnRenderer;return c;};b.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};b.prototype.bind=function(p,t){var P=T.parsePath(p),m=this.getModel(P.model),p=P.path,M=t?"bind"+q.sap.charToUpperCase(t):"bindProperty",B=m&&m[M](p),c=this;if(B){B.attachChange(function(){q.sap.log.debug("TemplateControl#"+c.getId()+": "+t+" binding changed for path \""+p+"\"");c.invalidate();});}this._aBindingInfos.push({binding:B,path:P.path,model:P.model});return B;};b.prototype.calculatePath=function(p,t){var B=this.getBindingContext(),s=B&&B.getPath();if(p&&s&&!q.sap.startsWith(p,"/")){if(!q.sap.endsWith(s,"/")){s+="/";}p=s+p;}return p;};b.prototype.bindProp=function(p){var B=this.bind(this.calculatePath(p),"property");return B&&B.getExternalValue();};b.prototype.bindList=function(p){var B=this.bind(this.calculatePath(p),"list"),m=B&&B.getModel(),p=B&&B.getPath();return B&&m.getProperty(p);};b.prototype.createDOMElement=function(s,p,d){var e=new a(s);if(p){e.bindObject(p);}if(!d){this.addAggregation("controls",e);}return e;};b.prototype.createControl=function(s,p,d,v){var h={};q.each(s,function(k,V){h["data-"+q.sap.hyphen(k)]=V;});var $=q("<div/>",h);var c=D._createControl($.get(0),v);if(p){c.bindObject(p);}if(!d){this.addAggregation("controls",c);}return c;};return b;});
