/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/ContextBinding","./_Context","./_ODataHelper","./lib/_Cache","./lib/_Helper"],function(q,B,C,a,_,b,c,d){"use strict";var s="sap.ui.model.odata.v4.ODataContextBinding",S={change:true,dataReceived:true,dataRequested:true};var O=a.extend("sap.ui.model.odata.v4.ODataContextBinding",{constructor:function(m,p,o,P){var e,i=p.indexOf("(...)"),D=i>=0;a.call(this,m,p,o);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.oCache=undefined;this.sGroupId=undefined;this.oOperation=undefined;this.mQueryOptions=undefined;this.sRefreshGroupId=undefined;this.sUpdateGroupId=undefined;if(!this.bRelative||D){this.mQueryOptions=b.buildQueryOptions(m.mUriParameters,P,["$expand","$filter","$orderby","$select"]);e=b.buildBindingParameters(P);this.sGroupId=e.$$groupId;this.sUpdateGroupId=e.$$updateGroupId;if(D){this.oOperation={bAction:undefined,oMetadataPromise:undefined,mParameters:{}};if(i!==p.length-5){throw new Error("The path must not continue after a deferred operation: "+p);}}else{this.oCache=c.createSingle(m.oRequestor,p.slice(1),this.mQueryOptions);}}else if(P){throw new Error("Bindings with a relative path do not support parameters");}},metadata:{publicMethods:[]}});O.prototype._requestOperationMetadata=function(){var m=this.oModel.getMetaModel(),o,p;if(!this.oOperation.oMetadataPromise){p=this.sPath.lastIndexOf("/");o=this.sPath.slice(p+1,-5);this.oOperation.oMetadataPromise=m.requestObject("/"+o).then(function(M){if(!M){throw new Error("Unknown operation: "+o);}if(Array.isArray(M)&&M[0].$kind==="Action"){return M;}if(Array.isArray(M)&&M[0].$kind==="Function"){throw new Error("Functions without import not supported: "+o);}if(M.$kind==="ActionImport"){return m.requestObject("/"+M.$Action);}if(M.$kind==="FunctionImport"){return m.requestObject("/"+M.$Function);}throw new Error("Not an operation: "+o);}).then(function(e){if(e.length!==1){throw new Error("Unsupported operation overloading: "+o);}return e[0];});}return this.oOperation.oMetadataPromise;};O.prototype.attachEvent=function(e){if(!(e in S)){throw new Error("Unsupported event '"+e+"': v4.ODataContextBinding#attachEvent");}return a.prototype.attachEvent.apply(this,arguments);};O.prototype.execute=function(g){var t=this;function e(o,p){var f,P,h=(p+t.sPath).slice(1),i;g=g||t.getGroupId();t.oOperation.bAction=o.$kind==="Action";if(t.oOperation.bAction){if(!t.oCache){t.oCache=c.createSingle(t.oModel.oRequestor,h.slice(0,-5),t.mQueryOptions,false,true);}i=t.oCache.post(g,t.oOperation.mParameters);}else{f=o.$Parameter;P=[];if(f){f.forEach(function(j){var n=j.$Name;if(n in t.oOperation.mParameters){if(j.$IsCollection){throw new Error("Unsupported: collection parameter");}P.push(encodeURIComponent(n)+"="+encodeURIComponent(d.formatLiteral(t.oOperation.mParameters[n],j.$Type)));}});}t.oCache=c.createSingle(t.oModel.oRequestor,h.replace("...",P.join(',')),t.mQueryOptions);i=t.oCache.read(g);}t.oModel.addedRequestToGroup(g);return i;}b.checkGroupId(g);if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(this.bRelative){if(!this.oContext){throw new Error("Unresolved binding: "+this.sPath);}if(this.oContext.getPath().indexOf("(...)")>=0){throw new Error("Nested deferred operation bindings not supported: "+this.oModel.resolve(this.sPath,this.oContext));}}return this._requestOperationMetadata().then(function(o){if(t.bRelative){return t.oModel.requestCanonicalPath(t.getContext()).then(function(p){return e(o,p+"/");});}return e(o,"");}).then(function(r){t._fireChange({reason:C.Change});})["catch"](function(E){t.oModel.reportError("Failed to execute "+t.sPath,s,E);throw E;});};O.prototype.getGroupId=function(){return this.sGroupId||this.oModel.getGroupId();};O.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId||this.oModel.getUpdateGroupId();};O.prototype.initialize=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oElementContext=_.create(this.oModel,this,r);this._fireChange({reason:C.Change});};O.prototype.isInitial=function(){throw new Error("Unsupported operation: v4.ODataContextBinding#isInitial");};O.prototype.refresh=function(g){if(this.oCache){if(!this.oOperation||!this.oOperation.bAction){b.checkGroupId(g);this.sRefreshGroupId=g;this.oCache.refresh();this._fireChange({reason:C.Refresh});}}else if(!this.oOperation){throw new Error("Refresh on this binding is not supported");}};O.prototype.requestValue=function(p){var D=false,g,t=this;if(this.oCache){g=this.sRefreshGroupId||this.getGroupId();this.sRefreshGroupId=undefined;return this.oCache.read(g,p,function(){D=true;t.oModel.addedRequestToGroup(g,t.fireDataRequested.bind(t));}).then(function(v){if(D){t.fireDataReceived();}return v;},function(e){if(D){if(e.canceled){t.fireDataReceived();}else{t.oModel.reportError("Failed to read path "+t.sPath,s,e);t.fireDataReceived({error:e});}}throw e;});}if(this.oContext){return this.oContext.requestValue(this.sPath+(p?"/"+p:""));}return Promise.resolve();};O.prototype.resume=function(){throw new Error("Unsupported operation: v4.ODataContextBinding#resume");};O.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative&&(this.oElementContext||o)){this.oElementContext=o?_.create(this.oModel,this,this.oModel.resolve(this.sPath,o)):null;this.oCache=undefined;B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};O.prototype.setParameter=function(p,v){if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(v===undefined){throw new Error("Missing value for parameter: "+p);}this.oOperation.mParameters[p]=v;return this;};O.prototype.suspend=function(){throw new Error("Unsupported operation: v4.ODataContextBinding#suspend");};O.prototype.toString=function(){return s+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};O.prototype.updateValue=function(g,p,v,e,P){var o;if(this.oCache){g=g||this.getUpdateGroupId();o=this.oCache.update(g,p,v,e,P);this.oModel.addedRequestToGroup(g);return o;}return this.oContext.updateValue(g,p,v,e,this.sPath+(P?"/"+P:""));};return O;},true);
