/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/json/JSONListBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","./_ODataHelper","./_SyncPromise"],function(q,B,C,a,F,J,M,P,_,b){"use strict";var D=q.sap.log.Level.DEBUG,O,c,o="sap.ui.model.odata.v4.ODataMetaModel",d,r=/\([^/]*|\/\d+/g,e=/^\d+$/,u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},s={messageChange:true},W=q.sap.log.Level.WARNING;O=C.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(m,p,g){C.call(this,m,p,g);},initialize:function(){var E=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(E!==this.oElementContext){this.oElementContext=E;this._fireChange();}},setContext:function(g){if(g!==this.oContext){this.oContext=g;if(!this.bInitial){this.initialize();}}}});c=J.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{applyFilter:function(){var t=this;this.aIndices=F.apply(this.aIndices,this.aFilters.concat(this.aApplicationFilters),function(R,p){return p==="@sapui.name"?R:t.oModel.getProperty(p,t.oList[R]);});this.iLength=this.aIndices.length;},constructor:function(){J.apply(this,arguments);},enableExtendedChangeDetection:function(){throw new Error("Unsupported operation");}});d=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=this.oModel.getProperty(this.sPath,this.oContext);},getValue:function(){return this.vValue;},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var f=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(R,U){M.call(this);this.sDefaultBindingMode=B.OneTime;this.oMetadataPromise=null;this.oRequestor=R;this.mSupportedBindingModes={"OneTime":true};this.sUrl=U;}});f.prototype._getObject=function(p,g){var i=false,I=p==="@"||p===""&&g.getPath().slice(-2)==="/@"||p.slice(-2)==="/@",k,h,R;if(I||p==="/"){h=p;}else if(p){h=p+"/";}else{h="./";}R=this.getObject(h,g);for(k in R){if(k[0]==="$"||I===(k[0]!=="@")){if(!i){R=q.extend({},R);i=true;}delete R[k];}}return R;};f.prototype.attachEvent=function(E){if(!(E in s)){throw new Error("Unsupported event '"+E+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};f.prototype.bindContext=function(p,g){return new O(this,p,g);};f.prototype.bindList=function(p,g,S,h){return new c(this,p,g,S,h);};f.prototype.bindProperty=function(p,g){return new d(this,p,g);};f.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};f.prototype.fetchEntityContainer=function(){if(!this.oMetadataPromise){this.oMetadataPromise=b.resolve(this.oRequestor.read(this.sUrl));}return this.oMetadataPromise;};f.prototype.fetchObject=function(p,g){var R=this.resolve(p,g);if(!R){q.sap.log.error("Invalid relative path w/o context",p,o);return b.resolve(null);}return this.fetchEntityContainer().then(function(S){var l,n,h=true,j,k,t,v=S;function m(L){var i;if(q.sap.log.isLoggable(L)){i=Array.isArray(l)?l.join("/"):l;q.sap.log[L===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(i?" at /"+i:""),R,o);}v=undefined;return false;}function w(Q,i){if(!(Q in S)){l=l||t&&t+"/"+i;return m(W,"Unknown qualified name '",Q,"'");}t=n=k=Q;v=j=S[k];return true;}function x(z,i,A){var I,E,G;if(z==="$Annotations"){return m(W,"Invalid segment: $Annotations");}if(z.length>11&&z.slice(-11)==="@sapui.name"){I=z.length-11;}else{I=z.indexOf("@");}if(I>0){if(!x(z.slice(0,I),i,A)){return false;}z=z.slice(I);G=true;}if(!(G&&z==="@sapui.name")&&typeof v==="string"&&!y(v,A.slice(0,i))){return false;}if(h){if(z[0]==="$"||e.test(z)){h=false;}else if(!G){if(z[0]!=="@"&&z.indexOf(".")>0){return w(z);}else if(v&&"$Type"in v){if(!w(v.$Type,"$Type")){return false;}}else if(v&&"$Action"in v){if(!w(v.$Action,"$Action")){return false;}}else if(v&&"$Function"in v){if(!w(v.$Function,"$Function")){return false;}}else if(i===0){t=n=k=k||S.$EntityContainer;v=j=j||S[k];if(z&&z[0]!=="@"&&!(z in j)){return m(W,"Unknown child '",z,"' of '",k,"'");}}if(Array.isArray(v)){if(v.length!==1){return m(W,"Unsupported overloads");}v=v[0].$ReturnType;t=t+"/0/$ReturnType";if(v){if(z==="value"&&!(S[v.$Type]&&S[v.$Type].value)){n=undefined;return true;}if(!w(v.$Type,"$Type")){return false;}}}}}if(!z){return i+1>=A.length||m(W,"Invalid empty segment");}if(z==="@sapui.name"){v=n;if(v===undefined){m(W,"Unsupported path before @sapui.name");}else if(i+1<A.length){m(W,"Unsupported path after @sapui.name");}return false;}if(!v||typeof v!=="object"){return m(D,"Invalid segment: ",z);}if(h&&z[0]==="@"){E=k.slice(0,k.lastIndexOf(".")+1);v=E===k?j:(S[E].$Annotations||{})[t]||{};h=false;}if(z!=="@"){n=h||z[0]==="@"?z:undefined;t=h?t+"/"+z:undefined;v=v[z];}return true;}function y(i,N){var z;if(l){return m(W,"Invalid recursion");}l=N;h=true;v=S;z=i.split("/").every(x);l=undefined;return z;}y(R.slice(1));return v;});};f.prototype.fetchUI5Type=function(p){var m=this.getMetaContext(p),t=this;return this.fetchObject(undefined,m).then(function(g){var h,n,T=g["$ui5.type"],i,j="sap.ui.model.odata.type.Raw";function k(K,v){if(v!==undefined){h=h||{};h[K]=v;}}if(T){return T;}if(g.$isCollection){q.sap.log.warning("Unsupported collection type, using "+j,p,o);}else{i=u[g.$Type];if(i){j=i.type;for(n in i.constraints){k(i.constraints[n],n[0]==="@"?t.getObject(n,m):g[n]);}if(g.$Nullable===false){k("nullable",false);}}else{q.sap.log.warning("Unsupported type '"+g.$Type+"', using "+j,p,o);}}T=new(q.sap.getObject(j,0))(undefined,h);g["$ui5.type"]=T;return T;});};f.prototype.getMetaContext=function(p){return new a(this,p.replace(r,""));};f.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};f.prototype.getObject=b.createGetMethod("fetchObject");f.prototype.getProperty=f.prototype.getObject;f.prototype.getUI5Type=b.createGetMethod("fetchUI5Type",true);f.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};f.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};f.prototype.requestCanonicalUrl=function(S,p,g){var m=p.replace(r,""),h=m.slice(1).split("/");return Promise.all([g.requestValue(""),this.fetchEntityContainer()]).then(function(v){var E=v[0],i=v[1],j=i[i.$EntityContainer],k=h.shift(),l=j[k],n=i[l.$Type];h.forEach(function(t){var N=n[t];if(!N||N.$kind!=="NavigationProperty"){throw new Error("Not a navigation property: "+t+" ("+p+")");}k=l.$NavigationPropertyBinding[t];l=j[k];n=i[N.$Type];});return S+encodeURIComponent(k)+_.getKeyPredicate(n,E);});};f.prototype.requestObject=b.createRequestMethod("fetchObject");f.prototype.requestUI5Type=b.createRequestMethod("fetchUI5Type");f.prototype.resolve=function(p,g){var h,i;if(!p){return g?g.getPath():undefined;}i=p[0];if(i==="/"){return p;}if(!g){return undefined;}if(i==="."){if(p[1]!=="/"){throw new Error("Unsupported relative path: "+p);}p=p.slice(2);}h=g.getPath();return i==="@"||h.slice(-1)==="/"?h+p:h+"/"+p;};f.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};f.prototype.toString=function(){return o+": "+this.sUrl;};return f;},true);
