/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,a,c,P,R,S,b,d,e,f,F,g,h,k,m,n,T,o,p,r,s){"use strict";var G=n.GroupEventType,N=n.NavigationMode,t=n.SelectionBehavior,u=n.SelectionMode,v=n.SharedDomRef,w=n.SortOrder,V=n.VisibleRowCountMode;var x,M,y,z;var A=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:u.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:t.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();A.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this.setNoDataText=function(j){if(!(this.getNoData()instanceof C)){this.setNoData(j);}q.sap.log.error("Function setNoDataText of control sap.ui.table.Table must not be used!");return this;};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;var i=this;this._performUpdateRows=function(j){if(!i.bIsDestroyed){i._lastCalledUpdateRows=Date.now();i._updateBindingContexts(undefined,undefined,j);if(!i._bInvalid){if(i._updateTableContent){i._updateTableContent();}i._getAccExtension().updateAccForCurrentCell(false);i._updateSelection();i._updateGroupHeader();var l=i._collectTableSizes();i._updateRowHeader(l.tableRowHeights);i._syncColumnHeaders(l);if(T.isVariableRowHeightEnabled(i)){i._adjustTablePosition();}if(i._bBindingLengthChanged||T.isVariableRowHeightEnabled(i)){i._updateVSb(l);}}i._mTimeouts.bindingTimer=undefined;i.fireEvent("_rowsUpdated");}i._bBindingLengthChanged=false;};this._initSelectionModel(g.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._oCalcColumnWidths=[];this._aTableHeaders=[];this._iLastHoveredColumnIndex=0;this._aIdxCols2Cells=[];this._aVisibleColumns=[];this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._doubleclickDelay=300;this._clicksRegistered=0;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};A.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}o.enrich(this,s);o.enrich(this,r);o.enrich(this,p);this._bExtensionsInitialized=true;};A.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();};A.prototype._detachExtensions=function(){if(!this._bExtensionsInitialized){return;}this._getPointerExtension().destroy();this._getKeyboardExtension().destroy();this._getAccExtension().destroy();delete this._bExtensionsInitialized;};A.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};A.prototype._collectRowHeights=function(){var j=this.getDomRef();if(!j){return[];}var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var B=j.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var H=[];for(var i=0;i<B.length;i++){var J=0;if(l[i]){var K=l[i].getBoundingClientRect();J=K.bottom-K.top;}var L=B[i].getBoundingClientRect();var O=L.bottom-L.top;H.push(Math.max(J,O));}return H;};A.prototype._resetRowHeights=function(){var j=this.getRowHeight();var l="";if(j){l=j+"px";}var B=this.getDomRef();if(B){var H=B.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<H.length;i++){H[i].style.height=l;}}};A.prototype._determineAvailableSpace=function(){var i=this.getDomRef();if(i&&i.parentNode){var j=i.querySelector(".sapUiTableCCnt");if(j){var U=i.scrollHeight-j.clientHeight;return q(i.parentNode).height()-U;}}return 0;};A.prototype._collectTableSizes=function(j){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlRowScrollTop:0,tableCtrlRowScrollHeight:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,columnRowHeight:0,columnRowOuterHeight:0,invisibleColWidth:0};var B=this.getDomRef();if(!B){return l;}var H=B.querySelector(".sapUiTableCnt");if(H){l.tableCntHeight=H.clientHeight;l.tableCntWidth=H.clientWidth;}var J=B.querySelector(".sapUiTableCtrlScroll");if(J){l.tableCtrlScrollWidth=J.clientWidth;}var K=B.querySelector(".sapUiTableRowHdrScr");if(K){l.tableRowHdrScrWidth=K.clientWidth;}var L=B.querySelector(".sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll");if(L){l.tableCtrlRowScrollTop=L.offsetTop;l.tableCtrlRowScrollHeight=L.offsetHeight;}var O=B.querySelector(".sapUiTableCtrlScr");if(O){l.tableCtrlScrWidth=O.clientWidth;}var Q=this.getDomRef(v.HorizontalScrollBar);if(Q){l.tableHSbScrollLeft=Q.scrollLeft;}var U=B.querySelector(".sapUiTableCtrlFixed");if(U){l.tableCtrlFixedWidth=U.clientWidth;}var W=this.getProperty("fixedColumnCount");var X=[];var Y=0;var Z=B.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(Z){for(var i=0;i<Z.length;i++){var $=Z[i].getBoundingClientRect();var _=$.right-$.left;X.push(_);if(i<W){Y+=_;}}}if(W>0){var a1=0;var b1=this.getDomRef("sapUiTableRowHdrScr");if(b1){a1+=b1.clientWidth;}var c1=this.getDomRef("vsb");if(c1){a1+=c1.offsetWidth;}var d1=(B.clientWidth-a1<Y);if(this._bIgnoreFixedColumnCount!=d1){this._bIgnoreFixedColumnCount=d1;this.invalidate();}}l.headerWidths=X;if(this.getSelectionMode()!==u.None&&this.getSelectionBehavior()!==t.RowOnly){var e1=B.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(e1){l.invisibleColWidth=e1.clientWidth;}}var f1=B.querySelector(".sapUiTableCol");if(f1){l.columnRowHeight=f1.clientHeight;l.columnRowOuterHeight=f1.offsetHeight;}if(!j){l.tableRowHeights=this._collectRowHeights();}else{l.tableRowHeights=j;}return l;};A.prototype._updateRowHeader=function(j){var l=this.getDomRef();if(!l){return;}var B=l.querySelectorAll(".sapUiTableRowHdr");var H=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var J=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(B.length,J.length,0);for(var i=0;i<L;i++){var K=j[i];if(K){if(B[i]){B[i].style.height=K+"px";}if(H[i]){H[i].style.height=K+"px";}if(J[i]){J[i].style.height=K+"px";}}}};A.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var j=this.getVisibleRowCountMode();if(T.isVariableRowHeightEnabled(this)){var l=this.getDomRef(v.VerticalScrollBar);if(l){this._iOldScrollTop=l.scrollTop;}}var B=this.getRows();if(j==V.Interactive||j==V.Fixed||(j==V.Auto&&this._iTableRowContentHeight&&B.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var H=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){H._adjustRows(H._calculateRowsToDisplay());H._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&B.length>0){this._adjustRows(B.length);}};A.prototype.onAfterRendering=function(j){if(j&&j.isMarked("insertTableRows")){return;}this._iDefaultRowHeight=undefined;this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var B=this.getColumns();for(var i=0,l=B.length;i<l;i++){if(B[i].getVisible()){B[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}if(T.isVariableRowHeightEnabled(this)){var H=this.getDomRef(v.VerticalScrollBar);if(H){H.scrollTop=Math.max(H.scrollTop,this._iOldScrollTop);}}this._updateGroupHeader();if(this._updateTableContent){this._updateTableContent();}if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};A.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var i=C.prototype.invalidate.call(this);}return i;};A.prototype._initRowDomRefs=function(){var j=this.getRows();for(var i=0;i<j.length;i++){j[i].initDomRefs();}};A.prototype._updateTableSizes=function(i,j){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var l=this.getDomRef();if(this._bInvalid||!l){return;}this._resetRowHeights();var B=this._collectRowHeights();this._getDefaultRowHeight(B);var H=0;if(!j&&this.getVisibleRowCountMode()==V.Auto){H=this._determineAvailableSpace();if(this._handleRowCountModeAuto(H)&&!i){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var J=this._collectTableSizes(B);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(J.tableCntHeight==0&&J.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(J.tableRowHeights);this._syncColumnHeaders(J);this._determineVisibleCols(J);if(!j){this._setRowContentHeight(H);}this._updateHSb(J);this._updateVSb(J);this.$().find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}var K=this;this._mTimeouts.afterUpdateTableSizes=window.setTimeout(function(){T.registerResizeHandler(K,"",K._onTableResize.bind(K),true);},0);};A.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var j=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(j);}return this;};A.prototype._updateGroupHeader=function(){var i=this;if(this._modifyRow){q.each(this.getRows(),function(j,l){i._modifyRow(j+i.getFirstVisibleRow(),l.$());i._modifyRow(j+i.getFirstVisibleRow(),l.$("fixed"));});}};A.prototype._updateFixedBottomRows=function(){var j=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&j>0){var $=q(l).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var B=this.getBinding("rows");if(B){var H=this.getVisibleRowCount();var J=false;var K=this.getRows();var L=this._getSanitizedFirstVisibleRow();for(var i=0;i<K.length;i++){var O=K[i].getDomRefs(true);if(this._iBindingLength>=H){J=(i==H-j-1);}else{J=(L+i)==(this._iBindingLength-j-1)&&(L+i)<this._iBindingLength;}O.row.toggleClass("sapUiTableFixedPreBottomRow",J);}}}};A.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};A.prototype.applyFocusInfo=function(i){if(i&&i.customId){this.$().find("#"+i.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};A.prototype.setTitle=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});j.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",j);return this;};A.prototype.setFooter=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});}this.setAggregation("footer",j);return this;};A.prototype.setSelectionMode=function(i){this.clearSelection();if(i===u.Single){this._oSelection.setSelectionMode(g.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(g.MULTI_SELECTION);}if(i===u.Multi){i=u.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}this.setProperty("selectionMode",i);return this;};A.prototype._adjustTablePosition=function(){var i=this.getDomRef(v.VerticalScrollBar).scrollTop;var j=this._getDefaultRowHeight();var l=i%j;var B=this.$().find(".sapUiTableCtrlRowScroll, .sapUiTableRowHdrScr");if(this._iBindingLength<=this.getVisibleRowCount()){B.css({"transform":"translate3d(0px, "+(-i)+"px, 0px)"});}else{var H=this._calculateRowCorrection(j,l,i);B.css({"transform":"translate3d(0px, "+(-H)+"px, 0px)"});}};A.prototype._calculateRowCorrection=function(i,j,l){var B=this.getFirstVisibleRow();var H=this._iBindingLength-this.getVisibleRowCount();if(B<H){var J=T.getRowHeightByIndex(this,0)-i;return Math.floor(j*(J/i))+j;}else if(B==H){return l-(this._iBindingLength*i)+this.getDomRef("tableCCnt").clientHeight;}};A.prototype.setFirstVisibleRow=function(i,O,j){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var l=this.getVisibleRowCount();var B=this._paginatorCalculateTargetPage(i,l);var H=(B-1)*l;if(i!=H){i=H;B=this._paginatorCalculateTargetPage(i,l);}this._paginatorUpdate(B);}var J=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(T.isVariableRowHeightEnabled(this)&&this.getBinding("rows")&&!this._bRefreshing&&!J){this._adjustTablePosition();}if(J&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(this.getNavigationMode()==N.Scrollbar){if(!O){var K=this.getDomRef(v.VerticalScrollBar);if(K){K.scrollTop=i*(this._getDefaultRowHeight()||28);}}}}if(J&&!j){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};A.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;A.prototype.bindRows=function(B,i,j,l){if(typeof B==="string"&&(i instanceof h||q.isArray(j)&&j[0]instanceof F)){l=j;j=i;i=undefined;}return this.bindAggregation("rows",B,i,j,l);};A.prototype._bindAggregation=function(i,j,l,B,H){E.prototype._bindAggregation.apply(this,arguments);var J=this.getBinding("rows");if(i==="rows"&&J){J.attachChange(this._onBindingChange,this);}this._initSelectionModel(g.MULTI_SELECTION);if(J&&this.isTreeBinding("rows")&&!J.hasListeners("selectionChanged")){J.attachSelectionChanged(this._onSelectionChanged,this);}return this;};A.prototype._initSelectionModel=function(i){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new g(i);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};A.prototype._onBindingChange=function(i){var j=typeof(i)==="object"?i.getParameter("reason"):i;if(j==="sort"||j==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};A.prototype.unbindAggregation=function(i,j){var B=this.getBinding("rows");if(i==="rows"&&this.isBound("rows")){j=true;}var l=E.prototype.unbindAggregation.apply(this,[i,j]);if(i==="rows"&&B){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return l;};A.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var j=this.getVisibleRowCountMode();if(j==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var l=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=l&&l>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};A.prototype.setTooltip=function(i){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",i,true);};A.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};A.prototype._getFixedBottomRowContexts=function(i,B){var j=this.getBinding("rows");var l=[];if(!j){return l;}i=i||this.getFixedBottomRowCount();B=B||j.getLength();var H=this.getVisibleRowCount();if(i>0&&(H-i)<B){l=this._getContexts(B-i,i,1);}return l;};A.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};A.prototype._getContexts=function(i,l,j){var B=this.getBinding("rows");if(B){return B.getContexts(i,l,j);}else{return[];}};A.prototype._getRowContexts=function(j,l,B){var H=false;var J=[];var K=this.getBinding("rows");var L=j||this.getRows().length;if(!K||L<=0){return[];}var O=this.getFirstVisibleRow();var Q=this.getFixedRowCount();var U=this.getFixedBottomRowCount();var W=0;var X;var Y=L-U;var Z=0;var $=Y;var _=this.getThreshold();_=_?Math.max(L,_):0;var a1=O;var b1=function(g1,h1,a1){for(var i=0;i<h1.length;i++){g1[a1+i]=h1[i];}};if(Q>0&&O>0){a1=O+Q;Y-=Q;Z=Q;X=this._getFixedRowContexts(Q);W+=X.length;J=J.concat(X);}X=this._getContexts(a1,Y,_);var c1=this._updateBindingLength(B);H=X.length<Math.min(Y,c1-U);if(this.getNavigationMode===N.Paginator){var d1=Math.min(Y,(Math.max(c1-O-U,0)));if(d1<Y){Y=d1;X=X.slice(0,Y);}}W+=X.length;b1(J,X,Z);$=Math.min($,Math.max(c1-U,0));if(U>0){X=this._getFixedBottomRowContexts(U,c1);W+=X.length;b1(J,X,$);}if(H&&!l){var e1=this._getSanitizedFirstVisibleRow(true);if(O!=e1){J=this._getRowContexts(L,true);W=J.length;}}if(!l){var f1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){f1._setBusy({requestedLength:Q+Y+U,receivedLength:W,contexts:J,reason:B});},0);}return J;};A.prototype._getSanitizedFirstVisibleRow=function(U){var i=this.getNavigationMode();var j=this.getVisibleRowCount();var l=this.getFirstVisibleRow();l=Math.max(l,0);if(i===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){l=Math.min(l,Math.max(this._iBindingLength-j,0));}else if(i===N.Paginator&&this._oPaginator){var B=this._paginatorCalculateTargetPage(l,j);l=(B-1)*j;if(U){this._paginatorUpdate(B);}}if(U){this.setProperty("firstVisibleRow",l,true);}return l;};A.prototype._paginatorCalculateTargetPage=function(i,j){if(this._oPaginator){var l=1;if(i<this._iBindingLength){l=Math.ceil((i+1)/j);}return l;}};A.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};A.prototype._updateBindingLength=function(i){var B=this.getBinding("rows");var j=0;if(B){j=B.getLength();}if(j!=this._iBindingLength){this._iBindingLength=j;this._onBindingLengthChange(i);}return j;};A.prototype._onBindingLengthChange=function(i){this._updateFixedBottomRows();this._toggleVSb();this._bBindingLengthChanged=true;if(i!="skipNoDataUpdate"){this._updateNoData();}};A.prototype.refreshRows=function(i){var B=this.getBinding("rows");if(!B){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var j=this;var l=typeof(i)==="object"?i.getParameter("reason"):i;if(l==e.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var H=this.getVisibleRowCountMode();if((this.bOutput&&H===V.Auto)||H!==V.Auto){var J=this._calculateRowsToDisplay();if(this.bOutput){this.getBinding("rows").attachEventOnce("dataRequested",function(){if(j._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(j._mTimeouts.refreshRowsAdjustRows);}j._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){j._adjustRows(J,true);},0);});}var U;if(l==e.Filter||l==e.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,J,U);}};A.prototype.updateRows=function(i){if(this._bExitCalled){return;}this._setBusy(i?{changeReason:i}:false);if(this._bBindingLengthChanged){this._updateNoData();}var j=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((j==V.Auto&&this.bOutput)||j!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var B=(i==e.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||i=="unbindAggregation"?0:this._iBindingTimerDelay);var l=this;if(B==0&&i){Promise.resolve().then(function(){l._performUpdateRows(i);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(i);},B);}}};A.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};A.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};A.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};A.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};A.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};A.prototype.autoResizeColumn=function(i){var j=this.getColumns()[i];this._iColumnResizeStart=null;var l=this._calculateAutomaticColumnWidth(i);if(l==null){return;}j._iNewWidth=l;this._oCalcColumnWidths[i]=j._iNewWidth;this._onColumnResized(null,i);};A.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(l){l.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").on("scroll.sapUiTablePreventCCntScroll",function(l){l.target.scrollTop=0;});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(l)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableColRsz").mousedown(q.proxy(this._onColumnResizeStart,this));$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").mousemove(q.proxy(this._onScrPointerMove,this));this._enableColumnAutoResizing();var i=q(this.getDomRef(v.VerticalScrollBar));var j=q(this.getDomRef(v.HorizontalScrollBar));i.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));j.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));j.bind("mousedown.sapUiTableHScroll",function(l){l.preventDefault();});i.bind("mousedown.sapUiTableVScroll",function(l){l.preventDefault();});if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(l){if(q(l.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}};A.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").unbind();$.find(".sapUiTableColRsz").unbind();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").unbind("scroll.sapUiTablePreventCCntScroll");}var i=q(this.getDomRef(v.VerticalScrollBar));i.unbind("scroll.sapUiTableVScroll");i.unbind("mousedown.sapUiTableVScroll");var j=q(this.getDomRef(v.HorizontalScrollBar));j.unbind("scroll.sapUiTableHScroll");j.unbind("mousedown.sapUiTableHScroll");var l=this._getScrollTargets();l.unbind("MozMousePixelScroll.sapUiTableMouseWheel");l.unbind("wheel.sapUiTableMouseWheel");var B=q(document.body);B.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);};A.prototype._onScrPointerMove=function(j){var l=this.getDomRef();if(this._bIsColumnResizerMoving||!l){return;}var B=j.clientX;var H=l.getBoundingClientRect();var L=0;var J;if(this._bRtlMode){J=10000;}else{J=-10000;}for(var i=0;i<this._aTableHeaders.length;i++){var K=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if(B<K.right-5){L=i;J=K.left-H.left;}}else{if(B>K.left+5){L=i;J=K.right-H.left;}}}var O=this._getVisibleColumns()[L];if(O&&O.getResizable()){this.$().find(".sapUiTableColRsz").css("left",J+"px");this._iLastHoveredColumnIndex=L;}};A.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var i=q(this.getDomRef("rsz"));var j=q(this.getDomRef("sapUiTableCtrlScrFixed"));var l=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(j).add(l).add(i);};A.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};A.prototype._updateHSb=function(i){var $=this.$();var j=i.tableCtrlScrollWidth;if(!!D.browser.safari){j=Math.max(j,this._getColumnsWidth(this.getFixedColumnCount()));}if(j>i.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var l=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){l.width(j);}else{l.outerWidth(j);}}}var B=i.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){B+=i.tableRowHdrScrWidth;}if(this.getRows().length>0){var H=$.find(".sapUiTableHSb");if(this._bRtlMode){H.css('margin-right',B+'px');}else{H.css('margin-left',B+'px');}}var J=this.getDomRef("hsb-content");if(J){J.style.width=j+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};A.prototype._updateVSb=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(!j){return;}var l=this.getFixedRowCount();var B=this.getFixedBottomRowCount();if(l>0||B>0){var $=q(j);if(l>0){$.css('top',(i.tableCtrlRowScrollTop-1)+'px');}if(B>0){$.css('height',i.tableCtrlRowScrollHeight+'px');}}var H=this._getDefaultRowHeight();var J=(this._iBindingLength-l-B)*H;if(T.isVariableRowHeightEnabled(this)){var K=0;var L=this.getDomRef("tableCCnt");if(L){K=L.clientHeight;}var O=0;var Q=this.getDomRef("table");if(Q){O=Q.clientHeight;}this._iRowHeightsDelta=O-K-T.getRowHeightByIndex(this,this.getRows().length-1);if(this._iBindingLength<=this.getVisibleRowCount()){J=this._iRowHeightsDelta+(this.getVisibleRowCount()*H);}else{J=this._iRowHeightsDelta+J;}this._toggleVSb();}this.getDomRef("vsb-content").style.height=J+"px";if(!T.isVariableRowHeightEnabled(this)){j.scrollTop=this._getSanitizedFirstVisibleRow()*H;}};A.prototype._toggleVSb=function(){var $=this.$();var B=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var j=0;if(B){var l=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/l);var H=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/l));this.setProperty("firstVisibleRow",(Math.max(H,1)-1)*l,true);j=H;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(j);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){$.toggleClass("sapUiTableVScr",this._isVSbRequired());}};A.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(T.isVariableRowHeightEnabled(this)&&this._iRowHeightsDelta>0){return true;}if(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount()){return true;}}return false;};A.prototype._updateBindingContexts=function(i,j,l){var B=this.getRows(),H=this.getBinding("rows"),J=this.mBindingInfos["rows"],K;if(H){K=this._getRowContexts(j,false,l);}if(!i){var L=this.getFirstVisibleRow();var O=typeof this._updateTableCell==="function";this._resetRowHeights();for(var Q=B.length-1;Q>=0;Q--){var U=K?K[Q]:undefined;var W=B[Q];if(W){var X=L+Q;this._updateRowBindingContext(W,U,J&&J.model,X,O,H);}}}};A.prototype._updateRowBindingContext=function(j,B,H,J,K,L){j.setRowBindingContext(B,H,L);if(K){var O=j.getCells();for(var i=0,l=O.length;i<l;i++){if(O[i]){this._updateTableCell(O[i],B,O[i].$().closest("td"),J);}}}};A.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};A.prototype._determineVisibleCols=function(j){var $=this.$();if($.hasClass("sapUiTableHScr")){var B=this._bRtlMode;var H=j.tableHSbScrollLeft;var J=j.tableCtrlScrollWidth;var K=j.tableCtrlScrWidth;if(B&&D.browser.firefox&&H<0){H=H*-1;}var L=H+K;if(this._iOldScrollLeft!==H||this._iOldScrollRight!==L||this._bForceVisibleColCalc){var O=B?J:0;if((D.browser.internet_explorer||D.browser.firefox)&&B){O=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var Q=j.headerWidths;for(var i=0;i<Q.length;i++){var U=Q[i];if(B&&D.browser.chrome){O-=U;}if(O+U>=H&&O<=L){this._aVisibleColumns.push(i);}if(!B||(D.browser.internet_explorer||D.browser.firefox)){O+=U;}}this._iOldScrollLeft=H;this._iOldScrollRight=L;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var W=this.getColumns();for(var i=0,l=W.length;i<l;i++){if(W[i].shouldRender()){this._aVisibleColumns.push(i);}}}};A.prototype._enableColumnAutoResizing=function(){var $=q(this.getDomRef("rsz"));if($.length>0){this._bindSimulatedDoubleclick($,null,this._onAutomaticColumnResize);}};A.prototype.removeColumn=function(i,j){var l=this.removeAggregation('columns',i,j);this._bDetermineVisibleCols=true;if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var B=q.inArray(i,this._aSortedColumns);if(this._iNewColPos===undefined&&B>=0){this._aSortedColumns.splice(B,1);}this._resetRowTemplate();return l;};A.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};A.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};A.prototype.addColumn=function(i,j){var l=this;this.addAggregation('columns',i,j);i.attachEvent('_widthChanged',function(B){l._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};A.prototype.insertColumn=function(i,j,l){var B=this;this.insertAggregation('columns',i,j,l);i.attachEvent('_widthChanged',function(){B._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};A.prototype._getRowCount=function(){return this._iBindingLength;};A.prototype._getSelectableRowCount=function(){return this._iBindingLength;};A.prototype._getFirstVisibleRowByScrollTop=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(j){i=(typeof i==="undefined")?j.scrollTop:i;if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>=this._iBindingLength){return 0;}else{return Math.min(this._iBindingLength-this.getVisibleRowCount(),Math.floor(i/this._getDefaultRowHeight()));}}else{return Math.ceil(i/this._getDefaultRowHeight());}}else{if(this.getNavigationMode()===N.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};A.prototype._getVisibleColumns=function(){var j=[];var B=this.getColumns();for(var i=0,l=B.length;i<l;i++){if(B[i].shouldRender()){j.push(B[i]);}}return j;};A.prototype._getColumnsWidth=function(j,B){var H=this.getColumns();var J=0;if(j!==0&&!j){j=0;}if(B!==0&&!B){B=H.length;}for(var i=j,l=B;i<l;i++){if(H[i]&&H[i].shouldRender()){J+=this._CSSSizeToPixel(H[i].getWidth());}}return J;};A.prototype._CSSSizeToPixel=function(i,j){var l=this._iColMinWidth;if(i){if(q.sap.endsWith(i,"px")){l=parseInt(i,10);}else if(q.sap.endsWith(i,"em")||q.sap.endsWith(i,"rem")){l=Math.ceil(parseFloat(i)*this._getBaseFontSize());}}if(j){return l+"px";}else{return parseInt(l,10);}};A.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};A.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};A.prototype._handleRowCountModeAuto=function(i){var B=this.getBinding("rows");if(B&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var j=this;var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var H=j.getBusyIndicatorDelay();var J=this.getEnableBusyIndicator();if(B&&J){j.setBusyIndicatorDelay(0);j.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!j._executeAdjustRows()){j._updateTableSizes(false,true);}j._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(J){j.setBusy(false);j.setBusyIndicatorDelay(H);}},0);return l;}};A.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var j=this._calculateRowsToDisplay(i);if(j==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(j);};A.prototype._syncColumnHeaders=function(l){var B=this.getDomRef();if(!B){return;}var $=this.$();var H=l.headerWidths;var J=this.getFixedColumnCount();var K=this._getVisibleColumns();if(K.length==0){return;}var L=$.find(".sapUiTableColHdr");var O=$.find(".sapUiTableColHdrScr");var Q=L.find(".sapUiTableCol");var U=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=U;var W={};U.each(function(_,a1){var b1=a1.getAttribute("data-sap-ui-headcolindex");var c1=H[_];var d1;var e1=K[_];if(e1){d1=c1;}if(_==0||_==J){d1+=Math.max(0,l.invisibleColWidth);}var f1=K[_]?K[_].getHeaderSpan():1,g1=[],h1;if(f1){if(!q.isArray(f1)){f1=[f1];}q.each(f1,function(j1,k1){f1[j1]=Math.max(k1,1);});h1=f1;}else{h1=[1];}for(var i=0;i<h1.length;i++){g1[i]={width:d1,span:1};for(var j=1;j<h1[i];j++){var i1=U[_+j];if(i1){g1[i].width+=H[_+j];g1[i].span=h1[i];}}}if(e1){W[b1]={domRefColumnTh:a1,domRefColumnDivs:[],aHeaderData:g1};}});var X=this;Q.each(function(i,j){var _=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var a1=W[_];if(a1){a1.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}});q.each(W,function(j,_){for(var i=0;i<_.domRefColumnDivs.length;i++){var a1=_.aHeaderData[0];if(_.aHeaderData[i]){a1=_.aHeaderData[i];}if(_.domRefColumnDivs[i]){_.domRefColumnDivs[i].style.width=a1.width+"px";_.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",a1.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}}});var Y=this.getColumnHeaderHeight()>0;if(!Y){Q.each(function(i,j){j.style.height=l.columnRowOuterHeight+"px";});var Z=B.querySelector(".sapUiTableColHdrCnt");if(Z){Z.style.height=Math.floor(l.columnRowHeight*T.getHeaderRowCount(this))+"px";}}O.each(function(i,j){j.style.width=l.tableCtrlScrWidth+"px";});};A.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(j){j.preventDefault();return false;});};A.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};A.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};A.prototype.onvscroll=function(i){var j=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(),true);j._mTimeouts._sScrollUpdateTimerId=null;},300);}else{this.setFirstVisibleRow(this._getFirstVisibleRowByScrollTop(),true);}this._bIsScrolledByWheel=false;};A.prototype.onpscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);var j=0;if(this.getNavigationMode()===N.Paginator){j=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(j,true);};A.prototype._onMouseWheel=function(i){var O=i.originalEvent;var j=O.shiftKey;var l=0;if(D.browser.firefox){l=O.detail;}else{if(j){l=O.deltaX;}else{l=O.deltaY;}}if(j){var H=this.getDomRef(v.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+l;}}else{var B=this.getDomRef(v.VerticalScrollBar);if(B){this._bIsScrolledByWheel=true;B.scrollTop=B.scrollTop+l;}}i.preventDefault();i.stopPropagation();};A.prototype._syncHeaderAndContent=function(i){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=i.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};A.prototype.onhscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);if(!this._bOnAfterRendering){var j=this._collectTableSizes();this._syncHeaderAndContent(j);this._determineVisibleCols(j);}};A.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableColHdrScr");var j=0;if(i){j=i.scrollLeft;}H.scrollLeft=j;}}};A.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=i.scrollLeft;}}};A.prototype.onmousedown=function(i){var l=i.button===0;var j=this._isTouchMode(i);if(l){var $=q(i.target);var B=$.closest(".sapUiTableCol");if(B.length===1&&i.target!=this.getDomRef("sb")){this._bShowMenu=true;this._mTimeouts.delayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});var H=this._isTouchMode(i)&&($.hasClass("sapUiTableColDropDown")||$.hasClass("sapUiTableColResizer"));if(this.getEnableColumnReordering()&&!H){var J=parseInt(B.attr("data-sap-ui-colindex"),10);if(J>this._iLastFixedColIndex){var K=this.getColumns()[J];this._mTimeouts.delayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(K,j);});}}}var L=!!(i.metaKey||i.ctrlKey);if(!!D.browser.firefox&&L){i.preventDefault();}}};A.prototype.onmouseup=function(i){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);};A.prototype.onclick=function(i){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);if(i.isMarked()){return;}var $=q(i.target);if($.hasClass("sapUiTableGroupIcon")||$.hasClass("sapUiTableTreeIcon")){if(T.toggleGroupHeader(this,i.target)){return;}}if(!this._findAndfireCellEvent(this.fireCellClick,i)){this._onSelect(i);}else{i.preventDefault();}};A.prototype.oncontextmenu=function(i){var $=q(i.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var j=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(j){j._openMenu(H[0],false);}i.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,i,this._oncellcontextmenu)){i.preventDefault();}}};A.prototype._oncellcontextmenu=function(i){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");y=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var j=sap.ui.getCore().byId(i.columnId);var l=j.getFilterProperty();if(j&&j.isFilterableByMenu()&&i.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new y({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var H=this.getContextByIndex(i.rowIndex);var J=H.getProperty(l);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:j,value:J});}else{this.filter(j,J);}},this]}));var B=P.Dock;this._oContextMenu.open(false,i.cellDomRef,B.BeginTop,B.BeginBottom,i.cellDomRef,"none none");return true;}}};A.prototype._bindSimulatedDoubleclick=function(i,j,l){var B="click";var H=this;if(!!D.support.touch){B="touchend";}q(i).on(B,function(J){J.preventDefault();J.stopPropagation();H._clicksRegistered=H._clicksRegistered+1;if(H._clicksRegistered<2){H._mTimeouts.singleClickTimer=q.sap.delayedCall(H._doubleclickDelay,H,function(){H._clicksRegistered=0;if(j){j.call(H,J);}},[J]);}else{q.sap.clearDelayedCall(H._mTimeouts.singleClickTimer);H._clicksRegistered=0;l.call(H,J);}});};A.prototype._findAndfireCellEvent=function(i,j,l){var $=q(j.target);var B=$.closest("td[role='gridcell']");var H=B.attr("id");var J=/.*-row(\d*)-col(\d*)/i.exec(H);var K=false;if(J){var L=J[1];var O=J[2];var Q=this.getRows()[L];var U=Q&&Q.getCells()[O];var W=Q&&Q.getIndex();var X=U.data("sap-ui-colid");var Y;if(this.getBindingInfo("rows")){Y=Q.getBindingContext(this.getBindingInfo("rows").model);}var Z={rowIndex:W,columnIndex:O,columnId:X,cellControl:U,rowBindingContext:Y,cellDomRef:B.get(0)};K=!i.call(this,Z);if(!K&&typeof l==="function"){Z.cellDomRef=B[0];K=l.call(this,Z);}}return K;};A.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};A.prototype.onfocusin=function(i){var $;var j=q(i.target);if(j.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(j.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var l=$.scrollLeft();var B=$.width();var H=j.position().left;var J=H+j.width();var O=H-l;var K=J-B-l;var L=this.getDomRef(v.HorizontalScrollBar);if(K>0){L.scrollLeft=L.scrollLeft+K+2;}else if(O<0){L.scrollLeft=L.scrollLeft+O-1;}}};A.prototype._getAbsoluteRowIndex=function(i){var j=0;var l=this.getFirstVisibleRow();var B=this.getFixedBottomRowCount();var H=this.getVisibleRowCount();var J=H-B;if(B>0&&i>=J){j=this.getBinding().getLength()-H+i;}else{j=l+i;}return j;};A.prototype._onSelect=function(i){var $=q(i.target);var j=i.shiftKey;var l=!!(i.metaKey||i.ctrlKey);var B=$.closest(".sapUiTableCol");if(this._bShowMenu&&B.length===1){var H=parseInt(B.attr("data-sap-ui-colindex"),10);var J=this.getColumns()[H];if($.hasClass("sapUiTableColDropDown")){var K=this.fireColumnSelect({column:J});if(K){J._openMenu(B[0],i.type=="keyup");}}else{this._onColumnSelect(J,B[0],this._isTouchMode(i),i.type=="keyup");}return;}var L=$.closest(".sapUiTableRowHdr");if(L.length===1){var H=parseInt(L.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(H),j,l);return;}var O;if(i.target){var Q=q(i.target).closest("td");if(Q.length>0){O=Q[0];}}if(O&&(O.getAttribute("role")=="gridcell"||q(O).hasClass("sapUiTableTDDummy"))&&(this.getSelectionBehavior()===t.Row||this.getSelectionBehavior()===t.RowOnly)){var L=$.closest(".sapUiTableCtrl > tbody > tr");if(L.length===1){var H=parseInt(L.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(H),j,l);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),i.target)){this._toggleSelectAll();return;}};A.prototype._isRowSelectable=function(i){return true;};A.prototype._onRowSelect=function(i,j,l){if(!!D.browser.internet_explorer&&j){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(i<0||i>=(B.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var H=this.getSelectionMode();if(H!==u.None){if(H===u.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(H===u.MultiToggle){l=true;}if(j){var J=this.getSelectedIndex();if(J>=0){this.addSelectionInterval(J,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(l){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(l){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};A.prototype._onColumnSelect=function(i,j,l,W){if(l&&(i.getResizable()||i._menuHasItems())){var $=q(j);var B=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){B.hide();var H="";if(i._menuHasItems()){H="<div class='sapUiTableColDropDown'></div>";}var J="";if(i.getResizable()){J="<div class='sapUiTableColResizer''></div>";}var K=q("<div class='sapUiTableColCellMenu'>"+H+J+"</div>");$.append(K);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:B,menu:K,self:$}));if(i.getResizable()){$.find(".sapUiTableColResizer").bind("touchstart",q.proxy(this._onColumnResizeStart,this));}}return;}var L=this.fireColumnSelect({column:i});if(L){i._openMenu(j,W);}};A.prototype.ontouchstart=function(i){if('ontouchstart'in document){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var j=q(i.target).closest($).length>0;if(j){var l=i.targetTouches[0];this._aTouchStartPosition=[l.pageX,l.pageY];var B=this.getDomRef(v.VerticalScrollBar);if(B){this._iTouchScrollTop=B.scrollTop;}var H=this.getDomRef(v.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};A.prototype.ontouchmove=function(i){if('ontouchstart'in document&&this._aTouchStartPosition){var j=i.targetTouches[0];var l=(j.pageX-this._aTouchStartPosition[0]);var B=(j.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(B)>Math.abs(l);}if(this._bIsScrollVertical){var H=this.getDomRef(v.VerticalScrollBar);if(H){var J=this._iTouchScrollTop-B;if(J>0&&J<(this.getDomRef("vsb-content").clientHeight-H.clientHeight)-1){i.preventDefault();i.stopPropagation();}H.scrollTop=J;}}else{var K=this.getDomRef(v.HorizontalScrollBar);if(K){var L=this._iTouchScrollLeft-l;if(L>0&&L<(this.getDomRef("hsb-content").clientWidth-K.clientWidth)-1){i.preventDefault();i.stopPropagation();}K.scrollLeft=L;}}}};A.prototype._onColumnMoveStart=function(i,j){this._disableTextSelection();var $=i.$();var l=parseInt($.attr("data-sap-ui-colindex"),10);if(l<this.getFixedColumnCount()){return;}this.$().addClass("sapUiTableDragDrop");this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(H,J){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);var B=q(document.body);if(j){B.bind("touchmove.sapUiColumnMove",q.proxy(this._onColumnMove,this));B.bind("touchend.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}else{B.bind("mousemove.sapUiColumnMove",q.proxy(this._onColumnMove,this));B.bind("mouseup.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}};A.prototype._onColumnMove=function(i){var $=this.$();var l=i.pageX;var L=i.pageY;if(i&&this._isTouchMode(i)){l=i.targetTouches[0].pageX;L=i.targetTouches[0].pageY;i.stopPropagation();i.preventDefault();}var j=this._bRtlMode;var B=l-$.offset().left;var H=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var J=this.getColumns()[H].$();var O=this._iNewColPos;this._iNewColPos=H;var K=this;$.find(".sapUiTableCol").each(function(Q,U){var W=q(U);var X=parseInt(W.attr("data-sap-ui-colindex"),10);var Y=sap.ui.getCore().byId(W.attr("data-sap-ui-colid")).getHeaderSpan();var Z;if(Y){if(q.isArray(Y)){Z=Y[0];}else{Z=Y;}}else{Z=1;}if(W.get(0)!==J.get(0)){var _=W.data("pos");var a1=B>=_.left&&B<=_.center;var b1=B>=_.center&&B<=_.right;if(!j){if(a1){K._iNewColPos=X;}else if(b1){K._iNewColPos=X+Z;}else{K._iNewColPos=K._iNewColPos;}}else{if(b1){K._iNewColPos=X;}else if(a1){K._iNewColPos=X+Z;}else{K._iNewColPos=K._iNewColPos;}}if((a1||b1)&&X>H){K._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=O;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=O;}this._animateColumnMove(H,O,this._iNewColPos);this._$colGhost.css({"left":l+5,"top":L+5});};A.prototype._animateColumnMove=function(j,O,B){var H=this._bRtlMode;var $=this.getColumns()[j].$();if(O!==B){for(var i=Math.min(O,B),l=Math.max(O,B);i<=l;i++){var J=this.getColumns()[i];if(i!==j&&J.getVisible()){J.$().stop(true,true).animate({left:"0px"});}}var K=0;if(B<j){for(var i=B;i<j;i++){var J=this.getColumns()[i];if(J.getVisible()){var L=J.$();K-=L.outerWidth();L.stop(true,true).animate({left:$.outerWidth()*(H?-1:1)+"px"});}}}else{for(var i=j+1,l=B+1;i<l;i++){var J=this.getColumns()[i];if(J.getVisible()){var L=J.$();K+=L.outerWidth();L.stop(true,true).animate({left:$.outerWidth()*(H?1:-1)+"px"});}}}$.stop(true,true).animate({left:K*(H?-1:1)+"px"});}};A.prototype._onColumnMoved=function(j){var l=this;this.$().removeClass("sapUiTableDragDrop");var B=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var H=this.getColumns()[B];var $=q(document.body);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var J=this.fireColumnMove({column:H,newPos:this._iNewColPos});var K=B<this._iNewColPos;if(J&&this._iNewColPos!==undefined&&this._iNewColPos!==B){this.removeColumn(H);this.insertColumn(H,this._iNewColPos);var L=H.getHeaderSpan(),O;if(L){if(q.isArray(L)){O=L[0];}else{O=L;}}else{O=1;}if(O>1){if(!K){this._iNewColPos++;}for(var i=1;i<O;i++){var Q=this.getColumns()[K?B:B+i];this.removeColumn(Q);this.insertColumn(Q,this._iNewColPos);this.fireColumnMove({column:Q,newPos:this._iNewColPos});if(!K){this._iNewColPos++;}}}}else{this._animateColumnMove(B,this._iNewColPos,B);H.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}if(this._mTimeouts.reApplyFocusTimer){window.clearTimeout(this._mTimeouts.reApplyFocusTimer);}this._mTimeouts.reApplyFocusTimer=window.setTimeout(function(){var U=T.getFocusedItemInfo(l).cell;T.focusItem(l,0,j);T.focusItem(l,U,j);},0);delete this._iNewColPos;};A.prototype._onAutomaticColumnResize=function(i){var j=this.getColumns()[this._iLastHoveredColumnIndex];if(!j.getAutoResizable()){return;}q.sap.log.debug("doubleclick fired");this._disableTextSelection();this.autoResizeColumn(this._iLastHoveredColumnIndex);i.preventDefault();i.stopPropagation();};A.prototype._onColumnResizeStart=function(i){this._bIsColumnResizerMoving=true;var $=q(document.body);this.$().addClass("sapUiTableResizing");if(this._isTouchMode(i)){this._iColumnResizeStart=i.targetTouches[0].pageX;this._disableTextSelection();this._$colResize=q("#"+this.getId()+"-rsz");$.bind("touchmove.sapUiTableColumnResize",this._onColumnResize.bind(this));$.bind("touchend.sapUiTableColumnResize",this._onColumnResized.bind(this));}else{if(i.button===0){this._iColumnResizeStart=i.pageX;this._disableTextSelection();this._$colResize=q(i.target);$.bind("mousemove.sapUiTableColumnResize",this._onColumnResize.bind(this));$.bind("mouseup.sapUiTableColumnResize",this._onColumnResized.bind(this));}}};A.prototype._onColumnResize=function(i){var l;if(this._isTouchMode(i)){l=i.targetTouches[0].pageX;i.stopPropagation();i.preventDefault();}else{l=i.pageX;}if(this._iColumnResizeStart&&l<this._iColumnResizeStart+3&&l>this._iColumnResizeStart-3){return;}if(this._isTouchMode(i)){this._$colResize.addClass("sapUiTableColTouchRszActive");}else{this._$colResize.addClass("sapUiTableColRszActive");}var j=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var B=l-this._iColumnResizeStart;var H=j.$().width();var W;if(this._bRtlMode){W=H-B;}else{W=H+B;}W=Math.max(W,this._iColMinWidth);var J=this.$().find(".sapUiTableCnt").offset().left;var K=Math.floor((l-J)-(this._$colResize.width()/2));this._$colResize.css("left",K+"px");j._iNewWidth=W;};A.prototype._onColumnResized=function(i,j){var l;this._bIsColumnResizerMoving=false;this.$().removeClass("sapUiTableResizing");if(!this._$colResize&&(j===null||j===undefined)){return;}if(j===null||j===undefined){l=this._iLastHoveredColumnIndex;}else{l=j;}var B=this._getVisibleColumns()[l];var H=false;if(B._iNewWidth){var W;var J=this.$().find(".sapUiTableCtrl").width();if(!this._checkPercentageColumnWidth()){W=B._iNewWidth+"px";}else{var K=Math.round(100/J*B._iNewWidth);W=K+"%";}if(this._updateColumnWidth(B,W,true)){this._resizeDependentColumns(B,W);}delete B._iNewWidth;H=true;}var $=q(document.body);$.unbind("touchmove.sapUiTableColumnResize");$.unbind("touchend.sapUiTableColumnResize");$.unbind("mousemove.sapUiTableColumnResize");$.unbind("mouseup.sapUiTableColumnResize");B.focus();if(this._$colResize){this._$colResize.removeClass("sapUiTableColTouchRszActive sapUiTableColRszActive");this._$colResize=undefined;}this._enableTextSelection();if(H){this.invalidate();}};A.prototype._resizeDependentColumns=function(j,W){var l=this;if(this._checkPercentageColumnWidth()){var B=this._getVisibleColumns();var H;q.each(B,function(d1,e1){if(j===e1){H=d1;}});var O=0;var L=B.length-1;var J;if(H===undefined){J=0;}else{J=parseInt(W,10);}var K=0;var Q=[];q.each(B,function(d1,e1){var f1=l._getColumnPercentageWidth(e1);if((((H===L&&d1<H)||((H!==L)&&d1>H))&&e1.getFlexible())||H===undefined){O+=e1.$().outerWidth();K+=f1;Q.push(e1);}else if(d1!==H){J+=f1;}});var U=J;q.each(Q,function(d1,e1){var f1=l._getColumnPercentageWidth(e1);var c1=Math.round((100-U)/K*f1);if(d1===Q.length-1){c1=100-J;}else{J+=c1;}l._updateColumnWidth(e1,c1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var B=this._getVisibleColumns(),X=this.$().find(".sapUiTableCtrl").width(),H,Y=0,Z=0,$=0,_=0;q.each(B,function(d1,e1){if(!q.sap.endsWith(e1.getWidth(),"px")&&!q.sap.endsWith(e1.getWidth(),"em")&&!q.sap.endsWith(e1.getWidth(),"rem")){_++;return false;}if(H!=undefined){$+=l._CSSSizeToPixel(e1.getWidth());Y++;}else if(j!==e1){Z+=l._CSSSizeToPixel(e1.getWidth());}if(j===e1){H=d1;Z+=l._CSSSizeToPixel(W);}});if(_>0||(Z+$>X)){return;}X-=Z;for(var i=H+1;i<B.length;i++){var j=B[i],a1=this._CSSSizeToPixel(j.getWidth()),b1=a1/$*100,c1=X/100*b1;this._updateColumnWidth(j,Math.round(c1)+'px');}}};A.prototype._getColumnPercentageWidth=function(i){var j=i.getWidth();var l=parseInt(i.getWidth(),10);var B=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(j,"px")||q.sap.endsWith(j,"em")||q.sap.endsWith(j,"rem")){l=Math.round(100/B*l);}else if(!q.sap.endsWith(j,"%")){l=Math.round(100/B*i.$().width());}return l;};A.prototype._updateColumnWidth=function(i,W,j){var l=true;if(j){l=this.fireColumnResize({column:i,width:W});}if(l){i.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]').css('width',W);}return l;};A.prototype._checkPercentageColumnWidth=function(){var i=this.getColumns();var H=false;q.each(i,function(j,l){if(q.sap.endsWith(l.getWidth(),"%")){H=true;return false;}});return H;};A.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,j){var W=j.getWidth();if(j.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};A.prototype.pushSortedColumn=function(i,j){if(!j){this._aSortedColumns=[];}this._aSortedColumns.push(i);};A.prototype.getSortedColumns=function(){return this._aSortedColumns;};A.prototype.sort=function(i,j,l){if(q.inArray(i,this.getColumns())>=0){i.sort(j===w.Descending,l);}};A.prototype.filter=function(i,j){if(q.inArray(i,this.getColumns())>=0){i.filter(j);}};A.prototype._getSelectOnCellsAllowed=function(){var i=this.getSelectionBehavior();var j=this.getSelectionMode();return j!==u.None&&(i===t.Row||i===t.RowOnly);};A.prototype._updateSelection=function(){if(this.getSelectionMode()===u.None){return;}var j=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=this._getSelectOnCellsAllowed();var B=this.getRows();for(var i=0;i<B.length;i++){var H=B[i];H._updateSelection(this,j,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);};A.prototype._onSelectionChanged=function(i){var j=i.getParameter("rowIndices");var l=i.getParameter("selectAll");var B=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var H=this.getSelectionMode();if(H==="Multi"||H==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:B,rowContext:this.getContextByIndex(B),rowIndices:j,selectAll:l,userInteraction:this._iSourceRowIndex!==undefined});};A.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};A.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};A.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};A.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};A.prototype.selectAll=function(){var i=this.getSelectionMode();if(!this.getEnableSelectAll()||(i!="Multi"&&i!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.selectAll((B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};A.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};A.prototype.addSelectionInterval=function(i,j){this._oSelection.addSelectionInterval(i,j);return this;};A.prototype.setSelectionInterval=function(i,j){this._oSelection.setSelectionInterval(i,j);return this;};A.prototype.removeSelectionInterval=function(i,j){this._oSelection.removeSelectionInterval(i,j);return this;};A.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};A.prototype.setGroupBy=function(i){var j=i;if(typeof j==="string"){j=sap.ui.getCore().byId(j);}var l=false;if(j&&j instanceof k){if(q.inArray(j,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var B=this.fireGroup({column:j,groupedColumns:[j.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);l=true;}if(B&&j instanceof k){j.setGrouped(true);}}if(!j||l){var H=this.getBindingInfo("rows");delete H.binding;this._bindAggregation("rows",H);}return this.setAssociation("groupBy",j);};A.prototype.getBinding=function(j){j=j||"rows";var B=E.prototype.getBinding.call(this,j);if(this.getEnableGrouping()){var l=sap.ui.requireSync("sap/ui/model/ClientListBinding");var H=sap.ui.getCore().byId(this.getGroupBy());var J=H&&H.getGrouped()&&j==="rows"&&B&&B instanceof l;if(J&&!B._modified){B._modified=true;this._modifyRow=function(Y,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var Z=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(Y)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var _=B.isExpanded(Y)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";Z.html("<div class=\"sapUiTableGroupIcon "+_+"\" tabindex=\"-1\">"+B.getTitle(Y)+"</div>");Z.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");Z.html("");Z.removeClass("sapUiTableGroupHeader");}};var K=H.getSortProperty();B.sort(new h(K));var L=B.getLength(),O=B.getContexts(0,L);var Q;var U=0;for(var i=L-1;i>=0;i--){var W=O[i].getProperty(K);if(!Q){Q=W;}if(Q!==W){var X=O[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);X.__groupInfo={oContext:O[i+1],name:Q,count:U,groupHeader:true,expanded:true};O.splice(i+1,0,X);Q=W;U=0;}U++;}var X=O[0].getModel().getContext("/sap.ui.table.GroupInfo");X.__groupInfo={oContext:O[0],name:Q,count:U,groupHeader:true,expanded:true};O.splice(0,0,X);q.extend(B,{getLength:function(){return O.length;},getContexts:function(Y,L){return O.slice(Y,Y+L);},isGroupHeader:function(Y){var Z=O[Y];return Z&&Z.__groupInfo&&Z.__groupInfo.groupHeader;},getTitle:function(Y){var Z=O[Y];return Z&&Z.__groupInfo&&Z.__groupInfo.name+" - "+Z.__groupInfo.count;},isExpanded:function(Y){var Z=O[Y];return this.isGroupHeader(Y)&&Z.__groupInfo&&Z.__groupInfo.expanded;},expand:function(Y){if(this.isGroupHeader(Y)&&!O[Y].__groupInfo.expanded){for(var i=0;i<O[Y].__childs.length;i++){O.splice(Y+1+i,0,O[Y].__childs[i]);}delete O[Y].__childs;O[Y].__groupInfo.expanded=true;this._fireChange();}},collapse:function(Y){if(this.isGroupHeader(Y)&&O[Y].__groupInfo.expanded){O[Y].__childs=O.splice(Y+1,O[Y].__groupInfo.count);O[Y].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(Y){if(this.isExpanded(Y)){this.collapse(Y);}else{this.expand(Y);}}});this._mTimeouts.groupingFireBindingChange=this._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){B._fireChange();},0);}}return B;};A.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this._modifyRow=undefined;var i=this.getBindingInfo("rows");this.unbindRows();this.bindRows(i);}};A.prototype.setEnableGrouping=function(i){this.setProperty("enableGrouping",i);if(!i){this.resetGrouping();}this._invalidateColumnMenus();return this;};A.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};A.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};A.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};A.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};A.prototype.setFixedColumnCount=function(j,l){var B=this._getVisibleColumns();var H=B[j-1]&&B[j-1].getHeaderSpan();if(H){var J;if(q.isArray(H)){J=parseInt(H[0],10);}else{J=parseInt(H,10);}j+=J-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<j;i++){var K=B[i];if(K){var L=q.inArray(K,this.getColumns());if(!K.getWidth()){K.setWidth($.filter("[data-sap-ui-headcolindex='"+L+"']").width()+"px");}}}this.setProperty("fixedColumnCount",j,l);this._collectTableSizes();this._invalidateColumnMenus();return this;};A.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};A.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};A.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};A.prototype._invalidateColumnMenus=function(){var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){j[i].invalidateMenu();}};A.prototype._isTouchMode=function(i){return!!i.originalEvent["touches"];};A.prototype._determineParent=function(){var i=this.getParent();if(i){var j;if(i.getDomRef){j=i.getDomRef();}else if(i.getRootNode){j=i.getRootNode();}if(j){return q(j);}}return q();};A.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new m(this.getId()+"-rows");var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getVisible()){var B=j[i].getTemplate();if(B){var H=B.clone("col"+i);H.data("sap-ui-colindex",i);H.data("sap-ui-colid",j[i].getId());this._oRowTemplate.addCell(H);}}}}return this._oRowTemplate;};A.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};A.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};A.prototype._adjustRows=function(j,l){if(isNaN(j)){return false;}if(T.isVariableRowHeightEnabled(this)){j=j+1;}var i;var B=this.getRows();if(!this._oRowTemplate&&B.length>0){this.destroyAggregation("rows",true);B=[];}if(j==B.length){return false;}for(i=B.length-1;i>=j;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",j-1,true);}else{this.setProperty("visibleRowCount",j,true);}this._ignoreInvalidateOfChildControls=true;var H;var J=this.getFirstVisibleRow();var K=0;var L=false;var O;var Q=this.getBinding("rows");if(!l){O=this.getBindingInfo("rows");L=typeof this._updateTableCell==="function";H=this._getRowContexts(j);for(i=0;i<B.length;i++){K=J+i;this._updateRowBindingContext(B[i],H[i],O&&O.model,K,L,Q);}}if(B.length<j){var U=this._getRowTemplate();for(i=B.length;i<j;i++){var W=U.clone("row"+i);if(!l){K=J+i;this._updateRowBindingContext(W,H[i],O&&O.model,K,L,Q);}this.addAggregation("rows",W,true);}}this._ignoreInvalidateOfChildControls=false;B=this.getRows();l=l||H.length==0;return this._insertTableRows(B,l);};A.prototype._insertTableRows=function(j,B){var H=false;if(!this._bInvalid){this._detachEvents();var J=this.getDomRef("tableCCnt");j=j||this.getRows();if(!j.length||!J){return;}if(this.getVisibleRowCountMode()==V.Auto){var K=this.getDomRef();if(K){K.style.height="0px";}}var L=q.Event("BeforeRendering");L.setMarked("insertTableRows");L.srcControl=this;this._handleEvent(L);var O=new sap.ui.getCore().createRenderManager(),Q=this.getRenderer();this._iDefaultRowHeight=undefined;Q.renderTableCCnt(O,this);O.flush(J,false,false);O.destroy();L=q.Event("AfterRendering");L.setMarked("insertTableRows");L.srcControl=this;this._handleEvent(L);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){if(U[i].getVisible()){U[i]._restoreIcons();}}this._updateTableSizes();this._updateGroupHeader();H=true;if(this._updateTableContent){this._updateTableContent();}this._attachEvents();}if(!B&&!this._bInvalid&&this.getBinding("rows")){var W=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){W.fireEvent("_rowsUpdated");},0);}return H;};A.prototype._getDefaultRowHeight=function(i){if(T.isVariableRowHeightEnabled(this)){this._iDefaultRowHeight=this.getRowHeight()||28;}else{if(!this._iDefaultRowHeight&&this.getDomRef()){i=i||this._collectRowHeights();if(i&&i.length>0){this._iDefaultRowHeight=i[0];}}if(!this._iDefaultRowHeight){this._iDefaultRowHeight=28;}}return this._iDefaultRowHeight;};A.prototype._setRowContentHeight=function(H){H=H||0;var i=this.getVisibleRowCountMode();var j=this.getVisibleRowCount();var l=this.getMinAutoRowCount();var B;var J=this._getDefaultRowHeight();if(i==V.Interactive||i==V.Fixed){if(this._iTableRowContentHeight&&i==V.Interactive){B=l*J;if(!H){H=this._iTableRowContentHeight;}}else{B=j*J;H=B;}}else if(i==V.Auto){B=l*J;}var K=Math.max(H,B);if((i==V.Fixed&&this.getRows().length==0)||i!=V.Fixed){this._iTableRowContentHeight=Math.floor(K/J)*J;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){var $=q(this.getDomRef("tableCCnt"));if(i==V.Fixed||i==V.Interactive){$.css("height",this._getDefaultRowHeight()*this.getVisibleRowCount()+"px");}else if(i==V.Auto){$.css("height",this._iTableRowContentHeight+"px");}}else{if((i==V.Fixed||i==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};A.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var j=this.getMinAutoRowCount();var l=j||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){l=i||j||5;}return l;};A.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var j=this.getVisibleRowCountMode();var l=0;if(j==V.Fixed){l=this.getVisibleRowCount()||0;}else if(j==V.Interactive||j==V.Auto){var B=this._determineMinAutoRowCount();var H=this._getDefaultRowHeight();if(!H||!i){l=B;}else{var J=Math.min(i,50000);var K=Math.floor(J/H);l=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(B,K));}}return Math.max(l,0);};A.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};A.prototype.exportData=function(j){var B=sap.ui.requireSync("sap/ui/core/util/Export");j=j||{};if(!j.rows){var H=this.getBinding("rows"),J=this.getBindingInfo("rows");var K=H.aFilters.concat(H.aApplicationFilters);j.rows={path:J.path,model:J.model,sorter:H.aSorters,filters:K,parameters:J.parameters};}if(!j.exportType){var L=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");j.exportType=new L();}var O=j.rows.model;if(!O){var Q=j.rows.path;var U=Q.indexOf(">");if(U>0){O=Q.substr(0,U);}}if(!j.columns){j.columns=[];var W=this.getColumns();for(var i=0,l=W.length;i<l;i++){var X=W[i];if(X.getSortProperty()){j.columns.push({name:X.getLabel().getText(),template:{content:{path:X.getSortProperty(),model:O}}});}}}var Y=new B(j);this.addDependent(Y);return Y;};A.prototype._calculateAutomaticColumnWidth=function(j){var l=["sap.m.Text","sap.m.Label","sap.m.Link","sap.ui.commons.TextView","sap.ui.commons.Label","sap.ui.commons.Link"];var $=this.$();var H=0;var B=$.find('td[headers=\"'+this.getId()+'_col'+j+'\"]').children("div");var J=this.getColumns();var K=J[j];if(!K){return null;}var L=K.getHeaderSpan();var O=K.getLabel();var Q=this;x=x||sap.ui.require("sap/m/Input");z=z||sap.ui.require("sap/ui/commons/TextField");var U=K.getTemplate();var W=q.inArray(U.getMetadata().getName(),l)!=-1||z&&U instanceof z||x&&U instanceof x;var X=document.createElement("div");document.body.appendChild(X);q(X).addClass("sapUiTableHiddenSizeDetector");var Y=K.getMultiLabels();if(Y.length==0&&!!O){Y=[O];}if(Y.length>0){q.each(Y,function(a1,b1){var c1;if(!!b1.getText()){q(X).text(b1.getText());H=X.scrollWidth;}else{H=b1.$().scrollWidth;}H=H+$.find("#"+K.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+K.getId()+"_"+a1+"-icons").first().width();if(L instanceof Array&&L[a1]>1){c1=L[a1];}else if(L>1){c1=L;}if(!!c1){var i=c1-1;while(i>j){H=H-(Q._oCalcColumnWidths[j+i]||0);i-=1;}}});}var Z=Math.max.apply(null,B.map(function(){var i=q(this);return parseInt(i.css('padding-left'),10)+parseInt(i.css('padding-right'),10)+parseInt(i.css('margin-left'),10)+parseInt(i.css('margin-right'),10);}).get());var _=Math.max.apply(null,B.children().map(function(){var i=0,a1=0;var b1=q(this);var c1=b1.text()||b1.val();if(W){q(X).text(c1);a1=X.scrollWidth;}else{a1=this.scrollWidth;}if(H>a1){a1=H;}i=a1+parseInt(b1.css('margin-left'),10)+parseInt(b1.css('margin-right'),10)+Z+1;return i;}).get());q(X).remove();return Math.max(_,this._iColMinWidth);};A.prototype._onPersoApplied=function(){var j=this.getColumns();var B=[];for(var i=0,l=j.length;i<l;i++){var H=j[i];if(H.getSorted()){B.push(new h(H.getSortProperty(),H.getSortOrder()===w.Descending));}}var J=this.getBinding("rows");if(J){if(B.length>0){J.sort(B);}this.refreshRows();}};A.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};A.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var i=this.getColumns();q.each(i,function(j,l){l._restoreAppDefaults();});};A.prototype._setBusy=function(j){var B,i,l;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}this.setBusy(false);if(j&&this._iDataRequestedCounter>0){var H=j.reason;if(j.contexts&&j.contexts.length!==undefined){l=false;for(i=0;i<j.contexts.length;i++){if(j.contexts[i]===undefined){l=true;break;}}}else if(j.changeReason===e.Expand){this.setBusy(true);}var L=B.getLength();if((H==e.Expand&&this._iDataRequestedCounter!==0)||l||(B.isInitial())||(j.receivedLength===0&&this._iDataRequestedCounter!==0)||(j.receivedLength<j.requestedLength&&j.receivedLength!==L&&j.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};A.prototype.setBusy=function(B,i){var j=this.getBusy()!=B;i="sapUiTableCnt";var l=C.prototype.setBusy.call(this,B,i);if(j){this.fireBusyStateChanged({busy:B});}return l;};A.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);};A.prototype._attachDataRequestedListeners=function(){var B=this.getBinding("rows");if(B){B.detachDataRequested(this._onBindingDataRequestedListener,this);B.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;B.attachDataRequested(this._onBindingDataRequestedListener,this);B.attachDataReceived(this._onBindingDataReceivedListener,this);}};A.prototype._onBindingDataRequestedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};A.prototype._onBindingDataReceivedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};A.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};A.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};A.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};return A;});
