/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","sap/ui/core/Control","./PlacementType","sap/ui/core/IconPool","sap/ui/core/HTML","./Text","sap/ui/core/Icon","./SegmentedButton","./Page","./NavContainer","./semantic/SemanticPage","./Popover","./MessagePopoverItem","jquery.sap.dom"],function(q,R,B,T,a,b,L,S,l,C,P,I,H,c,d,e,f,N,g,h,M){"use strict";var j=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessagePopoverItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});var k="sapMMsgPopover",m={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},n=["all","error","warning","success","information"],A=["asyncDescriptionHandler","asyncURLHandler"],D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(o){i.item.setDescription(o);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};j.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};j.prototype.init=function(){var t=this;var p;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:"440px",placement:this.getPlacement(),showCloseButton:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(k);this._createNavigationPages();this._createLists();p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onkeypress:this._onkeypress},this);if(sap.ui.Device.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};j.prototype.exit=function(){this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;if(this._oLists){this._destroyLists();}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};j.prototype.onBeforeRenderingPopover=function(){var i=this.getHeaderButton();if(i){this._oListHeader.insertContent(i,2);}if(!this.getBindingInfo("items")&&!this.getItems().length){this._makeAutomaticBinding();}if(this._bItemsChanged){this._clearLists();this._fillLists(this.getItems());this._clearSegmentedButton();this._fillSegmentedButton();this._bItemsChanged=false;}this._setInitialFocus();};j.prototype._makeAutomaticBinding=function(){this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this.bindAggregation("items",{path:"message>/",template:new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"})});};j.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this._fnHandleBackPress();}};j.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};j.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};j.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var r=this.getId()+"-HeadingDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\" role=\"heading\">"+p+"</span>"});this._oPopover.addAssociation("ariaDescribedBy",r,true);var u=new B({icon:m["close"],visible:!sap.ui.Device.system.phone,ariaLabelledBy:o,tooltip:s,press:this.close.bind(this)}).addStyleClass(k+"CloseBtn");this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new a(),u,o,t]});return this._oListHeader;};j.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var r=this.getId()+"-BackBtnDetDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\">"+p+"</span>"});var u=new B({icon:m["close"],visible:!sap.ui.Device.system.phone,ariaLabelledBy:o,tooltip:s,press:this.close.bind(this)}).addStyleClass(k+"CloseBtn");this._oBackButton=new B({icon:m["back"],press:this._fnHandleBackPress.bind(this),ariaLabelledBy:t,tooltip:p});this._oDetailsHeader=new T({content:[this._oBackButton,new a(),u,o,t]});return this._oDetailsHeader;};j.prototype._createNavigationPages=function(){this._listPage=new f(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new f(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==='A'&&(t.className.indexOf('sapMMsgPopoverItemDisabledLink')!==-1||t.className.indexOf('sapMMsgPopoverItemPendingLink')!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)});this._oPopover.addContent(this._navContainer);return this;};j.prototype._createLists=function(){this._oLists={};n.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};j.prototype._clearLists=function(){n.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};j.prototype._destroyLists=function(){n.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};j.prototype._fillLists=function(i){i.forEach(function(o){var p=this._mapItemToListItem(o),r=this._mapItemToListItem(o);this._oLists["all"].addAggregation("items",p,true);this._oLists[o.getType().toLowerCase()].addAggregation("items",r,true);},this);};j.prototype._mapItemToListItem=function(o){if(!o){return null;}var t=o.getType(),i=new S({title:o.getTitle(),icon:this._mapIcon(t),type:sap.m.ListType.Navigation}).addStyleClass(k+"Item").addStyleClass(k+"Item"+t);i._oMessagePopoverItem=o;return i;};j.prototype._mapIcon=function(i){if(!i){return null;}return m[i.toLowerCase()];};j.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};j.prototype._fillSegmentedButton=function(){var t=this;var p=function(s){return function(){t._fnFilterList(s);};};n.forEach(function(s){var o=this._oLists[s],i=o.getItems().length,r;if(i>0){r=new B(this.getId()+"-"+s,{text:s=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):i,icon:m[s],press:p(s)}).addStyleClass(k+"Btn"+s.charAt(0).toUpperCase()+s.slice(1));this._oSegmentedButton.addButton(r,true);}},this);return this;};j.prototype._setIcon=function(o,i){this._previousIconTypeClass=k+"DescIcon"+o.getType();this._oMessageIcon=new d({src:i.getIcon()}).addStyleClass(k+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};j.prototype._setTitle=function(o){this._oMessageTitleText=new c(this.getId()+'MessageTitleText',{text:o.getTitle()}).addStyleClass('sapMMsgPopoverTitleText');this._detailsPage.addAggregation("content",this._oMessageTitleText);};j.prototype._setDescription=function(o){if(o.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+'MarkupDescription',{content:"<div class='markupDescription'>"+o.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new c(this.getId()+'MessageDescriptionText',{text:o.getDescription()}).addStyleClass('sapMMsgPopoverDescriptionText');}this._detailsPage.addContent(this._oMessageDescriptionText);};j.prototype._iNextValidationTaskId=0;j.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return'';};j.prototype._queueValidation=function(i){var o=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var p={};var r=new window.Promise(function(s,t){p.resolve=s;p.reject=t;var u={url:i,id:v,promise:p};o(u);});r.id=v;return r;};j.prototype._getTagPolicy=function(){var t=this,i;var o=html.makeTagPolicy(this._validateURL());return function customTagPolicy(p,r){var s,v=false;if(p.toUpperCase()==="A"){for(i=0;i<r.length;){if(r[i]==="href"){v=true;s=r[i+1];r.splice(0,2);continue;}i+=2;}}r=o(p,r);if(v&&typeof t.getAsyncURLHandler()==="function"){r=r||[];var u=false;for(i=0;i<r.length;i+=2){if(r[i]==="class"){r[i+1]+="sapMMsgPopoverItemDisabledLink sapMMsgPopoverItemPendingLink";u=true;break;}}var w=r.indexOf("id");if(w>-1){r.splice(w+1,1);r.splice(w,1);}if(!u){r.unshift("sapMMsgPopoverItemDisabledLink sapMMsgPopoverItemPendingLink");r.unshift("class");}var V=t._queueValidation(s);r.push("href");r.push(s);r.push("target");r.push("_blank");r.push("id");r.push("sap-ui-"+t.getId()+"-link-under-validation-"+V.id);V.then(function(x){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+x.id);if(x.allowed){q.sap.log.info("Allow link "+s);}else{q.sap.log.info("Disallow link "+s);}$.removeClass('sapMMsgPopoverItemPendingLink');$.toggleClass('sapMMsgPopoverItemDisabledLink',!x.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return r;};};j.prototype._sanitizeDescription=function(o){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var t=this._getTagPolicy();var s=html.sanitizeWithPolicy(o.getDescription(),t);o.setDescription(s);this._setDescription(o);};j.prototype._fnHandleItemPress=function(E){var o=E.getParameter("listItem"),i=o._oMessagePopoverItem;var p=this.getAsyncDescriptionHandler();var r=function(v){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,o);this.fireLongtextLoaded();if(!v){this._navContainer.to(this._detailsPage);}}.bind(this);this._previousIconTypeClass=this._previousIconTypeClass||'';this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._detailsPage.destroyContent();if(typeof p==="function"&&!!i.getLongtextUrl()){i.setMarkupDescription(true);var s={};var t=new window.Promise(function(v,w){s.resolve=v;s.reject=w;});var u=function(){this._detailsPage.setBusy(false);r(true);}.bind(this);t.then(function(){u();}).catch(function(){q.sap.log.warning("Async description loading could not be performed.");u();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);p({promise:s,item:i});}else{r();}this._listPage.$().attr("aria-hidden","true");};j.prototype._fnHandleBackPress=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};j.prototype._fnFilterList=function(s){n.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._expandMsgPopover();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};j.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};j.prototype._navigate=function(){if(this._isListPage()){this._oRestoreFocus=q(document.activeElement);}};j.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,this._restoreFocus);};j.prototype._isListPage=function(){return(this._navContainer.getCurrentPage()==this._listPage);};j.prototype._setInitialFocus=function(){if(this._isListPage()){this._oPopover.setInitialFocus(this._oLists[this._sCurrentList]);}};j.prototype._restoreFocus=function(){if(this._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);if(r){r.focus();}}else{this._oBackButton.focus();}};j.prototype._restoreExpansionDefaults=function(){if(this.getInitiallyExpanded()){this._fnFilterList("all");this._oSegmentedButton.setSelectedButton(null);}else{this._collapseMsgPopover();}};j.prototype._expandMsgPopover=function(){var s=this._oPopover.$("cont").css("height")||this._oPopover.getContentWidth();this._oPopover.setContentHeight(s).removeStyleClass(k+"-init");};j.prototype._collapseMsgPopover=function(){n.forEach(function(s){this._oLists[s].setVisible(false);},this);this._oPopover.addStyleClass(k+"-init").setContentHeight("auto");this._oSegmentedButton.setSelectedButton("none");};j.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();if(r instanceof h){if((p instanceof T||p instanceof b||p instanceof g)){r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};j.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};j.prototype.isOpen=function(){return this._oPopover.isOpen();};j.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};j.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};j.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(s){j.prototype[s]=function(){if(this._oPopover&&this._oPopover[s]){var p=this._oPopover;var r=p[s].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){j.prototype["_"+F+"Old"]=j.prototype[F];j.prototype[F]=function(){var r=j.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return j;},true);
