/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,J){"use strict";var e=P.extend("sap.m.P13nDimMeasurePanel",{metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}});e.prototype.init=function(){var t=this;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;this._bOnBeforeRenderingFirstTimeExecuted=false;var m=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],indexOfMarkedTableItem:-1,markedTableItem:null,isMoveDownButtonEnabled:false,isMoveUpButtonEnabled:false,showOnlySelectedItems:false,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nDimMeasurePanel");this.setType(sap.m.P13nPanelType.dimeasure);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,f,h;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;f=$.children()[0].clientHeight;h=o?o.$()[0].clientHeight:0;a=f-h;if(i!==a){s.setHeight(a+'px');b=true;}}}}return b;};this.addAggregation("content",s);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};e.prototype._moveMarkedTableItem=function(D){var o=this.getModel("$sapmP13nDimMeasurePanel").getData();if(!o.markedTableItem||o.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(o.markedTableItem)<0){return;}var f=function(){switch(D){case"Down":return o.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return o.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[o.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);}};e.prototype._filterModelItemsBySearchText=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.aggregationRole&&M.aggregationRole.match(r)){M.visible=true;}if(M.role&&M.role.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};e.prototype.onBeforeRendering=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){this._bOnBeforeRenderingFirstTimeExecuted=true;this._syncPanel2Model();}var D=this.getModel("$sapmP13nDimMeasurePanel").getData();if(!D.markedTableItem){var v=this._getVisibleTableItems();this._switchMarkedTableItemTo(v[0]);}};e.prototype.onAfterRendering=function(){var t=this,L=0;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(L);L=window.setTimeout(function(){t._fnHandleResize();t._getToolbar()._resetAndInvalidateToolbar();},0);}};e.prototype.getOkPayload=function(){this._syncModel2Panel();return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};e.prototype._syncModel2Panel=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){return;}var D=this.getModel("$sapmP13nDimMeasurePanel").getData();this.setChartTypeKey(D.selectedChartTypeKey);D.items.forEach(function(m){var o=this._getDimMeasureItemByColumnKey(m.columnKey);if(o){if(!this._isDimMeasureItemEqualToModelItem(o,m)){o.setVisible(m.persistentSelected);o.setIndex(m.persistentIndex);o.setRole(m.role);}return;}if(!m.persistentSelected){return;}o=new sap.m.P13nDimMeasureItem({columnKey:m.columnKey,visible:m.persistentSelected,index:m.persistentIndex,role:m.role});this.addAggregation("dimMeasureItems",o,true);},this);};e.prototype._syncPanel2Model=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M||this._isDimMeasureItemEqualToModelItem(o,M)){return;}M.persistentIndex=o.getIndex();M.persistentSelected=o.getVisible();M.role=o.getRole();this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);},this);m.refresh();};e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this.getModel("$sapmP13nDimMeasurePanel")){this.getModel("$sapmP13nDimMeasurePanel").destroy();}};e.prototype.setChartTypeKey=function(s){var m=this.getModel("$sapmP13nDimMeasurePanel");this.setProperty("chartTypeKey",s);m.getData().selectedChartTypeKey=s;return this;};e.prototype.addAvailableChartType=function(i){var m=this.getModel("$sapmP13nDimMeasurePanel");this.addAggregation("availableChartTypes",i);m.getData().availableChartTypes.push({key:i.getKey(),text:i.getText()});return this;};e.prototype.insertAvailableChartType=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");this.insertAggregation("availableChartTypes",i,I);m.getData().availableChartTypes.splice(I,0,{key:i.getKey(),text:i.getText()});return this;};e.prototype.removeAvailableChartType=function(i){var I=this.indexOfAvailableChartTypes(i);if(I>-1){var m=this.getModel("$sapmP13nDimMeasurePanel");m.getData().availableChartTypes.splice(I,1);}i=this.removeAggregation("availableChartTypes",i);return i;};e.prototype.removeAllAvailableChartType=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var i=this.removeAllAggregation("availableChartTypes");m.getData().availableChartTypes=[];return i;};e.prototype.destroyAvailableChartType=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this.destroyAggregation("availableChartTypes");m.getData().availableChartTypes=[];return this;};e.prototype.addItem=function(i){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);return this;};e.prototype.insertItem=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);return this;};e.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;m.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);}i=this.removeAggregation("items",i);return i;};e.prototype.removeAllItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this._bOnBeforeRenderingFirstTimeExecuted=false;var i=this.removeAllAggregation("items");m.getData().items=[];return i;};e.prototype.destroyItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");this._bOnBeforeRenderingFirstTimeExecuted=false;this.destroyAggregation("items");m.getData().items=[];return this;};e.prototype.addDimMeasureItem=function(D){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();this.addAggregation("dimMeasureItems",D);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=D.getIndex();M.persistentSelected=D.getVisible();M.role=D.getRole();this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return this;};e.prototype.insertDimMeasureItem=function(D,i){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();this.insertAggregation("dimMeasureItems",D,i);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=D.getIndex();M.persistentSelected=D.getVisible();M.role=D.getRole();this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return this;};e.prototype.removeDimMeasureItem=function(D){var m=this.getModel("$sapmP13nDimMeasurePanel");var o=m.getData();D=this.removeAggregation("dimMeasureItems",D);var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;this._sortModelItemsByPersistentIndex(o.items);this._reindexModelItemsByTableIndex(o);return D;};e.prototype.removeAllDimMeasureItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);var a=this.removeAllAggregation("dimMeasureItems");return a;};e.prototype.destroyDimMeasureItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._reindexModelItemsByTableIndex(D);this.destroyAggregation("dimMeasureItems");return this;};e.prototype._includeModelItem=function(i,I){if(I<0){I=this._oTable.getItems().length;}var t=this;var g=function(){if(i.getAggregationRole()==="Dimension"){return[{key:"category",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"series",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_SERIES')}];}if(i.getAggregationRole()==="Measure"){return[{key:"axis1",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS2')}];}return[];};var m={columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),aggregationRole:i.getAggregationRole(),availableRoleTypes:g(),persistentIndex:-1,persistentSelected:undefined,role:undefined,tableIndex:undefined};var M=this.getModel("$sapmP13nDimMeasurePanel");M.getData().items.splice(I,0,m);};e.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));};e.prototype._onSelectionChange=function(E){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();var t=E.getParameter("listItem");this._switchMarkedTableItemTo(t);this._reindexModelItemsByPersistentIndex(D);m.refresh();this._notifyChange();};e.prototype._onSwitchButtonShowSelected=function(){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();D.showOnlySelectedItems=!D.showOnlySelectedItems;this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();this._fnHandleResize();};e.prototype._onExecuteSearch=function(){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};e.prototype._getDimMeasureItemByColumnKey=function(s){for(var i=0,D=this.getDimMeasureItems(),a=D.length;i<a;i++){if(D[i].getColumnKey()===s){return D[i];}}return null;};e.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this.getModel("$sapmP13nDimMeasurePanel").getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};e.prototype._getModelItemByColumnKey=function(s){var m=null;this.getModel("$sapmP13nDimMeasurePanel").getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};e.prototype._moveModelItems=function(i,I){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();if(i<0||I<0||i>D.items.length-1||I>D.items.length-1){return false;}var M=D.items.splice(i,1);D.items.splice(I,0,M[0]);this._reindexModelItemsByPersistentIndexAndTableIndex(D);m.refresh();return true;};e.prototype._switchVisibilityOfUnselectedModelItems=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var s=this._isFilteredByShowSelected();m.getData().items.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});m.refresh();};e.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};e.prototype._getVisibleModelItems=function(){var v=[];this.getModel("$sapmP13nDimMeasurePanel").getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};e.prototype._getSelectedModelItems=function(){var s=[];this.getModel("$sapmP13nDimMeasurePanel").getData().items.forEach(function(m){if(m.persistentSelected){s.push(m);}});return s;};e.prototype._getModelItemByTableItem=function(t){var i=this._getVisibleTableItems().indexOf(t);return this._getVisibleModelItems()[i];};e.prototype._reindexModelItemsByPersistentIndexAndTableIndex=function(D){var p=-1;D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m,t){m.persistentIndex=-1;if(m.persistentSelected){p++;D.countOfSelectedItems++;m.persistentIndex=p;}m.tableIndex=t;D.countOfItems++;});};e.prototype._reindexModelItemsByPersistentIndex=function(D){var p=-1;D.countOfSelectedItems=0;D.items.forEach(function(m){m.persistentIndex=-1;if(m.persistentSelected){p++;D.countOfSelectedItems++;m.persistentIndex=p;}});};e.prototype._reindexModelItemsByTableIndex=function(D){D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m,t){m.tableIndex=t;D.countOfItems++;if(m.persistentSelected){D.countOfSelectedItems++;}});};e.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex<b.persistentIndex){return-1;}else if(a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};e.prototype._switchMarkedTableItemTo=function(t){var D=this.getModel("$sapmP13nDimMeasurePanel").getData();if(D.markedTableItem===t){return;}if(D.markedTableItem){D.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}D.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);D.markedTableItem=t;if(D.markedTableItem){D.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._updateControlLogic();};e.prototype._createTable=function(){var t=this;this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(m){if(m.aggregationRole==="Dimension"){return t._oRb.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(m.aggregationRole==="Measure"){return t._oRb.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(i,b){var a=b.getObject();return new sap.ui.core.Item({key:a.key,text:a.text});}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this.getModel("$sapmP13nDimMeasurePanel"));};e.prototype._createToolbar=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var t=this;var M=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Down");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})});M.setModel(m);var o=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Up");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})});o.setModel(m);var a=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Bottom");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})});a.setModel(m);var b=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Top");},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})});b.setModel(m);var s=new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(i){return i?t._oRb.getText('COLUMNSPANEL_SHOW_ALL'):t._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}},press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});s.setModel(m);var L=0;var f=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(L);if(D){L=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});var g=new sap.m.ComboBox({selectedKey:{path:'/selectedChartTypeKey'},items:{path:'/availableChartTypes',template:new sap.ui.core.Item({key:"{key}",text:"{text}"})},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:false,stayInOverflow:false})});g.setModel(m);var h=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:sap.m.ToolbarDesign.Solid,content:[g,new sap.m.ToolbarSpacer(),f,s,b,o,M,a]});this.addAggregation("content",h);};e.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};e.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};e.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};e.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};e.prototype._isFilteredByShowSelected=function(){return this.getModel("$sapmP13nDimMeasurePanel").getData().showOnlySelectedItems;};e.prototype._isDimMeasureItemEqualToModelItem=function(D,m){return m.persistentIndex===D.getIndex()&&m.persistentSelected===D.getVisible()&&m.role===D.getRole();};e.prototype._updateControlLogic=function(){var m=this.getModel("$sapmP13nDimMeasurePanel");var D=m.getData();var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();D.isMoveUpButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem>0;D.isMoveDownButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem<v.length-1&&D.indexOfMarkedTableItem>-1;var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}m.refresh();};e.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};e.prototype._showAll=function(){q.sap.log.info("ModelItems: visible tableIndex isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var D=this.getModel("$sapmP13nDimMeasurePanel").getData();var t=this._oTable.getItems();var L=Math.max(D.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=D.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.visible+" "+m.tableIndex+" "+m.persistentSelected+"_"+m.persistentIndex+";    "+o.getId()+" "+o.getCells()[0].getText()+": "+o.getSelected()+" "+o.getCells()[1].getText());}};return e;},true);
