/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','./PlanningCalendarRow','./library','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils'],function(q,C,L,P,l,u,a){"use strict";var b=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{}}}});var c=sap.ui.core.Control.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(R,H){R.write("<div");R.writeControlData(H);R.addClass("sapMPlanCalHead");R.writeClasses();R.write(">");var T=H.getToolbar();if(T){R.renderControl(T);}var i=H.getAllCheckBox();if(i){R.renderControl(i);}R.write("</div>");}});b.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(sap.ui.Device.system.tablet||q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oIntervalTypeSelect=new sap.m.Select(this.getId()+"-IntType",{maxWidth:"15rem"});this._oIntervalTypeSelect.attachEvent("change",_,this);this._oTodayButton=new sap.m.Button(this.getId()+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:sap.m.ButtonType.Transparent});this._oTodayButton.attachEvent("press",d,this);this._oHeaderToolbar=new sap.m.Toolbar(this.getId()+"-HeaderToolbar",{design:sap.m.ToolbarDesign.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new c(this.getId()+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new sap.m.Toolbar(this.getId()+"-InfoToolbar",{height:"auto",design:sap.m.ToolbarDesign.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var T=new sap.m.Table(this.getId()+"-Table",{infoToolbar:this._oInfoToolbar,mode:sap.m.ListMode.SingleSelectMaster,columns:[new sap.m.Column({styleClass:"sapMPlanCalRowHead"}),new sap.m.Column({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:sap.m.ScreenSize.Desktop,demandPopin:true})]});T.attachEvent("selectionChange",n,this);this.setAggregation("table",T,true);this.setStartDate(new Date());this._resizeProxy=q.proxy(h,this);};b.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var T=this.getAggregation("table");T.removeAllItems();if(this._oTimeInterval){this._oTimeInterval._oPlanningCalendar=undefined;this._oTimeInterval.destroy();this._oTimeInterval=undefined;}if(this._oDateInterval){this._oDateInterval._oPlanningCalendar=undefined;this._oDateInterval.destroy();this._oDateInterval=undefined;}if(this._oMonthInterval){this._oMonthInterval._oPlanningCalendar=undefined;this._oMonthInterval.destroy();this._oMonthInterval=undefined;}if(this._aViews){for(var i=0;i<this._aViews.length;i++){this._aViews[i].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}};b.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}t.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._bBeforeRendering=undefined;};b.prototype.onAfterRendering=function(E){E.size={width:this.getDomRef().offsetWidth};h.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}k.call(this,false);};b.prototype.setStartDate=function(S){if(!S){S=new Date();}if(q.sap.equal(S,this.getStartDate())){return this;}if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=S.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var M=this.getMinDate();if(M&&M.getTime()>S.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(M.getTime());}else{var j=this.getMaxDate();if(j&&j.getTime()<S.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}}}this.setProperty("startDate",S,true);if(this._oTimeInterval){this._oTimeInterval.setStartDate(new Date(S.getTime()));}if(this._oDateInterval){this._oDateInterval.setStartDate(new Date(S.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setStartDate(new Date(S.getTime()));}var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];D.getCalendarRow().setStartDate(new Date(S.getTime()));}if(this.getDomRef()){k.call(this,false);}return this;};b.prototype.setMinDate=function(D){if(q.sap.equal(D,this.getMinDate())){return this;}var M=this.getMaxDate();if(D){if(!(D instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=D.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("minDate",D,true);this._bNoStartDateChange=true;if(this._oTimeInterval){this._oTimeInterval.setMinDate(new Date(D.getTime()));}if(this._oDateInterval){this._oDateInterval.setMinDate(new Date(D.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setMinDate(new Date(D.getTime()));}if(M&&M.getTime()<D.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);M=new Date(D.getTime());M.setMonth(M.getMonth()+1,0);M.setHours(23);M.setMinutes(59);M.setSeconds(59);M.setMilliseconds(0);this.setMaxDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()<D.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(D.getTime());this.setStartDate(S);}}else{this.setProperty("minDate",undefined,true);if(this._oTimeInterval){this._oTimeInterval.setMinDate();}if(this._oDateInterval){this._oDateInterval.setMinDate();}if(this._oMonthInterval){this._oMonthInterval.setMinDate();}}var T=new Date();if(D&&T.getTime()<D.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()<M.getTime()){this._oTodayButton.setVisible(true);}return this;};b.prototype.setMaxDate=function(D){if(q.sap.equal(D,this.getMaxDate())){return this;}var M=this.getMinDate();if(D){if(!(D instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=D.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("maxDate",D,true);this._bNoStartDateChange=true;if(this._oTimeInterval){this._oTimeInterval.setMaxDate(new Date(D.getTime()));}if(this._oDateInterval){this._oDateInterval.setMaxDate(new Date(D.getTime()));}if(this._oMonthInterval){this._oMonthInterval.setMaxDate(new Date(D.getTime()));}if(M&&M.getTime()>D.getTime()){q.sap.log.warning("maxDate < minDate -> maxDate set to begin of the month",this);M=new Date(D.getTime());M.setUTCDate(1);M.setHours(0);M.setMinutes(0);M.setSeconds(0);M.setMilliseconds(0);this.setMinDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()>D.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}this.setStartDate(S);}}else{this.setProperty("maxDate",undefined,true);if(this._oTimeInterval){this._oTimeInterval.setMaxDate();}if(this._oDateInterval){this._oDateInterval.setMaxDate();}if(this._oMonthInterval){this._oMonthInterval.setMaxDate();}}var T=new Date();if(D&&T.getTime()>D.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()>M.getTime()){this._oTodayButton.setVisible(true);}return this;};b.prototype.setViewKey=function(K){this.setProperty("viewKey",K,true);this._oIntervalTypeSelect.setSelectedKey(K);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}var S=this.getStartDate();var M=this.getMinDate();var j=this.getMaxDate();var V=s.call(this,K,!this._bBeforeRendering);if(!V){this._bCheckView=true;this.invalidate();}else{var I=V.getIntervalType();var D=v.call(this,V);this._bCheckView=false;switch(I){case sap.ui.unified.CalendarIntervalType.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(S.getTime()),items:D,pickerPopup:true});this._oTimeInterval.attachEvent("startDateChange",e,this);this._oTimeInterval.attachEvent("select",f,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oTimeInterval.setMinDate(new Date(M.getTime()));}if(j){this._oTimeInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oTimeInterval.getItems()!=D){this._oTimeInterval.setItems(D);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case sap.ui.unified.CalendarIntervalType.Day:if(!this._oDateInterval){this._oDateInterval=new sap.ui.unified.CalendarDateInterval(this.getId()+"-DateInt",{startDate:new Date(S.getTime()),days:D,showDayNamesLine:false,pickerPopup:true});this._oDateInterval.attachEvent("startDateChange",e,this);this._oDateInterval.attachEvent("select",f,this);this._oDateInterval._oPlanningCalendar=this;this._oDateInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oDateInterval.setMinDate(new Date(M.getTime()));}if(j){this._oDateInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oDateInterval.getDays()!=D){this._oDateInterval.setDays(D);}this._oInfoToolbar.addContent(this._oDateInterval);break;case sap.ui.unified.CalendarIntervalType.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(S.getTime()),months:D,pickerPopup:true});this._oMonthInterval.attachEvent("startDateChange",e,this);this._oMonthInterval.attachEvent("select",f,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oMonthInterval.setMinDate(new Date(M.getTime()));}if(j){this._oMonthInterval.setMaxDate(new Date(j.getTime()));}}else if(this._oMonthInterval.setMonths()!=D){this._oMonthInterval.setMonths(D);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var R=this.getRows();for(var i=0;i<R.length;i++){var E=R[i];var F=E.getCalendarRow();F.setIntervalType(I);F.setIntervals(D);F.setShowSubIntervals(V.getShowSubIntervals());}if(this.getDomRef()){k.call(this,false);}}return this;};b.prototype.setShowIntervalHeaders=function(S){this.setProperty("showIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowIntervalHeaders(S);}return this;};b.prototype.setShowEmptyIntervalHeaders=function(S){this.setProperty("showEmptyIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowEmptyIntervalHeaders(S);}return this;};b.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];D.getCalendarRow().setAppointmentsReducedHeight(j);}return this;};b.prototype.setShowRowHeaders=function(S){this.setProperty("showRowHeaders",S,true);var T=this.getAggregation("table");T.getColumns()[0].setVisible(S);this.$().toggleClass("sapMPlanCalNoHead",!S);z.call(this);B.call(this);return this;};b.prototype.addRow=function(R){this.addAggregation("rows",R,true);R.attachEvent("_change",A,this);var T=this.getAggregation("table");T.addItem(R.getColumnListItem());var i=R.getCalendarRow();i.setStartDate(this.getStartDate());i.setShowIntervalHeaders(this.getShowIntervalHeaders());i.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());i.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());i.attachEvent("select",m,this);i.attachEvent("startDateChange",e,this);i.attachEvent("leaveRow",x,this);i.attachEvent("intervalSelect",g,this);y.call(this);if(this._oTimeInterval||this._oDateInterval||this._oMonthInterval){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var j=v.call(this,V);i.setIntervalType(I);i.setIntervals(j);i.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};b.prototype.insertRow=function(R,i){this.insertAggregation("rows",R,i);R.attachEvent("_change",A,this);var T=this.getAggregation("table");T.insertItem(R.getColumnListItem(),i,true);var j=R.getCalendarRow();j.setStartDate(this.getStartDate());j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.attachEvent("select",m,this);j.attachEvent("startDateChange",e,this);j.attachEvent("leaveRow",x,this);j.attachEvent("intervalSelect",g,this);y.call(this);if(this._oTimeInterval||this._oDateInterval||this._oMonthInterval){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);j.setIntervalType(I);j.setIntervals(D);j.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};b.prototype.removeRow=function(O){var R=this.removeAggregation("rows",O,true);R.detachEvent("_change",A,this);var T=this.getAggregation("table");T.removeItem(R.getColumnListItem(),true);var i=R.getCalendarRow();i.detachEvent("select",m,this);i.detachEvent("startDateChange",e,this);i.detachEvent("leaveRow",x,this);i.detachEvent("intervalSelect",g,this);y.call(this);B.call(this);return R;};b.prototype.removeAllRows=function(){var R=this.removeAllAggregation("rows",true);var T=this.getAggregation("table");T.removeAllItems(true);for(var i=0;i<R.length;i++){var j=R[i];j.detachEvent("_change",A,this);var D=j.getCalendarRow();D.detachEvent("select",m,this);D.detachEvent("startDateChange",e,this);D.detachEvent("leaveRow",x,this);D.detachEvent("intervalSelect",g,this);}y.call(this);B.call(this);return R;};b.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var T=this.getAggregation("table");T.destroyItems(true);y.call(this);B.call(this);return i;};b.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);o.call(this);return this;};b.prototype.insertToolbarContent=function(i,I){this.insertAggregation("toolbarContent",i,I);o.call(this);return this;};b.prototype.removeToolbarContent=function(O){var R=this.removeAggregation("toolbarContent",O,true);o.call(this);return R;};b.prototype.removeAllToolbarContent=function(){var R=this.removeAllAggregation("toolbarContent",true);o.call(this);return R;};b.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);o.call(this);return i;};b.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};b.prototype.setSingleSelection=function(S){this.setProperty("singleSelection",S,true);z.call(this);B.call(this);if(S){this.selectAllRows(false);}else{y.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!S);return this;};b.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);var T=this.getAggregation("table");T.setNoDataText(N);return this;};b.prototype.invalidate=function(O){if(this._bDateRangeChanged||(O&&O instanceof sap.ui.unified.DateRange)){if(this.getDomRef()){var K=this.getViewKey();var V=s.call(this,K);var i=V.getIntervalType();switch(i){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(O&&O instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};b.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};b.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var D=this.destroyAggregation("specialDates");return D;};b.prototype.removeAllViews=function(){this._bCheckView=true;var R=this.removeAllAggregation("views");return R;};b.prototype.destroyViews=function(){this._bCheckView=true;var D=this.destroyAggregation("views");return D;};b.prototype.getSelectedRows=function(){return this.getRows().filter(function(R){return R.getSelected();});};b.prototype.selectAllRows=function(S){var R=this.getRows();if(!(S&&this.getSingleSelection())){for(var i=0;i<R.length;i++){var j=R[i];j.setSelected(S);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(S);}}return this;};b.prototype.onsaphomemodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[0];var N=new q.Event("saphome");N._bPlanningCalendar=true;i.getCalendarRow().onsaphome(N);E.preventDefault();E.stopPropagation();}};b.prototype.onsapendmodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[R.length-1];var N=new q.Event("sapend");N._bPlanningCalendar=true;i.getCalendarRow().onsapend(N);E.preventDefault();E.stopPropagation();}};function _(E){this.setViewKey(E.getParameter("selectedItem").getKey());this.fireViewChange();}function d(E){this.setStartDate(new Date());this.fireStartDateChange();}function e(E){if(this._bNoStartDateChange){return;}var S=E.oSource.getStartDate();this.setStartDate(new Date(S.getTime()));this.fireStartDateChange();}function f(E){var S=E.oSource.getSelectedDates();var i=new Date(S[0].getStartDate());S[0].setStartDate();var j=a._createUniversalUTCDate(i,undefined,true);var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();switch(I){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCHours(j.getUTCHours()+1);break;case sap.ui.unified.CalendarIntervalType.Day:j.setUTCDate(j.getUTCDate()+1);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCMonth(j.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}j.setUTCMilliseconds(j.getUTCMilliseconds()-1);j=a._createLocalDate(j,true);this.fireIntervalSelect({startDate:i,endDate:j,subInterval:false,row:undefined});}function g(E){var S=E.getParameter("startDate");var i=E.getParameter("endDate");var j=E.getParameter("subInterval");var R=E.oSource._oPlanningCalendarRow;this.fireIntervalSelect({startDate:S,endDate:i,subInterval:j,row:R});}function h(E,N){if(E.size.width<=0){return;}var R=this.getRows();var j;var i=0;var O=this._iSize;p.call(this,E.size.width);if(O!=this._iSize){var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);for(i=0;i<R.length;i++){j=R[i];var F=j.getCalendarRow();if(D!=F.getIntervals()){F.setIntervals(D);}else{F.handleResize();}}switch(I){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=D){this._oTimeInterval.setItems(D);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=D){this._oDateInterval.setDays(D);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=D){this._oMonthInterval.setMonths(D);}break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}z.call(this);}else if(!N){for(i=0;i<R.length;i++){j=R[i];j.getCalendarRow().handleResize();}}}function k(U){if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(U){var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().updateCurrentTimeVisualization();}}var N=new Date();var S=this.getStartDate();var K=this.getViewKey();var V=s.call(this,K);var I=V.getIntervalType();var D=v.call(this,V);var T=0;var E=0;var F=0;switch(I){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;E=S.getTime()-3600000;F=S.getTime()+D*3600000;break;case sap.ui.unified.CalendarIntervalType.Day:T=1800000;E=S.getTime()-3600000;F=S.getTime()+D*86400000;break;default:T=-1;break;}if(N.getTime()<=F&&N.getTime()>=E&&T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,k,[true]);}}function m(E){var D=E.getParameter("appointment");var M=E.getParameter("multiSelect");var F=E.getParameter("appointments");if(!M){var R=this.getRows();for(var i=0;i<R.length;i++){var G=R[i];var H=G.getCalendarRow();if(E.oSource!=H){var I=G.getAppointments();for(var j=0;j<I.length;j++){var J=I[j];J.setSelected(false);}}}}this.fireAppointmentSelect({appointment:D,appointments:F,multiSelect:M});}function n(E){var j=[];var R=this.getRows();for(var i=0;i<R.length;i++){var D=R[i];var F=D.getColumnListItem();var S=F.getSelected();if(D.getSelected()!=S){D.setProperty("selected",S,true);j.push(D);}}if(!this.getSingleSelection()){y.call(this);}if(j.length>0){this.fireRowSelectionChange({rows:j});}}function o(){var T=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:sap.m.ToolbarDesign.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!T.getHeaderToolbar()){T.setHeaderToolbar(this._oToolbar);}}else if(T.getHeaderToolbar()){T.setHeaderToolbar();}this._oToolbar.invalidate();}function p(W){if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function r(){var V=this.getViews();if(V.length==0){if(!this._aViews){this._aViews=[];var i=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:sap.ui.unified.CalendarIntervalType.Hour,intervalType:sap.ui.unified.CalendarIntervalType.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12});this._aViews.push(i);var j=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:sap.ui.unified.CalendarIntervalType.Day,intervalType:sap.ui.unified.CalendarIntervalType.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14});this._aViews.push(j);var D=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:sap.ui.unified.CalendarIntervalType.Month,intervalType:sap.ui.unified.CalendarIntervalType.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12});this._aViews.push(D);}V=this._aViews;}return V;}function s(K,N){var V=r.call(this);var j;for(var i=0;i<V.length;i++){j=V[i];if(j.getKey()!=K){j=undefined;}else{break;}}if(!j&&!N){throw new Error("PlanningCalendarView with key "+K+"not assigned "+this);}return j;}function t(){var V=r.call(this);var I=this._oIntervalTypeSelect.getItems();var i=0;var j;if(V.length<I.length){for(i=V.length;i<I.length;i++){j=I[i];this._oIntervalTypeSelect.removeItem(j);j.destroy();}}for(i=0;i<V.length;i++){var D=V[i];j=I[i];if(j){if(j.getKey()!=D.getKey()||j.getText()!=D.getDescription()){j.setKey(D.getKey());j.setText(D.getDescription());j.setTooltip(D.getTooltip());}}else{j=new sap.ui.core.Item(this.getId()+"-"+i,{key:D.getKey(),text:D.getDescription(),tooltip:D.getTooltip()});this._oIntervalTypeSelect.addItem(j);}}}function v(V){var i=0;switch(this._iSize){case 0:i=V.getIntervalsS();break;case 1:i=V.getIntervalsM();break;default:i=V.getIntervalsL();break;}return i;}function w(E){var i=E.getParameter("selected");var R=this.getRows();if(i){R=this.getRows().filter(function(j){return!j.getSelected();});}this.selectAllRows(i);this.fireRowSelectionChange({rows:R});}function x(E){var j=E.oSource;var T=E.getParameter("type");var R=this.getRows();var D;var N;var F;var G;var i=0;var I=0;var H;for(i=0;i<R.length;i++){D=R[i];if(D.getCalendarRow()==j){I=i;break;}}switch(T){case"sapup":F=j.getFocusedAppointment();G=F.getStartDate();if(I>0){I--;}N=R[I];N.getCalendarRow().focusNearestAppointment(G);break;case"sapdown":F=j.getFocusedAppointment();G=F.getStartDate();if(I<R.length-1){I++;}N=R[I];N.getCalendarRow().focusNearestAppointment(G);break;case"saphome":if(I>0){N=R[0];H=new q.Event(T);H._bPlanningCalendar=true;N.getCalendarRow().onsaphome(H);}break;case"sapend":if(I<R.length-1){N=R[R.length-1];H=new q.Event(T);H._bPlanningCalendar=true;N.getCalendarRow().onsapend(H);}break;default:break;}}function y(){if(this._oSelectAllCheckBox){var R=this.getRows();var S=this.getSelectedRows();if(R.length==S.length&&S.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function z(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",w,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function A(E){if(E.getParameter("name")=="selected"){y.call(this);}}function B(){var T=this.getAggregation("table");var M=T.getMode();var i;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){i=sap.m.ListMode.None;}else{i=sap.m.ListMode.SingleSelectMaster;}}else{i=sap.m.ListMode.MultiSelect;}if(M!=i){T.setMode(i);}}return b;},true);
