/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Slider","./Input",'sap/ui/core/InvisibleText'],function(S,I,a){"use strict";var R=S.extend("sap.m.RangeSlider",{metadata:{library:"sap.m",properties:{range:{type:"any",group:"Data",defaultValue:[]},inputsAsTooltips:{type:"boolean",group:"Appearance",defaultValue:false}}}});var b=32,C=8;R.prototype.init=function(){var r;S.prototype.init.call(this,arguments);r=this.getRange();r=Array.isArray(r)&&r.length===2?r:[0,100];this.setRange(r);this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._aInitialFocusRange=Array.prototype.slice.call(this.getRange());this._iLongestRangeTextWidth=0;this._fTooltipHalfWidthPercent=0;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._ariaUpdateDelay=[];};R.prototype.exit=function(){this._oResourceBundle=null;this._aInitialFocusRange=null;this._oRangeLabel.destroy();this._oRangeLabel=null;if(this.getInputsAsTooltips()){this._mHandleTooltip.start.tooltip.destroy();this._mHandleTooltip.end.tooltip.destroy();}this._mHandleTooltip.start.label.destroy();this._mHandleTooltip.end.label.destroy();this._mHandleTooltip.start.handle=null;this._mHandleTooltip.start.tooltip=null;this._mHandleTooltip.start.label=null;this._mHandleTooltip.end.handle=null;this._mHandleTooltip.end.tooltip=null;this._mHandleTooltip.end.label=null;this._ariaUpdateDelay=null;};R.prototype.onBeforeRendering=function(){var A=[Math.abs(this.getMin()),Math.abs(this.getMax())],r=A[0]>A[1]?0:1,i=!!this.getInputsAsTooltips(),s=new a({text:this._oResourceBundle.getText("RANGE_SLIDER_LEFT_HANDLE")}),e=new a({text:this._oResourceBundle.getText("RANGE_SLIDER_RIGHT_HANDLE")});this._oRangeLabel=new a({text:this._oResourceBundle.getText("RANGE_SLIDER_RANGE_HANDLE")});this._validateProperties();this._iLongestRangeTextWidth=((A[r].toString()).length+1)*C;this._mHandleTooltip={start:{handle:null,tooltip:i?this._createInputField("LeftTooltip",s):null,label:s},end:{handle:null,tooltip:i?this._createInputField("RightTooltip",e):null,label:e}};};R.prototype.onAfterRendering=function(){var r=this.getRange(),m=this.getMin(),M=this.getMax(),c=r.reduce(function(d,v){return d||v<m||v>M;});this._mHandleTooltip.start.handle=this.getDomRef("handle1");this._mHandleTooltip.end.handle=this.getDomRef("handle2");if(!this.getInputsAsTooltips()){this._mHandleTooltip.start.tooltip=this.$("LeftTooltip");this._mHandleTooltip.end.tooltip=this.$("RightTooltip");}this._recalculateStyles();if(c){jQuery.sap.log.warning("Warning: "+"Property wrong range: ["+r+"] not in the range: ["+m+","+M+"]",this);}this.$("TooltipsContainer").css("min-width",(this._fTooltipHalfWidthPercent*4)+"%");this._updateHandle(this._mHandleTooltip.start.handle,r[0]);this._updateHandle(this._mHandleTooltip.end.handle,r[1]);};R.prototype._createInputField=function(s,A){var i=new I(this.getId()+"-"+s,{value:this.getMin(),width:this._iLongestRangeTextWidth+(2*C)+"px",type:"Number",textAlign:sap.ui.core.TextAlign.Center,ariaLabelledBy:A});i.attachChange(this._handleInputChange.bind(this,i));i.addEventDelegate({onfocusout:function(e){e.srcControl.fireChange({value:e.target.value});}});return i;};R.prototype._recalculateStyles=function(){S.prototype._recalculateStyles.call(this,arguments);this._fTooltipHalfWidthPercent=((this._fSliderWidth-(this._fSliderWidth-(this._iLongestRangeTextWidth/2+C)))/this._fSliderWidth)*100;};R.prototype._recalculateRange=function(){var h,s,e,p,c=this._bRTL?"right":"left";h=[parseFloat(this._mHandleTooltip.start.handle.style[c]),parseFloat(this._mHandleTooltip.end.handle.style[c])];s=Math.min.apply(Math,h)+"%";e=(100-Math.max.apply(Math,h))+"%";p=this.getDomRef("progress");if(this._bRTL){p.style.left=e;p.style.right=s;}else{p.style.left=s;p.style.right=e;}};R.prototype.getClosestHandleDomRef=function(e){var h=this._mHandleTooltip.start.handle,H=this._mHandleTooltip.end.handle,p=Math.abs(e.pageX-h.offsetLeft-this._fSliderPaddingLeft-this._fSliderOffsetLeft),c=Math.abs(e.clientX-H.offsetLeft-this._fSliderPaddingLeft-this._fSliderOffsetLeft);return p>c?H:h;};R.prototype._getIndexOfHandle=function(h){if(h&&h.getAttribute&&h.getAttribute("data-range-val")==="start"){return 0;}else if(h&&h.getAttribute&&h.getAttribute("data-range-val")==="end"){return 1;}else{return-1;}};R.prototype._updateHandle=function(h,v){var t=(this._mHandleTooltip.start.handle===h)?this._mHandleTooltip.start.tooltip:this._mHandleTooltip.end.tooltip,r=this.getRange(),i=this._getIndexOfHandle(h),p=this._getPercentOfValue(v);r[i]=v;this.setProperty("range",Array.prototype.slice.call(r),true);this._updateHandleDom(h,r,i,v,p);this._updateTooltipContent(t,v);this._adjustTooltipsContainer(p);this._recalculateRange();};R.prototype._updateHandleDom=function(h,r,i,v,p){var m,c=this.getRenderer().CSS_CLASS,f=this.getDomRef("input");if(!!this.getName()){f.setAttribute(h.getAttribute("data-range-val"),r[i]);f.setAttribute("value",this.getValue());}if(this._bRTL){h.style.right=p+"%";}else{h.style.left=p+"%";}if(this.getShowHandleTooltip()){h.title=v;}m=r[0]===r[1];this.$("handle1").toggleClass(c+"HandleOverlap",m);this.$("handle2").toggleClass(c+"HandleOverlap",m);jQuery.sap.clearDelayedCall(this._ariaUpdateDelay[i]);this._ariaUpdateDelay[i]=jQuery.sap.delayedCall(100,this,"_updateHandleAria",[h,v]);};R.prototype._updateHandleAria=function(h,v){var r=this.getRange(),p=this.getDomRef("progress");this._updateHandlesAriaLabels();h.setAttribute("aria-valuenow",v);if(p){p.setAttribute("aria-valuenow",r.join("-"));p.setAttribute("aria-valuetext",this._oResourceBundle.getText('RANGE_SLIDER_RANGE_ANNOUNCEMENT',r));}};R.prototype._updateHandlesAriaLabels=function(){var r=this.getRange(),t=this._mHandleTooltip.start.label;if((r[0]>r[1]&&!this._mHandleTooltip.bAriaHandlesSwapped)||(r[0]<r[1]&&this._mHandleTooltip.bAriaHandlesSwapped)){this._mHandleTooltip.start.label=this._mHandleTooltip.end.label;this._mHandleTooltip.end.label=t;this._mHandleTooltip.start.handle.setAttribute("aria-labelledby",this._mHandleTooltip.start.label.getId());this._mHandleTooltip.end.handle.setAttribute("aria-labelledby",this._mHandleTooltip.end.label.getId());this._mHandleTooltip.bAriaHandlesSwapped=!this._mHandleTooltip.bAriaHandlesSwapped;}};R.prototype._updateTooltipContent=function(t,n){var i=this.getInputsAsTooltips();if(!i){t.text(n);}else if(i&&t.getValue()!==n){t.setValue(n);t.$("inner").attr("value",n);}};R.prototype._swapTooltips=function(r){var t=this._mHandleTooltip.start.tooltip;if((r[0]>=r[1]&&!this._mHandleTooltip.bTooltipsSwapped)||(r[0]<=r[1]&&this._mHandleTooltip.bTooltipsSwapped)){this._mHandleTooltip.start.tooltip=this._mHandleTooltip.end.tooltip;this._mHandleTooltip.end.tooltip=t;this._updateTooltipContent(this._mHandleTooltip.start.tooltip,r[0]);this._updateTooltipContent(this._mHandleTooltip.end.tooltip,r[1]);if(this.getInputsAsTooltips()){this._mHandleTooltip.start.handle.setAttribute("aria-controls",this._mHandleTooltip.start.tooltip.getId());this._mHandleTooltip.end.handle.setAttribute("aria-controls",this._mHandleTooltip.end.tooltip.getId());}this._mHandleTooltip.bTooltipsSwapped=!this._mHandleTooltip.bTooltipsSwapped;}};R.prototype._adjustTooltipsContainer=function(){var t=this.getDomRef("TooltipsContainer"),A=this._bRTL?"right":"left",s=this._bRTL?"left":"right",r=this.getRange(),f=this._getPercentOfValue(r[0]>r[1]?r[1]:r[0]),e=this._getPercentOfValue(r[0]>r[1]?r[0]:r[1]);if(f<=this._fTooltipHalfWidthPercent){t.style[A]=0+"%";}else if(f>=(100-3*this._fTooltipHalfWidthPercent)){t.style[A]=(100-4*this._fTooltipHalfWidthPercent)+"%";}else{t.style[A]=f-this._fTooltipHalfWidthPercent+"%";}if(e>=(100-this._fTooltipHalfWidthPercent)){t.style[s]=0+"%";}else{t.style[s]=(100-e-this._fTooltipHalfWidthPercent)+"%";}this._swapTooltips(r);};R.prototype._handleInputChange=function(i,e){var h,A,t=this._mHandleTooltip.bTooltipsSwapped,n=parseInt(e.getParameter("value"),10);if(isNaN(n)||n<this.getMin()||n>this.getMax()){i.setValueState("Error");return;}i.setValueState("None");h=this._mHandleTooltip.start.tooltip===i?this._mHandleTooltip.start.handle:this._mHandleTooltip.end.handle;this._updateHandle(h,n);if(t!==this._mHandleTooltip.bTooltipsSwapped){A=this._mHandleTooltip.start.tooltip!==i?this._mHandleTooltip.start.tooltip:this._mHandleTooltip.end.tooltip;A.focus();}this._fireChangeAndLiveChange({range:this.getRange()});};R.prototype.setRange=function(r){var m=this.getMax(),M=this.getMin();if(!Array.isArray(r)){jQuery.sap.log.error("Error: "+"Cannot set property range: "+r+" not an array in the range: ["+M+","+m+"]",this);return this;}r=r.map(this._adjustRangeValue,this);this.setProperty("range",Array.prototype.slice.call(r),true);if(this.getDomRef()){var p=this._getPercentOfValue(r[0]),P=this._getPercentOfValue(r[1]);this._updateHandleDom(this._mHandleTooltip.start.handle,r,0,r[0],p);this._updateHandleDom(this._mHandleTooltip.end.handle,r,1,r[1],P);this._updateTooltipContent(this._mHandleTooltip.start.tooltip,parseInt(r[0],10));this._updateTooltipContent(this._mHandleTooltip.end.tooltip,parseInt(r[1],10));this._recalculateRange();}return this;};R.prototype.setValue=R.prototype.setRange;R.prototype.getValue=function(){var r=this.getRange();return Math.abs(r[1]-r[0]);};R.prototype._calculateHandlePosition=function(v){var m=this.getMax(),M=this.getMin(),n;n=((v-this._fSliderPaddingLeft-this._fSliderOffsetLeft)/this._fSliderWidth)*(m-M)+M;if(this._bRTL){n=this._convertValueToRtlMode(n);}return this._adjustRangeValue(n);};R.prototype._adjustRangeValue=function(v){var m=this.getMax(),M=this.getMin(),s=this.getStep(),f;f=Math.abs((v-M)%s);if(f!==0){v=f*2>=s?v+s-f:v-f;}if(v<M){v=M;}else if(v>m){v=m;}return v;};R.prototype.ontouchstart=function(e){var t=e.targetTouches[0],c=this.getRenderer().CSS_CLASS,E="."+c,v,h,r,H,f,F;if(!this.getEnabled()){return;}e.setMarked();this._recalculateStyles();if(["number","text"].indexOf(e.target.type)>-1){return;}v=this._calculateHandlePosition(t.pageX);r=this.getRange();h=[this._mHandleTooltip.start.handle,this._mHandleTooltip.end.handle];H=r.indexOf(v);f=h.reduce(function(A,o){return Math.abs(A-o.offsetLeft);},0);if(v<Math.min.apply(Math,r)||v>Math.max.apply(Math,r)||f<=b){h=[this.getClosestHandleDomRef(t)];this._updateHandle(h[0],v);}else if(H!==-1){h=[this.getDomRef(H===0?"handle1":"handle2")];}jQuery(document).on("touchend"+E+" touchcancel"+E+" mouseup"+E,this._ontouchend.bind(this,h)).on("touchmove"+E+(e.originalEvent.type!=="touchstart"?" mousemove"+E:""),this._ontouchmove.bind(this,v,Array.prototype.slice.call(this.getRange()),h));h.map(function(o){if(o.className.indexOf(c+"HandlePressed")===-1){o.className+=" "+c+"HandlePressed";}});F=h.length===1?h[0]:this.getDomRef("progress");jQuery.sap.delayedCall(0,F,"focus");};R.prototype._ontouchmove=function(i,c,h,e){var o,d,m,M,p=e.targetTouches?e.targetTouches[0].pageX:e.pageX;e.preventDefault();e.setMarked();if(e.isMarked("delayedMouseEvent")||!this.getEnabled()||e.button){return;}m=this.getMax();M=this.getMin();o=this._calculateHandlePosition(p)-i;d=c.every(function(r){var f=r+o;if(h.length===1){return m>=f||f>=M;}else{return m>=f&&f>=M;}});d&&h.map(function(H){this._updateHandle(H,c[this._getIndexOfHandle(H)]+o);},this);this.fireLiveChange({range:this.getRange()});};R.prototype._ontouchend=function(h,e){var n=this.getRange(),c=this.getRenderer().CSS_CLASS;e.setMarked();h&&h.map(function(H){H.className=H.className.replace(new RegExp(" ?"+c+"HandlePressed","gi"),"");});jQuery(document).off("."+c);this._recalculateRange();if(this._aInitialFocusRange[0]!==n[0]||this._aInitialFocusRange[1]!==n[1]){this._aInitialFocusRange=Array.prototype.slice.call(n);this.fireChange({range:n});}this._updateTooltipContent(this._mHandleTooltip.start.tooltip,n[0]);this._updateTooltipContent(this._mHandleTooltip.end.tooltip,n[1]);};R.prototype.onfocusin=function(e){var c=this.getRenderer().CSS_CLASS;this.$("TooltipsContainer").addClass(c+"HandleTooltipsShow");if(!this._hasFocus()){this._aInitialFocusRange=Array.prototype.slice.call(this.getRange());}};R.prototype.onfocusout=function(e){var c=this.getRenderer().CSS_CLASS,i=this.getInputsAsTooltips();if(i&&jQuery.contains(this.getDomRef(),e.relatedTarget)){return;}this.$("TooltipsContainer").removeClass(c+"HandleTooltipsShow");};R.prototype._fireChangeAndLiveChange=function(p){this.fireChange(p);this.fireLiveChange(p);};R.prototype._updateSliderValues=function(o,h){var r=Array.prototype.slice.call(this.getRange()),m=this.getMax(),M=this.getMin(),f=Math.max.apply(null,r),c=Math.min.apply(null,r),i=this._getIndexOfHandle(h),O=o<0?-1:1,H=i>-1?[h]:[this._mHandleTooltip.start.handle,this._mHandleTooltip.end.handle];if(H.length===1){c=f=r[i];}if(f+o>m){o=O*(Math.abs(m)-Math.abs(f));}else if(c+o<M){o=O*(Math.abs(c)-Math.abs(M));}H.map(function(d){this._updateHandle(d,r[this._getIndexOfHandle(d)]+o);},this);};R.prototype.onsapincrease=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.preventDefault();e.setMarked();if(this.getEnabled()){this._updateSliderValues(this.getStep(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsapplus=R.prototype.onsapincrease;R.prototype.onsapincreasemodifiers=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.preventDefault();e.setMarked();if(this.getEnabled()){this._updateSliderValues(this._getLongStep(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsappageup=R.prototype.onsapincreasemodifiers;R.prototype.onsapdecrease=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.preventDefault();e.setMarked();if(this.getEnabled()){this._updateSliderValues(-1*this.getStep(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsapminus=R.prototype.onsapdecrease;R.prototype.onsapdecreasemodifiers=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.preventDefault();e.setMarked();if(this.getEnabled()){this._updateSliderValues(-1*this._getLongStep(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsappagedown=R.prototype.onsapdecreasemodifiers;R.prototype.onsaphome=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.setMarked();e.preventDefault();if(this.getEnabled()){this._updateSliderValues(this.getMin(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsapend=function(e){if(["number","text"].indexOf(e.target.type)>-1){return;}e.setMarked();e.preventDefault();if(this.getEnabled()){this._updateSliderValues(this.getMax(),e.target);this._fireChangeAndLiveChange({range:this.getRange()});}};R.prototype.onsapescape=function(){this.setRange(this._aInitialFocusRange);this._fireChangeAndLiveChange({range:this.getRange()});};return R;},true);
