/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','sap/ui/thirdparty/crossroads'],function(q,E,H,R,V,T,c){"use strict";var r={};var a=E.extend("sap.ui.core.routing.Router",{constructor:function(o,C,O,t){E.apply(this);this._oConfig=C||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function b(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=b();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);}var d=this,e;if(!o){o={};}if(q.isArray(o)){e=o;o={};q.each(e,function(i,f){o[f.name]=f;});}q.each(o,function(s,f){if(f.name===undefined){f.name=s;}d.addRoute(f);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));},addRoute:function(C,p){if(!C.name){q.sap.log.error("A name has to be specified for every route",this);}if(this._oRoutes[C.name]){q.sap.log.error("Route with name "+C.name+" already exists",this);}this._oRoutes[C.name]=new R(this,C,p);},parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{q.sap.log.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},initialize:function(){var t=this,h=this.oHashChanger=H.getInstance();if(this._bIsInitialized){q.sap.log.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this.fnHashChanged=function(e){t.parse(e.getParameter("newHash"),e.getParameter("oldHash"));};if(!h){q.sap.log.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return;}h.attachEvent("hashChanged",this.fnHashChanged);if(!h.init()){this.parse(h.getHash());}return this;},stop:function(){if(!this._bIsInitialized){q.sap.log.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}this._bIsInitialized=false;return this;},destroy:function(){E.prototype.destroy.apply(this);if(!this._bIsInitialized){q.sap.log.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}this.bIsDestroyed=true;return this;},getURL:function(n,p){if(p===undefined){p={};}var o=this.getRoute(n);if(!o){q.sap.log.warning("Route with name "+n+" does not exist",this);return;}return o.getURL(p);},getRoute:function(n){return this._oRoutes[n];},getViews:function(){return this._oViews;},_createTargets:function(C,t){return new T({views:this._oViews,config:C,targets:t});},getView:function(v,s,b){var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:b});this.fireViewCreated({view:o,viewName:v,type:s});return o;},setView:function(v,o){this._oViews.setView(v,o);return this;},navTo:function(n,p,b){var u=this.getURL(n,p);if(u===undefined){q.sap.log.error("Can not navigate to route with name "+n+" because the route does not exist");}if(b){this.oHashChanger.replaceHash(u);}else{this.oHashChanger.setHash(u);}return this;},getTargets:function(){return this._oTargets;},getTarget:function(n){return this._oTargets.getTarget(n);},attachRouteMatched:function(d,f,l){this.attachEvent("routeMatched",d,f,l);return this;},detachRouteMatched:function(f,l){this.detachEvent("routeMatched",f,l);return this;},fireRouteMatched:function(A){this.fireEvent("routeMatched",A);return this;},attachViewCreated:function(d,f,l){this.attachEvent("viewCreated",d,f,l);return this;},detachViewCreated:function(f,l){this.detachEvent("viewCreated",f,l);return this;},fireViewCreated:function(A){this.fireEvent("viewCreated",A);return this;},attachRoutePatternMatched:function(d,f,l){this.attachEvent("routePatternMatched",d,f,l);return this;},detachRoutePatternMatched:function(f,l){this.detachEvent("routePatternMatched",f,l);return this;},fireRoutePatternMatched:function(A){this.fireEvent("routePatternMatched",A);return this;},attachBypassed:function(d,f,l){return this.attachEvent(a.M_EVENTS.Bypassed,d,f,l);},detachBypassed:function(f,l){return this.detachEvent(a.M_EVENTS.Bypassed,f,l);},fireBypassed:function(A){return this.fireEvent(a.M_EVENTS.Bypassed,A);},register:function(n){r[n]=this;return this;},_onBypassed:function(h){var f=function(){this.fireBypassed({hash:h});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:h});if(o instanceof Promise){o.then(f);return;}}f();},_isAsync:function(){return this._oConfig._async;},metadata:{publicMethods:["initialize","getURL","register","getRoute"]}});a.M_EVENTS={RouteMatched:"routeMatched",RoutePatternMatched:"routePatternMatched",ViewCreated:"viewCreated",Bypassed:"bypassed"};a.getRouter=function(n){return r[n];};return a;});
